/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Tag;
import org.languagetool.UserConfig;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.TextLevelRule;

public class LongSentenceRule
extends TextLevelRule {
    public static final String RULE_ID = "TOO_LONG_SENTENCE";
    private final ResourceBundle messages;
    private final int maxWords;

    public LongSentenceRule(ResourceBundle messages, UserConfig userConfig, int maxWords) {
        int confWords;
        this.messages = messages;
        this.setCategory(Categories.STYLE.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Style);
        this.setTags(Collections.singletonList(Tag.picky));
        int tmpMaxWords = maxWords;
        if (userConfig != null && (confWords = userConfig.getConfigValueByID(this.getId())) > 0) {
            tmpMaxWords = confWords;
        }
        this.maxWords = tmpMaxWords;
    }

    @Override
    public String getDescription() {
        return "Finds long sentences";
    }

    @Override
    public String getId() {
        return RULE_ID;
    }

    private boolean isWordCount(String tokenText) {
        char firstChar;
        return tokenText.length() > 0 && ((firstChar = tokenText.charAt(0)) >= 'A' && firstChar <= 'Z' || firstChar >= 'a' && firstChar <= 'z');
    }

    public String getMessage() {
        return MessageFormat.format(this.messages.getString("long_sentence_rule_msg2"), this.maxWords);
    }

    @Override
    public RuleMatch[] match(List<AnalyzedSentence> sentences) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        int pos = 0;
        for (AnalyzedSentence sentence : sentences) {
            AnalyzedTokenReadings[] tokens = sentence.getTokens();
            if (tokens.length < this.maxWords) {
                pos += sentence.getCorrectedTextLength();
                continue;
            }
            String msg = this.getMessage();
            ArrayList<Integer> fromPos = new ArrayList<Integer>();
            ArrayList<Integer> toPos = new ArrayList<Integer>();
            for (int i = 0; i < tokens.length; ++i) {
                int numWords = 0;
                while (!(i >= tokens.length || tokens[i].getToken().equals(":") || tokens[i].getToken().equals(";") || tokens[i].getToken().equals("\n") || tokens[i].getToken().equals("\r\n") || tokens[i].getToken().equals("\n\r"))) {
                    if (this.isWordCount(tokens[i].getToken())) {
                        if (numWords == this.maxWords) {
                            fromPos.add(tokens[0].getStartPos());
                            toPos.add(tokens[tokens.length - 1].getEndPos() - 1);
                        }
                        ++numWords;
                    }
                    ++i;
                }
            }
            for (int j = 0; j < fromPos.size(); ++j) {
                RuleMatch ruleMatch = new RuleMatch(this, sentence, pos + (Integer)fromPos.get(j), pos + (Integer)toPos.get(j), msg);
                ruleMatches.add(ruleMatch);
            }
            pos += sentence.getCorrectedTextLength();
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    @Override
    public int minToCheckParagraph() {
        return 0;
    }
}

