/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.webkit.prism;

import com.sun.javafx.application.PlatformImpl;
import com.sun.javafx.tk.RenderJob;
import com.sun.javafx.tk.Toolkit;
import com.sun.webkit.Invoker;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.locks.ReentrantLock;

public final class PrismInvoker
extends Invoker {
    @Override
    protected boolean lock(ReentrantLock reentrantLock) {
        return false;
    }

    @Override
    protected boolean unlock(ReentrantLock reentrantLock) {
        return false;
    }

    @Override
    protected boolean isEventThread() {
        return PrismInvoker.isEventThreadPrivate();
    }

    private static boolean isEventThreadPrivate() {
        return Toolkit.getToolkit().isFxUserThread();
    }

    @Override
    public void checkEventThread() {
        Toolkit.getToolkit().checkFxUserThread();
    }

    @Override
    public void invokeOnEventThread(Runnable runnable2) {
        if (this.isEventThread()) {
            runnable2.run();
        } else {
            PlatformImpl.runLater(runnable2);
        }
    }

    @Override
    public void postOnEventThread(Runnable runnable2) {
        PlatformImpl.runLater(runnable2);
    }

    static void invokeOnRenderThread(Runnable runnable2) {
        Toolkit.getToolkit().addRenderJob(new RenderJob(runnable2));
    }

    static void runOnRenderThread(Runnable runnable2) {
        if (Thread.currentThread().getName().startsWith("QuantumRenderer")) {
            runnable2.run();
        } else {
            FutureTask<Object> futureTask = new FutureTask<Object>(runnable2, null);
            Toolkit.getToolkit().addRenderJob(new RenderJob(futureTask));
            try {
                futureTask.get();
            }
            catch (ExecutionException executionException) {
                throw new AssertionError((Object)executionException);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

