/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.skins;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.skins.TileSkin;
import eu.hansolo.tilesfx.tools.Helper;
import java.util.Locale;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.OverrunStyle;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Line;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;

public class StatusTileSkin
extends TileSkin {
    private Text titleText;
    private Label description;
    private Line verticalDivider;
    private Line horizontal1Divider;
    private Line horizontal2Divider;
    private Label leftValueLabel;
    private Label middleValueLabel;
    private Label rightValueLabel;
    private Label leftLabel;
    private Label middleLabel;
    private Label rightLabel;
    private Text text;
    private StackPane leftGraphicsPane;
    private StackPane middleGraphicsPane;
    private StackPane rightGraphicsPane;

    public StatusTileSkin(Tile TILE) {
        super(TILE);
    }

    @Override
    protected void initGraphics() {
        super.initGraphics();
        this.titleText = new Text();
        this.titleText.setFill(this.tile.getTitleColor());
        Helper.enableNode(this.titleText, !this.tile.getTitle().isEmpty());
        this.description = new Label(this.tile.getDescription());
        this.description.setAlignment(this.tile.getDescriptionAlignment());
        this.description.setTextAlignment(TextAlignment.RIGHT);
        this.description.setWrapText(true);
        this.description.setTextOverrun(OverrunStyle.WORD_ELLIPSIS);
        this.description.setTextFill(this.tile.getTextColor());
        this.description.setPrefSize(225.0, 198.75);
        Helper.enableNode(this.description, this.tile.isTextVisible());
        Color foregroundColor = ((Tile)this.getSkinnable()).getForegroundColor();
        Color halfTranslucent = Helper.getColorWithOpacity(foregroundColor, 0.5);
        this.verticalDivider = new Line(0.0, 87.5, 250.0, 87.5);
        this.verticalDivider.getStrokeDashArray().addAll((Double[])new Double[]{2.0, 2.0});
        this.verticalDivider.setStrokeDashOffset(1.0);
        this.verticalDivider.setStroke(halfTranslucent);
        this.verticalDivider.setStrokeWidth(1.0);
        this.horizontal1Divider = new Line(83.33333333333333, 112.5, 83.33333333333333, 212.5);
        this.horizontal1Divider.getStrokeDashArray().addAll((Double[])new Double[]{2.0, 2.0});
        this.horizontal1Divider.setStrokeDashOffset(1.0);
        this.horizontal1Divider.setStroke(halfTranslucent);
        this.horizontal1Divider.setStrokeWidth(1.0);
        this.horizontal2Divider = new Line(166.66666666666666, 112.5, 166.66666666666666, 212.5);
        this.horizontal2Divider.getStrokeDashArray().addAll((Double[])new Double[]{2.0, 2.0});
        this.horizontal2Divider.setStrokeDashOffset(1.0);
        this.horizontal2Divider.setStroke(halfTranslucent);
        this.horizontal2Divider.setStrokeWidth(1.0);
        this.leftGraphicsPane = new StackPane();
        this.middleGraphicsPane = new StackPane();
        this.rightGraphicsPane = new StackPane();
        if (null != this.tile.getLeftGraphics()) {
            this.leftGraphicsPane.getChildren().setAll((Node[])new Node[]{this.tile.getLeftGraphics()});
        }
        if (null != this.tile.getMiddleGraphics()) {
            this.middleGraphicsPane.getChildren().setAll((Node[])new Node[]{this.tile.getMiddleGraphics()});
        }
        if (null != this.tile.getRightGraphics()) {
            this.rightGraphicsPane.getChildren().setAll((Node[])new Node[]{this.tile.getRightGraphics()});
        }
        this.leftValueLabel = new Label();
        this.leftValueLabel.setAlignment(Pos.CENTER);
        this.middleValueLabel = new Label();
        this.middleValueLabel.setAlignment(Pos.CENTER);
        this.rightValueLabel = new Label();
        this.rightValueLabel.setAlignment(Pos.CENTER);
        this.leftLabel = new Label();
        this.leftLabel.setAlignment(Pos.CENTER);
        this.middleLabel = new Label();
        this.middleLabel.setAlignment(Pos.CENTER);
        this.rightLabel = new Label();
        this.rightLabel.setAlignment(Pos.CENTER);
        this.text = new Text(this.tile.getText());
        this.text.setFill(this.tile.getUnitColor());
        Helper.enableNode(this.text, this.tile.isTextVisible());
        this.getPane().getChildren().addAll((Node[])new Node[]{this.titleText, this.description, this.verticalDivider, this.horizontal1Divider, this.horizontal2Divider, this.leftGraphicsPane, this.middleGraphicsPane, this.rightGraphicsPane, this.leftValueLabel, this.middleValueLabel, this.rightValueLabel, this.leftLabel, this.middleLabel, this.rightLabel, this.text});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode(this.titleText, !this.tile.getTitle().isEmpty());
            Helper.enableNode(this.text, this.tile.isTextVisible());
            Helper.enableNode(this.description, !this.tile.getDescription().isEmpty());
        } else if ("RECALC".equals(EVENT_TYPE)) {
            if (null != this.tile.getLeftGraphics()) {
                this.leftGraphicsPane.getChildren().setAll((Node[])new Node[]{this.tile.getLeftGraphics()});
            }
            if (null != this.tile.getMiddleGraphics()) {
                this.middleGraphicsPane.getChildren().setAll((Node[])new Node[]{this.tile.getMiddleGraphics()});
            }
            if (null != this.tile.getRightGraphics()) {
                this.rightGraphicsPane.getChildren().setAll((Node[])new Node[]{this.tile.getRightGraphics()});
            }
            this.resize();
        }
    }

    @Override
    protected void resizeDynamicText() {
        double oneThirdWidth = this.width / 3.0;
        double fontSize = this.size * 0.1;
        this.description.setFont(Fonts.latoRegular(fontSize));
        this.description.setLayoutY(this.height * 0.175);
        fontSize = this.size * 0.075;
        this.leftValueLabel.setFont(Fonts.latoRegular(fontSize));
        this.middleValueLabel.setFont(Fonts.latoRegular(fontSize));
        this.rightValueLabel.setFont(Fonts.latoRegular(fontSize));
        this.leftValueLabel.relocate(0.0, this.height * 0.59);
        this.middleValueLabel.relocate(oneThirdWidth, this.height * 0.59);
        this.rightValueLabel.relocate(this.width - oneThirdWidth, this.height * 0.59);
    }

    @Override
    protected void resizeStaticText() {
        double maxWidth = this.width - this.size * 0.1;
        double fontSize = this.size * this.textSize.factor;
        boolean customFontEnabled = this.tile.isCustomFontEnabled();
        Font customFont = this.tile.getCustomFont();
        Font font = customFontEnabled && customFont != null ? Font.font(customFont.getFamily(), fontSize) : Fonts.latoRegular(fontSize);
        this.titleText.setFont(font);
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        switch (this.tile.getTitleAlignment()) {
            default: {
                this.titleText.relocate(this.size * 0.05, this.size * 0.05);
                break;
            }
            case CENTER: {
                this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.05);
                break;
            }
            case RIGHT: {
                this.titleText.relocate(this.width - this.size * 0.05 - this.titleText.getLayoutBounds().getWidth(), this.size * 0.05);
            }
        }
        this.text.setText(this.tile.getText());
        this.text.setFont(font);
        if (this.text.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.text, maxWidth, fontSize);
        }
        switch (this.tile.getTextAlignment()) {
            default: {
                this.text.setX(this.size * 0.05);
                break;
            }
            case CENTER: {
                this.text.setX((this.width - this.text.getLayoutBounds().getWidth()) * 0.5);
                break;
            }
            case RIGHT: {
                this.text.setX(this.width - this.size * 0.05 - this.text.getLayoutBounds().getWidth());
            }
        }
        this.text.setY(this.height - this.size * 0.05);
    }

    @Override
    protected void resize() {
        super.resize();
        this.description.setPrefSize(this.contentBounds.getWidth(), this.contentBounds.getHeight());
        this.description.relocate(this.contentBounds.getX(), this.contentBounds.getY());
        double oneThirdWidth = this.width / 3.0;
        double iconSize = Helper.clamp(1.0, this.height * 0.1, oneThirdWidth * 0.5);
        double offsetX = (oneThirdWidth - iconSize) * 0.5;
        this.verticalDivider.setStartX(0.0);
        this.verticalDivider.setEndX(this.width);
        this.verticalDivider.setStartY(this.height * 0.35);
        this.verticalDivider.setEndY(this.height * 0.35);
        this.horizontal1Divider.setStartX(oneThirdWidth);
        this.horizontal1Divider.setStartY(this.height * 0.4);
        this.horizontal1Divider.setEndX(oneThirdWidth);
        this.horizontal1Divider.setEndY(this.height * 0.8);
        this.horizontal2Divider.setStartX(2.0 * oneThirdWidth);
        this.horizontal2Divider.setStartY(this.height * 0.4);
        this.horizontal2Divider.setEndX(2.0 * oneThirdWidth);
        this.horizontal2Divider.setEndY(this.height * 0.8);
        this.leftGraphicsPane.setMinSize(iconSize, iconSize);
        this.leftGraphicsPane.setPrefSize(iconSize, iconSize);
        this.leftGraphicsPane.setMaxSize(iconSize, iconSize);
        this.leftGraphicsPane.relocate(offsetX, this.height * 0.425);
        this.middleGraphicsPane.setMinSize(iconSize, iconSize);
        this.middleGraphicsPane.setPrefSize(iconSize, iconSize);
        this.middleGraphicsPane.setMaxSize(iconSize, iconSize);
        this.middleGraphicsPane.relocate(oneThirdWidth + offsetX, this.height * 0.425);
        this.rightGraphicsPane.setMinSize(iconSize, iconSize);
        this.rightGraphicsPane.setPrefSize(iconSize, iconSize);
        this.rightGraphicsPane.setMaxSize(iconSize, iconSize);
        this.rightGraphicsPane.relocate(2.0 * oneThirdWidth + offsetX, this.height * 0.425);
        this.leftValueLabel.setPrefWidth(oneThirdWidth);
        this.middleValueLabel.setPrefWidth(oneThirdWidth);
        this.rightValueLabel.setPrefWidth(oneThirdWidth);
        this.leftLabel.setPrefWidth(oneThirdWidth);
        this.middleLabel.setPrefWidth(oneThirdWidth);
        this.rightLabel.setPrefWidth(oneThirdWidth);
        this.leftLabel.setFont(Fonts.latoRegular(this.size * 0.035));
        this.middleLabel.setFont(Fonts.latoRegular(this.size * 0.035));
        this.rightLabel.setFont(Fonts.latoRegular(this.size * 0.035));
        this.leftLabel.relocate(0.0, this.height * 0.75);
        this.middleLabel.relocate(oneThirdWidth, this.height * 0.75);
        this.rightLabel.relocate(this.width - oneThirdWidth, this.height * 0.75);
    }

    @Override
    protected void redraw() {
        super.redraw();
        this.titleText.setText(this.tile.getTitle());
        this.text.setText(this.tile.getText());
        this.description.setText(this.tile.getDescription());
        this.description.setAlignment(this.tile.getDescriptionAlignment());
        this.leftValueLabel.setText(String.format(Locale.US, "%.0f", this.tile.getLeftValue()));
        this.middleValueLabel.setText(String.format(Locale.US, "%.0f", this.tile.getMiddleValue()));
        this.rightValueLabel.setText(String.format(Locale.US, "%.0f", this.tile.getRightValue()));
        this.leftLabel.setText(this.tile.getLeftText());
        this.middleLabel.setText(this.tile.getMiddleText());
        this.rightLabel.setText(this.tile.getRightText());
        this.resizeDynamicText();
        this.resizeStaticText();
        this.titleText.setFill(this.tile.getTitleColor());
        this.text.setFill(this.tile.getTextColor());
        this.description.setTextFill(this.tile.getTextColor());
        Color foregroundColor = ((Tile)this.getSkinnable()).getForegroundColor();
        Color halfTranslucent = Helper.getColorWithOpacity(foregroundColor, 0.5);
        this.leftValueLabel.setTextFill(foregroundColor);
        this.middleValueLabel.setTextFill(foregroundColor);
        this.rightValueLabel.setTextFill(foregroundColor);
        this.leftLabel.setTextFill(halfTranslucent);
        this.middleLabel.setTextFill(halfTranslucent);
        this.rightLabel.setTextFill(halfTranslucent);
        this.verticalDivider.setStroke(halfTranslucent);
        this.horizontal1Divider.setStroke(halfTranslucent);
        this.horizontal2Divider.setStroke(halfTranslucent);
    }
}

