/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.tools;

import eu.hansolo.tilesfx.tools.ConicalGradient;
import eu.hansolo.tilesfx.tools.CtxBounds;
import eu.hansolo.tilesfx.tools.Helper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;

public class AngleConicalGradient {
    private ConicalGradient gradient;

    public AngleConicalGradient(Map<Double, Color> ANGLE_STOP_MAP) {
        this(0.0, 0.0, ANGLE_STOP_MAP);
    }

    public AngleConicalGradient(double CENTER_X, double CENTER_Y, Map<Double, Color> ANGLE_STOP_MAP) {
        this(CENTER_X, CENTER_Y, 0.0, ANGLE_STOP_MAP);
    }

    public AngleConicalGradient(double CENTER_X, double CENTER_Y, double OFFSET_ANGLE, Map<Double, Color> ANGLE_STOP_MAP) {
        double ANGLE_FACTOR = 0.002777777777777778;
        double offset = Helper.clamp(0.0, 1.0, OFFSET_ANGLE % 360.0 * 0.002777777777777778);
        ArrayList<Stop> stops = new ArrayList<Stop>();
        for (double fraction : ANGLE_STOP_MAP.keySet()) {
            stops.add(new Stop(Helper.clamp(0.0, 1.0, fraction % 360.0 * 0.002777777777777778), ANGLE_STOP_MAP.get(fraction)));
        }
        this.gradient = new ConicalGradient(CENTER_X, CENTER_Y, offset, stops);
    }

    public void recalculateWithAngle(double ANGLE) {
        this.gradient.recalculateWithAngle(ANGLE);
    }

    public List<Stop> getStops() {
        return this.gradient.getStops();
    }

    public double[] getCenter() {
        return this.gradient.getCenter();
    }

    public double getCenterX() {
        return this.gradient.getCenter()[0];
    }

    public double getCenterY() {
        return this.gradient.getCenter()[1];
    }

    public Point2D getCenterPoint() {
        return this.gradient.getCenterPoint();
    }

    public Image getImage(double WIDTH, double HEIGHT) {
        return this.gradient.getImage(WIDTH, HEIGHT);
    }

    public Image getRoundImage(double SIZE2) {
        return this.gradient.getRoundImage(SIZE2);
    }

    public ImagePattern apply(Shape SHAPE) {
        return this.gradient.apply(SHAPE);
    }

    public ImagePattern getImagePattern(Bounds BOUNDS) {
        return this.getImagePattern(new Rectangle(BOUNDS.getMinX(), BOUNDS.getMinY(), BOUNDS.getWidth(), BOUNDS.getHeight()));
    }

    public ImagePattern getImagePattern(Rectangle BOUNDS) {
        return this.gradient.getImagePattern(BOUNDS);
    }

    public ImagePattern getImagePattern(CtxBounds BOUNDS) {
        return this.gradient.getImagePattern(BOUNDS);
    }
}

