/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import mediathek.tool.ApplicationConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004J\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004J\b\u0010\u0011\u001a\u00020\u000eH\u0002J\u000e\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lmediathek/controller/SenderFilmlistLoadApprover;", "", "()V", "SENDER_KEY", "", "config", "Lorg/apache/commons/configuration2/Configuration;", "kotlin.jvm.PlatformType", "senderSet", "Ljava/util/concurrent/ConcurrentHashMap$KeySetView;", "", "getSenderSet", "()Ljava/util/concurrent/ConcurrentHashMap$KeySetView;", "approve", "", "sender", "deny", "initializeSenderList", "isApproved", "MediathekView"})
public final class SenderFilmlistLoadApprover {
    @NotNull
    private static final ConcurrentHashMap.KeySetView<String, Boolean> senderSet;
    private static final String SENDER_KEY = "filmlist.approved_for_load";
    private static final Configuration config;
    @NotNull
    public static final SenderFilmlistLoadApprover INSTANCE;

    @NotNull
    public final ConcurrentHashMap.KeySetView<String, Boolean> getSenderSet() {
        return senderSet;
    }

    public final boolean isApproved(@NotNull String sender) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        return senderSet.contains(sender);
    }

    public final void approve(@NotNull String sender) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        if (!senderSet.contains(sender)) {
            senderSet.add(sender);
            config.setProperty(SENDER_KEY, senderSet);
        }
    }

    public final void deny(@NotNull String sender) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        if (senderSet.contains(sender)) {
            senderSet.remove(sender);
            config.setProperty(SENDER_KEY, senderSet);
        }
    }

    private final void initializeSenderList() {
        senderSet.add("3Sat");
        senderSet.add("ARD");
        senderSet.add("ARTE.DE");
        senderSet.add("ARTE.FR");
        senderSet.add("BR");
        senderSet.add("DW");
        senderSet.add("HR");
        senderSet.add("KiKA");
        senderSet.add("MDR");
        senderSet.add("NDR");
        senderSet.add("ORF");
        senderSet.add("PHOENIX");
        senderSet.add("Radio Bremen TV");
        senderSet.add("RBB");
        senderSet.add("SR");
        senderSet.add("SRF");
        senderSet.add("SRF.Podcast");
        senderSet.add("SWR");
        senderSet.add("WDR");
        senderSet.add("ZDF");
        senderSet.add("ZDF-tivi");
        senderSet.add("Funk.net");
    }

    private SenderFilmlistLoadApprover() {
    }

    static {
        SenderFilmlistLoadApprover senderFilmlistLoadApprover;
        INSTANCE = senderFilmlistLoadApprover = new SenderFilmlistLoadApprover();
        ConcurrentHashMap.KeySetView keySetView = ConcurrentHashMap.newKeySet();
        Intrinsics.checkNotNullExpressionValue(keySetView, "ConcurrentHashMap.newKeySet()");
        senderSet = keySetView;
        config = ApplicationConfiguration.getConfiguration();
        List<String> storedSenderList = config.getList(String.class, SENDER_KEY);
        if (storedSenderList == null || storedSenderList.isEmpty()) {
            senderFilmlistLoadApprover.initializeSenderList();
            config.setProperty(SENDER_KEY, senderSet);
        } else {
            senderSet.addAll((Collection<String>)storedSenderList);
        }
    }
}

