/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller.history;

import com.google.common.collect.Sets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mediathek.config.Daten;
import mediathek.controller.history.SeenHistoryShutdownHook;
import mediathek.daten.DatenFilm;
import mediathek.gui.messages.history.DownloadHistoryChangedEvent;
import mediathek.tool.sql.SqlDatabaseConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.sqlite.SQLiteDataSource;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\r\u0018\u0000 12\u00020\u0001:\u00011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0016H\u0016J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0006\u0010\u001d\u001a\u00020\u0016J\u000e\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010!\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020 J\b\u0010\"\u001a\u00020\u0016H\u0002J\u0014\u0010#\u001a\u00020\u00162\f\u0010$\u001a\b\u0012\u0004\u0012\u00020 0%J\u000e\u0010#\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 J\u0014\u0010&\u001a\u00020\u00162\f\u0010$\u001a\b\u0012\u0004\u0012\u00020 0%J\u000e\u0010&\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010'\u001a\u00020\u0016J\b\u0010(\u001a\u00020\u0016H\u0002J\u0006\u0010)\u001a\u00020\u0016J\u0006\u0010*\u001a\u00020\u0016J\b\u0010+\u001a\u00020\u0016H\u0002J$\u0010,\u001a\u00020\u00162\b\u0010-\u001a\u0004\u0018\u00010\u00122\b\u0010.\u001a\u0004\u0018\u00010\u00122\b\u0010/\u001a\u0004\u0018\u00010\u0012J\u0010\u00100\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R2\u0010\u0010\u001a&\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00120\u0012 \u0013*\u0012\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00120\u0012\u0018\u00010\u00140\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lmediathek/controller/history/SeenHistoryController;", "Ljava/lang/AutoCloseable;", "()V", "connection", "Ljava/sql/Connection;", "dataSource", "Lorg/sqlite/SQLiteDataSource;", "deleteStatement", "Ljava/sql/PreparedStatement;", "insertStatement", "manualInsertStatement", "memCachePrepared", "", "seenStatement", "shutdownThread", "Lmediathek/controller/history/SeenHistoryShutdownHook;", "urlCache", "", "", "kotlin.jvm.PlatformType", "", "basicSqliteSettings", "", "statement", "Ljava/sql/Statement;", "close", "createEmptyDatabase", "dbPath", "Ljava/nio/file/Path;", "emptyMemoryCache", "hasBeenSeen", "film", "Lmediathek/daten/DatenFilm;", "hasBeenSeenFromCache", "installShutdownHook", "markSeen", "list", "", "markUnseen", "performMaintenance", "performSqliteSetup", "prepareMemoryCache", "removeAll", "sendChangeMessage", "writeManualEntry", "thema", "title", "url", "writeToDatabase", "Companion", "MediathekView"})
public final class SeenHistoryController
implements AutoCloseable {
    private Connection connection;
    private PreparedStatement insertStatement;
    private final SQLiteDataSource dataSource = SqlDatabaseConfig.getDataSource();
    private PreparedStatement deleteStatement;
    private PreparedStatement seenStatement;
    private PreparedStatement manualInsertStatement;
    private final Set<String> urlCache = Sets.newConcurrentHashSet();
    private boolean memCachePrepared;
    private SeenHistoryShutdownHook shutdownThread;
    private static final Logger logger;
    private static final String INSERT_SQL = "INSERT INTO seen_history(thema,titel,url) values (?,?,?)";
    private static final String DELETE_SQL = "DELETE FROM seen_history WHERE url = ?";
    private static final String SEEN_SQL = "SELECT COUNT(url) AS total FROM seen_history WHERE url = ?";
    private static final String MANUAL_INSERT_SQL = "INSERT INTO seen_history(thema, titel, url) VALUES (?,?,?)";
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeAll() {
        try {
            Connection connection = this.connection;
            Intrinsics.checkNotNull(connection);
            AutoCloseable autoCloseable = connection.createStatement();
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                Statement stmt = (Statement)autoCloseable;
                boolean bl3 = false;
                int n = stmt.executeUpdate("DELETE FROM seen_history");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally(autoCloseable, throwable);
            }
            this.sendChangeMessage();
        }
        catch (SQLException ex) {
            logger.error("removeAll", (Throwable)ex);
        }
    }

    public final void markUnseen(@NotNull DatenFilm film) {
        Intrinsics.checkNotNullParameter(film, "film");
        try {
            PreparedStatement preparedStatement = this.deleteStatement;
            Intrinsics.checkNotNull(preparedStatement);
            preparedStatement.setString(1, film.getUrl());
            PreparedStatement preparedStatement2 = this.deleteStatement;
            Intrinsics.checkNotNull(preparedStatement2);
            preparedStatement2.executeUpdate();
            Daten daten = Daten.getInstance();
            Intrinsics.checkNotNullExpressionValue(daten, "Daten.getInstance()");
            daten.getListeBookmarkList().updateSeen(false, film);
            this.sendChangeMessage();
        }
        catch (SQLException ex) {
            logger.error("markUnseen", (Throwable)ex);
        }
    }

    public final void markUnseen(@NotNull List<? extends DatenFilm> list) {
        Intrinsics.checkNotNullParameter(list, "list");
        try {
            for (DatenFilm film : list) {
                PreparedStatement preparedStatement = this.deleteStatement;
                Intrinsics.checkNotNull(preparedStatement);
                preparedStatement.setString(1, film.getUrl());
                PreparedStatement preparedStatement2 = this.deleteStatement;
                Intrinsics.checkNotNull(preparedStatement2);
                preparedStatement2.executeUpdate();
            }
            Daten daten = Daten.getInstance();
            Intrinsics.checkNotNullExpressionValue(daten, "Daten.getInstance()");
            daten.getListeBookmarkList().updateSeen(false, list);
            this.sendChangeMessage();
        }
        catch (SQLException ex) {
            logger.error("markUnseen", (Throwable)ex);
        }
    }

    public final void markSeen(@NotNull DatenFilm film) {
        Intrinsics.checkNotNullParameter(film, "film");
        if (film.isLivestream()) {
            return;
        }
        if (this.hasBeenSeen(film)) {
            return;
        }
        try {
            this.writeToDatabase(film);
            Daten daten = Daten.getInstance();
            Intrinsics.checkNotNullExpressionValue(daten, "Daten.getInstance()");
            daten.getListeBookmarkList().updateSeen(true, film);
            this.sendChangeMessage();
        }
        catch (SQLException ex) {
            logger.error("markSeen single", (Throwable)ex);
        }
    }

    public final void markSeen(@NotNull List<? extends DatenFilm> list) {
        Intrinsics.checkNotNullParameter(list, "list");
        try {
            for (DatenFilm film : list) {
                if (film.isLivestream() || this.hasBeenSeen(film)) continue;
                this.writeToDatabase(film);
            }
            Daten daten = Daten.getInstance();
            Intrinsics.checkNotNullExpressionValue(daten, "Daten.getInstance()");
            daten.getListeBookmarkList().updateSeen(true, list);
            this.sendChangeMessage();
        }
        catch (SQLException ex) {
            logger.error("markSeen", (Throwable)ex);
        }
    }

    public final void writeManualEntry(@Nullable String thema, @Nullable String title, @Nullable String url) {
        try {
            PreparedStatement preparedStatement = this.manualInsertStatement;
            Intrinsics.checkNotNull(preparedStatement);
            preparedStatement.setString(1, thema);
            PreparedStatement preparedStatement2 = this.manualInsertStatement;
            Intrinsics.checkNotNull(preparedStatement2);
            preparedStatement2.setString(2, title);
            PreparedStatement preparedStatement3 = this.manualInsertStatement;
            Intrinsics.checkNotNull(preparedStatement3);
            preparedStatement3.setString(3, url);
            PreparedStatement preparedStatement4 = this.manualInsertStatement;
            Intrinsics.checkNotNull(preparedStatement4);
            preparedStatement4.executeUpdate();
            this.sendChangeMessage();
        }
        catch (SQLException ex) {
            logger.error("writeManualEntry", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void prepareMemoryCache() {
        Connection connection = this.connection;
        Intrinsics.checkNotNull(connection);
        AutoCloseable autoCloseable = connection.createStatement();
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            Statement st = (Statement)autoCloseable;
            boolean bl3 = false;
            AutoCloseable autoCloseable2 = st.executeQuery("SELECT url as url FROM seen_history");
            boolean bl4 = false;
            boolean bl5 = false;
            Throwable throwable2 = null;
            try {
                ResultSet rs = (ResultSet)autoCloseable2;
                boolean bl6 = false;
                while (rs.next()) {
                    String url = rs.getString(1);
                    this.urlCache.add(url);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally(autoCloseable2, throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        logger.trace("cache size: {}", (Object)this.urlCache.size());
        this.memCachePrepared = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void performMaintenance() {
        logger.trace("Start maintenance");
        try {
            Connection connection = this.connection;
            Intrinsics.checkNotNull(connection);
            AutoCloseable autoCloseable = connection.createStatement();
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                Statement it = (Statement)autoCloseable;
                boolean bl3 = false;
                it.executeUpdate("DELETE FROM seen_history WHERE thema = 'Livestream'");
                it.executeUpdate("REINDEX seen_history");
                int n = it.executeUpdate("VACUUM");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally(autoCloseable, throwable);
            }
        }
        catch (SQLException e) {
            logger.error("Failed to execute maintenance script", (Throwable)e);
        }
        logger.trace("Finished maintenance");
    }

    public final void emptyMemoryCache() {
        this.urlCache.clear();
        this.memCachePrepared = false;
    }

    public final boolean hasBeenSeenFromCache(@NotNull DatenFilm film) {
        Intrinsics.checkNotNullParameter(film, "film");
        if (!this.memCachePrepared) {
            this.prepareMemoryCache();
        }
        return this.urlCache.contains(film.getUrl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasBeenSeen(@NotNull DatenFilm film) {
        Intrinsics.checkNotNullParameter(film, "film");
        boolean result = false;
        try {
            PreparedStatement preparedStatement = this.seenStatement;
            Intrinsics.checkNotNull(preparedStatement);
            preparedStatement.setString(1, film.getUrl());
            PreparedStatement preparedStatement2 = this.seenStatement;
            Intrinsics.checkNotNull(preparedStatement2);
            AutoCloseable autoCloseable = preparedStatement2.executeQuery();
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                ResultSet it = (ResultSet)autoCloseable;
                boolean bl3 = false;
                it.next();
                int total = it.getInt(1);
                result = total != 0;
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally(autoCloseable, throwable);
            }
        }
        catch (SQLException e) {
            logger.error("SQL error:", (Throwable)e);
            result = false;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void createEmptyDatabase(Path dbPath) throws SQLException {
        String dbUrl = "jdbc:sqlite:" + ((Object)dbPath.toAbsolutePath()).toString();
        AutoCloseable autoCloseable = DriverManager.getConnection(dbUrl, SqlDatabaseConfig.getConfig().toProperties());
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            int n;
            Connection conn = (Connection)autoCloseable;
            boolean bl3 = false;
            Connection connection = conn;
            Intrinsics.checkNotNullExpressionValue(connection, "conn");
            connection.setTransactionIsolation(8);
            AutoCloseable autoCloseable2 = conn.createStatement();
            boolean bl4 = false;
            boolean bl5 = false;
            Throwable throwable2 = null;
            try {
                Statement statement = (Statement)autoCloseable2;
                boolean bl6 = false;
                Statement statement2 = statement;
                Intrinsics.checkNotNullExpressionValue(statement2, "statement");
                this.basicSqliteSettings(statement2);
                statement.executeUpdate("DROP INDEX IF EXISTS IDX_SEEN_HISTORY_URL");
                statement.executeUpdate("DROP TABLE IF EXISTS seen_history");
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS seen_history (id INTEGER PRIMARY KEY ASC, datum DATE NOT NULL DEFAULT (date('now')), thema TEXT, titel TEXT, url TEXT NOT NULL)");
                n = statement.executeUpdate("CREATE INDEX IF NOT EXISTS IDX_SEEN_HISTORY_URL ON seen_history(url)");
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally(autoCloseable2, throwable2);
            }
            int n2 = n;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    private final void basicSqliteSettings(Statement statement) {
        statement.executeUpdate("PRAGMA encoding='UTF-8'");
        statement.executeUpdate("PRAGMA page_size = 4096");
    }

    private final void writeToDatabase(DatenFilm film) throws SQLException {
        PreparedStatement preparedStatement = this.insertStatement;
        Intrinsics.checkNotNull(preparedStatement);
        preparedStatement.setString(1, film.getThema());
        PreparedStatement preparedStatement2 = this.insertStatement;
        Intrinsics.checkNotNull(preparedStatement2);
        preparedStatement2.setString(2, film.getTitle());
        PreparedStatement preparedStatement3 = this.insertStatement;
        Intrinsics.checkNotNull(preparedStatement3);
        preparedStatement3.setString(3, film.getUrl());
        PreparedStatement preparedStatement4 = this.insertStatement;
        Intrinsics.checkNotNull(preparedStatement4);
        preparedStatement4.executeUpdate();
    }

    private final void sendChangeMessage() {
        Daten daten = Daten.getInstance();
        Intrinsics.checkNotNullExpressionValue(daten, "Daten.getInstance()");
        daten.getMessageBus().publishAsync(new DownloadHistoryChangedEvent());
    }

    @Override
    public void close() {
        this.urlCache.clear();
        try {
            PreparedStatement preparedStatement = this.insertStatement;
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            PreparedStatement preparedStatement2 = this.deleteStatement;
            if (preparedStatement2 != null) {
                preparedStatement2.close();
            }
            PreparedStatement preparedStatement3 = this.seenStatement;
            if (preparedStatement3 != null) {
                preparedStatement3.close();
            }
            PreparedStatement preparedStatement4 = this.manualInsertStatement;
            if (preparedStatement4 != null) {
                preparedStatement4.close();
            }
            Connection connection = this.connection;
            if (connection != null) {
                connection.close();
            }
            if (this.shutdownThread != null) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownThread);
            }
        }
        catch (SQLException ex) {
            logger.error("close", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void performSqliteSetup() {
        Connection connection = this.connection;
        Intrinsics.checkNotNull(connection);
        AutoCloseable autoCloseable = connection.createStatement();
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            Statement statement = (Statement)autoCloseable;
            boolean bl3 = false;
            Statement statement2 = statement;
            Intrinsics.checkNotNullExpressionValue(statement2, "statement");
            this.basicSqliteSettings(statement2);
            int cpus = Runtime.getRuntime().availableProcessors() / 2;
            int n = statement.executeUpdate("PRAGMA threads=" + cpus);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    private final void installShutdownHook() {
        this.shutdownThread = new SeenHistoryShutdownHook(this.connection);
        Runtime.getRuntime().addShutdownHook(this.shutdownThread);
    }

    public SeenHistoryController() {
        try {
            if (!Files.exists(SqlDatabaseConfig.getHistoryDbPath(), new LinkOption[0])) {
                this.createEmptyDatabase(SqlDatabaseConfig.getHistoryDbPath());
            }
            this.connection = this.dataSource.getConnection();
            this.performSqliteSetup();
            Connection connection = this.connection;
            this.insertStatement = connection != null ? connection.prepareStatement(INSERT_SQL) : null;
            Connection connection2 = this.connection;
            this.deleteStatement = connection2 != null ? connection2.prepareStatement(DELETE_SQL) : null;
            Connection connection3 = this.connection;
            this.seenStatement = connection3 != null ? connection3.prepareStatement(SEEN_SQL) : null;
            Connection connection4 = this.connection;
            this.manualInsertStatement = connection4 != null ? connection4.prepareStatement(MANUAL_INSERT_SQL) : null;
            this.installShutdownHook();
        }
        catch (SQLException ex) {
            logger.error("ctor", (Throwable)ex);
            int n = 99;
            boolean bl = false;
            System.exit(n);
            throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    static {
        Companion = new Companion(null);
        logger = LogManager.getLogger();
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lmediathek/controller/history/SeenHistoryController$Companion;", "", "()V", "DELETE_SQL", "", "INSERT_SQL", "MANUAL_INSERT_SQL", "SEEN_SQL", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "MediathekView"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

