/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.actions.import_actions;

import java.awt.event.ActionEvent;
import java.io.File;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javafx.stage.FileChooser;
import javax.swing.AbstractAction;
import mediathek.gui.actions.import_actions.ImportSettingsAlert;
import mediathek.gui.actions.import_actions.OldConfigFileImporter;
import mediathek.tool.javafx.FXErrorDialog;
import org.apache.commons.lang3.tuple.ImmutableTriple;

public class ImportOldBlacklistAction
extends AbstractAction {
    public ImportOldBlacklistAction() {
        this.putValue("Name", "Alte Blacklist...");
        this.putValue("ShortDescription", "Erm\u00f6glicht den Import der Blacklist aus einer alten Konfigurationsdatei.");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Platform.runLater(() -> {
            FileChooser fileChooser = new FileChooser();
            fileChooser.setTitle("Konfigurationsdatei \u00f6ffnen");
            File selectedFile = fileChooser.showOpenDialog(null);
            if (selectedFile != null) {
                try {
                    OldConfigFileImporter configReader = new OldConfigFileImporter();
                    ImmutableTriple<Integer, Integer, Integer> result = configReader.importAboBlacklist(selectedFile.getAbsolutePath(), false, true, false);
                    ImportSettingsAlert alert = new ImportSettingsAlert(Alert.AlertType.INFORMATION);
                    String text = "Es wurden " + result.middle + " Eintr\u00e4ge importiert.";
                    alert.setContentText(text);
                    alert.showAndWait();
                }
                catch (Exception ex) {
                    Platform.runLater(() -> FXErrorDialog.showErrorDialog("MediathekView", "Fehler beim Importieren der Blacklist", "Es trat ein Fehler beim Import der Blacklist auf.\nSollte dies h\u00e4ufiger auftreten kontaktieren Sie bitte das Entwicklerteam.", ex));
                }
            } else {
                ImportSettingsAlert alert = new ImportSettingsAlert(Alert.AlertType.WARNING);
                alert.setContentText("Der Import der Blacklist wurde abgebrochen.");
                alert.showAndWait();
            }
        });
    }
}

