/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialog.about;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.nio.file.Path;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;
import mediathek.config.Daten;
import mediathek.config.Konstanten;
import mediathek.tool.swing.HyperlinkDecorator;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;

public class AboutDialogPanel
extends JPanel {
    private JLabel lblVersion;
    private JLabel lblFilmListPath;
    private JLabel lblSettingsDirectory;
    private JLabel lblWebsite;
    private JLabel lblDonation;
    private JLabel lblSupportClientDev;
    private JLabel lblForum;
    private JLabel lblInstructions;
    private JLabel lblJetbrainsLink;
    private JLabel lblEjTechLink;

    public AboutDialogPanel() {
        this.initComponents();
        this.setupVersionString();
        this.setupProgramPaths();
        this.setupHyperlinks();
    }

    private void setupHyperlinks() {
        HyperlinkDecorator.makeLinkable(this.lblWebsite, "https://mediathekview.de/");
        HyperlinkDecorator.makeLinkable(this.lblDonation, "https://mediathekview.de/spenden/");
        HyperlinkDecorator.makeLinkable(this.lblSupportClientDev, "https://paypal.me/ChristianFranzke");
        HyperlinkDecorator.makeLinkable(this.lblForum, "https://forum.mediathekview.de/");
        HyperlinkDecorator.makeLinkable(this.lblInstructions, "https://mediathekview.de/anleitung/");
        HyperlinkDecorator.makeLinkable(this.lblJetbrainsLink, "https://www.jetbrains.com");
        HyperlinkDecorator.makeLinkable(this.lblEjTechLink, "https://www.ej-technologies.com");
    }

    private void setupProgramPaths() {
        Path xmlFilePath = Daten.getMediathekXmlFilePath();
        this.lblSettingsDirectory.setText(xmlFilePath.toAbsolutePath().toString());
        this.lblFilmListPath.setText(Daten.getDateiFilmliste());
    }

    private void setupVersionString() {
        Object strVersion = "Version ";
        strVersion = (String)strVersion + Konstanten.MVVERSION;
        this.lblVersion.setText((String)strVersion);
    }

    private void initComponents() {
        JLabel lblIcon = new JLabel();
        JPanel panel3 = new JPanel();
        JLabel lblAppName = new JLabel();
        this.lblVersion = new JLabel();
        JTabbedPane tabbedPane1 = new JTabbedPane();
        JPanel panel6 = new JPanel();
        JScrollPane scrollPane1 = new JScrollPane();
        JEditorPane editorPane1 = new JEditorPane();
        JPanel panel7 = new JPanel();
        JScrollPane scrollPane2 = new JScrollPane();
        JEditorPane editorPane2 = new JEditorPane();
        JPanel pnlProgramPath = new JPanel();
        JLabel label13 = new JLabel();
        this.lblFilmListPath = new JLabel();
        JLabel label14 = new JLabel();
        this.lblSettingsDirectory = new JLabel();
        JPanel pnlHyperlinks = new JPanel();
        this.lblWebsite = new JLabel();
        this.lblDonation = new JLabel();
        this.lblSupportClientDev = new JLabel();
        this.lblForum = new JLabel();
        this.lblInstructions = new JLabel();
        JPanel panel2 = new JPanel();
        JLabel label7 = new JLabel();
        this.lblJetbrainsLink = new JLabel();
        this.lblEjTechLink = new JLabel();
        this.setLayout(new MigLayout(new LC().insets("5").hideMode(3), new AC().fill().gap().grow().fill(), new AC().gap().gap()));
        lblIcon.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/MediathekView.png")));
        this.add((Component)lblIcon, new CC().cell(0, 0));
        panel3.setLayout(new MigLayout(new LC().hideMode(3), new AC().grow().fill(), new AC().gap().gap().gap().gap()));
        lblAppName.setText("MediathekView");
        lblAppName.setFont(lblAppName.getFont().deriveFont(lblAppName.getFont().getStyle() | 1, 24.0f));
        panel3.add((Component)lblAppName, new CC().cell(0, 0));
        this.lblVersion.setText("Version 13.4");
        this.lblVersion.setFont(this.lblVersion.getFont().deriveFont(this.lblVersion.getFont().getStyle() | 1));
        this.lblVersion.setForeground(Color.gray);
        panel3.add((Component)this.lblVersion, new CC().cell(0, 1));
        panel6.setMinimumSize(new Dimension(23, 250));
        panel6.setPreferredSize(new Dimension(147, 300));
        panel6.setLayout(new BorderLayout());
        editorPane1.setEditable(false);
        editorPane1.setText("MediathekView-Client:\nChristian Franzke (derreisende77)\n\nMediathekView-Server:\nNicklas Wiegandt (nicklas2751)\nPeter W. (pidoubleyou)\nSascha Wiegandt (thesasch)\n\nServer-Administration:\nAlexander Finkh\u00e4user (alex1702)");
        editorPane1.setCaretPosition(1);
        scrollPane1.setViewportView(editorPane1);
        panel6.add((Component)scrollPane1, "Center");
        tabbedPane1.addTab("Aktive Entwickler", panel6);
        panel7.setMinimumSize(new Dimension(23, 250));
        panel7.setPreferredSize(new Dimension(490, 300));
        panel7.setLayout(new BorderLayout());
        editorPane2.setEditable(false);
        editorPane2.setText("Gr\u00fcnder des Programms:\nXaver W. (xaverW)\n\nWeitere Beteiligte:\nsiedlerchr\nstyrol\nzxsd\nsiedlerchr\napoleon\nhostis\npmshell\nclel\nthausherr");
        editorPane2.setCaretPosition(1);
        scrollPane2.setViewportView(editorPane2);
        panel7.add((Component)scrollPane2, "Center");
        tabbedPane1.addTab("Ehemalige", panel7);
        panel3.add((Component)tabbedPane1, new CC().cell(0, 2).width("250:550").height("200:200:200"));
        pnlProgramPath.setBorder(new TitledBorder("Programmpfade"));
        pnlProgramPath.setLayout(new MigLayout(new LC().hideMode(3), new AC().fill().gap().grow().fill(), new AC().gap()));
        label13.setText("Filmliste:");
        label13.setHorizontalAlignment(4);
        label13.setForeground(Color.gray);
        pnlProgramPath.add((Component)label13, new CC().cell(0, 0));
        this.lblFilmListPath.setText("path to filmlist");
        this.lblFilmListPath.setForeground(Color.gray);
        pnlProgramPath.add((Component)this.lblFilmListPath, new CC().cell(1, 0).growX().width("300:500"));
        label14.setText("Einstellungen:");
        label14.setHorizontalAlignment(4);
        label14.setForeground(Color.gray);
        pnlProgramPath.add((Component)label14, new CC().cell(0, 1));
        this.lblSettingsDirectory.setText("path to settings directory");
        this.lblSettingsDirectory.setForeground(Color.gray);
        pnlProgramPath.add((Component)this.lblSettingsDirectory, new CC().cell(1, 1).growX());
        panel3.add((Component)pnlProgramPath, new CC().cell(0, 4).growX());
        this.add((Component)panel3, new CC().cell(1, 0, 1, 2).alignY("top").growY(0.0f));
        pnlHyperlinks.setLayout(new MigLayout(new LC().hideMode(3), new AC().fill(), new AC().gap().gap().gap().gap()));
        this.lblWebsite.setText("Website");
        this.lblWebsite.setHorizontalAlignment(2);
        this.lblWebsite.setForeground(new Color(88, 157, 246));
        pnlHyperlinks.add((Component)this.lblWebsite, new CC().cell(0, 0).alignX("left").growX(0.0f));
        this.lblDonation.setText("Spende f\u00fcr den Betrieb");
        this.lblDonation.setForeground(new Color(88, 157, 246));
        pnlHyperlinks.add((Component)this.lblDonation, new CC().cell(0, 1).alignX("left").growX(0.0f));
        this.lblSupportClientDev.setText("Spende an den Client-Entwickler");
        this.lblSupportClientDev.setForeground(new Color(88, 157, 246));
        pnlHyperlinks.add((Component)this.lblSupportClientDev, new CC().cell(0, 2).alignX("left").growX(0.0f));
        this.lblForum.setText("Forum");
        this.lblForum.setForeground(new Color(88, 157, 246));
        pnlHyperlinks.add((Component)this.lblForum, new CC().cell(0, 3).alignX("left").growX(0.0f));
        this.lblInstructions.setText("Anleitung");
        this.lblInstructions.setForeground(new Color(88, 157, 246));
        pnlHyperlinks.add((Component)this.lblInstructions, new CC().cell(0, 4).alignX("left").growX(0.0f));
        this.add((Component)pnlHyperlinks, new CC().cell(0, 1).alignY("top").growY(0.0f));
        panel2.setLayout(new MigLayout(new LC().hideMode(3), new AC().fill().gap().grow().fill(), new AC().gap()));
        label7.setText("Development supported by:");
        panel2.add((Component)label7, new CC().cell(0, 0));
        this.lblJetbrainsLink.setText("JetBrains IntelliJ");
        this.lblJetbrainsLink.setForeground(new Color(88, 157, 246));
        panel2.add((Component)this.lblJetbrainsLink, new CC().cell(1, 0).alignX("left").growX(0.0f));
        this.lblEjTechLink.setText("ej-technologies JProfiler and install4j");
        this.lblEjTechLink.setForeground(new Color(88, 157, 246));
        panel2.add((Component)this.lblEjTechLink, new CC().cell(1, 1).alignX("left").growX(0.0f));
        this.add((Component)panel2, new CC().cell(0, 2, 2, 1));
    }
}

