/*
 * Decompiled with CFR 0.152.
 */
package mediathek.javafx.bookmark;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;

public class BookmarkDateDiff {
    private LocalDate today = LocalDate.now();
    private static BookmarkDateDiff bookmarkDateComparator;
    DateTimeFormatter dateformatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");

    private BookmarkDateDiff() {
    }

    public long diff2Today(String str) {
        if (this.today != null && str != null) {
            LocalDate ld = LocalDate.parse(str, this.dateformatter);
            return ChronoUnit.DAYS.between(this.today, ld);
        }
        return 0L;
    }

    public void setToday(LocalDate d) {
        this.today = d;
    }

    public static synchronized BookmarkDateDiff getInstance() {
        if (bookmarkDateComparator == null) {
            bookmarkDateComparator = new BookmarkDateDiff();
        }
        return bookmarkDateComparator;
    }
}

