/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Log {
    public static final String LINE = "################################################################################";
    public static final Instant startZeit = Instant.now();
    private static final ArrayList<String> logList = new ArrayList();
    private static final Logger logger = LogManager.getLogger();
    private static boolean progress;

    public static void printRuntimeStatistics() {
        DateTimeFormatter formatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
        ZoneId systemZone = ZoneId.systemDefault();
        Instant endZeit = Instant.now();
        long runtimeDuration = Duration.between(startZeit, endZeit).toSeconds();
        LocalTime str = LocalTime.MIN.plusSeconds(runtimeDuration);
        logger.info(LINE);
        logger.info("   --> Start: {}", (Object)formatter.format(LocalDateTime.ofInstant(startZeit, systemZone)));
        logger.info("   --> Ende: {}", (Object)formatter.format(LocalDateTime.ofInstant(endZeit, systemZone)));
        logger.info("   --> Laufzeit: {}h {}m {}s", (Object)str.getHour(), (Object)str.getMinute(), (Object)str.getSecond());
        logger.info(LINE);
    }

    public static synchronized void sysLog(String text) {
        Log.systemmeldung_(new String[]{text});
    }

    public static synchronized void progress(String texte) {
        progress = true;
        if (!texte.isEmpty()) {
            System.out.print(texte + "\r");
        }
    }

    private static void resetProgress() {
        if (progress) {
            System.out.print("                                                                                                             \r");
            progress = false;
        }
    }

    private static void systemmeldung_(String[] texte) {
        Log.resetProgress();
        String z = ". ";
        if (texte.length <= 1) {
            logList.add(".  " + texte[0]);
        } else {
            String zeile = "---------------------------------------";
            logList.add(". " + zeile);
            for (String aTexte : texte) {
                String txt = "| " + aTexte;
                logList.add(". " + txt);
            }
            logList.add(". " + zeile);
        }
        Log.printLog();
    }

    private static void printLog() {
        logList.forEach(System.out::println);
        logList.clear();
    }
}

