/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.awt.Desktop;
import java.awt.Frame;
import java.io.File;
import mediathek.config.Daten;
import mediathek.config.MVConfig;
import mediathek.gui.dialog.DialogProgrammOrdnerOeffnen;
import mediathek.gui.messages.ProgramLocationChangedEvent;
import mediathek.tool.MVMessageDialog;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OpenPlayerAction {
    private static final Logger logger = LogManager.getLogger(OpenPlayerAction.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void filmAbspielen(Frame parent, String datei) {
        boolean gut = false;
        if (datei.isEmpty()) {
            return;
        }
        File sFile = new File(datei);
        if (!sFile.exists()) {
            MVMessageDialog.showMessageDialog(parent, "Film existiert noch nicht!", "Fehler", 0);
            return;
        }
        try {
            Desktop d;
            if (!MVConfig.get(MVConfig.Configs.SYSTEM_PLAYER_ABSPIELEN).isEmpty()) {
                String programm = MVConfig.get(MVConfig.Configs.SYSTEM_PLAYER_ABSPIELEN);
                String[] cmd = new String[]{programm, sFile.getAbsolutePath()};
                Runtime.getRuntime().exec(cmd);
                gut = true;
            } else if (Desktop.isDesktopSupported() && (d = Desktop.getDesktop()).isSupported(Desktop.Action.OPEN)) {
                d.open(sFile);
                gut = true;
            }
        }
        catch (Exception ex) {
            try {
                gut = false;
                String programm = "";
                String text = "\n Ein Videoplayer zum Abspielen wird nicht gefunden.\n Videoplayer selbst ausw\u00e4hlen.";
                DialogProgrammOrdnerOeffnen dialog = new DialogProgrammOrdnerOeffnen(parent, true, "", "Videoplayer suchen", text);
                dialog.setVisible(true);
                if (dialog.ok) {
                    programm = dialog.ziel;
                }
                String[] cmd = new String[]{programm, sFile.getAbsolutePath()};
                Runtime.getRuntime().exec(cmd);
                MVConfig.add(MVConfig.Configs.SYSTEM_PLAYER_ABSPIELEN, programm);
                Daten.getInstance().getMessageBus().publishAsync(new ProgramLocationChangedEvent());
                gut = true;
            }
            catch (Exception eex) {
                logger.error("Ordner \u00f6ffnen: {}", (Object)datei, (Object)ex);
            }
        }
        finally {
            if (!gut) {
                MVConfig.add(MVConfig.Configs.SYSTEM_PLAYER_ABSPIELEN, "");
                Daten.getInstance().getMessageBus().publishAsync(new ProgramLocationChangedEvent());
                MVMessageDialog.showMessageDialog(parent, "Kann den Videoplayer nicht \u00f6ffnen!", "Fehler", 0);
            }
        }
    }
}

