/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control;

import impl.org.controlsfx.collections.MappingChange;
import impl.org.controlsfx.collections.NonIterableChange;
import impl.org.controlsfx.collections.ReadOnlyUnbackedObservableList;
import java.util.BitSet;
import java.util.Map;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.ObservableList;
import org.controlsfx.control.IndexedCheckModel;

abstract class CheckBitSetModelBase<T>
implements IndexedCheckModel<T> {
    private final Map<T, BooleanProperty> itemBooleanMap;
    private final BitSet checkedIndices;
    private final ReadOnlyUnbackedObservableList<Integer> checkedIndicesList;
    private final ReadOnlyUnbackedObservableList<T> checkedItemsList;

    CheckBitSetModelBase(Map<T, BooleanProperty> itemBooleanMap) {
        this.itemBooleanMap = itemBooleanMap;
        this.checkedIndices = new BitSet();
        this.checkedIndicesList = new ReadOnlyUnbackedObservableList<Integer>(){

            @Override
            public Integer get(int index) {
                if (index < 0 || index >= CheckBitSetModelBase.this.getItemCount()) {
                    return -1;
                }
                int val = CheckBitSetModelBase.this.checkedIndices.nextSetBit(0);
                for (int pos = 0; val >= 0 || pos == index; ++pos) {
                    if (pos == index) {
                        return val;
                    }
                    val = CheckBitSetModelBase.this.checkedIndices.nextSetBit(val + 1);
                }
                return -1;
            }

            @Override
            public int size() {
                return CheckBitSetModelBase.this.checkedIndices.cardinality();
            }

            @Override
            public boolean contains(Object o) {
                if (o instanceof Number) {
                    Number n = (Number)o;
                    int index = n.intValue();
                    return index >= 0 && index < CheckBitSetModelBase.this.checkedIndices.length() && CheckBitSetModelBase.this.checkedIndices.get(index);
                }
                return false;
            }
        };
        this.checkedItemsList = new ReadOnlyUnbackedObservableList<T>(){

            @Override
            public T get(int i) {
                int pos = (Integer)CheckBitSetModelBase.this.checkedIndicesList.get(i);
                if (pos < 0 || pos >= CheckBitSetModelBase.this.getItemCount()) {
                    return null;
                }
                return CheckBitSetModelBase.this.getItem(pos);
            }

            @Override
            public int size() {
                return CheckBitSetModelBase.this.checkedIndices.cardinality();
            }
        };
        MappingChange.Map<Integer, Object> map = f -> this.getItem((int)f);
        this.checkedIndicesList.addListener(c -> {
            boolean hasRealChangeOccurred = false;
            while (c.next() && !hasRealChangeOccurred) {
                hasRealChangeOccurred = c.wasAdded() || c.wasRemoved();
            }
            if (hasRealChangeOccurred) {
                c.reset();
                this.checkedItemsList.callObservers(new MappingChange(c, map, this.checkedItemsList));
            }
            c.reset();
        });
        this.getCheckedItems().addListener(c -> {
            while (c.next()) {
                BooleanProperty p;
                if (c.wasAdded()) {
                    for (Object item : c.getAddedSubList()) {
                        p = this.getItemBooleanProperty(item);
                        if (p == null) continue;
                        p.set(true);
                    }
                }
                if (!c.wasRemoved()) continue;
                for (Object item : c.getRemoved()) {
                    p = this.getItemBooleanProperty(item);
                    if (p == null) continue;
                    p.set(false);
                }
            }
        });
    }

    @Override
    public abstract T getItem(int var1);

    @Override
    public abstract int getItemCount();

    @Override
    public abstract int getItemIndex(T var1);

    BooleanProperty getItemBooleanProperty(T item) {
        return this.itemBooleanMap.get(item);
    }

    @Override
    public ObservableList<Integer> getCheckedIndices() {
        return this.checkedIndicesList;
    }

    @Override
    public ObservableList<T> getCheckedItems() {
        return this.checkedItemsList;
    }

    @Override
    public void checkAll() {
        for (int i = 0; i < this.getItemCount(); ++i) {
            this.check(i);
        }
    }

    @Override
    public void checkIndices(int ... indices) {
        for (int i = 0; i < indices.length; ++i) {
            this.check(indices[i]);
        }
    }

    @Override
    public void clearCheck(T item) {
        int index = this.getItemIndex(item);
        this.clearCheck(index);
    }

    @Override
    public void clearChecks() {
        for (int index = 0; index < this.checkedIndices.length(); ++index) {
            this.clearCheck(index);
        }
    }

    @Override
    public void clearCheck(int index) {
        if (index < 0 || index >= this.getItemCount()) {
            return;
        }
        this.checkedIndices.clear(index);
        int changeIndex = this.checkedIndicesList.indexOf(index);
        this.checkedIndicesList.callObservers(new NonIterableChange.SimpleRemovedChange<Integer>(changeIndex, changeIndex, index, this.checkedIndicesList));
    }

    @Override
    public boolean isEmpty() {
        return this.checkedIndices.isEmpty();
    }

    @Override
    public boolean isChecked(T item) {
        int index = this.getItemIndex(item);
        return this.isChecked(index);
    }

    @Override
    public boolean isChecked(int index) {
        return this.checkedIndices.get(index);
    }

    @Override
    public void toggleCheckState(T item) {
        int index = this.getItemIndex(item);
        this.toggleCheckState(index);
    }

    @Override
    public void toggleCheckState(int index) {
        if (this.isChecked(index)) {
            this.clearCheck(index);
        } else {
            this.check(index);
        }
    }

    @Override
    public void check(int index) {
        if (index < 0 || index >= this.getItemCount()) {
            return;
        }
        this.checkedIndices.set(index);
        int changeIndex = this.checkedIndicesList.indexOf(index);
        this.checkedIndicesList.callObservers(new NonIterableChange.SimpleAddChange<Integer>(changeIndex, changeIndex + 1, this.checkedIndicesList));
    }

    @Override
    public void check(T item) {
        int index = this.getItemIndex(item);
        this.check(index);
    }

    protected void updateMap() {
        this.itemBooleanMap.clear();
        int i = 0;
        while (i < this.getItemCount()) {
            final int index = i++;
            T item = this.getItem(index);
            final SimpleBooleanProperty booleanProperty = new SimpleBooleanProperty(item, "selected", false);
            this.itemBooleanMap.put(item, booleanProperty);
            booleanProperty.addListener(new InvalidationListener(){

                @Override
                public void invalidated(Observable o) {
                    if (booleanProperty.get()) {
                        CheckBitSetModelBase.this.checkedIndices.set(index);
                        int changeIndex = CheckBitSetModelBase.this.checkedIndicesList.indexOf(index);
                        CheckBitSetModelBase.this.checkedIndicesList.callObservers(new NonIterableChange.SimpleAddChange(changeIndex, changeIndex + 1, CheckBitSetModelBase.this.checkedIndicesList));
                    } else {
                        int changeIndex = CheckBitSetModelBase.this.checkedIndicesList.indexOf(index);
                        CheckBitSetModelBase.this.checkedIndices.clear(index);
                        CheckBitSetModelBase.this.checkedIndicesList.callObservers(new NonIterableChange.SimpleRemovedChange<Integer>(changeIndex, changeIndex, index, CheckBitSetModelBase.this.checkedIndicesList));
                    }
                }
            });
        }
    }
}

