/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control;

import impl.org.controlsfx.skin.ToggleSwitchSkin;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.css.PseudoClass;
import javafx.event.ActionEvent;
import javafx.scene.control.Labeled;
import javafx.scene.control.Skin;

public class ToggleSwitch
extends Labeled {
    private BooleanProperty selected;
    private static final String DEFAULT_STYLE_CLASS = "toggle-switch";
    private static final PseudoClass PSEUDO_CLASS_SELECTED = PseudoClass.getPseudoClass("selected");

    public ToggleSwitch() {
        this.initialize();
    }

    public ToggleSwitch(String text) {
        super(text);
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().setAll((String[])new String[]{DEFAULT_STYLE_CLASS});
    }

    public final void setSelected(boolean value) {
        this.selectedProperty().set(value);
    }

    public final boolean isSelected() {
        return this.selected == null ? false : this.selected.get();
    }

    public final BooleanProperty selectedProperty() {
        if (this.selected == null) {
            this.selected = new BooleanPropertyBase(){

                @Override
                protected void invalidated() {
                    Boolean v = this.get();
                    ToggleSwitch.this.pseudoClassStateChanged(PSEUDO_CLASS_SELECTED, v);
                }

                @Override
                public Object getBean() {
                    return ToggleSwitch.this;
                }

                @Override
                public String getName() {
                    return "selected";
                }
            };
        }
        return this.selected;
    }

    public void fire() {
        if (!this.isDisabled()) {
            this.setSelected(!this.isSelected());
            this.fireEvent(new ActionEvent());
        }
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new ToggleSwitchSkin(this);
    }

    @Override
    public String getUserAgentStylesheet() {
        return ToggleSwitch.class.getResource("toggleswitch.css").toExternalForm();
    }
}

