/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Guillemet;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.cucadiagram.BodyFactory;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.EntityPortion;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.SkinParameter;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.Bibliotekon;
import net.sourceforge.plantuml.svek.Margins;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.SvekNode;
import net.sourceforge.plantuml.ugraphic.Shadowable;
import net.sourceforge.plantuml.ugraphic.UComment;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGraphicStencil;
import net.sourceforge.plantuml.ugraphic.UGroupType;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.utils.MathUtils;

public class EntityImageDescription
extends AbstractEntityImage {
    private final ShapeType shapeType;
    private final Url url;
    private final TextBlock asSmall;
    private final TextBlock name;
    private final TextBlock desc;
    private TextBlock stereo;
    private final boolean hideText;
    private final Collection<Link> links;
    private final boolean useRankSame = this.getSkinParam().useRankSame();
    private final boolean fixCircleLabelOverlapping;
    private final Bibliotekon bibliotekon;
    private final SymbolContext ctx;

    public EntityImageDescription(ILeaf entity, ISkinParam skinParam2, PortionShower portionShower, Collection<Link> links, SName styleName, Bibliotekon bibliotekon) {
        super(entity, entity.getColors(skinParam2).mute(skinParam2));
        HorizontalAlignment defaultAlign;
        FontConfiguration fcStereo;
        FontConfiguration fcTitle;
        UStroke stroke;
        double deltaShadow;
        double diagonalCorner;
        double roundCorner;
        HColor forecolor;
        this.bibliotekon = bibliotekon;
        this.fixCircleLabelOverlapping = this.getSkinParam().fixCircleLabelOverlapping();
        this.links = links;
        Stereotype stereotype = entity.getStereotype();
        USymbol symbol = this.getUSymbol(entity);
        this.shapeType = symbol == USymbol.FOLDER ? ShapeType.FOLDER : (symbol == USymbol.HEXAGON ? ShapeType.HEXAGON : (symbol == USymbol.INTERFACE ? (this.getSkinParam().fixCircleLabelOverlapping() ? ShapeType.RECTANGLE_WITH_CIRCLE_INSIDE : ShapeType.RECTANGLE) : ShapeType.RECTANGLE));
        this.hideText = symbol == USymbol.INTERFACE;
        this.url = entity.getUrl99();
        Colors colors = entity.getColors(this.getSkinParam());
        HColor backcolor = colors.getColor(ColorType.BACK);
        Style style = null;
        if (UseStyle.useBetaStyle()) {
            StyleSignature tmp = StyleSignature.of(SName.root, SName.element, styleName, symbol.getSkinParameter().getStyleName());
            style = tmp.with(stereotype).getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
            style = style.eventuallyOverride(colors);
            Style styleStereo = tmp.withStereotype(stereotype).getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
            forecolor = style.value(PName.LineColor).asColor(this.getSkinParam().getThemeStyle(), this.getSkinParam().getIHtmlColorSet());
            if (backcolor == null) {
                backcolor = style.value(PName.BackGroundColor).asColor(this.getSkinParam().getThemeStyle(), this.getSkinParam().getIHtmlColorSet());
            }
            roundCorner = style.value(PName.RoundCorner).asDouble();
            diagonalCorner = style.value(PName.DiagonalCorner).asDouble();
            deltaShadow = style.value(PName.Shadowing).asDouble();
            stroke = style.getStroke(colors);
            fcTitle = style.getFontConfiguration(this.getSkinParam().getThemeStyle(), this.getSkinParam().getIHtmlColorSet());
            fcStereo = styleStereo.getFontConfiguration(this.getSkinParam().getThemeStyle(), this.getSkinParam().getIHtmlColorSet());
            defaultAlign = style.getHorizontalAlignment();
        } else {
            forecolor = SkinParamUtils.getColor(this.getSkinParam(), stereotype, symbol.getColorParamBorder());
            if (backcolor == null) {
                backcolor = SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), symbol.getColorParamBack());
            }
            roundCorner = symbol.getSkinParameter().getRoundCorner(this.getSkinParam(), stereotype);
            diagonalCorner = symbol.getSkinParameter().getDiagonalCorner(this.getSkinParam(), stereotype);
            deltaShadow = this.getSkinParam().shadowing2(this.getEntity().getStereotype(), symbol.getSkinParameter()) ? 3.0 : 0.0;
            stroke = colors.muteStroke(symbol.getSkinParameter().getStroke(this.getSkinParam(), stereotype));
            fcTitle = new FontConfiguration(this.getSkinParam(), symbol.getFontParam(), stereotype);
            fcStereo = new FontConfiguration(this.getSkinParam(), symbol.getFontParamStereotype(), stereotype);
            defaultAlign = HorizontalAlignment.LEFT;
        }
        assert (this.getStereo() == stereotype);
        this.ctx = new SymbolContext(backcolor, forecolor).withStroke(stroke).withShadow(deltaShadow).withCorner(roundCorner, diagonalCorner);
        Display codeDisplay = Display.getWithNewlines(entity.getCodeGetName());
        if (entity.getDisplay().equals(codeDisplay) && symbol.getSkinParameter() == SkinParameter.PACKAGE || entity.getDisplay().isWhite()) {
            this.desc = TextBlockUtils.empty(this.getSkinParam().minClassWidth(), 0.0);
        } else {
            HorizontalAlignment align = this.getSkinParam().getDefaultTextAlignment(defaultAlign);
            this.desc = BodyFactory.create3(entity.getDisplay(), symbol.getFontParam(), this.getSkinParam(), align, fcTitle, this.getSkinParam().wrapWidth());
        }
        this.stereo = TextBlockUtils.empty(0.0, 0.0);
        if (stereotype != null && stereotype.getSprite(this.getSkinParam()) != null) {
            this.stereo = stereotype.getSprite(this.getSkinParam());
        } else if (stereotype != null && stereotype.getLabel(Guillemet.DOUBLE_COMPARATOR) != null && portionShower.showPortion(EntityPortion.STEREOTYPE, entity)) {
            this.stereo = Display.getWithNewlines(stereotype.getLabel(this.getSkinParam().guillemet())).create(fcStereo, HorizontalAlignment.CENTER, this.getSkinParam());
        }
        this.name = BodyFactory.create2(this.getSkinParam().getDefaultTextAlignment(HorizontalAlignment.CENTER), codeDisplay, symbol.getFontParam(), this.getSkinParam(), stereotype, entity, style);
        this.asSmall = this.hideText ? symbol.asSmall(TextBlockUtils.empty(0.0, 0.0), TextBlockUtils.empty(0.0, 0.0), TextBlockUtils.empty(0.0, 0.0), this.ctx, this.getSkinParam().getStereotypeAlignment()) : symbol.asSmall(this.name, this.desc, this.stereo, this.ctx, this.getSkinParam().getStereotypeAlignment());
    }

    private USymbol getUSymbol(ILeaf entity) {
        USymbol result = entity.getUSymbol() == null ? this.getSkinParam().componentStyle().toUSymbol() : entity.getUSymbol();
        return Objects.requireNonNull(result);
    }

    public Dimension2D getNameDimension(StringBounder stringBounder) {
        if (this.hideText) {
            return new Dimension2DDouble(0.0, 0.0);
        }
        return this.name.calculateDimension(stringBounder);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return this.asSmall.calculateDimension(stringBounder);
    }

    @Override
    public Margins getShield(StringBounder stringBounder) {
        if (!this.hideText) {
            return Margins.NONE;
        }
        if (this.isThereADoubleLink((ILeaf)this.getEntity(), this.links)) {
            return Margins.NONE;
        }
        if (!this.fixCircleLabelOverlapping && this.hasSomeHorizontalLinkVisible((ILeaf)this.getEntity(), this.links)) {
            return Margins.NONE;
        }
        if (this.hasSomeHorizontalLinkDoubleDecorated((ILeaf)this.getEntity(), this.links)) {
            return Margins.NONE;
        }
        Dimension2D dimStereo = this.stereo.calculateDimension(stringBounder);
        Dimension2D dimDesc = this.desc.calculateDimension(stringBounder);
        Dimension2D dimSmall = this.asSmall.calculateDimension(stringBounder);
        double x = Math.max(dimStereo.getWidth(), dimDesc.getWidth());
        double suppX = x - dimSmall.getWidth();
        if (suppX < 1.0) {
            suppX = 1.0;
        }
        double y = MathUtils.max(1.0, dimDesc.getHeight(), dimStereo.getHeight());
        return new Margins(suppX / 2.0, suppX / 2.0, y, y);
    }

    private boolean hasSomeHorizontalLinkVisible(ILeaf leaf, Collection<Link> links) {
        for (Link link : links) {
            if (link.getLength() != 1 || !link.contains(leaf) || link.isInvis()) continue;
            return true;
        }
        return false;
    }

    private boolean isThereADoubleLink(ILeaf leaf, Collection<Link> links) {
        HashSet<IEntity> others = new HashSet<IEntity>();
        for (Link link : links) {
            IEntity other;
            boolean changed;
            if (!link.contains(leaf) || (changed = others.add(other = link.getOther(leaf)))) continue;
            return true;
        }
        return false;
    }

    private boolean hasSomeHorizontalLinkDoubleDecorated(ILeaf leaf, Collection<Link> links) {
        for (Link link : links) {
            if (link.getLength() != 1 || !link.contains(leaf) || !link.getType().isDoubleDecorated()) continue;
            return true;
        }
        return false;
    }

    @Override
    public final void drawU(UGraphic ug) {
        ug.draw(new UComment("entity " + this.getEntity().getCodeGetName()));
        ug.startGroup(UGroupType.CLASS, "elem " + this.getEntity().getCode() + " selected");
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        if (this.shapeType == ShapeType.HEXAGON) {
            this.drawHexagon(this.ctx.apply(ug));
        }
        this.asSmall.drawU(ug);
        if (this.hideText) {
            double space = 8.0;
            Dimension2D dimSmall = this.asSmall.calculateDimension(ug.getStringBounder());
            Dimension2D dimDesc = this.desc.calculateDimension(ug.getStringBounder());
            double posx1 = (dimSmall.getWidth() - dimDesc.getWidth()) / 2.0;
            UGraphic ugDesc = ug.apply(new UTranslate(posx1, 8.0 + dimSmall.getHeight()));
            ugDesc = UGraphicStencil.create(ugDesc, dimDesc);
            this.desc.drawU(ugDesc);
            Dimension2D dimStereo = this.stereo.calculateDimension(ug.getStringBounder());
            double posx2 = (dimSmall.getWidth() - dimStereo.getWidth()) / 2.0;
            this.stereo.drawU(ug.apply(new UTranslate(posx2, -8.0 - dimStereo.getHeight())));
        }
        if (this.url != null) {
            ug.closeUrl();
        }
        ug.closeGroup();
    }

    private void drawHexagon(UGraphic ug) {
        if (this.bibliotekon == null) {
            throw new IllegalStateException();
        }
        SvekNode node = this.bibliotekon.getNode(this.getEntity());
        Shadowable hexagon = node.getPolygon();
        hexagon.setDeltaShadow(this.ctx.getDeltaShadow());
        ug.draw(hexagon);
    }

    @Override
    public ShapeType getShapeType() {
        return this.shapeType;
    }

    @Override
    public double getOverscanX(StringBounder stringBounder) {
        if (this.hideText) {
            Dimension2D dimSmall = this.asSmall.calculateDimension(stringBounder);
            Dimension2D dimDesc = this.desc.calculateDimension(stringBounder);
            Dimension2D dimStereo = this.stereo.calculateDimension(stringBounder);
            double posx1 = (dimSmall.getWidth() - dimDesc.getWidth()) / 2.0;
            double posx2 = (dimSmall.getWidth() - dimStereo.getWidth()) / 2.0;
            return MathUtils.max(-posx1, -posx2, 0.0);
        }
        return 0.0;
    }
}

