# -*- coding: utf-8 -*-

"""Data literal storing emoji Portuguese names and Unicode codes."""

__all__ = ['EMOJI_UNICODE_PORTUGUESE', 'UNICODE_EMOJI_PORTUGUESE',]


EMOJI_UNICODE_PORTUGUESE = {
    u':rosto_risonho:': u'\U0001F600',
    u':rosto_risonho_com_olhos_bem_abertos:': u'\U0001F603',
    u':rosto_risonho_com_olhos_sorridentes:': u'\U0001F604',
    u':rosto_contente_com_olhos_sorridentes:': u'\U0001F601',
    u':rosto_risonho_com_olhos_semicerrados:': u'\U0001F606',
    u':rosto_risonho_com_gota_de_suor:': u'\U0001F605',
    u':rolando_no_chão_de_rir:': u'\U0001F923',
    u':rosto_chorando_de_rir:': u'\U0001F602',
    u':rosto_levemente_sorridente:': u'\U0001F642',
    u':rosto_de_cabeça_para_baixo:': u'\U0001F643',
    u':rosto_com_olho_piscando:': u'\U0001F609',
    u':rosto_sorridente_com_olhos_sorridentes:': u'\U0001F60A',
    u':rosto_sorridente_com_auréola:': u'\U0001F607',
    u':rosto_sorridente_com_3_corações:': u'\U0001F970',
    u':rosto_sorridente_com_olhos_de_coração:': u'\U0001F60D',
    u':rosto_com_olhar_maravilhado:': u'\U0001F929',
    u':rosto_mandando_um_beijo:': u'\U0001F618',
    u':rosto_beijando:': u'\U0001F617',
    u':rosto_sorridente:': u'\U0000263A\U0000FE0F',
    u':rosto_beijando_com_olhos_fechados:': u'\U0001F61A',
    u':rosto_beijando_com_olhos_sorridentes:': u'\U0001F619',
    u':rosto_sorridente_com_lágrima:': u'\U0001F972',
    u':rosto_saboreando_comida:': u'\U0001F60B',
    u':rosto_mostrando_a_língua:': u'\U0001F61B',
    u':rosto_piscando_e_com_língua_para_fora:': u'\U0001F61C',
    u':rosto_bizarro:': u'\U0001F92A',
    u':rosto_com_olhos_semicerrados_e_língua_para_fora:': u'\U0001F61D',
    u':rosto_com_cifrões:': u'\U0001F911',
    u':rosto_abraçando:': u'\U0001F917',
    u':rosto_com_a_mão_sobre_a_boca:': u'\U0001F92D',
    u':rosto_fazendo_sinal_de_silêncio:': u'\U0001F92B',
    u':rosto_pensativo:': u'\U0001F914',
    u':rosto_com_boca_de_zíper:': u'\U0001F910',
    u':rosto_com_sobrancelha_levantada:': u'\U0001F928',
    u':rosto_neutro:': u'\U0001F610',
    u':rosto_inexpressivo:': u'\U0001F611',
    u':rosto_sem_boca:': u'\U0001F636',
    u':rosto_com_sorriso_maroto:': u'\U0001F60F',
    u':rosto_aborrecido:': u'\U0001F612',
    u':rosto_com_olhos_revirados:': u'\U0001F644',
    u':rosto_expressando_desagrado:': u'\U0001F62C',
    u':rosto_de_mentiroso:': u'\U0001F925',
    u':rosto_aliviado:': u'\U0001F60C',
    u':rosto_deprimido:': u'\U0001F614',
    u':rosto_sonolento:': u'\U0001F62A',
    u':rosto_babando:': u'\U0001F924',
    u':rosto_dormindo:': u'\U0001F634',
    u':rosto_com_máscara_médica:': u'\U0001F637',
    u':rosto_com_termômetro:': u'\U0001F912',
    u':rosto_com_atadura_na_cabeça:': u'\U0001F915',
    u':rosto_nauseado:': u'\U0001F922',
    u':rosto_vomitando:': u'\U0001F92E',
    u':rosto_espirrando:': u'\U0001F927',
    u':rosto_fervendo_de_calor:': u'\U0001F975',
    u':rosto_gelado:': u'\U0001F976',
    u':rosto_embriagado:': u'\U0001F974',
    u':rosto_atordoado:': u'\U0001F635',
    u':cabeça_explodindo:': u'\U0001F92F',
    u':rosto_com_chapéu_de_caubói:': u'\U0001F920',
    u':rosto_festivo:': u'\U0001F973',
    u':rosto_disfarçado:': u'\U0001F978',
    u':rosto_sorridente_com_óculos_escuros:': u'\U0001F60E',
    u':rosto_de_nerd:': u'\U0001F913',
    u':rosto_com_monóculo:': u'\U0001F9D0',
    u':rosto_confuso:': u'\U0001F615',
    u':rosto_preocupado:': u'\U0001F61F',
    u':rosto_meio_triste:': u'\U0001F641',
    u':rosto_descontente:': u'\U00002639\U0000FE0F',
    u':rosto_com_boca_aberta:': u'\U0001F62E',
    u':rosto_surpreso:': u'\U0001F62F',
    u':rosto_espantado:': u'\U0001F632',
    u':rosto_ruborizado:': u'\U0001F633',
    u':rosto_implorando:': u'\U0001F97A',
    u':rosto_franzido_com_boca_aberta:': u'\U0001F626',
    u':rosto_angustiado:': u'\U0001F627',
    u':rosto_amedrontado:': u'\U0001F628',
    u':rosto_ansioso_com_gota_de_suor:': u'\U0001F630',
    u':rosto_triste_mas_aliviado:': u'\U0001F625',
    u':rosto_chorando:': u'\U0001F622',
    u':rosto_chorando_aos_berros:': u'\U0001F62D',
    u':rosto_gritando_de_medo:': u'\U0001F631',
    u':rosto_perplexo:': u'\U0001F616',
    u':rosto_perseverante:': u'\U0001F623',
    u':rosto_desapontado:': u'\U0001F61E',
    u':rosto_cabisbaixo_com_gota_de_suor:': u'\U0001F613',
    u':rosto_desolado:': u'\U0001F629',
    u':rosto_cansado:': u'\U0001F62B',
    u':rosto_bocejando:': u'\U0001F971',
    u':rosto_soltando_vapor_pelo_nariz:': u'\U0001F624',
    u':rosto_furioso:': u'\U0001F621',
    u':rosto_zangado:': u'\U0001F620',
    u':rosto_com_símbolos_na_boca:': u'\U0001F92C',
    u':rosto_sorridente_com_chifres:': u'\U0001F608',
    u':rosto_zangado_com_chifres:': u'\U0001F47F',
    u':caveira:': u'\U0001F480',
    u':caveira_e_ossos_cruzados:': u'\U00002620\U0000FE0F',
    u':cocô:': u'\U0001F4A9',
    u':rosto_de_palhaço:': u'\U0001F921',
    u':ogro:': u'\U0001F479',
    u':duende_japonês:': u'\U0001F47A',
    u':fantasma:': u'\U0001F47B',
    u':alienígena:': u'\U0001F47D',
    u':monstro_alienígena:': u'\U0001F47E',
    u':rosto_de_robô:': u'\U0001F916',
    u':rosto_de_gato_sorrindo:': u'\U0001F63A',
    u':rosto_de_gato_sorrindo_com_olhos_sorridentes:': u'\U0001F638',
    u':rosto_de_gato_com_lágrimas_de_alegria:': u'\U0001F639',
    u':rosto_de_gato_sorridente_com_olhos_de_coração:': u'\U0001F63B',
    u':rosto_de_gato_com_sorriso_irônico:': u'\U0001F63C',
    u':rosto_de_gato_mandando_um_beijo:': u'\U0001F63D',
    u':rosto_de_gato_desolado:': u'\U0001F640',
    u':rosto_de_gato_chorando:': u'\U0001F63F',
    u':rosto_de_gato_mal-humorado:': u'\U0001F63E',
    u':macaco_que_não_vê_nada:': u'\U0001F648',
    u':macaco_que_não_ouve_nada:': u'\U0001F649',
    u':macaco_que_não_fala_nada:': u'\U0001F64A',
    u':marca_de_beijo:': u'\U0001F48B',
    u':carta_de_amor:': u'\U0001F48C',
    u':coração_com_flecha:': u'\U0001F498',
    u':coração_com_fita:': u'\U0001F49D',
    u':coração_brilhante:': u'\U0001F496',
    u':coração_crescendo:': u'\U0001F497',
    u':coração_pulsante:': u'\U0001F493',
    u':corações_girando:': u'\U0001F49E',
    u':dois_corações:': u'\U0001F495',
    u':coração_decorativo:': u'\U0001F49F',
    u':exclamação_de_coração:': u'\U00002763\U0000FE0F',
    u':coração_partido:': u'\U0001F494',
    u':coração_vermelho:': u'\U00002764\U0000FE0F',
    u':coração_laranja:': u'\U0001F9E1',
    u':coração_amarelo:': u'\U0001F49B',
    u':coração_verde:': u'\U0001F49A',
    u':coração_azul:': u'\U0001F499',
    u':coração_roxo:': u'\U0001F49C',
    u':coração_marrom:': u'\U0001F90E',
    u':coração_preto:': u'\U0001F5A4',
    u':coração_branco:': u'\U0001F90D',
    u':cem_pontos:': u'\U0001F4AF',
    u':símbolo_de_raiva:': u'\U0001F4A2',
    u':colisão:': u'\U0001F4A5',
    u':zonzo:': u'\U0001F4AB',
    u':pingos_de_suor:': u'\U0001F4A6',
    u':rapidez:': u'\U0001F4A8',
    u':buraco:': u'\U0001F573\U0000FE0F',
    u':bomba:': u'\U0001F4A3',
    u':balão_de_diálogo:': u'\U0001F4AC',
    u':olho_no_balão_de_diálogo:': u'\U0001F441\U0000FE0F\U0000200D\U0001F5E8\U0000FE0F',
    u':balão_de_diálogo_à_esquerda:': u'\U0001F5E8\U0000FE0F',
    u':balão_de_raiva_à_direita:': u'\U0001F5EF\U0000FE0F',
    u':balão_de_pensamento:': u'\U0001F4AD',
    u':zzz:': u'\U0001F4A4',
    u':mão_acenando:': u'\U0001F44B',
    u':mão_acenando_pele_clara:': u'\U0001F44B\U0001F3FB',
    u':mão_acenando_pele_morena_clara:': u'\U0001F44B\U0001F3FC',
    u':mão_acenando_pele_morena:': u'\U0001F44B\U0001F3FD',
    u':mão_acenando_pele_morena_escura:': u'\U0001F44B\U0001F3FE',
    u':mão_acenando_pele_escura:': u'\U0001F44B\U0001F3FF',
    u':dorso_da_mão_levantado:': u'\U0001F91A',
    u':dorso_da_mão_levantado_pele_clara:': u'\U0001F91A\U0001F3FB',
    u':dorso_da_mão_levantado_pele_morena_clara:': u'\U0001F91A\U0001F3FC',
    u':dorso_da_mão_levantado_pele_morena:': u'\U0001F91A\U0001F3FD',
    u':dorso_da_mão_levantado_pele_morena_escura:': u'\U0001F91A\U0001F3FE',
    u':dorso_da_mão_levantado_pele_escura:': u'\U0001F91A\U0001F3FF',
    u':mão_aberta_com_os_dedos_separados:': u'\U0001F590\U0000FE0F',
    u':mão_aberta_com_os_dedos_separados_pele_clara:': u'\U0001F590\U0001F3FB',
    u':mão_aberta_com_os_dedos_separados_pele_morena_clara:': u'\U0001F590\U0001F3FC',
    u':mão_aberta_com_os_dedos_separados_pele_morena:': u'\U0001F590\U0001F3FD',
    u':mão_aberta_com_os_dedos_separados_pele_morena_escura:': u'\U0001F590\U0001F3FE',
    u':mão_aberta_com_os_dedos_separados_pele_escura:': u'\U0001F590\U0001F3FF',
    u':mão_levantada:': u'\U0000270B',
    u':mão_levantada_pele_clara:': u'\U0000270B\U0001F3FB',
    u':mão_levantada_pele_morena_clara:': u'\U0000270B\U0001F3FC',
    u':mão_levantada_pele_morena:': u'\U0000270B\U0001F3FD',
    u':mão_levantada_pele_morena_escura:': u'\U0000270B\U0001F3FE',
    u':mão_levantada_pele_escura:': u'\U0000270B\U0001F3FF',
    u':saudação_vulcana:': u'\U0001F596',
    u':saudação_vulcana_pele_clara:': u'\U0001F596\U0001F3FB',
    u':saudação_vulcana_pele_morena_clara:': u'\U0001F596\U0001F3FC',
    u':saudação_vulcana_pele_morena:': u'\U0001F596\U0001F3FD',
    u':saudação_vulcana_pele_morena_escura:': u'\U0001F596\U0001F3FE',
    u':saudação_vulcana_pele_escura:': u'\U0001F596\U0001F3FF',
    u':sinal_de_ok:': u'\U0001F44C',
    u':sinal_de_ok_pele_clara:': u'\U0001F44C\U0001F3FB',
    u':sinal_de_ok_pele_morena_clara:': u'\U0001F44C\U0001F3FC',
    u':sinal_de_ok_pele_morena:': u'\U0001F44C\U0001F3FD',
    u':sinal_de_ok_pele_morena_escura:': u'\U0001F44C\U0001F3FE',
    u':sinal_de_ok_pele_escura:': u'\U0001F44C\U0001F3FF',
    u':dedos_comprimidos:': u'\U0001F90C',
    u':dedos_comprimidos_pele_clara:': u'\U0001F90C\U0001F3FB',
    u':dedos_comprimidos_pele_morena_clara:': u'\U0001F90C\U0001F3FC',
    u':dedos_comprimidos_pele_morena:': u'\U0001F90C\U0001F3FD',
    u':dedos_comprimidos_pele_morena_escura:': u'\U0001F90C\U0001F3FE',
    u':dedos_comprimidos_pele_escura:': u'\U0001F90C\U0001F3FF',
    u':mão_beliscando:': u'\U0001F90F',
    u':mão_beliscando_pele_clara:': u'\U0001F90F\U0001F3FB',
    u':mão_beliscando_pele_morena_clara:': u'\U0001F90F\U0001F3FC',
    u':mão_beliscando_pele_morena:': u'\U0001F90F\U0001F3FD',
    u':mão_beliscando_pele_morena_escura:': u'\U0001F90F\U0001F3FE',
    u':mão_beliscando_pele_escura:': u'\U0001F90F\U0001F3FF',
    u':mão_em_v_de_vitória:': u'\U0000270C',
    u':mão_em_v_de_vitória_selector:': u'\U0000270C\U0000FE0F',
    u':mão_em_v_de_vitória_pele_clara:': u'\U0000270C\U0001F3FB',
    u':mão_em_v_de_vitória_pele_morena_clara:': u'\U0000270C\U0001F3FC',
    u':mão_em_v_de_vitória_pele_morena:': u'\U0000270C\U0001F3FD',
    u':mão_em_v_de_vitória_pele_morena_escura:': u'\U0000270C\U0001F3FE',
    u':mão_em_v_de_vitória_pele_escura:': u'\U0000270C\U0001F3FF',
    u':dedos_cruzados:': u'\U0001F91E',
    u':dedos_cruzados_pele_clara:': u'\U0001F91E\U0001F3FB',
    u':dedos_cruzados_pele_morena_clara:': u'\U0001F91E\U0001F3FC',
    u':dedos_cruzados_pele_morena:': u'\U0001F91E\U0001F3FD',
    u':dedos_cruzados_pele_morena_escura:': u'\U0001F91E\U0001F3FE',
    u':dedos_cruzados_pele_escura:': u'\U0001F91E\U0001F3FF',
    u':gesto_de_te_amo:': u'\U0001F91F',
    u':gesto_de_te_amo_pele_clara:': u'\U0001F91F\U0001F3FB',
    u':gesto_de_te_amo_pele_morena_clara:': u'\U0001F91F\U0001F3FC',
    u':gesto_de_te_amo_pele_morena:': u'\U0001F91F\U0001F3FD',
    u':gesto_de_te_amo_pele_morena_escura:': u'\U0001F91F\U0001F3FE',
    u':gesto_de_te_amo_pele_escura:': u'\U0001F91F\U0001F3FF',
    u':saudação_do_rock:': u'\U0001F918',
    u':saudação_do_rock_pele_clara:': u'\U0001F918\U0001F3FB',
    u':saudação_do_rock_pele_morena_clara:': u'\U0001F918\U0001F3FC',
    u':saudação_do_rock_pele_morena:': u'\U0001F918\U0001F3FD',
    u':saudação_do_rock_pele_morena_escura:': u'\U0001F918\U0001F3FE',
    u':saudação_do_rock_pele_escura:': u'\U0001F918\U0001F3FF',
    u':sinal_me_liga:': u'\U0001F919',
    u':sinal_me_liga_pele_clara:': u'\U0001F919\U0001F3FB',
    u':sinal_me_liga_pele_morena_clara:': u'\U0001F919\U0001F3FC',
    u':sinal_me_liga_pele_morena:': u'\U0001F919\U0001F3FD',
    u':sinal_me_liga_pele_morena_escura:': u'\U0001F919\U0001F3FE',
    u':sinal_me_liga_pele_escura:': u'\U0001F919\U0001F3FF',
    u':dorso_da_mão_com_dedo_indicador_apontando_para_a_esquerda:': u'\U0001F448',
    u':dorso_da_mão_com_dedo_indicador_apontando_para_a_esquerda_pele_clara:': u'\U0001F448\U0001F3FB',
    u':dorso_da_mão_com_dedo_indicador_apontando_para_a_esquerda_pele_morena_clara:': u'\U0001F448\U0001F3FC',
    u':dorso_da_mão_com_dedo_indicador_apontando_para_a_esquerda_pele_morena:': u'\U0001F448\U0001F3FD',
    u':dorso_da_mão_com_dedo_indicador_apontando_para_a_esquerda_pele_morena_escura:': u'\U0001F448\U0001F3FE',
    u':dorso_da_mão_com_dedo_indicador_apontando_para_a_esquerda_pele_escura:': u'\U0001F448\U0001F3FF',
    u':dorso_da_mão_com_dedo_indicador_apontando_para_a_direita:': u'\U0001F449',
    u':dorso_da_mão_com_dedo_indicador_apontando_para_a_direita_pele_clara:': u'\U0001F449\U0001F3FB',
    u':dorso_da_mão_com_dedo_indicador_apontando_para_a_direita_pele_morena_clara:': u'\U0001F449\U0001F3FC',
    u':dorso_da_mão_com_dedo_indicador_apontando_para_a_direita_pele_morena:': u'\U0001F449\U0001F3FD',
    u':dorso_da_mão_com_dedo_indicador_apontando_para_a_direita_pele_morena_escura:': u'\U0001F449\U0001F3FE',
    u':dorso_da_mão_com_dedo_indicador_apontando_para_a_direita_pele_escura:': u'\U0001F449\U0001F3FF',
    u':dorso_da_mão_com_dedo_indicador_apontando_para_cima:': u'\U0001F446',
    u':dorso_da_mão_com_dedo_indicador_apontando_para_cima_pele_clara:': u'\U0001F446\U0001F3FB',
    u':dorso_da_mão_com_dedo_indicador_apontando_para_cima_pele_morena_clara:': u'\U0001F446\U0001F3FC',
    u':dorso_da_mão_com_dedo_indicador_apontando_para_cima_pele_morena:': u'\U0001F446\U0001F3FD',
    u':dorso_da_mão_com_dedo_indicador_apontando_para_cima_pele_morena_escura:': u'\U0001F446\U0001F3FE',
    u':dorso_da_mão_com_dedo_indicador_apontando_para_cima_pele_escura:': u'\U0001F446\U0001F3FF',
    u':dedo_do_meio:': u'\U0001F595',
    u':dedo_do_meio_pele_clara:': u'\U0001F595\U0001F3FB',
    u':dedo_do_meio_pele_morena_clara:': u'\U0001F595\U0001F3FC',
    u':dedo_do_meio_pele_morena:': u'\U0001F595\U0001F3FD',
    u':dedo_do_meio_pele_morena_escura:': u'\U0001F595\U0001F3FE',
    u':dedo_do_meio_pele_escura:': u'\U0001F595\U0001F3FF',
    u':dorso_da_mão_com_dedo_indicador_apontando_para_baixo:': u'\U0001F447',
    u':dorso_da_mão_com_dedo_indicador_apontando_para_baixo_pele_clara:': u'\U0001F447\U0001F3FB',
    u':dorso_da_mão_com_dedo_indicador_apontando_para_baixo_pele_morena_clara:': u'\U0001F447\U0001F3FC',
    u':dorso_da_mão_com_dedo_indicador_apontando_para_baixo_pele_morena:': u'\U0001F447\U0001F3FD',
    u':dorso_da_mão_com_dedo_indicador_apontando_para_baixo_pele_morena_escura:': u'\U0001F447\U0001F3FE',
    u':dorso_da_mão_com_dedo_indicador_apontando_para_baixo_pele_escura:': u'\U0001F447\U0001F3FF',
    u':indicador_apontando_para_cima:': u'\U0000261D',
    u':indicador_apontando_para_cima_selector:': u'\U0000261D\U0000FE0F',
    u':indicador_apontando_para_cima_pele_clara:': u'\U0000261D\U0001F3FB',
    u':indicador_apontando_para_cima_pele_morena_clara:': u'\U0000261D\U0001F3FC',
    u':indicador_apontando_para_cima_pele_morena:': u'\U0000261D\U0001F3FD',
    u':indicador_apontando_para_cima_pele_morena_escura:': u'\U0000261D\U0001F3FE',
    u':indicador_apontando_para_cima_pele_escura:': u'\U0000261D\U0001F3FF',
    u':polegar_para_cima:': u'\U0001F44D',
    u':polegar_para_cima_pele_clara:': u'\U0001F44D\U0001F3FB',
    u':polegar_para_cima_pele_morena_clara:': u'\U0001F44D\U0001F3FC',
    u':polegar_para_cima_pele_morena:': u'\U0001F44D\U0001F3FD',
    u':polegar_para_cima_pele_morena_escura:': u'\U0001F44D\U0001F3FE',
    u':polegar_para_cima_pele_escura:': u'\U0001F44D\U0001F3FF',
    u':polegar_para_baixo:': u'\U0001F44E',
    u':polegar_para_baixo_pele_clara:': u'\U0001F44E\U0001F3FB',
    u':polegar_para_baixo_pele_morena_clara:': u'\U0001F44E\U0001F3FC',
    u':polegar_para_baixo_pele_morena:': u'\U0001F44E\U0001F3FD',
    u':polegar_para_baixo_pele_morena_escura:': u'\U0001F44E\U0001F3FE',
    u':polegar_para_baixo_pele_escura:': u'\U0001F44E\U0001F3FF',
    u':punho_levantado:': u'\U0000270A',
    u':punho_levantado_pele_clara:': u'\U0000270A\U0001F3FB',
    u':punho_levantado_pele_morena_clara:': u'\U0000270A\U0001F3FC',
    u':punho_levantado_pele_morena:': u'\U0000270A\U0001F3FD',
    u':punho_levantado_pele_morena_escura:': u'\U0000270A\U0001F3FE',
    u':punho_levantado_pele_escura:': u'\U0000270A\U0001F3FF',
    u':soco:': u'\U0001F44A',
    u':soco_pele_clara:': u'\U0001F44A\U0001F3FB',
    u':soco_pele_morena_clara:': u'\U0001F44A\U0001F3FC',
    u':soco_pele_morena:': u'\U0001F44A\U0001F3FD',
    u':soco_pele_morena_escura:': u'\U0001F44A\U0001F3FE',
    u':soco_pele_escura:': u'\U0001F44A\U0001F3FF',
    u':punho_esquerdo:': u'\U0001F91B',
    u':punho_esquerdo_pele_clara:': u'\U0001F91B\U0001F3FB',
    u':punho_esquerdo_pele_morena_clara:': u'\U0001F91B\U0001F3FC',
    u':punho_esquerdo_pele_morena:': u'\U0001F91B\U0001F3FD',
    u':punho_esquerdo_pele_morena_escura:': u'\U0001F91B\U0001F3FE',
    u':punho_esquerdo_pele_escura:': u'\U0001F91B\U0001F3FF',
    u':punho_direito:': u'\U0001F91C',
    u':punho_direito_pele_clara:': u'\U0001F91C\U0001F3FB',
    u':punho_direito_pele_morena_clara:': u'\U0001F91C\U0001F3FC',
    u':punho_direito_pele_morena:': u'\U0001F91C\U0001F3FD',
    u':punho_direito_pele_morena_escura:': u'\U0001F91C\U0001F3FE',
    u':punho_direito_pele_escura:': u'\U0001F91C\U0001F3FF',
    u':mãos_aplaudindo:': u'\U0001F44F',
    u':mãos_aplaudindo_pele_clara:': u'\U0001F44F\U0001F3FB',
    u':mãos_aplaudindo_pele_morena_clara:': u'\U0001F44F\U0001F3FC',
    u':mãos_aplaudindo_pele_morena:': u'\U0001F44F\U0001F3FD',
    u':mãos_aplaudindo_pele_morena_escura:': u'\U0001F44F\U0001F3FE',
    u':mãos_aplaudindo_pele_escura:': u'\U0001F44F\U0001F3FF',
    u':mãos_para_cima:': u'\U0001F64C',
    u':mãos_para_cima_pele_clara:': u'\U0001F64C\U0001F3FB',
    u':mãos_para_cima_pele_morena_clara:': u'\U0001F64C\U0001F3FC',
    u':mãos_para_cima_pele_morena:': u'\U0001F64C\U0001F3FD',
    u':mãos_para_cima_pele_morena_escura:': u'\U0001F64C\U0001F3FE',
    u':mãos_para_cima_pele_escura:': u'\U0001F64C\U0001F3FF',
    u':mãos_abertas:': u'\U0001F450',
    u':mãos_abertas_pele_clara:': u'\U0001F450\U0001F3FB',
    u':mãos_abertas_pele_morena_clara:': u'\U0001F450\U0001F3FC',
    u':mãos_abertas_pele_morena:': u'\U0001F450\U0001F3FD',
    u':mãos_abertas_pele_morena_escura:': u'\U0001F450\U0001F3FE',
    u':mãos_abertas_pele_escura:': u'\U0001F450\U0001F3FF',
    u':palmas_unidas_para_cima:': u'\U0001F932',
    u':palmas_unidas_para_cima_pele_clara:': u'\U0001F932\U0001F3FB',
    u':palmas_unidas_para_cima_pele_morena_clara:': u'\U0001F932\U0001F3FC',
    u':palmas_unidas_para_cima_pele_morena:': u'\U0001F932\U0001F3FD',
    u':palmas_unidas_para_cima_pele_morena_escura:': u'\U0001F932\U0001F3FE',
    u':palmas_unidas_para_cima_pele_escura:': u'\U0001F932\U0001F3FF',
    u':aperto_de_mãos:': u'\U0001F91D',
    u':mãos_juntas:': u'\U0001F64F',
    u':mãos_juntas_pele_clara:': u'\U0001F64F\U0001F3FB',
    u':mãos_juntas_pele_morena_clara:': u'\U0001F64F\U0001F3FC',
    u':mãos_juntas_pele_morena:': u'\U0001F64F\U0001F3FD',
    u':mãos_juntas_pele_morena_escura:': u'\U0001F64F\U0001F3FE',
    u':mãos_juntas_pele_escura:': u'\U0001F64F\U0001F3FF',
    u':escrevendo_à_mão:': u'\U0000270D\U0000FE0F',
    u':escrevendo_à_mão_pele_clara:': u'\U0000270D\U0001F3FB',
    u':escrevendo_à_mão_pele_morena_clara:': u'\U0000270D\U0001F3FC',
    u':escrevendo_à_mão_pele_morena:': u'\U0000270D\U0001F3FD',
    u':escrevendo_à_mão_pele_morena_escura:': u'\U0000270D\U0001F3FE',
    u':escrevendo_à_mão_pele_escura:': u'\U0000270D\U0001F3FF',
    u':esmalte_de_unha:': u'\U0001F485',
    u':esmalte_de_unha_pele_clara:': u'\U0001F485\U0001F3FB',
    u':esmalte_de_unha_pele_morena_clara:': u'\U0001F485\U0001F3FC',
    u':esmalte_de_unha_pele_morena:': u'\U0001F485\U0001F3FD',
    u':esmalte_de_unha_pele_morena_escura:': u'\U0001F485\U0001F3FE',
    u':esmalte_de_unha_pele_escura:': u'\U0001F485\U0001F3FF',
    u':selfie:': u'\U0001F933',
    u':selfie_pele_clara:': u'\U0001F933\U0001F3FB',
    u':selfie_pele_morena_clara:': u'\U0001F933\U0001F3FC',
    u':selfie_pele_morena:': u'\U0001F933\U0001F3FD',
    u':selfie_pele_morena_escura:': u'\U0001F933\U0001F3FE',
    u':selfie_pele_escura:': u'\U0001F933\U0001F3FF',
    u':bíceps:': u'\U0001F4AA',
    u':bíceps_pele_clara:': u'\U0001F4AA\U0001F3FB',
    u':bíceps_pele_morena_clara:': u'\U0001F4AA\U0001F3FC',
    u':bíceps_pele_morena:': u'\U0001F4AA\U0001F3FD',
    u':bíceps_pele_morena_escura:': u'\U0001F4AA\U0001F3FE',
    u':bíceps_pele_escura:': u'\U0001F4AA\U0001F3FF',
    u':braço_mecânico:': u'\U0001F9BE',
    u':perna_mecânica:': u'\U0001F9BF',
    u':perna:': u'\U0001F9B5',
    u':perna_pele_clara:': u'\U0001F9B5\U0001F3FB',
    u':perna_pele_morena_clara:': u'\U0001F9B5\U0001F3FC',
    u':perna_pele_morena:': u'\U0001F9B5\U0001F3FD',
    u':perna_pele_morena_escura:': u'\U0001F9B5\U0001F3FE',
    u':perna_pele_escura:': u'\U0001F9B5\U0001F3FF',
    u':pé:': u'\U0001F9B6',
    u':pé_pele_clara:': u'\U0001F9B6\U0001F3FB',
    u':pé_pele_morena_clara:': u'\U0001F9B6\U0001F3FC',
    u':pé_pele_morena:': u'\U0001F9B6\U0001F3FD',
    u':pé_pele_morena_escura:': u'\U0001F9B6\U0001F3FE',
    u':pé_pele_escura:': u'\U0001F9B6\U0001F3FF',
    u':orelha:': u'\U0001F442',
    u':orelha_pele_clara:': u'\U0001F442\U0001F3FB',
    u':orelha_pele_morena_clara:': u'\U0001F442\U0001F3FC',
    u':orelha_pele_morena:': u'\U0001F442\U0001F3FD',
    u':orelha_pele_morena_escura:': u'\U0001F442\U0001F3FE',
    u':orelha_pele_escura:': u'\U0001F442\U0001F3FF',
    u':ouvido_com_aparelho_auditivo:': u'\U0001F9BB',
    u':ouvido_com_aparelho_auditivo_pele_clara:': u'\U0001F9BB\U0001F3FB',
    u':ouvido_com_aparelho_auditivo_pele_morena_clara:': u'\U0001F9BB\U0001F3FC',
    u':ouvido_com_aparelho_auditivo_pele_morena:': u'\U0001F9BB\U0001F3FD',
    u':ouvido_com_aparelho_auditivo_pele_morena_escura:': u'\U0001F9BB\U0001F3FE',
    u':ouvido_com_aparelho_auditivo_pele_escura:': u'\U0001F9BB\U0001F3FF',
    u':nariz:': u'\U0001F443',
    u':nariz_pele_clara:': u'\U0001F443\U0001F3FB',
    u':nariz_pele_morena_clara:': u'\U0001F443\U0001F3FC',
    u':nariz_pele_morena:': u'\U0001F443\U0001F3FD',
    u':nariz_pele_morena_escura:': u'\U0001F443\U0001F3FE',
    u':nariz_pele_escura:': u'\U0001F443\U0001F3FF',
    u':cérebro:': u'\U0001F9E0',
    u':coração_humano:': u'\U0001FAC0',
    u':pulmões:': u'\U0001FAC1',
    u':dente:': u'\U0001F9B7',
    u':osso:': u'\U0001F9B4',
    u':olhos:': u'\U0001F440',
    u':olho:': u'\U0001F441\U0000FE0F',
    u':língua:': u'\U0001F445',
    u':boca:': u'\U0001F444',
    u':bebê:': u'\U0001F476',
    u':bebê_pele_clara:': u'\U0001F476\U0001F3FB',
    u':bebê_pele_morena_clara:': u'\U0001F476\U0001F3FC',
    u':bebê_pele_morena:': u'\U0001F476\U0001F3FD',
    u':bebê_pele_morena_escura:': u'\U0001F476\U0001F3FE',
    u':bebê_pele_escura:': u'\U0001F476\U0001F3FF',
    u':criança:': u'\U0001F9D2',
    u':criança_pele_clara:': u'\U0001F9D2\U0001F3FB',
    u':criança_pele_morena_clara:': u'\U0001F9D2\U0001F3FC',
    u':criança_pele_morena:': u'\U0001F9D2\U0001F3FD',
    u':criança_pele_morena_escura:': u'\U0001F9D2\U0001F3FE',
    u':criança_pele_escura:': u'\U0001F9D2\U0001F3FF',
    u':menino:': u'\U0001F466',
    u':menino_pele_clara:': u'\U0001F466\U0001F3FB',
    u':menino_pele_morena_clara:': u'\U0001F466\U0001F3FC',
    u':menino_pele_morena:': u'\U0001F466\U0001F3FD',
    u':menino_pele_morena_escura:': u'\U0001F466\U0001F3FE',
    u':menino_pele_escura:': u'\U0001F466\U0001F3FF',
    u':menina:': u'\U0001F467',
    u':menina_pele_clara:': u'\U0001F467\U0001F3FB',
    u':menina_pele_morena_clara:': u'\U0001F467\U0001F3FC',
    u':menina_pele_morena:': u'\U0001F467\U0001F3FD',
    u':menina_pele_morena_escura:': u'\U0001F467\U0001F3FE',
    u':menina_pele_escura:': u'\U0001F467\U0001F3FF',
    u':pessoa:': u'\U0001F9D1',
    u':pessoa_pele_clara:': u'\U0001F9D1\U0001F3FB',
    u':pessoa_pele_morena_clara:': u'\U0001F9D1\U0001F3FC',
    u':pessoa_pele_morena:': u'\U0001F9D1\U0001F3FD',
    u':pessoa_pele_morena_escura:': u'\U0001F9D1\U0001F3FE',
    u':pessoa_pele_escura:': u'\U0001F9D1\U0001F3FF',
    u':pessoa_cabelo_louro:': u'\U0001F471',
    u':pessoa_pele_clara_e_cabelo_louro:': u'\U0001F471\U0001F3FB',
    u':pessoa_pele_morena_clara_e_cabelo_louro:': u'\U0001F471\U0001F3FC',
    u':pessoa_pele_morena_e_cabelo_louro:': u'\U0001F471\U0001F3FD',
    u':pessoa_pele_morena_escura_e_cabelo_louro:': u'\U0001F471\U0001F3FE',
    u':pessoa_pele_escura_e_cabelo_louro:': u'\U0001F471\U0001F3FF',
    u':homem:': u'\U0001F468',
    u':homem_pele_clara:': u'\U0001F468\U0001F3FB',
    u':homem_pele_morena_clara:': u'\U0001F468\U0001F3FC',
    u':homem_pele_morena:': u'\U0001F468\U0001F3FD',
    u':homem_pele_morena_escura:': u'\U0001F468\U0001F3FE',
    u':homem_pele_escura:': u'\U0001F468\U0001F3FF',
    u':homem_barba:': u'\U0001F9D4',
    u':homem_pele_clara_e_barba:': u'\U0001F9D4\U0001F3FB',
    u':homem_pele_morena_clara_e_barba:': u'\U0001F9D4\U0001F3FC',
    u':homem_pele_morena_e_barba:': u'\U0001F9D4\U0001F3FD',
    u':homem_pele_morena_escura_e_barba:': u'\U0001F9D4\U0001F3FE',
    u':homem_pele_escura_e_barba:': u'\U0001F9D4\U0001F3FF',
    u':homem_cabelo_vermelho:': u'\U0001F468\U0000200D\U0001F9B0',
    u':homem_pele_clara_e_cabelo_vermelho:': u'\U0001F468\U0001F3FB\U0000200D\U0001F9B0',
    u':homem_pele_morena_clara_e_cabelo_vermelho:': u'\U0001F468\U0001F3FC\U0000200D\U0001F9B0',
    u':homem_pele_morena_e_cabelo_vermelho:': u'\U0001F468\U0001F3FD\U0000200D\U0001F9B0',
    u':homem_pele_morena_escura_e_cabelo_vermelho:': u'\U0001F468\U0001F3FE\U0000200D\U0001F9B0',
    u':homem_pele_escura_e_cabelo_vermelho:': u'\U0001F468\U0001F3FF\U0000200D\U0001F9B0',
    u':homem_cabelo_cacheado:': u'\U0001F468\U0000200D\U0001F9B1',
    u':homem_pele_clara_e_cabelo_cacheado:': u'\U0001F468\U0001F3FB\U0000200D\U0001F9B1',
    u':homem_pele_morena_clara_e_cabelo_cacheado:': u'\U0001F468\U0001F3FC\U0000200D\U0001F9B1',
    u':homem_pele_morena_e_cabelo_cacheado:': u'\U0001F468\U0001F3FD\U0000200D\U0001F9B1',
    u':homem_pele_morena_escura_e_cabelo_cacheado:': u'\U0001F468\U0001F3FE\U0000200D\U0001F9B1',
    u':homem_pele_escura_e_cabelo_cacheado:': u'\U0001F468\U0001F3FF\U0000200D\U0001F9B1',
    u':homem_cabelo_branco:': u'\U0001F468\U0000200D\U0001F9B3',
    u':homem_pele_clara_e_cabelo_branco:': u'\U0001F468\U0001F3FB\U0000200D\U0001F9B3',
    u':homem_pele_morena_clara_e_cabelo_branco:': u'\U0001F468\U0001F3FC\U0000200D\U0001F9B3',
    u':homem_pele_morena_e_cabelo_branco:': u'\U0001F468\U0001F3FD\U0000200D\U0001F9B3',
    u':homem_pele_morena_escura_e_cabelo_branco:': u'\U0001F468\U0001F3FE\U0000200D\U0001F9B3',
    u':homem_pele_escura_e_cabelo_branco:': u'\U0001F468\U0001F3FF\U0000200D\U0001F9B3',
    u':homem_careca:': u'\U0001F468\U0000200D\U0001F9B2',
    u':homem_pele_clara_e_careca:': u'\U0001F468\U0001F3FB\U0000200D\U0001F9B2',
    u':homem_pele_morena_clara_e_careca:': u'\U0001F468\U0001F3FC\U0000200D\U0001F9B2',
    u':homem_pele_morena_e_careca:': u'\U0001F468\U0001F3FD\U0000200D\U0001F9B2',
    u':homem_pele_morena_escura_e_careca:': u'\U0001F468\U0001F3FE\U0000200D\U0001F9B2',
    u':homem_pele_escura_e_careca:': u'\U0001F468\U0001F3FF\U0000200D\U0001F9B2',
    u':mulher:': u'\U0001F469',
    u':mulher_pele_clara:': u'\U0001F469\U0001F3FB',
    u':mulher_pele_morena_clara:': u'\U0001F469\U0001F3FC',
    u':mulher_pele_morena:': u'\U0001F469\U0001F3FD',
    u':mulher_pele_morena_escura:': u'\U0001F469\U0001F3FE',
    u':mulher_pele_escura:': u'\U0001F469\U0001F3FF',
    u':mulher_cabelo_vermelho:': u'\U0001F469\U0000200D\U0001F9B0',
    u':mulher_pele_clara_e_cabelo_vermelho:': u'\U0001F469\U0001F3FB\U0000200D\U0001F9B0',
    u':mulher_pele_morena_clara_e_cabelo_vermelho:': u'\U0001F469\U0001F3FC\U0000200D\U0001F9B0',
    u':mulher_pele_morena_e_cabelo_vermelho:': u'\U0001F469\U0001F3FD\U0000200D\U0001F9B0',
    u':mulher_pele_morena_escura_e_cabelo_vermelho:': u'\U0001F469\U0001F3FE\U0000200D\U0001F9B0',
    u':mulher_pele_escura_e_cabelo_vermelho:': u'\U0001F469\U0001F3FF\U0000200D\U0001F9B0',
    u':pessoa_cabelo_vermelho:': u'\U0001F9D1\U0000200D\U0001F9B0',
    u':pessoa_pele_clara_e_cabelo_vermelho:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F9B0',
    u':pessoa_pele_morena_clara_e_cabelo_vermelho:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F9B0',
    u':pessoa_pele_morena_e_cabelo_vermelho:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F9B0',
    u':pessoa_pele_morena_escura_e_cabelo_vermelho:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F9B0',
    u':pessoa_pele_escura_e_cabelo_vermelho:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F9B0',
    u':mulher_cabelo_cacheado:': u'\U0001F469\U0000200D\U0001F9B1',
    u':mulher_pele_clara_e_cabelo_cacheado:': u'\U0001F469\U0001F3FB\U0000200D\U0001F9B1',
    u':mulher_pele_morena_clara_e_cabelo_cacheado:': u'\U0001F469\U0001F3FC\U0000200D\U0001F9B1',
    u':mulher_pele_morena_e_cabelo_cacheado:': u'\U0001F469\U0001F3FD\U0000200D\U0001F9B1',
    u':mulher_pele_morena_escura_e_cabelo_cacheado:': u'\U0001F469\U0001F3FE\U0000200D\U0001F9B1',
    u':mulher_pele_escura_e_cabelo_cacheado:': u'\U0001F469\U0001F3FF\U0000200D\U0001F9B1',
    u':pessoa_cabelo_cacheado:': u'\U0001F9D1\U0000200D\U0001F9B1',
    u':pessoa_pele_clara_e_cabelo_cacheado:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F9B1',
    u':pessoa_pele_morena_clara_e_cabelo_cacheado:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F9B1',
    u':pessoa_pele_morena_e_cabelo_cacheado:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F9B1',
    u':pessoa_pele_morena_escura_e_cabelo_cacheado:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F9B1',
    u':pessoa_pele_escura_e_cabelo_cacheado:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F9B1',
    u':mulher_cabelo_branco:': u'\U0001F469\U0000200D\U0001F9B3',
    u':mulher_pele_clara_e_cabelo_branco:': u'\U0001F469\U0001F3FB\U0000200D\U0001F9B3',
    u':mulher_pele_morena_clara_e_cabelo_branco:': u'\U0001F469\U0001F3FC\U0000200D\U0001F9B3',
    u':mulher_pele_morena_e_cabelo_branco:': u'\U0001F469\U0001F3FD\U0000200D\U0001F9B3',
    u':mulher_pele_morena_escura_e_cabelo_branco:': u'\U0001F469\U0001F3FE\U0000200D\U0001F9B3',
    u':mulher_pele_escura_e_cabelo_branco:': u'\U0001F469\U0001F3FF\U0000200D\U0001F9B3',
    u':pessoa_cabelo_branco:': u'\U0001F9D1\U0000200D\U0001F9B3',
    u':pessoa_pele_clara_e_cabelo_branco:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F9B3',
    u':pessoa_pele_morena_clara_e_cabelo_branco:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F9B3',
    u':pessoa_pele_morena_e_cabelo_branco:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F9B3',
    u':pessoa_pele_morena_escura_e_cabelo_branco:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F9B3',
    u':pessoa_pele_escura_e_cabelo_branco:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F9B3',
    u':mulher_careca:': u'\U0001F469\U0000200D\U0001F9B2',
    u':mulher_pele_clara_e_careca:': u'\U0001F469\U0001F3FB\U0000200D\U0001F9B2',
    u':mulher_pele_morena_clara_e_careca:': u'\U0001F469\U0001F3FC\U0000200D\U0001F9B2',
    u':mulher_pele_morena_e_careca:': u'\U0001F469\U0001F3FD\U0000200D\U0001F9B2',
    u':mulher_pele_morena_escura_e_careca:': u'\U0001F469\U0001F3FE\U0000200D\U0001F9B2',
    u':mulher_pele_escura_e_careca:': u'\U0001F469\U0001F3FF\U0000200D\U0001F9B2',
    u':pessoa_careca:': u'\U0001F9D1\U0000200D\U0001F9B2',
    u':pessoa_pele_clara_e_careca:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F9B2',
    u':pessoa_pele_morena_clara_e_careca:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F9B2',
    u':pessoa_pele_morena_e_careca:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F9B2',
    u':pessoa_pele_morena_escura_e_careca:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F9B2',
    u':pessoa_pele_escura_e_careca:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F9B2',
    u':mulher_cabelo_loiro:': u'\U0001F471\U0000200D\U00002640\U0000FE0F',
    u':mulher_pele_clara_e_cabelo_loiro:': u'\U0001F471\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mulher_pele_morena_clara_e_cabelo_loiro:': u'\U0001F471\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mulher_pele_morena_e_cabelo_loiro:': u'\U0001F471\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mulher_pele_morena_escura_e_cabelo_loiro:': u'\U0001F471\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mulher_pele_escura_e_cabelo_loiro:': u'\U0001F471\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':homem_cabelo_loiro:': u'\U0001F471\U0000200D\U00002642\U0000FE0F',
    u':homem_pele_clara_e_cabelo_loiro:': u'\U0001F471\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homem_pele_morena_clara_e_cabelo_loiro:': u'\U0001F471\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homem_pele_morena_e_cabelo_loiro:': u'\U0001F471\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homem_pele_morena_escura_e_cabelo_loiro:': u'\U0001F471\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homem_pele_escura_e_cabelo_loiro:': u'\U0001F471\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':idoso:': u'\U0001F9D3',
    u':idoso_pele_clara:': u'\U0001F9D3\U0001F3FB',
    u':idoso_pele_morena_clara:': u'\U0001F9D3\U0001F3FC',
    u':idoso_pele_morena:': u'\U0001F9D3\U0001F3FD',
    u':idoso_pele_morena_escura:': u'\U0001F9D3\U0001F3FE',
    u':idoso_pele_escura:': u'\U0001F9D3\U0001F3FF',
    u':homem_idoso:': u'\U0001F474',
    u':homem_idoso_pele_clara:': u'\U0001F474\U0001F3FB',
    u':homem_idoso_pele_morena_clara:': u'\U0001F474\U0001F3FC',
    u':homem_idoso_pele_morena:': u'\U0001F474\U0001F3FD',
    u':homem_idoso_pele_morena_escura:': u'\U0001F474\U0001F3FE',
    u':homem_idoso_pele_escura:': u'\U0001F474\U0001F3FF',
    u':idosa:': u'\U0001F475',
    u':idosa_pele_clara:': u'\U0001F475\U0001F3FB',
    u':idosa_pele_morena_clara:': u'\U0001F475\U0001F3FC',
    u':idosa_pele_morena:': u'\U0001F475\U0001F3FD',
    u':idosa_pele_morena_escura:': u'\U0001F475\U0001F3FE',
    u':idosa_pele_escura:': u'\U0001F475\U0001F3FF',
    u':franzindo_a_sobrancelha:': u'\U0001F64D',
    u':franzindo_a_sobrancelha_pele_clara:': u'\U0001F64D\U0001F3FB',
    u':franzindo_a_sobrancelha_pele_morena_clara:': u'\U0001F64D\U0001F3FC',
    u':franzindo_a_sobrancelha_pele_morena:': u'\U0001F64D\U0001F3FD',
    u':franzindo_a_sobrancelha_pele_morena_escura:': u'\U0001F64D\U0001F3FE',
    u':franzindo_a_sobrancelha_pele_escura:': u'\U0001F64D\U0001F3FF',
    u':homem_franzindo_a_sobrancelha:': u'\U0001F64D\U0000200D\U00002642\U0000FE0F',
    u':homem_franzindo_a_sobrancelha_pele_clara:': u'\U0001F64D\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homem_franzindo_a_sobrancelha_pele_morena_clara:': u'\U0001F64D\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homem_franzindo_a_sobrancelha_pele_morena:': u'\U0001F64D\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homem_franzindo_a_sobrancelha_pele_morena_escura:': u'\U0001F64D\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homem_franzindo_a_sobrancelha_pele_escura:': u'\U0001F64D\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mulher_franzindo_a_sobrancelha:': u'\U0001F64D\U0000200D\U00002640\U0000FE0F',
    u':mulher_franzindo_a_sobrancelha_pele_clara:': u'\U0001F64D\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mulher_franzindo_a_sobrancelha_pele_morena_clara:': u'\U0001F64D\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mulher_franzindo_a_sobrancelha_pele_morena:': u'\U0001F64D\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mulher_franzindo_a_sobrancelha_pele_morena_escura:': u'\U0001F64D\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mulher_franzindo_a_sobrancelha_pele_escura:': u'\U0001F64D\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':pessoa_fazendo_bico:': u'\U0001F64E',
    u':pessoa_fazendo_bico_pele_clara:': u'\U0001F64E\U0001F3FB',
    u':pessoa_fazendo_bico_pele_morena_clara:': u'\U0001F64E\U0001F3FC',
    u':pessoa_fazendo_bico_pele_morena:': u'\U0001F64E\U0001F3FD',
    u':pessoa_fazendo_bico_pele_morena_escura:': u'\U0001F64E\U0001F3FE',
    u':pessoa_fazendo_bico_pele_escura:': u'\U0001F64E\U0001F3FF',
    u':homem_fazendo_bico:': u'\U0001F64E\U0000200D\U00002642\U0000FE0F',
    u':homem_fazendo_bico_pele_clara:': u'\U0001F64E\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homem_fazendo_bico_pele_morena_clara:': u'\U0001F64E\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homem_fazendo_bico_pele_morena:': u'\U0001F64E\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homem_fazendo_bico_pele_morena_escura:': u'\U0001F64E\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homem_fazendo_bico_pele_escura:': u'\U0001F64E\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mulher_fazendo_bico:': u'\U0001F64E\U0000200D\U00002640\U0000FE0F',
    u':mulher_fazendo_bico_pele_clara:': u'\U0001F64E\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mulher_fazendo_bico_pele_morena_clara:': u'\U0001F64E\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mulher_fazendo_bico_pele_morena:': u'\U0001F64E\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mulher_fazendo_bico_pele_morena_escura:': u'\U0001F64E\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mulher_fazendo_bico_pele_escura:': u'\U0001F64E\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':pessoa_fazendo_gesto_de_“não”:': u'\U0001F645',
    u':pessoa_fazendo_gesto_de_“não”_pele_clara:': u'\U0001F645\U0001F3FB',
    u':pessoa_fazendo_gesto_de_“não”_pele_morena_clara:': u'\U0001F645\U0001F3FC',
    u':pessoa_fazendo_gesto_de_“não”_pele_morena:': u'\U0001F645\U0001F3FD',
    u':pessoa_fazendo_gesto_de_“não”_pele_morena_escura:': u'\U0001F645\U0001F3FE',
    u':pessoa_fazendo_gesto_de_“não”_pele_escura:': u'\U0001F645\U0001F3FF',
    u':homem_fazendo_gesto_de_“não”:': u'\U0001F645\U0000200D\U00002642\U0000FE0F',
    u':homem_fazendo_gesto_de_“não”_pele_clara:': u'\U0001F645\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homem_fazendo_gesto_de_“não”_pele_morena_clara:': u'\U0001F645\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homem_fazendo_gesto_de_“não”_pele_morena:': u'\U0001F645\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homem_fazendo_gesto_de_“não”_pele_morena_escura:': u'\U0001F645\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homem_fazendo_gesto_de_“não”_pele_escura:': u'\U0001F645\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mulher_fazendo_gesto_de_“não”:': u'\U0001F645\U0000200D\U00002640\U0000FE0F',
    u':mulher_fazendo_gesto_de_“não”_pele_clara:': u'\U0001F645\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mulher_fazendo_gesto_de_“não”_pele_morena_clara:': u'\U0001F645\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mulher_fazendo_gesto_de_“não”_pele_morena:': u'\U0001F645\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mulher_fazendo_gesto_de_“não”_pele_morena_escura:': u'\U0001F645\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mulher_fazendo_gesto_de_“não”_pele_escura:': u'\U0001F645\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':pessoa_fazendo_gesto_de_“ok”:': u'\U0001F646',
    u':pessoa_fazendo_gesto_de_“ok”_pele_clara:': u'\U0001F646\U0001F3FB',
    u':pessoa_fazendo_gesto_de_“ok”_pele_morena_clara:': u'\U0001F646\U0001F3FC',
    u':pessoa_fazendo_gesto_de_“ok”_pele_morena:': u'\U0001F646\U0001F3FD',
    u':pessoa_fazendo_gesto_de_“ok”_pele_morena_escura:': u'\U0001F646\U0001F3FE',
    u':pessoa_fazendo_gesto_de_“ok”_pele_escura:': u'\U0001F646\U0001F3FF',
    u':homem_fazendo_gesto_de_“ok”:': u'\U0001F646\U0000200D\U00002642\U0000FE0F',
    u':homem_fazendo_gesto_de_“ok”_pele_clara:': u'\U0001F646\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homem_fazendo_gesto_de_“ok”_pele_morena_clara:': u'\U0001F646\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homem_fazendo_gesto_de_“ok”_pele_morena:': u'\U0001F646\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homem_fazendo_gesto_de_“ok”_pele_morena_escura:': u'\U0001F646\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homem_fazendo_gesto_de_“ok”_pele_escura:': u'\U0001F646\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mulher_fazendo_gesto_de_“ok”:': u'\U0001F646\U0000200D\U00002640\U0000FE0F',
    u':mulher_fazendo_gesto_de_“ok”_pele_clara:': u'\U0001F646\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mulher_fazendo_gesto_de_“ok”_pele_morena_clara:': u'\U0001F646\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mulher_fazendo_gesto_de_“ok”_pele_morena:': u'\U0001F646\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mulher_fazendo_gesto_de_“ok”_pele_morena_escura:': u'\U0001F646\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mulher_fazendo_gesto_de_“ok”_pele_escura:': u'\U0001F646\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':pessoa_com_a_palma_virada_para_cima:': u'\U0001F481',
    u':pessoa_com_a_palma_virada_para_cima_pele_clara:': u'\U0001F481\U0001F3FB',
    u':pessoa_com_a_palma_virada_para_cima_pele_morena_clara:': u'\U0001F481\U0001F3FC',
    u':pessoa_com_a_palma_virada_para_cima_pele_morena:': u'\U0001F481\U0001F3FD',
    u':pessoa_com_a_palma_virada_para_cima_pele_morena_escura:': u'\U0001F481\U0001F3FE',
    u':pessoa_com_a_palma_virada_para_cima_pele_escura:': u'\U0001F481\U0001F3FF',
    u':homem_com_a_palma_virada_para_cima:': u'\U0001F481\U0000200D\U00002642\U0000FE0F',
    u':homem_com_a_palma_virada_para_cima_pele_clara:': u'\U0001F481\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homem_com_a_palma_virada_para_cima_pele_morena_clara:': u'\U0001F481\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homem_com_a_palma_virada_para_cima_pele_morena:': u'\U0001F481\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homem_com_a_palma_virada_para_cima_pele_morena_escura:': u'\U0001F481\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homem_com_a_palma_virada_para_cima_pele_escura:': u'\U0001F481\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mulher_com_a_palma_virada_para_cima:': u'\U0001F481\U0000200D\U00002640\U0000FE0F',
    u':mulher_com_a_palma_virada_para_cima_pele_clara:': u'\U0001F481\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mulher_com_a_palma_virada_para_cima_pele_morena_clara:': u'\U0001F481\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mulher_com_a_palma_virada_para_cima_pele_morena:': u'\U0001F481\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mulher_com_a_palma_virada_para_cima_pele_morena_escura:': u'\U0001F481\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mulher_com_a_palma_virada_para_cima_pele_escura:': u'\U0001F481\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':pessoa_levantando_a_mão:': u'\U0001F64B',
    u':pessoa_levantando_a_mão_pele_clara:': u'\U0001F64B\U0001F3FB',
    u':pessoa_levantando_a_mão_pele_morena_clara:': u'\U0001F64B\U0001F3FC',
    u':pessoa_levantando_a_mão_pele_morena:': u'\U0001F64B\U0001F3FD',
    u':pessoa_levantando_a_mão_pele_morena_escura:': u'\U0001F64B\U0001F3FE',
    u':pessoa_levantando_a_mão_pele_escura:': u'\U0001F64B\U0001F3FF',
    u':homem_levantando_a_mão:': u'\U0001F64B\U0000200D\U00002642\U0000FE0F',
    u':homem_levantando_a_mão_pele_clara:': u'\U0001F64B\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homem_levantando_a_mão_pele_morena_clara:': u'\U0001F64B\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homem_levantando_a_mão_pele_morena:': u'\U0001F64B\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homem_levantando_a_mão_pele_morena_escura:': u'\U0001F64B\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homem_levantando_a_mão_pele_escura:': u'\U0001F64B\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mulher_levantando_a_mão:': u'\U0001F64B\U0000200D\U00002640\U0000FE0F',
    u':mulher_levantando_a_mão_pele_clara:': u'\U0001F64B\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mulher_levantando_a_mão_pele_morena_clara:': u'\U0001F64B\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mulher_levantando_a_mão_pele_morena:': u'\U0001F64B\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mulher_levantando_a_mão_pele_morena_escura:': u'\U0001F64B\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mulher_levantando_a_mão_pele_escura:': u'\U0001F64B\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':pessoa_surda:': u'\U0001F9CF',
    u':pessoa_surda_pele_clara:': u'\U0001F9CF\U0001F3FB',
    u':pessoa_surda_pele_morena_clara:': u'\U0001F9CF\U0001F3FC',
    u':pessoa_surda_pele_morena:': u'\U0001F9CF\U0001F3FD',
    u':pessoa_surda_pele_morena_escura:': u'\U0001F9CF\U0001F3FE',
    u':pessoa_surda_pele_escura:': u'\U0001F9CF\U0001F3FF',
    u':homem_surdo:': u'\U0001F9CF\U0000200D\U00002642\U0000FE0F',
    u':homem_surdo_pele_clara:': u'\U0001F9CF\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homem_surdo_pele_morena_clara:': u'\U0001F9CF\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homem_surdo_pele_morena:': u'\U0001F9CF\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homem_surdo_pele_morena_escura:': u'\U0001F9CF\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homem_surdo_pele_escura:': u'\U0001F9CF\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mulher_surda:': u'\U0001F9CF\U0000200D\U00002640\U0000FE0F',
    u':mulher_surda_pele_clara:': u'\U0001F9CF\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mulher_surda_pele_morena_clara:': u'\U0001F9CF\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mulher_surda_pele_morena:': u'\U0001F9CF\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mulher_surda_pele_morena_escura:': u'\U0001F9CF\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mulher_surda_pele_escura:': u'\U0001F9CF\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':pessoa_fazendo_reverência:': u'\U0001F647',
    u':pessoa_fazendo_reverência_pele_clara:': u'\U0001F647\U0001F3FB',
    u':pessoa_fazendo_reverência_pele_morena_clara:': u'\U0001F647\U0001F3FC',
    u':pessoa_fazendo_reverência_pele_morena:': u'\U0001F647\U0001F3FD',
    u':pessoa_fazendo_reverência_pele_morena_escura:': u'\U0001F647\U0001F3FE',
    u':pessoa_fazendo_reverência_pele_escura:': u'\U0001F647\U0001F3FF',
    u':homem_fazendo_reverência:': u'\U0001F647\U0000200D\U00002642\U0000FE0F',
    u':homem_fazendo_reverência_pele_clara:': u'\U0001F647\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homem_fazendo_reverência_pele_morena_clara:': u'\U0001F647\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homem_fazendo_reverência_pele_morena:': u'\U0001F647\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homem_fazendo_reverência_pele_morena_escura:': u'\U0001F647\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homem_fazendo_reverência_pele_escura:': u'\U0001F647\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mulher_fazendo_reverência:': u'\U0001F647\U0000200D\U00002640\U0000FE0F',
    u':mulher_fazendo_reverência_pele_clara:': u'\U0001F647\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mulher_fazendo_reverência_pele_morena_clara:': u'\U0001F647\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mulher_fazendo_reverência_pele_morena:': u'\U0001F647\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mulher_fazendo_reverência_pele_morena_escura:': u'\U0001F647\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mulher_fazendo_reverência_pele_escura:': u'\U0001F647\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':pessoa_decepcionada:': u'\U0001F926',
    u':pessoa_decepcionada_pele_clara:': u'\U0001F926\U0001F3FB',
    u':pessoa_decepcionada_pele_morena_clara:': u'\U0001F926\U0001F3FC',
    u':pessoa_decepcionada_pele_morena:': u'\U0001F926\U0001F3FD',
    u':pessoa_decepcionada_pele_morena_escura:': u'\U0001F926\U0001F3FE',
    u':pessoa_decepcionada_pele_escura:': u'\U0001F926\U0001F3FF',
    u':homem_decepcionado:': u'\U0001F926\U0000200D\U00002642\U0000FE0F',
    u':homem_decepcionado_pele_clara:': u'\U0001F926\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homem_decepcionado_pele_morena_clara:': u'\U0001F926\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homem_decepcionado_pele_morena:': u'\U0001F926\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homem_decepcionado_pele_morena_escura:': u'\U0001F926\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homem_decepcionado_pele_escura:': u'\U0001F926\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mulher_decepcionada:': u'\U0001F926\U0000200D\U00002640\U0000FE0F',
    u':mulher_decepcionada_pele_clara:': u'\U0001F926\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mulher_decepcionada_pele_morena_clara:': u'\U0001F926\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mulher_decepcionada_pele_morena:': u'\U0001F926\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mulher_decepcionada_pele_morena_escura:': u'\U0001F926\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mulher_decepcionada_pele_escura:': u'\U0001F926\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':pessoa_dando_de_ombros:': u'\U0001F937',
    u':pessoa_dando_de_ombros_pele_clara:': u'\U0001F937\U0001F3FB',
    u':pessoa_dando_de_ombros_pele_morena_clara:': u'\U0001F937\U0001F3FC',
    u':pessoa_dando_de_ombros_pele_morena:': u'\U0001F937\U0001F3FD',
    u':pessoa_dando_de_ombros_pele_morena_escura:': u'\U0001F937\U0001F3FE',
    u':pessoa_dando_de_ombros_pele_escura:': u'\U0001F937\U0001F3FF',
    u':homem_dando_de_ombros:': u'\U0001F937\U0000200D\U00002642\U0000FE0F',
    u':homem_dando_de_ombros_pele_clara:': u'\U0001F937\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homem_dando_de_ombros_pele_morena_clara:': u'\U0001F937\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homem_dando_de_ombros_pele_morena:': u'\U0001F937\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homem_dando_de_ombros_pele_morena_escura:': u'\U0001F937\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homem_dando_de_ombros_pele_escura:': u'\U0001F937\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mulher_dando_de_ombros:': u'\U0001F937\U0000200D\U00002640\U0000FE0F',
    u':mulher_dando_de_ombros_pele_clara:': u'\U0001F937\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mulher_dando_de_ombros_pele_morena_clara:': u'\U0001F937\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mulher_dando_de_ombros_pele_morena:': u'\U0001F937\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mulher_dando_de_ombros_pele_morena_escura:': u'\U0001F937\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mulher_dando_de_ombros_pele_escura:': u'\U0001F937\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':profissional_de_saúde:': u'\U0001F9D1\U0000200D\U00002695\U0000FE0F',
    u':profissional_de_saúde_pele_clara:': u'\U0001F9D1\U0001F3FB\U0000200D\U00002695\U0000FE0F',
    u':profissional_de_saúde_pele_morena_clara:': u'\U0001F9D1\U0001F3FC\U0000200D\U00002695\U0000FE0F',
    u':profissional_de_saúde_pele_morena:': u'\U0001F9D1\U0001F3FD\U0000200D\U00002695\U0000FE0F',
    u':profissional_de_saúde_pele_morena_escura:': u'\U0001F9D1\U0001F3FE\U0000200D\U00002695\U0000FE0F',
    u':profissional_de_saúde_pele_escura:': u'\U0001F9D1\U0001F3FF\U0000200D\U00002695\U0000FE0F',
    u':homem_profissional_da_saúde:': u'\U0001F468\U0000200D\U00002695\U0000FE0F',
    u':homem_profissional_da_saúde_pele_clara:': u'\U0001F468\U0001F3FB\U0000200D\U00002695\U0000FE0F',
    u':homem_profissional_da_saúde_pele_morena_clara:': u'\U0001F468\U0001F3FC\U0000200D\U00002695\U0000FE0F',
    u':homem_profissional_da_saúde_pele_morena:': u'\U0001F468\U0001F3FD\U0000200D\U00002695\U0000FE0F',
    u':homem_profissional_da_saúde_pele_morena_escura:': u'\U0001F468\U0001F3FE\U0000200D\U00002695\U0000FE0F',
    u':homem_profissional_da_saúde_pele_escura:': u'\U0001F468\U0001F3FF\U0000200D\U00002695\U0000FE0F',
    u':mulher_profissional_da_saúde:': u'\U0001F469\U0000200D\U00002695\U0000FE0F',
    u':mulher_profissional_da_saúde_pele_clara:': u'\U0001F469\U0001F3FB\U0000200D\U00002695\U0000FE0F',
    u':mulher_profissional_da_saúde_pele_morena_clara:': u'\U0001F469\U0001F3FC\U0000200D\U00002695\U0000FE0F',
    u':mulher_profissional_da_saúde_pele_morena:': u'\U0001F469\U0001F3FD\U0000200D\U00002695\U0000FE0F',
    u':mulher_profissional_da_saúde_pele_morena_escura:': u'\U0001F469\U0001F3FE\U0000200D\U00002695\U0000FE0F',
    u':mulher_profissional_da_saúde_pele_escura:': u'\U0001F469\U0001F3FF\U0000200D\U00002695\U0000FE0F',
    u':aluno:': u'\U0001F9D1\U0000200D\U0001F393',
    u':aluno_pele_clara:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F393',
    u':aluno_pele_morena_clara:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F393',
    u':aluno_pele_morena:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F393',
    u':aluno_pele_morena_escura:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F393',
    u':aluno_pele_escura:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F393',
    u':estudante:': u'\U0001F468\U0000200D\U0001F393',
    u':estudante_pele_clara:': u'\U0001F468\U0001F3FB\U0000200D\U0001F393',
    u':estudante_pele_morena_clara:': u'\U0001F468\U0001F3FC\U0000200D\U0001F393',
    u':estudante_pele_morena:': u'\U0001F468\U0001F3FD\U0000200D\U0001F393',
    u':estudante_pele_morena_escura:': u'\U0001F468\U0001F3FE\U0000200D\U0001F393',
    u':estudante_pele_escura:': u'\U0001F468\U0001F3FF\U0000200D\U0001F393',
    u':aluna:': u'\U0001F469\U0000200D\U0001F393',
    u':aluna_pele_clara:': u'\U0001F469\U0001F3FB\U0000200D\U0001F393',
    u':aluna_pele_morena_clara:': u'\U0001F469\U0001F3FC\U0000200D\U0001F393',
    u':aluna_pele_morena:': u'\U0001F469\U0001F3FD\U0000200D\U0001F393',
    u':aluna_pele_morena_escura:': u'\U0001F469\U0001F3FE\U0000200D\U0001F393',
    u':aluna_pele_escura:': u'\U0001F469\U0001F3FF\U0000200D\U0001F393',
    u':professora_na_escola:': u'\U0001F9D1\U0000200D\U0001F3EB',
    u':professora_na_escola_pele_clara:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F3EB',
    u':professora_na_escola_pele_morena_clara:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F3EB',
    u':professora_na_escola_pele_morena:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F3EB',
    u':professora_na_escola_pele_morena_escura:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F3EB',
    u':professora_na_escola_pele_escura:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F3EB',
    u':professor:': u'\U0001F468\U0000200D\U0001F3EB',
    u':professor_pele_clara:': u'\U0001F468\U0001F3FB\U0000200D\U0001F3EB',
    u':professor_pele_morena_clara:': u'\U0001F468\U0001F3FC\U0000200D\U0001F3EB',
    u':professor_pele_morena:': u'\U0001F468\U0001F3FD\U0000200D\U0001F3EB',
    u':professor_pele_morena_escura:': u'\U0001F468\U0001F3FE\U0000200D\U0001F3EB',
    u':professor_pele_escura:': u'\U0001F468\U0001F3FF\U0000200D\U0001F3EB',
    u':professora:': u'\U0001F469\U0000200D\U0001F3EB',
    u':professora_pele_clara:': u'\U0001F469\U0001F3FB\U0000200D\U0001F3EB',
    u':professora_pele_morena_clara:': u'\U0001F469\U0001F3FC\U0000200D\U0001F3EB',
    u':professora_pele_morena:': u'\U0001F469\U0001F3FD\U0000200D\U0001F3EB',
    u':professora_pele_morena_escura:': u'\U0001F469\U0001F3FE\U0000200D\U0001F3EB',
    u':professora_pele_escura:': u'\U0001F469\U0001F3FF\U0000200D\U0001F3EB',
    u':juiz_no_tribunal:': u'\U0001F9D1\U0000200D\U00002696\U0000FE0F',
    u':juiz_no_tribunal_pele_clara:': u'\U0001F9D1\U0001F3FB\U0000200D\U00002696\U0000FE0F',
    u':juiz_no_tribunal_pele_morena_clara:': u'\U0001F9D1\U0001F3FC\U0000200D\U00002696\U0000FE0F',
    u':juiz_no_tribunal_pele_morena:': u'\U0001F9D1\U0001F3FD\U0000200D\U00002696\U0000FE0F',
    u':juiz_no_tribunal_pele_morena_escura:': u'\U0001F9D1\U0001F3FE\U0000200D\U00002696\U0000FE0F',
    u':juiz_no_tribunal_pele_escura:': u'\U0001F9D1\U0001F3FF\U0000200D\U00002696\U0000FE0F',
    u':juiz:': u'\U0001F468\U0000200D\U00002696\U0000FE0F',
    u':juiz_pele_clara:': u'\U0001F468\U0001F3FB\U0000200D\U00002696\U0000FE0F',
    u':juiz_pele_morena_clara:': u'\U0001F468\U0001F3FC\U0000200D\U00002696\U0000FE0F',
    u':juiz_pele_morena:': u'\U0001F468\U0001F3FD\U0000200D\U00002696\U0000FE0F',
    u':juiz_pele_morena_escura:': u'\U0001F468\U0001F3FE\U0000200D\U00002696\U0000FE0F',
    u':juiz_pele_escura:': u'\U0001F468\U0001F3FF\U0000200D\U00002696\U0000FE0F',
    u':juíza:': u'\U0001F469\U0000200D\U00002696\U0000FE0F',
    u':juíza_pele_clara:': u'\U0001F469\U0001F3FB\U0000200D\U00002696\U0000FE0F',
    u':juíza_pele_morena_clara:': u'\U0001F469\U0001F3FC\U0000200D\U00002696\U0000FE0F',
    u':juíza_pele_morena:': u'\U0001F469\U0001F3FD\U0000200D\U00002696\U0000FE0F',
    u':juíza_pele_morena_escura:': u'\U0001F469\U0001F3FE\U0000200D\U00002696\U0000FE0F',
    u':juíza_pele_escura:': u'\U0001F469\U0001F3FF\U0000200D\U00002696\U0000FE0F',
    u':agricultor:': u'\U0001F9D1\U0000200D\U0001F33E',
    u':agricultor_pele_clara:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F33E',
    u':agricultor_pele_morena_clara:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F33E',
    u':agricultor_pele_morena:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F33E',
    u':agricultor_pele_morena_escura:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F33E',
    u':agricultor_pele_escura:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F33E',
    u':fazendeiro:': u'\U0001F468\U0000200D\U0001F33E',
    u':fazendeiro_pele_clara:': u'\U0001F468\U0001F3FB\U0000200D\U0001F33E',
    u':fazendeiro_pele_morena_clara:': u'\U0001F468\U0001F3FC\U0000200D\U0001F33E',
    u':fazendeiro_pele_morena:': u'\U0001F468\U0001F3FD\U0000200D\U0001F33E',
    u':fazendeiro_pele_morena_escura:': u'\U0001F468\U0001F3FE\U0000200D\U0001F33E',
    u':fazendeiro_pele_escura:': u'\U0001F468\U0001F3FF\U0000200D\U0001F33E',
    u':fazendeira:': u'\U0001F469\U0000200D\U0001F33E',
    u':fazendeira_pele_clara:': u'\U0001F469\U0001F3FB\U0000200D\U0001F33E',
    u':fazendeira_pele_morena_clara:': u'\U0001F469\U0001F3FC\U0000200D\U0001F33E',
    u':fazendeira_pele_morena:': u'\U0001F469\U0001F3FD\U0000200D\U0001F33E',
    u':fazendeira_pele_morena_escura:': u'\U0001F469\U0001F3FE\U0000200D\U0001F33E',
    u':fazendeira_pele_escura:': u'\U0001F469\U0001F3FF\U0000200D\U0001F33E',
    u':chef_de_cozinha:': u'\U0001F9D1\U0000200D\U0001F373',
    u':chef_de_cozinha_pele_clara:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F373',
    u':chef_de_cozinha_pele_morena_clara:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F373',
    u':chef_de_cozinha_pele_morena:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F373',
    u':chef_de_cozinha_pele_morena_escura:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F373',
    u':chef_de_cozinha_pele_escura:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F373',
    u':cozinheiro:': u'\U0001F468\U0000200D\U0001F373',
    u':cozinheiro_pele_clara:': u'\U0001F468\U0001F3FB\U0000200D\U0001F373',
    u':cozinheiro_pele_morena_clara:': u'\U0001F468\U0001F3FC\U0000200D\U0001F373',
    u':cozinheiro_pele_morena:': u'\U0001F468\U0001F3FD\U0000200D\U0001F373',
    u':cozinheiro_pele_morena_escura:': u'\U0001F468\U0001F3FE\U0000200D\U0001F373',
    u':cozinheiro_pele_escura:': u'\U0001F468\U0001F3FF\U0000200D\U0001F373',
    u':cozinheira:': u'\U0001F469\U0000200D\U0001F373',
    u':cozinheira_pele_clara:': u'\U0001F469\U0001F3FB\U0000200D\U0001F373',
    u':cozinheira_pele_morena_clara:': u'\U0001F469\U0001F3FC\U0000200D\U0001F373',
    u':cozinheira_pele_morena:': u'\U0001F469\U0001F3FD\U0000200D\U0001F373',
    u':cozinheira_pele_morena_escura:': u'\U0001F469\U0001F3FE\U0000200D\U0001F373',
    u':cozinheira_pele_escura:': u'\U0001F469\U0001F3FF\U0000200D\U0001F373',
    u':mecânico_trabalhando:': u'\U0001F9D1\U0000200D\U0001F527',
    u':mecânico_trabalhando_pele_clara:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F527',
    u':mecânico_trabalhando_pele_morena_clara:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F527',
    u':mecânico_trabalhando_pele_morena:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F527',
    u':mecânico_trabalhando_pele_morena_escura:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F527',
    u':mecânico_trabalhando_pele_escura:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F527',
    u':mecânico:': u'\U0001F468\U0000200D\U0001F527',
    u':mecânico_pele_clara:': u'\U0001F468\U0001F3FB\U0000200D\U0001F527',
    u':mecânico_pele_morena_clara:': u'\U0001F468\U0001F3FC\U0000200D\U0001F527',
    u':mecânico_pele_morena:': u'\U0001F468\U0001F3FD\U0000200D\U0001F527',
    u':mecânico_pele_morena_escura:': u'\U0001F468\U0001F3FE\U0000200D\U0001F527',
    u':mecânico_pele_escura:': u'\U0001F468\U0001F3FF\U0000200D\U0001F527',
    u':mecânica:': u'\U0001F469\U0000200D\U0001F527',
    u':mecânica_pele_clara:': u'\U0001F469\U0001F3FB\U0000200D\U0001F527',
    u':mecânica_pele_morena_clara:': u'\U0001F469\U0001F3FC\U0000200D\U0001F527',
    u':mecânica_pele_morena:': u'\U0001F469\U0001F3FD\U0000200D\U0001F527',
    u':mecânica_pele_morena_escura:': u'\U0001F469\U0001F3FE\U0000200D\U0001F527',
    u':mecânica_pele_escura:': u'\U0001F469\U0001F3FF\U0000200D\U0001F527',
    u':funcionário_de_fábrica:': u'\U0001F9D1\U0000200D\U0001F3ED',
    u':funcionário_de_fábrica_pele_clara:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F3ED',
    u':funcionário_de_fábrica_pele_morena_clara:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F3ED',
    u':funcionário_de_fábrica_pele_morena:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F3ED',
    u':funcionário_de_fábrica_pele_morena_escura:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F3ED',
    u':funcionário_de_fábrica_pele_escura:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F3ED',
    u':operário:': u'\U0001F468\U0000200D\U0001F3ED',
    u':operário_pele_clara:': u'\U0001F468\U0001F3FB\U0000200D\U0001F3ED',
    u':operário_pele_morena_clara:': u'\U0001F468\U0001F3FC\U0000200D\U0001F3ED',
    u':operário_pele_morena:': u'\U0001F468\U0001F3FD\U0000200D\U0001F3ED',
    u':operário_pele_morena_escura:': u'\U0001F468\U0001F3FE\U0000200D\U0001F3ED',
    u':operário_pele_escura:': u'\U0001F468\U0001F3FF\U0000200D\U0001F3ED',
    u':operária:': u'\U0001F469\U0000200D\U0001F3ED',
    u':operária_pele_clara:': u'\U0001F469\U0001F3FB\U0000200D\U0001F3ED',
    u':operária_pele_morena_clara:': u'\U0001F469\U0001F3FC\U0000200D\U0001F3ED',
    u':operária_pele_morena:': u'\U0001F469\U0001F3FD\U0000200D\U0001F3ED',
    u':operária_pele_morena_escura:': u'\U0001F469\U0001F3FE\U0000200D\U0001F3ED',
    u':operária_pele_escura:': u'\U0001F469\U0001F3FF\U0000200D\U0001F3ED',
    u':trabalhador_de_escritório:': u'\U0001F9D1\U0000200D\U0001F4BC',
    u':trabalhador_de_escritório_pele_clara:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F4BC',
    u':trabalhador_de_escritório_pele_morena_clara:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F4BC',
    u':trabalhador_de_escritório_pele_morena:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F4BC',
    u':trabalhador_de_escritório_pele_morena_escura:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F4BC',
    u':trabalhador_de_escritório_pele_escura:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F4BC',
    u':funcionário_de_escritório:': u'\U0001F468\U0000200D\U0001F4BC',
    u':funcionário_de_escritório_pele_clara:': u'\U0001F468\U0001F3FB\U0000200D\U0001F4BC',
    u':funcionário_de_escritório_pele_morena_clara:': u'\U0001F468\U0001F3FC\U0000200D\U0001F4BC',
    u':funcionário_de_escritório_pele_morena:': u'\U0001F468\U0001F3FD\U0000200D\U0001F4BC',
    u':funcionário_de_escritório_pele_morena_escura:': u'\U0001F468\U0001F3FE\U0000200D\U0001F4BC',
    u':funcionário_de_escritório_pele_escura:': u'\U0001F468\U0001F3FF\U0000200D\U0001F4BC',
    u':funcionária_de_escritório:': u'\U0001F469\U0000200D\U0001F4BC',
    u':funcionária_de_escritório_pele_clara:': u'\U0001F469\U0001F3FB\U0000200D\U0001F4BC',
    u':funcionária_de_escritório_pele_morena_clara:': u'\U0001F469\U0001F3FC\U0000200D\U0001F4BC',
    u':funcionária_de_escritório_pele_morena:': u'\U0001F469\U0001F3FD\U0000200D\U0001F4BC',
    u':funcionária_de_escritório_pele_morena_escura:': u'\U0001F469\U0001F3FE\U0000200D\U0001F4BC',
    u':funcionária_de_escritório_pele_escura:': u'\U0001F469\U0001F3FF\U0000200D\U0001F4BC',
    u':cientista:': u'\U0001F9D1\U0000200D\U0001F52C',
    u':cientista_pele_clara:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F52C',
    u':cientista_pele_morena_clara:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F52C',
    u':cientista_pele_morena:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F52C',
    u':cientista_pele_morena_escura:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F52C',
    u':cientista_pele_escura:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F52C',
    u':cientista_homem:': u'\U0001F468\U0000200D\U0001F52C',
    u':cientista_homem_pele_clara:': u'\U0001F468\U0001F3FB\U0000200D\U0001F52C',
    u':cientista_homem_pele_morena_clara:': u'\U0001F468\U0001F3FC\U0000200D\U0001F52C',
    u':cientista_homem_pele_morena:': u'\U0001F468\U0001F3FD\U0000200D\U0001F52C',
    u':cientista_homem_pele_morena_escura:': u'\U0001F468\U0001F3FE\U0000200D\U0001F52C',
    u':cientista_homem_pele_escura:': u'\U0001F468\U0001F3FF\U0000200D\U0001F52C',
    u':cientista_mulher:': u'\U0001F469\U0000200D\U0001F52C',
    u':cientista_mulher_pele_clara:': u'\U0001F469\U0001F3FB\U0000200D\U0001F52C',
    u':cientista_mulher_pele_morena_clara:': u'\U0001F469\U0001F3FC\U0000200D\U0001F52C',
    u':cientista_mulher_pele_morena:': u'\U0001F469\U0001F3FD\U0000200D\U0001F52C',
    u':cientista_mulher_pele_morena_escura:': u'\U0001F469\U0001F3FE\U0000200D\U0001F52C',
    u':cientista_mulher_pele_escura:': u'\U0001F469\U0001F3FF\U0000200D\U0001F52C',
    u':programador:': u'\U0001F9D1\U0000200D\U0001F4BB',
    u':programador_pele_clara:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F4BB',
    u':programador_pele_morena_clara:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F4BB',
    u':programador_pele_morena:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F4BB',
    u':programador_pele_morena_escura:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F4BB',
    u':programador_pele_escura:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F4BB',
    u':tecnólogo:': u'\U0001F468\U0000200D\U0001F4BB',
    u':tecnólogo_pele_clara:': u'\U0001F468\U0001F3FB\U0000200D\U0001F4BB',
    u':tecnólogo_pele_morena_clara:': u'\U0001F468\U0001F3FC\U0000200D\U0001F4BB',
    u':tecnólogo_pele_morena:': u'\U0001F468\U0001F3FD\U0000200D\U0001F4BB',
    u':tecnólogo_pele_morena_escura:': u'\U0001F468\U0001F3FE\U0000200D\U0001F4BB',
    u':tecnólogo_pele_escura:': u'\U0001F468\U0001F3FF\U0000200D\U0001F4BB',
    u':tecnóloga:': u'\U0001F469\U0000200D\U0001F4BB',
    u':tecnóloga_pele_clara:': u'\U0001F469\U0001F3FB\U0000200D\U0001F4BB',
    u':tecnóloga_pele_morena_clara:': u'\U0001F469\U0001F3FC\U0000200D\U0001F4BB',
    u':tecnóloga_pele_morena:': u'\U0001F469\U0001F3FD\U0000200D\U0001F4BB',
    u':tecnóloga_pele_morena_escura:': u'\U0001F469\U0001F3FE\U0000200D\U0001F4BB',
    u':tecnóloga_pele_escura:': u'\U0001F469\U0001F3FF\U0000200D\U0001F4BB',
    u':cantor:': u'\U0001F9D1\U0000200D\U0001F3A4',
    u':cantor_pele_clara:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F3A4',
    u':cantor_pele_morena_clara:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F3A4',
    u':cantor_pele_morena:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F3A4',
    u':cantor_pele_morena_escura:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F3A4',
    u':cantor_pele_escura:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F3A4',
    u':cantor_homem:': u'\U0001F468\U0000200D\U0001F3A4',
    u':cantor_homem_pele_clara:': u'\U0001F468\U0001F3FB\U0000200D\U0001F3A4',
    u':cantor_homem_pele_morena_clara:': u'\U0001F468\U0001F3FC\U0000200D\U0001F3A4',
    u':cantor_homem_pele_morena:': u'\U0001F468\U0001F3FD\U0000200D\U0001F3A4',
    u':cantor_homem_pele_morena_escura:': u'\U0001F468\U0001F3FE\U0000200D\U0001F3A4',
    u':cantor_homem_pele_escura:': u'\U0001F468\U0001F3FF\U0000200D\U0001F3A4',
    u':cantora:': u'\U0001F469\U0000200D\U0001F3A4',
    u':cantora_pele_clara:': u'\U0001F469\U0001F3FB\U0000200D\U0001F3A4',
    u':cantora_pele_morena_clara:': u'\U0001F469\U0001F3FC\U0000200D\U0001F3A4',
    u':cantora_pele_morena:': u'\U0001F469\U0001F3FD\U0000200D\U0001F3A4',
    u':cantora_pele_morena_escura:': u'\U0001F469\U0001F3FE\U0000200D\U0001F3A4',
    u':cantora_pele_escura:': u'\U0001F469\U0001F3FF\U0000200D\U0001F3A4',
    u':artista:': u'\U0001F9D1\U0000200D\U0001F3A8',
    u':artista_pele_clara:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F3A8',
    u':artista_pele_morena_clara:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F3A8',
    u':artista_pele_morena:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F3A8',
    u':artista_pele_morena_escura:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F3A8',
    u':artista_pele_escura:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F3A8',
    u':artista_plástico:': u'\U0001F468\U0000200D\U0001F3A8',
    u':artista_plástico_pele_clara:': u'\U0001F468\U0001F3FB\U0000200D\U0001F3A8',
    u':artista_plástico_pele_morena_clara:': u'\U0001F468\U0001F3FC\U0000200D\U0001F3A8',
    u':artista_plástico_pele_morena:': u'\U0001F468\U0001F3FD\U0000200D\U0001F3A8',
    u':artista_plástico_pele_morena_escura:': u'\U0001F468\U0001F3FE\U0000200D\U0001F3A8',
    u':artista_plástico_pele_escura:': u'\U0001F468\U0001F3FF\U0000200D\U0001F3A8',
    u':artista_plástica:': u'\U0001F469\U0000200D\U0001F3A8',
    u':artista_plástica_pele_clara:': u'\U0001F469\U0001F3FB\U0000200D\U0001F3A8',
    u':artista_plástica_pele_morena_clara:': u'\U0001F469\U0001F3FC\U0000200D\U0001F3A8',
    u':artista_plástica_pele_morena:': u'\U0001F469\U0001F3FD\U0000200D\U0001F3A8',
    u':artista_plástica_pele_morena_escura:': u'\U0001F469\U0001F3FE\U0000200D\U0001F3A8',
    u':artista_plástica_pele_escura:': u'\U0001F469\U0001F3FF\U0000200D\U0001F3A8',
    u':piloto:': u'\U0001F9D1\U0000200D\U00002708\U0000FE0F',
    u':piloto_pele_clara:': u'\U0001F9D1\U0001F3FB\U0000200D\U00002708\U0000FE0F',
    u':piloto_pele_morena_clara:': u'\U0001F9D1\U0001F3FC\U0000200D\U00002708\U0000FE0F',
    u':piloto_pele_morena:': u'\U0001F9D1\U0001F3FD\U0000200D\U00002708\U0000FE0F',
    u':piloto_pele_morena_escura:': u'\U0001F9D1\U0001F3FE\U0000200D\U00002708\U0000FE0F',
    u':piloto_pele_escura:': u'\U0001F9D1\U0001F3FF\U0000200D\U00002708\U0000FE0F',
    u':piloto_de_avião_homem:': u'\U0001F468\U0000200D\U00002708\U0000FE0F',
    u':piloto_de_avião_homem_pele_clara:': u'\U0001F468\U0001F3FB\U0000200D\U00002708\U0000FE0F',
    u':piloto_de_avião_homem_pele_morena_clara:': u'\U0001F468\U0001F3FC\U0000200D\U00002708\U0000FE0F',
    u':piloto_de_avião_homem_pele_morena:': u'\U0001F468\U0001F3FD\U0000200D\U00002708\U0000FE0F',
    u':piloto_de_avião_homem_pele_morena_escura:': u'\U0001F468\U0001F3FE\U0000200D\U00002708\U0000FE0F',
    u':piloto_de_avião_homem_pele_escura:': u'\U0001F468\U0001F3FF\U0000200D\U00002708\U0000FE0F',
    u':piloto_de_avião_mulher:': u'\U0001F469\U0000200D\U00002708\U0000FE0F',
    u':piloto_de_avião_mulher_pele_clara:': u'\U0001F469\U0001F3FB\U0000200D\U00002708\U0000FE0F',
    u':piloto_de_avião_mulher_pele_morena_clara:': u'\U0001F469\U0001F3FC\U0000200D\U00002708\U0000FE0F',
    u':piloto_de_avião_mulher_pele_morena:': u'\U0001F469\U0001F3FD\U0000200D\U00002708\U0000FE0F',
    u':piloto_de_avião_mulher_pele_morena_escura:': u'\U0001F469\U0001F3FE\U0000200D\U00002708\U0000FE0F',
    u':piloto_de_avião_mulher_pele_escura:': u'\U0001F469\U0001F3FF\U0000200D\U00002708\U0000FE0F',
    u':astronauta:': u'\U0001F9D1\U0000200D\U0001F680',
    u':astronauta_pele_clara:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F680',
    u':astronauta_pele_morena_clara:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F680',
    u':astronauta_pele_morena:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F680',
    u':astronauta_pele_morena_escura:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F680',
    u':astronauta_pele_escura:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F680',
    u':astronauta_homem:': u'\U0001F468\U0000200D\U0001F680',
    u':astronauta_homem_pele_clara:': u'\U0001F468\U0001F3FB\U0000200D\U0001F680',
    u':astronauta_homem_pele_morena_clara:': u'\U0001F468\U0001F3FC\U0000200D\U0001F680',
    u':astronauta_homem_pele_morena:': u'\U0001F468\U0001F3FD\U0000200D\U0001F680',
    u':astronauta_homem_pele_morena_escura:': u'\U0001F468\U0001F3FE\U0000200D\U0001F680',
    u':astronauta_homem_pele_escura:': u'\U0001F468\U0001F3FF\U0000200D\U0001F680',
    u':astronauta_mulher:': u'\U0001F469\U0000200D\U0001F680',
    u':astronauta_mulher_pele_clara:': u'\U0001F469\U0001F3FB\U0000200D\U0001F680',
    u':astronauta_mulher_pele_morena_clara:': u'\U0001F469\U0001F3FC\U0000200D\U0001F680',
    u':astronauta_mulher_pele_morena:': u'\U0001F469\U0001F3FD\U0000200D\U0001F680',
    u':astronauta_mulher_pele_morena_escura:': u'\U0001F469\U0001F3FE\U0000200D\U0001F680',
    u':astronauta_mulher_pele_escura:': u'\U0001F469\U0001F3FF\U0000200D\U0001F680',
    u':bombeiro:': u'\U0001F9D1\U0000200D\U0001F692',
    u':bombeiro_pele_clara:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F692',
    u':bombeiro_pele_morena_clara:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F692',
    u':bombeiro_pele_morena:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F692',
    u':bombeiro_pele_morena_escura:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F692',
    u':bombeiro_pele_escura:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F692',
    u':bombeiro_homem:': u'\U0001F468\U0000200D\U0001F692',
    u':bombeiro_homem_pele_clara:': u'\U0001F468\U0001F3FB\U0000200D\U0001F692',
    u':bombeiro_homem_pele_morena_clara:': u'\U0001F468\U0001F3FC\U0000200D\U0001F692',
    u':bombeiro_homem_pele_morena:': u'\U0001F468\U0001F3FD\U0000200D\U0001F692',
    u':bombeiro_homem_pele_morena_escura:': u'\U0001F468\U0001F3FE\U0000200D\U0001F692',
    u':bombeiro_homem_pele_escura:': u'\U0001F468\U0001F3FF\U0000200D\U0001F692',
    u':bombeira:': u'\U0001F469\U0000200D\U0001F692',
    u':bombeira_pele_clara:': u'\U0001F469\U0001F3FB\U0000200D\U0001F692',
    u':bombeira_pele_morena_clara:': u'\U0001F469\U0001F3FC\U0000200D\U0001F692',
    u':bombeira_pele_morena:': u'\U0001F469\U0001F3FD\U0000200D\U0001F692',
    u':bombeira_pele_morena_escura:': u'\U0001F469\U0001F3FE\U0000200D\U0001F692',
    u':bombeira_pele_escura:': u'\U0001F469\U0001F3FF\U0000200D\U0001F692',
    u':policial:': u'\U0001F46E',
    u':policial_pele_clara:': u'\U0001F46E\U0001F3FB',
    u':policial_pele_morena_clara:': u'\U0001F46E\U0001F3FC',
    u':policial_pele_morena:': u'\U0001F46E\U0001F3FD',
    u':policial_pele_morena_escura:': u'\U0001F46E\U0001F3FE',
    u':policial_pele_escura:': u'\U0001F46E\U0001F3FF',
    u':policial_homem:': u'\U0001F46E\U0000200D\U00002642\U0000FE0F',
    u':policial_homem_pele_clara:': u'\U0001F46E\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':policial_homem_pele_morena_clara:': u'\U0001F46E\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':policial_homem_pele_morena:': u'\U0001F46E\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':policial_homem_pele_morena_escura:': u'\U0001F46E\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':policial_homem_pele_escura:': u'\U0001F46E\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':policial_mulher:': u'\U0001F46E\U0000200D\U00002640\U0000FE0F',
    u':policial_mulher_pele_clara:': u'\U0001F46E\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':policial_mulher_pele_morena_clara:': u'\U0001F46E\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':policial_mulher_pele_morena:': u'\U0001F46E\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':policial_mulher_pele_morena_escura:': u'\U0001F46E\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':policial_mulher_pele_escura:': u'\U0001F46E\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':detetive:': u'\U0001F575\U0000FE0F',
    u':detetive_pele_clara:': u'\U0001F575\U0001F3FB',
    u':detetive_pele_morena_clara:': u'\U0001F575\U0001F3FC',
    u':detetive_pele_morena:': u'\U0001F575\U0001F3FD',
    u':detetive_pele_morena_escura:': u'\U0001F575\U0001F3FE',
    u':detetive_pele_escura:': u'\U0001F575\U0001F3FF',
    u':detetive_homem:': u'\U0001F575\U0000FE0F\U0000200D\U00002642\U0000FE0F',
    u':detetive_homem_pele_clara:': u'\U0001F575\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':detetive_homem_pele_morena_clara:': u'\U0001F575\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':detetive_homem_pele_morena:': u'\U0001F575\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':detetive_homem_pele_morena_escura:': u'\U0001F575\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':detetive_homem_pele_escura:': u'\U0001F575\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':detetive_mulher:': u'\U0001F575\U0000FE0F\U0000200D\U00002640\U0000FE0F',
    u':detetive_mulher_pele_clara:': u'\U0001F575\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':detetive_mulher_pele_morena_clara:': u'\U0001F575\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':detetive_mulher_pele_morena:': u'\U0001F575\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':detetive_mulher_pele_morena_escura:': u'\U0001F575\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':detetive_mulher_pele_escura:': u'\U0001F575\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':guarda:': u'\U0001F482',
    u':guarda_pele_clara:': u'\U0001F482\U0001F3FB',
    u':guarda_pele_morena_clara:': u'\U0001F482\U0001F3FC',
    u':guarda_pele_morena:': u'\U0001F482\U0001F3FD',
    u':guarda_pele_morena_escura:': u'\U0001F482\U0001F3FE',
    u':guarda_pele_escura:': u'\U0001F482\U0001F3FF',
    u':guarda_homem:': u'\U0001F482\U0000200D\U00002642\U0000FE0F',
    u':guarda_homem_pele_clara:': u'\U0001F482\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':guarda_homem_pele_morena_clara:': u'\U0001F482\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':guarda_homem_pele_morena:': u'\U0001F482\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':guarda_homem_pele_morena_escura:': u'\U0001F482\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':guarda_homem_pele_escura:': u'\U0001F482\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':guarda_mulher:': u'\U0001F482\U0000200D\U00002640\U0000FE0F',
    u':guarda_mulher_pele_clara:': u'\U0001F482\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':guarda_mulher_pele_morena_clara:': u'\U0001F482\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':guarda_mulher_pele_morena:': u'\U0001F482\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':guarda_mulher_pele_morena_escura:': u'\U0001F482\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':guarda_mulher_pele_escura:': u'\U0001F482\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':ninja:': u'\U0001F977',
    u':ninja_pele_clara:': u'\U0001F977\U0001F3FB',
    u':ninja_pele_morena_clara:': u'\U0001F977\U0001F3FC',
    u':ninja_pele_morena:': u'\U0001F977\U0001F3FD',
    u':ninja_pele_morena_escura:': u'\U0001F977\U0001F3FE',
    u':ninja_pele_escura:': u'\U0001F977\U0001F3FF',
    u':trabalhador_de_construção_civil:': u'\U0001F477',
    u':trabalhador_de_construção_civil_pele_clara:': u'\U0001F477\U0001F3FB',
    u':trabalhador_de_construção_civil_pele_morena_clara:': u'\U0001F477\U0001F3FC',
    u':trabalhador_de_construção_civil_pele_morena:': u'\U0001F477\U0001F3FD',
    u':trabalhador_de_construção_civil_pele_morena_escura:': u'\U0001F477\U0001F3FE',
    u':trabalhador_de_construção_civil_pele_escura:': u'\U0001F477\U0001F3FF',
    u':pedreiro:': u'\U0001F477\U0000200D\U00002642\U0000FE0F',
    u':pedreiro_pele_clara:': u'\U0001F477\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':pedreiro_pele_morena_clara:': u'\U0001F477\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':pedreiro_pele_morena:': u'\U0001F477\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':pedreiro_pele_morena_escura:': u'\U0001F477\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':pedreiro_pele_escura:': u'\U0001F477\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':pedreira:': u'\U0001F477\U0000200D\U00002640\U0000FE0F',
    u':pedreira_pele_clara:': u'\U0001F477\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':pedreira_pele_morena_clara:': u'\U0001F477\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':pedreira_pele_morena:': u'\U0001F477\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':pedreira_pele_morena_escura:': u'\U0001F477\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':pedreira_pele_escura:': u'\U0001F477\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':príncipe:': u'\U0001F934',
    u':príncipe_pele_clara:': u'\U0001F934\U0001F3FB',
    u':príncipe_pele_morena_clara:': u'\U0001F934\U0001F3FC',
    u':príncipe_pele_morena:': u'\U0001F934\U0001F3FD',
    u':príncipe_pele_morena_escura:': u'\U0001F934\U0001F3FE',
    u':príncipe_pele_escura:': u'\U0001F934\U0001F3FF',
    u':princesa:': u'\U0001F478',
    u':princesa_pele_clara:': u'\U0001F478\U0001F3FB',
    u':princesa_pele_morena_clara:': u'\U0001F478\U0001F3FC',
    u':princesa_pele_morena:': u'\U0001F478\U0001F3FD',
    u':princesa_pele_morena_escura:': u'\U0001F478\U0001F3FE',
    u':princesa_pele_escura:': u'\U0001F478\U0001F3FF',
    u':pessoa_com_turbante:': u'\U0001F473',
    u':pessoa_com_turbante_pele_clara:': u'\U0001F473\U0001F3FB',
    u':pessoa_com_turbante_pele_morena_clara:': u'\U0001F473\U0001F3FC',
    u':pessoa_com_turbante_pele_morena:': u'\U0001F473\U0001F3FD',
    u':pessoa_com_turbante_pele_morena_escura:': u'\U0001F473\U0001F3FE',
    u':pessoa_com_turbante_pele_escura:': u'\U0001F473\U0001F3FF',
    u':homem_com_turbante:': u'\U0001F473\U0000200D\U00002642\U0000FE0F',
    u':homem_com_turbante_pele_clara:': u'\U0001F473\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homem_com_turbante_pele_morena_clara:': u'\U0001F473\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homem_com_turbante_pele_morena:': u'\U0001F473\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homem_com_turbante_pele_morena_escura:': u'\U0001F473\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homem_com_turbante_pele_escura:': u'\U0001F473\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mulher_com_turbante:': u'\U0001F473\U0000200D\U00002640\U0000FE0F',
    u':mulher_com_turbante_pele_clara:': u'\U0001F473\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mulher_com_turbante_pele_morena_clara:': u'\U0001F473\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mulher_com_turbante_pele_morena:': u'\U0001F473\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mulher_com_turbante_pele_morena_escura:': u'\U0001F473\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mulher_com_turbante_pele_escura:': u'\U0001F473\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':homem_de_boné:': u'\U0001F472',
    u':homem_de_boné_pele_clara:': u'\U0001F472\U0001F3FB',
    u':homem_de_boné_pele_morena_clara:': u'\U0001F472\U0001F3FC',
    u':homem_de_boné_pele_morena:': u'\U0001F472\U0001F3FD',
    u':homem_de_boné_pele_morena_escura:': u'\U0001F472\U0001F3FE',
    u':homem_de_boné_pele_escura:': u'\U0001F472\U0001F3FF',
    u':mulher_com_véu:': u'\U0001F9D5',
    u':mulher_com_véu_pele_clara:': u'\U0001F9D5\U0001F3FB',
    u':mulher_com_véu_pele_morena_clara:': u'\U0001F9D5\U0001F3FC',
    u':mulher_com_véu_pele_morena:': u'\U0001F9D5\U0001F3FD',
    u':mulher_com_véu_pele_morena_escura:': u'\U0001F9D5\U0001F3FE',
    u':mulher_com_véu_pele_escura:': u'\U0001F9D5\U0001F3FF',
    u':pessoa_de_smoking:': u'\U0001F935',
    u':pessoa_de_smoking_pele_clara:': u'\U0001F935\U0001F3FB',
    u':pessoa_de_smoking_pele_morena_clara:': u'\U0001F935\U0001F3FC',
    u':pessoa_de_smoking_pele_morena:': u'\U0001F935\U0001F3FD',
    u':pessoa_de_smoking_pele_morena_escura:': u'\U0001F935\U0001F3FE',
    u':pessoa_de_smoking_pele_escura:': u'\U0001F935\U0001F3FF',
    u':homem_de_smoking:': u'\U0001F935\U0000200D\U00002642\U0000FE0F',
    u':homem_de_smoking_pele_clara:': u'\U0001F935\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homem_de_smoking_pele_morena_clara:': u'\U0001F935\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homem_de_smoking_pele_morena:': u'\U0001F935\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homem_de_smoking_pele_morena_escura:': u'\U0001F935\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homem_de_smoking_pele_escura:': u'\U0001F935\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mulher_de_smoking:': u'\U0001F935\U0000200D\U00002640\U0000FE0F',
    u':mulher_de_smoking_pele_clara:': u'\U0001F935\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mulher_de_smoking_pele_morena_clara:': u'\U0001F935\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mulher_de_smoking_pele_morena:': u'\U0001F935\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mulher_de_smoking_pele_morena_escura:': u'\U0001F935\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mulher_de_smoking_pele_escura:': u'\U0001F935\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':noiva:': u'\U0001F470',
    u':noiva_pele_clara:': u'\U0001F470\U0001F3FB',
    u':noiva_pele_morena_clara:': u'\U0001F470\U0001F3FC',
    u':noiva_pele_morena:': u'\U0001F470\U0001F3FD',
    u':noiva_pele_morena_escura:': u'\U0001F470\U0001F3FE',
    u':noiva_pele_escura:': u'\U0001F470\U0001F3FF',
    u':noivo_com_véu:': u'\U0001F470\U0000200D\U00002642\U0000FE0F',
    u':noivo_com_véu_pele_clara:': u'\U0001F470\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':noivo_com_véu_pele_morena_clara:': u'\U0001F470\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':noivo_com_véu_pele_morena:': u'\U0001F470\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':noivo_com_véu_pele_morena_escura:': u'\U0001F470\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':noivo_com_véu_pele_escura:': u'\U0001F470\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':noiva_com_véu:': u'\U0001F470\U0000200D\U00002640\U0000FE0F',
    u':noiva_com_véu_pele_clara:': u'\U0001F470\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':noiva_com_véu_pele_morena_clara:': u'\U0001F470\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':noiva_com_véu_pele_morena:': u'\U0001F470\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':noiva_com_véu_pele_morena_escura:': u'\U0001F470\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':noiva_com_véu_pele_escura:': u'\U0001F470\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':grávida:': u'\U0001F930',
    u':grávida_pele_clara:': u'\U0001F930\U0001F3FB',
    u':grávida_pele_morena_clara:': u'\U0001F930\U0001F3FC',
    u':grávida_pele_morena:': u'\U0001F930\U0001F3FD',
    u':grávida_pele_morena_escura:': u'\U0001F930\U0001F3FE',
    u':grávida_pele_escura:': u'\U0001F930\U0001F3FF',
    u':amamentando:': u'\U0001F931',
    u':amamentando_pele_clara:': u'\U0001F931\U0001F3FB',
    u':amamentando_pele_morena_clara:': u'\U0001F931\U0001F3FC',
    u':amamentando_pele_morena:': u'\U0001F931\U0001F3FD',
    u':amamentando_pele_morena_escura:': u'\U0001F931\U0001F3FE',
    u':amamentando_pele_escura:': u'\U0001F931\U0001F3FF',
    u':mulher_alimentando_bebê:': u'\U0001F469\U0000200D\U0001F37C',
    u':mulher_alimentando_bebê_pele_clara:': u'\U0001F469\U0001F3FB\U0000200D\U0001F37C',
    u':mulher_alimentando_bebê_pele_morena_clara:': u'\U0001F469\U0001F3FC\U0000200D\U0001F37C',
    u':mulher_alimentando_bebê_pele_morena:': u'\U0001F469\U0001F3FD\U0000200D\U0001F37C',
    u':mulher_alimentando_bebê_pele_morena_escura:': u'\U0001F469\U0001F3FE\U0000200D\U0001F37C',
    u':mulher_alimentando_bebê_pele_escura:': u'\U0001F469\U0001F3FF\U0000200D\U0001F37C',
    u':homem_alimentando_bebê:': u'\U0001F468\U0000200D\U0001F37C',
    u':homem_alimentando_bebê_pele_clara:': u'\U0001F468\U0001F3FB\U0000200D\U0001F37C',
    u':homem_alimentando_bebê_pele_morena_clara:': u'\U0001F468\U0001F3FC\U0000200D\U0001F37C',
    u':homem_alimentando_bebê_pele_morena:': u'\U0001F468\U0001F3FD\U0000200D\U0001F37C',
    u':homem_alimentando_bebê_pele_morena_escura:': u'\U0001F468\U0001F3FE\U0000200D\U0001F37C',
    u':homem_alimentando_bebê_pele_escura:': u'\U0001F468\U0001F3FF\U0000200D\U0001F37C',
    u':pessoa_alimentando_bebê:': u'\U0001F9D1\U0000200D\U0001F37C',
    u':pessoa_alimentando_bebê_pele_clara:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F37C',
    u':pessoa_alimentando_bebê_pele_morena_clara:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F37C',
    u':pessoa_alimentando_bebê_pele_morena:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F37C',
    u':pessoa_alimentando_bebê_pele_morena_escura:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F37C',
    u':pessoa_alimentando_bebê_pele_escura:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F37C',
    u':bebê_anjo:': u'\U0001F47C',
    u':bebê_anjo_pele_clara:': u'\U0001F47C\U0001F3FB',
    u':bebê_anjo_pele_morena_clara:': u'\U0001F47C\U0001F3FC',
    u':bebê_anjo_pele_morena:': u'\U0001F47C\U0001F3FD',
    u':bebê_anjo_pele_morena_escura:': u'\U0001F47C\U0001F3FE',
    u':bebê_anjo_pele_escura:': u'\U0001F47C\U0001F3FF',
    u':papai_noel:': u'\U0001F385',
    u':papai_noel_pele_clara:': u'\U0001F385\U0001F3FB',
    u':papai_noel_pele_morena_clara:': u'\U0001F385\U0001F3FC',
    u':papai_noel_pele_morena:': u'\U0001F385\U0001F3FD',
    u':papai_noel_pele_morena_escura:': u'\U0001F385\U0001F3FE',
    u':papai_noel_pele_escura:': u'\U0001F385\U0001F3FF',
    u':mamãe_noel:': u'\U0001F936',
    u':mamãe_noel_pele_clara:': u'\U0001F936\U0001F3FB',
    u':mamãe_noel_pele_morena_clara:': u'\U0001F936\U0001F3FC',
    u':mamãe_noel_pele_morena:': u'\U0001F936\U0001F3FD',
    u':mamãe_noel_pele_morena_escura:': u'\U0001F936\U0001F3FE',
    u':mamãe_noel_pele_escura:': u'\U0001F936\U0001F3FF',
    u':noel:': u'\U0001F9D1\U0000200D\U0001F384',
    u':noel_pele_clara:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F384',
    u':noel_pele_morena_clara:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F384',
    u':noel_pele_morena:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F384',
    u':noel_pele_morena_escura:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F384',
    u':noel_pele_escura:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F384',
    u':super-herói:': u'\U0001F9B8',
    u':super-herói_pele_clara:': u'\U0001F9B8\U0001F3FB',
    u':super-herói_pele_morena_clara:': u'\U0001F9B8\U0001F3FC',
    u':super-herói_pele_morena:': u'\U0001F9B8\U0001F3FD',
    u':super-herói_pele_morena_escura:': u'\U0001F9B8\U0001F3FE',
    u':super-herói_pele_escura:': u'\U0001F9B8\U0001F3FF',
    u':homem_super-herói:': u'\U0001F9B8\U0000200D\U00002642\U0000FE0F',
    u':homem_super-herói_pele_clara:': u'\U0001F9B8\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homem_super-herói_pele_morena_clara:': u'\U0001F9B8\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homem_super-herói_pele_morena:': u'\U0001F9B8\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homem_super-herói_pele_morena_escura:': u'\U0001F9B8\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homem_super-herói_pele_escura:': u'\U0001F9B8\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':super-heroína:': u'\U0001F9B8\U0000200D\U00002640\U0000FE0F',
    u':super-heroína_pele_clara:': u'\U0001F9B8\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':super-heroína_pele_morena_clara:': u'\U0001F9B8\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':super-heroína_pele_morena:': u'\U0001F9B8\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':super-heroína_pele_morena_escura:': u'\U0001F9B8\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':super-heroína_pele_escura:': u'\U0001F9B8\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':supervilão:': u'\U0001F9B9',
    u':supervilão_pele_clara:': u'\U0001F9B9\U0001F3FB',
    u':supervilão_pele_morena_clara:': u'\U0001F9B9\U0001F3FC',
    u':supervilão_pele_morena:': u'\U0001F9B9\U0001F3FD',
    u':supervilão_pele_morena_escura:': u'\U0001F9B9\U0001F3FE',
    u':supervilão_pele_escura:': u'\U0001F9B9\U0001F3FF',
    u':homem_supervilão:': u'\U0001F9B9\U0000200D\U00002642\U0000FE0F',
    u':homem_supervilão_pele_clara:': u'\U0001F9B9\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homem_supervilão_pele_morena_clara:': u'\U0001F9B9\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homem_supervilão_pele_morena:': u'\U0001F9B9\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homem_supervilão_pele_morena_escura:': u'\U0001F9B9\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homem_supervilão_pele_escura:': u'\U0001F9B9\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':supervilã:': u'\U0001F9B9\U0000200D\U00002640\U0000FE0F',
    u':supervilã_pele_clara:': u'\U0001F9B9\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':supervilã_pele_morena_clara:': u'\U0001F9B9\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':supervilã_pele_morena:': u'\U0001F9B9\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':supervilã_pele_morena_escura:': u'\U0001F9B9\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':supervilã_pele_escura:': u'\U0001F9B9\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':mago:': u'\U0001F9D9',
    u':mago_pele_clara:': u'\U0001F9D9\U0001F3FB',
    u':mago_pele_morena_clara:': u'\U0001F9D9\U0001F3FC',
    u':mago_pele_morena:': u'\U0001F9D9\U0001F3FD',
    u':mago_pele_morena_escura:': u'\U0001F9D9\U0001F3FE',
    u':mago_pele_escura:': u'\U0001F9D9\U0001F3FF',
    u':homem_mago:': u'\U0001F9D9\U0000200D\U00002642\U0000FE0F',
    u':homem_mago_pele_clara:': u'\U0001F9D9\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homem_mago_pele_morena_clara:': u'\U0001F9D9\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homem_mago_pele_morena:': u'\U0001F9D9\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homem_mago_pele_morena_escura:': u'\U0001F9D9\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homem_mago_pele_escura:': u'\U0001F9D9\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':maga:': u'\U0001F9D9\U0000200D\U00002640\U0000FE0F',
    u':maga_pele_clara:': u'\U0001F9D9\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':maga_pele_morena_clara:': u'\U0001F9D9\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':maga_pele_morena:': u'\U0001F9D9\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':maga_pele_morena_escura:': u'\U0001F9D9\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':maga_pele_escura:': u'\U0001F9D9\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':fada:': u'\U0001F9DA',
    u':fada_pele_clara:': u'\U0001F9DA\U0001F3FB',
    u':fada_pele_morena_clara:': u'\U0001F9DA\U0001F3FC',
    u':fada_pele_morena:': u'\U0001F9DA\U0001F3FD',
    u':fada_pele_morena_escura:': u'\U0001F9DA\U0001F3FE',
    u':fada_pele_escura:': u'\U0001F9DA\U0001F3FF',
    u':homem_fada:': u'\U0001F9DA\U0000200D\U00002642\U0000FE0F',
    u':homem_fada_pele_clara:': u'\U0001F9DA\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homem_fada_pele_morena_clara:': u'\U0001F9DA\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homem_fada_pele_morena:': u'\U0001F9DA\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homem_fada_pele_morena_escura:': u'\U0001F9DA\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homem_fada_pele_escura:': u'\U0001F9DA\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mulher_fada:': u'\U0001F9DA\U0000200D\U00002640\U0000FE0F',
    u':mulher_fada_pele_clara:': u'\U0001F9DA\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mulher_fada_pele_morena_clara:': u'\U0001F9DA\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mulher_fada_pele_morena:': u'\U0001F9DA\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mulher_fada_pele_morena_escura:': u'\U0001F9DA\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mulher_fada_pele_escura:': u'\U0001F9DA\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':vampiro:': u'\U0001F9DB',
    u':vampiro_pele_clara:': u'\U0001F9DB\U0001F3FB',
    u':vampiro_pele_morena_clara:': u'\U0001F9DB\U0001F3FC',
    u':vampiro_pele_morena:': u'\U0001F9DB\U0001F3FD',
    u':vampiro_pele_morena_escura:': u'\U0001F9DB\U0001F3FE',
    u':vampiro_pele_escura:': u'\U0001F9DB\U0001F3FF',
    u':homem_vampiro:': u'\U0001F9DB\U0000200D\U00002642\U0000FE0F',
    u':homem_vampiro_pele_clara:': u'\U0001F9DB\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homem_vampiro_pele_morena_clara:': u'\U0001F9DB\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homem_vampiro_pele_morena:': u'\U0001F9DB\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homem_vampiro_pele_morena_escura:': u'\U0001F9DB\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homem_vampiro_pele_escura:': u'\U0001F9DB\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mulher_vampira:': u'\U0001F9DB\U0000200D\U00002640\U0000FE0F',
    u':mulher_vampira_pele_clara:': u'\U0001F9DB\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mulher_vampira_pele_morena_clara:': u'\U0001F9DB\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mulher_vampira_pele_morena:': u'\U0001F9DB\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mulher_vampira_pele_morena_escura:': u'\U0001F9DB\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mulher_vampira_pele_escura:': u'\U0001F9DB\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':pessoa_sereia:': u'\U0001F9DC',
    u':pessoa_sereia_pele_clara:': u'\U0001F9DC\U0001F3FB',
    u':pessoa_sereia_pele_morena_clara:': u'\U0001F9DC\U0001F3FC',
    u':pessoa_sereia_pele_morena:': u'\U0001F9DC\U0001F3FD',
    u':pessoa_sereia_pele_morena_escura:': u'\U0001F9DC\U0001F3FE',
    u':pessoa_sereia_pele_escura:': u'\U0001F9DC\U0001F3FF',
    u':sereio:': u'\U0001F9DC\U0000200D\U00002642\U0000FE0F',
    u':sereio_pele_clara:': u'\U0001F9DC\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':sereio_pele_morena_clara:': u'\U0001F9DC\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':sereio_pele_morena:': u'\U0001F9DC\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':sereio_pele_morena_escura:': u'\U0001F9DC\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':sereio_pele_escura:': u'\U0001F9DC\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':sereia:': u'\U0001F9DC\U0000200D\U00002640\U0000FE0F',
    u':sereia_pele_clara:': u'\U0001F9DC\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':sereia_pele_morena_clara:': u'\U0001F9DC\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':sereia_pele_morena:': u'\U0001F9DC\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':sereia_pele_morena_escura:': u'\U0001F9DC\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':sereia_pele_escura:': u'\U0001F9DC\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':elfo:': u'\U0001F9DD',
    u':elfo_pele_clara:': u'\U0001F9DD\U0001F3FB',
    u':elfo_pele_morena_clara:': u'\U0001F9DD\U0001F3FC',
    u':elfo_pele_morena:': u'\U0001F9DD\U0001F3FD',
    u':elfo_pele_morena_escura:': u'\U0001F9DD\U0001F3FE',
    u':elfo_pele_escura:': u'\U0001F9DD\U0001F3FF',
    u':elfo_homem:': u'\U0001F9DD\U0000200D\U00002642\U0000FE0F',
    u':elfo_homem_pele_clara:': u'\U0001F9DD\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':elfo_homem_pele_morena_clara:': u'\U0001F9DD\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':elfo_homem_pele_morena:': u'\U0001F9DD\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':elfo_homem_pele_morena_escura:': u'\U0001F9DD\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':elfo_homem_pele_escura:': u'\U0001F9DD\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':elfa:': u'\U0001F9DD\U0000200D\U00002640\U0000FE0F',
    u':elfa_pele_clara:': u'\U0001F9DD\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':elfa_pele_morena_clara:': u'\U0001F9DD\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':elfa_pele_morena:': u'\U0001F9DD\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':elfa_pele_morena_escura:': u'\U0001F9DD\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':elfa_pele_escura:': u'\U0001F9DD\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':gênio:': u'\U0001F9DE',
    u':homem_gênio:': u'\U0001F9DE\U0000200D\U00002642\U0000FE0F',
    u':mulher_gênio:': u'\U0001F9DE\U0000200D\U00002640\U0000FE0F',
    u':zumbi:': u'\U0001F9DF',
    u':homem_zumbi:': u'\U0001F9DF\U0000200D\U00002642\U0000FE0F',
    u':mulher_zumbi:': u'\U0001F9DF\U0000200D\U00002640\U0000FE0F',
    u':pessoa_recebendo_massagem_facial:': u'\U0001F486',
    u':pessoa_recebendo_massagem_facial_pele_clara:': u'\U0001F486\U0001F3FB',
    u':pessoa_recebendo_massagem_facial_pele_morena_clara:': u'\U0001F486\U0001F3FC',
    u':pessoa_recebendo_massagem_facial_pele_morena:': u'\U0001F486\U0001F3FD',
    u':pessoa_recebendo_massagem_facial_pele_morena_escura:': u'\U0001F486\U0001F3FE',
    u':pessoa_recebendo_massagem_facial_pele_escura:': u'\U0001F486\U0001F3FF',
    u':homem_recebendo_massagem_facial:': u'\U0001F486\U0000200D\U00002642\U0000FE0F',
    u':homem_recebendo_massagem_facial_pele_clara:': u'\U0001F486\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homem_recebendo_massagem_facial_pele_morena_clara:': u'\U0001F486\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homem_recebendo_massagem_facial_pele_morena:': u'\U0001F486\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homem_recebendo_massagem_facial_pele_morena_escura:': u'\U0001F486\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homem_recebendo_massagem_facial_pele_escura:': u'\U0001F486\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mulher_recebendo_massagem_facial:': u'\U0001F486\U0000200D\U00002640\U0000FE0F',
    u':mulher_recebendo_massagem_facial_pele_clara:': u'\U0001F486\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mulher_recebendo_massagem_facial_pele_morena_clara:': u'\U0001F486\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mulher_recebendo_massagem_facial_pele_morena:': u'\U0001F486\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mulher_recebendo_massagem_facial_pele_morena_escura:': u'\U0001F486\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mulher_recebendo_massagem_facial_pele_escura:': u'\U0001F486\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':pessoa_cortando_o_cabelo:': u'\U0001F487',
    u':pessoa_cortando_o_cabelo_pele_clara:': u'\U0001F487\U0001F3FB',
    u':pessoa_cortando_o_cabelo_pele_morena_clara:': u'\U0001F487\U0001F3FC',
    u':pessoa_cortando_o_cabelo_pele_morena:': u'\U0001F487\U0001F3FD',
    u':pessoa_cortando_o_cabelo_pele_morena_escura:': u'\U0001F487\U0001F3FE',
    u':pessoa_cortando_o_cabelo_pele_escura:': u'\U0001F487\U0001F3FF',
    u':homem_cortando_o_cabelo:': u'\U0001F487\U0000200D\U00002642\U0000FE0F',
    u':homem_cortando_o_cabelo_pele_clara:': u'\U0001F487\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homem_cortando_o_cabelo_pele_morena_clara:': u'\U0001F487\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homem_cortando_o_cabelo_pele_morena:': u'\U0001F487\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homem_cortando_o_cabelo_pele_morena_escura:': u'\U0001F487\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homem_cortando_o_cabelo_pele_escura:': u'\U0001F487\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mulher_cortando_o_cabelo:': u'\U0001F487\U0000200D\U00002640\U0000FE0F',
    u':mulher_cortando_o_cabelo_pele_clara:': u'\U0001F487\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mulher_cortando_o_cabelo_pele_morena_clara:': u'\U0001F487\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mulher_cortando_o_cabelo_pele_morena:': u'\U0001F487\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mulher_cortando_o_cabelo_pele_morena_escura:': u'\U0001F487\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mulher_cortando_o_cabelo_pele_escura:': u'\U0001F487\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':pessoa_andando:': u'\U0001F6B6',
    u':pessoa_andando_pele_clara:': u'\U0001F6B6\U0001F3FB',
    u':pessoa_andando_pele_morena_clara:': u'\U0001F6B6\U0001F3FC',
    u':pessoa_andando_pele_morena:': u'\U0001F6B6\U0001F3FD',
    u':pessoa_andando_pele_morena_escura:': u'\U0001F6B6\U0001F3FE',
    u':pessoa_andando_pele_escura:': u'\U0001F6B6\U0001F3FF',
    u':homem_andando:': u'\U0001F6B6\U0000200D\U00002642\U0000FE0F',
    u':homem_andando_pele_clara:': u'\U0001F6B6\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homem_andando_pele_morena_clara:': u'\U0001F6B6\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homem_andando_pele_morena:': u'\U0001F6B6\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homem_andando_pele_morena_escura:': u'\U0001F6B6\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homem_andando_pele_escura:': u'\U0001F6B6\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mulher_andando:': u'\U0001F6B6\U0000200D\U00002640\U0000FE0F',
    u':mulher_andando_pele_clara:': u'\U0001F6B6\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mulher_andando_pele_morena_clara:': u'\U0001F6B6\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mulher_andando_pele_morena:': u'\U0001F6B6\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mulher_andando_pele_morena_escura:': u'\U0001F6B6\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mulher_andando_pele_escura:': u'\U0001F6B6\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':pessoa_em_pé:': u'\U0001F9CD',
    u':pessoa_em_pé_pele_clara:': u'\U0001F9CD\U0001F3FB',
    u':pessoa_em_pé_pele_morena_clara:': u'\U0001F9CD\U0001F3FC',
    u':pessoa_em_pé_pele_morena:': u'\U0001F9CD\U0001F3FD',
    u':pessoa_em_pé_pele_morena_escura:': u'\U0001F9CD\U0001F3FE',
    u':pessoa_em_pé_pele_escura:': u'\U0001F9CD\U0001F3FF',
    u':homem_em_pé:': u'\U0001F9CD\U0000200D\U00002642\U0000FE0F',
    u':homem_em_pé_pele_clara:': u'\U0001F9CD\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homem_em_pé_pele_morena_clara:': u'\U0001F9CD\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homem_em_pé_pele_morena:': u'\U0001F9CD\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homem_em_pé_pele_morena_escura:': u'\U0001F9CD\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homem_em_pé_pele_escura:': u'\U0001F9CD\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mulher_em_pé:': u'\U0001F9CD\U0000200D\U00002640\U0000FE0F',
    u':mulher_em_pé_pele_clara:': u'\U0001F9CD\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mulher_em_pé_pele_morena_clara:': u'\U0001F9CD\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mulher_em_pé_pele_morena:': u'\U0001F9CD\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mulher_em_pé_pele_morena_escura:': u'\U0001F9CD\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mulher_em_pé_pele_escura:': u'\U0001F9CD\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':pessoa_ajoelhando:': u'\U0001F9CE',
    u':pessoa_ajoelhando_pele_clara:': u'\U0001F9CE\U0001F3FB',
    u':pessoa_ajoelhando_pele_morena_clara:': u'\U0001F9CE\U0001F3FC',
    u':pessoa_ajoelhando_pele_morena:': u'\U0001F9CE\U0001F3FD',
    u':pessoa_ajoelhando_pele_morena_escura:': u'\U0001F9CE\U0001F3FE',
    u':pessoa_ajoelhando_pele_escura:': u'\U0001F9CE\U0001F3FF',
    u':homem_ajoelhando:': u'\U0001F9CE\U0000200D\U00002642\U0000FE0F',
    u':homem_ajoelhando_pele_clara:': u'\U0001F9CE\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homem_ajoelhando_pele_morena_clara:': u'\U0001F9CE\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homem_ajoelhando_pele_morena:': u'\U0001F9CE\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homem_ajoelhando_pele_morena_escura:': u'\U0001F9CE\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homem_ajoelhando_pele_escura:': u'\U0001F9CE\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mulher_ajoelhando:': u'\U0001F9CE\U0000200D\U00002640\U0000FE0F',
    u':mulher_ajoelhando_pele_clara:': u'\U0001F9CE\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mulher_ajoelhando_pele_morena_clara:': u'\U0001F9CE\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mulher_ajoelhando_pele_morena:': u'\U0001F9CE\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mulher_ajoelhando_pele_morena_escura:': u'\U0001F9CE\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mulher_ajoelhando_pele_escura:': u'\U0001F9CE\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':pessoa_com_bengala_para_cego:': u'\U0001F9D1\U0000200D\U0001F9AF',
    u':pessoa_com_bengala_para_cego_pele_clara:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F9AF',
    u':pessoa_com_bengala_para_cego_pele_morena_clara:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F9AF',
    u':pessoa_com_bengala_para_cego_pele_morena:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F9AF',
    u':pessoa_com_bengala_para_cego_pele_morena_escura:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F9AF',
    u':pessoa_com_bengala_para_cego_pele_escura:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F9AF',
    u':homem_com_bengala_para_cego:': u'\U0001F468\U0000200D\U0001F9AF',
    u':homem_com_bengala_para_cego_pele_clara:': u'\U0001F468\U0001F3FB\U0000200D\U0001F9AF',
    u':homem_com_bengala_para_cego_pele_morena_clara:': u'\U0001F468\U0001F3FC\U0000200D\U0001F9AF',
    u':homem_com_bengala_para_cego_pele_morena:': u'\U0001F468\U0001F3FD\U0000200D\U0001F9AF',
    u':homem_com_bengala_para_cego_pele_morena_escura:': u'\U0001F468\U0001F3FE\U0000200D\U0001F9AF',
    u':homem_com_bengala_para_cego_pele_escura:': u'\U0001F468\U0001F3FF\U0000200D\U0001F9AF',
    u':mulher_com_bengala_para_cego:': u'\U0001F469\U0000200D\U0001F9AF',
    u':mulher_com_bengala_para_cego_pele_clara:': u'\U0001F469\U0001F3FB\U0000200D\U0001F9AF',
    u':mulher_com_bengala_para_cego_pele_morena_clara:': u'\U0001F469\U0001F3FC\U0000200D\U0001F9AF',
    u':mulher_com_bengala_para_cego_pele_morena:': u'\U0001F469\U0001F3FD\U0000200D\U0001F9AF',
    u':mulher_com_bengala_para_cego_pele_morena_escura:': u'\U0001F469\U0001F3FE\U0000200D\U0001F9AF',
    u':mulher_com_bengala_para_cego_pele_escura:': u'\U0001F469\U0001F3FF\U0000200D\U0001F9AF',
    u':pessoa_em_cadeira_de_rodas_motorizada:': u'\U0001F9D1\U0000200D\U0001F9BC',
    u':pessoa_em_cadeira_de_rodas_motorizada_pele_clara:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F9BC',
    u':pessoa_em_cadeira_de_rodas_motorizada_pele_morena_clara:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F9BC',
    u':pessoa_em_cadeira_de_rodas_motorizada_pele_morena:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F9BC',
    u':pessoa_em_cadeira_de_rodas_motorizada_pele_morena_escura:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F9BC',
    u':pessoa_em_cadeira_de_rodas_motorizada_pele_escura:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F9BC',
    u':homem_em_cadeira_de_rodas_motorizada:': u'\U0001F468\U0000200D\U0001F9BC',
    u':homem_em_cadeira_de_rodas_motorizada_pele_clara:': u'\U0001F468\U0001F3FB\U0000200D\U0001F9BC',
    u':homem_em_cadeira_de_rodas_motorizada_pele_morena_clara:': u'\U0001F468\U0001F3FC\U0000200D\U0001F9BC',
    u':homem_em_cadeira_de_rodas_motorizada_pele_morena:': u'\U0001F468\U0001F3FD\U0000200D\U0001F9BC',
    u':homem_em_cadeira_de_rodas_motorizada_pele_morena_escura:': u'\U0001F468\U0001F3FE\U0000200D\U0001F9BC',
    u':homem_em_cadeira_de_rodas_motorizada_pele_escura:': u'\U0001F468\U0001F3FF\U0000200D\U0001F9BC',
    u':mulher_em_cadeira_de_rodas_motorizada:': u'\U0001F469\U0000200D\U0001F9BC',
    u':mulher_em_cadeira_de_rodas_motorizada_pele_clara:': u'\U0001F469\U0001F3FB\U0000200D\U0001F9BC',
    u':mulher_em_cadeira_de_rodas_motorizada_pele_morena_clara:': u'\U0001F469\U0001F3FC\U0000200D\U0001F9BC',
    u':mulher_em_cadeira_de_rodas_motorizada_pele_morena:': u'\U0001F469\U0001F3FD\U0000200D\U0001F9BC',
    u':mulher_em_cadeira_de_rodas_motorizada_pele_morena_escura:': u'\U0001F469\U0001F3FE\U0000200D\U0001F9BC',
    u':mulher_em_cadeira_de_rodas_motorizada_pele_escura:': u'\U0001F469\U0001F3FF\U0000200D\U0001F9BC',
    u':pessoa_em_cadeira_de_rodas_manual:': u'\U0001F9D1\U0000200D\U0001F9BD',
    u':pessoa_em_cadeira_de_rodas_manual_pele_clara:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F9BD',
    u':pessoa_em_cadeira_de_rodas_manual_pele_morena_clara:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F9BD',
    u':pessoa_em_cadeira_de_rodas_manual_pele_morena:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F9BD',
    u':pessoa_em_cadeira_de_rodas_manual_pele_morena_escura:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F9BD',
    u':pessoa_em_cadeira_de_rodas_manual_pele_escura:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F9BD',
    u':homem_em_cadeira_de_rodas_manual:': u'\U0001F468\U0000200D\U0001F9BD',
    u':homem_em_cadeira_de_rodas_manual_pele_clara:': u'\U0001F468\U0001F3FB\U0000200D\U0001F9BD',
    u':homem_em_cadeira_de_rodas_manual_pele_morena_clara:': u'\U0001F468\U0001F3FC\U0000200D\U0001F9BD',
    u':homem_em_cadeira_de_rodas_manual_pele_morena:': u'\U0001F468\U0001F3FD\U0000200D\U0001F9BD',
    u':homem_em_cadeira_de_rodas_manual_pele_morena_escura:': u'\U0001F468\U0001F3FE\U0000200D\U0001F9BD',
    u':homem_em_cadeira_de_rodas_manual_pele_escura:': u'\U0001F468\U0001F3FF\U0000200D\U0001F9BD',
    u':mulher_em_cadeira_de_rodas_manual:': u'\U0001F469\U0000200D\U0001F9BD',
    u':mulher_em_cadeira_de_rodas_manual_pele_clara:': u'\U0001F469\U0001F3FB\U0000200D\U0001F9BD',
    u':mulher_em_cadeira_de_rodas_manual_pele_morena_clara:': u'\U0001F469\U0001F3FC\U0000200D\U0001F9BD',
    u':mulher_em_cadeira_de_rodas_manual_pele_morena:': u'\U0001F469\U0001F3FD\U0000200D\U0001F9BD',
    u':mulher_em_cadeira_de_rodas_manual_pele_morena_escura:': u'\U0001F469\U0001F3FE\U0000200D\U0001F9BD',
    u':mulher_em_cadeira_de_rodas_manual_pele_escura:': u'\U0001F469\U0001F3FF\U0000200D\U0001F9BD',
    u':pessoa_correndo:': u'\U0001F3C3',
    u':pessoa_correndo_pele_clara:': u'\U0001F3C3\U0001F3FB',
    u':pessoa_correndo_pele_morena_clara:': u'\U0001F3C3\U0001F3FC',
    u':pessoa_correndo_pele_morena:': u'\U0001F3C3\U0001F3FD',
    u':pessoa_correndo_pele_morena_escura:': u'\U0001F3C3\U0001F3FE',
    u':pessoa_correndo_pele_escura:': u'\U0001F3C3\U0001F3FF',
    u':homem_correndo:': u'\U0001F3C3\U0000200D\U00002642\U0000FE0F',
    u':homem_correndo_pele_clara:': u'\U0001F3C3\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homem_correndo_pele_morena_clara:': u'\U0001F3C3\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homem_correndo_pele_morena:': u'\U0001F3C3\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homem_correndo_pele_morena_escura:': u'\U0001F3C3\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homem_correndo_pele_escura:': u'\U0001F3C3\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mulher_correndo:': u'\U0001F3C3\U0000200D\U00002640\U0000FE0F',
    u':mulher_correndo_pele_clara:': u'\U0001F3C3\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mulher_correndo_pele_morena_clara:': u'\U0001F3C3\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mulher_correndo_pele_morena:': u'\U0001F3C3\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mulher_correndo_pele_morena_escura:': u'\U0001F3C3\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mulher_correndo_pele_escura:': u'\U0001F3C3\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':mulher_dançando:': u'\U0001F483',
    u':mulher_dançando_pele_clara:': u'\U0001F483\U0001F3FB',
    u':mulher_dançando_pele_morena_clara:': u'\U0001F483\U0001F3FC',
    u':mulher_dançando_pele_morena:': u'\U0001F483\U0001F3FD',
    u':mulher_dançando_pele_morena_escura:': u'\U0001F483\U0001F3FE',
    u':mulher_dançando_pele_escura:': u'\U0001F483\U0001F3FF',
    u':homem_dançando:': u'\U0001F57A',
    u':homem_dançando_pele_clara:': u'\U0001F57A\U0001F3FB',
    u':homem_dançando_pele_morena_clara:': u'\U0001F57A\U0001F3FC',
    u':homem_dançando_pele_morena:': u'\U0001F57A\U0001F3FD',
    u':homem_dançando_pele_morena_escura:': u'\U0001F57A\U0001F3FE',
    u':homem_dançando_pele_escura:': u'\U0001F57A\U0001F3FF',
    u':homem_de_terno_levitando:': u'\U0001F574\U0000FE0F',
    u':homem_de_terno_levitando_pele_clara:': u'\U0001F574\U0001F3FB',
    u':homem_de_terno_levitando_pele_morena_clara:': u'\U0001F574\U0001F3FC',
    u':homem_de_terno_levitando_pele_morena:': u'\U0001F574\U0001F3FD',
    u':homem_de_terno_levitando_pele_morena_escura:': u'\U0001F574\U0001F3FE',
    u':homem_de_terno_levitando_pele_escura:': u'\U0001F574\U0001F3FF',
    u':pessoas_com_orelhas_de_coelho:': u'\U0001F46F',
    u':homens_com_orelhas_de_coelho:': u'\U0001F46F\U0000200D\U00002642\U0000FE0F',
    u':mulheres_com_orelhas_de_coelho:': u'\U0001F46F\U0000200D\U00002640\U0000FE0F',
    u':pessoa_na_sauna:': u'\U0001F9D6',
    u':pessoa_na_sauna_pele_clara:': u'\U0001F9D6\U0001F3FB',
    u':pessoa_na_sauna_pele_morena_clara:': u'\U0001F9D6\U0001F3FC',
    u':pessoa_na_sauna_pele_morena:': u'\U0001F9D6\U0001F3FD',
    u':pessoa_na_sauna_pele_morena_escura:': u'\U0001F9D6\U0001F3FE',
    u':pessoa_na_sauna_pele_escura:': u'\U0001F9D6\U0001F3FF',
    u':homem_na_sauna:': u'\U0001F9D6\U0000200D\U00002642\U0000FE0F',
    u':homem_na_sauna_pele_clara:': u'\U0001F9D6\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homem_na_sauna_pele_morena_clara:': u'\U0001F9D6\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homem_na_sauna_pele_morena:': u'\U0001F9D6\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homem_na_sauna_pele_morena_escura:': u'\U0001F9D6\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homem_na_sauna_pele_escura:': u'\U0001F9D6\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mulher_na_sauna:': u'\U0001F9D6\U0000200D\U00002640\U0000FE0F',
    u':mulher_na_sauna_pele_clara:': u'\U0001F9D6\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mulher_na_sauna_pele_morena_clara:': u'\U0001F9D6\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mulher_na_sauna_pele_morena:': u'\U0001F9D6\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mulher_na_sauna_pele_morena_escura:': u'\U0001F9D6\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mulher_na_sauna_pele_escura:': u'\U0001F9D6\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':pessoa_escalando:': u'\U0001F9D7',
    u':pessoa_escalando_pele_clara:': u'\U0001F9D7\U0001F3FB',
    u':pessoa_escalando_pele_morena_clara:': u'\U0001F9D7\U0001F3FC',
    u':pessoa_escalando_pele_morena:': u'\U0001F9D7\U0001F3FD',
    u':pessoa_escalando_pele_morena_escura:': u'\U0001F9D7\U0001F3FE',
    u':pessoa_escalando_pele_escura:': u'\U0001F9D7\U0001F3FF',
    u':homem_escalando:': u'\U0001F9D7\U0000200D\U00002642\U0000FE0F',
    u':homem_escalando_pele_clara:': u'\U0001F9D7\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homem_escalando_pele_morena_clara:': u'\U0001F9D7\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homem_escalando_pele_morena:': u'\U0001F9D7\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homem_escalando_pele_morena_escura:': u'\U0001F9D7\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homem_escalando_pele_escura:': u'\U0001F9D7\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mulher_escalando:': u'\U0001F9D7\U0000200D\U00002640\U0000FE0F',
    u':mulher_escalando_pele_clara:': u'\U0001F9D7\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mulher_escalando_pele_morena_clara:': u'\U0001F9D7\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mulher_escalando_pele_morena:': u'\U0001F9D7\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mulher_escalando_pele_morena_escura:': u'\U0001F9D7\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mulher_escalando_pele_escura:': u'\U0001F9D7\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':esgrimista:': u'\U0001F93A',
    u':corrida_de_cavalos:': u'\U0001F3C7',
    u':corrida_de_cavalos_pele_clara:': u'\U0001F3C7\U0001F3FB',
    u':corrida_de_cavalos_pele_morena_clara:': u'\U0001F3C7\U0001F3FC',
    u':corrida_de_cavalos_pele_morena:': u'\U0001F3C7\U0001F3FD',
    u':corrida_de_cavalos_pele_morena_escura:': u'\U0001F3C7\U0001F3FE',
    u':corrida_de_cavalos_pele_escura:': u'\U0001F3C7\U0001F3FF',
    u':esquiador:': u'\U000026F7\U0000FE0F',
    u':praticante_de_snowboard:': u'\U0001F3C2',
    u':praticante_de_snowboard_pele_clara:': u'\U0001F3C2\U0001F3FB',
    u':praticante_de_snowboard_pele_morena_clara:': u'\U0001F3C2\U0001F3FC',
    u':praticante_de_snowboard_pele_morena:': u'\U0001F3C2\U0001F3FD',
    u':praticante_de_snowboard_pele_morena_escura:': u'\U0001F3C2\U0001F3FE',
    u':praticante_de_snowboard_pele_escura:': u'\U0001F3C2\U0001F3FF',
    u':golfista:': u'\U0001F3CC\U0000FE0F',
    u':golfista_pele_clara:': u'\U0001F3CC\U0001F3FB',
    u':golfista_pele_morena_clara:': u'\U0001F3CC\U0001F3FC',
    u':golfista_pele_morena:': u'\U0001F3CC\U0001F3FD',
    u':golfista_pele_morena_escura:': u'\U0001F3CC\U0001F3FE',
    u':golfista_pele_escura:': u'\U0001F3CC\U0001F3FF',
    u':homem_golfista:': u'\U0001F3CC\U0000FE0F\U0000200D\U00002642\U0000FE0F',
    u':homem_golfista_pele_clara:': u'\U0001F3CC\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homem_golfista_pele_morena_clara:': u'\U0001F3CC\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homem_golfista_pele_morena:': u'\U0001F3CC\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homem_golfista_pele_morena_escura:': u'\U0001F3CC\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homem_golfista_pele_escura:': u'\U0001F3CC\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mulher_golfista:': u'\U0001F3CC\U0000FE0F\U0000200D\U00002640\U0000FE0F',
    u':mulher_golfista_pele_clara:': u'\U0001F3CC\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mulher_golfista_pele_morena_clara:': u'\U0001F3CC\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mulher_golfista_pele_morena:': u'\U0001F3CC\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mulher_golfista_pele_morena_escura:': u'\U0001F3CC\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mulher_golfista_pele_escura:': u'\U0001F3CC\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':surfista:': u'\U0001F3C4',
    u':surfista_pele_clara:': u'\U0001F3C4\U0001F3FB',
    u':surfista_pele_morena_clara:': u'\U0001F3C4\U0001F3FC',
    u':surfista_pele_morena:': u'\U0001F3C4\U0001F3FD',
    u':surfista_pele_morena_escura:': u'\U0001F3C4\U0001F3FE',
    u':surfista_pele_escura:': u'\U0001F3C4\U0001F3FF',
    u':homem_surfista:': u'\U0001F3C4\U0000200D\U00002642\U0000FE0F',
    u':homem_surfista_pele_clara:': u'\U0001F3C4\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homem_surfista_pele_morena_clara:': u'\U0001F3C4\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homem_surfista_pele_morena:': u'\U0001F3C4\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homem_surfista_pele_morena_escura:': u'\U0001F3C4\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homem_surfista_pele_escura:': u'\U0001F3C4\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mulher_surfista:': u'\U0001F3C4\U0000200D\U00002640\U0000FE0F',
    u':mulher_surfista_pele_clara:': u'\U0001F3C4\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mulher_surfista_pele_morena_clara:': u'\U0001F3C4\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mulher_surfista_pele_morena:': u'\U0001F3C4\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mulher_surfista_pele_morena_escura:': u'\U0001F3C4\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mulher_surfista_pele_escura:': u'\U0001F3C4\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':pessoa_remando:': u'\U0001F6A3',
    u':pessoa_remando_pele_clara:': u'\U0001F6A3\U0001F3FB',
    u':pessoa_remando_pele_morena_clara:': u'\U0001F6A3\U0001F3FC',
    u':pessoa_remando_pele_morena:': u'\U0001F6A3\U0001F3FD',
    u':pessoa_remando_pele_morena_escura:': u'\U0001F6A3\U0001F3FE',
    u':pessoa_remando_pele_escura:': u'\U0001F6A3\U0001F3FF',
    u':homem_remando:': u'\U0001F6A3\U0000200D\U00002642\U0000FE0F',
    u':homem_remando_pele_clara:': u'\U0001F6A3\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homem_remando_pele_morena_clara:': u'\U0001F6A3\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homem_remando_pele_morena:': u'\U0001F6A3\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homem_remando_pele_morena_escura:': u'\U0001F6A3\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homem_remando_pele_escura:': u'\U0001F6A3\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mulher_remando:': u'\U0001F6A3\U0000200D\U00002640\U0000FE0F',
    u':mulher_remando_pele_clara:': u'\U0001F6A3\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mulher_remando_pele_morena_clara:': u'\U0001F6A3\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mulher_remando_pele_morena:': u'\U0001F6A3\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mulher_remando_pele_morena_escura:': u'\U0001F6A3\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mulher_remando_pele_escura:': u'\U0001F6A3\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':pessoa_nadando:': u'\U0001F3CA',
    u':pessoa_nadando_pele_clara:': u'\U0001F3CA\U0001F3FB',
    u':pessoa_nadando_pele_morena_clara:': u'\U0001F3CA\U0001F3FC',
    u':pessoa_nadando_pele_morena:': u'\U0001F3CA\U0001F3FD',
    u':pessoa_nadando_pele_morena_escura:': u'\U0001F3CA\U0001F3FE',
    u':pessoa_nadando_pele_escura:': u'\U0001F3CA\U0001F3FF',
    u':homem_nadando:': u'\U0001F3CA\U0000200D\U00002642\U0000FE0F',
    u':homem_nadando_pele_clara:': u'\U0001F3CA\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homem_nadando_pele_morena_clara:': u'\U0001F3CA\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homem_nadando_pele_morena:': u'\U0001F3CA\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homem_nadando_pele_morena_escura:': u'\U0001F3CA\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homem_nadando_pele_escura:': u'\U0001F3CA\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mulher_nadando:': u'\U0001F3CA\U0000200D\U00002640\U0000FE0F',
    u':mulher_nadando_pele_clara:': u'\U0001F3CA\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mulher_nadando_pele_morena_clara:': u'\U0001F3CA\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mulher_nadando_pele_morena:': u'\U0001F3CA\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mulher_nadando_pele_morena_escura:': u'\U0001F3CA\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mulher_nadando_pele_escura:': u'\U0001F3CA\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':pessoa_jogando_basquete:': u'\U000026F9\U0000FE0F',
    u':pessoa_jogando_basquete_pele_clara:': u'\U000026F9\U0001F3FB',
    u':pessoa_jogando_basquete_pele_morena_clara:': u'\U000026F9\U0001F3FC',
    u':pessoa_jogando_basquete_pele_morena:': u'\U000026F9\U0001F3FD',
    u':pessoa_jogando_basquete_pele_morena_escura:': u'\U000026F9\U0001F3FE',
    u':pessoa_jogando_basquete_pele_escura:': u'\U000026F9\U0001F3FF',
    u':homem_jogando_basquete:': u'\U000026F9\U0000FE0F\U0000200D\U00002642\U0000FE0F',
    u':homem_jogando_basquete_pele_clara:': u'\U000026F9\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homem_jogando_basquete_pele_morena_clara:': u'\U000026F9\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homem_jogando_basquete_pele_morena:': u'\U000026F9\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homem_jogando_basquete_pele_morena_escura:': u'\U000026F9\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homem_jogando_basquete_pele_escura:': u'\U000026F9\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mulher_jogando_basquete:': u'\U000026F9\U0000FE0F\U0000200D\U00002640\U0000FE0F',
    u':mulher_jogando_basquete_pele_clara:': u'\U000026F9\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mulher_jogando_basquete_pele_morena_clara:': u'\U000026F9\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mulher_jogando_basquete_pele_morena:': u'\U000026F9\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mulher_jogando_basquete_pele_morena_escura:': u'\U000026F9\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mulher_jogando_basquete_pele_escura:': u'\U000026F9\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':pessoa_levantando_peso:': u'\U0001F3CB\U0000FE0F',
    u':pessoa_levantando_peso_pele_clara:': u'\U0001F3CB\U0001F3FB',
    u':pessoa_levantando_peso_pele_morena_clara:': u'\U0001F3CB\U0001F3FC',
    u':pessoa_levantando_peso_pele_morena:': u'\U0001F3CB\U0001F3FD',
    u':pessoa_levantando_peso_pele_morena_escura:': u'\U0001F3CB\U0001F3FE',
    u':pessoa_levantando_peso_pele_escura:': u'\U0001F3CB\U0001F3FF',
    u':homem_levantando_peso:': u'\U0001F3CB\U0000FE0F\U0000200D\U00002642\U0000FE0F',
    u':homem_levantando_peso_pele_clara:': u'\U0001F3CB\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homem_levantando_peso_pele_morena_clara:': u'\U0001F3CB\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homem_levantando_peso_pele_morena:': u'\U0001F3CB\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homem_levantando_peso_pele_morena_escura:': u'\U0001F3CB\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homem_levantando_peso_pele_escura:': u'\U0001F3CB\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mulher_levantando_peso:': u'\U0001F3CB\U0000FE0F\U0000200D\U00002640\U0000FE0F',
    u':mulher_levantando_peso_pele_clara:': u'\U0001F3CB\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mulher_levantando_peso_pele_morena_clara:': u'\U0001F3CB\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mulher_levantando_peso_pele_morena:': u'\U0001F3CB\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mulher_levantando_peso_pele_morena_escura:': u'\U0001F3CB\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mulher_levantando_peso_pele_escura:': u'\U0001F3CB\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':ciclista:': u'\U0001F6B4',
    u':ciclista_pele_clara:': u'\U0001F6B4\U0001F3FB',
    u':ciclista_pele_morena_clara:': u'\U0001F6B4\U0001F3FC',
    u':ciclista_pele_morena:': u'\U0001F6B4\U0001F3FD',
    u':ciclista_pele_morena_escura:': u'\U0001F6B4\U0001F3FE',
    u':ciclista_pele_escura:': u'\U0001F6B4\U0001F3FF',
    u':homem_ciclista:': u'\U0001F6B4\U0000200D\U00002642\U0000FE0F',
    u':homem_ciclista_pele_clara:': u'\U0001F6B4\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homem_ciclista_pele_morena_clara:': u'\U0001F6B4\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homem_ciclista_pele_morena:': u'\U0001F6B4\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homem_ciclista_pele_morena_escura:': u'\U0001F6B4\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homem_ciclista_pele_escura:': u'\U0001F6B4\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mulher_ciclista:': u'\U0001F6B4\U0000200D\U00002640\U0000FE0F',
    u':mulher_ciclista_pele_clara:': u'\U0001F6B4\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mulher_ciclista_pele_morena_clara:': u'\U0001F6B4\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mulher_ciclista_pele_morena:': u'\U0001F6B4\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mulher_ciclista_pele_morena_escura:': u'\U0001F6B4\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mulher_ciclista_pele_escura:': u'\U0001F6B4\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':pessoa_fazendo_mountain_bike:': u'\U0001F6B5',
    u':pessoa_fazendo_mountain_bike_pele_clara:': u'\U0001F6B5\U0001F3FB',
    u':pessoa_fazendo_mountain_bike_pele_morena_clara:': u'\U0001F6B5\U0001F3FC',
    u':pessoa_fazendo_mountain_bike_pele_morena:': u'\U0001F6B5\U0001F3FD',
    u':pessoa_fazendo_mountain_bike_pele_morena_escura:': u'\U0001F6B5\U0001F3FE',
    u':pessoa_fazendo_mountain_bike_pele_escura:': u'\U0001F6B5\U0001F3FF',
    u':homem_fazendo_mountain_bike:': u'\U0001F6B5\U0000200D\U00002642\U0000FE0F',
    u':homem_fazendo_mountain_bike_pele_clara:': u'\U0001F6B5\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homem_fazendo_mountain_bike_pele_morena_clara:': u'\U0001F6B5\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homem_fazendo_mountain_bike_pele_morena:': u'\U0001F6B5\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homem_fazendo_mountain_bike_pele_morena_escura:': u'\U0001F6B5\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homem_fazendo_mountain_bike_pele_escura:': u'\U0001F6B5\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mulher_fazendo_mountain_bike:': u'\U0001F6B5\U0000200D\U00002640\U0000FE0F',
    u':mulher_fazendo_mountain_bike_pele_clara:': u'\U0001F6B5\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mulher_fazendo_mountain_bike_pele_morena_clara:': u'\U0001F6B5\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mulher_fazendo_mountain_bike_pele_morena:': u'\U0001F6B5\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mulher_fazendo_mountain_bike_pele_morena_escura:': u'\U0001F6B5\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mulher_fazendo_mountain_bike_pele_escura:': u'\U0001F6B5\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':pessoa_fazendo_estrela:': u'\U0001F938',
    u':pessoa_fazendo_estrela_pele_clara:': u'\U0001F938\U0001F3FB',
    u':pessoa_fazendo_estrela_pele_morena_clara:': u'\U0001F938\U0001F3FC',
    u':pessoa_fazendo_estrela_pele_morena:': u'\U0001F938\U0001F3FD',
    u':pessoa_fazendo_estrela_pele_morena_escura:': u'\U0001F938\U0001F3FE',
    u':pessoa_fazendo_estrela_pele_escura:': u'\U0001F938\U0001F3FF',
    u':homem_fazendo_estrela:': u'\U0001F938\U0000200D\U00002642\U0000FE0F',
    u':homem_fazendo_estrela_pele_clara:': u'\U0001F938\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homem_fazendo_estrela_pele_morena_clara:': u'\U0001F938\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homem_fazendo_estrela_pele_morena:': u'\U0001F938\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homem_fazendo_estrela_pele_morena_escura:': u'\U0001F938\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homem_fazendo_estrela_pele_escura:': u'\U0001F938\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mulher_fazendo_estrela:': u'\U0001F938\U0000200D\U00002640\U0000FE0F',
    u':mulher_fazendo_estrela_pele_clara:': u'\U0001F938\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mulher_fazendo_estrela_pele_morena_clara:': u'\U0001F938\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mulher_fazendo_estrela_pele_morena:': u'\U0001F938\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mulher_fazendo_estrela_pele_morena_escura:': u'\U0001F938\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mulher_fazendo_estrela_pele_escura:': u'\U0001F938\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':pessoas_lutando:': u'\U0001F93C',
    u':homens_lutando:': u'\U0001F93C\U0000200D\U00002642\U0000FE0F',
    u':mulheres_lutando:': u'\U0001F93C\U0000200D\U00002640\U0000FE0F',
    u':pessoa_jogando_polo_aquático:': u'\U0001F93D',
    u':pessoa_jogando_polo_aquático_pele_clara:': u'\U0001F93D\U0001F3FB',
    u':pessoa_jogando_polo_aquático_pele_morena_clara:': u'\U0001F93D\U0001F3FC',
    u':pessoa_jogando_polo_aquático_pele_morena:': u'\U0001F93D\U0001F3FD',
    u':pessoa_jogando_polo_aquático_pele_morena_escura:': u'\U0001F93D\U0001F3FE',
    u':pessoa_jogando_polo_aquático_pele_escura:': u'\U0001F93D\U0001F3FF',
    u':homem_jogando_polo_aquático:': u'\U0001F93D\U0000200D\U00002642\U0000FE0F',
    u':homem_jogando_polo_aquático_pele_clara:': u'\U0001F93D\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homem_jogando_polo_aquático_pele_morena_clara:': u'\U0001F93D\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homem_jogando_polo_aquático_pele_morena:': u'\U0001F93D\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homem_jogando_polo_aquático_pele_morena_escura:': u'\U0001F93D\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homem_jogando_polo_aquático_pele_escura:': u'\U0001F93D\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mulher_jogando_polo_aquático:': u'\U0001F93D\U0000200D\U00002640\U0000FE0F',
    u':mulher_jogando_polo_aquático_pele_clara:': u'\U0001F93D\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mulher_jogando_polo_aquático_pele_morena_clara:': u'\U0001F93D\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mulher_jogando_polo_aquático_pele_morena:': u'\U0001F93D\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mulher_jogando_polo_aquático_pele_morena_escura:': u'\U0001F93D\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mulher_jogando_polo_aquático_pele_escura:': u'\U0001F93D\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':handebol:': u'\U0001F93E',
    u':handebol_pele_clara:': u'\U0001F93E\U0001F3FB',
    u':handebol_pele_morena_clara:': u'\U0001F93E\U0001F3FC',
    u':handebol_pele_morena:': u'\U0001F93E\U0001F3FD',
    u':handebol_pele_morena_escura:': u'\U0001F93E\U0001F3FE',
    u':handebol_pele_escura:': u'\U0001F93E\U0001F3FF',
    u':jogador_de_handebol:': u'\U0001F93E\U0000200D\U00002642\U0000FE0F',
    u':jogador_de_handebol_pele_clara:': u'\U0001F93E\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':jogador_de_handebol_pele_morena_clara:': u'\U0001F93E\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':jogador_de_handebol_pele_morena:': u'\U0001F93E\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':jogador_de_handebol_pele_morena_escura:': u'\U0001F93E\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':jogador_de_handebol_pele_escura:': u'\U0001F93E\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':jogadora_de_handebol:': u'\U0001F93E\U0000200D\U00002640\U0000FE0F',
    u':jogadora_de_handebol_pele_clara:': u'\U0001F93E\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':jogadora_de_handebol_pele_morena_clara:': u'\U0001F93E\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':jogadora_de_handebol_pele_morena:': u'\U0001F93E\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':jogadora_de_handebol_pele_morena_escura:': u'\U0001F93E\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':jogadora_de_handebol_pele_escura:': u'\U0001F93E\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':malabarista:': u'\U0001F939',
    u':malabarista_pele_clara:': u'\U0001F939\U0001F3FB',
    u':malabarista_pele_morena_clara:': u'\U0001F939\U0001F3FC',
    u':malabarista_pele_morena:': u'\U0001F939\U0001F3FD',
    u':malabarista_pele_morena_escura:': u'\U0001F939\U0001F3FE',
    u':malabarista_pele_escura:': u'\U0001F939\U0001F3FF',
    u':homem_malabarista:': u'\U0001F939\U0000200D\U00002642\U0000FE0F',
    u':homem_malabarista_pele_clara:': u'\U0001F939\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homem_malabarista_pele_morena_clara:': u'\U0001F939\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homem_malabarista_pele_morena:': u'\U0001F939\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homem_malabarista_pele_morena_escura:': u'\U0001F939\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homem_malabarista_pele_escura:': u'\U0001F939\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mulher_malabarista:': u'\U0001F939\U0000200D\U00002640\U0000FE0F',
    u':mulher_malabarista_pele_clara:': u'\U0001F939\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mulher_malabarista_pele_morena_clara:': u'\U0001F939\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mulher_malabarista_pele_morena:': u'\U0001F939\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mulher_malabarista_pele_morena_escura:': u'\U0001F939\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mulher_malabarista_pele_escura:': u'\U0001F939\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':pessoa_na_posição_de_lótus:': u'\U0001F9D8',
    u':pessoa_na_posição_de_lótus_pele_clara:': u'\U0001F9D8\U0001F3FB',
    u':pessoa_na_posição_de_lótus_pele_morena_clara:': u'\U0001F9D8\U0001F3FC',
    u':pessoa_na_posição_de_lótus_pele_morena:': u'\U0001F9D8\U0001F3FD',
    u':pessoa_na_posição_de_lótus_pele_morena_escura:': u'\U0001F9D8\U0001F3FE',
    u':pessoa_na_posição_de_lótus_pele_escura:': u'\U0001F9D8\U0001F3FF',
    u':homem_na_posição_de_lótus:': u'\U0001F9D8\U0000200D\U00002642\U0000FE0F',
    u':homem_na_posição_de_lótus_pele_clara:': u'\U0001F9D8\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':homem_na_posição_de_lótus_pele_morena_clara:': u'\U0001F9D8\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':homem_na_posição_de_lótus_pele_morena:': u'\U0001F9D8\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':homem_na_posição_de_lótus_pele_morena_escura:': u'\U0001F9D8\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':homem_na_posição_de_lótus_pele_escura:': u'\U0001F9D8\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mulher_na_posição_de_lótus:': u'\U0001F9D8\U0000200D\U00002640\U0000FE0F',
    u':mulher_na_posição_de_lótus_pele_clara:': u'\U0001F9D8\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mulher_na_posição_de_lótus_pele_morena_clara:': u'\U0001F9D8\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mulher_na_posição_de_lótus_pele_morena:': u'\U0001F9D8\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mulher_na_posição_de_lótus_pele_morena_escura:': u'\U0001F9D8\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mulher_na_posição_de_lótus_pele_escura:': u'\U0001F9D8\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':pessoa_tomando_banho:': u'\U0001F6C0',
    u':pessoa_tomando_banho_pele_clara:': u'\U0001F6C0\U0001F3FB',
    u':pessoa_tomando_banho_pele_morena_clara:': u'\U0001F6C0\U0001F3FC',
    u':pessoa_tomando_banho_pele_morena:': u'\U0001F6C0\U0001F3FD',
    u':pessoa_tomando_banho_pele_morena_escura:': u'\U0001F6C0\U0001F3FE',
    u':pessoa_tomando_banho_pele_escura:': u'\U0001F6C0\U0001F3FF',
    u':pessoa_deitada_na_cama:': u'\U0001F6CC',
    u':pessoa_deitada_na_cama_pele_clara:': u'\U0001F6CC\U0001F3FB',
    u':pessoa_deitada_na_cama_pele_morena_clara:': u'\U0001F6CC\U0001F3FC',
    u':pessoa_deitada_na_cama_pele_morena:': u'\U0001F6CC\U0001F3FD',
    u':pessoa_deitada_na_cama_pele_morena_escura:': u'\U0001F6CC\U0001F3FE',
    u':pessoa_deitada_na_cama_pele_escura:': u'\U0001F6CC\U0001F3FF',
    u':pessoas_de_mãos_dadas:': u'\U0001F9D1\U0000200D\U0001F91D\U0000200D\U0001F9D1',
    u':pessoas_de_mãos_dadas_pele_clara:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FB',
    u':pessoas_de_mãos_dadas_pele_clara_e_pele_morena_clara:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FC',
    u':pessoas_de_mãos_dadas_pele_clara_e_pele_morena:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FD',
    u':pessoas_de_mãos_dadas_pele_clara_e_pele_morena_escura:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FE',
    u':pessoas_de_mãos_dadas_pele_clara_e_pele_escura:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FF',
    u':pessoas_de_mãos_dadas_pele_morena_clara_e_pele_clara:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FB',
    u':pessoas_de_mãos_dadas_pele_morena_clara:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FC',
    u':pessoas_de_mãos_dadas_pele_morena_clara_e_pele_morena:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FD',
    u':pessoas_de_mãos_dadas_pele_morena_clara_e_pele_morena_escura:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FE',
    u':pessoas_de_mãos_dadas_pele_morena_clara_e_pele_escura:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FF',
    u':pessoas_de_mãos_dadas_pele_morena_e_pele_clara:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FB',
    u':pessoas_de_mãos_dadas_pele_morena_e_pele_morena_clara:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FC',
    u':pessoas_de_mãos_dadas_pele_morena:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FD',
    u':pessoas_de_mãos_dadas_pele_morena_e_pele_morena_escura:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FE',
    u':pessoas_de_mãos_dadas_pele_morena_e_pele_escura:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FF',
    u':pessoas_de_mãos_dadas_pele_morena_escura_e_pele_clara:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FB',
    u':pessoas_de_mãos_dadas_pele_morena_escura_e_pele_morena_clara:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FC',
    u':pessoas_de_mãos_dadas_pele_morena_escura_e_pele_morena:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FD',
    u':pessoas_de_mãos_dadas_pele_morena_escura:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FE',
    u':pessoas_de_mãos_dadas_pele_morena_escura_e_pele_escura:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FF',
    u':pessoas_de_mãos_dadas_pele_escura_e_pele_clara:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FB',
    u':pessoas_de_mãos_dadas_pele_escura_e_pele_morena_clara:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FC',
    u':pessoas_de_mãos_dadas_pele_escura_e_pele_morena:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FD',
    u':pessoas_de_mãos_dadas_pele_escura_e_pele_morena_escura:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FE',
    u':pessoas_de_mãos_dadas_pele_escura:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FF',
    u':duas_mulheres_de_mãos_dadas:': u'\U0001F46D',
    u':duas_mulheres_de_mãos_dadas_pele_clara:': u'\U0001F46D\U0001F3FB',
    u':duas_mulheres_de_mãos_dadas_pele_clara_e_pele_morena_clara:': u'\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FC',
    u':duas_mulheres_de_mãos_dadas_pele_clara_e_pele_morena:': u'\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FD',
    u':duas_mulheres_de_mãos_dadas_pele_clara_e_pele_morena_escura:': u'\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FE',
    u':duas_mulheres_de_mãos_dadas_pele_clara_e_pele_escura:': u'\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FF',
    u':duas_mulheres_de_mãos_dadas_pele_morena_clara_e_pele_clara:': u'\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FB',
    u':duas_mulheres_de_mãos_dadas_pele_morena_clara:': u'\U0001F46D\U0001F3FC',
    u':duas_mulheres_de_mãos_dadas_pele_morena_clara_e_pele_morena:': u'\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FD',
    u':duas_mulheres_de_mãos_dadas_pele_morena_clara_e_pele_morena_escura:': u'\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FE',
    u':duas_mulheres_de_mãos_dadas_pele_morena_clara_e_pele_escura:': u'\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FF',
    u':duas_mulheres_de_mãos_dadas_pele_morena_e_pele_clara:': u'\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FB',
    u':duas_mulheres_de_mãos_dadas_pele_morena_e_pele_morena_clara:': u'\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FC',
    u':duas_mulheres_de_mãos_dadas_pele_morena:': u'\U0001F46D\U0001F3FD',
    u':duas_mulheres_de_mãos_dadas_pele_morena_e_pele_morena_escura:': u'\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FE',
    u':duas_mulheres_de_mãos_dadas_pele_morena_e_pele_escura:': u'\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FF',
    u':duas_mulheres_de_mãos_dadas_pele_morena_escura_e_pele_clara:': u'\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FB',
    u':duas_mulheres_de_mãos_dadas_pele_morena_escura_e_pele_morena_clara:': u'\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FC',
    u':duas_mulheres_de_mãos_dadas_pele_morena_escura_e_pele_morena:': u'\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FD',
    u':duas_mulheres_de_mãos_dadas_pele_morena_escura:': u'\U0001F46D\U0001F3FE',
    u':duas_mulheres_de_mãos_dadas_pele_morena_escura_e_pele_escura:': u'\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FF',
    u':duas_mulheres_de_mãos_dadas_pele_escura_e_pele_clara:': u'\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FB',
    u':duas_mulheres_de_mãos_dadas_pele_escura_e_pele_morena_clara:': u'\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FC',
    u':duas_mulheres_de_mãos_dadas_pele_escura_e_pele_morena:': u'\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FD',
    u':duas_mulheres_de_mãos_dadas_pele_escura_e_pele_morena_escura:': u'\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FE',
    u':duas_mulheres_de_mãos_dadas_pele_escura:': u'\U0001F46D\U0001F3FF',
    u':homem_e_mulher_de_mãos_dadas:': u'\U0001F46B',
    u':homem_e_mulher_de_mãos_dadas_pele_clara:': u'\U0001F46B\U0001F3FB',
    u':homem_e_mulher_de_mãos_dadas_pele_clara_e_pele_morena_clara:': u'\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC',
    u':homem_e_mulher_de_mãos_dadas_pele_clara_e_pele_morena:': u'\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD',
    u':homem_e_mulher_de_mãos_dadas_pele_clara_e_pele_morena_escura:': u'\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE',
    u':homem_e_mulher_de_mãos_dadas_pele_clara_e_pele_escura:': u'\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF',
    u':homem_e_mulher_de_mãos_dadas_pele_morena_clara_e_pele_clara:': u'\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB',
    u':homem_e_mulher_de_mãos_dadas_pele_morena_clara:': u'\U0001F46B\U0001F3FC',
    u':homem_e_mulher_de_mãos_dadas_pele_morena_clara_e_pele_morena:': u'\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD',
    u':homem_e_mulher_de_mãos_dadas_pele_morena_clara_e_pele_morena_escura:': u'\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE',
    u':homem_e_mulher_de_mãos_dadas_pele_morena_clara_e_pele_escura:': u'\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF',
    u':homem_e_mulher_de_mãos_dadas_pele_morena_e_pele_clara:': u'\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB',
    u':homem_e_mulher_de_mãos_dadas_pele_morena_e_pele_morena_clara:': u'\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC',
    u':homem_e_mulher_de_mãos_dadas_pele_morena:': u'\U0001F46B\U0001F3FD',
    u':homem_e_mulher_de_mãos_dadas_pele_morena_e_pele_morena_escura:': u'\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE',
    u':homem_e_mulher_de_mãos_dadas_pele_morena_e_pele_escura:': u'\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF',
    u':homem_e_mulher_de_mãos_dadas_pele_morena_escura_e_pele_clara:': u'\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB',
    u':homem_e_mulher_de_mãos_dadas_pele_morena_escura_e_pele_morena_clara:': u'\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC',
    u':homem_e_mulher_de_mãos_dadas_pele_morena_escura_e_pele_morena:': u'\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD',
    u':homem_e_mulher_de_mãos_dadas_pele_morena_escura:': u'\U0001F46B\U0001F3FE',
    u':homem_e_mulher_de_mãos_dadas_pele_morena_escura_e_pele_escura:': u'\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF',
    u':homem_e_mulher_de_mãos_dadas_pele_escura_e_pele_clara:': u'\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB',
    u':homem_e_mulher_de_mãos_dadas_pele_escura_e_pele_morena_clara:': u'\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC',
    u':homem_e_mulher_de_mãos_dadas_pele_escura_e_pele_morena:': u'\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD',
    u':homem_e_mulher_de_mãos_dadas_pele_escura_e_pele_morena_escura:': u'\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE',
    u':homem_e_mulher_de_mãos_dadas_pele_escura:': u'\U0001F46B\U0001F3FF',
    u':dois_homens_de_mãos_dadas:': u'\U0001F46C',
    u':dois_homens_de_mãos_dadas_pele_clara:': u'\U0001F46C\U0001F3FB',
    u':dois_homens_de_mãos_dadas_pele_clara_e_pele_morena_clara:': u'\U0001F468\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC',
    u':dois_homens_de_mãos_dadas_pele_clara_e_pele_morena:': u'\U0001F468\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD',
    u':dois_homens_de_mãos_dadas_pele_clara_e_pele_morena_escura:': u'\U0001F468\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE',
    u':dois_homens_de_mãos_dadas_pele_clara_e_pele_escura:': u'\U0001F468\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF',
    u':dois_homens_de_mãos_dadas_pele_morena_clara_e_pele_clara:': u'\U0001F468\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB',
    u':dois_homens_de_mãos_dadas_pele_morena_clara:': u'\U0001F46C\U0001F3FC',
    u':dois_homens_de_mãos_dadas_pele_morena_clara_e_pele_morena:': u'\U0001F468\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD',
    u':dois_homens_de_mãos_dadas_pele_morena_clara_e_pele_morena_escura:': u'\U0001F468\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE',
    u':dois_homens_de_mãos_dadas_pele_morena_clara_e_pele_escura:': u'\U0001F468\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF',
    u':dois_homens_de_mãos_dadas_pele_morena_e_pele_clara:': u'\U0001F468\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB',
    u':dois_homens_de_mãos_dadas_pele_morena_e_pele_morena_clara:': u'\U0001F468\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC',
    u':dois_homens_de_mãos_dadas_pele_morena:': u'\U0001F46C\U0001F3FD',
    u':dois_homens_de_mãos_dadas_pele_morena_e_pele_morena_escura:': u'\U0001F468\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE',
    u':dois_homens_de_mãos_dadas_pele_morena_e_pele_escura:': u'\U0001F468\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF',
    u':dois_homens_de_mãos_dadas_pele_morena_escura_e_pele_clara:': u'\U0001F468\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB',
    u':dois_homens_de_mãos_dadas_pele_morena_escura_e_pele_morena_clara:': u'\U0001F468\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC',
    u':dois_homens_de_mãos_dadas_pele_morena_escura_e_pele_morena:': u'\U0001F468\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD',
    u':dois_homens_de_mãos_dadas_pele_morena_escura:': u'\U0001F46C\U0001F3FE',
    u':dois_homens_de_mãos_dadas_pele_morena_escura_e_pele_escura:': u'\U0001F468\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF',
    u':dois_homens_de_mãos_dadas_pele_escura_e_pele_clara:': u'\U0001F468\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB',
    u':dois_homens_de_mãos_dadas_pele_escura_e_pele_morena_clara:': u'\U0001F468\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC',
    u':dois_homens_de_mãos_dadas_pele_escura_e_pele_morena:': u'\U0001F468\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD',
    u':dois_homens_de_mãos_dadas_pele_escura_e_pele_morena_escura:': u'\U0001F468\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE',
    u':dois_homens_de_mãos_dadas_pele_escura:': u'\U0001F46C\U0001F3FF',
    u':beijo:': u'\U0001F48F',
    u':beijo_mulher_e_homem:': u'\U0001F469\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468',
    u':beijo_homem_e_homem:': u'\U0001F468\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468',
    u':beijo_mulher_e_mulher:': u'\U0001F469\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F469',
    u':casal_apaixonado:': u'\U0001F491',
    u':casal_apaixonado_mulher_e_homem:': u'\U0001F469\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468',
    u':casal_apaixonado_homem_e_homem:': u'\U0001F468\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468',
    u':casal_apaixonado_mulher_e_mulher:': u'\U0001F469\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F469',
    u':família:': u'\U0001F46A',
    u':família_homem_mulher_e_menino:': u'\U0001F468\U0000200D\U0001F469\U0000200D\U0001F466',
    u':família_homem_mulher_e_menina:': u'\U0001F468\U0000200D\U0001F469\U0000200D\U0001F467',
    u':família_homem_mulher_menina_e_menino:': u'\U0001F468\U0000200D\U0001F469\U0000200D\U0001F467\U0000200D\U0001F466',
    u':família_homem_mulher_menino_e_menino:': u'\U0001F468\U0000200D\U0001F469\U0000200D\U0001F466\U0000200D\U0001F466',
    u':família_homem_mulher_menina_e_menina:': u'\U0001F468\U0000200D\U0001F469\U0000200D\U0001F467\U0000200D\U0001F467',
    u':família_homem_homem_e_menino:': u'\U0001F468\U0000200D\U0001F468\U0000200D\U0001F466',
    u':família_homem_homem_e_menina:': u'\U0001F468\U0000200D\U0001F468\U0000200D\U0001F467',
    u':família_homem_homem_menina_e_menino:': u'\U0001F468\U0000200D\U0001F468\U0000200D\U0001F467\U0000200D\U0001F466',
    u':família_homem_homem_menino_e_menino:': u'\U0001F468\U0000200D\U0001F468\U0000200D\U0001F466\U0000200D\U0001F466',
    u':família_homem_homem_menina_e_menina:': u'\U0001F468\U0000200D\U0001F468\U0000200D\U0001F467\U0000200D\U0001F467',
    u':família_mulher_mulher_e_menino:': u'\U0001F469\U0000200D\U0001F469\U0000200D\U0001F466',
    u':família_mulher_mulher_e_menina:': u'\U0001F469\U0000200D\U0001F469\U0000200D\U0001F467',
    u':família_mulher_mulher_menina_e_menino:': u'\U0001F469\U0000200D\U0001F469\U0000200D\U0001F467\U0000200D\U0001F466',
    u':família_mulher_mulher_menino_e_menino:': u'\U0001F469\U0000200D\U0001F469\U0000200D\U0001F466\U0000200D\U0001F466',
    u':família_mulher_mulher_menina_e_menina:': u'\U0001F469\U0000200D\U0001F469\U0000200D\U0001F467\U0000200D\U0001F467',
    u':família_homem_e_menino:': u'\U0001F468\U0000200D\U0001F466',
    u':família_homem_menino_e_menino:': u'\U0001F468\U0000200D\U0001F466\U0000200D\U0001F466',
    u':família_homem_e_menina:': u'\U0001F468\U0000200D\U0001F467',
    u':família_homem_menina_e_menino:': u'\U0001F468\U0000200D\U0001F467\U0000200D\U0001F466',
    u':família_homem_menina_e_menina:': u'\U0001F468\U0000200D\U0001F467\U0000200D\U0001F467',
    u':família_mulher_e_menino:': u'\U0001F469\U0000200D\U0001F466',
    u':família_mulher_menino_e_menino:': u'\U0001F469\U0000200D\U0001F466\U0000200D\U0001F466',
    u':família_mulher_e_menina:': u'\U0001F469\U0000200D\U0001F467',
    u':família_mulher_menina_e_menino:': u'\U0001F469\U0000200D\U0001F467\U0000200D\U0001F466',
    u':família_mulher_menina_e_menina:': u'\U0001F469\U0000200D\U0001F467\U0000200D\U0001F467',
    u':silhueta_falando:': u'\U0001F5E3\U0000FE0F',
    u':silhueta_de_busto:': u'\U0001F464',
    u':silhueta_de_bustos:': u'\U0001F465',
    u':pessoas_se_abraçando:': u'\U0001FAC2',
    u':pegadas:': u'\U0001F463',
    u':pele_clara:': u'\U0001F3FB',
    u':pele_morena_clara:': u'\U0001F3FC',
    u':pele_morena:': u'\U0001F3FD',
    u':pele_morena_escura:': u'\U0001F3FE',
    u':pele_escura:': u'\U0001F3FF',
    u':cabelo_vermelho:': u'\U0001F9B0',
    u':cabelo_cacheado:': u'\U0001F9B1',
    u':cabelo_branco:': u'\U0001F9B3',
    u':careca:': u'\U0001F9B2',
    u':rosto_de_macaco:': u'\U0001F435',
    u':macaco:': u'\U0001F412',
    u':gorila:': u'\U0001F98D',
    u':orangotango:': u'\U0001F9A7',
    u':rosto_de_cachorro:': u'\U0001F436',
    u':cachorro:': u'\U0001F415',
    u':cão-guia:': u'\U0001F9AE',
    u':cão_de_serviço:': u'\U0001F415\U0000200D\U0001F9BA',
    u':poodle:': u'\U0001F429',
    u':rosto_de_lobo:': u'\U0001F43A',
    u':rosto_de_raposa:': u'\U0001F98A',
    u':guaxinim:': u'\U0001F99D',
    u':rosto_de_gato:': u'\U0001F431',
    u':gato:': u'\U0001F408',
    u':gato_preto:': u'\U0001F408\U0000200D\U00002B1B',
    u':rosto_de_leão:': u'\U0001F981',
    u':rosto_de_tigre:': u'\U0001F42F',
    u':tigre:': u'\U0001F405',
    u':leopardo:': u'\U0001F406',
    u':rosto_de_cavalo:': u'\U0001F434',
    u':cavalo:': u'\U0001F40E',
    u':rosto_de_unicórnio:': u'\U0001F984',
    u':zebra:': u'\U0001F993',
    u':cervo:': u'\U0001F98C',
    u':bisão:': u'\U0001F9AC',
    u':rosto_de_vaca:': u'\U0001F42E',
    u':boi:': u'\U0001F402',
    u':búfalo-asiático:': u'\U0001F403',
    u':vaca:': u'\U0001F404',
    u':rosto_de_porco:': u'\U0001F437',
    u':porco:': u'\U0001F416',
    u':javali:': u'\U0001F417',
    u':nariz_de_porco:': u'\U0001F43D',
    u':carneiro:': u'\U0001F40F',
    u':ovelha:': u'\U0001F411',
    u':cabra:': u'\U0001F410',
    u':camelo:': u'\U0001F42A',
    u':camelo_com_duas_corcovas:': u'\U0001F42B',
    u':lhama:': u'\U0001F999',
    u':girafa:': u'\U0001F992',
    u':elefante:': u'\U0001F418',
    u':mamute:': u'\U0001F9A3',
    u':rinoceronte:': u'\U0001F98F',
    u':hipopótamo:': u'\U0001F99B',
    u':rosto_de_camundongo:': u'\U0001F42D',
    u':camundongo:': u'\U0001F401',
    u':rato:': u'\U0001F400',
    u':rosto_de_hamster:': u'\U0001F439',
    u':rosto_de_coelho:': u'\U0001F430',
    u':coelho:': u'\U0001F407',
    u':esquilo:': u'\U0001F43F\U0000FE0F',
    u':castor:': u'\U0001F9AB',
    u':porco-espinho:': u'\U0001F994',
    u':morcego:': u'\U0001F987',
    u':rosto_de_urso:': u'\U0001F43B',
    u':urso_polar:': u'\U0001F43B\U0000200D\U00002744\U0000FE0F',
    u':coala:': u'\U0001F428',
    u':rosto_de_panda:': u'\U0001F43C',
    u':preguiça:': u'\U0001F9A5',
    u':lontra:': u'\U0001F9A6',
    u':gambá:': u'\U0001F9A8',
    u':canguru:': u'\U0001F998',
    u':texugo:': u'\U0001F9A1',
    u':patas:': u'\U0001F43E',
    u':peru:': u'\U0001F983',
    u':galinha:': u'\U0001F414',
    u':galo:': u'\U0001F413',
    u':pintinho_chocando:': u'\U0001F423',
    u':pintinho_de_perfil:': u'\U0001F424',
    u':pintinho_de_frente:': u'\U0001F425',
    u':pássaro:': u'\U0001F426',
    u':pinguim:': u'\U0001F427',
    u':pomba_branca:': u'\U0001F54A\U0000FE0F',
    u':águia:': u'\U0001F985',
    u':pato:': u'\U0001F986',
    u':cisne:': u'\U0001F9A2',
    u':coruja:': u'\U0001F989',
    u':dodô:': u'\U0001F9A4',
    u':pena:': u'\U0001FAB6',
    u':flamingo:': u'\U0001F9A9',
    u':pavão:': u'\U0001F99A',
    u':papagaio:': u'\U0001F99C',
    u':sapo:': u'\U0001F438',
    u':crocodilo:': u'\U0001F40A',
    u':tartaruga:': u'\U0001F422',
    u':lagartixa:': u'\U0001F98E',
    u':cobra:': u'\U0001F40D',
    u':rosto_de_dragão:': u'\U0001F432',
    u':dragão:': u'\U0001F409',
    u':saurópode:': u'\U0001F995',
    u':tiranossauro_rex:': u'\U0001F996',
    u':baleia_esguichando_água:': u'\U0001F433',
    u':baleia:': u'\U0001F40B',
    u':golfinho:': u'\U0001F42C',
    u':foca:': u'\U0001F9AD',
    u':peixe:': u'\U0001F41F',
    u':peixe_tropical:': u'\U0001F420',
    u':baiacu:': u'\U0001F421',
    u':tubarão:': u'\U0001F988',
    u':polvo:': u'\U0001F419',
    u':caramujo:': u'\U0001F41A',
    u':caracol:': u'\U0001F40C',
    u':borboleta:': u'\U0001F98B',
    u':inseto:': u'\U0001F41B',
    u':formiga:': u'\U0001F41C',
    u':abelha:': u'\U0001F41D',
    u':besouro:': u'\U0001FAB2',
    u':joaninha:': u'\U0001F41E',
    u':grilo:': u'\U0001F997',
    u':barata:': u'\U0001FAB3',
    u':aranha:': u'\U0001F577\U0000FE0F',
    u':teia_de_aranha:': u'\U0001F578\U0000FE0F',
    u':escorpião:': u'\U0001F982',
    u':mosquito:': u'\U0001F99F',
    u':mosca:': u'\U0001FAB0',
    u':minhoca:': u'\U0001FAB1',
    u':micróbio:': u'\U0001F9A0',
    u':buquê:': u'\U0001F490',
    u':flor_de_cerejeira:': u'\U0001F338',
    u':flor_branca:': u'\U0001F4AE',
    u':roseta:': u'\U0001F3F5\U0000FE0F',
    u':rosa:': u'\U0001F339',
    u':flor_murcha:': u'\U0001F940',
    u':hibisco:': u'\U0001F33A',
    u':girassol:': u'\U0001F33B',
    u':flor:': u'\U0001F33C',
    u':tulipa:': u'\U0001F337',
    u':muda_de_planta:': u'\U0001F331',
    u':vaso_com_planta:': u'\U0001FAB4',
    u':conífera:': u'\U0001F332',
    u':árvore_caidiça:': u'\U0001F333',
    u':palmeira:': u'\U0001F334',
    u':cacto:': u'\U0001F335',
    u':planta_de_arroz:': u'\U0001F33E',
    u':erva:': u'\U0001F33F',
    u':trevo:': u'\U00002618\U0000FE0F',
    u':trevo_de_quatro_folhas:': u'\U0001F340',
    u':folha_de_bordo:': u'\U0001F341',
    u':folhas_caídas:': u'\U0001F342',
    u':folha_ao_vento:': u'\U0001F343',
    u':uvas:': u'\U0001F347',
    u':melão:': u'\U0001F348',
    u':melancia:': u'\U0001F349',
    u':tangerina:': u'\U0001F34A',
    u':limão:': u'\U0001F34B',
    u':banana:': u'\U0001F34C',
    u':abacaxi:': u'\U0001F34D',
    u':manga:': u'\U0001F96D',
    u':maçã_vermelha:': u'\U0001F34E',
    u':maçã_verde:': u'\U0001F34F',
    u':pera:': u'\U0001F350',
    u':pêssego:': u'\U0001F351',
    u':cereja:': u'\U0001F352',
    u':morango:': u'\U0001F353',
    u':mirtilos:': u'\U0001FAD0',
    u':kiwi:': u'\U0001F95D',
    u':tomate:': u'\U0001F345',
    u':azeitona:': u'\U0001FAD2',
    u':coco:': u'\U0001F965',
    u':abacate:': u'\U0001F951',
    u':berinjela:': u'\U0001F346',
    u':batata:': u'\U0001F954',
    u':cenoura:': u'\U0001F955',
    u':milho:': u'\U0001F33D',
    u':pimenta:': u'\U0001F336\U0000FE0F',
    u':pimentão:': u'\U0001FAD1',
    u':pepino:': u'\U0001F952',
    u':verdura:': u'\U0001F96C',
    u':brócolis:': u'\U0001F966',
    u':alho:': u'\U0001F9C4',
    u':cebola:': u'\U0001F9C5',
    u':cogumelo:': u'\U0001F344',
    u':amendoim:': u'\U0001F95C',
    u':castanha:': u'\U0001F330',
    u':pão:': u'\U0001F35E',
    u':croissant:': u'\U0001F950',
    u':baguete:': u'\U0001F956',
    u':pão_sírio:': u'\U0001FAD3',
    u':pretzel:': u'\U0001F968',
    u':rosca:': u'\U0001F96F',
    u':panquecas:': u'\U0001F95E',
    u':waffle:': u'\U0001F9C7',
    u':queijo:': u'\U0001F9C0',
    u':carne:': u'\U0001F356',
    u':coxa_de_frango:': u'\U0001F357',
    u':corte_de_carne:': u'\U0001F969',
    u':bacon:': u'\U0001F953',
    u':hambúrguer:': u'\U0001F354',
    u':batata_frita:': u'\U0001F35F',
    u':pizza:': u'\U0001F355',
    u':cachorro-quente:': u'\U0001F32D',
    u':sanduíche:': u'\U0001F96A',
    u':taco:': u'\U0001F32E',
    u':burrito:': u'\U0001F32F',
    u':tamale:': u'\U0001FAD4',
    u':pão_recheado:': u'\U0001F959',
    u':falafel:': u'\U0001F9C6',
    u':ovo:': u'\U0001F95A',
    u':ovo_frito:': u'\U0001F373',
    u':caçarola_com_comida:': u'\U0001F958',
    u':panela:': u'\U0001F372',
    u':fondue:': u'\U0001FAD5',
    u':tigela_com_colher:': u'\U0001F963',
    u':salada_verde:': u'\U0001F957',
    u':pipoca:': u'\U0001F37F',
    u':manteiga:': u'\U0001F9C8',
    u':sal:': u'\U0001F9C2',
    u':comida_enlatada:': u'\U0001F96B',
    u':bentô:': u'\U0001F371',
    u':biscoito_de_arroz:': u'\U0001F358',
    u':arroz_japonês:': u'\U0001F359',
    u':arroz_cozido:': u'\U0001F35A',
    u':arroz_com_curry:': u'\U0001F35B',
    u':lámen:': u'\U0001F35C',
    u':espaguete:': u'\U0001F35D',
    u':batata_assada:': u'\U0001F360',
    u':oden:': u'\U0001F362',
    u':sushi:': u'\U0001F363',
    u':camarão_frito:': u'\U0001F364',
    u':bolinho_de_peixe:': u'\U0001F365',
    u':bolo_lunar:': u'\U0001F96E',
    u':dango:': u'\U0001F361',
    u':bolinho_asiático:': u'\U0001F95F',
    u':biscoito_da_sorte:': u'\U0001F960',
    u':caixa_para_viagem:': u'\U0001F961',
    u':caranguejo:': u'\U0001F980',
    u':lagosta:': u'\U0001F99E',
    u':camarão:': u'\U0001F990',
    u':lula:': u'\U0001F991',
    u':ostra:': u'\U0001F9AA',
    u':sorvete_italiano:': u'\U0001F366',
    u':raspadinha_de_gelo:': u'\U0001F367',
    u':sorvete:': u'\U0001F368',
    u':donut:': u'\U0001F369',
    u':biscoito:': u'\U0001F36A',
    u':bolo_de_aniversário:': u'\U0001F382',
    u':pão_de_ló_de_morango:': u'\U0001F370',
    u':cupcake:': u'\U0001F9C1',
    u':torta:': u'\U0001F967',
    u':chocolate:': u'\U0001F36B',
    u':bala:': u'\U0001F36C',
    u':pirulito:': u'\U0001F36D',
    u':pudim:': u'\U0001F36E',
    u':pote_de_mel:': u'\U0001F36F',
    u':mamadeira:': u'\U0001F37C',
    u':copo_de_leite:': u'\U0001F95B',
    u':café:': u'\U00002615',
    u':bule:': u'\U0001FAD6',
    u':xícara_de_chá_sem_alça:': u'\U0001F375',
    u':saquê:': u'\U0001F376',
    u':garrafa_de_champanhe:': u'\U0001F37E',
    u':vinho:': u'\U0001F377',
    u':coquetel:': u'\U0001F378',
    u':bebida_tropical:': u'\U0001F379',
    u':cerveja:': u'\U0001F37A',
    u':canecas_de_cerveja:': u'\U0001F37B',
    u':taças_brindando:': u'\U0001F942',
    u':copo:': u'\U0001F943',
    u':copo_com_canudo:': u'\U0001F964',
    u':chá_perolado:': u'\U0001F9CB',
    u':suco_de_caixa:': u'\U0001F9C3',
    u':mate:': u'\U0001F9C9',
    u':cubo_de_gelo:': u'\U0001F9CA',
    u':hashi:': u'\U0001F962',
    u':prato_com_talheres:': u'\U0001F37D\U0000FE0F',
    u':garfo_e_faca:': u'\U0001F374',
    u':colher:': u'\U0001F944',
    u':faca_de_cozinha:': u'\U0001F52A',
    u':ânfora:': u'\U0001F3FA',
    u':globo_mostrando_europa_e_áfrica:': u'\U0001F30D',
    u':globo_mostrando_as_américas:': u'\U0001F30E',
    u':globo_mostrando_ásia_e_oceania:': u'\U0001F30F',
    u':globo_com_meridianos:': u'\U0001F310',
    u':mapa-múndi:': u'\U0001F5FA\U0000FE0F',
    u':mapa_do_japão:': u'\U0001F5FE',
    u':bússola:': u'\U0001F9ED',
    u':montanha_com_neve:': u'\U0001F3D4\U0000FE0F',
    u':montanha:': u'\U000026F0\U0000FE0F',
    u':vulcão:': u'\U0001F30B',
    u':monte_fuji:': u'\U0001F5FB',
    u':acampamento:': u'\U0001F3D5\U0000FE0F',
    u':praia_e_guarda-sol:': u'\U0001F3D6\U0000FE0F',
    u':deserto:': u'\U0001F3DC\U0000FE0F',
    u':ilha_deserta:': u'\U0001F3DD\U0000FE0F',
    u':parque_nacional:': u'\U0001F3DE\U0000FE0F',
    u':estádio:': u'\U0001F3DF\U0000FE0F',
    u':prédio_grego:': u'\U0001F3DB\U0000FE0F',
    u':construção:': u'\U0001F3D7\U0000FE0F',
    u':tijolo:': u'\U0001F9F1',
    u':pedra:': u'\U0001FAA8',
    u':madeira:': u'\U0001FAB5',
    u':cabana:': u'\U0001F6D6',
    u':casas:': u'\U0001F3D8\U0000FE0F',
    u':casa_abandonada:': u'\U0001F3DA\U0000FE0F',
    u':casa:': u'\U0001F3E0',
    u':casa_com_jardim:': u'\U0001F3E1',
    u':edifício_comercial:': u'\U0001F3E2',
    u':correio_japonês:': u'\U0001F3E3',
    u':correio:': u'\U0001F3E4',
    u':hospital:': u'\U0001F3E5',
    u':banco:': u'\U0001F3E6',
    u':hotel:': u'\U0001F3E8',
    u':motel:': u'\U0001F3E9',
    u':loja_de_conveniência:': u'\U0001F3EA',
    u':escola:': u'\U0001F3EB',
    u':loja_de_departamentos:': u'\U0001F3EC',
    u':fábrica:': u'\U0001F3ED',
    u':castelo_japonês:': u'\U0001F3EF',
    u':castelo:': u'\U0001F3F0',
    u':capela_de_casamento:': u'\U0001F492',
    u':torre_de_tóquio:': u'\U0001F5FC',
    u':estátua_da_liberdade:': u'\U0001F5FD',
    u':igreja:': u'\U000026EA',
    u':mesquita:': u'\U0001F54C',
    u':templo_hindu:': u'\U0001F6D5',
    u':sinagoga:': u'\U0001F54D',
    u':santuário_japonês:': u'\U000026E9\U0000FE0F',
    u':caaba_islã:': u'\U0001F54B',
    u':fonte:': u'\U000026F2',
    u':barraca:': u'\U000026FA',
    u':enevoado:': u'\U0001F301',
    u':noite_estrelada:': u'\U0001F303',
    u':cidade:': u'\U0001F3D9\U0000FE0F',
    u':aurora_sobre_montanhas:': u'\U0001F304',
    u':aurora_sobre_água:': u'\U0001F305',
    u':cidade_ao_anoitecer:': u'\U0001F306',
    u':pôr_do_sol:': u'\U0001F307',
    u':ponte_à_noite:': u'\U0001F309',
    u':chamas:': u'\U00002668\U0000FE0F',
    u':carrossel:': u'\U0001F3A0',
    u':roda_gigante:': u'\U0001F3A1',
    u':montanha_russa:': u'\U0001F3A2',
    u':barbearia:': u'\U0001F488',
    u':circo:': u'\U0001F3AA',
    u':locomotiva:': u'\U0001F682',
    u':vagão_de_trem:': u'\U0001F683',
    u':trem_de_alta_velocidade:': u'\U0001F684',
    u':trem_de_alta_velocidade_japonês:': u'\U0001F685',
    u':trem:': u'\U0001F686',
    u':metrô:': u'\U0001F687',
    u':trem_urbano:': u'\U0001F688',
    u':estação:': u'\U0001F689',
    u':bonde_elétrico:': u'\U0001F68A',
    u':monotrilho:': u'\U0001F69D',
    u':estrada_de_ferro_na_montanha:': u'\U0001F69E',
    u':bonde:': u'\U0001F68B',
    u':ônibus:': u'\U0001F68C',
    u':ônibus_se_aproximando:': u'\U0001F68D',
    u':ônibus_movido_a_eletricidade:': u'\U0001F68E',
    u':van:': u'\U0001F690',
    u':ambulância:': u'\U0001F691',
    u':carro_do_corpo_de_bombeiros:': u'\U0001F692',
    u':viatura_policial:': u'\U0001F693',
    u':viatura_policial_se_aproximando:': u'\U0001F694',
    u':táxi:': u'\U0001F695',
    u':táxi_se_aproximando:': u'\U0001F696',
    u':carro:': u'\U0001F697',
    u':carro_se_aproximando:': u'\U0001F698',
    u':suv:': u'\U0001F699',
    u':caminhonete:': u'\U0001F6FB',
    u':caminhão_de_entrega:': u'\U0001F69A',
    u':caminhão:': u'\U0001F69B',
    u':trator:': u'\U0001F69C',
    u':carro_de_corrida:': u'\U0001F3CE\U0000FE0F',
    u':motocicleta:': u'\U0001F3CD\U0000FE0F',
    u':scooter:': u'\U0001F6F5',
    u':cadeira_de_rodas_manual:': u'\U0001F9BD',
    u':cadeira_de_rodas_motorizada:': u'\U0001F9BC',
    u':automóvel_riquixá:': u'\U0001F6FA',
    u':bicicleta:': u'\U0001F6B2',
    u':patinete:': u'\U0001F6F4',
    u':skate:': u'\U0001F6F9',
    u':patins_de_rodas:': u'\U0001F6FC',
    u':ponto_de_ônibus:': u'\U0001F68F',
    u':estrada:': u'\U0001F6E3\U0000FE0F',
    u':trilhos:': u'\U0001F6E4\U0000FE0F',
    u':barril_de_óleo:': u'\U0001F6E2\U0000FE0F',
    u':posto_de_gasolina:': u'\U000026FD',
    u':sirene:': u'\U0001F6A8',
    u':semáforo_horizontal:': u'\U0001F6A5',
    u':semáforo_vertical:': u'\U0001F6A6',
    u':sinal_de_pare:': u'\U0001F6D1',
    u':em_construção:': u'\U0001F6A7',
    u':âncora:': u'\U00002693',
    u':barco_a_vela:': u'\U000026F5',
    u':canoa:': u'\U0001F6F6',
    u':lancha:': u'\U0001F6A4',
    u':cruzeiro:': u'\U0001F6F3\U0000FE0F',
    u':balsa:': u'\U000026F4\U0000FE0F',
    u':barco:': u'\U0001F6E5\U0000FE0F',
    u':navio:': u'\U0001F6A2',
    u':avião:': u'\U00002708\U0000FE0F',
    u':avião_pequeno:': u'\U0001F6E9\U0000FE0F',
    u':avião_decolando:': u'\U0001F6EB',
    u':avião_aterrissando:': u'\U0001F6EC',
    u':paraquedas:': u'\U0001FA82',
    u':assento:': u'\U0001F4BA',
    u':helicóptero:': u'\U0001F681',
    u':estrada_de_ferro_suspensa:': u'\U0001F69F',
    u':cabo_suspenso_usado_em_teleféricos_nas_montanhas:': u'\U0001F6A0',
    u':teleférico:': u'\U0001F6A1',
    u':satélite:': u'\U0001F6F0\U0000FE0F',
    u':foguete:': u'\U0001F680',
    u':disco_voador:': u'\U0001F6F8',
    u':sineta:': u'\U0001F6CE\U0000FE0F',
    u':mala:': u'\U0001F9F3',
    u':ampulheta:': u'\U0000231B',
    u':ampulheta_cheia_em_cima:': u'\U000023F3',
    u':relógio_de_pulso:': u'\U0000231A',
    u':despertador:': u'\U000023F0',
    u':cronômetro:': u'\U000023F1\U0000FE0F',
    u':relógio_temporizador:': u'\U000023F2\U0000FE0F',
    u':relógio_de_mesa:': u'\U0001F570\U0000FE0F',
    u':12_horas:': u'\U0001F55B',
    u':doze_e_meia:': u'\U0001F567',
    u':1_hora:': u'\U0001F550',
    u':uma_e_meia:': u'\U0001F55C',
    u':2_horas:': u'\U0001F551',
    u':duas_e_meia:': u'\U0001F55D',
    u':3_horas:': u'\U0001F552',
    u':três_e_meia:': u'\U0001F55E',
    u':4_horas:': u'\U0001F553',
    u':quatro_e_meia:': u'\U0001F55F',
    u':5_horas:': u'\U0001F554',
    u':cinco_e_meia:': u'\U0001F560',
    u':6_horas:': u'\U0001F555',
    u':seis_e_meia:': u'\U0001F561',
    u':7_horas:': u'\U0001F556',
    u':sete_e_meia:': u'\U0001F562',
    u':8_horas:': u'\U0001F557',
    u':oito_e_meia:': u'\U0001F563',
    u':9_horas:': u'\U0001F558',
    u':nove_e_meia:': u'\U0001F564',
    u':10_horas:': u'\U0001F559',
    u':dez_e_meia:': u'\U0001F565',
    u':11_horas:': u'\U0001F55A',
    u':onze_e_meia:': u'\U0001F566',
    u':lua_nova:': u'\U0001F311',
    u':lua_crescente_côncava:': u'\U0001F312',
    u':quarto_crescente:': u'\U0001F313',
    u':lua_crescente_convexa:': u'\U0001F314',
    u':lua_cheia:': u'\U0001F315',
    u':lua_minguante_convexa:': u'\U0001F316',
    u':quarto_minguante:': u'\U0001F317',
    u':lua_minguante_côncava:': u'\U0001F318',
    u':lua_crescente:': u'\U0001F319',
    u':rosto_da_lua_nova:': u'\U0001F31A',
    u':rosto_da_lua_de_quarto_crescente:': u'\U0001F31B',
    u':rosto_da_lua_de_quarto_minguante:': u'\U0001F31C',
    u':termômetro:': u'\U0001F321\U0000FE0F',
    u':sol:': u'\U00002600\U0000FE0F',
    u':rosto_da_lua_cheia:': u'\U0001F31D',
    u':rosto_do_sol:': u'\U0001F31E',
    u':planeta_com_anéis:': u'\U0001FA90',
    u':estrela_branca_média:': u'\U00002B50',
    u':estrela_brilhante:': u'\U0001F31F',
    u':estrela_cadente:': u'\U0001F320',
    u':via_láctea:': u'\U0001F30C',
    u':nuvem:': u'\U00002601\U0000FE0F',
    u':sol_por_trás_das_nuvens:': u'\U000026C5',
    u':chuva_com_trovão:': u'\U000026C8\U0000FE0F',
    u':sol_com_nuvens:': u'\U0001F324\U0000FE0F',
    u':nublado:': u'\U0001F325\U0000FE0F',
    u':sol_com_chuva:': u'\U0001F326\U0000FE0F',
    u':nuvem_com_chuva:': u'\U0001F327\U0000FE0F',
    u':nuvem_com_neve:': u'\U0001F328\U0000FE0F',
    u':nuvem_com_trovão:': u'\U0001F329\U0000FE0F',
    u':tornado:': u'\U0001F32A\U0000FE0F',
    u':neblina:': u'\U0001F32B\U0000FE0F',
    u':rosto_de_vento:': u'\U0001F32C\U0000FE0F',
    u':ciclone:': u'\U0001F300',
    u':arco-íris:': u'\U0001F308',
    u':guarda-chuva_fechado:': u'\U0001F302',
    u':guarda-chuva:': u'\U00002602\U0000FE0F',
    u':sombrinha_na_chuva:': u'\U00002614',
    u':guarda-sol:': u'\U000026F1\U0000FE0F',
    u':alta_tensão:': u'\U000026A1',
    u':floco_de_neve:': u'\U00002744\U0000FE0F',
    u':boneco_de_neve:': u'\U00002603\U0000FE0F',
    u':boneco_de_neve_sem_neve:': u'\U000026C4',
    u':cometa:': u'\U00002604\U0000FE0F',
    u':fogo:': u'\U0001F525',
    u':gota:': u'\U0001F4A7',
    u':onda:': u'\U0001F30A',
    u':abóbora_de_halloween:': u'\U0001F383',
    u':árvore_de_natal:': u'\U0001F384',
    u':fogos_de_artifício:': u'\U0001F386',
    u':vela_estrela:': u'\U0001F387',
    u':bombinha:': u'\U0001F9E8',
    u':brilhos:': u'\U00002728',
    u':balão:': u'\U0001F388',
    u':cone_de_festa:': u'\U0001F389',
    u':confete:': u'\U0001F38A',
    u':árvore_de_tanabata:': u'\U0001F38B',
    u':decoração_de_pinhos:': u'\U0001F38D',
    u':bonecas_japonesas:': u'\U0001F38E',
    u':bandeira_de_carpas:': u'\U0001F38F',
    u':carrilhão_de_vento:': u'\U0001F390',
    u':contemplação_da_lua:': u'\U0001F391',
    u':envelope_vermelho:': u'\U0001F9E7',
    u':fita:': u'\U0001F380',
    u':presente:': u'\U0001F381',
    u':fita_de_lembrete:': u'\U0001F397\U0000FE0F',
    u':ingresso_de_cinema:': u'\U0001F39F\U0000FE0F',
    u':ingresso:': u'\U0001F3AB',
    u':medalha_militar:': u'\U0001F396\U0000FE0F',
    u':troféu:': u'\U0001F3C6',
    u':medalha_esportiva:': u'\U0001F3C5',
    u':medalha_de_ouro:': u'\U0001F947',
    u':medalha_de_prata:': u'\U0001F948',
    u':medalha_de_bronze:': u'\U0001F949',
    u':bola_de_futebol:': u'\U000026BD',
    u':bola_de_beisebol:': u'\U000026BE',
    u':softbol:': u'\U0001F94E',
    u':bola_de_basquete:': u'\U0001F3C0',
    u':bola_de_vôlei:': u'\U0001F3D0',
    u':bola_de_futebol_americano:': u'\U0001F3C8',
    u':bola_de_rugby:': u'\U0001F3C9',
    u':tênis:': u'\U0001F3BE',
    u':frisbee:': u'\U0001F94F',
    u':boliche:': u'\U0001F3B3',
    u':críquete:': u'\U0001F3CF',
    u':hóquei_de_campo:': u'\U0001F3D1',
    u':hóquei_no_gelo:': u'\U0001F3D2',
    u':lacrosse:': u'\U0001F94D',
    u':pingue-pongue:': u'\U0001F3D3',
    u':badminton:': u'\U0001F3F8',
    u':luva_de_boxe:': u'\U0001F94A',
    u':quimono_de_artes_marciais:': u'\U0001F94B',
    u':gol:': u'\U0001F945',
    u':bandeira_no_buraco:': u'\U000026F3',
    u':patins_de_gelo:': u'\U000026F8\U0000FE0F',
    u':pesca:': u'\U0001F3A3',
    u':máscara_de_mergulho:': u'\U0001F93F',
    u':camiseta_de_corrida:': u'\U0001F3BD',
    u':esqui:': u'\U0001F3BF',
    u':trenó:': u'\U0001F6F7',
    u':pedra_de_curling:': u'\U0001F94C',
    u':no_alvo:': u'\U0001F3AF',
    u':ioiô:': u'\U0001FA80',
    u':pipa:': u'\U0001FA81',
    u':bilhar:': u'\U0001F3B1',
    u':bola_de_cristal:': u'\U0001F52E',
    u':varinha_mágica:': u'\U0001FA84',
    u':olho_turco:': u'\U0001F9FF',
    u':videogame:': u'\U0001F3AE',
    u':joystick:': u'\U0001F579\U0000FE0F',
    u':caça-níquel:': u'\U0001F3B0',
    u':jogo_de_dado:': u'\U0001F3B2',
    u':quebra-cabeça:': u'\U0001F9E9',
    u':ursinho_de_pelúcia:': u'\U0001F9F8',
    u':pinhata:': u'\U0001FA85',
    u':boneca_russa:': u'\U0001FA86',
    u':naipe_de_espadas:': u'\U00002660\U0000FE0F',
    u':naipe_de_copas:': u'\U00002665\U0000FE0F',
    u':naipe_de_ouros:': u'\U00002666\U0000FE0F',
    u':naipe_de_paus:': u'\U00002663\U0000FE0F',
    u':peão_de_xadrez:': u'\U0000265F\U0000FE0F',
    u':curinga:': u'\U0001F0CF',
    u':dragão_vermelho_de_mahjong:': u'\U0001F004',
    u':carta_de_flores:': u'\U0001F3B4',
    u':máscara:': u'\U0001F3AD',
    u':quadro_emoldurado:': u'\U0001F5BC\U0000FE0F',
    u':paleta_de_tintas:': u'\U0001F3A8',
    u':carretel:': u'\U0001F9F5',
    u':agulha_de_costura:': u'\U0001FAA1',
    u':novelo:': u'\U0001F9F6',
    u':nó:': u'\U0001FAA2',
    u':óculos:': u'\U0001F453',
    u':óculos_escuros:': u'\U0001F576\U0000FE0F',
    u':óculos_de_proteção:': u'\U0001F97D',
    u':jaleco:': u'\U0001F97C',
    u':colete_salva-vidas:': u'\U0001F9BA',
    u':gravata:': u'\U0001F454',
    u':camiseta:': u'\U0001F455',
    u':jeans:': u'\U0001F456',
    u':cachecol:': u'\U0001F9E3',
    u':luvas:': u'\U0001F9E4',
    u':casaco:': u'\U0001F9E5',
    u':meias:': u'\U0001F9E6',
    u':vestido:': u'\U0001F457',
    u':quimono:': u'\U0001F458',
    u':sari:': u'\U0001F97B',
    u':maiô:': u'\U0001FA71',
    u':cueca:': u'\U0001FA72',
    u':shorts:': u'\U0001FA73',
    u':biquíni:': u'\U0001F459',
    u':roupas_femininas:': u'\U0001F45A',
    u':bolsinha:': u'\U0001F45B',
    u':bolsa_de_mão:': u'\U0001F45C',
    u':bolsa_pequena:': u'\U0001F45D',
    u':sacolas_de_compras:': u'\U0001F6CD\U0000FE0F',
    u':mochila:': u'\U0001F392',
    u':chinelo:': u'\U0001FA74',
    u':sapato_masculino:': u'\U0001F45E',
    u':tênis_de_corrida:': u'\U0001F45F',
    u':bota_de_trekking:': u'\U0001F97E',
    u':sapatilha:': u'\U0001F97F',
    u':sapato_de_salto_alto:': u'\U0001F460',
    u':sandália_feminina:': u'\U0001F461',
    u':sapatilha_de_balé:': u'\U0001FA70',
    u':bota_feminina:': u'\U0001F462',
    u':coroa:': u'\U0001F451',
    u':chapéu_feminino:': u'\U0001F452',
    u':cartola:': u'\U0001F3A9',
    u':chapéu_de_formatura:': u'\U0001F393',
    u':boné:': u'\U0001F9E2',
    u':capacete_militar:': u'\U0001FA96',
    u':capacacete_de_socorrista:': u'\U000026D1\U0000FE0F',
    u':rosário_de_oração:': u'\U0001F4FF',
    u':batom:': u'\U0001F484',
    u':anel:': u'\U0001F48D',
    u':pedra_preciosa:': u'\U0001F48E',
    u':alto-falante_silenciado:': u'\U0001F507',
    u':alto-falante_com_volume_baixo:': u'\U0001F508',
    u':alto-falante_com_volume_médio:': u'\U0001F509',
    u':alto-falante_com_volume_alto:': u'\U0001F50A',
    u':buzina:': u'\U0001F4E2',
    u':megafone:': u'\U0001F4E3',
    u':corneta_postal:': u'\U0001F4EF',
    u':sino:': u'\U0001F514',
    u':sino_silenciado:': u'\U0001F515',
    u':partitura_musical:': u'\U0001F3BC',
    u':nota_musical:': u'\U0001F3B5',
    u':notas_musicais:': u'\U0001F3B6',
    u':microfone_de_estúdio:': u'\U0001F399\U0000FE0F',
    u':controle_de_volume:': u'\U0001F39A\U0000FE0F',
    u':botões_giratórios:': u'\U0001F39B\U0000FE0F',
    u':microfone:': u'\U0001F3A4',
    u':fones_de_ouvido:': u'\U0001F3A7',
    u':rádio:': u'\U0001F4FB',
    u':saxofone:': u'\U0001F3B7',
    u':acordeão:': u'\U0001FA97',
    u':guitarra:': u'\U0001F3B8',
    u':teclado_musical:': u'\U0001F3B9',
    u':trompete:': u'\U0001F3BA',
    u':violino:': u'\U0001F3BB',
    u':banjo:': u'\U0001FA95',
    u':tambor:': u'\U0001F941',
    u':tambor_comprido:': u'\U0001FA98',
    u':telefone_celular:': u'\U0001F4F1',
    u':telefone_celular_com_seta:': u'\U0001F4F2',
    u':telefone_no_gancho:': u'\U0000260E\U0000FE0F',
    u':telefone:': u'\U0001F4DE',
    u':pager:': u'\U0001F4DF',
    u':fax:': u'\U0001F4E0',
    u':pilha:': u'\U0001F50B',
    u':tomada_elétrica:': u'\U0001F50C',
    u':laptop:': u'\U0001F4BB',
    u':computador_de_mesa:': u'\U0001F5A5\U0000FE0F',
    u':impressora:': u'\U0001F5A8\U0000FE0F',
    u':teclado:': u'\U00002328\U0000FE0F',
    u':mouse:': u'\U0001F5B1\U0000FE0F',
    u':trackball:': u'\U0001F5B2\U0000FE0F',
    u':minidisc:': u'\U0001F4BD',
    u':disquete:': u'\U0001F4BE',
    u':cd:': u'\U0001F4BF',
    u':dvd:': u'\U0001F4C0',
    u':ábaco:': u'\U0001F9EE',
    u':câmera_de_cinema:': u'\U0001F3A5',
    u':rolo_de_filmes:': u'\U0001F39E\U0000FE0F',
    u':projetor_de_filmes:': u'\U0001F4FD\U0000FE0F',
    u':claquete:': u'\U0001F3AC',
    u':televisão:': u'\U0001F4FA',
    u':câmera:': u'\U0001F4F7',
    u':câmera_com_flash:': u'\U0001F4F8',
    u':câmera_de_vídeo:': u'\U0001F4F9',
    u':videocassete:': u'\U0001F4FC',
    u':lupa_para_a_esquerda:': u'\U0001F50D',
    u':lupa_para_a_direita:': u'\U0001F50E',
    u':vela:': u'\U0001F56F\U0000FE0F',
    u':lâmpada:': u'\U0001F4A1',
    u':lanterna:': u'\U0001F526',
    u':lanterna_vermelha_de_papel:': u'\U0001F3EE',
    u':lâmpada_de_óleo:': u'\U0001FA94',
    u':caderno_decorado:': u'\U0001F4D4',
    u':livro_fechado:': u'\U0001F4D5',
    u':livro_aberto:': u'\U0001F4D6',
    u':livro_verde:': u'\U0001F4D7',
    u':livro_azul:': u'\U0001F4D8',
    u':livro_laranja:': u'\U0001F4D9',
    u':livros:': u'\U0001F4DA',
    u':caderno:': u'\U0001F4D3',
    u':livro_contábil:': u'\U0001F4D2',
    u':página_dobrada:': u'\U0001F4C3',
    u':pergaminho:': u'\U0001F4DC',
    u':página_voltada_para_cima:': u'\U0001F4C4',
    u':jornal:': u'\U0001F4F0',
    u':jornal_enrolado:': u'\U0001F5DE\U0000FE0F',
    u':marcadores_de_página:': u'\U0001F4D1',
    u':marcador_de_página:': u'\U0001F516',
    u':etiqueta:': u'\U0001F3F7\U0000FE0F',
    u':saco_de_dinheiro:': u'\U0001F4B0',
    u':moeda:': u'\U0001FA99',
    u':nota_de_iene:': u'\U0001F4B4',
    u':nota_de_dólar:': u'\U0001F4B5',
    u':nota_de_euro:': u'\U0001F4B6',
    u':nota_de_libra:': u'\U0001F4B7',
    u':dinheiro_voando:': u'\U0001F4B8',
    u':cartão_de_crédito:': u'\U0001F4B3',
    u':recibo:': u'\U0001F9FE',
    u':gráfico_subindo_com_iene:': u'\U0001F4B9',
    u':envelope:': u'\U00002709\U0000FE0F',
    u':e-mail:': u'\U0001F4E7',
    u':envelope_chegando:': u'\U0001F4E8',
    u':envelope_com_seta:': u'\U0001F4E9',
    u':bandeja_de_saída:': u'\U0001F4E4',
    u':bandeja_de_entrada:': u'\U0001F4E5',
    u':pacote:': u'\U0001F4E6',
    u':caixa_de_correio_fechada_com_bandeira_levantada:': u'\U0001F4EB',
    u':caixa_de_correio_fechada_com_bandeira_abaixada:': u'\U0001F4EA',
    u':caixa_de_correio_aberta_com_bandeira_levantada:': u'\U0001F4EC',
    u':caixa_de_correio_aberta_com_bandeira_abaixada:': u'\U0001F4ED',
    u':caixa_de_correio:': u'\U0001F4EE',
    u':urna_eleitoral_com_cédula:': u'\U0001F5F3\U0000FE0F',
    u':lápis:': u'\U0000270F\U0000FE0F',
    u':ponta_de_caneta_tinteiro:': u'\U00002712\U0000FE0F',
    u':caneta_tinteiro:': u'\U0001F58B\U0000FE0F',
    u':caneta:': u'\U0001F58A\U0000FE0F',
    u':pincel:': u'\U0001F58C\U0000FE0F',
    u':giz_de_cera:': u'\U0001F58D\U0000FE0F',
    u':memorando:': u'\U0001F4DD',
    u':maleta:': u'\U0001F4BC',
    u':pasta_de_arquivos:': u'\U0001F4C1',
    u':pasta_de_arquivos_aberta:': u'\U0001F4C2',
    u':divisores_de_pastas:': u'\U0001F5C2\U0000FE0F',
    u':calendário:': u'\U0001F4C5',
    u':calendário_com_folhas_destacáveis:': u'\U0001F4C6',
    u':bloco_espiral:': u'\U0001F5D2\U0000FE0F',
    u':calendário_espiral:': u'\U0001F5D3\U0000FE0F',
    u':índice_de_cartões:': u'\U0001F4C7',
    u':gráfico_subindo:': u'\U0001F4C8',
    u':gráfico_caindo:': u'\U0001F4C9',
    u':gráfico_de_barras:': u'\U0001F4CA',
    u':prancheta:': u'\U0001F4CB',
    u':tacha:': u'\U0001F4CC',
    u':tacha_redonda:': u'\U0001F4CD',
    u':clipe_de_papel:': u'\U0001F4CE',
    u':clipes_de_papel_conectados:': u'\U0001F587\U0000FE0F',
    u':régua_reta:': u'\U0001F4CF',
    u':régua_triangular:': u'\U0001F4D0',
    u':tesoura:': u'\U00002702\U0000FE0F',
    u':caixa_de_arquivos:': u'\U0001F5C3\U0000FE0F',
    u':gavetas_de_escritório:': u'\U0001F5C4\U0000FE0F',
    u':lixeira:': u'\U0001F5D1\U0000FE0F',
    u':cadeado:': u'\U0001F512',
    u':cadeado_aberto:': u'\U0001F513',
    u':cadeado_com_caneta:': u'\U0001F50F',
    u':cadeado_fechado_com_chave:': u'\U0001F510',
    u':chave:': u'\U0001F511',
    u':chave_antiga:': u'\U0001F5DD\U0000FE0F',
    u':martelo:': u'\U0001F528',
    u':machado:': u'\U0001FA93',
    u':picareta:': u'\U000026CF\U0000FE0F',
    u':martelo_e_picareta:': u'\U00002692\U0000FE0F',
    u':martelo_e_chave-inglesa:': u'\U0001F6E0\U0000FE0F',
    u':adaga:': u'\U0001F5E1\U0000FE0F',
    u':espadas_cruzadas:': u'\U00002694\U0000FE0F',
    u':pistola:': u'\U0001F52B',
    u':bumerangue:': u'\U0001FA83',
    u':arco_e_flecha:': u'\U0001F3F9',
    u':escudo:': u'\U0001F6E1\U0000FE0F',
    u':serrote:': u'\U0001FA9A',
    u':chave_inglesa:': u'\U0001F527',
    u':chave_de_fenda:': u'\U0001FA9B',
    u':porca_e_parafuso:': u'\U0001F529',
    u':engrenagem:': u'\U00002699\U0000FE0F',
    u':braçadeira:': u'\U0001F5DC\U0000FE0F',
    u':balança:': u'\U00002696\U0000FE0F',
    u':bengala_para_cegos:': u'\U0001F9AF',
    u':link:': u'\U0001F517',
    u':correntes:': u'\U000026D3\U0000FE0F',
    u':gancho:': u'\U0001FA9D',
    u':caixa_de_ferramentas:': u'\U0001F9F0',
    u':ímã:': u'\U0001F9F2',
    u':escada:': u'\U0001FA9C',
    u':alambique:': u'\U00002697\U0000FE0F',
    u':tubo_de_ensaio:': u'\U0001F9EA',
    u':placa_de_petri:': u'\U0001F9EB',
    u':dna:': u'\U0001F9EC',
    u':microscópio:': u'\U0001F52C',
    u':telescópio:': u'\U0001F52D',
    u':antena_parabólica:': u'\U0001F4E1',
    u':seringa:': u'\U0001F489',
    u':gota_de_sangue:': u'\U0001FA78',
    u':comprimido:': u'\U0001F48A',
    u':atadura_adesiva:': u'\U0001FA79',
    u':estetoscópio:': u'\U0001FA7A',
    u':porta:': u'\U0001F6AA',
    u':elevador:': u'\U0001F6D7',
    u':espelho:': u'\U0001FA9E',
    u':janela:': u'\U0001FA9F',
    u':cama:': u'\U0001F6CF\U0000FE0F',
    u':sofá_e_luminária:': u'\U0001F6CB\U0000FE0F',
    u':cadeira:': u'\U0001FA91',
    u':vaso_sanitário:': u'\U0001F6BD',
    u':desentupidor:': u'\U0001FAA0',
    u':chuveiro:': u'\U0001F6BF',
    u':banheira:': u'\U0001F6C1',
    u':ratoeira:': u'\U0001FAA4',
    u':lâmina:': u'\U0001FA92',
    u':frasco_de_loção:': u'\U0001F9F4',
    u':alfinete_de_segurança:': u'\U0001F9F7',
    u':vassoura:': u'\U0001F9F9',
    u':cesta:': u'\U0001F9FA',
    u':rolo_de_papel:': u'\U0001F9FB',
    u':balde:': u'\U0001FAA3',
    u':sabonete:': u'\U0001F9FC',
    u':escova_de_dentes:': u'\U0001FAA5',
    u':esponja:': u'\U0001F9FD',
    u':extintor_de_incêndio:': u'\U0001F9EF',
    u':carrinho_de_compras:': u'\U0001F6D2',
    u':cigarro:': u'\U0001F6AC',
    u':caixão:': u'\U000026B0\U0000FE0F',
    u':lápide:': u'\U0001FAA6',
    u':urna_funerária:': u'\U000026B1\U0000FE0F',
    u':moai:': u'\U0001F5FF',
    u':placa:': u'\U0001FAA7',
    u':símbolo_de_caixa_automático:': u'\U0001F3E7',
    u':símbolo_de_lixeira:': u'\U0001F6AE',
    u':água_potável:': u'\U0001F6B0',
    u':símbolo_de_cadeira_de_rodas:': u'\U0000267F',
    u':banheiro_masculino:': u'\U0001F6B9',
    u':banheiro_feminino:': u'\U0001F6BA',
    u':banheiro:': u'\U0001F6BB',
    u':símbolo_de_bebê:': u'\U0001F6BC',
    u':wc:': u'\U0001F6BE',
    u':controle_de_passaportes:': u'\U0001F6C2',
    u':alfândega:': u'\U0001F6C3',
    u':restituição_de_bagagem:': u'\U0001F6C4',
    u':depósito_de_bagagem:': u'\U0001F6C5',
    u':aviso:': u'\U000026A0\U0000FE0F',
    u':crianças_atravessando:': u'\U0001F6B8',
    u':entrada_proibida:': u'\U000026D4',
    u':proibido:': u'\U0001F6AB',
    u':proibido_andar_de_bicicleta:': u'\U0001F6B3',
    u':proibido_fumar:': u'\U0001F6AD',
    u':proibido_jogar_lixo_no_chão:': u'\U0001F6AF',
    u':água_não_potável:': u'\U0001F6B1',
    u':proibida_a_passagem_de_pedestres:': u'\U0001F6B7',
    u':proibido_o_uso_de_telefone_celular:': u'\U0001F4F5',
    u':proibido_para_menores_de_18_anos:': u'\U0001F51E',
    u':radioativo:': u'\U00002622\U0000FE0F',
    u':risco_biológico:': u'\U00002623\U0000FE0F',
    u':seta_para_cima:': u'\U00002B06\U0000FE0F',
    u':seta_para_cima_e_para_a_direita:': u'\U00002197\U0000FE0F',
    u':seta_para_a_direita:': u'\U000027A1\U0000FE0F',
    u':seta_para_baixo_e_para_a_direita:': u'\U00002198\U0000FE0F',
    u':seta_para_baixo:': u'\U00002B07\U0000FE0F',
    u':seta_para_baixo_e_para_a_esquerda:': u'\U00002199\U0000FE0F',
    u':seta_para_a_esquerda:': u'\U00002B05\U0000FE0F',
    u':seta_para_cima_e_para_a_esquerda:': u'\U00002196\U0000FE0F',
    u':seta_para_cima_e_para_baixo:': u'\U00002195\U0000FE0F',
    u':seta_para_esquerda_e_direita:': u'\U00002194\U0000FE0F',
    u':seta_curva_da_direita_para_a_esquerda:': u'\U000021A9\U0000FE0F',
    u':seta_curva_da_esquerda_para_a_direita:': u'\U000021AA\U0000FE0F',
    u':seta_para_a_direita_curvada_para_cima:': u'\U00002934\U0000FE0F',
    u':seta_para_a_direita_curvada_para_baixo:': u'\U00002935\U0000FE0F',
    u':setas_verticais_no_sentido_horário:': u'\U0001F503',
    u':botão_de_setas_em_sentido_anti-horário:': u'\U0001F504',
    u':seta_back:': u'\U0001F519',
    u':seta_end:': u'\U0001F51A',
    u':seta_on!:': u'\U0001F51B',
    u':seta_soon:': u'\U0001F51C',
    u':seta_top:': u'\U0001F51D',
    u':local_de_culto:': u'\U0001F6D0',
    u':símbolo_de_átomo:': u'\U0000269B\U0000FE0F',
    u':om:': u'\U0001F549\U0000FE0F',
    u':estrela_de_davi:': u'\U00002721\U0000FE0F',
    u':roda_do_dharma:': u'\U00002638\U0000FE0F',
    u':yin_yang:': u'\U0000262F\U0000FE0F',
    u':cruz_latina:': u'\U0000271D\U0000FE0F',
    u':cruz_ortodoxa:': u'\U00002626\U0000FE0F',
    u':estrela_e_lua_crescente:': u'\U0000262A\U0000FE0F',
    u':símbolo_da_paz:': u'\U0000262E\U0000FE0F',
    u':menorá:': u'\U0001F54E',
    u':estrela_de_seis_pontas:': u'\U0001F52F',
    u':signo_de_áries:': u'\U00002648',
    u':signo_de_touro:': u'\U00002649',
    u':signo_de_gêmeos:': u'\U0000264A',
    u':signo_de_câncer:': u'\U0000264B',
    u':signo_de_leão:': u'\U0000264C',
    u':signo_de_virgem:': u'\U0000264D',
    u':signo_de_libra:': u'\U0000264E',
    u':signo_de_escorpião:': u'\U0000264F',
    u':signo_de_sagitário:': u'\U00002650',
    u':signo_de_capricórnio:': u'\U00002651',
    u':signo_de_aquário:': u'\U00002652',
    u':signo_de_peixes:': u'\U00002653',
    u':signo_de_ofiúco:': u'\U000026CE',
    u':botão_de_músicas_aleatórias:': u'\U0001F500',
    u':botão_de_repetir:': u'\U0001F501',
    u':botão_de_repetir_uma_única_faixa:': u'\U0001F502',
    u':botão_reproduzir:': u'\U000025B6\U0000FE0F',
    u':botão_avançar:': u'\U000023E9',
    u':botão_de_próxima_faixa:': u'\U000023ED\U0000FE0F',
    u':botão_de_reproduzir_ou_pausar:': u'\U000023EF\U0000FE0F',
    u':botão_de_voltar:': u'\U000025C0\U0000FE0F',
    u':botão_de_retroceder:': u'\U000023EA',
    u':botão_de_faixa_anterior:': u'\U000023EE\U0000FE0F',
    u':botão_apontando_para_cima:': u'\U0001F53C',
    u':botão_de_avanço_para_cima:': u'\U000023EB',
    u':botão_apontando_para_baixo:': u'\U0001F53D',
    u':botão_de_avanço_para_baixo:': u'\U000023EC',
    u':botão_pausar:': u'\U000023F8\U0000FE0F',
    u':botão_parar:': u'\U000023F9\U0000FE0F',
    u':botão_gravar:': u'\U000023FA\U0000FE0F',
    u':botão_ejetar:': u'\U000023CF\U0000FE0F',
    u':cinema:': u'\U0001F3A6',
    u':botão_de_diminuir_brilho:': u'\U0001F505',
    u':botão_de_aumentar_brilho:': u'\U0001F506',
    u':barras_de_sinal:': u'\U0001F4F6',
    u':modo_vibratório:': u'\U0001F4F3',
    u':telefone_celular_desligado:': u'\U0001F4F4',
    u':símbolo_de_feminino:': u'\U00002640\U0000FE0F',
    u':símbolo_de_masculino:': u'\U00002642\U0000FE0F',
    u':símbolo_transgênero:': u'\U000026A7\U0000FE0F',
    u':sinal_de_multiplicação:': u'\U00002716\U0000FE0F',
    u':símbolo_de_adição:': u'\U00002795',
    u':símbolo_de_subtração:': u'\U00002796',
    u':símbolo_de_divisão:': u'\U00002797',
    u':infinito:': u'\U0000267E\U0000FE0F',
    u':dupla_exclamação:': u'\U0000203C\U0000FE0F',
    u':exclamação_com_interrogação:': u'\U00002049\U0000FE0F',
    u':ponto_de_interrogação:': u'\U00002753',
    u':ponto_de_interrogação_branco:': u'\U00002754',
    u':ponto_de_exclamação_branco:': u'\U00002755',
    u':ponto_de_exclamação:': u'\U00002757',
    u':travessão_ondulado:': u'\U00003030\U0000FE0F',
    u':câmbio_de_moeda:': u'\U0001F4B1',
    u':cifrão:': u'\U0001F4B2',
    u':símbolo_da_medicina:': u'\U00002695\U0000FE0F',
    u':símbolo_de_reciclagem:': u'\U0000267B\U0000FE0F',
    u':flor-de-lis:': u'\U0000269C\U0000FE0F',
    u':emblema_de_tridente:': u'\U0001F531',
    u':crachá:': u'\U0001F4DB',
    u':símbolo_japonês_de_principiante:': u'\U0001F530',
    u':círculo_grande_oco:': u'\U00002B55',
    u':marca_de_seleção_branca:': u'\U00002705',
    u':caixa_de_seleção_marcada_com_tique:': u'\U00002611\U0000FE0F',
    u':marca_de_seleção:': u'\U00002714\U0000FE0F',
    u':xis:': u'\U0000274C',
    u':botão_de_xis:': u'\U0000274E',
    u':laço_encaracolado:': u'\U000027B0',
    u':loop_encaracolado_duas_vezes:': u'\U000027BF',
    u':sinal_japonês_indicando_início_de_música:': u'\U0000303D\U0000FE0F',
    u':asterisco_de_oito_pontas:': u'\U00002733\U0000FE0F',
    u':estrela_de_oito_pontas:': u'\U00002734\U0000FE0F',
    u':faísca:': u'\U00002747\U0000FE0F',
    u':símbolo_de_copyright:': u'\U000000A9\U0000FE0F',
    u':símbolo_de_registrado:': u'\U000000AE\U0000FE0F',
    u':símbolo_de_marca_registrada:': u'\U00002122\U0000FE0F',
    u':tecla_#:': u'\U00000023\U0000FE0F\U000020E3',
    u':tecla_*:': u'\U0000002A\U0000FE0F\U000020E3',
    u':tecla_0:': u'\U00000030\U0000FE0F\U000020E3',
    u':tecla_1:': u'\U00000031\U0000FE0F\U000020E3',
    u':tecla_2:': u'\U00000032\U0000FE0F\U000020E3',
    u':tecla_3:': u'\U00000033\U0000FE0F\U000020E3',
    u':tecla_4:': u'\U00000034\U0000FE0F\U000020E3',
    u':tecla_5:': u'\U00000035\U0000FE0F\U000020E3',
    u':tecla_6:': u'\U00000036\U0000FE0F\U000020E3',
    u':tecla_7:': u'\U00000037\U0000FE0F\U000020E3',
    u':tecla_8:': u'\U00000038\U0000FE0F\U000020E3',
    u':tecla_9:': u'\U00000039\U0000FE0F\U000020E3',
    u':tecla_10:': u'\U0001F51F',
    u':letras_latinas_maiúsculas:': u'\U0001F520',
    u':letras_latinas_minúsculas:': u'\U0001F521',
    u':números:': u'\U0001F522',
    u':símbolos:': u'\U0001F523',
    u':letras_latinas:': u'\U0001F524',
    u':botão_a_(tipo_sanguíneo):': u'\U0001F170\U0000FE0F',
    u':botão_ab_(tipo_sanguíneo):': u'\U0001F18E',
    u':botão_b_(tipo_sanguíneo):': u'\U0001F171\U0000FE0F',
    u':botão_cl:': u'\U0001F191',
    u':botão_cool:': u'\U0001F192',
    u':botão_free:': u'\U0001F193',
    u':informações:': u'\U00002139\U0000FE0F',
    u':botão_id:': u'\U0001F194',
    u':círculo_com_a_letra_m:': u'\U000024C2\U0000FE0F',
    u':botão_new:': u'\U0001F195',
    u':botão_ng:': u'\U0001F196',
    u':botão_o_(tipo_sanguíneo):': u'\U0001F17E\U0000FE0F',
    u':botão_ok:': u'\U0001F197',
    u':botão_p:': u'\U0001F17F\U0000FE0F',
    u':botão_sos:': u'\U0001F198',
    u':botão_up!:': u'\U0001F199',
    u':botão_vs:': u'\U0001F19A',
    u':botão_japonês_de_“aqui”:': u'\U0001F201',
    u':botão_japonês_de_“taxa_de_serviço”:': u'\U0001F202\U0000FE0F',
    u':botão_japonês_de_“quantidade_mensal”:': u'\U0001F237\U0000FE0F',
    u':botão_japonês_de_“não_gratuito”:': u'\U0001F236',
    u':botão_japonês_de_“reservado”:': u'\U0001F22F',
    u':botão_japonês_de_“barganha”:': u'\U0001F250',
    u':botão_japonês_de_“desconto”:': u'\U0001F239',
    u':botão_japonês_de_“gratuito”:': u'\U0001F21A',
    u':botão_japonês_de_“proibido”:': u'\U0001F232',
    u':botão_japonês_de_“aceitável”:': u'\U0001F251',
    u':botão_japonês_de_“aplicação”:': u'\U0001F238',
    u':botão_japonês_de_“nota_mínima”:': u'\U0001F234',
    u':botão_japonês_de_“vago”:': u'\U0001F233',
    u':botão_japonês_de_“parabéns”:': u'\U00003297\U0000FE0F',
    u':botão_japonês_de_“segredo”:': u'\U00003299\U0000FE0F',
    u':botão_japonês_de_“aberto_para_negócios”:': u'\U0001F23A',
    u':botão_japonês_de_“sem_vagas”:': u'\U0001F235',
    u':círculo_vermelho:': u'\U0001F534',
    u':círculo_laranja:': u'\U0001F7E0',
    u':círculo_amarelo:': u'\U0001F7E1',
    u':círculo_verde:': u'\U0001F7E2',
    u':círculo_azul:': u'\U0001F535',
    u':círculo_roxo:': u'\U0001F7E3',
    u':círculo_marrom:': u'\U0001F7E4',
    u':círculo_preto:': u'\U000026AB',
    u':círculo_branco:': u'\U000026AA',
    u':quadrado_vermelho:': u'\U0001F7E5',
    u':quadrado_laranja:': u'\U0001F7E7',
    u':quadrado_amarelo:': u'\U0001F7E8',
    u':quadrado_verde:': u'\U0001F7E9',
    u':quadrado_azul:': u'\U0001F7E6',
    u':quadrado_roxo:': u'\U0001F7EA',
    u':quadrado_marrom:': u'\U0001F7EB',
    u':quadrado_preto_grande:': u'\U00002B1B',
    u':quadrado_branco_grande:': u'\U00002B1C',
    u':quadrado_preto_médio:': u'\U000025FC\U0000FE0F',
    u':quadrado_branco_médio:': u'\U000025FB\U0000FE0F',
    u':quadrado_preto_médio_menor:': u'\U000025FE',
    u':quadrado_branco_médio_menor:': u'\U000025FD',
    u':quadrado_preto_pequeno:': u'\U000025AA\U0000FE0F',
    u':quadrado_branco_pequeno:': u'\U000025AB\U0000FE0F',
    u':losango_laranja_grande:': u'\U0001F536',
    u':losango_azul_grande:': u'\U0001F537',
    u':losango_laranja_pequeno:': u'\U0001F538',
    u':losango_azul_pequeno:': u'\U0001F539',
    u':triângulo_vermelho_para_cima:': u'\U0001F53A',
    u':triângulo_vermelho_para_baixo:': u'\U0001F53B',
    u':diamante_com_um_ponto:': u'\U0001F4A0',
    u':botão_de_opção:': u'\U0001F518',
    u':botão_quadrado_branco:': u'\U0001F533',
    u':botão_quadrado_preto:': u'\U0001F532',
    u':bandeira_quadriculada:': u'\U0001F3C1',
    u':bandeira_triangular:': u'\U0001F6A9',
    u':bandeiras_cruzadas:': u'\U0001F38C',
    u':bandeira_preta:': u'\U0001F3F4',
    u':bandeira_branca:': u'\U0001F3F3\U0000FE0F',
    u':bandeira_do_arco-íris:': u'\U0001F3F3\U0000FE0F\U0000200D\U0001F308',
    u':bandeira_transgênero:': u'\U0001F3F3\U0000FE0F\U0000200D\U000026A7\U0000FE0F',
    u':bandeira_de_pirata:': u'\U0001F3F4\U0000200D\U00002620\U0000FE0F',
    u':bandeira_ilha_de_ascensão:': u'\U0001F1E6\U0001F1E8',
    u':bandeira_andorra:': u'\U0001F1E6\U0001F1E9',
    u':bandeira_emirados_árabes_unidos:': u'\U0001F1E6\U0001F1EA',
    u':bandeira_afeganistão:': u'\U0001F1E6\U0001F1EB',
    u':bandeira_antígua_e_barbuda:': u'\U0001F1E6\U0001F1EC',
    u':bandeira_anguila:': u'\U0001F1E6\U0001F1EE',
    u':bandeira_albânia:': u'\U0001F1E6\U0001F1F1',
    u':bandeira_armênia:': u'\U0001F1E6\U0001F1F2',
    u':bandeira_angola:': u'\U0001F1E6\U0001F1F4',
    u':bandeira_antártida:': u'\U0001F1E6\U0001F1F6',
    u':bandeira_argentina:': u'\U0001F1E6\U0001F1F7',
    u':bandeira_samoa_americana:': u'\U0001F1E6\U0001F1F8',
    u':bandeira_áustria:': u'\U0001F1E6\U0001F1F9',
    u':bandeira_austrália:': u'\U0001F1E6\U0001F1FA',
    u':bandeira_aruba:': u'\U0001F1E6\U0001F1FC',
    u':bandeira_ilhas_aland:': u'\U0001F1E6\U0001F1FD',
    u':bandeira_azerbaijão:': u'\U0001F1E6\U0001F1FF',
    u':bandeira_bósnia_e_herzegovina:': u'\U0001F1E7\U0001F1E6',
    u':bandeira_barbados:': u'\U0001F1E7\U0001F1E7',
    u':bandeira_bangladesh:': u'\U0001F1E7\U0001F1E9',
    u':bandeira_bélgica:': u'\U0001F1E7\U0001F1EA',
    u':bandeira_burquina_faso:': u'\U0001F1E7\U0001F1EB',
    u':bandeira_bulgária:': u'\U0001F1E7\U0001F1EC',
    u':bandeira_bahrein:': u'\U0001F1E7\U0001F1ED',
    u':bandeira_burundi:': u'\U0001F1E7\U0001F1EE',
    u':bandeira_benin:': u'\U0001F1E7\U0001F1EF',
    u':bandeira_são_bartolomeu:': u'\U0001F1E7\U0001F1F1',
    u':bandeira_bermudas:': u'\U0001F1E7\U0001F1F2',
    u':bandeira_brunei:': u'\U0001F1E7\U0001F1F3',
    u':bandeira_bolívia:': u'\U0001F1E7\U0001F1F4',
    u':bandeira_países_baixos_caribenhos:': u'\U0001F1E7\U0001F1F6',
    u':bandeira_brasil:': u'\U0001F1E7\U0001F1F7',
    u':bandeira_bahamas:': u'\U0001F1E7\U0001F1F8',
    u':bandeira_butão:': u'\U0001F1E7\U0001F1F9',
    u':bandeira_ilha_bouvet:': u'\U0001F1E7\U0001F1FB',
    u':bandeira_botsuana:': u'\U0001F1E7\U0001F1FC',
    u':bandeira_bielorrússia:': u'\U0001F1E7\U0001F1FE',
    u':bandeira_belize:': u'\U0001F1E7\U0001F1FF',
    u':bandeira_canadá:': u'\U0001F1E8\U0001F1E6',
    u':bandeira_ilhas_cocos_(keeling):': u'\U0001F1E8\U0001F1E8',
    u':bandeira_congo_–_kinshasa:': u'\U0001F1E8\U0001F1E9',
    u':bandeira_república_centro-africana:': u'\U0001F1E8\U0001F1EB',
    u':bandeira_república_do_congo:': u'\U0001F1E8\U0001F1EC',
    u':bandeira_suíça:': u'\U0001F1E8\U0001F1ED',
    u':bandeira_costa_do_marfim:': u'\U0001F1E8\U0001F1EE',
    u':bandeira_ilhas_cook:': u'\U0001F1E8\U0001F1F0',
    u':bandeira_chile:': u'\U0001F1E8\U0001F1F1',
    u':bandeira_camarões:': u'\U0001F1E8\U0001F1F2',
    u':bandeira_china:': u'\U0001F1E8\U0001F1F3',
    u':bandeira_colômbia:': u'\U0001F1E8\U0001F1F4',
    u':bandeira_ilha_de_clipperton:': u'\U0001F1E8\U0001F1F5',
    u':bandeira_costa_rica:': u'\U0001F1E8\U0001F1F7',
    u':bandeira_cuba:': u'\U0001F1E8\U0001F1FA',
    u':bandeira_cabo_verde:': u'\U0001F1E8\U0001F1FB',
    u':bandeira_curaçao:': u'\U0001F1E8\U0001F1FC',
    u':bandeira_ilha_christmas:': u'\U0001F1E8\U0001F1FD',
    u':bandeira_chipre:': u'\U0001F1E8\U0001F1FE',
    u':bandeira_tchéquia:': u'\U0001F1E8\U0001F1FF',
    u':bandeira_alemanha:': u'\U0001F1E9\U0001F1EA',
    u':bandeira_diego_garcia:': u'\U0001F1E9\U0001F1EC',
    u':bandeira_djibuti:': u'\U0001F1E9\U0001F1EF',
    u':bandeira_dinamarca:': u'\U0001F1E9\U0001F1F0',
    u':bandeira_dominica:': u'\U0001F1E9\U0001F1F2',
    u':bandeira_república_dominicana:': u'\U0001F1E9\U0001F1F4',
    u':bandeira_argélia:': u'\U0001F1E9\U0001F1FF',
    u':bandeira_ceuta_e_melilla:': u'\U0001F1EA\U0001F1E6',
    u':bandeira_equador:': u'\U0001F1EA\U0001F1E8',
    u':bandeira_estônia:': u'\U0001F1EA\U0001F1EA',
    u':bandeira_egito:': u'\U0001F1EA\U0001F1EC',
    u':bandeira_saara_ocidental:': u'\U0001F1EA\U0001F1ED',
    u':bandeira_eritreia:': u'\U0001F1EA\U0001F1F7',
    u':bandeira_espanha:': u'\U0001F1EA\U0001F1F8',
    u':bandeira_etiópia:': u'\U0001F1EA\U0001F1F9',
    u':bandeira_união_europeia:': u'\U0001F1EA\U0001F1FA',
    u':bandeira_finlândia:': u'\U0001F1EB\U0001F1EE',
    u':bandeira_fiji:': u'\U0001F1EB\U0001F1EF',
    u':bandeira_ilhas_malvinas:': u'\U0001F1EB\U0001F1F0',
    u':bandeira_micronésia:': u'\U0001F1EB\U0001F1F2',
    u':bandeira_ilhas_faroe:': u'\U0001F1EB\U0001F1F4',
    u':bandeira_frança:': u'\U0001F1EB\U0001F1F7',
    u':bandeira_gabão:': u'\U0001F1EC\U0001F1E6',
    u':bandeira_reino_unido:': u'\U0001F1EC\U0001F1E7',
    u':bandeira_granada:': u'\U0001F1EC\U0001F1E9',
    u':bandeira_geórgia:': u'\U0001F1EC\U0001F1EA',
    u':bandeira_guiana_francesa:': u'\U0001F1EC\U0001F1EB',
    u':bandeira_guernsey:': u'\U0001F1EC\U0001F1EC',
    u':bandeira_gana:': u'\U0001F1EC\U0001F1ED',
    u':bandeira_gibraltar:': u'\U0001F1EC\U0001F1EE',
    u':bandeira_groenlândia:': u'\U0001F1EC\U0001F1F1',
    u':bandeira_gâmbia:': u'\U0001F1EC\U0001F1F2',
    u':bandeira_guiné:': u'\U0001F1EC\U0001F1F3',
    u':bandeira_guadalupe:': u'\U0001F1EC\U0001F1F5',
    u':bandeira_guiné_equatorial:': u'\U0001F1EC\U0001F1F6',
    u':bandeira_grécia:': u'\U0001F1EC\U0001F1F7',
    u':bandeira_ilhas_geórgia_do_sul_e_sandwich_do_sul:': u'\U0001F1EC\U0001F1F8',
    u':bandeira_guatemala:': u'\U0001F1EC\U0001F1F9',
    u':bandeira_guam:': u'\U0001F1EC\U0001F1FA',
    u':bandeira_guiné-bissau:': u'\U0001F1EC\U0001F1FC',
    u':bandeira_guiana:': u'\U0001F1EC\U0001F1FE',
    u':bandeira_hong_kong_rae_da_china:': u'\U0001F1ED\U0001F1F0',
    u':bandeira_ilhas_heard_e_mcdonald:': u'\U0001F1ED\U0001F1F2',
    u':bandeira_honduras:': u'\U0001F1ED\U0001F1F3',
    u':bandeira_croácia:': u'\U0001F1ED\U0001F1F7',
    u':bandeira_haiti:': u'\U0001F1ED\U0001F1F9',
    u':bandeira_hungria:': u'\U0001F1ED\U0001F1FA',
    u':bandeira_ilhas_canárias:': u'\U0001F1EE\U0001F1E8',
    u':bandeira_indonésia:': u'\U0001F1EE\U0001F1E9',
    u':bandeira_irlanda:': u'\U0001F1EE\U0001F1EA',
    u':bandeira_israel:': u'\U0001F1EE\U0001F1F1',
    u':bandeira_ilha_de_man:': u'\U0001F1EE\U0001F1F2',
    u':bandeira_índia:': u'\U0001F1EE\U0001F1F3',
    u':bandeira_território_britânico_do_oceano_índico:': u'\U0001F1EE\U0001F1F4',
    u':bandeira_iraque:': u'\U0001F1EE\U0001F1F6',
    u':bandeira_irã:': u'\U0001F1EE\U0001F1F7',
    u':bandeira_islândia:': u'\U0001F1EE\U0001F1F8',
    u':bandeira_itália:': u'\U0001F1EE\U0001F1F9',
    u':bandeira_jersey:': u'\U0001F1EF\U0001F1EA',
    u':bandeira_jamaica:': u'\U0001F1EF\U0001F1F2',
    u':bandeira_jordânia:': u'\U0001F1EF\U0001F1F4',
    u':bandeira_japão:': u'\U0001F1EF\U0001F1F5',
    u':bandeira_quênia:': u'\U0001F1F0\U0001F1EA',
    u':bandeira_quirguistão:': u'\U0001F1F0\U0001F1EC',
    u':bandeira_camboja:': u'\U0001F1F0\U0001F1ED',
    u':bandeira_quiribati:': u'\U0001F1F0\U0001F1EE',
    u':bandeira_comores:': u'\U0001F1F0\U0001F1F2',
    u':bandeira_são_cristóvão_e_névis:': u'\U0001F1F0\U0001F1F3',
    u':bandeira_coreia_do_norte:': u'\U0001F1F0\U0001F1F5',
    u':bandeira_coreia_do_sul:': u'\U0001F1F0\U0001F1F7',
    u':bandeira_kuwait:': u'\U0001F1F0\U0001F1FC',
    u':bandeira_ilhas_cayman:': u'\U0001F1F0\U0001F1FE',
    u':bandeira_cazaquistão:': u'\U0001F1F0\U0001F1FF',
    u':bandeira_laos:': u'\U0001F1F1\U0001F1E6',
    u':bandeira_líbano:': u'\U0001F1F1\U0001F1E7',
    u':bandeira_santa_lúcia:': u'\U0001F1F1\U0001F1E8',
    u':bandeira_liechtenstein:': u'\U0001F1F1\U0001F1EE',
    u':bandeira_sri_lanka:': u'\U0001F1F1\U0001F1F0',
    u':bandeira_libéria:': u'\U0001F1F1\U0001F1F7',
    u':bandeira_lesoto:': u'\U0001F1F1\U0001F1F8',
    u':bandeira_lituânia:': u'\U0001F1F1\U0001F1F9',
    u':bandeira_luxemburgo:': u'\U0001F1F1\U0001F1FA',
    u':bandeira_letônia:': u'\U0001F1F1\U0001F1FB',
    u':bandeira_líbia:': u'\U0001F1F1\U0001F1FE',
    u':bandeira_marrocos:': u'\U0001F1F2\U0001F1E6',
    u':bandeira_mônaco:': u'\U0001F1F2\U0001F1E8',
    u':bandeira_moldova:': u'\U0001F1F2\U0001F1E9',
    u':bandeira_montenegro:': u'\U0001F1F2\U0001F1EA',
    u':bandeira_são_martinho:': u'\U0001F1F2\U0001F1EB',
    u':bandeira_madagascar:': u'\U0001F1F2\U0001F1EC',
    u':bandeira_ilhas_marshall:': u'\U0001F1F2\U0001F1ED',
    u':bandeira_macedônia_do_norte:': u'\U0001F1F2\U0001F1F0',
    u':bandeira_mali:': u'\U0001F1F2\U0001F1F1',
    u':bandeira_mianmar_(birmânia):': u'\U0001F1F2\U0001F1F2',
    u':bandeira_mongólia:': u'\U0001F1F2\U0001F1F3',
    u':bandeira_macau_rae_da_china:': u'\U0001F1F2\U0001F1F4',
    u':bandeira_ilhas_marianas_do_norte:': u'\U0001F1F2\U0001F1F5',
    u':bandeira_martinica:': u'\U0001F1F2\U0001F1F6',
    u':bandeira_mauritânia:': u'\U0001F1F2\U0001F1F7',
    u':bandeira_montserrat:': u'\U0001F1F2\U0001F1F8',
    u':bandeira_malta:': u'\U0001F1F2\U0001F1F9',
    u':bandeira_maurício:': u'\U0001F1F2\U0001F1FA',
    u':bandeira_maldivas:': u'\U0001F1F2\U0001F1FB',
    u':bandeira_malaui:': u'\U0001F1F2\U0001F1FC',
    u':bandeira_méxico:': u'\U0001F1F2\U0001F1FD',
    u':bandeira_malásia:': u'\U0001F1F2\U0001F1FE',
    u':bandeira_moçambique:': u'\U0001F1F2\U0001F1FF',
    u':bandeira_namíbia:': u'\U0001F1F3\U0001F1E6',
    u':bandeira_nova_caledônia:': u'\U0001F1F3\U0001F1E8',
    u':bandeira_níger:': u'\U0001F1F3\U0001F1EA',
    u':bandeira_ilha_norfolk:': u'\U0001F1F3\U0001F1EB',
    u':bandeira_nigéria:': u'\U0001F1F3\U0001F1EC',
    u':bandeira_nicarágua:': u'\U0001F1F3\U0001F1EE',
    u':bandeira_países_baixos:': u'\U0001F1F3\U0001F1F1',
    u':bandeira_noruega:': u'\U0001F1F3\U0001F1F4',
    u':bandeira_nepal:': u'\U0001F1F3\U0001F1F5',
    u':bandeira_nauru:': u'\U0001F1F3\U0001F1F7',
    u':bandeira_niue:': u'\U0001F1F3\U0001F1FA',
    u':bandeira_nova_zelândia:': u'\U0001F1F3\U0001F1FF',
    u':bandeira_omã:': u'\U0001F1F4\U0001F1F2',
    u':bandeira_panamá:': u'\U0001F1F5\U0001F1E6',
    u':bandeira_peru:': u'\U0001F1F5\U0001F1EA',
    u':bandeira_polinésia_francesa:': u'\U0001F1F5\U0001F1EB',
    u':bandeira_papua-nova_guiné:': u'\U0001F1F5\U0001F1EC',
    u':bandeira_filipinas:': u'\U0001F1F5\U0001F1ED',
    u':bandeira_paquistão:': u'\U0001F1F5\U0001F1F0',
    u':bandeira_polônia:': u'\U0001F1F5\U0001F1F1',
    u':bandeira_são_pedro_e_miquelão:': u'\U0001F1F5\U0001F1F2',
    u':bandeira_ilhas_pitcairn:': u'\U0001F1F5\U0001F1F3',
    u':bandeira_porto_rico:': u'\U0001F1F5\U0001F1F7',
    u':bandeira_territórios_palestinos:': u'\U0001F1F5\U0001F1F8',
    u':bandeira_portugal:': u'\U0001F1F5\U0001F1F9',
    u':bandeira_palau:': u'\U0001F1F5\U0001F1FC',
    u':bandeira_paraguai:': u'\U0001F1F5\U0001F1FE',
    u':bandeira_catar:': u'\U0001F1F6\U0001F1E6',
    u':bandeira_reunião:': u'\U0001F1F7\U0001F1EA',
    u':bandeira_romênia:': u'\U0001F1F7\U0001F1F4',
    u':bandeira_sérvia:': u'\U0001F1F7\U0001F1F8',
    u':bandeira_rússia:': u'\U0001F1F7\U0001F1FA',
    u':bandeira_ruanda:': u'\U0001F1F7\U0001F1FC',
    u':bandeira_arábia_saudita:': u'\U0001F1F8\U0001F1E6',
    u':bandeira_ilhas_salomão:': u'\U0001F1F8\U0001F1E7',
    u':bandeira_seicheles:': u'\U0001F1F8\U0001F1E8',
    u':bandeira_sudão:': u'\U0001F1F8\U0001F1E9',
    u':bandeira_suécia:': u'\U0001F1F8\U0001F1EA',
    u':bandeira_singapura:': u'\U0001F1F8\U0001F1EC',
    u':bandeira_santa_helena:': u'\U0001F1F8\U0001F1ED',
    u':bandeira_eslovênia:': u'\U0001F1F8\U0001F1EE',
    u':bandeira_svalbard_e_jan_mayen:': u'\U0001F1F8\U0001F1EF',
    u':bandeira_eslováquia:': u'\U0001F1F8\U0001F1F0',
    u':bandeira_serra_leoa:': u'\U0001F1F8\U0001F1F1',
    u':bandeira_san_marino:': u'\U0001F1F8\U0001F1F2',
    u':bandeira_senegal:': u'\U0001F1F8\U0001F1F3',
    u':bandeira_somália:': u'\U0001F1F8\U0001F1F4',
    u':bandeira_suriname:': u'\U0001F1F8\U0001F1F7',
    u':bandeira_sudão_do_sul:': u'\U0001F1F8\U0001F1F8',
    u':bandeira_são_tomé_e_príncipe:': u'\U0001F1F8\U0001F1F9',
    u':bandeira_el_salvador:': u'\U0001F1F8\U0001F1FB',
    u':bandeira_sint_maarten:': u'\U0001F1F8\U0001F1FD',
    u':bandeira_síria:': u'\U0001F1F8\U0001F1FE',
    u':bandeira_essuatíni:': u'\U0001F1F8\U0001F1FF',
    u':bandeira_tristão_da_cunha:': u'\U0001F1F9\U0001F1E6',
    u':bandeira_ilhas_turcas_e_caicos:': u'\U0001F1F9\U0001F1E8',
    u':bandeira_chade:': u'\U0001F1F9\U0001F1E9',
    u':bandeira_territórios_franceses_do_sul:': u'\U0001F1F9\U0001F1EB',
    u':bandeira_togo:': u'\U0001F1F9\U0001F1EC',
    u':bandeira_tailândia:': u'\U0001F1F9\U0001F1ED',
    u':bandeira_tadjiquistão:': u'\U0001F1F9\U0001F1EF',
    u':bandeira_tokelau:': u'\U0001F1F9\U0001F1F0',
    u':bandeira_timor-leste:': u'\U0001F1F9\U0001F1F1',
    u':bandeira_turcomenistão:': u'\U0001F1F9\U0001F1F2',
    u':bandeira_tunísia:': u'\U0001F1F9\U0001F1F3',
    u':bandeira_tonga:': u'\U0001F1F9\U0001F1F4',
    u':bandeira_turquia:': u'\U0001F1F9\U0001F1F7',
    u':bandeira_trinidad_e_tobago:': u'\U0001F1F9\U0001F1F9',
    u':bandeira_tuvalu:': u'\U0001F1F9\U0001F1FB',
    u':bandeira_taiwan:': u'\U0001F1F9\U0001F1FC',
    u':bandeira_tanzânia:': u'\U0001F1F9\U0001F1FF',
    u':bandeira_ucrânia:': u'\U0001F1FA\U0001F1E6',
    u':bandeira_uganda:': u'\U0001F1FA\U0001F1EC',
    u':bandeira_ilhas_menores_distantes_dos_eua:': u'\U0001F1FA\U0001F1F2',
    u':bandeira_nações_unidas:': u'\U0001F1FA\U0001F1F3',
    u':bandeira_estados_unidos:': u'\U0001F1FA\U0001F1F8',
    u':bandeira_uruguai:': u'\U0001F1FA\U0001F1FE',
    u':bandeira_uzbequistão:': u'\U0001F1FA\U0001F1FF',
    u':bandeira_cidade_do_vaticano:': u'\U0001F1FB\U0001F1E6',
    u':bandeira_são_vicente_e_granadinas:': u'\U0001F1FB\U0001F1E8',
    u':bandeira_venezuela:': u'\U0001F1FB\U0001F1EA',
    u':bandeira_ilhas_virgens_britânicas:': u'\U0001F1FB\U0001F1EC',
    u':bandeira_ilhas_virgens_americanas:': u'\U0001F1FB\U0001F1EE',
    u':bandeira_vietnã:': u'\U0001F1FB\U0001F1F3',
    u':bandeira_vanuatu:': u'\U0001F1FB\U0001F1FA',
    u':bandeira_wallis_e_futuna:': u'\U0001F1FC\U0001F1EB',
    u':bandeira_samoa:': u'\U0001F1FC\U0001F1F8',
    u':bandeira_kosovo:': u'\U0001F1FD\U0001F1F0',
    u':bandeira_iêmen:': u'\U0001F1FE\U0001F1EA',
    u':bandeira_mayotte:': u'\U0001F1FE\U0001F1F9',
    u':bandeira_áfrica_do_sul:': u'\U0001F1FF\U0001F1E6',
    u':bandeira_zâmbia:': u'\U0001F1FF\U0001F1F2',
    u':bandeira_zimbábue:': u'\U0001F1FF\U0001F1FC',
    u':bandeira_inglaterra:': u'\U0001F3F4\U000E0067\U000E0062\U000E0065\U000E006E\U000E0067\U000E007F',
    u':bandeira_escócia:': u'\U0001F3F4\U000E0067\U000E0062\U000E0073\U000E0063\U000E0074\U000E007F',
    u':bandeira_país_de_gales:': u'\U0001F3F4\U000E0067\U000E0062\U000E0077\U000E006C\U000E0073\U000E007F',
}

UNICODE_EMOJI_PORTUGUESE = {v: k for k, v in EMOJI_UNICODE_PORTUGUESE.items()}
