if(NOT PKG_CONFIG_FOUND)
    INCLUDE(FindPkgConfig)
endif()
PKG_CHECK_MODULES(PC_SNDFILE "sndfile")

FIND_PATH(SNDFILE_INCLUDE_DIRS
    NAMES sndfile.h
    HINTS ${PC_SNDFILE_INCLUDE_DIR}
    ${CMAKE_INSTALL_PREFIX}/include
    PATHS
    /usr/local/include
    /usr/include
)

FIND_LIBRARY(SNDFILE_LIBRARIES
    NAMES sndfile ${SNDFILE_LIBRARY_NAME}
    HINTS ${PC_SNDFILE_LIBDIR}
    ${CMAKE_INSTALL_PREFIX}/lib
    ${CMAKE_INSTALL_PREFIX}/lib64
    PATHS
    ${SNDFILE_INCLUDE_DIRS}/../lib
    /usr/local/lib
    /usr/lib
)

INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(SNDFILE DEFAULT_MSG SNDFILE_LIBRARIES SNDFILE_INCLUDE_DIRS)
MARK_AS_ADVANCED(SNDFILE_LIBRARIES SNDFILE_INCLUDE_DIRS)

if (SNDFILE_FOUND AND NOT TARGET sndfile::sndfile)
  add_library(sndfile::sndfile INTERFACE IMPORTED)
  set_target_properties(sndfile::sndfile PROPERTIES
    INTERFACE_INCLUDE_DIRECTORIES "${SNDFILE_INCLUDE_DIRS}"
    INTERFACE_LINK_LIBRARIES "${SNDFILE_LIBRARIES}"
  )
endif()
