/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.gitlog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.cucadiagram.Display;

public class GNode {
    private final List<GNode> up = new ArrayList<GNode>();
    private final List<GNode> down = new ArrayList<GNode>();
    private final List<String> texts = new ArrayList<String>();
    private String comment;

    public void addText(String text) {
        this.texts.add(text);
    }

    public boolean isTop() {
        return this.up.size() == 0;
    }

    public final String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public static void link(GNode n1, GNode n2) {
        n1.down.add(n2);
        n2.up.add(n1);
    }

    public String toString() {
        return this.texts.toString();
    }

    public Display getDisplay() {
        return Display.create(this.texts);
    }

    public Collection<GNode> getDowns() {
        return Collections.unmodifiableCollection(this.down);
    }

    public boolean canEatTheNextOne() {
        if (this.up.size() != 1) {
            return false;
        }
        if (this.down.size() != 1) {
            return false;
        }
        GNode next = this.down.get(0);
        if (next.up.size() != 1) {
            return false;
        }
        return next.down.size() == 1;
    }

    public GNode eatTheNextOne() {
        if (!this.canEatTheNextOne()) {
            throw new IllegalStateException();
        }
        GNode removed = this.down.get(0);
        GNode newNext = removed.down.get(0);
        this.texts.addAll(removed.texts);
        this.down.set(0, newNext);
        if (!newNext.up.remove(removed)) {
            throw new IllegalStateException();
        }
        newNext.up.add(this);
        return removed;
    }
}

