/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.wordvector;

import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import opennlp.tools.util.wordvector.WordVector;
import opennlp.tools.util.wordvector.WordVectorType;

class DoubleArrayVector
implements WordVector {
    private final double[] vector;

    DoubleArrayVector(double[] vector) {
        this.vector = vector;
    }

    @Override
    public WordVectorType getDataType() {
        return WordVectorType.DOUBLE;
    }

    @Override
    public float getAsFloat(int index) {
        return (float)this.getAsDouble(index);
    }

    @Override
    public double getAsDouble(int index) {
        return this.vector[index];
    }

    @Override
    public FloatBuffer toFloatBuffer() {
        float[] floatVector = new float[this.vector.length];
        for (int i = 0; i < floatVector.length; ++i) {
            floatVector[i] = (float)this.vector[i];
        }
        return FloatBuffer.wrap(floatVector).asReadOnlyBuffer();
    }

    @Override
    public DoubleBuffer toDoubleBuffer() {
        return DoubleBuffer.wrap(this.vector).asReadOnlyBuffer();
    }

    @Override
    public int dimension() {
        return this.vector.length;
    }
}

