/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.StopFilterFactory;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.function.FunctionQuery;
import org.apache.lucene.queries.function.FunctionScoreQuery;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.ProductFloatFunction;
import org.apache.lucene.queries.function.valuesource.QueryValueSource;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.util.Version;
import org.apache.solr.analysis.TokenizerChain;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.DisMaxParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.parser.QueryParser;
import org.apache.solr.parser.SolrQueryParserBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.search.DisMaxQParser;
import org.apache.solr.search.FieldParams;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QueryParsing;
import org.apache.solr.search.QueryUtils;
import org.apache.solr.search.SolrQueryParser;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.util.SolrPluginUtils;

public class ExtendedDismaxQParser
extends QParser {
    private static String IMPOSSIBLE_FIELD_NAME = "\ufffc\ufffc\ufffc";
    private ExtendedDismaxConfiguration config;
    private Query parsedUserQuery;
    private Query altUserQuery;
    private List<Query> boostQueries;
    private boolean parsed = false;
    static final RuntimeException unknownField = new RuntimeException("UnknownField");

    public ExtendedDismaxQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        super(qstr, localParams, params, req);
        this.config = this.createConfiguration(qstr, localParams, params, req);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Query parse() throws SyntaxError {
        void var4_11;
        this.parsed = true;
        BooleanQuery.Builder query = new BooleanQuery.Builder();
        this.parsedUserQuery = null;
        String userQuery = this.getString();
        this.altUserQuery = null;
        if (StringUtils.isBlank((CharSequence)userQuery)) {
            if (this.config.altQ == null) return null;
            QParser altQParser = this.subQuery(this.config.altQ, null);
            this.altUserQuery = altQParser.getQuery();
            query.add(this.altUserQuery, BooleanClause.Occur.MUST);
        } else {
            ExtendedSolrQueryParser up = this.createEdismaxQueryParser(this, IMPOSSIBLE_FIELD_NAME);
            up.addAlias(IMPOSSIBLE_FIELD_NAME, this.config.tiebreaker, this.config.queryFields);
            this.addAliasesFromRequest(up, this.config.tiebreaker);
            this.validateQueryFields(up);
            up.setPhraseSlop(this.config.qslop);
            up.setAllowLeadingWildcard(true);
            up.setAllowSubQueryParsing(this.config.userFields.isAllowed(SolrQueryParserBase.MagicFieldName.QUERY.field));
            List<Clause> list = this.splitIntoClauses(userQuery, false);
            String mainUserQuery = this.rebuildUserQuery(list, this.config.lowercaseOperators);
            up.minShouldMatch = this.config.minShouldMatch;
            up.setSplitOnWhitespace(this.config.splitOnWhitespace);
            this.parsedUserQuery = this.parseOriginalQuery(up, mainUserQuery, list, this.config);
            if (this.parsedUserQuery == null) {
                this.parsedUserQuery = this.parseEscapedQuery(up, this.escapeUserQuery(list), this.config);
            }
            query.add(this.parsedUserQuery, BooleanClause.Occur.MUST);
            this.addPhraseFieldQueries(query, list, this.config);
        }
        this.boostQueries = this.getBoostQueries();
        for (Query query2 : this.boostQueries) {
            query.add(query2, BooleanClause.Occur.SHOULD);
        }
        List<Query> boostFunctions = this.getBoostFunctions();
        for (Query f : boostFunctions) {
            query.add(f, BooleanClause.Occur.SHOULD);
        }
        BooleanQuery booleanQuery = QueryUtils.build(query, this);
        List<ValueSource> boosts = this.getMultiplicativeBoosts();
        if (boosts.size() > 1) {
            ProductFloatFunction prod = new ProductFloatFunction(boosts.toArray(new ValueSource[boosts.size()]));
            FunctionScoreQuery functionScoreQuery = FunctionScoreQuery.boostByValue((Query)booleanQuery, (DoubleValuesSource)prod.asDoubleValuesSource());
            return var4_11;
        } else {
            if (boosts.size() != 1) return var4_11;
            FunctionScoreQuery functionScoreQuery = FunctionScoreQuery.boostByValue((Query)booleanQuery, (DoubleValuesSource)boosts.get(0).asDoubleValuesSource());
        }
        return var4_11;
    }

    protected void validateQueryFields(ExtendedSolrQueryParser up) throws SyntaxError {
        ArrayList<String> flds = new ArrayList<String>(this.config.queryFields.keySet().size());
        for (String fieldName : this.config.queryFields.keySet()) {
            this.buildQueryFieldList(fieldName, up.getAlias(fieldName), flds, up);
        }
        this.checkFieldsInSchema(flds);
    }

    private void buildQueryFieldList(String fieldName, ExtendedSolrQueryParser.Alias alias, List<String> flds, ExtendedSolrQueryParser up) throws SyntaxError {
        if (null == alias) {
            flds.add(fieldName);
            return;
        }
        up.validateCyclicAliasing(fieldName);
        flds.addAll(this.getFieldsFromAlias(up, alias));
    }

    private List<String> getFieldsFromAlias(ExtendedSolrQueryParser up, ExtendedSolrQueryParser.Alias a) throws SyntaxError {
        ArrayList<String> lst = new ArrayList<String>();
        for (String s : a.fields.keySet()) {
            this.buildQueryFieldList(s, up.getAlias(s), lst, up);
        }
        return lst;
    }

    private void checkFieldInSchema(String fieldName) throws SyntaxError {
        try {
            this.config.schema.getField(fieldName);
        }
        catch (SolrException se) {
            throw new SyntaxError("Query Field '" + fieldName + "' is not a valid field name", se);
        }
    }

    private void checkFieldsInSchema(List<String> flds) throws SyntaxError {
        for (String fieldName : flds) {
            this.checkFieldInSchema(fieldName);
        }
    }

    protected void addPhraseFieldQueries(BooleanQuery.Builder query, List<Clause> clauses, ExtendedDismaxConfiguration config) throws SyntaxError {
        List<FieldParams> allPhraseFields = config.getAllPhraseFields();
        if (allPhraseFields.size() > 0) {
            ArrayList<Clause> normalClauses = new ArrayList<Clause>(clauses.size());
            for (Clause clause : clauses) {
                String s;
                if (clause.field != null || clause.isPhrase || clause.isBareWord() && ("OR".equals(s = clause.val) || "AND".equals(s) || "NOT".equals(s) || "TO".equals(s))) continue;
                normalClauses.add(clause);
            }
            ImmutableListMultimap phraseFieldsByWordGram = Multimaps.index(allPhraseFields, FieldParams::getWordGrams);
            for (Map.Entry phraseFieldsByWordGramEntry : phraseFieldsByWordGram.asMap().entrySet()) {
                ImmutableListMultimap phraseFieldsBySlop = Multimaps.index((Iterable)((Iterable)phraseFieldsByWordGramEntry.getValue()), FieldParams::getSlop);
                for (Map.Entry phraseFieldsBySlopEntry : phraseFieldsBySlop.asMap().entrySet()) {
                    this.addShingledPhraseQueries(query, normalClauses, (Collection)phraseFieldsBySlopEntry.getValue(), (Integer)phraseFieldsByWordGramEntry.getKey(), config.tiebreaker, (Integer)phraseFieldsBySlopEntry.getKey());
                }
            }
        }
    }

    protected ExtendedDismaxConfiguration createConfiguration(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        return new ExtendedDismaxConfiguration(localParams, params, req);
    }

    protected ExtendedSolrQueryParser createEdismaxQueryParser(QParser qParser, String field) {
        return new ExtendedSolrQueryParser(qParser, field);
    }

    protected Query parseEscapedQuery(ExtendedSolrQueryParser up, String escapedUserQuery, ExtendedDismaxConfiguration config) throws SyntaxError {
        Query query = up.parse(escapedUserQuery);
        if (query instanceof BooleanQuery) {
            BooleanQuery.Builder t = new BooleanQuery.Builder();
            SolrPluginUtils.flattenBooleanQuery(t, (BooleanQuery)query);
            SolrPluginUtils.setMinShouldMatch(t, config.minShouldMatch, config.mmAutoRelax);
            query = QueryUtils.build(t, this);
        }
        return query;
    }

    protected Query parseOriginalQuery(ExtendedSolrQueryParser up, String mainUserQuery, List<Clause> clauses, ExtendedDismaxConfiguration config) {
        Query query = null;
        try {
            up.setRemoveStopFilter(!config.stopwords);
            up.exceptions = true;
            query = up.parse(mainUserQuery);
            if (this.shouldRemoveStopFilter(config, query)) {
                up.setRemoveStopFilter(true);
                query = up.parse(mainUserQuery);
            }
        }
        catch (Exception e) {
            up.exceptions = false;
        }
        if (query == null) {
            return null;
        }
        if (query instanceof BooleanQuery) {
            String mmSpec = config.minShouldMatch;
            if (this.foundOperators(clauses, config.lowercaseOperators)) {
                mmSpec = config.solrParams.get("mm", "0%");
            }
            query = SolrPluginUtils.setMinShouldMatch((BooleanQuery)query, mmSpec, config.mmAutoRelax);
        }
        return query;
    }

    protected boolean shouldRemoveStopFilter(ExtendedDismaxConfiguration config, Query query) {
        return config.stopwords && ExtendedDismaxQParser.isEmpty(query);
    }

    private String escapeUserQuery(List<Clause> clauses) {
        StringBuilder sb = new StringBuilder();
        for (Clause clause : clauses) {
            Float boost;
            boolean doQuote = clause.isPhrase;
            String s = clause.val;
            if (!clause.isPhrase && ("OR".equals(s) || "AND".equals(s) || "NOT".equals(s))) {
                doQuote = true;
            }
            if (clause.must != '\u0000') {
                sb.append(clause.must);
            }
            if (clause.field != null) {
                sb.append(clause.field);
                sb.append(':');
            }
            if (doQuote) {
                sb.append('\"');
            }
            sb.append(clause.val);
            if (doQuote) {
                sb.append('\"');
            }
            if (clause.field != null && (boost = this.config.userFields.getBoost(clause.field)) != null) {
                sb.append("^").append(boost);
            }
            sb.append(' ');
        }
        return sb.toString();
    }

    private boolean foundOperators(List<Clause> clauses, boolean lowercaseOperators) {
        for (Clause clause : clauses) {
            if (clause.must == '+') {
                return true;
            }
            if (clause.must == '-') {
                return true;
            }
            if (!clause.isBareWord()) continue;
            String s = clause.val;
            if ("OR".equals(s)) {
                return true;
            }
            if ("NOT".equals(s)) {
                return true;
            }
            if (!lowercaseOperators || !"or".equals(s)) continue;
            return true;
        }
        return false;
    }

    protected String rebuildUserQuery(List<Clause> clauses, boolean lowercaseOperators) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < clauses.size(); ++i) {
            Clause clause = clauses.get(i);
            String s = clause.raw;
            if (lowercaseOperators && i > 0 && i + 1 < clauses.size()) {
                if ("AND".equalsIgnoreCase(s)) {
                    s = "AND";
                } else if ("OR".equalsIgnoreCase(s)) {
                    s = "OR";
                }
            }
            sb.append(s);
            sb.append(' ');
        }
        return sb.toString();
    }

    protected List<ValueSource> getMultiplicativeBoosts() throws SyntaxError {
        ArrayList<ValueSource> boosts = new ArrayList<ValueSource>();
        if (this.config.hasMultiplicativeBoosts()) {
            for (String boostStr : this.config.multBoosts) {
                if (boostStr == null || boostStr.length() == 0) continue;
                Query boost = this.subQuery(boostStr, "func").getQuery();
                Object vs = boost instanceof FunctionQuery ? ((FunctionQuery)boost).getValueSource() : new QueryValueSource(boost, 1.0f);
                boosts.add((ValueSource)vs);
            }
        }
        return boosts;
    }

    protected List<Query> getBoostFunctions() throws SyntaxError {
        LinkedList<Query> boostFunctions = new LinkedList<Query>();
        if (this.config.hasBoostFunctions()) {
            for (String boostFunc : this.config.boostFuncs) {
                if (null == boostFunc || "".equals(boostFunc)) continue;
                Map<String, Float> ff = SolrPluginUtils.parseFieldBoosts(boostFunc);
                for (Map.Entry<String, Float> entry : ff.entrySet()) {
                    Query fq = this.subQuery(entry.getKey(), "func").getQuery();
                    Float b = entry.getValue();
                    if (null != b && b.floatValue() != 1.0f) {
                        fq = new BoostQuery(fq, b.floatValue());
                    }
                    boostFunctions.add(fq);
                }
            }
        }
        return boostFunctions;
    }

    protected List<Query> getBoostQueries() throws SyntaxError {
        LinkedList<Query> boostQueries = new LinkedList<Query>();
        if (this.config.hasBoostParams()) {
            for (String qs : this.config.boostParams) {
                if (qs.trim().length() == 0) continue;
                Query q = this.subQuery(qs, null).getQuery();
                boostQueries.add(q);
            }
        }
        return boostQueries;
    }

    private void addAliasesFromRequest(ExtendedSolrQueryParser up, float tiebreaker) {
        Iterator it = this.config.solrParams.getParameterNamesIterator();
        while (it.hasNext()) {
            String param = (String)it.next();
            if (!param.startsWith("f.") || !param.endsWith(".qf")) continue;
            String fname = param.substring(2, param.length() - 3);
            String qfReplacement = this.config.solrParams.get(param);
            Map<String, Float> parsedQf = SolrPluginUtils.parseFieldBoosts(qfReplacement);
            if (parsedQf.size() == 0) {
                return;
            }
            up.addAlias(fname, tiebreaker, parsedQf);
        }
    }

    protected void addShingledPhraseQueries(BooleanQuery.Builder mainQuery, List<Clause> clauses, Collection<FieldParams> fields, int shingleSize, float tiebreaker, int slop) throws SyntaxError {
        if (null == fields || fields.isEmpty() || null == clauses || clauses.size() < shingleSize) {
            return;
        }
        if (0 == shingleSize) {
            shingleSize = clauses.size();
        }
        int lastClauseIndex = shingleSize - 1;
        StringBuilder userPhraseQuery = new StringBuilder();
        for (int i = 0; i < clauses.size() - lastClauseIndex; ++i) {
            userPhraseQuery.append('\"');
            for (int j = 0; j <= lastClauseIndex; ++j) {
                userPhraseQuery.append(clauses.get((int)(i + j)).val);
                userPhraseQuery.append(' ');
            }
            userPhraseQuery.append('\"');
            userPhraseQuery.append(' ');
        }
        ExtendedSolrQueryParser pp = this.createEdismaxQueryParser(this, IMPOSSIBLE_FIELD_NAME);
        pp.addAlias(IMPOSSIBLE_FIELD_NAME, tiebreaker, this.getFieldBoosts(fields));
        pp.setPhraseSlop(slop);
        pp.setRemoveStopFilter(true);
        pp.setSplitOnWhitespace(this.config.splitOnWhitespace);
        pp.makeDismax = true;
        pp.minClauseSize = 2;
        Query phrase = pp.parse(userPhraseQuery.toString());
        if (phrase != null) {
            mainQuery.add(phrase, BooleanClause.Occur.SHOULD);
        }
    }

    private Map<String, Float> getFieldBoosts(Collection<FieldParams> fields) {
        LinkedHashMap<String, Float> fieldBoostMap = new LinkedHashMap<String, Float>(fields.size());
        for (FieldParams field : fields) {
            fieldBoostMap.put(field.getField(), Float.valueOf(field.getBoost()));
        }
        return fieldBoostMap;
    }

    @Override
    public String[] getDefaultHighlightFields() {
        return this.config.queryFields.keySet().toArray(new String[0]);
    }

    @Override
    public Query getHighlightQuery() throws SyntaxError {
        if (!this.parsed) {
            this.parse();
        }
        return this.parsedUserQuery == null ? this.altUserQuery : this.parsedUserQuery;
    }

    @Override
    public void addDebugInfo(NamedList<Object> debugInfo) {
        super.addDebugInfo(debugInfo);
        debugInfo.add("altquerystring", (Object)this.altUserQuery);
        if (null != this.boostQueries) {
            debugInfo.add("boost_queries", (Object)this.config.boostParams);
            debugInfo.add("parsed_boost_queries", QueryParsing.toString(this.boostQueries, this.getReq().getSchema()));
        }
        debugInfo.add("boostfuncs", (Object)this.getReq().getParams().getParams("bf"));
    }

    public List<Clause> splitIntoClauses(String s, boolean ignoreQuote) {
        ArrayList<Clause> lst = new ArrayList<Clause>(4);
        int pos = 0;
        int end = s.length();
        char ch = '\u0000';
        while (pos < end) {
            Clause clause = new Clause();
            boolean disallowUserField = true;
            ch = s.charAt(pos);
            while (Character.isWhitespace(ch) && ++pos < end) {
                ch = s.charAt(pos);
            }
            int start = pos;
            if ((ch == '+' || ch == '-') && pos + 1 < end) {
                clause.must = ch;
                ++pos;
            }
            clause.field = this.getFieldName(s, pos, end);
            if (clause.field != null && !this.config.userFields.isAllowed(clause.field)) {
                clause.field = null;
            }
            if (clause.field != null) {
                disallowUserField = false;
                int colon = s.indexOf(58, pos);
                clause.rawField = s.substring(pos, colon);
                pos += colon - pos;
                ++pos;
            }
            if (pos >= end) break;
            char inString = '\u0000';
            ch = s.charAt(pos);
            if (!ignoreQuote && ch == '\"') {
                clause.isPhrase = true;
                inString = '\"';
                ++pos;
            }
            StringBuilder sb = new StringBuilder();
            while (pos < end) {
                if ((ch = s.charAt(pos++)) == '\\') {
                    sb.append(ch);
                    if (pos >= end) {
                        sb.append(ch);
                        break;
                    }
                    ch = s.charAt(pos++);
                    sb.append(ch);
                    continue;
                }
                if (inString != '\u0000' && ch == inString) {
                    inString = '\u0000';
                    break;
                }
                if (Character.isWhitespace(ch)) {
                    clause.hasWhitespace = true;
                    if (inString == '\u0000') {
                        --pos;
                        break;
                    }
                }
                if (inString == '\u0000') {
                    if (!ignoreQuote && ch == '\"') {
                        --pos;
                        break;
                    }
                    switch (ch) {
                        case '!': 
                        case '\"': 
                        case '&': 
                        case '(': 
                        case ')': 
                        case '*': 
                        case '+': 
                        case '-': 
                        case '/': 
                        case ':': 
                        case '?': 
                        case '[': 
                        case '\\': 
                        case ']': 
                        case '^': 
                        case '{': 
                        case '|': 
                        case '}': 
                        case '~': {
                            clause.hasSpecialSyntax = true;
                            sb.append('\\');
                        }
                    }
                } else if (ch == '\"') {
                    sb.append('\\');
                }
                sb.append(ch);
            }
            clause.val = sb.toString();
            if (clause.isPhrase) {
                if (inString != '\u0000') {
                    return this.splitIntoClauses(s, true);
                }
                clause.hasSpecialSyntax = false;
            } else if (clause.val.length() == 0) {
                clause.syntaxError = true;
                if (clause.must != '\u0000') {
                    clause.val = "\\" + clause.must;
                    clause.must = '\u0000';
                    clause.hasSpecialSyntax = true;
                } else {
                    clause = null;
                }
            }
            if (clause == null) continue;
            if (disallowUserField) {
                clause.raw = s.substring(start, pos);
                if (!"*:*".equals(clause.raw)) {
                    clause.raw = clause.raw.replaceAll("([^\\\\]):", "$1\\\\:");
                }
            } else {
                Float boost;
                clause.raw = s.substring(start, pos);
                if (this.config.userFields.isAllowed(clause.field) && !clause.raw.contains("^") && (boost = this.config.userFields.getBoost(clause.field)) != null) {
                    clause.raw = clause.raw + "^" + boost;
                }
            }
            lst.add(clause);
        }
        return lst;
    }

    public String getFieldName(String s, int pos, int end) {
        if (pos >= end) {
            return null;
        }
        int p = pos;
        int colon = s.indexOf(58, pos);
        if (colon <= pos || colon + 1 >= end || Character.isWhitespace(s.charAt(colon + 1))) {
            return null;
        }
        char ch = s.charAt(p++);
        while ((ch == '(' || ch == '+' || ch == '-') && pos < end) {
            ch = s.charAt(p++);
            ++pos;
        }
        if (!Character.isJavaIdentifierPart(ch)) {
            return null;
        }
        while (p < colon) {
            if (Character.isJavaIdentifierPart(ch = s.charAt(p++)) || ch == '-' || ch == '.') continue;
            return null;
        }
        String fname = s.substring(pos, p);
        boolean isInSchema = this.getReq().getSchema().getFieldTypeNoEx(fname) != null;
        boolean isAlias = this.config.solrParams.get("f." + fname + ".qf") != null;
        boolean isMagic = null != SolrQueryParserBase.MagicFieldName.get(fname);
        return isInSchema || isAlias || isMagic ? fname : null;
    }

    public static List<String> split(String s, boolean ignoreQuote) {
        ArrayList<String> lst = new ArrayList<String>(4);
        int pos = 0;
        int start = 0;
        int end = s.length();
        char inString = '\u0000';
        char ch = '\u0000';
        while (pos < end) {
            char prevChar = ch;
            if ((ch = s.charAt(pos++)) == '\\') {
                ++pos;
                continue;
            }
            if (inString != '\u0000' && ch == inString) {
                inString = '\u0000';
                continue;
            }
            if (!ignoreQuote && ch == '\"') {
                if (Character.isLetterOrDigit(prevChar)) continue;
                inString = ch;
                continue;
            }
            if (!Character.isWhitespace(ch) || inString != '\u0000') continue;
            lst.add(s.substring(start, pos - 1));
            start = pos;
        }
        if (start < end) {
            lst.add(s.substring(start, end));
        }
        if (inString != '\u0000') {
            return ExtendedDismaxQParser.split(s, true);
        }
        return lst;
    }

    static boolean isEmpty(Query q) {
        if (q == null) {
            return true;
        }
        return q instanceof BooleanQuery && ((BooleanQuery)q).clauses().size() == 0;
    }

    static {
        unknownField.fillInStackTrace();
    }

    public static class ExtendedDismaxConfiguration {
        protected Map<String, Float> queryFields;
        protected UserFields userFields;
        protected String[] boostParams;
        protected String[] multBoosts;
        protected SolrParams solrParams;
        protected String minShouldMatch;
        protected List<FieldParams> allPhraseFields;
        protected float tiebreaker;
        protected int qslop;
        protected boolean stopwords;
        protected boolean mmAutoRelax;
        protected String altQ;
        protected boolean lowercaseOperators;
        protected String[] boostFuncs;
        protected boolean splitOnWhitespace;
        protected IndexSchema schema;

        public ExtendedDismaxConfiguration(SolrParams localParams, SolrParams params, SolrQueryRequest req) {
            this.solrParams = SolrParams.wrapDefaults((SolrParams)localParams, (SolrParams)params);
            this.schema = req.getSchema();
            this.minShouldMatch = DisMaxQParser.parseMinShouldMatch(this.schema, this.solrParams);
            boolean forbidSubQueryByDefault = req.getCore().getSolrConfig().luceneMatchVersion.onOrAfter(Version.LUCENE_7_2_0);
            this.userFields = new UserFields(U.parseFieldBoosts(this.solrParams.getParams("uf")), forbidSubQueryByDefault);
            try {
                this.queryFields = DisMaxQParser.parseQueryFields(this.schema, this.solrParams);
            }
            catch (SyntaxError e) {
                throw new RuntimeException(e);
            }
            int[] pslop = new int[4];
            pslop[0] = this.solrParams.getInt("ps", 0);
            pslop[2] = this.solrParams.getInt("ps2", pslop[0]);
            pslop[3] = this.solrParams.getInt("ps3", pslop[0]);
            List<FieldParams> phraseFields = U.parseFieldBoostsAndSlop(this.solrParams.getParams("pf"), 0, pslop[0]);
            List<FieldParams> phraseFields2 = U.parseFieldBoostsAndSlop(this.solrParams.getParams("pf2"), 2, pslop[2]);
            List<FieldParams> phraseFields3 = U.parseFieldBoostsAndSlop(this.solrParams.getParams("pf3"), 3, pslop[3]);
            this.allPhraseFields = new ArrayList<FieldParams>(phraseFields.size() + phraseFields2.size() + phraseFields3.size());
            this.allPhraseFields.addAll(phraseFields);
            this.allPhraseFields.addAll(phraseFields2);
            this.allPhraseFields.addAll(phraseFields3);
            this.tiebreaker = this.solrParams.getFloat("tie", 0.0f);
            this.qslop = this.solrParams.getInt("qs", 0);
            this.stopwords = this.solrParams.getBool("stopwords", true);
            this.mmAutoRelax = this.solrParams.getBool("mm.autoRelax", false);
            this.altQ = this.solrParams.get("q.alt");
            this.lowercaseOperators = this.solrParams.getBool("lowercaseOperators", !req.getCore().getSolrConfig().luceneMatchVersion.onOrAfter(Version.LUCENE_7_0_0));
            this.boostParams = this.solrParams.getParams("bq");
            this.boostFuncs = this.solrParams.getParams("bf");
            this.multBoosts = this.solrParams.getParams("boost");
            this.splitOnWhitespace = this.solrParams.getBool("sow", false);
        }

        public boolean hasMultiplicativeBoosts() {
            return this.multBoosts != null && this.multBoosts.length > 0;
        }

        public boolean hasBoostFunctions() {
            return null != this.boostFuncs && 0 != this.boostFuncs.length;
        }

        public boolean hasBoostParams() {
            return this.boostParams != null && this.boostParams.length > 0;
        }

        public List<FieldParams> getAllPhraseFields() {
            return this.allPhraseFields;
        }
    }

    public static class ExtendedSolrQueryParser
    extends SolrQueryParser {
        boolean makeDismax = true;
        boolean allowWildcard = true;
        int minClauseSize = 0;
        boolean exceptions;
        private Map<String, Analyzer> nonStopFilterAnalyzerPerField;
        private boolean removeStopFilter;
        String minShouldMatch;
        protected Map<String, Alias> aliases = new HashMap<String, Alias>(3);
        private QType type;
        private String field;
        private String val;
        private String val2;
        private List<String> vals;
        private boolean bool;
        private boolean bool2;
        private float flt;
        private int slop;

        public ExtendedSolrQueryParser(QParser parser, String defaultField) {
            super(parser, defaultField);
            SolrParams defaultParams = SolrParams.wrapDefaults((SolrParams)parser.getLocalParams(), (SolrParams)parser.getParams());
            QueryParser.Operator defaultOp = QueryParsing.parseOP(defaultParams.get("q.op"));
            this.setDefaultOperator(defaultOp);
        }

        public void setRemoveStopFilter(boolean remove) {
            this.removeStopFilter = remove;
        }

        @Override
        protected Query getBooleanQuery(List<BooleanClause> clauses) throws SyntaxError {
            Query q = super.getBooleanQuery(clauses);
            if (q != null) {
                q = QueryUtils.makeQueryable(q);
            }
            return q;
        }

        public void addAlias(String field, float tiebreaker, Map<String, Float> fieldBoosts) {
            Alias a = new Alias();
            a.tie = tiebreaker;
            a.fields = fieldBoosts;
            this.aliases.put(field, a);
        }

        protected Alias getAlias(String field) {
            return this.aliases.get(field);
        }

        @Override
        protected Query getFieldQuery(String field, String val, boolean quoted, boolean raw) throws SyntaxError {
            this.type = quoted ? QType.PHRASE : QType.FIELD;
            this.field = field;
            this.val = val;
            this.vals = null;
            this.slop = this.getPhraseSlop();
            return this.getAliasedQuery();
        }

        @Override
        protected Query getFieldQuery(String field, String val, int slop) throws SyntaxError {
            this.type = QType.PHRASE;
            this.field = field;
            this.val = val;
            this.vals = null;
            this.slop = slop;
            return this.getAliasedQuery();
        }

        @Override
        protected Query getFieldQuery(String field, List<String> queryTerms, boolean raw) throws SyntaxError {
            this.type = QType.FIELD;
            this.field = field;
            this.val = null;
            this.vals = queryTerms;
            this.slop = this.getPhraseSlop();
            return this.getAliasedMultiTermQuery();
        }

        @Override
        protected Query getPrefixQuery(String field, String val) throws SyntaxError {
            if (val.equals("") && field.equals("*")) {
                return new MatchAllDocsQuery();
            }
            this.type = QType.PREFIX;
            this.field = field;
            this.val = val;
            this.vals = null;
            return this.getAliasedQuery();
        }

        @Override
        protected Query newFieldQuery(Analyzer analyzer, String field, String queryText, boolean quoted, boolean fieldAutoGenPhraseQueries, boolean enableGraphQueries, SolrQueryParserBase.SynonymQueryStyle synonymQueryStyle) throws SyntaxError {
            Analyzer actualAnalyzer;
            if (this.removeStopFilter) {
                if (this.nonStopFilterAnalyzerPerField == null) {
                    this.nonStopFilterAnalyzerPerField = new HashMap<String, Analyzer>();
                }
                if ((actualAnalyzer = this.nonStopFilterAnalyzerPerField.get(field)) == null) {
                    actualAnalyzer = this.noStopwordFilterAnalyzer(field);
                }
            } else {
                actualAnalyzer = this.parser.getReq().getSchema().getFieldType(field).getQueryAnalyzer();
            }
            return super.newFieldQuery(actualAnalyzer, field, queryText, quoted, fieldAutoGenPhraseQueries, enableGraphQueries, synonymQueryStyle);
        }

        @Override
        protected Query getRangeQuery(String field, String a, String b, boolean startInclusive, boolean endInclusive) throws SyntaxError {
            this.type = QType.RANGE;
            this.field = field;
            this.val = a;
            this.val2 = b;
            this.vals = null;
            this.bool = startInclusive;
            this.bool2 = endInclusive;
            return this.getAliasedQuery();
        }

        @Override
        protected Query getWildcardQuery(String field, String val) throws SyntaxError {
            if (val.equals("*")) {
                if (field.equals("*") || this.getExplicitField() == null) {
                    return new MatchAllDocsQuery();
                }
                return this.getPrefixQuery(field, "");
            }
            this.type = QType.WILDCARD;
            this.field = field;
            this.val = val;
            this.vals = null;
            return this.getAliasedQuery();
        }

        @Override
        protected Query getFuzzyQuery(String field, String val, float minSimilarity) throws SyntaxError {
            this.type = QType.FUZZY;
            this.field = field;
            this.val = val;
            this.vals = null;
            this.flt = minSimilarity;
            return this.getAliasedQuery();
        }

        protected Query getAliasedQuery() throws SyntaxError {
            FieldType ft;
            Alias a = this.aliases.get(this.field);
            this.validateCyclicAliasing(this.field);
            if (a != null) {
                List<Query> lst = this.getQueries(a);
                if (lst == null || lst.size() == 0) {
                    return this.getQuery();
                }
                if (this.makeDismax) {
                    DisjunctionMaxQuery q = new DisjunctionMaxQuery(lst, a.tie);
                    return q;
                }
                BooleanQuery.Builder q = new BooleanQuery.Builder();
                for (Query sub : lst) {
                    q.add(sub, BooleanClause.Occur.SHOULD);
                }
                return QueryUtils.build(q, this.parser);
            }
            if (this.exceptions && (ft = this.schema.getFieldTypeNoEx(this.field)) == null && null == SolrQueryParserBase.MagicFieldName.get(this.field)) {
                throw unknownField;
            }
            return this.getQuery();
        }

        protected Query getAliasedMultiTermQuery() throws SyntaxError {
            FieldType ft;
            Alias a = this.aliases.get(this.field);
            this.validateCyclicAliasing(this.field);
            if (a != null) {
                List<Query> lst = this.getMultiTermQueries(a);
                if (lst == null || lst.size() == 0) {
                    return this.getQuery();
                }
                if (this.makeDismax) {
                    Query firstQuery = lst.get(0);
                    if ((firstQuery instanceof BooleanQuery || firstQuery instanceof BoostQuery && ((BoostQuery)firstQuery).getQuery() instanceof BooleanQuery) && this.allSameQueryStructure(lst)) {
                        BooleanQuery.Builder q = new BooleanQuery.Builder();
                        ArrayList<Object> subs = new ArrayList<Object>(lst.size());
                        BooleanQuery firstBooleanQuery = firstQuery instanceof BoostQuery ? (BooleanQuery)((BoostQuery)firstQuery).getQuery() : (BooleanQuery)firstQuery;
                        for (int c = 0; c < firstBooleanQuery.clauses().size(); ++c) {
                            subs.clear();
                            for (int n = 0; n < lst.size(); ++n) {
                                if (lst.get(n) instanceof BoostQuery) {
                                    BoostQuery boostQuery = (BoostQuery)lst.get(n);
                                    BooleanQuery booleanQuery = (BooleanQuery)boostQuery.getQuery();
                                    subs.add(new BoostQuery(((BooleanClause)booleanQuery.clauses().get(c)).getQuery(), boostQuery.getBoost()));
                                    continue;
                                }
                                subs.add(((BooleanClause)((BooleanQuery)lst.get(n)).clauses().get(c)).getQuery());
                            }
                            q.add(this.newBooleanClause((Query)new DisjunctionMaxQuery(subs, a.tie), BooleanClause.Occur.SHOULD));
                        }
                        return QueryUtils.build(q, this.parser);
                    }
                    return new DisjunctionMaxQuery(lst, a.tie);
                }
                BooleanQuery.Builder q = new BooleanQuery.Builder();
                for (Query sub : lst) {
                    q.add(sub, BooleanClause.Occur.SHOULD);
                }
                return QueryUtils.build(q, this.parser);
            }
            if (this.exceptions && (ft = this.schema.getFieldTypeNoEx(this.field)) == null && null == SolrQueryParserBase.MagicFieldName.get(this.field)) {
                throw unknownField;
            }
            return this.getQuery();
        }

        private boolean allSameQueryStructure(List<Query> lst) {
            boolean allSame = true;
            Query firstQuery = lst.get(0);
            if (firstQuery instanceof BoostQuery) {
                firstQuery = ((BoostQuery)firstQuery).getQuery();
            }
            block0: for (int n = 1; n < lst.size(); ++n) {
                Query nthQuery = lst.get(n);
                if (nthQuery instanceof BoostQuery) {
                    nthQuery = ((BoostQuery)nthQuery).getQuery();
                }
                if (nthQuery.getClass() != firstQuery.getClass()) {
                    allSame = false;
                    break;
                }
                if (!(firstQuery instanceof BooleanQuery)) continue;
                List firstBooleanClauses = ((BooleanQuery)firstQuery).clauses();
                List nthBooleanClauses = ((BooleanQuery)nthQuery).clauses();
                if (firstBooleanClauses.size() != nthBooleanClauses.size()) {
                    allSame = false;
                    break;
                }
                for (int c = 0; c < firstBooleanClauses.size(); ++c) {
                    if (((BooleanClause)nthBooleanClauses.get(c)).getQuery().getClass() != ((BooleanClause)firstBooleanClauses.get(c)).getQuery().getClass() || ((BooleanClause)nthBooleanClauses.get(c)).getOccur() != ((BooleanClause)firstBooleanClauses.get(c)).getOccur()) {
                        allSame = false;
                        continue block0;
                    }
                    if (!(((BooleanClause)firstBooleanClauses.get(c)).getQuery() instanceof BooleanQuery) || this.allSameQueryStructure(Arrays.asList(((BooleanClause)firstBooleanClauses.get(c)).getQuery(), ((BooleanClause)nthBooleanClauses.get(c)).getQuery()))) continue;
                    allSame = false;
                    continue block0;
                }
            }
            return allSame;
        }

        @Override
        protected void addMultiTermClause(List<BooleanClause> clauses, Query q) {
            BooleanClause.Occur occur;
            if (q == null) {
                return;
            }
            boolean required = this.operator == AND_OPERATOR;
            BooleanClause.Occur occur2 = occur = required ? BooleanClause.Occur.MUST : BooleanClause.Occur.SHOULD;
            if (q instanceof BooleanQuery) {
                boolean allOptionalDisMaxQueries = true;
                for (BooleanClause c : ((BooleanQuery)q).clauses()) {
                    if (c.getOccur() == BooleanClause.Occur.SHOULD && c.getQuery() instanceof DisjunctionMaxQuery) continue;
                    allOptionalDisMaxQueries = false;
                    break;
                }
                if (allOptionalDisMaxQueries) {
                    for (BooleanClause c : ((BooleanQuery)q).clauses()) {
                        clauses.add(this.newBooleanClause(c.getQuery(), occur));
                    }
                    return;
                }
            }
            clauses.add(this.newBooleanClause(q, occur));
        }

        private void validateCyclicAliasing(String field) throws SyntaxError {
            HashSet<String> set = new HashSet<String>();
            set.add(field);
            if (this.validateField(field, set)) {
                throw new SyntaxError("Field aliases lead to a cycle");
            }
        }

        private boolean validateField(String field, Set<String> set) {
            if (this.getAlias(field) == null) {
                return false;
            }
            boolean hascycle = false;
            for (String referencedField : this.getAlias((String)field).fields.keySet()) {
                if (!set.add(referencedField)) {
                    hascycle = true;
                    continue;
                }
                if (this.validateField(referencedField, set)) {
                    hascycle = true;
                }
                set.remove(referencedField);
            }
            return hascycle;
        }

        protected List<Query> getQueries(Alias a) throws SyntaxError {
            if (a == null) {
                return null;
            }
            if (a.fields.size() == 0) {
                return null;
            }
            ArrayList<Query> lst = new ArrayList<Query>(4);
            Iterator<String> iterator = a.fields.keySet().iterator();
            while (iterator.hasNext()) {
                String f;
                this.field = f = iterator.next();
                Query sub = this.getAliasedQuery();
                if (sub == null) continue;
                Float boost = a.fields.get(f);
                if (boost != null && boost.floatValue() != 1.0f) {
                    sub = new BoostQuery(sub, boost.floatValue());
                }
                lst.add(sub);
            }
            return lst;
        }

        protected List<Query> getMultiTermQueries(Alias a) throws SyntaxError {
            if (a == null) {
                return null;
            }
            if (a.fields.size() == 0) {
                return null;
            }
            ArrayList<Query> lst = new ArrayList<Query>(4);
            Iterator<String> iterator = a.fields.keySet().iterator();
            while (iterator.hasNext()) {
                String f;
                this.field = f = iterator.next();
                Query sub = this.getAliasedMultiTermQuery();
                if (sub == null) continue;
                Float boost = a.fields.get(f);
                if (boost != null && boost.floatValue() != 1.0f) {
                    sub = new BoostQuery(sub, boost.floatValue());
                }
                lst.add(sub);
            }
            return lst;
        }

        private Query getQuery() {
            try {
                switch (this.type) {
                    case FIELD: 
                    case PHRASE: {
                        Query query = this.val == null ? super.getFieldQuery(this.field, this.vals, false) : super.getFieldQuery(this.field, this.val, this.type == QType.PHRASE, false);
                        if (query instanceof BooleanQuery) {
                            if (this.type == QType.FIELD) {
                                BooleanQuery bq = (BooleanQuery)query;
                                query = SolrPluginUtils.setMinShouldMatch(bq, this.minShouldMatch, false);
                            }
                        } else if (query instanceof PhraseQuery) {
                            PhraseQuery pq = (PhraseQuery)query;
                            if (this.minClauseSize > 1 && pq.getTerms().length < this.minClauseSize) {
                                return null;
                            }
                            PhraseQuery.Builder builder = new PhraseQuery.Builder();
                            Term[] terms = pq.getTerms();
                            int[] positions = pq.getPositions();
                            for (int i = 0; i < terms.length; ++i) {
                                builder.add(terms[i], positions[i]);
                            }
                            builder.setSlop(this.slop);
                            query = builder.build();
                        } else if (query instanceof MultiPhraseQuery) {
                            MultiPhraseQuery mpq = (MultiPhraseQuery)query;
                            if (this.minClauseSize > 1 && mpq.getTermArrays().length < this.minClauseSize) {
                                return null;
                            }
                            if (this.slop != mpq.getSlop()) {
                                query = new MultiPhraseQuery.Builder(mpq).setSlop(this.slop).build();
                            }
                        } else {
                            if (query instanceof SpanQuery) {
                                return query;
                            }
                            if (this.minClauseSize > 1) {
                                return null;
                            }
                        }
                        return query;
                    }
                    case PREFIX: {
                        return super.getPrefixQuery(this.field, this.val);
                    }
                    case WILDCARD: {
                        return super.getWildcardQuery(this.field, this.val);
                    }
                    case FUZZY: {
                        return super.getFuzzyQuery(this.field, this.val, this.flt);
                    }
                    case RANGE: {
                        return super.getRangeQuery(this.field, this.val, this.val2, this.bool, this.bool2);
                    }
                }
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }

        private Analyzer noStopwordFilterAnalyzer(String fieldName) {
            FieldType ft = this.parser.getReq().getSchema().getFieldType(fieldName);
            Analyzer qa = ft.getQueryAnalyzer();
            if (!(qa instanceof TokenizerChain)) {
                return qa;
            }
            TokenizerChain tcq = (TokenizerChain)qa;
            Analyzer ia = ft.getIndexAnalyzer();
            if (ia == qa || !(ia instanceof TokenizerChain)) {
                return qa;
            }
            TokenizerChain tci = (TokenizerChain)ia;
            for (TokenFilterFactory tf : tci.getTokenFilterFactories()) {
                if (!(tf instanceof StopFilterFactory)) continue;
                return qa;
            }
            int stopIdx = -1;
            TokenFilterFactory[] facs = tcq.getTokenFilterFactories();
            for (int i = 0; i < facs.length; ++i) {
                TokenFilterFactory tf;
                tf = facs[i];
                if (!(tf instanceof StopFilterFactory)) continue;
                stopIdx = i;
                break;
            }
            if (stopIdx == -1) {
                return qa;
            }
            TokenFilterFactory[] newtf = new TokenFilterFactory[facs.length - 1];
            int j = 0;
            for (int i = 0; i < facs.length; ++i) {
                if (i == stopIdx) continue;
                newtf[j++] = facs[i];
            }
            TokenizerChain newa = new TokenizerChain(tcq.getCharFilterFactories(), tcq.getTokenizerFactory(), newtf);
            newa.setPositionIncrementGap(tcq.getPositionIncrementGap(fieldName));
            return newa;
        }

        protected static class Alias {
            public float tie;
            public Map<String, Float> fields;

            protected Alias() {
            }
        }
    }

    static class UserFields {
        private Map<String, Float> userFieldsMap;
        private DynamicField[] dynamicUserFields;
        private DynamicField[] negativeDynamicUserFields;

        UserFields(Map<String, Float> ufm, boolean forbidSubQueryByDefault) {
            this.userFieldsMap = ufm;
            if (0 == this.userFieldsMap.size()) {
                this.userFieldsMap.put("*", null);
            }
            ArrayList<DynamicField> dynUserFields = new ArrayList<DynamicField>();
            ArrayList<DynamicField> negDynUserFields = new ArrayList<DynamicField>();
            for (String f : this.userFieldsMap.keySet()) {
                if (!f.contains("*")) continue;
                if (f.startsWith("-")) {
                    negDynUserFields.add(new DynamicField(f.substring(1)));
                    continue;
                }
                dynUserFields.add(new DynamicField(f));
            }
            if (forbidSubQueryByDefault && !this.userFieldsMap.containsKey(SolrQueryParserBase.MagicFieldName.QUERY.field)) {
                this.userFieldsMap.put("-" + SolrQueryParserBase.MagicFieldName.QUERY.field, null);
            }
            Collections.sort(dynUserFields);
            this.dynamicUserFields = dynUserFields.toArray(new DynamicField[dynUserFields.size()]);
            Collections.sort(negDynUserFields);
            this.negativeDynamicUserFields = negDynUserFields.toArray(new DynamicField[negDynUserFields.size()]);
        }

        public boolean isAllowed(String fname) {
            boolean res = (this.userFieldsMap.containsKey(fname) || this.isDynField(fname, false)) && !this.userFieldsMap.containsKey("-" + fname) && !this.isDynField(fname, true);
            return res;
        }

        private boolean isDynField(String field, boolean neg) {
            return this.getDynFieldForName(field, neg) != null;
        }

        private String getDynFieldForName(String f, boolean neg) {
            for (DynamicField df : neg ? this.negativeDynamicUserFields : this.dynamicUserFields) {
                if (!df.matches(f)) continue;
                return df.wildcard;
            }
            return null;
        }

        public Float getBoost(String field) {
            return this.userFieldsMap.containsKey(field) ? this.userFieldsMap.get(field) : this.userFieldsMap.get(this.getDynFieldForName(field, false));
        }
    }

    protected static class Clause {
        protected String field;
        protected String rawField;
        protected boolean isPhrase;
        protected boolean hasWhitespace;
        protected boolean hasSpecialSyntax;
        protected boolean syntaxError;
        protected char must;
        protected String val;
        protected String raw;

        protected Clause() {
        }

        boolean isBareWord() {
            return this.must == '\u0000' && !this.isPhrase;
        }
    }

    static class DynamicField
    implements Comparable<DynamicField> {
        static final int STARTS_WITH = 1;
        static final int ENDS_WITH = 2;
        static final int CATCHALL = 3;
        final String wildcard;
        final int type;
        final String str;

        protected DynamicField(String wildcard) {
            this.wildcard = wildcard;
            if (wildcard.equals("*")) {
                this.type = 3;
                this.str = null;
            } else if (wildcard.startsWith("*")) {
                this.type = 2;
                this.str = wildcard.substring(1);
            } else if (wildcard.endsWith("*")) {
                this.type = 1;
                this.str = wildcard.substring(0, wildcard.length() - 1);
            } else {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "dynamic field name must start or end with *");
            }
        }

        public boolean matches(String name) {
            if (this.type == 3) {
                return true;
            }
            if (this.type == 1 && name.startsWith(this.str)) {
                return true;
            }
            return this.type == 2 && name.endsWith(this.str);
        }

        @Override
        public int compareTo(DynamicField other) {
            return other.wildcard.length() - this.wildcard.length();
        }

        public String toString() {
            return this.wildcard;
        }
    }

    static enum QType {
        FIELD,
        PHRASE,
        PREFIX,
        WILDCARD,
        FUZZY,
        RANGE;

    }

    private static interface DMP
    extends DisMaxParams {
        public static final String UF = "uf";
        public static final String LOWERCASE_OPS = "lowercaseOperators";
        public static final String MULT_BOOST = "boost";
        public static final String STOPWORDS = "stopwords";
    }

    private static class U
    extends SolrPluginUtils {
        private U() {
        }
    }
}

