/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider;

import java.nio.charset.Charset;
import jnr.ffi.Address;
import jnr.ffi.Pointer;
import jnr.ffi.provider.AbstractMemoryIO;
import jnr.ffi.provider.DelegatingMemoryIO;

public final class BoundedMemoryIO
extends AbstractMemoryIO
implements DelegatingMemoryIO {
    private final long base;
    private final long size;
    private final Pointer io;

    public BoundedMemoryIO(Pointer parent, long offset2, long size2) {
        super(parent.getRuntime(), parent.address() != 0L ? parent.address() + offset2 : 0L, parent.isDirect());
        this.io = parent;
        this.base = offset2;
        this.size = size2;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public final boolean hasArray() {
        return this.io.hasArray();
    }

    @Override
    public final Object array() {
        return this.io.array();
    }

    @Override
    public final int arrayOffset() {
        return this.io.arrayOffset() + (int)this.base;
    }

    @Override
    public final int arrayLength() {
        return (int)this.size;
    }

    @Override
    public void checkBounds(long offset2, long length2) {
        BoundedMemoryIO.checkBounds(this.size, offset2, length2);
        this.getDelegatedMemoryIO().checkBounds(this.base + offset2, length2);
    }

    @Override
    public Pointer getDelegatedMemoryIO() {
        return this.io;
    }

    public int hashCode() {
        return this.getDelegatedMemoryIO().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof BoundedMemoryIO && this.io.equals(((BoundedMemoryIO)obj).io) && ((BoundedMemoryIO)obj).base == this.base && ((BoundedMemoryIO)obj).size == this.size || this.io.equals(obj);
    }

    @Override
    public byte getByte(long offset2) {
        BoundedMemoryIO.checkBounds(this.size, offset2, 1L);
        return this.io.getByte(this.base + offset2);
    }

    @Override
    public short getShort(long offset2) {
        BoundedMemoryIO.checkBounds(this.size, offset2, 2L);
        return this.io.getShort(this.base + offset2);
    }

    @Override
    public int getInt(long offset2) {
        BoundedMemoryIO.checkBounds(this.size, offset2, 4L);
        return this.io.getInt(this.base + offset2);
    }

    @Override
    public long getLongLong(long offset2) {
        BoundedMemoryIO.checkBounds(this.size, offset2, 8L);
        return this.io.getLongLong(this.base + offset2);
    }

    @Override
    public float getFloat(long offset2) {
        BoundedMemoryIO.checkBounds(this.size, offset2, 4L);
        return this.io.getFloat(this.base + offset2);
    }

    @Override
    public double getDouble(long offset2) {
        BoundedMemoryIO.checkBounds(this.size, offset2, 8L);
        return this.io.getDouble(this.base + offset2);
    }

    @Override
    public Pointer getPointer(long offset2) {
        BoundedMemoryIO.checkBounds(this.size, offset2, this.getRuntime().addressSize());
        return this.io.getPointer(this.base + offset2);
    }

    @Override
    public Pointer getPointer(long offset2, long size2) {
        BoundedMemoryIO.checkBounds(this.size, this.base + offset2, this.getRuntime().addressSize());
        return this.io.getPointer(this.base + offset2, size2);
    }

    @Override
    public void putByte(long offset2, byte value2) {
        BoundedMemoryIO.checkBounds(this.size, offset2, 1L);
        this.io.putByte(this.base + offset2, value2);
    }

    @Override
    public void putShort(long offset2, short value2) {
        BoundedMemoryIO.checkBounds(this.size, offset2, 2L);
        this.io.putShort(this.base + offset2, value2);
    }

    @Override
    public void putInt(long offset2, int value2) {
        BoundedMemoryIO.checkBounds(this.size, offset2, 4L);
        this.io.putInt(this.base + offset2, value2);
    }

    @Override
    public void putLongLong(long offset2, long value2) {
        BoundedMemoryIO.checkBounds(this.size, offset2, 8L);
        this.io.putLongLong(this.base + offset2, value2);
    }

    @Override
    public void putFloat(long offset2, float value2) {
        BoundedMemoryIO.checkBounds(this.size, offset2, 4L);
        this.io.putFloat(this.base + offset2, value2);
    }

    @Override
    public void putDouble(long offset2, double value2) {
        BoundedMemoryIO.checkBounds(this.size, offset2, 8L);
        this.io.putDouble(this.base + offset2, value2);
    }

    @Override
    public void putPointer(long offset2, Pointer value2) {
        BoundedMemoryIO.checkBounds(this.size, offset2, this.getRuntime().addressSize());
        this.io.putPointer(this.base + offset2, value2);
    }

    @Override
    public void get(long offset2, byte[] dst, int off, int len) {
        BoundedMemoryIO.checkBounds(this.size, offset2, len);
        this.io.get(this.base + offset2, dst, off, len);
    }

    @Override
    public void put(long offset2, byte[] dst, int off, int len) {
        BoundedMemoryIO.checkBounds(this.size, offset2, len);
        this.io.put(this.base + offset2, dst, off, len);
    }

    @Override
    public void get(long offset2, short[] dst, int off, int len) {
        BoundedMemoryIO.checkBounds(this.size, offset2, len * 16 / 8);
        this.io.get(this.base + offset2, dst, off, len);
    }

    @Override
    public void put(long offset2, short[] dst, int off, int len) {
        BoundedMemoryIO.checkBounds(this.size, offset2, len * 16 / 8);
        this.io.put(this.base + offset2, dst, off, len);
    }

    @Override
    public void get(long offset2, int[] dst, int off, int len) {
        BoundedMemoryIO.checkBounds(this.size, offset2, len * 32 / 8);
        this.io.get(this.base + offset2, dst, off, len);
    }

    @Override
    public void put(long offset2, int[] src, int off, int len) {
        BoundedMemoryIO.checkBounds(this.size, offset2, len * 32 / 8);
        this.io.put(this.base + offset2, src, off, len);
    }

    @Override
    public void get(long offset2, long[] dst, int off, int len) {
        BoundedMemoryIO.checkBounds(this.size, offset2, len * 64 / 8);
        this.io.get(this.base + offset2, dst, off, len);
    }

    @Override
    public void put(long offset2, long[] src, int off, int len) {
        BoundedMemoryIO.checkBounds(this.size, offset2, len * 64 / 8);
        this.io.put(this.base + offset2, src, off, len);
    }

    @Override
    public void get(long offset2, float[] dst, int off, int len) {
        BoundedMemoryIO.checkBounds(this.size, offset2, len * 32 / 8);
        this.io.get(this.base + offset2, dst, off, len);
    }

    @Override
    public void put(long offset2, float[] src, int off, int len) {
        BoundedMemoryIO.checkBounds(this.size, offset2, len * 32 / 8);
        this.io.put(this.base + offset2, src, off, len);
    }

    @Override
    public void get(long offset2, double[] dst, int off, int len) {
        BoundedMemoryIO.checkBounds(this.size, offset2, len * 64 / 8);
        this.io.get(this.base + offset2, dst, off, len);
    }

    @Override
    public void put(long offset2, double[] src, int off, int len) {
        BoundedMemoryIO.checkBounds(this.size, offset2, len * 64 / 8);
        this.io.put(this.base + offset2, src, off, len);
    }

    @Override
    public long getAddress(long offset2) {
        BoundedMemoryIO.checkBounds(this.size, offset2, this.getRuntime().addressSize());
        return this.io.getAddress(this.base + offset2);
    }

    @Override
    public String getString(long offset2, int maxLength, Charset cs) {
        BoundedMemoryIO.checkBounds(this.size, offset2, maxLength);
        return this.io.getString(this.base + offset2, maxLength, cs);
    }

    @Override
    public String getString(long offset2) {
        return this.io.getString(this.base + offset2, (int)this.size, Charset.defaultCharset());
    }

    @Override
    public void putAddress(long offset2, long value2) {
        BoundedMemoryIO.checkBounds(this.size, offset2, this.getRuntime().addressSize());
        this.io.putAddress(this.base + offset2, value2);
    }

    @Override
    public void putAddress(long offset2, Address value2) {
        BoundedMemoryIO.checkBounds(this.size, offset2, this.getRuntime().addressSize());
        this.io.putAddress(this.base + offset2, value2);
    }

    @Override
    public void putString(long offset2, String string2, int maxLength, Charset cs) {
        BoundedMemoryIO.checkBounds(this.size, offset2, maxLength);
        this.io.putString(this.base + offset2, string2, maxLength, cs);
    }

    @Override
    public int indexOf(long offset2, byte value2) {
        return this.io.indexOf(this.base + offset2, value2, (int)this.size);
    }

    @Override
    public int indexOf(long offset2, byte value2, int maxlen) {
        BoundedMemoryIO.checkBounds(this.size, offset2, maxlen);
        return this.io.indexOf(this.base + offset2, value2, maxlen);
    }

    @Override
    public void setMemory(long offset2, long size2, byte value2) {
        BoundedMemoryIO.checkBounds(this.size, this.base + offset2, size2);
        this.io.setMemory(this.base + offset2, size2, value2);
    }

    @Override
    public void transferFrom(long offset2, Pointer other, long otherOffset, long count2) {
        BoundedMemoryIO.checkBounds(this.size, this.base + offset2, count2);
        this.getDelegatedMemoryIO().transferFrom(offset2, other, otherOffset, count2);
    }

    @Override
    public void transferTo(long offset2, Pointer other, long otherOffset, long count2) {
        BoundedMemoryIO.checkBounds(this.size, this.base + offset2, count2);
        this.getDelegatedMemoryIO().transferTo(offset2, other, otherOffset, count2);
    }
}

