/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.report;

import java.io.File;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.DownloadStatus;
import org.apache.ivy.core.report.MetadataArtifactDownloadReport;
import org.apache.ivy.util.DateUtil;
import org.apache.ivy.util.extendable.ExtendableItemHelper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlReportParser {
    private SaxXmlReportParser parser = null;

    public void parse(File serializable) throws ParseException {
        if (!serializable.exists()) {
            throw new IllegalStateException("Report file '" + serializable.getAbsolutePath() + "' does not exist.");
        }
        this.parser = new SaxXmlReportParser((File)serializable);
        try {
            this.parser.parse();
            return;
        }
        catch (Exception exception) {
            serializable = new ParseException("failed to parse report: " + serializable + ": " + exception.getMessage(), 0);
            ((Throwable)serializable).initCause(exception);
            throw serializable;
        }
    }

    public ArtifactDownloadReport[] getArtifactReports() {
        return this.parser.getArtifactReports().toArray(new ArtifactDownloadReport[this.parser.getArtifactReports().size()]);
    }

    public ModuleRevisionId[] getDependencyRevisionIds() {
        return this.parser.getModuleRevisionIds().toArray(new ModuleRevisionId[this.parser.getModuleRevisionIds().size()]);
    }

    public ModuleRevisionId[] getRealDependencyRevisionIds() {
        return this.parser.getRealModuleRevisionIds().toArray(new ModuleRevisionId[this.parser.getRealModuleRevisionIds().size()]);
    }

    public MetadataArtifactDownloadReport getMetadataArtifactReport(ModuleRevisionId moduleRevisionId) {
        return this.parser.getMetadataArtifactReport(moduleRevisionId);
    }

    private static class SaxXmlReportParser {
        private List mrids;
        private List defaultMrids;
        private List realMrids;
        private List artifacts = new ArrayList();
        private List artifactReports = new ArrayList();
        private Map metadataReports;
        private ModuleRevisionId mRevisionId;
        private File report;
        private boolean hasError = false;

        SaxXmlReportParser(File file) {
            this.mrids = new ArrayList();
            this.defaultMrids = new ArrayList();
            this.realMrids = new ArrayList();
            this.metadataReports = new HashMap();
            this.report = file;
        }

        public void parse() throws Exception {
            SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
            sAXParser.parse(this.report, (DefaultHandler)new XmlReportParserHandler());
        }

        private static boolean parseBoolean(String string) {
            return string != null && string.equalsIgnoreCase("true");
        }

        public List getArtifactReports() {
            return this.artifactReports;
        }

        public List getModuleRevisionIds() {
            return this.mrids;
        }

        public List getRealModuleRevisionIds() {
            return this.realMrids;
        }

        public MetadataArtifactDownloadReport getMetadataArtifactReport(ModuleRevisionId moduleRevisionId) {
            return (MetadataArtifactDownloadReport)this.metadataReports.get(moduleRevisionId);
        }

        private final class XmlReportParserHandler
        extends DefaultHandler {
            private String organisation;
            private String module;
            private String branch;
            private String revision;
            private int position;
            private Date pubdate;
            private boolean skip;
            private ModuleRevisionId mrid;
            private boolean isDefault;
            private SortedMap revisionsMap = new TreeMap();
            private List revisionArtifacts = null;

            private XmlReportParserHandler() {
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public final void startElement(String object, String object2, String object3, Attributes attributes) throws SAXException {
                if ("module".equals(object3)) {
                    this.organisation = attributes.getValue("organisation");
                    this.module = attributes.getValue("name");
                    return;
                }
                if ("revision".equals(object3)) {
                    this.revisionArtifacts = new ArrayList();
                    this.branch = attributes.getValue("branch");
                    this.revision = attributes.getValue("name");
                    this.isDefault = Boolean.valueOf(attributes.getValue("default"));
                    object = attributes.getValue("position");
                    int n = this.position = object == null ? this.getMaxPos() + 1 : Integer.valueOf((String)object);
                    if (attributes.getValue("error") != null) {
                        SaxXmlReportParser.this.hasError = true;
                        this.skip = true;
                        return;
                    }
                    if (attributes.getValue("evicted") != null) {
                        this.skip = true;
                        return;
                    }
                    this.revisionsMap.put(this.position, this.revisionArtifacts);
                    this.mrid = ModuleRevisionId.newInstance(this.organisation, this.module, this.branch, this.revision, ExtendableItemHelper.getExtraAttributes(attributes, "extra-"));
                    SaxXmlReportParser.this.mrids.add(this.mrid);
                    if (this.isDefault) {
                        SaxXmlReportParser.this.defaultMrids.add(this.mrid);
                    } else {
                        object2 = DefaultArtifact.newIvyArtifact(this.mrid, this.pubdate);
                        object3 = new MetadataArtifactDownloadReport((Artifact)object2);
                        SaxXmlReportParser.this.metadataReports.put(this.mrid, object3);
                        SaxXmlReportParser.this.realMrids.add(this.mrid);
                    }
                    try {
                        object2 = attributes.getValue("pubdate");
                        if (object2 != null) {
                            this.pubdate = DateUtil.parse((String)object2);
                        }
                        this.skip = false;
                        return;
                    }
                    catch (ParseException parseException) {
                        throw new IllegalArgumentException("invalid publication date for " + this.organisation + " " + this.module + " " + this.revision + ": " + attributes.getValue("pubdate"));
                    }
                }
                if ("metadata-artifact".equals(object3)) {
                    if (this.skip) {
                        return;
                    }
                    object = (MetadataArtifactDownloadReport)SaxXmlReportParser.this.metadataReports.get(this.mrid);
                    if (object == null) return;
                    ((ArtifactDownloadReport)object).setDownloadStatus(DownloadStatus.fromString(attributes.getValue("status")));
                    ((ArtifactDownloadReport)object).setDownloadDetails(attributes.getValue("details"));
                    ((ArtifactDownloadReport)object).setSize(Long.parseLong(attributes.getValue("size")));
                    ((ArtifactDownloadReport)object).setDownloadTimeMillis(Long.parseLong(attributes.getValue("time")));
                    ((MetadataArtifactDownloadReport)object).setSearched(SaxXmlReportParser.parseBoolean(attributes.getValue("searched")));
                    if (attributes.getValue("location") != null) {
                        ((ArtifactDownloadReport)object).setLocalFile(new File(attributes.getValue("location")));
                    }
                    if (attributes.getValue("original-local-location") != null) {
                        ((MetadataArtifactDownloadReport)object).setOriginalLocalFile(new File(attributes.getValue("original-local-location")));
                    }
                    if (attributes.getValue("origin-location") == null) return;
                    if (ArtifactOrigin.isUnknown(attributes.getValue("origin-location"))) {
                        Object object4 = object;
                        ((ArtifactDownloadReport)object4).setArtifactOrigin(ArtifactOrigin.unkwnown(((ArtifactDownloadReport)object4).getArtifact()));
                        return;
                    }
                    ((ArtifactDownloadReport)object).setArtifactOrigin(new ArtifactOrigin(((ArtifactDownloadReport)object).getArtifact(), SaxXmlReportParser.parseBoolean(attributes.getValue("origin-is-local")), attributes.getValue("origin-location")));
                    return;
                }
                if ("artifact".equals(object3)) {
                    if (this.skip) {
                        return;
                    }
                    object = attributes.getValue("status");
                    object2 = attributes.getValue("name");
                    object3 = attributes.getValue("type");
                    String string = attributes.getValue("ext");
                    DefaultArtifact defaultArtifact = new DefaultArtifact(this.mrid, this.pubdate, (String)object2, (String)object3, string, ExtendableItemHelper.getExtraAttributes(attributes, "extra-"));
                    ArtifactDownloadReport artifactDownloadReport = new ArtifactDownloadReport(defaultArtifact);
                    artifactDownloadReport.setDownloadStatus(DownloadStatus.fromString((String)object));
                    artifactDownloadReport.setDownloadDetails(attributes.getValue("details"));
                    artifactDownloadReport.setSize(Long.parseLong(attributes.getValue("size")));
                    artifactDownloadReport.setDownloadTimeMillis(Long.parseLong(attributes.getValue("time")));
                    if (attributes.getValue("location") != null) {
                        artifactDownloadReport.setLocalFile(new File(attributes.getValue("location")));
                    }
                    this.revisionArtifacts.add(artifactDownloadReport);
                    return;
                }
                if ("origin-location".equals(object3)) {
                    if (this.skip) {
                        return;
                    }
                    object = (ArtifactDownloadReport)this.revisionArtifacts.get(this.revisionArtifacts.size() - 1);
                    if (ArtifactOrigin.isUnknown(attributes.getValue("location"))) {
                        Object object5 = object;
                        ((ArtifactDownloadReport)object5).setArtifactOrigin(ArtifactOrigin.unkwnown(((ArtifactDownloadReport)object5).getArtifact()));
                        return;
                    }
                    ((ArtifactDownloadReport)object).setArtifactOrigin(new ArtifactOrigin(((ArtifactDownloadReport)object).getArtifact(), SaxXmlReportParser.parseBoolean(attributes.getValue("is-local")), attributes.getValue("location")));
                    return;
                }
                if (!"info".equals(object3)) return;
                object = attributes.getValue("organisation");
                object2 = attributes.getValue("module");
                object3 = attributes.getValue("branch");
                String string = attributes.getValue("revision");
                HashMap<String, String> hashMap = new HashMap<String, String>();
                int n = 0;
                while (true) {
                    if (n >= attributes.getLength()) {
                        SaxXmlReportParser.this.mRevisionId = ModuleRevisionId.newInstance((String)object, (String)object2, (String)object3, string, hashMap);
                        return;
                    }
                    String string2 = attributes.getQName(n);
                    if (string2.startsWith("extra-")) {
                        string2 = string2.substring(6);
                        String string3 = attributes.getValue(n);
                        hashMap.put(string2, string3);
                    }
                    ++n;
                }
            }

            @Override
            public final void endElement(String object, String iterator2, String object2) throws SAXException {
                if ("dependencies".equals(object2)) {
                    for (Iterator iterator2 : this.revisionsMap.values()) {
                        SaxXmlReportParser.this.artifactReports.addAll(iterator2);
                        iterator2 = iterator2.iterator();
                        while (iterator2.hasNext()) {
                            object2 = (ArtifactDownloadReport)iterator2.next();
                            if (((ArtifactDownloadReport)object2).getDownloadStatus() == DownloadStatus.FAILED) continue;
                            SaxXmlReportParser.this.artifacts.add(((ArtifactDownloadReport)object2).getArtifact());
                        }
                    }
                }
            }

            private int getMaxPos() {
                if (this.revisionsMap.isEmpty()) {
                    return -1;
                }
                return (Integer)this.revisionsMap.keySet().toArray()[this.revisionsMap.size() - 1];
            }
        }
    }
}

