/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial3d.geom;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.spatial3d.geom.Bounds;
import org.apache.lucene.spatial3d.geom.DistanceStyle;
import org.apache.lucene.spatial3d.geom.GeoBasePolygon;
import org.apache.lucene.spatial3d.geom.GeoPoint;
import org.apache.lucene.spatial3d.geom.GeoShape;
import org.apache.lucene.spatial3d.geom.Membership;
import org.apache.lucene.spatial3d.geom.Plane;
import org.apache.lucene.spatial3d.geom.PlanetModel;
import org.apache.lucene.spatial3d.geom.SerializableObject;
import org.apache.lucene.spatial3d.geom.SidedPlane;
import org.apache.lucene.spatial3d.geom.Vector;
import org.apache.lucene.spatial3d.geom.XYZBounds;

class GeoComplexPolygon
extends GeoBasePolygon {
    private final Tree xTree;
    private final Tree yTree;
    private final Tree zTree;
    private final List<List<GeoPoint>> pointsList;
    private final boolean testPoint1InSet;
    private final GeoPoint testPoint1;
    private final Plane testPoint1FixedYPlane;
    private final Plane testPoint1FixedYAbovePlane;
    private final Plane testPoint1FixedYBelowPlane;
    private final Plane testPoint1FixedXPlane;
    private final Plane testPoint1FixedXAbovePlane;
    private final Plane testPoint1FixedXBelowPlane;
    private final Plane testPoint1FixedZPlane;
    private final Plane testPoint1FixedZAbovePlane;
    private final Plane testPoint1FixedZBelowPlane;
    private final GeoPoint[] edgePoints;
    private final Edge[] shapeStartEdges;
    private static final double NEAR_EDGE_CUTOFF = -1.0E-8;
    private static final double[] halfProportions = new double[]{0.5};
    private static final double DELTA_DISTANCE = 1.0E-12;
    private static final int MAX_ITERATIONS = 100;
    private static final double OFF_PLANE_AMOUNT = 1.0E-13;

    public GeoComplexPolygon(PlanetModel planetModel, List<List<GeoPoint>> pointsList, GeoPoint testPoint, boolean testPointInSet) {
        super(planetModel);
        assert (planetModel.pointOnSurface(testPoint.x, testPoint.y, testPoint.z)) : "Test point is not on the ellipsoid surface";
        this.pointsList = pointsList;
        this.edgePoints = new GeoPoint[pointsList.size()];
        this.shapeStartEdges = new Edge[pointsList.size()];
        ArrayList<Edge> allEdges = new ArrayList<Edge>();
        int edgePointIndex = 0;
        for (List<GeoPoint> shapePoints : pointsList) {
            GeoPoint lastGeoPoint;
            allEdges.ensureCapacity(allEdges.size() + shapePoints.size());
            this.edgePoints[edgePointIndex] = lastGeoPoint = shapePoints.get(shapePoints.size() - 1);
            Edge lastEdge = null;
            Edge firstEdge = null;
            for (GeoPoint thisGeoPoint : shapePoints) {
                assert (planetModel.pointOnSurface(thisGeoPoint)) : "Polygon edge point must be on surface; " + thisGeoPoint + " is not";
                Edge edge = new Edge(planetModel, lastGeoPoint, thisGeoPoint);
                if (edge.isWithin(testPoint.x, testPoint.y, testPoint.z)) {
                    throw new IllegalArgumentException("Test point is on polygon edge: not allowed");
                }
                allEdges.add(edge);
                if (firstEdge == null) {
                    firstEdge = edge;
                }
                if (lastEdge != null) {
                    lastEdge.next = edge;
                    edge.previous = lastEdge;
                }
                lastEdge = edge;
                lastGeoPoint = thisGeoPoint;
            }
            firstEdge.previous = lastEdge;
            lastEdge.next = firstEdge;
            this.shapeStartEdges[edgePointIndex] = firstEdge;
            ++edgePointIndex;
        }
        this.xTree = new XTree(allEdges);
        this.yTree = new YTree(allEdges);
        this.zTree = new ZTree(allEdges);
        this.testPoint1 = testPoint;
        this.testPoint1FixedYPlane = new Plane(0.0, 1.0, 0.0, -this.testPoint1.y);
        this.testPoint1FixedXPlane = new Plane(1.0, 0.0, 0.0, -this.testPoint1.x);
        this.testPoint1FixedZPlane = new Plane(0.0, 0.0, 1.0, -this.testPoint1.z);
        Plane testPoint1FixedYAbovePlane = new Plane(this.testPoint1FixedYPlane, true);
        if (-testPoint1FixedYAbovePlane.D - planetModel.getMaximumYValue() > -1.0E-8 || planetModel.getMinimumYValue() + testPoint1FixedYAbovePlane.D > -1.0E-8) {
            testPoint1FixedYAbovePlane = null;
        }
        this.testPoint1FixedYAbovePlane = testPoint1FixedYAbovePlane;
        Plane testPoint1FixedYBelowPlane = new Plane(this.testPoint1FixedYPlane, false);
        if (-testPoint1FixedYBelowPlane.D - planetModel.getMaximumYValue() > -1.0E-8 || planetModel.getMinimumYValue() + testPoint1FixedYBelowPlane.D > -1.0E-8) {
            testPoint1FixedYBelowPlane = null;
        }
        this.testPoint1FixedYBelowPlane = testPoint1FixedYBelowPlane;
        Plane testPoint1FixedXAbovePlane = new Plane(this.testPoint1FixedXPlane, true);
        if (-testPoint1FixedXAbovePlane.D - planetModel.getMaximumXValue() > -1.0E-8 || planetModel.getMinimumXValue() + testPoint1FixedXAbovePlane.D > -1.0E-8) {
            testPoint1FixedXAbovePlane = null;
        }
        this.testPoint1FixedXAbovePlane = testPoint1FixedXAbovePlane;
        Plane testPoint1FixedXBelowPlane = new Plane(this.testPoint1FixedXPlane, false);
        if (-testPoint1FixedXBelowPlane.D - planetModel.getMaximumXValue() > -1.0E-8 || planetModel.getMinimumXValue() + testPoint1FixedXBelowPlane.D > -1.0E-8) {
            testPoint1FixedXBelowPlane = null;
        }
        this.testPoint1FixedXBelowPlane = testPoint1FixedXBelowPlane;
        Plane testPoint1FixedZAbovePlane = new Plane(this.testPoint1FixedZPlane, true);
        if (-testPoint1FixedZAbovePlane.D - planetModel.getMaximumZValue() > -1.0E-8 || planetModel.getMinimumZValue() + testPoint1FixedZAbovePlane.D > -1.0E-8) {
            testPoint1FixedZAbovePlane = null;
        }
        this.testPoint1FixedZAbovePlane = testPoint1FixedZAbovePlane;
        Plane testPoint1FixedZBelowPlane = new Plane(this.testPoint1FixedZPlane, false);
        if (-testPoint1FixedZBelowPlane.D - planetModel.getMaximumZValue() > -1.0E-8 || planetModel.getMinimumZValue() + testPoint1FixedZBelowPlane.D > -1.0E-8) {
            testPoint1FixedZBelowPlane = null;
        }
        this.testPoint1FixedZBelowPlane = testPoint1FixedZBelowPlane;
        this.testPoint1InSet = testPointInSet;
    }

    public GeoComplexPolygon(PlanetModel planetModel, InputStream inputStream) throws IOException {
        this(planetModel, GeoComplexPolygon.readPointsList(planetModel, inputStream), new GeoPoint(planetModel, inputStream), SerializableObject.readBoolean(inputStream));
    }

    private static List<List<GeoPoint>> readPointsList(PlanetModel planetModel, InputStream inputStream) throws IOException {
        int count = SerializableObject.readInt(inputStream);
        ArrayList<List<GeoPoint>> array = new ArrayList<List<GeoPoint>>(count);
        for (int i = 0; i < count; ++i) {
            array.add(Arrays.asList(SerializableObject.readPointArray(planetModel, inputStream)));
        }
        return array;
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        GeoComplexPolygon.writePointsList(outputStream, this.pointsList);
        this.testPoint1.write(outputStream);
        SerializableObject.writeBoolean(outputStream, this.testPoint1InSet);
    }

    private static void writePointsList(OutputStream outputStream, List<List<GeoPoint>> pointsList) throws IOException {
        SerializableObject.writeInt(outputStream, pointsList.size());
        for (List<GeoPoint> points : pointsList) {
            SerializableObject.writePointArray(outputStream, points);
        }
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        return this.isInSet(x, y, z, this.testPoint1, this.testPoint1InSet, this.testPoint1FixedXPlane, this.testPoint1FixedXAbovePlane, this.testPoint1FixedXBelowPlane, this.testPoint1FixedYPlane, this.testPoint1FixedYAbovePlane, this.testPoint1FixedYBelowPlane, this.testPoint1FixedZPlane, this.testPoint1FixedZAbovePlane, this.testPoint1FixedZBelowPlane);
    }

    private boolean isInSet(double x, double y, double z, GeoPoint testPoint, boolean testPointInSet, Plane testPointFixedXPlane, Plane testPointFixedXAbovePlane, Plane testPointFixedXBelowPlane, Plane testPointFixedYPlane, Plane testPointFixedYAbovePlane, Plane testPointFixedYBelowPlane, Plane testPointFixedZPlane, Plane testPointFixedZAbovePlane, Plane testPointFixedZBelowPlane) {
        double newDistance;
        double cpDelta2;
        double cpDelta1;
        double tpDelta2;
        double tpDelta1;
        double checkBelow;
        double checkAbove;
        if (testPoint.isNumericallyIdentical(x, y, z)) {
            return testPointInSet;
        }
        if (testPointFixedYAbovePlane != null && testPointFixedYBelowPlane != null && testPointFixedYPlane.evaluateIsZero(x, y, z)) {
            CountingEdgeIterator crossingEdgeIterator = this.createLinearCrossingEdgeIterator(testPoint, testPointFixedYPlane, testPointFixedYAbovePlane, testPointFixedYBelowPlane, x, y, z);
            this.yTree.traverse(crossingEdgeIterator, testPoint.y);
            return crossingEdgeIterator.isOnEdge() || ((crossingEdgeIterator.getCrossingCount() & 1) == 0 ? testPointInSet : !testPointInSet);
        }
        if (testPointFixedXAbovePlane != null && testPointFixedXBelowPlane != null && testPointFixedXPlane.evaluateIsZero(x, y, z)) {
            CountingEdgeIterator crossingEdgeIterator = this.createLinearCrossingEdgeIterator(testPoint, testPointFixedXPlane, testPointFixedXAbovePlane, testPointFixedXBelowPlane, x, y, z);
            this.xTree.traverse(crossingEdgeIterator, testPoint.x);
            return crossingEdgeIterator.isOnEdge() || ((crossingEdgeIterator.getCrossingCount() & 1) == 0 ? testPointInSet : !testPointInSet);
        }
        if (testPointFixedZAbovePlane != null && testPointFixedZBelowPlane != null && testPointFixedZPlane.evaluateIsZero(x, y, z)) {
            CountingEdgeIterator crossingEdgeIterator = this.createLinearCrossingEdgeIterator(testPoint, testPointFixedZPlane, testPointFixedZAbovePlane, testPointFixedZBelowPlane, x, y, z);
            this.zTree.traverse(crossingEdgeIterator, testPoint.z);
            return crossingEdgeIterator.isOnEdge() || ((crossingEdgeIterator.getCrossingCount() & 1) == 0 ? testPointInSet : !testPointInSet);
        }
        Plane travelPlaneFixedX = new Plane(1.0, 0.0, 0.0, -x);
        Plane travelPlaneFixedY = new Plane(0.0, 1.0, 0.0, -y);
        Plane travelPlaneFixedZ = new Plane(0.0, 0.0, 1.0, -z);
        Plane fixedYAbovePlane = new Plane(travelPlaneFixedY, true);
        if (-fixedYAbovePlane.D - this.planetModel.getMaximumYValue() > -1.0E-8 || this.planetModel.getMinimumYValue() + fixedYAbovePlane.D > -1.0E-8) {
            fixedYAbovePlane = null;
        }
        Plane fixedYBelowPlane = new Plane(travelPlaneFixedY, false);
        if (-fixedYBelowPlane.D - this.planetModel.getMaximumYValue() > -1.0E-8 || this.planetModel.getMinimumYValue() + fixedYBelowPlane.D > -1.0E-8) {
            fixedYBelowPlane = null;
        }
        Plane fixedXAbovePlane = new Plane(travelPlaneFixedX, true);
        if (-fixedXAbovePlane.D - this.planetModel.getMaximumXValue() > -1.0E-8 || this.planetModel.getMinimumXValue() + fixedXAbovePlane.D > -1.0E-8) {
            fixedXAbovePlane = null;
        }
        Plane fixedXBelowPlane = new Plane(travelPlaneFixedX, false);
        if (-fixedXBelowPlane.D - this.planetModel.getMaximumXValue() > -1.0E-8 || this.planetModel.getMinimumXValue() + fixedXBelowPlane.D > -1.0E-8) {
            fixedXBelowPlane = null;
        }
        Plane fixedZAbovePlane = new Plane(travelPlaneFixedZ, true);
        if (-fixedZAbovePlane.D - this.planetModel.getMaximumZValue() > -1.0E-8 || this.planetModel.getMinimumZValue() + fixedZAbovePlane.D > -1.0E-8) {
            fixedZAbovePlane = null;
        }
        Plane fixedZBelowPlane = new Plane(travelPlaneFixedZ, false);
        if (-fixedZBelowPlane.D - this.planetModel.getMaximumZValue() > -1.0E-8 || this.planetModel.getMinimumZValue() + fixedZBelowPlane.D > -1.0E-8) {
            fixedZBelowPlane = null;
        }
        ArrayList<TraversalStrategy> traversalStrategies = new ArrayList<TraversalStrategy>(12);
        if (testPointFixedYAbovePlane != null && testPointFixedYBelowPlane != null && fixedXAbovePlane != null && fixedXBelowPlane != null) {
            checkAbove = 4.0 * (fixedXAbovePlane.D * fixedXAbovePlane.D * this.planetModel.inverseXYScalingSquared + testPointFixedYAbovePlane.D * testPointFixedYAbovePlane.D * this.planetModel.inverseXYScalingSquared - 1.0);
            checkBelow = 4.0 * (fixedXBelowPlane.D * fixedXBelowPlane.D * this.planetModel.inverseXYScalingSquared + testPointFixedYBelowPlane.D * testPointFixedYBelowPlane.D * this.planetModel.inverseXYScalingSquared - 1.0);
            if (checkAbove < 1.0E-24 && checkBelow < 1.0E-24) {
                GeoPoint[] XIntersectionsY;
                for (GeoPoint p : XIntersectionsY = travelPlaneFixedX.findIntersections(this.planetModel, testPointFixedYPlane, new Membership[0])) {
                    tpDelta1 = testPoint.x - p.x;
                    tpDelta2 = testPoint.z - p.z;
                    cpDelta1 = y - p.y;
                    cpDelta2 = z - p.z;
                    newDistance = tpDelta1 * tpDelta1 + tpDelta2 * tpDelta2 + cpDelta1 * cpDelta1 + cpDelta2 * cpDelta2;
                    traversalStrategies.add(new TraversalStrategy(newDistance, testPoint.y, x, testPointFixedYPlane, testPointFixedYAbovePlane, testPointFixedYBelowPlane, travelPlaneFixedX, fixedXAbovePlane, fixedXBelowPlane, this.yTree, this.xTree, p));
                }
            }
        }
        if (testPointFixedZAbovePlane != null && testPointFixedZBelowPlane != null && fixedXAbovePlane != null && fixedXBelowPlane != null) {
            checkAbove = 4.0 * (fixedXAbovePlane.D * fixedXAbovePlane.D * this.planetModel.inverseXYScalingSquared + testPointFixedZAbovePlane.D * testPointFixedZAbovePlane.D * this.planetModel.inverseZScalingSquared - 1.0);
            checkBelow = 4.0 * (fixedXBelowPlane.D * fixedXBelowPlane.D * this.planetModel.inverseXYScalingSquared + testPointFixedZBelowPlane.D * testPointFixedZBelowPlane.D * this.planetModel.inverseZScalingSquared - 1.0);
            if (checkAbove < 1.0E-24 && checkBelow < 1.0E-24) {
                GeoPoint[] XIntersectionsZ;
                for (GeoPoint p : XIntersectionsZ = travelPlaneFixedX.findIntersections(this.planetModel, testPointFixedZPlane, new Membership[0])) {
                    tpDelta1 = testPoint.x - p.x;
                    tpDelta2 = testPoint.y - p.y;
                    cpDelta1 = y - p.y;
                    cpDelta2 = z - p.z;
                    newDistance = tpDelta1 * tpDelta1 + tpDelta2 * tpDelta2 + cpDelta1 * cpDelta1 + cpDelta2 * cpDelta2;
                    traversalStrategies.add(new TraversalStrategy(newDistance, testPoint.z, x, testPointFixedZPlane, testPointFixedZAbovePlane, testPointFixedZBelowPlane, travelPlaneFixedX, fixedXAbovePlane, fixedXBelowPlane, this.zTree, this.xTree, p));
                }
            }
        }
        if (testPointFixedXAbovePlane != null && testPointFixedXBelowPlane != null && fixedYAbovePlane != null && fixedYBelowPlane != null) {
            checkAbove = 4.0 * (testPointFixedXAbovePlane.D * testPointFixedXAbovePlane.D * this.planetModel.inverseXYScalingSquared + fixedYAbovePlane.D * fixedYAbovePlane.D * this.planetModel.inverseXYScalingSquared - 1.0);
            checkBelow = 4.0 * (testPointFixedXBelowPlane.D * testPointFixedXBelowPlane.D * this.planetModel.inverseXYScalingSquared + fixedYBelowPlane.D * fixedYBelowPlane.D * this.planetModel.inverseXYScalingSquared - 1.0);
            if (checkAbove < 1.0E-24 && checkBelow < 1.0E-24) {
                GeoPoint[] YIntersectionsX;
                for (GeoPoint p : YIntersectionsX = travelPlaneFixedY.findIntersections(this.planetModel, testPointFixedXPlane, new Membership[0])) {
                    tpDelta1 = testPoint.y - p.y;
                    tpDelta2 = testPoint.z - p.z;
                    cpDelta1 = x - p.x;
                    cpDelta2 = z - p.z;
                    newDistance = tpDelta1 * tpDelta1 + tpDelta2 * tpDelta2 + cpDelta1 * cpDelta1 + cpDelta2 * cpDelta2;
                    traversalStrategies.add(new TraversalStrategy(newDistance, testPoint.x, y, testPointFixedXPlane, testPointFixedXAbovePlane, testPointFixedXBelowPlane, travelPlaneFixedY, fixedYAbovePlane, fixedYBelowPlane, this.xTree, this.yTree, p));
                }
            }
        }
        if (testPointFixedZAbovePlane != null && testPointFixedZBelowPlane != null && fixedYAbovePlane != null && fixedYBelowPlane != null) {
            checkAbove = 4.0 * (testPointFixedZAbovePlane.D * testPointFixedZAbovePlane.D * this.planetModel.inverseZScalingSquared + fixedYAbovePlane.D * fixedYAbovePlane.D * this.planetModel.inverseXYScalingSquared - 1.0);
            checkBelow = 4.0 * (testPointFixedZBelowPlane.D * testPointFixedZBelowPlane.D * this.planetModel.inverseZScalingSquared + fixedYBelowPlane.D * fixedYBelowPlane.D * this.planetModel.inverseXYScalingSquared - 1.0);
            if (checkAbove < 1.0E-24 && checkBelow < 1.0E-24) {
                GeoPoint[] YIntersectionsZ;
                for (GeoPoint p : YIntersectionsZ = travelPlaneFixedY.findIntersections(this.planetModel, testPointFixedZPlane, new Membership[0])) {
                    tpDelta1 = testPoint.x - p.x;
                    tpDelta2 = testPoint.y - p.y;
                    cpDelta1 = x - p.x;
                    cpDelta2 = z - p.z;
                    newDistance = tpDelta1 * tpDelta1 + tpDelta2 * tpDelta2 + cpDelta1 * cpDelta1 + cpDelta2 * cpDelta2;
                    traversalStrategies.add(new TraversalStrategy(newDistance, testPoint.z, y, testPointFixedZPlane, testPointFixedZAbovePlane, testPointFixedZBelowPlane, travelPlaneFixedY, fixedYAbovePlane, fixedYBelowPlane, this.zTree, this.yTree, p));
                }
            }
        }
        if (testPointFixedXAbovePlane != null && testPointFixedXBelowPlane != null && fixedZAbovePlane != null && fixedZBelowPlane != null) {
            checkAbove = 4.0 * (testPointFixedXAbovePlane.D * testPointFixedXAbovePlane.D * this.planetModel.inverseXYScalingSquared + fixedZAbovePlane.D * fixedZAbovePlane.D * this.planetModel.inverseZScalingSquared - 1.0);
            checkBelow = 4.0 * (testPointFixedXBelowPlane.D * testPointFixedXBelowPlane.D * this.planetModel.inverseXYScalingSquared + fixedZBelowPlane.D * fixedZBelowPlane.D * this.planetModel.inverseZScalingSquared - 1.0);
            if (checkAbove < 1.0E-24 && checkBelow < 1.0E-24) {
                GeoPoint[] ZIntersectionsX;
                for (GeoPoint p : ZIntersectionsX = travelPlaneFixedZ.findIntersections(this.planetModel, testPointFixedXPlane, new Membership[0])) {
                    tpDelta1 = testPoint.y - p.y;
                    tpDelta2 = testPoint.z - p.z;
                    cpDelta1 = y - p.y;
                    cpDelta2 = x - p.x;
                    newDistance = tpDelta1 * tpDelta1 + tpDelta2 * tpDelta2 + cpDelta1 * cpDelta1 + cpDelta2 * cpDelta2;
                    traversalStrategies.add(new TraversalStrategy(newDistance, testPoint.x, z, testPointFixedXPlane, testPointFixedXAbovePlane, testPointFixedXBelowPlane, travelPlaneFixedZ, fixedZAbovePlane, fixedZBelowPlane, this.xTree, this.zTree, p));
                }
            }
        }
        if (testPointFixedYAbovePlane != null && testPointFixedYBelowPlane != null && fixedZAbovePlane != null && fixedZBelowPlane != null) {
            checkAbove = 4.0 * (testPointFixedYAbovePlane.D * testPointFixedYAbovePlane.D * this.planetModel.inverseXYScalingSquared + fixedZAbovePlane.D * fixedZAbovePlane.D * this.planetModel.inverseZScalingSquared - 1.0);
            checkBelow = 4.0 * (testPointFixedYBelowPlane.D * testPointFixedYBelowPlane.D * this.planetModel.inverseXYScalingSquared + fixedZBelowPlane.D * fixedZBelowPlane.D * this.planetModel.inverseZScalingSquared - 1.0);
            if (checkAbove < 1.0E-24 && checkBelow < 1.0E-24) {
                GeoPoint[] ZIntersectionsY;
                for (GeoPoint p : ZIntersectionsY = travelPlaneFixedZ.findIntersections(this.planetModel, testPointFixedYPlane, new Membership[0])) {
                    tpDelta1 = testPoint.x - p.x;
                    tpDelta2 = testPoint.z - p.z;
                    cpDelta1 = y - p.y;
                    cpDelta2 = x - p.x;
                    newDistance = tpDelta1 * tpDelta1 + tpDelta2 * tpDelta2 + cpDelta1 * cpDelta1 + cpDelta2 * cpDelta2;
                    traversalStrategies.add(new TraversalStrategy(newDistance, testPoint.y, z, testPointFixedYPlane, testPointFixedYAbovePlane, testPointFixedYBelowPlane, travelPlaneFixedZ, fixedZAbovePlane, fixedZBelowPlane, this.yTree, this.zTree, p));
                }
            }
        }
        Collections.sort(traversalStrategies);
        if (traversalStrategies.size() == 0) {
            throw new IllegalArgumentException("No dual-plane travel strategies were found");
        }
        for (TraversalStrategy ts : traversalStrategies) {
            try {
                return ts.apply(testPoint, testPointInSet, x, y, z);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        throw new IllegalArgumentException("Exhausted all traversal strategies");
    }

    @Override
    public GeoPoint[] getEdgePoints() {
        return this.edgePoints;
    }

    @Override
    public boolean intersects(Plane p, GeoPoint[] notablePoints, Membership ... bounds) {
        IntersectorEdgeIterator intersector = new IntersectorEdgeIterator(p, notablePoints, bounds);
        XYZBounds xyzBounds = new XYZBounds();
        p.recordBounds(this.planetModel, xyzBounds, bounds);
        for (GeoPoint point : notablePoints) {
            xyzBounds.addPoint(point);
        }
        if (xyzBounds.getMaximumX() == null || xyzBounds.getMinimumX() == null || xyzBounds.getMaximumY() == null || xyzBounds.getMinimumY() == null || xyzBounds.getMaximumZ() == null || xyzBounds.getMinimumZ() == null) {
            return false;
        }
        double xDelta = xyzBounds.getMaximumX() - xyzBounds.getMinimumX();
        double yDelta = xyzBounds.getMaximumY() - xyzBounds.getMinimumY();
        double zDelta = xyzBounds.getMaximumZ() - xyzBounds.getMinimumZ();
        if (xDelta <= yDelta && xDelta <= zDelta) {
            return !this.xTree.traverse(intersector, xyzBounds.getMinimumX(), xyzBounds.getMaximumX());
        }
        if (yDelta <= xDelta && yDelta <= zDelta) {
            return !this.yTree.traverse(intersector, xyzBounds.getMinimumY(), xyzBounds.getMaximumY());
        }
        if (zDelta <= xDelta && zDelta <= yDelta) {
            return !this.zTree.traverse(intersector, xyzBounds.getMinimumZ(), xyzBounds.getMaximumZ());
        }
        return true;
    }

    @Override
    public boolean intersects(GeoShape geoShape) {
        IntersectorShapeIterator intersector = new IntersectorShapeIterator(geoShape);
        XYZBounds xyzBounds = new XYZBounds();
        geoShape.getBounds(xyzBounds);
        double xDelta = xyzBounds.getMaximumX() - xyzBounds.getMinimumX();
        double yDelta = xyzBounds.getMaximumY() - xyzBounds.getMinimumY();
        double zDelta = xyzBounds.getMaximumZ() - xyzBounds.getMinimumZ();
        if (xDelta <= yDelta && xDelta <= zDelta) {
            return !this.xTree.traverse(intersector, xyzBounds.getMinimumX(), xyzBounds.getMaximumX());
        }
        if (yDelta <= xDelta && yDelta <= zDelta) {
            return !this.yTree.traverse(intersector, xyzBounds.getMinimumY(), xyzBounds.getMaximumY());
        }
        if (zDelta <= xDelta && zDelta <= yDelta) {
            return !this.zTree.traverse(intersector, xyzBounds.getMinimumZ(), xyzBounds.getMaximumZ());
        }
        return true;
    }

    @Override
    public void getBounds(Bounds bounds) {
        super.getBounds(bounds);
        Edge[] edgeArray = this.shapeStartEdges;
        int n = edgeArray.length;
        for (int i = 0; i < n; ++i) {
            Edge startEdge;
            Edge currentEdge = startEdge = edgeArray[i];
            do {
                bounds.addPoint(currentEdge.startPoint);
                bounds.addPlane(this.planetModel, currentEdge.plane, currentEdge.startPlane, currentEdge.endPlane);
            } while ((currentEdge = currentEdge.next) != startEdge);
        }
    }

    @Override
    protected double outsideDistance(DistanceStyle distanceStyle, double x, double y, double z) {
        double minimumDistance = Double.POSITIVE_INFINITY;
        Edge[] edgeArray = this.shapeStartEdges;
        int n = edgeArray.length;
        for (int i = 0; i < n; ++i) {
            Edge shapeStartEdge;
            Edge shapeEdge = shapeStartEdge = edgeArray[i];
            do {
                double newDist;
                if ((newDist = distanceStyle.computeDistance(shapeEdge.startPoint, x, y, z)) < minimumDistance) {
                    minimumDistance = newDist;
                }
                Membership[] membershipArray = new Membership[]{shapeEdge.startPlane, shapeEdge.endPlane};
                double newPlaneDist = distanceStyle.computeDistance(this.planetModel, shapeEdge.plane, x, y, z, membershipArray);
                if (!(newPlaneDist < minimumDistance)) continue;
                minimumDistance = newPlaneDist;
            } while ((shapeEdge = shapeEdge.next) != shapeStartEdge);
        }
        return minimumDistance;
    }

    private CountingEdgeIterator createLinearCrossingEdgeIterator(GeoPoint testPoint, Plane plane, Plane abovePlane, Plane belowPlane, double thePointX, double thePointY, double thePointZ) {
        try {
            return new SectorLinearCrossingEdgeIterator(testPoint, plane, abovePlane, belowPlane, thePointX, thePointY, thePointZ);
        }
        catch (IllegalArgumentException e) {
            return new FullLinearCrossingEdgeIterator(testPoint, plane, abovePlane, belowPlane, thePointX, thePointY, thePointZ);
        }
    }

    private GeoPoint[] findAdjoiningPoints(Plane plane, GeoPoint pointOnPlane, Plane envelopePlane) {
        Vector perpendicular = new Vector(plane, pointOnPlane);
        double distanceFactor = 0.0;
        for (int i = 0; i < 100; ++i) {
            GeoPoint pointA = this.planetModel.createSurfacePoint(pointOnPlane.x + perpendicular.x * (distanceFactor += 1.0E-12), pointOnPlane.y + perpendicular.y * distanceFactor, pointOnPlane.z + perpendicular.z * distanceFactor);
            GeoPoint pointB = this.planetModel.createSurfacePoint(pointOnPlane.x - perpendicular.x * distanceFactor, pointOnPlane.y - perpendicular.y * distanceFactor, pointOnPlane.z - perpendicular.z * distanceFactor);
            if (!(Math.abs(envelopePlane.evaluate(pointA)) > 1.0E-13) || !(Math.abs(envelopePlane.evaluate(pointB)) > 1.0E-13)) continue;
            return new GeoPoint[]{pointA, pointB};
        }
        return null;
    }

    private static double computeSquaredDistance(GeoPoint checkPoint, GeoPoint intersectionPoint) {
        double distanceX = checkPoint.x - intersectionPoint.x;
        double distanceY = checkPoint.y - intersectionPoint.y;
        double distanceZ = checkPoint.z - intersectionPoint.z;
        return distanceX * distanceX + distanceY * distanceY + distanceZ * distanceZ;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof GeoComplexPolygon)) {
            return false;
        }
        GeoComplexPolygon other = (GeoComplexPolygon)o;
        return super.equals(other) && this.testPoint1InSet == other.testPoint1InSet && this.testPoint1.equals(other.testPoint1) && this.pointsList.equals(other.pointsList);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Boolean.hashCode(this.testPoint1InSet);
        result = 31 * result + this.testPoint1.hashCode();
        result = 31 * result + this.pointsList.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder edgeDescription = new StringBuilder();
        for (Edge shapeStartEdge : this.shapeStartEdges) {
            GeoComplexPolygon.fillInEdgeDescription(edgeDescription, shapeStartEdge);
        }
        return "GeoComplexPolygon: {planetmodel=" + this.planetModel + ", number of shapes=" + this.shapeStartEdges.length + ", address=" + Integer.toHexString(this.hashCode()) + ", testPoint=" + this.testPoint1 + ", testPointInSet=" + this.testPoint1InSet + ", shapes={" + edgeDescription + "}}";
    }

    private static void fillInEdgeDescription(StringBuilder description, Edge startEdge) {
        description.append(" {");
        Edge currentEdge = startEdge;
        int edgeCounter = 0;
        while (true) {
            if (edgeCounter > 0) {
                description.append(", ");
            }
            if (edgeCounter >= 20) {
                description.append("...");
                break;
            }
            description.append(currentEdge.startPoint);
            currentEdge = currentEdge.next;
            if (currentEdge == startEdge) break;
            ++edgeCounter;
        }
    }

    private static interface CountingEdgeIterator
    extends EdgeIterator {
        public int getCrossingCount();

        public boolean isOnEdge();
    }

    private static class Edge {
        public final GeoPoint startPoint;
        public final GeoPoint endPoint;
        public final GeoPoint[] notablePoints;
        public final SidedPlane startPlane;
        public final SidedPlane endPlane;
        public final SidedPlane backingPlane;
        public final Plane plane;
        public final XYZBounds planeBounds;
        public Edge previous = null;
        public Edge next = null;

        public Edge(PlanetModel pm, GeoPoint startPoint, GeoPoint endPoint) {
            this.startPoint = startPoint;
            this.endPoint = endPoint;
            this.notablePoints = new GeoPoint[]{startPoint, endPoint};
            this.plane = new Plane((Vector)startPoint, endPoint);
            this.startPlane = new SidedPlane((Vector)endPoint, (Vector)this.plane, startPoint);
            this.endPlane = new SidedPlane((Vector)startPoint, (Vector)this.plane, endPoint);
            GeoPoint interpolationPoint = this.plane.interpolate(pm, startPoint, endPoint, halfProportions)[0];
            this.backingPlane = new SidedPlane((Vector)interpolationPoint, (Vector)interpolationPoint, 0.0);
            this.planeBounds = new XYZBounds();
            this.planeBounds.addPoint(startPoint);
            this.planeBounds.addPoint(endPoint);
            this.planeBounds.addPlane(pm, this.plane, this.startPlane, this.endPlane, this.backingPlane);
        }

        public boolean isWithin(double thePointX, double thePointY, double thePointZ) {
            return this.plane.evaluateIsZero(thePointX, thePointY, thePointZ) && this.startPlane.isWithin(thePointX, thePointY, thePointZ) && this.endPlane.isWithin(thePointX, thePointY, thePointZ) && this.backingPlane.isWithin(thePointX, thePointY, thePointZ);
        }
    }

    private static class XTree
    extends Tree {
        public XTree(List<Edge> allEdges) {
            super(allEdges);
        }

        @Override
        protected double getMinimum(Edge edge) {
            return edge.planeBounds.getMinimumX();
        }

        @Override
        protected double getMaximum(Edge edge) {
            return edge.planeBounds.getMaximumX();
        }
    }

    private static abstract class Tree {
        private final Node rootNode;
        protected static final Edge[] EMPTY_ARRAY = new Edge[0];

        public Tree(List<Edge> allEdges) {
            Node[] edges = new Node[allEdges.size()];
            int i = 0;
            for (Edge edge : allEdges) {
                edges[i++] = new Node(edge, this.getMinimum(edge), this.getMaximum(edge));
            }
            Arrays.sort(edges, (left, right) -> {
                int ret = Double.compare(left.low, right.low);
                if (ret == 0) {
                    ret = Double.compare(left.max, right.max);
                }
                return ret;
            });
            this.rootNode = Tree.createTree(edges, 0, edges.length - 1);
        }

        private static Node createTree(Node[] edges, int low, int high) {
            if (low > high) {
                return null;
            }
            int mid = low + high >>> 1;
            Node newNode = edges[mid];
            newNode.left = Tree.createTree(edges, low, mid - 1);
            newNode.right = Tree.createTree(edges, mid + 1, high);
            if (newNode.left != null) {
                newNode.max = Math.max(newNode.max, newNode.left.max);
            }
            if (newNode.right != null) {
                newNode.max = Math.max(newNode.max, newNode.right.max);
            }
            return newNode;
        }

        protected abstract double getMinimum(Edge var1);

        protected abstract double getMaximum(Edge var1);

        public boolean traverse(EdgeIterator edgeIterator, double value) {
            return this.traverse(edgeIterator, value, value);
        }

        public boolean traverse(EdgeIterator edgeIterator, double minValue, double maxValue) {
            if (this.rootNode == null) {
                return true;
            }
            return this.rootNode.traverse(edgeIterator, minValue, maxValue);
        }
    }

    private static class YTree
    extends Tree {
        public YTree(List<Edge> allEdges) {
            super(allEdges);
        }

        @Override
        protected double getMinimum(Edge edge) {
            return edge.planeBounds.getMinimumY();
        }

        @Override
        protected double getMaximum(Edge edge) {
            return edge.planeBounds.getMaximumY();
        }
    }

    private static class ZTree
    extends Tree {
        public Node rootNode = null;

        public ZTree(List<Edge> allEdges) {
            super(allEdges);
        }

        @Override
        protected double getMinimum(Edge edge) {
            return edge.planeBounds.getMinimumZ();
        }

        @Override
        protected double getMaximum(Edge edge) {
            return edge.planeBounds.getMaximumZ();
        }
    }

    private static interface EdgeIterator {
        public boolean matches(Edge var1);
    }

    private class TraversalStrategy
    implements Comparable<TraversalStrategy> {
        private final double traversalDistance;
        private final double firstLegValue;
        private final double secondLegValue;
        private final Plane firstLegPlane;
        private final Plane firstLegAbovePlane;
        private final Plane firstLegBelowPlane;
        private final Plane secondLegPlane;
        private final Plane secondLegAbovePlane;
        private final Plane secondLegBelowPlane;
        private final Tree firstLegTree;
        private final Tree secondLegTree;
        private final GeoPoint intersectionPoint;

        public TraversalStrategy(double traversalDistance, double firstLegValue, double secondLegValue, Plane firstLegPlane, Plane firstLegAbovePlane, Plane firstLegBelowPlane, Plane secondLegPlane, Plane secondLegAbovePlane, Plane secondLegBelowPlane, Tree firstLegTree, Tree secondLegTree, GeoPoint intersectionPoint) {
            this.traversalDistance = traversalDistance;
            this.firstLegValue = firstLegValue;
            this.secondLegValue = secondLegValue;
            this.firstLegPlane = firstLegPlane;
            this.firstLegAbovePlane = firstLegAbovePlane;
            this.firstLegBelowPlane = firstLegBelowPlane;
            this.secondLegPlane = secondLegPlane;
            this.secondLegAbovePlane = secondLegAbovePlane;
            this.secondLegBelowPlane = secondLegBelowPlane;
            this.firstLegTree = firstLegTree;
            this.secondLegTree = secondLegTree;
            this.intersectionPoint = intersectionPoint;
        }

        public boolean apply(GeoPoint testPoint, boolean testPointInSet, double x, double y, double z) {
            try {
                CountingEdgeIterator testPointEdgeIterator = GeoComplexPolygon.this.createLinearCrossingEdgeIterator(testPoint, this.firstLegPlane, this.firstLegAbovePlane, this.firstLegBelowPlane, this.intersectionPoint.x, this.intersectionPoint.y, this.intersectionPoint.z);
                this.firstLegTree.traverse(testPointEdgeIterator, this.firstLegValue);
                boolean intersectionPointOnEdge = testPointEdgeIterator.isOnEdge();
                if (intersectionPointOnEdge) {
                    throw new IllegalArgumentException("Intersection point landed on an edge -- illegal path");
                }
                boolean intersectionPointInSet = intersectionPointOnEdge || ((testPointEdgeIterator.getCrossingCount() & 1) == 0 ? testPointInSet : !testPointInSet);
                CountingEdgeIterator travelEdgeIterator = GeoComplexPolygon.this.createLinearCrossingEdgeIterator(this.intersectionPoint, this.secondLegPlane, this.secondLegAbovePlane, this.secondLegBelowPlane, x, y, z);
                this.secondLegTree.traverse(travelEdgeIterator, this.secondLegValue);
                boolean rval = travelEdgeIterator.isOnEdge() || ((travelEdgeIterator.getCrossingCount() & 1) == 0 ? intersectionPointInSet : !intersectionPointInSet);
                return rval;
            }
            catch (IllegalArgumentException e) {
                DualCrossingEdgeIterator edgeIterator = new DualCrossingEdgeIterator(testPoint, this.firstLegPlane, this.firstLegAbovePlane, this.firstLegBelowPlane, this.secondLegPlane, this.secondLegAbovePlane, this.secondLegBelowPlane, x, y, z, this.intersectionPoint);
                this.firstLegTree.traverse(edgeIterator, this.firstLegValue);
                if (edgeIterator.isOnEdge()) {
                    return true;
                }
                this.secondLegTree.traverse(edgeIterator, this.secondLegValue);
                return edgeIterator.isOnEdge() || ((edgeIterator.getCrossingCount() & 1) == 0 ? testPointInSet : !testPointInSet);
            }
        }

        public String toString() {
            return "{firstLegValue=" + this.firstLegValue + "; secondLegValue=" + this.secondLegValue + "; firstLegPlane=" + this.firstLegPlane + "; secondLegPlane=" + this.secondLegPlane + "; intersectionPoint=" + this.intersectionPoint + "}";
        }

        @Override
        public int compareTo(TraversalStrategy other) {
            if (this.traversalDistance < other.traversalDistance) {
                return -1;
            }
            if (this.traversalDistance > other.traversalDistance) {
                return 1;
            }
            return 0;
        }
    }

    private class IntersectorEdgeIterator
    implements EdgeIterator {
        private final Plane plane;
        private final GeoPoint[] notablePoints;
        private final Membership[] bounds;

        public IntersectorEdgeIterator(Plane plane, GeoPoint[] notablePoints, Membership ... bounds) {
            this.plane = plane;
            this.notablePoints = notablePoints;
            this.bounds = bounds;
        }

        @Override
        public boolean matches(Edge edge) {
            return !this.plane.intersects(GeoComplexPolygon.this.planetModel, edge.plane, this.notablePoints, edge.notablePoints, this.bounds, edge.startPlane, edge.endPlane);
        }
    }

    private class IntersectorShapeIterator
    implements EdgeIterator {
        private final GeoShape shape;

        public IntersectorShapeIterator(GeoShape shape) {
            this.shape = shape;
        }

        @Override
        public boolean matches(Edge edge) {
            return !this.shape.intersects(edge.plane, edge.notablePoints, edge.startPlane, edge.endPlane);
        }
    }

    private class SectorLinearCrossingEdgeIterator
    implements CountingEdgeIterator {
        private final GeoPoint testPoint;
        private final Plane plane;
        private final Plane abovePlane;
        private final Plane belowPlane;
        private final Membership bound1;
        private final Membership bound2;
        private final double thePointX;
        private final double thePointY;
        private final double thePointZ;
        private boolean onEdge = false;
        private int aboveCrossingCount = 0;
        private int belowCrossingCount = 0;

        public SectorLinearCrossingEdgeIterator(GeoPoint testPoint, Plane plane, Plane abovePlane, Plane belowPlane, double thePointX, double thePointY, double thePointZ) {
            assert (plane.evaluateIsZero(thePointX, thePointY, thePointZ)) : "Check point is not on travel plane";
            assert (plane.evaluateIsZero(testPoint)) : "Test point is not on travel plane";
            this.testPoint = testPoint;
            this.plane = plane;
            this.abovePlane = abovePlane;
            this.belowPlane = belowPlane;
            SidedPlane bound1Plane = new SidedPlane(thePointX, thePointY, thePointZ, (Vector)plane, testPoint);
            SidedPlane bound2Plane = new SidedPlane((Vector)testPoint, plane, thePointX, thePointY, thePointZ);
            if (bound1Plane.isNumericallyIdentical(bound2Plane)) {
                throw new IllegalArgumentException("Sector iterator unreliable when bounds planes are numerically identical");
            }
            this.bound1 = bound1Plane;
            this.bound2 = bound2Plane;
            this.thePointX = thePointX;
            this.thePointY = thePointY;
            this.thePointZ = thePointZ;
        }

        @Override
        public int getCrossingCount() {
            return Math.min(this.aboveCrossingCount, this.belowCrossingCount);
        }

        @Override
        public boolean isOnEdge() {
            return this.onEdge;
        }

        @Override
        public boolean matches(Edge edge) {
            if (edge.isWithin(this.thePointX, this.thePointY, this.thePointZ)) {
                this.onEdge = true;
                return false;
            }
            GeoPoint[] planeCrossings = this.plane.findIntersections(GeoComplexPolygon.this.planetModel, edge.plane, this.bound1, this.bound2, edge.startPlane, edge.endPlane);
            if (planeCrossings != null && planeCrossings.length == 0 && !this.plane.evaluateIsZero(edge.startPoint) && !this.plane.evaluateIsZero(edge.endPoint)) {
                return true;
            }
            int aboveCrossings = this.countCrossings(edge, this.abovePlane, this.bound1, this.bound2);
            this.aboveCrossingCount += aboveCrossings;
            int belowCrossings = this.countCrossings(edge, this.belowPlane, this.bound1, this.bound2);
            this.belowCrossingCount += belowCrossings;
            return true;
        }

        private int countCrossings(Edge edge, Plane envelopePlane, Membership envelopeBound1, Membership envelopeBound2) {
            GeoPoint[] intersections = edge.plane.findIntersections(GeoComplexPolygon.this.planetModel, envelopePlane, envelopeBound1, envelopeBound2);
            int crossings = 0;
            if (intersections != null) {
                for (GeoPoint intersection : intersections) {
                    if (!edge.startPlane.strictlyWithin(intersection) || !edge.endPlane.strictlyWithin(intersection)) continue;
                    int counter = this.edgeCrossesEnvelope(edge.plane, intersection, envelopePlane) ? 1 : 0;
                    crossings += counter;
                }
            }
            return crossings;
        }

        private boolean edgeCrossesEnvelope(Plane edgePlane, GeoPoint intersectionPoint, Plane envelopePlane) {
            GeoPoint[] adjoiningPoints = GeoComplexPolygon.this.findAdjoiningPoints(edgePlane, intersectionPoint, envelopePlane);
            if (adjoiningPoints == null) {
                return true;
            }
            int withinCount = 0;
            for (GeoPoint adjoining : adjoiningPoints) {
                if (!this.plane.evaluateIsZero(adjoining) || !this.bound1.isWithin(adjoining) || !this.bound2.isWithin(adjoining)) continue;
                ++withinCount;
            }
            return withinCount & true;
        }
    }

    private class FullLinearCrossingEdgeIterator
    implements CountingEdgeIterator {
        private final GeoPoint testPoint;
        private final Plane plane;
        private final Plane abovePlane;
        private final Plane belowPlane;
        private final Membership bound;
        private final double thePointX;
        private final double thePointY;
        private final double thePointZ;
        private boolean onEdge = false;
        private int aboveCrossingCount = 0;
        private int belowCrossingCount = 0;

        public FullLinearCrossingEdgeIterator(GeoPoint testPoint, Plane plane, Plane abovePlane, Plane belowPlane, double thePointX, double thePointY, double thePointZ) {
            assert (plane.evaluateIsZero(thePointX, thePointY, thePointZ)) : "Check point is not on travel plane";
            assert (plane.evaluateIsZero(testPoint)) : "Test point is not on travel plane";
            this.testPoint = testPoint;
            this.plane = plane;
            this.abovePlane = abovePlane;
            this.belowPlane = belowPlane;
            if (plane.isNumericallyIdentical(testPoint)) {
                throw new IllegalArgumentException("Plane vector identical to testpoint vector");
            }
            this.bound = new SidedPlane((Vector)plane, testPoint);
            this.thePointX = thePointX;
            this.thePointY = thePointY;
            this.thePointZ = thePointZ;
        }

        @Override
        public int getCrossingCount() {
            return Math.min(this.aboveCrossingCount, this.belowCrossingCount);
        }

        @Override
        public boolean isOnEdge() {
            return this.onEdge;
        }

        @Override
        public boolean matches(Edge edge) {
            if (edge.isWithin(this.thePointX, this.thePointY, this.thePointZ)) {
                this.onEdge = true;
                return false;
            }
            GeoPoint[] planeCrossings = this.plane.findIntersections(GeoComplexPolygon.this.planetModel, edge.plane, this.bound, edge.startPlane, edge.endPlane);
            if (planeCrossings != null && planeCrossings.length == 0 && !this.plane.evaluateIsZero(edge.startPoint) && !this.plane.evaluateIsZero(edge.endPoint)) {
                return true;
            }
            int aboveCrossings = this.countCrossings(edge, this.abovePlane, this.bound);
            this.aboveCrossingCount += aboveCrossings;
            int belowCrossings = this.countCrossings(edge, this.belowPlane, this.bound);
            this.belowCrossingCount += belowCrossings;
            return true;
        }

        private int countCrossings(Edge edge, Plane envelopePlane, Membership envelopeBound) {
            GeoPoint[] intersections = edge.plane.findIntersections(GeoComplexPolygon.this.planetModel, envelopePlane, envelopeBound);
            int crossings = 0;
            if (intersections != null) {
                for (GeoPoint intersection : intersections) {
                    if (!edge.startPlane.strictlyWithin(intersection) || !edge.endPlane.strictlyWithin(intersection)) continue;
                    crossings += this.edgeCrossesEnvelope(edge.plane, intersection, envelopePlane) ? 1 : 0;
                }
            }
            return crossings;
        }

        private boolean edgeCrossesEnvelope(Plane edgePlane, GeoPoint intersectionPoint, Plane envelopePlane) {
            GeoPoint[] adjoiningPoints = GeoComplexPolygon.this.findAdjoiningPoints(edgePlane, intersectionPoint, envelopePlane);
            if (adjoiningPoints == null) {
                return true;
            }
            int withinCount = 0;
            for (GeoPoint adjoining : adjoiningPoints) {
                if (!this.plane.evaluateIsZero(adjoining) || !this.bound.isWithin(adjoining)) continue;
                ++withinCount;
            }
            return withinCount & true;
        }
    }

    private class DualCrossingEdgeIterator
    implements CountingEdgeIterator {
        private Set<Edge> seenEdges = null;
        private final GeoPoint testPoint;
        private final Plane testPointPlane;
        private final Plane testPointAbovePlane;
        private final Plane testPointBelowPlane;
        private final Plane travelPlane;
        private final Plane travelAbovePlane;
        private final Plane travelBelowPlane;
        private final double thePointX;
        private final double thePointY;
        private final double thePointZ;
        private final GeoPoint intersectionPoint;
        private final SidedPlane testPointCutoffPlane;
        private final SidedPlane checkPointCutoffPlane;
        private final SidedPlane testPointOtherCutoffPlane;
        private final SidedPlane checkPointOtherCutoffPlane;
        private boolean computedInsideOutside = false;
        private Plane testPointInsidePlane;
        private Plane testPointOutsidePlane;
        private Plane travelInsidePlane;
        private Plane travelOutsidePlane;
        private SidedPlane insideTestPointCutoffPlane;
        private SidedPlane insideTravelCutoffPlane;
        private SidedPlane outsideTestPointCutoffPlane;
        private SidedPlane outsideTravelCutoffPlane;
        private boolean onEdge = false;
        private int innerCrossingCount = 0;
        private int outerCrossingCount = 0;

        public DualCrossingEdgeIterator(GeoPoint testPoint, Plane testPointPlane, Plane testPointAbovePlane, Plane testPointBelowPlane, Plane travelPlane, Plane travelAbovePlane, Plane travelBelowPlane, double thePointX, double thePointY, double thePointZ, GeoPoint intersectionPoint) {
            this.testPoint = testPoint;
            this.testPointPlane = testPointPlane;
            this.testPointAbovePlane = testPointAbovePlane;
            this.testPointBelowPlane = testPointBelowPlane;
            this.travelPlane = travelPlane;
            this.travelAbovePlane = travelAbovePlane;
            this.travelBelowPlane = travelBelowPlane;
            this.thePointX = thePointX;
            this.thePointY = thePointY;
            this.thePointZ = thePointZ;
            this.intersectionPoint = intersectionPoint;
            assert (travelPlane.evaluateIsZero(intersectionPoint)) : "intersection point must be on travel plane";
            assert (testPointPlane.evaluateIsZero(intersectionPoint)) : "intersection point must be on test point plane";
            assert (!testPoint.isNumericallyIdentical(intersectionPoint)) : "test point is the same as intersection point";
            assert (!intersectionPoint.isNumericallyIdentical(thePointX, thePointY, thePointZ)) : "check point is same as intersection point";
            SidedPlane testPointBound1 = new SidedPlane((Vector)intersectionPoint, (Vector)testPointPlane, testPoint);
            SidedPlane testPointBound2 = new SidedPlane((Vector)testPoint, (Vector)testPointPlane, intersectionPoint);
            if (testPointBound1.isFunctionallyIdentical(testPointBound2)) {
                throw new IllegalArgumentException("Dual iterator unreliable when bounds planes are functionally identical");
            }
            this.testPointCutoffPlane = testPointBound1;
            this.testPointOtherCutoffPlane = testPointBound2;
            SidedPlane checkPointBound1 = new SidedPlane((Vector)intersectionPoint, travelPlane, thePointX, thePointY, thePointZ);
            SidedPlane checkPointBound2 = new SidedPlane(thePointX, thePointY, thePointZ, (Vector)travelPlane, intersectionPoint);
            if (checkPointBound1.isFunctionallyIdentical(checkPointBound2)) {
                throw new IllegalArgumentException("Dual iterator unreliable when bounds planes are functionally identical");
            }
            this.checkPointCutoffPlane = checkPointBound1;
            this.checkPointOtherCutoffPlane = checkPointBound2;
            assert (this.testPointCutoffPlane.isWithin(intersectionPoint)) : "intersection must be within testPointCutoffPlane";
            assert (this.testPointOtherCutoffPlane.isWithin(intersectionPoint)) : "intersection must be within testPointOtherCutoffPlane";
            assert (this.checkPointCutoffPlane.isWithin(intersectionPoint)) : "intersection must be within checkPointCutoffPlane";
            assert (this.checkPointOtherCutoffPlane.isWithin(intersectionPoint)) : "intersection must be within checkPointOtherCutoffPlane";
        }

        protected void computeInsideOutside() {
            if (!this.computedInsideOutside) {
                GeoPoint[] insideInsidePoints;
                SidedPlane intersectionBound1 = new SidedPlane((Vector)this.testPoint, (Vector)this.travelPlane, this.travelPlane.D);
                SidedPlane intersectionBound2 = new SidedPlane(this.thePointX, this.thePointY, this.thePointZ, (Vector)this.testPointPlane, this.testPointPlane.D);
                assert (intersectionBound1.isWithin(this.intersectionPoint)) : "intersection must be within intersectionBound1";
                assert (intersectionBound2.isWithin(this.intersectionPoint)) : "intersection must be within intersectionBound2";
                GeoPoint[] aboveAbove = this.travelAbovePlane.findIntersections(GeoComplexPolygon.this.planetModel, this.testPointAbovePlane, intersectionBound1, intersectionBound2);
                assert (aboveAbove != null) : "Above + above should not be coplanar";
                GeoPoint[] aboveBelow = this.travelAbovePlane.findIntersections(GeoComplexPolygon.this.planetModel, this.testPointBelowPlane, intersectionBound1, intersectionBound2);
                assert (aboveBelow != null) : "Above + below should not be coplanar";
                GeoPoint[] belowBelow = this.travelBelowPlane.findIntersections(GeoComplexPolygon.this.planetModel, this.testPointBelowPlane, intersectionBound1, intersectionBound2);
                assert (belowBelow != null) : "Below + below should not be coplanar";
                GeoPoint[] belowAbove = this.travelBelowPlane.findIntersections(GeoComplexPolygon.this.planetModel, this.testPointAbovePlane, intersectionBound1, intersectionBound2);
                assert (belowAbove != null) : "Below + above should not be coplanar";
                assert ((aboveAbove.length > 0 ? 1 : 0) + (aboveBelow.length > 0 ? 1 : 0) + (belowBelow.length > 0 ? 1 : 0) + (belowAbove.length > 0 ? 1 : 0) == 1) : "Can be exactly one inside point, instead was: aa=" + aboveAbove.length + " xyScaling=" + aboveBelow.length + " bb=" + belowBelow.length + " ba=" + belowAbove.length;
                if (aboveAbove.length > 0) {
                    this.travelInsidePlane = this.travelAbovePlane;
                    this.testPointInsidePlane = this.testPointAbovePlane;
                    this.travelOutsidePlane = this.travelBelowPlane;
                    this.testPointOutsidePlane = this.testPointBelowPlane;
                    insideInsidePoints = aboveAbove;
                } else if (aboveBelow.length > 0) {
                    this.travelInsidePlane = this.travelAbovePlane;
                    this.testPointInsidePlane = this.testPointBelowPlane;
                    this.travelOutsidePlane = this.travelBelowPlane;
                    this.testPointOutsidePlane = this.testPointAbovePlane;
                    insideInsidePoints = aboveBelow;
                } else if (belowBelow.length > 0) {
                    this.travelInsidePlane = this.travelBelowPlane;
                    this.testPointInsidePlane = this.testPointBelowPlane;
                    this.travelOutsidePlane = this.travelAbovePlane;
                    this.testPointOutsidePlane = this.testPointAbovePlane;
                    insideInsidePoints = belowBelow;
                } else if (belowAbove.length > 0) {
                    this.travelInsidePlane = this.travelBelowPlane;
                    this.testPointInsidePlane = this.testPointAbovePlane;
                    this.travelOutsidePlane = this.travelAbovePlane;
                    this.testPointOutsidePlane = this.testPointBelowPlane;
                    insideInsidePoints = belowAbove;
                } else {
                    throw new IllegalStateException("Can't find traversal intersection among: " + this.travelAbovePlane + ", " + this.testPointAbovePlane + ", " + this.travelBelowPlane + ", " + this.testPointBelowPlane);
                }
                GeoPoint insideInsidePoint = this.pickProximate(insideInsidePoints);
                GeoPoint[] outsideOutsidePoints = this.testPointOutsidePlane.findIntersections(GeoComplexPolygon.this.planetModel, this.travelOutsidePlane, new Membership[0]);
                GeoPoint outsideOutsidePoint = this.pickProximate(outsideOutsidePoints);
                this.insideTravelCutoffPlane = new SidedPlane(this.thePointX, this.thePointY, this.thePointZ, (Vector)this.travelInsidePlane, insideInsidePoint);
                this.outsideTravelCutoffPlane = new SidedPlane(this.thePointX, this.thePointY, this.thePointZ, (Vector)this.travelInsidePlane, outsideOutsidePoint);
                this.insideTestPointCutoffPlane = new SidedPlane((Vector)this.testPoint, (Vector)this.testPointInsidePlane, insideInsidePoint);
                this.outsideTestPointCutoffPlane = new SidedPlane((Vector)this.testPoint, (Vector)this.testPointOutsidePlane, outsideOutsidePoint);
                this.computedInsideOutside = true;
            }
        }

        private GeoPoint pickProximate(GeoPoint[] points) {
            double p2dist;
            if (points.length == 0) {
                throw new IllegalArgumentException("No off-plane intersection points were found; can't compute traversal");
            }
            if (points.length == 1) {
                return points[0];
            }
            double p1dist = GeoComplexPolygon.computeSquaredDistance(points[0], this.intersectionPoint);
            if (p1dist < (p2dist = GeoComplexPolygon.computeSquaredDistance(points[1], this.intersectionPoint))) {
                return points[0];
            }
            if (p2dist < p1dist) {
                return points[1];
            }
            throw new IllegalArgumentException("Neither off-plane intersection point matched intersection point; intersection = " + this.intersectionPoint + "; offplane choice 0: " + points[0] + "; offplane choice 1: " + points[1]);
        }

        @Override
        public int getCrossingCount() {
            return Math.min(this.innerCrossingCount, this.outerCrossingCount);
        }

        @Override
        public boolean isOnEdge() {
            return this.onEdge;
        }

        @Override
        public boolean matches(Edge edge) {
            GeoPoint[] testPointCrossings;
            if (edge.isWithin(this.thePointX, this.thePointY, this.thePointZ)) {
                this.onEdge = true;
                return false;
            }
            if (this.seenEdges != null && this.seenEdges.contains(edge)) {
                return true;
            }
            if (this.seenEdges == null) {
                this.seenEdges = new HashSet<Edge>();
            }
            this.seenEdges.add(edge);
            this.computeInsideOutside();
            GeoPoint[] travelCrossings = this.travelPlane.findIntersections(GeoComplexPolygon.this.planetModel, edge.plane, this.checkPointCutoffPlane, this.checkPointOtherCutoffPlane, edge.startPlane, edge.endPlane);
            if (!(travelCrossings == null || travelCrossings.length != 0 || (testPointCrossings = this.testPointPlane.findIntersections(GeoComplexPolygon.this.planetModel, edge.plane, this.testPointCutoffPlane, this.testPointOtherCutoffPlane, edge.startPlane, edge.endPlane)) == null || testPointCrossings.length != 0 || this.travelPlane.evaluateIsZero(edge.startPoint) || this.travelPlane.evaluateIsZero(edge.endPoint) || this.testPointPlane.evaluateIsZero(edge.startPoint) || this.testPointPlane.evaluateIsZero(edge.endPoint))) {
                return true;
            }
            this.innerCrossingCount += this.countCrossings(edge, this.travelInsidePlane, this.checkPointCutoffPlane, this.insideTravelCutoffPlane, this.testPointInsidePlane, this.testPointCutoffPlane, this.insideTestPointCutoffPlane);
            this.outerCrossingCount += this.countCrossings(edge, this.travelOutsidePlane, this.checkPointCutoffPlane, this.outsideTravelCutoffPlane, this.testPointOutsidePlane, this.testPointCutoffPlane, this.outsideTestPointCutoffPlane);
            return true;
        }

        private int countCrossings(Edge edge, Plane travelEnvelopePlane, Membership travelEnvelopeBound1, Membership travelEnvelopeBound2, Plane testPointEnvelopePlane, Membership testPointEnvelopeBound1, Membership testPointEnvelopeBound2) {
            GeoPoint[] travelIntersections = edge.plane.findIntersections(GeoComplexPolygon.this.planetModel, travelEnvelopePlane, travelEnvelopeBound1, travelEnvelopeBound2);
            GeoPoint[] testPointIntersections = edge.plane.findIntersections(GeoComplexPolygon.this.planetModel, testPointEnvelopePlane, testPointEnvelopeBound1, testPointEnvelopeBound2);
            int crossings = 0;
            if (travelIntersections != null) {
                for (GeoPoint intersection : travelIntersections) {
                    if (!edge.startPlane.strictlyWithin(intersection) || !edge.endPlane.strictlyWithin(intersection)) continue;
                    boolean notDup = true;
                    if (testPointIntersections != null) {
                        for (GeoPoint otherIntersection : testPointIntersections) {
                            if (!edge.startPlane.strictlyWithin(otherIntersection) || !edge.endPlane.strictlyWithin(otherIntersection) || !intersection.isNumericallyIdentical(otherIntersection)) continue;
                            notDup = false;
                            break;
                        }
                    }
                    if (!notDup) continue;
                    crossings += this.edgeCrossesEnvelope(edge.plane, intersection, travelEnvelopePlane) ? 1 : 0;
                }
            }
            if (testPointIntersections != null) {
                for (GeoPoint intersection : testPointIntersections) {
                    if (!edge.startPlane.strictlyWithin(intersection) || !edge.endPlane.strictlyWithin(intersection)) continue;
                    crossings += this.edgeCrossesEnvelope(edge.plane, intersection, testPointEnvelopePlane) ? 1 : 0;
                }
            }
            return crossings;
        }

        private boolean edgeCrossesEnvelope(Plane edgePlane, GeoPoint intersectionPoint, Plane envelopePlane) {
            GeoPoint[] adjoiningPoints = GeoComplexPolygon.this.findAdjoiningPoints(edgePlane, intersectionPoint, envelopePlane);
            if (adjoiningPoints == null) {
                return true;
            }
            int withinCount = 0;
            for (GeoPoint adjoining : adjoiningPoints) {
                if ((!this.travelPlane.evaluateIsZero(adjoining) || !this.checkPointCutoffPlane.isWithin(adjoining) || !this.checkPointOtherCutoffPlane.isWithin(adjoining)) && (!this.testPointPlane.evaluateIsZero(adjoining) || !this.testPointCutoffPlane.isWithin(adjoining) || !this.testPointOtherCutoffPlane.isWithin(adjoining))) continue;
                ++withinCount;
            }
            return withinCount & true;
        }
    }

    private static class Node {
        public final Edge edge;
        public final double low;
        public final double high;
        public Node left = null;
        public Node right = null;
        public double max;

        public Node(Edge edge, double minimumValue, double maximumValue) {
            this.edge = edge;
            this.low = minimumValue;
            this.high = maximumValue;
            this.max = maximumValue;
        }

        public boolean traverse(EdgeIterator edgeIterator, double minValue, double maxValue) {
            if (minValue <= this.max) {
                if (minValue <= this.high && maxValue >= this.low && !edgeIterator.matches(this.edge)) {
                    return false;
                }
                if (this.left != null && !this.left.traverse(edgeIterator, minValue, maxValue)) {
                    return false;
                }
                if (this.right != null && maxValue >= this.low && !this.right.traverse(edgeIterator, minValue, maxValue)) {
                    return false;
                }
            }
            return true;
        }
    }
}

