/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.solr.common.SolrException;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DIHCache;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.DocBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DIHCacheSupport {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String cacheForeignKey;
    private String cacheImplName;
    private Map<String, DIHCache> queryVsCache = new HashMap<String, DIHCache>();
    private Map<String, Iterator<Map<String, Object>>> queryVsCacheIterator;
    private Iterator<Map<String, Object>> dataSourceRowCache;
    private boolean cacheDoKeyLookup;
    public static final String CACHE_IMPL = "cacheImpl";
    public static final String CACHE_DELETE_PRIOR_DATA = "cacheDeletePriorData";
    public static final String CACHE_FOREIGN_KEY = "cacheLookup";
    public static final String CACHE_PRIMARY_KEY = "cacheKey";
    public static final String CACHE_READ_ONLY = "cacheReadOnly";

    public DIHCacheSupport(Context context, String cacheImplName) {
        this.cacheImplName = cacheImplName;
        Relation r = new Relation(context);
        this.cacheDoKeyLookup = r.doKeyLookup;
        String cacheKey = r.primaryKey;
        this.cacheForeignKey = r.foreignKey;
        context.setSessionAttribute(CACHE_PRIMARY_KEY, cacheKey, "entity");
        context.setSessionAttribute(CACHE_FOREIGN_KEY, this.cacheForeignKey, "entity");
        context.setSessionAttribute(CACHE_DELETE_PRIOR_DATA, "true", "entity");
        context.setSessionAttribute(CACHE_READ_ONLY, "false", "entity");
    }

    private DIHCache instantiateCache(Context context) {
        DIHCache cache = null;
        try {
            Class cacheClass = DocBuilder.loadClass(this.cacheImplName, context.getSolrCore());
            Constructor constr = cacheClass.getConstructor(new Class[0]);
            cache = (DIHCache)constr.newInstance(new Object[0]);
            cache.open(context);
        }
        catch (Exception e) {
            throw new DataImportHandlerException(500, "Unable to load Cache implementation:" + this.cacheImplName, e);
        }
        return cache;
    }

    public void initNewParent(Context context) {
        this.dataSourceRowCache = null;
        this.queryVsCacheIterator = new HashMap<String, Iterator<Map<String, Object>>>();
        for (Map.Entry<String, DIHCache> entry : this.queryVsCache.entrySet()) {
            this.queryVsCacheIterator.put(entry.getKey(), entry.getValue().iterator());
        }
    }

    public void destroyAll() {
        if (this.queryVsCache != null) {
            for (DIHCache cache : this.queryVsCache.values()) {
                cache.destroy();
            }
        }
        this.queryVsCache = null;
        this.dataSourceRowCache = null;
        this.cacheForeignKey = null;
    }

    public void populateCache(String query, Iterator<Map<String, Object>> rowIterator) {
        Map<String, Object> aRow = null;
        DIHCache cache = this.queryVsCache.get(query);
        while ((aRow = this.getNextFromCache(query, rowIterator)) != null) {
            cache.add(aRow);
        }
    }

    private Map<String, Object> getNextFromCache(String query, Iterator<Map<String, Object>> rowIterator) {
        try {
            if (rowIterator == null) {
                return null;
            }
            if (rowIterator.hasNext()) {
                return rowIterator.next();
            }
            return null;
        }
        catch (Exception e) {
            SolrException.log((Logger)log, (String)("getNextFromCache() failed for query '" + query + "'"), (Throwable)e);
            DataImportHandlerException.wrapAndThrow(400, e);
            return null;
        }
    }

    public Map<String, Object> getCacheData(Context context, String query, Iterator<Map<String, Object>> rowIterator) {
        if (this.cacheDoKeyLookup) {
            return this.getIdCacheData(context, query, rowIterator);
        }
        return this.getSimpleCacheData(context, query, rowIterator);
    }

    protected Map<String, Object> getIdCacheData(Context context, String query, Iterator<Map<String, Object>> rowIterator) {
        Object key = context.resolve(this.cacheForeignKey);
        if (key == null) {
            throw new DataImportHandlerException(400, "The cache lookup value : " + this.cacheForeignKey + " is resolved to be null in the entity :" + context.getEntityAttribute("name"));
        }
        if (this.dataSourceRowCache == null) {
            DIHCache cache = this.queryVsCache.get(query);
            if (cache == null) {
                cache = this.instantiateCache(context);
                this.queryVsCache.put(query, cache);
                this.populateCache(query, rowIterator);
            }
            this.dataSourceRowCache = cache.iterator(key);
        }
        return this.getFromRowCacheTransformed();
    }

    protected Map<String, Object> getSimpleCacheData(Context context, String query, Iterator<Map<String, Object>> rowIterator) {
        if (this.dataSourceRowCache == null) {
            DIHCache cache = this.queryVsCache.get(query);
            if (cache == null) {
                cache = this.instantiateCache(context);
                this.queryVsCache.put(query, cache);
                this.populateCache(query, rowIterator);
                this.queryVsCacheIterator.put(query, cache.iterator());
            }
            Iterator<Map<String, Object>> cacheIter = this.queryVsCacheIterator.get(query);
            this.dataSourceRowCache = cacheIter;
        }
        return this.getFromRowCacheTransformed();
    }

    protected Map<String, Object> getFromRowCacheTransformed() {
        if (this.dataSourceRowCache == null || !this.dataSourceRowCache.hasNext()) {
            this.dataSourceRowCache = null;
            return null;
        }
        Map<String, Object> r = this.dataSourceRowCache.next();
        return r;
    }

    static class Relation {
        protected final boolean doKeyLookup;
        protected final String foreignKey;
        protected final String primaryKey;

        public Relation(Context context) {
            String where = context.getEntityAttribute("where");
            String cacheKey = context.getEntityAttribute(DIHCacheSupport.CACHE_PRIMARY_KEY);
            String lookupKey = context.getEntityAttribute(DIHCacheSupport.CACHE_FOREIGN_KEY);
            if (cacheKey != null && lookupKey == null) {
                throw new DataImportHandlerException(500, "'cacheKey' is specified for the entity " + context.getEntityAttribute("name") + " but 'cacheLookup' is missing");
            }
            if (where == null && cacheKey == null) {
                this.doKeyLookup = false;
                this.primaryKey = null;
                this.foreignKey = null;
            } else {
                if (where != null) {
                    String[] splits = where.split("=");
                    this.primaryKey = splits[0];
                    this.foreignKey = splits[1].trim();
                } else {
                    this.primaryKey = cacheKey;
                    this.foreignKey = lookupKey;
                }
                this.doKeyLookup = true;
            }
        }

        public String toString() {
            return "Relation " + this.primaryKey + "=" + this.foreignKey;
        }
    }
}

