/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl;

import com.healthmarketscience.jackcess.impl.BaseCryptCodecHandler;
import com.healthmarketscience.jackcess.impl.PageChannel;
import com.healthmarketscience.jackcess.util.StreamCipherCompat;
import com.healthmarketscience.jackcess.util.StreamCipherFactory;
import java.nio.ByteBuffer;

public abstract class BaseJetCryptCodecHandler
extends BaseCryptCodecHandler {
    private StreamCipherCompat _engine;

    protected BaseJetCryptCodecHandler(PageChannel channel, byte[] encodingKey) {
        super(channel, encodingKey);
    }

    public boolean canEncodePartialPage() {
        return true;
    }

    public boolean canDecodeInline() {
        return true;
    }

    @Override
    protected final StreamCipherCompat getStreamCipher() {
        if (this._engine == null) {
            this._engine = StreamCipherFactory.newRC4Engine();
        }
        return this._engine;
    }

    public void decodePage(ByteBuffer inPage, ByteBuffer outPage, int pageNumber) {
        if (!this.isEncryptedPage(pageNumber)) {
            return;
        }
        this.streamDecrypt(inPage, pageNumber);
    }

    public ByteBuffer encodePage(ByteBuffer buffer, int pageNumber, int pageOffset) {
        if (!this.isEncryptedPage(pageNumber)) {
            return buffer;
        }
        return this.streamEncrypt(buffer, pageNumber, pageOffset);
    }

    private boolean isEncryptedPage(int pageNumber) {
        return pageNumber > 0 && pageNumber <= this.getMaxEncodedPage();
    }

    protected abstract int getMaxEncodedPage();
}

