/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.backup.repository.BackupRepository;
import org.apache.solr.handler.IndexFetcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestoreCore
implements Callable<Boolean> {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final String backupName;
    private final URI backupLocation;
    private final SolrCore core;
    private final BackupRepository backupRepo;

    public RestoreCore(BackupRepository backupRepo, SolrCore core, URI location, String name) {
        this.backupRepo = backupRepo;
        this.core = core;
        this.backupLocation = location;
        this.backupName = name;
    }

    @Override
    public Boolean call() throws Exception {
        return this.doRestore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean doRestore() throws Exception {
        int n;
        Directory indexDir;
        block24: {
            URI backupPath = this.backupRepo.resolve(this.backupLocation, this.backupName);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS", Locale.ROOT);
            String restoreIndexName = "restore." + dateFormat.format(new Date());
            String restoreIndexPath = this.core.getDataDir() + restoreIndexName;
            String indexDirPath = this.core.getIndexDir();
            Directory restoreIndexDir = null;
            indexDir = null;
            try {
                boolean success;
                restoreIndexDir = this.core.getDirectoryFactory().get(restoreIndexPath, DirectoryFactory.DirContext.DEFAULT, this.core.getSolrConfig().indexConfig.lockType);
                indexDir = this.core.getDirectoryFactory().get(indexDirPath, DirectoryFactory.DirContext.DEFAULT, this.core.getSolrConfig().indexConfig.lockType);
                for (String filename : this.backupRepo.listAll(backupPath)) {
                    this.checkInterrupted();
                    log.info("Copying file {} to restore directory ", (Object)filename);
                    try (IndexInput indexInput = this.backupRepo.openInput(backupPath, filename, IOContext.READONCE);){
                        Long checksum = null;
                        try {
                            checksum = CodecUtil.retrieveChecksum((IndexInput)indexInput);
                        }
                        catch (Exception e) {
                            log.warn("Could not read checksum from index file: {}", (Object)filename, (Object)e);
                        }
                        long length = indexInput.length();
                        IndexFetcher.CompareResult compareResult = IndexFetcher.compareFile(indexDir, filename, length, checksum);
                        if (!compareResult.equal || IndexFetcher.filesToAlwaysDownloadIfNoChecksums(filename, length, compareResult)) {
                            this.backupRepo.copyFileTo(backupPath, filename, restoreIndexDir);
                            continue;
                        }
                        restoreIndexDir.copyFrom(indexDir, filename, filename, IOContext.READONCE);
                    }
                    catch (Exception e) {
                        log.warn("Exception while restoring the backup index ", (Throwable)e);
                        throw new SolrException(SolrException.ErrorCode.UNKNOWN, "Exception while restoring the backup index", (Throwable)e);
                    }
                }
                log.debug("Switching directories");
                this.core.modifyIndexProps(restoreIndexName);
                try {
                    this.core.getUpdateHandler().newIndexWriter(false);
                    this.openNewSearcher();
                    success = true;
                    log.info("Successfully restored to the backup index");
                }
                catch (Exception e) {
                    block23: {
                        log.warn("Could not switch to restored index. Rolling back to the current index", (Throwable)e);
                        Directory dir = null;
                        try {
                            dir = this.core.getDirectoryFactory().get(this.core.getDataDir(), DirectoryFactory.DirContext.META_DATA, this.core.getSolrConfig().indexConfig.lockType);
                            dir.deleteFile("index.properties");
                            if (dir == null) break block23;
                        }
                        catch (Throwable throwable) {
                            if (dir != null) {
                                this.core.getDirectoryFactory().release(dir);
                            }
                            throw throwable;
                        }
                        this.core.getDirectoryFactory().release(dir);
                    }
                    this.core.getDirectoryFactory().doneWithDirectory(restoreIndexDir);
                    this.core.getDirectoryFactory().remove(restoreIndexDir);
                    this.core.getUpdateHandler().newIndexWriter(false);
                    this.openNewSearcher();
                    throw new SolrException(SolrException.ErrorCode.UNKNOWN, "Exception while restoring the backup index", (Throwable)e);
                }
                if (success) {
                    this.core.getDirectoryFactory().doneWithDirectory(indexDir);
                    this.core.deleteNonSnapshotIndexFiles(indexDirPath);
                }
                n = 1;
                if (restoreIndexDir == null) break block24;
            }
            catch (Throwable throwable) {
                if (restoreIndexDir != null) {
                    this.core.getDirectoryFactory().release(restoreIndexDir);
                }
                if (indexDir != null) {
                    this.core.getDirectoryFactory().release(indexDir);
                }
                throw throwable;
            }
            this.core.getDirectoryFactory().release(restoreIndexDir);
        }
        if (indexDir != null) {
            this.core.getDirectoryFactory().release(indexDir);
        }
        return n != 0;
    }

    private void checkInterrupted() throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException("Stopping restore process. Thread was interrupted.");
        }
    }

    private void openNewSearcher() throws Exception {
        Future[] waitSearcher = new Future[1];
        this.core.getSearcher(true, false, waitSearcher, true);
        if (waitSearcher[0] != null) {
            waitSearcher[0].get();
        }
    }
}

