// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from nrf5340_network.svd, see https://github.com/NordicSemiconductor/nrfx/tree/master/mdk

// +build nrf,nrf5340_network

// nRF53 reference description for system-on-chip with dual ARM 32-bit Cortex-M33 microcontrollers
//
//     Copyright (c) 2010 - 2020, Nordic Semiconductor ASA All rights reserved. Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met: 1. Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer. 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution. 3. Neither the name of Nordic Semiconductor ASA nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission. THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL NORDIC SEMICONDUCTOR ASA OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
package nrf

import (
	"runtime/interrupt"
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "nrf5340_network"
	CPU          = "CM33"
	FPUPresent   = false
	NVICPrioBits = 3
)

// Interrupt numbers.
const (
	// Clock management // Power control
	IRQ_CLOCK_POWER = 5

	// Clock management
	IRQ_CLOCK_NS = 5

	// Power control
	IRQ_POWER_NS = 5

	// 2.4 GHz radio
	IRQ_RADIO = 8

	// 2.4 GHz radio
	IRQ_RADIO_NS = 8

	// Random Number Generator
	IRQ_RNG = 9

	// Random Number Generator
	IRQ_RNG_NS = 9

	// GPIO Tasks and Events
	IRQ_GPIOTE = 10

	// GPIO Tasks and Events
	IRQ_GPIOTE_NS = 10

	// Watchdog Timer
	IRQ_WDT = 11

	// Watchdog Timer
	IRQ_WDT_NS = 11

	// Timer/Counter 0
	IRQ_TIMER0 = 12

	// Timer/Counter 0
	IRQ_TIMER0_NS = 12

	// AES ECB Mode Encryption
	IRQ_ECB = 13

	// AES ECB Mode Encryption
	IRQ_ECB_NS = 13

	// Accelerated Address Resolver // AES CCM mode encryption
	IRQ_AAR_CCM = 14

	// Accelerated Address Resolver
	IRQ_AAR_NS = 14

	// AES CCM mode encryption
	IRQ_CCM_NS = 14

	// Temperature Sensor
	IRQ_TEMP = 16

	// Temperature Sensor
	IRQ_TEMP_NS = 16

	// Real-time counter 0
	IRQ_RTC0 = 17

	// Real-time counter 0
	IRQ_RTC0_NS = 17

	// Interprocessor communication
	IRQ_IPC = 18

	// Interprocessor communication
	IRQ_IPC_NS = 18

	// Serial Peripheral Interface Master with EasyDMA // SPI Slave // I2C compatible Two-Wire Master Interface with EasyDMA // I2C compatible Two-Wire Slave Interface with EasyDMA // UART with EasyDMA
	IRQ_SPIM0_SPIS0_TWIM0_TWIS0_UARTE0 = 19

	// Serial Peripheral Interface Master with EasyDMA
	IRQ_SPIM0_NS = 19

	// SPI Slave
	IRQ_SPIS0_NS = 19

	// I2C compatible Two-Wire Master Interface with EasyDMA
	IRQ_TWIM0_NS = 19

	// I2C compatible Two-Wire Slave Interface with EasyDMA
	IRQ_TWIS0_NS = 19

	// UART with EasyDMA
	IRQ_UARTE0_NS = 19

	// Event generator unit
	IRQ_EGU0 = 20

	// Event generator unit
	IRQ_EGU0_NS = 20

	// Real-time counter 1
	IRQ_RTC1 = 22

	// Real-time counter 1
	IRQ_RTC1_NS = 22

	// Timer/Counter 1
	IRQ_TIMER1 = 24

	// Timer/Counter 1
	IRQ_TIMER1_NS = 24

	// Timer/Counter 2
	IRQ_TIMER2 = 25

	// Timer/Counter 2
	IRQ_TIMER2_NS = 25

	// Software interrupt 0
	IRQ_SWI0 = 26

	// Software interrupt 0
	IRQ_SWI0_NS = 26

	// Software interrupt 1
	IRQ_SWI1 = 27

	// Software interrupt 1
	IRQ_SWI1_NS = 27

	// Software interrupt 2
	IRQ_SWI2 = 28

	// Software interrupt 2
	IRQ_SWI2_NS = 28

	// Software interrupt 3
	IRQ_SWI3 = 29

	// Software interrupt 3
	IRQ_SWI3_NS = 29

	// Highest interrupt number on this device.
	IRQ_max = 29
)

// Map interrupt numbers to function names.
// These aren't real calls, they're removed by the compiler.
var (
	_ = interrupt.Register(IRQ_CLOCK_POWER, "CLOCK_POWER_IRQHandler")
	_ = interrupt.Register(IRQ_CLOCK_NS, "CLOCK_POWER_IRQHandler")
	_ = interrupt.Register(IRQ_POWER_NS, "CLOCK_POWER_IRQHandler")
	_ = interrupt.Register(IRQ_RADIO, "RADIO_IRQHandler")
	_ = interrupt.Register(IRQ_RADIO_NS, "RADIO_IRQHandler")
	_ = interrupt.Register(IRQ_RNG, "RNG_IRQHandler")
	_ = interrupt.Register(IRQ_RNG_NS, "RNG_IRQHandler")
	_ = interrupt.Register(IRQ_GPIOTE, "GPIOTE_IRQHandler")
	_ = interrupt.Register(IRQ_GPIOTE_NS, "GPIOTE_IRQHandler")
	_ = interrupt.Register(IRQ_WDT, "WDT_IRQHandler")
	_ = interrupt.Register(IRQ_WDT_NS, "WDT_IRQHandler")
	_ = interrupt.Register(IRQ_TIMER0, "TIMER0_IRQHandler")
	_ = interrupt.Register(IRQ_TIMER0_NS, "TIMER0_IRQHandler")
	_ = interrupt.Register(IRQ_ECB, "ECB_IRQHandler")
	_ = interrupt.Register(IRQ_ECB_NS, "ECB_IRQHandler")
	_ = interrupt.Register(IRQ_AAR_CCM, "AAR_CCM_IRQHandler")
	_ = interrupt.Register(IRQ_AAR_NS, "AAR_CCM_IRQHandler")
	_ = interrupt.Register(IRQ_CCM_NS, "AAR_CCM_IRQHandler")
	_ = interrupt.Register(IRQ_TEMP, "TEMP_IRQHandler")
	_ = interrupt.Register(IRQ_TEMP_NS, "TEMP_IRQHandler")
	_ = interrupt.Register(IRQ_RTC0, "RTC0_IRQHandler")
	_ = interrupt.Register(IRQ_RTC0_NS, "RTC0_IRQHandler")
	_ = interrupt.Register(IRQ_IPC, "IPC_IRQHandler")
	_ = interrupt.Register(IRQ_IPC_NS, "IPC_IRQHandler")
	_ = interrupt.Register(IRQ_SPIM0_SPIS0_TWIM0_TWIS0_UARTE0, "SPIM0_SPIS0_TWIM0_TWIS0_UARTE0_IRQHandler")
	_ = interrupt.Register(IRQ_SPIM0_NS, "SPIM0_SPIS0_TWIM0_TWIS0_UARTE0_IRQHandler")
	_ = interrupt.Register(IRQ_SPIS0_NS, "SPIM0_SPIS0_TWIM0_TWIS0_UARTE0_IRQHandler")
	_ = interrupt.Register(IRQ_TWIM0_NS, "SPIM0_SPIS0_TWIM0_TWIS0_UARTE0_IRQHandler")
	_ = interrupt.Register(IRQ_TWIS0_NS, "SPIM0_SPIS0_TWIM0_TWIS0_UARTE0_IRQHandler")
	_ = interrupt.Register(IRQ_UARTE0_NS, "SPIM0_SPIS0_TWIM0_TWIS0_UARTE0_IRQHandler")
	_ = interrupt.Register(IRQ_EGU0, "EGU0_IRQHandler")
	_ = interrupt.Register(IRQ_EGU0_NS, "EGU0_IRQHandler")
	_ = interrupt.Register(IRQ_RTC1, "RTC1_IRQHandler")
	_ = interrupt.Register(IRQ_RTC1_NS, "RTC1_IRQHandler")
	_ = interrupt.Register(IRQ_TIMER1, "TIMER1_IRQHandler")
	_ = interrupt.Register(IRQ_TIMER1_NS, "TIMER1_IRQHandler")
	_ = interrupt.Register(IRQ_TIMER2, "TIMER2_IRQHandler")
	_ = interrupt.Register(IRQ_TIMER2_NS, "TIMER2_IRQHandler")
	_ = interrupt.Register(IRQ_SWI0, "SWI0_IRQHandler")
	_ = interrupt.Register(IRQ_SWI0_NS, "SWI0_IRQHandler")
	_ = interrupt.Register(IRQ_SWI1, "SWI1_IRQHandler")
	_ = interrupt.Register(IRQ_SWI1_NS, "SWI1_IRQHandler")
	_ = interrupt.Register(IRQ_SWI2, "SWI2_IRQHandler")
	_ = interrupt.Register(IRQ_SWI2_NS, "SWI2_IRQHandler")
	_ = interrupt.Register(IRQ_SWI3, "SWI3_IRQHandler")
	_ = interrupt.Register(IRQ_SWI3_NS, "SWI3_IRQHandler")
)

// Peripherals.
var (
	// Factory Information Configuration Registers
	FICR_NS = (*FICR_Type)(unsafe.Pointer(uintptr(0x1ff0000)))

	// User Information Configuration Registers
	UICR_NS = (*UICR_Type)(unsafe.Pointer(uintptr(0x1ff8000)))

	// Cross-Trigger Interface control. NOTE: this is not a separate peripheral, but describes CM33 functionality.
	CTI_NS = (*CTI_Type)(unsafe.Pointer(uintptr(0xe0042000)))

	// Domain configuration management
	DCNF_NS = (*DCNF_Type)(unsafe.Pointer(uintptr(0x41000000)))

	// Voltage request control
	VREQCTRL_NS = (*VREQCTRL_Type)(unsafe.Pointer(uintptr(0x41004000)))

	// Clock management
	CLOCK_NS = (*CLOCK_Type)(unsafe.Pointer(uintptr(0x41005000)))

	// Power control
	POWER_NS = (*POWER_Type)(unsafe.Pointer(uintptr(0x41005000)))

	// Reset control
	RESET_NS = (*RESET_Type)(unsafe.Pointer(uintptr(0x41005000)))

	// Control access port
	CTRLAP_NS = (*CTRLAPPERI_Type)(unsafe.Pointer(uintptr(0x41006000)))

	// 2.4 GHz radio
	RADIO_NS = (*RADIO_Type)(unsafe.Pointer(uintptr(0x41008000)))

	// Random Number Generator
	RNG_NS = (*RNG_Type)(unsafe.Pointer(uintptr(0x41009000)))

	// GPIO Tasks and Events
	GPIOTE_NS = (*GPIOTE_Type)(unsafe.Pointer(uintptr(0x4100a000)))

	// Watchdog Timer
	WDT_NS = (*WDT_Type)(unsafe.Pointer(uintptr(0x4100b000)))

	// Timer/Counter 0
	TIMER0_NS = (*TIMER_Type)(unsafe.Pointer(uintptr(0x4100c000)))

	// AES ECB Mode Encryption
	ECB_NS = (*ECB_Type)(unsafe.Pointer(uintptr(0x4100d000)))

	// Accelerated Address Resolver
	AAR_NS = (*AAR_Type)(unsafe.Pointer(uintptr(0x4100e000)))

	// AES CCM mode encryption
	CCM_NS = (*CCM_Type)(unsafe.Pointer(uintptr(0x4100e000)))

	// Distributed programmable peripheral interconnect controller
	DPPIC_NS = (*DPPIC_Type)(unsafe.Pointer(uintptr(0x4100f000)))

	// Temperature Sensor
	TEMP_NS = (*TEMP_Type)(unsafe.Pointer(uintptr(0x41010000)))

	// Real-time counter 0
	RTC0_NS = (*RTC_Type)(unsafe.Pointer(uintptr(0x41011000)))

	// Interprocessor communication
	IPC_NS = (*IPC_Type)(unsafe.Pointer(uintptr(0x41012000)))

	// Serial Peripheral Interface Master with EasyDMA
	SPIM0_NS = (*SPIM_Type)(unsafe.Pointer(uintptr(0x41013000)))

	// SPI Slave
	SPIS0_NS = (*SPIS_Type)(unsafe.Pointer(uintptr(0x41013000)))

	// I2C compatible Two-Wire Master Interface with EasyDMA
	TWIM0_NS = (*TWIM_Type)(unsafe.Pointer(uintptr(0x41013000)))

	// I2C compatible Two-Wire Slave Interface with EasyDMA
	TWIS0_NS = (*TWIS_Type)(unsafe.Pointer(uintptr(0x41013000)))

	// UART with EasyDMA
	UARTE0_NS = (*UARTE_Type)(unsafe.Pointer(uintptr(0x41013000)))

	// Event generator unit
	EGU0_NS = (*EGU_Type)(unsafe.Pointer(uintptr(0x41014000)))

	// Software interrupt 0
	SWI0_NS = (*SWI_Type)(unsafe.Pointer(uintptr(0x4101a000)))

	// MUTEX 0
	APPMUTEX_NS = (*MUTEX_Type)(unsafe.Pointer(uintptr(0x40030000)))

	// Access control lists
	ACL_NS = (*ACL_Type)(unsafe.Pointer(uintptr(0x41080000)))

	// Non-volatile memory controller
	NVMC_NS = (*NVMC_Type)(unsafe.Pointer(uintptr(0x41080000)))

	// Volatile Memory controller
	VMC_NS = (*VMC_Type)(unsafe.Pointer(uintptr(0x41081000)))

	// GPIO Port 0
	P0_NS = (*GPIO_Type)(unsafe.Pointer(uintptr(0x418c0500)))

	// Real-time counter 1
	RTC1_NS = (*RTC_Type)(unsafe.Pointer(uintptr(0x41016000)))

	// Timer/Counter 1
	TIMER1_NS = (*TIMER_Type)(unsafe.Pointer(uintptr(0x41018000)))

	// Timer/Counter 2
	TIMER2_NS = (*TIMER_Type)(unsafe.Pointer(uintptr(0x41019000)))

	// Software interrupt 1
	SWI1_NS = (*SWI_Type)(unsafe.Pointer(uintptr(0x4101b000)))

	// Software interrupt 2
	SWI2_NS = (*SWI_Type)(unsafe.Pointer(uintptr(0x4101c000)))

	// Software interrupt 3
	SWI3_NS = (*SWI_Type)(unsafe.Pointer(uintptr(0x4101d000)))

	// MUTEX 1
	APPMUTEX_S = (*MUTEX_Type)(unsafe.Pointer(uintptr(0x50030000)))

	// GPIO Port 1
	P1_NS = (*GPIO_Type)(unsafe.Pointer(uintptr(0x418c0800)))
)

// Factory Information Configuration Registers
type FICR_Type struct {
	_    [512]byte
	INFO struct {
		CONFIGID     volatile.Register32
		DEVICEID     [2]volatile.Register32
		PART         volatile.Register32
		VARIANT      volatile.Register32
		PACKAGE      volatile.Register32
		RAM          volatile.Register32
		FLASH        volatile.Register32
		CODEPAGESIZE volatile.Register32
		CODESIZE     volatile.Register32
		DEVICETYPE   volatile.Register32
	} // 0x200
	_              [84]byte
	ER             [4]volatile.Register32 // 0x280
	IR             [4]volatile.Register32 // 0x290
	DEVICEADDRTYPE volatile.Register32    // 0x2A0
	DEVICEADDR     [2]volatile.Register32 // 0x2A4
	_              [84]byte
	TRIMCNF        [32]struct {
		ADDR volatile.Register32
		DATA volatile.Register32
	} // 0x300
}

// User Information Configuration Registers
type UICR_Type struct {
	APPROTECT    volatile.Register32 // 0x0
	ERASEPROTECT volatile.Register32 // 0x4
	_            [504]byte
	NRFFW        [32]volatile.Register32 // 0x200
	_            [128]byte
	CUSTOMER     [32]volatile.Register32 // 0x300
}

// Cross-Trigger Interface control. NOTE: this is not a separate peripheral, but describes CM33 functionality.
type CTI_Type struct {
	CTICONTROL       volatile.Register32 // 0x0
	_                [12]byte
	CTIINTACK        volatile.Register32    // 0x10
	CTIAPPSET        volatile.Register32    // 0x14
	CTIAPPCLEAR      volatile.Register32    // 0x18
	CTIAPPPULSE      volatile.Register32    // 0x1C
	CTIINEN          [8]volatile.Register32 // 0x20
	_                [96]byte
	CTIOUTEN         [8]volatile.Register32 // 0xA0
	_                [112]byte
	CTITRIGINSTATUS  volatile.Register32 // 0x130
	CTITRIGOUTSTATUS volatile.Register32 // 0x134
	CTICHINSTATUS    volatile.Register32 // 0x138
	_                [4]byte
	CTIGATE          volatile.Register32 // 0x140
	_                [3704]byte
	DEVARCH          volatile.Register32 // 0xFBC
	_                [8]byte
	DEVID            volatile.Register32 // 0xFC8
	DEVTYPE          volatile.Register32 // 0xFCC
	PIDR4            volatile.Register32 // 0xFD0
	PIDR5            volatile.Register32 // 0xFD4
	PIDR6            volatile.Register32 // 0xFD8
	PIDR7            volatile.Register32 // 0xFDC
	PIDR0            volatile.Register32 // 0xFE0
	PIDR1            volatile.Register32 // 0xFE4
	PIDR2            volatile.Register32 // 0xFE8
	PIDR3            volatile.Register32 // 0xFEC
	CIDR0            volatile.Register32 // 0xFF0
	CIDR1            volatile.Register32 // 0xFF4
	CIDR2            volatile.Register32 // 0xFF8
	CIDR3            volatile.Register32 // 0xFFC
}

// Domain configuration management
type DCNF_Type struct {
	_     [1056]byte
	CPUID volatile.Register32 // 0x420
}

// Voltage request control
type VREQCTRL_Type struct {
	_         [1280]byte
	VREGRADIO struct {
		VREQH      volatile.Register32
		_          [4]byte
		VREQHREADY volatile.Register32
	} // 0x500
}

// Clock management
type CLOCK_Type struct {
	TASKS_HFCLKSTART     volatile.Register32 // 0x0
	TASKS_HFCLKSTOP      volatile.Register32 // 0x4
	TASKS_LFCLKSTART     volatile.Register32 // 0x8
	TASKS_LFCLKSTOP      volatile.Register32 // 0xC
	TASKS_CAL            volatile.Register32 // 0x10
	_                    [108]byte
	SUBSCRIBE_HFCLKSTART volatile.Register32 // 0x80
	SUBSCRIBE_HFCLKSTOP  volatile.Register32 // 0x84
	SUBSCRIBE_LFCLKSTART volatile.Register32 // 0x88
	SUBSCRIBE_LFCLKSTOP  volatile.Register32 // 0x8C
	SUBSCRIBE_CAL        volatile.Register32 // 0x90
	_                    [108]byte
	EVENTS_HFCLKSTARTED  volatile.Register32 // 0x100
	EVENTS_LFCLKSTARTED  volatile.Register32 // 0x104
	_                    [20]byte
	EVENTS_DONE          volatile.Register32 // 0x11C
	_                    [96]byte
	PUBLISH_HFCLKSTARTED volatile.Register32 // 0x180
	PUBLISH_LFCLKSTARTED volatile.Register32 // 0x184
	_                    [20]byte
	PUBLISH_DONE         volatile.Register32 // 0x19C
	_                    [352]byte
	INTEN                volatile.Register32 // 0x300
	INTENSET             volatile.Register32 // 0x304
	INTENCLR             volatile.Register32 // 0x308
	INTPEND              volatile.Register32 // 0x30C
	_                    [248]byte
	HFCLKRUN             volatile.Register32 // 0x408
	HFCLKSTAT            volatile.Register32 // 0x40C
	_                    [4]byte
	LFCLKRUN             volatile.Register32 // 0x414
	LFCLKSTAT            volatile.Register32 // 0x418
	LFCLKSRCCOPY         volatile.Register32 // 0x41C
	_                    [244]byte
	HFCLKSRC             volatile.Register32 // 0x514
	LFCLKSRC             volatile.Register32 // 0x518
	_                    [60]byte
	HFCLKCTRL            volatile.Register32 // 0x558
	_                    [20]byte
	HFCLKALWAYSRUN       volatile.Register32 // 0x570
	LFCLKALWAYSRUN       volatile.Register32 // 0x574
}

// Power control
type POWER_Type struct {
	_                  [120]byte
	TASKS_CONSTLAT     volatile.Register32 // 0x78
	TASKS_LOWPWR       volatile.Register32 // 0x7C
	_                  [120]byte
	SUBSCRIBE_CONSTLAT volatile.Register32 // 0xF8
	SUBSCRIBE_LOWPWR   volatile.Register32 // 0xFC
	_                  [8]byte
	EVENTS_POFWARN     volatile.Register32 // 0x108
	_                  [8]byte
	EVENTS_SLEEPENTER  volatile.Register32 // 0x114
	EVENTS_SLEEPEXIT   volatile.Register32 // 0x118
	_                  [108]byte
	PUBLISH_POFWARN    volatile.Register32 // 0x188
	_                  [8]byte
	PUBLISH_SLEEPENTER volatile.Register32 // 0x194
	PUBLISH_SLEEPEXIT  volatile.Register32 // 0x198
	_                  [356]byte
	INTEN              volatile.Register32 // 0x300
	INTENSET           volatile.Register32 // 0x304
	INTENCLR           volatile.Register32 // 0x308
	_                  [528]byte
	GPREGRET           [2]volatile.Register32 // 0x51C
}

// Reset control
type RESET_Type struct {
	_         [1024]byte
	RESETREAS volatile.Register32 // 0x400
}

// Control access port
type CTRLAPPERI_Type struct {
	_       [1024]byte
	MAILBOX struct {
		RXDATA   volatile.Register32
		RXSTATUS volatile.Register32
		_        [120]byte
		TXDATA   volatile.Register32
		TXSTATUS volatile.Register32
	} // 0x400
	_            [120]byte
	ERASEPROTECT struct {
		LOCK    volatile.Register32
		DISABLE volatile.Register32
	} // 0x500
	_         [56]byte
	APPROTECT struct {
		LOCK    volatile.Register32
		DISABLE volatile.Register32
	} // 0x540
	_      [184]byte
	STATUS volatile.Register32 // 0x600
}

// 2.4 GHz radio
type RADIO_Type struct {
	TASKS_TXEN          volatile.Register32 // 0x0
	TASKS_RXEN          volatile.Register32 // 0x4
	TASKS_START         volatile.Register32 // 0x8
	TASKS_STOP          volatile.Register32 // 0xC
	TASKS_DISABLE       volatile.Register32 // 0x10
	TASKS_RSSISTART     volatile.Register32 // 0x14
	TASKS_RSSISTOP      volatile.Register32 // 0x18
	TASKS_BCSTART       volatile.Register32 // 0x1C
	TASKS_BCSTOP        volatile.Register32 // 0x20
	TASKS_EDSTART       volatile.Register32 // 0x24
	TASKS_EDSTOP        volatile.Register32 // 0x28
	TASKS_CCASTART      volatile.Register32 // 0x2C
	TASKS_CCASTOP       volatile.Register32 // 0x30
	_                   [76]byte
	SUBSCRIBE_TXEN      volatile.Register32 // 0x80
	SUBSCRIBE_RXEN      volatile.Register32 // 0x84
	SUBSCRIBE_START     volatile.Register32 // 0x88
	SUBSCRIBE_STOP      volatile.Register32 // 0x8C
	SUBSCRIBE_DISABLE   volatile.Register32 // 0x90
	SUBSCRIBE_RSSISTART volatile.Register32 // 0x94
	SUBSCRIBE_RSSISTOP  volatile.Register32 // 0x98
	SUBSCRIBE_BCSTART   volatile.Register32 // 0x9C
	SUBSCRIBE_BCSTOP    volatile.Register32 // 0xA0
	SUBSCRIBE_EDSTART   volatile.Register32 // 0xA4
	SUBSCRIBE_EDSTOP    volatile.Register32 // 0xA8
	SUBSCRIBE_CCASTART  volatile.Register32 // 0xAC
	SUBSCRIBE_CCASTOP   volatile.Register32 // 0xB0
	_                   [76]byte
	EVENTS_READY        volatile.Register32 // 0x100
	EVENTS_ADDRESS      volatile.Register32 // 0x104
	EVENTS_PAYLOAD      volatile.Register32 // 0x108
	EVENTS_END          volatile.Register32 // 0x10C
	EVENTS_DISABLED     volatile.Register32 // 0x110
	EVENTS_DEVMATCH     volatile.Register32 // 0x114
	EVENTS_DEVMISS      volatile.Register32 // 0x118
	EVENTS_RSSIEND      volatile.Register32 // 0x11C
	_                   [8]byte
	EVENTS_BCMATCH      volatile.Register32 // 0x128
	_                   [4]byte
	EVENTS_CRCOK        volatile.Register32 // 0x130
	EVENTS_CRCERROR     volatile.Register32 // 0x134
	EVENTS_FRAMESTART   volatile.Register32 // 0x138
	EVENTS_EDEND        volatile.Register32 // 0x13C
	EVENTS_EDSTOPPED    volatile.Register32 // 0x140
	EVENTS_CCAIDLE      volatile.Register32 // 0x144
	EVENTS_CCABUSY      volatile.Register32 // 0x148
	EVENTS_CCASTOPPED   volatile.Register32 // 0x14C
	EVENTS_RATEBOOST    volatile.Register32 // 0x150
	EVENTS_TXREADY      volatile.Register32 // 0x154
	EVENTS_RXREADY      volatile.Register32 // 0x158
	EVENTS_MHRMATCH     volatile.Register32 // 0x15C
	_                   [8]byte
	EVENTS_SYNC         volatile.Register32 // 0x168
	EVENTS_PHYEND       volatile.Register32 // 0x16C
	EVENTS_CTEPRESENT   volatile.Register32 // 0x170
	_                   [12]byte
	PUBLISH_READY       volatile.Register32 // 0x180
	PUBLISH_ADDRESS     volatile.Register32 // 0x184
	PUBLISH_PAYLOAD     volatile.Register32 // 0x188
	PUBLISH_END         volatile.Register32 // 0x18C
	PUBLISH_DISABLED    volatile.Register32 // 0x190
	PUBLISH_DEVMATCH    volatile.Register32 // 0x194
	PUBLISH_DEVMISS     volatile.Register32 // 0x198
	PUBLISH_RSSIEND     volatile.Register32 // 0x19C
	_                   [8]byte
	PUBLISH_BCMATCH     volatile.Register32 // 0x1A8
	_                   [4]byte
	PUBLISH_CRCOK       volatile.Register32 // 0x1B0
	PUBLISH_CRCERROR    volatile.Register32 // 0x1B4
	PUBLISH_FRAMESTART  volatile.Register32 // 0x1B8
	PUBLISH_EDEND       volatile.Register32 // 0x1BC
	PUBLISH_EDSTOPPED   volatile.Register32 // 0x1C0
	PUBLISH_CCAIDLE     volatile.Register32 // 0x1C4
	PUBLISH_CCABUSY     volatile.Register32 // 0x1C8
	PUBLISH_CCASTOPPED  volatile.Register32 // 0x1CC
	PUBLISH_RATEBOOST   volatile.Register32 // 0x1D0
	PUBLISH_TXREADY     volatile.Register32 // 0x1D4
	PUBLISH_RXREADY     volatile.Register32 // 0x1D8
	PUBLISH_MHRMATCH    volatile.Register32 // 0x1DC
	_                   [8]byte
	PUBLISH_SYNC        volatile.Register32 // 0x1E8
	PUBLISH_PHYEND      volatile.Register32 // 0x1EC
	PUBLISH_CTEPRESENT  volatile.Register32 // 0x1F0
	_                   [12]byte
	SHORTS              volatile.Register32 // 0x200
	_                   [256]byte
	INTENSET            volatile.Register32 // 0x304
	INTENCLR            volatile.Register32 // 0x308
	_                   [244]byte
	CRCSTATUS           volatile.Register32 // 0x400
	_                   [4]byte
	RXMATCH             volatile.Register32 // 0x408
	RXCRC               volatile.Register32 // 0x40C
	DAI                 volatile.Register32 // 0x410
	PDUSTAT             volatile.Register32 // 0x414
	_                   [52]byte
	CTESTATUS           volatile.Register32 // 0x44C
	_                   [8]byte
	DFESTATUS           volatile.Register32 // 0x458
	_                   [168]byte
	PACKETPTR           volatile.Register32 // 0x504
	FREQUENCY           volatile.Register32 // 0x508
	TXPOWER             volatile.Register32 // 0x50C
	MODE                volatile.Register32 // 0x510
	PCNF0               volatile.Register32 // 0x514
	PCNF1               volatile.Register32 // 0x518
	BASE0               volatile.Register32 // 0x51C
	BASE1               volatile.Register32 // 0x520
	PREFIX0             volatile.Register32 // 0x524
	PREFIX1             volatile.Register32 // 0x528
	TXADDRESS           volatile.Register32 // 0x52C
	RXADDRESSES         volatile.Register32 // 0x530
	CRCCNF              volatile.Register32 // 0x534
	CRCPOLY             volatile.Register32 // 0x538
	CRCINIT             volatile.Register32 // 0x53C
	_                   [4]byte
	TIFS                volatile.Register32 // 0x544
	RSSISAMPLE          volatile.Register32 // 0x548
	_                   [4]byte
	STATE               volatile.Register32 // 0x550
	DATAWHITEIV         volatile.Register32 // 0x554
	_                   [8]byte
	BCC                 volatile.Register32 // 0x560
	_                   [156]byte
	DAB                 [8]volatile.Register32 // 0x600
	DAP                 [8]volatile.Register32 // 0x620
	DACNF               volatile.Register32    // 0x640
	MHRMATCHCONF        volatile.Register32    // 0x644
	MHRMATCHMAS         volatile.Register32    // 0x648
	_                   [4]byte
	MODECNF0            volatile.Register32 // 0x650
	_                   [12]byte
	SFD                 volatile.Register32 // 0x660
	EDCNT               volatile.Register32 // 0x664
	EDSAMPLE            volatile.Register32 // 0x668
	CCACTRL             volatile.Register32 // 0x66C
	_                   [656]byte
	DFEMODE             volatile.Register32 // 0x900
	CTEINLINECONF       volatile.Register32 // 0x904
	_                   [8]byte
	DFECTRL1            volatile.Register32 // 0x910
	DFECTRL2            volatile.Register32 // 0x914
	_                   [16]byte
	SWITCHPATTERN       volatile.Register32 // 0x928
	CLEARPATTERN        volatile.Register32 // 0x92C
	PSEL                struct {
		DFEGPIO [8]volatile.Register32
	} // 0x930
	DFEPACKET struct {
		PTR    volatile.Register32
		MAXCNT volatile.Register32
		AMOUNT volatile.Register32
	} // 0x950
	_     [1696]byte
	POWER volatile.Register32 // 0xFFC
}

// Random Number Generator
type RNG_Type struct {
	TASKS_START     volatile.Register32 // 0x0
	TASKS_STOP      volatile.Register32 // 0x4
	_               [120]byte
	SUBSCRIBE_START volatile.Register32 // 0x80
	SUBSCRIBE_STOP  volatile.Register32 // 0x84
	_               [120]byte
	EVENTS_VALRDY   volatile.Register32 // 0x100
	_               [124]byte
	PUBLISH_VALRDY  volatile.Register32 // 0x180
	_               [124]byte
	SHORTS          volatile.Register32 // 0x200
	_               [256]byte
	INTENSET        volatile.Register32 // 0x304
	INTENCLR        volatile.Register32 // 0x308
	_               [504]byte
	CONFIG          volatile.Register32 // 0x504
	VALUE           volatile.Register32 // 0x508
}

// GPIO Tasks and Events
type GPIOTE_Type struct {
	TASKS_OUT     [8]volatile.Register32 // 0x0
	_             [16]byte
	TASKS_SET     [8]volatile.Register32 // 0x30
	_             [16]byte
	TASKS_CLR     [8]volatile.Register32 // 0x60
	SUBSCRIBE_OUT [8]volatile.Register32 // 0x80
	_             [16]byte
	SUBSCRIBE_SET [8]volatile.Register32 // 0xB0
	_             [16]byte
	SUBSCRIBE_CLR [8]volatile.Register32 // 0xE0
	EVENTS_IN     [8]volatile.Register32 // 0x100
	_             [92]byte
	EVENTS_PORT   volatile.Register32    // 0x17C
	PUBLISH_IN    [8]volatile.Register32 // 0x180
	_             [92]byte
	PUBLISH_PORT  volatile.Register32 // 0x1FC
	_             [260]byte
	INTENSET      volatile.Register32 // 0x304
	INTENCLR      volatile.Register32 // 0x308
	_             [504]byte
	LATENCY       volatile.Register32 // 0x504
	_             [8]byte
	CONFIG        [8]volatile.Register32 // 0x510
}

// Watchdog Timer
type WDT_Type struct {
	TASKS_START     volatile.Register32 // 0x0
	TASKS_STOP      volatile.Register32 // 0x4
	_               [120]byte
	SUBSCRIBE_START volatile.Register32 // 0x80
	SUBSCRIBE_STOP  volatile.Register32 // 0x84
	_               [120]byte
	EVENTS_TIMEOUT  volatile.Register32 // 0x100
	EVENTS_STOPPED  volatile.Register32 // 0x104
	_               [120]byte
	PUBLISH_TIMEOUT volatile.Register32 // 0x180
	PUBLISH_STOPPED volatile.Register32 // 0x184
	_               [380]byte
	INTENSET        volatile.Register32 // 0x304
	INTENCLR        volatile.Register32 // 0x308
	_               [24]byte
	NMIENSET        volatile.Register32 // 0x324
	NMIENCLR        volatile.Register32 // 0x328
	_               [212]byte
	RUNSTATUS       volatile.Register32 // 0x400
	REQSTATUS       volatile.Register32 // 0x404
	_               [252]byte
	CRV             volatile.Register32 // 0x504
	RREN            volatile.Register32 // 0x508
	CONFIG          volatile.Register32 // 0x50C
	_               [16]byte
	TSEN            volatile.Register32 // 0x520
	_               [220]byte
	RR              [8]volatile.Register32 // 0x600
}

// Timer/Counter 0
type TIMER_Type struct {
	TASKS_START        volatile.Register32 // 0x0
	TASKS_STOP         volatile.Register32 // 0x4
	TASKS_COUNT        volatile.Register32 // 0x8
	TASKS_CLEAR        volatile.Register32 // 0xC
	TASKS_SHUTDOWN     volatile.Register32 // 0x10
	_                  [44]byte
	TASKS_CAPTURE      [8]volatile.Register32 // 0x40
	_                  [32]byte
	SUBSCRIBE_START    volatile.Register32 // 0x80
	SUBSCRIBE_STOP     volatile.Register32 // 0x84
	SUBSCRIBE_COUNT    volatile.Register32 // 0x88
	SUBSCRIBE_CLEAR    volatile.Register32 // 0x8C
	SUBSCRIBE_SHUTDOWN volatile.Register32 // 0x90
	_                  [44]byte
	SUBSCRIBE_CAPTURE  [8]volatile.Register32 // 0xC0
	_                  [96]byte
	EVENTS_COMPARE     [8]volatile.Register32 // 0x140
	_                  [96]byte
	PUBLISH_COMPARE    [8]volatile.Register32 // 0x1C0
	_                  [32]byte
	SHORTS             volatile.Register32 // 0x200
	_                  [252]byte
	INTEN              volatile.Register32 // 0x300
	INTENSET           volatile.Register32 // 0x304
	INTENCLR           volatile.Register32 // 0x308
	_                  [504]byte
	MODE               volatile.Register32 // 0x504
	BITMODE            volatile.Register32 // 0x508
	_                  [4]byte
	PRESCALER          volatile.Register32 // 0x510
	_                  [44]byte
	CC                 [8]volatile.Register32 // 0x540
	_                  [32]byte
	ONESHOTEN          [8]volatile.Register32 // 0x580
}

// AES ECB Mode Encryption
type ECB_Type struct {
	TASKS_STARTECB     volatile.Register32 // 0x0
	TASKS_STOPECB      volatile.Register32 // 0x4
	_                  [120]byte
	SUBSCRIBE_STARTECB volatile.Register32 // 0x80
	SUBSCRIBE_STOPECB  volatile.Register32 // 0x84
	_                  [120]byte
	EVENTS_ENDECB      volatile.Register32 // 0x100
	EVENTS_ERRORECB    volatile.Register32 // 0x104
	_                  [120]byte
	PUBLISH_ENDECB     volatile.Register32 // 0x180
	PUBLISH_ERRORECB   volatile.Register32 // 0x184
	_                  [380]byte
	INTENSET           volatile.Register32 // 0x304
	INTENCLR           volatile.Register32 // 0x308
	_                  [504]byte
	ECBDATAPTR         volatile.Register32 // 0x504
}

// Accelerated Address Resolver
type AAR_Type struct {
	TASKS_START         volatile.Register32 // 0x0
	_                   [4]byte
	TASKS_STOP          volatile.Register32 // 0x8
	_                   [116]byte
	SUBSCRIBE_START     volatile.Register32 // 0x80
	_                   [4]byte
	SUBSCRIBE_STOP      volatile.Register32 // 0x88
	_                   [116]byte
	EVENTS_END          volatile.Register32 // 0x100
	EVENTS_RESOLVED     volatile.Register32 // 0x104
	EVENTS_NOTRESOLVED  volatile.Register32 // 0x108
	_                   [116]byte
	PUBLISH_END         volatile.Register32 // 0x180
	PUBLISH_RESOLVED    volatile.Register32 // 0x184
	PUBLISH_NOTRESOLVED volatile.Register32 // 0x188
	_                   [376]byte
	INTENSET            volatile.Register32 // 0x304
	INTENCLR            volatile.Register32 // 0x308
	_                   [244]byte
	STATUS              volatile.Register32 // 0x400
	_                   [252]byte
	ENABLE              volatile.Register32 // 0x500
	NIRK                volatile.Register32 // 0x504
	IRKPTR              volatile.Register32 // 0x508
	_                   [4]byte
	ADDRPTR             volatile.Register32 // 0x510
	SCRATCHPTR          volatile.Register32 // 0x514
}

// AES CCM mode encryption
type CCM_Type struct {
	TASKS_KSGEN            volatile.Register32 // 0x0
	TASKS_CRYPT            volatile.Register32 // 0x4
	TASKS_STOP             volatile.Register32 // 0x8
	TASKS_RATEOVERRIDE     volatile.Register32 // 0xC
	_                      [112]byte
	SUBSCRIBE_KSGEN        volatile.Register32 // 0x80
	SUBSCRIBE_CRYPT        volatile.Register32 // 0x84
	SUBSCRIBE_STOP         volatile.Register32 // 0x88
	SUBSCRIBE_RATEOVERRIDE volatile.Register32 // 0x8C
	_                      [112]byte
	EVENTS_ENDKSGEN        volatile.Register32 // 0x100
	EVENTS_ENDCRYPT        volatile.Register32 // 0x104
	EVENTS_ERROR           volatile.Register32 // 0x108
	_                      [116]byte
	PUBLISH_ENDKSGEN       volatile.Register32 // 0x180
	PUBLISH_ENDCRYPT       volatile.Register32 // 0x184
	PUBLISH_ERROR          volatile.Register32 // 0x188
	_                      [116]byte
	SHORTS                 volatile.Register32 // 0x200
	_                      [256]byte
	INTENSET               volatile.Register32 // 0x304
	INTENCLR               volatile.Register32 // 0x308
	_                      [244]byte
	MICSTATUS              volatile.Register32 // 0x400
	_                      [252]byte
	ENABLE                 volatile.Register32 // 0x500
	MODE                   volatile.Register32 // 0x504
	CNFPTR                 volatile.Register32 // 0x508
	INPTR                  volatile.Register32 // 0x50C
	OUTPTR                 volatile.Register32 // 0x510
	SCRATCHPTR             volatile.Register32 // 0x514
	MAXPACKETSIZE          volatile.Register32 // 0x518
	RATEOVERRIDE           volatile.Register32 // 0x51C
	HEADERMASK             volatile.Register32 // 0x520
}

// Distributed programmable peripheral interconnect controller
type DPPIC_Type struct {
	TASKS_CHG [6]struct {
		EN  volatile.Register32
		DIS volatile.Register32
	} // 0x0
	_             [80]byte
	SUBSCRIBE_CHG [6]struct {
		EN  volatile.Register32
		DIS volatile.Register32
	} // 0x80
	_       [1104]byte
	CHEN    volatile.Register32 // 0x500
	CHENSET volatile.Register32 // 0x504
	CHENCLR volatile.Register32 // 0x508
	_       [756]byte
	CHG     [6]volatile.Register32 // 0x800
}

// Temperature Sensor
type TEMP_Type struct {
	TASKS_START     volatile.Register32 // 0x0
	TASKS_STOP      volatile.Register32 // 0x4
	_               [120]byte
	SUBSCRIBE_START volatile.Register32 // 0x80
	SUBSCRIBE_STOP  volatile.Register32 // 0x84
	_               [120]byte
	EVENTS_DATARDY  volatile.Register32 // 0x100
	_               [124]byte
	PUBLISH_DATARDY volatile.Register32 // 0x180
	_               [384]byte
	INTENSET        volatile.Register32 // 0x304
	INTENCLR        volatile.Register32 // 0x308
	_               [508]byte
	TEMP            volatile.Register32 // 0x508
	_               [20]byte
	A0              volatile.Register32 // 0x520
	A1              volatile.Register32 // 0x524
	A2              volatile.Register32 // 0x528
	A3              volatile.Register32 // 0x52C
	A4              volatile.Register32 // 0x530
	A5              volatile.Register32 // 0x534
	_               [8]byte
	B0              volatile.Register32 // 0x540
	B1              volatile.Register32 // 0x544
	B2              volatile.Register32 // 0x548
	B3              volatile.Register32 // 0x54C
	B4              volatile.Register32 // 0x550
	B5              volatile.Register32 // 0x554
	_               [8]byte
	T0              volatile.Register32 // 0x560
	T1              volatile.Register32 // 0x564
	T2              volatile.Register32 // 0x568
	T3              volatile.Register32 // 0x56C
	T4              volatile.Register32 // 0x570
}

// Real-time counter 0
type RTC_Type struct {
	TASKS_START          volatile.Register32 // 0x0
	TASKS_STOP           volatile.Register32 // 0x4
	TASKS_CLEAR          volatile.Register32 // 0x8
	TASKS_TRIGOVRFLW     volatile.Register32 // 0xC
	_                    [48]byte
	TASKS_CAPTURE        [4]volatile.Register32 // 0x40
	_                    [48]byte
	SUBSCRIBE_START      volatile.Register32 // 0x80
	SUBSCRIBE_STOP       volatile.Register32 // 0x84
	SUBSCRIBE_CLEAR      volatile.Register32 // 0x88
	SUBSCRIBE_TRIGOVRFLW volatile.Register32 // 0x8C
	_                    [48]byte
	SUBSCRIBE_CAPTURE    [4]volatile.Register32 // 0xC0
	_                    [48]byte
	EVENTS_TICK          volatile.Register32 // 0x100
	EVENTS_OVRFLW        volatile.Register32 // 0x104
	_                    [56]byte
	EVENTS_COMPARE       [4]volatile.Register32 // 0x140
	_                    [48]byte
	PUBLISH_TICK         volatile.Register32 // 0x180
	PUBLISH_OVRFLW       volatile.Register32 // 0x184
	_                    [56]byte
	PUBLISH_COMPARE      [4]volatile.Register32 // 0x1C0
	_                    [48]byte
	SHORTS               volatile.Register32 // 0x200
	_                    [256]byte
	INTENSET             volatile.Register32 // 0x304
	INTENCLR             volatile.Register32 // 0x308
	_                    [52]byte
	EVTEN                volatile.Register32 // 0x340
	EVTENSET             volatile.Register32 // 0x344
	EVTENCLR             volatile.Register32 // 0x348
	_                    [440]byte
	COUNTER              volatile.Register32 // 0x504
	PRESCALER            volatile.Register32 // 0x508
	_                    [52]byte
	CC                   [4]volatile.Register32 // 0x540
}

// Interprocessor communication
type IPC_Type struct {
	TASKS_SEND      [16]volatile.Register32 // 0x0
	_               [64]byte
	SUBSCRIBE_SEND  [16]volatile.Register32 // 0x80
	_               [64]byte
	EVENTS_RECEIVE  [16]volatile.Register32 // 0x100
	_               [64]byte
	PUBLISH_RECEIVE [16]volatile.Register32 // 0x180
	_               [320]byte
	INTEN           volatile.Register32 // 0x300
	INTENSET        volatile.Register32 // 0x304
	INTENCLR        volatile.Register32 // 0x308
	INTPEND         volatile.Register32 // 0x30C
	_               [512]byte
	SEND_CNF        [16]volatile.Register32 // 0x510
	_               [64]byte
	RECEIVE_CNF     [16]volatile.Register32 // 0x590
	_               [64]byte
	GPMEM           [2]volatile.Register32 // 0x610
}

// Serial Peripheral Interface Master with EasyDMA
type SPIM_Type struct {
	_                 [16]byte
	TASKS_START       volatile.Register32 // 0x10
	TASKS_STOP        volatile.Register32 // 0x14
	_                 [4]byte
	TASKS_SUSPEND     volatile.Register32 // 0x1C
	TASKS_RESUME      volatile.Register32 // 0x20
	_                 [108]byte
	SUBSCRIBE_START   volatile.Register32 // 0x90
	SUBSCRIBE_STOP    volatile.Register32 // 0x94
	_                 [4]byte
	SUBSCRIBE_SUSPEND volatile.Register32 // 0x9C
	SUBSCRIBE_RESUME  volatile.Register32 // 0xA0
	_                 [96]byte
	EVENTS_STOPPED    volatile.Register32 // 0x104
	_                 [8]byte
	EVENTS_ENDRX      volatile.Register32 // 0x110
	_                 [4]byte
	EVENTS_END        volatile.Register32 // 0x118
	_                 [4]byte
	EVENTS_ENDTX      volatile.Register32 // 0x120
	_                 [40]byte
	EVENTS_STARTED    volatile.Register32 // 0x14C
	_                 [52]byte
	PUBLISH_STOPPED   volatile.Register32 // 0x184
	_                 [8]byte
	PUBLISH_ENDRX     volatile.Register32 // 0x190
	_                 [4]byte
	PUBLISH_END       volatile.Register32 // 0x198
	_                 [4]byte
	PUBLISH_ENDTX     volatile.Register32 // 0x1A0
	_                 [40]byte
	PUBLISH_STARTED   volatile.Register32 // 0x1CC
	_                 [48]byte
	SHORTS            volatile.Register32 // 0x200
	_                 [256]byte
	INTENSET          volatile.Register32 // 0x304
	INTENCLR          volatile.Register32 // 0x308
	_                 [244]byte
	STALLSTAT         volatile.Register32 // 0x400
	_                 [252]byte
	ENABLE            volatile.Register32 // 0x500
	_                 [4]byte
	PSEL              struct {
		SCK  volatile.Register32
		MOSI volatile.Register32
		MISO volatile.Register32
		CSN  volatile.Register32
	} // 0x508
	_         [12]byte
	FREQUENCY volatile.Register32 // 0x524
	_         [12]byte
	RXD       struct {
		PTR    volatile.Register32
		MAXCNT volatile.Register32
		AMOUNT volatile.Register32
		LIST   volatile.Register32
	} // 0x534
	TXD struct {
		PTR    volatile.Register32
		MAXCNT volatile.Register32
		AMOUNT volatile.Register32
		LIST   volatile.Register32
	} // 0x544
	CONFIG   volatile.Register32 // 0x554
	_        [8]byte
	IFTIMING struct {
		RXDELAY volatile.Register32
		CSNDUR  volatile.Register32
	} // 0x560
	CSNPOL  volatile.Register32 // 0x568
	PSELDCX volatile.Register32 // 0x56C
	DCXCNT  volatile.Register32 // 0x570
	_       [76]byte
	ORC     volatile.Register32 // 0x5C0
}

// SPI Slave
type SPIS_Type struct {
	_                 [36]byte
	TASKS_ACQUIRE     volatile.Register32 // 0x24
	TASKS_RELEASE     volatile.Register32 // 0x28
	_                 [120]byte
	SUBSCRIBE_ACQUIRE volatile.Register32 // 0xA4
	SUBSCRIBE_RELEASE volatile.Register32 // 0xA8
	_                 [88]byte
	EVENTS_END        volatile.Register32 // 0x104
	_                 [8]byte
	EVENTS_ENDRX      volatile.Register32 // 0x110
	_                 [20]byte
	EVENTS_ACQUIRED   volatile.Register32 // 0x128
	_                 [88]byte
	PUBLISH_END       volatile.Register32 // 0x184
	_                 [8]byte
	PUBLISH_ENDRX     volatile.Register32 // 0x190
	_                 [20]byte
	PUBLISH_ACQUIRED  volatile.Register32 // 0x1A8
	_                 [84]byte
	SHORTS            volatile.Register32 // 0x200
	_                 [256]byte
	INTENSET          volatile.Register32 // 0x304
	INTENCLR          volatile.Register32 // 0x308
	_                 [244]byte
	SEMSTAT           volatile.Register32 // 0x400
	_                 [60]byte
	STATUS            volatile.Register32 // 0x440
	_                 [188]byte
	ENABLE            volatile.Register32 // 0x500
	_                 [4]byte
	PSEL              struct {
		SCK  volatile.Register32
		MISO volatile.Register32
		MOSI volatile.Register32
		CSN  volatile.Register32
	} // 0x508
	_   [28]byte
	RXD struct {
		PTR    volatile.Register32
		MAXCNT volatile.Register32
		AMOUNT volatile.Register32
		LIST   volatile.Register32
	} // 0x534
	TXD struct {
		PTR    volatile.Register32
		MAXCNT volatile.Register32
		AMOUNT volatile.Register32
		LIST   volatile.Register32
	} // 0x544
	CONFIG volatile.Register32 // 0x554
	_      [4]byte
	DEF    volatile.Register32 // 0x55C
	_      [96]byte
	ORC    volatile.Register32 // 0x5C0
}

// I2C compatible Two-Wire Master Interface with EasyDMA
type TWIM_Type struct {
	TASKS_STARTRX     volatile.Register32 // 0x0
	_                 [4]byte
	TASKS_STARTTX     volatile.Register32 // 0x8
	_                 [8]byte
	TASKS_STOP        volatile.Register32 // 0x14
	_                 [4]byte
	TASKS_SUSPEND     volatile.Register32 // 0x1C
	TASKS_RESUME      volatile.Register32 // 0x20
	_                 [92]byte
	SUBSCRIBE_STARTRX volatile.Register32 // 0x80
	_                 [4]byte
	SUBSCRIBE_STARTTX volatile.Register32 // 0x88
	_                 [8]byte
	SUBSCRIBE_STOP    volatile.Register32 // 0x94
	_                 [4]byte
	SUBSCRIBE_SUSPEND volatile.Register32 // 0x9C
	SUBSCRIBE_RESUME  volatile.Register32 // 0xA0
	_                 [96]byte
	EVENTS_STOPPED    volatile.Register32 // 0x104
	_                 [28]byte
	EVENTS_ERROR      volatile.Register32 // 0x124
	_                 [32]byte
	EVENTS_SUSPENDED  volatile.Register32 // 0x148
	EVENTS_RXSTARTED  volatile.Register32 // 0x14C
	EVENTS_TXSTARTED  volatile.Register32 // 0x150
	_                 [8]byte
	EVENTS_LASTRX     volatile.Register32 // 0x15C
	EVENTS_LASTTX     volatile.Register32 // 0x160
	_                 [32]byte
	PUBLISH_STOPPED   volatile.Register32 // 0x184
	_                 [28]byte
	PUBLISH_ERROR     volatile.Register32 // 0x1A4
	_                 [32]byte
	PUBLISH_SUSPENDED volatile.Register32 // 0x1C8
	PUBLISH_RXSTARTED volatile.Register32 // 0x1CC
	PUBLISH_TXSTARTED volatile.Register32 // 0x1D0
	_                 [8]byte
	PUBLISH_LASTRX    volatile.Register32 // 0x1DC
	PUBLISH_LASTTX    volatile.Register32 // 0x1E0
	_                 [28]byte
	SHORTS            volatile.Register32 // 0x200
	_                 [252]byte
	INTEN             volatile.Register32 // 0x300
	INTENSET          volatile.Register32 // 0x304
	INTENCLR          volatile.Register32 // 0x308
	_                 [440]byte
	ERRORSRC          volatile.Register32 // 0x4C4
	_                 [56]byte
	ENABLE            volatile.Register32 // 0x500
	_                 [4]byte
	PSEL              struct {
		SCL volatile.Register32
		SDA volatile.Register32
	} // 0x508
	_         [20]byte
	FREQUENCY volatile.Register32 // 0x524
	_         [12]byte
	RXD       struct {
		PTR    volatile.Register32
		MAXCNT volatile.Register32
		AMOUNT volatile.Register32
		LIST   volatile.Register32
	} // 0x534
	TXD struct {
		PTR    volatile.Register32
		MAXCNT volatile.Register32
		AMOUNT volatile.Register32
		LIST   volatile.Register32
	} // 0x544
	_       [52]byte
	ADDRESS volatile.Register32 // 0x588
}

// I2C compatible Two-Wire Slave Interface with EasyDMA
type TWIS_Type struct {
	_                   [20]byte
	TASKS_STOP          volatile.Register32 // 0x14
	_                   [4]byte
	TASKS_SUSPEND       volatile.Register32 // 0x1C
	TASKS_RESUME        volatile.Register32 // 0x20
	_                   [12]byte
	TASKS_PREPARERX     volatile.Register32 // 0x30
	TASKS_PREPARETX     volatile.Register32 // 0x34
	_                   [92]byte
	SUBSCRIBE_STOP      volatile.Register32 // 0x94
	_                   [4]byte
	SUBSCRIBE_SUSPEND   volatile.Register32 // 0x9C
	SUBSCRIBE_RESUME    volatile.Register32 // 0xA0
	_                   [12]byte
	SUBSCRIBE_PREPARERX volatile.Register32 // 0xB0
	SUBSCRIBE_PREPARETX volatile.Register32 // 0xB4
	_                   [76]byte
	EVENTS_STOPPED      volatile.Register32 // 0x104
	_                   [28]byte
	EVENTS_ERROR        volatile.Register32 // 0x124
	_                   [36]byte
	EVENTS_RXSTARTED    volatile.Register32 // 0x14C
	EVENTS_TXSTARTED    volatile.Register32 // 0x150
	_                   [16]byte
	EVENTS_WRITE        volatile.Register32 // 0x164
	EVENTS_READ         volatile.Register32 // 0x168
	_                   [24]byte
	PUBLISH_STOPPED     volatile.Register32 // 0x184
	_                   [28]byte
	PUBLISH_ERROR       volatile.Register32 // 0x1A4
	_                   [36]byte
	PUBLISH_RXSTARTED   volatile.Register32 // 0x1CC
	PUBLISH_TXSTARTED   volatile.Register32 // 0x1D0
	_                   [16]byte
	PUBLISH_WRITE       volatile.Register32 // 0x1E4
	PUBLISH_READ        volatile.Register32 // 0x1E8
	_                   [20]byte
	SHORTS              volatile.Register32 // 0x200
	_                   [252]byte
	INTEN               volatile.Register32 // 0x300
	INTENSET            volatile.Register32 // 0x304
	INTENCLR            volatile.Register32 // 0x308
	_                   [452]byte
	ERRORSRC            volatile.Register32 // 0x4D0
	MATCH               volatile.Register32 // 0x4D4
	_                   [40]byte
	ENABLE              volatile.Register32 // 0x500
	_                   [4]byte
	PSEL                struct {
		SCL volatile.Register32
		SDA volatile.Register32
	} // 0x508
	_   [36]byte
	RXD struct {
		PTR    volatile.Register32
		MAXCNT volatile.Register32
		AMOUNT volatile.Register32
		LIST   volatile.Register32
	} // 0x534
	TXD struct {
		PTR    volatile.Register32
		MAXCNT volatile.Register32
		AMOUNT volatile.Register32
		LIST   volatile.Register32
	} // 0x544
	_       [52]byte
	ADDRESS [2]volatile.Register32 // 0x588
	_       [4]byte
	CONFIG  volatile.Register32 // 0x594
	_       [40]byte
	ORC     volatile.Register32 // 0x5C0
}

// UART with EasyDMA
type UARTE_Type struct {
	TASKS_STARTRX     volatile.Register32 // 0x0
	TASKS_STOPRX      volatile.Register32 // 0x4
	TASKS_STARTTX     volatile.Register32 // 0x8
	TASKS_STOPTX      volatile.Register32 // 0xC
	_                 [28]byte
	TASKS_FLUSHRX     volatile.Register32 // 0x2C
	_                 [80]byte
	SUBSCRIBE_STARTRX volatile.Register32 // 0x80
	SUBSCRIBE_STOPRX  volatile.Register32 // 0x84
	SUBSCRIBE_STARTTX volatile.Register32 // 0x88
	SUBSCRIBE_STOPTX  volatile.Register32 // 0x8C
	_                 [28]byte
	SUBSCRIBE_FLUSHRX volatile.Register32 // 0xAC
	_                 [80]byte
	EVENTS_CTS        volatile.Register32 // 0x100
	EVENTS_NCTS       volatile.Register32 // 0x104
	EVENTS_RXDRDY     volatile.Register32 // 0x108
	_                 [4]byte
	EVENTS_ENDRX      volatile.Register32 // 0x110
	_                 [8]byte
	EVENTS_TXDRDY     volatile.Register32 // 0x11C
	EVENTS_ENDTX      volatile.Register32 // 0x120
	EVENTS_ERROR      volatile.Register32 // 0x124
	_                 [28]byte
	EVENTS_RXTO       volatile.Register32 // 0x144
	_                 [4]byte
	EVENTS_RXSTARTED  volatile.Register32 // 0x14C
	EVENTS_TXSTARTED  volatile.Register32 // 0x150
	_                 [4]byte
	EVENTS_TXSTOPPED  volatile.Register32 // 0x158
	_                 [36]byte
	PUBLISH_CTS       volatile.Register32 // 0x180
	PUBLISH_NCTS      volatile.Register32 // 0x184
	PUBLISH_RXDRDY    volatile.Register32 // 0x188
	_                 [4]byte
	PUBLISH_ENDRX     volatile.Register32 // 0x190
	_                 [8]byte
	PUBLISH_TXDRDY    volatile.Register32 // 0x19C
	PUBLISH_ENDTX     volatile.Register32 // 0x1A0
	PUBLISH_ERROR     volatile.Register32 // 0x1A4
	_                 [28]byte
	PUBLISH_RXTO      volatile.Register32 // 0x1C4
	_                 [4]byte
	PUBLISH_RXSTARTED volatile.Register32 // 0x1CC
	PUBLISH_TXSTARTED volatile.Register32 // 0x1D0
	_                 [4]byte
	PUBLISH_TXSTOPPED volatile.Register32 // 0x1D8
	_                 [36]byte
	SHORTS            volatile.Register32 // 0x200
	_                 [252]byte
	INTEN             volatile.Register32 // 0x300
	INTENSET          volatile.Register32 // 0x304
	INTENCLR          volatile.Register32 // 0x308
	_                 [372]byte
	ERRORSRC          volatile.Register32 // 0x480
	_                 [124]byte
	ENABLE            volatile.Register32 // 0x500
	_                 [4]byte
	PSEL              struct {
		RTS volatile.Register32
		TXD volatile.Register32
		CTS volatile.Register32
		RXD volatile.Register32
	} // 0x508
	_        [12]byte
	BAUDRATE volatile.Register32 // 0x524
	_        [12]byte
	RXD      struct {
		PTR    volatile.Register32
		MAXCNT volatile.Register32
		AMOUNT volatile.Register32
	} // 0x534
	_   [4]byte
	TXD struct {
		PTR    volatile.Register32
		MAXCNT volatile.Register32
		AMOUNT volatile.Register32
	} // 0x544
	_      [28]byte
	CONFIG volatile.Register32 // 0x56C
}

// Event generator unit
type EGU_Type struct {
	TASKS_TRIGGER     [16]volatile.Register32 // 0x0
	_                 [64]byte
	SUBSCRIBE_TRIGGER [16]volatile.Register32 // 0x80
	_                 [64]byte
	EVENTS_TRIGGERED  [16]volatile.Register32 // 0x100
	_                 [64]byte
	PUBLISH_TRIGGERED [16]volatile.Register32 // 0x180
	_                 [320]byte
	INTEN             volatile.Register32 // 0x300
	INTENSET          volatile.Register32 // 0x304
	INTENCLR          volatile.Register32 // 0x308
}

// Software interrupt 0
type SWI_Type struct {
	UNUSED volatile.Register32 // 0x0
}

// MUTEX 0
type MUTEX_Type struct {
	_     [1024]byte
	MUTEX [16]volatile.Register32 // 0x400
}

// Access control lists
type ACL_Type struct {
	_   [2048]byte
	ACL [8]struct {
		ADDR volatile.Register32
		SIZE volatile.Register32
		PERM volatile.Register32
		_    [4]byte
	} // 0x800
}

// Non-volatile memory controller
type NVMC_Type struct {
	_                   [1024]byte
	READY               volatile.Register32 // 0x400
	_                   [4]byte
	READYNEXT           volatile.Register32 // 0x408
	_                   [248]byte
	CONFIG              volatile.Register32 // 0x504
	_                   [4]byte
	ERASEALL            volatile.Register32 // 0x50C
	_                   [12]byte
	ERASEPAGEPARTIALCFG volatile.Register32 // 0x51C
	_                   [32]byte
	ICACHECNF           volatile.Register32 // 0x540
	_                   [4]byte
	IHIT                volatile.Register32 // 0x548
	IMISS               volatile.Register32 // 0x54C
}

// Volatile Memory controller
type VMC_Type struct {
	_   [1536]byte
	RAM [4]struct {
		POWER    volatile.Register32
		POWERSET volatile.Register32
		POWERCLR volatile.Register32
		_        [4]byte
	} // 0x600
}

// GPIO Port 0
type GPIO_Type struct {
	_              [4]byte
	OUT            volatile.Register32 // 0x4
	OUTSET         volatile.Register32 // 0x8
	OUTCLR         volatile.Register32 // 0xC
	IN             volatile.Register32 // 0x10
	DIR            volatile.Register32 // 0x14
	DIRSET         volatile.Register32 // 0x18
	DIRCLR         volatile.Register32 // 0x1C
	LATCH          volatile.Register32 // 0x20
	DETECTMODE     volatile.Register32 // 0x24
	DETECTMODE_SEC volatile.Register32 // 0x28
	_              [468]byte
	PIN_CNF        [32]volatile.Register32 // 0x200
}

// Bitfields for FICR_NS: Factory Information Configuration Registers
const (
	// INFO.CONFIGID: Configuration identifier
	// Position of HWID field.
	FICR_INFO_CONFIGID_HWID_Pos = 0x0
	// Bit mask of HWID field.
	FICR_INFO_CONFIGID_HWID_Msk = 0xffff

	// INFO.DEVICEID: Description collection: Device identifier
	// Position of DEVICEID field.
	FICR_INFO_DEVICEID_DEVICEID_Pos = 0x0
	// Bit mask of DEVICEID field.
	FICR_INFO_DEVICEID_DEVICEID_Msk = 0xffffffff

	// INFO.PART: Part code
	// Position of PART field.
	FICR_INFO_PART_PART_Pos = 0x0
	// Bit mask of PART field.
	FICR_INFO_PART_PART_Msk = 0xffffffff
	// nRF5340
	FICR_INFO_PART_PART_N5340 = 0x5340
	// Unspecified
	FICR_INFO_PART_PART_Unspecified = 0xffffffff

	// INFO.VARIANT: Part Variant, Hardware version and Production configuration
	// Position of VARIANT field.
	FICR_INFO_VARIANT_VARIANT_Pos = 0x0
	// Bit mask of VARIANT field.
	FICR_INFO_VARIANT_VARIANT_Msk = 0xffffffff
	// QKAA
	FICR_INFO_VARIANT_VARIANT_QKAA = 0x514b4141
	// Unspecified
	FICR_INFO_VARIANT_VARIANT_Unspecified = 0xffffffff

	// INFO.PACKAGE: Package option
	// Position of PACKAGE field.
	FICR_INFO_PACKAGE_PACKAGE_Pos = 0x0
	// Bit mask of PACKAGE field.
	FICR_INFO_PACKAGE_PACKAGE_Msk = 0xffffffff
	// QFxx - 94 pin QFN
	FICR_INFO_PACKAGE_PACKAGE_QF = 0x2000
	// Unspecified
	FICR_INFO_PACKAGE_PACKAGE_Unspecified = 0xffffffff

	// INFO.RAM: RAM variant
	// Position of RAM field.
	FICR_INFO_RAM_RAM_Pos = 0x0
	// Bit mask of RAM field.
	FICR_INFO_RAM_RAM_Msk = 0xffffffff
	// 16 kByte RAM
	FICR_INFO_RAM_RAM_K16 = 0x10
	// 32 kByte RAM
	FICR_INFO_RAM_RAM_K32 = 0x20
	// 64 kByte RAM
	FICR_INFO_RAM_RAM_K64 = 0x40
	// 128 kByte RAM
	FICR_INFO_RAM_RAM_K128 = 0x80
	// 256 kByte RAM
	FICR_INFO_RAM_RAM_K256 = 0x100
	// 512 kByte RAM
	FICR_INFO_RAM_RAM_K512 = 0x200
	// Unspecified
	FICR_INFO_RAM_RAM_Unspecified = 0xffffffff

	// INFO.FLASH: Flash variant
	// Position of FLASH field.
	FICR_INFO_FLASH_FLASH_Pos = 0x0
	// Bit mask of FLASH field.
	FICR_INFO_FLASH_FLASH_Msk = 0xffffffff
	// 128 kByte FLASH
	FICR_INFO_FLASH_FLASH_K128 = 0x80
	// 256 kByte FLASH
	FICR_INFO_FLASH_FLASH_K256 = 0x100
	// 512 kByte FLASH
	FICR_INFO_FLASH_FLASH_K512 = 0x200
	// 1 MByte FLASH
	FICR_INFO_FLASH_FLASH_K1024 = 0x400
	// 2 MByte FLASH
	FICR_INFO_FLASH_FLASH_K2048 = 0x800
	// Unspecified
	FICR_INFO_FLASH_FLASH_Unspecified = 0xffffffff

	// INFO.CODEPAGESIZE: Code memory page size in bytes
	// Position of CODEPAGESIZE field.
	FICR_INFO_CODEPAGESIZE_CODEPAGESIZE_Pos = 0x0
	// Bit mask of CODEPAGESIZE field.
	FICR_INFO_CODEPAGESIZE_CODEPAGESIZE_Msk = 0xffffffff
	// 2 kByte
	FICR_INFO_CODEPAGESIZE_CODEPAGESIZE_K2048 = 0x800

	// INFO.CODESIZE: Code memory size
	// Position of CODESIZE field.
	FICR_INFO_CODESIZE_CODESIZE_Pos = 0x0
	// Bit mask of CODESIZE field.
	FICR_INFO_CODESIZE_CODESIZE_Msk = 0xffffffff
	// 128 pages
	FICR_INFO_CODESIZE_CODESIZE_P128 = 0x80

	// INFO.DEVICETYPE: Device type
	// Position of DEVICETYPE field.
	FICR_INFO_DEVICETYPE_DEVICETYPE_Pos = 0x0
	// Bit mask of DEVICETYPE field.
	FICR_INFO_DEVICETYPE_DEVICETYPE_Msk = 0xffffffff
	// Device is an physical DIE
	FICR_INFO_DEVICETYPE_DEVICETYPE_Die = 0x0
	// Device is an FPGA
	FICR_INFO_DEVICETYPE_DEVICETYPE_FPGA = 0xffffffff

	// ER: Description collection: Encryption Root, word n
	// Position of ER field.
	FICR_ER_ER_Pos = 0x0
	// Bit mask of ER field.
	FICR_ER_ER_Msk = 0xffffffff

	// IR: Description collection: Identity Root, word n
	// Position of IR field.
	FICR_IR_IR_Pos = 0x0
	// Bit mask of IR field.
	FICR_IR_IR_Msk = 0xffffffff

	// DEVICEADDRTYPE: Device address type
	// Position of DEVICEADDRTYPE field.
	FICR_DEVICEADDRTYPE_DEVICEADDRTYPE_Pos = 0x0
	// Bit mask of DEVICEADDRTYPE field.
	FICR_DEVICEADDRTYPE_DEVICEADDRTYPE_Msk = 0x1
	// Bit DEVICEADDRTYPE.
	FICR_DEVICEADDRTYPE_DEVICEADDRTYPE = 0x1
	// Public address
	FICR_DEVICEADDRTYPE_DEVICEADDRTYPE_Public = 0x0
	// Random address
	FICR_DEVICEADDRTYPE_DEVICEADDRTYPE_Random = 0x1

	// DEVICEADDR: Description collection: Device address n
	// Position of DEVICEADDR field.
	FICR_DEVICEADDR_DEVICEADDR_Pos = 0x0
	// Bit mask of DEVICEADDR field.
	FICR_DEVICEADDR_DEVICEADDR_Msk = 0xffffffff

	// TRIMCNF.ADDR: Description cluster: Address
	// Position of Address field.
	FICR_TRIMCNF_ADDR_Address_Pos = 0x0
	// Bit mask of Address field.
	FICR_TRIMCNF_ADDR_Address_Msk = 0xffffffff

	// TRIMCNF.DATA: Description cluster: Data
	// Position of Data field.
	FICR_TRIMCNF_DATA_Data_Pos = 0x0
	// Bit mask of Data field.
	FICR_TRIMCNF_DATA_Data_Msk = 0xffffffff
)

// Bitfields for UICR_NS: User Information Configuration Registers
const (
	// APPROTECT: Access port protection
	// Position of PALL field.
	UICR_APPROTECT_PALL_Pos = 0x0
	// Bit mask of PALL field.
	UICR_APPROTECT_PALL_Msk = 0xffffffff
	// Unprotected
	UICR_APPROTECT_PALL_Unprotected = 0xffffffff
	// Protected
	UICR_APPROTECT_PALL_Protected = 0x0

	// ERASEPROTECT: Erase protection
	// Position of PALL field.
	UICR_ERASEPROTECT_PALL_Pos = 0x0
	// Bit mask of PALL field.
	UICR_ERASEPROTECT_PALL_Msk = 0xffffffff
	// Unprotected
	UICR_ERASEPROTECT_PALL_Unprotected = 0xffffffff
	// Protected
	UICR_ERASEPROTECT_PALL_Protected = 0x0

	// NRFFW: Description collection: Reserved for Nordic firmware design
	// Position of NRFFW field.
	UICR_NRFFW_NRFFW_Pos = 0x0
	// Bit mask of NRFFW field.
	UICR_NRFFW_NRFFW_Msk = 0xffffffff

	// CUSTOMER: Description collection: Reserved for customer
	// Position of CUSTOMER field.
	UICR_CUSTOMER_CUSTOMER_Pos = 0x0
	// Bit mask of CUSTOMER field.
	UICR_CUSTOMER_CUSTOMER_Msk = 0xffffffff
)

// Bitfields for CTI_NS: Cross-Trigger Interface control. NOTE: this is not a separate peripheral, but describes CM33 functionality.
const (
	// CTICONTROL: CTI Control register
	// Position of GLBEN field.
	CTI_CTICONTROL_GLBEN_Pos = 0x0
	// Bit mask of GLBEN field.
	CTI_CTICONTROL_GLBEN_Msk = 0x1
	// Bit GLBEN.
	CTI_CTICONTROL_GLBEN = 0x1
	// All cross-triggering mapping logic functionality is disabled.
	CTI_CTICONTROL_GLBEN_Disabled = 0x0
	// Cross-triggering mapping logic functionality is enabled.
	CTI_CTICONTROL_GLBEN_Enabled = 0x1

	// CTIINTACK: CTI Interrupt Acknowledge register
	// Position of DEBUGREQ field.
	CTI_CTIINTACK_DEBUGREQ_Pos = 0x0
	// Bit mask of DEBUGREQ field.
	CTI_CTIINTACK_DEBUGREQ_Msk = 0x1
	// Bit DEBUGREQ.
	CTI_CTIINTACK_DEBUGREQ = 0x1
	// Clears the ctitrigout.
	CTI_CTIINTACK_DEBUGREQ_Acknowledge = 0x1
	// Position of CPURESTART field.
	CTI_CTIINTACK_CPURESTART_Pos = 0x1
	// Bit mask of CPURESTART field.
	CTI_CTIINTACK_CPURESTART_Msk = 0x2
	// Bit CPURESTART.
	CTI_CTIINTACK_CPURESTART = 0x2
	// Clears the ctitrigout.
	CTI_CTIINTACK_CPURESTART_Acknowledge = 0x1
	// Position of UNUSED0 field.
	CTI_CTIINTACK_UNUSED0_Pos = 0x2
	// Bit mask of UNUSED0 field.
	CTI_CTIINTACK_UNUSED0_Msk = 0x4
	// Bit UNUSED0.
	CTI_CTIINTACK_UNUSED0 = 0x4
	// Clears the ctitrigout.
	CTI_CTIINTACK_UNUSED0_Acknowledge = 0x1
	// Position of UNUSED1 field.
	CTI_CTIINTACK_UNUSED1_Pos = 0x3
	// Bit mask of UNUSED1 field.
	CTI_CTIINTACK_UNUSED1_Msk = 0x8
	// Bit UNUSED1.
	CTI_CTIINTACK_UNUSED1 = 0x8
	// Clears the ctitrigout.
	CTI_CTIINTACK_UNUSED1_Acknowledge = 0x1
	// Position of UNUSED2 field.
	CTI_CTIINTACK_UNUSED2_Pos = 0x4
	// Bit mask of UNUSED2 field.
	CTI_CTIINTACK_UNUSED2_Msk = 0x10
	// Bit UNUSED2.
	CTI_CTIINTACK_UNUSED2 = 0x10
	// Clears the ctitrigout.
	CTI_CTIINTACK_UNUSED2_Acknowledge = 0x1
	// Position of UNUSED3 field.
	CTI_CTIINTACK_UNUSED3_Pos = 0x5
	// Bit mask of UNUSED3 field.
	CTI_CTIINTACK_UNUSED3_Msk = 0x20
	// Bit UNUSED3.
	CTI_CTIINTACK_UNUSED3 = 0x20
	// Clears the ctitrigout.
	CTI_CTIINTACK_UNUSED3_Acknowledge = 0x1
	// Position of UNUSED4 field.
	CTI_CTIINTACK_UNUSED4_Pos = 0x6
	// Bit mask of UNUSED4 field.
	CTI_CTIINTACK_UNUSED4_Msk = 0x40
	// Bit UNUSED4.
	CTI_CTIINTACK_UNUSED4 = 0x40
	// Clears the ctitrigout.
	CTI_CTIINTACK_UNUSED4_Acknowledge = 0x1
	// Position of UNUSED5 field.
	CTI_CTIINTACK_UNUSED5_Pos = 0x7
	// Bit mask of UNUSED5 field.
	CTI_CTIINTACK_UNUSED5_Msk = 0x80
	// Bit UNUSED5.
	CTI_CTIINTACK_UNUSED5 = 0x80
	// Clears the ctitrigout.
	CTI_CTIINTACK_UNUSED5_Acknowledge = 0x1

	// CTIAPPSET: CTI Application Trigger Set register
	// Position of APPSET_0 field.
	CTI_CTIAPPSET_APPSET_0_Pos = 0x0
	// Bit mask of APPSET_0 field.
	CTI_CTIAPPSET_APPSET_0_Msk = 0x1
	// Bit APPSET_0.
	CTI_CTIAPPSET_APPSET_0 = 0x1
	// Application trigger 0 is inactive.
	CTI_CTIAPPSET_APPSET_0_Inactive = 0x0
	// Application trigger 0 is active.
	CTI_CTIAPPSET_APPSET_0_Active = 0x1
	// Generate channel event for channel 0.
	CTI_CTIAPPSET_APPSET_0_Activate = 0x1
	// Position of APPSET_1 field.
	CTI_CTIAPPSET_APPSET_1_Pos = 0x1
	// Bit mask of APPSET_1 field.
	CTI_CTIAPPSET_APPSET_1_Msk = 0x2
	// Bit APPSET_1.
	CTI_CTIAPPSET_APPSET_1 = 0x2
	// Application trigger 1 is inactive.
	CTI_CTIAPPSET_APPSET_1_Inactive = 0x0
	// Application trigger 1 is active.
	CTI_CTIAPPSET_APPSET_1_Active = 0x1
	// Generate channel event for channel 1.
	CTI_CTIAPPSET_APPSET_1_Activate = 0x1
	// Position of APPSET_2 field.
	CTI_CTIAPPSET_APPSET_2_Pos = 0x2
	// Bit mask of APPSET_2 field.
	CTI_CTIAPPSET_APPSET_2_Msk = 0x4
	// Bit APPSET_2.
	CTI_CTIAPPSET_APPSET_2 = 0x4
	// Application trigger 2 is inactive.
	CTI_CTIAPPSET_APPSET_2_Inactive = 0x0
	// Application trigger 2 is active.
	CTI_CTIAPPSET_APPSET_2_Active = 0x1
	// Generate channel event for channel 2.
	CTI_CTIAPPSET_APPSET_2_Activate = 0x1
	// Position of APPSET_3 field.
	CTI_CTIAPPSET_APPSET_3_Pos = 0x3
	// Bit mask of APPSET_3 field.
	CTI_CTIAPPSET_APPSET_3_Msk = 0x8
	// Bit APPSET_3.
	CTI_CTIAPPSET_APPSET_3 = 0x8
	// Application trigger 3 is inactive.
	CTI_CTIAPPSET_APPSET_3_Inactive = 0x0
	// Application trigger 3 is active.
	CTI_CTIAPPSET_APPSET_3_Active = 0x1
	// Generate channel event for channel 3.
	CTI_CTIAPPSET_APPSET_3_Activate = 0x1

	// CTIAPPCLEAR: CTI Application Trigger Clear register
	// Position of APPCLEAR_0 field.
	CTI_CTIAPPCLEAR_APPCLEAR_0_Pos = 0x0
	// Bit mask of APPCLEAR_0 field.
	CTI_CTIAPPCLEAR_APPCLEAR_0_Msk = 0x1
	// Bit APPCLEAR_0.
	CTI_CTIAPPCLEAR_APPCLEAR_0 = 0x1
	// Clears the event for channel 0.
	CTI_CTIAPPCLEAR_APPCLEAR_0_Clear = 0x1
	// Position of APPCLEAR_1 field.
	CTI_CTIAPPCLEAR_APPCLEAR_1_Pos = 0x1
	// Bit mask of APPCLEAR_1 field.
	CTI_CTIAPPCLEAR_APPCLEAR_1_Msk = 0x2
	// Bit APPCLEAR_1.
	CTI_CTIAPPCLEAR_APPCLEAR_1 = 0x2
	// Clears the event for channel 1.
	CTI_CTIAPPCLEAR_APPCLEAR_1_Clear = 0x1
	// Position of APPCLEAR_2 field.
	CTI_CTIAPPCLEAR_APPCLEAR_2_Pos = 0x2
	// Bit mask of APPCLEAR_2 field.
	CTI_CTIAPPCLEAR_APPCLEAR_2_Msk = 0x4
	// Bit APPCLEAR_2.
	CTI_CTIAPPCLEAR_APPCLEAR_2 = 0x4
	// Clears the event for channel 2.
	CTI_CTIAPPCLEAR_APPCLEAR_2_Clear = 0x1
	// Position of APPCLEAR_3 field.
	CTI_CTIAPPCLEAR_APPCLEAR_3_Pos = 0x3
	// Bit mask of APPCLEAR_3 field.
	CTI_CTIAPPCLEAR_APPCLEAR_3_Msk = 0x8
	// Bit APPCLEAR_3.
	CTI_CTIAPPCLEAR_APPCLEAR_3 = 0x8
	// Clears the event for channel 3.
	CTI_CTIAPPCLEAR_APPCLEAR_3_Clear = 0x1

	// CTIAPPPULSE: CTI Application Pulse register
	// Position of APPULSE_0 field.
	CTI_CTIAPPPULSE_APPULSE_0_Pos = 0x0
	// Bit mask of APPULSE_0 field.
	CTI_CTIAPPPULSE_APPULSE_0_Msk = 0x1
	// Bit APPULSE_0.
	CTI_CTIAPPPULSE_APPULSE_0 = 0x1
	// Generates an event pulse on channel 0.
	CTI_CTIAPPPULSE_APPULSE_0_Generate = 0x1
	// Position of APPULSE_1 field.
	CTI_CTIAPPPULSE_APPULSE_1_Pos = 0x1
	// Bit mask of APPULSE_1 field.
	CTI_CTIAPPPULSE_APPULSE_1_Msk = 0x2
	// Bit APPULSE_1.
	CTI_CTIAPPPULSE_APPULSE_1 = 0x2
	// Generates an event pulse on channel 1.
	CTI_CTIAPPPULSE_APPULSE_1_Generate = 0x1
	// Position of APPULSE_2 field.
	CTI_CTIAPPPULSE_APPULSE_2_Pos = 0x2
	// Bit mask of APPULSE_2 field.
	CTI_CTIAPPPULSE_APPULSE_2_Msk = 0x4
	// Bit APPULSE_2.
	CTI_CTIAPPPULSE_APPULSE_2 = 0x4
	// Generates an event pulse on channel 2.
	CTI_CTIAPPPULSE_APPULSE_2_Generate = 0x1
	// Position of APPULSE_3 field.
	CTI_CTIAPPPULSE_APPULSE_3_Pos = 0x3
	// Bit mask of APPULSE_3 field.
	CTI_CTIAPPPULSE_APPULSE_3_Msk = 0x8
	// Bit APPULSE_3.
	CTI_CTIAPPPULSE_APPULSE_3 = 0x8
	// Generates an event pulse on channel 3.
	CTI_CTIAPPPULSE_APPULSE_3_Generate = 0x1

	// CTIINEN: Description collection: CTI Trigger input
	// Position of TRIGINEN_0 field.
	CTI_CTIINEN_TRIGINEN_0_Pos = 0x0
	// Bit mask of TRIGINEN_0 field.
	CTI_CTIINEN_TRIGINEN_0_Msk = 0x1
	// Bit TRIGINEN_0.
	CTI_CTIINEN_TRIGINEN_0 = 0x1
	// Input trigger n events are ignored by channel 0.
	CTI_CTIINEN_TRIGINEN_0_Disabled = 0x0
	// When an event is received on input trigger n (ctitrigin[n]), generate an event on channel 0.
	CTI_CTIINEN_TRIGINEN_0_Enabled = 0x1
	// Position of TRIGINEN_1 field.
	CTI_CTIINEN_TRIGINEN_1_Pos = 0x1
	// Bit mask of TRIGINEN_1 field.
	CTI_CTIINEN_TRIGINEN_1_Msk = 0x2
	// Bit TRIGINEN_1.
	CTI_CTIINEN_TRIGINEN_1 = 0x2
	// Input trigger n events are ignored by channel 1.
	CTI_CTIINEN_TRIGINEN_1_Disabled = 0x0
	// When an event is received on input trigger n (ctitrigin[n]), generate an event on channel 1.
	CTI_CTIINEN_TRIGINEN_1_Enabled = 0x1
	// Position of TRIGINEN_2 field.
	CTI_CTIINEN_TRIGINEN_2_Pos = 0x2
	// Bit mask of TRIGINEN_2 field.
	CTI_CTIINEN_TRIGINEN_2_Msk = 0x4
	// Bit TRIGINEN_2.
	CTI_CTIINEN_TRIGINEN_2 = 0x4
	// Input trigger n events are ignored by channel 2.
	CTI_CTIINEN_TRIGINEN_2_Disabled = 0x0
	// When an event is received on input trigger n (ctitrigin[n]), generate an event on channel 2.
	CTI_CTIINEN_TRIGINEN_2_Enabled = 0x1
	// Position of TRIGINEN_3 field.
	CTI_CTIINEN_TRIGINEN_3_Pos = 0x3
	// Bit mask of TRIGINEN_3 field.
	CTI_CTIINEN_TRIGINEN_3_Msk = 0x8
	// Bit TRIGINEN_3.
	CTI_CTIINEN_TRIGINEN_3 = 0x8
	// Input trigger n events are ignored by channel 3.
	CTI_CTIINEN_TRIGINEN_3_Disabled = 0x0
	// When an event is received on input trigger n (ctitrigin[n]), generate an event on channel 3.
	CTI_CTIINEN_TRIGINEN_3_Enabled = 0x1

	// CTIOUTEN: Description collection: CTI Trigger output
	// Position of TRIGOUTEN_0 field.
	CTI_CTIOUTEN_TRIGOUTEN_0_Pos = 0x0
	// Bit mask of TRIGOUTEN_0 field.
	CTI_CTIOUTEN_TRIGOUTEN_0_Msk = 0x1
	// Bit TRIGOUTEN_0.
	CTI_CTIOUTEN_TRIGOUTEN_0 = 0x1
	// Channel 0 is ignored by output trigger n.
	CTI_CTIOUTEN_TRIGOUTEN_0_Disabled = 0x0
	// When an event occurs on channel 0, generate an event on output event n (ctitrigout[n]).
	CTI_CTIOUTEN_TRIGOUTEN_0_Enabled = 0x1
	// Position of TRIGOUTEN_1 field.
	CTI_CTIOUTEN_TRIGOUTEN_1_Pos = 0x1
	// Bit mask of TRIGOUTEN_1 field.
	CTI_CTIOUTEN_TRIGOUTEN_1_Msk = 0x2
	// Bit TRIGOUTEN_1.
	CTI_CTIOUTEN_TRIGOUTEN_1 = 0x2
	// Channel 1 is ignored by output trigger n.
	CTI_CTIOUTEN_TRIGOUTEN_1_Disabled = 0x0
	// When an event occurs on channel 1, generate an event on output event n (ctitrigout[n]).
	CTI_CTIOUTEN_TRIGOUTEN_1_Enabled = 0x1
	// Position of TRIGOUTEN_2 field.
	CTI_CTIOUTEN_TRIGOUTEN_2_Pos = 0x2
	// Bit mask of TRIGOUTEN_2 field.
	CTI_CTIOUTEN_TRIGOUTEN_2_Msk = 0x4
	// Bit TRIGOUTEN_2.
	CTI_CTIOUTEN_TRIGOUTEN_2 = 0x4
	// Channel 2 is ignored by output trigger n.
	CTI_CTIOUTEN_TRIGOUTEN_2_Disabled = 0x0
	// When an event occurs on channel 2, generate an event on output event n (ctitrigout[n]).
	CTI_CTIOUTEN_TRIGOUTEN_2_Enabled = 0x1
	// Position of TRIGOUTEN_3 field.
	CTI_CTIOUTEN_TRIGOUTEN_3_Pos = 0x3
	// Bit mask of TRIGOUTEN_3 field.
	CTI_CTIOUTEN_TRIGOUTEN_3_Msk = 0x8
	// Bit TRIGOUTEN_3.
	CTI_CTIOUTEN_TRIGOUTEN_3 = 0x8
	// Channel 3 is ignored by output trigger n.
	CTI_CTIOUTEN_TRIGOUTEN_3_Disabled = 0x0
	// When an event occurs on channel 3, generate an event on output event n (ctitrigout[n]).
	CTI_CTIOUTEN_TRIGOUTEN_3_Enabled = 0x1

	// CTITRIGINSTATUS: CTI Trigger In Status register
	// Position of CPUHALTED field.
	CTI_CTITRIGINSTATUS_CPUHALTED_Pos = 0x0
	// Bit mask of CPUHALTED field.
	CTI_CTITRIGINSTATUS_CPUHALTED_Msk = 0x1
	// Bit CPUHALTED.
	CTI_CTITRIGINSTATUS_CPUHALTED = 0x1
	// Ctitrigin 0 is active.
	CTI_CTITRIGINSTATUS_CPUHALTED_Active = 0x1
	// Ctitrigin 0 is inactive.
	CTI_CTITRIGINSTATUS_CPUHALTED_Inactive = 0x0
	// Position of DWTCOMPOUT0 field.
	CTI_CTITRIGINSTATUS_DWTCOMPOUT0_Pos = 0x1
	// Bit mask of DWTCOMPOUT0 field.
	CTI_CTITRIGINSTATUS_DWTCOMPOUT0_Msk = 0x2
	// Bit DWTCOMPOUT0.
	CTI_CTITRIGINSTATUS_DWTCOMPOUT0 = 0x2
	// Ctitrigin 1 is active.
	CTI_CTITRIGINSTATUS_DWTCOMPOUT0_Active = 0x1
	// Ctitrigin 1 is inactive.
	CTI_CTITRIGINSTATUS_DWTCOMPOUT0_Inactive = 0x0
	// Position of DWTCOMPOUT1 field.
	CTI_CTITRIGINSTATUS_DWTCOMPOUT1_Pos = 0x2
	// Bit mask of DWTCOMPOUT1 field.
	CTI_CTITRIGINSTATUS_DWTCOMPOUT1_Msk = 0x4
	// Bit DWTCOMPOUT1.
	CTI_CTITRIGINSTATUS_DWTCOMPOUT1 = 0x4
	// Ctitrigin 2 is active.
	CTI_CTITRIGINSTATUS_DWTCOMPOUT1_Active = 0x1
	// Ctitrigin 2 is inactive.
	CTI_CTITRIGINSTATUS_DWTCOMPOUT1_Inactive = 0x0
	// Position of DWTCOMPOUT2 field.
	CTI_CTITRIGINSTATUS_DWTCOMPOUT2_Pos = 0x3
	// Bit mask of DWTCOMPOUT2 field.
	CTI_CTITRIGINSTATUS_DWTCOMPOUT2_Msk = 0x8
	// Bit DWTCOMPOUT2.
	CTI_CTITRIGINSTATUS_DWTCOMPOUT2 = 0x8
	// Ctitrigin 3 is active.
	CTI_CTITRIGINSTATUS_DWTCOMPOUT2_Active = 0x1
	// Ctitrigin 3 is inactive.
	CTI_CTITRIGINSTATUS_DWTCOMPOUT2_Inactive = 0x0
	// Position of UNUSED0 field.
	CTI_CTITRIGINSTATUS_UNUSED0_Pos = 0x4
	// Bit mask of UNUSED0 field.
	CTI_CTITRIGINSTATUS_UNUSED0_Msk = 0x10
	// Bit UNUSED0.
	CTI_CTITRIGINSTATUS_UNUSED0 = 0x10
	// Ctitrigin 4 is active.
	CTI_CTITRIGINSTATUS_UNUSED0_Active = 0x1
	// Ctitrigin 4 is inactive.
	CTI_CTITRIGINSTATUS_UNUSED0_Inactive = 0x0
	// Position of UNUSED1 field.
	CTI_CTITRIGINSTATUS_UNUSED1_Pos = 0x5
	// Bit mask of UNUSED1 field.
	CTI_CTITRIGINSTATUS_UNUSED1_Msk = 0x20
	// Bit UNUSED1.
	CTI_CTITRIGINSTATUS_UNUSED1 = 0x20
	// Ctitrigin 5 is active.
	CTI_CTITRIGINSTATUS_UNUSED1_Active = 0x1
	// Ctitrigin 5 is inactive.
	CTI_CTITRIGINSTATUS_UNUSED1_Inactive = 0x0
	// Position of UNUSED2 field.
	CTI_CTITRIGINSTATUS_UNUSED2_Pos = 0x6
	// Bit mask of UNUSED2 field.
	CTI_CTITRIGINSTATUS_UNUSED2_Msk = 0x40
	// Bit UNUSED2.
	CTI_CTITRIGINSTATUS_UNUSED2 = 0x40
	// Ctitrigin 6 is active.
	CTI_CTITRIGINSTATUS_UNUSED2_Active = 0x1
	// Ctitrigin 6 is inactive.
	CTI_CTITRIGINSTATUS_UNUSED2_Inactive = 0x0
	// Position of UNUSED3 field.
	CTI_CTITRIGINSTATUS_UNUSED3_Pos = 0x7
	// Bit mask of UNUSED3 field.
	CTI_CTITRIGINSTATUS_UNUSED3_Msk = 0x80
	// Bit UNUSED3.
	CTI_CTITRIGINSTATUS_UNUSED3 = 0x80
	// Ctitrigin 7 is active.
	CTI_CTITRIGINSTATUS_UNUSED3_Active = 0x1
	// Ctitrigin 7 is inactive.
	CTI_CTITRIGINSTATUS_UNUSED3_Inactive = 0x0

	// CTITRIGOUTSTATUS: CTI Trigger Out Status register
	// Position of DEBUGREQ field.
	CTI_CTITRIGOUTSTATUS_DEBUGREQ_Pos = 0x0
	// Bit mask of DEBUGREQ field.
	CTI_CTITRIGOUTSTATUS_DEBUGREQ_Msk = 0x1
	// Bit DEBUGREQ.
	CTI_CTITRIGOUTSTATUS_DEBUGREQ = 0x1
	// Ctitrigout 0 is active.
	CTI_CTITRIGOUTSTATUS_DEBUGREQ_Active = 0x1
	// Ctitrigout 0 is inactive.
	CTI_CTITRIGOUTSTATUS_DEBUGREQ_Inactive = 0x0
	// Position of CPURESTART field.
	CTI_CTITRIGOUTSTATUS_CPURESTART_Pos = 0x1
	// Bit mask of CPURESTART field.
	CTI_CTITRIGOUTSTATUS_CPURESTART_Msk = 0x2
	// Bit CPURESTART.
	CTI_CTITRIGOUTSTATUS_CPURESTART = 0x2
	// Ctitrigout 1 is active.
	CTI_CTITRIGOUTSTATUS_CPURESTART_Active = 0x1
	// Ctitrigout 1 is inactive.
	CTI_CTITRIGOUTSTATUS_CPURESTART_Inactive = 0x0
	// Position of UNUSED0 field.
	CTI_CTITRIGOUTSTATUS_UNUSED0_Pos = 0x2
	// Bit mask of UNUSED0 field.
	CTI_CTITRIGOUTSTATUS_UNUSED0_Msk = 0x4
	// Bit UNUSED0.
	CTI_CTITRIGOUTSTATUS_UNUSED0 = 0x4
	// Ctitrigout 2 is active.
	CTI_CTITRIGOUTSTATUS_UNUSED0_Active = 0x1
	// Ctitrigout 2 is inactive.
	CTI_CTITRIGOUTSTATUS_UNUSED0_Inactive = 0x0
	// Position of UNUSED1 field.
	CTI_CTITRIGOUTSTATUS_UNUSED1_Pos = 0x3
	// Bit mask of UNUSED1 field.
	CTI_CTITRIGOUTSTATUS_UNUSED1_Msk = 0x8
	// Bit UNUSED1.
	CTI_CTITRIGOUTSTATUS_UNUSED1 = 0x8
	// Ctitrigout 3 is active.
	CTI_CTITRIGOUTSTATUS_UNUSED1_Active = 0x1
	// Ctitrigout 3 is inactive.
	CTI_CTITRIGOUTSTATUS_UNUSED1_Inactive = 0x0
	// Position of UNUSED2 field.
	CTI_CTITRIGOUTSTATUS_UNUSED2_Pos = 0x4
	// Bit mask of UNUSED2 field.
	CTI_CTITRIGOUTSTATUS_UNUSED2_Msk = 0x10
	// Bit UNUSED2.
	CTI_CTITRIGOUTSTATUS_UNUSED2 = 0x10
	// Ctitrigout 4 is active.
	CTI_CTITRIGOUTSTATUS_UNUSED2_Active = 0x1
	// Ctitrigout 4 is inactive.
	CTI_CTITRIGOUTSTATUS_UNUSED2_Inactive = 0x0
	// Position of UNUSED3 field.
	CTI_CTITRIGOUTSTATUS_UNUSED3_Pos = 0x5
	// Bit mask of UNUSED3 field.
	CTI_CTITRIGOUTSTATUS_UNUSED3_Msk = 0x20
	// Bit UNUSED3.
	CTI_CTITRIGOUTSTATUS_UNUSED3 = 0x20
	// Ctitrigout 5 is active.
	CTI_CTITRIGOUTSTATUS_UNUSED3_Active = 0x1
	// Ctitrigout 5 is inactive.
	CTI_CTITRIGOUTSTATUS_UNUSED3_Inactive = 0x0
	// Position of UNUSED4 field.
	CTI_CTITRIGOUTSTATUS_UNUSED4_Pos = 0x6
	// Bit mask of UNUSED4 field.
	CTI_CTITRIGOUTSTATUS_UNUSED4_Msk = 0x40
	// Bit UNUSED4.
	CTI_CTITRIGOUTSTATUS_UNUSED4 = 0x40
	// Ctitrigout 6 is active.
	CTI_CTITRIGOUTSTATUS_UNUSED4_Active = 0x1
	// Ctitrigout 6 is inactive.
	CTI_CTITRIGOUTSTATUS_UNUSED4_Inactive = 0x0
	// Position of UNUSED5 field.
	CTI_CTITRIGOUTSTATUS_UNUSED5_Pos = 0x7
	// Bit mask of UNUSED5 field.
	CTI_CTITRIGOUTSTATUS_UNUSED5_Msk = 0x80
	// Bit UNUSED5.
	CTI_CTITRIGOUTSTATUS_UNUSED5 = 0x80
	// Ctitrigout 7 is active.
	CTI_CTITRIGOUTSTATUS_UNUSED5_Active = 0x1
	// Ctitrigout 7 is inactive.
	CTI_CTITRIGOUTSTATUS_UNUSED5_Inactive = 0x0

	// CTICHINSTATUS: CTI Channel In Status register
	// Position of CTICHINSTATUS_0 field.
	CTI_CTICHINSTATUS_CTICHINSTATUS_0_Pos = 0x0
	// Bit mask of CTICHINSTATUS_0 field.
	CTI_CTICHINSTATUS_CTICHINSTATUS_0_Msk = 0x1
	// Bit CTICHINSTATUS_0.
	CTI_CTICHINSTATUS_CTICHINSTATUS_0 = 0x1
	// Ctichin 0 is active.
	CTI_CTICHINSTATUS_CTICHINSTATUS_0_Active = 0x1
	// Ctichin 0 is inactive.
	CTI_CTICHINSTATUS_CTICHINSTATUS_0_Inactive = 0x0
	// Position of CTICHINSTATUS_1 field.
	CTI_CTICHINSTATUS_CTICHINSTATUS_1_Pos = 0x1
	// Bit mask of CTICHINSTATUS_1 field.
	CTI_CTICHINSTATUS_CTICHINSTATUS_1_Msk = 0x2
	// Bit CTICHINSTATUS_1.
	CTI_CTICHINSTATUS_CTICHINSTATUS_1 = 0x2
	// Ctichin 1 is active.
	CTI_CTICHINSTATUS_CTICHINSTATUS_1_Active = 0x1
	// Ctichin 1 is inactive.
	CTI_CTICHINSTATUS_CTICHINSTATUS_1_Inactive = 0x0
	// Position of CTICHINSTATUS_2 field.
	CTI_CTICHINSTATUS_CTICHINSTATUS_2_Pos = 0x2
	// Bit mask of CTICHINSTATUS_2 field.
	CTI_CTICHINSTATUS_CTICHINSTATUS_2_Msk = 0x4
	// Bit CTICHINSTATUS_2.
	CTI_CTICHINSTATUS_CTICHINSTATUS_2 = 0x4
	// Ctichin 2 is active.
	CTI_CTICHINSTATUS_CTICHINSTATUS_2_Active = 0x1
	// Ctichin 2 is inactive.
	CTI_CTICHINSTATUS_CTICHINSTATUS_2_Inactive = 0x0
	// Position of CTICHINSTATUS_3 field.
	CTI_CTICHINSTATUS_CTICHINSTATUS_3_Pos = 0x3
	// Bit mask of CTICHINSTATUS_3 field.
	CTI_CTICHINSTATUS_CTICHINSTATUS_3_Msk = 0x8
	// Bit CTICHINSTATUS_3.
	CTI_CTICHINSTATUS_CTICHINSTATUS_3 = 0x8
	// Ctichin 3 is active.
	CTI_CTICHINSTATUS_CTICHINSTATUS_3_Active = 0x1
	// Ctichin 3 is inactive.
	CTI_CTICHINSTATUS_CTICHINSTATUS_3_Inactive = 0x0

	// CTIGATE: Enable CTI Channel Gate register
	// Position of CTIGATEEN_0 field.
	CTI_CTIGATE_CTIGATEEN_0_Pos = 0x0
	// Bit mask of CTIGATEEN_0 field.
	CTI_CTIGATE_CTIGATEEN_0_Msk = 0x1
	// Bit CTIGATEEN_0.
	CTI_CTIGATE_CTIGATEEN_0 = 0x1
	// Enable ctichout channel 0 propagation.
	CTI_CTIGATE_CTIGATEEN_0_Enabled = 0x1
	// Disable ctichout channel 0 propagation.
	CTI_CTIGATE_CTIGATEEN_0_Disabled = 0x0
	// Position of CTIGATEEN_1 field.
	CTI_CTIGATE_CTIGATEEN_1_Pos = 0x1
	// Bit mask of CTIGATEEN_1 field.
	CTI_CTIGATE_CTIGATEEN_1_Msk = 0x2
	// Bit CTIGATEEN_1.
	CTI_CTIGATE_CTIGATEEN_1 = 0x2
	// Enable ctichout channel 1 propagation.
	CTI_CTIGATE_CTIGATEEN_1_Enabled = 0x1
	// Disable ctichout channel 1 propagation.
	CTI_CTIGATE_CTIGATEEN_1_Disabled = 0x0
	// Position of CTIGATEEN_2 field.
	CTI_CTIGATE_CTIGATEEN_2_Pos = 0x2
	// Bit mask of CTIGATEEN_2 field.
	CTI_CTIGATE_CTIGATEEN_2_Msk = 0x4
	// Bit CTIGATEEN_2.
	CTI_CTIGATE_CTIGATEEN_2 = 0x4
	// Enable ctichout channel 2 propagation.
	CTI_CTIGATE_CTIGATEEN_2_Enabled = 0x1
	// Disable ctichout channel 2 propagation.
	CTI_CTIGATE_CTIGATEEN_2_Disabled = 0x0
	// Position of CTIGATEEN_3 field.
	CTI_CTIGATE_CTIGATEEN_3_Pos = 0x3
	// Bit mask of CTIGATEEN_3 field.
	CTI_CTIGATE_CTIGATEEN_3_Msk = 0x8
	// Bit CTIGATEEN_3.
	CTI_CTIGATE_CTIGATEEN_3 = 0x8
	// Enable ctichout channel 3 propagation.
	CTI_CTIGATE_CTIGATEEN_3_Enabled = 0x1
	// Disable ctichout channel 3 propagation.
	CTI_CTIGATE_CTIGATEEN_3_Disabled = 0x0

	// DEVARCH: Device Architecture register
	// Position of Architecture field.
	CTI_DEVARCH_Architecture_Pos = 0x0
	// Bit mask of Architecture field.
	CTI_DEVARCH_Architecture_Msk = 0x1
	// Bit Architecture.
	CTI_DEVARCH_Architecture = 0x1

	// DEVID: Device Configuration register
	// Position of EXTMUXNUM field.
	CTI_DEVID_EXTMUXNUM_Pos = 0x0
	// Bit mask of EXTMUXNUM field.
	CTI_DEVID_EXTMUXNUM_Msk = 0x1f
	// Position of NUMTRIG field.
	CTI_DEVID_NUMTRIG_Pos = 0x8
	// Bit mask of NUMTRIG field.
	CTI_DEVID_NUMTRIG_Msk = 0xff00
	// Position of NUMCH field.
	CTI_DEVID_NUMCH_Pos = 0x10
	// Bit mask of NUMCH field.
	CTI_DEVID_NUMCH_Msk = 0xf0000

	// DEVTYPE: Device Type Identifier register
	// Position of MAJOR field.
	CTI_DEVTYPE_MAJOR_Pos = 0x0
	// Bit mask of MAJOR field.
	CTI_DEVTYPE_MAJOR_Msk = 0xf
	// Indicates that this component allows a debugger to control other components in a CoreSight SoC-400 system.
	CTI_DEVTYPE_MAJOR_Controller = 0x4
	// Position of SUB field.
	CTI_DEVTYPE_SUB_Pos = 0x4
	// Bit mask of SUB field.
	CTI_DEVTYPE_SUB_Msk = 0xf0
	// Indicates that this component is a sub-triggering component.
	CTI_DEVTYPE_SUB_Crosstrigger = 0x1

	// PIDR4: Peripheral ID4 Register
	// Position of DES_2 field.
	CTI_PIDR4_DES_2_Pos = 0x0
	// Bit mask of DES_2 field.
	CTI_PIDR4_DES_2_Msk = 0xf
	// JEDEC continuation code
	CTI_PIDR4_DES_2_Code = 0x4
	// Position of SIZE field.
	CTI_PIDR4_SIZE_Pos = 0x4
	// Bit mask of SIZE field.
	CTI_PIDR4_SIZE_Msk = 0xf0

	// PIDR0: Peripheral ID0 Register
	// Position of PART_0 field.
	CTI_PIDR0_PART_0_Pos = 0x0
	// Bit mask of PART_0 field.
	CTI_PIDR0_PART_0_Msk = 0xff
	// Indicates bits[7:0] of the part number of the component.
	CTI_PIDR0_PART_0_PartnumberL = 0x21

	// PIDR1: Peripheral ID1 Register
	// Position of PART_1 field.
	CTI_PIDR1_PART_1_Pos = 0x0
	// Bit mask of PART_1 field.
	CTI_PIDR1_PART_1_Msk = 0xf
	// Indicates bits[11:8] of the part number of the component.
	CTI_PIDR1_PART_1_PartnumberH = 0xd
	// Position of DES_0 field.
	CTI_PIDR1_DES_0_Pos = 0x4
	// Bit mask of DES_0 field.
	CTI_PIDR1_DES_0_Msk = 0xf0
	// ARM. Bits[3:0] of the JEDEC JEP106 Identity Code
	CTI_PIDR1_DES_0_Arm = 0xb

	// PIDR2: Peripheral ID2 Register
	// Position of DES_1 field.
	CTI_PIDR2_DES_1_Pos = 0x0
	// Bit mask of DES_1 field.
	CTI_PIDR2_DES_1_Msk = 0x7
	// ARM. Bits[6:4] of the JEDEC JEP106 Identity Code
	CTI_PIDR2_DES_1_Arm = 0x3
	// Position of JEDEC field.
	CTI_PIDR2_JEDEC_Pos = 0x3
	// Bit mask of JEDEC field.
	CTI_PIDR2_JEDEC_Msk = 0x8
	// Bit JEDEC.
	CTI_PIDR2_JEDEC = 0x8
	// Position of REVISION field.
	CTI_PIDR2_REVISION_Pos = 0x4
	// Bit mask of REVISION field.
	CTI_PIDR2_REVISION_Msk = 0xf0
	// This device is at r0p0
	CTI_PIDR2_REVISION_Rev0p0 = 0x0

	// PIDR3: Peripheral ID3 Register
	// Position of CMOD field.
	CTI_PIDR3_CMOD_Pos = 0x0
	// Bit mask of CMOD field.
	CTI_PIDR3_CMOD_Msk = 0xf
	// Indicates that the customer has not modified this component.
	CTI_PIDR3_CMOD_Unmodified = 0x0
	// Position of REVAND field.
	CTI_PIDR3_REVAND_Pos = 0x4
	// Bit mask of REVAND field.
	CTI_PIDR3_REVAND_Msk = 0xf0
	// Indicates that there are no errata fixes to this component.
	CTI_PIDR3_REVAND_NoErrata = 0x0

	// CIDR0: Component ID0 Register
	// Position of PRMBL_0 field.
	CTI_CIDR0_PRMBL_0_Pos = 0x0
	// Bit mask of PRMBL_0 field.
	CTI_CIDR0_PRMBL_0_Msk = 0xff
	// Bits[7:0] of the identification code.
	CTI_CIDR0_PRMBL_0_Value = 0xd

	// CIDR1: Component ID1 Register
	// Position of PRMBL_1 field.
	CTI_CIDR1_PRMBL_1_Pos = 0x0
	// Bit mask of PRMBL_1 field.
	CTI_CIDR1_PRMBL_1_Msk = 0xf
	// Bits[11:8] of the identification code.
	CTI_CIDR1_PRMBL_1_Value = 0x0
	// Position of CLASS field.
	CTI_CIDR1_CLASS_Pos = 0x4
	// Bit mask of CLASS field.
	CTI_CIDR1_CLASS_Msk = 0xf0
	// Indicates that the component is a CoreSight component.
	CTI_CIDR1_CLASS_Coresight = 0x9

	// CIDR2: Component ID2 Register
	// Position of PRMBL_2 field.
	CTI_CIDR2_PRMBL_2_Pos = 0x0
	// Bit mask of PRMBL_2 field.
	CTI_CIDR2_PRMBL_2_Msk = 0xff
	// Bits[23:16] of the identification code.
	CTI_CIDR2_PRMBL_2_Value = 0x5

	// CIDR3: Component ID3 Register
	// Position of PRMBL_3 field.
	CTI_CIDR3_PRMBL_3_Pos = 0x0
	// Bit mask of PRMBL_3 field.
	CTI_CIDR3_PRMBL_3_Msk = 0xff
	// Bits[31:24] of the identification code.
	CTI_CIDR3_PRMBL_3_Value = 0xb1
)

// Bitfields for DCNF_NS: Domain configuration management
const (
	// CPUID: CPU ID of this subsystem
	// Position of CPUID field.
	DCNF_CPUID_CPUID_Pos = 0x0
	// Bit mask of CPUID field.
	DCNF_CPUID_CPUID_Msk = 0xff
)

// Bitfields for VREQCTRL_NS: Voltage request control
const (
	// VREGRADIO.VREQH: Request high voltage on RADIO After requesting high voltage, the user must wait until VREQHREADY is set to Ready
	// Position of VREQH field.
	VREQCTRL_VREGRADIO_VREQH_VREQH_Pos = 0x0
	// Bit mask of VREQH field.
	VREQCTRL_VREGRADIO_VREQH_VREQH_Msk = 0x1
	// Bit VREQH.
	VREQCTRL_VREGRADIO_VREQH_VREQH = 0x1
	// Disable
	VREQCTRL_VREGRADIO_VREQH_VREQH_Disabled = 0x0
	// Enable
	VREQCTRL_VREGRADIO_VREQH_VREQH_Enabled = 0x1

	// VREGRADIO.VREQHREADY: High voltage on RADIO is ready
	// Position of READY field.
	VREQCTRL_VREGRADIO_VREQHREADY_READY_Pos = 0x0
	// Bit mask of READY field.
	VREQCTRL_VREGRADIO_VREQHREADY_READY_Msk = 0x1
	// Bit READY.
	VREQCTRL_VREGRADIO_VREQHREADY_READY = 0x1
	// Not ready
	VREQCTRL_VREGRADIO_VREQHREADY_READY_NotReady = 0x0
	// Ready
	VREQCTRL_VREGRADIO_VREQHREADY_READY_Ready = 0x1
)

// Bitfields for CLOCK_NS: Clock management
const (
	// TASKS_HFCLKSTART: Start HFCLK128M/HFCLK64M source as selected in HFCLKSRC
	// Position of TASKS_HFCLKSTART field.
	CLOCK_TASKS_HFCLKSTART_TASKS_HFCLKSTART_Pos = 0x0
	// Bit mask of TASKS_HFCLKSTART field.
	CLOCK_TASKS_HFCLKSTART_TASKS_HFCLKSTART_Msk = 0x1
	// Bit TASKS_HFCLKSTART.
	CLOCK_TASKS_HFCLKSTART_TASKS_HFCLKSTART = 0x1
	// Trigger task
	CLOCK_TASKS_HFCLKSTART_TASKS_HFCLKSTART_Trigger = 0x1

	// TASKS_HFCLKSTOP: Stop HFCLK128M/HFCLK64M source
	// Position of TASKS_HFCLKSTOP field.
	CLOCK_TASKS_HFCLKSTOP_TASKS_HFCLKSTOP_Pos = 0x0
	// Bit mask of TASKS_HFCLKSTOP field.
	CLOCK_TASKS_HFCLKSTOP_TASKS_HFCLKSTOP_Msk = 0x1
	// Bit TASKS_HFCLKSTOP.
	CLOCK_TASKS_HFCLKSTOP_TASKS_HFCLKSTOP = 0x1
	// Trigger task
	CLOCK_TASKS_HFCLKSTOP_TASKS_HFCLKSTOP_Trigger = 0x1

	// TASKS_LFCLKSTART: Start LFCLK source as selected in LFCLKSRC
	// Position of TASKS_LFCLKSTART field.
	CLOCK_TASKS_LFCLKSTART_TASKS_LFCLKSTART_Pos = 0x0
	// Bit mask of TASKS_LFCLKSTART field.
	CLOCK_TASKS_LFCLKSTART_TASKS_LFCLKSTART_Msk = 0x1
	// Bit TASKS_LFCLKSTART.
	CLOCK_TASKS_LFCLKSTART_TASKS_LFCLKSTART = 0x1
	// Trigger task
	CLOCK_TASKS_LFCLKSTART_TASKS_LFCLKSTART_Trigger = 0x1

	// TASKS_LFCLKSTOP: Stop LFCLK source
	// Position of TASKS_LFCLKSTOP field.
	CLOCK_TASKS_LFCLKSTOP_TASKS_LFCLKSTOP_Pos = 0x0
	// Bit mask of TASKS_LFCLKSTOP field.
	CLOCK_TASKS_LFCLKSTOP_TASKS_LFCLKSTOP_Msk = 0x1
	// Bit TASKS_LFCLKSTOP.
	CLOCK_TASKS_LFCLKSTOP_TASKS_LFCLKSTOP = 0x1
	// Trigger task
	CLOCK_TASKS_LFCLKSTOP_TASKS_LFCLKSTOP_Trigger = 0x1

	// TASKS_CAL: Start calibration of LFRC oscillator
	// Position of TASKS_CAL field.
	CLOCK_TASKS_CAL_TASKS_CAL_Pos = 0x0
	// Bit mask of TASKS_CAL field.
	CLOCK_TASKS_CAL_TASKS_CAL_Msk = 0x1
	// Bit TASKS_CAL.
	CLOCK_TASKS_CAL_TASKS_CAL = 0x1
	// Trigger task
	CLOCK_TASKS_CAL_TASKS_CAL_Trigger = 0x1

	// SUBSCRIBE_HFCLKSTART: Subscribe configuration for task HFCLKSTART
	// Position of CHIDX field.
	CLOCK_SUBSCRIBE_HFCLKSTART_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	CLOCK_SUBSCRIBE_HFCLKSTART_CHIDX_Msk = 0xff
	// Position of EN field.
	CLOCK_SUBSCRIBE_HFCLKSTART_EN_Pos = 0x1f
	// Bit mask of EN field.
	CLOCK_SUBSCRIBE_HFCLKSTART_EN_Msk = 0x80000000
	// Bit EN.
	CLOCK_SUBSCRIBE_HFCLKSTART_EN = 0x80000000
	// Disable subscription
	CLOCK_SUBSCRIBE_HFCLKSTART_EN_Disabled = 0x0
	// Enable subscription
	CLOCK_SUBSCRIBE_HFCLKSTART_EN_Enabled = 0x1

	// SUBSCRIBE_HFCLKSTOP: Subscribe configuration for task HFCLKSTOP
	// Position of CHIDX field.
	CLOCK_SUBSCRIBE_HFCLKSTOP_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	CLOCK_SUBSCRIBE_HFCLKSTOP_CHIDX_Msk = 0xff
	// Position of EN field.
	CLOCK_SUBSCRIBE_HFCLKSTOP_EN_Pos = 0x1f
	// Bit mask of EN field.
	CLOCK_SUBSCRIBE_HFCLKSTOP_EN_Msk = 0x80000000
	// Bit EN.
	CLOCK_SUBSCRIBE_HFCLKSTOP_EN = 0x80000000
	// Disable subscription
	CLOCK_SUBSCRIBE_HFCLKSTOP_EN_Disabled = 0x0
	// Enable subscription
	CLOCK_SUBSCRIBE_HFCLKSTOP_EN_Enabled = 0x1

	// SUBSCRIBE_LFCLKSTART: Subscribe configuration for task LFCLKSTART
	// Position of CHIDX field.
	CLOCK_SUBSCRIBE_LFCLKSTART_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	CLOCK_SUBSCRIBE_LFCLKSTART_CHIDX_Msk = 0xff
	// Position of EN field.
	CLOCK_SUBSCRIBE_LFCLKSTART_EN_Pos = 0x1f
	// Bit mask of EN field.
	CLOCK_SUBSCRIBE_LFCLKSTART_EN_Msk = 0x80000000
	// Bit EN.
	CLOCK_SUBSCRIBE_LFCLKSTART_EN = 0x80000000
	// Disable subscription
	CLOCK_SUBSCRIBE_LFCLKSTART_EN_Disabled = 0x0
	// Enable subscription
	CLOCK_SUBSCRIBE_LFCLKSTART_EN_Enabled = 0x1

	// SUBSCRIBE_LFCLKSTOP: Subscribe configuration for task LFCLKSTOP
	// Position of CHIDX field.
	CLOCK_SUBSCRIBE_LFCLKSTOP_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	CLOCK_SUBSCRIBE_LFCLKSTOP_CHIDX_Msk = 0xff
	// Position of EN field.
	CLOCK_SUBSCRIBE_LFCLKSTOP_EN_Pos = 0x1f
	// Bit mask of EN field.
	CLOCK_SUBSCRIBE_LFCLKSTOP_EN_Msk = 0x80000000
	// Bit EN.
	CLOCK_SUBSCRIBE_LFCLKSTOP_EN = 0x80000000
	// Disable subscription
	CLOCK_SUBSCRIBE_LFCLKSTOP_EN_Disabled = 0x0
	// Enable subscription
	CLOCK_SUBSCRIBE_LFCLKSTOP_EN_Enabled = 0x1

	// SUBSCRIBE_CAL: Subscribe configuration for task CAL
	// Position of CHIDX field.
	CLOCK_SUBSCRIBE_CAL_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	CLOCK_SUBSCRIBE_CAL_CHIDX_Msk = 0xff
	// Position of EN field.
	CLOCK_SUBSCRIBE_CAL_EN_Pos = 0x1f
	// Bit mask of EN field.
	CLOCK_SUBSCRIBE_CAL_EN_Msk = 0x80000000
	// Bit EN.
	CLOCK_SUBSCRIBE_CAL_EN = 0x80000000
	// Disable subscription
	CLOCK_SUBSCRIBE_CAL_EN_Disabled = 0x0
	// Enable subscription
	CLOCK_SUBSCRIBE_CAL_EN_Enabled = 0x1

	// EVENTS_HFCLKSTARTED: HFCLK128M/HFCLK64M source started
	// Position of EVENTS_HFCLKSTARTED field.
	CLOCK_EVENTS_HFCLKSTARTED_EVENTS_HFCLKSTARTED_Pos = 0x0
	// Bit mask of EVENTS_HFCLKSTARTED field.
	CLOCK_EVENTS_HFCLKSTARTED_EVENTS_HFCLKSTARTED_Msk = 0x1
	// Bit EVENTS_HFCLKSTARTED.
	CLOCK_EVENTS_HFCLKSTARTED_EVENTS_HFCLKSTARTED = 0x1
	// Event not generated
	CLOCK_EVENTS_HFCLKSTARTED_EVENTS_HFCLKSTARTED_NotGenerated = 0x0
	// Event generated
	CLOCK_EVENTS_HFCLKSTARTED_EVENTS_HFCLKSTARTED_Generated = 0x1

	// EVENTS_LFCLKSTARTED: LFCLK source started
	// Position of EVENTS_LFCLKSTARTED field.
	CLOCK_EVENTS_LFCLKSTARTED_EVENTS_LFCLKSTARTED_Pos = 0x0
	// Bit mask of EVENTS_LFCLKSTARTED field.
	CLOCK_EVENTS_LFCLKSTARTED_EVENTS_LFCLKSTARTED_Msk = 0x1
	// Bit EVENTS_LFCLKSTARTED.
	CLOCK_EVENTS_LFCLKSTARTED_EVENTS_LFCLKSTARTED = 0x1
	// Event not generated
	CLOCK_EVENTS_LFCLKSTARTED_EVENTS_LFCLKSTARTED_NotGenerated = 0x0
	// Event generated
	CLOCK_EVENTS_LFCLKSTARTED_EVENTS_LFCLKSTARTED_Generated = 0x1

	// EVENTS_DONE: Calibration of LFRC oscillator complete event
	// Position of EVENTS_DONE field.
	CLOCK_EVENTS_DONE_EVENTS_DONE_Pos = 0x0
	// Bit mask of EVENTS_DONE field.
	CLOCK_EVENTS_DONE_EVENTS_DONE_Msk = 0x1
	// Bit EVENTS_DONE.
	CLOCK_EVENTS_DONE_EVENTS_DONE = 0x1
	// Event not generated
	CLOCK_EVENTS_DONE_EVENTS_DONE_NotGenerated = 0x0
	// Event generated
	CLOCK_EVENTS_DONE_EVENTS_DONE_Generated = 0x1

	// PUBLISH_HFCLKSTARTED: Publish configuration for event HFCLKSTARTED
	// Position of CHIDX field.
	CLOCK_PUBLISH_HFCLKSTARTED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	CLOCK_PUBLISH_HFCLKSTARTED_CHIDX_Msk = 0xff
	// Position of EN field.
	CLOCK_PUBLISH_HFCLKSTARTED_EN_Pos = 0x1f
	// Bit mask of EN field.
	CLOCK_PUBLISH_HFCLKSTARTED_EN_Msk = 0x80000000
	// Bit EN.
	CLOCK_PUBLISH_HFCLKSTARTED_EN = 0x80000000
	// Disable publishing
	CLOCK_PUBLISH_HFCLKSTARTED_EN_Disabled = 0x0
	// Enable publishing
	CLOCK_PUBLISH_HFCLKSTARTED_EN_Enabled = 0x1

	// PUBLISH_LFCLKSTARTED: Publish configuration for event LFCLKSTARTED
	// Position of CHIDX field.
	CLOCK_PUBLISH_LFCLKSTARTED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	CLOCK_PUBLISH_LFCLKSTARTED_CHIDX_Msk = 0xff
	// Position of EN field.
	CLOCK_PUBLISH_LFCLKSTARTED_EN_Pos = 0x1f
	// Bit mask of EN field.
	CLOCK_PUBLISH_LFCLKSTARTED_EN_Msk = 0x80000000
	// Bit EN.
	CLOCK_PUBLISH_LFCLKSTARTED_EN = 0x80000000
	// Disable publishing
	CLOCK_PUBLISH_LFCLKSTARTED_EN_Disabled = 0x0
	// Enable publishing
	CLOCK_PUBLISH_LFCLKSTARTED_EN_Enabled = 0x1

	// PUBLISH_DONE: Publish configuration for event DONE
	// Position of CHIDX field.
	CLOCK_PUBLISH_DONE_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	CLOCK_PUBLISH_DONE_CHIDX_Msk = 0xff
	// Position of EN field.
	CLOCK_PUBLISH_DONE_EN_Pos = 0x1f
	// Bit mask of EN field.
	CLOCK_PUBLISH_DONE_EN_Msk = 0x80000000
	// Bit EN.
	CLOCK_PUBLISH_DONE_EN = 0x80000000
	// Disable publishing
	CLOCK_PUBLISH_DONE_EN_Disabled = 0x0
	// Enable publishing
	CLOCK_PUBLISH_DONE_EN_Enabled = 0x1

	// INTEN: Enable or disable interrupt
	// Position of HFCLKSTARTED field.
	CLOCK_INTEN_HFCLKSTARTED_Pos = 0x0
	// Bit mask of HFCLKSTARTED field.
	CLOCK_INTEN_HFCLKSTARTED_Msk = 0x1
	// Bit HFCLKSTARTED.
	CLOCK_INTEN_HFCLKSTARTED = 0x1
	// Disable
	CLOCK_INTEN_HFCLKSTARTED_Disabled = 0x0
	// Enable
	CLOCK_INTEN_HFCLKSTARTED_Enabled = 0x1
	// Position of LFCLKSTARTED field.
	CLOCK_INTEN_LFCLKSTARTED_Pos = 0x1
	// Bit mask of LFCLKSTARTED field.
	CLOCK_INTEN_LFCLKSTARTED_Msk = 0x2
	// Bit LFCLKSTARTED.
	CLOCK_INTEN_LFCLKSTARTED = 0x2
	// Disable
	CLOCK_INTEN_LFCLKSTARTED_Disabled = 0x0
	// Enable
	CLOCK_INTEN_LFCLKSTARTED_Enabled = 0x1
	// Position of DONE field.
	CLOCK_INTEN_DONE_Pos = 0x7
	// Bit mask of DONE field.
	CLOCK_INTEN_DONE_Msk = 0x80
	// Bit DONE.
	CLOCK_INTEN_DONE = 0x80
	// Disable
	CLOCK_INTEN_DONE_Disabled = 0x0
	// Enable
	CLOCK_INTEN_DONE_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of HFCLKSTARTED field.
	CLOCK_INTENSET_HFCLKSTARTED_Pos = 0x0
	// Bit mask of HFCLKSTARTED field.
	CLOCK_INTENSET_HFCLKSTARTED_Msk = 0x1
	// Bit HFCLKSTARTED.
	CLOCK_INTENSET_HFCLKSTARTED = 0x1
	// Read: Disabled
	CLOCK_INTENSET_HFCLKSTARTED_Disabled = 0x0
	// Read: Enabled
	CLOCK_INTENSET_HFCLKSTARTED_Enabled = 0x1
	// Enable
	CLOCK_INTENSET_HFCLKSTARTED_Set = 0x1
	// Position of LFCLKSTARTED field.
	CLOCK_INTENSET_LFCLKSTARTED_Pos = 0x1
	// Bit mask of LFCLKSTARTED field.
	CLOCK_INTENSET_LFCLKSTARTED_Msk = 0x2
	// Bit LFCLKSTARTED.
	CLOCK_INTENSET_LFCLKSTARTED = 0x2
	// Read: Disabled
	CLOCK_INTENSET_LFCLKSTARTED_Disabled = 0x0
	// Read: Enabled
	CLOCK_INTENSET_LFCLKSTARTED_Enabled = 0x1
	// Enable
	CLOCK_INTENSET_LFCLKSTARTED_Set = 0x1
	// Position of DONE field.
	CLOCK_INTENSET_DONE_Pos = 0x7
	// Bit mask of DONE field.
	CLOCK_INTENSET_DONE_Msk = 0x80
	// Bit DONE.
	CLOCK_INTENSET_DONE = 0x80
	// Read: Disabled
	CLOCK_INTENSET_DONE_Disabled = 0x0
	// Read: Enabled
	CLOCK_INTENSET_DONE_Enabled = 0x1
	// Enable
	CLOCK_INTENSET_DONE_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of HFCLKSTARTED field.
	CLOCK_INTENCLR_HFCLKSTARTED_Pos = 0x0
	// Bit mask of HFCLKSTARTED field.
	CLOCK_INTENCLR_HFCLKSTARTED_Msk = 0x1
	// Bit HFCLKSTARTED.
	CLOCK_INTENCLR_HFCLKSTARTED = 0x1
	// Read: Disabled
	CLOCK_INTENCLR_HFCLKSTARTED_Disabled = 0x0
	// Read: Enabled
	CLOCK_INTENCLR_HFCLKSTARTED_Enabled = 0x1
	// Disable
	CLOCK_INTENCLR_HFCLKSTARTED_Clear = 0x1
	// Position of LFCLKSTARTED field.
	CLOCK_INTENCLR_LFCLKSTARTED_Pos = 0x1
	// Bit mask of LFCLKSTARTED field.
	CLOCK_INTENCLR_LFCLKSTARTED_Msk = 0x2
	// Bit LFCLKSTARTED.
	CLOCK_INTENCLR_LFCLKSTARTED = 0x2
	// Read: Disabled
	CLOCK_INTENCLR_LFCLKSTARTED_Disabled = 0x0
	// Read: Enabled
	CLOCK_INTENCLR_LFCLKSTARTED_Enabled = 0x1
	// Disable
	CLOCK_INTENCLR_LFCLKSTARTED_Clear = 0x1
	// Position of DONE field.
	CLOCK_INTENCLR_DONE_Pos = 0x7
	// Bit mask of DONE field.
	CLOCK_INTENCLR_DONE_Msk = 0x80
	// Bit DONE.
	CLOCK_INTENCLR_DONE = 0x80
	// Read: Disabled
	CLOCK_INTENCLR_DONE_Disabled = 0x0
	// Read: Enabled
	CLOCK_INTENCLR_DONE_Enabled = 0x1
	// Disable
	CLOCK_INTENCLR_DONE_Clear = 0x1

	// INTPEND: Pending interrupts
	// Position of HFCLKSTARTED field.
	CLOCK_INTPEND_HFCLKSTARTED_Pos = 0x0
	// Bit mask of HFCLKSTARTED field.
	CLOCK_INTPEND_HFCLKSTARTED_Msk = 0x1
	// Bit HFCLKSTARTED.
	CLOCK_INTPEND_HFCLKSTARTED = 0x1
	// Read: Not pending
	CLOCK_INTPEND_HFCLKSTARTED_NotPending = 0x0
	// Read: Pending
	CLOCK_INTPEND_HFCLKSTARTED_Pending = 0x1
	// Position of LFCLKSTARTED field.
	CLOCK_INTPEND_LFCLKSTARTED_Pos = 0x1
	// Bit mask of LFCLKSTARTED field.
	CLOCK_INTPEND_LFCLKSTARTED_Msk = 0x2
	// Bit LFCLKSTARTED.
	CLOCK_INTPEND_LFCLKSTARTED = 0x2
	// Read: Not pending
	CLOCK_INTPEND_LFCLKSTARTED_NotPending = 0x0
	// Read: Pending
	CLOCK_INTPEND_LFCLKSTARTED_Pending = 0x1
	// Position of DONE field.
	CLOCK_INTPEND_DONE_Pos = 0x7
	// Bit mask of DONE field.
	CLOCK_INTPEND_DONE_Msk = 0x80
	// Bit DONE.
	CLOCK_INTPEND_DONE = 0x80
	// Read: Not pending
	CLOCK_INTPEND_DONE_NotPending = 0x0
	// Read: Pending
	CLOCK_INTPEND_DONE_Pending = 0x1

	// HFCLKRUN: Status indicating that HFCLKSTART task has been triggered
	// Position of STATUS field.
	CLOCK_HFCLKRUN_STATUS_Pos = 0x0
	// Bit mask of STATUS field.
	CLOCK_HFCLKRUN_STATUS_Msk = 0x1
	// Bit STATUS.
	CLOCK_HFCLKRUN_STATUS = 0x1
	// Task not triggered
	CLOCK_HFCLKRUN_STATUS_NotTriggered = 0x0
	// Task triggered
	CLOCK_HFCLKRUN_STATUS_Triggered = 0x1

	// HFCLKSTAT: Status indicating which HFCLK128M/HFCLK64M source is running This register value in any CLOCK instance reflects status only due to configurations/actions in that CLOCK instance.
	// Position of SRC field.
	CLOCK_HFCLKSTAT_SRC_Pos = 0x0
	// Bit mask of SRC field.
	CLOCK_HFCLKSTAT_SRC_Msk = 0x1
	// Bit SRC.
	CLOCK_HFCLKSTAT_SRC = 0x1
	// Clock source: HFINT - 128 MHz on-chip oscillator
	CLOCK_HFCLKSTAT_SRC_HFINT = 0x0
	// Clock source: HFXO - 128 MHz clock derived from external 32 MHz crystal oscillator
	CLOCK_HFCLKSTAT_SRC_HFXO = 0x1
	// Position of ALWAYSRUNNING field.
	CLOCK_HFCLKSTAT_ALWAYSRUNNING_Pos = 0x4
	// Bit mask of ALWAYSRUNNING field.
	CLOCK_HFCLKSTAT_ALWAYSRUNNING_Msk = 0x10
	// Bit ALWAYSRUNNING.
	CLOCK_HFCLKSTAT_ALWAYSRUNNING = 0x10
	// Automatic clock control enabled
	CLOCK_HFCLKSTAT_ALWAYSRUNNING_NotRunning = 0x0
	// Oscillator is always running
	CLOCK_HFCLKSTAT_ALWAYSRUNNING_Running = 0x1
	// Position of STATE field.
	CLOCK_HFCLKSTAT_STATE_Pos = 0x10
	// Bit mask of STATE field.
	CLOCK_HFCLKSTAT_STATE_Msk = 0x10000
	// Bit STATE.
	CLOCK_HFCLKSTAT_STATE = 0x10000
	// HFCLK not running
	CLOCK_HFCLKSTAT_STATE_NotRunning = 0x0
	// HFCLK running
	CLOCK_HFCLKSTAT_STATE_Running = 0x1

	// LFCLKRUN: Status indicating that LFCLKSTART task has been triggered
	// Position of STATUS field.
	CLOCK_LFCLKRUN_STATUS_Pos = 0x0
	// Bit mask of STATUS field.
	CLOCK_LFCLKRUN_STATUS_Msk = 0x1
	// Bit STATUS.
	CLOCK_LFCLKRUN_STATUS = 0x1
	// Task not triggered
	CLOCK_LFCLKRUN_STATUS_NotTriggered = 0x0
	// Task triggered
	CLOCK_LFCLKRUN_STATUS_Triggered = 0x1

	// LFCLKSTAT: Status indicating which LFCLK source is running This register value in any CLOCK instance reflects status only due to configurations/actions in that CLOCK instance.
	// Position of SRC field.
	CLOCK_LFCLKSTAT_SRC_Pos = 0x0
	// Bit mask of SRC field.
	CLOCK_LFCLKSTAT_SRC_Msk = 0x3
	// 32.768 kHz ultra-low power RC oscillator
	CLOCK_LFCLKSTAT_SRC_LFULP = 0x0
	// 32.768 kHz RC oscillator
	CLOCK_LFCLKSTAT_SRC_LFRC = 0x1
	// 32.768 kHz crystal oscillator
	CLOCK_LFCLKSTAT_SRC_LFXO = 0x2
	// 32.768 kHz synthesized from HFCLK
	CLOCK_LFCLKSTAT_SRC_LFSYNT = 0x3
	// Position of ALWAYSRUNNING field.
	CLOCK_LFCLKSTAT_ALWAYSRUNNING_Pos = 0x4
	// Bit mask of ALWAYSRUNNING field.
	CLOCK_LFCLKSTAT_ALWAYSRUNNING_Msk = 0x10
	// Bit ALWAYSRUNNING.
	CLOCK_LFCLKSTAT_ALWAYSRUNNING = 0x10
	// Automatic clock control enabled
	CLOCK_LFCLKSTAT_ALWAYSRUNNING_NotRunning = 0x0
	// Oscillator is always running
	CLOCK_LFCLKSTAT_ALWAYSRUNNING_Running = 0x1
	// Position of STATE field.
	CLOCK_LFCLKSTAT_STATE_Pos = 0x10
	// Bit mask of STATE field.
	CLOCK_LFCLKSTAT_STATE_Msk = 0x10000
	// Bit STATE.
	CLOCK_LFCLKSTAT_STATE = 0x10000
	// LFCLK not running
	CLOCK_LFCLKSTAT_STATE_NotRunning = 0x0
	// LFCLK running
	CLOCK_LFCLKSTAT_STATE_Running = 0x1

	// LFCLKSRCCOPY: Copy of LFCLKSRC register, set when LFCLKSTART task was triggered
	// Position of SRC field.
	CLOCK_LFCLKSRCCOPY_SRC_Pos = 0x0
	// Bit mask of SRC field.
	CLOCK_LFCLKSRCCOPY_SRC_Msk = 0x3
	// 32.768 kHz ultra-low power RC oscillator
	CLOCK_LFCLKSRCCOPY_SRC_LFULP = 0x0
	// 32.768 kHz RC oscillator
	CLOCK_LFCLKSRCCOPY_SRC_LFRC = 0x1
	// 32.768 kHz crystal oscillator
	CLOCK_LFCLKSRCCOPY_SRC_LFXO = 0x2
	// 32.768 kHz synthesized from HFCLK
	CLOCK_LFCLKSRCCOPY_SRC_LFSYNT = 0x3

	// HFCLKSRC: Clock source for HFCLK128M/HFCLK64M
	// Position of SRC field.
	CLOCK_HFCLKSRC_SRC_Pos = 0x0
	// Bit mask of SRC field.
	CLOCK_HFCLKSRC_SRC_Msk = 0x1
	// Bit SRC.
	CLOCK_HFCLKSRC_SRC = 0x1
	// HFCLKSTART task starts HFINT oscillator
	CLOCK_HFCLKSRC_SRC_HFINT = 0x0
	// HFCLKSTART task starts HFXO oscillator
	CLOCK_HFCLKSRC_SRC_HFXO = 0x1

	// LFCLKSRC: Clock source for LFCLK
	// Position of SRC field.
	CLOCK_LFCLKSRC_SRC_Pos = 0x0
	// Bit mask of SRC field.
	CLOCK_LFCLKSRC_SRC_Msk = 0x3
	// 32.768 kHz ultra-low power RC oscillator
	CLOCK_LFCLKSRC_SRC_LFULP = 0x0
	// 32.768 kHz RC oscillator
	CLOCK_LFCLKSRC_SRC_LFRC = 0x1
	// 32.768 kHz crystal oscillator
	CLOCK_LFCLKSRC_SRC_LFXO = 0x2
	// 32.768 kHz synthesized from HFCLK
	CLOCK_LFCLKSRC_SRC_LFSYNT = 0x3

	// HFCLKCTRL: HFCLK128M frequency configuration
	// Position of HCLK field.
	CLOCK_HFCLKCTRL_HCLK_Pos = 0x0
	// Bit mask of HCLK field.
	CLOCK_HFCLKCTRL_HCLK_Msk = 0x3
	// Divide HFCLK by 1
	CLOCK_HFCLKCTRL_HCLK_Div1 = 0x0
	// Divide HFCLK by 2
	CLOCK_HFCLKCTRL_HCLK_Div2 = 0x1

	// HFCLKALWAYSRUN: Automatic or manual control of HFCLK128M/HFCLK64M
	// Position of ALWAYSRUN field.
	CLOCK_HFCLKALWAYSRUN_ALWAYSRUN_Pos = 0x0
	// Bit mask of ALWAYSRUN field.
	CLOCK_HFCLKALWAYSRUN_ALWAYSRUN_Msk = 0x1
	// Bit ALWAYSRUN.
	CLOCK_HFCLKALWAYSRUN_ALWAYSRUN = 0x1
	// Use automatic clock control
	CLOCK_HFCLKALWAYSRUN_ALWAYSRUN_Automatic = 0x0
	// Ensure clock is always running
	CLOCK_HFCLKALWAYSRUN_ALWAYSRUN_AlwaysRun = 0x1

	// LFCLKALWAYSRUN: Automatic or manual control of LFCLK
	// Position of ALWAYSRUN field.
	CLOCK_LFCLKALWAYSRUN_ALWAYSRUN_Pos = 0x0
	// Bit mask of ALWAYSRUN field.
	CLOCK_LFCLKALWAYSRUN_ALWAYSRUN_Msk = 0x1
	// Bit ALWAYSRUN.
	CLOCK_LFCLKALWAYSRUN_ALWAYSRUN = 0x1
	// Use automatic clock control
	CLOCK_LFCLKALWAYSRUN_ALWAYSRUN_Automatic = 0x0
	// Ensure clock is always running
	CLOCK_LFCLKALWAYSRUN_ALWAYSRUN_AlwaysRun = 0x1
)

// Bitfields for POWER_NS: Power control
const (
	// TASKS_CONSTLAT: Enable Constant Latency mode
	// Position of TASKS_CONSTLAT field.
	POWER_TASKS_CONSTLAT_TASKS_CONSTLAT_Pos = 0x0
	// Bit mask of TASKS_CONSTLAT field.
	POWER_TASKS_CONSTLAT_TASKS_CONSTLAT_Msk = 0x1
	// Bit TASKS_CONSTLAT.
	POWER_TASKS_CONSTLAT_TASKS_CONSTLAT = 0x1
	// Trigger task
	POWER_TASKS_CONSTLAT_TASKS_CONSTLAT_Trigger = 0x1

	// TASKS_LOWPWR: Enable Low-Power mode (variable latency)
	// Position of TASKS_LOWPWR field.
	POWER_TASKS_LOWPWR_TASKS_LOWPWR_Pos = 0x0
	// Bit mask of TASKS_LOWPWR field.
	POWER_TASKS_LOWPWR_TASKS_LOWPWR_Msk = 0x1
	// Bit TASKS_LOWPWR.
	POWER_TASKS_LOWPWR_TASKS_LOWPWR = 0x1
	// Trigger task
	POWER_TASKS_LOWPWR_TASKS_LOWPWR_Trigger = 0x1

	// SUBSCRIBE_CONSTLAT: Subscribe configuration for task CONSTLAT
	// Position of CHIDX field.
	POWER_SUBSCRIBE_CONSTLAT_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	POWER_SUBSCRIBE_CONSTLAT_CHIDX_Msk = 0xff
	// Position of EN field.
	POWER_SUBSCRIBE_CONSTLAT_EN_Pos = 0x1f
	// Bit mask of EN field.
	POWER_SUBSCRIBE_CONSTLAT_EN_Msk = 0x80000000
	// Bit EN.
	POWER_SUBSCRIBE_CONSTLAT_EN = 0x80000000
	// Disable subscription
	POWER_SUBSCRIBE_CONSTLAT_EN_Disabled = 0x0
	// Enable subscription
	POWER_SUBSCRIBE_CONSTLAT_EN_Enabled = 0x1

	// SUBSCRIBE_LOWPWR: Subscribe configuration for task LOWPWR
	// Position of CHIDX field.
	POWER_SUBSCRIBE_LOWPWR_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	POWER_SUBSCRIBE_LOWPWR_CHIDX_Msk = 0xff
	// Position of EN field.
	POWER_SUBSCRIBE_LOWPWR_EN_Pos = 0x1f
	// Bit mask of EN field.
	POWER_SUBSCRIBE_LOWPWR_EN_Msk = 0x80000000
	// Bit EN.
	POWER_SUBSCRIBE_LOWPWR_EN = 0x80000000
	// Disable subscription
	POWER_SUBSCRIBE_LOWPWR_EN_Disabled = 0x0
	// Enable subscription
	POWER_SUBSCRIBE_LOWPWR_EN_Enabled = 0x1

	// EVENTS_POFWARN: Power failure warning
	// Position of EVENTS_POFWARN field.
	POWER_EVENTS_POFWARN_EVENTS_POFWARN_Pos = 0x0
	// Bit mask of EVENTS_POFWARN field.
	POWER_EVENTS_POFWARN_EVENTS_POFWARN_Msk = 0x1
	// Bit EVENTS_POFWARN.
	POWER_EVENTS_POFWARN_EVENTS_POFWARN = 0x1
	// Event not generated
	POWER_EVENTS_POFWARN_EVENTS_POFWARN_NotGenerated = 0x0
	// Event generated
	POWER_EVENTS_POFWARN_EVENTS_POFWARN_Generated = 0x1

	// EVENTS_SLEEPENTER: CPU entered WFI/WFE sleep
	// Position of EVENTS_SLEEPENTER field.
	POWER_EVENTS_SLEEPENTER_EVENTS_SLEEPENTER_Pos = 0x0
	// Bit mask of EVENTS_SLEEPENTER field.
	POWER_EVENTS_SLEEPENTER_EVENTS_SLEEPENTER_Msk = 0x1
	// Bit EVENTS_SLEEPENTER.
	POWER_EVENTS_SLEEPENTER_EVENTS_SLEEPENTER = 0x1
	// Event not generated
	POWER_EVENTS_SLEEPENTER_EVENTS_SLEEPENTER_NotGenerated = 0x0
	// Event generated
	POWER_EVENTS_SLEEPENTER_EVENTS_SLEEPENTER_Generated = 0x1

	// EVENTS_SLEEPEXIT: CPU exited WFI/WFE sleep
	// Position of EVENTS_SLEEPEXIT field.
	POWER_EVENTS_SLEEPEXIT_EVENTS_SLEEPEXIT_Pos = 0x0
	// Bit mask of EVENTS_SLEEPEXIT field.
	POWER_EVENTS_SLEEPEXIT_EVENTS_SLEEPEXIT_Msk = 0x1
	// Bit EVENTS_SLEEPEXIT.
	POWER_EVENTS_SLEEPEXIT_EVENTS_SLEEPEXIT = 0x1
	// Event not generated
	POWER_EVENTS_SLEEPEXIT_EVENTS_SLEEPEXIT_NotGenerated = 0x0
	// Event generated
	POWER_EVENTS_SLEEPEXIT_EVENTS_SLEEPEXIT_Generated = 0x1

	// PUBLISH_POFWARN: Publish configuration for event POFWARN
	// Position of CHIDX field.
	POWER_PUBLISH_POFWARN_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	POWER_PUBLISH_POFWARN_CHIDX_Msk = 0xff
	// Position of EN field.
	POWER_PUBLISH_POFWARN_EN_Pos = 0x1f
	// Bit mask of EN field.
	POWER_PUBLISH_POFWARN_EN_Msk = 0x80000000
	// Bit EN.
	POWER_PUBLISH_POFWARN_EN = 0x80000000
	// Disable publishing
	POWER_PUBLISH_POFWARN_EN_Disabled = 0x0
	// Enable publishing
	POWER_PUBLISH_POFWARN_EN_Enabled = 0x1

	// PUBLISH_SLEEPENTER: Publish configuration for event SLEEPENTER
	// Position of CHIDX field.
	POWER_PUBLISH_SLEEPENTER_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	POWER_PUBLISH_SLEEPENTER_CHIDX_Msk = 0xff
	// Position of EN field.
	POWER_PUBLISH_SLEEPENTER_EN_Pos = 0x1f
	// Bit mask of EN field.
	POWER_PUBLISH_SLEEPENTER_EN_Msk = 0x80000000
	// Bit EN.
	POWER_PUBLISH_SLEEPENTER_EN = 0x80000000
	// Disable publishing
	POWER_PUBLISH_SLEEPENTER_EN_Disabled = 0x0
	// Enable publishing
	POWER_PUBLISH_SLEEPENTER_EN_Enabled = 0x1

	// PUBLISH_SLEEPEXIT: Publish configuration for event SLEEPEXIT
	// Position of CHIDX field.
	POWER_PUBLISH_SLEEPEXIT_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	POWER_PUBLISH_SLEEPEXIT_CHIDX_Msk = 0xff
	// Position of EN field.
	POWER_PUBLISH_SLEEPEXIT_EN_Pos = 0x1f
	// Bit mask of EN field.
	POWER_PUBLISH_SLEEPEXIT_EN_Msk = 0x80000000
	// Bit EN.
	POWER_PUBLISH_SLEEPEXIT_EN = 0x80000000
	// Disable publishing
	POWER_PUBLISH_SLEEPEXIT_EN_Disabled = 0x0
	// Enable publishing
	POWER_PUBLISH_SLEEPEXIT_EN_Enabled = 0x1

	// INTEN: Enable or disable interrupt
	// Position of POFWARN field.
	POWER_INTEN_POFWARN_Pos = 0x2
	// Bit mask of POFWARN field.
	POWER_INTEN_POFWARN_Msk = 0x4
	// Bit POFWARN.
	POWER_INTEN_POFWARN = 0x4
	// Disable
	POWER_INTEN_POFWARN_Disabled = 0x0
	// Enable
	POWER_INTEN_POFWARN_Enabled = 0x1
	// Position of SLEEPENTER field.
	POWER_INTEN_SLEEPENTER_Pos = 0x5
	// Bit mask of SLEEPENTER field.
	POWER_INTEN_SLEEPENTER_Msk = 0x20
	// Bit SLEEPENTER.
	POWER_INTEN_SLEEPENTER = 0x20
	// Disable
	POWER_INTEN_SLEEPENTER_Disabled = 0x0
	// Enable
	POWER_INTEN_SLEEPENTER_Enabled = 0x1
	// Position of SLEEPEXIT field.
	POWER_INTEN_SLEEPEXIT_Pos = 0x6
	// Bit mask of SLEEPEXIT field.
	POWER_INTEN_SLEEPEXIT_Msk = 0x40
	// Bit SLEEPEXIT.
	POWER_INTEN_SLEEPEXIT = 0x40
	// Disable
	POWER_INTEN_SLEEPEXIT_Disabled = 0x0
	// Enable
	POWER_INTEN_SLEEPEXIT_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of POFWARN field.
	POWER_INTENSET_POFWARN_Pos = 0x2
	// Bit mask of POFWARN field.
	POWER_INTENSET_POFWARN_Msk = 0x4
	// Bit POFWARN.
	POWER_INTENSET_POFWARN = 0x4
	// Read: Disabled
	POWER_INTENSET_POFWARN_Disabled = 0x0
	// Read: Enabled
	POWER_INTENSET_POFWARN_Enabled = 0x1
	// Enable
	POWER_INTENSET_POFWARN_Set = 0x1
	// Position of SLEEPENTER field.
	POWER_INTENSET_SLEEPENTER_Pos = 0x5
	// Bit mask of SLEEPENTER field.
	POWER_INTENSET_SLEEPENTER_Msk = 0x20
	// Bit SLEEPENTER.
	POWER_INTENSET_SLEEPENTER = 0x20
	// Read: Disabled
	POWER_INTENSET_SLEEPENTER_Disabled = 0x0
	// Read: Enabled
	POWER_INTENSET_SLEEPENTER_Enabled = 0x1
	// Enable
	POWER_INTENSET_SLEEPENTER_Set = 0x1
	// Position of SLEEPEXIT field.
	POWER_INTENSET_SLEEPEXIT_Pos = 0x6
	// Bit mask of SLEEPEXIT field.
	POWER_INTENSET_SLEEPEXIT_Msk = 0x40
	// Bit SLEEPEXIT.
	POWER_INTENSET_SLEEPEXIT = 0x40
	// Read: Disabled
	POWER_INTENSET_SLEEPEXIT_Disabled = 0x0
	// Read: Enabled
	POWER_INTENSET_SLEEPEXIT_Enabled = 0x1
	// Enable
	POWER_INTENSET_SLEEPEXIT_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of POFWARN field.
	POWER_INTENCLR_POFWARN_Pos = 0x2
	// Bit mask of POFWARN field.
	POWER_INTENCLR_POFWARN_Msk = 0x4
	// Bit POFWARN.
	POWER_INTENCLR_POFWARN = 0x4
	// Read: Disabled
	POWER_INTENCLR_POFWARN_Disabled = 0x0
	// Read: Enabled
	POWER_INTENCLR_POFWARN_Enabled = 0x1
	// Disable
	POWER_INTENCLR_POFWARN_Clear = 0x1
	// Position of SLEEPENTER field.
	POWER_INTENCLR_SLEEPENTER_Pos = 0x5
	// Bit mask of SLEEPENTER field.
	POWER_INTENCLR_SLEEPENTER_Msk = 0x20
	// Bit SLEEPENTER.
	POWER_INTENCLR_SLEEPENTER = 0x20
	// Read: Disabled
	POWER_INTENCLR_SLEEPENTER_Disabled = 0x0
	// Read: Enabled
	POWER_INTENCLR_SLEEPENTER_Enabled = 0x1
	// Disable
	POWER_INTENCLR_SLEEPENTER_Clear = 0x1
	// Position of SLEEPEXIT field.
	POWER_INTENCLR_SLEEPEXIT_Pos = 0x6
	// Bit mask of SLEEPEXIT field.
	POWER_INTENCLR_SLEEPEXIT_Msk = 0x40
	// Bit SLEEPEXIT.
	POWER_INTENCLR_SLEEPEXIT = 0x40
	// Read: Disabled
	POWER_INTENCLR_SLEEPEXIT_Disabled = 0x0
	// Read: Enabled
	POWER_INTENCLR_SLEEPEXIT_Enabled = 0x1
	// Disable
	POWER_INTENCLR_SLEEPEXIT_Clear = 0x1

	// GPREGRET: Description collection: General purpose retention register
	// Position of GPREGRET field.
	POWER_GPREGRET_GPREGRET_Pos = 0x0
	// Bit mask of GPREGRET field.
	POWER_GPREGRET_GPREGRET_Msk = 0xff
)

// Bitfields for RESET_NS: Reset control
const (
	// RESETREAS: Reset reason
	// Position of RESETPIN field.
	RESET_RESETREAS_RESETPIN_Pos = 0x0
	// Bit mask of RESETPIN field.
	RESET_RESETREAS_RESETPIN_Msk = 0x1
	// Bit RESETPIN.
	RESET_RESETREAS_RESETPIN = 0x1
	// Not detected
	RESET_RESETREAS_RESETPIN_NotDetected = 0x0
	// Detected
	RESET_RESETREAS_RESETPIN_Detected = 0x1
	// Position of DOG0 field.
	RESET_RESETREAS_DOG0_Pos = 0x1
	// Bit mask of DOG0 field.
	RESET_RESETREAS_DOG0_Msk = 0x2
	// Bit DOG0.
	RESET_RESETREAS_DOG0 = 0x2
	// Not detected
	RESET_RESETREAS_DOG0_NotDetected = 0x0
	// Detected
	RESET_RESETREAS_DOG0_Detected = 0x1
	// Position of CTRLAP field.
	RESET_RESETREAS_CTRLAP_Pos = 0x2
	// Bit mask of CTRLAP field.
	RESET_RESETREAS_CTRLAP_Msk = 0x4
	// Bit CTRLAP.
	RESET_RESETREAS_CTRLAP = 0x4
	// Not detected
	RESET_RESETREAS_CTRLAP_NotDetected = 0x0
	// Detected
	RESET_RESETREAS_CTRLAP_Detected = 0x1
	// Position of SREQ field.
	RESET_RESETREAS_SREQ_Pos = 0x3
	// Bit mask of SREQ field.
	RESET_RESETREAS_SREQ_Msk = 0x8
	// Bit SREQ.
	RESET_RESETREAS_SREQ = 0x8
	// Not detected
	RESET_RESETREAS_SREQ_NotDetected = 0x0
	// Detected
	RESET_RESETREAS_SREQ_Detected = 0x1
	// Position of LOCKUP field.
	RESET_RESETREAS_LOCKUP_Pos = 0x4
	// Bit mask of LOCKUP field.
	RESET_RESETREAS_LOCKUP_Msk = 0x10
	// Bit LOCKUP.
	RESET_RESETREAS_LOCKUP = 0x10
	// Not detected
	RESET_RESETREAS_LOCKUP_NotDetected = 0x0
	// Detected
	RESET_RESETREAS_LOCKUP_Detected = 0x1
	// Position of OFF field.
	RESET_RESETREAS_OFF_Pos = 0x5
	// Bit mask of OFF field.
	RESET_RESETREAS_OFF_Msk = 0x20
	// Bit OFF.
	RESET_RESETREAS_OFF = 0x20
	// Not detected
	RESET_RESETREAS_OFF_NotDetected = 0x0
	// Detected
	RESET_RESETREAS_OFF_Detected = 0x1
	// Position of LPCOMP field.
	RESET_RESETREAS_LPCOMP_Pos = 0x6
	// Bit mask of LPCOMP field.
	RESET_RESETREAS_LPCOMP_Msk = 0x40
	// Bit LPCOMP.
	RESET_RESETREAS_LPCOMP = 0x40
	// Not detected
	RESET_RESETREAS_LPCOMP_NotDetected = 0x0
	// Detected
	RESET_RESETREAS_LPCOMP_Detected = 0x1
	// Position of DIF field.
	RESET_RESETREAS_DIF_Pos = 0x7
	// Bit mask of DIF field.
	RESET_RESETREAS_DIF_Msk = 0x80
	// Bit DIF.
	RESET_RESETREAS_DIF = 0x80
	// Not detected
	RESET_RESETREAS_DIF_NotDetected = 0x0
	// Detected
	RESET_RESETREAS_DIF_Detected = 0x1
	// Position of LSREQ field.
	RESET_RESETREAS_LSREQ_Pos = 0x10
	// Bit mask of LSREQ field.
	RESET_RESETREAS_LSREQ_Msk = 0x10000
	// Bit LSREQ.
	RESET_RESETREAS_LSREQ = 0x10000
	// Not detected
	RESET_RESETREAS_LSREQ_NotDetected = 0x0
	// Detected
	RESET_RESETREAS_LSREQ_Detected = 0x1
	// Position of LLOCKUP field.
	RESET_RESETREAS_LLOCKUP_Pos = 0x11
	// Bit mask of LLOCKUP field.
	RESET_RESETREAS_LLOCKUP_Msk = 0x20000
	// Bit LLOCKUP.
	RESET_RESETREAS_LLOCKUP = 0x20000
	// Not detected
	RESET_RESETREAS_LLOCKUP_NotDetected = 0x0
	// Detected
	RESET_RESETREAS_LLOCKUP_Detected = 0x1
	// Position of LDOG field.
	RESET_RESETREAS_LDOG_Pos = 0x12
	// Bit mask of LDOG field.
	RESET_RESETREAS_LDOG_Msk = 0x40000
	// Bit LDOG.
	RESET_RESETREAS_LDOG = 0x40000
	// Not detected
	RESET_RESETREAS_LDOG_NotDetected = 0x0
	// Detected
	RESET_RESETREAS_LDOG_Detected = 0x1
	// Position of MFORCEOFF field.
	RESET_RESETREAS_MFORCEOFF_Pos = 0x17
	// Bit mask of MFORCEOFF field.
	RESET_RESETREAS_MFORCEOFF_Msk = 0x800000
	// Bit MFORCEOFF.
	RESET_RESETREAS_MFORCEOFF = 0x800000
	// Not detected
	RESET_RESETREAS_MFORCEOFF_NotDetected = 0x0
	// Detected
	RESET_RESETREAS_MFORCEOFF_Detected = 0x1
	// Position of NFC field.
	RESET_RESETREAS_NFC_Pos = 0x18
	// Bit mask of NFC field.
	RESET_RESETREAS_NFC_Msk = 0x1000000
	// Bit NFC.
	RESET_RESETREAS_NFC = 0x1000000
	// Not detected
	RESET_RESETREAS_NFC_NotDetected = 0x0
	// Detected
	RESET_RESETREAS_NFC_Detected = 0x1
	// Position of DOG1 field.
	RESET_RESETREAS_DOG1_Pos = 0x19
	// Bit mask of DOG1 field.
	RESET_RESETREAS_DOG1_Msk = 0x2000000
	// Bit DOG1.
	RESET_RESETREAS_DOG1 = 0x2000000
	// Not detected
	RESET_RESETREAS_DOG1_NotDetected = 0x0
	// Detected
	RESET_RESETREAS_DOG1_Detected = 0x1
	// Position of VBUS field.
	RESET_RESETREAS_VBUS_Pos = 0x1a
	// Bit mask of VBUS field.
	RESET_RESETREAS_VBUS_Msk = 0x4000000
	// Bit VBUS.
	RESET_RESETREAS_VBUS = 0x4000000
	// Not detected
	RESET_RESETREAS_VBUS_NotDetected = 0x0
	// Detected
	RESET_RESETREAS_VBUS_Detected = 0x1
	// Position of LCTRLAP field.
	RESET_RESETREAS_LCTRLAP_Pos = 0x1b
	// Bit mask of LCTRLAP field.
	RESET_RESETREAS_LCTRLAP_Msk = 0x8000000
	// Bit LCTRLAP.
	RESET_RESETREAS_LCTRLAP = 0x8000000
	// Not detected
	RESET_RESETREAS_LCTRLAP_NotDetected = 0x0
	// Detected
	RESET_RESETREAS_LCTRLAP_Detected = 0x1
)

// Bitfields for CTRLAP_NS: Control access port
const (
	// MAILBOX.RXDATA: Data sent from the debugger to the CPU.
	// Position of RXDATA field.
	CTRLAPPERI_MAILBOX_RXDATA_RXDATA_Pos = 0x0
	// Bit mask of RXDATA field.
	CTRLAPPERI_MAILBOX_RXDATA_RXDATA_Msk = 0xffffffff

	// MAILBOX.RXSTATUS: This register shows a status that indicates if data sent from the debugger to the CPU has been read.
	// Position of RXSTATUS field.
	CTRLAPPERI_MAILBOX_RXSTATUS_RXSTATUS_Pos = 0x0
	// Bit mask of RXSTATUS field.
	CTRLAPPERI_MAILBOX_RXSTATUS_RXSTATUS_Msk = 0x1
	// Bit RXSTATUS.
	CTRLAPPERI_MAILBOX_RXSTATUS_RXSTATUS = 0x1
	// No data pending in register RXDATA
	CTRLAPPERI_MAILBOX_RXSTATUS_RXSTATUS_NoDataPending = 0x0
	// Data pending in register RXDATA
	CTRLAPPERI_MAILBOX_RXSTATUS_RXSTATUS_DataPending = 0x1

	// MAILBOX.TXDATA: Data sent from the CPU to the debugger.
	// Position of TXDATA field.
	CTRLAPPERI_MAILBOX_TXDATA_TXDATA_Pos = 0x0
	// Bit mask of TXDATA field.
	CTRLAPPERI_MAILBOX_TXDATA_TXDATA_Msk = 0xffffffff

	// MAILBOX.TXSTATUS: This register shows a status that indicates if the data sent from the CPU to the debugger has been read.
	// Position of TXSTATUS field.
	CTRLAPPERI_MAILBOX_TXSTATUS_TXSTATUS_Pos = 0x0
	// Bit mask of TXSTATUS field.
	CTRLAPPERI_MAILBOX_TXSTATUS_TXSTATUS_Msk = 0x1
	// Bit TXSTATUS.
	CTRLAPPERI_MAILBOX_TXSTATUS_TXSTATUS = 0x1
	// No data pending in register TXDATA
	CTRLAPPERI_MAILBOX_TXSTATUS_TXSTATUS_NoDataPending = 0x0
	// Data pending in register TXDATA
	CTRLAPPERI_MAILBOX_TXSTATUS_TXSTATUS_DataPending = 0x1

	// ERASEPROTECT.LOCK: This register locks the ERASEPROTECT.DISABLE register from being written until next reset.
	// Position of LOCK field.
	CTRLAPPERI_ERASEPROTECT_LOCK_LOCK_Pos = 0x0
	// Bit mask of LOCK field.
	CTRLAPPERI_ERASEPROTECT_LOCK_LOCK_Msk = 0x1
	// Bit LOCK.
	CTRLAPPERI_ERASEPROTECT_LOCK_LOCK = 0x1
	// Register ERASEPROTECT.DISABLE is writeable
	CTRLAPPERI_ERASEPROTECT_LOCK_LOCK_Unlocked = 0x0
	// Register ERASEPROTECT.DISABLE is read-only
	CTRLAPPERI_ERASEPROTECT_LOCK_LOCK_Locked = 0x1

	// ERASEPROTECT.DISABLE: This register disables the ERASEPROTECT register and performs an ERASEALL operation.
	// Position of KEY field.
	CTRLAPPERI_ERASEPROTECT_DISABLE_KEY_Pos = 0x0
	// Bit mask of KEY field.
	CTRLAPPERI_ERASEPROTECT_DISABLE_KEY_Msk = 0xffffffff

	// APPROTECT.LOCK: This register locks the APPROTECT.DISABLE register from being written to until next reset.
	// Position of LOCK field.
	CTRLAPPERI_APPROTECT_LOCK_LOCK_Pos = 0x0
	// Bit mask of LOCK field.
	CTRLAPPERI_APPROTECT_LOCK_LOCK_Msk = 0x1
	// Bit LOCK.
	CTRLAPPERI_APPROTECT_LOCK_LOCK = 0x1
	// Register APPROTECT.DISABLE is writeable
	CTRLAPPERI_APPROTECT_LOCK_LOCK_Unlocked = 0x0
	// Register APPROTECT.DISABLE is read-only
	CTRLAPPERI_APPROTECT_LOCK_LOCK_Locked = 0x1

	// APPROTECT.DISABLE: This register disables the APPROTECT register and enables debug access to non-secure mode.
	// Position of KEY field.
	CTRLAPPERI_APPROTECT_DISABLE_KEY_Pos = 0x0
	// Bit mask of KEY field.
	CTRLAPPERI_APPROTECT_DISABLE_KEY_Msk = 0xffffffff

	// STATUS: Status bits for CTRL-AP peripheral
	// Position of APPROTECT field.
	CTRLAPPERI_STATUS_APPROTECT_Pos = 0x0
	// Bit mask of APPROTECT field.
	CTRLAPPERI_STATUS_APPROTECT_Msk = 0x1
	// Bit APPROTECT.
	CTRLAPPERI_STATUS_APPROTECT = 0x1
	// Non-secure mode access port protection is currently disabled
	CTRLAPPERI_STATUS_APPROTECT_Disabled = 0x0
	// Non-secure mode access port protection is currently enabled
	CTRLAPPERI_STATUS_APPROTECT_Enabled = 0x1
	// Position of DBGIFACEMODE field.
	CTRLAPPERI_STATUS_DBGIFACEMODE_Pos = 0x2
	// Bit mask of DBGIFACEMODE field.
	CTRLAPPERI_STATUS_DBGIFACEMODE_Msk = 0x4
	// Bit DBGIFACEMODE.
	CTRLAPPERI_STATUS_DBGIFACEMODE = 0x4
	// No debugger attached
	CTRLAPPERI_STATUS_DBGIFACEMODE_Disabled = 0x0
	// Debugger is attached and device is in debug interface mode
	CTRLAPPERI_STATUS_DBGIFACEMODE_Enabled = 0x1
)

// Bitfields for RADIO_NS: 2.4 GHz radio
const (
	// TASKS_TXEN: Enable RADIO in TX mode
	// Position of TASKS_TXEN field.
	RADIO_TASKS_TXEN_TASKS_TXEN_Pos = 0x0
	// Bit mask of TASKS_TXEN field.
	RADIO_TASKS_TXEN_TASKS_TXEN_Msk = 0x1
	// Bit TASKS_TXEN.
	RADIO_TASKS_TXEN_TASKS_TXEN = 0x1
	// Trigger task
	RADIO_TASKS_TXEN_TASKS_TXEN_Trigger = 0x1

	// TASKS_RXEN: Enable RADIO in RX mode
	// Position of TASKS_RXEN field.
	RADIO_TASKS_RXEN_TASKS_RXEN_Pos = 0x0
	// Bit mask of TASKS_RXEN field.
	RADIO_TASKS_RXEN_TASKS_RXEN_Msk = 0x1
	// Bit TASKS_RXEN.
	RADIO_TASKS_RXEN_TASKS_RXEN = 0x1
	// Trigger task
	RADIO_TASKS_RXEN_TASKS_RXEN_Trigger = 0x1

	// TASKS_START: Start RADIO
	// Position of TASKS_START field.
	RADIO_TASKS_START_TASKS_START_Pos = 0x0
	// Bit mask of TASKS_START field.
	RADIO_TASKS_START_TASKS_START_Msk = 0x1
	// Bit TASKS_START.
	RADIO_TASKS_START_TASKS_START = 0x1
	// Trigger task
	RADIO_TASKS_START_TASKS_START_Trigger = 0x1

	// TASKS_STOP: Stop RADIO
	// Position of TASKS_STOP field.
	RADIO_TASKS_STOP_TASKS_STOP_Pos = 0x0
	// Bit mask of TASKS_STOP field.
	RADIO_TASKS_STOP_TASKS_STOP_Msk = 0x1
	// Bit TASKS_STOP.
	RADIO_TASKS_STOP_TASKS_STOP = 0x1
	// Trigger task
	RADIO_TASKS_STOP_TASKS_STOP_Trigger = 0x1

	// TASKS_DISABLE: Disable RADIO
	// Position of TASKS_DISABLE field.
	RADIO_TASKS_DISABLE_TASKS_DISABLE_Pos = 0x0
	// Bit mask of TASKS_DISABLE field.
	RADIO_TASKS_DISABLE_TASKS_DISABLE_Msk = 0x1
	// Bit TASKS_DISABLE.
	RADIO_TASKS_DISABLE_TASKS_DISABLE = 0x1
	// Trigger task
	RADIO_TASKS_DISABLE_TASKS_DISABLE_Trigger = 0x1

	// TASKS_RSSISTART: Start the RSSI and take one single sample of the receive signal strength
	// Position of TASKS_RSSISTART field.
	RADIO_TASKS_RSSISTART_TASKS_RSSISTART_Pos = 0x0
	// Bit mask of TASKS_RSSISTART field.
	RADIO_TASKS_RSSISTART_TASKS_RSSISTART_Msk = 0x1
	// Bit TASKS_RSSISTART.
	RADIO_TASKS_RSSISTART_TASKS_RSSISTART = 0x1
	// Trigger task
	RADIO_TASKS_RSSISTART_TASKS_RSSISTART_Trigger = 0x1

	// TASKS_RSSISTOP: Stop the RSSI measurement
	// Position of TASKS_RSSISTOP field.
	RADIO_TASKS_RSSISTOP_TASKS_RSSISTOP_Pos = 0x0
	// Bit mask of TASKS_RSSISTOP field.
	RADIO_TASKS_RSSISTOP_TASKS_RSSISTOP_Msk = 0x1
	// Bit TASKS_RSSISTOP.
	RADIO_TASKS_RSSISTOP_TASKS_RSSISTOP = 0x1
	// Trigger task
	RADIO_TASKS_RSSISTOP_TASKS_RSSISTOP_Trigger = 0x1

	// TASKS_BCSTART: Start the bit counter
	// Position of TASKS_BCSTART field.
	RADIO_TASKS_BCSTART_TASKS_BCSTART_Pos = 0x0
	// Bit mask of TASKS_BCSTART field.
	RADIO_TASKS_BCSTART_TASKS_BCSTART_Msk = 0x1
	// Bit TASKS_BCSTART.
	RADIO_TASKS_BCSTART_TASKS_BCSTART = 0x1
	// Trigger task
	RADIO_TASKS_BCSTART_TASKS_BCSTART_Trigger = 0x1

	// TASKS_BCSTOP: Stop the bit counter
	// Position of TASKS_BCSTOP field.
	RADIO_TASKS_BCSTOP_TASKS_BCSTOP_Pos = 0x0
	// Bit mask of TASKS_BCSTOP field.
	RADIO_TASKS_BCSTOP_TASKS_BCSTOP_Msk = 0x1
	// Bit TASKS_BCSTOP.
	RADIO_TASKS_BCSTOP_TASKS_BCSTOP = 0x1
	// Trigger task
	RADIO_TASKS_BCSTOP_TASKS_BCSTOP_Trigger = 0x1

	// TASKS_EDSTART: Start the energy detect measurement used in IEEE 802.15.4 mode
	// Position of TASKS_EDSTART field.
	RADIO_TASKS_EDSTART_TASKS_EDSTART_Pos = 0x0
	// Bit mask of TASKS_EDSTART field.
	RADIO_TASKS_EDSTART_TASKS_EDSTART_Msk = 0x1
	// Bit TASKS_EDSTART.
	RADIO_TASKS_EDSTART_TASKS_EDSTART = 0x1
	// Trigger task
	RADIO_TASKS_EDSTART_TASKS_EDSTART_Trigger = 0x1

	// TASKS_EDSTOP: Stop the energy detect measurement
	// Position of TASKS_EDSTOP field.
	RADIO_TASKS_EDSTOP_TASKS_EDSTOP_Pos = 0x0
	// Bit mask of TASKS_EDSTOP field.
	RADIO_TASKS_EDSTOP_TASKS_EDSTOP_Msk = 0x1
	// Bit TASKS_EDSTOP.
	RADIO_TASKS_EDSTOP_TASKS_EDSTOP = 0x1
	// Trigger task
	RADIO_TASKS_EDSTOP_TASKS_EDSTOP_Trigger = 0x1

	// TASKS_CCASTART: Start the clear channel assessment used in IEEE 802.15.4 mode
	// Position of TASKS_CCASTART field.
	RADIO_TASKS_CCASTART_TASKS_CCASTART_Pos = 0x0
	// Bit mask of TASKS_CCASTART field.
	RADIO_TASKS_CCASTART_TASKS_CCASTART_Msk = 0x1
	// Bit TASKS_CCASTART.
	RADIO_TASKS_CCASTART_TASKS_CCASTART = 0x1
	// Trigger task
	RADIO_TASKS_CCASTART_TASKS_CCASTART_Trigger = 0x1

	// TASKS_CCASTOP: Stop the clear channel assessment
	// Position of TASKS_CCASTOP field.
	RADIO_TASKS_CCASTOP_TASKS_CCASTOP_Pos = 0x0
	// Bit mask of TASKS_CCASTOP field.
	RADIO_TASKS_CCASTOP_TASKS_CCASTOP_Msk = 0x1
	// Bit TASKS_CCASTOP.
	RADIO_TASKS_CCASTOP_TASKS_CCASTOP = 0x1
	// Trigger task
	RADIO_TASKS_CCASTOP_TASKS_CCASTOP_Trigger = 0x1

	// SUBSCRIBE_TXEN: Subscribe configuration for task TXEN
	// Position of CHIDX field.
	RADIO_SUBSCRIBE_TXEN_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_SUBSCRIBE_TXEN_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_SUBSCRIBE_TXEN_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_SUBSCRIBE_TXEN_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_SUBSCRIBE_TXEN_EN = 0x80000000
	// Disable subscription
	RADIO_SUBSCRIBE_TXEN_EN_Disabled = 0x0
	// Enable subscription
	RADIO_SUBSCRIBE_TXEN_EN_Enabled = 0x1

	// SUBSCRIBE_RXEN: Subscribe configuration for task RXEN
	// Position of CHIDX field.
	RADIO_SUBSCRIBE_RXEN_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_SUBSCRIBE_RXEN_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_SUBSCRIBE_RXEN_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_SUBSCRIBE_RXEN_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_SUBSCRIBE_RXEN_EN = 0x80000000
	// Disable subscription
	RADIO_SUBSCRIBE_RXEN_EN_Disabled = 0x0
	// Enable subscription
	RADIO_SUBSCRIBE_RXEN_EN_Enabled = 0x1

	// SUBSCRIBE_START: Subscribe configuration for task START
	// Position of CHIDX field.
	RADIO_SUBSCRIBE_START_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_SUBSCRIBE_START_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_SUBSCRIBE_START_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_SUBSCRIBE_START_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_SUBSCRIBE_START_EN = 0x80000000
	// Disable subscription
	RADIO_SUBSCRIBE_START_EN_Disabled = 0x0
	// Enable subscription
	RADIO_SUBSCRIBE_START_EN_Enabled = 0x1

	// SUBSCRIBE_STOP: Subscribe configuration for task STOP
	// Position of CHIDX field.
	RADIO_SUBSCRIBE_STOP_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_SUBSCRIBE_STOP_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_SUBSCRIBE_STOP_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_SUBSCRIBE_STOP_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_SUBSCRIBE_STOP_EN = 0x80000000
	// Disable subscription
	RADIO_SUBSCRIBE_STOP_EN_Disabled = 0x0
	// Enable subscription
	RADIO_SUBSCRIBE_STOP_EN_Enabled = 0x1

	// SUBSCRIBE_DISABLE: Subscribe configuration for task DISABLE
	// Position of CHIDX field.
	RADIO_SUBSCRIBE_DISABLE_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_SUBSCRIBE_DISABLE_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_SUBSCRIBE_DISABLE_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_SUBSCRIBE_DISABLE_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_SUBSCRIBE_DISABLE_EN = 0x80000000
	// Disable subscription
	RADIO_SUBSCRIBE_DISABLE_EN_Disabled = 0x0
	// Enable subscription
	RADIO_SUBSCRIBE_DISABLE_EN_Enabled = 0x1

	// SUBSCRIBE_RSSISTART: Subscribe configuration for task RSSISTART
	// Position of CHIDX field.
	RADIO_SUBSCRIBE_RSSISTART_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_SUBSCRIBE_RSSISTART_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_SUBSCRIBE_RSSISTART_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_SUBSCRIBE_RSSISTART_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_SUBSCRIBE_RSSISTART_EN = 0x80000000
	// Disable subscription
	RADIO_SUBSCRIBE_RSSISTART_EN_Disabled = 0x0
	// Enable subscription
	RADIO_SUBSCRIBE_RSSISTART_EN_Enabled = 0x1

	// SUBSCRIBE_RSSISTOP: Subscribe configuration for task RSSISTOP
	// Position of CHIDX field.
	RADIO_SUBSCRIBE_RSSISTOP_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_SUBSCRIBE_RSSISTOP_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_SUBSCRIBE_RSSISTOP_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_SUBSCRIBE_RSSISTOP_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_SUBSCRIBE_RSSISTOP_EN = 0x80000000
	// Disable subscription
	RADIO_SUBSCRIBE_RSSISTOP_EN_Disabled = 0x0
	// Enable subscription
	RADIO_SUBSCRIBE_RSSISTOP_EN_Enabled = 0x1

	// SUBSCRIBE_BCSTART: Subscribe configuration for task BCSTART
	// Position of CHIDX field.
	RADIO_SUBSCRIBE_BCSTART_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_SUBSCRIBE_BCSTART_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_SUBSCRIBE_BCSTART_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_SUBSCRIBE_BCSTART_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_SUBSCRIBE_BCSTART_EN = 0x80000000
	// Disable subscription
	RADIO_SUBSCRIBE_BCSTART_EN_Disabled = 0x0
	// Enable subscription
	RADIO_SUBSCRIBE_BCSTART_EN_Enabled = 0x1

	// SUBSCRIBE_BCSTOP: Subscribe configuration for task BCSTOP
	// Position of CHIDX field.
	RADIO_SUBSCRIBE_BCSTOP_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_SUBSCRIBE_BCSTOP_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_SUBSCRIBE_BCSTOP_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_SUBSCRIBE_BCSTOP_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_SUBSCRIBE_BCSTOP_EN = 0x80000000
	// Disable subscription
	RADIO_SUBSCRIBE_BCSTOP_EN_Disabled = 0x0
	// Enable subscription
	RADIO_SUBSCRIBE_BCSTOP_EN_Enabled = 0x1

	// SUBSCRIBE_EDSTART: Subscribe configuration for task EDSTART
	// Position of CHIDX field.
	RADIO_SUBSCRIBE_EDSTART_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_SUBSCRIBE_EDSTART_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_SUBSCRIBE_EDSTART_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_SUBSCRIBE_EDSTART_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_SUBSCRIBE_EDSTART_EN = 0x80000000
	// Disable subscription
	RADIO_SUBSCRIBE_EDSTART_EN_Disabled = 0x0
	// Enable subscription
	RADIO_SUBSCRIBE_EDSTART_EN_Enabled = 0x1

	// SUBSCRIBE_EDSTOP: Subscribe configuration for task EDSTOP
	// Position of CHIDX field.
	RADIO_SUBSCRIBE_EDSTOP_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_SUBSCRIBE_EDSTOP_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_SUBSCRIBE_EDSTOP_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_SUBSCRIBE_EDSTOP_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_SUBSCRIBE_EDSTOP_EN = 0x80000000
	// Disable subscription
	RADIO_SUBSCRIBE_EDSTOP_EN_Disabled = 0x0
	// Enable subscription
	RADIO_SUBSCRIBE_EDSTOP_EN_Enabled = 0x1

	// SUBSCRIBE_CCASTART: Subscribe configuration for task CCASTART
	// Position of CHIDX field.
	RADIO_SUBSCRIBE_CCASTART_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_SUBSCRIBE_CCASTART_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_SUBSCRIBE_CCASTART_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_SUBSCRIBE_CCASTART_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_SUBSCRIBE_CCASTART_EN = 0x80000000
	// Disable subscription
	RADIO_SUBSCRIBE_CCASTART_EN_Disabled = 0x0
	// Enable subscription
	RADIO_SUBSCRIBE_CCASTART_EN_Enabled = 0x1

	// SUBSCRIBE_CCASTOP: Subscribe configuration for task CCASTOP
	// Position of CHIDX field.
	RADIO_SUBSCRIBE_CCASTOP_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_SUBSCRIBE_CCASTOP_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_SUBSCRIBE_CCASTOP_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_SUBSCRIBE_CCASTOP_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_SUBSCRIBE_CCASTOP_EN = 0x80000000
	// Disable subscription
	RADIO_SUBSCRIBE_CCASTOP_EN_Disabled = 0x0
	// Enable subscription
	RADIO_SUBSCRIBE_CCASTOP_EN_Enabled = 0x1

	// EVENTS_READY: RADIO has ramped up and is ready to be started
	// Position of EVENTS_READY field.
	RADIO_EVENTS_READY_EVENTS_READY_Pos = 0x0
	// Bit mask of EVENTS_READY field.
	RADIO_EVENTS_READY_EVENTS_READY_Msk = 0x1
	// Bit EVENTS_READY.
	RADIO_EVENTS_READY_EVENTS_READY = 0x1
	// Event not generated
	RADIO_EVENTS_READY_EVENTS_READY_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_READY_EVENTS_READY_Generated = 0x1

	// EVENTS_ADDRESS: Address sent or received
	// Position of EVENTS_ADDRESS field.
	RADIO_EVENTS_ADDRESS_EVENTS_ADDRESS_Pos = 0x0
	// Bit mask of EVENTS_ADDRESS field.
	RADIO_EVENTS_ADDRESS_EVENTS_ADDRESS_Msk = 0x1
	// Bit EVENTS_ADDRESS.
	RADIO_EVENTS_ADDRESS_EVENTS_ADDRESS = 0x1
	// Event not generated
	RADIO_EVENTS_ADDRESS_EVENTS_ADDRESS_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_ADDRESS_EVENTS_ADDRESS_Generated = 0x1

	// EVENTS_PAYLOAD: Packet payload sent or received
	// Position of EVENTS_PAYLOAD field.
	RADIO_EVENTS_PAYLOAD_EVENTS_PAYLOAD_Pos = 0x0
	// Bit mask of EVENTS_PAYLOAD field.
	RADIO_EVENTS_PAYLOAD_EVENTS_PAYLOAD_Msk = 0x1
	// Bit EVENTS_PAYLOAD.
	RADIO_EVENTS_PAYLOAD_EVENTS_PAYLOAD = 0x1
	// Event not generated
	RADIO_EVENTS_PAYLOAD_EVENTS_PAYLOAD_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_PAYLOAD_EVENTS_PAYLOAD_Generated = 0x1

	// EVENTS_END: Packet sent or received
	// Position of EVENTS_END field.
	RADIO_EVENTS_END_EVENTS_END_Pos = 0x0
	// Bit mask of EVENTS_END field.
	RADIO_EVENTS_END_EVENTS_END_Msk = 0x1
	// Bit EVENTS_END.
	RADIO_EVENTS_END_EVENTS_END = 0x1
	// Event not generated
	RADIO_EVENTS_END_EVENTS_END_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_END_EVENTS_END_Generated = 0x1

	// EVENTS_DISABLED: RADIO has been disabled
	// Position of EVENTS_DISABLED field.
	RADIO_EVENTS_DISABLED_EVENTS_DISABLED_Pos = 0x0
	// Bit mask of EVENTS_DISABLED field.
	RADIO_EVENTS_DISABLED_EVENTS_DISABLED_Msk = 0x1
	// Bit EVENTS_DISABLED.
	RADIO_EVENTS_DISABLED_EVENTS_DISABLED = 0x1
	// Event not generated
	RADIO_EVENTS_DISABLED_EVENTS_DISABLED_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_DISABLED_EVENTS_DISABLED_Generated = 0x1

	// EVENTS_DEVMATCH: A device address match occurred on the last received packet
	// Position of EVENTS_DEVMATCH field.
	RADIO_EVENTS_DEVMATCH_EVENTS_DEVMATCH_Pos = 0x0
	// Bit mask of EVENTS_DEVMATCH field.
	RADIO_EVENTS_DEVMATCH_EVENTS_DEVMATCH_Msk = 0x1
	// Bit EVENTS_DEVMATCH.
	RADIO_EVENTS_DEVMATCH_EVENTS_DEVMATCH = 0x1
	// Event not generated
	RADIO_EVENTS_DEVMATCH_EVENTS_DEVMATCH_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_DEVMATCH_EVENTS_DEVMATCH_Generated = 0x1

	// EVENTS_DEVMISS: No device address match occurred on the last received packet
	// Position of EVENTS_DEVMISS field.
	RADIO_EVENTS_DEVMISS_EVENTS_DEVMISS_Pos = 0x0
	// Bit mask of EVENTS_DEVMISS field.
	RADIO_EVENTS_DEVMISS_EVENTS_DEVMISS_Msk = 0x1
	// Bit EVENTS_DEVMISS.
	RADIO_EVENTS_DEVMISS_EVENTS_DEVMISS = 0x1
	// Event not generated
	RADIO_EVENTS_DEVMISS_EVENTS_DEVMISS_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_DEVMISS_EVENTS_DEVMISS_Generated = 0x1

	// EVENTS_RSSIEND: Sampling of receive signal strength complete
	// Position of EVENTS_RSSIEND field.
	RADIO_EVENTS_RSSIEND_EVENTS_RSSIEND_Pos = 0x0
	// Bit mask of EVENTS_RSSIEND field.
	RADIO_EVENTS_RSSIEND_EVENTS_RSSIEND_Msk = 0x1
	// Bit EVENTS_RSSIEND.
	RADIO_EVENTS_RSSIEND_EVENTS_RSSIEND = 0x1
	// Event not generated
	RADIO_EVENTS_RSSIEND_EVENTS_RSSIEND_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_RSSIEND_EVENTS_RSSIEND_Generated = 0x1

	// EVENTS_BCMATCH: Bit counter reached bit count value
	// Position of EVENTS_BCMATCH field.
	RADIO_EVENTS_BCMATCH_EVENTS_BCMATCH_Pos = 0x0
	// Bit mask of EVENTS_BCMATCH field.
	RADIO_EVENTS_BCMATCH_EVENTS_BCMATCH_Msk = 0x1
	// Bit EVENTS_BCMATCH.
	RADIO_EVENTS_BCMATCH_EVENTS_BCMATCH = 0x1
	// Event not generated
	RADIO_EVENTS_BCMATCH_EVENTS_BCMATCH_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_BCMATCH_EVENTS_BCMATCH_Generated = 0x1

	// EVENTS_CRCOK: Packet received with CRC ok
	// Position of EVENTS_CRCOK field.
	RADIO_EVENTS_CRCOK_EVENTS_CRCOK_Pos = 0x0
	// Bit mask of EVENTS_CRCOK field.
	RADIO_EVENTS_CRCOK_EVENTS_CRCOK_Msk = 0x1
	// Bit EVENTS_CRCOK.
	RADIO_EVENTS_CRCOK_EVENTS_CRCOK = 0x1
	// Event not generated
	RADIO_EVENTS_CRCOK_EVENTS_CRCOK_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_CRCOK_EVENTS_CRCOK_Generated = 0x1

	// EVENTS_CRCERROR: Packet received with CRC error
	// Position of EVENTS_CRCERROR field.
	RADIO_EVENTS_CRCERROR_EVENTS_CRCERROR_Pos = 0x0
	// Bit mask of EVENTS_CRCERROR field.
	RADIO_EVENTS_CRCERROR_EVENTS_CRCERROR_Msk = 0x1
	// Bit EVENTS_CRCERROR.
	RADIO_EVENTS_CRCERROR_EVENTS_CRCERROR = 0x1
	// Event not generated
	RADIO_EVENTS_CRCERROR_EVENTS_CRCERROR_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_CRCERROR_EVENTS_CRCERROR_Generated = 0x1

	// EVENTS_FRAMESTART: IEEE 802.15.4 length field received
	// Position of EVENTS_FRAMESTART field.
	RADIO_EVENTS_FRAMESTART_EVENTS_FRAMESTART_Pos = 0x0
	// Bit mask of EVENTS_FRAMESTART field.
	RADIO_EVENTS_FRAMESTART_EVENTS_FRAMESTART_Msk = 0x1
	// Bit EVENTS_FRAMESTART.
	RADIO_EVENTS_FRAMESTART_EVENTS_FRAMESTART = 0x1
	// Event not generated
	RADIO_EVENTS_FRAMESTART_EVENTS_FRAMESTART_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_FRAMESTART_EVENTS_FRAMESTART_Generated = 0x1

	// EVENTS_EDEND: Sampling of energy detection complete. A new ED sample is ready for readout from the RADIO.EDSAMPLE register
	// Position of EVENTS_EDEND field.
	RADIO_EVENTS_EDEND_EVENTS_EDEND_Pos = 0x0
	// Bit mask of EVENTS_EDEND field.
	RADIO_EVENTS_EDEND_EVENTS_EDEND_Msk = 0x1
	// Bit EVENTS_EDEND.
	RADIO_EVENTS_EDEND_EVENTS_EDEND = 0x1
	// Event not generated
	RADIO_EVENTS_EDEND_EVENTS_EDEND_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_EDEND_EVENTS_EDEND_Generated = 0x1

	// EVENTS_EDSTOPPED: The sampling of energy detection has stopped
	// Position of EVENTS_EDSTOPPED field.
	RADIO_EVENTS_EDSTOPPED_EVENTS_EDSTOPPED_Pos = 0x0
	// Bit mask of EVENTS_EDSTOPPED field.
	RADIO_EVENTS_EDSTOPPED_EVENTS_EDSTOPPED_Msk = 0x1
	// Bit EVENTS_EDSTOPPED.
	RADIO_EVENTS_EDSTOPPED_EVENTS_EDSTOPPED = 0x1
	// Event not generated
	RADIO_EVENTS_EDSTOPPED_EVENTS_EDSTOPPED_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_EDSTOPPED_EVENTS_EDSTOPPED_Generated = 0x1

	// EVENTS_CCAIDLE: Wireless medium in idle - clear to send
	// Position of EVENTS_CCAIDLE field.
	RADIO_EVENTS_CCAIDLE_EVENTS_CCAIDLE_Pos = 0x0
	// Bit mask of EVENTS_CCAIDLE field.
	RADIO_EVENTS_CCAIDLE_EVENTS_CCAIDLE_Msk = 0x1
	// Bit EVENTS_CCAIDLE.
	RADIO_EVENTS_CCAIDLE_EVENTS_CCAIDLE = 0x1
	// Event not generated
	RADIO_EVENTS_CCAIDLE_EVENTS_CCAIDLE_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_CCAIDLE_EVENTS_CCAIDLE_Generated = 0x1

	// EVENTS_CCABUSY: Wireless medium busy - do not send
	// Position of EVENTS_CCABUSY field.
	RADIO_EVENTS_CCABUSY_EVENTS_CCABUSY_Pos = 0x0
	// Bit mask of EVENTS_CCABUSY field.
	RADIO_EVENTS_CCABUSY_EVENTS_CCABUSY_Msk = 0x1
	// Bit EVENTS_CCABUSY.
	RADIO_EVENTS_CCABUSY_EVENTS_CCABUSY = 0x1
	// Event not generated
	RADIO_EVENTS_CCABUSY_EVENTS_CCABUSY_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_CCABUSY_EVENTS_CCABUSY_Generated = 0x1

	// EVENTS_CCASTOPPED: The CCA has stopped
	// Position of EVENTS_CCASTOPPED field.
	RADIO_EVENTS_CCASTOPPED_EVENTS_CCASTOPPED_Pos = 0x0
	// Bit mask of EVENTS_CCASTOPPED field.
	RADIO_EVENTS_CCASTOPPED_EVENTS_CCASTOPPED_Msk = 0x1
	// Bit EVENTS_CCASTOPPED.
	RADIO_EVENTS_CCASTOPPED_EVENTS_CCASTOPPED = 0x1
	// Event not generated
	RADIO_EVENTS_CCASTOPPED_EVENTS_CCASTOPPED_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_CCASTOPPED_EVENTS_CCASTOPPED_Generated = 0x1

	// EVENTS_RATEBOOST: Ble_LR CI field received, receive mode is changed from Ble_LR125Kbit to Ble_LR500Kbit.
	// Position of EVENTS_RATEBOOST field.
	RADIO_EVENTS_RATEBOOST_EVENTS_RATEBOOST_Pos = 0x0
	// Bit mask of EVENTS_RATEBOOST field.
	RADIO_EVENTS_RATEBOOST_EVENTS_RATEBOOST_Msk = 0x1
	// Bit EVENTS_RATEBOOST.
	RADIO_EVENTS_RATEBOOST_EVENTS_RATEBOOST = 0x1
	// Event not generated
	RADIO_EVENTS_RATEBOOST_EVENTS_RATEBOOST_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_RATEBOOST_EVENTS_RATEBOOST_Generated = 0x1

	// EVENTS_TXREADY: RADIO has ramped up and is ready to be started TX path
	// Position of EVENTS_TXREADY field.
	RADIO_EVENTS_TXREADY_EVENTS_TXREADY_Pos = 0x0
	// Bit mask of EVENTS_TXREADY field.
	RADIO_EVENTS_TXREADY_EVENTS_TXREADY_Msk = 0x1
	// Bit EVENTS_TXREADY.
	RADIO_EVENTS_TXREADY_EVENTS_TXREADY = 0x1
	// Event not generated
	RADIO_EVENTS_TXREADY_EVENTS_TXREADY_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_TXREADY_EVENTS_TXREADY_Generated = 0x1

	// EVENTS_RXREADY: RADIO has ramped up and is ready to be started RX path
	// Position of EVENTS_RXREADY field.
	RADIO_EVENTS_RXREADY_EVENTS_RXREADY_Pos = 0x0
	// Bit mask of EVENTS_RXREADY field.
	RADIO_EVENTS_RXREADY_EVENTS_RXREADY_Msk = 0x1
	// Bit EVENTS_RXREADY.
	RADIO_EVENTS_RXREADY_EVENTS_RXREADY = 0x1
	// Event not generated
	RADIO_EVENTS_RXREADY_EVENTS_RXREADY_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_RXREADY_EVENTS_RXREADY_Generated = 0x1

	// EVENTS_MHRMATCH: MAC header match found
	// Position of EVENTS_MHRMATCH field.
	RADIO_EVENTS_MHRMATCH_EVENTS_MHRMATCH_Pos = 0x0
	// Bit mask of EVENTS_MHRMATCH field.
	RADIO_EVENTS_MHRMATCH_EVENTS_MHRMATCH_Msk = 0x1
	// Bit EVENTS_MHRMATCH.
	RADIO_EVENTS_MHRMATCH_EVENTS_MHRMATCH = 0x1
	// Event not generated
	RADIO_EVENTS_MHRMATCH_EVENTS_MHRMATCH_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_MHRMATCH_EVENTS_MHRMATCH_Generated = 0x1

	// EVENTS_SYNC: Preamble indicator
	// Position of EVENTS_SYNC field.
	RADIO_EVENTS_SYNC_EVENTS_SYNC_Pos = 0x0
	// Bit mask of EVENTS_SYNC field.
	RADIO_EVENTS_SYNC_EVENTS_SYNC_Msk = 0x1
	// Bit EVENTS_SYNC.
	RADIO_EVENTS_SYNC_EVENTS_SYNC = 0x1
	// Event not generated
	RADIO_EVENTS_SYNC_EVENTS_SYNC_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_SYNC_EVENTS_SYNC_Generated = 0x1

	// EVENTS_PHYEND: Generated when last bit is sent on air, or received from air
	// Position of EVENTS_PHYEND field.
	RADIO_EVENTS_PHYEND_EVENTS_PHYEND_Pos = 0x0
	// Bit mask of EVENTS_PHYEND field.
	RADIO_EVENTS_PHYEND_EVENTS_PHYEND_Msk = 0x1
	// Bit EVENTS_PHYEND.
	RADIO_EVENTS_PHYEND_EVENTS_PHYEND = 0x1
	// Event not generated
	RADIO_EVENTS_PHYEND_EVENTS_PHYEND_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_PHYEND_EVENTS_PHYEND_Generated = 0x1

	// EVENTS_CTEPRESENT: CTE is present (early warning right after receiving CTEInfo byte)
	// Position of EVENTS_CTEPRESENT field.
	RADIO_EVENTS_CTEPRESENT_EVENTS_CTEPRESENT_Pos = 0x0
	// Bit mask of EVENTS_CTEPRESENT field.
	RADIO_EVENTS_CTEPRESENT_EVENTS_CTEPRESENT_Msk = 0x1
	// Bit EVENTS_CTEPRESENT.
	RADIO_EVENTS_CTEPRESENT_EVENTS_CTEPRESENT = 0x1
	// Event not generated
	RADIO_EVENTS_CTEPRESENT_EVENTS_CTEPRESENT_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_CTEPRESENT_EVENTS_CTEPRESENT_Generated = 0x1

	// PUBLISH_READY: Publish configuration for event READY
	// Position of CHIDX field.
	RADIO_PUBLISH_READY_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_PUBLISH_READY_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_PUBLISH_READY_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_PUBLISH_READY_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_PUBLISH_READY_EN = 0x80000000
	// Disable publishing
	RADIO_PUBLISH_READY_EN_Disabled = 0x0
	// Enable publishing
	RADIO_PUBLISH_READY_EN_Enabled = 0x1

	// PUBLISH_ADDRESS: Publish configuration for event ADDRESS
	// Position of CHIDX field.
	RADIO_PUBLISH_ADDRESS_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_PUBLISH_ADDRESS_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_PUBLISH_ADDRESS_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_PUBLISH_ADDRESS_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_PUBLISH_ADDRESS_EN = 0x80000000
	// Disable publishing
	RADIO_PUBLISH_ADDRESS_EN_Disabled = 0x0
	// Enable publishing
	RADIO_PUBLISH_ADDRESS_EN_Enabled = 0x1

	// PUBLISH_PAYLOAD: Publish configuration for event PAYLOAD
	// Position of CHIDX field.
	RADIO_PUBLISH_PAYLOAD_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_PUBLISH_PAYLOAD_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_PUBLISH_PAYLOAD_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_PUBLISH_PAYLOAD_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_PUBLISH_PAYLOAD_EN = 0x80000000
	// Disable publishing
	RADIO_PUBLISH_PAYLOAD_EN_Disabled = 0x0
	// Enable publishing
	RADIO_PUBLISH_PAYLOAD_EN_Enabled = 0x1

	// PUBLISH_END: Publish configuration for event END
	// Position of CHIDX field.
	RADIO_PUBLISH_END_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_PUBLISH_END_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_PUBLISH_END_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_PUBLISH_END_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_PUBLISH_END_EN = 0x80000000
	// Disable publishing
	RADIO_PUBLISH_END_EN_Disabled = 0x0
	// Enable publishing
	RADIO_PUBLISH_END_EN_Enabled = 0x1

	// PUBLISH_DISABLED: Publish configuration for event DISABLED
	// Position of CHIDX field.
	RADIO_PUBLISH_DISABLED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_PUBLISH_DISABLED_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_PUBLISH_DISABLED_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_PUBLISH_DISABLED_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_PUBLISH_DISABLED_EN = 0x80000000
	// Disable publishing
	RADIO_PUBLISH_DISABLED_EN_Disabled = 0x0
	// Enable publishing
	RADIO_PUBLISH_DISABLED_EN_Enabled = 0x1

	// PUBLISH_DEVMATCH: Publish configuration for event DEVMATCH
	// Position of CHIDX field.
	RADIO_PUBLISH_DEVMATCH_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_PUBLISH_DEVMATCH_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_PUBLISH_DEVMATCH_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_PUBLISH_DEVMATCH_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_PUBLISH_DEVMATCH_EN = 0x80000000
	// Disable publishing
	RADIO_PUBLISH_DEVMATCH_EN_Disabled = 0x0
	// Enable publishing
	RADIO_PUBLISH_DEVMATCH_EN_Enabled = 0x1

	// PUBLISH_DEVMISS: Publish configuration for event DEVMISS
	// Position of CHIDX field.
	RADIO_PUBLISH_DEVMISS_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_PUBLISH_DEVMISS_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_PUBLISH_DEVMISS_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_PUBLISH_DEVMISS_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_PUBLISH_DEVMISS_EN = 0x80000000
	// Disable publishing
	RADIO_PUBLISH_DEVMISS_EN_Disabled = 0x0
	// Enable publishing
	RADIO_PUBLISH_DEVMISS_EN_Enabled = 0x1

	// PUBLISH_RSSIEND: Publish configuration for event RSSIEND
	// Position of CHIDX field.
	RADIO_PUBLISH_RSSIEND_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_PUBLISH_RSSIEND_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_PUBLISH_RSSIEND_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_PUBLISH_RSSIEND_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_PUBLISH_RSSIEND_EN = 0x80000000
	// Disable publishing
	RADIO_PUBLISH_RSSIEND_EN_Disabled = 0x0
	// Enable publishing
	RADIO_PUBLISH_RSSIEND_EN_Enabled = 0x1

	// PUBLISH_BCMATCH: Publish configuration for event BCMATCH
	// Position of CHIDX field.
	RADIO_PUBLISH_BCMATCH_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_PUBLISH_BCMATCH_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_PUBLISH_BCMATCH_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_PUBLISH_BCMATCH_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_PUBLISH_BCMATCH_EN = 0x80000000
	// Disable publishing
	RADIO_PUBLISH_BCMATCH_EN_Disabled = 0x0
	// Enable publishing
	RADIO_PUBLISH_BCMATCH_EN_Enabled = 0x1

	// PUBLISH_CRCOK: Publish configuration for event CRCOK
	// Position of CHIDX field.
	RADIO_PUBLISH_CRCOK_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_PUBLISH_CRCOK_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_PUBLISH_CRCOK_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_PUBLISH_CRCOK_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_PUBLISH_CRCOK_EN = 0x80000000
	// Disable publishing
	RADIO_PUBLISH_CRCOK_EN_Disabled = 0x0
	// Enable publishing
	RADIO_PUBLISH_CRCOK_EN_Enabled = 0x1

	// PUBLISH_CRCERROR: Publish configuration for event CRCERROR
	// Position of CHIDX field.
	RADIO_PUBLISH_CRCERROR_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_PUBLISH_CRCERROR_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_PUBLISH_CRCERROR_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_PUBLISH_CRCERROR_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_PUBLISH_CRCERROR_EN = 0x80000000
	// Disable publishing
	RADIO_PUBLISH_CRCERROR_EN_Disabled = 0x0
	// Enable publishing
	RADIO_PUBLISH_CRCERROR_EN_Enabled = 0x1

	// PUBLISH_FRAMESTART: Publish configuration for event FRAMESTART
	// Position of CHIDX field.
	RADIO_PUBLISH_FRAMESTART_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_PUBLISH_FRAMESTART_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_PUBLISH_FRAMESTART_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_PUBLISH_FRAMESTART_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_PUBLISH_FRAMESTART_EN = 0x80000000
	// Disable publishing
	RADIO_PUBLISH_FRAMESTART_EN_Disabled = 0x0
	// Enable publishing
	RADIO_PUBLISH_FRAMESTART_EN_Enabled = 0x1

	// PUBLISH_EDEND: Publish configuration for event EDEND
	// Position of CHIDX field.
	RADIO_PUBLISH_EDEND_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_PUBLISH_EDEND_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_PUBLISH_EDEND_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_PUBLISH_EDEND_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_PUBLISH_EDEND_EN = 0x80000000
	// Disable publishing
	RADIO_PUBLISH_EDEND_EN_Disabled = 0x0
	// Enable publishing
	RADIO_PUBLISH_EDEND_EN_Enabled = 0x1

	// PUBLISH_EDSTOPPED: Publish configuration for event EDSTOPPED
	// Position of CHIDX field.
	RADIO_PUBLISH_EDSTOPPED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_PUBLISH_EDSTOPPED_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_PUBLISH_EDSTOPPED_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_PUBLISH_EDSTOPPED_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_PUBLISH_EDSTOPPED_EN = 0x80000000
	// Disable publishing
	RADIO_PUBLISH_EDSTOPPED_EN_Disabled = 0x0
	// Enable publishing
	RADIO_PUBLISH_EDSTOPPED_EN_Enabled = 0x1

	// PUBLISH_CCAIDLE: Publish configuration for event CCAIDLE
	// Position of CHIDX field.
	RADIO_PUBLISH_CCAIDLE_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_PUBLISH_CCAIDLE_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_PUBLISH_CCAIDLE_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_PUBLISH_CCAIDLE_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_PUBLISH_CCAIDLE_EN = 0x80000000
	// Disable publishing
	RADIO_PUBLISH_CCAIDLE_EN_Disabled = 0x0
	// Enable publishing
	RADIO_PUBLISH_CCAIDLE_EN_Enabled = 0x1

	// PUBLISH_CCABUSY: Publish configuration for event CCABUSY
	// Position of CHIDX field.
	RADIO_PUBLISH_CCABUSY_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_PUBLISH_CCABUSY_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_PUBLISH_CCABUSY_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_PUBLISH_CCABUSY_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_PUBLISH_CCABUSY_EN = 0x80000000
	// Disable publishing
	RADIO_PUBLISH_CCABUSY_EN_Disabled = 0x0
	// Enable publishing
	RADIO_PUBLISH_CCABUSY_EN_Enabled = 0x1

	// PUBLISH_CCASTOPPED: Publish configuration for event CCASTOPPED
	// Position of CHIDX field.
	RADIO_PUBLISH_CCASTOPPED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_PUBLISH_CCASTOPPED_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_PUBLISH_CCASTOPPED_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_PUBLISH_CCASTOPPED_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_PUBLISH_CCASTOPPED_EN = 0x80000000
	// Disable publishing
	RADIO_PUBLISH_CCASTOPPED_EN_Disabled = 0x0
	// Enable publishing
	RADIO_PUBLISH_CCASTOPPED_EN_Enabled = 0x1

	// PUBLISH_RATEBOOST: Publish configuration for event RATEBOOST
	// Position of CHIDX field.
	RADIO_PUBLISH_RATEBOOST_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_PUBLISH_RATEBOOST_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_PUBLISH_RATEBOOST_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_PUBLISH_RATEBOOST_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_PUBLISH_RATEBOOST_EN = 0x80000000
	// Disable publishing
	RADIO_PUBLISH_RATEBOOST_EN_Disabled = 0x0
	// Enable publishing
	RADIO_PUBLISH_RATEBOOST_EN_Enabled = 0x1

	// PUBLISH_TXREADY: Publish configuration for event TXREADY
	// Position of CHIDX field.
	RADIO_PUBLISH_TXREADY_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_PUBLISH_TXREADY_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_PUBLISH_TXREADY_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_PUBLISH_TXREADY_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_PUBLISH_TXREADY_EN = 0x80000000
	// Disable publishing
	RADIO_PUBLISH_TXREADY_EN_Disabled = 0x0
	// Enable publishing
	RADIO_PUBLISH_TXREADY_EN_Enabled = 0x1

	// PUBLISH_RXREADY: Publish configuration for event RXREADY
	// Position of CHIDX field.
	RADIO_PUBLISH_RXREADY_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_PUBLISH_RXREADY_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_PUBLISH_RXREADY_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_PUBLISH_RXREADY_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_PUBLISH_RXREADY_EN = 0x80000000
	// Disable publishing
	RADIO_PUBLISH_RXREADY_EN_Disabled = 0x0
	// Enable publishing
	RADIO_PUBLISH_RXREADY_EN_Enabled = 0x1

	// PUBLISH_MHRMATCH: Publish configuration for event MHRMATCH
	// Position of CHIDX field.
	RADIO_PUBLISH_MHRMATCH_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_PUBLISH_MHRMATCH_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_PUBLISH_MHRMATCH_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_PUBLISH_MHRMATCH_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_PUBLISH_MHRMATCH_EN = 0x80000000
	// Disable publishing
	RADIO_PUBLISH_MHRMATCH_EN_Disabled = 0x0
	// Enable publishing
	RADIO_PUBLISH_MHRMATCH_EN_Enabled = 0x1

	// PUBLISH_SYNC: Publish configuration for event SYNC
	// Position of CHIDX field.
	RADIO_PUBLISH_SYNC_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_PUBLISH_SYNC_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_PUBLISH_SYNC_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_PUBLISH_SYNC_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_PUBLISH_SYNC_EN = 0x80000000
	// Disable publishing
	RADIO_PUBLISH_SYNC_EN_Disabled = 0x0
	// Enable publishing
	RADIO_PUBLISH_SYNC_EN_Enabled = 0x1

	// PUBLISH_PHYEND: Publish configuration for event PHYEND
	// Position of CHIDX field.
	RADIO_PUBLISH_PHYEND_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_PUBLISH_PHYEND_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_PUBLISH_PHYEND_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_PUBLISH_PHYEND_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_PUBLISH_PHYEND_EN = 0x80000000
	// Disable publishing
	RADIO_PUBLISH_PHYEND_EN_Disabled = 0x0
	// Enable publishing
	RADIO_PUBLISH_PHYEND_EN_Enabled = 0x1

	// PUBLISH_CTEPRESENT: Publish configuration for event CTEPRESENT
	// Position of CHIDX field.
	RADIO_PUBLISH_CTEPRESENT_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_PUBLISH_CTEPRESENT_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_PUBLISH_CTEPRESENT_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_PUBLISH_CTEPRESENT_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_PUBLISH_CTEPRESENT_EN = 0x80000000
	// Disable publishing
	RADIO_PUBLISH_CTEPRESENT_EN_Disabled = 0x0
	// Enable publishing
	RADIO_PUBLISH_CTEPRESENT_EN_Enabled = 0x1

	// SHORTS: Shortcuts between local events and tasks
	// Position of READY_START field.
	RADIO_SHORTS_READY_START_Pos = 0x0
	// Bit mask of READY_START field.
	RADIO_SHORTS_READY_START_Msk = 0x1
	// Bit READY_START.
	RADIO_SHORTS_READY_START = 0x1
	// Disable shortcut
	RADIO_SHORTS_READY_START_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_READY_START_Enabled = 0x1
	// Position of END_DISABLE field.
	RADIO_SHORTS_END_DISABLE_Pos = 0x1
	// Bit mask of END_DISABLE field.
	RADIO_SHORTS_END_DISABLE_Msk = 0x2
	// Bit END_DISABLE.
	RADIO_SHORTS_END_DISABLE = 0x2
	// Disable shortcut
	RADIO_SHORTS_END_DISABLE_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_END_DISABLE_Enabled = 0x1
	// Position of DISABLED_TXEN field.
	RADIO_SHORTS_DISABLED_TXEN_Pos = 0x2
	// Bit mask of DISABLED_TXEN field.
	RADIO_SHORTS_DISABLED_TXEN_Msk = 0x4
	// Bit DISABLED_TXEN.
	RADIO_SHORTS_DISABLED_TXEN = 0x4
	// Disable shortcut
	RADIO_SHORTS_DISABLED_TXEN_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_DISABLED_TXEN_Enabled = 0x1
	// Position of DISABLED_RXEN field.
	RADIO_SHORTS_DISABLED_RXEN_Pos = 0x3
	// Bit mask of DISABLED_RXEN field.
	RADIO_SHORTS_DISABLED_RXEN_Msk = 0x8
	// Bit DISABLED_RXEN.
	RADIO_SHORTS_DISABLED_RXEN = 0x8
	// Disable shortcut
	RADIO_SHORTS_DISABLED_RXEN_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_DISABLED_RXEN_Enabled = 0x1
	// Position of ADDRESS_RSSISTART field.
	RADIO_SHORTS_ADDRESS_RSSISTART_Pos = 0x4
	// Bit mask of ADDRESS_RSSISTART field.
	RADIO_SHORTS_ADDRESS_RSSISTART_Msk = 0x10
	// Bit ADDRESS_RSSISTART.
	RADIO_SHORTS_ADDRESS_RSSISTART = 0x10
	// Disable shortcut
	RADIO_SHORTS_ADDRESS_RSSISTART_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_ADDRESS_RSSISTART_Enabled = 0x1
	// Position of END_START field.
	RADIO_SHORTS_END_START_Pos = 0x5
	// Bit mask of END_START field.
	RADIO_SHORTS_END_START_Msk = 0x20
	// Bit END_START.
	RADIO_SHORTS_END_START = 0x20
	// Disable shortcut
	RADIO_SHORTS_END_START_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_END_START_Enabled = 0x1
	// Position of ADDRESS_BCSTART field.
	RADIO_SHORTS_ADDRESS_BCSTART_Pos = 0x6
	// Bit mask of ADDRESS_BCSTART field.
	RADIO_SHORTS_ADDRESS_BCSTART_Msk = 0x40
	// Bit ADDRESS_BCSTART.
	RADIO_SHORTS_ADDRESS_BCSTART = 0x40
	// Disable shortcut
	RADIO_SHORTS_ADDRESS_BCSTART_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_ADDRESS_BCSTART_Enabled = 0x1
	// Position of DISABLED_RSSISTOP field.
	RADIO_SHORTS_DISABLED_RSSISTOP_Pos = 0x8
	// Bit mask of DISABLED_RSSISTOP field.
	RADIO_SHORTS_DISABLED_RSSISTOP_Msk = 0x100
	// Bit DISABLED_RSSISTOP.
	RADIO_SHORTS_DISABLED_RSSISTOP = 0x100
	// Disable shortcut
	RADIO_SHORTS_DISABLED_RSSISTOP_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_DISABLED_RSSISTOP_Enabled = 0x1
	// Position of RXREADY_CCASTART field.
	RADIO_SHORTS_RXREADY_CCASTART_Pos = 0xb
	// Bit mask of RXREADY_CCASTART field.
	RADIO_SHORTS_RXREADY_CCASTART_Msk = 0x800
	// Bit RXREADY_CCASTART.
	RADIO_SHORTS_RXREADY_CCASTART = 0x800
	// Disable shortcut
	RADIO_SHORTS_RXREADY_CCASTART_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_RXREADY_CCASTART_Enabled = 0x1
	// Position of CCAIDLE_TXEN field.
	RADIO_SHORTS_CCAIDLE_TXEN_Pos = 0xc
	// Bit mask of CCAIDLE_TXEN field.
	RADIO_SHORTS_CCAIDLE_TXEN_Msk = 0x1000
	// Bit CCAIDLE_TXEN.
	RADIO_SHORTS_CCAIDLE_TXEN = 0x1000
	// Disable shortcut
	RADIO_SHORTS_CCAIDLE_TXEN_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_CCAIDLE_TXEN_Enabled = 0x1
	// Position of CCABUSY_DISABLE field.
	RADIO_SHORTS_CCABUSY_DISABLE_Pos = 0xd
	// Bit mask of CCABUSY_DISABLE field.
	RADIO_SHORTS_CCABUSY_DISABLE_Msk = 0x2000
	// Bit CCABUSY_DISABLE.
	RADIO_SHORTS_CCABUSY_DISABLE = 0x2000
	// Disable shortcut
	RADIO_SHORTS_CCABUSY_DISABLE_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_CCABUSY_DISABLE_Enabled = 0x1
	// Position of FRAMESTART_BCSTART field.
	RADIO_SHORTS_FRAMESTART_BCSTART_Pos = 0xe
	// Bit mask of FRAMESTART_BCSTART field.
	RADIO_SHORTS_FRAMESTART_BCSTART_Msk = 0x4000
	// Bit FRAMESTART_BCSTART.
	RADIO_SHORTS_FRAMESTART_BCSTART = 0x4000
	// Disable shortcut
	RADIO_SHORTS_FRAMESTART_BCSTART_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_FRAMESTART_BCSTART_Enabled = 0x1
	// Position of READY_EDSTART field.
	RADIO_SHORTS_READY_EDSTART_Pos = 0xf
	// Bit mask of READY_EDSTART field.
	RADIO_SHORTS_READY_EDSTART_Msk = 0x8000
	// Bit READY_EDSTART.
	RADIO_SHORTS_READY_EDSTART = 0x8000
	// Disable shortcut
	RADIO_SHORTS_READY_EDSTART_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_READY_EDSTART_Enabled = 0x1
	// Position of EDEND_DISABLE field.
	RADIO_SHORTS_EDEND_DISABLE_Pos = 0x10
	// Bit mask of EDEND_DISABLE field.
	RADIO_SHORTS_EDEND_DISABLE_Msk = 0x10000
	// Bit EDEND_DISABLE.
	RADIO_SHORTS_EDEND_DISABLE = 0x10000
	// Disable shortcut
	RADIO_SHORTS_EDEND_DISABLE_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_EDEND_DISABLE_Enabled = 0x1
	// Position of CCAIDLE_STOP field.
	RADIO_SHORTS_CCAIDLE_STOP_Pos = 0x11
	// Bit mask of CCAIDLE_STOP field.
	RADIO_SHORTS_CCAIDLE_STOP_Msk = 0x20000
	// Bit CCAIDLE_STOP.
	RADIO_SHORTS_CCAIDLE_STOP = 0x20000
	// Disable shortcut
	RADIO_SHORTS_CCAIDLE_STOP_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_CCAIDLE_STOP_Enabled = 0x1
	// Position of TXREADY_START field.
	RADIO_SHORTS_TXREADY_START_Pos = 0x12
	// Bit mask of TXREADY_START field.
	RADIO_SHORTS_TXREADY_START_Msk = 0x40000
	// Bit TXREADY_START.
	RADIO_SHORTS_TXREADY_START = 0x40000
	// Disable shortcut
	RADIO_SHORTS_TXREADY_START_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_TXREADY_START_Enabled = 0x1
	// Position of RXREADY_START field.
	RADIO_SHORTS_RXREADY_START_Pos = 0x13
	// Bit mask of RXREADY_START field.
	RADIO_SHORTS_RXREADY_START_Msk = 0x80000
	// Bit RXREADY_START.
	RADIO_SHORTS_RXREADY_START = 0x80000
	// Disable shortcut
	RADIO_SHORTS_RXREADY_START_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_RXREADY_START_Enabled = 0x1
	// Position of PHYEND_DISABLE field.
	RADIO_SHORTS_PHYEND_DISABLE_Pos = 0x14
	// Bit mask of PHYEND_DISABLE field.
	RADIO_SHORTS_PHYEND_DISABLE_Msk = 0x100000
	// Bit PHYEND_DISABLE.
	RADIO_SHORTS_PHYEND_DISABLE = 0x100000
	// Disable shortcut
	RADIO_SHORTS_PHYEND_DISABLE_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_PHYEND_DISABLE_Enabled = 0x1
	// Position of PHYEND_START field.
	RADIO_SHORTS_PHYEND_START_Pos = 0x15
	// Bit mask of PHYEND_START field.
	RADIO_SHORTS_PHYEND_START_Msk = 0x200000
	// Bit PHYEND_START.
	RADIO_SHORTS_PHYEND_START = 0x200000
	// Disable shortcut
	RADIO_SHORTS_PHYEND_START_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_PHYEND_START_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of READY field.
	RADIO_INTENSET_READY_Pos = 0x0
	// Bit mask of READY field.
	RADIO_INTENSET_READY_Msk = 0x1
	// Bit READY.
	RADIO_INTENSET_READY = 0x1
	// Read: Disabled
	RADIO_INTENSET_READY_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_READY_Enabled = 0x1
	// Enable
	RADIO_INTENSET_READY_Set = 0x1
	// Position of ADDRESS field.
	RADIO_INTENSET_ADDRESS_Pos = 0x1
	// Bit mask of ADDRESS field.
	RADIO_INTENSET_ADDRESS_Msk = 0x2
	// Bit ADDRESS.
	RADIO_INTENSET_ADDRESS = 0x2
	// Read: Disabled
	RADIO_INTENSET_ADDRESS_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_ADDRESS_Enabled = 0x1
	// Enable
	RADIO_INTENSET_ADDRESS_Set = 0x1
	// Position of PAYLOAD field.
	RADIO_INTENSET_PAYLOAD_Pos = 0x2
	// Bit mask of PAYLOAD field.
	RADIO_INTENSET_PAYLOAD_Msk = 0x4
	// Bit PAYLOAD.
	RADIO_INTENSET_PAYLOAD = 0x4
	// Read: Disabled
	RADIO_INTENSET_PAYLOAD_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_PAYLOAD_Enabled = 0x1
	// Enable
	RADIO_INTENSET_PAYLOAD_Set = 0x1
	// Position of END field.
	RADIO_INTENSET_END_Pos = 0x3
	// Bit mask of END field.
	RADIO_INTENSET_END_Msk = 0x8
	// Bit END.
	RADIO_INTENSET_END = 0x8
	// Read: Disabled
	RADIO_INTENSET_END_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_END_Enabled = 0x1
	// Enable
	RADIO_INTENSET_END_Set = 0x1
	// Position of DISABLED field.
	RADIO_INTENSET_DISABLED_Pos = 0x4
	// Bit mask of DISABLED field.
	RADIO_INTENSET_DISABLED_Msk = 0x10
	// Bit DISABLED.
	RADIO_INTENSET_DISABLED = 0x10
	// Read: Disabled
	RADIO_INTENSET_DISABLED_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_DISABLED_Enabled = 0x1
	// Enable
	RADIO_INTENSET_DISABLED_Set = 0x1
	// Position of DEVMATCH field.
	RADIO_INTENSET_DEVMATCH_Pos = 0x5
	// Bit mask of DEVMATCH field.
	RADIO_INTENSET_DEVMATCH_Msk = 0x20
	// Bit DEVMATCH.
	RADIO_INTENSET_DEVMATCH = 0x20
	// Read: Disabled
	RADIO_INTENSET_DEVMATCH_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_DEVMATCH_Enabled = 0x1
	// Enable
	RADIO_INTENSET_DEVMATCH_Set = 0x1
	// Position of DEVMISS field.
	RADIO_INTENSET_DEVMISS_Pos = 0x6
	// Bit mask of DEVMISS field.
	RADIO_INTENSET_DEVMISS_Msk = 0x40
	// Bit DEVMISS.
	RADIO_INTENSET_DEVMISS = 0x40
	// Read: Disabled
	RADIO_INTENSET_DEVMISS_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_DEVMISS_Enabled = 0x1
	// Enable
	RADIO_INTENSET_DEVMISS_Set = 0x1
	// Position of RSSIEND field.
	RADIO_INTENSET_RSSIEND_Pos = 0x7
	// Bit mask of RSSIEND field.
	RADIO_INTENSET_RSSIEND_Msk = 0x80
	// Bit RSSIEND.
	RADIO_INTENSET_RSSIEND = 0x80
	// Read: Disabled
	RADIO_INTENSET_RSSIEND_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_RSSIEND_Enabled = 0x1
	// Enable
	RADIO_INTENSET_RSSIEND_Set = 0x1
	// Position of BCMATCH field.
	RADIO_INTENSET_BCMATCH_Pos = 0xa
	// Bit mask of BCMATCH field.
	RADIO_INTENSET_BCMATCH_Msk = 0x400
	// Bit BCMATCH.
	RADIO_INTENSET_BCMATCH = 0x400
	// Read: Disabled
	RADIO_INTENSET_BCMATCH_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_BCMATCH_Enabled = 0x1
	// Enable
	RADIO_INTENSET_BCMATCH_Set = 0x1
	// Position of CRCOK field.
	RADIO_INTENSET_CRCOK_Pos = 0xc
	// Bit mask of CRCOK field.
	RADIO_INTENSET_CRCOK_Msk = 0x1000
	// Bit CRCOK.
	RADIO_INTENSET_CRCOK = 0x1000
	// Read: Disabled
	RADIO_INTENSET_CRCOK_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_CRCOK_Enabled = 0x1
	// Enable
	RADIO_INTENSET_CRCOK_Set = 0x1
	// Position of CRCERROR field.
	RADIO_INTENSET_CRCERROR_Pos = 0xd
	// Bit mask of CRCERROR field.
	RADIO_INTENSET_CRCERROR_Msk = 0x2000
	// Bit CRCERROR.
	RADIO_INTENSET_CRCERROR = 0x2000
	// Read: Disabled
	RADIO_INTENSET_CRCERROR_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_CRCERROR_Enabled = 0x1
	// Enable
	RADIO_INTENSET_CRCERROR_Set = 0x1
	// Position of FRAMESTART field.
	RADIO_INTENSET_FRAMESTART_Pos = 0xe
	// Bit mask of FRAMESTART field.
	RADIO_INTENSET_FRAMESTART_Msk = 0x4000
	// Bit FRAMESTART.
	RADIO_INTENSET_FRAMESTART = 0x4000
	// Read: Disabled
	RADIO_INTENSET_FRAMESTART_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_FRAMESTART_Enabled = 0x1
	// Enable
	RADIO_INTENSET_FRAMESTART_Set = 0x1
	// Position of EDEND field.
	RADIO_INTENSET_EDEND_Pos = 0xf
	// Bit mask of EDEND field.
	RADIO_INTENSET_EDEND_Msk = 0x8000
	// Bit EDEND.
	RADIO_INTENSET_EDEND = 0x8000
	// Read: Disabled
	RADIO_INTENSET_EDEND_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_EDEND_Enabled = 0x1
	// Enable
	RADIO_INTENSET_EDEND_Set = 0x1
	// Position of EDSTOPPED field.
	RADIO_INTENSET_EDSTOPPED_Pos = 0x10
	// Bit mask of EDSTOPPED field.
	RADIO_INTENSET_EDSTOPPED_Msk = 0x10000
	// Bit EDSTOPPED.
	RADIO_INTENSET_EDSTOPPED = 0x10000
	// Read: Disabled
	RADIO_INTENSET_EDSTOPPED_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_EDSTOPPED_Enabled = 0x1
	// Enable
	RADIO_INTENSET_EDSTOPPED_Set = 0x1
	// Position of CCAIDLE field.
	RADIO_INTENSET_CCAIDLE_Pos = 0x11
	// Bit mask of CCAIDLE field.
	RADIO_INTENSET_CCAIDLE_Msk = 0x20000
	// Bit CCAIDLE.
	RADIO_INTENSET_CCAIDLE = 0x20000
	// Read: Disabled
	RADIO_INTENSET_CCAIDLE_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_CCAIDLE_Enabled = 0x1
	// Enable
	RADIO_INTENSET_CCAIDLE_Set = 0x1
	// Position of CCABUSY field.
	RADIO_INTENSET_CCABUSY_Pos = 0x12
	// Bit mask of CCABUSY field.
	RADIO_INTENSET_CCABUSY_Msk = 0x40000
	// Bit CCABUSY.
	RADIO_INTENSET_CCABUSY = 0x40000
	// Read: Disabled
	RADIO_INTENSET_CCABUSY_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_CCABUSY_Enabled = 0x1
	// Enable
	RADIO_INTENSET_CCABUSY_Set = 0x1
	// Position of CCASTOPPED field.
	RADIO_INTENSET_CCASTOPPED_Pos = 0x13
	// Bit mask of CCASTOPPED field.
	RADIO_INTENSET_CCASTOPPED_Msk = 0x80000
	// Bit CCASTOPPED.
	RADIO_INTENSET_CCASTOPPED = 0x80000
	// Read: Disabled
	RADIO_INTENSET_CCASTOPPED_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_CCASTOPPED_Enabled = 0x1
	// Enable
	RADIO_INTENSET_CCASTOPPED_Set = 0x1
	// Position of RATEBOOST field.
	RADIO_INTENSET_RATEBOOST_Pos = 0x14
	// Bit mask of RATEBOOST field.
	RADIO_INTENSET_RATEBOOST_Msk = 0x100000
	// Bit RATEBOOST.
	RADIO_INTENSET_RATEBOOST = 0x100000
	// Read: Disabled
	RADIO_INTENSET_RATEBOOST_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_RATEBOOST_Enabled = 0x1
	// Enable
	RADIO_INTENSET_RATEBOOST_Set = 0x1
	// Position of TXREADY field.
	RADIO_INTENSET_TXREADY_Pos = 0x15
	// Bit mask of TXREADY field.
	RADIO_INTENSET_TXREADY_Msk = 0x200000
	// Bit TXREADY.
	RADIO_INTENSET_TXREADY = 0x200000
	// Read: Disabled
	RADIO_INTENSET_TXREADY_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_TXREADY_Enabled = 0x1
	// Enable
	RADIO_INTENSET_TXREADY_Set = 0x1
	// Position of RXREADY field.
	RADIO_INTENSET_RXREADY_Pos = 0x16
	// Bit mask of RXREADY field.
	RADIO_INTENSET_RXREADY_Msk = 0x400000
	// Bit RXREADY.
	RADIO_INTENSET_RXREADY = 0x400000
	// Read: Disabled
	RADIO_INTENSET_RXREADY_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_RXREADY_Enabled = 0x1
	// Enable
	RADIO_INTENSET_RXREADY_Set = 0x1
	// Position of MHRMATCH field.
	RADIO_INTENSET_MHRMATCH_Pos = 0x17
	// Bit mask of MHRMATCH field.
	RADIO_INTENSET_MHRMATCH_Msk = 0x800000
	// Bit MHRMATCH.
	RADIO_INTENSET_MHRMATCH = 0x800000
	// Read: Disabled
	RADIO_INTENSET_MHRMATCH_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_MHRMATCH_Enabled = 0x1
	// Enable
	RADIO_INTENSET_MHRMATCH_Set = 0x1
	// Position of SYNC field.
	RADIO_INTENSET_SYNC_Pos = 0x1a
	// Bit mask of SYNC field.
	RADIO_INTENSET_SYNC_Msk = 0x4000000
	// Bit SYNC.
	RADIO_INTENSET_SYNC = 0x4000000
	// Read: Disabled
	RADIO_INTENSET_SYNC_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_SYNC_Enabled = 0x1
	// Enable
	RADIO_INTENSET_SYNC_Set = 0x1
	// Position of PHYEND field.
	RADIO_INTENSET_PHYEND_Pos = 0x1b
	// Bit mask of PHYEND field.
	RADIO_INTENSET_PHYEND_Msk = 0x8000000
	// Bit PHYEND.
	RADIO_INTENSET_PHYEND = 0x8000000
	// Read: Disabled
	RADIO_INTENSET_PHYEND_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_PHYEND_Enabled = 0x1
	// Enable
	RADIO_INTENSET_PHYEND_Set = 0x1
	// Position of CTEPRESENT field.
	RADIO_INTENSET_CTEPRESENT_Pos = 0x1c
	// Bit mask of CTEPRESENT field.
	RADIO_INTENSET_CTEPRESENT_Msk = 0x10000000
	// Bit CTEPRESENT.
	RADIO_INTENSET_CTEPRESENT = 0x10000000
	// Read: Disabled
	RADIO_INTENSET_CTEPRESENT_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_CTEPRESENT_Enabled = 0x1
	// Enable
	RADIO_INTENSET_CTEPRESENT_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of READY field.
	RADIO_INTENCLR_READY_Pos = 0x0
	// Bit mask of READY field.
	RADIO_INTENCLR_READY_Msk = 0x1
	// Bit READY.
	RADIO_INTENCLR_READY = 0x1
	// Read: Disabled
	RADIO_INTENCLR_READY_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_READY_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_READY_Clear = 0x1
	// Position of ADDRESS field.
	RADIO_INTENCLR_ADDRESS_Pos = 0x1
	// Bit mask of ADDRESS field.
	RADIO_INTENCLR_ADDRESS_Msk = 0x2
	// Bit ADDRESS.
	RADIO_INTENCLR_ADDRESS = 0x2
	// Read: Disabled
	RADIO_INTENCLR_ADDRESS_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_ADDRESS_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_ADDRESS_Clear = 0x1
	// Position of PAYLOAD field.
	RADIO_INTENCLR_PAYLOAD_Pos = 0x2
	// Bit mask of PAYLOAD field.
	RADIO_INTENCLR_PAYLOAD_Msk = 0x4
	// Bit PAYLOAD.
	RADIO_INTENCLR_PAYLOAD = 0x4
	// Read: Disabled
	RADIO_INTENCLR_PAYLOAD_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_PAYLOAD_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_PAYLOAD_Clear = 0x1
	// Position of END field.
	RADIO_INTENCLR_END_Pos = 0x3
	// Bit mask of END field.
	RADIO_INTENCLR_END_Msk = 0x8
	// Bit END.
	RADIO_INTENCLR_END = 0x8
	// Read: Disabled
	RADIO_INTENCLR_END_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_END_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_END_Clear = 0x1
	// Position of DISABLED field.
	RADIO_INTENCLR_DISABLED_Pos = 0x4
	// Bit mask of DISABLED field.
	RADIO_INTENCLR_DISABLED_Msk = 0x10
	// Bit DISABLED.
	RADIO_INTENCLR_DISABLED = 0x10
	// Read: Disabled
	RADIO_INTENCLR_DISABLED_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_DISABLED_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_DISABLED_Clear = 0x1
	// Position of DEVMATCH field.
	RADIO_INTENCLR_DEVMATCH_Pos = 0x5
	// Bit mask of DEVMATCH field.
	RADIO_INTENCLR_DEVMATCH_Msk = 0x20
	// Bit DEVMATCH.
	RADIO_INTENCLR_DEVMATCH = 0x20
	// Read: Disabled
	RADIO_INTENCLR_DEVMATCH_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_DEVMATCH_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_DEVMATCH_Clear = 0x1
	// Position of DEVMISS field.
	RADIO_INTENCLR_DEVMISS_Pos = 0x6
	// Bit mask of DEVMISS field.
	RADIO_INTENCLR_DEVMISS_Msk = 0x40
	// Bit DEVMISS.
	RADIO_INTENCLR_DEVMISS = 0x40
	// Read: Disabled
	RADIO_INTENCLR_DEVMISS_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_DEVMISS_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_DEVMISS_Clear = 0x1
	// Position of RSSIEND field.
	RADIO_INTENCLR_RSSIEND_Pos = 0x7
	// Bit mask of RSSIEND field.
	RADIO_INTENCLR_RSSIEND_Msk = 0x80
	// Bit RSSIEND.
	RADIO_INTENCLR_RSSIEND = 0x80
	// Read: Disabled
	RADIO_INTENCLR_RSSIEND_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_RSSIEND_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_RSSIEND_Clear = 0x1
	// Position of BCMATCH field.
	RADIO_INTENCLR_BCMATCH_Pos = 0xa
	// Bit mask of BCMATCH field.
	RADIO_INTENCLR_BCMATCH_Msk = 0x400
	// Bit BCMATCH.
	RADIO_INTENCLR_BCMATCH = 0x400
	// Read: Disabled
	RADIO_INTENCLR_BCMATCH_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_BCMATCH_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_BCMATCH_Clear = 0x1
	// Position of CRCOK field.
	RADIO_INTENCLR_CRCOK_Pos = 0xc
	// Bit mask of CRCOK field.
	RADIO_INTENCLR_CRCOK_Msk = 0x1000
	// Bit CRCOK.
	RADIO_INTENCLR_CRCOK = 0x1000
	// Read: Disabled
	RADIO_INTENCLR_CRCOK_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_CRCOK_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_CRCOK_Clear = 0x1
	// Position of CRCERROR field.
	RADIO_INTENCLR_CRCERROR_Pos = 0xd
	// Bit mask of CRCERROR field.
	RADIO_INTENCLR_CRCERROR_Msk = 0x2000
	// Bit CRCERROR.
	RADIO_INTENCLR_CRCERROR = 0x2000
	// Read: Disabled
	RADIO_INTENCLR_CRCERROR_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_CRCERROR_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_CRCERROR_Clear = 0x1
	// Position of FRAMESTART field.
	RADIO_INTENCLR_FRAMESTART_Pos = 0xe
	// Bit mask of FRAMESTART field.
	RADIO_INTENCLR_FRAMESTART_Msk = 0x4000
	// Bit FRAMESTART.
	RADIO_INTENCLR_FRAMESTART = 0x4000
	// Read: Disabled
	RADIO_INTENCLR_FRAMESTART_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_FRAMESTART_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_FRAMESTART_Clear = 0x1
	// Position of EDEND field.
	RADIO_INTENCLR_EDEND_Pos = 0xf
	// Bit mask of EDEND field.
	RADIO_INTENCLR_EDEND_Msk = 0x8000
	// Bit EDEND.
	RADIO_INTENCLR_EDEND = 0x8000
	// Read: Disabled
	RADIO_INTENCLR_EDEND_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_EDEND_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_EDEND_Clear = 0x1
	// Position of EDSTOPPED field.
	RADIO_INTENCLR_EDSTOPPED_Pos = 0x10
	// Bit mask of EDSTOPPED field.
	RADIO_INTENCLR_EDSTOPPED_Msk = 0x10000
	// Bit EDSTOPPED.
	RADIO_INTENCLR_EDSTOPPED = 0x10000
	// Read: Disabled
	RADIO_INTENCLR_EDSTOPPED_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_EDSTOPPED_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_EDSTOPPED_Clear = 0x1
	// Position of CCAIDLE field.
	RADIO_INTENCLR_CCAIDLE_Pos = 0x11
	// Bit mask of CCAIDLE field.
	RADIO_INTENCLR_CCAIDLE_Msk = 0x20000
	// Bit CCAIDLE.
	RADIO_INTENCLR_CCAIDLE = 0x20000
	// Read: Disabled
	RADIO_INTENCLR_CCAIDLE_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_CCAIDLE_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_CCAIDLE_Clear = 0x1
	// Position of CCABUSY field.
	RADIO_INTENCLR_CCABUSY_Pos = 0x12
	// Bit mask of CCABUSY field.
	RADIO_INTENCLR_CCABUSY_Msk = 0x40000
	// Bit CCABUSY.
	RADIO_INTENCLR_CCABUSY = 0x40000
	// Read: Disabled
	RADIO_INTENCLR_CCABUSY_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_CCABUSY_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_CCABUSY_Clear = 0x1
	// Position of CCASTOPPED field.
	RADIO_INTENCLR_CCASTOPPED_Pos = 0x13
	// Bit mask of CCASTOPPED field.
	RADIO_INTENCLR_CCASTOPPED_Msk = 0x80000
	// Bit CCASTOPPED.
	RADIO_INTENCLR_CCASTOPPED = 0x80000
	// Read: Disabled
	RADIO_INTENCLR_CCASTOPPED_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_CCASTOPPED_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_CCASTOPPED_Clear = 0x1
	// Position of RATEBOOST field.
	RADIO_INTENCLR_RATEBOOST_Pos = 0x14
	// Bit mask of RATEBOOST field.
	RADIO_INTENCLR_RATEBOOST_Msk = 0x100000
	// Bit RATEBOOST.
	RADIO_INTENCLR_RATEBOOST = 0x100000
	// Read: Disabled
	RADIO_INTENCLR_RATEBOOST_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_RATEBOOST_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_RATEBOOST_Clear = 0x1
	// Position of TXREADY field.
	RADIO_INTENCLR_TXREADY_Pos = 0x15
	// Bit mask of TXREADY field.
	RADIO_INTENCLR_TXREADY_Msk = 0x200000
	// Bit TXREADY.
	RADIO_INTENCLR_TXREADY = 0x200000
	// Read: Disabled
	RADIO_INTENCLR_TXREADY_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_TXREADY_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_TXREADY_Clear = 0x1
	// Position of RXREADY field.
	RADIO_INTENCLR_RXREADY_Pos = 0x16
	// Bit mask of RXREADY field.
	RADIO_INTENCLR_RXREADY_Msk = 0x400000
	// Bit RXREADY.
	RADIO_INTENCLR_RXREADY = 0x400000
	// Read: Disabled
	RADIO_INTENCLR_RXREADY_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_RXREADY_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_RXREADY_Clear = 0x1
	// Position of MHRMATCH field.
	RADIO_INTENCLR_MHRMATCH_Pos = 0x17
	// Bit mask of MHRMATCH field.
	RADIO_INTENCLR_MHRMATCH_Msk = 0x800000
	// Bit MHRMATCH.
	RADIO_INTENCLR_MHRMATCH = 0x800000
	// Read: Disabled
	RADIO_INTENCLR_MHRMATCH_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_MHRMATCH_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_MHRMATCH_Clear = 0x1
	// Position of SYNC field.
	RADIO_INTENCLR_SYNC_Pos = 0x1a
	// Bit mask of SYNC field.
	RADIO_INTENCLR_SYNC_Msk = 0x4000000
	// Bit SYNC.
	RADIO_INTENCLR_SYNC = 0x4000000
	// Read: Disabled
	RADIO_INTENCLR_SYNC_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_SYNC_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_SYNC_Clear = 0x1
	// Position of PHYEND field.
	RADIO_INTENCLR_PHYEND_Pos = 0x1b
	// Bit mask of PHYEND field.
	RADIO_INTENCLR_PHYEND_Msk = 0x8000000
	// Bit PHYEND.
	RADIO_INTENCLR_PHYEND = 0x8000000
	// Read: Disabled
	RADIO_INTENCLR_PHYEND_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_PHYEND_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_PHYEND_Clear = 0x1
	// Position of CTEPRESENT field.
	RADIO_INTENCLR_CTEPRESENT_Pos = 0x1c
	// Bit mask of CTEPRESENT field.
	RADIO_INTENCLR_CTEPRESENT_Msk = 0x10000000
	// Bit CTEPRESENT.
	RADIO_INTENCLR_CTEPRESENT = 0x10000000
	// Read: Disabled
	RADIO_INTENCLR_CTEPRESENT_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_CTEPRESENT_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_CTEPRESENT_Clear = 0x1

	// CRCSTATUS: CRC status
	// Position of CRCSTATUS field.
	RADIO_CRCSTATUS_CRCSTATUS_Pos = 0x0
	// Bit mask of CRCSTATUS field.
	RADIO_CRCSTATUS_CRCSTATUS_Msk = 0x1
	// Bit CRCSTATUS.
	RADIO_CRCSTATUS_CRCSTATUS = 0x1
	// Packet received with CRC error
	RADIO_CRCSTATUS_CRCSTATUS_CRCError = 0x0
	// Packet received with CRC ok
	RADIO_CRCSTATUS_CRCSTATUS_CRCOk = 0x1

	// RXMATCH: Received address
	// Position of RXMATCH field.
	RADIO_RXMATCH_RXMATCH_Pos = 0x0
	// Bit mask of RXMATCH field.
	RADIO_RXMATCH_RXMATCH_Msk = 0x7

	// RXCRC: CRC field of previously received packet
	// Position of RXCRC field.
	RADIO_RXCRC_RXCRC_Pos = 0x0
	// Bit mask of RXCRC field.
	RADIO_RXCRC_RXCRC_Msk = 0xffffff

	// DAI: Device address match index
	// Position of DAI field.
	RADIO_DAI_DAI_Pos = 0x0
	// Bit mask of DAI field.
	RADIO_DAI_DAI_Msk = 0x7

	// PDUSTAT: Payload status
	// Position of PDUSTAT field.
	RADIO_PDUSTAT_PDUSTAT_Pos = 0x0
	// Bit mask of PDUSTAT field.
	RADIO_PDUSTAT_PDUSTAT_Msk = 0x1
	// Bit PDUSTAT.
	RADIO_PDUSTAT_PDUSTAT = 0x1
	// Payload less than PCNF1.MAXLEN
	RADIO_PDUSTAT_PDUSTAT_LessThan = 0x0
	// Payload greater than PCNF1.MAXLEN
	RADIO_PDUSTAT_PDUSTAT_GreaterThan = 0x1
	// Position of CISTAT field.
	RADIO_PDUSTAT_CISTAT_Pos = 0x1
	// Bit mask of CISTAT field.
	RADIO_PDUSTAT_CISTAT_Msk = 0x6
	// Frame is received at 125 kbps
	RADIO_PDUSTAT_CISTAT_LR125kbit = 0x0
	// Frame is received at 500 kbps
	RADIO_PDUSTAT_CISTAT_LR500kbit = 0x1

	// CTESTATUS: CTEInfo parsed from received packet
	// Position of CTETIME field.
	RADIO_CTESTATUS_CTETIME_Pos = 0x0
	// Bit mask of CTETIME field.
	RADIO_CTESTATUS_CTETIME_Msk = 0x1f
	// Position of RFU field.
	RADIO_CTESTATUS_RFU_Pos = 0x5
	// Bit mask of RFU field.
	RADIO_CTESTATUS_RFU_Msk = 0x20
	// Bit RFU.
	RADIO_CTESTATUS_RFU = 0x20
	// Position of CTETYPE field.
	RADIO_CTESTATUS_CTETYPE_Pos = 0x6
	// Bit mask of CTETYPE field.
	RADIO_CTESTATUS_CTETYPE_Msk = 0xc0

	// DFESTATUS: DFE status information
	// Position of SWITCHINGSTATE field.
	RADIO_DFESTATUS_SWITCHINGSTATE_Pos = 0x0
	// Bit mask of SWITCHINGSTATE field.
	RADIO_DFESTATUS_SWITCHINGSTATE_Msk = 0x7
	// Switching state Idle
	RADIO_DFESTATUS_SWITCHINGSTATE_Idle = 0x0
	// Switching state Offset
	RADIO_DFESTATUS_SWITCHINGSTATE_Offset = 0x1
	// Switching state Guard
	RADIO_DFESTATUS_SWITCHINGSTATE_Guard = 0x2
	// Switching state Ref
	RADIO_DFESTATUS_SWITCHINGSTATE_Ref = 0x3
	// Switching state Switching
	RADIO_DFESTATUS_SWITCHINGSTATE_Switching = 0x4
	// Switching state Ending
	RADIO_DFESTATUS_SWITCHINGSTATE_Ending = 0x5
	// Position of SAMPLINGSTATE field.
	RADIO_DFESTATUS_SAMPLINGSTATE_Pos = 0x4
	// Bit mask of SAMPLINGSTATE field.
	RADIO_DFESTATUS_SAMPLINGSTATE_Msk = 0x10
	// Bit SAMPLINGSTATE.
	RADIO_DFESTATUS_SAMPLINGSTATE = 0x10
	// Sampling state Idle
	RADIO_DFESTATUS_SAMPLINGSTATE_Idle = 0x0
	// Sampling state Sampling
	RADIO_DFESTATUS_SAMPLINGSTATE_Sampling = 0x1

	// PACKETPTR: Packet pointer
	// Position of PACKETPTR field.
	RADIO_PACKETPTR_PACKETPTR_Pos = 0x0
	// Bit mask of PACKETPTR field.
	RADIO_PACKETPTR_PACKETPTR_Msk = 0xffffffff

	// FREQUENCY: Frequency
	// Position of FREQUENCY field.
	RADIO_FREQUENCY_FREQUENCY_Pos = 0x0
	// Bit mask of FREQUENCY field.
	RADIO_FREQUENCY_FREQUENCY_Msk = 0x7f
	// Position of MAP field.
	RADIO_FREQUENCY_MAP_Pos = 0x8
	// Bit mask of MAP field.
	RADIO_FREQUENCY_MAP_Msk = 0x100
	// Bit MAP.
	RADIO_FREQUENCY_MAP = 0x100
	// Channel map between 2400 MHZ .. 2500 MHz
	RADIO_FREQUENCY_MAP_Default = 0x0
	// Channel map between 2360 MHZ .. 2460 MHz
	RADIO_FREQUENCY_MAP_Low = 0x1

	// TXPOWER: Output power
	// Position of TXPOWER field.
	RADIO_TXPOWER_TXPOWER_Pos = 0x0
	// Bit mask of TXPOWER field.
	RADIO_TXPOWER_TXPOWER_Msk = 0xff
	// 0 dBm
	RADIO_TXPOWER_TXPOWER_0dBm = 0x0
	// -1 dBm
	RADIO_TXPOWER_TXPOWER_Neg1dBm = 0xff
	// -2 dBm
	RADIO_TXPOWER_TXPOWER_Neg2dBm = 0xfe
	// -3 dBm
	RADIO_TXPOWER_TXPOWER_Neg3dBm = 0xfd
	// -4 dBm
	RADIO_TXPOWER_TXPOWER_Neg4dBm = 0xfc
	// -5 dBm
	RADIO_TXPOWER_TXPOWER_Neg5dBm = 0xfb
	// -6 dBm
	RADIO_TXPOWER_TXPOWER_Neg6dBm = 0xfa
	// -7 dBm
	RADIO_TXPOWER_TXPOWER_Neg7dBm = 0xf9
	// -8 dBm
	RADIO_TXPOWER_TXPOWER_Neg8dBm = 0xf8
	// -12 dBm
	RADIO_TXPOWER_TXPOWER_Neg12dBm = 0xf4
	// -16 dBm
	RADIO_TXPOWER_TXPOWER_Neg16dBm = 0xf0
	// -20 dBm
	RADIO_TXPOWER_TXPOWER_Neg20dBm = 0xec
	// Deprecated enumerator - -40 dBm
	RADIO_TXPOWER_TXPOWER_Neg30dBm = 0xe2
	// -40 dBm
	RADIO_TXPOWER_TXPOWER_Neg40dBm = 0xd8

	// MODE: Data rate and modulation
	// Position of MODE field.
	RADIO_MODE_MODE_Pos = 0x0
	// Bit mask of MODE field.
	RADIO_MODE_MODE_Msk = 0xf
	// 1 Mbps Nordic proprietary radio mode
	RADIO_MODE_MODE_Nrf_1Mbit = 0x0
	// 2 Mbps Nordic proprietary radio mode
	RADIO_MODE_MODE_Nrf_2Mbit = 0x1
	// 1 Mbps BLE
	RADIO_MODE_MODE_Ble_1Mbit = 0x3
	// 2 Mbps BLE
	RADIO_MODE_MODE_Ble_2Mbit = 0x4
	// Long range 125 kbps TX, 125 kbps and 500 kbps RX
	RADIO_MODE_MODE_Ble_LR125Kbit = 0x5
	// Long range 500 kbps TX, 125 kbps and 500 kbps RX
	RADIO_MODE_MODE_Ble_LR500Kbit = 0x6
	// IEEE 802.15.4-2006 250 kbps
	RADIO_MODE_MODE_Ieee802154_250Kbit = 0xf

	// PCNF0: Packet configuration register 0
	// Position of LFLEN field.
	RADIO_PCNF0_LFLEN_Pos = 0x0
	// Bit mask of LFLEN field.
	RADIO_PCNF0_LFLEN_Msk = 0xf
	// Position of S0LEN field.
	RADIO_PCNF0_S0LEN_Pos = 0x8
	// Bit mask of S0LEN field.
	RADIO_PCNF0_S0LEN_Msk = 0x100
	// Bit S0LEN.
	RADIO_PCNF0_S0LEN = 0x100
	// Position of S1LEN field.
	RADIO_PCNF0_S1LEN_Pos = 0x10
	// Bit mask of S1LEN field.
	RADIO_PCNF0_S1LEN_Msk = 0xf0000
	// Position of S1INCL field.
	RADIO_PCNF0_S1INCL_Pos = 0x14
	// Bit mask of S1INCL field.
	RADIO_PCNF0_S1INCL_Msk = 0x100000
	// Bit S1INCL.
	RADIO_PCNF0_S1INCL = 0x100000
	// Include S1 field in RAM only if S1LEN &gt; 0
	RADIO_PCNF0_S1INCL_Automatic = 0x0
	// Always include S1 field in RAM independent of S1LEN
	RADIO_PCNF0_S1INCL_Include = 0x1
	// Position of CILEN field.
	RADIO_PCNF0_CILEN_Pos = 0x16
	// Bit mask of CILEN field.
	RADIO_PCNF0_CILEN_Msk = 0xc00000
	// Position of PLEN field.
	RADIO_PCNF0_PLEN_Pos = 0x18
	// Bit mask of PLEN field.
	RADIO_PCNF0_PLEN_Msk = 0x3000000
	// 8-bit preamble
	RADIO_PCNF0_PLEN_8bit = 0x0
	// 16-bit preamble
	RADIO_PCNF0_PLEN_16bit = 0x1
	// 32-bit zero preamble - used for IEEE 802.15.4
	RADIO_PCNF0_PLEN_32bitZero = 0x2
	// Preamble - used for BLE long range
	RADIO_PCNF0_PLEN_LongRange = 0x3
	// Position of CRCINC field.
	RADIO_PCNF0_CRCINC_Pos = 0x1a
	// Bit mask of CRCINC field.
	RADIO_PCNF0_CRCINC_Msk = 0x4000000
	// Bit CRCINC.
	RADIO_PCNF0_CRCINC = 0x4000000
	// LENGTH does not contain CRC
	RADIO_PCNF0_CRCINC_Exclude = 0x0
	// LENGTH includes CRC
	RADIO_PCNF0_CRCINC_Include = 0x1
	// Position of TERMLEN field.
	RADIO_PCNF0_TERMLEN_Pos = 0x1d
	// Bit mask of TERMLEN field.
	RADIO_PCNF0_TERMLEN_Msk = 0x60000000

	// PCNF1: Packet configuration register 1
	// Position of MAXLEN field.
	RADIO_PCNF1_MAXLEN_Pos = 0x0
	// Bit mask of MAXLEN field.
	RADIO_PCNF1_MAXLEN_Msk = 0xff
	// Position of STATLEN field.
	RADIO_PCNF1_STATLEN_Pos = 0x8
	// Bit mask of STATLEN field.
	RADIO_PCNF1_STATLEN_Msk = 0xff00
	// Position of BALEN field.
	RADIO_PCNF1_BALEN_Pos = 0x10
	// Bit mask of BALEN field.
	RADIO_PCNF1_BALEN_Msk = 0x70000
	// Position of ENDIAN field.
	RADIO_PCNF1_ENDIAN_Pos = 0x18
	// Bit mask of ENDIAN field.
	RADIO_PCNF1_ENDIAN_Msk = 0x1000000
	// Bit ENDIAN.
	RADIO_PCNF1_ENDIAN = 0x1000000
	// Least significant bit on air first
	RADIO_PCNF1_ENDIAN_Little = 0x0
	// Most significant bit on air first
	RADIO_PCNF1_ENDIAN_Big = 0x1
	// Position of WHITEEN field.
	RADIO_PCNF1_WHITEEN_Pos = 0x19
	// Bit mask of WHITEEN field.
	RADIO_PCNF1_WHITEEN_Msk = 0x2000000
	// Bit WHITEEN.
	RADIO_PCNF1_WHITEEN = 0x2000000
	// Disable
	RADIO_PCNF1_WHITEEN_Disabled = 0x0
	// Enable
	RADIO_PCNF1_WHITEEN_Enabled = 0x1

	// BASE0: Base address 0
	// Position of BASE0 field.
	RADIO_BASE0_BASE0_Pos = 0x0
	// Bit mask of BASE0 field.
	RADIO_BASE0_BASE0_Msk = 0xffffffff

	// BASE1: Base address 1
	// Position of BASE1 field.
	RADIO_BASE1_BASE1_Pos = 0x0
	// Bit mask of BASE1 field.
	RADIO_BASE1_BASE1_Msk = 0xffffffff

	// PREFIX0: Prefixes bytes for logical addresses 0-3
	// Position of AP0 field.
	RADIO_PREFIX0_AP0_Pos = 0x0
	// Bit mask of AP0 field.
	RADIO_PREFIX0_AP0_Msk = 0xff
	// Position of AP1 field.
	RADIO_PREFIX0_AP1_Pos = 0x8
	// Bit mask of AP1 field.
	RADIO_PREFIX0_AP1_Msk = 0xff00
	// Position of AP2 field.
	RADIO_PREFIX0_AP2_Pos = 0x10
	// Bit mask of AP2 field.
	RADIO_PREFIX0_AP2_Msk = 0xff0000
	// Position of AP3 field.
	RADIO_PREFIX0_AP3_Pos = 0x18
	// Bit mask of AP3 field.
	RADIO_PREFIX0_AP3_Msk = 0xff000000

	// PREFIX1: Prefixes bytes for logical addresses 4-7
	// Position of AP4 field.
	RADIO_PREFIX1_AP4_Pos = 0x0
	// Bit mask of AP4 field.
	RADIO_PREFIX1_AP4_Msk = 0xff
	// Position of AP5 field.
	RADIO_PREFIX1_AP5_Pos = 0x8
	// Bit mask of AP5 field.
	RADIO_PREFIX1_AP5_Msk = 0xff00
	// Position of AP6 field.
	RADIO_PREFIX1_AP6_Pos = 0x10
	// Bit mask of AP6 field.
	RADIO_PREFIX1_AP6_Msk = 0xff0000
	// Position of AP7 field.
	RADIO_PREFIX1_AP7_Pos = 0x18
	// Bit mask of AP7 field.
	RADIO_PREFIX1_AP7_Msk = 0xff000000

	// TXADDRESS: Transmit address select
	// Position of TXADDRESS field.
	RADIO_TXADDRESS_TXADDRESS_Pos = 0x0
	// Bit mask of TXADDRESS field.
	RADIO_TXADDRESS_TXADDRESS_Msk = 0x7

	// RXADDRESSES: Receive address select
	// Position of ADDR0 field.
	RADIO_RXADDRESSES_ADDR0_Pos = 0x0
	// Bit mask of ADDR0 field.
	RADIO_RXADDRESSES_ADDR0_Msk = 0x1
	// Bit ADDR0.
	RADIO_RXADDRESSES_ADDR0 = 0x1
	// Disable
	RADIO_RXADDRESSES_ADDR0_Disabled = 0x0
	// Enable
	RADIO_RXADDRESSES_ADDR0_Enabled = 0x1
	// Position of ADDR1 field.
	RADIO_RXADDRESSES_ADDR1_Pos = 0x1
	// Bit mask of ADDR1 field.
	RADIO_RXADDRESSES_ADDR1_Msk = 0x2
	// Bit ADDR1.
	RADIO_RXADDRESSES_ADDR1 = 0x2
	// Disable
	RADIO_RXADDRESSES_ADDR1_Disabled = 0x0
	// Enable
	RADIO_RXADDRESSES_ADDR1_Enabled = 0x1
	// Position of ADDR2 field.
	RADIO_RXADDRESSES_ADDR2_Pos = 0x2
	// Bit mask of ADDR2 field.
	RADIO_RXADDRESSES_ADDR2_Msk = 0x4
	// Bit ADDR2.
	RADIO_RXADDRESSES_ADDR2 = 0x4
	// Disable
	RADIO_RXADDRESSES_ADDR2_Disabled = 0x0
	// Enable
	RADIO_RXADDRESSES_ADDR2_Enabled = 0x1
	// Position of ADDR3 field.
	RADIO_RXADDRESSES_ADDR3_Pos = 0x3
	// Bit mask of ADDR3 field.
	RADIO_RXADDRESSES_ADDR3_Msk = 0x8
	// Bit ADDR3.
	RADIO_RXADDRESSES_ADDR3 = 0x8
	// Disable
	RADIO_RXADDRESSES_ADDR3_Disabled = 0x0
	// Enable
	RADIO_RXADDRESSES_ADDR3_Enabled = 0x1
	// Position of ADDR4 field.
	RADIO_RXADDRESSES_ADDR4_Pos = 0x4
	// Bit mask of ADDR4 field.
	RADIO_RXADDRESSES_ADDR4_Msk = 0x10
	// Bit ADDR4.
	RADIO_RXADDRESSES_ADDR4 = 0x10
	// Disable
	RADIO_RXADDRESSES_ADDR4_Disabled = 0x0
	// Enable
	RADIO_RXADDRESSES_ADDR4_Enabled = 0x1
	// Position of ADDR5 field.
	RADIO_RXADDRESSES_ADDR5_Pos = 0x5
	// Bit mask of ADDR5 field.
	RADIO_RXADDRESSES_ADDR5_Msk = 0x20
	// Bit ADDR5.
	RADIO_RXADDRESSES_ADDR5 = 0x20
	// Disable
	RADIO_RXADDRESSES_ADDR5_Disabled = 0x0
	// Enable
	RADIO_RXADDRESSES_ADDR5_Enabled = 0x1
	// Position of ADDR6 field.
	RADIO_RXADDRESSES_ADDR6_Pos = 0x6
	// Bit mask of ADDR6 field.
	RADIO_RXADDRESSES_ADDR6_Msk = 0x40
	// Bit ADDR6.
	RADIO_RXADDRESSES_ADDR6 = 0x40
	// Disable
	RADIO_RXADDRESSES_ADDR6_Disabled = 0x0
	// Enable
	RADIO_RXADDRESSES_ADDR6_Enabled = 0x1
	// Position of ADDR7 field.
	RADIO_RXADDRESSES_ADDR7_Pos = 0x7
	// Bit mask of ADDR7 field.
	RADIO_RXADDRESSES_ADDR7_Msk = 0x80
	// Bit ADDR7.
	RADIO_RXADDRESSES_ADDR7 = 0x80
	// Disable
	RADIO_RXADDRESSES_ADDR7_Disabled = 0x0
	// Enable
	RADIO_RXADDRESSES_ADDR7_Enabled = 0x1

	// CRCCNF: CRC configuration
	// Position of LEN field.
	RADIO_CRCCNF_LEN_Pos = 0x0
	// Bit mask of LEN field.
	RADIO_CRCCNF_LEN_Msk = 0x3
	// CRC length is zero and CRC calculation is disabled
	RADIO_CRCCNF_LEN_Disabled = 0x0
	// CRC length is one byte and CRC calculation is enabled
	RADIO_CRCCNF_LEN_One = 0x1
	// CRC length is two bytes and CRC calculation is enabled
	RADIO_CRCCNF_LEN_Two = 0x2
	// CRC length is three bytes and CRC calculation is enabled
	RADIO_CRCCNF_LEN_Three = 0x3
	// Position of SKIPADDR field.
	RADIO_CRCCNF_SKIPADDR_Pos = 0x8
	// Bit mask of SKIPADDR field.
	RADIO_CRCCNF_SKIPADDR_Msk = 0x300
	// CRC calculation includes address field
	RADIO_CRCCNF_SKIPADDR_Include = 0x0
	// CRC calculation does not include address field. The CRC calculation will start at the first byte after the address.
	RADIO_CRCCNF_SKIPADDR_Skip = 0x1
	// CRC calculation as per 802.15.4 standard. Starting at first byte after length field.
	RADIO_CRCCNF_SKIPADDR_Ieee802154 = 0x2

	// CRCPOLY: CRC polynomial
	// Position of CRCPOLY field.
	RADIO_CRCPOLY_CRCPOLY_Pos = 0x0
	// Bit mask of CRCPOLY field.
	RADIO_CRCPOLY_CRCPOLY_Msk = 0xffffff

	// CRCINIT: CRC initial value
	// Position of CRCINIT field.
	RADIO_CRCINIT_CRCINIT_Pos = 0x0
	// Bit mask of CRCINIT field.
	RADIO_CRCINIT_CRCINIT_Msk = 0xffffff

	// TIFS: Interframe spacing in us
	// Position of TIFS field.
	RADIO_TIFS_TIFS_Pos = 0x0
	// Bit mask of TIFS field.
	RADIO_TIFS_TIFS_Msk = 0x3ff

	// RSSISAMPLE: RSSI sample
	// Position of RSSISAMPLE field.
	RADIO_RSSISAMPLE_RSSISAMPLE_Pos = 0x0
	// Bit mask of RSSISAMPLE field.
	RADIO_RSSISAMPLE_RSSISAMPLE_Msk = 0x7f

	// STATE: Current radio state
	// Position of STATE field.
	RADIO_STATE_STATE_Pos = 0x0
	// Bit mask of STATE field.
	RADIO_STATE_STATE_Msk = 0xf
	// RADIO is in the Disabled state
	RADIO_STATE_STATE_Disabled = 0x0
	// RADIO is in the RXRU state
	RADIO_STATE_STATE_RxRu = 0x1
	// RADIO is in the RXIDLE state
	RADIO_STATE_STATE_RxIdle = 0x2
	// RADIO is in the RX state
	RADIO_STATE_STATE_Rx = 0x3
	// RADIO is in the RXDISABLED state
	RADIO_STATE_STATE_RxDisable = 0x4
	// RADIO is in the TXRU state
	RADIO_STATE_STATE_TxRu = 0x9
	// RADIO is in the TXIDLE state
	RADIO_STATE_STATE_TxIdle = 0xa
	// RADIO is in the TX state
	RADIO_STATE_STATE_Tx = 0xb
	// RADIO is in the TXDISABLED state
	RADIO_STATE_STATE_TxDisable = 0xc

	// DATAWHITEIV: Data whitening initial value
	// Position of DATAWHITEIV field.
	RADIO_DATAWHITEIV_DATAWHITEIV_Pos = 0x0
	// Bit mask of DATAWHITEIV field.
	RADIO_DATAWHITEIV_DATAWHITEIV_Msk = 0x7f

	// BCC: Bit counter compare
	// Position of BCC field.
	RADIO_BCC_BCC_Pos = 0x0
	// Bit mask of BCC field.
	RADIO_BCC_BCC_Msk = 0xffffffff

	// DAB: Description collection: Device address base segment n
	// Position of DAB field.
	RADIO_DAB_DAB_Pos = 0x0
	// Bit mask of DAB field.
	RADIO_DAB_DAB_Msk = 0xffffffff

	// DAP: Description collection: Device address prefix n
	// Position of DAP field.
	RADIO_DAP_DAP_Pos = 0x0
	// Bit mask of DAP field.
	RADIO_DAP_DAP_Msk = 0xffff

	// DACNF: Device address match configuration
	// Position of ENA0 field.
	RADIO_DACNF_ENA0_Pos = 0x0
	// Bit mask of ENA0 field.
	RADIO_DACNF_ENA0_Msk = 0x1
	// Bit ENA0.
	RADIO_DACNF_ENA0 = 0x1
	// Disabled
	RADIO_DACNF_ENA0_Disabled = 0x0
	// Enabled
	RADIO_DACNF_ENA0_Enabled = 0x1
	// Position of ENA1 field.
	RADIO_DACNF_ENA1_Pos = 0x1
	// Bit mask of ENA1 field.
	RADIO_DACNF_ENA1_Msk = 0x2
	// Bit ENA1.
	RADIO_DACNF_ENA1 = 0x2
	// Disabled
	RADIO_DACNF_ENA1_Disabled = 0x0
	// Enabled
	RADIO_DACNF_ENA1_Enabled = 0x1
	// Position of ENA2 field.
	RADIO_DACNF_ENA2_Pos = 0x2
	// Bit mask of ENA2 field.
	RADIO_DACNF_ENA2_Msk = 0x4
	// Bit ENA2.
	RADIO_DACNF_ENA2 = 0x4
	// Disabled
	RADIO_DACNF_ENA2_Disabled = 0x0
	// Enabled
	RADIO_DACNF_ENA2_Enabled = 0x1
	// Position of ENA3 field.
	RADIO_DACNF_ENA3_Pos = 0x3
	// Bit mask of ENA3 field.
	RADIO_DACNF_ENA3_Msk = 0x8
	// Bit ENA3.
	RADIO_DACNF_ENA3 = 0x8
	// Disabled
	RADIO_DACNF_ENA3_Disabled = 0x0
	// Enabled
	RADIO_DACNF_ENA3_Enabled = 0x1
	// Position of ENA4 field.
	RADIO_DACNF_ENA4_Pos = 0x4
	// Bit mask of ENA4 field.
	RADIO_DACNF_ENA4_Msk = 0x10
	// Bit ENA4.
	RADIO_DACNF_ENA4 = 0x10
	// Disabled
	RADIO_DACNF_ENA4_Disabled = 0x0
	// Enabled
	RADIO_DACNF_ENA4_Enabled = 0x1
	// Position of ENA5 field.
	RADIO_DACNF_ENA5_Pos = 0x5
	// Bit mask of ENA5 field.
	RADIO_DACNF_ENA5_Msk = 0x20
	// Bit ENA5.
	RADIO_DACNF_ENA5 = 0x20
	// Disabled
	RADIO_DACNF_ENA5_Disabled = 0x0
	// Enabled
	RADIO_DACNF_ENA5_Enabled = 0x1
	// Position of ENA6 field.
	RADIO_DACNF_ENA6_Pos = 0x6
	// Bit mask of ENA6 field.
	RADIO_DACNF_ENA6_Msk = 0x40
	// Bit ENA6.
	RADIO_DACNF_ENA6 = 0x40
	// Disabled
	RADIO_DACNF_ENA6_Disabled = 0x0
	// Enabled
	RADIO_DACNF_ENA6_Enabled = 0x1
	// Position of ENA7 field.
	RADIO_DACNF_ENA7_Pos = 0x7
	// Bit mask of ENA7 field.
	RADIO_DACNF_ENA7_Msk = 0x80
	// Bit ENA7.
	RADIO_DACNF_ENA7 = 0x80
	// Disabled
	RADIO_DACNF_ENA7_Disabled = 0x0
	// Enabled
	RADIO_DACNF_ENA7_Enabled = 0x1
	// Position of TXADD0 field.
	RADIO_DACNF_TXADD0_Pos = 0x8
	// Bit mask of TXADD0 field.
	RADIO_DACNF_TXADD0_Msk = 0x100
	// Bit TXADD0.
	RADIO_DACNF_TXADD0 = 0x100
	// Position of TXADD1 field.
	RADIO_DACNF_TXADD1_Pos = 0x9
	// Bit mask of TXADD1 field.
	RADIO_DACNF_TXADD1_Msk = 0x200
	// Bit TXADD1.
	RADIO_DACNF_TXADD1 = 0x200
	// Position of TXADD2 field.
	RADIO_DACNF_TXADD2_Pos = 0xa
	// Bit mask of TXADD2 field.
	RADIO_DACNF_TXADD2_Msk = 0x400
	// Bit TXADD2.
	RADIO_DACNF_TXADD2 = 0x400
	// Position of TXADD3 field.
	RADIO_DACNF_TXADD3_Pos = 0xb
	// Bit mask of TXADD3 field.
	RADIO_DACNF_TXADD3_Msk = 0x800
	// Bit TXADD3.
	RADIO_DACNF_TXADD3 = 0x800
	// Position of TXADD4 field.
	RADIO_DACNF_TXADD4_Pos = 0xc
	// Bit mask of TXADD4 field.
	RADIO_DACNF_TXADD4_Msk = 0x1000
	// Bit TXADD4.
	RADIO_DACNF_TXADD4 = 0x1000
	// Position of TXADD5 field.
	RADIO_DACNF_TXADD5_Pos = 0xd
	// Bit mask of TXADD5 field.
	RADIO_DACNF_TXADD5_Msk = 0x2000
	// Bit TXADD5.
	RADIO_DACNF_TXADD5 = 0x2000
	// Position of TXADD6 field.
	RADIO_DACNF_TXADD6_Pos = 0xe
	// Bit mask of TXADD6 field.
	RADIO_DACNF_TXADD6_Msk = 0x4000
	// Bit TXADD6.
	RADIO_DACNF_TXADD6 = 0x4000
	// Position of TXADD7 field.
	RADIO_DACNF_TXADD7_Pos = 0xf
	// Bit mask of TXADD7 field.
	RADIO_DACNF_TXADD7_Msk = 0x8000
	// Bit TXADD7.
	RADIO_DACNF_TXADD7 = 0x8000

	// MHRMATCHCONF: Search pattern configuration
	// Position of MHRMATCHCONF field.
	RADIO_MHRMATCHCONF_MHRMATCHCONF_Pos = 0x0
	// Bit mask of MHRMATCHCONF field.
	RADIO_MHRMATCHCONF_MHRMATCHCONF_Msk = 0xffffffff

	// MHRMATCHMAS: Pattern mask
	// Position of MHRMATCHMAS field.
	RADIO_MHRMATCHMAS_MHRMATCHMAS_Pos = 0x0
	// Bit mask of MHRMATCHMAS field.
	RADIO_MHRMATCHMAS_MHRMATCHMAS_Msk = 0xffffffff

	// MODECNF0: Radio mode configuration register 0
	// Position of RU field.
	RADIO_MODECNF0_RU_Pos = 0x0
	// Bit mask of RU field.
	RADIO_MODECNF0_RU_Msk = 0x1
	// Bit RU.
	RADIO_MODECNF0_RU = 0x1
	// Default ramp-up time (tRXEN and tTXEN), compatible with firmware written for nRF51
	RADIO_MODECNF0_RU_Default = 0x0
	// Fast ramp-up (tRXEN,FAST and tTXEN,FAST), see electrical specification for more information
	RADIO_MODECNF0_RU_Fast = 0x1
	// Position of DTX field.
	RADIO_MODECNF0_DTX_Pos = 0x8
	// Bit mask of DTX field.
	RADIO_MODECNF0_DTX_Msk = 0x300
	// Transmit '1'
	RADIO_MODECNF0_DTX_B1 = 0x0
	// Transmit '0'
	RADIO_MODECNF0_DTX_B0 = 0x1
	// Transmit center frequency
	RADIO_MODECNF0_DTX_Center = 0x2

	// SFD: IEEE 802.15.4 start of frame delimiter
	// Position of SFD field.
	RADIO_SFD_SFD_Pos = 0x0
	// Bit mask of SFD field.
	RADIO_SFD_SFD_Msk = 0xff

	// EDCNT: IEEE 802.15.4 energy detect loop count
	// Position of EDCNT field.
	RADIO_EDCNT_EDCNT_Pos = 0x0
	// Bit mask of EDCNT field.
	RADIO_EDCNT_EDCNT_Msk = 0x1fffff

	// EDSAMPLE: IEEE 802.15.4 energy detect level
	// Position of EDLVL field.
	RADIO_EDSAMPLE_EDLVL_Pos = 0x0
	// Bit mask of EDLVL field.
	RADIO_EDSAMPLE_EDLVL_Msk = 0xff

	// CCACTRL: IEEE 802.15.4 clear channel assessment control
	// Position of CCAMODE field.
	RADIO_CCACTRL_CCAMODE_Pos = 0x0
	// Bit mask of CCAMODE field.
	RADIO_CCACTRL_CCAMODE_Msk = 0x7
	// Energy above threshold
	RADIO_CCACTRL_CCAMODE_EdMode = 0x0
	// Carrier seen
	RADIO_CCACTRL_CCAMODE_CarrierMode = 0x1
	// Energy above threshold AND carrier seen
	RADIO_CCACTRL_CCAMODE_CarrierAndEdMode = 0x2
	// Energy above threshold OR carrier seen
	RADIO_CCACTRL_CCAMODE_CarrierOrEdMode = 0x3
	// Energy above threshold test mode that will abort when first ED measurement over threshold is seen. No averaging.
	RADIO_CCACTRL_CCAMODE_EdModeTest1 = 0x4
	// Position of CCAEDTHRES field.
	RADIO_CCACTRL_CCAEDTHRES_Pos = 0x8
	// Bit mask of CCAEDTHRES field.
	RADIO_CCACTRL_CCAEDTHRES_Msk = 0xff00
	// Position of CCACORRTHRES field.
	RADIO_CCACTRL_CCACORRTHRES_Pos = 0x10
	// Bit mask of CCACORRTHRES field.
	RADIO_CCACTRL_CCACORRTHRES_Msk = 0xff0000
	// Position of CCACORRCNT field.
	RADIO_CCACTRL_CCACORRCNT_Pos = 0x18
	// Bit mask of CCACORRCNT field.
	RADIO_CCACTRL_CCACORRCNT_Msk = 0xff000000

	// DFEMODE: Whether to use Angle-of-Arrival (AOA) or Angle-of-Departure (AOD)
	// Position of DFEOPMODE field.
	RADIO_DFEMODE_DFEOPMODE_Pos = 0x0
	// Bit mask of DFEOPMODE field.
	RADIO_DFEMODE_DFEOPMODE_Msk = 0x3
	// Direction finding mode disabled
	RADIO_DFEMODE_DFEOPMODE_Disabled = 0x0
	// Direction finding mode set to AoD
	RADIO_DFEMODE_DFEOPMODE_AoD = 0x2
	// Direction finding mode set to AoA
	RADIO_DFEMODE_DFEOPMODE_AoA = 0x3

	// CTEINLINECONF: Configuration for CTE inline mode
	// Position of CTEINLINECTRLEN field.
	RADIO_CTEINLINECONF_CTEINLINECTRLEN_Pos = 0x0
	// Bit mask of CTEINLINECTRLEN field.
	RADIO_CTEINLINECONF_CTEINLINECTRLEN_Msk = 0x1
	// Bit CTEINLINECTRLEN.
	RADIO_CTEINLINECONF_CTEINLINECTRLEN = 0x1
	// Parsing of CTEInfo is enabled
	RADIO_CTEINLINECONF_CTEINLINECTRLEN_Enabled = 0x1
	// Parsing of CTEInfo is disabled
	RADIO_CTEINLINECONF_CTEINLINECTRLEN_Disabled = 0x0
	// Position of CTEINFOINS1 field.
	RADIO_CTEINLINECONF_CTEINFOINS1_Pos = 0x3
	// Bit mask of CTEINFOINS1 field.
	RADIO_CTEINLINECONF_CTEINFOINS1_Msk = 0x8
	// Bit CTEINFOINS1.
	RADIO_CTEINLINECONF_CTEINFOINS1 = 0x8
	// CTEInfo is in S1 byte (data PDU)
	RADIO_CTEINLINECONF_CTEINFOINS1_InS1 = 0x1
	// CTEInfo is NOT in S1 byte (advertising PDU)
	RADIO_CTEINLINECONF_CTEINFOINS1_NotInS1 = 0x0
	// Position of CTEERRORHANDLING field.
	RADIO_CTEINLINECONF_CTEERRORHANDLING_Pos = 0x4
	// Bit mask of CTEERRORHANDLING field.
	RADIO_CTEINLINECONF_CTEERRORHANDLING_Msk = 0x10
	// Bit CTEERRORHANDLING.
	RADIO_CTEINLINECONF_CTEERRORHANDLING = 0x10
	// Sampling and antenna switching also when CRC is not OK
	RADIO_CTEINLINECONF_CTEERRORHANDLING_Yes = 0x1
	// No sampling and antenna switching when CRC is not OK
	RADIO_CTEINLINECONF_CTEERRORHANDLING_No = 0x0
	// Position of CTETIMEVALIDRANGE field.
	RADIO_CTEINLINECONF_CTETIMEVALIDRANGE_Pos = 0x6
	// Bit mask of CTETIMEVALIDRANGE field.
	RADIO_CTEINLINECONF_CTETIMEVALIDRANGE_Msk = 0xc0
	// 20 in 8us unit (default) Set to 20 if parsed CTETime is larger han 20
	RADIO_CTEINLINECONF_CTETIMEVALIDRANGE_20 = 0x0
	// 31 in 8us unit
	RADIO_CTEINLINECONF_CTETIMEVALIDRANGE_31 = 0x1
	// 63 in 8us unit
	RADIO_CTEINLINECONF_CTETIMEVALIDRANGE_63 = 0x2
	// Position of CTEINLINERXMODE1US field.
	RADIO_CTEINLINECONF_CTEINLINERXMODE1US_Pos = 0xa
	// Bit mask of CTEINLINERXMODE1US field.
	RADIO_CTEINLINECONF_CTEINLINERXMODE1US_Msk = 0x1c00
	// 4us
	RADIO_CTEINLINECONF_CTEINLINERXMODE1US_4us = 0x1
	// 2us
	RADIO_CTEINLINECONF_CTEINLINERXMODE1US_2us = 0x2
	// 1us
	RADIO_CTEINLINECONF_CTEINLINERXMODE1US_1us = 0x3
	// 0.5us
	RADIO_CTEINLINECONF_CTEINLINERXMODE1US_500ns = 0x4
	// 0.25us
	RADIO_CTEINLINECONF_CTEINLINERXMODE1US_250ns = 0x5
	// 0.125us
	RADIO_CTEINLINECONF_CTEINLINERXMODE1US_125ns = 0x6
	// Position of CTEINLINERXMODE2US field.
	RADIO_CTEINLINECONF_CTEINLINERXMODE2US_Pos = 0xd
	// Bit mask of CTEINLINERXMODE2US field.
	RADIO_CTEINLINECONF_CTEINLINERXMODE2US_Msk = 0xe000
	// 4us
	RADIO_CTEINLINECONF_CTEINLINERXMODE2US_4us = 0x1
	// 2us
	RADIO_CTEINLINECONF_CTEINLINERXMODE2US_2us = 0x2
	// 1us
	RADIO_CTEINLINECONF_CTEINLINERXMODE2US_1us = 0x3
	// 0.5us
	RADIO_CTEINLINECONF_CTEINLINERXMODE2US_500ns = 0x4
	// 0.25us
	RADIO_CTEINLINECONF_CTEINLINERXMODE2US_250ns = 0x5
	// 0.125us
	RADIO_CTEINLINECONF_CTEINLINERXMODE2US_125ns = 0x6
	// Position of S0CONF field.
	RADIO_CTEINLINECONF_S0CONF_Pos = 0x10
	// Bit mask of S0CONF field.
	RADIO_CTEINLINECONF_S0CONF_Msk = 0xff0000
	// Position of S0MASK field.
	RADIO_CTEINLINECONF_S0MASK_Pos = 0x18
	// Bit mask of S0MASK field.
	RADIO_CTEINLINECONF_S0MASK_Msk = 0xff000000

	// DFECTRL1: Various configuration for Direction finding
	// Position of NUMBEROF8US field.
	RADIO_DFECTRL1_NUMBEROF8US_Pos = 0x0
	// Bit mask of NUMBEROF8US field.
	RADIO_DFECTRL1_NUMBEROF8US_Msk = 0x3f
	// Position of DFEINEXTENSION field.
	RADIO_DFECTRL1_DFEINEXTENSION_Pos = 0x7
	// Bit mask of DFEINEXTENSION field.
	RADIO_DFECTRL1_DFEINEXTENSION_Msk = 0x80
	// Bit DFEINEXTENSION.
	RADIO_DFECTRL1_DFEINEXTENSION = 0x80
	// AoA/AoD procedure triggered at end of CRC
	RADIO_DFECTRL1_DFEINEXTENSION_CRC = 0x1
	// Antenna switching/sampling is done in the packet payload
	RADIO_DFECTRL1_DFEINEXTENSION_Payload = 0x0
	// Position of TSWITCHSPACING field.
	RADIO_DFECTRL1_TSWITCHSPACING_Pos = 0x8
	// Bit mask of TSWITCHSPACING field.
	RADIO_DFECTRL1_TSWITCHSPACING_Msk = 0x700
	// 4us
	RADIO_DFECTRL1_TSWITCHSPACING_4us = 0x1
	// 2us
	RADIO_DFECTRL1_TSWITCHSPACING_2us = 0x2
	// 1us
	RADIO_DFECTRL1_TSWITCHSPACING_1us = 0x3
	// Position of TSAMPLESPACINGREF field.
	RADIO_DFECTRL1_TSAMPLESPACINGREF_Pos = 0xc
	// Bit mask of TSAMPLESPACINGREF field.
	RADIO_DFECTRL1_TSAMPLESPACINGREF_Msk = 0x7000
	// 4us
	RADIO_DFECTRL1_TSAMPLESPACINGREF_4us = 0x1
	// 2us
	RADIO_DFECTRL1_TSAMPLESPACINGREF_2us = 0x2
	// 1us
	RADIO_DFECTRL1_TSAMPLESPACINGREF_1us = 0x3
	// 0.5us
	RADIO_DFECTRL1_TSAMPLESPACINGREF_500ns = 0x4
	// 0.25us
	RADIO_DFECTRL1_TSAMPLESPACINGREF_250ns = 0x5
	// 0.125us
	RADIO_DFECTRL1_TSAMPLESPACINGREF_125ns = 0x6
	// Position of SAMPLETYPE field.
	RADIO_DFECTRL1_SAMPLETYPE_Pos = 0xf
	// Bit mask of SAMPLETYPE field.
	RADIO_DFECTRL1_SAMPLETYPE_Msk = 0x8000
	// Bit SAMPLETYPE.
	RADIO_DFECTRL1_SAMPLETYPE = 0x8000
	// Complex samples in I and Q
	RADIO_DFECTRL1_SAMPLETYPE_IQ = 0x0
	// Complex samples as magnitude and phase
	RADIO_DFECTRL1_SAMPLETYPE_MagPhase = 0x1
	// Position of TSAMPLESPACING field.
	RADIO_DFECTRL1_TSAMPLESPACING_Pos = 0x10
	// Bit mask of TSAMPLESPACING field.
	RADIO_DFECTRL1_TSAMPLESPACING_Msk = 0x70000
	// 4us
	RADIO_DFECTRL1_TSAMPLESPACING_4us = 0x1
	// 2us
	RADIO_DFECTRL1_TSAMPLESPACING_2us = 0x2
	// 1us
	RADIO_DFECTRL1_TSAMPLESPACING_1us = 0x3
	// 0.5us
	RADIO_DFECTRL1_TSAMPLESPACING_500ns = 0x4
	// 0.25us
	RADIO_DFECTRL1_TSAMPLESPACING_250ns = 0x5
	// 0.125us
	RADIO_DFECTRL1_TSAMPLESPACING_125ns = 0x6
	// Position of REPEATPATTERN field.
	RADIO_DFECTRL1_REPEATPATTERN_Pos = 0x14
	// Bit mask of REPEATPATTERN field.
	RADIO_DFECTRL1_REPEATPATTERN_Msk = 0xf00000
	// Do not repeat (1 time in total)
	RADIO_DFECTRL1_REPEATPATTERN_NoRepeat = 0x0
	// Position of AGCBACKOFFGAIN field.
	RADIO_DFECTRL1_AGCBACKOFFGAIN_Pos = 0x18
	// Bit mask of AGCBACKOFFGAIN field.
	RADIO_DFECTRL1_AGCBACKOFFGAIN_Msk = 0xf000000

	// DFECTRL2: Start offset for Direction finding
	// Position of TSWITCHOFFSET field.
	RADIO_DFECTRL2_TSWITCHOFFSET_Pos = 0x0
	// Bit mask of TSWITCHOFFSET field.
	RADIO_DFECTRL2_TSWITCHOFFSET_Msk = 0x1fff
	// Position of TSAMPLEOFFSET field.
	RADIO_DFECTRL2_TSAMPLEOFFSET_Pos = 0x10
	// Bit mask of TSAMPLEOFFSET field.
	RADIO_DFECTRL2_TSAMPLEOFFSET_Msk = 0xfff0000

	// SWITCHPATTERN: GPIO patterns to be used for each antenna
	// Position of SWITCHPATTERN field.
	RADIO_SWITCHPATTERN_SWITCHPATTERN_Pos = 0x0
	// Bit mask of SWITCHPATTERN field.
	RADIO_SWITCHPATTERN_SWITCHPATTERN_Msk = 0xff

	// CLEARPATTERN: Clear the GPIO pattern array for antenna control
	// Position of CLEARPATTERN field.
	RADIO_CLEARPATTERN_CLEARPATTERN_Pos = 0x0
	// Bit mask of CLEARPATTERN field.
	RADIO_CLEARPATTERN_CLEARPATTERN_Msk = 0x1
	// Bit CLEARPATTERN.
	RADIO_CLEARPATTERN_CLEARPATTERN = 0x1
	// Clear the GPIO pattern
	RADIO_CLEARPATTERN_CLEARPATTERN_Clear = 0x1

	// PSEL.DFEGPIO: Description collection: Pin select for DFE pin n
	// Position of PIN field.
	RADIO_PSEL_DFEGPIO_PIN_Pos = 0x0
	// Bit mask of PIN field.
	RADIO_PSEL_DFEGPIO_PIN_Msk = 0x1f
	// Position of PORT field.
	RADIO_PSEL_DFEGPIO_PORT_Pos = 0x5
	// Bit mask of PORT field.
	RADIO_PSEL_DFEGPIO_PORT_Msk = 0x20
	// Bit PORT.
	RADIO_PSEL_DFEGPIO_PORT = 0x20
	// Position of CONNECT field.
	RADIO_PSEL_DFEGPIO_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	RADIO_PSEL_DFEGPIO_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	RADIO_PSEL_DFEGPIO_CONNECT = 0x80000000
	// Disconnect
	RADIO_PSEL_DFEGPIO_CONNECT_Disconnected = 0x1
	// Connect
	RADIO_PSEL_DFEGPIO_CONNECT_Connected = 0x0

	// DFEPACKET.PTR: Data pointer
	// Position of PTR field.
	RADIO_DFEPACKET_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	RADIO_DFEPACKET_PTR_PTR_Msk = 0xffffffff

	// DFEPACKET.MAXCNT: Maximum number of buffer words to transfer
	// Position of MAXCNT field.
	RADIO_DFEPACKET_MAXCNT_MAXCNT_Pos = 0x0
	// Bit mask of MAXCNT field.
	RADIO_DFEPACKET_MAXCNT_MAXCNT_Msk = 0x3fff

	// DFEPACKET.AMOUNT: Number of samples transferred in the last transaction
	// Position of AMOUNT field.
	RADIO_DFEPACKET_AMOUNT_AMOUNT_Pos = 0x0
	// Bit mask of AMOUNT field.
	RADIO_DFEPACKET_AMOUNT_AMOUNT_Msk = 0xffff

	// POWER: Peripheral power control
	// Position of POWER field.
	RADIO_POWER_POWER_Pos = 0x0
	// Bit mask of POWER field.
	RADIO_POWER_POWER_Msk = 0x1
	// Bit POWER.
	RADIO_POWER_POWER = 0x1
	// Peripheral is powered off
	RADIO_POWER_POWER_Disabled = 0x0
	// Peripheral is powered on
	RADIO_POWER_POWER_Enabled = 0x1
)

// Bitfields for RNG_NS: Random Number Generator
const (
	// TASKS_START: Task starting the random number generator
	// Position of TASKS_START field.
	RNG_TASKS_START_TASKS_START_Pos = 0x0
	// Bit mask of TASKS_START field.
	RNG_TASKS_START_TASKS_START_Msk = 0x1
	// Bit TASKS_START.
	RNG_TASKS_START_TASKS_START = 0x1
	// Trigger task
	RNG_TASKS_START_TASKS_START_Trigger = 0x1

	// TASKS_STOP: Task stopping the random number generator
	// Position of TASKS_STOP field.
	RNG_TASKS_STOP_TASKS_STOP_Pos = 0x0
	// Bit mask of TASKS_STOP field.
	RNG_TASKS_STOP_TASKS_STOP_Msk = 0x1
	// Bit TASKS_STOP.
	RNG_TASKS_STOP_TASKS_STOP = 0x1
	// Trigger task
	RNG_TASKS_STOP_TASKS_STOP_Trigger = 0x1

	// SUBSCRIBE_START: Subscribe configuration for task START
	// Position of CHIDX field.
	RNG_SUBSCRIBE_START_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RNG_SUBSCRIBE_START_CHIDX_Msk = 0xff
	// Position of EN field.
	RNG_SUBSCRIBE_START_EN_Pos = 0x1f
	// Bit mask of EN field.
	RNG_SUBSCRIBE_START_EN_Msk = 0x80000000
	// Bit EN.
	RNG_SUBSCRIBE_START_EN = 0x80000000
	// Disable subscription
	RNG_SUBSCRIBE_START_EN_Disabled = 0x0
	// Enable subscription
	RNG_SUBSCRIBE_START_EN_Enabled = 0x1

	// SUBSCRIBE_STOP: Subscribe configuration for task STOP
	// Position of CHIDX field.
	RNG_SUBSCRIBE_STOP_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RNG_SUBSCRIBE_STOP_CHIDX_Msk = 0xff
	// Position of EN field.
	RNG_SUBSCRIBE_STOP_EN_Pos = 0x1f
	// Bit mask of EN field.
	RNG_SUBSCRIBE_STOP_EN_Msk = 0x80000000
	// Bit EN.
	RNG_SUBSCRIBE_STOP_EN = 0x80000000
	// Disable subscription
	RNG_SUBSCRIBE_STOP_EN_Disabled = 0x0
	// Enable subscription
	RNG_SUBSCRIBE_STOP_EN_Enabled = 0x1

	// EVENTS_VALRDY: Event being generated for every new random number written to the VALUE register
	// Position of EVENTS_VALRDY field.
	RNG_EVENTS_VALRDY_EVENTS_VALRDY_Pos = 0x0
	// Bit mask of EVENTS_VALRDY field.
	RNG_EVENTS_VALRDY_EVENTS_VALRDY_Msk = 0x1
	// Bit EVENTS_VALRDY.
	RNG_EVENTS_VALRDY_EVENTS_VALRDY = 0x1
	// Event not generated
	RNG_EVENTS_VALRDY_EVENTS_VALRDY_NotGenerated = 0x0
	// Event generated
	RNG_EVENTS_VALRDY_EVENTS_VALRDY_Generated = 0x1

	// PUBLISH_VALRDY: Publish configuration for event VALRDY
	// Position of CHIDX field.
	RNG_PUBLISH_VALRDY_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RNG_PUBLISH_VALRDY_CHIDX_Msk = 0xff
	// Position of EN field.
	RNG_PUBLISH_VALRDY_EN_Pos = 0x1f
	// Bit mask of EN field.
	RNG_PUBLISH_VALRDY_EN_Msk = 0x80000000
	// Bit EN.
	RNG_PUBLISH_VALRDY_EN = 0x80000000
	// Disable publishing
	RNG_PUBLISH_VALRDY_EN_Disabled = 0x0
	// Enable publishing
	RNG_PUBLISH_VALRDY_EN_Enabled = 0x1

	// SHORTS: Shortcuts between local events and tasks
	// Position of VALRDY_STOP field.
	RNG_SHORTS_VALRDY_STOP_Pos = 0x0
	// Bit mask of VALRDY_STOP field.
	RNG_SHORTS_VALRDY_STOP_Msk = 0x1
	// Bit VALRDY_STOP.
	RNG_SHORTS_VALRDY_STOP = 0x1
	// Disable shortcut
	RNG_SHORTS_VALRDY_STOP_Disabled = 0x0
	// Enable shortcut
	RNG_SHORTS_VALRDY_STOP_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of VALRDY field.
	RNG_INTENSET_VALRDY_Pos = 0x0
	// Bit mask of VALRDY field.
	RNG_INTENSET_VALRDY_Msk = 0x1
	// Bit VALRDY.
	RNG_INTENSET_VALRDY = 0x1
	// Read: Disabled
	RNG_INTENSET_VALRDY_Disabled = 0x0
	// Read: Enabled
	RNG_INTENSET_VALRDY_Enabled = 0x1
	// Enable
	RNG_INTENSET_VALRDY_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of VALRDY field.
	RNG_INTENCLR_VALRDY_Pos = 0x0
	// Bit mask of VALRDY field.
	RNG_INTENCLR_VALRDY_Msk = 0x1
	// Bit VALRDY.
	RNG_INTENCLR_VALRDY = 0x1
	// Read: Disabled
	RNG_INTENCLR_VALRDY_Disabled = 0x0
	// Read: Enabled
	RNG_INTENCLR_VALRDY_Enabled = 0x1
	// Disable
	RNG_INTENCLR_VALRDY_Clear = 0x1

	// CONFIG: Configuration register
	// Position of DERCEN field.
	RNG_CONFIG_DERCEN_Pos = 0x0
	// Bit mask of DERCEN field.
	RNG_CONFIG_DERCEN_Msk = 0x1
	// Bit DERCEN.
	RNG_CONFIG_DERCEN = 0x1
	// Disabled
	RNG_CONFIG_DERCEN_Disabled = 0x0
	// Enabled
	RNG_CONFIG_DERCEN_Enabled = 0x1

	// VALUE: Output random number
	// Position of VALUE field.
	RNG_VALUE_VALUE_Pos = 0x0
	// Bit mask of VALUE field.
	RNG_VALUE_VALUE_Msk = 0xff
)

// Bitfields for GPIOTE_NS: GPIO Tasks and Events
const (
	// TASKS_OUT: Description collection: Task for writing to pin specified in CONFIG[n].PSEL. Action on pin is configured in CONFIG[n].POLARITY.
	// Position of TASKS_OUT field.
	GPIOTE_TASKS_OUT_TASKS_OUT_Pos = 0x0
	// Bit mask of TASKS_OUT field.
	GPIOTE_TASKS_OUT_TASKS_OUT_Msk = 0x1
	// Bit TASKS_OUT.
	GPIOTE_TASKS_OUT_TASKS_OUT = 0x1
	// Trigger task
	GPIOTE_TASKS_OUT_TASKS_OUT_Trigger = 0x1

	// TASKS_SET: Description collection: Task for writing to pin specified in CONFIG[n].PSEL. Action on pin is to set it high.
	// Position of TASKS_SET field.
	GPIOTE_TASKS_SET_TASKS_SET_Pos = 0x0
	// Bit mask of TASKS_SET field.
	GPIOTE_TASKS_SET_TASKS_SET_Msk = 0x1
	// Bit TASKS_SET.
	GPIOTE_TASKS_SET_TASKS_SET = 0x1
	// Trigger task
	GPIOTE_TASKS_SET_TASKS_SET_Trigger = 0x1

	// TASKS_CLR: Description collection: Task for writing to pin specified in CONFIG[n].PSEL. Action on pin is to set it low.
	// Position of TASKS_CLR field.
	GPIOTE_TASKS_CLR_TASKS_CLR_Pos = 0x0
	// Bit mask of TASKS_CLR field.
	GPIOTE_TASKS_CLR_TASKS_CLR_Msk = 0x1
	// Bit TASKS_CLR.
	GPIOTE_TASKS_CLR_TASKS_CLR = 0x1
	// Trigger task
	GPIOTE_TASKS_CLR_TASKS_CLR_Trigger = 0x1

	// SUBSCRIBE_OUT: Description collection: Subscribe configuration for task OUT[n]
	// Position of CHIDX field.
	GPIOTE_SUBSCRIBE_OUT_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	GPIOTE_SUBSCRIBE_OUT_CHIDX_Msk = 0xff
	// Position of EN field.
	GPIOTE_SUBSCRIBE_OUT_EN_Pos = 0x1f
	// Bit mask of EN field.
	GPIOTE_SUBSCRIBE_OUT_EN_Msk = 0x80000000
	// Bit EN.
	GPIOTE_SUBSCRIBE_OUT_EN = 0x80000000
	// Disable subscription
	GPIOTE_SUBSCRIBE_OUT_EN_Disabled = 0x0
	// Enable subscription
	GPIOTE_SUBSCRIBE_OUT_EN_Enabled = 0x1

	// SUBSCRIBE_SET: Description collection: Subscribe configuration for task SET[n]
	// Position of CHIDX field.
	GPIOTE_SUBSCRIBE_SET_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	GPIOTE_SUBSCRIBE_SET_CHIDX_Msk = 0xff
	// Position of EN field.
	GPIOTE_SUBSCRIBE_SET_EN_Pos = 0x1f
	// Bit mask of EN field.
	GPIOTE_SUBSCRIBE_SET_EN_Msk = 0x80000000
	// Bit EN.
	GPIOTE_SUBSCRIBE_SET_EN = 0x80000000
	// Disable subscription
	GPIOTE_SUBSCRIBE_SET_EN_Disabled = 0x0
	// Enable subscription
	GPIOTE_SUBSCRIBE_SET_EN_Enabled = 0x1

	// SUBSCRIBE_CLR: Description collection: Subscribe configuration for task CLR[n]
	// Position of CHIDX field.
	GPIOTE_SUBSCRIBE_CLR_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	GPIOTE_SUBSCRIBE_CLR_CHIDX_Msk = 0xff
	// Position of EN field.
	GPIOTE_SUBSCRIBE_CLR_EN_Pos = 0x1f
	// Bit mask of EN field.
	GPIOTE_SUBSCRIBE_CLR_EN_Msk = 0x80000000
	// Bit EN.
	GPIOTE_SUBSCRIBE_CLR_EN = 0x80000000
	// Disable subscription
	GPIOTE_SUBSCRIBE_CLR_EN_Disabled = 0x0
	// Enable subscription
	GPIOTE_SUBSCRIBE_CLR_EN_Enabled = 0x1

	// EVENTS_IN: Description collection: Event generated from pin specified in CONFIG[n].PSEL
	// Position of EVENTS_IN field.
	GPIOTE_EVENTS_IN_EVENTS_IN_Pos = 0x0
	// Bit mask of EVENTS_IN field.
	GPIOTE_EVENTS_IN_EVENTS_IN_Msk = 0x1
	// Bit EVENTS_IN.
	GPIOTE_EVENTS_IN_EVENTS_IN = 0x1
	// Event not generated
	GPIOTE_EVENTS_IN_EVENTS_IN_NotGenerated = 0x0
	// Event generated
	GPIOTE_EVENTS_IN_EVENTS_IN_Generated = 0x1

	// EVENTS_PORT: Event generated from multiple input GPIO pins with SENSE mechanism enabled
	// Position of EVENTS_PORT field.
	GPIOTE_EVENTS_PORT_EVENTS_PORT_Pos = 0x0
	// Bit mask of EVENTS_PORT field.
	GPIOTE_EVENTS_PORT_EVENTS_PORT_Msk = 0x1
	// Bit EVENTS_PORT.
	GPIOTE_EVENTS_PORT_EVENTS_PORT = 0x1
	// Event not generated
	GPIOTE_EVENTS_PORT_EVENTS_PORT_NotGenerated = 0x0
	// Event generated
	GPIOTE_EVENTS_PORT_EVENTS_PORT_Generated = 0x1

	// PUBLISH_IN: Description collection: Publish configuration for event IN[n]
	// Position of CHIDX field.
	GPIOTE_PUBLISH_IN_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	GPIOTE_PUBLISH_IN_CHIDX_Msk = 0xff
	// Position of EN field.
	GPIOTE_PUBLISH_IN_EN_Pos = 0x1f
	// Bit mask of EN field.
	GPIOTE_PUBLISH_IN_EN_Msk = 0x80000000
	// Bit EN.
	GPIOTE_PUBLISH_IN_EN = 0x80000000
	// Disable publishing
	GPIOTE_PUBLISH_IN_EN_Disabled = 0x0
	// Enable publishing
	GPIOTE_PUBLISH_IN_EN_Enabled = 0x1

	// PUBLISH_PORT: Publish configuration for event PORT
	// Position of CHIDX field.
	GPIOTE_PUBLISH_PORT_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	GPIOTE_PUBLISH_PORT_CHIDX_Msk = 0xff
	// Position of EN field.
	GPIOTE_PUBLISH_PORT_EN_Pos = 0x1f
	// Bit mask of EN field.
	GPIOTE_PUBLISH_PORT_EN_Msk = 0x80000000
	// Bit EN.
	GPIOTE_PUBLISH_PORT_EN = 0x80000000
	// Disable publishing
	GPIOTE_PUBLISH_PORT_EN_Disabled = 0x0
	// Enable publishing
	GPIOTE_PUBLISH_PORT_EN_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of IN0 field.
	GPIOTE_INTENSET_IN0_Pos = 0x0
	// Bit mask of IN0 field.
	GPIOTE_INTENSET_IN0_Msk = 0x1
	// Bit IN0.
	GPIOTE_INTENSET_IN0 = 0x1
	// Read: Disabled
	GPIOTE_INTENSET_IN0_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENSET_IN0_Enabled = 0x1
	// Enable
	GPIOTE_INTENSET_IN0_Set = 0x1
	// Position of IN1 field.
	GPIOTE_INTENSET_IN1_Pos = 0x1
	// Bit mask of IN1 field.
	GPIOTE_INTENSET_IN1_Msk = 0x2
	// Bit IN1.
	GPIOTE_INTENSET_IN1 = 0x2
	// Read: Disabled
	GPIOTE_INTENSET_IN1_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENSET_IN1_Enabled = 0x1
	// Enable
	GPIOTE_INTENSET_IN1_Set = 0x1
	// Position of IN2 field.
	GPIOTE_INTENSET_IN2_Pos = 0x2
	// Bit mask of IN2 field.
	GPIOTE_INTENSET_IN2_Msk = 0x4
	// Bit IN2.
	GPIOTE_INTENSET_IN2 = 0x4
	// Read: Disabled
	GPIOTE_INTENSET_IN2_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENSET_IN2_Enabled = 0x1
	// Enable
	GPIOTE_INTENSET_IN2_Set = 0x1
	// Position of IN3 field.
	GPIOTE_INTENSET_IN3_Pos = 0x3
	// Bit mask of IN3 field.
	GPIOTE_INTENSET_IN3_Msk = 0x8
	// Bit IN3.
	GPIOTE_INTENSET_IN3 = 0x8
	// Read: Disabled
	GPIOTE_INTENSET_IN3_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENSET_IN3_Enabled = 0x1
	// Enable
	GPIOTE_INTENSET_IN3_Set = 0x1
	// Position of IN4 field.
	GPIOTE_INTENSET_IN4_Pos = 0x4
	// Bit mask of IN4 field.
	GPIOTE_INTENSET_IN4_Msk = 0x10
	// Bit IN4.
	GPIOTE_INTENSET_IN4 = 0x10
	// Read: Disabled
	GPIOTE_INTENSET_IN4_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENSET_IN4_Enabled = 0x1
	// Enable
	GPIOTE_INTENSET_IN4_Set = 0x1
	// Position of IN5 field.
	GPIOTE_INTENSET_IN5_Pos = 0x5
	// Bit mask of IN5 field.
	GPIOTE_INTENSET_IN5_Msk = 0x20
	// Bit IN5.
	GPIOTE_INTENSET_IN5 = 0x20
	// Read: Disabled
	GPIOTE_INTENSET_IN5_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENSET_IN5_Enabled = 0x1
	// Enable
	GPIOTE_INTENSET_IN5_Set = 0x1
	// Position of IN6 field.
	GPIOTE_INTENSET_IN6_Pos = 0x6
	// Bit mask of IN6 field.
	GPIOTE_INTENSET_IN6_Msk = 0x40
	// Bit IN6.
	GPIOTE_INTENSET_IN6 = 0x40
	// Read: Disabled
	GPIOTE_INTENSET_IN6_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENSET_IN6_Enabled = 0x1
	// Enable
	GPIOTE_INTENSET_IN6_Set = 0x1
	// Position of IN7 field.
	GPIOTE_INTENSET_IN7_Pos = 0x7
	// Bit mask of IN7 field.
	GPIOTE_INTENSET_IN7_Msk = 0x80
	// Bit IN7.
	GPIOTE_INTENSET_IN7 = 0x80
	// Read: Disabled
	GPIOTE_INTENSET_IN7_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENSET_IN7_Enabled = 0x1
	// Enable
	GPIOTE_INTENSET_IN7_Set = 0x1
	// Position of PORT field.
	GPIOTE_INTENSET_PORT_Pos = 0x1f
	// Bit mask of PORT field.
	GPIOTE_INTENSET_PORT_Msk = 0x80000000
	// Bit PORT.
	GPIOTE_INTENSET_PORT = 0x80000000
	// Read: Disabled
	GPIOTE_INTENSET_PORT_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENSET_PORT_Enabled = 0x1
	// Enable
	GPIOTE_INTENSET_PORT_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of IN0 field.
	GPIOTE_INTENCLR_IN0_Pos = 0x0
	// Bit mask of IN0 field.
	GPIOTE_INTENCLR_IN0_Msk = 0x1
	// Bit IN0.
	GPIOTE_INTENCLR_IN0 = 0x1
	// Read: Disabled
	GPIOTE_INTENCLR_IN0_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENCLR_IN0_Enabled = 0x1
	// Disable
	GPIOTE_INTENCLR_IN0_Clear = 0x1
	// Position of IN1 field.
	GPIOTE_INTENCLR_IN1_Pos = 0x1
	// Bit mask of IN1 field.
	GPIOTE_INTENCLR_IN1_Msk = 0x2
	// Bit IN1.
	GPIOTE_INTENCLR_IN1 = 0x2
	// Read: Disabled
	GPIOTE_INTENCLR_IN1_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENCLR_IN1_Enabled = 0x1
	// Disable
	GPIOTE_INTENCLR_IN1_Clear = 0x1
	// Position of IN2 field.
	GPIOTE_INTENCLR_IN2_Pos = 0x2
	// Bit mask of IN2 field.
	GPIOTE_INTENCLR_IN2_Msk = 0x4
	// Bit IN2.
	GPIOTE_INTENCLR_IN2 = 0x4
	// Read: Disabled
	GPIOTE_INTENCLR_IN2_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENCLR_IN2_Enabled = 0x1
	// Disable
	GPIOTE_INTENCLR_IN2_Clear = 0x1
	// Position of IN3 field.
	GPIOTE_INTENCLR_IN3_Pos = 0x3
	// Bit mask of IN3 field.
	GPIOTE_INTENCLR_IN3_Msk = 0x8
	// Bit IN3.
	GPIOTE_INTENCLR_IN3 = 0x8
	// Read: Disabled
	GPIOTE_INTENCLR_IN3_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENCLR_IN3_Enabled = 0x1
	// Disable
	GPIOTE_INTENCLR_IN3_Clear = 0x1
	// Position of IN4 field.
	GPIOTE_INTENCLR_IN4_Pos = 0x4
	// Bit mask of IN4 field.
	GPIOTE_INTENCLR_IN4_Msk = 0x10
	// Bit IN4.
	GPIOTE_INTENCLR_IN4 = 0x10
	// Read: Disabled
	GPIOTE_INTENCLR_IN4_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENCLR_IN4_Enabled = 0x1
	// Disable
	GPIOTE_INTENCLR_IN4_Clear = 0x1
	// Position of IN5 field.
	GPIOTE_INTENCLR_IN5_Pos = 0x5
	// Bit mask of IN5 field.
	GPIOTE_INTENCLR_IN5_Msk = 0x20
	// Bit IN5.
	GPIOTE_INTENCLR_IN5 = 0x20
	// Read: Disabled
	GPIOTE_INTENCLR_IN5_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENCLR_IN5_Enabled = 0x1
	// Disable
	GPIOTE_INTENCLR_IN5_Clear = 0x1
	// Position of IN6 field.
	GPIOTE_INTENCLR_IN6_Pos = 0x6
	// Bit mask of IN6 field.
	GPIOTE_INTENCLR_IN6_Msk = 0x40
	// Bit IN6.
	GPIOTE_INTENCLR_IN6 = 0x40
	// Read: Disabled
	GPIOTE_INTENCLR_IN6_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENCLR_IN6_Enabled = 0x1
	// Disable
	GPIOTE_INTENCLR_IN6_Clear = 0x1
	// Position of IN7 field.
	GPIOTE_INTENCLR_IN7_Pos = 0x7
	// Bit mask of IN7 field.
	GPIOTE_INTENCLR_IN7_Msk = 0x80
	// Bit IN7.
	GPIOTE_INTENCLR_IN7 = 0x80
	// Read: Disabled
	GPIOTE_INTENCLR_IN7_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENCLR_IN7_Enabled = 0x1
	// Disable
	GPIOTE_INTENCLR_IN7_Clear = 0x1
	// Position of PORT field.
	GPIOTE_INTENCLR_PORT_Pos = 0x1f
	// Bit mask of PORT field.
	GPIOTE_INTENCLR_PORT_Msk = 0x80000000
	// Bit PORT.
	GPIOTE_INTENCLR_PORT = 0x80000000
	// Read: Disabled
	GPIOTE_INTENCLR_PORT_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENCLR_PORT_Enabled = 0x1
	// Disable
	GPIOTE_INTENCLR_PORT_Clear = 0x1

	// LATENCY: Latency selection for Event mode (MODE=Event) with rising or falling edge detection on the pin.
	// Position of LATENCY field.
	GPIOTE_LATENCY_LATENCY_Pos = 0x0
	// Bit mask of LATENCY field.
	GPIOTE_LATENCY_LATENCY_Msk = 0x1
	// Bit LATENCY.
	GPIOTE_LATENCY_LATENCY = 0x1
	// Low power setting, for signals with minimum hold time tGPIOTE,HOLD,LP; refer to Electrical specification section
	GPIOTE_LATENCY_LATENCY_LowPower = 0x0
	// Low latency setting, for signals with minimum hold time tGPIOTE,HOLD,LL; refer to Electrical specification section
	GPIOTE_LATENCY_LATENCY_LowLatency = 0x1

	// CONFIG: Description collection: Configuration for OUT[n], SET[n], and CLR[n] tasks and IN[n] event
	// Position of MODE field.
	GPIOTE_CONFIG_MODE_Pos = 0x0
	// Bit mask of MODE field.
	GPIOTE_CONFIG_MODE_Msk = 0x3
	// Disabled. Pin specified by PSEL will not be acquired by the GPIOTE module.
	GPIOTE_CONFIG_MODE_Disabled = 0x0
	// Event mode
	GPIOTE_CONFIG_MODE_Event = 0x1
	// Task mode
	GPIOTE_CONFIG_MODE_Task = 0x3
	// Position of PSEL field.
	GPIOTE_CONFIG_PSEL_Pos = 0x8
	// Bit mask of PSEL field.
	GPIOTE_CONFIG_PSEL_Msk = 0x1f00
	// Position of PORT field.
	GPIOTE_CONFIG_PORT_Pos = 0xd
	// Bit mask of PORT field.
	GPIOTE_CONFIG_PORT_Msk = 0x2000
	// Bit PORT.
	GPIOTE_CONFIG_PORT = 0x2000
	// Position of POLARITY field.
	GPIOTE_CONFIG_POLARITY_Pos = 0x10
	// Bit mask of POLARITY field.
	GPIOTE_CONFIG_POLARITY_Msk = 0x30000
	// Task mode: No effect on pin from OUT[n] task. Event mode: no IN[n] event generated on pin activity.
	GPIOTE_CONFIG_POLARITY_None = 0x0
	// Task mode: Set pin from OUT[n] task. Event mode: Generate IN[n] event when rising edge on pin.
	GPIOTE_CONFIG_POLARITY_LoToHi = 0x1
	// Task mode: Clear pin from OUT[n] task. Event mode: Generate IN[n] event when falling edge on pin.
	GPIOTE_CONFIG_POLARITY_HiToLo = 0x2
	// Task mode: Toggle pin from OUT[n]. Event mode: Generate IN[n] when any change on pin.
	GPIOTE_CONFIG_POLARITY_Toggle = 0x3
	// Position of OUTINIT field.
	GPIOTE_CONFIG_OUTINIT_Pos = 0x14
	// Bit mask of OUTINIT field.
	GPIOTE_CONFIG_OUTINIT_Msk = 0x100000
	// Bit OUTINIT.
	GPIOTE_CONFIG_OUTINIT = 0x100000
	// Task mode: Initial value of pin before task triggering is low
	GPIOTE_CONFIG_OUTINIT_Low = 0x0
	// Task mode: Initial value of pin before task triggering is high
	GPIOTE_CONFIG_OUTINIT_High = 0x1
)

// Bitfields for WDT_NS: Watchdog Timer
const (
	// TASKS_START: Start the watchdog
	// Position of TASKS_START field.
	WDT_TASKS_START_TASKS_START_Pos = 0x0
	// Bit mask of TASKS_START field.
	WDT_TASKS_START_TASKS_START_Msk = 0x1
	// Bit TASKS_START.
	WDT_TASKS_START_TASKS_START = 0x1
	// Trigger task
	WDT_TASKS_START_TASKS_START_Trigger = 0x1

	// TASKS_STOP: Stop the watchdog timer.
	// Position of TASKS_STOP field.
	WDT_TASKS_STOP_TASKS_STOP_Pos = 0x0
	// Bit mask of TASKS_STOP field.
	WDT_TASKS_STOP_TASKS_STOP_Msk = 0x1
	// Bit TASKS_STOP.
	WDT_TASKS_STOP_TASKS_STOP = 0x1
	// Trigger task
	WDT_TASKS_STOP_TASKS_STOP_Trigger = 0x1

	// SUBSCRIBE_START: Subscribe configuration for task START
	// Position of CHIDX field.
	WDT_SUBSCRIBE_START_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	WDT_SUBSCRIBE_START_CHIDX_Msk = 0xff
	// Position of EN field.
	WDT_SUBSCRIBE_START_EN_Pos = 0x1f
	// Bit mask of EN field.
	WDT_SUBSCRIBE_START_EN_Msk = 0x80000000
	// Bit EN.
	WDT_SUBSCRIBE_START_EN = 0x80000000
	// Disable subscription
	WDT_SUBSCRIBE_START_EN_Disabled = 0x0
	// Enable subscription
	WDT_SUBSCRIBE_START_EN_Enabled = 0x1

	// SUBSCRIBE_STOP: Subscribe configuration for task STOP
	// Position of CHIDX field.
	WDT_SUBSCRIBE_STOP_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	WDT_SUBSCRIBE_STOP_CHIDX_Msk = 0xff
	// Position of EN field.
	WDT_SUBSCRIBE_STOP_EN_Pos = 0x1f
	// Bit mask of EN field.
	WDT_SUBSCRIBE_STOP_EN_Msk = 0x80000000
	// Bit EN.
	WDT_SUBSCRIBE_STOP_EN = 0x80000000
	// Disable subscription
	WDT_SUBSCRIBE_STOP_EN_Disabled = 0x0
	// Enable subscription
	WDT_SUBSCRIBE_STOP_EN_Enabled = 0x1

	// EVENTS_TIMEOUT: Watchdog timeout
	// Position of EVENTS_TIMEOUT field.
	WDT_EVENTS_TIMEOUT_EVENTS_TIMEOUT_Pos = 0x0
	// Bit mask of EVENTS_TIMEOUT field.
	WDT_EVENTS_TIMEOUT_EVENTS_TIMEOUT_Msk = 0x1
	// Bit EVENTS_TIMEOUT.
	WDT_EVENTS_TIMEOUT_EVENTS_TIMEOUT = 0x1
	// Event not generated
	WDT_EVENTS_TIMEOUT_EVENTS_TIMEOUT_NotGenerated = 0x0
	// Event generated
	WDT_EVENTS_TIMEOUT_EVENTS_TIMEOUT_Generated = 0x1

	// EVENTS_STOPPED: Watchdog stopped
	// Position of EVENTS_STOPPED field.
	WDT_EVENTS_STOPPED_EVENTS_STOPPED_Pos = 0x0
	// Bit mask of EVENTS_STOPPED field.
	WDT_EVENTS_STOPPED_EVENTS_STOPPED_Msk = 0x1
	// Bit EVENTS_STOPPED.
	WDT_EVENTS_STOPPED_EVENTS_STOPPED = 0x1
	// Event not generated
	WDT_EVENTS_STOPPED_EVENTS_STOPPED_NotGenerated = 0x0
	// Event generated
	WDT_EVENTS_STOPPED_EVENTS_STOPPED_Generated = 0x1

	// PUBLISH_TIMEOUT: Publish configuration for event TIMEOUT
	// Position of CHIDX field.
	WDT_PUBLISH_TIMEOUT_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	WDT_PUBLISH_TIMEOUT_CHIDX_Msk = 0xff
	// Position of EN field.
	WDT_PUBLISH_TIMEOUT_EN_Pos = 0x1f
	// Bit mask of EN field.
	WDT_PUBLISH_TIMEOUT_EN_Msk = 0x80000000
	// Bit EN.
	WDT_PUBLISH_TIMEOUT_EN = 0x80000000
	// Disable publishing
	WDT_PUBLISH_TIMEOUT_EN_Disabled = 0x0
	// Enable publishing
	WDT_PUBLISH_TIMEOUT_EN_Enabled = 0x1

	// PUBLISH_STOPPED: Publish configuration for event STOPPED
	// Position of CHIDX field.
	WDT_PUBLISH_STOPPED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	WDT_PUBLISH_STOPPED_CHIDX_Msk = 0xff
	// Position of EN field.
	WDT_PUBLISH_STOPPED_EN_Pos = 0x1f
	// Bit mask of EN field.
	WDT_PUBLISH_STOPPED_EN_Msk = 0x80000000
	// Bit EN.
	WDT_PUBLISH_STOPPED_EN = 0x80000000
	// Disable publishing
	WDT_PUBLISH_STOPPED_EN_Disabled = 0x0
	// Enable publishing
	WDT_PUBLISH_STOPPED_EN_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of TIMEOUT field.
	WDT_INTENSET_TIMEOUT_Pos = 0x0
	// Bit mask of TIMEOUT field.
	WDT_INTENSET_TIMEOUT_Msk = 0x1
	// Bit TIMEOUT.
	WDT_INTENSET_TIMEOUT = 0x1
	// Read: Disabled
	WDT_INTENSET_TIMEOUT_Disabled = 0x0
	// Read: Enabled
	WDT_INTENSET_TIMEOUT_Enabled = 0x1
	// Enable
	WDT_INTENSET_TIMEOUT_Set = 0x1
	// Position of STOPPED field.
	WDT_INTENSET_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	WDT_INTENSET_STOPPED_Msk = 0x2
	// Bit STOPPED.
	WDT_INTENSET_STOPPED = 0x2
	// Read: Disabled
	WDT_INTENSET_STOPPED_Disabled = 0x0
	// Read: Enabled
	WDT_INTENSET_STOPPED_Enabled = 0x1
	// Enable
	WDT_INTENSET_STOPPED_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of TIMEOUT field.
	WDT_INTENCLR_TIMEOUT_Pos = 0x0
	// Bit mask of TIMEOUT field.
	WDT_INTENCLR_TIMEOUT_Msk = 0x1
	// Bit TIMEOUT.
	WDT_INTENCLR_TIMEOUT = 0x1
	// Read: Disabled
	WDT_INTENCLR_TIMEOUT_Disabled = 0x0
	// Read: Enabled
	WDT_INTENCLR_TIMEOUT_Enabled = 0x1
	// Disable
	WDT_INTENCLR_TIMEOUT_Clear = 0x1
	// Position of STOPPED field.
	WDT_INTENCLR_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	WDT_INTENCLR_STOPPED_Msk = 0x2
	// Bit STOPPED.
	WDT_INTENCLR_STOPPED = 0x2
	// Read: Disabled
	WDT_INTENCLR_STOPPED_Disabled = 0x0
	// Read: Enabled
	WDT_INTENCLR_STOPPED_Enabled = 0x1
	// Disable
	WDT_INTENCLR_STOPPED_Clear = 0x1

	// NMIENSET: Enable interrupt
	// Position of TIMEOUT field.
	WDT_NMIENSET_TIMEOUT_Pos = 0x0
	// Bit mask of TIMEOUT field.
	WDT_NMIENSET_TIMEOUT_Msk = 0x1
	// Bit TIMEOUT.
	WDT_NMIENSET_TIMEOUT = 0x1
	// Read: Disabled
	WDT_NMIENSET_TIMEOUT_Disabled = 0x0
	// Read: Enabled
	WDT_NMIENSET_TIMEOUT_Enabled = 0x1
	// Enable
	WDT_NMIENSET_TIMEOUT_Set = 0x1
	// Position of STOPPED field.
	WDT_NMIENSET_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	WDT_NMIENSET_STOPPED_Msk = 0x2
	// Bit STOPPED.
	WDT_NMIENSET_STOPPED = 0x2
	// Read: Disabled
	WDT_NMIENSET_STOPPED_Disabled = 0x0
	// Read: Enabled
	WDT_NMIENSET_STOPPED_Enabled = 0x1
	// Enable
	WDT_NMIENSET_STOPPED_Set = 0x1

	// NMIENCLR: Disable interrupt
	// Position of TIMEOUT field.
	WDT_NMIENCLR_TIMEOUT_Pos = 0x0
	// Bit mask of TIMEOUT field.
	WDT_NMIENCLR_TIMEOUT_Msk = 0x1
	// Bit TIMEOUT.
	WDT_NMIENCLR_TIMEOUT = 0x1
	// Read: Disabled
	WDT_NMIENCLR_TIMEOUT_Disabled = 0x0
	// Read: Enabled
	WDT_NMIENCLR_TIMEOUT_Enabled = 0x1
	// Disable
	WDT_NMIENCLR_TIMEOUT_Clear = 0x1
	// Position of STOPPED field.
	WDT_NMIENCLR_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	WDT_NMIENCLR_STOPPED_Msk = 0x2
	// Bit STOPPED.
	WDT_NMIENCLR_STOPPED = 0x2
	// Read: Disabled
	WDT_NMIENCLR_STOPPED_Disabled = 0x0
	// Read: Enabled
	WDT_NMIENCLR_STOPPED_Enabled = 0x1
	// Disable
	WDT_NMIENCLR_STOPPED_Clear = 0x1

	// RUNSTATUS: Run status
	// Position of RUNSTATUSWDT field.
	WDT_RUNSTATUS_RUNSTATUSWDT_Pos = 0x0
	// Bit mask of RUNSTATUSWDT field.
	WDT_RUNSTATUS_RUNSTATUSWDT_Msk = 0x1
	// Bit RUNSTATUSWDT.
	WDT_RUNSTATUS_RUNSTATUSWDT = 0x1
	// Watchdog not running
	WDT_RUNSTATUS_RUNSTATUSWDT_NotRunning = 0x0
	// Watchdog is running
	WDT_RUNSTATUS_RUNSTATUSWDT_Running = 0x1

	// REQSTATUS: Request status
	// Position of RR0 field.
	WDT_REQSTATUS_RR0_Pos = 0x0
	// Bit mask of RR0 field.
	WDT_REQSTATUS_RR0_Msk = 0x1
	// Bit RR0.
	WDT_REQSTATUS_RR0 = 0x1
	// RR[0] register is not enabled, or are already requesting reload
	WDT_REQSTATUS_RR0_DisabledOrRequested = 0x0
	// RR[0] register is enabled, and are not yet requesting reload
	WDT_REQSTATUS_RR0_EnabledAndUnrequested = 0x1
	// Position of RR1 field.
	WDT_REQSTATUS_RR1_Pos = 0x1
	// Bit mask of RR1 field.
	WDT_REQSTATUS_RR1_Msk = 0x2
	// Bit RR1.
	WDT_REQSTATUS_RR1 = 0x2
	// RR[1] register is not enabled, or are already requesting reload
	WDT_REQSTATUS_RR1_DisabledOrRequested = 0x0
	// RR[1] register is enabled, and are not yet requesting reload
	WDT_REQSTATUS_RR1_EnabledAndUnrequested = 0x1
	// Position of RR2 field.
	WDT_REQSTATUS_RR2_Pos = 0x2
	// Bit mask of RR2 field.
	WDT_REQSTATUS_RR2_Msk = 0x4
	// Bit RR2.
	WDT_REQSTATUS_RR2 = 0x4
	// RR[2] register is not enabled, or are already requesting reload
	WDT_REQSTATUS_RR2_DisabledOrRequested = 0x0
	// RR[2] register is enabled, and are not yet requesting reload
	WDT_REQSTATUS_RR2_EnabledAndUnrequested = 0x1
	// Position of RR3 field.
	WDT_REQSTATUS_RR3_Pos = 0x3
	// Bit mask of RR3 field.
	WDT_REQSTATUS_RR3_Msk = 0x8
	// Bit RR3.
	WDT_REQSTATUS_RR3 = 0x8
	// RR[3] register is not enabled, or are already requesting reload
	WDT_REQSTATUS_RR3_DisabledOrRequested = 0x0
	// RR[3] register is enabled, and are not yet requesting reload
	WDT_REQSTATUS_RR3_EnabledAndUnrequested = 0x1
	// Position of RR4 field.
	WDT_REQSTATUS_RR4_Pos = 0x4
	// Bit mask of RR4 field.
	WDT_REQSTATUS_RR4_Msk = 0x10
	// Bit RR4.
	WDT_REQSTATUS_RR4 = 0x10
	// RR[4] register is not enabled, or are already requesting reload
	WDT_REQSTATUS_RR4_DisabledOrRequested = 0x0
	// RR[4] register is enabled, and are not yet requesting reload
	WDT_REQSTATUS_RR4_EnabledAndUnrequested = 0x1
	// Position of RR5 field.
	WDT_REQSTATUS_RR5_Pos = 0x5
	// Bit mask of RR5 field.
	WDT_REQSTATUS_RR5_Msk = 0x20
	// Bit RR5.
	WDT_REQSTATUS_RR5 = 0x20
	// RR[5] register is not enabled, or are already requesting reload
	WDT_REQSTATUS_RR5_DisabledOrRequested = 0x0
	// RR[5] register is enabled, and are not yet requesting reload
	WDT_REQSTATUS_RR5_EnabledAndUnrequested = 0x1
	// Position of RR6 field.
	WDT_REQSTATUS_RR6_Pos = 0x6
	// Bit mask of RR6 field.
	WDT_REQSTATUS_RR6_Msk = 0x40
	// Bit RR6.
	WDT_REQSTATUS_RR6 = 0x40
	// RR[6] register is not enabled, or are already requesting reload
	WDT_REQSTATUS_RR6_DisabledOrRequested = 0x0
	// RR[6] register is enabled, and are not yet requesting reload
	WDT_REQSTATUS_RR6_EnabledAndUnrequested = 0x1
	// Position of RR7 field.
	WDT_REQSTATUS_RR7_Pos = 0x7
	// Bit mask of RR7 field.
	WDT_REQSTATUS_RR7_Msk = 0x80
	// Bit RR7.
	WDT_REQSTATUS_RR7 = 0x80
	// RR[7] register is not enabled, or are already requesting reload
	WDT_REQSTATUS_RR7_DisabledOrRequested = 0x0
	// RR[7] register is enabled, and are not yet requesting reload
	WDT_REQSTATUS_RR7_EnabledAndUnrequested = 0x1

	// CRV: Counter reload value
	// Position of CRV field.
	WDT_CRV_CRV_Pos = 0x0
	// Bit mask of CRV field.
	WDT_CRV_CRV_Msk = 0xffffffff

	// RREN: Enable register for reload request registers
	// Position of RR0 field.
	WDT_RREN_RR0_Pos = 0x0
	// Bit mask of RR0 field.
	WDT_RREN_RR0_Msk = 0x1
	// Bit RR0.
	WDT_RREN_RR0 = 0x1
	// Disable RR[0] register
	WDT_RREN_RR0_Disabled = 0x0
	// Enable RR[0] register
	WDT_RREN_RR0_Enabled = 0x1
	// Position of RR1 field.
	WDT_RREN_RR1_Pos = 0x1
	// Bit mask of RR1 field.
	WDT_RREN_RR1_Msk = 0x2
	// Bit RR1.
	WDT_RREN_RR1 = 0x2
	// Disable RR[1] register
	WDT_RREN_RR1_Disabled = 0x0
	// Enable RR[1] register
	WDT_RREN_RR1_Enabled = 0x1
	// Position of RR2 field.
	WDT_RREN_RR2_Pos = 0x2
	// Bit mask of RR2 field.
	WDT_RREN_RR2_Msk = 0x4
	// Bit RR2.
	WDT_RREN_RR2 = 0x4
	// Disable RR[2] register
	WDT_RREN_RR2_Disabled = 0x0
	// Enable RR[2] register
	WDT_RREN_RR2_Enabled = 0x1
	// Position of RR3 field.
	WDT_RREN_RR3_Pos = 0x3
	// Bit mask of RR3 field.
	WDT_RREN_RR3_Msk = 0x8
	// Bit RR3.
	WDT_RREN_RR3 = 0x8
	// Disable RR[3] register
	WDT_RREN_RR3_Disabled = 0x0
	// Enable RR[3] register
	WDT_RREN_RR3_Enabled = 0x1
	// Position of RR4 field.
	WDT_RREN_RR4_Pos = 0x4
	// Bit mask of RR4 field.
	WDT_RREN_RR4_Msk = 0x10
	// Bit RR4.
	WDT_RREN_RR4 = 0x10
	// Disable RR[4] register
	WDT_RREN_RR4_Disabled = 0x0
	// Enable RR[4] register
	WDT_RREN_RR4_Enabled = 0x1
	// Position of RR5 field.
	WDT_RREN_RR5_Pos = 0x5
	// Bit mask of RR5 field.
	WDT_RREN_RR5_Msk = 0x20
	// Bit RR5.
	WDT_RREN_RR5 = 0x20
	// Disable RR[5] register
	WDT_RREN_RR5_Disabled = 0x0
	// Enable RR[5] register
	WDT_RREN_RR5_Enabled = 0x1
	// Position of RR6 field.
	WDT_RREN_RR6_Pos = 0x6
	// Bit mask of RR6 field.
	WDT_RREN_RR6_Msk = 0x40
	// Bit RR6.
	WDT_RREN_RR6 = 0x40
	// Disable RR[6] register
	WDT_RREN_RR6_Disabled = 0x0
	// Enable RR[6] register
	WDT_RREN_RR6_Enabled = 0x1
	// Position of RR7 field.
	WDT_RREN_RR7_Pos = 0x7
	// Bit mask of RR7 field.
	WDT_RREN_RR7_Msk = 0x80
	// Bit RR7.
	WDT_RREN_RR7 = 0x80
	// Disable RR[7] register
	WDT_RREN_RR7_Disabled = 0x0
	// Enable RR[7] register
	WDT_RREN_RR7_Enabled = 0x1

	// CONFIG: Configuration register
	// Position of SLEEP field.
	WDT_CONFIG_SLEEP_Pos = 0x0
	// Bit mask of SLEEP field.
	WDT_CONFIG_SLEEP_Msk = 0x1
	// Bit SLEEP.
	WDT_CONFIG_SLEEP = 0x1
	// Pause watchdog while the CPU is sleeping
	WDT_CONFIG_SLEEP_Pause = 0x0
	// Keep the watchdog running while the CPU is sleeping
	WDT_CONFIG_SLEEP_Run = 0x1
	// Position of HALT field.
	WDT_CONFIG_HALT_Pos = 0x3
	// Bit mask of HALT field.
	WDT_CONFIG_HALT_Msk = 0x8
	// Bit HALT.
	WDT_CONFIG_HALT = 0x8
	// Pause watchdog while the CPU is halted by the debugger
	WDT_CONFIG_HALT_Pause = 0x0
	// Keep the watchdog running while the CPU is halted by the debugger
	WDT_CONFIG_HALT_Run = 0x1
	// Position of STOPEN field.
	WDT_CONFIG_STOPEN_Pos = 0x6
	// Bit mask of STOPEN field.
	WDT_CONFIG_STOPEN_Msk = 0x40
	// Bit STOPEN.
	WDT_CONFIG_STOPEN = 0x40
	// Do not allow stopping the watchdog
	WDT_CONFIG_STOPEN_Disable = 0x0
	// Allow stopping the watchdog
	WDT_CONFIG_STOPEN_Enable = 0x1

	// TSEN: Task Stop Enable
	// Position of TSEN field.
	WDT_TSEN_TSEN_Pos = 0x0
	// Bit mask of TSEN field.
	WDT_TSEN_TSEN_Msk = 0xffffffff
	// Value to allow stopping the watchdog
	WDT_TSEN_TSEN_Enable = 0x6e524635

	// RR: Description collection: Reload request n
	// Position of RR field.
	WDT_RR_RR_Pos = 0x0
	// Bit mask of RR field.
	WDT_RR_RR_Msk = 0xffffffff
	// Value to request a reload of the watchdog timer
	WDT_RR_RR_Reload = 0x6e524635
)

// Bitfields for TIMER0_NS: Timer/Counter 0
const (
	// TASKS_START: Start Timer
	// Position of TASKS_START field.
	TIMER_TASKS_START_TASKS_START_Pos = 0x0
	// Bit mask of TASKS_START field.
	TIMER_TASKS_START_TASKS_START_Msk = 0x1
	// Bit TASKS_START.
	TIMER_TASKS_START_TASKS_START = 0x1
	// Trigger task
	TIMER_TASKS_START_TASKS_START_Trigger = 0x1

	// TASKS_STOP: Stop Timer
	// Position of TASKS_STOP field.
	TIMER_TASKS_STOP_TASKS_STOP_Pos = 0x0
	// Bit mask of TASKS_STOP field.
	TIMER_TASKS_STOP_TASKS_STOP_Msk = 0x1
	// Bit TASKS_STOP.
	TIMER_TASKS_STOP_TASKS_STOP = 0x1
	// Trigger task
	TIMER_TASKS_STOP_TASKS_STOP_Trigger = 0x1

	// TASKS_COUNT: Increment Timer (Counter mode only)
	// Position of TASKS_COUNT field.
	TIMER_TASKS_COUNT_TASKS_COUNT_Pos = 0x0
	// Bit mask of TASKS_COUNT field.
	TIMER_TASKS_COUNT_TASKS_COUNT_Msk = 0x1
	// Bit TASKS_COUNT.
	TIMER_TASKS_COUNT_TASKS_COUNT = 0x1
	// Trigger task
	TIMER_TASKS_COUNT_TASKS_COUNT_Trigger = 0x1

	// TASKS_CLEAR: Clear time
	// Position of TASKS_CLEAR field.
	TIMER_TASKS_CLEAR_TASKS_CLEAR_Pos = 0x0
	// Bit mask of TASKS_CLEAR field.
	TIMER_TASKS_CLEAR_TASKS_CLEAR_Msk = 0x1
	// Bit TASKS_CLEAR.
	TIMER_TASKS_CLEAR_TASKS_CLEAR = 0x1
	// Trigger task
	TIMER_TASKS_CLEAR_TASKS_CLEAR_Trigger = 0x1

	// TASKS_SHUTDOWN: Deprecated register - Shut down timer
	// Position of TASKS_SHUTDOWN field.
	TIMER_TASKS_SHUTDOWN_TASKS_SHUTDOWN_Pos = 0x0
	// Bit mask of TASKS_SHUTDOWN field.
	TIMER_TASKS_SHUTDOWN_TASKS_SHUTDOWN_Msk = 0x1
	// Bit TASKS_SHUTDOWN.
	TIMER_TASKS_SHUTDOWN_TASKS_SHUTDOWN = 0x1
	// Trigger task
	TIMER_TASKS_SHUTDOWN_TASKS_SHUTDOWN_Trigger = 0x1

	// TASKS_CAPTURE: Description collection: Capture Timer value to CC[n] register
	// Position of TASKS_CAPTURE field.
	TIMER_TASKS_CAPTURE_TASKS_CAPTURE_Pos = 0x0
	// Bit mask of TASKS_CAPTURE field.
	TIMER_TASKS_CAPTURE_TASKS_CAPTURE_Msk = 0x1
	// Bit TASKS_CAPTURE.
	TIMER_TASKS_CAPTURE_TASKS_CAPTURE = 0x1
	// Trigger task
	TIMER_TASKS_CAPTURE_TASKS_CAPTURE_Trigger = 0x1

	// SUBSCRIBE_START: Subscribe configuration for task START
	// Position of CHIDX field.
	TIMER_SUBSCRIBE_START_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TIMER_SUBSCRIBE_START_CHIDX_Msk = 0xff
	// Position of EN field.
	TIMER_SUBSCRIBE_START_EN_Pos = 0x1f
	// Bit mask of EN field.
	TIMER_SUBSCRIBE_START_EN_Msk = 0x80000000
	// Bit EN.
	TIMER_SUBSCRIBE_START_EN = 0x80000000
	// Disable subscription
	TIMER_SUBSCRIBE_START_EN_Disabled = 0x0
	// Enable subscription
	TIMER_SUBSCRIBE_START_EN_Enabled = 0x1

	// SUBSCRIBE_STOP: Subscribe configuration for task STOP
	// Position of CHIDX field.
	TIMER_SUBSCRIBE_STOP_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TIMER_SUBSCRIBE_STOP_CHIDX_Msk = 0xff
	// Position of EN field.
	TIMER_SUBSCRIBE_STOP_EN_Pos = 0x1f
	// Bit mask of EN field.
	TIMER_SUBSCRIBE_STOP_EN_Msk = 0x80000000
	// Bit EN.
	TIMER_SUBSCRIBE_STOP_EN = 0x80000000
	// Disable subscription
	TIMER_SUBSCRIBE_STOP_EN_Disabled = 0x0
	// Enable subscription
	TIMER_SUBSCRIBE_STOP_EN_Enabled = 0x1

	// SUBSCRIBE_COUNT: Subscribe configuration for task COUNT
	// Position of CHIDX field.
	TIMER_SUBSCRIBE_COUNT_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TIMER_SUBSCRIBE_COUNT_CHIDX_Msk = 0xff
	// Position of EN field.
	TIMER_SUBSCRIBE_COUNT_EN_Pos = 0x1f
	// Bit mask of EN field.
	TIMER_SUBSCRIBE_COUNT_EN_Msk = 0x80000000
	// Bit EN.
	TIMER_SUBSCRIBE_COUNT_EN = 0x80000000
	// Disable subscription
	TIMER_SUBSCRIBE_COUNT_EN_Disabled = 0x0
	// Enable subscription
	TIMER_SUBSCRIBE_COUNT_EN_Enabled = 0x1

	// SUBSCRIBE_CLEAR: Subscribe configuration for task CLEAR
	// Position of CHIDX field.
	TIMER_SUBSCRIBE_CLEAR_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TIMER_SUBSCRIBE_CLEAR_CHIDX_Msk = 0xff
	// Position of EN field.
	TIMER_SUBSCRIBE_CLEAR_EN_Pos = 0x1f
	// Bit mask of EN field.
	TIMER_SUBSCRIBE_CLEAR_EN_Msk = 0x80000000
	// Bit EN.
	TIMER_SUBSCRIBE_CLEAR_EN = 0x80000000
	// Disable subscription
	TIMER_SUBSCRIBE_CLEAR_EN_Disabled = 0x0
	// Enable subscription
	TIMER_SUBSCRIBE_CLEAR_EN_Enabled = 0x1

	// SUBSCRIBE_SHUTDOWN: Deprecated register - Subscribe configuration for task SHUTDOWN
	// Position of CHIDX field.
	TIMER_SUBSCRIBE_SHUTDOWN_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TIMER_SUBSCRIBE_SHUTDOWN_CHIDX_Msk = 0xff
	// Position of EN field.
	TIMER_SUBSCRIBE_SHUTDOWN_EN_Pos = 0x1f
	// Bit mask of EN field.
	TIMER_SUBSCRIBE_SHUTDOWN_EN_Msk = 0x80000000
	// Bit EN.
	TIMER_SUBSCRIBE_SHUTDOWN_EN = 0x80000000
	// Disable subscription
	TIMER_SUBSCRIBE_SHUTDOWN_EN_Disabled = 0x0
	// Enable subscription
	TIMER_SUBSCRIBE_SHUTDOWN_EN_Enabled = 0x1

	// SUBSCRIBE_CAPTURE: Description collection: Subscribe configuration for task CAPTURE[n]
	// Position of CHIDX field.
	TIMER_SUBSCRIBE_CAPTURE_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TIMER_SUBSCRIBE_CAPTURE_CHIDX_Msk = 0xff
	// Position of EN field.
	TIMER_SUBSCRIBE_CAPTURE_EN_Pos = 0x1f
	// Bit mask of EN field.
	TIMER_SUBSCRIBE_CAPTURE_EN_Msk = 0x80000000
	// Bit EN.
	TIMER_SUBSCRIBE_CAPTURE_EN = 0x80000000
	// Disable subscription
	TIMER_SUBSCRIBE_CAPTURE_EN_Disabled = 0x0
	// Enable subscription
	TIMER_SUBSCRIBE_CAPTURE_EN_Enabled = 0x1

	// EVENTS_COMPARE: Description collection: Compare event on CC[n] match
	// Position of EVENTS_COMPARE field.
	TIMER_EVENTS_COMPARE_EVENTS_COMPARE_Pos = 0x0
	// Bit mask of EVENTS_COMPARE field.
	TIMER_EVENTS_COMPARE_EVENTS_COMPARE_Msk = 0x1
	// Bit EVENTS_COMPARE.
	TIMER_EVENTS_COMPARE_EVENTS_COMPARE = 0x1
	// Event not generated
	TIMER_EVENTS_COMPARE_EVENTS_COMPARE_NotGenerated = 0x0
	// Event generated
	TIMER_EVENTS_COMPARE_EVENTS_COMPARE_Generated = 0x1

	// PUBLISH_COMPARE: Description collection: Publish configuration for event COMPARE[n]
	// Position of CHIDX field.
	TIMER_PUBLISH_COMPARE_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TIMER_PUBLISH_COMPARE_CHIDX_Msk = 0xff
	// Position of EN field.
	TIMER_PUBLISH_COMPARE_EN_Pos = 0x1f
	// Bit mask of EN field.
	TIMER_PUBLISH_COMPARE_EN_Msk = 0x80000000
	// Bit EN.
	TIMER_PUBLISH_COMPARE_EN = 0x80000000
	// Disable publishing
	TIMER_PUBLISH_COMPARE_EN_Disabled = 0x0
	// Enable publishing
	TIMER_PUBLISH_COMPARE_EN_Enabled = 0x1

	// SHORTS: Shortcuts between local events and tasks
	// Position of COMPARE0_CLEAR field.
	TIMER_SHORTS_COMPARE0_CLEAR_Pos = 0x0
	// Bit mask of COMPARE0_CLEAR field.
	TIMER_SHORTS_COMPARE0_CLEAR_Msk = 0x1
	// Bit COMPARE0_CLEAR.
	TIMER_SHORTS_COMPARE0_CLEAR = 0x1
	// Disable shortcut
	TIMER_SHORTS_COMPARE0_CLEAR_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE0_CLEAR_Enabled = 0x1
	// Position of COMPARE1_CLEAR field.
	TIMER_SHORTS_COMPARE1_CLEAR_Pos = 0x1
	// Bit mask of COMPARE1_CLEAR field.
	TIMER_SHORTS_COMPARE1_CLEAR_Msk = 0x2
	// Bit COMPARE1_CLEAR.
	TIMER_SHORTS_COMPARE1_CLEAR = 0x2
	// Disable shortcut
	TIMER_SHORTS_COMPARE1_CLEAR_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE1_CLEAR_Enabled = 0x1
	// Position of COMPARE2_CLEAR field.
	TIMER_SHORTS_COMPARE2_CLEAR_Pos = 0x2
	// Bit mask of COMPARE2_CLEAR field.
	TIMER_SHORTS_COMPARE2_CLEAR_Msk = 0x4
	// Bit COMPARE2_CLEAR.
	TIMER_SHORTS_COMPARE2_CLEAR = 0x4
	// Disable shortcut
	TIMER_SHORTS_COMPARE2_CLEAR_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE2_CLEAR_Enabled = 0x1
	// Position of COMPARE3_CLEAR field.
	TIMER_SHORTS_COMPARE3_CLEAR_Pos = 0x3
	// Bit mask of COMPARE3_CLEAR field.
	TIMER_SHORTS_COMPARE3_CLEAR_Msk = 0x8
	// Bit COMPARE3_CLEAR.
	TIMER_SHORTS_COMPARE3_CLEAR = 0x8
	// Disable shortcut
	TIMER_SHORTS_COMPARE3_CLEAR_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE3_CLEAR_Enabled = 0x1
	// Position of COMPARE4_CLEAR field.
	TIMER_SHORTS_COMPARE4_CLEAR_Pos = 0x4
	// Bit mask of COMPARE4_CLEAR field.
	TIMER_SHORTS_COMPARE4_CLEAR_Msk = 0x10
	// Bit COMPARE4_CLEAR.
	TIMER_SHORTS_COMPARE4_CLEAR = 0x10
	// Disable shortcut
	TIMER_SHORTS_COMPARE4_CLEAR_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE4_CLEAR_Enabled = 0x1
	// Position of COMPARE5_CLEAR field.
	TIMER_SHORTS_COMPARE5_CLEAR_Pos = 0x5
	// Bit mask of COMPARE5_CLEAR field.
	TIMER_SHORTS_COMPARE5_CLEAR_Msk = 0x20
	// Bit COMPARE5_CLEAR.
	TIMER_SHORTS_COMPARE5_CLEAR = 0x20
	// Disable shortcut
	TIMER_SHORTS_COMPARE5_CLEAR_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE5_CLEAR_Enabled = 0x1
	// Position of COMPARE6_CLEAR field.
	TIMER_SHORTS_COMPARE6_CLEAR_Pos = 0x6
	// Bit mask of COMPARE6_CLEAR field.
	TIMER_SHORTS_COMPARE6_CLEAR_Msk = 0x40
	// Bit COMPARE6_CLEAR.
	TIMER_SHORTS_COMPARE6_CLEAR = 0x40
	// Disable shortcut
	TIMER_SHORTS_COMPARE6_CLEAR_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE6_CLEAR_Enabled = 0x1
	// Position of COMPARE7_CLEAR field.
	TIMER_SHORTS_COMPARE7_CLEAR_Pos = 0x7
	// Bit mask of COMPARE7_CLEAR field.
	TIMER_SHORTS_COMPARE7_CLEAR_Msk = 0x80
	// Bit COMPARE7_CLEAR.
	TIMER_SHORTS_COMPARE7_CLEAR = 0x80
	// Disable shortcut
	TIMER_SHORTS_COMPARE7_CLEAR_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE7_CLEAR_Enabled = 0x1
	// Position of COMPARE0_STOP field.
	TIMER_SHORTS_COMPARE0_STOP_Pos = 0x10
	// Bit mask of COMPARE0_STOP field.
	TIMER_SHORTS_COMPARE0_STOP_Msk = 0x10000
	// Bit COMPARE0_STOP.
	TIMER_SHORTS_COMPARE0_STOP = 0x10000
	// Disable shortcut
	TIMER_SHORTS_COMPARE0_STOP_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE0_STOP_Enabled = 0x1
	// Position of COMPARE1_STOP field.
	TIMER_SHORTS_COMPARE1_STOP_Pos = 0x11
	// Bit mask of COMPARE1_STOP field.
	TIMER_SHORTS_COMPARE1_STOP_Msk = 0x20000
	// Bit COMPARE1_STOP.
	TIMER_SHORTS_COMPARE1_STOP = 0x20000
	// Disable shortcut
	TIMER_SHORTS_COMPARE1_STOP_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE1_STOP_Enabled = 0x1
	// Position of COMPARE2_STOP field.
	TIMER_SHORTS_COMPARE2_STOP_Pos = 0x12
	// Bit mask of COMPARE2_STOP field.
	TIMER_SHORTS_COMPARE2_STOP_Msk = 0x40000
	// Bit COMPARE2_STOP.
	TIMER_SHORTS_COMPARE2_STOP = 0x40000
	// Disable shortcut
	TIMER_SHORTS_COMPARE2_STOP_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE2_STOP_Enabled = 0x1
	// Position of COMPARE3_STOP field.
	TIMER_SHORTS_COMPARE3_STOP_Pos = 0x13
	// Bit mask of COMPARE3_STOP field.
	TIMER_SHORTS_COMPARE3_STOP_Msk = 0x80000
	// Bit COMPARE3_STOP.
	TIMER_SHORTS_COMPARE3_STOP = 0x80000
	// Disable shortcut
	TIMER_SHORTS_COMPARE3_STOP_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE3_STOP_Enabled = 0x1
	// Position of COMPARE4_STOP field.
	TIMER_SHORTS_COMPARE4_STOP_Pos = 0x14
	// Bit mask of COMPARE4_STOP field.
	TIMER_SHORTS_COMPARE4_STOP_Msk = 0x100000
	// Bit COMPARE4_STOP.
	TIMER_SHORTS_COMPARE4_STOP = 0x100000
	// Disable shortcut
	TIMER_SHORTS_COMPARE4_STOP_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE4_STOP_Enabled = 0x1
	// Position of COMPARE5_STOP field.
	TIMER_SHORTS_COMPARE5_STOP_Pos = 0x15
	// Bit mask of COMPARE5_STOP field.
	TIMER_SHORTS_COMPARE5_STOP_Msk = 0x200000
	// Bit COMPARE5_STOP.
	TIMER_SHORTS_COMPARE5_STOP = 0x200000
	// Disable shortcut
	TIMER_SHORTS_COMPARE5_STOP_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE5_STOP_Enabled = 0x1
	// Position of COMPARE6_STOP field.
	TIMER_SHORTS_COMPARE6_STOP_Pos = 0x16
	// Bit mask of COMPARE6_STOP field.
	TIMER_SHORTS_COMPARE6_STOP_Msk = 0x400000
	// Bit COMPARE6_STOP.
	TIMER_SHORTS_COMPARE6_STOP = 0x400000
	// Disable shortcut
	TIMER_SHORTS_COMPARE6_STOP_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE6_STOP_Enabled = 0x1
	// Position of COMPARE7_STOP field.
	TIMER_SHORTS_COMPARE7_STOP_Pos = 0x17
	// Bit mask of COMPARE7_STOP field.
	TIMER_SHORTS_COMPARE7_STOP_Msk = 0x800000
	// Bit COMPARE7_STOP.
	TIMER_SHORTS_COMPARE7_STOP = 0x800000
	// Disable shortcut
	TIMER_SHORTS_COMPARE7_STOP_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE7_STOP_Enabled = 0x1

	// INTEN: Enable or disable interrupt
	// Position of COMPARE0 field.
	TIMER_INTEN_COMPARE0_Pos = 0x10
	// Bit mask of COMPARE0 field.
	TIMER_INTEN_COMPARE0_Msk = 0x10000
	// Bit COMPARE0.
	TIMER_INTEN_COMPARE0 = 0x10000
	// Disable
	TIMER_INTEN_COMPARE0_Disabled = 0x0
	// Enable
	TIMER_INTEN_COMPARE0_Enabled = 0x1
	// Position of COMPARE1 field.
	TIMER_INTEN_COMPARE1_Pos = 0x11
	// Bit mask of COMPARE1 field.
	TIMER_INTEN_COMPARE1_Msk = 0x20000
	// Bit COMPARE1.
	TIMER_INTEN_COMPARE1 = 0x20000
	// Disable
	TIMER_INTEN_COMPARE1_Disabled = 0x0
	// Enable
	TIMER_INTEN_COMPARE1_Enabled = 0x1
	// Position of COMPARE2 field.
	TIMER_INTEN_COMPARE2_Pos = 0x12
	// Bit mask of COMPARE2 field.
	TIMER_INTEN_COMPARE2_Msk = 0x40000
	// Bit COMPARE2.
	TIMER_INTEN_COMPARE2 = 0x40000
	// Disable
	TIMER_INTEN_COMPARE2_Disabled = 0x0
	// Enable
	TIMER_INTEN_COMPARE2_Enabled = 0x1
	// Position of COMPARE3 field.
	TIMER_INTEN_COMPARE3_Pos = 0x13
	// Bit mask of COMPARE3 field.
	TIMER_INTEN_COMPARE3_Msk = 0x80000
	// Bit COMPARE3.
	TIMER_INTEN_COMPARE3 = 0x80000
	// Disable
	TIMER_INTEN_COMPARE3_Disabled = 0x0
	// Enable
	TIMER_INTEN_COMPARE3_Enabled = 0x1
	// Position of COMPARE4 field.
	TIMER_INTEN_COMPARE4_Pos = 0x14
	// Bit mask of COMPARE4 field.
	TIMER_INTEN_COMPARE4_Msk = 0x100000
	// Bit COMPARE4.
	TIMER_INTEN_COMPARE4 = 0x100000
	// Disable
	TIMER_INTEN_COMPARE4_Disabled = 0x0
	// Enable
	TIMER_INTEN_COMPARE4_Enabled = 0x1
	// Position of COMPARE5 field.
	TIMER_INTEN_COMPARE5_Pos = 0x15
	// Bit mask of COMPARE5 field.
	TIMER_INTEN_COMPARE5_Msk = 0x200000
	// Bit COMPARE5.
	TIMER_INTEN_COMPARE5 = 0x200000
	// Disable
	TIMER_INTEN_COMPARE5_Disabled = 0x0
	// Enable
	TIMER_INTEN_COMPARE5_Enabled = 0x1
	// Position of COMPARE6 field.
	TIMER_INTEN_COMPARE6_Pos = 0x16
	// Bit mask of COMPARE6 field.
	TIMER_INTEN_COMPARE6_Msk = 0x400000
	// Bit COMPARE6.
	TIMER_INTEN_COMPARE6 = 0x400000
	// Disable
	TIMER_INTEN_COMPARE6_Disabled = 0x0
	// Enable
	TIMER_INTEN_COMPARE6_Enabled = 0x1
	// Position of COMPARE7 field.
	TIMER_INTEN_COMPARE7_Pos = 0x17
	// Bit mask of COMPARE7 field.
	TIMER_INTEN_COMPARE7_Msk = 0x800000
	// Bit COMPARE7.
	TIMER_INTEN_COMPARE7 = 0x800000
	// Disable
	TIMER_INTEN_COMPARE7_Disabled = 0x0
	// Enable
	TIMER_INTEN_COMPARE7_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of COMPARE0 field.
	TIMER_INTENSET_COMPARE0_Pos = 0x10
	// Bit mask of COMPARE0 field.
	TIMER_INTENSET_COMPARE0_Msk = 0x10000
	// Bit COMPARE0.
	TIMER_INTENSET_COMPARE0 = 0x10000
	// Read: Disabled
	TIMER_INTENSET_COMPARE0_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENSET_COMPARE0_Enabled = 0x1
	// Enable
	TIMER_INTENSET_COMPARE0_Set = 0x1
	// Position of COMPARE1 field.
	TIMER_INTENSET_COMPARE1_Pos = 0x11
	// Bit mask of COMPARE1 field.
	TIMER_INTENSET_COMPARE1_Msk = 0x20000
	// Bit COMPARE1.
	TIMER_INTENSET_COMPARE1 = 0x20000
	// Read: Disabled
	TIMER_INTENSET_COMPARE1_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENSET_COMPARE1_Enabled = 0x1
	// Enable
	TIMER_INTENSET_COMPARE1_Set = 0x1
	// Position of COMPARE2 field.
	TIMER_INTENSET_COMPARE2_Pos = 0x12
	// Bit mask of COMPARE2 field.
	TIMER_INTENSET_COMPARE2_Msk = 0x40000
	// Bit COMPARE2.
	TIMER_INTENSET_COMPARE2 = 0x40000
	// Read: Disabled
	TIMER_INTENSET_COMPARE2_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENSET_COMPARE2_Enabled = 0x1
	// Enable
	TIMER_INTENSET_COMPARE2_Set = 0x1
	// Position of COMPARE3 field.
	TIMER_INTENSET_COMPARE3_Pos = 0x13
	// Bit mask of COMPARE3 field.
	TIMER_INTENSET_COMPARE3_Msk = 0x80000
	// Bit COMPARE3.
	TIMER_INTENSET_COMPARE3 = 0x80000
	// Read: Disabled
	TIMER_INTENSET_COMPARE3_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENSET_COMPARE3_Enabled = 0x1
	// Enable
	TIMER_INTENSET_COMPARE3_Set = 0x1
	// Position of COMPARE4 field.
	TIMER_INTENSET_COMPARE4_Pos = 0x14
	// Bit mask of COMPARE4 field.
	TIMER_INTENSET_COMPARE4_Msk = 0x100000
	// Bit COMPARE4.
	TIMER_INTENSET_COMPARE4 = 0x100000
	// Read: Disabled
	TIMER_INTENSET_COMPARE4_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENSET_COMPARE4_Enabled = 0x1
	// Enable
	TIMER_INTENSET_COMPARE4_Set = 0x1
	// Position of COMPARE5 field.
	TIMER_INTENSET_COMPARE5_Pos = 0x15
	// Bit mask of COMPARE5 field.
	TIMER_INTENSET_COMPARE5_Msk = 0x200000
	// Bit COMPARE5.
	TIMER_INTENSET_COMPARE5 = 0x200000
	// Read: Disabled
	TIMER_INTENSET_COMPARE5_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENSET_COMPARE5_Enabled = 0x1
	// Enable
	TIMER_INTENSET_COMPARE5_Set = 0x1
	// Position of COMPARE6 field.
	TIMER_INTENSET_COMPARE6_Pos = 0x16
	// Bit mask of COMPARE6 field.
	TIMER_INTENSET_COMPARE6_Msk = 0x400000
	// Bit COMPARE6.
	TIMER_INTENSET_COMPARE6 = 0x400000
	// Read: Disabled
	TIMER_INTENSET_COMPARE6_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENSET_COMPARE6_Enabled = 0x1
	// Enable
	TIMER_INTENSET_COMPARE6_Set = 0x1
	// Position of COMPARE7 field.
	TIMER_INTENSET_COMPARE7_Pos = 0x17
	// Bit mask of COMPARE7 field.
	TIMER_INTENSET_COMPARE7_Msk = 0x800000
	// Bit COMPARE7.
	TIMER_INTENSET_COMPARE7 = 0x800000
	// Read: Disabled
	TIMER_INTENSET_COMPARE7_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENSET_COMPARE7_Enabled = 0x1
	// Enable
	TIMER_INTENSET_COMPARE7_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of COMPARE0 field.
	TIMER_INTENCLR_COMPARE0_Pos = 0x10
	// Bit mask of COMPARE0 field.
	TIMER_INTENCLR_COMPARE0_Msk = 0x10000
	// Bit COMPARE0.
	TIMER_INTENCLR_COMPARE0 = 0x10000
	// Read: Disabled
	TIMER_INTENCLR_COMPARE0_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENCLR_COMPARE0_Enabled = 0x1
	// Disable
	TIMER_INTENCLR_COMPARE0_Clear = 0x1
	// Position of COMPARE1 field.
	TIMER_INTENCLR_COMPARE1_Pos = 0x11
	// Bit mask of COMPARE1 field.
	TIMER_INTENCLR_COMPARE1_Msk = 0x20000
	// Bit COMPARE1.
	TIMER_INTENCLR_COMPARE1 = 0x20000
	// Read: Disabled
	TIMER_INTENCLR_COMPARE1_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENCLR_COMPARE1_Enabled = 0x1
	// Disable
	TIMER_INTENCLR_COMPARE1_Clear = 0x1
	// Position of COMPARE2 field.
	TIMER_INTENCLR_COMPARE2_Pos = 0x12
	// Bit mask of COMPARE2 field.
	TIMER_INTENCLR_COMPARE2_Msk = 0x40000
	// Bit COMPARE2.
	TIMER_INTENCLR_COMPARE2 = 0x40000
	// Read: Disabled
	TIMER_INTENCLR_COMPARE2_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENCLR_COMPARE2_Enabled = 0x1
	// Disable
	TIMER_INTENCLR_COMPARE2_Clear = 0x1
	// Position of COMPARE3 field.
	TIMER_INTENCLR_COMPARE3_Pos = 0x13
	// Bit mask of COMPARE3 field.
	TIMER_INTENCLR_COMPARE3_Msk = 0x80000
	// Bit COMPARE3.
	TIMER_INTENCLR_COMPARE3 = 0x80000
	// Read: Disabled
	TIMER_INTENCLR_COMPARE3_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENCLR_COMPARE3_Enabled = 0x1
	// Disable
	TIMER_INTENCLR_COMPARE3_Clear = 0x1
	// Position of COMPARE4 field.
	TIMER_INTENCLR_COMPARE4_Pos = 0x14
	// Bit mask of COMPARE4 field.
	TIMER_INTENCLR_COMPARE4_Msk = 0x100000
	// Bit COMPARE4.
	TIMER_INTENCLR_COMPARE4 = 0x100000
	// Read: Disabled
	TIMER_INTENCLR_COMPARE4_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENCLR_COMPARE4_Enabled = 0x1
	// Disable
	TIMER_INTENCLR_COMPARE4_Clear = 0x1
	// Position of COMPARE5 field.
	TIMER_INTENCLR_COMPARE5_Pos = 0x15
	// Bit mask of COMPARE5 field.
	TIMER_INTENCLR_COMPARE5_Msk = 0x200000
	// Bit COMPARE5.
	TIMER_INTENCLR_COMPARE5 = 0x200000
	// Read: Disabled
	TIMER_INTENCLR_COMPARE5_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENCLR_COMPARE5_Enabled = 0x1
	// Disable
	TIMER_INTENCLR_COMPARE5_Clear = 0x1
	// Position of COMPARE6 field.
	TIMER_INTENCLR_COMPARE6_Pos = 0x16
	// Bit mask of COMPARE6 field.
	TIMER_INTENCLR_COMPARE6_Msk = 0x400000
	// Bit COMPARE6.
	TIMER_INTENCLR_COMPARE6 = 0x400000
	// Read: Disabled
	TIMER_INTENCLR_COMPARE6_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENCLR_COMPARE6_Enabled = 0x1
	// Disable
	TIMER_INTENCLR_COMPARE6_Clear = 0x1
	// Position of COMPARE7 field.
	TIMER_INTENCLR_COMPARE7_Pos = 0x17
	// Bit mask of COMPARE7 field.
	TIMER_INTENCLR_COMPARE7_Msk = 0x800000
	// Bit COMPARE7.
	TIMER_INTENCLR_COMPARE7 = 0x800000
	// Read: Disabled
	TIMER_INTENCLR_COMPARE7_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENCLR_COMPARE7_Enabled = 0x1
	// Disable
	TIMER_INTENCLR_COMPARE7_Clear = 0x1

	// MODE: Timer mode selection
	// Position of MODE field.
	TIMER_MODE_MODE_Pos = 0x0
	// Bit mask of MODE field.
	TIMER_MODE_MODE_Msk = 0x3
	// Select Timer mode
	TIMER_MODE_MODE_Timer = 0x0
	// Deprecated enumerator - Select Counter mode
	TIMER_MODE_MODE_Counter = 0x1
	// Select Low Power Counter mode
	TIMER_MODE_MODE_LowPowerCounter = 0x2

	// BITMODE: Configure the number of bits used by the TIMER
	// Position of BITMODE field.
	TIMER_BITMODE_BITMODE_Pos = 0x0
	// Bit mask of BITMODE field.
	TIMER_BITMODE_BITMODE_Msk = 0x3
	// 16 bit timer bit width
	TIMER_BITMODE_BITMODE_16Bit = 0x0
	// 8 bit timer bit width
	TIMER_BITMODE_BITMODE_08Bit = 0x1
	// 24 bit timer bit width
	TIMER_BITMODE_BITMODE_24Bit = 0x2
	// 32 bit timer bit width
	TIMER_BITMODE_BITMODE_32Bit = 0x3

	// PRESCALER: Timer prescaler register
	// Position of PRESCALER field.
	TIMER_PRESCALER_PRESCALER_Pos = 0x0
	// Bit mask of PRESCALER field.
	TIMER_PRESCALER_PRESCALER_Msk = 0xf

	// CC: Description collection: Capture/Compare register n
	// Position of CC field.
	TIMER_CC_CC_Pos = 0x0
	// Bit mask of CC field.
	TIMER_CC_CC_Msk = 0xffffffff

	// ONESHOTEN: Description collection: Enable one-shot operation for Capture/Compare channel n
	// Position of ONESHOTEN field.
	TIMER_ONESHOTEN_ONESHOTEN_Pos = 0x0
	// Bit mask of ONESHOTEN field.
	TIMER_ONESHOTEN_ONESHOTEN_Msk = 0x1
	// Bit ONESHOTEN.
	TIMER_ONESHOTEN_ONESHOTEN = 0x1
	// Disable one-shot operation
	TIMER_ONESHOTEN_ONESHOTEN_Disable = 0x0
	// Enable one-shot operation
	TIMER_ONESHOTEN_ONESHOTEN_Enable = 0x1
)

// Bitfields for ECB_NS: AES ECB Mode Encryption
const (
	// TASKS_STARTECB: Start ECB block encrypt
	// Position of TASKS_STARTECB field.
	ECB_TASKS_STARTECB_TASKS_STARTECB_Pos = 0x0
	// Bit mask of TASKS_STARTECB field.
	ECB_TASKS_STARTECB_TASKS_STARTECB_Msk = 0x1
	// Bit TASKS_STARTECB.
	ECB_TASKS_STARTECB_TASKS_STARTECB = 0x1
	// Trigger task
	ECB_TASKS_STARTECB_TASKS_STARTECB_Trigger = 0x1

	// TASKS_STOPECB: Abort a possible executing ECB operation
	// Position of TASKS_STOPECB field.
	ECB_TASKS_STOPECB_TASKS_STOPECB_Pos = 0x0
	// Bit mask of TASKS_STOPECB field.
	ECB_TASKS_STOPECB_TASKS_STOPECB_Msk = 0x1
	// Bit TASKS_STOPECB.
	ECB_TASKS_STOPECB_TASKS_STOPECB = 0x1
	// Trigger task
	ECB_TASKS_STOPECB_TASKS_STOPECB_Trigger = 0x1

	// SUBSCRIBE_STARTECB: Subscribe configuration for task STARTECB
	// Position of CHIDX field.
	ECB_SUBSCRIBE_STARTECB_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	ECB_SUBSCRIBE_STARTECB_CHIDX_Msk = 0xff
	// Position of EN field.
	ECB_SUBSCRIBE_STARTECB_EN_Pos = 0x1f
	// Bit mask of EN field.
	ECB_SUBSCRIBE_STARTECB_EN_Msk = 0x80000000
	// Bit EN.
	ECB_SUBSCRIBE_STARTECB_EN = 0x80000000
	// Disable subscription
	ECB_SUBSCRIBE_STARTECB_EN_Disabled = 0x0
	// Enable subscription
	ECB_SUBSCRIBE_STARTECB_EN_Enabled = 0x1

	// SUBSCRIBE_STOPECB: Subscribe configuration for task STOPECB
	// Position of CHIDX field.
	ECB_SUBSCRIBE_STOPECB_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	ECB_SUBSCRIBE_STOPECB_CHIDX_Msk = 0xff
	// Position of EN field.
	ECB_SUBSCRIBE_STOPECB_EN_Pos = 0x1f
	// Bit mask of EN field.
	ECB_SUBSCRIBE_STOPECB_EN_Msk = 0x80000000
	// Bit EN.
	ECB_SUBSCRIBE_STOPECB_EN = 0x80000000
	// Disable subscription
	ECB_SUBSCRIBE_STOPECB_EN_Disabled = 0x0
	// Enable subscription
	ECB_SUBSCRIBE_STOPECB_EN_Enabled = 0x1

	// EVENTS_ENDECB: ECB block encrypt complete
	// Position of EVENTS_ENDECB field.
	ECB_EVENTS_ENDECB_EVENTS_ENDECB_Pos = 0x0
	// Bit mask of EVENTS_ENDECB field.
	ECB_EVENTS_ENDECB_EVENTS_ENDECB_Msk = 0x1
	// Bit EVENTS_ENDECB.
	ECB_EVENTS_ENDECB_EVENTS_ENDECB = 0x1
	// Event not generated
	ECB_EVENTS_ENDECB_EVENTS_ENDECB_NotGenerated = 0x0
	// Event generated
	ECB_EVENTS_ENDECB_EVENTS_ENDECB_Generated = 0x1

	// EVENTS_ERRORECB: ECB block encrypt aborted because of a STOPECB task or due to an error
	// Position of EVENTS_ERRORECB field.
	ECB_EVENTS_ERRORECB_EVENTS_ERRORECB_Pos = 0x0
	// Bit mask of EVENTS_ERRORECB field.
	ECB_EVENTS_ERRORECB_EVENTS_ERRORECB_Msk = 0x1
	// Bit EVENTS_ERRORECB.
	ECB_EVENTS_ERRORECB_EVENTS_ERRORECB = 0x1
	// Event not generated
	ECB_EVENTS_ERRORECB_EVENTS_ERRORECB_NotGenerated = 0x0
	// Event generated
	ECB_EVENTS_ERRORECB_EVENTS_ERRORECB_Generated = 0x1

	// PUBLISH_ENDECB: Publish configuration for event ENDECB
	// Position of CHIDX field.
	ECB_PUBLISH_ENDECB_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	ECB_PUBLISH_ENDECB_CHIDX_Msk = 0xff
	// Position of EN field.
	ECB_PUBLISH_ENDECB_EN_Pos = 0x1f
	// Bit mask of EN field.
	ECB_PUBLISH_ENDECB_EN_Msk = 0x80000000
	// Bit EN.
	ECB_PUBLISH_ENDECB_EN = 0x80000000
	// Disable publishing
	ECB_PUBLISH_ENDECB_EN_Disabled = 0x0
	// Enable publishing
	ECB_PUBLISH_ENDECB_EN_Enabled = 0x1

	// PUBLISH_ERRORECB: Publish configuration for event ERRORECB
	// Position of CHIDX field.
	ECB_PUBLISH_ERRORECB_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	ECB_PUBLISH_ERRORECB_CHIDX_Msk = 0xff
	// Position of EN field.
	ECB_PUBLISH_ERRORECB_EN_Pos = 0x1f
	// Bit mask of EN field.
	ECB_PUBLISH_ERRORECB_EN_Msk = 0x80000000
	// Bit EN.
	ECB_PUBLISH_ERRORECB_EN = 0x80000000
	// Disable publishing
	ECB_PUBLISH_ERRORECB_EN_Disabled = 0x0
	// Enable publishing
	ECB_PUBLISH_ERRORECB_EN_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of ENDECB field.
	ECB_INTENSET_ENDECB_Pos = 0x0
	// Bit mask of ENDECB field.
	ECB_INTENSET_ENDECB_Msk = 0x1
	// Bit ENDECB.
	ECB_INTENSET_ENDECB = 0x1
	// Read: Disabled
	ECB_INTENSET_ENDECB_Disabled = 0x0
	// Read: Enabled
	ECB_INTENSET_ENDECB_Enabled = 0x1
	// Enable
	ECB_INTENSET_ENDECB_Set = 0x1
	// Position of ERRORECB field.
	ECB_INTENSET_ERRORECB_Pos = 0x1
	// Bit mask of ERRORECB field.
	ECB_INTENSET_ERRORECB_Msk = 0x2
	// Bit ERRORECB.
	ECB_INTENSET_ERRORECB = 0x2
	// Read: Disabled
	ECB_INTENSET_ERRORECB_Disabled = 0x0
	// Read: Enabled
	ECB_INTENSET_ERRORECB_Enabled = 0x1
	// Enable
	ECB_INTENSET_ERRORECB_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of ENDECB field.
	ECB_INTENCLR_ENDECB_Pos = 0x0
	// Bit mask of ENDECB field.
	ECB_INTENCLR_ENDECB_Msk = 0x1
	// Bit ENDECB.
	ECB_INTENCLR_ENDECB = 0x1
	// Read: Disabled
	ECB_INTENCLR_ENDECB_Disabled = 0x0
	// Read: Enabled
	ECB_INTENCLR_ENDECB_Enabled = 0x1
	// Disable
	ECB_INTENCLR_ENDECB_Clear = 0x1
	// Position of ERRORECB field.
	ECB_INTENCLR_ERRORECB_Pos = 0x1
	// Bit mask of ERRORECB field.
	ECB_INTENCLR_ERRORECB_Msk = 0x2
	// Bit ERRORECB.
	ECB_INTENCLR_ERRORECB = 0x2
	// Read: Disabled
	ECB_INTENCLR_ERRORECB_Disabled = 0x0
	// Read: Enabled
	ECB_INTENCLR_ERRORECB_Enabled = 0x1
	// Disable
	ECB_INTENCLR_ERRORECB_Clear = 0x1

	// ECBDATAPTR: ECB block encrypt memory pointers
	// Position of ECBDATAPTR field.
	ECB_ECBDATAPTR_ECBDATAPTR_Pos = 0x0
	// Bit mask of ECBDATAPTR field.
	ECB_ECBDATAPTR_ECBDATAPTR_Msk = 0xffffffff
)

// Bitfields for AAR_NS: Accelerated Address Resolver
const (
	// TASKS_START: Start resolving addresses based on IRKs specified in the IRK data structure
	// Position of TASKS_START field.
	AAR_TASKS_START_TASKS_START_Pos = 0x0
	// Bit mask of TASKS_START field.
	AAR_TASKS_START_TASKS_START_Msk = 0x1
	// Bit TASKS_START.
	AAR_TASKS_START_TASKS_START = 0x1
	// Trigger task
	AAR_TASKS_START_TASKS_START_Trigger = 0x1

	// TASKS_STOP: Stop resolving addresses
	// Position of TASKS_STOP field.
	AAR_TASKS_STOP_TASKS_STOP_Pos = 0x0
	// Bit mask of TASKS_STOP field.
	AAR_TASKS_STOP_TASKS_STOP_Msk = 0x1
	// Bit TASKS_STOP.
	AAR_TASKS_STOP_TASKS_STOP = 0x1
	// Trigger task
	AAR_TASKS_STOP_TASKS_STOP_Trigger = 0x1

	// SUBSCRIBE_START: Subscribe configuration for task START
	// Position of CHIDX field.
	AAR_SUBSCRIBE_START_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	AAR_SUBSCRIBE_START_CHIDX_Msk = 0xff
	// Position of EN field.
	AAR_SUBSCRIBE_START_EN_Pos = 0x1f
	// Bit mask of EN field.
	AAR_SUBSCRIBE_START_EN_Msk = 0x80000000
	// Bit EN.
	AAR_SUBSCRIBE_START_EN = 0x80000000
	// Disable subscription
	AAR_SUBSCRIBE_START_EN_Disabled = 0x0
	// Enable subscription
	AAR_SUBSCRIBE_START_EN_Enabled = 0x1

	// SUBSCRIBE_STOP: Subscribe configuration for task STOP
	// Position of CHIDX field.
	AAR_SUBSCRIBE_STOP_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	AAR_SUBSCRIBE_STOP_CHIDX_Msk = 0xff
	// Position of EN field.
	AAR_SUBSCRIBE_STOP_EN_Pos = 0x1f
	// Bit mask of EN field.
	AAR_SUBSCRIBE_STOP_EN_Msk = 0x80000000
	// Bit EN.
	AAR_SUBSCRIBE_STOP_EN = 0x80000000
	// Disable subscription
	AAR_SUBSCRIBE_STOP_EN_Disabled = 0x0
	// Enable subscription
	AAR_SUBSCRIBE_STOP_EN_Enabled = 0x1

	// EVENTS_END: Address resolution procedure complete
	// Position of EVENTS_END field.
	AAR_EVENTS_END_EVENTS_END_Pos = 0x0
	// Bit mask of EVENTS_END field.
	AAR_EVENTS_END_EVENTS_END_Msk = 0x1
	// Bit EVENTS_END.
	AAR_EVENTS_END_EVENTS_END = 0x1
	// Event not generated
	AAR_EVENTS_END_EVENTS_END_NotGenerated = 0x0
	// Event generated
	AAR_EVENTS_END_EVENTS_END_Generated = 0x1

	// EVENTS_RESOLVED: Address resolved
	// Position of EVENTS_RESOLVED field.
	AAR_EVENTS_RESOLVED_EVENTS_RESOLVED_Pos = 0x0
	// Bit mask of EVENTS_RESOLVED field.
	AAR_EVENTS_RESOLVED_EVENTS_RESOLVED_Msk = 0x1
	// Bit EVENTS_RESOLVED.
	AAR_EVENTS_RESOLVED_EVENTS_RESOLVED = 0x1
	// Event not generated
	AAR_EVENTS_RESOLVED_EVENTS_RESOLVED_NotGenerated = 0x0
	// Event generated
	AAR_EVENTS_RESOLVED_EVENTS_RESOLVED_Generated = 0x1

	// EVENTS_NOTRESOLVED: Address not resolved
	// Position of EVENTS_NOTRESOLVED field.
	AAR_EVENTS_NOTRESOLVED_EVENTS_NOTRESOLVED_Pos = 0x0
	// Bit mask of EVENTS_NOTRESOLVED field.
	AAR_EVENTS_NOTRESOLVED_EVENTS_NOTRESOLVED_Msk = 0x1
	// Bit EVENTS_NOTRESOLVED.
	AAR_EVENTS_NOTRESOLVED_EVENTS_NOTRESOLVED = 0x1
	// Event not generated
	AAR_EVENTS_NOTRESOLVED_EVENTS_NOTRESOLVED_NotGenerated = 0x0
	// Event generated
	AAR_EVENTS_NOTRESOLVED_EVENTS_NOTRESOLVED_Generated = 0x1

	// PUBLISH_END: Publish configuration for event END
	// Position of CHIDX field.
	AAR_PUBLISH_END_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	AAR_PUBLISH_END_CHIDX_Msk = 0xff
	// Position of EN field.
	AAR_PUBLISH_END_EN_Pos = 0x1f
	// Bit mask of EN field.
	AAR_PUBLISH_END_EN_Msk = 0x80000000
	// Bit EN.
	AAR_PUBLISH_END_EN = 0x80000000
	// Disable publishing
	AAR_PUBLISH_END_EN_Disabled = 0x0
	// Enable publishing
	AAR_PUBLISH_END_EN_Enabled = 0x1

	// PUBLISH_RESOLVED: Publish configuration for event RESOLVED
	// Position of CHIDX field.
	AAR_PUBLISH_RESOLVED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	AAR_PUBLISH_RESOLVED_CHIDX_Msk = 0xff
	// Position of EN field.
	AAR_PUBLISH_RESOLVED_EN_Pos = 0x1f
	// Bit mask of EN field.
	AAR_PUBLISH_RESOLVED_EN_Msk = 0x80000000
	// Bit EN.
	AAR_PUBLISH_RESOLVED_EN = 0x80000000
	// Disable publishing
	AAR_PUBLISH_RESOLVED_EN_Disabled = 0x0
	// Enable publishing
	AAR_PUBLISH_RESOLVED_EN_Enabled = 0x1

	// PUBLISH_NOTRESOLVED: Publish configuration for event NOTRESOLVED
	// Position of CHIDX field.
	AAR_PUBLISH_NOTRESOLVED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	AAR_PUBLISH_NOTRESOLVED_CHIDX_Msk = 0xff
	// Position of EN field.
	AAR_PUBLISH_NOTRESOLVED_EN_Pos = 0x1f
	// Bit mask of EN field.
	AAR_PUBLISH_NOTRESOLVED_EN_Msk = 0x80000000
	// Bit EN.
	AAR_PUBLISH_NOTRESOLVED_EN = 0x80000000
	// Disable publishing
	AAR_PUBLISH_NOTRESOLVED_EN_Disabled = 0x0
	// Enable publishing
	AAR_PUBLISH_NOTRESOLVED_EN_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of END field.
	AAR_INTENSET_END_Pos = 0x0
	// Bit mask of END field.
	AAR_INTENSET_END_Msk = 0x1
	// Bit END.
	AAR_INTENSET_END = 0x1
	// Read: Disabled
	AAR_INTENSET_END_Disabled = 0x0
	// Read: Enabled
	AAR_INTENSET_END_Enabled = 0x1
	// Enable
	AAR_INTENSET_END_Set = 0x1
	// Position of RESOLVED field.
	AAR_INTENSET_RESOLVED_Pos = 0x1
	// Bit mask of RESOLVED field.
	AAR_INTENSET_RESOLVED_Msk = 0x2
	// Bit RESOLVED.
	AAR_INTENSET_RESOLVED = 0x2
	// Read: Disabled
	AAR_INTENSET_RESOLVED_Disabled = 0x0
	// Read: Enabled
	AAR_INTENSET_RESOLVED_Enabled = 0x1
	// Enable
	AAR_INTENSET_RESOLVED_Set = 0x1
	// Position of NOTRESOLVED field.
	AAR_INTENSET_NOTRESOLVED_Pos = 0x2
	// Bit mask of NOTRESOLVED field.
	AAR_INTENSET_NOTRESOLVED_Msk = 0x4
	// Bit NOTRESOLVED.
	AAR_INTENSET_NOTRESOLVED = 0x4
	// Read: Disabled
	AAR_INTENSET_NOTRESOLVED_Disabled = 0x0
	// Read: Enabled
	AAR_INTENSET_NOTRESOLVED_Enabled = 0x1
	// Enable
	AAR_INTENSET_NOTRESOLVED_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of END field.
	AAR_INTENCLR_END_Pos = 0x0
	// Bit mask of END field.
	AAR_INTENCLR_END_Msk = 0x1
	// Bit END.
	AAR_INTENCLR_END = 0x1
	// Read: Disabled
	AAR_INTENCLR_END_Disabled = 0x0
	// Read: Enabled
	AAR_INTENCLR_END_Enabled = 0x1
	// Disable
	AAR_INTENCLR_END_Clear = 0x1
	// Position of RESOLVED field.
	AAR_INTENCLR_RESOLVED_Pos = 0x1
	// Bit mask of RESOLVED field.
	AAR_INTENCLR_RESOLVED_Msk = 0x2
	// Bit RESOLVED.
	AAR_INTENCLR_RESOLVED = 0x2
	// Read: Disabled
	AAR_INTENCLR_RESOLVED_Disabled = 0x0
	// Read: Enabled
	AAR_INTENCLR_RESOLVED_Enabled = 0x1
	// Disable
	AAR_INTENCLR_RESOLVED_Clear = 0x1
	// Position of NOTRESOLVED field.
	AAR_INTENCLR_NOTRESOLVED_Pos = 0x2
	// Bit mask of NOTRESOLVED field.
	AAR_INTENCLR_NOTRESOLVED_Msk = 0x4
	// Bit NOTRESOLVED.
	AAR_INTENCLR_NOTRESOLVED = 0x4
	// Read: Disabled
	AAR_INTENCLR_NOTRESOLVED_Disabled = 0x0
	// Read: Enabled
	AAR_INTENCLR_NOTRESOLVED_Enabled = 0x1
	// Disable
	AAR_INTENCLR_NOTRESOLVED_Clear = 0x1

	// STATUS: Resolution status
	// Position of STATUS field.
	AAR_STATUS_STATUS_Pos = 0x0
	// Bit mask of STATUS field.
	AAR_STATUS_STATUS_Msk = 0xf

	// ENABLE: Enable AAR
	// Position of ENABLE field.
	AAR_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	AAR_ENABLE_ENABLE_Msk = 0x3
	// Disable
	AAR_ENABLE_ENABLE_Disabled = 0x0
	// Enable
	AAR_ENABLE_ENABLE_Enabled = 0x3

	// NIRK: Number of IRKs
	// Position of NIRK field.
	AAR_NIRK_NIRK_Pos = 0x0
	// Bit mask of NIRK field.
	AAR_NIRK_NIRK_Msk = 0x1f

	// IRKPTR: Pointer to IRK data structure
	// Position of IRKPTR field.
	AAR_IRKPTR_IRKPTR_Pos = 0x0
	// Bit mask of IRKPTR field.
	AAR_IRKPTR_IRKPTR_Msk = 0xffffffff

	// ADDRPTR: Pointer to the resolvable address
	// Position of ADDRPTR field.
	AAR_ADDRPTR_ADDRPTR_Pos = 0x0
	// Bit mask of ADDRPTR field.
	AAR_ADDRPTR_ADDRPTR_Msk = 0xffffffff

	// SCRATCHPTR: Pointer to data area used for temporary storage
	// Position of SCRATCHPTR field.
	AAR_SCRATCHPTR_SCRATCHPTR_Pos = 0x0
	// Bit mask of SCRATCHPTR field.
	AAR_SCRATCHPTR_SCRATCHPTR_Msk = 0xffffffff
)

// Bitfields for CCM_NS: AES CCM mode encryption
const (
	// TASKS_KSGEN: Start generation of keystream. This operation will stop by itself when completed.
	// Position of TASKS_KSGEN field.
	CCM_TASKS_KSGEN_TASKS_KSGEN_Pos = 0x0
	// Bit mask of TASKS_KSGEN field.
	CCM_TASKS_KSGEN_TASKS_KSGEN_Msk = 0x1
	// Bit TASKS_KSGEN.
	CCM_TASKS_KSGEN_TASKS_KSGEN = 0x1
	// Trigger task
	CCM_TASKS_KSGEN_TASKS_KSGEN_Trigger = 0x1

	// TASKS_CRYPT: Start encryption/decryption. This operation will stop by itself when completed.
	// Position of TASKS_CRYPT field.
	CCM_TASKS_CRYPT_TASKS_CRYPT_Pos = 0x0
	// Bit mask of TASKS_CRYPT field.
	CCM_TASKS_CRYPT_TASKS_CRYPT_Msk = 0x1
	// Bit TASKS_CRYPT.
	CCM_TASKS_CRYPT_TASKS_CRYPT = 0x1
	// Trigger task
	CCM_TASKS_CRYPT_TASKS_CRYPT_Trigger = 0x1

	// TASKS_STOP: Stop encryption/decryption
	// Position of TASKS_STOP field.
	CCM_TASKS_STOP_TASKS_STOP_Pos = 0x0
	// Bit mask of TASKS_STOP field.
	CCM_TASKS_STOP_TASKS_STOP_Msk = 0x1
	// Bit TASKS_STOP.
	CCM_TASKS_STOP_TASKS_STOP = 0x1
	// Trigger task
	CCM_TASKS_STOP_TASKS_STOP_Trigger = 0x1

	// TASKS_RATEOVERRIDE: Override DATARATE setting in MODE register with the contents of the RATEOVERRIDE register for any ongoing encryption/decryption
	// Position of TASKS_RATEOVERRIDE field.
	CCM_TASKS_RATEOVERRIDE_TASKS_RATEOVERRIDE_Pos = 0x0
	// Bit mask of TASKS_RATEOVERRIDE field.
	CCM_TASKS_RATEOVERRIDE_TASKS_RATEOVERRIDE_Msk = 0x1
	// Bit TASKS_RATEOVERRIDE.
	CCM_TASKS_RATEOVERRIDE_TASKS_RATEOVERRIDE = 0x1
	// Trigger task
	CCM_TASKS_RATEOVERRIDE_TASKS_RATEOVERRIDE_Trigger = 0x1

	// SUBSCRIBE_KSGEN: Subscribe configuration for task KSGEN
	// Position of CHIDX field.
	CCM_SUBSCRIBE_KSGEN_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	CCM_SUBSCRIBE_KSGEN_CHIDX_Msk = 0xff
	// Position of EN field.
	CCM_SUBSCRIBE_KSGEN_EN_Pos = 0x1f
	// Bit mask of EN field.
	CCM_SUBSCRIBE_KSGEN_EN_Msk = 0x80000000
	// Bit EN.
	CCM_SUBSCRIBE_KSGEN_EN = 0x80000000
	// Disable subscription
	CCM_SUBSCRIBE_KSGEN_EN_Disabled = 0x0
	// Enable subscription
	CCM_SUBSCRIBE_KSGEN_EN_Enabled = 0x1

	// SUBSCRIBE_CRYPT: Subscribe configuration for task CRYPT
	// Position of CHIDX field.
	CCM_SUBSCRIBE_CRYPT_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	CCM_SUBSCRIBE_CRYPT_CHIDX_Msk = 0xff
	// Position of EN field.
	CCM_SUBSCRIBE_CRYPT_EN_Pos = 0x1f
	// Bit mask of EN field.
	CCM_SUBSCRIBE_CRYPT_EN_Msk = 0x80000000
	// Bit EN.
	CCM_SUBSCRIBE_CRYPT_EN = 0x80000000
	// Disable subscription
	CCM_SUBSCRIBE_CRYPT_EN_Disabled = 0x0
	// Enable subscription
	CCM_SUBSCRIBE_CRYPT_EN_Enabled = 0x1

	// SUBSCRIBE_STOP: Subscribe configuration for task STOP
	// Position of CHIDX field.
	CCM_SUBSCRIBE_STOP_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	CCM_SUBSCRIBE_STOP_CHIDX_Msk = 0xff
	// Position of EN field.
	CCM_SUBSCRIBE_STOP_EN_Pos = 0x1f
	// Bit mask of EN field.
	CCM_SUBSCRIBE_STOP_EN_Msk = 0x80000000
	// Bit EN.
	CCM_SUBSCRIBE_STOP_EN = 0x80000000
	// Disable subscription
	CCM_SUBSCRIBE_STOP_EN_Disabled = 0x0
	// Enable subscription
	CCM_SUBSCRIBE_STOP_EN_Enabled = 0x1

	// SUBSCRIBE_RATEOVERRIDE: Subscribe configuration for task RATEOVERRIDE
	// Position of CHIDX field.
	CCM_SUBSCRIBE_RATEOVERRIDE_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	CCM_SUBSCRIBE_RATEOVERRIDE_CHIDX_Msk = 0xff
	// Position of EN field.
	CCM_SUBSCRIBE_RATEOVERRIDE_EN_Pos = 0x1f
	// Bit mask of EN field.
	CCM_SUBSCRIBE_RATEOVERRIDE_EN_Msk = 0x80000000
	// Bit EN.
	CCM_SUBSCRIBE_RATEOVERRIDE_EN = 0x80000000
	// Disable subscription
	CCM_SUBSCRIBE_RATEOVERRIDE_EN_Disabled = 0x0
	// Enable subscription
	CCM_SUBSCRIBE_RATEOVERRIDE_EN_Enabled = 0x1

	// EVENTS_ENDKSGEN: Keystream generation complete
	// Position of EVENTS_ENDKSGEN field.
	CCM_EVENTS_ENDKSGEN_EVENTS_ENDKSGEN_Pos = 0x0
	// Bit mask of EVENTS_ENDKSGEN field.
	CCM_EVENTS_ENDKSGEN_EVENTS_ENDKSGEN_Msk = 0x1
	// Bit EVENTS_ENDKSGEN.
	CCM_EVENTS_ENDKSGEN_EVENTS_ENDKSGEN = 0x1
	// Event not generated
	CCM_EVENTS_ENDKSGEN_EVENTS_ENDKSGEN_NotGenerated = 0x0
	// Event generated
	CCM_EVENTS_ENDKSGEN_EVENTS_ENDKSGEN_Generated = 0x1

	// EVENTS_ENDCRYPT: Encrypt/decrypt complete
	// Position of EVENTS_ENDCRYPT field.
	CCM_EVENTS_ENDCRYPT_EVENTS_ENDCRYPT_Pos = 0x0
	// Bit mask of EVENTS_ENDCRYPT field.
	CCM_EVENTS_ENDCRYPT_EVENTS_ENDCRYPT_Msk = 0x1
	// Bit EVENTS_ENDCRYPT.
	CCM_EVENTS_ENDCRYPT_EVENTS_ENDCRYPT = 0x1
	// Event not generated
	CCM_EVENTS_ENDCRYPT_EVENTS_ENDCRYPT_NotGenerated = 0x0
	// Event generated
	CCM_EVENTS_ENDCRYPT_EVENTS_ENDCRYPT_Generated = 0x1

	// EVENTS_ERROR: Deprecated register - CCM error event
	// Position of EVENTS_ERROR field.
	CCM_EVENTS_ERROR_EVENTS_ERROR_Pos = 0x0
	// Bit mask of EVENTS_ERROR field.
	CCM_EVENTS_ERROR_EVENTS_ERROR_Msk = 0x1
	// Bit EVENTS_ERROR.
	CCM_EVENTS_ERROR_EVENTS_ERROR = 0x1
	// Event not generated
	CCM_EVENTS_ERROR_EVENTS_ERROR_NotGenerated = 0x0
	// Event generated
	CCM_EVENTS_ERROR_EVENTS_ERROR_Generated = 0x1

	// PUBLISH_ENDKSGEN: Publish configuration for event ENDKSGEN
	// Position of CHIDX field.
	CCM_PUBLISH_ENDKSGEN_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	CCM_PUBLISH_ENDKSGEN_CHIDX_Msk = 0xff
	// Position of EN field.
	CCM_PUBLISH_ENDKSGEN_EN_Pos = 0x1f
	// Bit mask of EN field.
	CCM_PUBLISH_ENDKSGEN_EN_Msk = 0x80000000
	// Bit EN.
	CCM_PUBLISH_ENDKSGEN_EN = 0x80000000
	// Disable publishing
	CCM_PUBLISH_ENDKSGEN_EN_Disabled = 0x0
	// Enable publishing
	CCM_PUBLISH_ENDKSGEN_EN_Enabled = 0x1

	// PUBLISH_ENDCRYPT: Publish configuration for event ENDCRYPT
	// Position of CHIDX field.
	CCM_PUBLISH_ENDCRYPT_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	CCM_PUBLISH_ENDCRYPT_CHIDX_Msk = 0xff
	// Position of EN field.
	CCM_PUBLISH_ENDCRYPT_EN_Pos = 0x1f
	// Bit mask of EN field.
	CCM_PUBLISH_ENDCRYPT_EN_Msk = 0x80000000
	// Bit EN.
	CCM_PUBLISH_ENDCRYPT_EN = 0x80000000
	// Disable publishing
	CCM_PUBLISH_ENDCRYPT_EN_Disabled = 0x0
	// Enable publishing
	CCM_PUBLISH_ENDCRYPT_EN_Enabled = 0x1

	// PUBLISH_ERROR: Deprecated register - Publish configuration for event ERROR
	// Position of CHIDX field.
	CCM_PUBLISH_ERROR_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	CCM_PUBLISH_ERROR_CHIDX_Msk = 0xff
	// Position of EN field.
	CCM_PUBLISH_ERROR_EN_Pos = 0x1f
	// Bit mask of EN field.
	CCM_PUBLISH_ERROR_EN_Msk = 0x80000000
	// Bit EN.
	CCM_PUBLISH_ERROR_EN = 0x80000000
	// Disable publishing
	CCM_PUBLISH_ERROR_EN_Disabled = 0x0
	// Enable publishing
	CCM_PUBLISH_ERROR_EN_Enabled = 0x1

	// SHORTS: Shortcuts between local events and tasks
	// Position of ENDKSGEN_CRYPT field.
	CCM_SHORTS_ENDKSGEN_CRYPT_Pos = 0x0
	// Bit mask of ENDKSGEN_CRYPT field.
	CCM_SHORTS_ENDKSGEN_CRYPT_Msk = 0x1
	// Bit ENDKSGEN_CRYPT.
	CCM_SHORTS_ENDKSGEN_CRYPT = 0x1
	// Disable shortcut
	CCM_SHORTS_ENDKSGEN_CRYPT_Disabled = 0x0
	// Enable shortcut
	CCM_SHORTS_ENDKSGEN_CRYPT_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of ENDKSGEN field.
	CCM_INTENSET_ENDKSGEN_Pos = 0x0
	// Bit mask of ENDKSGEN field.
	CCM_INTENSET_ENDKSGEN_Msk = 0x1
	// Bit ENDKSGEN.
	CCM_INTENSET_ENDKSGEN = 0x1
	// Read: Disabled
	CCM_INTENSET_ENDKSGEN_Disabled = 0x0
	// Read: Enabled
	CCM_INTENSET_ENDKSGEN_Enabled = 0x1
	// Enable
	CCM_INTENSET_ENDKSGEN_Set = 0x1
	// Position of ENDCRYPT field.
	CCM_INTENSET_ENDCRYPT_Pos = 0x1
	// Bit mask of ENDCRYPT field.
	CCM_INTENSET_ENDCRYPT_Msk = 0x2
	// Bit ENDCRYPT.
	CCM_INTENSET_ENDCRYPT = 0x2
	// Read: Disabled
	CCM_INTENSET_ENDCRYPT_Disabled = 0x0
	// Read: Enabled
	CCM_INTENSET_ENDCRYPT_Enabled = 0x1
	// Enable
	CCM_INTENSET_ENDCRYPT_Set = 0x1
	// Position of ERROR field.
	CCM_INTENSET_ERROR_Pos = 0x2
	// Bit mask of ERROR field.
	CCM_INTENSET_ERROR_Msk = 0x4
	// Bit ERROR.
	CCM_INTENSET_ERROR = 0x4
	// Read: Disabled
	CCM_INTENSET_ERROR_Disabled = 0x0
	// Read: Enabled
	CCM_INTENSET_ERROR_Enabled = 0x1
	// Enable
	CCM_INTENSET_ERROR_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of ENDKSGEN field.
	CCM_INTENCLR_ENDKSGEN_Pos = 0x0
	// Bit mask of ENDKSGEN field.
	CCM_INTENCLR_ENDKSGEN_Msk = 0x1
	// Bit ENDKSGEN.
	CCM_INTENCLR_ENDKSGEN = 0x1
	// Read: Disabled
	CCM_INTENCLR_ENDKSGEN_Disabled = 0x0
	// Read: Enabled
	CCM_INTENCLR_ENDKSGEN_Enabled = 0x1
	// Disable
	CCM_INTENCLR_ENDKSGEN_Clear = 0x1
	// Position of ENDCRYPT field.
	CCM_INTENCLR_ENDCRYPT_Pos = 0x1
	// Bit mask of ENDCRYPT field.
	CCM_INTENCLR_ENDCRYPT_Msk = 0x2
	// Bit ENDCRYPT.
	CCM_INTENCLR_ENDCRYPT = 0x2
	// Read: Disabled
	CCM_INTENCLR_ENDCRYPT_Disabled = 0x0
	// Read: Enabled
	CCM_INTENCLR_ENDCRYPT_Enabled = 0x1
	// Disable
	CCM_INTENCLR_ENDCRYPT_Clear = 0x1
	// Position of ERROR field.
	CCM_INTENCLR_ERROR_Pos = 0x2
	// Bit mask of ERROR field.
	CCM_INTENCLR_ERROR_Msk = 0x4
	// Bit ERROR.
	CCM_INTENCLR_ERROR = 0x4
	// Read: Disabled
	CCM_INTENCLR_ERROR_Disabled = 0x0
	// Read: Enabled
	CCM_INTENCLR_ERROR_Enabled = 0x1
	// Disable
	CCM_INTENCLR_ERROR_Clear = 0x1

	// MICSTATUS: MIC check result
	// Position of MICSTATUS field.
	CCM_MICSTATUS_MICSTATUS_Pos = 0x0
	// Bit mask of MICSTATUS field.
	CCM_MICSTATUS_MICSTATUS_Msk = 0x1
	// Bit MICSTATUS.
	CCM_MICSTATUS_MICSTATUS = 0x1
	// MIC check failed
	CCM_MICSTATUS_MICSTATUS_CheckFailed = 0x0
	// MIC check passed
	CCM_MICSTATUS_MICSTATUS_CheckPassed = 0x1

	// ENABLE: Enable
	// Position of ENABLE field.
	CCM_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	CCM_ENABLE_ENABLE_Msk = 0x3
	// Disable
	CCM_ENABLE_ENABLE_Disabled = 0x0
	// Enable
	CCM_ENABLE_ENABLE_Enabled = 0x2

	// MODE: Operation mode
	// Position of MODE field.
	CCM_MODE_MODE_Pos = 0x0
	// Bit mask of MODE field.
	CCM_MODE_MODE_Msk = 0x1
	// Bit MODE.
	CCM_MODE_MODE = 0x1
	// AES CCM packet encryption mode
	CCM_MODE_MODE_Encryption = 0x0
	// AES CCM packet decryption mode
	CCM_MODE_MODE_Decryption = 0x1
	// Position of DATARATE field.
	CCM_MODE_DATARATE_Pos = 0x10
	// Bit mask of DATARATE field.
	CCM_MODE_DATARATE_Msk = 0x30000
	// 1 Mbps
	CCM_MODE_DATARATE_1Mbit = 0x0
	// 2 Mbps
	CCM_MODE_DATARATE_2Mbit = 0x1
	// 125 Kbps
	CCM_MODE_DATARATE_125Kbps = 0x2
	// 500 Kbps
	CCM_MODE_DATARATE_500Kbps = 0x3
	// Position of LENGTH field.
	CCM_MODE_LENGTH_Pos = 0x18
	// Bit mask of LENGTH field.
	CCM_MODE_LENGTH_Msk = 0x1000000
	// Bit LENGTH.
	CCM_MODE_LENGTH = 0x1000000
	// Default length. Effective length of LENGTH field in encrypted/decrypted packet is 5 bits. A keystream for packet payloads up to 27 bytes will be generated.
	CCM_MODE_LENGTH_Default = 0x0
	// Extended length. Effective length of LENGTH field in encrypted/decrypted packet is 8 bits. A keystream for packet payloads up to MAXPACKETSIZE bytes will be generated.
	CCM_MODE_LENGTH_Extended = 0x1

	// CNFPTR: Pointer to data structure holding the AES key and the NONCE vector
	// Position of CNFPTR field.
	CCM_CNFPTR_CNFPTR_Pos = 0x0
	// Bit mask of CNFPTR field.
	CCM_CNFPTR_CNFPTR_Msk = 0xffffffff

	// INPTR: Input pointer
	// Position of INPTR field.
	CCM_INPTR_INPTR_Pos = 0x0
	// Bit mask of INPTR field.
	CCM_INPTR_INPTR_Msk = 0xffffffff

	// OUTPTR: Output pointer
	// Position of OUTPTR field.
	CCM_OUTPTR_OUTPTR_Pos = 0x0
	// Bit mask of OUTPTR field.
	CCM_OUTPTR_OUTPTR_Msk = 0xffffffff

	// SCRATCHPTR: Pointer to data area used for temporary storage
	// Position of SCRATCHPTR field.
	CCM_SCRATCHPTR_SCRATCHPTR_Pos = 0x0
	// Bit mask of SCRATCHPTR field.
	CCM_SCRATCHPTR_SCRATCHPTR_Msk = 0xffffffff

	// MAXPACKETSIZE: Length of keystream generated when MODE.LENGTH = Extended
	// Position of MAXPACKETSIZE field.
	CCM_MAXPACKETSIZE_MAXPACKETSIZE_Pos = 0x0
	// Bit mask of MAXPACKETSIZE field.
	CCM_MAXPACKETSIZE_MAXPACKETSIZE_Msk = 0xff

	// RATEOVERRIDE: Data rate override setting.
	// Position of RATEOVERRIDE field.
	CCM_RATEOVERRIDE_RATEOVERRIDE_Pos = 0x0
	// Bit mask of RATEOVERRIDE field.
	CCM_RATEOVERRIDE_RATEOVERRIDE_Msk = 0x3
	// 1 Mbps
	CCM_RATEOVERRIDE_RATEOVERRIDE_1Mbit = 0x0
	// 2 Mbps
	CCM_RATEOVERRIDE_RATEOVERRIDE_2Mbit = 0x1
	// 125 Kbps
	CCM_RATEOVERRIDE_RATEOVERRIDE_125Kbps = 0x2
	// 500 Kbps
	CCM_RATEOVERRIDE_RATEOVERRIDE_500Kbps = 0x3

	// HEADERMASK: Header (S0) mask.
	// Position of HEADERMASK field.
	CCM_HEADERMASK_HEADERMASK_Pos = 0x0
	// Bit mask of HEADERMASK field.
	CCM_HEADERMASK_HEADERMASK_Msk = 0xff
)

// Bitfields for DPPIC_NS: Distributed programmable peripheral interconnect controller
const (
	// TASKS_CHG.EN: Description cluster: Enable channel group n
	// Position of EN field.
	DPPIC_TASKS_CHG_EN_EN_Pos = 0x0
	// Bit mask of EN field.
	DPPIC_TASKS_CHG_EN_EN_Msk = 0x1
	// Bit EN.
	DPPIC_TASKS_CHG_EN_EN = 0x1
	// Trigger task
	DPPIC_TASKS_CHG_EN_EN_Trigger = 0x1

	// TASKS_CHG.DIS: Description cluster: Disable channel group n
	// Position of DIS field.
	DPPIC_TASKS_CHG_DIS_DIS_Pos = 0x0
	// Bit mask of DIS field.
	DPPIC_TASKS_CHG_DIS_DIS_Msk = 0x1
	// Bit DIS.
	DPPIC_TASKS_CHG_DIS_DIS = 0x1
	// Trigger task
	DPPIC_TASKS_CHG_DIS_DIS_Trigger = 0x1

	// SUBSCRIBE_CHG.EN: Description cluster: Subscribe configuration for task CHG[n].EN
	// Position of CHIDX field.
	DPPIC_SUBSCRIBE_CHG_EN_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	DPPIC_SUBSCRIBE_CHG_EN_CHIDX_Msk = 0xff
	// Position of EN field.
	DPPIC_SUBSCRIBE_CHG_EN_EN_Pos = 0x1f
	// Bit mask of EN field.
	DPPIC_SUBSCRIBE_CHG_EN_EN_Msk = 0x80000000
	// Bit EN.
	DPPIC_SUBSCRIBE_CHG_EN_EN = 0x80000000
	// Disable subscription
	DPPIC_SUBSCRIBE_CHG_EN_EN_Disabled = 0x0
	// Enable subscription
	DPPIC_SUBSCRIBE_CHG_EN_EN_Enabled = 0x1

	// SUBSCRIBE_CHG.DIS: Description cluster: Subscribe configuration for task CHG[n].DIS
	// Position of CHIDX field.
	DPPIC_SUBSCRIBE_CHG_DIS_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	DPPIC_SUBSCRIBE_CHG_DIS_CHIDX_Msk = 0xff
	// Position of EN field.
	DPPIC_SUBSCRIBE_CHG_DIS_EN_Pos = 0x1f
	// Bit mask of EN field.
	DPPIC_SUBSCRIBE_CHG_DIS_EN_Msk = 0x80000000
	// Bit EN.
	DPPIC_SUBSCRIBE_CHG_DIS_EN = 0x80000000
	// Disable subscription
	DPPIC_SUBSCRIBE_CHG_DIS_EN_Disabled = 0x0
	// Enable subscription
	DPPIC_SUBSCRIBE_CHG_DIS_EN_Enabled = 0x1

	// CHEN: Channel enable register
	// Position of CH0 field.
	DPPIC_CHEN_CH0_Pos = 0x0
	// Bit mask of CH0 field.
	DPPIC_CHEN_CH0_Msk = 0x1
	// Bit CH0.
	DPPIC_CHEN_CH0 = 0x1
	// Disable channel
	DPPIC_CHEN_CH0_Disabled = 0x0
	// Enable channel
	DPPIC_CHEN_CH0_Enabled = 0x1
	// Position of CH1 field.
	DPPIC_CHEN_CH1_Pos = 0x1
	// Bit mask of CH1 field.
	DPPIC_CHEN_CH1_Msk = 0x2
	// Bit CH1.
	DPPIC_CHEN_CH1 = 0x2
	// Disable channel
	DPPIC_CHEN_CH1_Disabled = 0x0
	// Enable channel
	DPPIC_CHEN_CH1_Enabled = 0x1
	// Position of CH2 field.
	DPPIC_CHEN_CH2_Pos = 0x2
	// Bit mask of CH2 field.
	DPPIC_CHEN_CH2_Msk = 0x4
	// Bit CH2.
	DPPIC_CHEN_CH2 = 0x4
	// Disable channel
	DPPIC_CHEN_CH2_Disabled = 0x0
	// Enable channel
	DPPIC_CHEN_CH2_Enabled = 0x1
	// Position of CH3 field.
	DPPIC_CHEN_CH3_Pos = 0x3
	// Bit mask of CH3 field.
	DPPIC_CHEN_CH3_Msk = 0x8
	// Bit CH3.
	DPPIC_CHEN_CH3 = 0x8
	// Disable channel
	DPPIC_CHEN_CH3_Disabled = 0x0
	// Enable channel
	DPPIC_CHEN_CH3_Enabled = 0x1
	// Position of CH4 field.
	DPPIC_CHEN_CH4_Pos = 0x4
	// Bit mask of CH4 field.
	DPPIC_CHEN_CH4_Msk = 0x10
	// Bit CH4.
	DPPIC_CHEN_CH4 = 0x10
	// Disable channel
	DPPIC_CHEN_CH4_Disabled = 0x0
	// Enable channel
	DPPIC_CHEN_CH4_Enabled = 0x1
	// Position of CH5 field.
	DPPIC_CHEN_CH5_Pos = 0x5
	// Bit mask of CH5 field.
	DPPIC_CHEN_CH5_Msk = 0x20
	// Bit CH5.
	DPPIC_CHEN_CH5 = 0x20
	// Disable channel
	DPPIC_CHEN_CH5_Disabled = 0x0
	// Enable channel
	DPPIC_CHEN_CH5_Enabled = 0x1
	// Position of CH6 field.
	DPPIC_CHEN_CH6_Pos = 0x6
	// Bit mask of CH6 field.
	DPPIC_CHEN_CH6_Msk = 0x40
	// Bit CH6.
	DPPIC_CHEN_CH6 = 0x40
	// Disable channel
	DPPIC_CHEN_CH6_Disabled = 0x0
	// Enable channel
	DPPIC_CHEN_CH6_Enabled = 0x1
	// Position of CH7 field.
	DPPIC_CHEN_CH7_Pos = 0x7
	// Bit mask of CH7 field.
	DPPIC_CHEN_CH7_Msk = 0x80
	// Bit CH7.
	DPPIC_CHEN_CH7 = 0x80
	// Disable channel
	DPPIC_CHEN_CH7_Disabled = 0x0
	// Enable channel
	DPPIC_CHEN_CH7_Enabled = 0x1
	// Position of CH8 field.
	DPPIC_CHEN_CH8_Pos = 0x8
	// Bit mask of CH8 field.
	DPPIC_CHEN_CH8_Msk = 0x100
	// Bit CH8.
	DPPIC_CHEN_CH8 = 0x100
	// Disable channel
	DPPIC_CHEN_CH8_Disabled = 0x0
	// Enable channel
	DPPIC_CHEN_CH8_Enabled = 0x1
	// Position of CH9 field.
	DPPIC_CHEN_CH9_Pos = 0x9
	// Bit mask of CH9 field.
	DPPIC_CHEN_CH9_Msk = 0x200
	// Bit CH9.
	DPPIC_CHEN_CH9 = 0x200
	// Disable channel
	DPPIC_CHEN_CH9_Disabled = 0x0
	// Enable channel
	DPPIC_CHEN_CH9_Enabled = 0x1
	// Position of CH10 field.
	DPPIC_CHEN_CH10_Pos = 0xa
	// Bit mask of CH10 field.
	DPPIC_CHEN_CH10_Msk = 0x400
	// Bit CH10.
	DPPIC_CHEN_CH10 = 0x400
	// Disable channel
	DPPIC_CHEN_CH10_Disabled = 0x0
	// Enable channel
	DPPIC_CHEN_CH10_Enabled = 0x1
	// Position of CH11 field.
	DPPIC_CHEN_CH11_Pos = 0xb
	// Bit mask of CH11 field.
	DPPIC_CHEN_CH11_Msk = 0x800
	// Bit CH11.
	DPPIC_CHEN_CH11 = 0x800
	// Disable channel
	DPPIC_CHEN_CH11_Disabled = 0x0
	// Enable channel
	DPPIC_CHEN_CH11_Enabled = 0x1
	// Position of CH12 field.
	DPPIC_CHEN_CH12_Pos = 0xc
	// Bit mask of CH12 field.
	DPPIC_CHEN_CH12_Msk = 0x1000
	// Bit CH12.
	DPPIC_CHEN_CH12 = 0x1000
	// Disable channel
	DPPIC_CHEN_CH12_Disabled = 0x0
	// Enable channel
	DPPIC_CHEN_CH12_Enabled = 0x1
	// Position of CH13 field.
	DPPIC_CHEN_CH13_Pos = 0xd
	// Bit mask of CH13 field.
	DPPIC_CHEN_CH13_Msk = 0x2000
	// Bit CH13.
	DPPIC_CHEN_CH13 = 0x2000
	// Disable channel
	DPPIC_CHEN_CH13_Disabled = 0x0
	// Enable channel
	DPPIC_CHEN_CH13_Enabled = 0x1
	// Position of CH14 field.
	DPPIC_CHEN_CH14_Pos = 0xe
	// Bit mask of CH14 field.
	DPPIC_CHEN_CH14_Msk = 0x4000
	// Bit CH14.
	DPPIC_CHEN_CH14 = 0x4000
	// Disable channel
	DPPIC_CHEN_CH14_Disabled = 0x0
	// Enable channel
	DPPIC_CHEN_CH14_Enabled = 0x1
	// Position of CH15 field.
	DPPIC_CHEN_CH15_Pos = 0xf
	// Bit mask of CH15 field.
	DPPIC_CHEN_CH15_Msk = 0x8000
	// Bit CH15.
	DPPIC_CHEN_CH15 = 0x8000
	// Disable channel
	DPPIC_CHEN_CH15_Disabled = 0x0
	// Enable channel
	DPPIC_CHEN_CH15_Enabled = 0x1

	// CHENSET: Channel enable set register
	// Position of CH0 field.
	DPPIC_CHENSET_CH0_Pos = 0x0
	// Bit mask of CH0 field.
	DPPIC_CHENSET_CH0_Msk = 0x1
	// Bit CH0.
	DPPIC_CHENSET_CH0 = 0x1
	// Read: Channel disabled
	DPPIC_CHENSET_CH0_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENSET_CH0_Enabled = 0x1
	// Write: Enable channel
	DPPIC_CHENSET_CH0_Set = 0x1
	// Position of CH1 field.
	DPPIC_CHENSET_CH1_Pos = 0x1
	// Bit mask of CH1 field.
	DPPIC_CHENSET_CH1_Msk = 0x2
	// Bit CH1.
	DPPIC_CHENSET_CH1 = 0x2
	// Read: Channel disabled
	DPPIC_CHENSET_CH1_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENSET_CH1_Enabled = 0x1
	// Write: Enable channel
	DPPIC_CHENSET_CH1_Set = 0x1
	// Position of CH2 field.
	DPPIC_CHENSET_CH2_Pos = 0x2
	// Bit mask of CH2 field.
	DPPIC_CHENSET_CH2_Msk = 0x4
	// Bit CH2.
	DPPIC_CHENSET_CH2 = 0x4
	// Read: Channel disabled
	DPPIC_CHENSET_CH2_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENSET_CH2_Enabled = 0x1
	// Write: Enable channel
	DPPIC_CHENSET_CH2_Set = 0x1
	// Position of CH3 field.
	DPPIC_CHENSET_CH3_Pos = 0x3
	// Bit mask of CH3 field.
	DPPIC_CHENSET_CH3_Msk = 0x8
	// Bit CH3.
	DPPIC_CHENSET_CH3 = 0x8
	// Read: Channel disabled
	DPPIC_CHENSET_CH3_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENSET_CH3_Enabled = 0x1
	// Write: Enable channel
	DPPIC_CHENSET_CH3_Set = 0x1
	// Position of CH4 field.
	DPPIC_CHENSET_CH4_Pos = 0x4
	// Bit mask of CH4 field.
	DPPIC_CHENSET_CH4_Msk = 0x10
	// Bit CH4.
	DPPIC_CHENSET_CH4 = 0x10
	// Read: Channel disabled
	DPPIC_CHENSET_CH4_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENSET_CH4_Enabled = 0x1
	// Write: Enable channel
	DPPIC_CHENSET_CH4_Set = 0x1
	// Position of CH5 field.
	DPPIC_CHENSET_CH5_Pos = 0x5
	// Bit mask of CH5 field.
	DPPIC_CHENSET_CH5_Msk = 0x20
	// Bit CH5.
	DPPIC_CHENSET_CH5 = 0x20
	// Read: Channel disabled
	DPPIC_CHENSET_CH5_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENSET_CH5_Enabled = 0x1
	// Write: Enable channel
	DPPIC_CHENSET_CH5_Set = 0x1
	// Position of CH6 field.
	DPPIC_CHENSET_CH6_Pos = 0x6
	// Bit mask of CH6 field.
	DPPIC_CHENSET_CH6_Msk = 0x40
	// Bit CH6.
	DPPIC_CHENSET_CH6 = 0x40
	// Read: Channel disabled
	DPPIC_CHENSET_CH6_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENSET_CH6_Enabled = 0x1
	// Write: Enable channel
	DPPIC_CHENSET_CH6_Set = 0x1
	// Position of CH7 field.
	DPPIC_CHENSET_CH7_Pos = 0x7
	// Bit mask of CH7 field.
	DPPIC_CHENSET_CH7_Msk = 0x80
	// Bit CH7.
	DPPIC_CHENSET_CH7 = 0x80
	// Read: Channel disabled
	DPPIC_CHENSET_CH7_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENSET_CH7_Enabled = 0x1
	// Write: Enable channel
	DPPIC_CHENSET_CH7_Set = 0x1
	// Position of CH8 field.
	DPPIC_CHENSET_CH8_Pos = 0x8
	// Bit mask of CH8 field.
	DPPIC_CHENSET_CH8_Msk = 0x100
	// Bit CH8.
	DPPIC_CHENSET_CH8 = 0x100
	// Read: Channel disabled
	DPPIC_CHENSET_CH8_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENSET_CH8_Enabled = 0x1
	// Write: Enable channel
	DPPIC_CHENSET_CH8_Set = 0x1
	// Position of CH9 field.
	DPPIC_CHENSET_CH9_Pos = 0x9
	// Bit mask of CH9 field.
	DPPIC_CHENSET_CH9_Msk = 0x200
	// Bit CH9.
	DPPIC_CHENSET_CH9 = 0x200
	// Read: Channel disabled
	DPPIC_CHENSET_CH9_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENSET_CH9_Enabled = 0x1
	// Write: Enable channel
	DPPIC_CHENSET_CH9_Set = 0x1
	// Position of CH10 field.
	DPPIC_CHENSET_CH10_Pos = 0xa
	// Bit mask of CH10 field.
	DPPIC_CHENSET_CH10_Msk = 0x400
	// Bit CH10.
	DPPIC_CHENSET_CH10 = 0x400
	// Read: Channel disabled
	DPPIC_CHENSET_CH10_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENSET_CH10_Enabled = 0x1
	// Write: Enable channel
	DPPIC_CHENSET_CH10_Set = 0x1
	// Position of CH11 field.
	DPPIC_CHENSET_CH11_Pos = 0xb
	// Bit mask of CH11 field.
	DPPIC_CHENSET_CH11_Msk = 0x800
	// Bit CH11.
	DPPIC_CHENSET_CH11 = 0x800
	// Read: Channel disabled
	DPPIC_CHENSET_CH11_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENSET_CH11_Enabled = 0x1
	// Write: Enable channel
	DPPIC_CHENSET_CH11_Set = 0x1
	// Position of CH12 field.
	DPPIC_CHENSET_CH12_Pos = 0xc
	// Bit mask of CH12 field.
	DPPIC_CHENSET_CH12_Msk = 0x1000
	// Bit CH12.
	DPPIC_CHENSET_CH12 = 0x1000
	// Read: Channel disabled
	DPPIC_CHENSET_CH12_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENSET_CH12_Enabled = 0x1
	// Write: Enable channel
	DPPIC_CHENSET_CH12_Set = 0x1
	// Position of CH13 field.
	DPPIC_CHENSET_CH13_Pos = 0xd
	// Bit mask of CH13 field.
	DPPIC_CHENSET_CH13_Msk = 0x2000
	// Bit CH13.
	DPPIC_CHENSET_CH13 = 0x2000
	// Read: Channel disabled
	DPPIC_CHENSET_CH13_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENSET_CH13_Enabled = 0x1
	// Write: Enable channel
	DPPIC_CHENSET_CH13_Set = 0x1
	// Position of CH14 field.
	DPPIC_CHENSET_CH14_Pos = 0xe
	// Bit mask of CH14 field.
	DPPIC_CHENSET_CH14_Msk = 0x4000
	// Bit CH14.
	DPPIC_CHENSET_CH14 = 0x4000
	// Read: Channel disabled
	DPPIC_CHENSET_CH14_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENSET_CH14_Enabled = 0x1
	// Write: Enable channel
	DPPIC_CHENSET_CH14_Set = 0x1
	// Position of CH15 field.
	DPPIC_CHENSET_CH15_Pos = 0xf
	// Bit mask of CH15 field.
	DPPIC_CHENSET_CH15_Msk = 0x8000
	// Bit CH15.
	DPPIC_CHENSET_CH15 = 0x8000
	// Read: Channel disabled
	DPPIC_CHENSET_CH15_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENSET_CH15_Enabled = 0x1
	// Write: Enable channel
	DPPIC_CHENSET_CH15_Set = 0x1

	// CHENCLR: Channel enable clear register
	// Position of CH0 field.
	DPPIC_CHENCLR_CH0_Pos = 0x0
	// Bit mask of CH0 field.
	DPPIC_CHENCLR_CH0_Msk = 0x1
	// Bit CH0.
	DPPIC_CHENCLR_CH0 = 0x1
	// Read: Channel disabled
	DPPIC_CHENCLR_CH0_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENCLR_CH0_Enabled = 0x1
	// Write: Disable channel
	DPPIC_CHENCLR_CH0_Clear = 0x1
	// Position of CH1 field.
	DPPIC_CHENCLR_CH1_Pos = 0x1
	// Bit mask of CH1 field.
	DPPIC_CHENCLR_CH1_Msk = 0x2
	// Bit CH1.
	DPPIC_CHENCLR_CH1 = 0x2
	// Read: Channel disabled
	DPPIC_CHENCLR_CH1_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENCLR_CH1_Enabled = 0x1
	// Write: Disable channel
	DPPIC_CHENCLR_CH1_Clear = 0x1
	// Position of CH2 field.
	DPPIC_CHENCLR_CH2_Pos = 0x2
	// Bit mask of CH2 field.
	DPPIC_CHENCLR_CH2_Msk = 0x4
	// Bit CH2.
	DPPIC_CHENCLR_CH2 = 0x4
	// Read: Channel disabled
	DPPIC_CHENCLR_CH2_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENCLR_CH2_Enabled = 0x1
	// Write: Disable channel
	DPPIC_CHENCLR_CH2_Clear = 0x1
	// Position of CH3 field.
	DPPIC_CHENCLR_CH3_Pos = 0x3
	// Bit mask of CH3 field.
	DPPIC_CHENCLR_CH3_Msk = 0x8
	// Bit CH3.
	DPPIC_CHENCLR_CH3 = 0x8
	// Read: Channel disabled
	DPPIC_CHENCLR_CH3_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENCLR_CH3_Enabled = 0x1
	// Write: Disable channel
	DPPIC_CHENCLR_CH3_Clear = 0x1
	// Position of CH4 field.
	DPPIC_CHENCLR_CH4_Pos = 0x4
	// Bit mask of CH4 field.
	DPPIC_CHENCLR_CH4_Msk = 0x10
	// Bit CH4.
	DPPIC_CHENCLR_CH4 = 0x10
	// Read: Channel disabled
	DPPIC_CHENCLR_CH4_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENCLR_CH4_Enabled = 0x1
	// Write: Disable channel
	DPPIC_CHENCLR_CH4_Clear = 0x1
	// Position of CH5 field.
	DPPIC_CHENCLR_CH5_Pos = 0x5
	// Bit mask of CH5 field.
	DPPIC_CHENCLR_CH5_Msk = 0x20
	// Bit CH5.
	DPPIC_CHENCLR_CH5 = 0x20
	// Read: Channel disabled
	DPPIC_CHENCLR_CH5_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENCLR_CH5_Enabled = 0x1
	// Write: Disable channel
	DPPIC_CHENCLR_CH5_Clear = 0x1
	// Position of CH6 field.
	DPPIC_CHENCLR_CH6_Pos = 0x6
	// Bit mask of CH6 field.
	DPPIC_CHENCLR_CH6_Msk = 0x40
	// Bit CH6.
	DPPIC_CHENCLR_CH6 = 0x40
	// Read: Channel disabled
	DPPIC_CHENCLR_CH6_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENCLR_CH6_Enabled = 0x1
	// Write: Disable channel
	DPPIC_CHENCLR_CH6_Clear = 0x1
	// Position of CH7 field.
	DPPIC_CHENCLR_CH7_Pos = 0x7
	// Bit mask of CH7 field.
	DPPIC_CHENCLR_CH7_Msk = 0x80
	// Bit CH7.
	DPPIC_CHENCLR_CH7 = 0x80
	// Read: Channel disabled
	DPPIC_CHENCLR_CH7_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENCLR_CH7_Enabled = 0x1
	// Write: Disable channel
	DPPIC_CHENCLR_CH7_Clear = 0x1
	// Position of CH8 field.
	DPPIC_CHENCLR_CH8_Pos = 0x8
	// Bit mask of CH8 field.
	DPPIC_CHENCLR_CH8_Msk = 0x100
	// Bit CH8.
	DPPIC_CHENCLR_CH8 = 0x100
	// Read: Channel disabled
	DPPIC_CHENCLR_CH8_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENCLR_CH8_Enabled = 0x1
	// Write: Disable channel
	DPPIC_CHENCLR_CH8_Clear = 0x1
	// Position of CH9 field.
	DPPIC_CHENCLR_CH9_Pos = 0x9
	// Bit mask of CH9 field.
	DPPIC_CHENCLR_CH9_Msk = 0x200
	// Bit CH9.
	DPPIC_CHENCLR_CH9 = 0x200
	// Read: Channel disabled
	DPPIC_CHENCLR_CH9_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENCLR_CH9_Enabled = 0x1
	// Write: Disable channel
	DPPIC_CHENCLR_CH9_Clear = 0x1
	// Position of CH10 field.
	DPPIC_CHENCLR_CH10_Pos = 0xa
	// Bit mask of CH10 field.
	DPPIC_CHENCLR_CH10_Msk = 0x400
	// Bit CH10.
	DPPIC_CHENCLR_CH10 = 0x400
	// Read: Channel disabled
	DPPIC_CHENCLR_CH10_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENCLR_CH10_Enabled = 0x1
	// Write: Disable channel
	DPPIC_CHENCLR_CH10_Clear = 0x1
	// Position of CH11 field.
	DPPIC_CHENCLR_CH11_Pos = 0xb
	// Bit mask of CH11 field.
	DPPIC_CHENCLR_CH11_Msk = 0x800
	// Bit CH11.
	DPPIC_CHENCLR_CH11 = 0x800
	// Read: Channel disabled
	DPPIC_CHENCLR_CH11_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENCLR_CH11_Enabled = 0x1
	// Write: Disable channel
	DPPIC_CHENCLR_CH11_Clear = 0x1
	// Position of CH12 field.
	DPPIC_CHENCLR_CH12_Pos = 0xc
	// Bit mask of CH12 field.
	DPPIC_CHENCLR_CH12_Msk = 0x1000
	// Bit CH12.
	DPPIC_CHENCLR_CH12 = 0x1000
	// Read: Channel disabled
	DPPIC_CHENCLR_CH12_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENCLR_CH12_Enabled = 0x1
	// Write: Disable channel
	DPPIC_CHENCLR_CH12_Clear = 0x1
	// Position of CH13 field.
	DPPIC_CHENCLR_CH13_Pos = 0xd
	// Bit mask of CH13 field.
	DPPIC_CHENCLR_CH13_Msk = 0x2000
	// Bit CH13.
	DPPIC_CHENCLR_CH13 = 0x2000
	// Read: Channel disabled
	DPPIC_CHENCLR_CH13_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENCLR_CH13_Enabled = 0x1
	// Write: Disable channel
	DPPIC_CHENCLR_CH13_Clear = 0x1
	// Position of CH14 field.
	DPPIC_CHENCLR_CH14_Pos = 0xe
	// Bit mask of CH14 field.
	DPPIC_CHENCLR_CH14_Msk = 0x4000
	// Bit CH14.
	DPPIC_CHENCLR_CH14 = 0x4000
	// Read: Channel disabled
	DPPIC_CHENCLR_CH14_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENCLR_CH14_Enabled = 0x1
	// Write: Disable channel
	DPPIC_CHENCLR_CH14_Clear = 0x1
	// Position of CH15 field.
	DPPIC_CHENCLR_CH15_Pos = 0xf
	// Bit mask of CH15 field.
	DPPIC_CHENCLR_CH15_Msk = 0x8000
	// Bit CH15.
	DPPIC_CHENCLR_CH15 = 0x8000
	// Read: Channel disabled
	DPPIC_CHENCLR_CH15_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENCLR_CH15_Enabled = 0x1
	// Write: Disable channel
	DPPIC_CHENCLR_CH15_Clear = 0x1

	// CHG: Description collection: Channel group n Note: Writes to this register are ignored if either SUBSCRIBE_CHG[n].EN or SUBSCRIBE_CHG[n].DIS is enabled
	// Position of CH0 field.
	DPPIC_CHG_CH0_Pos = 0x0
	// Bit mask of CH0 field.
	DPPIC_CHG_CH0_Msk = 0x1
	// Bit CH0.
	DPPIC_CHG_CH0 = 0x1
	// Exclude
	DPPIC_CHG_CH0_Excluded = 0x0
	// Include
	DPPIC_CHG_CH0_Included = 0x1
	// Position of CH1 field.
	DPPIC_CHG_CH1_Pos = 0x1
	// Bit mask of CH1 field.
	DPPIC_CHG_CH1_Msk = 0x2
	// Bit CH1.
	DPPIC_CHG_CH1 = 0x2
	// Exclude
	DPPIC_CHG_CH1_Excluded = 0x0
	// Include
	DPPIC_CHG_CH1_Included = 0x1
	// Position of CH2 field.
	DPPIC_CHG_CH2_Pos = 0x2
	// Bit mask of CH2 field.
	DPPIC_CHG_CH2_Msk = 0x4
	// Bit CH2.
	DPPIC_CHG_CH2 = 0x4
	// Exclude
	DPPIC_CHG_CH2_Excluded = 0x0
	// Include
	DPPIC_CHG_CH2_Included = 0x1
	// Position of CH3 field.
	DPPIC_CHG_CH3_Pos = 0x3
	// Bit mask of CH3 field.
	DPPIC_CHG_CH3_Msk = 0x8
	// Bit CH3.
	DPPIC_CHG_CH3 = 0x8
	// Exclude
	DPPIC_CHG_CH3_Excluded = 0x0
	// Include
	DPPIC_CHG_CH3_Included = 0x1
	// Position of CH4 field.
	DPPIC_CHG_CH4_Pos = 0x4
	// Bit mask of CH4 field.
	DPPIC_CHG_CH4_Msk = 0x10
	// Bit CH4.
	DPPIC_CHG_CH4 = 0x10
	// Exclude
	DPPIC_CHG_CH4_Excluded = 0x0
	// Include
	DPPIC_CHG_CH4_Included = 0x1
	// Position of CH5 field.
	DPPIC_CHG_CH5_Pos = 0x5
	// Bit mask of CH5 field.
	DPPIC_CHG_CH5_Msk = 0x20
	// Bit CH5.
	DPPIC_CHG_CH5 = 0x20
	// Exclude
	DPPIC_CHG_CH5_Excluded = 0x0
	// Include
	DPPIC_CHG_CH5_Included = 0x1
	// Position of CH6 field.
	DPPIC_CHG_CH6_Pos = 0x6
	// Bit mask of CH6 field.
	DPPIC_CHG_CH6_Msk = 0x40
	// Bit CH6.
	DPPIC_CHG_CH6 = 0x40
	// Exclude
	DPPIC_CHG_CH6_Excluded = 0x0
	// Include
	DPPIC_CHG_CH6_Included = 0x1
	// Position of CH7 field.
	DPPIC_CHG_CH7_Pos = 0x7
	// Bit mask of CH7 field.
	DPPIC_CHG_CH7_Msk = 0x80
	// Bit CH7.
	DPPIC_CHG_CH7 = 0x80
	// Exclude
	DPPIC_CHG_CH7_Excluded = 0x0
	// Include
	DPPIC_CHG_CH7_Included = 0x1
	// Position of CH8 field.
	DPPIC_CHG_CH8_Pos = 0x8
	// Bit mask of CH8 field.
	DPPIC_CHG_CH8_Msk = 0x100
	// Bit CH8.
	DPPIC_CHG_CH8 = 0x100
	// Exclude
	DPPIC_CHG_CH8_Excluded = 0x0
	// Include
	DPPIC_CHG_CH8_Included = 0x1
	// Position of CH9 field.
	DPPIC_CHG_CH9_Pos = 0x9
	// Bit mask of CH9 field.
	DPPIC_CHG_CH9_Msk = 0x200
	// Bit CH9.
	DPPIC_CHG_CH9 = 0x200
	// Exclude
	DPPIC_CHG_CH9_Excluded = 0x0
	// Include
	DPPIC_CHG_CH9_Included = 0x1
	// Position of CH10 field.
	DPPIC_CHG_CH10_Pos = 0xa
	// Bit mask of CH10 field.
	DPPIC_CHG_CH10_Msk = 0x400
	// Bit CH10.
	DPPIC_CHG_CH10 = 0x400
	// Exclude
	DPPIC_CHG_CH10_Excluded = 0x0
	// Include
	DPPIC_CHG_CH10_Included = 0x1
	// Position of CH11 field.
	DPPIC_CHG_CH11_Pos = 0xb
	// Bit mask of CH11 field.
	DPPIC_CHG_CH11_Msk = 0x800
	// Bit CH11.
	DPPIC_CHG_CH11 = 0x800
	// Exclude
	DPPIC_CHG_CH11_Excluded = 0x0
	// Include
	DPPIC_CHG_CH11_Included = 0x1
	// Position of CH12 field.
	DPPIC_CHG_CH12_Pos = 0xc
	// Bit mask of CH12 field.
	DPPIC_CHG_CH12_Msk = 0x1000
	// Bit CH12.
	DPPIC_CHG_CH12 = 0x1000
	// Exclude
	DPPIC_CHG_CH12_Excluded = 0x0
	// Include
	DPPIC_CHG_CH12_Included = 0x1
	// Position of CH13 field.
	DPPIC_CHG_CH13_Pos = 0xd
	// Bit mask of CH13 field.
	DPPIC_CHG_CH13_Msk = 0x2000
	// Bit CH13.
	DPPIC_CHG_CH13 = 0x2000
	// Exclude
	DPPIC_CHG_CH13_Excluded = 0x0
	// Include
	DPPIC_CHG_CH13_Included = 0x1
	// Position of CH14 field.
	DPPIC_CHG_CH14_Pos = 0xe
	// Bit mask of CH14 field.
	DPPIC_CHG_CH14_Msk = 0x4000
	// Bit CH14.
	DPPIC_CHG_CH14 = 0x4000
	// Exclude
	DPPIC_CHG_CH14_Excluded = 0x0
	// Include
	DPPIC_CHG_CH14_Included = 0x1
	// Position of CH15 field.
	DPPIC_CHG_CH15_Pos = 0xf
	// Bit mask of CH15 field.
	DPPIC_CHG_CH15_Msk = 0x8000
	// Bit CH15.
	DPPIC_CHG_CH15 = 0x8000
	// Exclude
	DPPIC_CHG_CH15_Excluded = 0x0
	// Include
	DPPIC_CHG_CH15_Included = 0x1
)

// Bitfields for TEMP_NS: Temperature Sensor
const (
	// TASKS_START: Start temperature measurement
	// Position of TASKS_START field.
	TEMP_TASKS_START_TASKS_START_Pos = 0x0
	// Bit mask of TASKS_START field.
	TEMP_TASKS_START_TASKS_START_Msk = 0x1
	// Bit TASKS_START.
	TEMP_TASKS_START_TASKS_START = 0x1
	// Trigger task
	TEMP_TASKS_START_TASKS_START_Trigger = 0x1

	// TASKS_STOP: Stop temperature measurement
	// Position of TASKS_STOP field.
	TEMP_TASKS_STOP_TASKS_STOP_Pos = 0x0
	// Bit mask of TASKS_STOP field.
	TEMP_TASKS_STOP_TASKS_STOP_Msk = 0x1
	// Bit TASKS_STOP.
	TEMP_TASKS_STOP_TASKS_STOP = 0x1
	// Trigger task
	TEMP_TASKS_STOP_TASKS_STOP_Trigger = 0x1

	// SUBSCRIBE_START: Subscribe configuration for task START
	// Position of CHIDX field.
	TEMP_SUBSCRIBE_START_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TEMP_SUBSCRIBE_START_CHIDX_Msk = 0xff
	// Position of EN field.
	TEMP_SUBSCRIBE_START_EN_Pos = 0x1f
	// Bit mask of EN field.
	TEMP_SUBSCRIBE_START_EN_Msk = 0x80000000
	// Bit EN.
	TEMP_SUBSCRIBE_START_EN = 0x80000000
	// Disable subscription
	TEMP_SUBSCRIBE_START_EN_Disabled = 0x0
	// Enable subscription
	TEMP_SUBSCRIBE_START_EN_Enabled = 0x1

	// SUBSCRIBE_STOP: Subscribe configuration for task STOP
	// Position of CHIDX field.
	TEMP_SUBSCRIBE_STOP_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TEMP_SUBSCRIBE_STOP_CHIDX_Msk = 0xff
	// Position of EN field.
	TEMP_SUBSCRIBE_STOP_EN_Pos = 0x1f
	// Bit mask of EN field.
	TEMP_SUBSCRIBE_STOP_EN_Msk = 0x80000000
	// Bit EN.
	TEMP_SUBSCRIBE_STOP_EN = 0x80000000
	// Disable subscription
	TEMP_SUBSCRIBE_STOP_EN_Disabled = 0x0
	// Enable subscription
	TEMP_SUBSCRIBE_STOP_EN_Enabled = 0x1

	// EVENTS_DATARDY: Temperature measurement complete, data ready
	// Position of EVENTS_DATARDY field.
	TEMP_EVENTS_DATARDY_EVENTS_DATARDY_Pos = 0x0
	// Bit mask of EVENTS_DATARDY field.
	TEMP_EVENTS_DATARDY_EVENTS_DATARDY_Msk = 0x1
	// Bit EVENTS_DATARDY.
	TEMP_EVENTS_DATARDY_EVENTS_DATARDY = 0x1
	// Event not generated
	TEMP_EVENTS_DATARDY_EVENTS_DATARDY_NotGenerated = 0x0
	// Event generated
	TEMP_EVENTS_DATARDY_EVENTS_DATARDY_Generated = 0x1

	// PUBLISH_DATARDY: Publish configuration for event DATARDY
	// Position of CHIDX field.
	TEMP_PUBLISH_DATARDY_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TEMP_PUBLISH_DATARDY_CHIDX_Msk = 0xff
	// Position of EN field.
	TEMP_PUBLISH_DATARDY_EN_Pos = 0x1f
	// Bit mask of EN field.
	TEMP_PUBLISH_DATARDY_EN_Msk = 0x80000000
	// Bit EN.
	TEMP_PUBLISH_DATARDY_EN = 0x80000000
	// Disable publishing
	TEMP_PUBLISH_DATARDY_EN_Disabled = 0x0
	// Enable publishing
	TEMP_PUBLISH_DATARDY_EN_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of DATARDY field.
	TEMP_INTENSET_DATARDY_Pos = 0x0
	// Bit mask of DATARDY field.
	TEMP_INTENSET_DATARDY_Msk = 0x1
	// Bit DATARDY.
	TEMP_INTENSET_DATARDY = 0x1
	// Read: Disabled
	TEMP_INTENSET_DATARDY_Disabled = 0x0
	// Read: Enabled
	TEMP_INTENSET_DATARDY_Enabled = 0x1
	// Enable
	TEMP_INTENSET_DATARDY_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of DATARDY field.
	TEMP_INTENCLR_DATARDY_Pos = 0x0
	// Bit mask of DATARDY field.
	TEMP_INTENCLR_DATARDY_Msk = 0x1
	// Bit DATARDY.
	TEMP_INTENCLR_DATARDY = 0x1
	// Read: Disabled
	TEMP_INTENCLR_DATARDY_Disabled = 0x0
	// Read: Enabled
	TEMP_INTENCLR_DATARDY_Enabled = 0x1
	// Disable
	TEMP_INTENCLR_DATARDY_Clear = 0x1

	// TEMP: Temperature in degC (0.25deg steps)
	// Position of TEMP field.
	TEMP_TEMP_TEMP_Pos = 0x0
	// Bit mask of TEMP field.
	TEMP_TEMP_TEMP_Msk = 0xffffffff

	// A0: Slope of 1st piece wise linear function
	// Position of A0 field.
	TEMP_A0_A0_Pos = 0x0
	// Bit mask of A0 field.
	TEMP_A0_A0_Msk = 0xfff

	// A1: Slope of 2nd piece wise linear function
	// Position of A1 field.
	TEMP_A1_A1_Pos = 0x0
	// Bit mask of A1 field.
	TEMP_A1_A1_Msk = 0xfff

	// A2: Slope of 3rd piece wise linear function
	// Position of A2 field.
	TEMP_A2_A2_Pos = 0x0
	// Bit mask of A2 field.
	TEMP_A2_A2_Msk = 0xfff

	// A3: Slope of 4th piece wise linear function
	// Position of A3 field.
	TEMP_A3_A3_Pos = 0x0
	// Bit mask of A3 field.
	TEMP_A3_A3_Msk = 0xfff

	// A4: Slope of 5th piece wise linear function
	// Position of A4 field.
	TEMP_A4_A4_Pos = 0x0
	// Bit mask of A4 field.
	TEMP_A4_A4_Msk = 0xfff

	// A5: Slope of 6th piece wise linear function
	// Position of A5 field.
	TEMP_A5_A5_Pos = 0x0
	// Bit mask of A5 field.
	TEMP_A5_A5_Msk = 0xfff

	// B0: y-intercept of 1st piece wise linear function
	// Position of B0 field.
	TEMP_B0_B0_Pos = 0x0
	// Bit mask of B0 field.
	TEMP_B0_B0_Msk = 0xfff

	// B1: y-intercept of 2nd piece wise linear function
	// Position of B1 field.
	TEMP_B1_B1_Pos = 0x0
	// Bit mask of B1 field.
	TEMP_B1_B1_Msk = 0xfff

	// B2: y-intercept of 3rd piece wise linear function
	// Position of B2 field.
	TEMP_B2_B2_Pos = 0x0
	// Bit mask of B2 field.
	TEMP_B2_B2_Msk = 0xfff

	// B3: y-intercept of 4th piece wise linear function
	// Position of B3 field.
	TEMP_B3_B3_Pos = 0x0
	// Bit mask of B3 field.
	TEMP_B3_B3_Msk = 0xfff

	// B4: y-intercept of 5th piece wise linear function
	// Position of B4 field.
	TEMP_B4_B4_Pos = 0x0
	// Bit mask of B4 field.
	TEMP_B4_B4_Msk = 0xfff

	// B5: y-intercept of 6th piece wise linear function
	// Position of B5 field.
	TEMP_B5_B5_Pos = 0x0
	// Bit mask of B5 field.
	TEMP_B5_B5_Msk = 0xfff

	// T0: End point of 1st piece wise linear function
	// Position of T0 field.
	TEMP_T0_T0_Pos = 0x0
	// Bit mask of T0 field.
	TEMP_T0_T0_Msk = 0xff

	// T1: End point of 2nd piece wise linear function
	// Position of T1 field.
	TEMP_T1_T1_Pos = 0x0
	// Bit mask of T1 field.
	TEMP_T1_T1_Msk = 0xff

	// T2: End point of 3rd piece wise linear function
	// Position of T2 field.
	TEMP_T2_T2_Pos = 0x0
	// Bit mask of T2 field.
	TEMP_T2_T2_Msk = 0xff

	// T3: End point of 4th piece wise linear function
	// Position of T3 field.
	TEMP_T3_T3_Pos = 0x0
	// Bit mask of T3 field.
	TEMP_T3_T3_Msk = 0xff

	// T4: End point of 5th piece wise linear function
	// Position of T4 field.
	TEMP_T4_T4_Pos = 0x0
	// Bit mask of T4 field.
	TEMP_T4_T4_Msk = 0xff
)

// Bitfields for RTC0_NS: Real-time counter 0
const (
	// TASKS_START: Start RTC counter
	// Position of TASKS_START field.
	RTC_TASKS_START_TASKS_START_Pos = 0x0
	// Bit mask of TASKS_START field.
	RTC_TASKS_START_TASKS_START_Msk = 0x1
	// Bit TASKS_START.
	RTC_TASKS_START_TASKS_START = 0x1
	// Trigger task
	RTC_TASKS_START_TASKS_START_Trigger = 0x1

	// TASKS_STOP: Stop RTC counter
	// Position of TASKS_STOP field.
	RTC_TASKS_STOP_TASKS_STOP_Pos = 0x0
	// Bit mask of TASKS_STOP field.
	RTC_TASKS_STOP_TASKS_STOP_Msk = 0x1
	// Bit TASKS_STOP.
	RTC_TASKS_STOP_TASKS_STOP = 0x1
	// Trigger task
	RTC_TASKS_STOP_TASKS_STOP_Trigger = 0x1

	// TASKS_CLEAR: Clear RTC counter
	// Position of TASKS_CLEAR field.
	RTC_TASKS_CLEAR_TASKS_CLEAR_Pos = 0x0
	// Bit mask of TASKS_CLEAR field.
	RTC_TASKS_CLEAR_TASKS_CLEAR_Msk = 0x1
	// Bit TASKS_CLEAR.
	RTC_TASKS_CLEAR_TASKS_CLEAR = 0x1
	// Trigger task
	RTC_TASKS_CLEAR_TASKS_CLEAR_Trigger = 0x1

	// TASKS_TRIGOVRFLW: Set counter to 0xFFFFF0
	// Position of TASKS_TRIGOVRFLW field.
	RTC_TASKS_TRIGOVRFLW_TASKS_TRIGOVRFLW_Pos = 0x0
	// Bit mask of TASKS_TRIGOVRFLW field.
	RTC_TASKS_TRIGOVRFLW_TASKS_TRIGOVRFLW_Msk = 0x1
	// Bit TASKS_TRIGOVRFLW.
	RTC_TASKS_TRIGOVRFLW_TASKS_TRIGOVRFLW = 0x1
	// Trigger task
	RTC_TASKS_TRIGOVRFLW_TASKS_TRIGOVRFLW_Trigger = 0x1

	// TASKS_CAPTURE: Description collection: Capture RTC counter to CC[n] register
	// Position of TASKS_CAPTURE field.
	RTC_TASKS_CAPTURE_TASKS_CAPTURE_Pos = 0x0
	// Bit mask of TASKS_CAPTURE field.
	RTC_TASKS_CAPTURE_TASKS_CAPTURE_Msk = 0x1
	// Bit TASKS_CAPTURE.
	RTC_TASKS_CAPTURE_TASKS_CAPTURE = 0x1
	// Trigger task
	RTC_TASKS_CAPTURE_TASKS_CAPTURE_Trigger = 0x1

	// SUBSCRIBE_START: Subscribe configuration for task START
	// Position of CHIDX field.
	RTC_SUBSCRIBE_START_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RTC_SUBSCRIBE_START_CHIDX_Msk = 0xff
	// Position of EN field.
	RTC_SUBSCRIBE_START_EN_Pos = 0x1f
	// Bit mask of EN field.
	RTC_SUBSCRIBE_START_EN_Msk = 0x80000000
	// Bit EN.
	RTC_SUBSCRIBE_START_EN = 0x80000000
	// Disable subscription
	RTC_SUBSCRIBE_START_EN_Disabled = 0x0
	// Enable subscription
	RTC_SUBSCRIBE_START_EN_Enabled = 0x1

	// SUBSCRIBE_STOP: Subscribe configuration for task STOP
	// Position of CHIDX field.
	RTC_SUBSCRIBE_STOP_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RTC_SUBSCRIBE_STOP_CHIDX_Msk = 0xff
	// Position of EN field.
	RTC_SUBSCRIBE_STOP_EN_Pos = 0x1f
	// Bit mask of EN field.
	RTC_SUBSCRIBE_STOP_EN_Msk = 0x80000000
	// Bit EN.
	RTC_SUBSCRIBE_STOP_EN = 0x80000000
	// Disable subscription
	RTC_SUBSCRIBE_STOP_EN_Disabled = 0x0
	// Enable subscription
	RTC_SUBSCRIBE_STOP_EN_Enabled = 0x1

	// SUBSCRIBE_CLEAR: Subscribe configuration for task CLEAR
	// Position of CHIDX field.
	RTC_SUBSCRIBE_CLEAR_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RTC_SUBSCRIBE_CLEAR_CHIDX_Msk = 0xff
	// Position of EN field.
	RTC_SUBSCRIBE_CLEAR_EN_Pos = 0x1f
	// Bit mask of EN field.
	RTC_SUBSCRIBE_CLEAR_EN_Msk = 0x80000000
	// Bit EN.
	RTC_SUBSCRIBE_CLEAR_EN = 0x80000000
	// Disable subscription
	RTC_SUBSCRIBE_CLEAR_EN_Disabled = 0x0
	// Enable subscription
	RTC_SUBSCRIBE_CLEAR_EN_Enabled = 0x1

	// SUBSCRIBE_TRIGOVRFLW: Subscribe configuration for task TRIGOVRFLW
	// Position of CHIDX field.
	RTC_SUBSCRIBE_TRIGOVRFLW_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RTC_SUBSCRIBE_TRIGOVRFLW_CHIDX_Msk = 0xff
	// Position of EN field.
	RTC_SUBSCRIBE_TRIGOVRFLW_EN_Pos = 0x1f
	// Bit mask of EN field.
	RTC_SUBSCRIBE_TRIGOVRFLW_EN_Msk = 0x80000000
	// Bit EN.
	RTC_SUBSCRIBE_TRIGOVRFLW_EN = 0x80000000
	// Disable subscription
	RTC_SUBSCRIBE_TRIGOVRFLW_EN_Disabled = 0x0
	// Enable subscription
	RTC_SUBSCRIBE_TRIGOVRFLW_EN_Enabled = 0x1

	// SUBSCRIBE_CAPTURE: Description collection: Subscribe configuration for task CAPTURE[n]
	// Position of CHIDX field.
	RTC_SUBSCRIBE_CAPTURE_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RTC_SUBSCRIBE_CAPTURE_CHIDX_Msk = 0xff
	// Position of EN field.
	RTC_SUBSCRIBE_CAPTURE_EN_Pos = 0x1f
	// Bit mask of EN field.
	RTC_SUBSCRIBE_CAPTURE_EN_Msk = 0x80000000
	// Bit EN.
	RTC_SUBSCRIBE_CAPTURE_EN = 0x80000000
	// Disable subscription
	RTC_SUBSCRIBE_CAPTURE_EN_Disabled = 0x0
	// Enable subscription
	RTC_SUBSCRIBE_CAPTURE_EN_Enabled = 0x1

	// EVENTS_TICK: Event on counter increment
	// Position of EVENTS_TICK field.
	RTC_EVENTS_TICK_EVENTS_TICK_Pos = 0x0
	// Bit mask of EVENTS_TICK field.
	RTC_EVENTS_TICK_EVENTS_TICK_Msk = 0x1
	// Bit EVENTS_TICK.
	RTC_EVENTS_TICK_EVENTS_TICK = 0x1
	// Event not generated
	RTC_EVENTS_TICK_EVENTS_TICK_NotGenerated = 0x0
	// Event generated
	RTC_EVENTS_TICK_EVENTS_TICK_Generated = 0x1

	// EVENTS_OVRFLW: Event on counter overflow
	// Position of EVENTS_OVRFLW field.
	RTC_EVENTS_OVRFLW_EVENTS_OVRFLW_Pos = 0x0
	// Bit mask of EVENTS_OVRFLW field.
	RTC_EVENTS_OVRFLW_EVENTS_OVRFLW_Msk = 0x1
	// Bit EVENTS_OVRFLW.
	RTC_EVENTS_OVRFLW_EVENTS_OVRFLW = 0x1
	// Event not generated
	RTC_EVENTS_OVRFLW_EVENTS_OVRFLW_NotGenerated = 0x0
	// Event generated
	RTC_EVENTS_OVRFLW_EVENTS_OVRFLW_Generated = 0x1

	// EVENTS_COMPARE: Description collection: Compare event on CC[n] match
	// Position of EVENTS_COMPARE field.
	RTC_EVENTS_COMPARE_EVENTS_COMPARE_Pos = 0x0
	// Bit mask of EVENTS_COMPARE field.
	RTC_EVENTS_COMPARE_EVENTS_COMPARE_Msk = 0x1
	// Bit EVENTS_COMPARE.
	RTC_EVENTS_COMPARE_EVENTS_COMPARE = 0x1
	// Event not generated
	RTC_EVENTS_COMPARE_EVENTS_COMPARE_NotGenerated = 0x0
	// Event generated
	RTC_EVENTS_COMPARE_EVENTS_COMPARE_Generated = 0x1

	// PUBLISH_TICK: Publish configuration for event TICK
	// Position of CHIDX field.
	RTC_PUBLISH_TICK_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RTC_PUBLISH_TICK_CHIDX_Msk = 0xff
	// Position of EN field.
	RTC_PUBLISH_TICK_EN_Pos = 0x1f
	// Bit mask of EN field.
	RTC_PUBLISH_TICK_EN_Msk = 0x80000000
	// Bit EN.
	RTC_PUBLISH_TICK_EN = 0x80000000
	// Disable publishing
	RTC_PUBLISH_TICK_EN_Disabled = 0x0
	// Enable publishing
	RTC_PUBLISH_TICK_EN_Enabled = 0x1

	// PUBLISH_OVRFLW: Publish configuration for event OVRFLW
	// Position of CHIDX field.
	RTC_PUBLISH_OVRFLW_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RTC_PUBLISH_OVRFLW_CHIDX_Msk = 0xff
	// Position of EN field.
	RTC_PUBLISH_OVRFLW_EN_Pos = 0x1f
	// Bit mask of EN field.
	RTC_PUBLISH_OVRFLW_EN_Msk = 0x80000000
	// Bit EN.
	RTC_PUBLISH_OVRFLW_EN = 0x80000000
	// Disable publishing
	RTC_PUBLISH_OVRFLW_EN_Disabled = 0x0
	// Enable publishing
	RTC_PUBLISH_OVRFLW_EN_Enabled = 0x1

	// PUBLISH_COMPARE: Description collection: Publish configuration for event COMPARE[n]
	// Position of CHIDX field.
	RTC_PUBLISH_COMPARE_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RTC_PUBLISH_COMPARE_CHIDX_Msk = 0xff
	// Position of EN field.
	RTC_PUBLISH_COMPARE_EN_Pos = 0x1f
	// Bit mask of EN field.
	RTC_PUBLISH_COMPARE_EN_Msk = 0x80000000
	// Bit EN.
	RTC_PUBLISH_COMPARE_EN = 0x80000000
	// Disable publishing
	RTC_PUBLISH_COMPARE_EN_Disabled = 0x0
	// Enable publishing
	RTC_PUBLISH_COMPARE_EN_Enabled = 0x1

	// SHORTS: Shortcuts between local events and tasks
	// Position of COMPARE0_CLEAR field.
	RTC_SHORTS_COMPARE0_CLEAR_Pos = 0x0
	// Bit mask of COMPARE0_CLEAR field.
	RTC_SHORTS_COMPARE0_CLEAR_Msk = 0x1
	// Bit COMPARE0_CLEAR.
	RTC_SHORTS_COMPARE0_CLEAR = 0x1
	// Disable shortcut
	RTC_SHORTS_COMPARE0_CLEAR_Disabled = 0x0
	// Enable shortcut
	RTC_SHORTS_COMPARE0_CLEAR_Enabled = 0x1
	// Position of COMPARE1_CLEAR field.
	RTC_SHORTS_COMPARE1_CLEAR_Pos = 0x1
	// Bit mask of COMPARE1_CLEAR field.
	RTC_SHORTS_COMPARE1_CLEAR_Msk = 0x2
	// Bit COMPARE1_CLEAR.
	RTC_SHORTS_COMPARE1_CLEAR = 0x2
	// Disable shortcut
	RTC_SHORTS_COMPARE1_CLEAR_Disabled = 0x0
	// Enable shortcut
	RTC_SHORTS_COMPARE1_CLEAR_Enabled = 0x1
	// Position of COMPARE2_CLEAR field.
	RTC_SHORTS_COMPARE2_CLEAR_Pos = 0x2
	// Bit mask of COMPARE2_CLEAR field.
	RTC_SHORTS_COMPARE2_CLEAR_Msk = 0x4
	// Bit COMPARE2_CLEAR.
	RTC_SHORTS_COMPARE2_CLEAR = 0x4
	// Disable shortcut
	RTC_SHORTS_COMPARE2_CLEAR_Disabled = 0x0
	// Enable shortcut
	RTC_SHORTS_COMPARE2_CLEAR_Enabled = 0x1
	// Position of COMPARE3_CLEAR field.
	RTC_SHORTS_COMPARE3_CLEAR_Pos = 0x3
	// Bit mask of COMPARE3_CLEAR field.
	RTC_SHORTS_COMPARE3_CLEAR_Msk = 0x8
	// Bit COMPARE3_CLEAR.
	RTC_SHORTS_COMPARE3_CLEAR = 0x8
	// Disable shortcut
	RTC_SHORTS_COMPARE3_CLEAR_Disabled = 0x0
	// Enable shortcut
	RTC_SHORTS_COMPARE3_CLEAR_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of TICK field.
	RTC_INTENSET_TICK_Pos = 0x0
	// Bit mask of TICK field.
	RTC_INTENSET_TICK_Msk = 0x1
	// Bit TICK.
	RTC_INTENSET_TICK = 0x1
	// Read: Disabled
	RTC_INTENSET_TICK_Disabled = 0x0
	// Read: Enabled
	RTC_INTENSET_TICK_Enabled = 0x1
	// Enable
	RTC_INTENSET_TICK_Set = 0x1
	// Position of OVRFLW field.
	RTC_INTENSET_OVRFLW_Pos = 0x1
	// Bit mask of OVRFLW field.
	RTC_INTENSET_OVRFLW_Msk = 0x2
	// Bit OVRFLW.
	RTC_INTENSET_OVRFLW = 0x2
	// Read: Disabled
	RTC_INTENSET_OVRFLW_Disabled = 0x0
	// Read: Enabled
	RTC_INTENSET_OVRFLW_Enabled = 0x1
	// Enable
	RTC_INTENSET_OVRFLW_Set = 0x1
	// Position of COMPARE0 field.
	RTC_INTENSET_COMPARE0_Pos = 0x10
	// Bit mask of COMPARE0 field.
	RTC_INTENSET_COMPARE0_Msk = 0x10000
	// Bit COMPARE0.
	RTC_INTENSET_COMPARE0 = 0x10000
	// Read: Disabled
	RTC_INTENSET_COMPARE0_Disabled = 0x0
	// Read: Enabled
	RTC_INTENSET_COMPARE0_Enabled = 0x1
	// Enable
	RTC_INTENSET_COMPARE0_Set = 0x1
	// Position of COMPARE1 field.
	RTC_INTENSET_COMPARE1_Pos = 0x11
	// Bit mask of COMPARE1 field.
	RTC_INTENSET_COMPARE1_Msk = 0x20000
	// Bit COMPARE1.
	RTC_INTENSET_COMPARE1 = 0x20000
	// Read: Disabled
	RTC_INTENSET_COMPARE1_Disabled = 0x0
	// Read: Enabled
	RTC_INTENSET_COMPARE1_Enabled = 0x1
	// Enable
	RTC_INTENSET_COMPARE1_Set = 0x1
	// Position of COMPARE2 field.
	RTC_INTENSET_COMPARE2_Pos = 0x12
	// Bit mask of COMPARE2 field.
	RTC_INTENSET_COMPARE2_Msk = 0x40000
	// Bit COMPARE2.
	RTC_INTENSET_COMPARE2 = 0x40000
	// Read: Disabled
	RTC_INTENSET_COMPARE2_Disabled = 0x0
	// Read: Enabled
	RTC_INTENSET_COMPARE2_Enabled = 0x1
	// Enable
	RTC_INTENSET_COMPARE2_Set = 0x1
	// Position of COMPARE3 field.
	RTC_INTENSET_COMPARE3_Pos = 0x13
	// Bit mask of COMPARE3 field.
	RTC_INTENSET_COMPARE3_Msk = 0x80000
	// Bit COMPARE3.
	RTC_INTENSET_COMPARE3 = 0x80000
	// Read: Disabled
	RTC_INTENSET_COMPARE3_Disabled = 0x0
	// Read: Enabled
	RTC_INTENSET_COMPARE3_Enabled = 0x1
	// Enable
	RTC_INTENSET_COMPARE3_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of TICK field.
	RTC_INTENCLR_TICK_Pos = 0x0
	// Bit mask of TICK field.
	RTC_INTENCLR_TICK_Msk = 0x1
	// Bit TICK.
	RTC_INTENCLR_TICK = 0x1
	// Read: Disabled
	RTC_INTENCLR_TICK_Disabled = 0x0
	// Read: Enabled
	RTC_INTENCLR_TICK_Enabled = 0x1
	// Disable
	RTC_INTENCLR_TICK_Clear = 0x1
	// Position of OVRFLW field.
	RTC_INTENCLR_OVRFLW_Pos = 0x1
	// Bit mask of OVRFLW field.
	RTC_INTENCLR_OVRFLW_Msk = 0x2
	// Bit OVRFLW.
	RTC_INTENCLR_OVRFLW = 0x2
	// Read: Disabled
	RTC_INTENCLR_OVRFLW_Disabled = 0x0
	// Read: Enabled
	RTC_INTENCLR_OVRFLW_Enabled = 0x1
	// Disable
	RTC_INTENCLR_OVRFLW_Clear = 0x1
	// Position of COMPARE0 field.
	RTC_INTENCLR_COMPARE0_Pos = 0x10
	// Bit mask of COMPARE0 field.
	RTC_INTENCLR_COMPARE0_Msk = 0x10000
	// Bit COMPARE0.
	RTC_INTENCLR_COMPARE0 = 0x10000
	// Read: Disabled
	RTC_INTENCLR_COMPARE0_Disabled = 0x0
	// Read: Enabled
	RTC_INTENCLR_COMPARE0_Enabled = 0x1
	// Disable
	RTC_INTENCLR_COMPARE0_Clear = 0x1
	// Position of COMPARE1 field.
	RTC_INTENCLR_COMPARE1_Pos = 0x11
	// Bit mask of COMPARE1 field.
	RTC_INTENCLR_COMPARE1_Msk = 0x20000
	// Bit COMPARE1.
	RTC_INTENCLR_COMPARE1 = 0x20000
	// Read: Disabled
	RTC_INTENCLR_COMPARE1_Disabled = 0x0
	// Read: Enabled
	RTC_INTENCLR_COMPARE1_Enabled = 0x1
	// Disable
	RTC_INTENCLR_COMPARE1_Clear = 0x1
	// Position of COMPARE2 field.
	RTC_INTENCLR_COMPARE2_Pos = 0x12
	// Bit mask of COMPARE2 field.
	RTC_INTENCLR_COMPARE2_Msk = 0x40000
	// Bit COMPARE2.
	RTC_INTENCLR_COMPARE2 = 0x40000
	// Read: Disabled
	RTC_INTENCLR_COMPARE2_Disabled = 0x0
	// Read: Enabled
	RTC_INTENCLR_COMPARE2_Enabled = 0x1
	// Disable
	RTC_INTENCLR_COMPARE2_Clear = 0x1
	// Position of COMPARE3 field.
	RTC_INTENCLR_COMPARE3_Pos = 0x13
	// Bit mask of COMPARE3 field.
	RTC_INTENCLR_COMPARE3_Msk = 0x80000
	// Bit COMPARE3.
	RTC_INTENCLR_COMPARE3 = 0x80000
	// Read: Disabled
	RTC_INTENCLR_COMPARE3_Disabled = 0x0
	// Read: Enabled
	RTC_INTENCLR_COMPARE3_Enabled = 0x1
	// Disable
	RTC_INTENCLR_COMPARE3_Clear = 0x1

	// EVTEN: Enable or disable event routing
	// Position of TICK field.
	RTC_EVTEN_TICK_Pos = 0x0
	// Bit mask of TICK field.
	RTC_EVTEN_TICK_Msk = 0x1
	// Bit TICK.
	RTC_EVTEN_TICK = 0x1
	// Disable
	RTC_EVTEN_TICK_Disabled = 0x0
	// Enable
	RTC_EVTEN_TICK_Enabled = 0x1
	// Position of OVRFLW field.
	RTC_EVTEN_OVRFLW_Pos = 0x1
	// Bit mask of OVRFLW field.
	RTC_EVTEN_OVRFLW_Msk = 0x2
	// Bit OVRFLW.
	RTC_EVTEN_OVRFLW = 0x2
	// Disable
	RTC_EVTEN_OVRFLW_Disabled = 0x0
	// Enable
	RTC_EVTEN_OVRFLW_Enabled = 0x1
	// Position of COMPARE0 field.
	RTC_EVTEN_COMPARE0_Pos = 0x10
	// Bit mask of COMPARE0 field.
	RTC_EVTEN_COMPARE0_Msk = 0x10000
	// Bit COMPARE0.
	RTC_EVTEN_COMPARE0 = 0x10000
	// Disable
	RTC_EVTEN_COMPARE0_Disabled = 0x0
	// Enable
	RTC_EVTEN_COMPARE0_Enabled = 0x1
	// Position of COMPARE1 field.
	RTC_EVTEN_COMPARE1_Pos = 0x11
	// Bit mask of COMPARE1 field.
	RTC_EVTEN_COMPARE1_Msk = 0x20000
	// Bit COMPARE1.
	RTC_EVTEN_COMPARE1 = 0x20000
	// Disable
	RTC_EVTEN_COMPARE1_Disabled = 0x0
	// Enable
	RTC_EVTEN_COMPARE1_Enabled = 0x1
	// Position of COMPARE2 field.
	RTC_EVTEN_COMPARE2_Pos = 0x12
	// Bit mask of COMPARE2 field.
	RTC_EVTEN_COMPARE2_Msk = 0x40000
	// Bit COMPARE2.
	RTC_EVTEN_COMPARE2 = 0x40000
	// Disable
	RTC_EVTEN_COMPARE2_Disabled = 0x0
	// Enable
	RTC_EVTEN_COMPARE2_Enabled = 0x1
	// Position of COMPARE3 field.
	RTC_EVTEN_COMPARE3_Pos = 0x13
	// Bit mask of COMPARE3 field.
	RTC_EVTEN_COMPARE3_Msk = 0x80000
	// Bit COMPARE3.
	RTC_EVTEN_COMPARE3 = 0x80000
	// Disable
	RTC_EVTEN_COMPARE3_Disabled = 0x0
	// Enable
	RTC_EVTEN_COMPARE3_Enabled = 0x1

	// EVTENSET: Enable event routing
	// Position of TICK field.
	RTC_EVTENSET_TICK_Pos = 0x0
	// Bit mask of TICK field.
	RTC_EVTENSET_TICK_Msk = 0x1
	// Bit TICK.
	RTC_EVTENSET_TICK = 0x1
	// Read: Disabled
	RTC_EVTENSET_TICK_Disabled = 0x0
	// Read: Enabled
	RTC_EVTENSET_TICK_Enabled = 0x1
	// Enable
	RTC_EVTENSET_TICK_Set = 0x1
	// Position of OVRFLW field.
	RTC_EVTENSET_OVRFLW_Pos = 0x1
	// Bit mask of OVRFLW field.
	RTC_EVTENSET_OVRFLW_Msk = 0x2
	// Bit OVRFLW.
	RTC_EVTENSET_OVRFLW = 0x2
	// Read: Disabled
	RTC_EVTENSET_OVRFLW_Disabled = 0x0
	// Read: Enabled
	RTC_EVTENSET_OVRFLW_Enabled = 0x1
	// Enable
	RTC_EVTENSET_OVRFLW_Set = 0x1
	// Position of COMPARE0 field.
	RTC_EVTENSET_COMPARE0_Pos = 0x10
	// Bit mask of COMPARE0 field.
	RTC_EVTENSET_COMPARE0_Msk = 0x10000
	// Bit COMPARE0.
	RTC_EVTENSET_COMPARE0 = 0x10000
	// Read: Disabled
	RTC_EVTENSET_COMPARE0_Disabled = 0x0
	// Read: Enabled
	RTC_EVTENSET_COMPARE0_Enabled = 0x1
	// Enable
	RTC_EVTENSET_COMPARE0_Set = 0x1
	// Position of COMPARE1 field.
	RTC_EVTENSET_COMPARE1_Pos = 0x11
	// Bit mask of COMPARE1 field.
	RTC_EVTENSET_COMPARE1_Msk = 0x20000
	// Bit COMPARE1.
	RTC_EVTENSET_COMPARE1 = 0x20000
	// Read: Disabled
	RTC_EVTENSET_COMPARE1_Disabled = 0x0
	// Read: Enabled
	RTC_EVTENSET_COMPARE1_Enabled = 0x1
	// Enable
	RTC_EVTENSET_COMPARE1_Set = 0x1
	// Position of COMPARE2 field.
	RTC_EVTENSET_COMPARE2_Pos = 0x12
	// Bit mask of COMPARE2 field.
	RTC_EVTENSET_COMPARE2_Msk = 0x40000
	// Bit COMPARE2.
	RTC_EVTENSET_COMPARE2 = 0x40000
	// Read: Disabled
	RTC_EVTENSET_COMPARE2_Disabled = 0x0
	// Read: Enabled
	RTC_EVTENSET_COMPARE2_Enabled = 0x1
	// Enable
	RTC_EVTENSET_COMPARE2_Set = 0x1
	// Position of COMPARE3 field.
	RTC_EVTENSET_COMPARE3_Pos = 0x13
	// Bit mask of COMPARE3 field.
	RTC_EVTENSET_COMPARE3_Msk = 0x80000
	// Bit COMPARE3.
	RTC_EVTENSET_COMPARE3 = 0x80000
	// Read: Disabled
	RTC_EVTENSET_COMPARE3_Disabled = 0x0
	// Read: Enabled
	RTC_EVTENSET_COMPARE3_Enabled = 0x1
	// Enable
	RTC_EVTENSET_COMPARE3_Set = 0x1

	// EVTENCLR: Disable event routing
	// Position of TICK field.
	RTC_EVTENCLR_TICK_Pos = 0x0
	// Bit mask of TICK field.
	RTC_EVTENCLR_TICK_Msk = 0x1
	// Bit TICK.
	RTC_EVTENCLR_TICK = 0x1
	// Read: Disabled
	RTC_EVTENCLR_TICK_Disabled = 0x0
	// Read: Enabled
	RTC_EVTENCLR_TICK_Enabled = 0x1
	// Disable
	RTC_EVTENCLR_TICK_Clear = 0x1
	// Position of OVRFLW field.
	RTC_EVTENCLR_OVRFLW_Pos = 0x1
	// Bit mask of OVRFLW field.
	RTC_EVTENCLR_OVRFLW_Msk = 0x2
	// Bit OVRFLW.
	RTC_EVTENCLR_OVRFLW = 0x2
	// Read: Disabled
	RTC_EVTENCLR_OVRFLW_Disabled = 0x0
	// Read: Enabled
	RTC_EVTENCLR_OVRFLW_Enabled = 0x1
	// Disable
	RTC_EVTENCLR_OVRFLW_Clear = 0x1
	// Position of COMPARE0 field.
	RTC_EVTENCLR_COMPARE0_Pos = 0x10
	// Bit mask of COMPARE0 field.
	RTC_EVTENCLR_COMPARE0_Msk = 0x10000
	// Bit COMPARE0.
	RTC_EVTENCLR_COMPARE0 = 0x10000
	// Read: Disabled
	RTC_EVTENCLR_COMPARE0_Disabled = 0x0
	// Read: Enabled
	RTC_EVTENCLR_COMPARE0_Enabled = 0x1
	// Disable
	RTC_EVTENCLR_COMPARE0_Clear = 0x1
	// Position of COMPARE1 field.
	RTC_EVTENCLR_COMPARE1_Pos = 0x11
	// Bit mask of COMPARE1 field.
	RTC_EVTENCLR_COMPARE1_Msk = 0x20000
	// Bit COMPARE1.
	RTC_EVTENCLR_COMPARE1 = 0x20000
	// Read: Disabled
	RTC_EVTENCLR_COMPARE1_Disabled = 0x0
	// Read: Enabled
	RTC_EVTENCLR_COMPARE1_Enabled = 0x1
	// Disable
	RTC_EVTENCLR_COMPARE1_Clear = 0x1
	// Position of COMPARE2 field.
	RTC_EVTENCLR_COMPARE2_Pos = 0x12
	// Bit mask of COMPARE2 field.
	RTC_EVTENCLR_COMPARE2_Msk = 0x40000
	// Bit COMPARE2.
	RTC_EVTENCLR_COMPARE2 = 0x40000
	// Read: Disabled
	RTC_EVTENCLR_COMPARE2_Disabled = 0x0
	// Read: Enabled
	RTC_EVTENCLR_COMPARE2_Enabled = 0x1
	// Disable
	RTC_EVTENCLR_COMPARE2_Clear = 0x1
	// Position of COMPARE3 field.
	RTC_EVTENCLR_COMPARE3_Pos = 0x13
	// Bit mask of COMPARE3 field.
	RTC_EVTENCLR_COMPARE3_Msk = 0x80000
	// Bit COMPARE3.
	RTC_EVTENCLR_COMPARE3 = 0x80000
	// Read: Disabled
	RTC_EVTENCLR_COMPARE3_Disabled = 0x0
	// Read: Enabled
	RTC_EVTENCLR_COMPARE3_Enabled = 0x1
	// Disable
	RTC_EVTENCLR_COMPARE3_Clear = 0x1

	// COUNTER: Current counter value
	// Position of COUNTER field.
	RTC_COUNTER_COUNTER_Pos = 0x0
	// Bit mask of COUNTER field.
	RTC_COUNTER_COUNTER_Msk = 0xffffff

	// PRESCALER: 12-bit prescaler for counter frequency (32768/(PRESCALER+1)). Must be written when RTC is stopped.
	// Position of PRESCALER field.
	RTC_PRESCALER_PRESCALER_Pos = 0x0
	// Bit mask of PRESCALER field.
	RTC_PRESCALER_PRESCALER_Msk = 0xfff

	// CC: Description collection: Compare register n
	// Position of COMPARE field.
	RTC_CC_COMPARE_Pos = 0x0
	// Bit mask of COMPARE field.
	RTC_CC_COMPARE_Msk = 0xffffff
)

// Bitfields for IPC_NS: Interprocessor communication
const (
	// TASKS_SEND: Description collection: Trigger events on IPC channel enabled in SEND_CNF[n]
	// Position of TASKS_SEND field.
	IPC_TASKS_SEND_TASKS_SEND_Pos = 0x0
	// Bit mask of TASKS_SEND field.
	IPC_TASKS_SEND_TASKS_SEND_Msk = 0x1
	// Bit TASKS_SEND.
	IPC_TASKS_SEND_TASKS_SEND = 0x1
	// Trigger task
	IPC_TASKS_SEND_TASKS_SEND_Trigger = 0x1

	// SUBSCRIBE_SEND: Description collection: Subscribe configuration for task SEND[n]
	// Position of CHIDX field.
	IPC_SUBSCRIBE_SEND_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	IPC_SUBSCRIBE_SEND_CHIDX_Msk = 0xff
	// Position of EN field.
	IPC_SUBSCRIBE_SEND_EN_Pos = 0x1f
	// Bit mask of EN field.
	IPC_SUBSCRIBE_SEND_EN_Msk = 0x80000000
	// Bit EN.
	IPC_SUBSCRIBE_SEND_EN = 0x80000000
	// Disable subscription
	IPC_SUBSCRIBE_SEND_EN_Disabled = 0x0
	// Enable subscription
	IPC_SUBSCRIBE_SEND_EN_Enabled = 0x1

	// EVENTS_RECEIVE: Description collection: Event received on one or more of the enabled IPC channels in RECEIVE_CNF[n]
	// Position of EVENTS_RECEIVE field.
	IPC_EVENTS_RECEIVE_EVENTS_RECEIVE_Pos = 0x0
	// Bit mask of EVENTS_RECEIVE field.
	IPC_EVENTS_RECEIVE_EVENTS_RECEIVE_Msk = 0x1
	// Bit EVENTS_RECEIVE.
	IPC_EVENTS_RECEIVE_EVENTS_RECEIVE = 0x1
	// Event not generated
	IPC_EVENTS_RECEIVE_EVENTS_RECEIVE_NotGenerated = 0x0
	// Event generated
	IPC_EVENTS_RECEIVE_EVENTS_RECEIVE_Generated = 0x1

	// PUBLISH_RECEIVE: Description collection: Publish configuration for event RECEIVE[n]
	// Position of CHIDX field.
	IPC_PUBLISH_RECEIVE_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	IPC_PUBLISH_RECEIVE_CHIDX_Msk = 0xff
	// Position of EN field.
	IPC_PUBLISH_RECEIVE_EN_Pos = 0x1f
	// Bit mask of EN field.
	IPC_PUBLISH_RECEIVE_EN_Msk = 0x80000000
	// Bit EN.
	IPC_PUBLISH_RECEIVE_EN = 0x80000000
	// Disable publishing
	IPC_PUBLISH_RECEIVE_EN_Disabled = 0x0
	// Enable publishing
	IPC_PUBLISH_RECEIVE_EN_Enabled = 0x1

	// INTEN: Enable or disable interrupt
	// Position of RECEIVE0 field.
	IPC_INTEN_RECEIVE0_Pos = 0x0
	// Bit mask of RECEIVE0 field.
	IPC_INTEN_RECEIVE0_Msk = 0x1
	// Bit RECEIVE0.
	IPC_INTEN_RECEIVE0 = 0x1
	// Disable
	IPC_INTEN_RECEIVE0_Disabled = 0x0
	// Enable
	IPC_INTEN_RECEIVE0_Enabled = 0x1
	// Position of RECEIVE1 field.
	IPC_INTEN_RECEIVE1_Pos = 0x1
	// Bit mask of RECEIVE1 field.
	IPC_INTEN_RECEIVE1_Msk = 0x2
	// Bit RECEIVE1.
	IPC_INTEN_RECEIVE1 = 0x2
	// Disable
	IPC_INTEN_RECEIVE1_Disabled = 0x0
	// Enable
	IPC_INTEN_RECEIVE1_Enabled = 0x1
	// Position of RECEIVE2 field.
	IPC_INTEN_RECEIVE2_Pos = 0x2
	// Bit mask of RECEIVE2 field.
	IPC_INTEN_RECEIVE2_Msk = 0x4
	// Bit RECEIVE2.
	IPC_INTEN_RECEIVE2 = 0x4
	// Disable
	IPC_INTEN_RECEIVE2_Disabled = 0x0
	// Enable
	IPC_INTEN_RECEIVE2_Enabled = 0x1
	// Position of RECEIVE3 field.
	IPC_INTEN_RECEIVE3_Pos = 0x3
	// Bit mask of RECEIVE3 field.
	IPC_INTEN_RECEIVE3_Msk = 0x8
	// Bit RECEIVE3.
	IPC_INTEN_RECEIVE3 = 0x8
	// Disable
	IPC_INTEN_RECEIVE3_Disabled = 0x0
	// Enable
	IPC_INTEN_RECEIVE3_Enabled = 0x1
	// Position of RECEIVE4 field.
	IPC_INTEN_RECEIVE4_Pos = 0x4
	// Bit mask of RECEIVE4 field.
	IPC_INTEN_RECEIVE4_Msk = 0x10
	// Bit RECEIVE4.
	IPC_INTEN_RECEIVE4 = 0x10
	// Disable
	IPC_INTEN_RECEIVE4_Disabled = 0x0
	// Enable
	IPC_INTEN_RECEIVE4_Enabled = 0x1
	// Position of RECEIVE5 field.
	IPC_INTEN_RECEIVE5_Pos = 0x5
	// Bit mask of RECEIVE5 field.
	IPC_INTEN_RECEIVE5_Msk = 0x20
	// Bit RECEIVE5.
	IPC_INTEN_RECEIVE5 = 0x20
	// Disable
	IPC_INTEN_RECEIVE5_Disabled = 0x0
	// Enable
	IPC_INTEN_RECEIVE5_Enabled = 0x1
	// Position of RECEIVE6 field.
	IPC_INTEN_RECEIVE6_Pos = 0x6
	// Bit mask of RECEIVE6 field.
	IPC_INTEN_RECEIVE6_Msk = 0x40
	// Bit RECEIVE6.
	IPC_INTEN_RECEIVE6 = 0x40
	// Disable
	IPC_INTEN_RECEIVE6_Disabled = 0x0
	// Enable
	IPC_INTEN_RECEIVE6_Enabled = 0x1
	// Position of RECEIVE7 field.
	IPC_INTEN_RECEIVE7_Pos = 0x7
	// Bit mask of RECEIVE7 field.
	IPC_INTEN_RECEIVE7_Msk = 0x80
	// Bit RECEIVE7.
	IPC_INTEN_RECEIVE7 = 0x80
	// Disable
	IPC_INTEN_RECEIVE7_Disabled = 0x0
	// Enable
	IPC_INTEN_RECEIVE7_Enabled = 0x1
	// Position of RECEIVE8 field.
	IPC_INTEN_RECEIVE8_Pos = 0x8
	// Bit mask of RECEIVE8 field.
	IPC_INTEN_RECEIVE8_Msk = 0x100
	// Bit RECEIVE8.
	IPC_INTEN_RECEIVE8 = 0x100
	// Disable
	IPC_INTEN_RECEIVE8_Disabled = 0x0
	// Enable
	IPC_INTEN_RECEIVE8_Enabled = 0x1
	// Position of RECEIVE9 field.
	IPC_INTEN_RECEIVE9_Pos = 0x9
	// Bit mask of RECEIVE9 field.
	IPC_INTEN_RECEIVE9_Msk = 0x200
	// Bit RECEIVE9.
	IPC_INTEN_RECEIVE9 = 0x200
	// Disable
	IPC_INTEN_RECEIVE9_Disabled = 0x0
	// Enable
	IPC_INTEN_RECEIVE9_Enabled = 0x1
	// Position of RECEIVE10 field.
	IPC_INTEN_RECEIVE10_Pos = 0xa
	// Bit mask of RECEIVE10 field.
	IPC_INTEN_RECEIVE10_Msk = 0x400
	// Bit RECEIVE10.
	IPC_INTEN_RECEIVE10 = 0x400
	// Disable
	IPC_INTEN_RECEIVE10_Disabled = 0x0
	// Enable
	IPC_INTEN_RECEIVE10_Enabled = 0x1
	// Position of RECEIVE11 field.
	IPC_INTEN_RECEIVE11_Pos = 0xb
	// Bit mask of RECEIVE11 field.
	IPC_INTEN_RECEIVE11_Msk = 0x800
	// Bit RECEIVE11.
	IPC_INTEN_RECEIVE11 = 0x800
	// Disable
	IPC_INTEN_RECEIVE11_Disabled = 0x0
	// Enable
	IPC_INTEN_RECEIVE11_Enabled = 0x1
	// Position of RECEIVE12 field.
	IPC_INTEN_RECEIVE12_Pos = 0xc
	// Bit mask of RECEIVE12 field.
	IPC_INTEN_RECEIVE12_Msk = 0x1000
	// Bit RECEIVE12.
	IPC_INTEN_RECEIVE12 = 0x1000
	// Disable
	IPC_INTEN_RECEIVE12_Disabled = 0x0
	// Enable
	IPC_INTEN_RECEIVE12_Enabled = 0x1
	// Position of RECEIVE13 field.
	IPC_INTEN_RECEIVE13_Pos = 0xd
	// Bit mask of RECEIVE13 field.
	IPC_INTEN_RECEIVE13_Msk = 0x2000
	// Bit RECEIVE13.
	IPC_INTEN_RECEIVE13 = 0x2000
	// Disable
	IPC_INTEN_RECEIVE13_Disabled = 0x0
	// Enable
	IPC_INTEN_RECEIVE13_Enabled = 0x1
	// Position of RECEIVE14 field.
	IPC_INTEN_RECEIVE14_Pos = 0xe
	// Bit mask of RECEIVE14 field.
	IPC_INTEN_RECEIVE14_Msk = 0x4000
	// Bit RECEIVE14.
	IPC_INTEN_RECEIVE14 = 0x4000
	// Disable
	IPC_INTEN_RECEIVE14_Disabled = 0x0
	// Enable
	IPC_INTEN_RECEIVE14_Enabled = 0x1
	// Position of RECEIVE15 field.
	IPC_INTEN_RECEIVE15_Pos = 0xf
	// Bit mask of RECEIVE15 field.
	IPC_INTEN_RECEIVE15_Msk = 0x8000
	// Bit RECEIVE15.
	IPC_INTEN_RECEIVE15 = 0x8000
	// Disable
	IPC_INTEN_RECEIVE15_Disabled = 0x0
	// Enable
	IPC_INTEN_RECEIVE15_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of RECEIVE0 field.
	IPC_INTENSET_RECEIVE0_Pos = 0x0
	// Bit mask of RECEIVE0 field.
	IPC_INTENSET_RECEIVE0_Msk = 0x1
	// Bit RECEIVE0.
	IPC_INTENSET_RECEIVE0 = 0x1
	// Read: Disabled
	IPC_INTENSET_RECEIVE0_Disabled = 0x0
	// Read: Enabled
	IPC_INTENSET_RECEIVE0_Enabled = 0x1
	// Enable
	IPC_INTENSET_RECEIVE0_Set = 0x1
	// Position of RECEIVE1 field.
	IPC_INTENSET_RECEIVE1_Pos = 0x1
	// Bit mask of RECEIVE1 field.
	IPC_INTENSET_RECEIVE1_Msk = 0x2
	// Bit RECEIVE1.
	IPC_INTENSET_RECEIVE1 = 0x2
	// Read: Disabled
	IPC_INTENSET_RECEIVE1_Disabled = 0x0
	// Read: Enabled
	IPC_INTENSET_RECEIVE1_Enabled = 0x1
	// Enable
	IPC_INTENSET_RECEIVE1_Set = 0x1
	// Position of RECEIVE2 field.
	IPC_INTENSET_RECEIVE2_Pos = 0x2
	// Bit mask of RECEIVE2 field.
	IPC_INTENSET_RECEIVE2_Msk = 0x4
	// Bit RECEIVE2.
	IPC_INTENSET_RECEIVE2 = 0x4
	// Read: Disabled
	IPC_INTENSET_RECEIVE2_Disabled = 0x0
	// Read: Enabled
	IPC_INTENSET_RECEIVE2_Enabled = 0x1
	// Enable
	IPC_INTENSET_RECEIVE2_Set = 0x1
	// Position of RECEIVE3 field.
	IPC_INTENSET_RECEIVE3_Pos = 0x3
	// Bit mask of RECEIVE3 field.
	IPC_INTENSET_RECEIVE3_Msk = 0x8
	// Bit RECEIVE3.
	IPC_INTENSET_RECEIVE3 = 0x8
	// Read: Disabled
	IPC_INTENSET_RECEIVE3_Disabled = 0x0
	// Read: Enabled
	IPC_INTENSET_RECEIVE3_Enabled = 0x1
	// Enable
	IPC_INTENSET_RECEIVE3_Set = 0x1
	// Position of RECEIVE4 field.
	IPC_INTENSET_RECEIVE4_Pos = 0x4
	// Bit mask of RECEIVE4 field.
	IPC_INTENSET_RECEIVE4_Msk = 0x10
	// Bit RECEIVE4.
	IPC_INTENSET_RECEIVE4 = 0x10
	// Read: Disabled
	IPC_INTENSET_RECEIVE4_Disabled = 0x0
	// Read: Enabled
	IPC_INTENSET_RECEIVE4_Enabled = 0x1
	// Enable
	IPC_INTENSET_RECEIVE4_Set = 0x1
	// Position of RECEIVE5 field.
	IPC_INTENSET_RECEIVE5_Pos = 0x5
	// Bit mask of RECEIVE5 field.
	IPC_INTENSET_RECEIVE5_Msk = 0x20
	// Bit RECEIVE5.
	IPC_INTENSET_RECEIVE5 = 0x20
	// Read: Disabled
	IPC_INTENSET_RECEIVE5_Disabled = 0x0
	// Read: Enabled
	IPC_INTENSET_RECEIVE5_Enabled = 0x1
	// Enable
	IPC_INTENSET_RECEIVE5_Set = 0x1
	// Position of RECEIVE6 field.
	IPC_INTENSET_RECEIVE6_Pos = 0x6
	// Bit mask of RECEIVE6 field.
	IPC_INTENSET_RECEIVE6_Msk = 0x40
	// Bit RECEIVE6.
	IPC_INTENSET_RECEIVE6 = 0x40
	// Read: Disabled
	IPC_INTENSET_RECEIVE6_Disabled = 0x0
	// Read: Enabled
	IPC_INTENSET_RECEIVE6_Enabled = 0x1
	// Enable
	IPC_INTENSET_RECEIVE6_Set = 0x1
	// Position of RECEIVE7 field.
	IPC_INTENSET_RECEIVE7_Pos = 0x7
	// Bit mask of RECEIVE7 field.
	IPC_INTENSET_RECEIVE7_Msk = 0x80
	// Bit RECEIVE7.
	IPC_INTENSET_RECEIVE7 = 0x80
	// Read: Disabled
	IPC_INTENSET_RECEIVE7_Disabled = 0x0
	// Read: Enabled
	IPC_INTENSET_RECEIVE7_Enabled = 0x1
	// Enable
	IPC_INTENSET_RECEIVE7_Set = 0x1
	// Position of RECEIVE8 field.
	IPC_INTENSET_RECEIVE8_Pos = 0x8
	// Bit mask of RECEIVE8 field.
	IPC_INTENSET_RECEIVE8_Msk = 0x100
	// Bit RECEIVE8.
	IPC_INTENSET_RECEIVE8 = 0x100
	// Read: Disabled
	IPC_INTENSET_RECEIVE8_Disabled = 0x0
	// Read: Enabled
	IPC_INTENSET_RECEIVE8_Enabled = 0x1
	// Enable
	IPC_INTENSET_RECEIVE8_Set = 0x1
	// Position of RECEIVE9 field.
	IPC_INTENSET_RECEIVE9_Pos = 0x9
	// Bit mask of RECEIVE9 field.
	IPC_INTENSET_RECEIVE9_Msk = 0x200
	// Bit RECEIVE9.
	IPC_INTENSET_RECEIVE9 = 0x200
	// Read: Disabled
	IPC_INTENSET_RECEIVE9_Disabled = 0x0
	// Read: Enabled
	IPC_INTENSET_RECEIVE9_Enabled = 0x1
	// Enable
	IPC_INTENSET_RECEIVE9_Set = 0x1
	// Position of RECEIVE10 field.
	IPC_INTENSET_RECEIVE10_Pos = 0xa
	// Bit mask of RECEIVE10 field.
	IPC_INTENSET_RECEIVE10_Msk = 0x400
	// Bit RECEIVE10.
	IPC_INTENSET_RECEIVE10 = 0x400
	// Read: Disabled
	IPC_INTENSET_RECEIVE10_Disabled = 0x0
	// Read: Enabled
	IPC_INTENSET_RECEIVE10_Enabled = 0x1
	// Enable
	IPC_INTENSET_RECEIVE10_Set = 0x1
	// Position of RECEIVE11 field.
	IPC_INTENSET_RECEIVE11_Pos = 0xb
	// Bit mask of RECEIVE11 field.
	IPC_INTENSET_RECEIVE11_Msk = 0x800
	// Bit RECEIVE11.
	IPC_INTENSET_RECEIVE11 = 0x800
	// Read: Disabled
	IPC_INTENSET_RECEIVE11_Disabled = 0x0
	// Read: Enabled
	IPC_INTENSET_RECEIVE11_Enabled = 0x1
	// Enable
	IPC_INTENSET_RECEIVE11_Set = 0x1
	// Position of RECEIVE12 field.
	IPC_INTENSET_RECEIVE12_Pos = 0xc
	// Bit mask of RECEIVE12 field.
	IPC_INTENSET_RECEIVE12_Msk = 0x1000
	// Bit RECEIVE12.
	IPC_INTENSET_RECEIVE12 = 0x1000
	// Read: Disabled
	IPC_INTENSET_RECEIVE12_Disabled = 0x0
	// Read: Enabled
	IPC_INTENSET_RECEIVE12_Enabled = 0x1
	// Enable
	IPC_INTENSET_RECEIVE12_Set = 0x1
	// Position of RECEIVE13 field.
	IPC_INTENSET_RECEIVE13_Pos = 0xd
	// Bit mask of RECEIVE13 field.
	IPC_INTENSET_RECEIVE13_Msk = 0x2000
	// Bit RECEIVE13.
	IPC_INTENSET_RECEIVE13 = 0x2000
	// Read: Disabled
	IPC_INTENSET_RECEIVE13_Disabled = 0x0
	// Read: Enabled
	IPC_INTENSET_RECEIVE13_Enabled = 0x1
	// Enable
	IPC_INTENSET_RECEIVE13_Set = 0x1
	// Position of RECEIVE14 field.
	IPC_INTENSET_RECEIVE14_Pos = 0xe
	// Bit mask of RECEIVE14 field.
	IPC_INTENSET_RECEIVE14_Msk = 0x4000
	// Bit RECEIVE14.
	IPC_INTENSET_RECEIVE14 = 0x4000
	// Read: Disabled
	IPC_INTENSET_RECEIVE14_Disabled = 0x0
	// Read: Enabled
	IPC_INTENSET_RECEIVE14_Enabled = 0x1
	// Enable
	IPC_INTENSET_RECEIVE14_Set = 0x1
	// Position of RECEIVE15 field.
	IPC_INTENSET_RECEIVE15_Pos = 0xf
	// Bit mask of RECEIVE15 field.
	IPC_INTENSET_RECEIVE15_Msk = 0x8000
	// Bit RECEIVE15.
	IPC_INTENSET_RECEIVE15 = 0x8000
	// Read: Disabled
	IPC_INTENSET_RECEIVE15_Disabled = 0x0
	// Read: Enabled
	IPC_INTENSET_RECEIVE15_Enabled = 0x1
	// Enable
	IPC_INTENSET_RECEIVE15_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of RECEIVE0 field.
	IPC_INTENCLR_RECEIVE0_Pos = 0x0
	// Bit mask of RECEIVE0 field.
	IPC_INTENCLR_RECEIVE0_Msk = 0x1
	// Bit RECEIVE0.
	IPC_INTENCLR_RECEIVE0 = 0x1
	// Read: Disabled
	IPC_INTENCLR_RECEIVE0_Disabled = 0x0
	// Read: Enabled
	IPC_INTENCLR_RECEIVE0_Enabled = 0x1
	// Disable
	IPC_INTENCLR_RECEIVE0_Clear = 0x1
	// Position of RECEIVE1 field.
	IPC_INTENCLR_RECEIVE1_Pos = 0x1
	// Bit mask of RECEIVE1 field.
	IPC_INTENCLR_RECEIVE1_Msk = 0x2
	// Bit RECEIVE1.
	IPC_INTENCLR_RECEIVE1 = 0x2
	// Read: Disabled
	IPC_INTENCLR_RECEIVE1_Disabled = 0x0
	// Read: Enabled
	IPC_INTENCLR_RECEIVE1_Enabled = 0x1
	// Disable
	IPC_INTENCLR_RECEIVE1_Clear = 0x1
	// Position of RECEIVE2 field.
	IPC_INTENCLR_RECEIVE2_Pos = 0x2
	// Bit mask of RECEIVE2 field.
	IPC_INTENCLR_RECEIVE2_Msk = 0x4
	// Bit RECEIVE2.
	IPC_INTENCLR_RECEIVE2 = 0x4
	// Read: Disabled
	IPC_INTENCLR_RECEIVE2_Disabled = 0x0
	// Read: Enabled
	IPC_INTENCLR_RECEIVE2_Enabled = 0x1
	// Disable
	IPC_INTENCLR_RECEIVE2_Clear = 0x1
	// Position of RECEIVE3 field.
	IPC_INTENCLR_RECEIVE3_Pos = 0x3
	// Bit mask of RECEIVE3 field.
	IPC_INTENCLR_RECEIVE3_Msk = 0x8
	// Bit RECEIVE3.
	IPC_INTENCLR_RECEIVE3 = 0x8
	// Read: Disabled
	IPC_INTENCLR_RECEIVE3_Disabled = 0x0
	// Read: Enabled
	IPC_INTENCLR_RECEIVE3_Enabled = 0x1
	// Disable
	IPC_INTENCLR_RECEIVE3_Clear = 0x1
	// Position of RECEIVE4 field.
	IPC_INTENCLR_RECEIVE4_Pos = 0x4
	// Bit mask of RECEIVE4 field.
	IPC_INTENCLR_RECEIVE4_Msk = 0x10
	// Bit RECEIVE4.
	IPC_INTENCLR_RECEIVE4 = 0x10
	// Read: Disabled
	IPC_INTENCLR_RECEIVE4_Disabled = 0x0
	// Read: Enabled
	IPC_INTENCLR_RECEIVE4_Enabled = 0x1
	// Disable
	IPC_INTENCLR_RECEIVE4_Clear = 0x1
	// Position of RECEIVE5 field.
	IPC_INTENCLR_RECEIVE5_Pos = 0x5
	// Bit mask of RECEIVE5 field.
	IPC_INTENCLR_RECEIVE5_Msk = 0x20
	// Bit RECEIVE5.
	IPC_INTENCLR_RECEIVE5 = 0x20
	// Read: Disabled
	IPC_INTENCLR_RECEIVE5_Disabled = 0x0
	// Read: Enabled
	IPC_INTENCLR_RECEIVE5_Enabled = 0x1
	// Disable
	IPC_INTENCLR_RECEIVE5_Clear = 0x1
	// Position of RECEIVE6 field.
	IPC_INTENCLR_RECEIVE6_Pos = 0x6
	// Bit mask of RECEIVE6 field.
	IPC_INTENCLR_RECEIVE6_Msk = 0x40
	// Bit RECEIVE6.
	IPC_INTENCLR_RECEIVE6 = 0x40
	// Read: Disabled
	IPC_INTENCLR_RECEIVE6_Disabled = 0x0
	// Read: Enabled
	IPC_INTENCLR_RECEIVE6_Enabled = 0x1
	// Disable
	IPC_INTENCLR_RECEIVE6_Clear = 0x1
	// Position of RECEIVE7 field.
	IPC_INTENCLR_RECEIVE7_Pos = 0x7
	// Bit mask of RECEIVE7 field.
	IPC_INTENCLR_RECEIVE7_Msk = 0x80
	// Bit RECEIVE7.
	IPC_INTENCLR_RECEIVE7 = 0x80
	// Read: Disabled
	IPC_INTENCLR_RECEIVE7_Disabled = 0x0
	// Read: Enabled
	IPC_INTENCLR_RECEIVE7_Enabled = 0x1
	// Disable
	IPC_INTENCLR_RECEIVE7_Clear = 0x1
	// Position of RECEIVE8 field.
	IPC_INTENCLR_RECEIVE8_Pos = 0x8
	// Bit mask of RECEIVE8 field.
	IPC_INTENCLR_RECEIVE8_Msk = 0x100
	// Bit RECEIVE8.
	IPC_INTENCLR_RECEIVE8 = 0x100
	// Read: Disabled
	IPC_INTENCLR_RECEIVE8_Disabled = 0x0
	// Read: Enabled
	IPC_INTENCLR_RECEIVE8_Enabled = 0x1
	// Disable
	IPC_INTENCLR_RECEIVE8_Clear = 0x1
	// Position of RECEIVE9 field.
	IPC_INTENCLR_RECEIVE9_Pos = 0x9
	// Bit mask of RECEIVE9 field.
	IPC_INTENCLR_RECEIVE9_Msk = 0x200
	// Bit RECEIVE9.
	IPC_INTENCLR_RECEIVE9 = 0x200
	// Read: Disabled
	IPC_INTENCLR_RECEIVE9_Disabled = 0x0
	// Read: Enabled
	IPC_INTENCLR_RECEIVE9_Enabled = 0x1
	// Disable
	IPC_INTENCLR_RECEIVE9_Clear = 0x1
	// Position of RECEIVE10 field.
	IPC_INTENCLR_RECEIVE10_Pos = 0xa
	// Bit mask of RECEIVE10 field.
	IPC_INTENCLR_RECEIVE10_Msk = 0x400
	// Bit RECEIVE10.
	IPC_INTENCLR_RECEIVE10 = 0x400
	// Read: Disabled
	IPC_INTENCLR_RECEIVE10_Disabled = 0x0
	// Read: Enabled
	IPC_INTENCLR_RECEIVE10_Enabled = 0x1
	// Disable
	IPC_INTENCLR_RECEIVE10_Clear = 0x1
	// Position of RECEIVE11 field.
	IPC_INTENCLR_RECEIVE11_Pos = 0xb
	// Bit mask of RECEIVE11 field.
	IPC_INTENCLR_RECEIVE11_Msk = 0x800
	// Bit RECEIVE11.
	IPC_INTENCLR_RECEIVE11 = 0x800
	// Read: Disabled
	IPC_INTENCLR_RECEIVE11_Disabled = 0x0
	// Read: Enabled
	IPC_INTENCLR_RECEIVE11_Enabled = 0x1
	// Disable
	IPC_INTENCLR_RECEIVE11_Clear = 0x1
	// Position of RECEIVE12 field.
	IPC_INTENCLR_RECEIVE12_Pos = 0xc
	// Bit mask of RECEIVE12 field.
	IPC_INTENCLR_RECEIVE12_Msk = 0x1000
	// Bit RECEIVE12.
	IPC_INTENCLR_RECEIVE12 = 0x1000
	// Read: Disabled
	IPC_INTENCLR_RECEIVE12_Disabled = 0x0
	// Read: Enabled
	IPC_INTENCLR_RECEIVE12_Enabled = 0x1
	// Disable
	IPC_INTENCLR_RECEIVE12_Clear = 0x1
	// Position of RECEIVE13 field.
	IPC_INTENCLR_RECEIVE13_Pos = 0xd
	// Bit mask of RECEIVE13 field.
	IPC_INTENCLR_RECEIVE13_Msk = 0x2000
	// Bit RECEIVE13.
	IPC_INTENCLR_RECEIVE13 = 0x2000
	// Read: Disabled
	IPC_INTENCLR_RECEIVE13_Disabled = 0x0
	// Read: Enabled
	IPC_INTENCLR_RECEIVE13_Enabled = 0x1
	// Disable
	IPC_INTENCLR_RECEIVE13_Clear = 0x1
	// Position of RECEIVE14 field.
	IPC_INTENCLR_RECEIVE14_Pos = 0xe
	// Bit mask of RECEIVE14 field.
	IPC_INTENCLR_RECEIVE14_Msk = 0x4000
	// Bit RECEIVE14.
	IPC_INTENCLR_RECEIVE14 = 0x4000
	// Read: Disabled
	IPC_INTENCLR_RECEIVE14_Disabled = 0x0
	// Read: Enabled
	IPC_INTENCLR_RECEIVE14_Enabled = 0x1
	// Disable
	IPC_INTENCLR_RECEIVE14_Clear = 0x1
	// Position of RECEIVE15 field.
	IPC_INTENCLR_RECEIVE15_Pos = 0xf
	// Bit mask of RECEIVE15 field.
	IPC_INTENCLR_RECEIVE15_Msk = 0x8000
	// Bit RECEIVE15.
	IPC_INTENCLR_RECEIVE15 = 0x8000
	// Read: Disabled
	IPC_INTENCLR_RECEIVE15_Disabled = 0x0
	// Read: Enabled
	IPC_INTENCLR_RECEIVE15_Enabled = 0x1
	// Disable
	IPC_INTENCLR_RECEIVE15_Clear = 0x1

	// INTPEND: Pending interrupts
	// Position of RECEIVE0 field.
	IPC_INTPEND_RECEIVE0_Pos = 0x0
	// Bit mask of RECEIVE0 field.
	IPC_INTPEND_RECEIVE0_Msk = 0x1
	// Bit RECEIVE0.
	IPC_INTPEND_RECEIVE0 = 0x1
	// Read: Not pending
	IPC_INTPEND_RECEIVE0_NotPending = 0x0
	// Read: Pending
	IPC_INTPEND_RECEIVE0_Pending = 0x1
	// Position of RECEIVE1 field.
	IPC_INTPEND_RECEIVE1_Pos = 0x1
	// Bit mask of RECEIVE1 field.
	IPC_INTPEND_RECEIVE1_Msk = 0x2
	// Bit RECEIVE1.
	IPC_INTPEND_RECEIVE1 = 0x2
	// Read: Not pending
	IPC_INTPEND_RECEIVE1_NotPending = 0x0
	// Read: Pending
	IPC_INTPEND_RECEIVE1_Pending = 0x1
	// Position of RECEIVE2 field.
	IPC_INTPEND_RECEIVE2_Pos = 0x2
	// Bit mask of RECEIVE2 field.
	IPC_INTPEND_RECEIVE2_Msk = 0x4
	// Bit RECEIVE2.
	IPC_INTPEND_RECEIVE2 = 0x4
	// Read: Not pending
	IPC_INTPEND_RECEIVE2_NotPending = 0x0
	// Read: Pending
	IPC_INTPEND_RECEIVE2_Pending = 0x1
	// Position of RECEIVE3 field.
	IPC_INTPEND_RECEIVE3_Pos = 0x3
	// Bit mask of RECEIVE3 field.
	IPC_INTPEND_RECEIVE3_Msk = 0x8
	// Bit RECEIVE3.
	IPC_INTPEND_RECEIVE3 = 0x8
	// Read: Not pending
	IPC_INTPEND_RECEIVE3_NotPending = 0x0
	// Read: Pending
	IPC_INTPEND_RECEIVE3_Pending = 0x1
	// Position of RECEIVE4 field.
	IPC_INTPEND_RECEIVE4_Pos = 0x4
	// Bit mask of RECEIVE4 field.
	IPC_INTPEND_RECEIVE4_Msk = 0x10
	// Bit RECEIVE4.
	IPC_INTPEND_RECEIVE4 = 0x10
	// Read: Not pending
	IPC_INTPEND_RECEIVE4_NotPending = 0x0
	// Read: Pending
	IPC_INTPEND_RECEIVE4_Pending = 0x1
	// Position of RECEIVE5 field.
	IPC_INTPEND_RECEIVE5_Pos = 0x5
	// Bit mask of RECEIVE5 field.
	IPC_INTPEND_RECEIVE5_Msk = 0x20
	// Bit RECEIVE5.
	IPC_INTPEND_RECEIVE5 = 0x20
	// Read: Not pending
	IPC_INTPEND_RECEIVE5_NotPending = 0x0
	// Read: Pending
	IPC_INTPEND_RECEIVE5_Pending = 0x1
	// Position of RECEIVE6 field.
	IPC_INTPEND_RECEIVE6_Pos = 0x6
	// Bit mask of RECEIVE6 field.
	IPC_INTPEND_RECEIVE6_Msk = 0x40
	// Bit RECEIVE6.
	IPC_INTPEND_RECEIVE6 = 0x40
	// Read: Not pending
	IPC_INTPEND_RECEIVE6_NotPending = 0x0
	// Read: Pending
	IPC_INTPEND_RECEIVE6_Pending = 0x1
	// Position of RECEIVE7 field.
	IPC_INTPEND_RECEIVE7_Pos = 0x7
	// Bit mask of RECEIVE7 field.
	IPC_INTPEND_RECEIVE7_Msk = 0x80
	// Bit RECEIVE7.
	IPC_INTPEND_RECEIVE7 = 0x80
	// Read: Not pending
	IPC_INTPEND_RECEIVE7_NotPending = 0x0
	// Read: Pending
	IPC_INTPEND_RECEIVE7_Pending = 0x1
	// Position of RECEIVE8 field.
	IPC_INTPEND_RECEIVE8_Pos = 0x8
	// Bit mask of RECEIVE8 field.
	IPC_INTPEND_RECEIVE8_Msk = 0x100
	// Bit RECEIVE8.
	IPC_INTPEND_RECEIVE8 = 0x100
	// Read: Not pending
	IPC_INTPEND_RECEIVE8_NotPending = 0x0
	// Read: Pending
	IPC_INTPEND_RECEIVE8_Pending = 0x1
	// Position of RECEIVE9 field.
	IPC_INTPEND_RECEIVE9_Pos = 0x9
	// Bit mask of RECEIVE9 field.
	IPC_INTPEND_RECEIVE9_Msk = 0x200
	// Bit RECEIVE9.
	IPC_INTPEND_RECEIVE9 = 0x200
	// Read: Not pending
	IPC_INTPEND_RECEIVE9_NotPending = 0x0
	// Read: Pending
	IPC_INTPEND_RECEIVE9_Pending = 0x1
	// Position of RECEIVE10 field.
	IPC_INTPEND_RECEIVE10_Pos = 0xa
	// Bit mask of RECEIVE10 field.
	IPC_INTPEND_RECEIVE10_Msk = 0x400
	// Bit RECEIVE10.
	IPC_INTPEND_RECEIVE10 = 0x400
	// Read: Not pending
	IPC_INTPEND_RECEIVE10_NotPending = 0x0
	// Read: Pending
	IPC_INTPEND_RECEIVE10_Pending = 0x1
	// Position of RECEIVE11 field.
	IPC_INTPEND_RECEIVE11_Pos = 0xb
	// Bit mask of RECEIVE11 field.
	IPC_INTPEND_RECEIVE11_Msk = 0x800
	// Bit RECEIVE11.
	IPC_INTPEND_RECEIVE11 = 0x800
	// Read: Not pending
	IPC_INTPEND_RECEIVE11_NotPending = 0x0
	// Read: Pending
	IPC_INTPEND_RECEIVE11_Pending = 0x1
	// Position of RECEIVE12 field.
	IPC_INTPEND_RECEIVE12_Pos = 0xc
	// Bit mask of RECEIVE12 field.
	IPC_INTPEND_RECEIVE12_Msk = 0x1000
	// Bit RECEIVE12.
	IPC_INTPEND_RECEIVE12 = 0x1000
	// Read: Not pending
	IPC_INTPEND_RECEIVE12_NotPending = 0x0
	// Read: Pending
	IPC_INTPEND_RECEIVE12_Pending = 0x1
	// Position of RECEIVE13 field.
	IPC_INTPEND_RECEIVE13_Pos = 0xd
	// Bit mask of RECEIVE13 field.
	IPC_INTPEND_RECEIVE13_Msk = 0x2000
	// Bit RECEIVE13.
	IPC_INTPEND_RECEIVE13 = 0x2000
	// Read: Not pending
	IPC_INTPEND_RECEIVE13_NotPending = 0x0
	// Read: Pending
	IPC_INTPEND_RECEIVE13_Pending = 0x1
	// Position of RECEIVE14 field.
	IPC_INTPEND_RECEIVE14_Pos = 0xe
	// Bit mask of RECEIVE14 field.
	IPC_INTPEND_RECEIVE14_Msk = 0x4000
	// Bit RECEIVE14.
	IPC_INTPEND_RECEIVE14 = 0x4000
	// Read: Not pending
	IPC_INTPEND_RECEIVE14_NotPending = 0x0
	// Read: Pending
	IPC_INTPEND_RECEIVE14_Pending = 0x1
	// Position of RECEIVE15 field.
	IPC_INTPEND_RECEIVE15_Pos = 0xf
	// Bit mask of RECEIVE15 field.
	IPC_INTPEND_RECEIVE15_Msk = 0x8000
	// Bit RECEIVE15.
	IPC_INTPEND_RECEIVE15 = 0x8000
	// Read: Not pending
	IPC_INTPEND_RECEIVE15_NotPending = 0x0
	// Read: Pending
	IPC_INTPEND_RECEIVE15_Pending = 0x1

	// SEND_CNF: Description collection: Send event configuration for TASKS_SEND[n]
	// Position of CHEN0 field.
	IPC_SEND_CNF_CHEN0_Pos = 0x0
	// Bit mask of CHEN0 field.
	IPC_SEND_CNF_CHEN0_Msk = 0x1
	// Bit CHEN0.
	IPC_SEND_CNF_CHEN0 = 0x1
	// Disable broadcast
	IPC_SEND_CNF_CHEN0_Disable = 0x0
	// Enable broadcast
	IPC_SEND_CNF_CHEN0_Enable = 0x1
	// Position of CHEN1 field.
	IPC_SEND_CNF_CHEN1_Pos = 0x1
	// Bit mask of CHEN1 field.
	IPC_SEND_CNF_CHEN1_Msk = 0x2
	// Bit CHEN1.
	IPC_SEND_CNF_CHEN1 = 0x2
	// Disable broadcast
	IPC_SEND_CNF_CHEN1_Disable = 0x0
	// Enable broadcast
	IPC_SEND_CNF_CHEN1_Enable = 0x1
	// Position of CHEN2 field.
	IPC_SEND_CNF_CHEN2_Pos = 0x2
	// Bit mask of CHEN2 field.
	IPC_SEND_CNF_CHEN2_Msk = 0x4
	// Bit CHEN2.
	IPC_SEND_CNF_CHEN2 = 0x4
	// Disable broadcast
	IPC_SEND_CNF_CHEN2_Disable = 0x0
	// Enable broadcast
	IPC_SEND_CNF_CHEN2_Enable = 0x1
	// Position of CHEN3 field.
	IPC_SEND_CNF_CHEN3_Pos = 0x3
	// Bit mask of CHEN3 field.
	IPC_SEND_CNF_CHEN3_Msk = 0x8
	// Bit CHEN3.
	IPC_SEND_CNF_CHEN3 = 0x8
	// Disable broadcast
	IPC_SEND_CNF_CHEN3_Disable = 0x0
	// Enable broadcast
	IPC_SEND_CNF_CHEN3_Enable = 0x1
	// Position of CHEN4 field.
	IPC_SEND_CNF_CHEN4_Pos = 0x4
	// Bit mask of CHEN4 field.
	IPC_SEND_CNF_CHEN4_Msk = 0x10
	// Bit CHEN4.
	IPC_SEND_CNF_CHEN4 = 0x10
	// Disable broadcast
	IPC_SEND_CNF_CHEN4_Disable = 0x0
	// Enable broadcast
	IPC_SEND_CNF_CHEN4_Enable = 0x1
	// Position of CHEN5 field.
	IPC_SEND_CNF_CHEN5_Pos = 0x5
	// Bit mask of CHEN5 field.
	IPC_SEND_CNF_CHEN5_Msk = 0x20
	// Bit CHEN5.
	IPC_SEND_CNF_CHEN5 = 0x20
	// Disable broadcast
	IPC_SEND_CNF_CHEN5_Disable = 0x0
	// Enable broadcast
	IPC_SEND_CNF_CHEN5_Enable = 0x1
	// Position of CHEN6 field.
	IPC_SEND_CNF_CHEN6_Pos = 0x6
	// Bit mask of CHEN6 field.
	IPC_SEND_CNF_CHEN6_Msk = 0x40
	// Bit CHEN6.
	IPC_SEND_CNF_CHEN6 = 0x40
	// Disable broadcast
	IPC_SEND_CNF_CHEN6_Disable = 0x0
	// Enable broadcast
	IPC_SEND_CNF_CHEN6_Enable = 0x1
	// Position of CHEN7 field.
	IPC_SEND_CNF_CHEN7_Pos = 0x7
	// Bit mask of CHEN7 field.
	IPC_SEND_CNF_CHEN7_Msk = 0x80
	// Bit CHEN7.
	IPC_SEND_CNF_CHEN7 = 0x80
	// Disable broadcast
	IPC_SEND_CNF_CHEN7_Disable = 0x0
	// Enable broadcast
	IPC_SEND_CNF_CHEN7_Enable = 0x1
	// Position of CHEN8 field.
	IPC_SEND_CNF_CHEN8_Pos = 0x8
	// Bit mask of CHEN8 field.
	IPC_SEND_CNF_CHEN8_Msk = 0x100
	// Bit CHEN8.
	IPC_SEND_CNF_CHEN8 = 0x100
	// Disable broadcast
	IPC_SEND_CNF_CHEN8_Disable = 0x0
	// Enable broadcast
	IPC_SEND_CNF_CHEN8_Enable = 0x1
	// Position of CHEN9 field.
	IPC_SEND_CNF_CHEN9_Pos = 0x9
	// Bit mask of CHEN9 field.
	IPC_SEND_CNF_CHEN9_Msk = 0x200
	// Bit CHEN9.
	IPC_SEND_CNF_CHEN9 = 0x200
	// Disable broadcast
	IPC_SEND_CNF_CHEN9_Disable = 0x0
	// Enable broadcast
	IPC_SEND_CNF_CHEN9_Enable = 0x1
	// Position of CHEN10 field.
	IPC_SEND_CNF_CHEN10_Pos = 0xa
	// Bit mask of CHEN10 field.
	IPC_SEND_CNF_CHEN10_Msk = 0x400
	// Bit CHEN10.
	IPC_SEND_CNF_CHEN10 = 0x400
	// Disable broadcast
	IPC_SEND_CNF_CHEN10_Disable = 0x0
	// Enable broadcast
	IPC_SEND_CNF_CHEN10_Enable = 0x1
	// Position of CHEN11 field.
	IPC_SEND_CNF_CHEN11_Pos = 0xb
	// Bit mask of CHEN11 field.
	IPC_SEND_CNF_CHEN11_Msk = 0x800
	// Bit CHEN11.
	IPC_SEND_CNF_CHEN11 = 0x800
	// Disable broadcast
	IPC_SEND_CNF_CHEN11_Disable = 0x0
	// Enable broadcast
	IPC_SEND_CNF_CHEN11_Enable = 0x1
	// Position of CHEN12 field.
	IPC_SEND_CNF_CHEN12_Pos = 0xc
	// Bit mask of CHEN12 field.
	IPC_SEND_CNF_CHEN12_Msk = 0x1000
	// Bit CHEN12.
	IPC_SEND_CNF_CHEN12 = 0x1000
	// Disable broadcast
	IPC_SEND_CNF_CHEN12_Disable = 0x0
	// Enable broadcast
	IPC_SEND_CNF_CHEN12_Enable = 0x1
	// Position of CHEN13 field.
	IPC_SEND_CNF_CHEN13_Pos = 0xd
	// Bit mask of CHEN13 field.
	IPC_SEND_CNF_CHEN13_Msk = 0x2000
	// Bit CHEN13.
	IPC_SEND_CNF_CHEN13 = 0x2000
	// Disable broadcast
	IPC_SEND_CNF_CHEN13_Disable = 0x0
	// Enable broadcast
	IPC_SEND_CNF_CHEN13_Enable = 0x1
	// Position of CHEN14 field.
	IPC_SEND_CNF_CHEN14_Pos = 0xe
	// Bit mask of CHEN14 field.
	IPC_SEND_CNF_CHEN14_Msk = 0x4000
	// Bit CHEN14.
	IPC_SEND_CNF_CHEN14 = 0x4000
	// Disable broadcast
	IPC_SEND_CNF_CHEN14_Disable = 0x0
	// Enable broadcast
	IPC_SEND_CNF_CHEN14_Enable = 0x1
	// Position of CHEN15 field.
	IPC_SEND_CNF_CHEN15_Pos = 0xf
	// Bit mask of CHEN15 field.
	IPC_SEND_CNF_CHEN15_Msk = 0x8000
	// Bit CHEN15.
	IPC_SEND_CNF_CHEN15 = 0x8000
	// Disable broadcast
	IPC_SEND_CNF_CHEN15_Disable = 0x0
	// Enable broadcast
	IPC_SEND_CNF_CHEN15_Enable = 0x1

	// RECEIVE_CNF: Description collection: Receive event configuration for EVENTS_RECEIVE[n]
	// Position of CHEN0 field.
	IPC_RECEIVE_CNF_CHEN0_Pos = 0x0
	// Bit mask of CHEN0 field.
	IPC_RECEIVE_CNF_CHEN0_Msk = 0x1
	// Bit CHEN0.
	IPC_RECEIVE_CNF_CHEN0 = 0x1
	// Disable events
	IPC_RECEIVE_CNF_CHEN0_Disable = 0x0
	// Enable events
	IPC_RECEIVE_CNF_CHEN0_Enable = 0x1
	// Position of CHEN1 field.
	IPC_RECEIVE_CNF_CHEN1_Pos = 0x1
	// Bit mask of CHEN1 field.
	IPC_RECEIVE_CNF_CHEN1_Msk = 0x2
	// Bit CHEN1.
	IPC_RECEIVE_CNF_CHEN1 = 0x2
	// Disable events
	IPC_RECEIVE_CNF_CHEN1_Disable = 0x0
	// Enable events
	IPC_RECEIVE_CNF_CHEN1_Enable = 0x1
	// Position of CHEN2 field.
	IPC_RECEIVE_CNF_CHEN2_Pos = 0x2
	// Bit mask of CHEN2 field.
	IPC_RECEIVE_CNF_CHEN2_Msk = 0x4
	// Bit CHEN2.
	IPC_RECEIVE_CNF_CHEN2 = 0x4
	// Disable events
	IPC_RECEIVE_CNF_CHEN2_Disable = 0x0
	// Enable events
	IPC_RECEIVE_CNF_CHEN2_Enable = 0x1
	// Position of CHEN3 field.
	IPC_RECEIVE_CNF_CHEN3_Pos = 0x3
	// Bit mask of CHEN3 field.
	IPC_RECEIVE_CNF_CHEN3_Msk = 0x8
	// Bit CHEN3.
	IPC_RECEIVE_CNF_CHEN3 = 0x8
	// Disable events
	IPC_RECEIVE_CNF_CHEN3_Disable = 0x0
	// Enable events
	IPC_RECEIVE_CNF_CHEN3_Enable = 0x1
	// Position of CHEN4 field.
	IPC_RECEIVE_CNF_CHEN4_Pos = 0x4
	// Bit mask of CHEN4 field.
	IPC_RECEIVE_CNF_CHEN4_Msk = 0x10
	// Bit CHEN4.
	IPC_RECEIVE_CNF_CHEN4 = 0x10
	// Disable events
	IPC_RECEIVE_CNF_CHEN4_Disable = 0x0
	// Enable events
	IPC_RECEIVE_CNF_CHEN4_Enable = 0x1
	// Position of CHEN5 field.
	IPC_RECEIVE_CNF_CHEN5_Pos = 0x5
	// Bit mask of CHEN5 field.
	IPC_RECEIVE_CNF_CHEN5_Msk = 0x20
	// Bit CHEN5.
	IPC_RECEIVE_CNF_CHEN5 = 0x20
	// Disable events
	IPC_RECEIVE_CNF_CHEN5_Disable = 0x0
	// Enable events
	IPC_RECEIVE_CNF_CHEN5_Enable = 0x1
	// Position of CHEN6 field.
	IPC_RECEIVE_CNF_CHEN6_Pos = 0x6
	// Bit mask of CHEN6 field.
	IPC_RECEIVE_CNF_CHEN6_Msk = 0x40
	// Bit CHEN6.
	IPC_RECEIVE_CNF_CHEN6 = 0x40
	// Disable events
	IPC_RECEIVE_CNF_CHEN6_Disable = 0x0
	// Enable events
	IPC_RECEIVE_CNF_CHEN6_Enable = 0x1
	// Position of CHEN7 field.
	IPC_RECEIVE_CNF_CHEN7_Pos = 0x7
	// Bit mask of CHEN7 field.
	IPC_RECEIVE_CNF_CHEN7_Msk = 0x80
	// Bit CHEN7.
	IPC_RECEIVE_CNF_CHEN7 = 0x80
	// Disable events
	IPC_RECEIVE_CNF_CHEN7_Disable = 0x0
	// Enable events
	IPC_RECEIVE_CNF_CHEN7_Enable = 0x1
	// Position of CHEN8 field.
	IPC_RECEIVE_CNF_CHEN8_Pos = 0x8
	// Bit mask of CHEN8 field.
	IPC_RECEIVE_CNF_CHEN8_Msk = 0x100
	// Bit CHEN8.
	IPC_RECEIVE_CNF_CHEN8 = 0x100
	// Disable events
	IPC_RECEIVE_CNF_CHEN8_Disable = 0x0
	// Enable events
	IPC_RECEIVE_CNF_CHEN8_Enable = 0x1
	// Position of CHEN9 field.
	IPC_RECEIVE_CNF_CHEN9_Pos = 0x9
	// Bit mask of CHEN9 field.
	IPC_RECEIVE_CNF_CHEN9_Msk = 0x200
	// Bit CHEN9.
	IPC_RECEIVE_CNF_CHEN9 = 0x200
	// Disable events
	IPC_RECEIVE_CNF_CHEN9_Disable = 0x0
	// Enable events
	IPC_RECEIVE_CNF_CHEN9_Enable = 0x1
	// Position of CHEN10 field.
	IPC_RECEIVE_CNF_CHEN10_Pos = 0xa
	// Bit mask of CHEN10 field.
	IPC_RECEIVE_CNF_CHEN10_Msk = 0x400
	// Bit CHEN10.
	IPC_RECEIVE_CNF_CHEN10 = 0x400
	// Disable events
	IPC_RECEIVE_CNF_CHEN10_Disable = 0x0
	// Enable events
	IPC_RECEIVE_CNF_CHEN10_Enable = 0x1
	// Position of CHEN11 field.
	IPC_RECEIVE_CNF_CHEN11_Pos = 0xb
	// Bit mask of CHEN11 field.
	IPC_RECEIVE_CNF_CHEN11_Msk = 0x800
	// Bit CHEN11.
	IPC_RECEIVE_CNF_CHEN11 = 0x800
	// Disable events
	IPC_RECEIVE_CNF_CHEN11_Disable = 0x0
	// Enable events
	IPC_RECEIVE_CNF_CHEN11_Enable = 0x1
	// Position of CHEN12 field.
	IPC_RECEIVE_CNF_CHEN12_Pos = 0xc
	// Bit mask of CHEN12 field.
	IPC_RECEIVE_CNF_CHEN12_Msk = 0x1000
	// Bit CHEN12.
	IPC_RECEIVE_CNF_CHEN12 = 0x1000
	// Disable events
	IPC_RECEIVE_CNF_CHEN12_Disable = 0x0
	// Enable events
	IPC_RECEIVE_CNF_CHEN12_Enable = 0x1
	// Position of CHEN13 field.
	IPC_RECEIVE_CNF_CHEN13_Pos = 0xd
	// Bit mask of CHEN13 field.
	IPC_RECEIVE_CNF_CHEN13_Msk = 0x2000
	// Bit CHEN13.
	IPC_RECEIVE_CNF_CHEN13 = 0x2000
	// Disable events
	IPC_RECEIVE_CNF_CHEN13_Disable = 0x0
	// Enable events
	IPC_RECEIVE_CNF_CHEN13_Enable = 0x1
	// Position of CHEN14 field.
	IPC_RECEIVE_CNF_CHEN14_Pos = 0xe
	// Bit mask of CHEN14 field.
	IPC_RECEIVE_CNF_CHEN14_Msk = 0x4000
	// Bit CHEN14.
	IPC_RECEIVE_CNF_CHEN14 = 0x4000
	// Disable events
	IPC_RECEIVE_CNF_CHEN14_Disable = 0x0
	// Enable events
	IPC_RECEIVE_CNF_CHEN14_Enable = 0x1
	// Position of CHEN15 field.
	IPC_RECEIVE_CNF_CHEN15_Pos = 0xf
	// Bit mask of CHEN15 field.
	IPC_RECEIVE_CNF_CHEN15_Msk = 0x8000
	// Bit CHEN15.
	IPC_RECEIVE_CNF_CHEN15 = 0x8000
	// Disable events
	IPC_RECEIVE_CNF_CHEN15_Disable = 0x0
	// Enable events
	IPC_RECEIVE_CNF_CHEN15_Enable = 0x1

	// GPMEM: Description collection: General purpose memory
	// Position of GPMEM field.
	IPC_GPMEM_GPMEM_Pos = 0x0
	// Bit mask of GPMEM field.
	IPC_GPMEM_GPMEM_Msk = 0xffffffff
)

// Bitfields for SPIM0_NS: Serial Peripheral Interface Master with EasyDMA
const (
	// TASKS_START: Start SPI transaction
	// Position of TASKS_START field.
	SPIM_TASKS_START_TASKS_START_Pos = 0x0
	// Bit mask of TASKS_START field.
	SPIM_TASKS_START_TASKS_START_Msk = 0x1
	// Bit TASKS_START.
	SPIM_TASKS_START_TASKS_START = 0x1
	// Trigger task
	SPIM_TASKS_START_TASKS_START_Trigger = 0x1

	// TASKS_STOP: Stop SPI transaction
	// Position of TASKS_STOP field.
	SPIM_TASKS_STOP_TASKS_STOP_Pos = 0x0
	// Bit mask of TASKS_STOP field.
	SPIM_TASKS_STOP_TASKS_STOP_Msk = 0x1
	// Bit TASKS_STOP.
	SPIM_TASKS_STOP_TASKS_STOP = 0x1
	// Trigger task
	SPIM_TASKS_STOP_TASKS_STOP_Trigger = 0x1

	// TASKS_SUSPEND: Suspend SPI transaction
	// Position of TASKS_SUSPEND field.
	SPIM_TASKS_SUSPEND_TASKS_SUSPEND_Pos = 0x0
	// Bit mask of TASKS_SUSPEND field.
	SPIM_TASKS_SUSPEND_TASKS_SUSPEND_Msk = 0x1
	// Bit TASKS_SUSPEND.
	SPIM_TASKS_SUSPEND_TASKS_SUSPEND = 0x1
	// Trigger task
	SPIM_TASKS_SUSPEND_TASKS_SUSPEND_Trigger = 0x1

	// TASKS_RESUME: Resume SPI transaction
	// Position of TASKS_RESUME field.
	SPIM_TASKS_RESUME_TASKS_RESUME_Pos = 0x0
	// Bit mask of TASKS_RESUME field.
	SPIM_TASKS_RESUME_TASKS_RESUME_Msk = 0x1
	// Bit TASKS_RESUME.
	SPIM_TASKS_RESUME_TASKS_RESUME = 0x1
	// Trigger task
	SPIM_TASKS_RESUME_TASKS_RESUME_Trigger = 0x1

	// SUBSCRIBE_START: Subscribe configuration for task START
	// Position of CHIDX field.
	SPIM_SUBSCRIBE_START_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SPIM_SUBSCRIBE_START_CHIDX_Msk = 0xff
	// Position of EN field.
	SPIM_SUBSCRIBE_START_EN_Pos = 0x1f
	// Bit mask of EN field.
	SPIM_SUBSCRIBE_START_EN_Msk = 0x80000000
	// Bit EN.
	SPIM_SUBSCRIBE_START_EN = 0x80000000
	// Disable subscription
	SPIM_SUBSCRIBE_START_EN_Disabled = 0x0
	// Enable subscription
	SPIM_SUBSCRIBE_START_EN_Enabled = 0x1

	// SUBSCRIBE_STOP: Subscribe configuration for task STOP
	// Position of CHIDX field.
	SPIM_SUBSCRIBE_STOP_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SPIM_SUBSCRIBE_STOP_CHIDX_Msk = 0xff
	// Position of EN field.
	SPIM_SUBSCRIBE_STOP_EN_Pos = 0x1f
	// Bit mask of EN field.
	SPIM_SUBSCRIBE_STOP_EN_Msk = 0x80000000
	// Bit EN.
	SPIM_SUBSCRIBE_STOP_EN = 0x80000000
	// Disable subscription
	SPIM_SUBSCRIBE_STOP_EN_Disabled = 0x0
	// Enable subscription
	SPIM_SUBSCRIBE_STOP_EN_Enabled = 0x1

	// SUBSCRIBE_SUSPEND: Subscribe configuration for task SUSPEND
	// Position of CHIDX field.
	SPIM_SUBSCRIBE_SUSPEND_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SPIM_SUBSCRIBE_SUSPEND_CHIDX_Msk = 0xff
	// Position of EN field.
	SPIM_SUBSCRIBE_SUSPEND_EN_Pos = 0x1f
	// Bit mask of EN field.
	SPIM_SUBSCRIBE_SUSPEND_EN_Msk = 0x80000000
	// Bit EN.
	SPIM_SUBSCRIBE_SUSPEND_EN = 0x80000000
	// Disable subscription
	SPIM_SUBSCRIBE_SUSPEND_EN_Disabled = 0x0
	// Enable subscription
	SPIM_SUBSCRIBE_SUSPEND_EN_Enabled = 0x1

	// SUBSCRIBE_RESUME: Subscribe configuration for task RESUME
	// Position of CHIDX field.
	SPIM_SUBSCRIBE_RESUME_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SPIM_SUBSCRIBE_RESUME_CHIDX_Msk = 0xff
	// Position of EN field.
	SPIM_SUBSCRIBE_RESUME_EN_Pos = 0x1f
	// Bit mask of EN field.
	SPIM_SUBSCRIBE_RESUME_EN_Msk = 0x80000000
	// Bit EN.
	SPIM_SUBSCRIBE_RESUME_EN = 0x80000000
	// Disable subscription
	SPIM_SUBSCRIBE_RESUME_EN_Disabled = 0x0
	// Enable subscription
	SPIM_SUBSCRIBE_RESUME_EN_Enabled = 0x1

	// EVENTS_STOPPED: SPI transaction has stopped
	// Position of EVENTS_STOPPED field.
	SPIM_EVENTS_STOPPED_EVENTS_STOPPED_Pos = 0x0
	// Bit mask of EVENTS_STOPPED field.
	SPIM_EVENTS_STOPPED_EVENTS_STOPPED_Msk = 0x1
	// Bit EVENTS_STOPPED.
	SPIM_EVENTS_STOPPED_EVENTS_STOPPED = 0x1
	// Event not generated
	SPIM_EVENTS_STOPPED_EVENTS_STOPPED_NotGenerated = 0x0
	// Event generated
	SPIM_EVENTS_STOPPED_EVENTS_STOPPED_Generated = 0x1

	// EVENTS_ENDRX: End of RXD buffer reached
	// Position of EVENTS_ENDRX field.
	SPIM_EVENTS_ENDRX_EVENTS_ENDRX_Pos = 0x0
	// Bit mask of EVENTS_ENDRX field.
	SPIM_EVENTS_ENDRX_EVENTS_ENDRX_Msk = 0x1
	// Bit EVENTS_ENDRX.
	SPIM_EVENTS_ENDRX_EVENTS_ENDRX = 0x1
	// Event not generated
	SPIM_EVENTS_ENDRX_EVENTS_ENDRX_NotGenerated = 0x0
	// Event generated
	SPIM_EVENTS_ENDRX_EVENTS_ENDRX_Generated = 0x1

	// EVENTS_END: End of RXD buffer and TXD buffer reached
	// Position of EVENTS_END field.
	SPIM_EVENTS_END_EVENTS_END_Pos = 0x0
	// Bit mask of EVENTS_END field.
	SPIM_EVENTS_END_EVENTS_END_Msk = 0x1
	// Bit EVENTS_END.
	SPIM_EVENTS_END_EVENTS_END = 0x1
	// Event not generated
	SPIM_EVENTS_END_EVENTS_END_NotGenerated = 0x0
	// Event generated
	SPIM_EVENTS_END_EVENTS_END_Generated = 0x1

	// EVENTS_ENDTX: End of TXD buffer reached
	// Position of EVENTS_ENDTX field.
	SPIM_EVENTS_ENDTX_EVENTS_ENDTX_Pos = 0x0
	// Bit mask of EVENTS_ENDTX field.
	SPIM_EVENTS_ENDTX_EVENTS_ENDTX_Msk = 0x1
	// Bit EVENTS_ENDTX.
	SPIM_EVENTS_ENDTX_EVENTS_ENDTX = 0x1
	// Event not generated
	SPIM_EVENTS_ENDTX_EVENTS_ENDTX_NotGenerated = 0x0
	// Event generated
	SPIM_EVENTS_ENDTX_EVENTS_ENDTX_Generated = 0x1

	// EVENTS_STARTED: Transaction started
	// Position of EVENTS_STARTED field.
	SPIM_EVENTS_STARTED_EVENTS_STARTED_Pos = 0x0
	// Bit mask of EVENTS_STARTED field.
	SPIM_EVENTS_STARTED_EVENTS_STARTED_Msk = 0x1
	// Bit EVENTS_STARTED.
	SPIM_EVENTS_STARTED_EVENTS_STARTED = 0x1
	// Event not generated
	SPIM_EVENTS_STARTED_EVENTS_STARTED_NotGenerated = 0x0
	// Event generated
	SPIM_EVENTS_STARTED_EVENTS_STARTED_Generated = 0x1

	// PUBLISH_STOPPED: Publish configuration for event STOPPED
	// Position of CHIDX field.
	SPIM_PUBLISH_STOPPED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SPIM_PUBLISH_STOPPED_CHIDX_Msk = 0xff
	// Position of EN field.
	SPIM_PUBLISH_STOPPED_EN_Pos = 0x1f
	// Bit mask of EN field.
	SPIM_PUBLISH_STOPPED_EN_Msk = 0x80000000
	// Bit EN.
	SPIM_PUBLISH_STOPPED_EN = 0x80000000
	// Disable publishing
	SPIM_PUBLISH_STOPPED_EN_Disabled = 0x0
	// Enable publishing
	SPIM_PUBLISH_STOPPED_EN_Enabled = 0x1

	// PUBLISH_ENDRX: Publish configuration for event ENDRX
	// Position of CHIDX field.
	SPIM_PUBLISH_ENDRX_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SPIM_PUBLISH_ENDRX_CHIDX_Msk = 0xff
	// Position of EN field.
	SPIM_PUBLISH_ENDRX_EN_Pos = 0x1f
	// Bit mask of EN field.
	SPIM_PUBLISH_ENDRX_EN_Msk = 0x80000000
	// Bit EN.
	SPIM_PUBLISH_ENDRX_EN = 0x80000000
	// Disable publishing
	SPIM_PUBLISH_ENDRX_EN_Disabled = 0x0
	// Enable publishing
	SPIM_PUBLISH_ENDRX_EN_Enabled = 0x1

	// PUBLISH_END: Publish configuration for event END
	// Position of CHIDX field.
	SPIM_PUBLISH_END_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SPIM_PUBLISH_END_CHIDX_Msk = 0xff
	// Position of EN field.
	SPIM_PUBLISH_END_EN_Pos = 0x1f
	// Bit mask of EN field.
	SPIM_PUBLISH_END_EN_Msk = 0x80000000
	// Bit EN.
	SPIM_PUBLISH_END_EN = 0x80000000
	// Disable publishing
	SPIM_PUBLISH_END_EN_Disabled = 0x0
	// Enable publishing
	SPIM_PUBLISH_END_EN_Enabled = 0x1

	// PUBLISH_ENDTX: Publish configuration for event ENDTX
	// Position of CHIDX field.
	SPIM_PUBLISH_ENDTX_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SPIM_PUBLISH_ENDTX_CHIDX_Msk = 0xff
	// Position of EN field.
	SPIM_PUBLISH_ENDTX_EN_Pos = 0x1f
	// Bit mask of EN field.
	SPIM_PUBLISH_ENDTX_EN_Msk = 0x80000000
	// Bit EN.
	SPIM_PUBLISH_ENDTX_EN = 0x80000000
	// Disable publishing
	SPIM_PUBLISH_ENDTX_EN_Disabled = 0x0
	// Enable publishing
	SPIM_PUBLISH_ENDTX_EN_Enabled = 0x1

	// PUBLISH_STARTED: Publish configuration for event STARTED
	// Position of CHIDX field.
	SPIM_PUBLISH_STARTED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SPIM_PUBLISH_STARTED_CHIDX_Msk = 0xff
	// Position of EN field.
	SPIM_PUBLISH_STARTED_EN_Pos = 0x1f
	// Bit mask of EN field.
	SPIM_PUBLISH_STARTED_EN_Msk = 0x80000000
	// Bit EN.
	SPIM_PUBLISH_STARTED_EN = 0x80000000
	// Disable publishing
	SPIM_PUBLISH_STARTED_EN_Disabled = 0x0
	// Enable publishing
	SPIM_PUBLISH_STARTED_EN_Enabled = 0x1

	// SHORTS: Shortcuts between local events and tasks
	// Position of END_START field.
	SPIM_SHORTS_END_START_Pos = 0x11
	// Bit mask of END_START field.
	SPIM_SHORTS_END_START_Msk = 0x20000
	// Bit END_START.
	SPIM_SHORTS_END_START = 0x20000
	// Disable shortcut
	SPIM_SHORTS_END_START_Disabled = 0x0
	// Enable shortcut
	SPIM_SHORTS_END_START_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of STOPPED field.
	SPIM_INTENSET_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	SPIM_INTENSET_STOPPED_Msk = 0x2
	// Bit STOPPED.
	SPIM_INTENSET_STOPPED = 0x2
	// Read: Disabled
	SPIM_INTENSET_STOPPED_Disabled = 0x0
	// Read: Enabled
	SPIM_INTENSET_STOPPED_Enabled = 0x1
	// Enable
	SPIM_INTENSET_STOPPED_Set = 0x1
	// Position of ENDRX field.
	SPIM_INTENSET_ENDRX_Pos = 0x4
	// Bit mask of ENDRX field.
	SPIM_INTENSET_ENDRX_Msk = 0x10
	// Bit ENDRX.
	SPIM_INTENSET_ENDRX = 0x10
	// Read: Disabled
	SPIM_INTENSET_ENDRX_Disabled = 0x0
	// Read: Enabled
	SPIM_INTENSET_ENDRX_Enabled = 0x1
	// Enable
	SPIM_INTENSET_ENDRX_Set = 0x1
	// Position of END field.
	SPIM_INTENSET_END_Pos = 0x6
	// Bit mask of END field.
	SPIM_INTENSET_END_Msk = 0x40
	// Bit END.
	SPIM_INTENSET_END = 0x40
	// Read: Disabled
	SPIM_INTENSET_END_Disabled = 0x0
	// Read: Enabled
	SPIM_INTENSET_END_Enabled = 0x1
	// Enable
	SPIM_INTENSET_END_Set = 0x1
	// Position of ENDTX field.
	SPIM_INTENSET_ENDTX_Pos = 0x8
	// Bit mask of ENDTX field.
	SPIM_INTENSET_ENDTX_Msk = 0x100
	// Bit ENDTX.
	SPIM_INTENSET_ENDTX = 0x100
	// Read: Disabled
	SPIM_INTENSET_ENDTX_Disabled = 0x0
	// Read: Enabled
	SPIM_INTENSET_ENDTX_Enabled = 0x1
	// Enable
	SPIM_INTENSET_ENDTX_Set = 0x1
	// Position of STARTED field.
	SPIM_INTENSET_STARTED_Pos = 0x13
	// Bit mask of STARTED field.
	SPIM_INTENSET_STARTED_Msk = 0x80000
	// Bit STARTED.
	SPIM_INTENSET_STARTED = 0x80000
	// Read: Disabled
	SPIM_INTENSET_STARTED_Disabled = 0x0
	// Read: Enabled
	SPIM_INTENSET_STARTED_Enabled = 0x1
	// Enable
	SPIM_INTENSET_STARTED_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of STOPPED field.
	SPIM_INTENCLR_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	SPIM_INTENCLR_STOPPED_Msk = 0x2
	// Bit STOPPED.
	SPIM_INTENCLR_STOPPED = 0x2
	// Read: Disabled
	SPIM_INTENCLR_STOPPED_Disabled = 0x0
	// Read: Enabled
	SPIM_INTENCLR_STOPPED_Enabled = 0x1
	// Disable
	SPIM_INTENCLR_STOPPED_Clear = 0x1
	// Position of ENDRX field.
	SPIM_INTENCLR_ENDRX_Pos = 0x4
	// Bit mask of ENDRX field.
	SPIM_INTENCLR_ENDRX_Msk = 0x10
	// Bit ENDRX.
	SPIM_INTENCLR_ENDRX = 0x10
	// Read: Disabled
	SPIM_INTENCLR_ENDRX_Disabled = 0x0
	// Read: Enabled
	SPIM_INTENCLR_ENDRX_Enabled = 0x1
	// Disable
	SPIM_INTENCLR_ENDRX_Clear = 0x1
	// Position of END field.
	SPIM_INTENCLR_END_Pos = 0x6
	// Bit mask of END field.
	SPIM_INTENCLR_END_Msk = 0x40
	// Bit END.
	SPIM_INTENCLR_END = 0x40
	// Read: Disabled
	SPIM_INTENCLR_END_Disabled = 0x0
	// Read: Enabled
	SPIM_INTENCLR_END_Enabled = 0x1
	// Disable
	SPIM_INTENCLR_END_Clear = 0x1
	// Position of ENDTX field.
	SPIM_INTENCLR_ENDTX_Pos = 0x8
	// Bit mask of ENDTX field.
	SPIM_INTENCLR_ENDTX_Msk = 0x100
	// Bit ENDTX.
	SPIM_INTENCLR_ENDTX = 0x100
	// Read: Disabled
	SPIM_INTENCLR_ENDTX_Disabled = 0x0
	// Read: Enabled
	SPIM_INTENCLR_ENDTX_Enabled = 0x1
	// Disable
	SPIM_INTENCLR_ENDTX_Clear = 0x1
	// Position of STARTED field.
	SPIM_INTENCLR_STARTED_Pos = 0x13
	// Bit mask of STARTED field.
	SPIM_INTENCLR_STARTED_Msk = 0x80000
	// Bit STARTED.
	SPIM_INTENCLR_STARTED = 0x80000
	// Read: Disabled
	SPIM_INTENCLR_STARTED_Disabled = 0x0
	// Read: Enabled
	SPIM_INTENCLR_STARTED_Enabled = 0x1
	// Disable
	SPIM_INTENCLR_STARTED_Clear = 0x1

	// STALLSTAT: Stall status for EasyDMA RAM accesses. The fields in this register is set to STALL by hardware whenever a stall occurres and can be cleared (set to NOSTALL) by the CPU.
	// Position of TX field.
	SPIM_STALLSTAT_TX_Pos = 0x0
	// Bit mask of TX field.
	SPIM_STALLSTAT_TX_Msk = 0x1
	// Bit TX.
	SPIM_STALLSTAT_TX = 0x1
	// No stall
	SPIM_STALLSTAT_TX_NOSTALL = 0x0
	// A stall has occurred
	SPIM_STALLSTAT_TX_STALL = 0x1
	// Position of RX field.
	SPIM_STALLSTAT_RX_Pos = 0x1
	// Bit mask of RX field.
	SPIM_STALLSTAT_RX_Msk = 0x2
	// Bit RX.
	SPIM_STALLSTAT_RX = 0x2
	// No stall
	SPIM_STALLSTAT_RX_NOSTALL = 0x0
	// A stall has occurred
	SPIM_STALLSTAT_RX_STALL = 0x1

	// ENABLE: Enable SPIM
	// Position of ENABLE field.
	SPIM_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	SPIM_ENABLE_ENABLE_Msk = 0xf
	// Disable SPIM
	SPIM_ENABLE_ENABLE_Disabled = 0x0
	// Enable SPIM
	SPIM_ENABLE_ENABLE_Enabled = 0x7

	// PSEL.SCK: Pin select for SCK
	// Position of PIN field.
	SPIM_PSEL_SCK_PIN_Pos = 0x0
	// Bit mask of PIN field.
	SPIM_PSEL_SCK_PIN_Msk = 0x1f
	// Position of PORT field.
	SPIM_PSEL_SCK_PORT_Pos = 0x5
	// Bit mask of PORT field.
	SPIM_PSEL_SCK_PORT_Msk = 0x20
	// Bit PORT.
	SPIM_PSEL_SCK_PORT = 0x20
	// Position of CONNECT field.
	SPIM_PSEL_SCK_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	SPIM_PSEL_SCK_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	SPIM_PSEL_SCK_CONNECT = 0x80000000
	// Disconnect
	SPIM_PSEL_SCK_CONNECT_Disconnected = 0x1
	// Connect
	SPIM_PSEL_SCK_CONNECT_Connected = 0x0

	// PSEL.MOSI: Pin select for MOSI signal
	// Position of PIN field.
	SPIM_PSEL_MOSI_PIN_Pos = 0x0
	// Bit mask of PIN field.
	SPIM_PSEL_MOSI_PIN_Msk = 0x1f
	// Position of PORT field.
	SPIM_PSEL_MOSI_PORT_Pos = 0x5
	// Bit mask of PORT field.
	SPIM_PSEL_MOSI_PORT_Msk = 0x20
	// Bit PORT.
	SPIM_PSEL_MOSI_PORT = 0x20
	// Position of CONNECT field.
	SPIM_PSEL_MOSI_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	SPIM_PSEL_MOSI_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	SPIM_PSEL_MOSI_CONNECT = 0x80000000
	// Disconnect
	SPIM_PSEL_MOSI_CONNECT_Disconnected = 0x1
	// Connect
	SPIM_PSEL_MOSI_CONNECT_Connected = 0x0

	// PSEL.MISO: Pin select for MISO signal
	// Position of PIN field.
	SPIM_PSEL_MISO_PIN_Pos = 0x0
	// Bit mask of PIN field.
	SPIM_PSEL_MISO_PIN_Msk = 0x1f
	// Position of PORT field.
	SPIM_PSEL_MISO_PORT_Pos = 0x5
	// Bit mask of PORT field.
	SPIM_PSEL_MISO_PORT_Msk = 0x20
	// Bit PORT.
	SPIM_PSEL_MISO_PORT = 0x20
	// Position of CONNECT field.
	SPIM_PSEL_MISO_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	SPIM_PSEL_MISO_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	SPIM_PSEL_MISO_CONNECT = 0x80000000
	// Disconnect
	SPIM_PSEL_MISO_CONNECT_Disconnected = 0x1
	// Connect
	SPIM_PSEL_MISO_CONNECT_Connected = 0x0

	// PSEL.CSN: Pin select for CSN
	// Position of PIN field.
	SPIM_PSEL_CSN_PIN_Pos = 0x0
	// Bit mask of PIN field.
	SPIM_PSEL_CSN_PIN_Msk = 0x1f
	// Position of PORT field.
	SPIM_PSEL_CSN_PORT_Pos = 0x5
	// Bit mask of PORT field.
	SPIM_PSEL_CSN_PORT_Msk = 0x20
	// Bit PORT.
	SPIM_PSEL_CSN_PORT = 0x20
	// Position of CONNECT field.
	SPIM_PSEL_CSN_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	SPIM_PSEL_CSN_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	SPIM_PSEL_CSN_CONNECT = 0x80000000
	// Disconnect
	SPIM_PSEL_CSN_CONNECT_Disconnected = 0x1
	// Connect
	SPIM_PSEL_CSN_CONNECT_Connected = 0x0

	// FREQUENCY: SPI frequency. Accuracy depends on the HFCLK source selected.
	// Position of FREQUENCY field.
	SPIM_FREQUENCY_FREQUENCY_Pos = 0x0
	// Bit mask of FREQUENCY field.
	SPIM_FREQUENCY_FREQUENCY_Msk = 0xffffffff
	// 125 kbps
	SPIM_FREQUENCY_FREQUENCY_K125 = 0x2000000
	// 250 kbps
	SPIM_FREQUENCY_FREQUENCY_K250 = 0x4000000
	// 500 kbps
	SPIM_FREQUENCY_FREQUENCY_K500 = 0x8000000
	// 1 Mbps
	SPIM_FREQUENCY_FREQUENCY_M1 = 0x10000000
	// 2 Mbps
	SPIM_FREQUENCY_FREQUENCY_M2 = 0x20000000
	// 4 Mbps
	SPIM_FREQUENCY_FREQUENCY_M4 = 0x40000000
	// 8 Mbps
	SPIM_FREQUENCY_FREQUENCY_M8 = 0x80000000
	// 16 Mbps
	SPIM_FREQUENCY_FREQUENCY_M16 = 0xa000000
	// 32 Mbps
	SPIM_FREQUENCY_FREQUENCY_M32 = 0x14000000

	// RXD.PTR: Data pointer
	// Position of PTR field.
	SPIM_RXD_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	SPIM_RXD_PTR_PTR_Msk = 0xffffffff

	// RXD.MAXCNT: Maximum number of bytes in receive buffer
	// Position of MAXCNT field.
	SPIM_RXD_MAXCNT_MAXCNT_Pos = 0x0
	// Bit mask of MAXCNT field.
	SPIM_RXD_MAXCNT_MAXCNT_Msk = 0xffff

	// RXD.AMOUNT: Number of bytes transferred in the last transaction
	// Position of AMOUNT field.
	SPIM_RXD_AMOUNT_AMOUNT_Pos = 0x0
	// Bit mask of AMOUNT field.
	SPIM_RXD_AMOUNT_AMOUNT_Msk = 0xffff

	// RXD.LIST: EasyDMA list type
	// Position of LIST field.
	SPIM_RXD_LIST_LIST_Pos = 0x0
	// Bit mask of LIST field.
	SPIM_RXD_LIST_LIST_Msk = 0x3
	// Disable EasyDMA list
	SPIM_RXD_LIST_LIST_Disabled = 0x0
	// Use array list
	SPIM_RXD_LIST_LIST_ArrayList = 0x1

	// TXD.PTR: Data pointer
	// Position of PTR field.
	SPIM_TXD_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	SPIM_TXD_PTR_PTR_Msk = 0xffffffff

	// TXD.MAXCNT: Number of bytes in transmit buffer
	// Position of MAXCNT field.
	SPIM_TXD_MAXCNT_MAXCNT_Pos = 0x0
	// Bit mask of MAXCNT field.
	SPIM_TXD_MAXCNT_MAXCNT_Msk = 0xffff

	// TXD.AMOUNT: Number of bytes transferred in the last transaction
	// Position of AMOUNT field.
	SPIM_TXD_AMOUNT_AMOUNT_Pos = 0x0
	// Bit mask of AMOUNT field.
	SPIM_TXD_AMOUNT_AMOUNT_Msk = 0xffff

	// TXD.LIST: EasyDMA list type
	// Position of LIST field.
	SPIM_TXD_LIST_LIST_Pos = 0x0
	// Bit mask of LIST field.
	SPIM_TXD_LIST_LIST_Msk = 0x3
	// Disable EasyDMA list
	SPIM_TXD_LIST_LIST_Disabled = 0x0
	// Use array list
	SPIM_TXD_LIST_LIST_ArrayList = 0x1

	// CONFIG: Configuration register
	// Position of ORDER field.
	SPIM_CONFIG_ORDER_Pos = 0x0
	// Bit mask of ORDER field.
	SPIM_CONFIG_ORDER_Msk = 0x1
	// Bit ORDER.
	SPIM_CONFIG_ORDER = 0x1
	// Most significant bit shifted out first
	SPIM_CONFIG_ORDER_MsbFirst = 0x0
	// Least significant bit shifted out first
	SPIM_CONFIG_ORDER_LsbFirst = 0x1
	// Position of CPHA field.
	SPIM_CONFIG_CPHA_Pos = 0x1
	// Bit mask of CPHA field.
	SPIM_CONFIG_CPHA_Msk = 0x2
	// Bit CPHA.
	SPIM_CONFIG_CPHA = 0x2
	// Sample on leading edge of clock, shift serial data on trailing edge
	SPIM_CONFIG_CPHA_Leading = 0x0
	// Sample on trailing edge of clock, shift serial data on leading edge
	SPIM_CONFIG_CPHA_Trailing = 0x1
	// Position of CPOL field.
	SPIM_CONFIG_CPOL_Pos = 0x2
	// Bit mask of CPOL field.
	SPIM_CONFIG_CPOL_Msk = 0x4
	// Bit CPOL.
	SPIM_CONFIG_CPOL = 0x4
	// Active high
	SPIM_CONFIG_CPOL_ActiveHigh = 0x0
	// Active low
	SPIM_CONFIG_CPOL_ActiveLow = 0x1

	// IFTIMING.RXDELAY: Sample delay for input serial data on MISO
	// Position of RXDELAY field.
	SPIM_IFTIMING_RXDELAY_RXDELAY_Pos = 0x0
	// Bit mask of RXDELAY field.
	SPIM_IFTIMING_RXDELAY_RXDELAY_Msk = 0x7

	// IFTIMING.CSNDUR: Minimum duration between edge of CSN and edge of SCK and minimum duration CSN must stay high between transactions
	// Position of CSNDUR field.
	SPIM_IFTIMING_CSNDUR_CSNDUR_Pos = 0x0
	// Bit mask of CSNDUR field.
	SPIM_IFTIMING_CSNDUR_CSNDUR_Msk = 0xff

	// CSNPOL: Polarity of CSN output
	// Position of CSNPOL field.
	SPIM_CSNPOL_CSNPOL_Pos = 0x0
	// Bit mask of CSNPOL field.
	SPIM_CSNPOL_CSNPOL_Msk = 0x1
	// Bit CSNPOL.
	SPIM_CSNPOL_CSNPOL = 0x1
	// Active low (idle state high)
	SPIM_CSNPOL_CSNPOL_LOW = 0x0
	// Active high (idle state low)
	SPIM_CSNPOL_CSNPOL_HIGH = 0x1

	// PSELDCX: Pin select for DCX signal
	// Position of PIN field.
	SPIM_PSELDCX_PIN_Pos = 0x0
	// Bit mask of PIN field.
	SPIM_PSELDCX_PIN_Msk = 0x1f
	// Position of PORT field.
	SPIM_PSELDCX_PORT_Pos = 0x5
	// Bit mask of PORT field.
	SPIM_PSELDCX_PORT_Msk = 0x20
	// Bit PORT.
	SPIM_PSELDCX_PORT = 0x20
	// Position of CONNECT field.
	SPIM_PSELDCX_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	SPIM_PSELDCX_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	SPIM_PSELDCX_CONNECT = 0x80000000
	// Disconnect
	SPIM_PSELDCX_CONNECT_Disconnected = 0x1
	// Connect
	SPIM_PSELDCX_CONNECT_Connected = 0x0

	// DCXCNT: DCX configuration
	// Position of DCXCNT field.
	SPIM_DCXCNT_DCXCNT_Pos = 0x0
	// Bit mask of DCXCNT field.
	SPIM_DCXCNT_DCXCNT_Msk = 0xf

	// ORC: Byte transmitted after TXD.MAXCNT bytes have been transmitted in the case when RXD.MAXCNT is greater than TXD.MAXCNT
	// Position of ORC field.
	SPIM_ORC_ORC_Pos = 0x0
	// Bit mask of ORC field.
	SPIM_ORC_ORC_Msk = 0xff
)

// Bitfields for SPIS0_NS: SPI Slave
const (
	// TASKS_ACQUIRE: Acquire SPI semaphore
	// Position of TASKS_ACQUIRE field.
	SPIS_TASKS_ACQUIRE_TASKS_ACQUIRE_Pos = 0x0
	// Bit mask of TASKS_ACQUIRE field.
	SPIS_TASKS_ACQUIRE_TASKS_ACQUIRE_Msk = 0x1
	// Bit TASKS_ACQUIRE.
	SPIS_TASKS_ACQUIRE_TASKS_ACQUIRE = 0x1
	// Trigger task
	SPIS_TASKS_ACQUIRE_TASKS_ACQUIRE_Trigger = 0x1

	// TASKS_RELEASE: Release SPI semaphore, enabling the SPI slave to acquire it
	// Position of TASKS_RELEASE field.
	SPIS_TASKS_RELEASE_TASKS_RELEASE_Pos = 0x0
	// Bit mask of TASKS_RELEASE field.
	SPIS_TASKS_RELEASE_TASKS_RELEASE_Msk = 0x1
	// Bit TASKS_RELEASE.
	SPIS_TASKS_RELEASE_TASKS_RELEASE = 0x1
	// Trigger task
	SPIS_TASKS_RELEASE_TASKS_RELEASE_Trigger = 0x1

	// SUBSCRIBE_ACQUIRE: Subscribe configuration for task ACQUIRE
	// Position of CHIDX field.
	SPIS_SUBSCRIBE_ACQUIRE_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SPIS_SUBSCRIBE_ACQUIRE_CHIDX_Msk = 0xff
	// Position of EN field.
	SPIS_SUBSCRIBE_ACQUIRE_EN_Pos = 0x1f
	// Bit mask of EN field.
	SPIS_SUBSCRIBE_ACQUIRE_EN_Msk = 0x80000000
	// Bit EN.
	SPIS_SUBSCRIBE_ACQUIRE_EN = 0x80000000
	// Disable subscription
	SPIS_SUBSCRIBE_ACQUIRE_EN_Disabled = 0x0
	// Enable subscription
	SPIS_SUBSCRIBE_ACQUIRE_EN_Enabled = 0x1

	// SUBSCRIBE_RELEASE: Subscribe configuration for task RELEASE
	// Position of CHIDX field.
	SPIS_SUBSCRIBE_RELEASE_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SPIS_SUBSCRIBE_RELEASE_CHIDX_Msk = 0xff
	// Position of EN field.
	SPIS_SUBSCRIBE_RELEASE_EN_Pos = 0x1f
	// Bit mask of EN field.
	SPIS_SUBSCRIBE_RELEASE_EN_Msk = 0x80000000
	// Bit EN.
	SPIS_SUBSCRIBE_RELEASE_EN = 0x80000000
	// Disable subscription
	SPIS_SUBSCRIBE_RELEASE_EN_Disabled = 0x0
	// Enable subscription
	SPIS_SUBSCRIBE_RELEASE_EN_Enabled = 0x1

	// EVENTS_END: Granted transaction completed
	// Position of EVENTS_END field.
	SPIS_EVENTS_END_EVENTS_END_Pos = 0x0
	// Bit mask of EVENTS_END field.
	SPIS_EVENTS_END_EVENTS_END_Msk = 0x1
	// Bit EVENTS_END.
	SPIS_EVENTS_END_EVENTS_END = 0x1
	// Event not generated
	SPIS_EVENTS_END_EVENTS_END_NotGenerated = 0x0
	// Event generated
	SPIS_EVENTS_END_EVENTS_END_Generated = 0x1

	// EVENTS_ENDRX: End of RXD buffer reached
	// Position of EVENTS_ENDRX field.
	SPIS_EVENTS_ENDRX_EVENTS_ENDRX_Pos = 0x0
	// Bit mask of EVENTS_ENDRX field.
	SPIS_EVENTS_ENDRX_EVENTS_ENDRX_Msk = 0x1
	// Bit EVENTS_ENDRX.
	SPIS_EVENTS_ENDRX_EVENTS_ENDRX = 0x1
	// Event not generated
	SPIS_EVENTS_ENDRX_EVENTS_ENDRX_NotGenerated = 0x0
	// Event generated
	SPIS_EVENTS_ENDRX_EVENTS_ENDRX_Generated = 0x1

	// EVENTS_ACQUIRED: Semaphore acquired
	// Position of EVENTS_ACQUIRED field.
	SPIS_EVENTS_ACQUIRED_EVENTS_ACQUIRED_Pos = 0x0
	// Bit mask of EVENTS_ACQUIRED field.
	SPIS_EVENTS_ACQUIRED_EVENTS_ACQUIRED_Msk = 0x1
	// Bit EVENTS_ACQUIRED.
	SPIS_EVENTS_ACQUIRED_EVENTS_ACQUIRED = 0x1
	// Event not generated
	SPIS_EVENTS_ACQUIRED_EVENTS_ACQUIRED_NotGenerated = 0x0
	// Event generated
	SPIS_EVENTS_ACQUIRED_EVENTS_ACQUIRED_Generated = 0x1

	// PUBLISH_END: Publish configuration for event END
	// Position of CHIDX field.
	SPIS_PUBLISH_END_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SPIS_PUBLISH_END_CHIDX_Msk = 0xff
	// Position of EN field.
	SPIS_PUBLISH_END_EN_Pos = 0x1f
	// Bit mask of EN field.
	SPIS_PUBLISH_END_EN_Msk = 0x80000000
	// Bit EN.
	SPIS_PUBLISH_END_EN = 0x80000000
	// Disable publishing
	SPIS_PUBLISH_END_EN_Disabled = 0x0
	// Enable publishing
	SPIS_PUBLISH_END_EN_Enabled = 0x1

	// PUBLISH_ENDRX: Publish configuration for event ENDRX
	// Position of CHIDX field.
	SPIS_PUBLISH_ENDRX_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SPIS_PUBLISH_ENDRX_CHIDX_Msk = 0xff
	// Position of EN field.
	SPIS_PUBLISH_ENDRX_EN_Pos = 0x1f
	// Bit mask of EN field.
	SPIS_PUBLISH_ENDRX_EN_Msk = 0x80000000
	// Bit EN.
	SPIS_PUBLISH_ENDRX_EN = 0x80000000
	// Disable publishing
	SPIS_PUBLISH_ENDRX_EN_Disabled = 0x0
	// Enable publishing
	SPIS_PUBLISH_ENDRX_EN_Enabled = 0x1

	// PUBLISH_ACQUIRED: Publish configuration for event ACQUIRED
	// Position of CHIDX field.
	SPIS_PUBLISH_ACQUIRED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SPIS_PUBLISH_ACQUIRED_CHIDX_Msk = 0xff
	// Position of EN field.
	SPIS_PUBLISH_ACQUIRED_EN_Pos = 0x1f
	// Bit mask of EN field.
	SPIS_PUBLISH_ACQUIRED_EN_Msk = 0x80000000
	// Bit EN.
	SPIS_PUBLISH_ACQUIRED_EN = 0x80000000
	// Disable publishing
	SPIS_PUBLISH_ACQUIRED_EN_Disabled = 0x0
	// Enable publishing
	SPIS_PUBLISH_ACQUIRED_EN_Enabled = 0x1

	// SHORTS: Shortcuts between local events and tasks
	// Position of END_ACQUIRE field.
	SPIS_SHORTS_END_ACQUIRE_Pos = 0x2
	// Bit mask of END_ACQUIRE field.
	SPIS_SHORTS_END_ACQUIRE_Msk = 0x4
	// Bit END_ACQUIRE.
	SPIS_SHORTS_END_ACQUIRE = 0x4
	// Disable shortcut
	SPIS_SHORTS_END_ACQUIRE_Disabled = 0x0
	// Enable shortcut
	SPIS_SHORTS_END_ACQUIRE_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of END field.
	SPIS_INTENSET_END_Pos = 0x1
	// Bit mask of END field.
	SPIS_INTENSET_END_Msk = 0x2
	// Bit END.
	SPIS_INTENSET_END = 0x2
	// Read: Disabled
	SPIS_INTENSET_END_Disabled = 0x0
	// Read: Enabled
	SPIS_INTENSET_END_Enabled = 0x1
	// Enable
	SPIS_INTENSET_END_Set = 0x1
	// Position of ENDRX field.
	SPIS_INTENSET_ENDRX_Pos = 0x4
	// Bit mask of ENDRX field.
	SPIS_INTENSET_ENDRX_Msk = 0x10
	// Bit ENDRX.
	SPIS_INTENSET_ENDRX = 0x10
	// Read: Disabled
	SPIS_INTENSET_ENDRX_Disabled = 0x0
	// Read: Enabled
	SPIS_INTENSET_ENDRX_Enabled = 0x1
	// Enable
	SPIS_INTENSET_ENDRX_Set = 0x1
	// Position of ACQUIRED field.
	SPIS_INTENSET_ACQUIRED_Pos = 0xa
	// Bit mask of ACQUIRED field.
	SPIS_INTENSET_ACQUIRED_Msk = 0x400
	// Bit ACQUIRED.
	SPIS_INTENSET_ACQUIRED = 0x400
	// Read: Disabled
	SPIS_INTENSET_ACQUIRED_Disabled = 0x0
	// Read: Enabled
	SPIS_INTENSET_ACQUIRED_Enabled = 0x1
	// Enable
	SPIS_INTENSET_ACQUIRED_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of END field.
	SPIS_INTENCLR_END_Pos = 0x1
	// Bit mask of END field.
	SPIS_INTENCLR_END_Msk = 0x2
	// Bit END.
	SPIS_INTENCLR_END = 0x2
	// Read: Disabled
	SPIS_INTENCLR_END_Disabled = 0x0
	// Read: Enabled
	SPIS_INTENCLR_END_Enabled = 0x1
	// Disable
	SPIS_INTENCLR_END_Clear = 0x1
	// Position of ENDRX field.
	SPIS_INTENCLR_ENDRX_Pos = 0x4
	// Bit mask of ENDRX field.
	SPIS_INTENCLR_ENDRX_Msk = 0x10
	// Bit ENDRX.
	SPIS_INTENCLR_ENDRX = 0x10
	// Read: Disabled
	SPIS_INTENCLR_ENDRX_Disabled = 0x0
	// Read: Enabled
	SPIS_INTENCLR_ENDRX_Enabled = 0x1
	// Disable
	SPIS_INTENCLR_ENDRX_Clear = 0x1
	// Position of ACQUIRED field.
	SPIS_INTENCLR_ACQUIRED_Pos = 0xa
	// Bit mask of ACQUIRED field.
	SPIS_INTENCLR_ACQUIRED_Msk = 0x400
	// Bit ACQUIRED.
	SPIS_INTENCLR_ACQUIRED = 0x400
	// Read: Disabled
	SPIS_INTENCLR_ACQUIRED_Disabled = 0x0
	// Read: Enabled
	SPIS_INTENCLR_ACQUIRED_Enabled = 0x1
	// Disable
	SPIS_INTENCLR_ACQUIRED_Clear = 0x1

	// SEMSTAT: Semaphore status register
	// Position of SEMSTAT field.
	SPIS_SEMSTAT_SEMSTAT_Pos = 0x0
	// Bit mask of SEMSTAT field.
	SPIS_SEMSTAT_SEMSTAT_Msk = 0x3
	// Semaphore is free
	SPIS_SEMSTAT_SEMSTAT_Free = 0x0
	// Semaphore is assigned to CPU
	SPIS_SEMSTAT_SEMSTAT_CPU = 0x1
	// Semaphore is assigned to SPI slave
	SPIS_SEMSTAT_SEMSTAT_SPIS = 0x2
	// Semaphore is assigned to SPI but a handover to the CPU is pending
	SPIS_SEMSTAT_SEMSTAT_CPUPending = 0x3

	// STATUS: Status from last transaction
	// Position of OVERREAD field.
	SPIS_STATUS_OVERREAD_Pos = 0x0
	// Bit mask of OVERREAD field.
	SPIS_STATUS_OVERREAD_Msk = 0x1
	// Bit OVERREAD.
	SPIS_STATUS_OVERREAD = 0x1
	// Read: error not present
	SPIS_STATUS_OVERREAD_NotPresent = 0x0
	// Read: error present
	SPIS_STATUS_OVERREAD_Present = 0x1
	// Write: clear error on writing '1'
	SPIS_STATUS_OVERREAD_Clear = 0x1
	// Position of OVERFLOW field.
	SPIS_STATUS_OVERFLOW_Pos = 0x1
	// Bit mask of OVERFLOW field.
	SPIS_STATUS_OVERFLOW_Msk = 0x2
	// Bit OVERFLOW.
	SPIS_STATUS_OVERFLOW = 0x2
	// Read: error not present
	SPIS_STATUS_OVERFLOW_NotPresent = 0x0
	// Read: error present
	SPIS_STATUS_OVERFLOW_Present = 0x1
	// Write: clear error on writing '1'
	SPIS_STATUS_OVERFLOW_Clear = 0x1

	// ENABLE: Enable SPI slave
	// Position of ENABLE field.
	SPIS_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	SPIS_ENABLE_ENABLE_Msk = 0xf
	// Disable SPI slave
	SPIS_ENABLE_ENABLE_Disabled = 0x0
	// Enable SPI slave
	SPIS_ENABLE_ENABLE_Enabled = 0x2

	// PSEL.SCK: Pin select for SCK
	// Position of PIN field.
	SPIS_PSEL_SCK_PIN_Pos = 0x0
	// Bit mask of PIN field.
	SPIS_PSEL_SCK_PIN_Msk = 0x1f
	// Position of PORT field.
	SPIS_PSEL_SCK_PORT_Pos = 0x5
	// Bit mask of PORT field.
	SPIS_PSEL_SCK_PORT_Msk = 0x20
	// Bit PORT.
	SPIS_PSEL_SCK_PORT = 0x20
	// Position of CONNECT field.
	SPIS_PSEL_SCK_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	SPIS_PSEL_SCK_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	SPIS_PSEL_SCK_CONNECT = 0x80000000
	// Disconnect
	SPIS_PSEL_SCK_CONNECT_Disconnected = 0x1
	// Connect
	SPIS_PSEL_SCK_CONNECT_Connected = 0x0

	// PSEL.MISO: Pin select for MISO signal
	// Position of PIN field.
	SPIS_PSEL_MISO_PIN_Pos = 0x0
	// Bit mask of PIN field.
	SPIS_PSEL_MISO_PIN_Msk = 0x1f
	// Position of PORT field.
	SPIS_PSEL_MISO_PORT_Pos = 0x5
	// Bit mask of PORT field.
	SPIS_PSEL_MISO_PORT_Msk = 0x20
	// Bit PORT.
	SPIS_PSEL_MISO_PORT = 0x20
	// Position of CONNECT field.
	SPIS_PSEL_MISO_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	SPIS_PSEL_MISO_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	SPIS_PSEL_MISO_CONNECT = 0x80000000
	// Disconnect
	SPIS_PSEL_MISO_CONNECT_Disconnected = 0x1
	// Connect
	SPIS_PSEL_MISO_CONNECT_Connected = 0x0

	// PSEL.MOSI: Pin select for MOSI signal
	// Position of PIN field.
	SPIS_PSEL_MOSI_PIN_Pos = 0x0
	// Bit mask of PIN field.
	SPIS_PSEL_MOSI_PIN_Msk = 0x1f
	// Position of PORT field.
	SPIS_PSEL_MOSI_PORT_Pos = 0x5
	// Bit mask of PORT field.
	SPIS_PSEL_MOSI_PORT_Msk = 0x20
	// Bit PORT.
	SPIS_PSEL_MOSI_PORT = 0x20
	// Position of CONNECT field.
	SPIS_PSEL_MOSI_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	SPIS_PSEL_MOSI_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	SPIS_PSEL_MOSI_CONNECT = 0x80000000
	// Disconnect
	SPIS_PSEL_MOSI_CONNECT_Disconnected = 0x1
	// Connect
	SPIS_PSEL_MOSI_CONNECT_Connected = 0x0

	// PSEL.CSN: Pin select for CSN signal
	// Position of PIN field.
	SPIS_PSEL_CSN_PIN_Pos = 0x0
	// Bit mask of PIN field.
	SPIS_PSEL_CSN_PIN_Msk = 0x1f
	// Position of PORT field.
	SPIS_PSEL_CSN_PORT_Pos = 0x5
	// Bit mask of PORT field.
	SPIS_PSEL_CSN_PORT_Msk = 0x20
	// Bit PORT.
	SPIS_PSEL_CSN_PORT = 0x20
	// Position of CONNECT field.
	SPIS_PSEL_CSN_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	SPIS_PSEL_CSN_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	SPIS_PSEL_CSN_CONNECT = 0x80000000
	// Disconnect
	SPIS_PSEL_CSN_CONNECT_Disconnected = 0x1
	// Connect
	SPIS_PSEL_CSN_CONNECT_Connected = 0x0

	// RXD.PTR: RXD data pointer
	// Position of PTR field.
	SPIS_RXD_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	SPIS_RXD_PTR_PTR_Msk = 0xffffffff

	// RXD.MAXCNT: Maximum number of bytes in receive buffer
	// Position of MAXCNT field.
	SPIS_RXD_MAXCNT_MAXCNT_Pos = 0x0
	// Bit mask of MAXCNT field.
	SPIS_RXD_MAXCNT_MAXCNT_Msk = 0xffff

	// RXD.AMOUNT: Number of bytes received in last granted transaction
	// Position of AMOUNT field.
	SPIS_RXD_AMOUNT_AMOUNT_Pos = 0x0
	// Bit mask of AMOUNT field.
	SPIS_RXD_AMOUNT_AMOUNT_Msk = 0xffff

	// RXD.LIST: EasyDMA list type
	// Position of LIST field.
	SPIS_RXD_LIST_LIST_Pos = 0x0
	// Bit mask of LIST field.
	SPIS_RXD_LIST_LIST_Msk = 0x3
	// Disable EasyDMA list
	SPIS_RXD_LIST_LIST_Disabled = 0x0
	// Use array list
	SPIS_RXD_LIST_LIST_ArrayList = 0x1

	// TXD.PTR: TXD data pointer
	// Position of PTR field.
	SPIS_TXD_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	SPIS_TXD_PTR_PTR_Msk = 0xffffffff

	// TXD.MAXCNT: Maximum number of bytes in transmit buffer
	// Position of MAXCNT field.
	SPIS_TXD_MAXCNT_MAXCNT_Pos = 0x0
	// Bit mask of MAXCNT field.
	SPIS_TXD_MAXCNT_MAXCNT_Msk = 0xffff

	// TXD.AMOUNT: Number of bytes transmitted in last granted transaction
	// Position of AMOUNT field.
	SPIS_TXD_AMOUNT_AMOUNT_Pos = 0x0
	// Bit mask of AMOUNT field.
	SPIS_TXD_AMOUNT_AMOUNT_Msk = 0xffff

	// TXD.LIST: EasyDMA list type
	// Position of LIST field.
	SPIS_TXD_LIST_LIST_Pos = 0x0
	// Bit mask of LIST field.
	SPIS_TXD_LIST_LIST_Msk = 0x3
	// Disable EasyDMA list
	SPIS_TXD_LIST_LIST_Disabled = 0x0
	// Use array list
	SPIS_TXD_LIST_LIST_ArrayList = 0x1

	// CONFIG: Configuration register
	// Position of ORDER field.
	SPIS_CONFIG_ORDER_Pos = 0x0
	// Bit mask of ORDER field.
	SPIS_CONFIG_ORDER_Msk = 0x1
	// Bit ORDER.
	SPIS_CONFIG_ORDER = 0x1
	// Most significant bit shifted out first
	SPIS_CONFIG_ORDER_MsbFirst = 0x0
	// Least significant bit shifted out first
	SPIS_CONFIG_ORDER_LsbFirst = 0x1
	// Position of CPHA field.
	SPIS_CONFIG_CPHA_Pos = 0x1
	// Bit mask of CPHA field.
	SPIS_CONFIG_CPHA_Msk = 0x2
	// Bit CPHA.
	SPIS_CONFIG_CPHA = 0x2
	// Sample on leading edge of clock, shift serial data on trailing edge
	SPIS_CONFIG_CPHA_Leading = 0x0
	// Sample on trailing edge of clock, shift serial data on leading edge
	SPIS_CONFIG_CPHA_Trailing = 0x1
	// Position of CPOL field.
	SPIS_CONFIG_CPOL_Pos = 0x2
	// Bit mask of CPOL field.
	SPIS_CONFIG_CPOL_Msk = 0x4
	// Bit CPOL.
	SPIS_CONFIG_CPOL = 0x4
	// Active high
	SPIS_CONFIG_CPOL_ActiveHigh = 0x0
	// Active low
	SPIS_CONFIG_CPOL_ActiveLow = 0x1

	// DEF: Default character. Character clocked out in case of an ignored transaction.
	// Position of DEF field.
	SPIS_DEF_DEF_Pos = 0x0
	// Bit mask of DEF field.
	SPIS_DEF_DEF_Msk = 0xff

	// ORC: Over-read character
	// Position of ORC field.
	SPIS_ORC_ORC_Pos = 0x0
	// Bit mask of ORC field.
	SPIS_ORC_ORC_Msk = 0xff
)

// Bitfields for TWIM0_NS: I2C compatible Two-Wire Master Interface with EasyDMA
const (
	// TASKS_STARTRX: Start TWI receive sequence
	// Position of TASKS_STARTRX field.
	TWIM_TASKS_STARTRX_TASKS_STARTRX_Pos = 0x0
	// Bit mask of TASKS_STARTRX field.
	TWIM_TASKS_STARTRX_TASKS_STARTRX_Msk = 0x1
	// Bit TASKS_STARTRX.
	TWIM_TASKS_STARTRX_TASKS_STARTRX = 0x1
	// Trigger task
	TWIM_TASKS_STARTRX_TASKS_STARTRX_Trigger = 0x1

	// TASKS_STARTTX: Start TWI transmit sequence
	// Position of TASKS_STARTTX field.
	TWIM_TASKS_STARTTX_TASKS_STARTTX_Pos = 0x0
	// Bit mask of TASKS_STARTTX field.
	TWIM_TASKS_STARTTX_TASKS_STARTTX_Msk = 0x1
	// Bit TASKS_STARTTX.
	TWIM_TASKS_STARTTX_TASKS_STARTTX = 0x1
	// Trigger task
	TWIM_TASKS_STARTTX_TASKS_STARTTX_Trigger = 0x1

	// TASKS_STOP: Stop TWI transaction. Must be issued while the TWI master is not suspended.
	// Position of TASKS_STOP field.
	TWIM_TASKS_STOP_TASKS_STOP_Pos = 0x0
	// Bit mask of TASKS_STOP field.
	TWIM_TASKS_STOP_TASKS_STOP_Msk = 0x1
	// Bit TASKS_STOP.
	TWIM_TASKS_STOP_TASKS_STOP = 0x1
	// Trigger task
	TWIM_TASKS_STOP_TASKS_STOP_Trigger = 0x1

	// TASKS_SUSPEND: Suspend TWI transaction
	// Position of TASKS_SUSPEND field.
	TWIM_TASKS_SUSPEND_TASKS_SUSPEND_Pos = 0x0
	// Bit mask of TASKS_SUSPEND field.
	TWIM_TASKS_SUSPEND_TASKS_SUSPEND_Msk = 0x1
	// Bit TASKS_SUSPEND.
	TWIM_TASKS_SUSPEND_TASKS_SUSPEND = 0x1
	// Trigger task
	TWIM_TASKS_SUSPEND_TASKS_SUSPEND_Trigger = 0x1

	// TASKS_RESUME: Resume TWI transaction
	// Position of TASKS_RESUME field.
	TWIM_TASKS_RESUME_TASKS_RESUME_Pos = 0x0
	// Bit mask of TASKS_RESUME field.
	TWIM_TASKS_RESUME_TASKS_RESUME_Msk = 0x1
	// Bit TASKS_RESUME.
	TWIM_TASKS_RESUME_TASKS_RESUME = 0x1
	// Trigger task
	TWIM_TASKS_RESUME_TASKS_RESUME_Trigger = 0x1

	// SUBSCRIBE_STARTRX: Subscribe configuration for task STARTRX
	// Position of CHIDX field.
	TWIM_SUBSCRIBE_STARTRX_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIM_SUBSCRIBE_STARTRX_CHIDX_Msk = 0xff
	// Position of EN field.
	TWIM_SUBSCRIBE_STARTRX_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIM_SUBSCRIBE_STARTRX_EN_Msk = 0x80000000
	// Bit EN.
	TWIM_SUBSCRIBE_STARTRX_EN = 0x80000000
	// Disable subscription
	TWIM_SUBSCRIBE_STARTRX_EN_Disabled = 0x0
	// Enable subscription
	TWIM_SUBSCRIBE_STARTRX_EN_Enabled = 0x1

	// SUBSCRIBE_STARTTX: Subscribe configuration for task STARTTX
	// Position of CHIDX field.
	TWIM_SUBSCRIBE_STARTTX_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIM_SUBSCRIBE_STARTTX_CHIDX_Msk = 0xff
	// Position of EN field.
	TWIM_SUBSCRIBE_STARTTX_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIM_SUBSCRIBE_STARTTX_EN_Msk = 0x80000000
	// Bit EN.
	TWIM_SUBSCRIBE_STARTTX_EN = 0x80000000
	// Disable subscription
	TWIM_SUBSCRIBE_STARTTX_EN_Disabled = 0x0
	// Enable subscription
	TWIM_SUBSCRIBE_STARTTX_EN_Enabled = 0x1

	// SUBSCRIBE_STOP: Subscribe configuration for task STOP
	// Position of CHIDX field.
	TWIM_SUBSCRIBE_STOP_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIM_SUBSCRIBE_STOP_CHIDX_Msk = 0xff
	// Position of EN field.
	TWIM_SUBSCRIBE_STOP_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIM_SUBSCRIBE_STOP_EN_Msk = 0x80000000
	// Bit EN.
	TWIM_SUBSCRIBE_STOP_EN = 0x80000000
	// Disable subscription
	TWIM_SUBSCRIBE_STOP_EN_Disabled = 0x0
	// Enable subscription
	TWIM_SUBSCRIBE_STOP_EN_Enabled = 0x1

	// SUBSCRIBE_SUSPEND: Subscribe configuration for task SUSPEND
	// Position of CHIDX field.
	TWIM_SUBSCRIBE_SUSPEND_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIM_SUBSCRIBE_SUSPEND_CHIDX_Msk = 0xff
	// Position of EN field.
	TWIM_SUBSCRIBE_SUSPEND_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIM_SUBSCRIBE_SUSPEND_EN_Msk = 0x80000000
	// Bit EN.
	TWIM_SUBSCRIBE_SUSPEND_EN = 0x80000000
	// Disable subscription
	TWIM_SUBSCRIBE_SUSPEND_EN_Disabled = 0x0
	// Enable subscription
	TWIM_SUBSCRIBE_SUSPEND_EN_Enabled = 0x1

	// SUBSCRIBE_RESUME: Subscribe configuration for task RESUME
	// Position of CHIDX field.
	TWIM_SUBSCRIBE_RESUME_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIM_SUBSCRIBE_RESUME_CHIDX_Msk = 0xff
	// Position of EN field.
	TWIM_SUBSCRIBE_RESUME_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIM_SUBSCRIBE_RESUME_EN_Msk = 0x80000000
	// Bit EN.
	TWIM_SUBSCRIBE_RESUME_EN = 0x80000000
	// Disable subscription
	TWIM_SUBSCRIBE_RESUME_EN_Disabled = 0x0
	// Enable subscription
	TWIM_SUBSCRIBE_RESUME_EN_Enabled = 0x1

	// EVENTS_STOPPED: TWI stopped
	// Position of EVENTS_STOPPED field.
	TWIM_EVENTS_STOPPED_EVENTS_STOPPED_Pos = 0x0
	// Bit mask of EVENTS_STOPPED field.
	TWIM_EVENTS_STOPPED_EVENTS_STOPPED_Msk = 0x1
	// Bit EVENTS_STOPPED.
	TWIM_EVENTS_STOPPED_EVENTS_STOPPED = 0x1
	// Event not generated
	TWIM_EVENTS_STOPPED_EVENTS_STOPPED_NotGenerated = 0x0
	// Event generated
	TWIM_EVENTS_STOPPED_EVENTS_STOPPED_Generated = 0x1

	// EVENTS_ERROR: TWI error
	// Position of EVENTS_ERROR field.
	TWIM_EVENTS_ERROR_EVENTS_ERROR_Pos = 0x0
	// Bit mask of EVENTS_ERROR field.
	TWIM_EVENTS_ERROR_EVENTS_ERROR_Msk = 0x1
	// Bit EVENTS_ERROR.
	TWIM_EVENTS_ERROR_EVENTS_ERROR = 0x1
	// Event not generated
	TWIM_EVENTS_ERROR_EVENTS_ERROR_NotGenerated = 0x0
	// Event generated
	TWIM_EVENTS_ERROR_EVENTS_ERROR_Generated = 0x1

	// EVENTS_SUSPENDED: SUSPEND task has been issued, TWI traffic is now suspended.
	// Position of EVENTS_SUSPENDED field.
	TWIM_EVENTS_SUSPENDED_EVENTS_SUSPENDED_Pos = 0x0
	// Bit mask of EVENTS_SUSPENDED field.
	TWIM_EVENTS_SUSPENDED_EVENTS_SUSPENDED_Msk = 0x1
	// Bit EVENTS_SUSPENDED.
	TWIM_EVENTS_SUSPENDED_EVENTS_SUSPENDED = 0x1
	// Event not generated
	TWIM_EVENTS_SUSPENDED_EVENTS_SUSPENDED_NotGenerated = 0x0
	// Event generated
	TWIM_EVENTS_SUSPENDED_EVENTS_SUSPENDED_Generated = 0x1

	// EVENTS_RXSTARTED: Receive sequence started
	// Position of EVENTS_RXSTARTED field.
	TWIM_EVENTS_RXSTARTED_EVENTS_RXSTARTED_Pos = 0x0
	// Bit mask of EVENTS_RXSTARTED field.
	TWIM_EVENTS_RXSTARTED_EVENTS_RXSTARTED_Msk = 0x1
	// Bit EVENTS_RXSTARTED.
	TWIM_EVENTS_RXSTARTED_EVENTS_RXSTARTED = 0x1
	// Event not generated
	TWIM_EVENTS_RXSTARTED_EVENTS_RXSTARTED_NotGenerated = 0x0
	// Event generated
	TWIM_EVENTS_RXSTARTED_EVENTS_RXSTARTED_Generated = 0x1

	// EVENTS_TXSTARTED: Transmit sequence started
	// Position of EVENTS_TXSTARTED field.
	TWIM_EVENTS_TXSTARTED_EVENTS_TXSTARTED_Pos = 0x0
	// Bit mask of EVENTS_TXSTARTED field.
	TWIM_EVENTS_TXSTARTED_EVENTS_TXSTARTED_Msk = 0x1
	// Bit EVENTS_TXSTARTED.
	TWIM_EVENTS_TXSTARTED_EVENTS_TXSTARTED = 0x1
	// Event not generated
	TWIM_EVENTS_TXSTARTED_EVENTS_TXSTARTED_NotGenerated = 0x0
	// Event generated
	TWIM_EVENTS_TXSTARTED_EVENTS_TXSTARTED_Generated = 0x1

	// EVENTS_LASTRX: Byte boundary, starting to receive the last byte
	// Position of EVENTS_LASTRX field.
	TWIM_EVENTS_LASTRX_EVENTS_LASTRX_Pos = 0x0
	// Bit mask of EVENTS_LASTRX field.
	TWIM_EVENTS_LASTRX_EVENTS_LASTRX_Msk = 0x1
	// Bit EVENTS_LASTRX.
	TWIM_EVENTS_LASTRX_EVENTS_LASTRX = 0x1
	// Event not generated
	TWIM_EVENTS_LASTRX_EVENTS_LASTRX_NotGenerated = 0x0
	// Event generated
	TWIM_EVENTS_LASTRX_EVENTS_LASTRX_Generated = 0x1

	// EVENTS_LASTTX: Byte boundary, starting to transmit the last byte
	// Position of EVENTS_LASTTX field.
	TWIM_EVENTS_LASTTX_EVENTS_LASTTX_Pos = 0x0
	// Bit mask of EVENTS_LASTTX field.
	TWIM_EVENTS_LASTTX_EVENTS_LASTTX_Msk = 0x1
	// Bit EVENTS_LASTTX.
	TWIM_EVENTS_LASTTX_EVENTS_LASTTX = 0x1
	// Event not generated
	TWIM_EVENTS_LASTTX_EVENTS_LASTTX_NotGenerated = 0x0
	// Event generated
	TWIM_EVENTS_LASTTX_EVENTS_LASTTX_Generated = 0x1

	// PUBLISH_STOPPED: Publish configuration for event STOPPED
	// Position of CHIDX field.
	TWIM_PUBLISH_STOPPED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIM_PUBLISH_STOPPED_CHIDX_Msk = 0xff
	// Position of EN field.
	TWIM_PUBLISH_STOPPED_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIM_PUBLISH_STOPPED_EN_Msk = 0x80000000
	// Bit EN.
	TWIM_PUBLISH_STOPPED_EN = 0x80000000
	// Disable publishing
	TWIM_PUBLISH_STOPPED_EN_Disabled = 0x0
	// Enable publishing
	TWIM_PUBLISH_STOPPED_EN_Enabled = 0x1

	// PUBLISH_ERROR: Publish configuration for event ERROR
	// Position of CHIDX field.
	TWIM_PUBLISH_ERROR_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIM_PUBLISH_ERROR_CHIDX_Msk = 0xff
	// Position of EN field.
	TWIM_PUBLISH_ERROR_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIM_PUBLISH_ERROR_EN_Msk = 0x80000000
	// Bit EN.
	TWIM_PUBLISH_ERROR_EN = 0x80000000
	// Disable publishing
	TWIM_PUBLISH_ERROR_EN_Disabled = 0x0
	// Enable publishing
	TWIM_PUBLISH_ERROR_EN_Enabled = 0x1

	// PUBLISH_SUSPENDED: Publish configuration for event SUSPENDED
	// Position of CHIDX field.
	TWIM_PUBLISH_SUSPENDED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIM_PUBLISH_SUSPENDED_CHIDX_Msk = 0xff
	// Position of EN field.
	TWIM_PUBLISH_SUSPENDED_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIM_PUBLISH_SUSPENDED_EN_Msk = 0x80000000
	// Bit EN.
	TWIM_PUBLISH_SUSPENDED_EN = 0x80000000
	// Disable publishing
	TWIM_PUBLISH_SUSPENDED_EN_Disabled = 0x0
	// Enable publishing
	TWIM_PUBLISH_SUSPENDED_EN_Enabled = 0x1

	// PUBLISH_RXSTARTED: Publish configuration for event RXSTARTED
	// Position of CHIDX field.
	TWIM_PUBLISH_RXSTARTED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIM_PUBLISH_RXSTARTED_CHIDX_Msk = 0xff
	// Position of EN field.
	TWIM_PUBLISH_RXSTARTED_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIM_PUBLISH_RXSTARTED_EN_Msk = 0x80000000
	// Bit EN.
	TWIM_PUBLISH_RXSTARTED_EN = 0x80000000
	// Disable publishing
	TWIM_PUBLISH_RXSTARTED_EN_Disabled = 0x0
	// Enable publishing
	TWIM_PUBLISH_RXSTARTED_EN_Enabled = 0x1

	// PUBLISH_TXSTARTED: Publish configuration for event TXSTARTED
	// Position of CHIDX field.
	TWIM_PUBLISH_TXSTARTED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIM_PUBLISH_TXSTARTED_CHIDX_Msk = 0xff
	// Position of EN field.
	TWIM_PUBLISH_TXSTARTED_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIM_PUBLISH_TXSTARTED_EN_Msk = 0x80000000
	// Bit EN.
	TWIM_PUBLISH_TXSTARTED_EN = 0x80000000
	// Disable publishing
	TWIM_PUBLISH_TXSTARTED_EN_Disabled = 0x0
	// Enable publishing
	TWIM_PUBLISH_TXSTARTED_EN_Enabled = 0x1

	// PUBLISH_LASTRX: Publish configuration for event LASTRX
	// Position of CHIDX field.
	TWIM_PUBLISH_LASTRX_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIM_PUBLISH_LASTRX_CHIDX_Msk = 0xff
	// Position of EN field.
	TWIM_PUBLISH_LASTRX_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIM_PUBLISH_LASTRX_EN_Msk = 0x80000000
	// Bit EN.
	TWIM_PUBLISH_LASTRX_EN = 0x80000000
	// Disable publishing
	TWIM_PUBLISH_LASTRX_EN_Disabled = 0x0
	// Enable publishing
	TWIM_PUBLISH_LASTRX_EN_Enabled = 0x1

	// PUBLISH_LASTTX: Publish configuration for event LASTTX
	// Position of CHIDX field.
	TWIM_PUBLISH_LASTTX_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIM_PUBLISH_LASTTX_CHIDX_Msk = 0xff
	// Position of EN field.
	TWIM_PUBLISH_LASTTX_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIM_PUBLISH_LASTTX_EN_Msk = 0x80000000
	// Bit EN.
	TWIM_PUBLISH_LASTTX_EN = 0x80000000
	// Disable publishing
	TWIM_PUBLISH_LASTTX_EN_Disabled = 0x0
	// Enable publishing
	TWIM_PUBLISH_LASTTX_EN_Enabled = 0x1

	// SHORTS: Shortcuts between local events and tasks
	// Position of LASTTX_STARTRX field.
	TWIM_SHORTS_LASTTX_STARTRX_Pos = 0x7
	// Bit mask of LASTTX_STARTRX field.
	TWIM_SHORTS_LASTTX_STARTRX_Msk = 0x80
	// Bit LASTTX_STARTRX.
	TWIM_SHORTS_LASTTX_STARTRX = 0x80
	// Disable shortcut
	TWIM_SHORTS_LASTTX_STARTRX_Disabled = 0x0
	// Enable shortcut
	TWIM_SHORTS_LASTTX_STARTRX_Enabled = 0x1
	// Position of LASTTX_SUSPEND field.
	TWIM_SHORTS_LASTTX_SUSPEND_Pos = 0x8
	// Bit mask of LASTTX_SUSPEND field.
	TWIM_SHORTS_LASTTX_SUSPEND_Msk = 0x100
	// Bit LASTTX_SUSPEND.
	TWIM_SHORTS_LASTTX_SUSPEND = 0x100
	// Disable shortcut
	TWIM_SHORTS_LASTTX_SUSPEND_Disabled = 0x0
	// Enable shortcut
	TWIM_SHORTS_LASTTX_SUSPEND_Enabled = 0x1
	// Position of LASTTX_STOP field.
	TWIM_SHORTS_LASTTX_STOP_Pos = 0x9
	// Bit mask of LASTTX_STOP field.
	TWIM_SHORTS_LASTTX_STOP_Msk = 0x200
	// Bit LASTTX_STOP.
	TWIM_SHORTS_LASTTX_STOP = 0x200
	// Disable shortcut
	TWIM_SHORTS_LASTTX_STOP_Disabled = 0x0
	// Enable shortcut
	TWIM_SHORTS_LASTTX_STOP_Enabled = 0x1
	// Position of LASTRX_STARTTX field.
	TWIM_SHORTS_LASTRX_STARTTX_Pos = 0xa
	// Bit mask of LASTRX_STARTTX field.
	TWIM_SHORTS_LASTRX_STARTTX_Msk = 0x400
	// Bit LASTRX_STARTTX.
	TWIM_SHORTS_LASTRX_STARTTX = 0x400
	// Disable shortcut
	TWIM_SHORTS_LASTRX_STARTTX_Disabled = 0x0
	// Enable shortcut
	TWIM_SHORTS_LASTRX_STARTTX_Enabled = 0x1
	// Position of LASTRX_SUSPEND field.
	TWIM_SHORTS_LASTRX_SUSPEND_Pos = 0xb
	// Bit mask of LASTRX_SUSPEND field.
	TWIM_SHORTS_LASTRX_SUSPEND_Msk = 0x800
	// Bit LASTRX_SUSPEND.
	TWIM_SHORTS_LASTRX_SUSPEND = 0x800
	// Disable shortcut
	TWIM_SHORTS_LASTRX_SUSPEND_Disabled = 0x0
	// Enable shortcut
	TWIM_SHORTS_LASTRX_SUSPEND_Enabled = 0x1
	// Position of LASTRX_STOP field.
	TWIM_SHORTS_LASTRX_STOP_Pos = 0xc
	// Bit mask of LASTRX_STOP field.
	TWIM_SHORTS_LASTRX_STOP_Msk = 0x1000
	// Bit LASTRX_STOP.
	TWIM_SHORTS_LASTRX_STOP = 0x1000
	// Disable shortcut
	TWIM_SHORTS_LASTRX_STOP_Disabled = 0x0
	// Enable shortcut
	TWIM_SHORTS_LASTRX_STOP_Enabled = 0x1

	// INTEN: Enable or disable interrupt
	// Position of STOPPED field.
	TWIM_INTEN_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	TWIM_INTEN_STOPPED_Msk = 0x2
	// Bit STOPPED.
	TWIM_INTEN_STOPPED = 0x2
	// Disable
	TWIM_INTEN_STOPPED_Disabled = 0x0
	// Enable
	TWIM_INTEN_STOPPED_Enabled = 0x1
	// Position of ERROR field.
	TWIM_INTEN_ERROR_Pos = 0x9
	// Bit mask of ERROR field.
	TWIM_INTEN_ERROR_Msk = 0x200
	// Bit ERROR.
	TWIM_INTEN_ERROR = 0x200
	// Disable
	TWIM_INTEN_ERROR_Disabled = 0x0
	// Enable
	TWIM_INTEN_ERROR_Enabled = 0x1
	// Position of SUSPENDED field.
	TWIM_INTEN_SUSPENDED_Pos = 0x12
	// Bit mask of SUSPENDED field.
	TWIM_INTEN_SUSPENDED_Msk = 0x40000
	// Bit SUSPENDED.
	TWIM_INTEN_SUSPENDED = 0x40000
	// Disable
	TWIM_INTEN_SUSPENDED_Disabled = 0x0
	// Enable
	TWIM_INTEN_SUSPENDED_Enabled = 0x1
	// Position of RXSTARTED field.
	TWIM_INTEN_RXSTARTED_Pos = 0x13
	// Bit mask of RXSTARTED field.
	TWIM_INTEN_RXSTARTED_Msk = 0x80000
	// Bit RXSTARTED.
	TWIM_INTEN_RXSTARTED = 0x80000
	// Disable
	TWIM_INTEN_RXSTARTED_Disabled = 0x0
	// Enable
	TWIM_INTEN_RXSTARTED_Enabled = 0x1
	// Position of TXSTARTED field.
	TWIM_INTEN_TXSTARTED_Pos = 0x14
	// Bit mask of TXSTARTED field.
	TWIM_INTEN_TXSTARTED_Msk = 0x100000
	// Bit TXSTARTED.
	TWIM_INTEN_TXSTARTED = 0x100000
	// Disable
	TWIM_INTEN_TXSTARTED_Disabled = 0x0
	// Enable
	TWIM_INTEN_TXSTARTED_Enabled = 0x1
	// Position of LASTRX field.
	TWIM_INTEN_LASTRX_Pos = 0x17
	// Bit mask of LASTRX field.
	TWIM_INTEN_LASTRX_Msk = 0x800000
	// Bit LASTRX.
	TWIM_INTEN_LASTRX = 0x800000
	// Disable
	TWIM_INTEN_LASTRX_Disabled = 0x0
	// Enable
	TWIM_INTEN_LASTRX_Enabled = 0x1
	// Position of LASTTX field.
	TWIM_INTEN_LASTTX_Pos = 0x18
	// Bit mask of LASTTX field.
	TWIM_INTEN_LASTTX_Msk = 0x1000000
	// Bit LASTTX.
	TWIM_INTEN_LASTTX = 0x1000000
	// Disable
	TWIM_INTEN_LASTTX_Disabled = 0x0
	// Enable
	TWIM_INTEN_LASTTX_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of STOPPED field.
	TWIM_INTENSET_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	TWIM_INTENSET_STOPPED_Msk = 0x2
	// Bit STOPPED.
	TWIM_INTENSET_STOPPED = 0x2
	// Read: Disabled
	TWIM_INTENSET_STOPPED_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENSET_STOPPED_Enabled = 0x1
	// Enable
	TWIM_INTENSET_STOPPED_Set = 0x1
	// Position of ERROR field.
	TWIM_INTENSET_ERROR_Pos = 0x9
	// Bit mask of ERROR field.
	TWIM_INTENSET_ERROR_Msk = 0x200
	// Bit ERROR.
	TWIM_INTENSET_ERROR = 0x200
	// Read: Disabled
	TWIM_INTENSET_ERROR_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENSET_ERROR_Enabled = 0x1
	// Enable
	TWIM_INTENSET_ERROR_Set = 0x1
	// Position of SUSPENDED field.
	TWIM_INTENSET_SUSPENDED_Pos = 0x12
	// Bit mask of SUSPENDED field.
	TWIM_INTENSET_SUSPENDED_Msk = 0x40000
	// Bit SUSPENDED.
	TWIM_INTENSET_SUSPENDED = 0x40000
	// Read: Disabled
	TWIM_INTENSET_SUSPENDED_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENSET_SUSPENDED_Enabled = 0x1
	// Enable
	TWIM_INTENSET_SUSPENDED_Set = 0x1
	// Position of RXSTARTED field.
	TWIM_INTENSET_RXSTARTED_Pos = 0x13
	// Bit mask of RXSTARTED field.
	TWIM_INTENSET_RXSTARTED_Msk = 0x80000
	// Bit RXSTARTED.
	TWIM_INTENSET_RXSTARTED = 0x80000
	// Read: Disabled
	TWIM_INTENSET_RXSTARTED_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENSET_RXSTARTED_Enabled = 0x1
	// Enable
	TWIM_INTENSET_RXSTARTED_Set = 0x1
	// Position of TXSTARTED field.
	TWIM_INTENSET_TXSTARTED_Pos = 0x14
	// Bit mask of TXSTARTED field.
	TWIM_INTENSET_TXSTARTED_Msk = 0x100000
	// Bit TXSTARTED.
	TWIM_INTENSET_TXSTARTED = 0x100000
	// Read: Disabled
	TWIM_INTENSET_TXSTARTED_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENSET_TXSTARTED_Enabled = 0x1
	// Enable
	TWIM_INTENSET_TXSTARTED_Set = 0x1
	// Position of LASTRX field.
	TWIM_INTENSET_LASTRX_Pos = 0x17
	// Bit mask of LASTRX field.
	TWIM_INTENSET_LASTRX_Msk = 0x800000
	// Bit LASTRX.
	TWIM_INTENSET_LASTRX = 0x800000
	// Read: Disabled
	TWIM_INTENSET_LASTRX_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENSET_LASTRX_Enabled = 0x1
	// Enable
	TWIM_INTENSET_LASTRX_Set = 0x1
	// Position of LASTTX field.
	TWIM_INTENSET_LASTTX_Pos = 0x18
	// Bit mask of LASTTX field.
	TWIM_INTENSET_LASTTX_Msk = 0x1000000
	// Bit LASTTX.
	TWIM_INTENSET_LASTTX = 0x1000000
	// Read: Disabled
	TWIM_INTENSET_LASTTX_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENSET_LASTTX_Enabled = 0x1
	// Enable
	TWIM_INTENSET_LASTTX_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of STOPPED field.
	TWIM_INTENCLR_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	TWIM_INTENCLR_STOPPED_Msk = 0x2
	// Bit STOPPED.
	TWIM_INTENCLR_STOPPED = 0x2
	// Read: Disabled
	TWIM_INTENCLR_STOPPED_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENCLR_STOPPED_Enabled = 0x1
	// Disable
	TWIM_INTENCLR_STOPPED_Clear = 0x1
	// Position of ERROR field.
	TWIM_INTENCLR_ERROR_Pos = 0x9
	// Bit mask of ERROR field.
	TWIM_INTENCLR_ERROR_Msk = 0x200
	// Bit ERROR.
	TWIM_INTENCLR_ERROR = 0x200
	// Read: Disabled
	TWIM_INTENCLR_ERROR_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENCLR_ERROR_Enabled = 0x1
	// Disable
	TWIM_INTENCLR_ERROR_Clear = 0x1
	// Position of SUSPENDED field.
	TWIM_INTENCLR_SUSPENDED_Pos = 0x12
	// Bit mask of SUSPENDED field.
	TWIM_INTENCLR_SUSPENDED_Msk = 0x40000
	// Bit SUSPENDED.
	TWIM_INTENCLR_SUSPENDED = 0x40000
	// Read: Disabled
	TWIM_INTENCLR_SUSPENDED_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENCLR_SUSPENDED_Enabled = 0x1
	// Disable
	TWIM_INTENCLR_SUSPENDED_Clear = 0x1
	// Position of RXSTARTED field.
	TWIM_INTENCLR_RXSTARTED_Pos = 0x13
	// Bit mask of RXSTARTED field.
	TWIM_INTENCLR_RXSTARTED_Msk = 0x80000
	// Bit RXSTARTED.
	TWIM_INTENCLR_RXSTARTED = 0x80000
	// Read: Disabled
	TWIM_INTENCLR_RXSTARTED_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENCLR_RXSTARTED_Enabled = 0x1
	// Disable
	TWIM_INTENCLR_RXSTARTED_Clear = 0x1
	// Position of TXSTARTED field.
	TWIM_INTENCLR_TXSTARTED_Pos = 0x14
	// Bit mask of TXSTARTED field.
	TWIM_INTENCLR_TXSTARTED_Msk = 0x100000
	// Bit TXSTARTED.
	TWIM_INTENCLR_TXSTARTED = 0x100000
	// Read: Disabled
	TWIM_INTENCLR_TXSTARTED_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENCLR_TXSTARTED_Enabled = 0x1
	// Disable
	TWIM_INTENCLR_TXSTARTED_Clear = 0x1
	// Position of LASTRX field.
	TWIM_INTENCLR_LASTRX_Pos = 0x17
	// Bit mask of LASTRX field.
	TWIM_INTENCLR_LASTRX_Msk = 0x800000
	// Bit LASTRX.
	TWIM_INTENCLR_LASTRX = 0x800000
	// Read: Disabled
	TWIM_INTENCLR_LASTRX_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENCLR_LASTRX_Enabled = 0x1
	// Disable
	TWIM_INTENCLR_LASTRX_Clear = 0x1
	// Position of LASTTX field.
	TWIM_INTENCLR_LASTTX_Pos = 0x18
	// Bit mask of LASTTX field.
	TWIM_INTENCLR_LASTTX_Msk = 0x1000000
	// Bit LASTTX.
	TWIM_INTENCLR_LASTTX = 0x1000000
	// Read: Disabled
	TWIM_INTENCLR_LASTTX_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENCLR_LASTTX_Enabled = 0x1
	// Disable
	TWIM_INTENCLR_LASTTX_Clear = 0x1

	// ERRORSRC: Error source
	// Position of OVERRUN field.
	TWIM_ERRORSRC_OVERRUN_Pos = 0x0
	// Bit mask of OVERRUN field.
	TWIM_ERRORSRC_OVERRUN_Msk = 0x1
	// Bit OVERRUN.
	TWIM_ERRORSRC_OVERRUN = 0x1
	// Error did not occur
	TWIM_ERRORSRC_OVERRUN_NotReceived = 0x0
	// Error occurred
	TWIM_ERRORSRC_OVERRUN_Received = 0x1
	// Position of ANACK field.
	TWIM_ERRORSRC_ANACK_Pos = 0x1
	// Bit mask of ANACK field.
	TWIM_ERRORSRC_ANACK_Msk = 0x2
	// Bit ANACK.
	TWIM_ERRORSRC_ANACK = 0x2
	// Error did not occur
	TWIM_ERRORSRC_ANACK_NotReceived = 0x0
	// Error occurred
	TWIM_ERRORSRC_ANACK_Received = 0x1
	// Position of DNACK field.
	TWIM_ERRORSRC_DNACK_Pos = 0x2
	// Bit mask of DNACK field.
	TWIM_ERRORSRC_DNACK_Msk = 0x4
	// Bit DNACK.
	TWIM_ERRORSRC_DNACK = 0x4
	// Error did not occur
	TWIM_ERRORSRC_DNACK_NotReceived = 0x0
	// Error occurred
	TWIM_ERRORSRC_DNACK_Received = 0x1

	// ENABLE: Enable TWIM
	// Position of ENABLE field.
	TWIM_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	TWIM_ENABLE_ENABLE_Msk = 0xf
	// Disable TWIM
	TWIM_ENABLE_ENABLE_Disabled = 0x0
	// Enable TWIM
	TWIM_ENABLE_ENABLE_Enabled = 0x6

	// PSEL.SCL: Pin select for SCL signal
	// Position of PIN field.
	TWIM_PSEL_SCL_PIN_Pos = 0x0
	// Bit mask of PIN field.
	TWIM_PSEL_SCL_PIN_Msk = 0x1f
	// Position of PORT field.
	TWIM_PSEL_SCL_PORT_Pos = 0x5
	// Bit mask of PORT field.
	TWIM_PSEL_SCL_PORT_Msk = 0x20
	// Bit PORT.
	TWIM_PSEL_SCL_PORT = 0x20
	// Position of CONNECT field.
	TWIM_PSEL_SCL_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	TWIM_PSEL_SCL_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	TWIM_PSEL_SCL_CONNECT = 0x80000000
	// Disconnect
	TWIM_PSEL_SCL_CONNECT_Disconnected = 0x1
	// Connect
	TWIM_PSEL_SCL_CONNECT_Connected = 0x0

	// PSEL.SDA: Pin select for SDA signal
	// Position of PIN field.
	TWIM_PSEL_SDA_PIN_Pos = 0x0
	// Bit mask of PIN field.
	TWIM_PSEL_SDA_PIN_Msk = 0x1f
	// Position of PORT field.
	TWIM_PSEL_SDA_PORT_Pos = 0x5
	// Bit mask of PORT field.
	TWIM_PSEL_SDA_PORT_Msk = 0x20
	// Bit PORT.
	TWIM_PSEL_SDA_PORT = 0x20
	// Position of CONNECT field.
	TWIM_PSEL_SDA_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	TWIM_PSEL_SDA_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	TWIM_PSEL_SDA_CONNECT = 0x80000000
	// Disconnect
	TWIM_PSEL_SDA_CONNECT_Disconnected = 0x1
	// Connect
	TWIM_PSEL_SDA_CONNECT_Connected = 0x0

	// FREQUENCY: TWI frequency. Accuracy depends on the HFCLK source selected.
	// Position of FREQUENCY field.
	TWIM_FREQUENCY_FREQUENCY_Pos = 0x0
	// Bit mask of FREQUENCY field.
	TWIM_FREQUENCY_FREQUENCY_Msk = 0xffffffff
	// 100 kbps
	TWIM_FREQUENCY_FREQUENCY_K100 = 0x1980000
	// 250 kbps
	TWIM_FREQUENCY_FREQUENCY_K250 = 0x4000000
	// 400 kbps
	TWIM_FREQUENCY_FREQUENCY_K400 = 0x6400000
	// 1000 kbps
	TWIM_FREQUENCY_FREQUENCY_K1000 = 0xff00000

	// RXD.PTR: Data pointer
	// Position of PTR field.
	TWIM_RXD_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	TWIM_RXD_PTR_PTR_Msk = 0xffffffff

	// RXD.MAXCNT: Maximum number of bytes in receive buffer
	// Position of MAXCNT field.
	TWIM_RXD_MAXCNT_MAXCNT_Pos = 0x0
	// Bit mask of MAXCNT field.
	TWIM_RXD_MAXCNT_MAXCNT_Msk = 0xffff

	// RXD.AMOUNT: Number of bytes transferred in the last transaction
	// Position of AMOUNT field.
	TWIM_RXD_AMOUNT_AMOUNT_Pos = 0x0
	// Bit mask of AMOUNT field.
	TWIM_RXD_AMOUNT_AMOUNT_Msk = 0xffff

	// RXD.LIST: EasyDMA list type
	// Position of LIST field.
	TWIM_RXD_LIST_LIST_Pos = 0x0
	// Bit mask of LIST field.
	TWIM_RXD_LIST_LIST_Msk = 0x7
	// Disable EasyDMA list
	TWIM_RXD_LIST_LIST_Disabled = 0x0
	// Use array list
	TWIM_RXD_LIST_LIST_ArrayList = 0x1

	// TXD.PTR: Data pointer
	// Position of PTR field.
	TWIM_TXD_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	TWIM_TXD_PTR_PTR_Msk = 0xffffffff

	// TXD.MAXCNT: Maximum number of bytes in transmit buffer
	// Position of MAXCNT field.
	TWIM_TXD_MAXCNT_MAXCNT_Pos = 0x0
	// Bit mask of MAXCNT field.
	TWIM_TXD_MAXCNT_MAXCNT_Msk = 0xffff

	// TXD.AMOUNT: Number of bytes transferred in the last transaction
	// Position of AMOUNT field.
	TWIM_TXD_AMOUNT_AMOUNT_Pos = 0x0
	// Bit mask of AMOUNT field.
	TWIM_TXD_AMOUNT_AMOUNT_Msk = 0xffff

	// TXD.LIST: EasyDMA list type
	// Position of LIST field.
	TWIM_TXD_LIST_LIST_Pos = 0x0
	// Bit mask of LIST field.
	TWIM_TXD_LIST_LIST_Msk = 0x7
	// Disable EasyDMA list
	TWIM_TXD_LIST_LIST_Disabled = 0x0
	// Use array list
	TWIM_TXD_LIST_LIST_ArrayList = 0x1

	// ADDRESS: Address used in the TWI transfer
	// Position of ADDRESS field.
	TWIM_ADDRESS_ADDRESS_Pos = 0x0
	// Bit mask of ADDRESS field.
	TWIM_ADDRESS_ADDRESS_Msk = 0x7f
)

// Bitfields for TWIS0_NS: I2C compatible Two-Wire Slave Interface with EasyDMA
const (
	// TASKS_STOP: Stop TWI transaction
	// Position of TASKS_STOP field.
	TWIS_TASKS_STOP_TASKS_STOP_Pos = 0x0
	// Bit mask of TASKS_STOP field.
	TWIS_TASKS_STOP_TASKS_STOP_Msk = 0x1
	// Bit TASKS_STOP.
	TWIS_TASKS_STOP_TASKS_STOP = 0x1
	// Trigger task
	TWIS_TASKS_STOP_TASKS_STOP_Trigger = 0x1

	// TASKS_SUSPEND: Suspend TWI transaction
	// Position of TASKS_SUSPEND field.
	TWIS_TASKS_SUSPEND_TASKS_SUSPEND_Pos = 0x0
	// Bit mask of TASKS_SUSPEND field.
	TWIS_TASKS_SUSPEND_TASKS_SUSPEND_Msk = 0x1
	// Bit TASKS_SUSPEND.
	TWIS_TASKS_SUSPEND_TASKS_SUSPEND = 0x1
	// Trigger task
	TWIS_TASKS_SUSPEND_TASKS_SUSPEND_Trigger = 0x1

	// TASKS_RESUME: Resume TWI transaction
	// Position of TASKS_RESUME field.
	TWIS_TASKS_RESUME_TASKS_RESUME_Pos = 0x0
	// Bit mask of TASKS_RESUME field.
	TWIS_TASKS_RESUME_TASKS_RESUME_Msk = 0x1
	// Bit TASKS_RESUME.
	TWIS_TASKS_RESUME_TASKS_RESUME = 0x1
	// Trigger task
	TWIS_TASKS_RESUME_TASKS_RESUME_Trigger = 0x1

	// TASKS_PREPARERX: Prepare the TWI slave to respond to a write command
	// Position of TASKS_PREPARERX field.
	TWIS_TASKS_PREPARERX_TASKS_PREPARERX_Pos = 0x0
	// Bit mask of TASKS_PREPARERX field.
	TWIS_TASKS_PREPARERX_TASKS_PREPARERX_Msk = 0x1
	// Bit TASKS_PREPARERX.
	TWIS_TASKS_PREPARERX_TASKS_PREPARERX = 0x1
	// Trigger task
	TWIS_TASKS_PREPARERX_TASKS_PREPARERX_Trigger = 0x1

	// TASKS_PREPARETX: Prepare the TWI slave to respond to a read command
	// Position of TASKS_PREPARETX field.
	TWIS_TASKS_PREPARETX_TASKS_PREPARETX_Pos = 0x0
	// Bit mask of TASKS_PREPARETX field.
	TWIS_TASKS_PREPARETX_TASKS_PREPARETX_Msk = 0x1
	// Bit TASKS_PREPARETX.
	TWIS_TASKS_PREPARETX_TASKS_PREPARETX = 0x1
	// Trigger task
	TWIS_TASKS_PREPARETX_TASKS_PREPARETX_Trigger = 0x1

	// SUBSCRIBE_STOP: Subscribe configuration for task STOP
	// Position of CHIDX field.
	TWIS_SUBSCRIBE_STOP_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIS_SUBSCRIBE_STOP_CHIDX_Msk = 0xff
	// Position of EN field.
	TWIS_SUBSCRIBE_STOP_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIS_SUBSCRIBE_STOP_EN_Msk = 0x80000000
	// Bit EN.
	TWIS_SUBSCRIBE_STOP_EN = 0x80000000
	// Disable subscription
	TWIS_SUBSCRIBE_STOP_EN_Disabled = 0x0
	// Enable subscription
	TWIS_SUBSCRIBE_STOP_EN_Enabled = 0x1

	// SUBSCRIBE_SUSPEND: Subscribe configuration for task SUSPEND
	// Position of CHIDX field.
	TWIS_SUBSCRIBE_SUSPEND_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIS_SUBSCRIBE_SUSPEND_CHIDX_Msk = 0xff
	// Position of EN field.
	TWIS_SUBSCRIBE_SUSPEND_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIS_SUBSCRIBE_SUSPEND_EN_Msk = 0x80000000
	// Bit EN.
	TWIS_SUBSCRIBE_SUSPEND_EN = 0x80000000
	// Disable subscription
	TWIS_SUBSCRIBE_SUSPEND_EN_Disabled = 0x0
	// Enable subscription
	TWIS_SUBSCRIBE_SUSPEND_EN_Enabled = 0x1

	// SUBSCRIBE_RESUME: Subscribe configuration for task RESUME
	// Position of CHIDX field.
	TWIS_SUBSCRIBE_RESUME_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIS_SUBSCRIBE_RESUME_CHIDX_Msk = 0xff
	// Position of EN field.
	TWIS_SUBSCRIBE_RESUME_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIS_SUBSCRIBE_RESUME_EN_Msk = 0x80000000
	// Bit EN.
	TWIS_SUBSCRIBE_RESUME_EN = 0x80000000
	// Disable subscription
	TWIS_SUBSCRIBE_RESUME_EN_Disabled = 0x0
	// Enable subscription
	TWIS_SUBSCRIBE_RESUME_EN_Enabled = 0x1

	// SUBSCRIBE_PREPARERX: Subscribe configuration for task PREPARERX
	// Position of CHIDX field.
	TWIS_SUBSCRIBE_PREPARERX_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIS_SUBSCRIBE_PREPARERX_CHIDX_Msk = 0xff
	// Position of EN field.
	TWIS_SUBSCRIBE_PREPARERX_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIS_SUBSCRIBE_PREPARERX_EN_Msk = 0x80000000
	// Bit EN.
	TWIS_SUBSCRIBE_PREPARERX_EN = 0x80000000
	// Disable subscription
	TWIS_SUBSCRIBE_PREPARERX_EN_Disabled = 0x0
	// Enable subscription
	TWIS_SUBSCRIBE_PREPARERX_EN_Enabled = 0x1

	// SUBSCRIBE_PREPARETX: Subscribe configuration for task PREPARETX
	// Position of CHIDX field.
	TWIS_SUBSCRIBE_PREPARETX_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIS_SUBSCRIBE_PREPARETX_CHIDX_Msk = 0xff
	// Position of EN field.
	TWIS_SUBSCRIBE_PREPARETX_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIS_SUBSCRIBE_PREPARETX_EN_Msk = 0x80000000
	// Bit EN.
	TWIS_SUBSCRIBE_PREPARETX_EN = 0x80000000
	// Disable subscription
	TWIS_SUBSCRIBE_PREPARETX_EN_Disabled = 0x0
	// Enable subscription
	TWIS_SUBSCRIBE_PREPARETX_EN_Enabled = 0x1

	// EVENTS_STOPPED: TWI stopped
	// Position of EVENTS_STOPPED field.
	TWIS_EVENTS_STOPPED_EVENTS_STOPPED_Pos = 0x0
	// Bit mask of EVENTS_STOPPED field.
	TWIS_EVENTS_STOPPED_EVENTS_STOPPED_Msk = 0x1
	// Bit EVENTS_STOPPED.
	TWIS_EVENTS_STOPPED_EVENTS_STOPPED = 0x1
	// Event not generated
	TWIS_EVENTS_STOPPED_EVENTS_STOPPED_NotGenerated = 0x0
	// Event generated
	TWIS_EVENTS_STOPPED_EVENTS_STOPPED_Generated = 0x1

	// EVENTS_ERROR: TWI error
	// Position of EVENTS_ERROR field.
	TWIS_EVENTS_ERROR_EVENTS_ERROR_Pos = 0x0
	// Bit mask of EVENTS_ERROR field.
	TWIS_EVENTS_ERROR_EVENTS_ERROR_Msk = 0x1
	// Bit EVENTS_ERROR.
	TWIS_EVENTS_ERROR_EVENTS_ERROR = 0x1
	// Event not generated
	TWIS_EVENTS_ERROR_EVENTS_ERROR_NotGenerated = 0x0
	// Event generated
	TWIS_EVENTS_ERROR_EVENTS_ERROR_Generated = 0x1

	// EVENTS_RXSTARTED: Receive sequence started
	// Position of EVENTS_RXSTARTED field.
	TWIS_EVENTS_RXSTARTED_EVENTS_RXSTARTED_Pos = 0x0
	// Bit mask of EVENTS_RXSTARTED field.
	TWIS_EVENTS_RXSTARTED_EVENTS_RXSTARTED_Msk = 0x1
	// Bit EVENTS_RXSTARTED.
	TWIS_EVENTS_RXSTARTED_EVENTS_RXSTARTED = 0x1
	// Event not generated
	TWIS_EVENTS_RXSTARTED_EVENTS_RXSTARTED_NotGenerated = 0x0
	// Event generated
	TWIS_EVENTS_RXSTARTED_EVENTS_RXSTARTED_Generated = 0x1

	// EVENTS_TXSTARTED: Transmit sequence started
	// Position of EVENTS_TXSTARTED field.
	TWIS_EVENTS_TXSTARTED_EVENTS_TXSTARTED_Pos = 0x0
	// Bit mask of EVENTS_TXSTARTED field.
	TWIS_EVENTS_TXSTARTED_EVENTS_TXSTARTED_Msk = 0x1
	// Bit EVENTS_TXSTARTED.
	TWIS_EVENTS_TXSTARTED_EVENTS_TXSTARTED = 0x1
	// Event not generated
	TWIS_EVENTS_TXSTARTED_EVENTS_TXSTARTED_NotGenerated = 0x0
	// Event generated
	TWIS_EVENTS_TXSTARTED_EVENTS_TXSTARTED_Generated = 0x1

	// EVENTS_WRITE: Write command received
	// Position of EVENTS_WRITE field.
	TWIS_EVENTS_WRITE_EVENTS_WRITE_Pos = 0x0
	// Bit mask of EVENTS_WRITE field.
	TWIS_EVENTS_WRITE_EVENTS_WRITE_Msk = 0x1
	// Bit EVENTS_WRITE.
	TWIS_EVENTS_WRITE_EVENTS_WRITE = 0x1
	// Event not generated
	TWIS_EVENTS_WRITE_EVENTS_WRITE_NotGenerated = 0x0
	// Event generated
	TWIS_EVENTS_WRITE_EVENTS_WRITE_Generated = 0x1

	// EVENTS_READ: Read command received
	// Position of EVENTS_READ field.
	TWIS_EVENTS_READ_EVENTS_READ_Pos = 0x0
	// Bit mask of EVENTS_READ field.
	TWIS_EVENTS_READ_EVENTS_READ_Msk = 0x1
	// Bit EVENTS_READ.
	TWIS_EVENTS_READ_EVENTS_READ = 0x1
	// Event not generated
	TWIS_EVENTS_READ_EVENTS_READ_NotGenerated = 0x0
	// Event generated
	TWIS_EVENTS_READ_EVENTS_READ_Generated = 0x1

	// PUBLISH_STOPPED: Publish configuration for event STOPPED
	// Position of CHIDX field.
	TWIS_PUBLISH_STOPPED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIS_PUBLISH_STOPPED_CHIDX_Msk = 0xff
	// Position of EN field.
	TWIS_PUBLISH_STOPPED_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIS_PUBLISH_STOPPED_EN_Msk = 0x80000000
	// Bit EN.
	TWIS_PUBLISH_STOPPED_EN = 0x80000000
	// Disable publishing
	TWIS_PUBLISH_STOPPED_EN_Disabled = 0x0
	// Enable publishing
	TWIS_PUBLISH_STOPPED_EN_Enabled = 0x1

	// PUBLISH_ERROR: Publish configuration for event ERROR
	// Position of CHIDX field.
	TWIS_PUBLISH_ERROR_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIS_PUBLISH_ERROR_CHIDX_Msk = 0xff
	// Position of EN field.
	TWIS_PUBLISH_ERROR_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIS_PUBLISH_ERROR_EN_Msk = 0x80000000
	// Bit EN.
	TWIS_PUBLISH_ERROR_EN = 0x80000000
	// Disable publishing
	TWIS_PUBLISH_ERROR_EN_Disabled = 0x0
	// Enable publishing
	TWIS_PUBLISH_ERROR_EN_Enabled = 0x1

	// PUBLISH_RXSTARTED: Publish configuration for event RXSTARTED
	// Position of CHIDX field.
	TWIS_PUBLISH_RXSTARTED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIS_PUBLISH_RXSTARTED_CHIDX_Msk = 0xff
	// Position of EN field.
	TWIS_PUBLISH_RXSTARTED_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIS_PUBLISH_RXSTARTED_EN_Msk = 0x80000000
	// Bit EN.
	TWIS_PUBLISH_RXSTARTED_EN = 0x80000000
	// Disable publishing
	TWIS_PUBLISH_RXSTARTED_EN_Disabled = 0x0
	// Enable publishing
	TWIS_PUBLISH_RXSTARTED_EN_Enabled = 0x1

	// PUBLISH_TXSTARTED: Publish configuration for event TXSTARTED
	// Position of CHIDX field.
	TWIS_PUBLISH_TXSTARTED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIS_PUBLISH_TXSTARTED_CHIDX_Msk = 0xff
	// Position of EN field.
	TWIS_PUBLISH_TXSTARTED_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIS_PUBLISH_TXSTARTED_EN_Msk = 0x80000000
	// Bit EN.
	TWIS_PUBLISH_TXSTARTED_EN = 0x80000000
	// Disable publishing
	TWIS_PUBLISH_TXSTARTED_EN_Disabled = 0x0
	// Enable publishing
	TWIS_PUBLISH_TXSTARTED_EN_Enabled = 0x1

	// PUBLISH_WRITE: Publish configuration for event WRITE
	// Position of CHIDX field.
	TWIS_PUBLISH_WRITE_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIS_PUBLISH_WRITE_CHIDX_Msk = 0xff
	// Position of EN field.
	TWIS_PUBLISH_WRITE_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIS_PUBLISH_WRITE_EN_Msk = 0x80000000
	// Bit EN.
	TWIS_PUBLISH_WRITE_EN = 0x80000000
	// Disable publishing
	TWIS_PUBLISH_WRITE_EN_Disabled = 0x0
	// Enable publishing
	TWIS_PUBLISH_WRITE_EN_Enabled = 0x1

	// PUBLISH_READ: Publish configuration for event READ
	// Position of CHIDX field.
	TWIS_PUBLISH_READ_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIS_PUBLISH_READ_CHIDX_Msk = 0xff
	// Position of EN field.
	TWIS_PUBLISH_READ_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIS_PUBLISH_READ_EN_Msk = 0x80000000
	// Bit EN.
	TWIS_PUBLISH_READ_EN = 0x80000000
	// Disable publishing
	TWIS_PUBLISH_READ_EN_Disabled = 0x0
	// Enable publishing
	TWIS_PUBLISH_READ_EN_Enabled = 0x1

	// SHORTS: Shortcuts between local events and tasks
	// Position of WRITE_SUSPEND field.
	TWIS_SHORTS_WRITE_SUSPEND_Pos = 0xd
	// Bit mask of WRITE_SUSPEND field.
	TWIS_SHORTS_WRITE_SUSPEND_Msk = 0x2000
	// Bit WRITE_SUSPEND.
	TWIS_SHORTS_WRITE_SUSPEND = 0x2000
	// Disable shortcut
	TWIS_SHORTS_WRITE_SUSPEND_Disabled = 0x0
	// Enable shortcut
	TWIS_SHORTS_WRITE_SUSPEND_Enabled = 0x1
	// Position of READ_SUSPEND field.
	TWIS_SHORTS_READ_SUSPEND_Pos = 0xe
	// Bit mask of READ_SUSPEND field.
	TWIS_SHORTS_READ_SUSPEND_Msk = 0x4000
	// Bit READ_SUSPEND.
	TWIS_SHORTS_READ_SUSPEND = 0x4000
	// Disable shortcut
	TWIS_SHORTS_READ_SUSPEND_Disabled = 0x0
	// Enable shortcut
	TWIS_SHORTS_READ_SUSPEND_Enabled = 0x1

	// INTEN: Enable or disable interrupt
	// Position of STOPPED field.
	TWIS_INTEN_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	TWIS_INTEN_STOPPED_Msk = 0x2
	// Bit STOPPED.
	TWIS_INTEN_STOPPED = 0x2
	// Disable
	TWIS_INTEN_STOPPED_Disabled = 0x0
	// Enable
	TWIS_INTEN_STOPPED_Enabled = 0x1
	// Position of ERROR field.
	TWIS_INTEN_ERROR_Pos = 0x9
	// Bit mask of ERROR field.
	TWIS_INTEN_ERROR_Msk = 0x200
	// Bit ERROR.
	TWIS_INTEN_ERROR = 0x200
	// Disable
	TWIS_INTEN_ERROR_Disabled = 0x0
	// Enable
	TWIS_INTEN_ERROR_Enabled = 0x1
	// Position of RXSTARTED field.
	TWIS_INTEN_RXSTARTED_Pos = 0x13
	// Bit mask of RXSTARTED field.
	TWIS_INTEN_RXSTARTED_Msk = 0x80000
	// Bit RXSTARTED.
	TWIS_INTEN_RXSTARTED = 0x80000
	// Disable
	TWIS_INTEN_RXSTARTED_Disabled = 0x0
	// Enable
	TWIS_INTEN_RXSTARTED_Enabled = 0x1
	// Position of TXSTARTED field.
	TWIS_INTEN_TXSTARTED_Pos = 0x14
	// Bit mask of TXSTARTED field.
	TWIS_INTEN_TXSTARTED_Msk = 0x100000
	// Bit TXSTARTED.
	TWIS_INTEN_TXSTARTED = 0x100000
	// Disable
	TWIS_INTEN_TXSTARTED_Disabled = 0x0
	// Enable
	TWIS_INTEN_TXSTARTED_Enabled = 0x1
	// Position of WRITE field.
	TWIS_INTEN_WRITE_Pos = 0x19
	// Bit mask of WRITE field.
	TWIS_INTEN_WRITE_Msk = 0x2000000
	// Bit WRITE.
	TWIS_INTEN_WRITE = 0x2000000
	// Disable
	TWIS_INTEN_WRITE_Disabled = 0x0
	// Enable
	TWIS_INTEN_WRITE_Enabled = 0x1
	// Position of READ field.
	TWIS_INTEN_READ_Pos = 0x1a
	// Bit mask of READ field.
	TWIS_INTEN_READ_Msk = 0x4000000
	// Bit READ.
	TWIS_INTEN_READ = 0x4000000
	// Disable
	TWIS_INTEN_READ_Disabled = 0x0
	// Enable
	TWIS_INTEN_READ_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of STOPPED field.
	TWIS_INTENSET_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	TWIS_INTENSET_STOPPED_Msk = 0x2
	// Bit STOPPED.
	TWIS_INTENSET_STOPPED = 0x2
	// Read: Disabled
	TWIS_INTENSET_STOPPED_Disabled = 0x0
	// Read: Enabled
	TWIS_INTENSET_STOPPED_Enabled = 0x1
	// Enable
	TWIS_INTENSET_STOPPED_Set = 0x1
	// Position of ERROR field.
	TWIS_INTENSET_ERROR_Pos = 0x9
	// Bit mask of ERROR field.
	TWIS_INTENSET_ERROR_Msk = 0x200
	// Bit ERROR.
	TWIS_INTENSET_ERROR = 0x200
	// Read: Disabled
	TWIS_INTENSET_ERROR_Disabled = 0x0
	// Read: Enabled
	TWIS_INTENSET_ERROR_Enabled = 0x1
	// Enable
	TWIS_INTENSET_ERROR_Set = 0x1
	// Position of RXSTARTED field.
	TWIS_INTENSET_RXSTARTED_Pos = 0x13
	// Bit mask of RXSTARTED field.
	TWIS_INTENSET_RXSTARTED_Msk = 0x80000
	// Bit RXSTARTED.
	TWIS_INTENSET_RXSTARTED = 0x80000
	// Read: Disabled
	TWIS_INTENSET_RXSTARTED_Disabled = 0x0
	// Read: Enabled
	TWIS_INTENSET_RXSTARTED_Enabled = 0x1
	// Enable
	TWIS_INTENSET_RXSTARTED_Set = 0x1
	// Position of TXSTARTED field.
	TWIS_INTENSET_TXSTARTED_Pos = 0x14
	// Bit mask of TXSTARTED field.
	TWIS_INTENSET_TXSTARTED_Msk = 0x100000
	// Bit TXSTARTED.
	TWIS_INTENSET_TXSTARTED = 0x100000
	// Read: Disabled
	TWIS_INTENSET_TXSTARTED_Disabled = 0x0
	// Read: Enabled
	TWIS_INTENSET_TXSTARTED_Enabled = 0x1
	// Enable
	TWIS_INTENSET_TXSTARTED_Set = 0x1
	// Position of WRITE field.
	TWIS_INTENSET_WRITE_Pos = 0x19
	// Bit mask of WRITE field.
	TWIS_INTENSET_WRITE_Msk = 0x2000000
	// Bit WRITE.
	TWIS_INTENSET_WRITE = 0x2000000
	// Read: Disabled
	TWIS_INTENSET_WRITE_Disabled = 0x0
	// Read: Enabled
	TWIS_INTENSET_WRITE_Enabled = 0x1
	// Enable
	TWIS_INTENSET_WRITE_Set = 0x1
	// Position of READ field.
	TWIS_INTENSET_READ_Pos = 0x1a
	// Bit mask of READ field.
	TWIS_INTENSET_READ_Msk = 0x4000000
	// Bit READ.
	TWIS_INTENSET_READ = 0x4000000
	// Read: Disabled
	TWIS_INTENSET_READ_Disabled = 0x0
	// Read: Enabled
	TWIS_INTENSET_READ_Enabled = 0x1
	// Enable
	TWIS_INTENSET_READ_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of STOPPED field.
	TWIS_INTENCLR_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	TWIS_INTENCLR_STOPPED_Msk = 0x2
	// Bit STOPPED.
	TWIS_INTENCLR_STOPPED = 0x2
	// Read: Disabled
	TWIS_INTENCLR_STOPPED_Disabled = 0x0
	// Read: Enabled
	TWIS_INTENCLR_STOPPED_Enabled = 0x1
	// Disable
	TWIS_INTENCLR_STOPPED_Clear = 0x1
	// Position of ERROR field.
	TWIS_INTENCLR_ERROR_Pos = 0x9
	// Bit mask of ERROR field.
	TWIS_INTENCLR_ERROR_Msk = 0x200
	// Bit ERROR.
	TWIS_INTENCLR_ERROR = 0x200
	// Read: Disabled
	TWIS_INTENCLR_ERROR_Disabled = 0x0
	// Read: Enabled
	TWIS_INTENCLR_ERROR_Enabled = 0x1
	// Disable
	TWIS_INTENCLR_ERROR_Clear = 0x1
	// Position of RXSTARTED field.
	TWIS_INTENCLR_RXSTARTED_Pos = 0x13
	// Bit mask of RXSTARTED field.
	TWIS_INTENCLR_RXSTARTED_Msk = 0x80000
	// Bit RXSTARTED.
	TWIS_INTENCLR_RXSTARTED = 0x80000
	// Read: Disabled
	TWIS_INTENCLR_RXSTARTED_Disabled = 0x0
	// Read: Enabled
	TWIS_INTENCLR_RXSTARTED_Enabled = 0x1
	// Disable
	TWIS_INTENCLR_RXSTARTED_Clear = 0x1
	// Position of TXSTARTED field.
	TWIS_INTENCLR_TXSTARTED_Pos = 0x14
	// Bit mask of TXSTARTED field.
	TWIS_INTENCLR_TXSTARTED_Msk = 0x100000
	// Bit TXSTARTED.
	TWIS_INTENCLR_TXSTARTED = 0x100000
	// Read: Disabled
	TWIS_INTENCLR_TXSTARTED_Disabled = 0x0
	// Read: Enabled
	TWIS_INTENCLR_TXSTARTED_Enabled = 0x1
	// Disable
	TWIS_INTENCLR_TXSTARTED_Clear = 0x1
	// Position of WRITE field.
	TWIS_INTENCLR_WRITE_Pos = 0x19
	// Bit mask of WRITE field.
	TWIS_INTENCLR_WRITE_Msk = 0x2000000
	// Bit WRITE.
	TWIS_INTENCLR_WRITE = 0x2000000
	// Read: Disabled
	TWIS_INTENCLR_WRITE_Disabled = 0x0
	// Read: Enabled
	TWIS_INTENCLR_WRITE_Enabled = 0x1
	// Disable
	TWIS_INTENCLR_WRITE_Clear = 0x1
	// Position of READ field.
	TWIS_INTENCLR_READ_Pos = 0x1a
	// Bit mask of READ field.
	TWIS_INTENCLR_READ_Msk = 0x4000000
	// Bit READ.
	TWIS_INTENCLR_READ = 0x4000000
	// Read: Disabled
	TWIS_INTENCLR_READ_Disabled = 0x0
	// Read: Enabled
	TWIS_INTENCLR_READ_Enabled = 0x1
	// Disable
	TWIS_INTENCLR_READ_Clear = 0x1

	// ERRORSRC: Error source
	// Position of OVERFLOW field.
	TWIS_ERRORSRC_OVERFLOW_Pos = 0x0
	// Bit mask of OVERFLOW field.
	TWIS_ERRORSRC_OVERFLOW_Msk = 0x1
	// Bit OVERFLOW.
	TWIS_ERRORSRC_OVERFLOW = 0x1
	// Error did not occur
	TWIS_ERRORSRC_OVERFLOW_NotDetected = 0x0
	// Error occurred
	TWIS_ERRORSRC_OVERFLOW_Detected = 0x1
	// Position of DNACK field.
	TWIS_ERRORSRC_DNACK_Pos = 0x2
	// Bit mask of DNACK field.
	TWIS_ERRORSRC_DNACK_Msk = 0x4
	// Bit DNACK.
	TWIS_ERRORSRC_DNACK = 0x4
	// Error did not occur
	TWIS_ERRORSRC_DNACK_NotReceived = 0x0
	// Error occurred
	TWIS_ERRORSRC_DNACK_Received = 0x1
	// Position of OVERREAD field.
	TWIS_ERRORSRC_OVERREAD_Pos = 0x3
	// Bit mask of OVERREAD field.
	TWIS_ERRORSRC_OVERREAD_Msk = 0x8
	// Bit OVERREAD.
	TWIS_ERRORSRC_OVERREAD = 0x8
	// Error did not occur
	TWIS_ERRORSRC_OVERREAD_NotDetected = 0x0
	// Error occurred
	TWIS_ERRORSRC_OVERREAD_Detected = 0x1

	// MATCH: Status register indicating which address had a match
	// Position of MATCH field.
	TWIS_MATCH_MATCH_Pos = 0x0
	// Bit mask of MATCH field.
	TWIS_MATCH_MATCH_Msk = 0x1
	// Bit MATCH.
	TWIS_MATCH_MATCH = 0x1

	// ENABLE: Enable TWIS
	// Position of ENABLE field.
	TWIS_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	TWIS_ENABLE_ENABLE_Msk = 0xf
	// Disable TWIS
	TWIS_ENABLE_ENABLE_Disabled = 0x0
	// Enable TWIS
	TWIS_ENABLE_ENABLE_Enabled = 0x9

	// PSEL.SCL: Pin select for SCL signal
	// Position of PIN field.
	TWIS_PSEL_SCL_PIN_Pos = 0x0
	// Bit mask of PIN field.
	TWIS_PSEL_SCL_PIN_Msk = 0x1f
	// Position of PORT field.
	TWIS_PSEL_SCL_PORT_Pos = 0x5
	// Bit mask of PORT field.
	TWIS_PSEL_SCL_PORT_Msk = 0x20
	// Bit PORT.
	TWIS_PSEL_SCL_PORT = 0x20
	// Position of CONNECT field.
	TWIS_PSEL_SCL_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	TWIS_PSEL_SCL_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	TWIS_PSEL_SCL_CONNECT = 0x80000000
	// Disconnect
	TWIS_PSEL_SCL_CONNECT_Disconnected = 0x1
	// Connect
	TWIS_PSEL_SCL_CONNECT_Connected = 0x0

	// PSEL.SDA: Pin select for SDA signal
	// Position of PIN field.
	TWIS_PSEL_SDA_PIN_Pos = 0x0
	// Bit mask of PIN field.
	TWIS_PSEL_SDA_PIN_Msk = 0x1f
	// Position of PORT field.
	TWIS_PSEL_SDA_PORT_Pos = 0x5
	// Bit mask of PORT field.
	TWIS_PSEL_SDA_PORT_Msk = 0x20
	// Bit PORT.
	TWIS_PSEL_SDA_PORT = 0x20
	// Position of CONNECT field.
	TWIS_PSEL_SDA_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	TWIS_PSEL_SDA_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	TWIS_PSEL_SDA_CONNECT = 0x80000000
	// Disconnect
	TWIS_PSEL_SDA_CONNECT_Disconnected = 0x1
	// Connect
	TWIS_PSEL_SDA_CONNECT_Connected = 0x0

	// RXD.PTR: RXD Data pointer
	// Position of PTR field.
	TWIS_RXD_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	TWIS_RXD_PTR_PTR_Msk = 0xffffffff

	// RXD.MAXCNT: Maximum number of bytes in RXD buffer
	// Position of MAXCNT field.
	TWIS_RXD_MAXCNT_MAXCNT_Pos = 0x0
	// Bit mask of MAXCNT field.
	TWIS_RXD_MAXCNT_MAXCNT_Msk = 0xffff

	// RXD.AMOUNT: Number of bytes transferred in the last RXD transaction
	// Position of AMOUNT field.
	TWIS_RXD_AMOUNT_AMOUNT_Pos = 0x0
	// Bit mask of AMOUNT field.
	TWIS_RXD_AMOUNT_AMOUNT_Msk = 0xffff

	// RXD.LIST: EasyDMA list type
	// Position of LIST field.
	TWIS_RXD_LIST_LIST_Pos = 0x0
	// Bit mask of LIST field.
	TWIS_RXD_LIST_LIST_Msk = 0x3
	// Disable EasyDMA list
	TWIS_RXD_LIST_LIST_Disabled = 0x0
	// Use array list
	TWIS_RXD_LIST_LIST_ArrayList = 0x1

	// TXD.PTR: TXD Data pointer
	// Position of PTR field.
	TWIS_TXD_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	TWIS_TXD_PTR_PTR_Msk = 0xffffffff

	// TXD.MAXCNT: Maximum number of bytes in TXD buffer
	// Position of MAXCNT field.
	TWIS_TXD_MAXCNT_MAXCNT_Pos = 0x0
	// Bit mask of MAXCNT field.
	TWIS_TXD_MAXCNT_MAXCNT_Msk = 0xffff

	// TXD.AMOUNT: Number of bytes transferred in the last TXD transaction
	// Position of AMOUNT field.
	TWIS_TXD_AMOUNT_AMOUNT_Pos = 0x0
	// Bit mask of AMOUNT field.
	TWIS_TXD_AMOUNT_AMOUNT_Msk = 0xffff

	// TXD.LIST: EasyDMA list type
	// Position of LIST field.
	TWIS_TXD_LIST_LIST_Pos = 0x0
	// Bit mask of LIST field.
	TWIS_TXD_LIST_LIST_Msk = 0x3
	// Disable EasyDMA list
	TWIS_TXD_LIST_LIST_Disabled = 0x0
	// Use array list
	TWIS_TXD_LIST_LIST_ArrayList = 0x1

	// ADDRESS: Description collection: TWI slave address n
	// Position of ADDRESS field.
	TWIS_ADDRESS_ADDRESS_Pos = 0x0
	// Bit mask of ADDRESS field.
	TWIS_ADDRESS_ADDRESS_Msk = 0x7f

	// CONFIG: Configuration register for the address match mechanism
	// Position of ADDRESS0 field.
	TWIS_CONFIG_ADDRESS0_Pos = 0x0
	// Bit mask of ADDRESS0 field.
	TWIS_CONFIG_ADDRESS0_Msk = 0x1
	// Bit ADDRESS0.
	TWIS_CONFIG_ADDRESS0 = 0x1
	// Disabled
	TWIS_CONFIG_ADDRESS0_Disabled = 0x0
	// Enabled
	TWIS_CONFIG_ADDRESS0_Enabled = 0x1
	// Position of ADDRESS1 field.
	TWIS_CONFIG_ADDRESS1_Pos = 0x1
	// Bit mask of ADDRESS1 field.
	TWIS_CONFIG_ADDRESS1_Msk = 0x2
	// Bit ADDRESS1.
	TWIS_CONFIG_ADDRESS1 = 0x2
	// Disabled
	TWIS_CONFIG_ADDRESS1_Disabled = 0x0
	// Enabled
	TWIS_CONFIG_ADDRESS1_Enabled = 0x1

	// ORC: Over-read character. Character sent out in case of an over-read of the transmit buffer.
	// Position of ORC field.
	TWIS_ORC_ORC_Pos = 0x0
	// Bit mask of ORC field.
	TWIS_ORC_ORC_Msk = 0xff
)

// Bitfields for UARTE0_NS: UART with EasyDMA
const (
	// TASKS_STARTRX: Start UART receiver
	// Position of TASKS_STARTRX field.
	UARTE_TASKS_STARTRX_TASKS_STARTRX_Pos = 0x0
	// Bit mask of TASKS_STARTRX field.
	UARTE_TASKS_STARTRX_TASKS_STARTRX_Msk = 0x1
	// Bit TASKS_STARTRX.
	UARTE_TASKS_STARTRX_TASKS_STARTRX = 0x1
	// Trigger task
	UARTE_TASKS_STARTRX_TASKS_STARTRX_Trigger = 0x1

	// TASKS_STOPRX: Stop UART receiver
	// Position of TASKS_STOPRX field.
	UARTE_TASKS_STOPRX_TASKS_STOPRX_Pos = 0x0
	// Bit mask of TASKS_STOPRX field.
	UARTE_TASKS_STOPRX_TASKS_STOPRX_Msk = 0x1
	// Bit TASKS_STOPRX.
	UARTE_TASKS_STOPRX_TASKS_STOPRX = 0x1
	// Trigger task
	UARTE_TASKS_STOPRX_TASKS_STOPRX_Trigger = 0x1

	// TASKS_STARTTX: Start UART transmitter
	// Position of TASKS_STARTTX field.
	UARTE_TASKS_STARTTX_TASKS_STARTTX_Pos = 0x0
	// Bit mask of TASKS_STARTTX field.
	UARTE_TASKS_STARTTX_TASKS_STARTTX_Msk = 0x1
	// Bit TASKS_STARTTX.
	UARTE_TASKS_STARTTX_TASKS_STARTTX = 0x1
	// Trigger task
	UARTE_TASKS_STARTTX_TASKS_STARTTX_Trigger = 0x1

	// TASKS_STOPTX: Stop UART transmitter
	// Position of TASKS_STOPTX field.
	UARTE_TASKS_STOPTX_TASKS_STOPTX_Pos = 0x0
	// Bit mask of TASKS_STOPTX field.
	UARTE_TASKS_STOPTX_TASKS_STOPTX_Msk = 0x1
	// Bit TASKS_STOPTX.
	UARTE_TASKS_STOPTX_TASKS_STOPTX = 0x1
	// Trigger task
	UARTE_TASKS_STOPTX_TASKS_STOPTX_Trigger = 0x1

	// TASKS_FLUSHRX: Flush RX FIFO into RX buffer
	// Position of TASKS_FLUSHRX field.
	UARTE_TASKS_FLUSHRX_TASKS_FLUSHRX_Pos = 0x0
	// Bit mask of TASKS_FLUSHRX field.
	UARTE_TASKS_FLUSHRX_TASKS_FLUSHRX_Msk = 0x1
	// Bit TASKS_FLUSHRX.
	UARTE_TASKS_FLUSHRX_TASKS_FLUSHRX = 0x1
	// Trigger task
	UARTE_TASKS_FLUSHRX_TASKS_FLUSHRX_Trigger = 0x1

	// SUBSCRIBE_STARTRX: Subscribe configuration for task STARTRX
	// Position of CHIDX field.
	UARTE_SUBSCRIBE_STARTRX_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	UARTE_SUBSCRIBE_STARTRX_CHIDX_Msk = 0xff
	// Position of EN field.
	UARTE_SUBSCRIBE_STARTRX_EN_Pos = 0x1f
	// Bit mask of EN field.
	UARTE_SUBSCRIBE_STARTRX_EN_Msk = 0x80000000
	// Bit EN.
	UARTE_SUBSCRIBE_STARTRX_EN = 0x80000000
	// Disable subscription
	UARTE_SUBSCRIBE_STARTRX_EN_Disabled = 0x0
	// Enable subscription
	UARTE_SUBSCRIBE_STARTRX_EN_Enabled = 0x1

	// SUBSCRIBE_STOPRX: Subscribe configuration for task STOPRX
	// Position of CHIDX field.
	UARTE_SUBSCRIBE_STOPRX_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	UARTE_SUBSCRIBE_STOPRX_CHIDX_Msk = 0xff
	// Position of EN field.
	UARTE_SUBSCRIBE_STOPRX_EN_Pos = 0x1f
	// Bit mask of EN field.
	UARTE_SUBSCRIBE_STOPRX_EN_Msk = 0x80000000
	// Bit EN.
	UARTE_SUBSCRIBE_STOPRX_EN = 0x80000000
	// Disable subscription
	UARTE_SUBSCRIBE_STOPRX_EN_Disabled = 0x0
	// Enable subscription
	UARTE_SUBSCRIBE_STOPRX_EN_Enabled = 0x1

	// SUBSCRIBE_STARTTX: Subscribe configuration for task STARTTX
	// Position of CHIDX field.
	UARTE_SUBSCRIBE_STARTTX_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	UARTE_SUBSCRIBE_STARTTX_CHIDX_Msk = 0xff
	// Position of EN field.
	UARTE_SUBSCRIBE_STARTTX_EN_Pos = 0x1f
	// Bit mask of EN field.
	UARTE_SUBSCRIBE_STARTTX_EN_Msk = 0x80000000
	// Bit EN.
	UARTE_SUBSCRIBE_STARTTX_EN = 0x80000000
	// Disable subscription
	UARTE_SUBSCRIBE_STARTTX_EN_Disabled = 0x0
	// Enable subscription
	UARTE_SUBSCRIBE_STARTTX_EN_Enabled = 0x1

	// SUBSCRIBE_STOPTX: Subscribe configuration for task STOPTX
	// Position of CHIDX field.
	UARTE_SUBSCRIBE_STOPTX_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	UARTE_SUBSCRIBE_STOPTX_CHIDX_Msk = 0xff
	// Position of EN field.
	UARTE_SUBSCRIBE_STOPTX_EN_Pos = 0x1f
	// Bit mask of EN field.
	UARTE_SUBSCRIBE_STOPTX_EN_Msk = 0x80000000
	// Bit EN.
	UARTE_SUBSCRIBE_STOPTX_EN = 0x80000000
	// Disable subscription
	UARTE_SUBSCRIBE_STOPTX_EN_Disabled = 0x0
	// Enable subscription
	UARTE_SUBSCRIBE_STOPTX_EN_Enabled = 0x1

	// SUBSCRIBE_FLUSHRX: Subscribe configuration for task FLUSHRX
	// Position of CHIDX field.
	UARTE_SUBSCRIBE_FLUSHRX_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	UARTE_SUBSCRIBE_FLUSHRX_CHIDX_Msk = 0xff
	// Position of EN field.
	UARTE_SUBSCRIBE_FLUSHRX_EN_Pos = 0x1f
	// Bit mask of EN field.
	UARTE_SUBSCRIBE_FLUSHRX_EN_Msk = 0x80000000
	// Bit EN.
	UARTE_SUBSCRIBE_FLUSHRX_EN = 0x80000000
	// Disable subscription
	UARTE_SUBSCRIBE_FLUSHRX_EN_Disabled = 0x0
	// Enable subscription
	UARTE_SUBSCRIBE_FLUSHRX_EN_Enabled = 0x1

	// EVENTS_CTS: CTS is activated (set low). Clear To Send.
	// Position of EVENTS_CTS field.
	UARTE_EVENTS_CTS_EVENTS_CTS_Pos = 0x0
	// Bit mask of EVENTS_CTS field.
	UARTE_EVENTS_CTS_EVENTS_CTS_Msk = 0x1
	// Bit EVENTS_CTS.
	UARTE_EVENTS_CTS_EVENTS_CTS = 0x1
	// Event not generated
	UARTE_EVENTS_CTS_EVENTS_CTS_NotGenerated = 0x0
	// Event generated
	UARTE_EVENTS_CTS_EVENTS_CTS_Generated = 0x1

	// EVENTS_NCTS: CTS is deactivated (set high). Not Clear To Send.
	// Position of EVENTS_NCTS field.
	UARTE_EVENTS_NCTS_EVENTS_NCTS_Pos = 0x0
	// Bit mask of EVENTS_NCTS field.
	UARTE_EVENTS_NCTS_EVENTS_NCTS_Msk = 0x1
	// Bit EVENTS_NCTS.
	UARTE_EVENTS_NCTS_EVENTS_NCTS = 0x1
	// Event not generated
	UARTE_EVENTS_NCTS_EVENTS_NCTS_NotGenerated = 0x0
	// Event generated
	UARTE_EVENTS_NCTS_EVENTS_NCTS_Generated = 0x1

	// EVENTS_RXDRDY: Data received in RXD (but potentially not yet transferred to Data RAM)
	// Position of EVENTS_RXDRDY field.
	UARTE_EVENTS_RXDRDY_EVENTS_RXDRDY_Pos = 0x0
	// Bit mask of EVENTS_RXDRDY field.
	UARTE_EVENTS_RXDRDY_EVENTS_RXDRDY_Msk = 0x1
	// Bit EVENTS_RXDRDY.
	UARTE_EVENTS_RXDRDY_EVENTS_RXDRDY = 0x1
	// Event not generated
	UARTE_EVENTS_RXDRDY_EVENTS_RXDRDY_NotGenerated = 0x0
	// Event generated
	UARTE_EVENTS_RXDRDY_EVENTS_RXDRDY_Generated = 0x1

	// EVENTS_ENDRX: Receive buffer is filled up
	// Position of EVENTS_ENDRX field.
	UARTE_EVENTS_ENDRX_EVENTS_ENDRX_Pos = 0x0
	// Bit mask of EVENTS_ENDRX field.
	UARTE_EVENTS_ENDRX_EVENTS_ENDRX_Msk = 0x1
	// Bit EVENTS_ENDRX.
	UARTE_EVENTS_ENDRX_EVENTS_ENDRX = 0x1
	// Event not generated
	UARTE_EVENTS_ENDRX_EVENTS_ENDRX_NotGenerated = 0x0
	// Event generated
	UARTE_EVENTS_ENDRX_EVENTS_ENDRX_Generated = 0x1

	// EVENTS_TXDRDY: Data sent from TXD
	// Position of EVENTS_TXDRDY field.
	UARTE_EVENTS_TXDRDY_EVENTS_TXDRDY_Pos = 0x0
	// Bit mask of EVENTS_TXDRDY field.
	UARTE_EVENTS_TXDRDY_EVENTS_TXDRDY_Msk = 0x1
	// Bit EVENTS_TXDRDY.
	UARTE_EVENTS_TXDRDY_EVENTS_TXDRDY = 0x1
	// Event not generated
	UARTE_EVENTS_TXDRDY_EVENTS_TXDRDY_NotGenerated = 0x0
	// Event generated
	UARTE_EVENTS_TXDRDY_EVENTS_TXDRDY_Generated = 0x1

	// EVENTS_ENDTX: Last TX byte transmitted
	// Position of EVENTS_ENDTX field.
	UARTE_EVENTS_ENDTX_EVENTS_ENDTX_Pos = 0x0
	// Bit mask of EVENTS_ENDTX field.
	UARTE_EVENTS_ENDTX_EVENTS_ENDTX_Msk = 0x1
	// Bit EVENTS_ENDTX.
	UARTE_EVENTS_ENDTX_EVENTS_ENDTX = 0x1
	// Event not generated
	UARTE_EVENTS_ENDTX_EVENTS_ENDTX_NotGenerated = 0x0
	// Event generated
	UARTE_EVENTS_ENDTX_EVENTS_ENDTX_Generated = 0x1

	// EVENTS_ERROR: Error detected
	// Position of EVENTS_ERROR field.
	UARTE_EVENTS_ERROR_EVENTS_ERROR_Pos = 0x0
	// Bit mask of EVENTS_ERROR field.
	UARTE_EVENTS_ERROR_EVENTS_ERROR_Msk = 0x1
	// Bit EVENTS_ERROR.
	UARTE_EVENTS_ERROR_EVENTS_ERROR = 0x1
	// Event not generated
	UARTE_EVENTS_ERROR_EVENTS_ERROR_NotGenerated = 0x0
	// Event generated
	UARTE_EVENTS_ERROR_EVENTS_ERROR_Generated = 0x1

	// EVENTS_RXTO: Receiver timeout
	// Position of EVENTS_RXTO field.
	UARTE_EVENTS_RXTO_EVENTS_RXTO_Pos = 0x0
	// Bit mask of EVENTS_RXTO field.
	UARTE_EVENTS_RXTO_EVENTS_RXTO_Msk = 0x1
	// Bit EVENTS_RXTO.
	UARTE_EVENTS_RXTO_EVENTS_RXTO = 0x1
	// Event not generated
	UARTE_EVENTS_RXTO_EVENTS_RXTO_NotGenerated = 0x0
	// Event generated
	UARTE_EVENTS_RXTO_EVENTS_RXTO_Generated = 0x1

	// EVENTS_RXSTARTED: UART receiver has started
	// Position of EVENTS_RXSTARTED field.
	UARTE_EVENTS_RXSTARTED_EVENTS_RXSTARTED_Pos = 0x0
	// Bit mask of EVENTS_RXSTARTED field.
	UARTE_EVENTS_RXSTARTED_EVENTS_RXSTARTED_Msk = 0x1
	// Bit EVENTS_RXSTARTED.
	UARTE_EVENTS_RXSTARTED_EVENTS_RXSTARTED = 0x1
	// Event not generated
	UARTE_EVENTS_RXSTARTED_EVENTS_RXSTARTED_NotGenerated = 0x0
	// Event generated
	UARTE_EVENTS_RXSTARTED_EVENTS_RXSTARTED_Generated = 0x1

	// EVENTS_TXSTARTED: UART transmitter has started
	// Position of EVENTS_TXSTARTED field.
	UARTE_EVENTS_TXSTARTED_EVENTS_TXSTARTED_Pos = 0x0
	// Bit mask of EVENTS_TXSTARTED field.
	UARTE_EVENTS_TXSTARTED_EVENTS_TXSTARTED_Msk = 0x1
	// Bit EVENTS_TXSTARTED.
	UARTE_EVENTS_TXSTARTED_EVENTS_TXSTARTED = 0x1
	// Event not generated
	UARTE_EVENTS_TXSTARTED_EVENTS_TXSTARTED_NotGenerated = 0x0
	// Event generated
	UARTE_EVENTS_TXSTARTED_EVENTS_TXSTARTED_Generated = 0x1

	// EVENTS_TXSTOPPED: Transmitter stopped
	// Position of EVENTS_TXSTOPPED field.
	UARTE_EVENTS_TXSTOPPED_EVENTS_TXSTOPPED_Pos = 0x0
	// Bit mask of EVENTS_TXSTOPPED field.
	UARTE_EVENTS_TXSTOPPED_EVENTS_TXSTOPPED_Msk = 0x1
	// Bit EVENTS_TXSTOPPED.
	UARTE_EVENTS_TXSTOPPED_EVENTS_TXSTOPPED = 0x1
	// Event not generated
	UARTE_EVENTS_TXSTOPPED_EVENTS_TXSTOPPED_NotGenerated = 0x0
	// Event generated
	UARTE_EVENTS_TXSTOPPED_EVENTS_TXSTOPPED_Generated = 0x1

	// PUBLISH_CTS: Publish configuration for event CTS
	// Position of CHIDX field.
	UARTE_PUBLISH_CTS_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	UARTE_PUBLISH_CTS_CHIDX_Msk = 0xff
	// Position of EN field.
	UARTE_PUBLISH_CTS_EN_Pos = 0x1f
	// Bit mask of EN field.
	UARTE_PUBLISH_CTS_EN_Msk = 0x80000000
	// Bit EN.
	UARTE_PUBLISH_CTS_EN = 0x80000000
	// Disable publishing
	UARTE_PUBLISH_CTS_EN_Disabled = 0x0
	// Enable publishing
	UARTE_PUBLISH_CTS_EN_Enabled = 0x1

	// PUBLISH_NCTS: Publish configuration for event NCTS
	// Position of CHIDX field.
	UARTE_PUBLISH_NCTS_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	UARTE_PUBLISH_NCTS_CHIDX_Msk = 0xff
	// Position of EN field.
	UARTE_PUBLISH_NCTS_EN_Pos = 0x1f
	// Bit mask of EN field.
	UARTE_PUBLISH_NCTS_EN_Msk = 0x80000000
	// Bit EN.
	UARTE_PUBLISH_NCTS_EN = 0x80000000
	// Disable publishing
	UARTE_PUBLISH_NCTS_EN_Disabled = 0x0
	// Enable publishing
	UARTE_PUBLISH_NCTS_EN_Enabled = 0x1

	// PUBLISH_RXDRDY: Publish configuration for event RXDRDY
	// Position of CHIDX field.
	UARTE_PUBLISH_RXDRDY_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	UARTE_PUBLISH_RXDRDY_CHIDX_Msk = 0xff
	// Position of EN field.
	UARTE_PUBLISH_RXDRDY_EN_Pos = 0x1f
	// Bit mask of EN field.
	UARTE_PUBLISH_RXDRDY_EN_Msk = 0x80000000
	// Bit EN.
	UARTE_PUBLISH_RXDRDY_EN = 0x80000000
	// Disable publishing
	UARTE_PUBLISH_RXDRDY_EN_Disabled = 0x0
	// Enable publishing
	UARTE_PUBLISH_RXDRDY_EN_Enabled = 0x1

	// PUBLISH_ENDRX: Publish configuration for event ENDRX
	// Position of CHIDX field.
	UARTE_PUBLISH_ENDRX_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	UARTE_PUBLISH_ENDRX_CHIDX_Msk = 0xff
	// Position of EN field.
	UARTE_PUBLISH_ENDRX_EN_Pos = 0x1f
	// Bit mask of EN field.
	UARTE_PUBLISH_ENDRX_EN_Msk = 0x80000000
	// Bit EN.
	UARTE_PUBLISH_ENDRX_EN = 0x80000000
	// Disable publishing
	UARTE_PUBLISH_ENDRX_EN_Disabled = 0x0
	// Enable publishing
	UARTE_PUBLISH_ENDRX_EN_Enabled = 0x1

	// PUBLISH_TXDRDY: Publish configuration for event TXDRDY
	// Position of CHIDX field.
	UARTE_PUBLISH_TXDRDY_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	UARTE_PUBLISH_TXDRDY_CHIDX_Msk = 0xff
	// Position of EN field.
	UARTE_PUBLISH_TXDRDY_EN_Pos = 0x1f
	// Bit mask of EN field.
	UARTE_PUBLISH_TXDRDY_EN_Msk = 0x80000000
	// Bit EN.
	UARTE_PUBLISH_TXDRDY_EN = 0x80000000
	// Disable publishing
	UARTE_PUBLISH_TXDRDY_EN_Disabled = 0x0
	// Enable publishing
	UARTE_PUBLISH_TXDRDY_EN_Enabled = 0x1

	// PUBLISH_ENDTX: Publish configuration for event ENDTX
	// Position of CHIDX field.
	UARTE_PUBLISH_ENDTX_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	UARTE_PUBLISH_ENDTX_CHIDX_Msk = 0xff
	// Position of EN field.
	UARTE_PUBLISH_ENDTX_EN_Pos = 0x1f
	// Bit mask of EN field.
	UARTE_PUBLISH_ENDTX_EN_Msk = 0x80000000
	// Bit EN.
	UARTE_PUBLISH_ENDTX_EN = 0x80000000
	// Disable publishing
	UARTE_PUBLISH_ENDTX_EN_Disabled = 0x0
	// Enable publishing
	UARTE_PUBLISH_ENDTX_EN_Enabled = 0x1

	// PUBLISH_ERROR: Publish configuration for event ERROR
	// Position of CHIDX field.
	UARTE_PUBLISH_ERROR_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	UARTE_PUBLISH_ERROR_CHIDX_Msk = 0xff
	// Position of EN field.
	UARTE_PUBLISH_ERROR_EN_Pos = 0x1f
	// Bit mask of EN field.
	UARTE_PUBLISH_ERROR_EN_Msk = 0x80000000
	// Bit EN.
	UARTE_PUBLISH_ERROR_EN = 0x80000000
	// Disable publishing
	UARTE_PUBLISH_ERROR_EN_Disabled = 0x0
	// Enable publishing
	UARTE_PUBLISH_ERROR_EN_Enabled = 0x1

	// PUBLISH_RXTO: Publish configuration for event RXTO
	// Position of CHIDX field.
	UARTE_PUBLISH_RXTO_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	UARTE_PUBLISH_RXTO_CHIDX_Msk = 0xff
	// Position of EN field.
	UARTE_PUBLISH_RXTO_EN_Pos = 0x1f
	// Bit mask of EN field.
	UARTE_PUBLISH_RXTO_EN_Msk = 0x80000000
	// Bit EN.
	UARTE_PUBLISH_RXTO_EN = 0x80000000
	// Disable publishing
	UARTE_PUBLISH_RXTO_EN_Disabled = 0x0
	// Enable publishing
	UARTE_PUBLISH_RXTO_EN_Enabled = 0x1

	// PUBLISH_RXSTARTED: Publish configuration for event RXSTARTED
	// Position of CHIDX field.
	UARTE_PUBLISH_RXSTARTED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	UARTE_PUBLISH_RXSTARTED_CHIDX_Msk = 0xff
	// Position of EN field.
	UARTE_PUBLISH_RXSTARTED_EN_Pos = 0x1f
	// Bit mask of EN field.
	UARTE_PUBLISH_RXSTARTED_EN_Msk = 0x80000000
	// Bit EN.
	UARTE_PUBLISH_RXSTARTED_EN = 0x80000000
	// Disable publishing
	UARTE_PUBLISH_RXSTARTED_EN_Disabled = 0x0
	// Enable publishing
	UARTE_PUBLISH_RXSTARTED_EN_Enabled = 0x1

	// PUBLISH_TXSTARTED: Publish configuration for event TXSTARTED
	// Position of CHIDX field.
	UARTE_PUBLISH_TXSTARTED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	UARTE_PUBLISH_TXSTARTED_CHIDX_Msk = 0xff
	// Position of EN field.
	UARTE_PUBLISH_TXSTARTED_EN_Pos = 0x1f
	// Bit mask of EN field.
	UARTE_PUBLISH_TXSTARTED_EN_Msk = 0x80000000
	// Bit EN.
	UARTE_PUBLISH_TXSTARTED_EN = 0x80000000
	// Disable publishing
	UARTE_PUBLISH_TXSTARTED_EN_Disabled = 0x0
	// Enable publishing
	UARTE_PUBLISH_TXSTARTED_EN_Enabled = 0x1

	// PUBLISH_TXSTOPPED: Publish configuration for event TXSTOPPED
	// Position of CHIDX field.
	UARTE_PUBLISH_TXSTOPPED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	UARTE_PUBLISH_TXSTOPPED_CHIDX_Msk = 0xff
	// Position of EN field.
	UARTE_PUBLISH_TXSTOPPED_EN_Pos = 0x1f
	// Bit mask of EN field.
	UARTE_PUBLISH_TXSTOPPED_EN_Msk = 0x80000000
	// Bit EN.
	UARTE_PUBLISH_TXSTOPPED_EN = 0x80000000
	// Disable publishing
	UARTE_PUBLISH_TXSTOPPED_EN_Disabled = 0x0
	// Enable publishing
	UARTE_PUBLISH_TXSTOPPED_EN_Enabled = 0x1

	// SHORTS: Shortcuts between local events and tasks
	// Position of ENDRX_STARTRX field.
	UARTE_SHORTS_ENDRX_STARTRX_Pos = 0x5
	// Bit mask of ENDRX_STARTRX field.
	UARTE_SHORTS_ENDRX_STARTRX_Msk = 0x20
	// Bit ENDRX_STARTRX.
	UARTE_SHORTS_ENDRX_STARTRX = 0x20
	// Disable shortcut
	UARTE_SHORTS_ENDRX_STARTRX_Disabled = 0x0
	// Enable shortcut
	UARTE_SHORTS_ENDRX_STARTRX_Enabled = 0x1
	// Position of ENDRX_STOPRX field.
	UARTE_SHORTS_ENDRX_STOPRX_Pos = 0x6
	// Bit mask of ENDRX_STOPRX field.
	UARTE_SHORTS_ENDRX_STOPRX_Msk = 0x40
	// Bit ENDRX_STOPRX.
	UARTE_SHORTS_ENDRX_STOPRX = 0x40
	// Disable shortcut
	UARTE_SHORTS_ENDRX_STOPRX_Disabled = 0x0
	// Enable shortcut
	UARTE_SHORTS_ENDRX_STOPRX_Enabled = 0x1

	// INTEN: Enable or disable interrupt
	// Position of CTS field.
	UARTE_INTEN_CTS_Pos = 0x0
	// Bit mask of CTS field.
	UARTE_INTEN_CTS_Msk = 0x1
	// Bit CTS.
	UARTE_INTEN_CTS = 0x1
	// Disable
	UARTE_INTEN_CTS_Disabled = 0x0
	// Enable
	UARTE_INTEN_CTS_Enabled = 0x1
	// Position of NCTS field.
	UARTE_INTEN_NCTS_Pos = 0x1
	// Bit mask of NCTS field.
	UARTE_INTEN_NCTS_Msk = 0x2
	// Bit NCTS.
	UARTE_INTEN_NCTS = 0x2
	// Disable
	UARTE_INTEN_NCTS_Disabled = 0x0
	// Enable
	UARTE_INTEN_NCTS_Enabled = 0x1
	// Position of RXDRDY field.
	UARTE_INTEN_RXDRDY_Pos = 0x2
	// Bit mask of RXDRDY field.
	UARTE_INTEN_RXDRDY_Msk = 0x4
	// Bit RXDRDY.
	UARTE_INTEN_RXDRDY = 0x4
	// Disable
	UARTE_INTEN_RXDRDY_Disabled = 0x0
	// Enable
	UARTE_INTEN_RXDRDY_Enabled = 0x1
	// Position of ENDRX field.
	UARTE_INTEN_ENDRX_Pos = 0x4
	// Bit mask of ENDRX field.
	UARTE_INTEN_ENDRX_Msk = 0x10
	// Bit ENDRX.
	UARTE_INTEN_ENDRX = 0x10
	// Disable
	UARTE_INTEN_ENDRX_Disabled = 0x0
	// Enable
	UARTE_INTEN_ENDRX_Enabled = 0x1
	// Position of TXDRDY field.
	UARTE_INTEN_TXDRDY_Pos = 0x7
	// Bit mask of TXDRDY field.
	UARTE_INTEN_TXDRDY_Msk = 0x80
	// Bit TXDRDY.
	UARTE_INTEN_TXDRDY = 0x80
	// Disable
	UARTE_INTEN_TXDRDY_Disabled = 0x0
	// Enable
	UARTE_INTEN_TXDRDY_Enabled = 0x1
	// Position of ENDTX field.
	UARTE_INTEN_ENDTX_Pos = 0x8
	// Bit mask of ENDTX field.
	UARTE_INTEN_ENDTX_Msk = 0x100
	// Bit ENDTX.
	UARTE_INTEN_ENDTX = 0x100
	// Disable
	UARTE_INTEN_ENDTX_Disabled = 0x0
	// Enable
	UARTE_INTEN_ENDTX_Enabled = 0x1
	// Position of ERROR field.
	UARTE_INTEN_ERROR_Pos = 0x9
	// Bit mask of ERROR field.
	UARTE_INTEN_ERROR_Msk = 0x200
	// Bit ERROR.
	UARTE_INTEN_ERROR = 0x200
	// Disable
	UARTE_INTEN_ERROR_Disabled = 0x0
	// Enable
	UARTE_INTEN_ERROR_Enabled = 0x1
	// Position of RXTO field.
	UARTE_INTEN_RXTO_Pos = 0x11
	// Bit mask of RXTO field.
	UARTE_INTEN_RXTO_Msk = 0x20000
	// Bit RXTO.
	UARTE_INTEN_RXTO = 0x20000
	// Disable
	UARTE_INTEN_RXTO_Disabled = 0x0
	// Enable
	UARTE_INTEN_RXTO_Enabled = 0x1
	// Position of RXSTARTED field.
	UARTE_INTEN_RXSTARTED_Pos = 0x13
	// Bit mask of RXSTARTED field.
	UARTE_INTEN_RXSTARTED_Msk = 0x80000
	// Bit RXSTARTED.
	UARTE_INTEN_RXSTARTED = 0x80000
	// Disable
	UARTE_INTEN_RXSTARTED_Disabled = 0x0
	// Enable
	UARTE_INTEN_RXSTARTED_Enabled = 0x1
	// Position of TXSTARTED field.
	UARTE_INTEN_TXSTARTED_Pos = 0x14
	// Bit mask of TXSTARTED field.
	UARTE_INTEN_TXSTARTED_Msk = 0x100000
	// Bit TXSTARTED.
	UARTE_INTEN_TXSTARTED = 0x100000
	// Disable
	UARTE_INTEN_TXSTARTED_Disabled = 0x0
	// Enable
	UARTE_INTEN_TXSTARTED_Enabled = 0x1
	// Position of TXSTOPPED field.
	UARTE_INTEN_TXSTOPPED_Pos = 0x16
	// Bit mask of TXSTOPPED field.
	UARTE_INTEN_TXSTOPPED_Msk = 0x400000
	// Bit TXSTOPPED.
	UARTE_INTEN_TXSTOPPED = 0x400000
	// Disable
	UARTE_INTEN_TXSTOPPED_Disabled = 0x0
	// Enable
	UARTE_INTEN_TXSTOPPED_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of CTS field.
	UARTE_INTENSET_CTS_Pos = 0x0
	// Bit mask of CTS field.
	UARTE_INTENSET_CTS_Msk = 0x1
	// Bit CTS.
	UARTE_INTENSET_CTS = 0x1
	// Read: Disabled
	UARTE_INTENSET_CTS_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENSET_CTS_Enabled = 0x1
	// Enable
	UARTE_INTENSET_CTS_Set = 0x1
	// Position of NCTS field.
	UARTE_INTENSET_NCTS_Pos = 0x1
	// Bit mask of NCTS field.
	UARTE_INTENSET_NCTS_Msk = 0x2
	// Bit NCTS.
	UARTE_INTENSET_NCTS = 0x2
	// Read: Disabled
	UARTE_INTENSET_NCTS_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENSET_NCTS_Enabled = 0x1
	// Enable
	UARTE_INTENSET_NCTS_Set = 0x1
	// Position of RXDRDY field.
	UARTE_INTENSET_RXDRDY_Pos = 0x2
	// Bit mask of RXDRDY field.
	UARTE_INTENSET_RXDRDY_Msk = 0x4
	// Bit RXDRDY.
	UARTE_INTENSET_RXDRDY = 0x4
	// Read: Disabled
	UARTE_INTENSET_RXDRDY_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENSET_RXDRDY_Enabled = 0x1
	// Enable
	UARTE_INTENSET_RXDRDY_Set = 0x1
	// Position of ENDRX field.
	UARTE_INTENSET_ENDRX_Pos = 0x4
	// Bit mask of ENDRX field.
	UARTE_INTENSET_ENDRX_Msk = 0x10
	// Bit ENDRX.
	UARTE_INTENSET_ENDRX = 0x10
	// Read: Disabled
	UARTE_INTENSET_ENDRX_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENSET_ENDRX_Enabled = 0x1
	// Enable
	UARTE_INTENSET_ENDRX_Set = 0x1
	// Position of TXDRDY field.
	UARTE_INTENSET_TXDRDY_Pos = 0x7
	// Bit mask of TXDRDY field.
	UARTE_INTENSET_TXDRDY_Msk = 0x80
	// Bit TXDRDY.
	UARTE_INTENSET_TXDRDY = 0x80
	// Read: Disabled
	UARTE_INTENSET_TXDRDY_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENSET_TXDRDY_Enabled = 0x1
	// Enable
	UARTE_INTENSET_TXDRDY_Set = 0x1
	// Position of ENDTX field.
	UARTE_INTENSET_ENDTX_Pos = 0x8
	// Bit mask of ENDTX field.
	UARTE_INTENSET_ENDTX_Msk = 0x100
	// Bit ENDTX.
	UARTE_INTENSET_ENDTX = 0x100
	// Read: Disabled
	UARTE_INTENSET_ENDTX_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENSET_ENDTX_Enabled = 0x1
	// Enable
	UARTE_INTENSET_ENDTX_Set = 0x1
	// Position of ERROR field.
	UARTE_INTENSET_ERROR_Pos = 0x9
	// Bit mask of ERROR field.
	UARTE_INTENSET_ERROR_Msk = 0x200
	// Bit ERROR.
	UARTE_INTENSET_ERROR = 0x200
	// Read: Disabled
	UARTE_INTENSET_ERROR_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENSET_ERROR_Enabled = 0x1
	// Enable
	UARTE_INTENSET_ERROR_Set = 0x1
	// Position of RXTO field.
	UARTE_INTENSET_RXTO_Pos = 0x11
	// Bit mask of RXTO field.
	UARTE_INTENSET_RXTO_Msk = 0x20000
	// Bit RXTO.
	UARTE_INTENSET_RXTO = 0x20000
	// Read: Disabled
	UARTE_INTENSET_RXTO_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENSET_RXTO_Enabled = 0x1
	// Enable
	UARTE_INTENSET_RXTO_Set = 0x1
	// Position of RXSTARTED field.
	UARTE_INTENSET_RXSTARTED_Pos = 0x13
	// Bit mask of RXSTARTED field.
	UARTE_INTENSET_RXSTARTED_Msk = 0x80000
	// Bit RXSTARTED.
	UARTE_INTENSET_RXSTARTED = 0x80000
	// Read: Disabled
	UARTE_INTENSET_RXSTARTED_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENSET_RXSTARTED_Enabled = 0x1
	// Enable
	UARTE_INTENSET_RXSTARTED_Set = 0x1
	// Position of TXSTARTED field.
	UARTE_INTENSET_TXSTARTED_Pos = 0x14
	// Bit mask of TXSTARTED field.
	UARTE_INTENSET_TXSTARTED_Msk = 0x100000
	// Bit TXSTARTED.
	UARTE_INTENSET_TXSTARTED = 0x100000
	// Read: Disabled
	UARTE_INTENSET_TXSTARTED_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENSET_TXSTARTED_Enabled = 0x1
	// Enable
	UARTE_INTENSET_TXSTARTED_Set = 0x1
	// Position of TXSTOPPED field.
	UARTE_INTENSET_TXSTOPPED_Pos = 0x16
	// Bit mask of TXSTOPPED field.
	UARTE_INTENSET_TXSTOPPED_Msk = 0x400000
	// Bit TXSTOPPED.
	UARTE_INTENSET_TXSTOPPED = 0x400000
	// Read: Disabled
	UARTE_INTENSET_TXSTOPPED_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENSET_TXSTOPPED_Enabled = 0x1
	// Enable
	UARTE_INTENSET_TXSTOPPED_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of CTS field.
	UARTE_INTENCLR_CTS_Pos = 0x0
	// Bit mask of CTS field.
	UARTE_INTENCLR_CTS_Msk = 0x1
	// Bit CTS.
	UARTE_INTENCLR_CTS = 0x1
	// Read: Disabled
	UARTE_INTENCLR_CTS_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENCLR_CTS_Enabled = 0x1
	// Disable
	UARTE_INTENCLR_CTS_Clear = 0x1
	// Position of NCTS field.
	UARTE_INTENCLR_NCTS_Pos = 0x1
	// Bit mask of NCTS field.
	UARTE_INTENCLR_NCTS_Msk = 0x2
	// Bit NCTS.
	UARTE_INTENCLR_NCTS = 0x2
	// Read: Disabled
	UARTE_INTENCLR_NCTS_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENCLR_NCTS_Enabled = 0x1
	// Disable
	UARTE_INTENCLR_NCTS_Clear = 0x1
	// Position of RXDRDY field.
	UARTE_INTENCLR_RXDRDY_Pos = 0x2
	// Bit mask of RXDRDY field.
	UARTE_INTENCLR_RXDRDY_Msk = 0x4
	// Bit RXDRDY.
	UARTE_INTENCLR_RXDRDY = 0x4
	// Read: Disabled
	UARTE_INTENCLR_RXDRDY_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENCLR_RXDRDY_Enabled = 0x1
	// Disable
	UARTE_INTENCLR_RXDRDY_Clear = 0x1
	// Position of ENDRX field.
	UARTE_INTENCLR_ENDRX_Pos = 0x4
	// Bit mask of ENDRX field.
	UARTE_INTENCLR_ENDRX_Msk = 0x10
	// Bit ENDRX.
	UARTE_INTENCLR_ENDRX = 0x10
	// Read: Disabled
	UARTE_INTENCLR_ENDRX_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENCLR_ENDRX_Enabled = 0x1
	// Disable
	UARTE_INTENCLR_ENDRX_Clear = 0x1
	// Position of TXDRDY field.
	UARTE_INTENCLR_TXDRDY_Pos = 0x7
	// Bit mask of TXDRDY field.
	UARTE_INTENCLR_TXDRDY_Msk = 0x80
	// Bit TXDRDY.
	UARTE_INTENCLR_TXDRDY = 0x80
	// Read: Disabled
	UARTE_INTENCLR_TXDRDY_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENCLR_TXDRDY_Enabled = 0x1
	// Disable
	UARTE_INTENCLR_TXDRDY_Clear = 0x1
	// Position of ENDTX field.
	UARTE_INTENCLR_ENDTX_Pos = 0x8
	// Bit mask of ENDTX field.
	UARTE_INTENCLR_ENDTX_Msk = 0x100
	// Bit ENDTX.
	UARTE_INTENCLR_ENDTX = 0x100
	// Read: Disabled
	UARTE_INTENCLR_ENDTX_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENCLR_ENDTX_Enabled = 0x1
	// Disable
	UARTE_INTENCLR_ENDTX_Clear = 0x1
	// Position of ERROR field.
	UARTE_INTENCLR_ERROR_Pos = 0x9
	// Bit mask of ERROR field.
	UARTE_INTENCLR_ERROR_Msk = 0x200
	// Bit ERROR.
	UARTE_INTENCLR_ERROR = 0x200
	// Read: Disabled
	UARTE_INTENCLR_ERROR_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENCLR_ERROR_Enabled = 0x1
	// Disable
	UARTE_INTENCLR_ERROR_Clear = 0x1
	// Position of RXTO field.
	UARTE_INTENCLR_RXTO_Pos = 0x11
	// Bit mask of RXTO field.
	UARTE_INTENCLR_RXTO_Msk = 0x20000
	// Bit RXTO.
	UARTE_INTENCLR_RXTO = 0x20000
	// Read: Disabled
	UARTE_INTENCLR_RXTO_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENCLR_RXTO_Enabled = 0x1
	// Disable
	UARTE_INTENCLR_RXTO_Clear = 0x1
	// Position of RXSTARTED field.
	UARTE_INTENCLR_RXSTARTED_Pos = 0x13
	// Bit mask of RXSTARTED field.
	UARTE_INTENCLR_RXSTARTED_Msk = 0x80000
	// Bit RXSTARTED.
	UARTE_INTENCLR_RXSTARTED = 0x80000
	// Read: Disabled
	UARTE_INTENCLR_RXSTARTED_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENCLR_RXSTARTED_Enabled = 0x1
	// Disable
	UARTE_INTENCLR_RXSTARTED_Clear = 0x1
	// Position of TXSTARTED field.
	UARTE_INTENCLR_TXSTARTED_Pos = 0x14
	// Bit mask of TXSTARTED field.
	UARTE_INTENCLR_TXSTARTED_Msk = 0x100000
	// Bit TXSTARTED.
	UARTE_INTENCLR_TXSTARTED = 0x100000
	// Read: Disabled
	UARTE_INTENCLR_TXSTARTED_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENCLR_TXSTARTED_Enabled = 0x1
	// Disable
	UARTE_INTENCLR_TXSTARTED_Clear = 0x1
	// Position of TXSTOPPED field.
	UARTE_INTENCLR_TXSTOPPED_Pos = 0x16
	// Bit mask of TXSTOPPED field.
	UARTE_INTENCLR_TXSTOPPED_Msk = 0x400000
	// Bit TXSTOPPED.
	UARTE_INTENCLR_TXSTOPPED = 0x400000
	// Read: Disabled
	UARTE_INTENCLR_TXSTOPPED_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENCLR_TXSTOPPED_Enabled = 0x1
	// Disable
	UARTE_INTENCLR_TXSTOPPED_Clear = 0x1

	// ERRORSRC: Error source Note : this register is read / write one to clear.
	// Position of OVERRUN field.
	UARTE_ERRORSRC_OVERRUN_Pos = 0x0
	// Bit mask of OVERRUN field.
	UARTE_ERRORSRC_OVERRUN_Msk = 0x1
	// Bit OVERRUN.
	UARTE_ERRORSRC_OVERRUN = 0x1
	// Read: error not present
	UARTE_ERRORSRC_OVERRUN_NotPresent = 0x0
	// Read: error present
	UARTE_ERRORSRC_OVERRUN_Present = 0x1
	// Position of PARITY field.
	UARTE_ERRORSRC_PARITY_Pos = 0x1
	// Bit mask of PARITY field.
	UARTE_ERRORSRC_PARITY_Msk = 0x2
	// Bit PARITY.
	UARTE_ERRORSRC_PARITY = 0x2
	// Read: error not present
	UARTE_ERRORSRC_PARITY_NotPresent = 0x0
	// Read: error present
	UARTE_ERRORSRC_PARITY_Present = 0x1
	// Position of FRAMING field.
	UARTE_ERRORSRC_FRAMING_Pos = 0x2
	// Bit mask of FRAMING field.
	UARTE_ERRORSRC_FRAMING_Msk = 0x4
	// Bit FRAMING.
	UARTE_ERRORSRC_FRAMING = 0x4
	// Read: error not present
	UARTE_ERRORSRC_FRAMING_NotPresent = 0x0
	// Read: error present
	UARTE_ERRORSRC_FRAMING_Present = 0x1
	// Position of BREAK field.
	UARTE_ERRORSRC_BREAK_Pos = 0x3
	// Bit mask of BREAK field.
	UARTE_ERRORSRC_BREAK_Msk = 0x8
	// Bit BREAK.
	UARTE_ERRORSRC_BREAK = 0x8
	// Read: error not present
	UARTE_ERRORSRC_BREAK_NotPresent = 0x0
	// Read: error present
	UARTE_ERRORSRC_BREAK_Present = 0x1

	// ENABLE: Enable UART
	// Position of ENABLE field.
	UARTE_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	UARTE_ENABLE_ENABLE_Msk = 0xf
	// Disable UARTE
	UARTE_ENABLE_ENABLE_Disabled = 0x0
	// Enable UARTE
	UARTE_ENABLE_ENABLE_Enabled = 0x8

	// PSEL.RTS: Pin select for RTS signal
	// Position of PIN field.
	UARTE_PSEL_RTS_PIN_Pos = 0x0
	// Bit mask of PIN field.
	UARTE_PSEL_RTS_PIN_Msk = 0x1f
	// Position of PORT field.
	UARTE_PSEL_RTS_PORT_Pos = 0x5
	// Bit mask of PORT field.
	UARTE_PSEL_RTS_PORT_Msk = 0x20
	// Bit PORT.
	UARTE_PSEL_RTS_PORT = 0x20
	// Position of CONNECT field.
	UARTE_PSEL_RTS_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	UARTE_PSEL_RTS_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	UARTE_PSEL_RTS_CONNECT = 0x80000000
	// Disconnect
	UARTE_PSEL_RTS_CONNECT_Disconnected = 0x1
	// Connect
	UARTE_PSEL_RTS_CONNECT_Connected = 0x0

	// PSEL.TXD: Pin select for TXD signal
	// Position of PIN field.
	UARTE_PSEL_TXD_PIN_Pos = 0x0
	// Bit mask of PIN field.
	UARTE_PSEL_TXD_PIN_Msk = 0x1f
	// Position of PORT field.
	UARTE_PSEL_TXD_PORT_Pos = 0x5
	// Bit mask of PORT field.
	UARTE_PSEL_TXD_PORT_Msk = 0x20
	// Bit PORT.
	UARTE_PSEL_TXD_PORT = 0x20
	// Position of CONNECT field.
	UARTE_PSEL_TXD_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	UARTE_PSEL_TXD_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	UARTE_PSEL_TXD_CONNECT = 0x80000000
	// Disconnect
	UARTE_PSEL_TXD_CONNECT_Disconnected = 0x1
	// Connect
	UARTE_PSEL_TXD_CONNECT_Connected = 0x0

	// PSEL.CTS: Pin select for CTS signal
	// Position of PIN field.
	UARTE_PSEL_CTS_PIN_Pos = 0x0
	// Bit mask of PIN field.
	UARTE_PSEL_CTS_PIN_Msk = 0x1f
	// Position of PORT field.
	UARTE_PSEL_CTS_PORT_Pos = 0x5
	// Bit mask of PORT field.
	UARTE_PSEL_CTS_PORT_Msk = 0x20
	// Bit PORT.
	UARTE_PSEL_CTS_PORT = 0x20
	// Position of CONNECT field.
	UARTE_PSEL_CTS_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	UARTE_PSEL_CTS_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	UARTE_PSEL_CTS_CONNECT = 0x80000000
	// Disconnect
	UARTE_PSEL_CTS_CONNECT_Disconnected = 0x1
	// Connect
	UARTE_PSEL_CTS_CONNECT_Connected = 0x0

	// PSEL.RXD: Pin select for RXD signal
	// Position of PIN field.
	UARTE_PSEL_RXD_PIN_Pos = 0x0
	// Bit mask of PIN field.
	UARTE_PSEL_RXD_PIN_Msk = 0x1f
	// Position of PORT field.
	UARTE_PSEL_RXD_PORT_Pos = 0x5
	// Bit mask of PORT field.
	UARTE_PSEL_RXD_PORT_Msk = 0x20
	// Bit PORT.
	UARTE_PSEL_RXD_PORT = 0x20
	// Position of CONNECT field.
	UARTE_PSEL_RXD_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	UARTE_PSEL_RXD_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	UARTE_PSEL_RXD_CONNECT = 0x80000000
	// Disconnect
	UARTE_PSEL_RXD_CONNECT_Disconnected = 0x1
	// Connect
	UARTE_PSEL_RXD_CONNECT_Connected = 0x0

	// BAUDRATE: Baud rate. Accuracy depends on the HFCLK source selected.
	// Position of BAUDRATE field.
	UARTE_BAUDRATE_BAUDRATE_Pos = 0x0
	// Bit mask of BAUDRATE field.
	UARTE_BAUDRATE_BAUDRATE_Msk = 0xffffffff
	// 1200 baud (actual rate: 1205)
	UARTE_BAUDRATE_BAUDRATE_Baud1200 = 0x4f000
	// 2400 baud (actual rate: 2396)
	UARTE_BAUDRATE_BAUDRATE_Baud2400 = 0x9d000
	// 4800 baud (actual rate: 4808)
	UARTE_BAUDRATE_BAUDRATE_Baud4800 = 0x13b000
	// 9600 baud (actual rate: 9598)
	UARTE_BAUDRATE_BAUDRATE_Baud9600 = 0x275000
	// 14400 baud (actual rate: 14401)
	UARTE_BAUDRATE_BAUDRATE_Baud14400 = 0x3af000
	// 19200 baud (actual rate: 19208)
	UARTE_BAUDRATE_BAUDRATE_Baud19200 = 0x4ea000
	// 28800 baud (actual rate: 28777)
	UARTE_BAUDRATE_BAUDRATE_Baud28800 = 0x75c000
	// 31250 baud
	UARTE_BAUDRATE_BAUDRATE_Baud31250 = 0x800000
	// 38400 baud (actual rate: 38369)
	UARTE_BAUDRATE_BAUDRATE_Baud38400 = 0x9d0000
	// 56000 baud (actual rate: 55944)
	UARTE_BAUDRATE_BAUDRATE_Baud56000 = 0xe50000
	// 57600 baud (actual rate: 57554)
	UARTE_BAUDRATE_BAUDRATE_Baud57600 = 0xeb0000
	// 76800 baud (actual rate: 76923)
	UARTE_BAUDRATE_BAUDRATE_Baud76800 = 0x13a9000
	// 115200 baud (actual rate: 115108)
	UARTE_BAUDRATE_BAUDRATE_Baud115200 = 0x1d60000
	// 230400 baud (actual rate: 231884)
	UARTE_BAUDRATE_BAUDRATE_Baud230400 = 0x3b00000
	// 250000 baud
	UARTE_BAUDRATE_BAUDRATE_Baud250000 = 0x4000000
	// 460800 baud (actual rate: 457143)
	UARTE_BAUDRATE_BAUDRATE_Baud460800 = 0x7400000
	// 921600 baud (actual rate: 941176)
	UARTE_BAUDRATE_BAUDRATE_Baud921600 = 0xf000000
	// 1Mega baud
	UARTE_BAUDRATE_BAUDRATE_Baud1M = 0x10000000

	// RXD.PTR: Data pointer
	// Position of PTR field.
	UARTE_RXD_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	UARTE_RXD_PTR_PTR_Msk = 0xffffffff

	// RXD.MAXCNT: Maximum number of bytes in receive buffer
	// Position of MAXCNT field.
	UARTE_RXD_MAXCNT_MAXCNT_Pos = 0x0
	// Bit mask of MAXCNT field.
	UARTE_RXD_MAXCNT_MAXCNT_Msk = 0xffff

	// RXD.AMOUNT: Number of bytes transferred in the last transaction
	// Position of AMOUNT field.
	UARTE_RXD_AMOUNT_AMOUNT_Pos = 0x0
	// Bit mask of AMOUNT field.
	UARTE_RXD_AMOUNT_AMOUNT_Msk = 0xffff

	// TXD.PTR: Data pointer
	// Position of PTR field.
	UARTE_TXD_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	UARTE_TXD_PTR_PTR_Msk = 0xffffffff

	// TXD.MAXCNT: Maximum number of bytes in transmit buffer
	// Position of MAXCNT field.
	UARTE_TXD_MAXCNT_MAXCNT_Pos = 0x0
	// Bit mask of MAXCNT field.
	UARTE_TXD_MAXCNT_MAXCNT_Msk = 0xffff

	// TXD.AMOUNT: Number of bytes transferred in the last transaction
	// Position of AMOUNT field.
	UARTE_TXD_AMOUNT_AMOUNT_Pos = 0x0
	// Bit mask of AMOUNT field.
	UARTE_TXD_AMOUNT_AMOUNT_Msk = 0xffff

	// CONFIG: Configuration of parity and hardware flow control
	// Position of HWFC field.
	UARTE_CONFIG_HWFC_Pos = 0x0
	// Bit mask of HWFC field.
	UARTE_CONFIG_HWFC_Msk = 0x1
	// Bit HWFC.
	UARTE_CONFIG_HWFC = 0x1
	// Disabled
	UARTE_CONFIG_HWFC_Disabled = 0x0
	// Enabled
	UARTE_CONFIG_HWFC_Enabled = 0x1
	// Position of PARITY field.
	UARTE_CONFIG_PARITY_Pos = 0x1
	// Bit mask of PARITY field.
	UARTE_CONFIG_PARITY_Msk = 0xe
	// Exclude parity bit
	UARTE_CONFIG_PARITY_Excluded = 0x0
	// Include even parity bit
	UARTE_CONFIG_PARITY_Included = 0x7
	// Position of STOP field.
	UARTE_CONFIG_STOP_Pos = 0x4
	// Bit mask of STOP field.
	UARTE_CONFIG_STOP_Msk = 0x10
	// Bit STOP.
	UARTE_CONFIG_STOP = 0x10
	// One stop bit
	UARTE_CONFIG_STOP_One = 0x0
	// Two stop bits
	UARTE_CONFIG_STOP_Two = 0x1
	// Position of PARITYTYPE field.
	UARTE_CONFIG_PARITYTYPE_Pos = 0x8
	// Bit mask of PARITYTYPE field.
	UARTE_CONFIG_PARITYTYPE_Msk = 0x100
	// Bit PARITYTYPE.
	UARTE_CONFIG_PARITYTYPE = 0x100
	// Even parity
	UARTE_CONFIG_PARITYTYPE_Even = 0x0
	// Odd parity
	UARTE_CONFIG_PARITYTYPE_Odd = 0x1
)

// Bitfields for EGU0_NS: Event generator unit
const (
	// TASKS_TRIGGER: Description collection: Trigger n for triggering the corresponding TRIGGERED[n] event
	// Position of TASKS_TRIGGER field.
	EGU_TASKS_TRIGGER_TASKS_TRIGGER_Pos = 0x0
	// Bit mask of TASKS_TRIGGER field.
	EGU_TASKS_TRIGGER_TASKS_TRIGGER_Msk = 0x1
	// Bit TASKS_TRIGGER.
	EGU_TASKS_TRIGGER_TASKS_TRIGGER = 0x1
	// Trigger task
	EGU_TASKS_TRIGGER_TASKS_TRIGGER_Trigger = 0x1

	// SUBSCRIBE_TRIGGER: Description collection: Subscribe configuration for task TRIGGER[n]
	// Position of CHIDX field.
	EGU_SUBSCRIBE_TRIGGER_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	EGU_SUBSCRIBE_TRIGGER_CHIDX_Msk = 0xff
	// Position of EN field.
	EGU_SUBSCRIBE_TRIGGER_EN_Pos = 0x1f
	// Bit mask of EN field.
	EGU_SUBSCRIBE_TRIGGER_EN_Msk = 0x80000000
	// Bit EN.
	EGU_SUBSCRIBE_TRIGGER_EN = 0x80000000
	// Disable subscription
	EGU_SUBSCRIBE_TRIGGER_EN_Disabled = 0x0
	// Enable subscription
	EGU_SUBSCRIBE_TRIGGER_EN_Enabled = 0x1

	// EVENTS_TRIGGERED: Description collection: Event number n generated by triggering the corresponding TRIGGER[n] task
	// Position of EVENTS_TRIGGERED field.
	EGU_EVENTS_TRIGGERED_EVENTS_TRIGGERED_Pos = 0x0
	// Bit mask of EVENTS_TRIGGERED field.
	EGU_EVENTS_TRIGGERED_EVENTS_TRIGGERED_Msk = 0x1
	// Bit EVENTS_TRIGGERED.
	EGU_EVENTS_TRIGGERED_EVENTS_TRIGGERED = 0x1
	// Event not generated
	EGU_EVENTS_TRIGGERED_EVENTS_TRIGGERED_NotGenerated = 0x0
	// Event generated
	EGU_EVENTS_TRIGGERED_EVENTS_TRIGGERED_Generated = 0x1

	// PUBLISH_TRIGGERED: Description collection: Publish configuration for event TRIGGERED[n]
	// Position of CHIDX field.
	EGU_PUBLISH_TRIGGERED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	EGU_PUBLISH_TRIGGERED_CHIDX_Msk = 0xff
	// Position of EN field.
	EGU_PUBLISH_TRIGGERED_EN_Pos = 0x1f
	// Bit mask of EN field.
	EGU_PUBLISH_TRIGGERED_EN_Msk = 0x80000000
	// Bit EN.
	EGU_PUBLISH_TRIGGERED_EN = 0x80000000
	// Disable publishing
	EGU_PUBLISH_TRIGGERED_EN_Disabled = 0x0
	// Enable publishing
	EGU_PUBLISH_TRIGGERED_EN_Enabled = 0x1

	// INTEN: Enable or disable interrupt
	// Position of TRIGGERED0 field.
	EGU_INTEN_TRIGGERED0_Pos = 0x0
	// Bit mask of TRIGGERED0 field.
	EGU_INTEN_TRIGGERED0_Msk = 0x1
	// Bit TRIGGERED0.
	EGU_INTEN_TRIGGERED0 = 0x1
	// Disable
	EGU_INTEN_TRIGGERED0_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED0_Enabled = 0x1
	// Position of TRIGGERED1 field.
	EGU_INTEN_TRIGGERED1_Pos = 0x1
	// Bit mask of TRIGGERED1 field.
	EGU_INTEN_TRIGGERED1_Msk = 0x2
	// Bit TRIGGERED1.
	EGU_INTEN_TRIGGERED1 = 0x2
	// Disable
	EGU_INTEN_TRIGGERED1_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED1_Enabled = 0x1
	// Position of TRIGGERED2 field.
	EGU_INTEN_TRIGGERED2_Pos = 0x2
	// Bit mask of TRIGGERED2 field.
	EGU_INTEN_TRIGGERED2_Msk = 0x4
	// Bit TRIGGERED2.
	EGU_INTEN_TRIGGERED2 = 0x4
	// Disable
	EGU_INTEN_TRIGGERED2_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED2_Enabled = 0x1
	// Position of TRIGGERED3 field.
	EGU_INTEN_TRIGGERED3_Pos = 0x3
	// Bit mask of TRIGGERED3 field.
	EGU_INTEN_TRIGGERED3_Msk = 0x8
	// Bit TRIGGERED3.
	EGU_INTEN_TRIGGERED3 = 0x8
	// Disable
	EGU_INTEN_TRIGGERED3_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED3_Enabled = 0x1
	// Position of TRIGGERED4 field.
	EGU_INTEN_TRIGGERED4_Pos = 0x4
	// Bit mask of TRIGGERED4 field.
	EGU_INTEN_TRIGGERED4_Msk = 0x10
	// Bit TRIGGERED4.
	EGU_INTEN_TRIGGERED4 = 0x10
	// Disable
	EGU_INTEN_TRIGGERED4_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED4_Enabled = 0x1
	// Position of TRIGGERED5 field.
	EGU_INTEN_TRIGGERED5_Pos = 0x5
	// Bit mask of TRIGGERED5 field.
	EGU_INTEN_TRIGGERED5_Msk = 0x20
	// Bit TRIGGERED5.
	EGU_INTEN_TRIGGERED5 = 0x20
	// Disable
	EGU_INTEN_TRIGGERED5_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED5_Enabled = 0x1
	// Position of TRIGGERED6 field.
	EGU_INTEN_TRIGGERED6_Pos = 0x6
	// Bit mask of TRIGGERED6 field.
	EGU_INTEN_TRIGGERED6_Msk = 0x40
	// Bit TRIGGERED6.
	EGU_INTEN_TRIGGERED6 = 0x40
	// Disable
	EGU_INTEN_TRIGGERED6_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED6_Enabled = 0x1
	// Position of TRIGGERED7 field.
	EGU_INTEN_TRIGGERED7_Pos = 0x7
	// Bit mask of TRIGGERED7 field.
	EGU_INTEN_TRIGGERED7_Msk = 0x80
	// Bit TRIGGERED7.
	EGU_INTEN_TRIGGERED7 = 0x80
	// Disable
	EGU_INTEN_TRIGGERED7_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED7_Enabled = 0x1
	// Position of TRIGGERED8 field.
	EGU_INTEN_TRIGGERED8_Pos = 0x8
	// Bit mask of TRIGGERED8 field.
	EGU_INTEN_TRIGGERED8_Msk = 0x100
	// Bit TRIGGERED8.
	EGU_INTEN_TRIGGERED8 = 0x100
	// Disable
	EGU_INTEN_TRIGGERED8_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED8_Enabled = 0x1
	// Position of TRIGGERED9 field.
	EGU_INTEN_TRIGGERED9_Pos = 0x9
	// Bit mask of TRIGGERED9 field.
	EGU_INTEN_TRIGGERED9_Msk = 0x200
	// Bit TRIGGERED9.
	EGU_INTEN_TRIGGERED9 = 0x200
	// Disable
	EGU_INTEN_TRIGGERED9_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED9_Enabled = 0x1
	// Position of TRIGGERED10 field.
	EGU_INTEN_TRIGGERED10_Pos = 0xa
	// Bit mask of TRIGGERED10 field.
	EGU_INTEN_TRIGGERED10_Msk = 0x400
	// Bit TRIGGERED10.
	EGU_INTEN_TRIGGERED10 = 0x400
	// Disable
	EGU_INTEN_TRIGGERED10_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED10_Enabled = 0x1
	// Position of TRIGGERED11 field.
	EGU_INTEN_TRIGGERED11_Pos = 0xb
	// Bit mask of TRIGGERED11 field.
	EGU_INTEN_TRIGGERED11_Msk = 0x800
	// Bit TRIGGERED11.
	EGU_INTEN_TRIGGERED11 = 0x800
	// Disable
	EGU_INTEN_TRIGGERED11_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED11_Enabled = 0x1
	// Position of TRIGGERED12 field.
	EGU_INTEN_TRIGGERED12_Pos = 0xc
	// Bit mask of TRIGGERED12 field.
	EGU_INTEN_TRIGGERED12_Msk = 0x1000
	// Bit TRIGGERED12.
	EGU_INTEN_TRIGGERED12 = 0x1000
	// Disable
	EGU_INTEN_TRIGGERED12_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED12_Enabled = 0x1
	// Position of TRIGGERED13 field.
	EGU_INTEN_TRIGGERED13_Pos = 0xd
	// Bit mask of TRIGGERED13 field.
	EGU_INTEN_TRIGGERED13_Msk = 0x2000
	// Bit TRIGGERED13.
	EGU_INTEN_TRIGGERED13 = 0x2000
	// Disable
	EGU_INTEN_TRIGGERED13_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED13_Enabled = 0x1
	// Position of TRIGGERED14 field.
	EGU_INTEN_TRIGGERED14_Pos = 0xe
	// Bit mask of TRIGGERED14 field.
	EGU_INTEN_TRIGGERED14_Msk = 0x4000
	// Bit TRIGGERED14.
	EGU_INTEN_TRIGGERED14 = 0x4000
	// Disable
	EGU_INTEN_TRIGGERED14_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED14_Enabled = 0x1
	// Position of TRIGGERED15 field.
	EGU_INTEN_TRIGGERED15_Pos = 0xf
	// Bit mask of TRIGGERED15 field.
	EGU_INTEN_TRIGGERED15_Msk = 0x8000
	// Bit TRIGGERED15.
	EGU_INTEN_TRIGGERED15 = 0x8000
	// Disable
	EGU_INTEN_TRIGGERED15_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED15_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of TRIGGERED0 field.
	EGU_INTENSET_TRIGGERED0_Pos = 0x0
	// Bit mask of TRIGGERED0 field.
	EGU_INTENSET_TRIGGERED0_Msk = 0x1
	// Bit TRIGGERED0.
	EGU_INTENSET_TRIGGERED0 = 0x1
	// Read: Disabled
	EGU_INTENSET_TRIGGERED0_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED0_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED0_Set = 0x1
	// Position of TRIGGERED1 field.
	EGU_INTENSET_TRIGGERED1_Pos = 0x1
	// Bit mask of TRIGGERED1 field.
	EGU_INTENSET_TRIGGERED1_Msk = 0x2
	// Bit TRIGGERED1.
	EGU_INTENSET_TRIGGERED1 = 0x2
	// Read: Disabled
	EGU_INTENSET_TRIGGERED1_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED1_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED1_Set = 0x1
	// Position of TRIGGERED2 field.
	EGU_INTENSET_TRIGGERED2_Pos = 0x2
	// Bit mask of TRIGGERED2 field.
	EGU_INTENSET_TRIGGERED2_Msk = 0x4
	// Bit TRIGGERED2.
	EGU_INTENSET_TRIGGERED2 = 0x4
	// Read: Disabled
	EGU_INTENSET_TRIGGERED2_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED2_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED2_Set = 0x1
	// Position of TRIGGERED3 field.
	EGU_INTENSET_TRIGGERED3_Pos = 0x3
	// Bit mask of TRIGGERED3 field.
	EGU_INTENSET_TRIGGERED3_Msk = 0x8
	// Bit TRIGGERED3.
	EGU_INTENSET_TRIGGERED3 = 0x8
	// Read: Disabled
	EGU_INTENSET_TRIGGERED3_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED3_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED3_Set = 0x1
	// Position of TRIGGERED4 field.
	EGU_INTENSET_TRIGGERED4_Pos = 0x4
	// Bit mask of TRIGGERED4 field.
	EGU_INTENSET_TRIGGERED4_Msk = 0x10
	// Bit TRIGGERED4.
	EGU_INTENSET_TRIGGERED4 = 0x10
	// Read: Disabled
	EGU_INTENSET_TRIGGERED4_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED4_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED4_Set = 0x1
	// Position of TRIGGERED5 field.
	EGU_INTENSET_TRIGGERED5_Pos = 0x5
	// Bit mask of TRIGGERED5 field.
	EGU_INTENSET_TRIGGERED5_Msk = 0x20
	// Bit TRIGGERED5.
	EGU_INTENSET_TRIGGERED5 = 0x20
	// Read: Disabled
	EGU_INTENSET_TRIGGERED5_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED5_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED5_Set = 0x1
	// Position of TRIGGERED6 field.
	EGU_INTENSET_TRIGGERED6_Pos = 0x6
	// Bit mask of TRIGGERED6 field.
	EGU_INTENSET_TRIGGERED6_Msk = 0x40
	// Bit TRIGGERED6.
	EGU_INTENSET_TRIGGERED6 = 0x40
	// Read: Disabled
	EGU_INTENSET_TRIGGERED6_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED6_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED6_Set = 0x1
	// Position of TRIGGERED7 field.
	EGU_INTENSET_TRIGGERED7_Pos = 0x7
	// Bit mask of TRIGGERED7 field.
	EGU_INTENSET_TRIGGERED7_Msk = 0x80
	// Bit TRIGGERED7.
	EGU_INTENSET_TRIGGERED7 = 0x80
	// Read: Disabled
	EGU_INTENSET_TRIGGERED7_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED7_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED7_Set = 0x1
	// Position of TRIGGERED8 field.
	EGU_INTENSET_TRIGGERED8_Pos = 0x8
	// Bit mask of TRIGGERED8 field.
	EGU_INTENSET_TRIGGERED8_Msk = 0x100
	// Bit TRIGGERED8.
	EGU_INTENSET_TRIGGERED8 = 0x100
	// Read: Disabled
	EGU_INTENSET_TRIGGERED8_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED8_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED8_Set = 0x1
	// Position of TRIGGERED9 field.
	EGU_INTENSET_TRIGGERED9_Pos = 0x9
	// Bit mask of TRIGGERED9 field.
	EGU_INTENSET_TRIGGERED9_Msk = 0x200
	// Bit TRIGGERED9.
	EGU_INTENSET_TRIGGERED9 = 0x200
	// Read: Disabled
	EGU_INTENSET_TRIGGERED9_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED9_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED9_Set = 0x1
	// Position of TRIGGERED10 field.
	EGU_INTENSET_TRIGGERED10_Pos = 0xa
	// Bit mask of TRIGGERED10 field.
	EGU_INTENSET_TRIGGERED10_Msk = 0x400
	// Bit TRIGGERED10.
	EGU_INTENSET_TRIGGERED10 = 0x400
	// Read: Disabled
	EGU_INTENSET_TRIGGERED10_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED10_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED10_Set = 0x1
	// Position of TRIGGERED11 field.
	EGU_INTENSET_TRIGGERED11_Pos = 0xb
	// Bit mask of TRIGGERED11 field.
	EGU_INTENSET_TRIGGERED11_Msk = 0x800
	// Bit TRIGGERED11.
	EGU_INTENSET_TRIGGERED11 = 0x800
	// Read: Disabled
	EGU_INTENSET_TRIGGERED11_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED11_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED11_Set = 0x1
	// Position of TRIGGERED12 field.
	EGU_INTENSET_TRIGGERED12_Pos = 0xc
	// Bit mask of TRIGGERED12 field.
	EGU_INTENSET_TRIGGERED12_Msk = 0x1000
	// Bit TRIGGERED12.
	EGU_INTENSET_TRIGGERED12 = 0x1000
	// Read: Disabled
	EGU_INTENSET_TRIGGERED12_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED12_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED12_Set = 0x1
	// Position of TRIGGERED13 field.
	EGU_INTENSET_TRIGGERED13_Pos = 0xd
	// Bit mask of TRIGGERED13 field.
	EGU_INTENSET_TRIGGERED13_Msk = 0x2000
	// Bit TRIGGERED13.
	EGU_INTENSET_TRIGGERED13 = 0x2000
	// Read: Disabled
	EGU_INTENSET_TRIGGERED13_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED13_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED13_Set = 0x1
	// Position of TRIGGERED14 field.
	EGU_INTENSET_TRIGGERED14_Pos = 0xe
	// Bit mask of TRIGGERED14 field.
	EGU_INTENSET_TRIGGERED14_Msk = 0x4000
	// Bit TRIGGERED14.
	EGU_INTENSET_TRIGGERED14 = 0x4000
	// Read: Disabled
	EGU_INTENSET_TRIGGERED14_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED14_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED14_Set = 0x1
	// Position of TRIGGERED15 field.
	EGU_INTENSET_TRIGGERED15_Pos = 0xf
	// Bit mask of TRIGGERED15 field.
	EGU_INTENSET_TRIGGERED15_Msk = 0x8000
	// Bit TRIGGERED15.
	EGU_INTENSET_TRIGGERED15 = 0x8000
	// Read: Disabled
	EGU_INTENSET_TRIGGERED15_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED15_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED15_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of TRIGGERED0 field.
	EGU_INTENCLR_TRIGGERED0_Pos = 0x0
	// Bit mask of TRIGGERED0 field.
	EGU_INTENCLR_TRIGGERED0_Msk = 0x1
	// Bit TRIGGERED0.
	EGU_INTENCLR_TRIGGERED0 = 0x1
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED0_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED0_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED0_Clear = 0x1
	// Position of TRIGGERED1 field.
	EGU_INTENCLR_TRIGGERED1_Pos = 0x1
	// Bit mask of TRIGGERED1 field.
	EGU_INTENCLR_TRIGGERED1_Msk = 0x2
	// Bit TRIGGERED1.
	EGU_INTENCLR_TRIGGERED1 = 0x2
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED1_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED1_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED1_Clear = 0x1
	// Position of TRIGGERED2 field.
	EGU_INTENCLR_TRIGGERED2_Pos = 0x2
	// Bit mask of TRIGGERED2 field.
	EGU_INTENCLR_TRIGGERED2_Msk = 0x4
	// Bit TRIGGERED2.
	EGU_INTENCLR_TRIGGERED2 = 0x4
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED2_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED2_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED2_Clear = 0x1
	// Position of TRIGGERED3 field.
	EGU_INTENCLR_TRIGGERED3_Pos = 0x3
	// Bit mask of TRIGGERED3 field.
	EGU_INTENCLR_TRIGGERED3_Msk = 0x8
	// Bit TRIGGERED3.
	EGU_INTENCLR_TRIGGERED3 = 0x8
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED3_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED3_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED3_Clear = 0x1
	// Position of TRIGGERED4 field.
	EGU_INTENCLR_TRIGGERED4_Pos = 0x4
	// Bit mask of TRIGGERED4 field.
	EGU_INTENCLR_TRIGGERED4_Msk = 0x10
	// Bit TRIGGERED4.
	EGU_INTENCLR_TRIGGERED4 = 0x10
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED4_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED4_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED4_Clear = 0x1
	// Position of TRIGGERED5 field.
	EGU_INTENCLR_TRIGGERED5_Pos = 0x5
	// Bit mask of TRIGGERED5 field.
	EGU_INTENCLR_TRIGGERED5_Msk = 0x20
	// Bit TRIGGERED5.
	EGU_INTENCLR_TRIGGERED5 = 0x20
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED5_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED5_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED5_Clear = 0x1
	// Position of TRIGGERED6 field.
	EGU_INTENCLR_TRIGGERED6_Pos = 0x6
	// Bit mask of TRIGGERED6 field.
	EGU_INTENCLR_TRIGGERED6_Msk = 0x40
	// Bit TRIGGERED6.
	EGU_INTENCLR_TRIGGERED6 = 0x40
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED6_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED6_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED6_Clear = 0x1
	// Position of TRIGGERED7 field.
	EGU_INTENCLR_TRIGGERED7_Pos = 0x7
	// Bit mask of TRIGGERED7 field.
	EGU_INTENCLR_TRIGGERED7_Msk = 0x80
	// Bit TRIGGERED7.
	EGU_INTENCLR_TRIGGERED7 = 0x80
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED7_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED7_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED7_Clear = 0x1
	// Position of TRIGGERED8 field.
	EGU_INTENCLR_TRIGGERED8_Pos = 0x8
	// Bit mask of TRIGGERED8 field.
	EGU_INTENCLR_TRIGGERED8_Msk = 0x100
	// Bit TRIGGERED8.
	EGU_INTENCLR_TRIGGERED8 = 0x100
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED8_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED8_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED8_Clear = 0x1
	// Position of TRIGGERED9 field.
	EGU_INTENCLR_TRIGGERED9_Pos = 0x9
	// Bit mask of TRIGGERED9 field.
	EGU_INTENCLR_TRIGGERED9_Msk = 0x200
	// Bit TRIGGERED9.
	EGU_INTENCLR_TRIGGERED9 = 0x200
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED9_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED9_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED9_Clear = 0x1
	// Position of TRIGGERED10 field.
	EGU_INTENCLR_TRIGGERED10_Pos = 0xa
	// Bit mask of TRIGGERED10 field.
	EGU_INTENCLR_TRIGGERED10_Msk = 0x400
	// Bit TRIGGERED10.
	EGU_INTENCLR_TRIGGERED10 = 0x400
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED10_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED10_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED10_Clear = 0x1
	// Position of TRIGGERED11 field.
	EGU_INTENCLR_TRIGGERED11_Pos = 0xb
	// Bit mask of TRIGGERED11 field.
	EGU_INTENCLR_TRIGGERED11_Msk = 0x800
	// Bit TRIGGERED11.
	EGU_INTENCLR_TRIGGERED11 = 0x800
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED11_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED11_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED11_Clear = 0x1
	// Position of TRIGGERED12 field.
	EGU_INTENCLR_TRIGGERED12_Pos = 0xc
	// Bit mask of TRIGGERED12 field.
	EGU_INTENCLR_TRIGGERED12_Msk = 0x1000
	// Bit TRIGGERED12.
	EGU_INTENCLR_TRIGGERED12 = 0x1000
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED12_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED12_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED12_Clear = 0x1
	// Position of TRIGGERED13 field.
	EGU_INTENCLR_TRIGGERED13_Pos = 0xd
	// Bit mask of TRIGGERED13 field.
	EGU_INTENCLR_TRIGGERED13_Msk = 0x2000
	// Bit TRIGGERED13.
	EGU_INTENCLR_TRIGGERED13 = 0x2000
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED13_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED13_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED13_Clear = 0x1
	// Position of TRIGGERED14 field.
	EGU_INTENCLR_TRIGGERED14_Pos = 0xe
	// Bit mask of TRIGGERED14 field.
	EGU_INTENCLR_TRIGGERED14_Msk = 0x4000
	// Bit TRIGGERED14.
	EGU_INTENCLR_TRIGGERED14 = 0x4000
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED14_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED14_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED14_Clear = 0x1
	// Position of TRIGGERED15 field.
	EGU_INTENCLR_TRIGGERED15_Pos = 0xf
	// Bit mask of TRIGGERED15 field.
	EGU_INTENCLR_TRIGGERED15_Msk = 0x8000
	// Bit TRIGGERED15.
	EGU_INTENCLR_TRIGGERED15 = 0x8000
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED15_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED15_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED15_Clear = 0x1
)

// Bitfields for SWI0_NS: Software interrupt 0
const ()

// Bitfields for APPMUTEX_NS: MUTEX 0
const (
	// MUTEX: Description collection: Mutex register
	// Position of MUTEX field.
	MUTEX_MUTEX_MUTEX_Pos = 0x0
	// Bit mask of MUTEX field.
	MUTEX_MUTEX_MUTEX_Msk = 0x1
	// Bit MUTEX.
	MUTEX_MUTEX_MUTEX = 0x1
	// Mutex n is in unlocked state
	MUTEX_MUTEX_MUTEX_Unlocked = 0x0
	// Mutex n is in locked state
	MUTEX_MUTEX_MUTEX_Locked = 0x1
)

// Bitfields for ACL_NS: Access control lists
const (
	// ACL.ADDR: Description cluster: Configure the word-aligned start address of region n to protect
	// Position of ADDR field.
	ACL_ACL_ADDR_ADDR_Pos = 0x0
	// Bit mask of ADDR field.
	ACL_ACL_ADDR_ADDR_Msk = 0xffffffff

	// ACL.SIZE: Description cluster: Size of region to protect counting from address ACL[n].ADDR. Write '0' as no effect.
	// Position of SIZE field.
	ACL_ACL_SIZE_SIZE_Pos = 0x0
	// Bit mask of SIZE field.
	ACL_ACL_SIZE_SIZE_Msk = 0xffffffff

	// ACL.PERM: Description cluster: Access permissions for region n as defined by start address ACL[n].ADDR and size ACL[n].SIZE
	// Position of WRITE field.
	ACL_ACL_PERM_WRITE_Pos = 0x1
	// Bit mask of WRITE field.
	ACL_ACL_PERM_WRITE_Msk = 0x2
	// Bit WRITE.
	ACL_ACL_PERM_WRITE = 0x2
	// Allow write and erase instructions to region n
	ACL_ACL_PERM_WRITE_Enable = 0x0
	// Block write and erase instructions to region n
	ACL_ACL_PERM_WRITE_Disable = 0x1
	// Position of READ field.
	ACL_ACL_PERM_READ_Pos = 0x2
	// Bit mask of READ field.
	ACL_ACL_PERM_READ_Msk = 0x4
	// Bit READ.
	ACL_ACL_PERM_READ = 0x4
	// Allow read instructions to region n
	ACL_ACL_PERM_READ_Enable = 0x0
	// Block read instructions to region n
	ACL_ACL_PERM_READ_Disable = 0x1
)

// Bitfields for NVMC_NS: Non-volatile memory controller
const (
	// READY: Ready flag
	// Position of READY field.
	NVMC_READY_READY_Pos = 0x0
	// Bit mask of READY field.
	NVMC_READY_READY_Msk = 0x1
	// Bit READY.
	NVMC_READY_READY = 0x1
	// NVMC is busy (on-going write or erase operation)
	NVMC_READY_READY_Busy = 0x0
	// NVMC is ready
	NVMC_READY_READY_Ready = 0x1

	// READYNEXT: Ready flag
	// Position of READYNEXT field.
	NVMC_READYNEXT_READYNEXT_Pos = 0x0
	// Bit mask of READYNEXT field.
	NVMC_READYNEXT_READYNEXT_Msk = 0x1
	// Bit READYNEXT.
	NVMC_READYNEXT_READYNEXT = 0x1
	// NVMC cannot accept any write operation
	NVMC_READYNEXT_READYNEXT_Busy = 0x0
	// NVMC is ready
	NVMC_READYNEXT_READYNEXT_Ready = 0x1

	// CONFIG: Configuration register
	// Position of WEN field.
	NVMC_CONFIG_WEN_Pos = 0x0
	// Bit mask of WEN field.
	NVMC_CONFIG_WEN_Msk = 0x7
	// Read only access
	NVMC_CONFIG_WEN_Ren = 0x0
	// Write enabled
	NVMC_CONFIG_WEN_Wen = 0x1
	// Erase enabled
	NVMC_CONFIG_WEN_Een = 0x2
	// Partial erase enabled
	NVMC_CONFIG_WEN_PEen = 0x4

	// ERASEALL: Register for erasing all non-volatile user memory
	// Position of ERASEALL field.
	NVMC_ERASEALL_ERASEALL_Pos = 0x0
	// Bit mask of ERASEALL field.
	NVMC_ERASEALL_ERASEALL_Msk = 0x1
	// Bit ERASEALL.
	NVMC_ERASEALL_ERASEALL = 0x1
	// No operation
	NVMC_ERASEALL_ERASEALL_NoOperation = 0x0
	// Start chip erase
	NVMC_ERASEALL_ERASEALL_Erase = 0x1

	// ERASEPAGEPARTIALCFG: Register for partial erase configuration
	// Position of DURATION field.
	NVMC_ERASEPAGEPARTIALCFG_DURATION_Pos = 0x0
	// Bit mask of DURATION field.
	NVMC_ERASEPAGEPARTIALCFG_DURATION_Msk = 0x7f

	// ICACHECNF: I-code cache configuration register
	// Position of CACHEEN field.
	NVMC_ICACHECNF_CACHEEN_Pos = 0x0
	// Bit mask of CACHEEN field.
	NVMC_ICACHECNF_CACHEEN_Msk = 0x1
	// Bit CACHEEN.
	NVMC_ICACHECNF_CACHEEN = 0x1
	// Disable cache. Invalidates all cache entries.
	NVMC_ICACHECNF_CACHEEN_Disabled = 0x0
	// Enable cache
	NVMC_ICACHECNF_CACHEEN_Enabled = 0x1
	// Position of CACHEPROFEN field.
	NVMC_ICACHECNF_CACHEPROFEN_Pos = 0x8
	// Bit mask of CACHEPROFEN field.
	NVMC_ICACHECNF_CACHEPROFEN_Msk = 0x100
	// Bit CACHEPROFEN.
	NVMC_ICACHECNF_CACHEPROFEN = 0x100
	// Disable cache profiling
	NVMC_ICACHECNF_CACHEPROFEN_Disabled = 0x0
	// Enable cache profiling
	NVMC_ICACHECNF_CACHEPROFEN_Enabled = 0x1

	// IHIT: I-code cache hit counter
	// Position of HITS field.
	NVMC_IHIT_HITS_Pos = 0x0
	// Bit mask of HITS field.
	NVMC_IHIT_HITS_Msk = 0xffffffff

	// IMISS: I-code cache miss counter
	// Position of MISSES field.
	NVMC_IMISS_MISSES_Pos = 0x0
	// Bit mask of MISSES field.
	NVMC_IMISS_MISSES_Msk = 0xffffffff
)

// Bitfields for VMC_NS: Volatile Memory controller
const (
	// RAM.POWER: Description cluster: RAM[n] power control register
	// Position of S0POWER field.
	VMC_RAM_POWER_S0POWER_Pos = 0x0
	// Bit mask of S0POWER field.
	VMC_RAM_POWER_S0POWER_Msk = 0x1
	// Bit S0POWER.
	VMC_RAM_POWER_S0POWER = 0x1
	// Off
	VMC_RAM_POWER_S0POWER_Off = 0x0
	// On
	VMC_RAM_POWER_S0POWER_On = 0x1
	// Position of S1POWER field.
	VMC_RAM_POWER_S1POWER_Pos = 0x1
	// Bit mask of S1POWER field.
	VMC_RAM_POWER_S1POWER_Msk = 0x2
	// Bit S1POWER.
	VMC_RAM_POWER_S1POWER = 0x2
	// Off
	VMC_RAM_POWER_S1POWER_Off = 0x0
	// On
	VMC_RAM_POWER_S1POWER_On = 0x1
	// Position of S2POWER field.
	VMC_RAM_POWER_S2POWER_Pos = 0x2
	// Bit mask of S2POWER field.
	VMC_RAM_POWER_S2POWER_Msk = 0x4
	// Bit S2POWER.
	VMC_RAM_POWER_S2POWER = 0x4
	// Off
	VMC_RAM_POWER_S2POWER_Off = 0x0
	// On
	VMC_RAM_POWER_S2POWER_On = 0x1
	// Position of S3POWER field.
	VMC_RAM_POWER_S3POWER_Pos = 0x3
	// Bit mask of S3POWER field.
	VMC_RAM_POWER_S3POWER_Msk = 0x8
	// Bit S3POWER.
	VMC_RAM_POWER_S3POWER = 0x8
	// Off
	VMC_RAM_POWER_S3POWER_Off = 0x0
	// On
	VMC_RAM_POWER_S3POWER_On = 0x1
	// Position of S0RETENTION field.
	VMC_RAM_POWER_S0RETENTION_Pos = 0x10
	// Bit mask of S0RETENTION field.
	VMC_RAM_POWER_S0RETENTION_Msk = 0x10000
	// Bit S0RETENTION.
	VMC_RAM_POWER_S0RETENTION = 0x10000
	// Off
	VMC_RAM_POWER_S0RETENTION_Off = 0x0
	// On
	VMC_RAM_POWER_S0RETENTION_On = 0x1
	// Position of S1RETENTION field.
	VMC_RAM_POWER_S1RETENTION_Pos = 0x11
	// Bit mask of S1RETENTION field.
	VMC_RAM_POWER_S1RETENTION_Msk = 0x20000
	// Bit S1RETENTION.
	VMC_RAM_POWER_S1RETENTION = 0x20000
	// Off
	VMC_RAM_POWER_S1RETENTION_Off = 0x0
	// On
	VMC_RAM_POWER_S1RETENTION_On = 0x1
	// Position of S2RETENTION field.
	VMC_RAM_POWER_S2RETENTION_Pos = 0x12
	// Bit mask of S2RETENTION field.
	VMC_RAM_POWER_S2RETENTION_Msk = 0x40000
	// Bit S2RETENTION.
	VMC_RAM_POWER_S2RETENTION = 0x40000
	// Off
	VMC_RAM_POWER_S2RETENTION_Off = 0x0
	// On
	VMC_RAM_POWER_S2RETENTION_On = 0x1
	// Position of S3RETENTION field.
	VMC_RAM_POWER_S3RETENTION_Pos = 0x13
	// Bit mask of S3RETENTION field.
	VMC_RAM_POWER_S3RETENTION_Msk = 0x80000
	// Bit S3RETENTION.
	VMC_RAM_POWER_S3RETENTION = 0x80000
	// Off
	VMC_RAM_POWER_S3RETENTION_Off = 0x0
	// On
	VMC_RAM_POWER_S3RETENTION_On = 0x1

	// RAM.POWERSET: Description cluster: RAM[n] power control set register
	// Position of S0POWER field.
	VMC_RAM_POWERSET_S0POWER_Pos = 0x0
	// Bit mask of S0POWER field.
	VMC_RAM_POWERSET_S0POWER_Msk = 0x1
	// Bit S0POWER.
	VMC_RAM_POWERSET_S0POWER = 0x1
	// On
	VMC_RAM_POWERSET_S0POWER_On = 0x1
	// Position of S1POWER field.
	VMC_RAM_POWERSET_S1POWER_Pos = 0x1
	// Bit mask of S1POWER field.
	VMC_RAM_POWERSET_S1POWER_Msk = 0x2
	// Bit S1POWER.
	VMC_RAM_POWERSET_S1POWER = 0x2
	// On
	VMC_RAM_POWERSET_S1POWER_On = 0x1
	// Position of S2POWER field.
	VMC_RAM_POWERSET_S2POWER_Pos = 0x2
	// Bit mask of S2POWER field.
	VMC_RAM_POWERSET_S2POWER_Msk = 0x4
	// Bit S2POWER.
	VMC_RAM_POWERSET_S2POWER = 0x4
	// On
	VMC_RAM_POWERSET_S2POWER_On = 0x1
	// Position of S3POWER field.
	VMC_RAM_POWERSET_S3POWER_Pos = 0x3
	// Bit mask of S3POWER field.
	VMC_RAM_POWERSET_S3POWER_Msk = 0x8
	// Bit S3POWER.
	VMC_RAM_POWERSET_S3POWER = 0x8
	// On
	VMC_RAM_POWERSET_S3POWER_On = 0x1
	// Position of S0RETENTION field.
	VMC_RAM_POWERSET_S0RETENTION_Pos = 0x10
	// Bit mask of S0RETENTION field.
	VMC_RAM_POWERSET_S0RETENTION_Msk = 0x10000
	// Bit S0RETENTION.
	VMC_RAM_POWERSET_S0RETENTION = 0x10000
	// On
	VMC_RAM_POWERSET_S0RETENTION_On = 0x1
	// Position of S1RETENTION field.
	VMC_RAM_POWERSET_S1RETENTION_Pos = 0x11
	// Bit mask of S1RETENTION field.
	VMC_RAM_POWERSET_S1RETENTION_Msk = 0x20000
	// Bit S1RETENTION.
	VMC_RAM_POWERSET_S1RETENTION = 0x20000
	// On
	VMC_RAM_POWERSET_S1RETENTION_On = 0x1
	// Position of S2RETENTION field.
	VMC_RAM_POWERSET_S2RETENTION_Pos = 0x12
	// Bit mask of S2RETENTION field.
	VMC_RAM_POWERSET_S2RETENTION_Msk = 0x40000
	// Bit S2RETENTION.
	VMC_RAM_POWERSET_S2RETENTION = 0x40000
	// On
	VMC_RAM_POWERSET_S2RETENTION_On = 0x1
	// Position of S3RETENTION field.
	VMC_RAM_POWERSET_S3RETENTION_Pos = 0x13
	// Bit mask of S3RETENTION field.
	VMC_RAM_POWERSET_S3RETENTION_Msk = 0x80000
	// Bit S3RETENTION.
	VMC_RAM_POWERSET_S3RETENTION = 0x80000
	// On
	VMC_RAM_POWERSET_S3RETENTION_On = 0x1

	// RAM.POWERCLR: Description cluster: RAM[n] power control clear register
	// Position of S0POWER field.
	VMC_RAM_POWERCLR_S0POWER_Pos = 0x0
	// Bit mask of S0POWER field.
	VMC_RAM_POWERCLR_S0POWER_Msk = 0x1
	// Bit S0POWER.
	VMC_RAM_POWERCLR_S0POWER = 0x1
	// Off
	VMC_RAM_POWERCLR_S0POWER_Off = 0x1
	// Position of S1POWER field.
	VMC_RAM_POWERCLR_S1POWER_Pos = 0x1
	// Bit mask of S1POWER field.
	VMC_RAM_POWERCLR_S1POWER_Msk = 0x2
	// Bit S1POWER.
	VMC_RAM_POWERCLR_S1POWER = 0x2
	// Off
	VMC_RAM_POWERCLR_S1POWER_Off = 0x1
	// Position of S2POWER field.
	VMC_RAM_POWERCLR_S2POWER_Pos = 0x2
	// Bit mask of S2POWER field.
	VMC_RAM_POWERCLR_S2POWER_Msk = 0x4
	// Bit S2POWER.
	VMC_RAM_POWERCLR_S2POWER = 0x4
	// Off
	VMC_RAM_POWERCLR_S2POWER_Off = 0x1
	// Position of S3POWER field.
	VMC_RAM_POWERCLR_S3POWER_Pos = 0x3
	// Bit mask of S3POWER field.
	VMC_RAM_POWERCLR_S3POWER_Msk = 0x8
	// Bit S3POWER.
	VMC_RAM_POWERCLR_S3POWER = 0x8
	// Off
	VMC_RAM_POWERCLR_S3POWER_Off = 0x1
	// Position of S0RETENTION field.
	VMC_RAM_POWERCLR_S0RETENTION_Pos = 0x10
	// Bit mask of S0RETENTION field.
	VMC_RAM_POWERCLR_S0RETENTION_Msk = 0x10000
	// Bit S0RETENTION.
	VMC_RAM_POWERCLR_S0RETENTION = 0x10000
	// Off
	VMC_RAM_POWERCLR_S0RETENTION_Off = 0x1
	// Position of S1RETENTION field.
	VMC_RAM_POWERCLR_S1RETENTION_Pos = 0x11
	// Bit mask of S1RETENTION field.
	VMC_RAM_POWERCLR_S1RETENTION_Msk = 0x20000
	// Bit S1RETENTION.
	VMC_RAM_POWERCLR_S1RETENTION = 0x20000
	// Off
	VMC_RAM_POWERCLR_S1RETENTION_Off = 0x1
	// Position of S2RETENTION field.
	VMC_RAM_POWERCLR_S2RETENTION_Pos = 0x12
	// Bit mask of S2RETENTION field.
	VMC_RAM_POWERCLR_S2RETENTION_Msk = 0x40000
	// Bit S2RETENTION.
	VMC_RAM_POWERCLR_S2RETENTION = 0x40000
	// Off
	VMC_RAM_POWERCLR_S2RETENTION_Off = 0x1
	// Position of S3RETENTION field.
	VMC_RAM_POWERCLR_S3RETENTION_Pos = 0x13
	// Bit mask of S3RETENTION field.
	VMC_RAM_POWERCLR_S3RETENTION_Msk = 0x80000
	// Bit S3RETENTION.
	VMC_RAM_POWERCLR_S3RETENTION = 0x80000
	// Off
	VMC_RAM_POWERCLR_S3RETENTION_Off = 0x1
)

// Bitfields for P0_NS: GPIO Port 0
const (
	// OUT: Write GPIO port
	// Position of PIN0 field.
	GPIO_OUT_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_OUT_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_OUT_PIN0 = 0x1
	// Pin driver is low
	GPIO_OUT_PIN0_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN0_High = 0x1
	// Position of PIN1 field.
	GPIO_OUT_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_OUT_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_OUT_PIN1 = 0x2
	// Pin driver is low
	GPIO_OUT_PIN1_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN1_High = 0x1
	// Position of PIN2 field.
	GPIO_OUT_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_OUT_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_OUT_PIN2 = 0x4
	// Pin driver is low
	GPIO_OUT_PIN2_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN2_High = 0x1
	// Position of PIN3 field.
	GPIO_OUT_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_OUT_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_OUT_PIN3 = 0x8
	// Pin driver is low
	GPIO_OUT_PIN3_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN3_High = 0x1
	// Position of PIN4 field.
	GPIO_OUT_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_OUT_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_OUT_PIN4 = 0x10
	// Pin driver is low
	GPIO_OUT_PIN4_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN4_High = 0x1
	// Position of PIN5 field.
	GPIO_OUT_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_OUT_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_OUT_PIN5 = 0x20
	// Pin driver is low
	GPIO_OUT_PIN5_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN5_High = 0x1
	// Position of PIN6 field.
	GPIO_OUT_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_OUT_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_OUT_PIN6 = 0x40
	// Pin driver is low
	GPIO_OUT_PIN6_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN6_High = 0x1
	// Position of PIN7 field.
	GPIO_OUT_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_OUT_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_OUT_PIN7 = 0x80
	// Pin driver is low
	GPIO_OUT_PIN7_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN7_High = 0x1
	// Position of PIN8 field.
	GPIO_OUT_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_OUT_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_OUT_PIN8 = 0x100
	// Pin driver is low
	GPIO_OUT_PIN8_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN8_High = 0x1
	// Position of PIN9 field.
	GPIO_OUT_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_OUT_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_OUT_PIN9 = 0x200
	// Pin driver is low
	GPIO_OUT_PIN9_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN9_High = 0x1
	// Position of PIN10 field.
	GPIO_OUT_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_OUT_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_OUT_PIN10 = 0x400
	// Pin driver is low
	GPIO_OUT_PIN10_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN10_High = 0x1
	// Position of PIN11 field.
	GPIO_OUT_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_OUT_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_OUT_PIN11 = 0x800
	// Pin driver is low
	GPIO_OUT_PIN11_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN11_High = 0x1
	// Position of PIN12 field.
	GPIO_OUT_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_OUT_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_OUT_PIN12 = 0x1000
	// Pin driver is low
	GPIO_OUT_PIN12_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN12_High = 0x1
	// Position of PIN13 field.
	GPIO_OUT_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_OUT_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_OUT_PIN13 = 0x2000
	// Pin driver is low
	GPIO_OUT_PIN13_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN13_High = 0x1
	// Position of PIN14 field.
	GPIO_OUT_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_OUT_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_OUT_PIN14 = 0x4000
	// Pin driver is low
	GPIO_OUT_PIN14_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN14_High = 0x1
	// Position of PIN15 field.
	GPIO_OUT_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_OUT_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_OUT_PIN15 = 0x8000
	// Pin driver is low
	GPIO_OUT_PIN15_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN15_High = 0x1
	// Position of PIN16 field.
	GPIO_OUT_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_OUT_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_OUT_PIN16 = 0x10000
	// Pin driver is low
	GPIO_OUT_PIN16_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN16_High = 0x1
	// Position of PIN17 field.
	GPIO_OUT_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_OUT_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_OUT_PIN17 = 0x20000
	// Pin driver is low
	GPIO_OUT_PIN17_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN17_High = 0x1
	// Position of PIN18 field.
	GPIO_OUT_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_OUT_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_OUT_PIN18 = 0x40000
	// Pin driver is low
	GPIO_OUT_PIN18_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN18_High = 0x1
	// Position of PIN19 field.
	GPIO_OUT_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_OUT_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_OUT_PIN19 = 0x80000
	// Pin driver is low
	GPIO_OUT_PIN19_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN19_High = 0x1
	// Position of PIN20 field.
	GPIO_OUT_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_OUT_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_OUT_PIN20 = 0x100000
	// Pin driver is low
	GPIO_OUT_PIN20_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN20_High = 0x1
	// Position of PIN21 field.
	GPIO_OUT_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_OUT_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_OUT_PIN21 = 0x200000
	// Pin driver is low
	GPIO_OUT_PIN21_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN21_High = 0x1
	// Position of PIN22 field.
	GPIO_OUT_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_OUT_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_OUT_PIN22 = 0x400000
	// Pin driver is low
	GPIO_OUT_PIN22_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN22_High = 0x1
	// Position of PIN23 field.
	GPIO_OUT_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_OUT_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_OUT_PIN23 = 0x800000
	// Pin driver is low
	GPIO_OUT_PIN23_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN23_High = 0x1
	// Position of PIN24 field.
	GPIO_OUT_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_OUT_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_OUT_PIN24 = 0x1000000
	// Pin driver is low
	GPIO_OUT_PIN24_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN24_High = 0x1
	// Position of PIN25 field.
	GPIO_OUT_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_OUT_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_OUT_PIN25 = 0x2000000
	// Pin driver is low
	GPIO_OUT_PIN25_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN25_High = 0x1
	// Position of PIN26 field.
	GPIO_OUT_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_OUT_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_OUT_PIN26 = 0x4000000
	// Pin driver is low
	GPIO_OUT_PIN26_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN26_High = 0x1
	// Position of PIN27 field.
	GPIO_OUT_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_OUT_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_OUT_PIN27 = 0x8000000
	// Pin driver is low
	GPIO_OUT_PIN27_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN27_High = 0x1
	// Position of PIN28 field.
	GPIO_OUT_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_OUT_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_OUT_PIN28 = 0x10000000
	// Pin driver is low
	GPIO_OUT_PIN28_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN28_High = 0x1
	// Position of PIN29 field.
	GPIO_OUT_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_OUT_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_OUT_PIN29 = 0x20000000
	// Pin driver is low
	GPIO_OUT_PIN29_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN29_High = 0x1
	// Position of PIN30 field.
	GPIO_OUT_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_OUT_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_OUT_PIN30 = 0x40000000
	// Pin driver is low
	GPIO_OUT_PIN30_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN30_High = 0x1
	// Position of PIN31 field.
	GPIO_OUT_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_OUT_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_OUT_PIN31 = 0x80000000
	// Pin driver is low
	GPIO_OUT_PIN31_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN31_High = 0x1

	// OUTSET: Set individual bits in GPIO port
	// Position of PIN0 field.
	GPIO_OUTSET_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_OUTSET_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_OUTSET_PIN0 = 0x1
	// Read: pin driver is low
	GPIO_OUTSET_PIN0_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN0_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN0_Set = 0x1
	// Position of PIN1 field.
	GPIO_OUTSET_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_OUTSET_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_OUTSET_PIN1 = 0x2
	// Read: pin driver is low
	GPIO_OUTSET_PIN1_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN1_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN1_Set = 0x1
	// Position of PIN2 field.
	GPIO_OUTSET_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_OUTSET_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_OUTSET_PIN2 = 0x4
	// Read: pin driver is low
	GPIO_OUTSET_PIN2_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN2_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN2_Set = 0x1
	// Position of PIN3 field.
	GPIO_OUTSET_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_OUTSET_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_OUTSET_PIN3 = 0x8
	// Read: pin driver is low
	GPIO_OUTSET_PIN3_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN3_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN3_Set = 0x1
	// Position of PIN4 field.
	GPIO_OUTSET_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_OUTSET_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_OUTSET_PIN4 = 0x10
	// Read: pin driver is low
	GPIO_OUTSET_PIN4_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN4_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN4_Set = 0x1
	// Position of PIN5 field.
	GPIO_OUTSET_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_OUTSET_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_OUTSET_PIN5 = 0x20
	// Read: pin driver is low
	GPIO_OUTSET_PIN5_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN5_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN5_Set = 0x1
	// Position of PIN6 field.
	GPIO_OUTSET_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_OUTSET_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_OUTSET_PIN6 = 0x40
	// Read: pin driver is low
	GPIO_OUTSET_PIN6_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN6_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN6_Set = 0x1
	// Position of PIN7 field.
	GPIO_OUTSET_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_OUTSET_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_OUTSET_PIN7 = 0x80
	// Read: pin driver is low
	GPIO_OUTSET_PIN7_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN7_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN7_Set = 0x1
	// Position of PIN8 field.
	GPIO_OUTSET_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_OUTSET_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_OUTSET_PIN8 = 0x100
	// Read: pin driver is low
	GPIO_OUTSET_PIN8_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN8_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN8_Set = 0x1
	// Position of PIN9 field.
	GPIO_OUTSET_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_OUTSET_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_OUTSET_PIN9 = 0x200
	// Read: pin driver is low
	GPIO_OUTSET_PIN9_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN9_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN9_Set = 0x1
	// Position of PIN10 field.
	GPIO_OUTSET_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_OUTSET_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_OUTSET_PIN10 = 0x400
	// Read: pin driver is low
	GPIO_OUTSET_PIN10_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN10_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN10_Set = 0x1
	// Position of PIN11 field.
	GPIO_OUTSET_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_OUTSET_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_OUTSET_PIN11 = 0x800
	// Read: pin driver is low
	GPIO_OUTSET_PIN11_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN11_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN11_Set = 0x1
	// Position of PIN12 field.
	GPIO_OUTSET_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_OUTSET_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_OUTSET_PIN12 = 0x1000
	// Read: pin driver is low
	GPIO_OUTSET_PIN12_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN12_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN12_Set = 0x1
	// Position of PIN13 field.
	GPIO_OUTSET_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_OUTSET_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_OUTSET_PIN13 = 0x2000
	// Read: pin driver is low
	GPIO_OUTSET_PIN13_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN13_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN13_Set = 0x1
	// Position of PIN14 field.
	GPIO_OUTSET_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_OUTSET_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_OUTSET_PIN14 = 0x4000
	// Read: pin driver is low
	GPIO_OUTSET_PIN14_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN14_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN14_Set = 0x1
	// Position of PIN15 field.
	GPIO_OUTSET_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_OUTSET_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_OUTSET_PIN15 = 0x8000
	// Read: pin driver is low
	GPIO_OUTSET_PIN15_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN15_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN15_Set = 0x1
	// Position of PIN16 field.
	GPIO_OUTSET_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_OUTSET_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_OUTSET_PIN16 = 0x10000
	// Read: pin driver is low
	GPIO_OUTSET_PIN16_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN16_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN16_Set = 0x1
	// Position of PIN17 field.
	GPIO_OUTSET_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_OUTSET_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_OUTSET_PIN17 = 0x20000
	// Read: pin driver is low
	GPIO_OUTSET_PIN17_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN17_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN17_Set = 0x1
	// Position of PIN18 field.
	GPIO_OUTSET_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_OUTSET_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_OUTSET_PIN18 = 0x40000
	// Read: pin driver is low
	GPIO_OUTSET_PIN18_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN18_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN18_Set = 0x1
	// Position of PIN19 field.
	GPIO_OUTSET_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_OUTSET_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_OUTSET_PIN19 = 0x80000
	// Read: pin driver is low
	GPIO_OUTSET_PIN19_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN19_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN19_Set = 0x1
	// Position of PIN20 field.
	GPIO_OUTSET_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_OUTSET_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_OUTSET_PIN20 = 0x100000
	// Read: pin driver is low
	GPIO_OUTSET_PIN20_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN20_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN20_Set = 0x1
	// Position of PIN21 field.
	GPIO_OUTSET_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_OUTSET_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_OUTSET_PIN21 = 0x200000
	// Read: pin driver is low
	GPIO_OUTSET_PIN21_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN21_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN21_Set = 0x1
	// Position of PIN22 field.
	GPIO_OUTSET_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_OUTSET_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_OUTSET_PIN22 = 0x400000
	// Read: pin driver is low
	GPIO_OUTSET_PIN22_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN22_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN22_Set = 0x1
	// Position of PIN23 field.
	GPIO_OUTSET_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_OUTSET_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_OUTSET_PIN23 = 0x800000
	// Read: pin driver is low
	GPIO_OUTSET_PIN23_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN23_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN23_Set = 0x1
	// Position of PIN24 field.
	GPIO_OUTSET_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_OUTSET_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_OUTSET_PIN24 = 0x1000000
	// Read: pin driver is low
	GPIO_OUTSET_PIN24_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN24_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN24_Set = 0x1
	// Position of PIN25 field.
	GPIO_OUTSET_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_OUTSET_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_OUTSET_PIN25 = 0x2000000
	// Read: pin driver is low
	GPIO_OUTSET_PIN25_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN25_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN25_Set = 0x1
	// Position of PIN26 field.
	GPIO_OUTSET_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_OUTSET_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_OUTSET_PIN26 = 0x4000000
	// Read: pin driver is low
	GPIO_OUTSET_PIN26_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN26_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN26_Set = 0x1
	// Position of PIN27 field.
	GPIO_OUTSET_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_OUTSET_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_OUTSET_PIN27 = 0x8000000
	// Read: pin driver is low
	GPIO_OUTSET_PIN27_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN27_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN27_Set = 0x1
	// Position of PIN28 field.
	GPIO_OUTSET_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_OUTSET_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_OUTSET_PIN28 = 0x10000000
	// Read: pin driver is low
	GPIO_OUTSET_PIN28_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN28_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN28_Set = 0x1
	// Position of PIN29 field.
	GPIO_OUTSET_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_OUTSET_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_OUTSET_PIN29 = 0x20000000
	// Read: pin driver is low
	GPIO_OUTSET_PIN29_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN29_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN29_Set = 0x1
	// Position of PIN30 field.
	GPIO_OUTSET_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_OUTSET_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_OUTSET_PIN30 = 0x40000000
	// Read: pin driver is low
	GPIO_OUTSET_PIN30_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN30_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN30_Set = 0x1
	// Position of PIN31 field.
	GPIO_OUTSET_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_OUTSET_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_OUTSET_PIN31 = 0x80000000
	// Read: pin driver is low
	GPIO_OUTSET_PIN31_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN31_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN31_Set = 0x1

	// OUTCLR: Clear individual bits in GPIO port
	// Position of PIN0 field.
	GPIO_OUTCLR_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_OUTCLR_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_OUTCLR_PIN0 = 0x1
	// Read: pin driver is low
	GPIO_OUTCLR_PIN0_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN0_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN0_Clear = 0x1
	// Position of PIN1 field.
	GPIO_OUTCLR_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_OUTCLR_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_OUTCLR_PIN1 = 0x2
	// Read: pin driver is low
	GPIO_OUTCLR_PIN1_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN1_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN1_Clear = 0x1
	// Position of PIN2 field.
	GPIO_OUTCLR_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_OUTCLR_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_OUTCLR_PIN2 = 0x4
	// Read: pin driver is low
	GPIO_OUTCLR_PIN2_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN2_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN2_Clear = 0x1
	// Position of PIN3 field.
	GPIO_OUTCLR_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_OUTCLR_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_OUTCLR_PIN3 = 0x8
	// Read: pin driver is low
	GPIO_OUTCLR_PIN3_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN3_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN3_Clear = 0x1
	// Position of PIN4 field.
	GPIO_OUTCLR_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_OUTCLR_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_OUTCLR_PIN4 = 0x10
	// Read: pin driver is low
	GPIO_OUTCLR_PIN4_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN4_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN4_Clear = 0x1
	// Position of PIN5 field.
	GPIO_OUTCLR_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_OUTCLR_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_OUTCLR_PIN5 = 0x20
	// Read: pin driver is low
	GPIO_OUTCLR_PIN5_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN5_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN5_Clear = 0x1
	// Position of PIN6 field.
	GPIO_OUTCLR_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_OUTCLR_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_OUTCLR_PIN6 = 0x40
	// Read: pin driver is low
	GPIO_OUTCLR_PIN6_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN6_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN6_Clear = 0x1
	// Position of PIN7 field.
	GPIO_OUTCLR_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_OUTCLR_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_OUTCLR_PIN7 = 0x80
	// Read: pin driver is low
	GPIO_OUTCLR_PIN7_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN7_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN7_Clear = 0x1
	// Position of PIN8 field.
	GPIO_OUTCLR_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_OUTCLR_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_OUTCLR_PIN8 = 0x100
	// Read: pin driver is low
	GPIO_OUTCLR_PIN8_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN8_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN8_Clear = 0x1
	// Position of PIN9 field.
	GPIO_OUTCLR_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_OUTCLR_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_OUTCLR_PIN9 = 0x200
	// Read: pin driver is low
	GPIO_OUTCLR_PIN9_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN9_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN9_Clear = 0x1
	// Position of PIN10 field.
	GPIO_OUTCLR_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_OUTCLR_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_OUTCLR_PIN10 = 0x400
	// Read: pin driver is low
	GPIO_OUTCLR_PIN10_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN10_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN10_Clear = 0x1
	// Position of PIN11 field.
	GPIO_OUTCLR_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_OUTCLR_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_OUTCLR_PIN11 = 0x800
	// Read: pin driver is low
	GPIO_OUTCLR_PIN11_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN11_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN11_Clear = 0x1
	// Position of PIN12 field.
	GPIO_OUTCLR_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_OUTCLR_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_OUTCLR_PIN12 = 0x1000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN12_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN12_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN12_Clear = 0x1
	// Position of PIN13 field.
	GPIO_OUTCLR_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_OUTCLR_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_OUTCLR_PIN13 = 0x2000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN13_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN13_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN13_Clear = 0x1
	// Position of PIN14 field.
	GPIO_OUTCLR_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_OUTCLR_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_OUTCLR_PIN14 = 0x4000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN14_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN14_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN14_Clear = 0x1
	// Position of PIN15 field.
	GPIO_OUTCLR_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_OUTCLR_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_OUTCLR_PIN15 = 0x8000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN15_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN15_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN15_Clear = 0x1
	// Position of PIN16 field.
	GPIO_OUTCLR_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_OUTCLR_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_OUTCLR_PIN16 = 0x10000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN16_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN16_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN16_Clear = 0x1
	// Position of PIN17 field.
	GPIO_OUTCLR_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_OUTCLR_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_OUTCLR_PIN17 = 0x20000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN17_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN17_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN17_Clear = 0x1
	// Position of PIN18 field.
	GPIO_OUTCLR_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_OUTCLR_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_OUTCLR_PIN18 = 0x40000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN18_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN18_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN18_Clear = 0x1
	// Position of PIN19 field.
	GPIO_OUTCLR_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_OUTCLR_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_OUTCLR_PIN19 = 0x80000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN19_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN19_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN19_Clear = 0x1
	// Position of PIN20 field.
	GPIO_OUTCLR_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_OUTCLR_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_OUTCLR_PIN20 = 0x100000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN20_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN20_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN20_Clear = 0x1
	// Position of PIN21 field.
	GPIO_OUTCLR_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_OUTCLR_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_OUTCLR_PIN21 = 0x200000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN21_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN21_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN21_Clear = 0x1
	// Position of PIN22 field.
	GPIO_OUTCLR_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_OUTCLR_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_OUTCLR_PIN22 = 0x400000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN22_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN22_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN22_Clear = 0x1
	// Position of PIN23 field.
	GPIO_OUTCLR_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_OUTCLR_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_OUTCLR_PIN23 = 0x800000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN23_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN23_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN23_Clear = 0x1
	// Position of PIN24 field.
	GPIO_OUTCLR_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_OUTCLR_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_OUTCLR_PIN24 = 0x1000000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN24_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN24_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN24_Clear = 0x1
	// Position of PIN25 field.
	GPIO_OUTCLR_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_OUTCLR_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_OUTCLR_PIN25 = 0x2000000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN25_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN25_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN25_Clear = 0x1
	// Position of PIN26 field.
	GPIO_OUTCLR_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_OUTCLR_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_OUTCLR_PIN26 = 0x4000000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN26_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN26_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN26_Clear = 0x1
	// Position of PIN27 field.
	GPIO_OUTCLR_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_OUTCLR_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_OUTCLR_PIN27 = 0x8000000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN27_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN27_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN27_Clear = 0x1
	// Position of PIN28 field.
	GPIO_OUTCLR_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_OUTCLR_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_OUTCLR_PIN28 = 0x10000000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN28_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN28_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN28_Clear = 0x1
	// Position of PIN29 field.
	GPIO_OUTCLR_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_OUTCLR_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_OUTCLR_PIN29 = 0x20000000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN29_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN29_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN29_Clear = 0x1
	// Position of PIN30 field.
	GPIO_OUTCLR_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_OUTCLR_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_OUTCLR_PIN30 = 0x40000000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN30_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN30_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN30_Clear = 0x1
	// Position of PIN31 field.
	GPIO_OUTCLR_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_OUTCLR_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_OUTCLR_PIN31 = 0x80000000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN31_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN31_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN31_Clear = 0x1

	// IN: Read GPIO port
	// Position of PIN0 field.
	GPIO_IN_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_IN_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_IN_PIN0 = 0x1
	// Pin input is low
	GPIO_IN_PIN0_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN0_High = 0x1
	// Position of PIN1 field.
	GPIO_IN_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_IN_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_IN_PIN1 = 0x2
	// Pin input is low
	GPIO_IN_PIN1_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN1_High = 0x1
	// Position of PIN2 field.
	GPIO_IN_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_IN_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_IN_PIN2 = 0x4
	// Pin input is low
	GPIO_IN_PIN2_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN2_High = 0x1
	// Position of PIN3 field.
	GPIO_IN_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_IN_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_IN_PIN3 = 0x8
	// Pin input is low
	GPIO_IN_PIN3_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN3_High = 0x1
	// Position of PIN4 field.
	GPIO_IN_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_IN_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_IN_PIN4 = 0x10
	// Pin input is low
	GPIO_IN_PIN4_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN4_High = 0x1
	// Position of PIN5 field.
	GPIO_IN_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_IN_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_IN_PIN5 = 0x20
	// Pin input is low
	GPIO_IN_PIN5_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN5_High = 0x1
	// Position of PIN6 field.
	GPIO_IN_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_IN_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_IN_PIN6 = 0x40
	// Pin input is low
	GPIO_IN_PIN6_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN6_High = 0x1
	// Position of PIN7 field.
	GPIO_IN_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_IN_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_IN_PIN7 = 0x80
	// Pin input is low
	GPIO_IN_PIN7_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN7_High = 0x1
	// Position of PIN8 field.
	GPIO_IN_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_IN_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_IN_PIN8 = 0x100
	// Pin input is low
	GPIO_IN_PIN8_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN8_High = 0x1
	// Position of PIN9 field.
	GPIO_IN_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_IN_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_IN_PIN9 = 0x200
	// Pin input is low
	GPIO_IN_PIN9_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN9_High = 0x1
	// Position of PIN10 field.
	GPIO_IN_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_IN_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_IN_PIN10 = 0x400
	// Pin input is low
	GPIO_IN_PIN10_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN10_High = 0x1
	// Position of PIN11 field.
	GPIO_IN_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_IN_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_IN_PIN11 = 0x800
	// Pin input is low
	GPIO_IN_PIN11_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN11_High = 0x1
	// Position of PIN12 field.
	GPIO_IN_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_IN_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_IN_PIN12 = 0x1000
	// Pin input is low
	GPIO_IN_PIN12_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN12_High = 0x1
	// Position of PIN13 field.
	GPIO_IN_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_IN_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_IN_PIN13 = 0x2000
	// Pin input is low
	GPIO_IN_PIN13_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN13_High = 0x1
	// Position of PIN14 field.
	GPIO_IN_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_IN_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_IN_PIN14 = 0x4000
	// Pin input is low
	GPIO_IN_PIN14_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN14_High = 0x1
	// Position of PIN15 field.
	GPIO_IN_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_IN_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_IN_PIN15 = 0x8000
	// Pin input is low
	GPIO_IN_PIN15_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN15_High = 0x1
	// Position of PIN16 field.
	GPIO_IN_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_IN_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_IN_PIN16 = 0x10000
	// Pin input is low
	GPIO_IN_PIN16_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN16_High = 0x1
	// Position of PIN17 field.
	GPIO_IN_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_IN_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_IN_PIN17 = 0x20000
	// Pin input is low
	GPIO_IN_PIN17_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN17_High = 0x1
	// Position of PIN18 field.
	GPIO_IN_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_IN_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_IN_PIN18 = 0x40000
	// Pin input is low
	GPIO_IN_PIN18_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN18_High = 0x1
	// Position of PIN19 field.
	GPIO_IN_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_IN_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_IN_PIN19 = 0x80000
	// Pin input is low
	GPIO_IN_PIN19_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN19_High = 0x1
	// Position of PIN20 field.
	GPIO_IN_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_IN_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_IN_PIN20 = 0x100000
	// Pin input is low
	GPIO_IN_PIN20_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN20_High = 0x1
	// Position of PIN21 field.
	GPIO_IN_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_IN_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_IN_PIN21 = 0x200000
	// Pin input is low
	GPIO_IN_PIN21_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN21_High = 0x1
	// Position of PIN22 field.
	GPIO_IN_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_IN_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_IN_PIN22 = 0x400000
	// Pin input is low
	GPIO_IN_PIN22_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN22_High = 0x1
	// Position of PIN23 field.
	GPIO_IN_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_IN_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_IN_PIN23 = 0x800000
	// Pin input is low
	GPIO_IN_PIN23_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN23_High = 0x1
	// Position of PIN24 field.
	GPIO_IN_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_IN_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_IN_PIN24 = 0x1000000
	// Pin input is low
	GPIO_IN_PIN24_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN24_High = 0x1
	// Position of PIN25 field.
	GPIO_IN_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_IN_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_IN_PIN25 = 0x2000000
	// Pin input is low
	GPIO_IN_PIN25_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN25_High = 0x1
	// Position of PIN26 field.
	GPIO_IN_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_IN_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_IN_PIN26 = 0x4000000
	// Pin input is low
	GPIO_IN_PIN26_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN26_High = 0x1
	// Position of PIN27 field.
	GPIO_IN_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_IN_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_IN_PIN27 = 0x8000000
	// Pin input is low
	GPIO_IN_PIN27_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN27_High = 0x1
	// Position of PIN28 field.
	GPIO_IN_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_IN_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_IN_PIN28 = 0x10000000
	// Pin input is low
	GPIO_IN_PIN28_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN28_High = 0x1
	// Position of PIN29 field.
	GPIO_IN_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_IN_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_IN_PIN29 = 0x20000000
	// Pin input is low
	GPIO_IN_PIN29_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN29_High = 0x1
	// Position of PIN30 field.
	GPIO_IN_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_IN_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_IN_PIN30 = 0x40000000
	// Pin input is low
	GPIO_IN_PIN30_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN30_High = 0x1
	// Position of PIN31 field.
	GPIO_IN_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_IN_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_IN_PIN31 = 0x80000000
	// Pin input is low
	GPIO_IN_PIN31_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN31_High = 0x1

	// DIR: Direction of GPIO pins
	// Position of PIN0 field.
	GPIO_DIR_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_DIR_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_DIR_PIN0 = 0x1
	// Pin set as input
	GPIO_DIR_PIN0_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN0_Output = 0x1
	// Position of PIN1 field.
	GPIO_DIR_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_DIR_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_DIR_PIN1 = 0x2
	// Pin set as input
	GPIO_DIR_PIN1_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN1_Output = 0x1
	// Position of PIN2 field.
	GPIO_DIR_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_DIR_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_DIR_PIN2 = 0x4
	// Pin set as input
	GPIO_DIR_PIN2_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN2_Output = 0x1
	// Position of PIN3 field.
	GPIO_DIR_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_DIR_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_DIR_PIN3 = 0x8
	// Pin set as input
	GPIO_DIR_PIN3_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN3_Output = 0x1
	// Position of PIN4 field.
	GPIO_DIR_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_DIR_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_DIR_PIN4 = 0x10
	// Pin set as input
	GPIO_DIR_PIN4_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN4_Output = 0x1
	// Position of PIN5 field.
	GPIO_DIR_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_DIR_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_DIR_PIN5 = 0x20
	// Pin set as input
	GPIO_DIR_PIN5_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN5_Output = 0x1
	// Position of PIN6 field.
	GPIO_DIR_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_DIR_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_DIR_PIN6 = 0x40
	// Pin set as input
	GPIO_DIR_PIN6_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN6_Output = 0x1
	// Position of PIN7 field.
	GPIO_DIR_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_DIR_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_DIR_PIN7 = 0x80
	// Pin set as input
	GPIO_DIR_PIN7_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN7_Output = 0x1
	// Position of PIN8 field.
	GPIO_DIR_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_DIR_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_DIR_PIN8 = 0x100
	// Pin set as input
	GPIO_DIR_PIN8_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN8_Output = 0x1
	// Position of PIN9 field.
	GPIO_DIR_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_DIR_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_DIR_PIN9 = 0x200
	// Pin set as input
	GPIO_DIR_PIN9_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN9_Output = 0x1
	// Position of PIN10 field.
	GPIO_DIR_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_DIR_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_DIR_PIN10 = 0x400
	// Pin set as input
	GPIO_DIR_PIN10_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN10_Output = 0x1
	// Position of PIN11 field.
	GPIO_DIR_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_DIR_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_DIR_PIN11 = 0x800
	// Pin set as input
	GPIO_DIR_PIN11_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN11_Output = 0x1
	// Position of PIN12 field.
	GPIO_DIR_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_DIR_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_DIR_PIN12 = 0x1000
	// Pin set as input
	GPIO_DIR_PIN12_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN12_Output = 0x1
	// Position of PIN13 field.
	GPIO_DIR_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_DIR_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_DIR_PIN13 = 0x2000
	// Pin set as input
	GPIO_DIR_PIN13_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN13_Output = 0x1
	// Position of PIN14 field.
	GPIO_DIR_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_DIR_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_DIR_PIN14 = 0x4000
	// Pin set as input
	GPIO_DIR_PIN14_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN14_Output = 0x1
	// Position of PIN15 field.
	GPIO_DIR_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_DIR_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_DIR_PIN15 = 0x8000
	// Pin set as input
	GPIO_DIR_PIN15_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN15_Output = 0x1
	// Position of PIN16 field.
	GPIO_DIR_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_DIR_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_DIR_PIN16 = 0x10000
	// Pin set as input
	GPIO_DIR_PIN16_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN16_Output = 0x1
	// Position of PIN17 field.
	GPIO_DIR_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_DIR_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_DIR_PIN17 = 0x20000
	// Pin set as input
	GPIO_DIR_PIN17_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN17_Output = 0x1
	// Position of PIN18 field.
	GPIO_DIR_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_DIR_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_DIR_PIN18 = 0x40000
	// Pin set as input
	GPIO_DIR_PIN18_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN18_Output = 0x1
	// Position of PIN19 field.
	GPIO_DIR_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_DIR_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_DIR_PIN19 = 0x80000
	// Pin set as input
	GPIO_DIR_PIN19_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN19_Output = 0x1
	// Position of PIN20 field.
	GPIO_DIR_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_DIR_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_DIR_PIN20 = 0x100000
	// Pin set as input
	GPIO_DIR_PIN20_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN20_Output = 0x1
	// Position of PIN21 field.
	GPIO_DIR_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_DIR_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_DIR_PIN21 = 0x200000
	// Pin set as input
	GPIO_DIR_PIN21_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN21_Output = 0x1
	// Position of PIN22 field.
	GPIO_DIR_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_DIR_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_DIR_PIN22 = 0x400000
	// Pin set as input
	GPIO_DIR_PIN22_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN22_Output = 0x1
	// Position of PIN23 field.
	GPIO_DIR_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_DIR_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_DIR_PIN23 = 0x800000
	// Pin set as input
	GPIO_DIR_PIN23_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN23_Output = 0x1
	// Position of PIN24 field.
	GPIO_DIR_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_DIR_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_DIR_PIN24 = 0x1000000
	// Pin set as input
	GPIO_DIR_PIN24_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN24_Output = 0x1
	// Position of PIN25 field.
	GPIO_DIR_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_DIR_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_DIR_PIN25 = 0x2000000
	// Pin set as input
	GPIO_DIR_PIN25_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN25_Output = 0x1
	// Position of PIN26 field.
	GPIO_DIR_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_DIR_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_DIR_PIN26 = 0x4000000
	// Pin set as input
	GPIO_DIR_PIN26_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN26_Output = 0x1
	// Position of PIN27 field.
	GPIO_DIR_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_DIR_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_DIR_PIN27 = 0x8000000
	// Pin set as input
	GPIO_DIR_PIN27_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN27_Output = 0x1
	// Position of PIN28 field.
	GPIO_DIR_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_DIR_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_DIR_PIN28 = 0x10000000
	// Pin set as input
	GPIO_DIR_PIN28_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN28_Output = 0x1
	// Position of PIN29 field.
	GPIO_DIR_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_DIR_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_DIR_PIN29 = 0x20000000
	// Pin set as input
	GPIO_DIR_PIN29_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN29_Output = 0x1
	// Position of PIN30 field.
	GPIO_DIR_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_DIR_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_DIR_PIN30 = 0x40000000
	// Pin set as input
	GPIO_DIR_PIN30_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN30_Output = 0x1
	// Position of PIN31 field.
	GPIO_DIR_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_DIR_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_DIR_PIN31 = 0x80000000
	// Pin set as input
	GPIO_DIR_PIN31_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN31_Output = 0x1

	// DIRSET: DIR set register
	// Position of PIN0 field.
	GPIO_DIRSET_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_DIRSET_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_DIRSET_PIN0 = 0x1
	// Read: pin set as input
	GPIO_DIRSET_PIN0_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN0_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN0_Set = 0x1
	// Position of PIN1 field.
	GPIO_DIRSET_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_DIRSET_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_DIRSET_PIN1 = 0x2
	// Read: pin set as input
	GPIO_DIRSET_PIN1_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN1_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN1_Set = 0x1
	// Position of PIN2 field.
	GPIO_DIRSET_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_DIRSET_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_DIRSET_PIN2 = 0x4
	// Read: pin set as input
	GPIO_DIRSET_PIN2_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN2_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN2_Set = 0x1
	// Position of PIN3 field.
	GPIO_DIRSET_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_DIRSET_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_DIRSET_PIN3 = 0x8
	// Read: pin set as input
	GPIO_DIRSET_PIN3_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN3_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN3_Set = 0x1
	// Position of PIN4 field.
	GPIO_DIRSET_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_DIRSET_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_DIRSET_PIN4 = 0x10
	// Read: pin set as input
	GPIO_DIRSET_PIN4_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN4_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN4_Set = 0x1
	// Position of PIN5 field.
	GPIO_DIRSET_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_DIRSET_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_DIRSET_PIN5 = 0x20
	// Read: pin set as input
	GPIO_DIRSET_PIN5_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN5_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN5_Set = 0x1
	// Position of PIN6 field.
	GPIO_DIRSET_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_DIRSET_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_DIRSET_PIN6 = 0x40
	// Read: pin set as input
	GPIO_DIRSET_PIN6_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN6_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN6_Set = 0x1
	// Position of PIN7 field.
	GPIO_DIRSET_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_DIRSET_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_DIRSET_PIN7 = 0x80
	// Read: pin set as input
	GPIO_DIRSET_PIN7_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN7_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN7_Set = 0x1
	// Position of PIN8 field.
	GPIO_DIRSET_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_DIRSET_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_DIRSET_PIN8 = 0x100
	// Read: pin set as input
	GPIO_DIRSET_PIN8_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN8_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN8_Set = 0x1
	// Position of PIN9 field.
	GPIO_DIRSET_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_DIRSET_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_DIRSET_PIN9 = 0x200
	// Read: pin set as input
	GPIO_DIRSET_PIN9_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN9_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN9_Set = 0x1
	// Position of PIN10 field.
	GPIO_DIRSET_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_DIRSET_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_DIRSET_PIN10 = 0x400
	// Read: pin set as input
	GPIO_DIRSET_PIN10_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN10_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN10_Set = 0x1
	// Position of PIN11 field.
	GPIO_DIRSET_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_DIRSET_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_DIRSET_PIN11 = 0x800
	// Read: pin set as input
	GPIO_DIRSET_PIN11_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN11_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN11_Set = 0x1
	// Position of PIN12 field.
	GPIO_DIRSET_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_DIRSET_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_DIRSET_PIN12 = 0x1000
	// Read: pin set as input
	GPIO_DIRSET_PIN12_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN12_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN12_Set = 0x1
	// Position of PIN13 field.
	GPIO_DIRSET_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_DIRSET_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_DIRSET_PIN13 = 0x2000
	// Read: pin set as input
	GPIO_DIRSET_PIN13_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN13_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN13_Set = 0x1
	// Position of PIN14 field.
	GPIO_DIRSET_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_DIRSET_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_DIRSET_PIN14 = 0x4000
	// Read: pin set as input
	GPIO_DIRSET_PIN14_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN14_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN14_Set = 0x1
	// Position of PIN15 field.
	GPIO_DIRSET_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_DIRSET_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_DIRSET_PIN15 = 0x8000
	// Read: pin set as input
	GPIO_DIRSET_PIN15_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN15_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN15_Set = 0x1
	// Position of PIN16 field.
	GPIO_DIRSET_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_DIRSET_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_DIRSET_PIN16 = 0x10000
	// Read: pin set as input
	GPIO_DIRSET_PIN16_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN16_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN16_Set = 0x1
	// Position of PIN17 field.
	GPIO_DIRSET_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_DIRSET_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_DIRSET_PIN17 = 0x20000
	// Read: pin set as input
	GPIO_DIRSET_PIN17_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN17_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN17_Set = 0x1
	// Position of PIN18 field.
	GPIO_DIRSET_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_DIRSET_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_DIRSET_PIN18 = 0x40000
	// Read: pin set as input
	GPIO_DIRSET_PIN18_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN18_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN18_Set = 0x1
	// Position of PIN19 field.
	GPIO_DIRSET_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_DIRSET_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_DIRSET_PIN19 = 0x80000
	// Read: pin set as input
	GPIO_DIRSET_PIN19_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN19_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN19_Set = 0x1
	// Position of PIN20 field.
	GPIO_DIRSET_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_DIRSET_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_DIRSET_PIN20 = 0x100000
	// Read: pin set as input
	GPIO_DIRSET_PIN20_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN20_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN20_Set = 0x1
	// Position of PIN21 field.
	GPIO_DIRSET_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_DIRSET_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_DIRSET_PIN21 = 0x200000
	// Read: pin set as input
	GPIO_DIRSET_PIN21_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN21_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN21_Set = 0x1
	// Position of PIN22 field.
	GPIO_DIRSET_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_DIRSET_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_DIRSET_PIN22 = 0x400000
	// Read: pin set as input
	GPIO_DIRSET_PIN22_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN22_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN22_Set = 0x1
	// Position of PIN23 field.
	GPIO_DIRSET_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_DIRSET_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_DIRSET_PIN23 = 0x800000
	// Read: pin set as input
	GPIO_DIRSET_PIN23_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN23_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN23_Set = 0x1
	// Position of PIN24 field.
	GPIO_DIRSET_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_DIRSET_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_DIRSET_PIN24 = 0x1000000
	// Read: pin set as input
	GPIO_DIRSET_PIN24_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN24_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN24_Set = 0x1
	// Position of PIN25 field.
	GPIO_DIRSET_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_DIRSET_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_DIRSET_PIN25 = 0x2000000
	// Read: pin set as input
	GPIO_DIRSET_PIN25_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN25_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN25_Set = 0x1
	// Position of PIN26 field.
	GPIO_DIRSET_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_DIRSET_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_DIRSET_PIN26 = 0x4000000
	// Read: pin set as input
	GPIO_DIRSET_PIN26_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN26_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN26_Set = 0x1
	// Position of PIN27 field.
	GPIO_DIRSET_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_DIRSET_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_DIRSET_PIN27 = 0x8000000
	// Read: pin set as input
	GPIO_DIRSET_PIN27_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN27_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN27_Set = 0x1
	// Position of PIN28 field.
	GPIO_DIRSET_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_DIRSET_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_DIRSET_PIN28 = 0x10000000
	// Read: pin set as input
	GPIO_DIRSET_PIN28_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN28_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN28_Set = 0x1
	// Position of PIN29 field.
	GPIO_DIRSET_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_DIRSET_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_DIRSET_PIN29 = 0x20000000
	// Read: pin set as input
	GPIO_DIRSET_PIN29_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN29_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN29_Set = 0x1
	// Position of PIN30 field.
	GPIO_DIRSET_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_DIRSET_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_DIRSET_PIN30 = 0x40000000
	// Read: pin set as input
	GPIO_DIRSET_PIN30_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN30_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN30_Set = 0x1
	// Position of PIN31 field.
	GPIO_DIRSET_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_DIRSET_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_DIRSET_PIN31 = 0x80000000
	// Read: pin set as input
	GPIO_DIRSET_PIN31_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN31_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN31_Set = 0x1

	// DIRCLR: DIR clear register
	// Position of PIN0 field.
	GPIO_DIRCLR_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_DIRCLR_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_DIRCLR_PIN0 = 0x1
	// Read: pin set as input
	GPIO_DIRCLR_PIN0_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN0_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN0_Clear = 0x1
	// Position of PIN1 field.
	GPIO_DIRCLR_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_DIRCLR_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_DIRCLR_PIN1 = 0x2
	// Read: pin set as input
	GPIO_DIRCLR_PIN1_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN1_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN1_Clear = 0x1
	// Position of PIN2 field.
	GPIO_DIRCLR_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_DIRCLR_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_DIRCLR_PIN2 = 0x4
	// Read: pin set as input
	GPIO_DIRCLR_PIN2_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN2_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN2_Clear = 0x1
	// Position of PIN3 field.
	GPIO_DIRCLR_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_DIRCLR_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_DIRCLR_PIN3 = 0x8
	// Read: pin set as input
	GPIO_DIRCLR_PIN3_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN3_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN3_Clear = 0x1
	// Position of PIN4 field.
	GPIO_DIRCLR_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_DIRCLR_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_DIRCLR_PIN4 = 0x10
	// Read: pin set as input
	GPIO_DIRCLR_PIN4_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN4_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN4_Clear = 0x1
	// Position of PIN5 field.
	GPIO_DIRCLR_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_DIRCLR_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_DIRCLR_PIN5 = 0x20
	// Read: pin set as input
	GPIO_DIRCLR_PIN5_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN5_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN5_Clear = 0x1
	// Position of PIN6 field.
	GPIO_DIRCLR_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_DIRCLR_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_DIRCLR_PIN6 = 0x40
	// Read: pin set as input
	GPIO_DIRCLR_PIN6_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN6_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN6_Clear = 0x1
	// Position of PIN7 field.
	GPIO_DIRCLR_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_DIRCLR_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_DIRCLR_PIN7 = 0x80
	// Read: pin set as input
	GPIO_DIRCLR_PIN7_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN7_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN7_Clear = 0x1
	// Position of PIN8 field.
	GPIO_DIRCLR_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_DIRCLR_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_DIRCLR_PIN8 = 0x100
	// Read: pin set as input
	GPIO_DIRCLR_PIN8_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN8_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN8_Clear = 0x1
	// Position of PIN9 field.
	GPIO_DIRCLR_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_DIRCLR_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_DIRCLR_PIN9 = 0x200
	// Read: pin set as input
	GPIO_DIRCLR_PIN9_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN9_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN9_Clear = 0x1
	// Position of PIN10 field.
	GPIO_DIRCLR_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_DIRCLR_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_DIRCLR_PIN10 = 0x400
	// Read: pin set as input
	GPIO_DIRCLR_PIN10_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN10_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN10_Clear = 0x1
	// Position of PIN11 field.
	GPIO_DIRCLR_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_DIRCLR_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_DIRCLR_PIN11 = 0x800
	// Read: pin set as input
	GPIO_DIRCLR_PIN11_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN11_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN11_Clear = 0x1
	// Position of PIN12 field.
	GPIO_DIRCLR_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_DIRCLR_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_DIRCLR_PIN12 = 0x1000
	// Read: pin set as input
	GPIO_DIRCLR_PIN12_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN12_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN12_Clear = 0x1
	// Position of PIN13 field.
	GPIO_DIRCLR_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_DIRCLR_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_DIRCLR_PIN13 = 0x2000
	// Read: pin set as input
	GPIO_DIRCLR_PIN13_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN13_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN13_Clear = 0x1
	// Position of PIN14 field.
	GPIO_DIRCLR_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_DIRCLR_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_DIRCLR_PIN14 = 0x4000
	// Read: pin set as input
	GPIO_DIRCLR_PIN14_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN14_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN14_Clear = 0x1
	// Position of PIN15 field.
	GPIO_DIRCLR_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_DIRCLR_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_DIRCLR_PIN15 = 0x8000
	// Read: pin set as input
	GPIO_DIRCLR_PIN15_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN15_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN15_Clear = 0x1
	// Position of PIN16 field.
	GPIO_DIRCLR_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_DIRCLR_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_DIRCLR_PIN16 = 0x10000
	// Read: pin set as input
	GPIO_DIRCLR_PIN16_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN16_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN16_Clear = 0x1
	// Position of PIN17 field.
	GPIO_DIRCLR_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_DIRCLR_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_DIRCLR_PIN17 = 0x20000
	// Read: pin set as input
	GPIO_DIRCLR_PIN17_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN17_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN17_Clear = 0x1
	// Position of PIN18 field.
	GPIO_DIRCLR_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_DIRCLR_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_DIRCLR_PIN18 = 0x40000
	// Read: pin set as input
	GPIO_DIRCLR_PIN18_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN18_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN18_Clear = 0x1
	// Position of PIN19 field.
	GPIO_DIRCLR_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_DIRCLR_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_DIRCLR_PIN19 = 0x80000
	// Read: pin set as input
	GPIO_DIRCLR_PIN19_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN19_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN19_Clear = 0x1
	// Position of PIN20 field.
	GPIO_DIRCLR_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_DIRCLR_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_DIRCLR_PIN20 = 0x100000
	// Read: pin set as input
	GPIO_DIRCLR_PIN20_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN20_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN20_Clear = 0x1
	// Position of PIN21 field.
	GPIO_DIRCLR_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_DIRCLR_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_DIRCLR_PIN21 = 0x200000
	// Read: pin set as input
	GPIO_DIRCLR_PIN21_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN21_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN21_Clear = 0x1
	// Position of PIN22 field.
	GPIO_DIRCLR_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_DIRCLR_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_DIRCLR_PIN22 = 0x400000
	// Read: pin set as input
	GPIO_DIRCLR_PIN22_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN22_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN22_Clear = 0x1
	// Position of PIN23 field.
	GPIO_DIRCLR_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_DIRCLR_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_DIRCLR_PIN23 = 0x800000
	// Read: pin set as input
	GPIO_DIRCLR_PIN23_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN23_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN23_Clear = 0x1
	// Position of PIN24 field.
	GPIO_DIRCLR_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_DIRCLR_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_DIRCLR_PIN24 = 0x1000000
	// Read: pin set as input
	GPIO_DIRCLR_PIN24_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN24_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN24_Clear = 0x1
	// Position of PIN25 field.
	GPIO_DIRCLR_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_DIRCLR_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_DIRCLR_PIN25 = 0x2000000
	// Read: pin set as input
	GPIO_DIRCLR_PIN25_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN25_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN25_Clear = 0x1
	// Position of PIN26 field.
	GPIO_DIRCLR_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_DIRCLR_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_DIRCLR_PIN26 = 0x4000000
	// Read: pin set as input
	GPIO_DIRCLR_PIN26_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN26_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN26_Clear = 0x1
	// Position of PIN27 field.
	GPIO_DIRCLR_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_DIRCLR_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_DIRCLR_PIN27 = 0x8000000
	// Read: pin set as input
	GPIO_DIRCLR_PIN27_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN27_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN27_Clear = 0x1
	// Position of PIN28 field.
	GPIO_DIRCLR_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_DIRCLR_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_DIRCLR_PIN28 = 0x10000000
	// Read: pin set as input
	GPIO_DIRCLR_PIN28_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN28_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN28_Clear = 0x1
	// Position of PIN29 field.
	GPIO_DIRCLR_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_DIRCLR_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_DIRCLR_PIN29 = 0x20000000
	// Read: pin set as input
	GPIO_DIRCLR_PIN29_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN29_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN29_Clear = 0x1
	// Position of PIN30 field.
	GPIO_DIRCLR_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_DIRCLR_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_DIRCLR_PIN30 = 0x40000000
	// Read: pin set as input
	GPIO_DIRCLR_PIN30_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN30_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN30_Clear = 0x1
	// Position of PIN31 field.
	GPIO_DIRCLR_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_DIRCLR_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_DIRCLR_PIN31 = 0x80000000
	// Read: pin set as input
	GPIO_DIRCLR_PIN31_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN31_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN31_Clear = 0x1

	// LATCH: Latch register indicating what GPIO pins that have met the criteria set in the PIN_CNF[n].SENSE registers
	// Position of PIN0 field.
	GPIO_LATCH_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_LATCH_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_LATCH_PIN0 = 0x1
	// Criteria has not been met
	GPIO_LATCH_PIN0_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN0_Latched = 0x1
	// Position of PIN1 field.
	GPIO_LATCH_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_LATCH_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_LATCH_PIN1 = 0x2
	// Criteria has not been met
	GPIO_LATCH_PIN1_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN1_Latched = 0x1
	// Position of PIN2 field.
	GPIO_LATCH_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_LATCH_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_LATCH_PIN2 = 0x4
	// Criteria has not been met
	GPIO_LATCH_PIN2_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN2_Latched = 0x1
	// Position of PIN3 field.
	GPIO_LATCH_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_LATCH_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_LATCH_PIN3 = 0x8
	// Criteria has not been met
	GPIO_LATCH_PIN3_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN3_Latched = 0x1
	// Position of PIN4 field.
	GPIO_LATCH_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_LATCH_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_LATCH_PIN4 = 0x10
	// Criteria has not been met
	GPIO_LATCH_PIN4_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN4_Latched = 0x1
	// Position of PIN5 field.
	GPIO_LATCH_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_LATCH_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_LATCH_PIN5 = 0x20
	// Criteria has not been met
	GPIO_LATCH_PIN5_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN5_Latched = 0x1
	// Position of PIN6 field.
	GPIO_LATCH_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_LATCH_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_LATCH_PIN6 = 0x40
	// Criteria has not been met
	GPIO_LATCH_PIN6_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN6_Latched = 0x1
	// Position of PIN7 field.
	GPIO_LATCH_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_LATCH_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_LATCH_PIN7 = 0x80
	// Criteria has not been met
	GPIO_LATCH_PIN7_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN7_Latched = 0x1
	// Position of PIN8 field.
	GPIO_LATCH_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_LATCH_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_LATCH_PIN8 = 0x100
	// Criteria has not been met
	GPIO_LATCH_PIN8_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN8_Latched = 0x1
	// Position of PIN9 field.
	GPIO_LATCH_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_LATCH_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_LATCH_PIN9 = 0x200
	// Criteria has not been met
	GPIO_LATCH_PIN9_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN9_Latched = 0x1
	// Position of PIN10 field.
	GPIO_LATCH_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_LATCH_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_LATCH_PIN10 = 0x400
	// Criteria has not been met
	GPIO_LATCH_PIN10_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN10_Latched = 0x1
	// Position of PIN11 field.
	GPIO_LATCH_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_LATCH_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_LATCH_PIN11 = 0x800
	// Criteria has not been met
	GPIO_LATCH_PIN11_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN11_Latched = 0x1
	// Position of PIN12 field.
	GPIO_LATCH_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_LATCH_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_LATCH_PIN12 = 0x1000
	// Criteria has not been met
	GPIO_LATCH_PIN12_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN12_Latched = 0x1
	// Position of PIN13 field.
	GPIO_LATCH_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_LATCH_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_LATCH_PIN13 = 0x2000
	// Criteria has not been met
	GPIO_LATCH_PIN13_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN13_Latched = 0x1
	// Position of PIN14 field.
	GPIO_LATCH_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_LATCH_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_LATCH_PIN14 = 0x4000
	// Criteria has not been met
	GPIO_LATCH_PIN14_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN14_Latched = 0x1
	// Position of PIN15 field.
	GPIO_LATCH_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_LATCH_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_LATCH_PIN15 = 0x8000
	// Criteria has not been met
	GPIO_LATCH_PIN15_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN15_Latched = 0x1
	// Position of PIN16 field.
	GPIO_LATCH_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_LATCH_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_LATCH_PIN16 = 0x10000
	// Criteria has not been met
	GPIO_LATCH_PIN16_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN16_Latched = 0x1
	// Position of PIN17 field.
	GPIO_LATCH_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_LATCH_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_LATCH_PIN17 = 0x20000
	// Criteria has not been met
	GPIO_LATCH_PIN17_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN17_Latched = 0x1
	// Position of PIN18 field.
	GPIO_LATCH_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_LATCH_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_LATCH_PIN18 = 0x40000
	// Criteria has not been met
	GPIO_LATCH_PIN18_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN18_Latched = 0x1
	// Position of PIN19 field.
	GPIO_LATCH_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_LATCH_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_LATCH_PIN19 = 0x80000
	// Criteria has not been met
	GPIO_LATCH_PIN19_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN19_Latched = 0x1
	// Position of PIN20 field.
	GPIO_LATCH_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_LATCH_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_LATCH_PIN20 = 0x100000
	// Criteria has not been met
	GPIO_LATCH_PIN20_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN20_Latched = 0x1
	// Position of PIN21 field.
	GPIO_LATCH_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_LATCH_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_LATCH_PIN21 = 0x200000
	// Criteria has not been met
	GPIO_LATCH_PIN21_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN21_Latched = 0x1
	// Position of PIN22 field.
	GPIO_LATCH_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_LATCH_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_LATCH_PIN22 = 0x400000
	// Criteria has not been met
	GPIO_LATCH_PIN22_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN22_Latched = 0x1
	// Position of PIN23 field.
	GPIO_LATCH_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_LATCH_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_LATCH_PIN23 = 0x800000
	// Criteria has not been met
	GPIO_LATCH_PIN23_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN23_Latched = 0x1
	// Position of PIN24 field.
	GPIO_LATCH_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_LATCH_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_LATCH_PIN24 = 0x1000000
	// Criteria has not been met
	GPIO_LATCH_PIN24_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN24_Latched = 0x1
	// Position of PIN25 field.
	GPIO_LATCH_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_LATCH_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_LATCH_PIN25 = 0x2000000
	// Criteria has not been met
	GPIO_LATCH_PIN25_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN25_Latched = 0x1
	// Position of PIN26 field.
	GPIO_LATCH_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_LATCH_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_LATCH_PIN26 = 0x4000000
	// Criteria has not been met
	GPIO_LATCH_PIN26_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN26_Latched = 0x1
	// Position of PIN27 field.
	GPIO_LATCH_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_LATCH_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_LATCH_PIN27 = 0x8000000
	// Criteria has not been met
	GPIO_LATCH_PIN27_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN27_Latched = 0x1
	// Position of PIN28 field.
	GPIO_LATCH_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_LATCH_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_LATCH_PIN28 = 0x10000000
	// Criteria has not been met
	GPIO_LATCH_PIN28_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN28_Latched = 0x1
	// Position of PIN29 field.
	GPIO_LATCH_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_LATCH_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_LATCH_PIN29 = 0x20000000
	// Criteria has not been met
	GPIO_LATCH_PIN29_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN29_Latched = 0x1
	// Position of PIN30 field.
	GPIO_LATCH_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_LATCH_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_LATCH_PIN30 = 0x40000000
	// Criteria has not been met
	GPIO_LATCH_PIN30_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN30_Latched = 0x1
	// Position of PIN31 field.
	GPIO_LATCH_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_LATCH_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_LATCH_PIN31 = 0x80000000
	// Criteria has not been met
	GPIO_LATCH_PIN31_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN31_Latched = 0x1

	// DETECTMODE: Select between default DETECT signal behavior and LDETECT mode (For non-secure pin only)
	// Position of DETECTMODE field.
	GPIO_DETECTMODE_DETECTMODE_Pos = 0x0
	// Bit mask of DETECTMODE field.
	GPIO_DETECTMODE_DETECTMODE_Msk = 0x1
	// Bit DETECTMODE.
	GPIO_DETECTMODE_DETECTMODE = 0x1
	// DETECT directly connected to PIN DETECT signals
	GPIO_DETECTMODE_DETECTMODE_Default = 0x0
	// Use the latched LDETECT behavior
	GPIO_DETECTMODE_DETECTMODE_LDETECT = 0x1

	// DETECTMODE_SEC: Select between default DETECT signal behavior and LDETECT mode (For secure pin only)
	// Position of DETECTMODE field.
	GPIO_DETECTMODE_SEC_DETECTMODE_Pos = 0x0
	// Bit mask of DETECTMODE field.
	GPIO_DETECTMODE_SEC_DETECTMODE_Msk = 0x1
	// Bit DETECTMODE.
	GPIO_DETECTMODE_SEC_DETECTMODE = 0x1
	// DETECT directly connected to PIN DETECT signals
	GPIO_DETECTMODE_SEC_DETECTMODE_Default = 0x0
	// Use the latched LDETECT behavior
	GPIO_DETECTMODE_SEC_DETECTMODE_LDETECT = 0x1

	// PIN_CNF: Description collection: Configuration of GPIO pins
	// Position of DIR field.
	GPIO_PIN_CNF_DIR_Pos = 0x0
	// Bit mask of DIR field.
	GPIO_PIN_CNF_DIR_Msk = 0x1
	// Bit DIR.
	GPIO_PIN_CNF_DIR = 0x1
	// Configure pin as an input pin
	GPIO_PIN_CNF_DIR_Input = 0x0
	// Configure pin as an output pin
	GPIO_PIN_CNF_DIR_Output = 0x1
	// Position of INPUT field.
	GPIO_PIN_CNF_INPUT_Pos = 0x1
	// Bit mask of INPUT field.
	GPIO_PIN_CNF_INPUT_Msk = 0x2
	// Bit INPUT.
	GPIO_PIN_CNF_INPUT = 0x2
	// Connect input buffer
	GPIO_PIN_CNF_INPUT_Connect = 0x0
	// Disconnect input buffer
	GPIO_PIN_CNF_INPUT_Disconnect = 0x1
	// Position of PULL field.
	GPIO_PIN_CNF_PULL_Pos = 0x2
	// Bit mask of PULL field.
	GPIO_PIN_CNF_PULL_Msk = 0xc
	// No pull
	GPIO_PIN_CNF_PULL_Disabled = 0x0
	// Pull down on pin
	GPIO_PIN_CNF_PULL_Pulldown = 0x1
	// Pull up on pin
	GPIO_PIN_CNF_PULL_Pullup = 0x3
	// Position of DRIVE field.
	GPIO_PIN_CNF_DRIVE_Pos = 0x8
	// Bit mask of DRIVE field.
	GPIO_PIN_CNF_DRIVE_Msk = 0xf00
	// Standard '0', standard '1'
	GPIO_PIN_CNF_DRIVE_S0S1 = 0x0
	// High drive '0', standard '1'
	GPIO_PIN_CNF_DRIVE_H0S1 = 0x1
	// Standard '0', high drive '1'
	GPIO_PIN_CNF_DRIVE_S0H1 = 0x2
	// High drive '0', high 'drive '1''
	GPIO_PIN_CNF_DRIVE_H0H1 = 0x3
	// Disconnect '0', standard '1' (normally used for wired-or connections)
	GPIO_PIN_CNF_DRIVE_D0S1 = 0x4
	// Disconnect '0', high drive '1' (normally used for wired-or connections)
	GPIO_PIN_CNF_DRIVE_D0H1 = 0x5
	// Standard '0', disconnect '1' (normally used for wired-and connections)
	GPIO_PIN_CNF_DRIVE_S0D1 = 0x6
	// High drive '0', disconnect '1' (normally used for wired-and connections)
	GPIO_PIN_CNF_DRIVE_H0D1 = 0x7
	// Extra high drive '0', extra high drive '1'
	GPIO_PIN_CNF_DRIVE_E0E1 = 0xb
	// Position of SENSE field.
	GPIO_PIN_CNF_SENSE_Pos = 0x10
	// Bit mask of SENSE field.
	GPIO_PIN_CNF_SENSE_Msk = 0x30000
	// Disabled
	GPIO_PIN_CNF_SENSE_Disabled = 0x0
	// Sense for high level
	GPIO_PIN_CNF_SENSE_High = 0x2
	// Sense for low level
	GPIO_PIN_CNF_SENSE_Low = 0x3
	// Position of MCUSEL field.
	GPIO_PIN_CNF_MCUSEL_Pos = 0x1c
	// Bit mask of MCUSEL field.
	GPIO_PIN_CNF_MCUSEL_Msk = 0x70000000
	// Application MCU
	GPIO_PIN_CNF_MCUSEL_AppMCU = 0x0
	// Network MCU
	GPIO_PIN_CNF_MCUSEL_NetworkMCU = 0x1
	// Peripheral with dedicated pins
	GPIO_PIN_CNF_MCUSEL_Peripheral = 0x3
	// Trace and Debug Subsystem
	GPIO_PIN_CNF_MCUSEL_TND = 0x7
)
