/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http2;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.CompletionHandler;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.WebConnection;
import org.apache.coyote.Adapter;
import org.apache.coyote.ProtocolException;
import org.apache.coyote.Request;
import org.apache.coyote.http2.AbstractNonZeroStream;
import org.apache.coyote.http2.ByteUtil;
import org.apache.coyote.http2.FrameType;
import org.apache.coyote.http2.Http2AsyncParser;
import org.apache.coyote.http2.Http2Parser;
import org.apache.coyote.http2.Http2Protocol;
import org.apache.coyote.http2.Http2UpgradeHandler;
import org.apache.coyote.http2.SendfileData;
import org.apache.coyote.http2.Stream;
import org.apache.coyote.http2.StreamException;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.net.SendfileState;
import org.apache.tomcat.util.net.SocketWrapperBase;

public class Http2AsyncUpgradeHandler
extends Http2UpgradeHandler {
    private static final ByteBuffer[] BYTEBUFFER_ARRAY = new ByteBuffer[0];
    private final Object headerWriteLock = new Object();
    private final AtomicReference<Throwable> error = new AtomicReference();
    private final AtomicReference<IOException> applicationIOE = new AtomicReference();
    private final CompletionHandler<Long, Void> errorCompletion = new CompletionHandler<Long, Void>(){

        @Override
        public void completed(Long l, Void void_) {
        }

        @Override
        public void failed(Throwable throwable, Void void_) {
            Http2AsyncUpgradeHandler.this.error.set(throwable);
        }
    };
    private final CompletionHandler<Long, Void> applicationErrorCompletion = new CompletionHandler<Long, Void>(){

        @Override
        public void completed(Long l, Void void_) {
        }

        @Override
        public void failed(Throwable throwable, Void void_) {
            if (throwable instanceof IOException) {
                Http2AsyncUpgradeHandler.this.applicationIOE.set((IOException)throwable);
            }
            Http2AsyncUpgradeHandler.this.error.set(throwable);
        }
    };

    public Http2AsyncUpgradeHandler(Http2Protocol http2Protocol, Adapter adapter, Request request) {
        super(http2Protocol, adapter, request);
    }

    @Override
    protected Http2Parser getParser(String string) {
        return new Http2AsyncParser(string, this, this, this.socketWrapper, this);
    }

    @Override
    protected Http2UpgradeHandler.PingManager getPingManager() {
        return new AsyncPingManager();
    }

    @Override
    public boolean hasAsyncIO() {
        return true;
    }

    @Override
    protected void processConnection(WebConnection webConnection, Stream stream) {
    }

    void processConnectionCallback(WebConnection webConnection, Stream stream) {
        super.processConnection(webConnection, stream);
    }

    @Override
    protected void writeSettings() {
        this.socketWrapper.write(SocketWrapperBase.BlockingMode.SEMI_BLOCK, this.protocol.getWriteTimeout(), TimeUnit.MILLISECONDS, null, SocketWrapperBase.COMPLETE_WRITE, this.errorCompletion, ByteBuffer.wrap(this.localSettings.getSettingsFrameForPending()), ByteBuffer.wrap(this.createWindowUpdateForSettings()));
        Throwable throwable = this.error.get();
        if (throwable != null) {
            String string = sm.getString("upgradeHandler.sendPrefaceFail", new Object[]{this.connectionId});
            if (log.isDebugEnabled()) {
                log.debug((Object)string);
            }
            throw new ProtocolException(string, throwable);
        }
    }

    @Override
    void sendStreamReset(StreamException streamException) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("upgradeHandler.rst.debug", new Object[]{this.connectionId, Integer.toString(streamException.getStreamId()), streamException.getError(), streamException.getMessage()}));
        }
        byte[] byArray = new byte[13];
        ByteUtil.setThreeBytes(byArray, 0, 4);
        byArray[3] = FrameType.RST.getIdByte();
        ByteUtil.set31Bits(byArray, 5, streamException.getStreamId());
        ByteUtil.setFourBytes(byArray, 9, streamException.getError().getCode());
        this.socketWrapper.write(SocketWrapperBase.BlockingMode.SEMI_BLOCK, this.protocol.getWriteTimeout(), TimeUnit.MILLISECONDS, null, SocketWrapperBase.COMPLETE_WRITE, this.errorCompletion, ByteBuffer.wrap(byArray));
        this.handleAsyncException();
    }

    @Override
    protected void writeGoAwayFrame(int n, long l, byte[] byArray) throws IOException {
        byte[] byArray2 = new byte[8];
        ByteUtil.set31Bits(byArray2, 0, n);
        ByteUtil.setFourBytes(byArray2, 4, l);
        int n2 = 8;
        if (byArray != null) {
            n2 += byArray.length;
        }
        byte[] byArray3 = new byte[3];
        ByteUtil.setThreeBytes(byArray3, 0, n2);
        if (byArray != null) {
            this.socketWrapper.write(SocketWrapperBase.BlockingMode.SEMI_BLOCK, this.protocol.getWriteTimeout(), TimeUnit.MILLISECONDS, null, SocketWrapperBase.COMPLETE_WRITE, this.errorCompletion, ByteBuffer.wrap(byArray3), ByteBuffer.wrap(GOAWAY), ByteBuffer.wrap(byArray2), ByteBuffer.wrap(byArray));
        } else {
            this.socketWrapper.write(SocketWrapperBase.BlockingMode.SEMI_BLOCK, this.protocol.getWriteTimeout(), TimeUnit.MILLISECONDS, null, SocketWrapperBase.COMPLETE_WRITE, this.errorCompletion, ByteBuffer.wrap(byArray3), ByteBuffer.wrap(GOAWAY), ByteBuffer.wrap(byArray2));
        }
        this.handleAsyncException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void writeHeaders(Stream stream, int n, MimeHeaders mimeHeaders, boolean bl, int n2) throws IOException {
        Object object = this.headerWriteLock;
        synchronized (object) {
            AsyncHeaderFrameBuffers asyncHeaderFrameBuffers = (AsyncHeaderFrameBuffers)this.doWriteHeaders(stream, n, mimeHeaders, bl, n2);
            if (asyncHeaderFrameBuffers != null) {
                this.socketWrapper.write(SocketWrapperBase.BlockingMode.SEMI_BLOCK, this.protocol.getWriteTimeout(), TimeUnit.MILLISECONDS, null, SocketWrapperBase.COMPLETE_WRITE, this.applicationErrorCompletion, asyncHeaderFrameBuffers.bufs.toArray(BYTEBUFFER_ARRAY));
                this.handleAsyncException();
            }
        }
        if (bl) {
            stream.sentEndOfStream();
        }
    }

    @Override
    protected Http2UpgradeHandler.HeaderFrameBuffers getHeaderFrameBuffers(int n) {
        return new AsyncHeaderFrameBuffers(n);
    }

    @Override
    void writeBody(Stream stream, ByteBuffer byteBuffer, int n, boolean bl) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("upgradeHandler.writeBody", new Object[]{this.connectionId, stream.getIdAsString(), Integer.toString(n), bl}));
        }
        boolean bl2 = stream.canWrite();
        byte[] byArray = new byte[9];
        ByteUtil.setThreeBytes(byArray, 0, n);
        byArray[3] = FrameType.DATA.getIdByte();
        if (bl) {
            byArray[4] = 1;
            stream.sentEndOfStream();
            if (!stream.isActive()) {
                this.setConnectionTimeoutForStreamCount(this.activeRemoteStreamCount.decrementAndGet());
            }
        }
        if (bl2) {
            ByteUtil.set31Bits(byArray, 5, stream.getIdAsInt());
            int n2 = byteBuffer.limit();
            byteBuffer.limit(byteBuffer.position() + n);
            this.socketWrapper.write(SocketWrapperBase.BlockingMode.BLOCK, this.protocol.getWriteTimeout(), TimeUnit.MILLISECONDS, null, SocketWrapperBase.COMPLETE_WRITE, this.applicationErrorCompletion, ByteBuffer.wrap(byArray), byteBuffer);
            byteBuffer.limit(n2);
            this.handleAsyncException();
        }
    }

    @Override
    void writeWindowUpdate(AbstractNonZeroStream abstractNonZeroStream, int n, boolean bl) throws IOException {
        int n2;
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("upgradeHandler.windowUpdateConnection", new Object[]{this.getConnectionId(), n}));
        }
        byte[] byArray = new byte[13];
        ByteUtil.setThreeBytes(byArray, 0, 4);
        byArray[3] = FrameType.WINDOW_UPDATE.getIdByte();
        ByteUtil.set31Bits(byArray, 9, n);
        boolean bl2 = true;
        if (abstractNonZeroStream instanceof Stream && ((Stream)abstractNonZeroStream).canWrite() && (n2 = ((Stream)abstractNonZeroStream).getWindowUpdateSizeToWrite(n)) > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("upgradeHandler.windowUpdateStream", new Object[]{this.getConnectionId(), this.getIdAsString(), n2}));
            }
            byte[] byArray2 = new byte[13];
            ByteUtil.setThreeBytes(byArray2, 0, 4);
            byArray2[3] = FrameType.WINDOW_UPDATE.getIdByte();
            ByteUtil.set31Bits(byArray2, 9, n2);
            ByteUtil.set31Bits(byArray2, 5, abstractNonZeroStream.getIdAsInt());
            this.socketWrapper.write(SocketWrapperBase.BlockingMode.SEMI_BLOCK, this.protocol.getWriteTimeout(), TimeUnit.MILLISECONDS, null, SocketWrapperBase.COMPLETE_WRITE, this.errorCompletion, ByteBuffer.wrap(byArray), ByteBuffer.wrap(byArray2));
            bl2 = false;
        }
        if (bl2) {
            this.socketWrapper.write(SocketWrapperBase.BlockingMode.SEMI_BLOCK, this.protocol.getWriteTimeout(), TimeUnit.MILLISECONDS, null, SocketWrapperBase.COMPLETE_WRITE, this.errorCompletion, ByteBuffer.wrap(byArray));
        }
        this.handleAsyncException();
    }

    @Override
    public void settingsEnd(boolean bl) throws IOException {
        if (bl) {
            if (!this.localSettings.ack()) {
                log.warn((Object)sm.getString("upgradeHandler.unexpectedAck", new Object[]{this.connectionId, this.getIdAsString()}));
            }
        } else {
            this.socketWrapper.write(SocketWrapperBase.BlockingMode.SEMI_BLOCK, this.protocol.getWriteTimeout(), TimeUnit.MILLISECONDS, null, SocketWrapperBase.COMPLETE_WRITE, this.errorCompletion, ByteBuffer.wrap(SETTINGS_ACK));
        }
        this.handleAsyncException();
    }

    private void handleAsyncException() throws IOException {
        IOException iOException = this.applicationIOE.getAndSet(null);
        if (iOException != null) {
            this.handleAppInitiatedIOException(iOException);
        } else {
            Throwable throwable = this.error.getAndSet(null);
            if (throwable != null) {
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                throw new IOException(throwable);
            }
        }
    }

    @Override
    protected SendfileState processSendfile(SendfileData sendfileData) {
        if (sendfileData != null) {
            int n;
            try {
                try (FileChannel fileChannel = FileChannel.open(sendfileData.path, StandardOpenOption.READ);){
                    sendfileData.mappedBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, sendfileData.pos, sendfileData.end - sendfileData.pos);
                }
                n = sendfileData.end - sendfileData.pos > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)(sendfileData.end - sendfileData.pos);
                sendfileData.streamReservation = sendfileData.stream.reserveWindowSize(n, true);
                sendfileData.connectionReservation = this.reserveWindowSize(sendfileData.stream, sendfileData.streamReservation, true);
            }
            catch (IOException iOException) {
                return SendfileState.ERROR;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("upgradeHandler.sendfile.reservation", new Object[]{this.connectionId, sendfileData.stream.getIdAsString(), sendfileData.connectionReservation, sendfileData.streamReservation}));
            }
            boolean bl = (long)(n = Integer.min(this.getMaxFrameSize(), sendfileData.connectionReservation)) == sendfileData.left && sendfileData.stream.getCoyoteResponse().getTrailerFields() == null;
            boolean bl2 = sendfileData.stream.canWrite();
            byte[] byArray = new byte[9];
            ByteUtil.setThreeBytes(byArray, 0, n);
            byArray[3] = FrameType.DATA.getIdByte();
            if (bl) {
                byArray[4] = 1;
                sendfileData.stream.sentEndOfStream();
                if (!sendfileData.stream.isActive()) {
                    this.setConnectionTimeoutForStreamCount(this.activeRemoteStreamCount.decrementAndGet());
                }
            }
            if (bl2) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("upgradeHandler.writeBody", new Object[]{this.connectionId, sendfileData.stream.getIdAsString(), Integer.toString(n), bl}));
                }
                ByteUtil.set31Bits(byArray, 5, sendfileData.stream.getIdAsInt());
                sendfileData.mappedBuffer.limit(sendfileData.mappedBuffer.position() + n);
                this.socketWrapper.write(SocketWrapperBase.BlockingMode.SEMI_BLOCK, this.protocol.getWriteTimeout(), TimeUnit.MILLISECONDS, sendfileData, SocketWrapperBase.COMPLETE_WRITE_WITH_COMPLETION, new SendfileCompletionHandler(), ByteBuffer.wrap(byArray), sendfileData.mappedBuffer);
                try {
                    this.handleAsyncException();
                }
                catch (IOException iOException) {
                    return SendfileState.ERROR;
                }
            }
            return SendfileState.PENDING;
        }
        return SendfileState.DONE;
    }

    private static class AsyncHeaderFrameBuffers
    implements Http2UpgradeHandler.HeaderFrameBuffers {
        int payloadSize;
        private byte[] header;
        private ByteBuffer payload;
        private final List<ByteBuffer> bufs = new ArrayList<ByteBuffer>();

        public AsyncHeaderFrameBuffers(int n) {
            this.payloadSize = n;
        }

        @Override
        public void startFrame() {
            this.header = new byte[9];
            this.payload = ByteBuffer.allocate(this.payloadSize);
        }

        @Override
        public void endFrame() throws IOException {
            this.bufs.add(ByteBuffer.wrap(this.header));
            this.bufs.add(this.payload);
        }

        @Override
        public void endHeaders() throws IOException {
        }

        @Override
        public byte[] getHeader() {
            return this.header;
        }

        @Override
        public ByteBuffer getPayload() {
            return this.payload;
        }

        @Override
        public void expandPayload() {
            this.payloadSize *= 2;
            this.payload = ByteBuffer.allocate(this.payloadSize);
        }
    }

    protected class AsyncPingManager
    extends Http2UpgradeHandler.PingManager {
        protected AsyncPingManager() {
            super(Http2AsyncUpgradeHandler.this);
        }

        @Override
        public void sendPing(boolean bl) throws IOException {
            if (this.initiateDisabled) {
                return;
            }
            long l = System.nanoTime();
            if (bl || l - this.lastPingNanoTime > 10000000000L) {
                this.lastPingNanoTime = l;
                byte[] byArray = new byte[8];
                int n = ++this.sequence;
                Http2UpgradeHandler.PingRecord pingRecord = new Http2UpgradeHandler.PingRecord(n, l);
                this.inflightPings.add(pingRecord);
                ByteUtil.set31Bits(byArray, 4, n);
                Http2AsyncUpgradeHandler.this.socketWrapper.write(SocketWrapperBase.BlockingMode.SEMI_BLOCK, Http2AsyncUpgradeHandler.this.protocol.getWriteTimeout(), TimeUnit.MILLISECONDS, null, SocketWrapperBase.COMPLETE_WRITE, Http2AsyncUpgradeHandler.this.errorCompletion, ByteBuffer.wrap(Http2UpgradeHandler.PING), ByteBuffer.wrap(byArray));
                Http2AsyncUpgradeHandler.this.handleAsyncException();
            }
        }

        @Override
        public void receivePing(byte[] byArray, boolean bl) throws IOException {
            if (bl) {
                super.receivePing(byArray, bl);
            } else {
                Http2AsyncUpgradeHandler.this.socketWrapper.write(SocketWrapperBase.BlockingMode.SEMI_BLOCK, Http2AsyncUpgradeHandler.this.protocol.getWriteTimeout(), TimeUnit.MILLISECONDS, null, SocketWrapperBase.COMPLETE_WRITE, Http2AsyncUpgradeHandler.this.errorCompletion, ByteBuffer.wrap(Http2UpgradeHandler.PING_ACK), ByteBuffer.wrap(byArray));
                Http2AsyncUpgradeHandler.this.handleAsyncException();
            }
        }
    }

    protected class SendfileCompletionHandler
    implements CompletionHandler<Long, SendfileData> {
        protected SendfileCompletionHandler() {
        }

        @Override
        public void completed(Long l, SendfileData sendfileData) {
            int n;
            long l2 = l - 9L;
            sendfileData.left -= l2;
            if (sendfileData.left == 0L) {
                try {
                    sendfileData.stream.getOutputBuffer().end();
                }
                catch (IOException iOException) {
                    this.failed((Throwable)iOException, sendfileData);
                }
                return;
            }
            sendfileData.streamReservation = (int)((long)sendfileData.streamReservation - l2);
            sendfileData.connectionReservation = (int)((long)sendfileData.connectionReservation - l2);
            sendfileData.pos += l2;
            try {
                if (sendfileData.connectionReservation == 0) {
                    if (sendfileData.streamReservation == 0) {
                        n = sendfileData.end - sendfileData.pos > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)(sendfileData.end - sendfileData.pos);
                        sendfileData.streamReservation = sendfileData.stream.reserveWindowSize(n, true);
                    }
                    sendfileData.connectionReservation = Http2AsyncUpgradeHandler.this.reserveWindowSize(sendfileData.stream, sendfileData.streamReservation, true);
                }
            }
            catch (IOException iOException) {
                this.failed((Throwable)iOException, sendfileData);
                return;
            }
            if (Http2UpgradeHandler.log.isDebugEnabled()) {
                Http2UpgradeHandler.log.debug((Object)Http2UpgradeHandler.sm.getString("upgradeHandler.sendfile.reservation", new Object[]{Http2AsyncUpgradeHandler.this.connectionId, sendfileData.stream.getIdAsString(), sendfileData.connectionReservation, sendfileData.streamReservation}));
            }
            boolean bl = (long)(n = Integer.min(Http2AsyncUpgradeHandler.this.getMaxFrameSize(), sendfileData.connectionReservation)) == sendfileData.left && sendfileData.stream.getCoyoteResponse().getTrailerFields() == null;
            boolean bl2 = sendfileData.stream.canWrite();
            byte[] byArray = new byte[9];
            ByteUtil.setThreeBytes(byArray, 0, n);
            byArray[3] = FrameType.DATA.getIdByte();
            if (bl) {
                byArray[4] = 1;
                sendfileData.stream.sentEndOfStream();
                if (!sendfileData.stream.isActive()) {
                    Http2AsyncUpgradeHandler.this.setConnectionTimeoutForStreamCount(Http2AsyncUpgradeHandler.this.activeRemoteStreamCount.decrementAndGet());
                }
            }
            if (bl2) {
                if (Http2UpgradeHandler.log.isDebugEnabled()) {
                    Http2UpgradeHandler.log.debug((Object)Http2UpgradeHandler.sm.getString("upgradeHandler.writeBody", new Object[]{Http2AsyncUpgradeHandler.this.connectionId, sendfileData.stream.getIdAsString(), Integer.toString(n), bl}));
                }
                ByteUtil.set31Bits(byArray, 5, sendfileData.stream.getIdAsInt());
                sendfileData.mappedBuffer.limit(sendfileData.mappedBuffer.position() + n);
                Http2AsyncUpgradeHandler.this.socketWrapper.write(SocketWrapperBase.BlockingMode.SEMI_BLOCK, Http2AsyncUpgradeHandler.this.protocol.getWriteTimeout(), TimeUnit.MILLISECONDS, sendfileData, SocketWrapperBase.COMPLETE_WRITE_WITH_COMPLETION, this, ByteBuffer.wrap(byArray), sendfileData.mappedBuffer);
                try {
                    Http2AsyncUpgradeHandler.this.handleAsyncException();
                }
                catch (IOException iOException) {
                    this.failed((Throwable)iOException, sendfileData);
                }
            }
        }

        @Override
        public void failed(Throwable throwable, SendfileData sendfileData) {
            Http2AsyncUpgradeHandler.this.applicationErrorCompletion.failed(throwable, null);
        }
    }
}

