/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.results.cpu;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.swing.tree.TreeNode;
import org.graalvm.visualvm.lib.jfluid.results.CCTNode;
import org.graalvm.visualvm.lib.jfluid.results.FilterSortSupport;
import org.graalvm.visualvm.lib.jfluid.results.cpu.CPUCCTContainer;
import org.graalvm.visualvm.lib.jfluid.utils.formatting.MethodNameFormatterFactory;

public abstract class PrestimeCPUCCTNode
extends CCTNode
implements Cloneable {
    private static final String SELF_TIME_STRING;
    protected static final char MASK_SELF_TIME_NODE = '\u0001';
    protected static final char MASK_CONTEXT_CALLS_NODE = '\u0002';
    protected static final char MASK_THREAD_NODE = '\u0004';
    public static final int SORT_BY_NAME = 1;
    public static final int SORT_BY_TIME_0 = 2;
    public static final int SORT_BY_TIME_1 = 3;
    public static final int SORT_BY_INVOCATIONS = 4;
    public static final PrestimeCPUCCTNode EMPTY;
    protected CPUCCTContainer container;
    protected PrestimeCPUCCTNode parent;
    protected PrestimeCPUCCTNode[] children;
    protected char flags;
    private String nodeName;
    protected int methodId;
    protected int nCalls;
    protected long sleepTime0;
    protected long totalTime0;
    protected long totalTime1;
    protected long waitTime0;

    protected PrestimeCPUCCTNode() {
    }

    protected PrestimeCPUCCTNode(CPUCCTContainer container, PrestimeCPUCCTNode parent, int methodId) {
        this.container = container;
        this.parent = parent;
        this.methodId = methodId;
    }

    PrestimeCPUCCTNode createCopy() {
        throw new UnsupportedOperationException("Cannot be called directly on " + this.getClass().getName());
    }

    void setupCopy(PrestimeCPUCCTNode node) {
        node.container = this.container;
        node.parent = this.parent;
        node.children = this.children;
        node.flags = this.flags;
        node.nodeName = this.nodeName;
        node.methodId = this.methodId;
        node.nCalls = this.nCalls;
        node.sleepTime0 = this.sleepTime0;
        node.totalTime0 = this.totalTime0;
        node.totalTime1 = this.totalTime1;
        node.waitTime0 = this.waitTime0;
    }

    protected void setupFilteredNode(PrestimeCPUCCTNode filtered) {
        this.setupCopy(filtered);
        filtered.setFilteredNode();
        filtered.nodeName = null;
        filtered.methodId = -1;
        Collection<PrestimeCPUCCTNode> _childrenL = PrestimeCPUCCTNode.resolveChildren(this);
        filtered.children = _childrenL.toArray(new PrestimeCPUCCTNode[0]);
    }

    @Override
    public void merge(CCTNode node) {
        if (node instanceof PrestimeCPUCCTNode) {
            PrestimeCPUCCTNode[] __children;
            PrestimeCPUCCTNode _node = (PrestimeCPUCCTNode)node;
            this.addNCalls(_node.getNCalls());
            this.addSleepTime0(_node.getSleepTime0());
            this.addTotalTime0(_node.getTotalTime0());
            this.addTotalTime1(_node.getTotalTime1());
            this.addWaitTime0(_node.getWaitTime0());
            ArrayList<PrestimeCPUCCTNode> ch = new ArrayList<PrestimeCPUCCTNode>();
            PrestimeCPUCCTNode[] _children = (PrestimeCPUCCTNode[])this.getChildren();
            if (_children != null) {
                for (PrestimeCPUCCTNode child : _children) {
                    ch.add(child.createCopy());
                }
            }
            if ((__children = (PrestimeCPUCCTNode[])node.getChildren()) != null) {
                for (PrestimeCPUCCTNode child : __children) {
                    if (child == null || child.isSelfTimeNode()) continue;
                    int idx = ch.indexOf(child);
                    if (idx == -1) {
                        ch.add(child.createCopy());
                        continue;
                    }
                    ((CCTNode)ch.get(idx)).merge(child);
                }
            }
            this.children = ch.toArray(new PrestimeCPUCCTNode[0]);
        }
    }

    protected static Collection<PrestimeCPUCCTNode> resolveChildren(PrestimeCPUCCTNode node) {
        ArrayList<PrestimeCPUCCTNode> chldrn = new ArrayList<PrestimeCPUCCTNode>();
        PrestimeCPUCCTNode[] chld = (PrestimeCPUCCTNode[])node.getChildren();
        if (chld != null) {
            for (PrestimeCPUCCTNode chl : chld) {
                if (chl.isSelfTimeNode()) continue;
                chldrn.add(chl);
            }
        }
        return chldrn;
    }

    @Override
    public CCTNode getChild(int index) {
        return this.children[index];
    }

    @Override
    public CCTNode[] getChildren() {
        return this.children;
    }

    @Override
    public int getNChildren() {
        return this.children != null ? this.children.length : 0;
    }

    public CPUCCTContainer getContainer() {
        return this.container;
    }

    public int getMethodId() {
        return this.methodId;
    }

    public int getNCalls() {
        return this.nCalls;
    }

    public long getSleepTime0() {
        return this.sleepTime0;
    }

    public int getThreadId() {
        return this.container.getThreadId();
    }

    public long getTotalTime0() {
        return this.totalTime0;
    }

    public long getTotalTime1() {
        return this.totalTime1;
    }

    public long getWaitTime0() {
        return this.waitTime0;
    }

    public void addNCalls(int addCalls) {
        this.nCalls += addCalls;
    }

    public void addSleepTime0(long addTime) {
        this.sleepTime0 += addTime;
    }

    public void addTotalTime0(long addTime) {
        this.totalTime0 += addTime;
    }

    public void addTotalTime1(long addTime) {
        this.totalTime1 += addTime;
    }

    public void addWaitTime0(long addTime) {
        this.waitTime0 += addTime;
    }

    public void setContextCallsNode() {
        this.flags = (char)2;
    }

    public boolean isContextCallsNode() {
        return (this.flags & 2) != 0;
    }

    public String[] getMethodClassNameAndSig() {
        if (!this.isThreadNode()) {
            return this.container.getMethodClassNameAndSig(this.getMethodId());
        }
        return new String[]{this.container.getThreadName(), "", ""};
    }

    protected void resetChildren() {
        if (this.children != null) {
            for (PrestimeCPUCCTNode n : this.children) {
                n.resetChildren();
            }
        }
    }

    public String getNodeName() {
        if (this.nodeName == null) {
            this.nodeName = this.computeNodeName();
        }
        return this.nodeName;
    }

    protected String computeNodeName() {
        if (this.isFiltered()) {
            return FilterSortSupport.FILTERED_OUT_LBL;
        }
        if (this.isSelfTimeNode()) {
            return SELF_TIME_STRING;
        }
        if (this.isThreadNode()) {
            return this.container.getThreadName();
        }
        int methodId = this.getMethodId();
        String[] methodClassNameAndSig = this.container.getMethodClassNameAndSig(methodId);
        return MethodNameFormatterFactory.getDefault().getFormatter().formatMethodName(methodClassNameAndSig[0], methodClassNameAndSig[1], methodClassNameAndSig[2]).toFormatted();
    }

    public boolean equals(Object o) {
        if (!(o instanceof PrestimeCPUCCTNode)) {
            return false;
        }
        PrestimeCPUCCTNode oo = (PrestimeCPUCCTNode)o;
        if (this.parent == null) {
            return oo.parent == null;
        }
        if (this.isThreadNode()) {
            return this.container.getThreadId() == oo.container.getThreadId();
        }
        if (this.isSelfTimeNode()) {
            return oo.isSelfTimeNode();
        }
        if (this.isFiltered()) {
            return oo.isFiltered();
        }
        if (this.isContextCallsNode()) {
            return this.getMethodId() == oo.getMethodId();
        }
        return this.getMethodId() == oo.getMethodId();
    }

    public int hashCode() {
        if (this.parent == null) {
            return 1;
        }
        if (this.isThreadNode()) {
            return this.container.getThreadId();
        }
        if (this.isSelfTimeNode()) {
            return -1;
        }
        if (this.isFiltered()) {
            return -10;
        }
        if (this.isContextCallsNode()) {
            return Integer.MIN_VALUE + this.getMethodId();
        }
        return this.getMethodId();
    }

    @Override
    public CCTNode getParent() {
        return this.parent;
    }

    public void setSelfTimeNode() {
        this.flags = (char)(this.flags | '\u0001');
    }

    public boolean isSelfTimeNode() {
        return (this.flags & '\u0001') != 0;
    }

    public void setThreadNode() {
        this.flags = (char)(this.flags | 4);
    }

    public boolean isThreadNode() {
        return (this.flags & 4) != 0;
    }

    public abstract float getTotalTime0InPerCent();

    public abstract float getTotalTime1InPerCent();

    @Override
    public int getIndexOfChild(Object child) {
        if (this.getNChildren() == 0) {
            return -1;
        }
        for (int i = 0; i < this.children.length; ++i) {
            if ((PrestimeCPUCCTNode)child != this.children[i]) continue;
            return i;
        }
        return -1;
    }

    public void sortChildren(int sortBy, boolean sortOrder) {
    }

    public String toString() {
        return this.getNodeName();
    }

    static {
        ResourceBundle messages = ResourceBundle.getBundle("org.graalvm.visualvm.lib.jfluid.results.cpu.Bundle");
        SELF_TIME_STRING = messages.getString("PrestimeCPUCCTNode_SelfTimeString");
        EMPTY = new PrestimeCPUCCTNode(){

            @Override
            PrestimeCPUCCTNode createCopy() {
                return null;
            }

            @Override
            public PrestimeCPUCCTNode getChild(int index) {
                return null;
            }

            public PrestimeCPUCCTNode[] getChildren() {
                return new PrestimeCPUCCTNode[0];
            }

            @Override
            public int getIndexOfChild(Object child) {
                return -1;
            }

            @Override
            public int getNChildren() {
                return 0;
            }

            @Override
            public String getNodeName() {
                return "";
            }

            public long getTime() {
                return 0L;
            }

            public double getTimeInPerCent() {
                return 0.0;
            }

            public long getWaits() {
                return 0L;
            }

            @Override
            public int getMethodId() {
                return -1;
            }

            @Override
            public int getNCalls() {
                return -1;
            }

            @Override
            public long getSleepTime0() {
                return -1L;
            }

            @Override
            public int getThreadId() {
                return -1;
            }

            @Override
            public long getTotalTime0() {
                return -1L;
            }

            @Override
            public float getTotalTime0InPerCent() {
                return -1.0f;
            }

            @Override
            public long getTotalTime1() {
                return -1L;
            }

            @Override
            public float getTotalTime1InPerCent() {
                return -1.0f;
            }

            @Override
            public long getWaitTime0() {
                return -1L;
            }

            @Override
            public void sortChildren(int sortBy, boolean sortOrder) {
            }

            @Override
            public TreeNode getChildAt(int childIndex) {
                return null;
            }

            @Override
            public int getChildCount() {
                return 0;
            }

            @Override
            public CCTNode getParent() {
                return null;
            }

            @Override
            public int getIndex(TreeNode node) {
                return -1;
            }

            @Override
            public boolean getAllowsChildren() {
                return false;
            }

            @Override
            public boolean isLeaf() {
                return true;
            }

            public Enumeration children() {
                return null;
            }
        };
    }
}

