/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.ctp;

import ca.odell.glazedlists.impl.ctp.CTPConnection;
import ca.odell.glazedlists.impl.ctp.CTPConnectionManager;
import ca.odell.glazedlists.impl.ctp.CTPHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;

class OpenConnection
implements Runnable {
    private CTPConnectionManager connectionManager;
    private String host;
    private int port;
    private CTPHandler handler;

    public OpenConnection(CTPConnectionManager connectionManager, CTPHandler handler, String host, int port) {
        this.connectionManager = connectionManager;
        this.handler = handler;
        this.host = host;
        this.port = port;
    }

    @Override
    public void run() {
        CTPConnection client = null;
        try {
            InetSocketAddress address = new InetSocketAddress(this.host, this.port);
            SocketChannel channel = SocketChannel.open();
            channel.configureBlocking(false);
            SelectionKey selectionKey = channel.register(this.connectionManager.getNIODaemon().getSelector(), 8);
            client = CTPConnection.client(this.host, selectionKey, this.handler, this.connectionManager);
            selectionKey.attach(client);
            channel.connect(address);
        }
        catch (IOException e) {
            this.handler.connectionClosed(client, e);
        }
    }
}

