/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapdump.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.core.VisualVM;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasource.descriptor.DataSourceDescriptor;
import org.graalvm.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import org.graalvm.visualvm.core.snapshot.Snapshot;
import org.graalvm.visualvm.core.snapshot.SnapshotView;
import org.graalvm.visualvm.core.ui.components.DataViewComponent;
import org.graalvm.visualvm.core.ui.components.ScrollableContainer;
import org.graalvm.visualvm.heapdump.HeapDump;
import org.graalvm.visualvm.heapviewer.HeapViewer;
import org.openide.util.NbBundle;

class HeapDumpView
extends SnapshotView {
    private static final Logger LOGGER = Logger.getLogger(HeapDumpView.class.getName());
    private MasterViewSupport mvs;

    public HeapDumpView(HeapDump heapDump) {
        this(heapDump, DataSourceDescriptorFactory.getDescriptor((DataSource)heapDump));
    }

    private HeapDumpView(HeapDump heapDump, DataSourceDescriptor descriptor) {
        super((Snapshot)heapDump, descriptor.getName(), descriptor.getIcon(), 0);
    }

    protected DataViewComponent createComponent() {
        HeapDump heapDump = (HeapDump)this.getDataSource();
        this.mvs = new MasterViewSupport(heapDump);
        DataViewComponent dvc = new DataViewComponent(this.mvs.getMasterView(), new DataViewComponent.MasterViewConfiguration(true));
        return dvc;
    }

    protected void willBeRemoved() {
        if (this.mvs != null) {
            this.mvs.willBeRemoved();
        }
    }

    protected void removed() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (HeapDumpView.this.mvs != null) {
                    HeapDumpView.this.mvs.closed();
                }
            }
        });
    }

    private static class MasterViewSupport
    extends JPanel {
        private JLabel progressLabel;
        private JPanel contentsPanel;
        private HeapViewer heapViewer;

        public MasterViewSupport(HeapDump heapDump) {
            File file = heapDump.getFile();
            this.initComponents(file != null);
            if (file != null) {
                this.loadHeap(file);
            }
        }

        public DataViewComponent.MasterView getMasterView() {
            return new DataViewComponent.MasterView(NbBundle.getMessage(HeapDumpView.class, (String)"LBL_Heap_Dump"), null, (JComponent)new ScrollableContainer((JComponent)this));
        }

        void willBeRemoved() {
            if (this.heapViewer != null) {
                this.heapViewer.willBeRemoved();
            }
        }

        void closed() {
            if (this.heapViewer != null) {
                this.heapViewer.closed();
            }
        }

        private void initComponents(boolean hasDump) {
            this.setLayout(new BorderLayout());
            String label = hasDump ? NbBundle.getMessage(HeapDumpView.class, (String)"LBL_Loading_Heap_Dump") : NbBundle.getMessage(HeapDumpView.class, (String)"LBL_Loading_Heap_Dump_failed");
            this.progressLabel = new JLabel(label, 0);
            this.contentsPanel = new JPanel(new BorderLayout());
            this.contentsPanel.add((Component)this.progressLabel, "Center");
            this.contentsPanel.setOpaque(false);
            this.add((Component)this.contentsPanel, "Center");
            this.setOpaque(false);
        }

        private void loadHeap(final File file) {
            VisualVM.getInstance().runTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        final HeapViewer _heapViewer = new HeapViewer(file);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                heapViewer = _heapViewer;
                                contentsPanel.remove(progressLabel);
                                contentsPanel.add((Component)heapViewer.getComponent(), "Center");
                                contentsPanel.revalidate();
                                contentsPanel.repaint();
                            }
                        });
                    }
                    catch (IOException ex) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                progressLabel.setText(NbBundle.getMessage(HeapDumpView.class, (String)"LBL_Loading_Heap_Dump_failed2", (Object)ex.getMessage()));
                                contentsPanel.revalidate();
                                contentsPanel.repaint();
                            }
                        });
                        LOGGER.log(Level.INFO, "Failed to load heap dump", ex);
                    }
                }
            });
        }
    }
}

