
# Serverless Platform SDK

This Serverless Platform SDK makes it easy to interact with the Serverless Platform and perform operations on it. Please note that there is an existing `@serverless/platform-sdk` npm module for interacting with the Serverless Inc. SaaS original platform services.  This SDK is for the new services, which are multi-cloud, self-hostable and focued on Components.  At some point, we will try to merge these SDKs.

The SDK is light-weight, so that it can be used in the following: CLIs, Dashboards, Back-End Services, FaaS Layers.  Please **DO NOT** add any big Node.js dependencies to this SDK.

This SDK should guide the interface design between Services and Clients.  All Clients and Services **MUST** use the SDK and should never hardcode API endpoints or FaaS resources identifiers.

## Quick-Start

**If you are working within a Node.js environment, install the Serverless Platform Client SDK via NPM:**

```
npm i @serverless/platform-client-china
```

**If you are working within a web/browser environment, use the CDN hosted Serverless Platform Client SDK:**

This is minified, tree-shaked, browserified.  The CDN fetches it directly from NPM, so just reference any npm version, like below.

This CDN service has several locations in China, so it works well there.

```
// In index.html <head></head>
<!-- Load the Serverless Platform (Components) SDK -->
<script src="https://cdn.jsdelivr.net/npm/@serverless/platform-client-china@1.0.10" async></script>
```

You can also pin to the latest version, but this could break at any time:

```
// In index.html <head></head>
<!-- Load the Serverless Platform (Components) SDK -->
<script src="https://cdn.jsdelivr.net/npm/@serverless/platform-client-china" async></script>
```

If you are working with the `dev` environment of the Serverless Platform, set the following environment variable, or configure the client programmatically, as detailed below.

```
export SERVERLESS_PLATFORM_STAGE=dev
```

Here is how you require, instantiate the Client and use it:

```javascript
const { ServerlessSDK } = require('@serverless/platform-client-china')

sdk = new ServerlessSDK({
  platformStage: 'dev',  // Optional.  Defaults to 'prod'
  accessKey: 'JA98JAJFASLFJSALFJASLFJ', // Optional, but recommended.  Platform Access Key needed to identify all requests.
})

const instances = await sdk.listInstances('my-org')
```

<a name="ServerlessSDK"></a>

## ServerlessSDK
The Serverless Platform SDK Class

**Kind**: global class  

* [ServerlessSDK](#ServerlessSDK)
    * [new ServerlessSDK()](#new_ServerlessSDK_new)
    * [.events](#ServerlessSDK+events)
    * [.config()](#ServerlessSDK+config) ⇒ <code>null</code>
    * [.getDomain(serviceName)](#ServerlessSDK+getDomain) ⇒ <code>string</code>
    * [.connect()](#ServerlessSDK+connect) ⇒ <code>null</code>
    * [.disconnect()](#ServerlessSDK+disconnect) ⇒ <code>null</code>
    * [.isConnected()](#ServerlessSDK+isConnected) ⇒ <code>boolean</code>
    * [.publish()](#ServerlessSDK+publish) ⇒ <code>null</code>
    * [.createComponent(orgName, componentName)](#ServerlessSDK+createComponent)
    * [.publishComponent(componentDefinition)](#ServerlessSDK+publishComponent) ⇒ <code>object</code>
    * [.getComponent(componentName, componentVersion)](#ServerlessSDK+getComponent) ⇒ <code>object</code>
    * [.listComponents(orgUid, filter)](#ServerlessSDK+listComponents)
    * [.generateInstanceId(orgUid, stageName, appUid, instanceName)](#ServerlessSDK+generateInstanceId) ⇒ <code>object</code>
    * [.validateInstance(instanceToValidate)](#ServerlessSDK+validateInstance) ⇒ <code>object</code>
    * [.createInstance(orgName, stageName, appName, instanceName)](#ServerlessSDK+createInstance) ⇒ <code>object</code>
    * [.getInstance(orgName, stageName, appName, instanceName)](#ServerlessSDK+getInstance)
    * [.listInstances(orgName, orgUid)](#ServerlessSDK+listInstances)
    * [.run(action, instanceData, credentials, options)](#ServerlessSDK+run)
    * [.runFinish(method, instanceData)](#ServerlessSDK+runFinish)
    * [.deploy()](#ServerlessSDK+deploy)
    * [.remove()](#ServerlessSDK+remove)
    * [.startInterceptingLogs()](#ServerlessSDK+startInterceptingLogs)
    * [.stopInterceptingLogs()](#ServerlessSDK+stopInterceptingLogs)
    * [.paramSet()](#ServerlessSDK+paramSet)
    * [.paramList()](#ServerlessSDK+paramList)
    * [.bindRole()](#ServerlessSDK+bindRole)

<a name="new_ServerlessSDK_new"></a>

### new ServerlessSDK()
Creates an instance of the SDK.  Accepts a configuration object and calls the `config()` method.  See the `config()` method for more information on allowed configuration.


| Param | Type | Description |
| --- | --- | --- |
| [config.accessKey] | <code>string</code> | Can either be a Serverless Platform Access Key or an ID Token. |
| [config.platformStage] | <code>string</code> | The Serverless Platform Stage you wish to interact with.  This can also be set by the environment variable SERVERLESS_PLATFORM_STAGE= |
| [context.orgName] | <code>string</code> | The name of the Serverless Platform Organization you wish to interact with.  If set, this value is used upon creating a Websockets connection, and auto-added to every Event you publish. |
| [context.orgUid] | <code>string</code> | The ID of the Serverless Platform Organization you wish to interact with.  If set, this value is used upon creating a Websockets connection, and auto-added to every Event you publish. |
| [context.stageName] | <code>string</code> | The Serverless Platform Organization Stage you wish to interact with.  If set, this value is auto-added to every Event you publish. |
| [context.appName] | <code>string</code> | The Serverless Platform Application you wish to interact with.  If set, this value is auto-added to every Event you publish. |
| [context.instanceName] | <code>string</code> | The Serverless Platform Instance you wish to interact with.  If set, this value is auto-added to every Event you publish. |
| [context.componentName] | <code>string</code> | The Serverless Platform Component you wish to interact with.  If set, this value is auto-added to every Event you publish. |
| [context.componentVersion] | <code>string</code> | The Serverless Platform Component version you wish to interact with.  If set, this value is auto-added to every Event you publish. |
| [context.traceId] | <code>string</code> | The Serverless Platform Component version you wish to use this traceId to trace the all requests.  If set, this value is auto-added to every Event you publish. |

**Example**  
```js
const { ServerlessSDK } = require('@serverless/platform-client-china')

  const sdk = new ServerlessSDK({
    accessKey: '123456789',
    context: {
      orgName: 'my-org',
      orgUid: '1234',
      stageName: 'prod',
      appName: 'my-app',
      instanceName: 'my-instance'
    }
  })
```
<a name="ServerlessSDK+events"></a>

### serverlessSDK.events
events is the functions that will intercept with event bus: https://hackmd.io/_xwPrkdET2aKKr1VWcaWjQ?both, https://app.asana.com/0/1200011502754281/1200402117339672/f

**Kind**: instance property of [<code>ServerlessSDK</code>](#ServerlessSDK)  
**Param{object}**: eventData is the event object  
<a name="ServerlessSDK+config"></a>

### serverlessSDK.config() ⇒ <code>null</code>
Updates the SDK configuration

**Kind**: instance method of [<code>ServerlessSDK</code>](#ServerlessSDK)  

| Param | Type | Description |
| --- | --- | --- |
| [config.accessKey] | <code>string</code> | Can either be a Serverless Platform Access Key or an ID Token. |
| [config.platformStage] | <code>string</code> | The Serverless Platform Stage you wish to interact with.  This can also be set by the environment variable SERVERLESS_PLATFORM_STAGE= |
| [context.orgName] | <code>string</code> | The name of the Serverless Platform Organization you wish to interact with.  If set, this value is used upon creating a Websockets connection, and auto-added to every Event you publish. |
| [context.orgUid] | <code>string</code> | The ID of the Serverless Platform Organization you wish to interact with.  If set, this value is used upon creating a Websockets connection, and auto-added to every Event you publish. |
| [context.stageName] | <code>string</code> | The Serverless Platform Organization Stage you wish to interact with.  If set, this value is auto-added to every Event you publish. |
| [context.appName] | <code>string</code> | The Serverless Platform Application you wish to interact with.  If set, this value is auto-added to every Event you publish. |
| [context.instanceName] | <code>string</code> | The Serverless Platform Instance you wish to interact with.  If set, this value is auto-added to every Event you publish. |
| [context.componentName] | <code>string</code> | The Serverless Platform Component you wish to interact with.  If set, this value is auto-added to every Event you publish. |
| [context.componentVersion] | <code>string</code> | The Serverless Platform Component version you wish to interact with.  If set, this value is auto-added to every Event you publish. |
| [context.traceId] | <code>string</code> | The Serverless Platform Component version you wish to use this traceId to trace the all requests.  If set, this value is auto-added to every Event you publish. |

**Example**  
```js
const { ServerlessSDK } = require('@serverless/platform-client-china')

  const sdk = new ServerlessSDK()
  sdk.config({
    accessKey: '123456789',
    context: {
      orgName: 'my-org',
      orgUid: '1234',
      stageName: 'prod',
      appName: 'my-app',
      instanceName: 'my-instance'
      traceId: '123-456
    }
  })
```
<a name="ServerlessSDK+getDomain"></a>

### serverlessSDK.getDomain(serviceName) ⇒ <code>string</code>
Gets a domain for a specific service, currently CN verison only has 'events' and 'events-streaming'
Registry and engine are exposed through Tencent API

**Kind**: instance method of [<code>ServerlessSDK</code>](#ServerlessSDK)  
**Returns**: <code>string</code> - The domain of that service.  

| Param | Type | Default | Description |
| --- | --- | --- | --- |
| serviceName | <code>string</code> | <code>null</code> | The name of the Serverless Platform Service you want the domain for. |

<a name="ServerlessSDK+connect"></a>

### serverlessSDK.connect() ⇒ <code>null</code>
Establishes a websockets connection with the Serverless Platform

**Kind**: instance method of [<code>ServerlessSDK</code>](#ServerlessSDK)  

| Param | Type | Description |
| --- | --- | --- |
| options.orgName | <code>string</code> | Name of the Serverless Platform Org. |
| options.orgUid | <code>string</code> | ID of the Serverless Platform Org. |
| options.onEvent | <code>function</code> | A function that handles events recieved from the Serverless Platform |
| options.filter | <code>string</code> | Filters which events this connection should receive |
| options.filter.stageName | <code>string</code> | Tells the SDK to only receive events on a specific stage |
| options.filter.appName | <code>string</code> | Tells the SDK to only receive events on a specific app |
| options.filter.instanceName | <code>string</code> | Tells the SDK to only receive events on a specific service |

<a name="ServerlessSDK+disconnect"></a>

### serverlessSDK.disconnect() ⇒ <code>null</code>
Disconnects a websockets connection with the Serverless Platform

**Kind**: instance method of [<code>ServerlessSDK</code>](#ServerlessSDK)  
<a name="ServerlessSDK+isConnected"></a>

### serverlessSDK.isConnected() ⇒ <code>boolean</code>
Checks if the SDK is currently connected to the Serverless Platform

**Kind**: instance method of [<code>ServerlessSDK</code>](#ServerlessSDK)  
**Returns**: <code>boolean</code> - Will return true if the websocket connection is active.  
<a name="ServerlessSDK+publish"></a>

### serverlessSDK.publish() ⇒ <code>null</code>
Publishes a Serverless Platform Event via Websockets.  The use-case for this is asynchronous publishing, where you do not want to synchronous auth requests, where every message must be authorized first, adding latency.

**Kind**: instance method of [<code>ServerlessSDK</code>](#ServerlessSDK)  
<a name="ServerlessSDK+createComponent"></a>

### serverlessSDK.createComponent(orgName, componentName)
DEPRECATED: this method is deprecated, use createPackage instead
Returns a new Component as a Javascript object.

**Kind**: instance method of [<code>ServerlessSDK</code>](#ServerlessSDK)  

| Param | Type | Default | Description |
| --- | --- | --- | --- |
| orgName | <code>\*</code> | <code></code> | The name of the Serverless Platform Organization. |
| componentName | <code>\*</code> | <code></code> | The name of the Serverless Platform Stage. |

<a name="ServerlessSDK+publishComponent"></a>

### serverlessSDK.publishComponent(componentDefinition) ⇒ <code>object</code>
DEPRECATED: this method is deprecated, use publishPackage instead
This method publishes a Component to the Serverless Platform Registry.  This method accepts a Component Definition (e.g. serverless.component.yml) as an object.  In the Component Definition, it looks at the 'main' property to find the path to the Component source directory.  Then it collects that directory, adds in the special Component Handler, and packages everything into a zip file.  After that, it fetches secure upload URLs and uploads the Component to the Serverless Registry.  Once a Component has been uploaded to the Registry, the Registry must do some background processing to publish it, while that's happening, this method polls the API to see when the Component is finished being processed, and then returns the published definition.

**Kind**: instance method of [<code>ServerlessSDK</code>](#ServerlessSDK)  
**Returns**: <code>object</code> - The published Component definition is returned from the Platform API.  

| Param | Type | Description |
| --- | --- | --- |
| componentDefinition | <code>\*</code> | An object containing the properties of a registryPackage. |

<a name="ServerlessSDK+getComponent"></a>

### serverlessSDK.getComponent(componentName, componentVersion) ⇒ <code>object</code>
DEPRECATED: this method is deprecated, use getPackage instead
Get Component

**Kind**: instance method of [<code>ServerlessSDK</code>](#ServerlessSDK)  
**Returns**: <code>object</code> - Returns a Component definition from the Registry.  

| Param | Type | Default | Description |
| --- | --- | --- | --- |
| componentName | <code>\*</code> | <code></code> | The name of the Component within the Registry. |
| componentVersion | <code>\*</code> | <code></code> | The version of a specific Component within the Registry.  If this is not included, this method will always return the latest version. |

<a name="ServerlessSDK+listComponents"></a>

### serverlessSDK.listComponents(orgUid, filter)
DEPRECATED: this method is deprecated, use listPackages instead
List Components

**Kind**: instance method of [<code>ServerlessSDK</code>](#ServerlessSDK)  

| Param | Type | Default | Description |
| --- | --- | --- | --- |
| orgUid | <code>\*</code> | <code></code> | The org ID which components belongs to |
| filter | <code>\*</code> |  | The filter we can apply |

<a name="ServerlessSDK+generateInstanceId"></a>

### serverlessSDK.generateInstanceId(orgUid, stageName, appUid, instanceName) ⇒ <code>object</code>
Returns a properly formatted ID for an Instance

**Kind**: instance method of [<code>ServerlessSDK</code>](#ServerlessSDK)  
**Returns**: <code>object</code> - Returns a properly formatted ID for an Instance  

| Param | Type | Description |
| --- | --- | --- |
| orgUid | <code>\*</code> | The Uid of the Serverless Platform Organization. |
| stageName | <code>\*</code> | The name of the Serverless Platform Stage. |
| appUid | <code>\*</code> | The Uid of the Serverless Platform Application. |
| instanceName | <code>\*</code> | The name of the Serverless Platform Instance. |

<a name="ServerlessSDK+validateInstance"></a>

### serverlessSDK.validateInstance(instanceToValidate) ⇒ <code>object</code>
Validates the properties of an Instance, as well as auto-corrects shortened syntax (e.g. org => orgName)

**Kind**: instance method of [<code>ServerlessSDK</code>](#ServerlessSDK)  
**Returns**: <code>object</code> - Returns a validated, formatted version of the Instance  

| Param | Type | Description |
| --- | --- | --- |
| instanceToValidate | <code>\*</code> | The Serverless Platform Instance you want to validate. |

<a name="ServerlessSDK+createInstance"></a>

### serverlessSDK.createInstance(orgName, stageName, appName, instanceName) ⇒ <code>object</code>
Returns a new Instance as a Javascript object.

**Kind**: instance method of [<code>ServerlessSDK</code>](#ServerlessSDK)  
**Returns**: <code>object</code> - Returns a new Instance definition as a Javascript Object.  

| Param | Type | Default | Description |
| --- | --- | --- | --- |
| orgName | <code>\*</code> | <code></code> | The name of the Serverless Platform Organization. |
| stageName | <code>\*</code> | <code></code> | The name of the Serverless Platform Stage. |
| appName | <code>\*</code> | <code></code> | The name of the Serverless Platform Application. |
| instanceName | <code>\*</code> | <code></code> | The name of the Serverless Platform Instance. |

<a name="ServerlessSDK+getInstance"></a>

### serverlessSDK.getInstance(orgName, stageName, appName, instanceName)
Get an Instance from the Serverless Platform by it's name and the names of its Organization, Stage, Application.

**Kind**: instance method of [<code>ServerlessSDK</code>](#ServerlessSDK)  

| Param | Type | Default | Description |
| --- | --- | --- | --- |
| orgName | <code>\*</code> | <code></code> | The name of the Serverless Platform Organization. |
| stageName | <code>\*</code> | <code></code> | The name of the Serverless Platform Stage. |
| appName | <code>\*</code> | <code></code> | The name of the Serverless Platform Application. |
| instanceName | <code>\*</code> | <code></code> | The name of the Serverless Platform Instance. |

<a name="ServerlessSDK+listInstances"></a>

### serverlessSDK.listInstances(orgName, orgUid)
List all Component Instances within an Org, given an org name or org UId

**Kind**: instance method of [<code>ServerlessSDK</code>](#ServerlessSDK)  

| Param | Type | Default | Description |
| --- | --- | --- | --- |
| orgName | <code>\*</code> | <code></code> | Optional.  Must include either orgName or orgUid. |
| orgUid | <code>\*</code> | <code></code> | Optional.  Must include either orgName or orgUid. |

<a name="ServerlessSDK+run"></a>

### serverlessSDK.run(action, instanceData, credentials, options)
Run an action on a Component Instance.  Is an asynchronous call by default, but you can perform this synchronously if you set `options.sync`.  Please note that synchronous runs have a 24 second timeout limit.  That is not ideal for long operations, and is not recommended for deployments.

**Kind**: instance method of [<code>ServerlessSDK</code>](#ServerlessSDK)  

| Param | Type |
| --- | --- |
| action | <code>\*</code> | 
| instanceData | <code>\*</code> | 
| credentials | <code>\*</code> | 
| options | <code>\*</code> | 

<a name="ServerlessSDK+runFinish"></a>

### serverlessSDK.runFinish(method, instanceData)
Run Finish

**Kind**: instance method of [<code>ServerlessSDK</code>](#ServerlessSDK)  

| Param | Type | Default | Description |
| --- | --- | --- | --- |
| method | <code>string</code> | <code>null</code> | The action that was performed on the component. |
| instanceData | <code>object</code> |  | An object representing your Instance definition. |

<a name="ServerlessSDK+deploy"></a>

### serverlessSDK.deploy()
Performs a 'deploy' action and polls the 'getInstance' endpoint until its 'instanceStatus' reflects a successful deployment, or error.

**Kind**: instance method of [<code>ServerlessSDK</code>](#ServerlessSDK)  
<a name="ServerlessSDK+remove"></a>

### serverlessSDK.remove()
Performs a 'remove' action and polls the 'getInstance' endpoint until its 'instanceStatus' reflects a successful deployment, or error.

**Kind**: instance method of [<code>ServerlessSDK</code>](#ServerlessSDK)  
<a name="ServerlessSDK+startInterceptingLogs"></a>

### serverlessSDK.startInterceptingLogs()
Intercepts console 'log' 'debug' and 'error' methods, and sends their data to the Serverless Platform as an Event, before writing to stdout.

**Kind**: instance method of [<code>ServerlessSDK</code>](#ServerlessSDK)  
<a name="ServerlessSDK+stopInterceptingLogs"></a>

### serverlessSDK.stopInterceptingLogs()
Stop intercepting console methods

**Kind**: instance method of [<code>ServerlessSDK</code>](#ServerlessSDK)  
<a name="ServerlessSDK+paramSet"></a>

### serverlessSDK.paramSet()
CLI set parameters

**Kind**: instance method of [<code>ServerlessSDK</code>](#ServerlessSDK)  
**Param{object}:**: The value of parameters settings  
**Stage{string}:**: Which stage to store  
**App{string}:**: Which app it belongs to  
**Params{object}:**: The param key and param value to store  
<a name="ServerlessSDK+paramList"></a>

### serverlessSDK.paramList()
CLI list parameters

**Kind**: instance method of [<code>ServerlessSDK</code>](#ServerlessSDK)  
**Param{object}:**: The value of parameters settings  
**Stage{string}:**: Which stage to find from  
**App{string}:**: Which app it belongs to  
**Params{array&lt;string&gt;}:**: Which parameters to find out  
<a name="ServerlessSDK+bindRole"></a>

### serverlessSDK.bindRole()
Init user's roles

**Kind**: instance method of [<code>ServerlessSDK</code>](#ServerlessSDK)  
**Param{object}:**: credentials of the user  

## Publishing the SDK

Before publishing the SDK, be sure to run the pre-publish script, which browserifies the code and updates its documentation, by running: `npm run pre-publish` within the `sdk` folder.

* * *

&copy; Serverless Inc.