/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.x.io;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.mysql.cj.api.io.ValueFactory;
import com.mysql.cj.api.result.Row;
import com.mysql.cj.api.x.io.DecoderFunction;
import com.mysql.cj.core.exceptions.DataReadException;
import com.mysql.cj.core.result.Field;
import com.mysql.cj.x.io.XProtocolDecoder;
import com.mysql.cj.x.protobuf.MysqlxResultset;
import java.io.IOException;
import java.util.ArrayList;

public class XProtocolRow
implements Row {
    private ArrayList<Field> metadata;
    private MysqlxResultset.Row rowMessage;
    private boolean wasNull = false;

    public XProtocolRow(ArrayList<Field> metadata, MysqlxResultset.Row rowMessage) {
        this.metadata = metadata;
        this.rowMessage = rowMessage;
    }

    @Override
    public <T> T getValue(int columnIndex, ValueFactory<T> vf) {
        if (columnIndex >= this.metadata.size()) {
            throw new DataReadException("Invalid column");
        }
        Field f = this.metadata.get(columnIndex);
        ByteString byteString = this.rowMessage.getField(columnIndex);
        try {
            if (byteString.size() == 0) {
                T result = vf.createFromNull();
                this.wasNull = result == null;
                return result;
            }
            if (f.getMysqlTypeId() == 8 && f.isUnsigned()) {
                return XProtocolDecoder.instance.decodeUnsignedLong(CodedInputStream.newInstance((byte[])byteString.toByteArray()), vf);
            }
            DecoderFunction decoderFunction = XProtocolDecoder.MYSQL_TYPE_TO_DECODER_FUNCTION.get(f.getMysqlTypeId());
            if (decoderFunction != null) {
                this.wasNull = false;
                return decoderFunction.apply(CodedInputStream.newInstance((byte[])byteString.toByteArray()), vf);
            }
            throw new DataReadException("Unknown MySQL type constant: " + f.getMysqlTypeId());
        }
        catch (IOException ex) {
            throw new DataReadException(ex);
        }
    }

    @Override
    public boolean getNull(int columnIndex) {
        ByteString byteString = this.rowMessage.getField(columnIndex);
        this.wasNull = byteString.size() == 0;
        return this.wasNull;
    }

    @Override
    public boolean wasNull() {
        return this.wasNull;
    }
}

