/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.da.comp.writer2xhtml;

import com.sun.star.awt.XDialog;
import com.sun.star.beans.XPropertySet;
import com.sun.star.uno.XComponentContext;
import org.openoffice.da.comp.w2lcommon.filter.OptionsDialogBase;
import org.openoffice.da.comp.w2lcommon.helper.PropertyHelper;
import org.openoffice.da.comp.writer2xhtml.W2XRegistration;
import org.openoffice.da.comp.writer2xhtml.XhtmlOptionsDialogMath;

public class XhtmlOptionsDialog
extends OptionsDialogBase {
    public static String __serviceName = "org.openoffice.da.writer2xhtml.XhtmlOptionsDialog";
    public static String __implementationName = "org.openoffice.da.comp.writer2xhtml.XhtmlOptionsDialog";

    @Override
    public String getDialogLibraryName() {
        return "W2XDialogs";
    }

    @Override
    public String getDialogName() {
        return "XhtmlOptions";
    }

    @Override
    public String getRegistryPath() {
        return "/org.openoffice.da.Writer2xhtml.Options/XhtmlOptions";
    }

    public XhtmlOptionsDialog(XComponentContext xContext) {
        super(xContext);
        this.xMSF = W2XRegistration.xMultiServiceFactory;
    }

    @Override
    protected void loadSettings(XPropertySet xProps) {
        int nColumnScaling;
        this.loadConfig(xProps);
        this.loadCheckBoxOption(xProps, "ConvertToPx");
        int nScaling = this.loadNumericOption(xProps, "Scaling");
        if (nScaling <= 1) {
            this.setNumericFieldValue("Scaling", 100);
        }
        if ((nColumnScaling = this.loadNumericOption(xProps, "ColumnScaling")) <= 1) {
            this.setNumericFieldValue("ColumnScaling", 100);
        }
        this.loadCheckBoxOption(xProps, "OriginalImageSize");
        this.loadCheckBoxOption(xProps, "Notes");
        this.loadCheckBoxOption(xProps, "UseDublinCore");
        this.loadCheckBoxOption(xProps, "IgnoreHardLineBreaks");
        this.loadCheckBoxOption(xProps, "IgnoreEmptyParagraphs");
        this.loadCheckBoxOption(xProps, "IgnoreDoubleSpaces");
        this.loadCheckBoxOption(xProps, "Split");
        this.loadListBoxOption(xProps, "SplitLevel");
        this.loadListBoxOption(xProps, "RepeatLevels");
        this.loadCheckBoxOption(xProps, "SaveImagesInSubdir");
        this.loadCheckBoxOption(xProps, "UseMathjax");
        this.updateLockedOptions();
        this.enableControls();
    }

    @Override
    protected void saveSettings(XPropertySet xProps, PropertyHelper helper) {
        short nConfig = this.saveConfig(xProps, helper);
        String[] sCoreStyles = new String[]{"Chocolate", "Midnight", "Modernist", "Oldstyle", "Steely", "Swiss", "Traditional", "Ultramarine"};
        switch (nConfig) {
            case 0: {
                helper.put("ConfigURL", "*default.xml");
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                helper.put("ConfigURL", "*cleanxhtml.xml");
                helper.put("custom_stylesheet", "http://www.w3.org/StyleSheets/Core/" + sCoreStyles[nConfig - 1]);
                break;
            }
            case 9: {
                helper.put("ConfigURL", "$(user)/writer2xhtml.xml");
                helper.put("AutoCreate", "true");
                helper.put("TemplateURL", "$(user)/writer2xhtml-template.xhtml");
                helper.put("StyleSheetURL", "$(user)/writer2xhtml-styles.css");
            }
        }
        this.saveCheckBoxOption(xProps, helper, "ConvertToPx", "convert_to_px");
        this.saveNumericOptionAsPercentage(xProps, helper, "Scaling", "scaling");
        this.saveNumericOptionAsPercentage(xProps, helper, "ColumnScaling", "column_scaling");
        this.saveCheckBoxOption(xProps, "OriginalImageSize");
        helper.put("image_size", this.getCheckBoxStateAsBoolean("OriginalImageSize") ? "none" : "absolute");
        this.saveCheckBoxOption(xProps, helper, "Notes", "notes");
        this.saveCheckBoxOption(xProps, helper, "UseDublinCore", "use_dublin_core");
        this.saveCheckBoxOption(xProps, helper, "IgnoreHardLineBreaks", "ignore_hard_line_breaks");
        this.saveCheckBoxOption(xProps, helper, "IgnoreEmptyParagraphs", "ignore_empty_paragraphs");
        this.saveCheckBoxOption(xProps, helper, "IgnoreDoubleSpaces", "ignore_double_spaces");
        boolean bSplit = this.saveCheckBoxOption(xProps, "Split");
        short nSplitLevel = this.saveListBoxOption(xProps, "SplitLevel");
        short nRepeatLevels = this.saveListBoxOption(xProps, "RepeatLevels");
        if (!this.isLocked("split_level")) {
            if (bSplit) {
                helper.put("split_level", Integer.toString(nSplitLevel + 1));
                helper.put("repeat_levels", Integer.toString(nRepeatLevels));
            } else {
                helper.put("split_level", "0");
            }
        }
        this.saveCheckBoxOption(xProps, helper, "SaveImagesInSubdir", "save_images_in_subdir");
        this.saveCheckBoxOption(xProps, helper, "UseMathjax", "use_mathjax");
    }

    @Override
    public boolean callHandlerMethod(XDialog xDialog, Object event, String sMethod) {
        if (sMethod.equals("ConfigChange")) {
            this.updateLockedOptions();
            this.enableControls();
        } else if (sMethod.equals("SplitChange")) {
            this.enableSplitLevel();
        }
        return true;
    }

    @Override
    public String[] getSupportedMethodNames() {
        String[] sNames = new String[]{"ConfigChange", "SplitChange"};
        return sNames;
    }

    private void enableControls() {
        this.setControlEnabled("ScalingLabel", !this.isLocked("scaling"));
        this.setControlEnabled("Scaling", !this.isLocked("scaling"));
        this.setControlEnabled("ColumnScalingLabel", !this.isLocked("column_scaling"));
        this.setControlEnabled("ColumnScaling", !this.isLocked("column_scaling"));
        this.setControlEnabled("ConvertToPx", !this.isLocked("convert_to_px"));
        this.setControlEnabled("OriginalImageSize", !this.isLocked("image_size") && !this.isLocked("original_image_size"));
        this.setControlEnabled("Notes", !this.isLocked("notes"));
        this.setControlEnabled("UseDublinCore", !this.isLocked("use_dublin_core"));
        this.setControlEnabled("IgnoreHardLineBreaks", !this.isLocked("ignore_hard_line_breaks"));
        this.setControlEnabled("IgnoreEmptyParagraphs", !this.isLocked("ignore_empty_paragraphs"));
        this.setControlEnabled("IgnoreDoubleSpaces", !this.isLocked("ignore_double_spaces"));
        boolean bSplit = this.getCheckBoxStateAsBoolean("Split");
        this.setControlEnabled("Split", !this.isLocked("split_level"));
        this.setControlEnabled("SplitLevelLabel", !this.isLocked("split_level") && bSplit);
        this.setControlEnabled("SplitLevel", !this.isLocked("split_level") && bSplit);
        this.setControlEnabled("RepeatLevelsLabel", !this.isLocked("repeat_levels") && !this.isLocked("split_level") && bSplit);
        this.setControlEnabled("RepeatLevels", !this.isLocked("repeat_levels") && !this.isLocked("split_level") && bSplit);
        this.setControlEnabled("SaveImagesInSubdir", !this.isLocked("save_images_in_subdir"));
        this.setControlEnabled("UseMathjax", this instanceof XhtmlOptionsDialogMath && !this.isLocked("use_mathjax"));
    }

    private void enableSplitLevel() {
        if (!this.isLocked("split_level")) {
            boolean bState = this.getCheckBoxStateAsBoolean("Split");
            this.setControlEnabled("SplitLevelLabel", bState);
            this.setControlEnabled("SplitLevel", bState);
            if (!this.isLocked("repeat_levels")) {
                this.setControlEnabled("RepeatLevelsLabel", bState);
                this.setControlEnabled("RepeatLevels", bState);
            }
        }
    }
}

