/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.BackgroundRetained;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingLeaf;
import javax.media.j3d.BoundingLeafRetained;
import javax.media.j3d.Bounds;
import javax.media.j3d.Context;
import javax.media.j3d.EnvironmentSet;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.Group;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.HashKey;
import javax.media.j3d.IllegalSharingException;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.LeafRetained;
import javax.media.j3d.Node;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroupRetained;
import javax.media.j3d.UnorderList;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Color3f;
import javax.vecmath.Tuple3f;

abstract class FogRetained
extends LeafRetained {
    static final int COLOR_CHANGED = 1;
    static final int SCOPE_CHANGED = 2;
    static final int BOUNDS_CHANGED = 4;
    static final int BOUNDINGLEAF_CHANGED = 8;
    static final int INIT_MIRROR = 16;
    static final int CLEAR_MIRROR = 32;
    static final int LAST_DEFINED_BIT = 32;
    Color3f color = new Color3f(0.0f, 0.0f, 0.0f);
    Bounds regionOfInfluence = null;
    BoundingLeafRetained boundingLeaf = null;
    Vector<GroupRetained> scopes = new Vector();
    int isDirty = 65535;
    boolean inImmCtx = false;
    Bounds region = null;
    FogRetained sgFog = null;
    FogRetained mirrorFog = null;
    static final int targetThreads = 4224;
    boolean isScoped = false;
    HashKey tempKey = new HashKey(250);
    UnorderList environmentSets = new UnorderList(1, EnvironmentSet.class);
    boolean isViewScoped = false;
    private double localToVworldScale = 1.0;

    FogRetained() {
        this.localBounds = new BoundingBox((Bounds)null);
    }

    void initColor(Color3f color3f) {
        this.color.set((Tuple3f)color3f);
    }

    void setColor(Color3f color3f) {
        this.color.set((Tuple3f)color3f);
        this.sendMessage(1, new Color3f(color3f));
    }

    void initColor(float f, float f2, float f3) {
        this.color.x = f;
        this.color.y = f2;
        this.color.z = f3;
    }

    void setColor(float f, float f2, float f3) {
        this.initColor(f, f2, f3);
        this.sendMessage(1, new Color3f(f, f2, f3));
    }

    void getColor(Color3f color3f) {
        color3f.set((Tuple3f)this.color);
    }

    void initInfluencingBounds(Bounds bounds) {
        this.regionOfInfluence = bounds != null ? (Bounds)bounds.clone() : null;
        if (this.staticTransform != null) {
            this.regionOfInfluence.transform(this.staticTransform.transform);
        }
    }

    void setInfluencingBounds(Bounds bounds) {
        this.initInfluencingBounds(bounds);
        this.sendMessage(4, bounds != null ? bounds.clone() : null);
    }

    Bounds getInfluencingBounds() {
        Bounds bounds = null;
        if (this.regionOfInfluence != null) {
            bounds = (Bounds)this.regionOfInfluence.clone();
            if (this.staticTransform != null) {
                Transform3D transform3D = this.staticTransform.getInvTransform();
                bounds.transform(transform3D);
            }
        }
        return bounds;
    }

    void initInfluencingBoundingLeaf(BoundingLeaf boundingLeaf) {
        this.boundingLeaf = boundingLeaf != null ? (BoundingLeafRetained)boundingLeaf.retained : null;
    }

    void setInfluencingBoundingLeaf(BoundingLeaf boundingLeaf) {
        if (this.boundingLeaf != null) {
            this.boundingLeaf.mirrorBoundingLeaf.removeUser(this.mirrorFog);
        }
        if (boundingLeaf != null) {
            this.boundingLeaf = (BoundingLeafRetained)boundingLeaf.retained;
            this.boundingLeaf.mirrorBoundingLeaf.addUser(this.mirrorFog);
        } else {
            this.boundingLeaf = null;
        }
        this.sendMessage(8, this.boundingLeaf != null ? this.boundingLeaf.mirrorBoundingLeaf : null);
    }

    BoundingLeaf getInfluencingBoundingLeaf() {
        return this.boundingLeaf != null ? (BoundingLeaf)this.boundingLeaf.source : null;
    }

    void initScope(Group group, int n) {
        this.scopes.setElementAt((GroupRetained)group.retained, n);
    }

    void setScope(Group group, int n) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        Object[] objectArray = new Object[3];
        GroupRetained groupRetained = this.scopes.get(n);
        this.tempKey.reset();
        groupRetained.removeAllNodesForScopedFog(this.mirrorFog, arrayList2, this.tempKey);
        groupRetained = (GroupRetained)group.retained;
        this.initScope(group, n);
        this.tempKey.reset();
        groupRetained.addAllNodesForScopedFog(this.mirrorFog, arrayList, this.tempKey);
        objectArray[0] = arrayList;
        objectArray[1] = arrayList2;
        objectArray[2] = this.scopes.size() > 0 ? Boolean.TRUE : Boolean.FALSE;
        this.sendMessage(2, objectArray);
    }

    void initInsertScope(Node node, int n) {
        GroupRetained groupRetained = (GroupRetained)node.retained;
        groupRetained.setFogScope();
        this.scopes.insertElementAt((GroupRetained)node.retained, n);
    }

    void insertScope(Node node, int n) {
        Object[] objectArray = new Object[3];
        ArrayList arrayList = new ArrayList();
        this.initInsertScope(node, n);
        GroupRetained groupRetained = (GroupRetained)node.retained;
        this.tempKey.reset();
        groupRetained.addAllNodesForScopedFog(this.mirrorFog, arrayList, this.tempKey);
        objectArray[0] = arrayList;
        objectArray[1] = null;
        objectArray[2] = this.scopes.size() > 0 ? Boolean.TRUE : Boolean.FALSE;
        this.sendMessage(2, objectArray);
    }

    void initRemoveScope(int n) {
        GroupRetained groupRetained = this.scopes.elementAt(n);
        this.scopes.removeElementAt(n);
        groupRetained.removeFogScope();
    }

    void removeScope(int n) {
        Object[] objectArray = new Object[3];
        ArrayList arrayList = new ArrayList();
        GroupRetained groupRetained = this.scopes.elementAt(n);
        this.tempKey.reset();
        groupRetained.removeAllNodesForScopedFog(this.mirrorFog, arrayList, this.tempKey);
        this.initRemoveScope(n);
        objectArray[0] = null;
        objectArray[1] = arrayList;
        objectArray[2] = this.scopes.size() > 0 ? Boolean.TRUE : Boolean.FALSE;
        this.sendMessage(2, objectArray);
    }

    Group getScope(int n) {
        return (Group)this.scopes.elementAt((int)n).source;
    }

    Enumeration<Group> getAllScopes() {
        Enumeration<GroupRetained> enumeration = this.scopes.elements();
        Vector<Group> vector = new Vector<Group>(this.scopes.size());
        while (enumeration.hasMoreElements()) {
            vector.add((Group)enumeration.nextElement().source);
        }
        return vector.elements();
    }

    void initAddScope(Group group) {
        GroupRetained groupRetained = (GroupRetained)group.retained;
        this.scopes.addElement(groupRetained);
        groupRetained.setFogScope();
    }

    void addScope(Group group) {
        Object[] objectArray = new Object[3];
        ArrayList arrayList = new ArrayList();
        GroupRetained groupRetained = (GroupRetained)group.retained;
        this.initAddScope(group);
        this.tempKey.reset();
        groupRetained.addAllNodesForScopedFog(this.mirrorFog, arrayList, this.tempKey);
        objectArray[0] = arrayList;
        objectArray[1] = null;
        objectArray[2] = this.scopes.size() > 0 ? Boolean.TRUE : Boolean.FALSE;
        this.sendMessage(2, objectArray);
    }

    int numScopes() {
        return this.scopes.size();
    }

    int indexOfScope(Group group) {
        if (group != null) {
            return this.scopes.indexOf(group.retained);
        }
        return this.scopes.indexOf(null);
    }

    void removeScope(Group group) {
        int n = this.indexOfScope(group);
        if (n >= 0) {
            this.removeScope(n);
        }
    }

    void initRemoveScope(Group group) {
        int n = this.indexOfScope(group);
        if (n >= 0) {
            this.initRemoveScope(n);
        }
    }

    void removeAllScopes() {
        Object[] objectArray = new Object[3];
        ArrayList arrayList = new ArrayList();
        int n = this.scopes.size();
        this.tempKey.reset();
        for (int i = n - 1; i >= 0; --i) {
            GroupRetained groupRetained = this.scopes.elementAt(i);
            groupRetained.removeAllNodesForScopedFog(this.mirrorFog, arrayList, this.tempKey);
            this.initRemoveScope(i);
        }
        objectArray[0] = null;
        objectArray[1] = arrayList;
        objectArray[2] = Boolean.FALSE;
        this.sendMessage(2, objectArray);
    }

    void initRemoveAllScopes() {
        int n = this.scopes.size();
        for (int i = n - 1; i >= 0; --i) {
            this.initRemoveScope(i);
        }
    }

    void setInImmCtx(boolean bl) {
        this.inImmCtx = bl;
    }

    boolean getInImmCtx() {
        return this.inImmCtx;
    }

    boolean isScoped() {
        return this.scopes != null;
    }

    abstract void update(Context var1, double var2);

    void updateImmediateMirrorObject(Object[] objectArray) {
        int n = (Integer)objectArray[1];
        if ((n & 4) != 0) {
            this.mirrorFog.regionOfInfluence = (Bounds)objectArray[2];
            if (this.mirrorFog.boundingLeaf == null) {
                if (objectArray[2] != null) {
                    this.mirrorFog.region = this.mirrorFog.regionOfInfluence.copy(this.mirrorFog.region);
                    this.mirrorFog.region.transform(this.mirrorFog.regionOfInfluence, this.getCurrentLocalToVworld());
                } else {
                    this.mirrorFog.region = null;
                }
            }
        } else if ((n & 8) != 0) {
            this.mirrorFog.boundingLeaf = (BoundingLeafRetained)objectArray[2];
            if (objectArray[2] != null) {
                this.mirrorFog.region = this.mirrorFog.boundingLeaf.transformedRegion;
            } else if (this.mirrorFog.regionOfInfluence != null) {
                this.mirrorFog.region = this.mirrorFog.regionOfInfluence.copy(this.mirrorFog.region);
                this.mirrorFog.region.transform(this.mirrorFog.regionOfInfluence, this.getCurrentLocalToVworld());
            } else {
                this.mirrorFog.region = null;
            }
        } else if ((n & 2) != 0) {
            Shape3DRetained shape3DRetained;
            int n2;
            Object[] objectArray2 = (Object[])objectArray[2];
            ArrayList arrayList = (ArrayList)objectArray2[0];
            ArrayList arrayList2 = (ArrayList)objectArray2[1];
            boolean bl = (Boolean)objectArray2[2];
            if (arrayList != null) {
                this.mirrorFog.isScoped = bl;
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    shape3DRetained = ((GeometryAtom)arrayList.get((int)n2)).source;
                    shape3DRetained.addFog(this.mirrorFog);
                }
            }
            if (arrayList2 != null) {
                this.mirrorFog.isScoped = bl;
                for (n2 = 0; n2 < arrayList2.size(); ++n2) {
                    shape3DRetained = ((GeometryAtom)arrayList2.get((int)n2)).source;
                    shape3DRetained.removeFog(this.mirrorFog);
                }
            }
        }
    }

    @Override
    void updateMirrorObject(Object[] objectArray) {
        int n = (Integer)objectArray[1];
        if ((n & 1) != 0) {
            this.mirrorFog.color.set((Tuple3f)((Color3f)objectArray[2]));
        }
        if ((n & 0x10) != 0) {
            this.mirrorFog.color.set((Tuple3f)((Color3f)objectArray[3]));
        }
    }

    @Override
    void updateBoundingLeaf() {
        if (this.boundingLeaf != null && this.boundingLeaf.switchState.currentSwitchOn) {
            this.region = this.boundingLeaf.transformedRegion;
        } else if (this.regionOfInfluence != null) {
            this.region = this.regionOfInfluence.copy(this.region);
            this.region.transform(this.regionOfInfluence, this.getCurrentLocalToVworld());
        } else {
            this.region = null;
        }
    }

    @Override
    void setLive(SetLiveState setLiveState) {
        if (this.inImmCtx) {
            throw new IllegalSharingException(J3dI18N.getString("FogRetained0"));
        }
        super.doSetLive(setLiveState);
        if (this.inSharedGroup) {
            throw new IllegalSharingException(J3dI18N.getString("FogRetained1"));
        }
        if (this.mirrorFog == null) {
            this.mirrorFog = (FogRetained)this.clone();
            this.mirrorFog.boundingLeaf = null;
            this.mirrorFog.sgFog = this;
        }
        if (this.boundingLeaf != null) {
            this.boundingLeaf.mirrorBoundingLeaf.addUser(this.mirrorFog);
        }
        if (setLiveState.viewScopedNodeList != null && setLiveState.viewLists != null) {
            setLiveState.viewScopedNodeList.add(this.mirrorFog);
            setLiveState.scopedNodesViewList.add(setLiveState.viewLists.get(0));
        } else {
            setLiveState.nodeList.add(this.mirrorFog);
        }
        if (setLiveState.transformTargets != null && setLiveState.transformTargets[0] != null) {
            setLiveState.transformTargets[0].addNode(this.mirrorFog, 1);
            setLiveState.notifyThreads |= 0x2000;
        }
        if (setLiveState.switchTargets != null && setLiveState.switchTargets[0] != null) {
            setLiveState.switchTargets[0].addNode(this.mirrorFog, 1);
        }
        this.mirrorFog.switchState = setLiveState.switchStates.get(0);
        setLiveState.notifyThreads |= 0x1080;
        super.markAsLive();
    }

    void initMirrorObject(Object[] objectArray) {
        Object[] objectArray2 = (Object[])objectArray[2];
        Boolean bl = (Boolean)objectArray2[0];
        ArrayList arrayList = (ArrayList)objectArray2[1];
        BoundingLeafRetained boundingLeafRetained = (BoundingLeafRetained)((Object[])objectArray[4])[0];
        Bounds bounds = (Bounds)((Object[])objectArray[4])[1];
        this.mirrorFog.inBackgroundGroup = (Boolean)((Object[])objectArray[4])[2];
        this.mirrorFog.geometryBackground = (BackgroundRetained)((Object[])objectArray[4])[3];
        for (int i = 0; i < arrayList.size(); ++i) {
            Shape3DRetained shape3DRetained = ((GeometryAtom)arrayList.get((int)i)).source;
            shape3DRetained.addFog(this.mirrorFog);
        }
        this.mirrorFog.isScoped = bl;
        if (boundingLeafRetained != null) {
            this.mirrorFog.boundingLeaf = boundingLeafRetained.mirrorBoundingLeaf;
            this.mirrorFog.region = this.boundingLeaf.transformedRegion;
        } else {
            this.mirrorFog.boundingLeaf = null;
            this.mirrorFog.region = null;
        }
        if (bounds != null) {
            this.mirrorFog.regionOfInfluence = bounds;
            if (this.mirrorFog.region == null) {
                this.mirrorFog.region = (Bounds)this.regionOfInfluence.clone();
                this.mirrorFog.region.transform(this.regionOfInfluence, this.getLastLocalToVworld());
            }
        } else {
            this.mirrorFog.regionOfInfluence = null;
        }
    }

    void clearMirrorObject(Object[] objectArray) {
        ArrayList arrayList = (ArrayList)objectArray[2];
        for (int i = 0; i < arrayList.size(); ++i) {
            Shape3DRetained shape3DRetained = ((GeometryAtom)arrayList.get((int)i)).source;
            shape3DRetained.removeFog(this.mirrorFog);
        }
        this.mirrorFog.isScoped = false;
    }

    @Override
    void clearLive(SetLiveState setLiveState) {
        super.clearLive(setLiveState);
        if (setLiveState.switchTargets != null && setLiveState.switchTargets[0] != null) {
            setLiveState.switchTargets[0].addNode(this.mirrorFog, 1);
        }
        setLiveState.notifyThreads |= 0x1080;
        if (this.mirrorFog.boundingLeaf != null) {
            this.mirrorFog.boundingLeaf.removeUser(this.mirrorFog);
        }
        if (setLiveState.viewScopedNodeList != null && setLiveState.viewLists != null) {
            setLiveState.viewScopedNodeList.add(this.mirrorFog);
            setLiveState.scopedNodesViewList.add(setLiveState.viewLists.get(0));
        } else {
            setLiveState.nodeList.add(this.mirrorFog);
        }
        if (setLiveState.transformTargets != null && setLiveState.transformTargets[0] != null) {
            setLiveState.transformTargets[0].addNode(this.mirrorFog, 1);
            setLiveState.notifyThreads |= 0x2000;
        }
        if (this.scopes.size() > 0) {
            J3dMessage j3dMessage = new J3dMessage();
            j3dMessage.threads = 4096;
            j3dMessage.universe = this.universe;
            j3dMessage.type = 22;
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Integer(32);
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < this.scopes.size(); ++i) {
                GroupRetained groupRetained = this.scopes.get(i);
                this.tempKey.reset();
                groupRetained.removeAllNodesForScopedFog(this.mirrorFog, arrayList, this.tempKey);
            }
            j3dMessage.args[2] = arrayList;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    @Override
    protected Object clone() {
        FogRetained fogRetained = (FogRetained)super.clone();
        fogRetained.color = new Color3f(this.color);
        Bounds bounds = this.getInfluencingBounds();
        if (bounds != null) {
            fogRetained.initInfluencingBounds(bounds);
        }
        fogRetained.scopes = new Vector();
        fogRetained.isDirty = 65535;
        fogRetained.inImmCtx = false;
        fogRetained.region = null;
        fogRetained.sgFog = null;
        fogRetained.mirrorFog = null;
        fogRetained.environmentSets = new UnorderList(1, EnvironmentSet.class);
        return fogRetained;
    }

    @Override
    void updateTransformChange() {
        super.updateTransformChange();
        this.setLocalToVworldScale(this.sgFog.getLastLocalToVworld().getDistanceScale());
    }

    void updateImmediateTransformChange() {
        if (this.boundingLeaf == null && this.regionOfInfluence != null) {
            this.region = this.regionOfInfluence.copy(this.region);
            this.region.transform(this.regionOfInfluence, this.sgFog.getCurrentLocalToVworld());
        }
    }

    final void sendMessage(int n, Object object) {
        J3dMessage j3dMessage = new J3dMessage();
        j3dMessage.threads = 4224;
        j3dMessage.universe = this.universe;
        j3dMessage.type = 22;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(n);
        j3dMessage.args[2] = object;
        VirtualUniverse.mc.processMessage(j3dMessage);
    }

    @Override
    void mergeTransform(TransformGroupRetained transformGroupRetained) {
        super.mergeTransform(transformGroupRetained);
        if (this.regionOfInfluence != null) {
            this.regionOfInfluence.transform(transformGroupRetained.transform);
        }
    }

    @Override
    void getMirrorObjects(ArrayList arrayList, HashKey hashKey) {
        arrayList.add(this.mirrorFog);
    }

    protected void validateDistancesInEc(double d) {
        assert (false) : "subclasses should override this method";
    }

    double getLocalToVworldScale() {
        return this.localToVworldScale;
    }

    void setLocalToVworldScale(double d) {
        this.localToVworldScale = d;
    }
}

