/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp.datasources;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.apache.tomcat.dbcp.dbcp.datasources.PooledConnectionAndInfo;
import org.apache.tomcat.dbcp.dbcp.datasources.PooledConnectionManager;
import org.apache.tomcat.dbcp.dbcp.datasources.UserPassKey;
import org.apache.tomcat.dbcp.pool.KeyedObjectPool;
import org.apache.tomcat.dbcp.pool.KeyedPoolableObjectFactory;

class KeyedCPDSConnectionFactory
implements KeyedPoolableObjectFactory<UserPassKey, PooledConnectionAndInfo>,
ConnectionEventListener,
PooledConnectionManager {
    private static final String NO_KEY_MESSAGE = "close() was called on a Connection, but I have no record of the underlying PooledConnection.";
    private final ConnectionPoolDataSource _cpds;
    private final String _validationQuery;
    private final boolean _rollbackAfterValidation;
    private final KeyedObjectPool<UserPassKey, PooledConnectionAndInfo> _pool;
    private final Set<PooledConnection> validatingSet = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<PooledConnection, PooledConnectionAndInfo> pcMap = new ConcurrentHashMap<PooledConnection, PooledConnectionAndInfo>();

    public KeyedCPDSConnectionFactory(ConnectionPoolDataSource connectionPoolDataSource, KeyedObjectPool<UserPassKey, PooledConnectionAndInfo> keyedObjectPool, String string) {
        this(connectionPoolDataSource, keyedObjectPool, string, false);
    }

    public KeyedCPDSConnectionFactory(ConnectionPoolDataSource connectionPoolDataSource, KeyedObjectPool<UserPassKey, PooledConnectionAndInfo> keyedObjectPool, String string, boolean bl) {
        this._cpds = connectionPoolDataSource;
        this._pool = keyedObjectPool;
        keyedObjectPool.setFactory(this);
        this._validationQuery = string;
        this._rollbackAfterValidation = bl;
    }

    public KeyedObjectPool<UserPassKey, PooledConnectionAndInfo> getPool() {
        return this._pool;
    }

    @Override
    public synchronized PooledConnectionAndInfo makeObject(UserPassKey userPassKey) throws Exception {
        PooledConnectionAndInfo pooledConnectionAndInfo = null;
        PooledConnection pooledConnection = null;
        String string = userPassKey.getUsername();
        String string2 = userPassKey.getPassword();
        pooledConnection = string == null ? this._cpds.getPooledConnection() : this._cpds.getPooledConnection(string, string2);
        if (pooledConnection == null) {
            throw new IllegalStateException("Connection pool data source returned null from getPooledConnection");
        }
        pooledConnection.addConnectionEventListener(this);
        pooledConnectionAndInfo = new PooledConnectionAndInfo(pooledConnection, string, string2);
        this.pcMap.put(pooledConnection, pooledConnectionAndInfo);
        return pooledConnectionAndInfo;
    }

    @Override
    public void destroyObject(UserPassKey userPassKey, PooledConnectionAndInfo pooledConnectionAndInfo) throws Exception {
        PooledConnection pooledConnection = pooledConnectionAndInfo.getPooledConnection();
        pooledConnection.removeConnectionEventListener(this);
        this.pcMap.remove(pooledConnection);
        pooledConnection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean validateObject(UserPassKey userPassKey, PooledConnectionAndInfo pooledConnectionAndInfo) {
        boolean bl = false;
        PooledConnection pooledConnection = pooledConnectionAndInfo.getPooledConnection();
        String string = this._validationQuery;
        if (null == string) return true;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        this.validatingSet.add(pooledConnection);
        try {
            connection = pooledConnection.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string);
            bl = resultSet.next();
            if (!this._rollbackAfterValidation) return bl;
            connection.rollback();
            return bl;
        }
        catch (Exception exception) {
            bl = false;
            return bl;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Throwable throwable) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Throwable throwable) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Throwable throwable) {}
            }
            this.validatingSet.remove(pooledConnection);
        }
    }

    @Override
    public void passivateObject(UserPassKey userPassKey, PooledConnectionAndInfo pooledConnectionAndInfo) {
    }

    @Override
    public void activateObject(UserPassKey userPassKey, PooledConnectionAndInfo pooledConnectionAndInfo) {
    }

    @Override
    public void connectionClosed(ConnectionEvent connectionEvent) {
        PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
        if (!this.validatingSet.contains(pooledConnection)) {
            PooledConnectionAndInfo pooledConnectionAndInfo = this.pcMap.get(pooledConnection);
            if (pooledConnectionAndInfo == null) {
                throw new IllegalStateException(NO_KEY_MESSAGE);
            }
            try {
                this._pool.returnObject(pooledConnectionAndInfo.getUserPassKey(), pooledConnectionAndInfo);
            }
            catch (Exception exception) {
                System.err.println("CLOSING DOWN CONNECTION AS IT COULD NOT BE RETURNED TO THE POOL");
                pooledConnection.removeConnectionEventListener(this);
                try {
                    this._pool.invalidateObject(pooledConnectionAndInfo.getUserPassKey(), pooledConnectionAndInfo);
                }
                catch (Exception exception2) {
                    System.err.println("EXCEPTION WHILE DESTROYING OBJECT " + pooledConnectionAndInfo);
                    exception2.printStackTrace();
                }
            }
        }
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
        if (null != connectionEvent.getSQLException()) {
            System.err.println("CLOSING DOWN CONNECTION DUE TO INTERNAL ERROR (" + connectionEvent.getSQLException() + ")");
        }
        pooledConnection.removeConnectionEventListener(this);
        PooledConnectionAndInfo pooledConnectionAndInfo = this.pcMap.get(pooledConnection);
        if (pooledConnectionAndInfo == null) {
            throw new IllegalStateException(NO_KEY_MESSAGE);
        }
        try {
            this._pool.invalidateObject(pooledConnectionAndInfo.getUserPassKey(), pooledConnectionAndInfo);
        }
        catch (Exception exception) {
            System.err.println("EXCEPTION WHILE DESTROYING OBJECT " + pooledConnectionAndInfo);
            exception.printStackTrace();
        }
    }

    @Override
    public void invalidate(PooledConnection pooledConnection) throws SQLException {
        PooledConnectionAndInfo pooledConnectionAndInfo = this.pcMap.get(pooledConnection);
        if (pooledConnectionAndInfo == null) {
            throw new IllegalStateException(NO_KEY_MESSAGE);
        }
        UserPassKey userPassKey = pooledConnectionAndInfo.getUserPassKey();
        try {
            this._pool.invalidateObject(userPassKey, pooledConnectionAndInfo);
            this._pool.clear(userPassKey);
        }
        catch (Exception exception) {
            throw (SQLException)new SQLException("Error invalidating connection").initCause(exception);
        }
    }

    @Override
    public void setPassword(String string) {
    }

    @Override
    public void closePool(String string) throws SQLException {
        try {
            this._pool.clear(new UserPassKey(string, null));
        }
        catch (Exception exception) {
            throw (SQLException)new SQLException("Error closing connection pool").initCause(exception);
        }
    }
}

