# cal

Use `cal` to display a calendar.

## Flags

* `-y`, `--year`: Display the year column
* `-q`, `--quarter`: Display the quarter column
* `-m`, `--month`: Display the month column
* `--full-year` \<integer>: Display a year-long calendar for the specified year
* `--week-start` \<string>: Display the calendar with the specified day as the first day of the week
* `--month-names`: Display the month names instead of integers

## Examples

```shell
> cal
───┬────────┬────────┬─────────┬───────────┬──────────┬────────┬──────────
 # │ sunday │ monday │ tuesday │ wednesday │ thursday │ friday │ saturday
───┼────────┼────────┼─────────┼───────────┼──────────┼────────┼──────────
 0 │        │        │         │           │          │      1 │        2
 1 │      3 │      4 │       5 │         6 │        7 │      8 │        9
 2 │     10 │     11 │      12 │        13 │       14 │     15 │       16
 3 │     17 │     18 │      19 │        20 │       21 │     22 │       23
 4 │     24 │     25 │      26 │        27 │       28 │     29 │       30
 5 │     31 │        │         │           │          │        │
───┴────────┴────────┴─────────┴───────────┴──────────┴────────┴──────────
```

```shell
> cal -yqm --full-year 2020
────┬──────┬─────────┬───────┬────────┬────────┬─────────┬───────────┬──────────┬────────┬──────────
 #  │ year │ quarter │ month │ sunday │ monday │ tuesday │ wednesday │ thursday │ friday │ saturday
────┼──────┼─────────┼───────┼────────┼────────┼─────────┼───────────┼──────────┼────────┼──────────
  0 │ 2020 │       1 │     1 │        │        │         │         1 │        2 │      3 │        4
  1 │ 2020 │       1 │     1 │      5 │      6 │       7 │         8 │        9 │     10 │       11
  2 │ 2020 │       1 │     1 │     12 │     13 │      14 │        15 │       16 │     17 │       18
  3 │ 2020 │       1 │     1 │     19 │     20 │      21 │        22 │       23 │     24 │       25
  4 │ 2020 │       1 │     1 │     26 │     27 │      28 │        29 │       30 │     31 │
  5 │ 2020 │       1 │     2 │        │        │         │           │          │        │        1
  6 │ 2020 │       1 │     2 │      2 │      3 │       4 │         5 │        6 │      7 │        8
  7 │ 2020 │       1 │     2 │      9 │     10 │      11 │        12 │       13 │     14 │       15
  8 │ 2020 │       1 │     2 │     16 │     17 │      18 │        19 │       20 │     21 │       22
  9 │ 2020 │       1 │     2 │     23 │     24 │      25 │        26 │       27 │     28 │       29
 10 │ 2020 │       1 │     3 │      1 │      2 │       3 │         4 │        5 │      6 │        7
 11 │ 2020 │       1 │     3 │      8 │      9 │      10 │        11 │       12 │     13 │       14
 12 │ 2020 │       1 │     3 │     15 │     16 │      17 │        18 │       19 │     20 │       21
 13 │ 2020 │       1 │     3 │     22 │     23 │      24 │        25 │       26 │     27 │       28
 14 │ 2020 │       1 │     3 │     29 │     30 │      31 │           │          │        │
 15 │ 2020 │       2 │     4 │        │        │         │         1 │        2 │      3 │        4
 16 │ 2020 │       2 │     4 │      5 │      6 │       7 │         8 │        9 │     10 │       11
 17 │ 2020 │       2 │     4 │     12 │     13 │      14 │        15 │       16 │     17 │       18
 18 │ 2020 │       2 │     4 │     19 │     20 │      21 │        22 │       23 │     24 │       25
 19 │ 2020 │       2 │     4 │     26 │     27 │      28 │        29 │       30 │        │
 20 │ 2020 │       2 │     5 │        │        │         │           │          │      1 │        2
 21 │ 2020 │       2 │     5 │      3 │      4 │       5 │         6 │        7 │      8 │        9
 22 │ 2020 │       2 │     5 │     10 │     11 │      12 │        13 │       14 │     15 │       16
 23 │ 2020 │       2 │     5 │     17 │     18 │      19 │        20 │       21 │     22 │       23
 24 │ 2020 │       2 │     5 │     24 │     25 │      26 │        27 │       28 │     29 │       30
 25 │ 2020 │       2 │     5 │     31 │        │         │           │          │        │
 26 │ 2020 │       2 │     6 │        │      1 │       2 │         3 │        4 │      5 │        6
 27 │ 2020 │       2 │     6 │      7 │      8 │       9 │        10 │       11 │     12 │       13
 28 │ 2020 │       2 │     6 │     14 │     15 │      16 │        17 │       18 │     19 │       20
 29 │ 2020 │       2 │     6 │     21 │     22 │      23 │        24 │       25 │     26 │       27
 30 │ 2020 │       2 │     6 │     28 │     29 │      30 │           │          │        │
 31 │ 2020 │       3 │     7 │        │        │         │         1 │        2 │      3 │        4
 32 │ 2020 │       3 │     7 │      5 │      6 │       7 │         8 │        9 │     10 │       11
 33 │ 2020 │       3 │     7 │     12 │     13 │      14 │        15 │       16 │     17 │       18
 34 │ 2020 │       3 │     7 │     19 │     20 │      21 │        22 │       23 │     24 │       25
 35 │ 2020 │       3 │     7 │     26 │     27 │      28 │        29 │       30 │     31 │
 36 │ 2020 │       3 │     8 │        │        │         │           │          │        │        1
 37 │ 2020 │       3 │     8 │      2 │      3 │       4 │         5 │        6 │      7 │        8
 38 │ 2020 │       3 │     8 │      9 │     10 │      11 │        12 │       13 │     14 │       15
 39 │ 2020 │       3 │     8 │     16 │     17 │      18 │        19 │       20 │     21 │       22
 40 │ 2020 │       3 │     8 │     23 │     24 │      25 │        26 │       27 │     28 │       29
 41 │ 2020 │       3 │     8 │     30 │     31 │         │           │          │        │
 42 │ 2020 │       3 │     9 │        │        │       1 │         2 │        3 │      4 │        5
 43 │ 2020 │       3 │     9 │      6 │      7 │       8 │         9 │       10 │     11 │       12
 44 │ 2020 │       3 │     9 │     13 │     14 │      15 │        16 │       17 │     18 │       19
 45 │ 2020 │       3 │     9 │     20 │     21 │      22 │        23 │       24 │     25 │       26
 46 │ 2020 │       3 │     9 │     27 │     28 │      29 │        30 │          │        │
 47 │ 2020 │       4 │    10 │        │        │         │           │        1 │      2 │        3
 48 │ 2020 │       4 │    10 │      4 │      5 │       6 │         7 │        8 │      9 │       10
 49 │ 2020 │       4 │    10 │     11 │     12 │      13 │        14 │       15 │     16 │       17
 50 │ 2020 │       4 │    10 │     18 │     19 │      20 │        21 │       22 │     23 │       24
 51 │ 2020 │       4 │    10 │     25 │     26 │      27 │        28 │       29 │     30 │       31
 52 │ 2020 │       4 │    11 │      1 │      2 │       3 │         4 │        5 │      6 │        7
 53 │ 2020 │       4 │    11 │      8 │      9 │      10 │        11 │       12 │     13 │       14
 54 │ 2020 │       4 │    11 │     15 │     16 │      17 │        18 │       19 │     20 │       21
 55 │ 2020 │       4 │    11 │     22 │     23 │      24 │        25 │       26 │     27 │       28
 56 │ 2020 │       4 │    11 │     29 │     30 │         │           │          │        │
 57 │ 2020 │       4 │    12 │        │        │       1 │         2 │        3 │      4 │        5
 58 │ 2020 │       4 │    12 │      6 │      7 │       8 │         9 │       10 │     11 │       12
 59 │ 2020 │       4 │    12 │     13 │     14 │      15 │        16 │       17 │     18 │       19
 60 │ 2020 │       4 │    12 │     20 │     21 │      22 │        23 │       24 │     25 │       26
 61 │ 2020 │       4 │    12 │     27 │     28 │      29 │        30 │       31 │        │
────┴──────┴─────────┴───────┴────────┴────────┴─────────┴───────────┴──────────┴────────┴──────────
```

```shell
> cal -yqm --full-year 2020 --month-names
────┬──────┬─────────┬───────────┬────────┬────────┬─────────┬───────────┬──────────┬────────┬──────────
 #  │ year │ quarter │ month     │ sunday │ monday │ tuesday │ wednesday │ thursday │ friday │ saturday
────┼──────┼─────────┼───────────┼────────┼────────┼─────────┼───────────┼──────────┼────────┼──────────
  0 │ 2020 │       1 │ january   │        │        │         │         1 │        2 │      3 │        4
  1 │ 2020 │       1 │ january   │      5 │      6 │       7 │         8 │        9 │     10 │       11
  2 │ 2020 │       1 │ january   │     12 │     13 │      14 │        15 │       16 │     17 │       18
  3 │ 2020 │       1 │ january   │     19 │     20 │      21 │        22 │       23 │     24 │       25
  4 │ 2020 │       1 │ january   │     26 │     27 │      28 │        29 │       30 │     31 │
  5 │ 2020 │       1 │ february  │        │        │         │           │          │        │        1
  6 │ 2020 │       1 │ february  │      2 │      3 │       4 │         5 │        6 │      7 │        8
  7 │ 2020 │       1 │ february  │      9 │     10 │      11 │        12 │       13 │     14 │       15
  8 │ 2020 │       1 │ february  │     16 │     17 │      18 │        19 │       20 │     21 │       22
  9 │ 2020 │       1 │ february  │     23 │     24 │      25 │        26 │       27 │     28 │       29
 10 │ 2020 │       1 │ march     │      1 │      2 │       3 │         4 │        5 │      6 │        7
 11 │ 2020 │       1 │ march     │      8 │      9 │      10 │        11 │       12 │     13 │       14
 12 │ 2020 │       1 │ march     │     15 │     16 │      17 │        18 │       19 │     20 │       21
 13 │ 2020 │       1 │ march     │     22 │     23 │      24 │        25 │       26 │     27 │       28
 14 │ 2020 │       1 │ march     │     29 │     30 │      31 │           │          │        │
 15 │ 2020 │       2 │ april     │        │        │         │         1 │        2 │      3 │        4
 16 │ 2020 │       2 │ april     │      5 │      6 │       7 │         8 │        9 │     10 │       11
 17 │ 2020 │       2 │ april     │     12 │     13 │      14 │        15 │       16 │     17 │       18
 18 │ 2020 │       2 │ april     │     19 │     20 │      21 │        22 │       23 │     24 │       25
 19 │ 2020 │       2 │ april     │     26 │     27 │      28 │        29 │       30 │        │
 20 │ 2020 │       2 │ may       │        │        │         │           │          │      1 │        2
 21 │ 2020 │       2 │ may       │      3 │      4 │       5 │         6 │        7 │      8 │        9
 22 │ 2020 │       2 │ may       │     10 │     11 │      12 │        13 │       14 │     15 │       16
 23 │ 2020 │       2 │ may       │     17 │     18 │      19 │        20 │       21 │     22 │       23
 24 │ 2020 │       2 │ may       │     24 │     25 │      26 │        27 │       28 │     29 │       30
 25 │ 2020 │       2 │ may       │     31 │        │         │           │          │        │
 26 │ 2020 │       2 │ june      │        │      1 │       2 │         3 │        4 │      5 │        6
 27 │ 2020 │       2 │ june      │      7 │      8 │       9 │        10 │       11 │     12 │       13
 28 │ 2020 │       2 │ june      │     14 │     15 │      16 │        17 │       18 │     19 │       20
 29 │ 2020 │       2 │ june      │     21 │     22 │      23 │        24 │       25 │     26 │       27
 30 │ 2020 │       2 │ june      │     28 │     29 │      30 │           │          │        │
 31 │ 2020 │       3 │ july      │        │        │         │         1 │        2 │      3 │        4
 32 │ 2020 │       3 │ july      │      5 │      6 │       7 │         8 │        9 │     10 │       11
 33 │ 2020 │       3 │ july      │     12 │     13 │      14 │        15 │       16 │     17 │       18
 34 │ 2020 │       3 │ july      │     19 │     20 │      21 │        22 │       23 │     24 │       25
 35 │ 2020 │       3 │ july      │     26 │     27 │      28 │        29 │       30 │     31 │
 36 │ 2020 │       3 │ august    │        │        │         │           │          │        │        1
 37 │ 2020 │       3 │ august    │      2 │      3 │       4 │         5 │        6 │      7 │        8
 38 │ 2020 │       3 │ august    │      9 │     10 │      11 │        12 │       13 │     14 │       15
 39 │ 2020 │       3 │ august    │     16 │     17 │      18 │        19 │       20 │     21 │       22
 40 │ 2020 │       3 │ august    │     23 │     24 │      25 │        26 │       27 │     28 │       29
 41 │ 2020 │       3 │ august    │     30 │     31 │         │           │          │        │
 42 │ 2020 │       3 │ september │        │        │       1 │         2 │        3 │      4 │        5
 43 │ 2020 │       3 │ september │      6 │      7 │       8 │         9 │       10 │     11 │       12
 44 │ 2020 │       3 │ september │     13 │     14 │      15 │        16 │       17 │     18 │       19
 45 │ 2020 │       3 │ september │     20 │     21 │      22 │        23 │       24 │     25 │       26
 46 │ 2020 │       3 │ september │     27 │     28 │      29 │        30 │          │        │
 47 │ 2020 │       4 │ october   │        │        │         │           │        1 │      2 │        3
 48 │ 2020 │       4 │ october   │      4 │      5 │       6 │         7 │        8 │      9 │       10
 49 │ 2020 │       4 │ october   │     11 │     12 │      13 │        14 │       15 │     16 │       17
 50 │ 2020 │       4 │ october   │     18 │     19 │      20 │        21 │       22 │     23 │       24
 51 │ 2020 │       4 │ october   │     25 │     26 │      27 │        28 │       29 │     30 │       31
 52 │ 2020 │       4 │ november  │      1 │      2 │       3 │         4 │        5 │      6 │        7
 53 │ 2020 │       4 │ november  │      8 │      9 │      10 │        11 │       12 │     13 │       14
 54 │ 2020 │       4 │ november  │     15 │     16 │      17 │        18 │       19 │     20 │       21
 55 │ 2020 │       4 │ november  │     22 │     23 │      24 │        25 │       26 │     27 │       28
 56 │ 2020 │       4 │ november  │     29 │     30 │         │           │          │        │
 57 │ 2020 │       4 │ december  │        │        │       1 │         2 │        3 │      4 │        5
 58 │ 2020 │       4 │ december  │      6 │      7 │       8 │         9 │       10 │     11 │       12
 59 │ 2020 │       4 │ december  │     13 │     14 │      15 │        16 │       17 │     18 │       19
 60 │ 2020 │       4 │ december  │     20 │     21 │      22 │        23 │       24 │     25 │       26
 61 │ 2020 │       4 │ december  │     27 │     28 │      29 │        30 │       31 │        │
────┴──────┴─────────┴───────────┴────────┴────────┴─────────┴───────────┴──────────┴────────┴──────────
```

```shell
> cal -ym --full-year 2303 --month-names | where month == "june"
───┬──────┬───────┬────────┬────────┬─────────┬───────────┬──────────┬────────┬──────────
 # │ year │ month │ sunday │ monday │ tuesday │ wednesday │ thursday │ friday │ saturday
───┼──────┼───────┼────────┼────────┼─────────┼───────────┼──────────┼────────┼──────────
 0 │ 2303 │ june  │        │      1 │       2 │         3 │        4 │      5 │        6
 1 │ 2303 │ june  │      7 │      8 │       9 │        10 │       11 │     12 │       13
 2 │ 2303 │ june  │     14 │     15 │      16 │        17 │       18 │     19 │       20
 3 │ 2303 │ june  │     21 │     22 │      23 │        24 │       25 │     26 │       27
 4 │ 2303 │ june  │     28 │     29 │      30 │           │          │        │
───┴──────┴───────┴────────┴────────┴─────────┴───────────┴──────────┴────────┴──────────
```

```shell
> cal -my --full-year 2020 --month-names | default friday 0 | where friday == 13
───┬──────┬──────────┬────────┬────────┬─────────┬───────────┬──────────┬────────┬──────────
 # │ year │ month    │ sunday │ monday │ tuesday │ wednesday │ thursday │ friday │ saturday
───┼──────┼──────────┼────────┼────────┼─────────┼───────────┼──────────┼────────┼──────────
 0 │ 2020 │ march    │      8 │      9 │      10 │        11 │       12 │     13 │       14
 1 │ 2020 │ november │      8 │      9 │      10 │        11 │       12 │     13 │       14
───┴──────┴──────────┴────────┴────────┴─────────┴───────────┴──────────┴────────┴──────────
```

```shell
> cal -ymq --month-names --week-start monday
───┬──────┬─────────┬───────┬────────┬─────────┬───────────┬──────────┬────────┬──────────┬────────
 # │ year │ quarter │ month │ monday │ tuesday │ wednesday │ thursday │ friday │ saturday │ sunday
───┼──────┼─────────┼───────┼────────┼─────────┼───────────┼──────────┼────────┼──────────┼────────
 0 │ 2020 │       2 │ june  │      1 │       2 │         3 │        4 │      5 │        6 │      7
 1 │ 2020 │       2 │ june  │      8 │       9 │        10 │       11 │     12 │       13 │     14
 2 │ 2020 │       2 │ june  │     15 │      16 │        17 │       18 │     19 │       20 │     21
 3 │ 2020 │       2 │ june  │     22 │      23 │        24 │       25 │     26 │       27 │     28
 4 │ 2020 │       2 │ june  │     29 │      30 │           │          │        │          │
───┴──────┴─────────┴───────┴────────┴─────────┴───────────┴──────────┴────────┴──────────┴────────
```
