/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.named.providers;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.named.support.AdaptedSemaphoreNamedLock;
import org.eclipse.aether.named.support.NamedLockFactorySupport;

@Singleton
@Named(value="semaphore-local")
public class LocalSemaphoreNamedLockFactory
extends NamedLockFactorySupport {
    public static final String NAME = "semaphore-local";

    @Override
    protected AdaptedSemaphoreNamedLock createLock(String name2) {
        return new AdaptedSemaphoreNamedLock(name2, this, new JVMSemaphore());
    }

    private static final class JVMSemaphore
    implements AdaptedSemaphoreNamedLock.AdaptedSemaphore {
        private final Semaphore semaphore = new Semaphore(Integer.MAX_VALUE);

        private JVMSemaphore() {
        }

        @Override
        public boolean tryAcquire(int perms, long time2, TimeUnit unit) throws InterruptedException {
            return this.semaphore.tryAcquire(perms, time2, unit);
        }

        @Override
        public void release(int perms) {
            this.semaphore.release(perms);
        }
    }
}

