/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import javax.swing.JOptionPane;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.data.Photo;
import tim.prune.undo.UndoDeletePhoto;

public class RemovePhotoFunction
extends GenericFunction {
    public RemovePhotoFunction(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.removephoto";
    }

    @Override
    public void begin() {
        Photo photo = this._app.getTrackInfo().getCurrentPhoto();
        if (photo != null) {
            boolean bl = false;
            UndoDeletePhoto undoDeletePhoto = null;
            if (photo.getDataPoint() == null) {
                undoDeletePhoto = new UndoDeletePhoto(photo, this._app.getTrackInfo().getSelection().getCurrentPhotoIndex(), null, -1);
                bl = this._app.getTrackInfo().deleteCurrentPhoto(false);
            } else {
                boolean bl2;
                int n = this._app.getTrackInfo().getTrack().getPointIndex(photo.getDataPoint());
                undoDeletePhoto = new UndoDeletePhoto(photo, this._app.getTrackInfo().getSelection().getCurrentPhotoIndex(), photo.getDataPoint(), n);
                undoDeletePhoto.setAtBoundaryOfSelectedRange(n == this._app.getTrackInfo().getSelection().getStart() || n == this._app.getTrackInfo().getSelection().getEnd());
                int n2 = JOptionPane.showConfirmDialog(this._app.getFrame(), I18nManager.getText("dialog.deletephoto.deletepoint"), I18nManager.getText("dialog.deletephoto.title"), 1);
                boolean bl3 = bl2 = n2 == 0;
                if (n2 == 0 || n2 == 1) {
                    bl = this._app.getTrackInfo().deleteCurrentPhoto(bl2);
                }
            }
            if (bl) {
                this._app.completeFunction(undoDeletePhoto, String.valueOf(photo.getName()) + " " + I18nManager.getText("confirm.media.removed"));
            }
        }
    }
}

