/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import mediathek.config.Config;
import mediathek.config.Daten;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.MemoryUtils;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\b8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\t\u0010\u0002\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\b8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\r\u0010\u0002\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lmediathek/daten/PooledDatabaseConnection;", "", "()V", "dataSource", "Lcom/zaxxer/hikari/HikariDataSource;", "getDataSource", "()Lcom/zaxxer/hikari/HikariDataSource;", "databaseCacheDirectory", "", "getDatabaseCacheDirectory$annotations", "getDatabaseCacheDirectory", "()Ljava/lang/String;", "databaseLocation", "getDatabaseLocation$annotations", "getDatabaseLocation", "MediathekView"})
public final class PooledDatabaseConnection {
    @Nullable
    private static final HikariDataSource dataSource;
    @NotNull
    public static final PooledDatabaseConnection INSTANCE;

    @Nullable
    public final HikariDataSource getDataSource() {
        return dataSource;
    }

    @JvmStatic
    public static /* synthetic */ void getDatabaseLocation$annotations() {
    }

    @NotNull
    public static final String getDatabaseLocation() {
        String strDatabase = Config.isPortableMode() ? Daten.getSettingsDirectory_String() + File.separator + "database" + File.separator : PooledDatabaseConnection.getDatabaseCacheDirectory();
        Path filePath = Paths.get(strDatabase, new String[0]);
        Path absolutePath = filePath.toAbsolutePath();
        return ((Object)absolutePath).toString();
    }

    @JvmStatic
    public static /* synthetic */ void getDatabaseCacheDirectory$annotations() {
    }

    @NotNull
    public static final String getDatabaseCacheDirectory() {
        return SystemUtils.IS_OS_MAC_OSX ? GuiFunktionen.getHomePath() + File.separator + "Library/Caches/MediathekView" + File.separator : Daten.getSettingsDirectory_String() + File.separator;
    }

    private PooledDatabaseConnection() {
    }

    static {
        PooledDatabaseConnection pooledDatabaseConnection;
        INSTANCE = pooledDatabaseConnection = new PooledDatabaseConnection();
        if (MemoryUtils.isLowMemoryEnvironment()) {
            String driverCommand = "jdbc:h2:file:" + PooledDatabaseConnection.getDatabaseLocation() + "/mediathekview;DB_CLOSE_DELAY=-1;DB_CLOSE_ON_EXIT=FALSE;AUTO_RECONNECT=TRUE";
            HikariConfig config = new HikariConfig();
            config.setDataSourceClassName("org.h2.jdbcx.JdbcDataSource");
            config.setAutoCommit(false);
            config.addDataSourceProperty("URL", driverCommand);
            config.setMaximumPoolSize(Runtime.getRuntime().availableProcessors());
            dataSource = new HikariDataSource(config);
        } else {
            dataSource = null;
        }
    }
}

