![openui5](https://openui5.org/images/OpenUI5_new_big_side.png)
=======

[OpenUI5. Build Once. Run on any device.](https://openui5.org)

[![REUSE status](https://api.reuse.software/badge/github.com/SAP/openui5)](https://api.reuse.software/info/github.com/SAP/openui5)


What is it?
-----------
OpenUI5 lets you build enterprise-ready web applications, responsive to all devices, running on almost
any browser of your choice. It's based on JavaScript and follows web standards.
It eases your development with a client-side HTML5 rendering library including a rich set of controls
and supports data binding to different data models (JSON, XML and OData).

And... it's free and open source: OpenUI5 is licensed under the Apache License, Version 2.0 - see [LICENSE.txt](LICENSE.txt).
It also contains third-party open source modules. See the list and respective licenses in [THIRDPARTY.txt](THIRDPARTY.txt).
Third-party module license information is also available in machine-readable format in the [.reuse/dep5](.reuse/dep5) file.

Try it!
-------
Check out our [control playground](https://openui5.hana.ondemand.com/#/controls)
as well as a number of [sample applications](https://openui5.hana.ondemand.com/#/demoapps).

Get it!
-------
Go to the [**download page**](https://openui5.org/releases/) and get the complete UI5 runtime
and the UI5 SDK containing the documentation and many example apps as well as the complete runtime.

Or use [**UI5 Tooling**](https://sap.github.io/ui5-tooling/), the recommended tool for working with OpenUI5! It allows you to manage your framework dependencies and to build optimized packages for all applications, components and libraries. **Get started [here](https://sap.github.io/ui5-tooling/pages/GettingStarted/).**

Get started!
------------
Try the [Hello World](https://openui5.org/), read
the [Developer Guide](https://openui5.hana.ondemand.com/topic)
and refer to the [API Reference](https://openui5.hana.ondemand.com/api).
Use [App Templates](https://openui5.hana.ondemand.com/topic/a460a7348a6c431a8bd967ab9fb8d918) as a foundation for your developments (available in SAP Business Application Studio or here on [GitHub](https://github.com/SAP?q=openui5-worklist-app%20OR%20openui5-masterdetail-app%20OR%20openui5-sample-app)).
Check out the [SAP Community Forum](https://answers.sap.com/tags/500983881501772639608291559920477) for 20,000+ questions and answers and
[stackoverflow](http://stackoverflow.com/questions/tagged/sapui5) (use the tag "sapui5") to discuss code-related problems and questions. Or join the [OpenUI5 Slack](https://ui5-slack-invite.cfapps.eu10.hana.ondemand.com/). 

Hack it!
--------
You can get the sources and build UI5 on your own, please check the [documentation for the UI5 development setup](docs/developing.md). You might then want to understand how [control libraries are structured and controls are developed](docs/controllibraries.md).
Maybe there's a bug you could analyze and fix?

