# -*- coding: utf-8 -*-

"""Data literal storing emoji Spanish names and Unicode codes."""

__all__ = ['EMOJI_UNICODE_SPANISH', 'UNICODE_EMOJI_SPANISH',]


EMOJI_UNICODE_SPANISH = {
    u':cara_sonriendo:': u'\U0001F600',
    u':cara_sonriendo_con_ojos_grandes:': u'\U0001F603',
    u':cara_sonriendo_con_ojos_sonrientes:': u'\U0001F604',
    u':cara_radiante_con_ojos_sonrientes:': u'\U0001F601',
    u':cara_sonriendo_con_los_ojos_cerrados:': u'\U0001F606',
    u':cara_sonriendo_con_sudor_frío:': u'\U0001F605',
    u':cara_revolviéndose_de_la_risa:': u'\U0001F923',
    u':cara_llorando_de_risa:': u'\U0001F602',
    u':cara_sonriendo_ligeramente:': u'\U0001F642',
    u':cara_al_revés:': u'\U0001F643',
    u':cara_guiñando_el_ojo:': u'\U0001F609',
    u':cara_feliz_con_ojos_sonrientes:': u'\U0001F60A',
    u':cara_sonriendo_con_aureola:': u'\U0001F607',
    u':cara_sonriendo_con_corazones:': u'\U0001F970',
    u':cara_sonriendo_con_ojos_de_corazón:': u'\U0001F60D',
    u':cara_sonriendo_con_estrellas:': u'\U0001F929',
    u':cara_lanzando_un_beso:': u'\U0001F618',
    u':cara_besando:': u'\U0001F617',
    u':cara_sonriente:': u'\U0000263A\U0000FE0F',
    u':cara_besando_con_los_ojos_cerrados:': u'\U0001F61A',
    u':cara_besando_con_ojos_sonrientes:': u'\U0001F619',
    u':cara_sonriente_con_lágrima:': u'\U0001F972',
    u':cara_saboreando_comida:': u'\U0001F60B',
    u':cara_sacando_la_lengua:': u'\U0001F61B',
    u':cara_sacando_la_lengua_y_guiñando_un_ojo:': u'\U0001F61C',
    u':cara_de_loco:': u'\U0001F92A',
    u':cara_con_ojos_cerrados_y_lengua_fuera:': u'\U0001F61D',
    u':cara_con_lengua_de_dinero:': u'\U0001F911',
    u':cara_con_manos_abrazando:': u'\U0001F917',
    u':cara_con_mano_sobre_la_boca:': u'\U0001F92D',
    u':cara_pidiendo_silencio:': u'\U0001F92B',
    u':cara_pensativa:': u'\U0001F914',
    u':cara_con_la_boca_cerrada_con_cremallera:': u'\U0001F910',
    u':cara_con_ceja_alzada:': u'\U0001F928',
    u':cara_neutral:': u'\U0001F610',
    u':cara_sin_expresión:': u'\U0001F611',
    u':cara_sin_boca:': u'\U0001F636',
    u':cara_sonriendo_con_superioridad:': u'\U0001F60F',
    u':cara_de_desaprobación:': u'\U0001F612',
    u':cara_con_ojos_en_blanco:': u'\U0001F644',
    u':cara_haciendo_una_mueca:': u'\U0001F62C',
    u':cara_de_mentiroso:': u'\U0001F925',
    u':cara_de_alivio:': u'\U0001F60C',
    u':cara_desanimada:': u'\U0001F614',
    u':cara_de_sueño:': u'\U0001F62A',
    u':cara_babeando:': u'\U0001F924',
    u':cara_durmiendo:': u'\U0001F634',
    u':cara_con_mascarilla_médica:': u'\U0001F637',
    u':cara_con_termómetro:': u'\U0001F912',
    u':cara_con_la_cabeza_vendada:': u'\U0001F915',
    u':cara_de_náuseas:': u'\U0001F922',
    u':cara_vomitando:': u'\U0001F92E',
    u':cara_estornudando:': u'\U0001F927',
    u':cara_con_calor:': u'\U0001F975',
    u':cara_con_frío:': u'\U0001F976',
    u':cara_de_grogui:': u'\U0001F974',
    u':cara_mareada:': u'\U0001F635',
    u':cabeza_explotando:': u'\U0001F92F',
    u':cara_con_sombrero_de_vaquero:': u'\U0001F920',
    u':cara_de_fiesta:': u'\U0001F973',
    u':cara_disfrazada:': u'\U0001F978',
    u':cara_sonriendo_con_gafas_de_sol:': u'\U0001F60E',
    u':cara_de_empollón:': u'\U0001F913',
    u':cara_con_monóculo:': u'\U0001F9D0',
    u':cara_de_confusión:': u'\U0001F615',
    u':cara_preocupada:': u'\U0001F61F',
    u':cara_con_el_ceño_ligeramente_fruncido:': u'\U0001F641',
    u':cara_con_el_ceño_fruncido:': u'\U00002639\U0000FE0F',
    u':cara_con_la_boca_abierta:': u'\U0001F62E',
    u':cara_estupefacta:': u'\U0001F62F',
    u':cara_asombrada:': u'\U0001F632',
    u':cara_sonrojada:': u'\U0001F633',
    u':cara_de_por_favor:': u'\U0001F97A',
    u':cara_con_el_ceño_fruncido_y_la_boca_abierta:': u'\U0001F626',
    u':cara_angustiada:': u'\U0001F627',
    u':cara_asustada:': u'\U0001F628',
    u':cara_con_ansiedad_y_sudor:': u'\U0001F630',
    u':cara_triste_pero_aliviada:': u'\U0001F625',
    u':cara_llorando:': u'\U0001F622',
    u':cara_llorando_fuerte:': u'\U0001F62D',
    u':cara_gritando_de_miedo:': u'\U0001F631',
    u':cara_de_frustración:': u'\U0001F616',
    u':cara_desesperada:': u'\U0001F623',
    u':cara_decepcionada:': u'\U0001F61E',
    u':cara_con_sudor_frío:': u'\U0001F613',
    u':cara_agotada:': u'\U0001F629',
    u':cara_cansada:': u'\U0001F62B',
    u':cara_de_bostezo:': u'\U0001F971',
    u':cara_resoplando:': u'\U0001F624',
    u':cara_cabreada:': u'\U0001F621',
    u':cara_enfadada:': u'\U0001F620',
    u':cara_con_símbolos_en_la_boca:': u'\U0001F92C',
    u':cara_sonriendo_con_cuernos:': u'\U0001F608',
    u':cara_enfadada_con_cuernos:': u'\U0001F47F',
    u':calavera:': u'\U0001F480',
    u':calavera_y_huesos_cruzados:': u'\U00002620\U0000FE0F',
    u':caca_con_ojos:': u'\U0001F4A9',
    u':cara_de_payaso:': u'\U0001F921',
    u':demonio_japonés_oni:': u'\U0001F479',
    u':demonio_japonés_tengu:': u'\U0001F47A',
    u':fantasma:': u'\U0001F47B',
    u':alienígena:': u'\U0001F47D',
    u':monstruo_alienígena:': u'\U0001F47E',
    u':robot:': u'\U0001F916',
    u':gato_sonriendo:': u'\U0001F63A',
    u':gato_sonriendo_con_ojos_sonrientes:': u'\U0001F638',
    u':gato_llorando_de_risa:': u'\U0001F639',
    u':gato_sonriendo_con_ojos_de_corazón:': u'\U0001F63B',
    u':gato_haciendo_una_mueca:': u'\U0001F63C',
    u':gato_besando:': u'\U0001F63D',
    u':gato_asustado:': u'\U0001F640',
    u':gato_llorando:': u'\U0001F63F',
    u':gato_enfadado:': u'\U0001F63E',
    u':mono_con_los_ojos_tapados:': u'\U0001F648',
    u':mono_con_los_oídos_tapados:': u'\U0001F649',
    u':mono_con_la_boca_tapada:': u'\U0001F64A',
    u':marca_de_beso:': u'\U0001F48B',
    u':carta_de_amor:': u'\U0001F48C',
    u':corazón_con_flecha:': u'\U0001F498',
    u':corazón_con_lazo:': u'\U0001F49D',
    u':corazón_brillante:': u'\U0001F496',
    u':corazón_creciente:': u'\U0001F497',
    u':corazón_latiendo:': u'\U0001F493',
    u':corazones_giratorios:': u'\U0001F49E',
    u':dos_corazones:': u'\U0001F495',
    u':adorno_de_corazón:': u'\U0001F49F',
    u':exclamación_de_corazón:': u'\U00002763\U0000FE0F',
    u':corazón_roto:': u'\U0001F494',
    u':corazón_rojo:': u'\U00002764\U0000FE0F',
    u':corazón_naranja:': u'\U0001F9E1',
    u':corazón_amarillo:': u'\U0001F49B',
    u':corazón_verde:': u'\U0001F49A',
    u':corazón_azul:': u'\U0001F499',
    u':corazón_morado:': u'\U0001F49C',
    u':corazón_marrón:': u'\U0001F90E',
    u':corazón_negro:': u'\U0001F5A4',
    u':corazón_blanco:': u'\U0001F90D',
    u':cien_puntos:': u'\U0001F4AF',
    u':símbolo_de_enfado:': u'\U0001F4A2',
    u':colisión:': u'\U0001F4A5',
    u':símbolo_de_mareo:': u'\U0001F4AB',
    u':gotas_de_sudor:': u'\U0001F4A6',
    u':salir_corriendo:': u'\U0001F4A8',
    u':agujero:': u'\U0001F573\U0000FE0F',
    u':bomba:': u'\U0001F4A3',
    u':bocadillo_de_diálogo:': u'\U0001F4AC',
    u':ojo_en_bocadillo_de_texto:': u'\U0001F441\U0000FE0F\U0000200D\U0001F5E8\U0000FE0F',
    u':bocadillo_de_diálogo_por_la_izquierda:': u'\U0001F5E8\U0000FE0F',
    u':bocadillo_de_enfado_por_la_derecha:': u'\U0001F5EF\U0000FE0F',
    u':bocadillo_de_pensamiento:': u'\U0001F4AD',
    u':símbolo_de_sueño:': u'\U0001F4A4',
    u':mano_saludando:': u'\U0001F44B',
    u':mano_saludando_tono_de_piel_claro:': u'\U0001F44B\U0001F3FB',
    u':mano_saludando_tono_de_piel_claro_medio:': u'\U0001F44B\U0001F3FC',
    u':mano_saludando_tono_de_piel_medio:': u'\U0001F44B\U0001F3FD',
    u':mano_saludando_tono_de_piel_oscuro_medio:': u'\U0001F44B\U0001F3FE',
    u':mano_saludando_tono_de_piel_oscuro:': u'\U0001F44B\U0001F3FF',
    u':dorso_de_la_mano:': u'\U0001F91A',
    u':dorso_de_la_mano_tono_de_piel_claro:': u'\U0001F91A\U0001F3FB',
    u':dorso_de_la_mano_tono_de_piel_claro_medio:': u'\U0001F91A\U0001F3FC',
    u':dorso_de_la_mano_tono_de_piel_medio:': u'\U0001F91A\U0001F3FD',
    u':dorso_de_la_mano_tono_de_piel_oscuro_medio:': u'\U0001F91A\U0001F3FE',
    u':dorso_de_la_mano_tono_de_piel_oscuro:': u'\U0001F91A\U0001F3FF',
    u':mano_abierta:': u'\U0001F590\U0000FE0F',
    u':mano_abierta_tono_de_piel_claro:': u'\U0001F590\U0001F3FB',
    u':mano_abierta_tono_de_piel_claro_medio:': u'\U0001F590\U0001F3FC',
    u':mano_abierta_tono_de_piel_medio:': u'\U0001F590\U0001F3FD',
    u':mano_abierta_tono_de_piel_oscuro_medio:': u'\U0001F590\U0001F3FE',
    u':mano_abierta_tono_de_piel_oscuro:': u'\U0001F590\U0001F3FF',
    u':mano_levantada:': u'\U0000270B',
    u':mano_levantada_tono_de_piel_claro:': u'\U0000270B\U0001F3FB',
    u':mano_levantada_tono_de_piel_claro_medio:': u'\U0000270B\U0001F3FC',
    u':mano_levantada_tono_de_piel_medio:': u'\U0000270B\U0001F3FD',
    u':mano_levantada_tono_de_piel_oscuro_medio:': u'\U0000270B\U0001F3FE',
    u':mano_levantada_tono_de_piel_oscuro:': u'\U0000270B\U0001F3FF',
    u':saludo_vulcano:': u'\U0001F596',
    u':saludo_vulcano_tono_de_piel_claro:': u'\U0001F596\U0001F3FB',
    u':saludo_vulcano_tono_de_piel_claro_medio:': u'\U0001F596\U0001F3FC',
    u':saludo_vulcano_tono_de_piel_medio:': u'\U0001F596\U0001F3FD',
    u':saludo_vulcano_tono_de_piel_oscuro_medio:': u'\U0001F596\U0001F3FE',
    u':saludo_vulcano_tono_de_piel_oscuro:': u'\U0001F596\U0001F3FF',
    u':señal_de_aprobación_con_la_mano:': u'\U0001F44C',
    u':señal_de_aprobación_con_la_mano_tono_de_piel_claro:': u'\U0001F44C\U0001F3FB',
    u':señal_de_aprobación_con_la_mano_tono_de_piel_claro_medio:': u'\U0001F44C\U0001F3FC',
    u':señal_de_aprobación_con_la_mano_tono_de_piel_medio:': u'\U0001F44C\U0001F3FD',
    u':señal_de_aprobación_con_la_mano_tono_de_piel_oscuro_medio:': u'\U0001F44C\U0001F3FE',
    u':señal_de_aprobación_con_la_mano_tono_de_piel_oscuro:': u'\U0001F44C\U0001F3FF',
    u':dedos_juntos_apuntando_hacia_arriba:': u'\U0001F90C',
    u':dedos_juntos_apuntando_hacia_arriba_tono_de_piel_claro:': u'\U0001F90C\U0001F3FB',
    u':dedos_juntos_apuntando_hacia_arriba_tono_de_piel_claro_medio:': u'\U0001F90C\U0001F3FC',
    u':dedos_juntos_apuntando_hacia_arriba_tono_de_piel_medio:': u'\U0001F90C\U0001F3FD',
    u':dedos_juntos_apuntando_hacia_arriba_tono_de_piel_oscuro_medio:': u'\U0001F90C\U0001F3FE',
    u':dedos_juntos_apuntando_hacia_arriba_tono_de_piel_oscuro:': u'\U0001F90C\U0001F3FF',
    u':mano_pellizcando:': u'\U0001F90F',
    u':mano_pellizcando_tono_de_piel_claro:': u'\U0001F90F\U0001F3FB',
    u':mano_pellizcando_tono_de_piel_claro_medio:': u'\U0001F90F\U0001F3FC',
    u':mano_pellizcando_tono_de_piel_medio:': u'\U0001F90F\U0001F3FD',
    u':mano_pellizcando_tono_de_piel_oscuro_medio:': u'\U0001F90F\U0001F3FE',
    u':mano_pellizcando_tono_de_piel_oscuro:': u'\U0001F90F\U0001F3FF',
    u':mano_con_señal_de_victoria:': u'\U0000270C',
    u':mano_con_señal_de_victoria_selector:': u'\U0000270C\U0000FE0F',
    u':mano_con_señal_de_victoria_tono_de_piel_claro:': u'\U0000270C\U0001F3FB',
    u':mano_con_señal_de_victoria_tono_de_piel_claro_medio:': u'\U0000270C\U0001F3FC',
    u':mano_con_señal_de_victoria_tono_de_piel_medio:': u'\U0000270C\U0001F3FD',
    u':mano_con_señal_de_victoria_tono_de_piel_oscuro_medio:': u'\U0000270C\U0001F3FE',
    u':mano_con_señal_de_victoria_tono_de_piel_oscuro:': u'\U0000270C\U0001F3FF',
    u':dedos_cruzados:': u'\U0001F91E',
    u':dedos_cruzados_tono_de_piel_claro:': u'\U0001F91E\U0001F3FB',
    u':dedos_cruzados_tono_de_piel_claro_medio:': u'\U0001F91E\U0001F3FC',
    u':dedos_cruzados_tono_de_piel_medio:': u'\U0001F91E\U0001F3FD',
    u':dedos_cruzados_tono_de_piel_oscuro_medio:': u'\U0001F91E\U0001F3FE',
    u':dedos_cruzados_tono_de_piel_oscuro:': u'\U0001F91E\U0001F3FF',
    u':gesto_de_te_quiero:': u'\U0001F91F',
    u':gesto_de_te_quiero_tono_de_piel_claro:': u'\U0001F91F\U0001F3FB',
    u':gesto_de_te_quiero_tono_de_piel_claro_medio:': u'\U0001F91F\U0001F3FC',
    u':gesto_de_te_quiero_tono_de_piel_medio:': u'\U0001F91F\U0001F3FD',
    u':gesto_de_te_quiero_tono_de_piel_oscuro_medio:': u'\U0001F91F\U0001F3FE',
    u':gesto_de_te_quiero_tono_de_piel_oscuro:': u'\U0001F91F\U0001F3FF',
    u':mano_haciendo_el_signo_de_cuernos:': u'\U0001F918',
    u':mano_haciendo_el_signo_de_cuernos_tono_de_piel_claro:': u'\U0001F918\U0001F3FB',
    u':mano_haciendo_el_signo_de_cuernos_tono_de_piel_claro_medio:': u'\U0001F918\U0001F3FC',
    u':mano_haciendo_el_signo_de_cuernos_tono_de_piel_medio:': u'\U0001F918\U0001F3FD',
    u':mano_haciendo_el_signo_de_cuernos_tono_de_piel_oscuro_medio:': u'\U0001F918\U0001F3FE',
    u':mano_haciendo_el_signo_de_cuernos_tono_de_piel_oscuro:': u'\U0001F918\U0001F3FF',
    u':mano_haciendo_el_gesto_de_llamar:': u'\U0001F919',
    u':mano_haciendo_el_gesto_de_llamar_tono_de_piel_claro:': u'\U0001F919\U0001F3FB',
    u':mano_haciendo_el_gesto_de_llamar_tono_de_piel_claro_medio:': u'\U0001F919\U0001F3FC',
    u':mano_haciendo_el_gesto_de_llamar_tono_de_piel_medio:': u'\U0001F919\U0001F3FD',
    u':mano_haciendo_el_gesto_de_llamar_tono_de_piel_oscuro_medio:': u'\U0001F919\U0001F3FE',
    u':mano_haciendo_el_gesto_de_llamar_tono_de_piel_oscuro:': u'\U0001F919\U0001F3FF',
    u':dorso_de_mano_con_índice_a_la_izquierda:': u'\U0001F448',
    u':dorso_de_mano_con_índice_a_la_izquierda_tono_de_piel_claro:': u'\U0001F448\U0001F3FB',
    u':dorso_de_mano_con_índice_a_la_izquierda_tono_de_piel_claro_medio:': u'\U0001F448\U0001F3FC',
    u':dorso_de_mano_con_índice_a_la_izquierda_tono_de_piel_medio:': u'\U0001F448\U0001F3FD',
    u':dorso_de_mano_con_índice_a_la_izquierda_tono_de_piel_oscuro_medio:': u'\U0001F448\U0001F3FE',
    u':dorso_de_mano_con_índice_a_la_izquierda_tono_de_piel_oscuro:': u'\U0001F448\U0001F3FF',
    u':dorso_de_mano_con_índice_a_la_derecha:': u'\U0001F449',
    u':dorso_de_mano_con_índice_a_la_derecha_tono_de_piel_claro:': u'\U0001F449\U0001F3FB',
    u':dorso_de_mano_con_índice_a_la_derecha_tono_de_piel_claro_medio:': u'\U0001F449\U0001F3FC',
    u':dorso_de_mano_con_índice_a_la_derecha_tono_de_piel_medio:': u'\U0001F449\U0001F3FD',
    u':dorso_de_mano_con_índice_a_la_derecha_tono_de_piel_oscuro_medio:': u'\U0001F449\U0001F3FE',
    u':dorso_de_mano_con_índice_a_la_derecha_tono_de_piel_oscuro:': u'\U0001F449\U0001F3FF',
    u':dorso_de_mano_con_índice_hacia_arriba:': u'\U0001F446',
    u':dorso_de_mano_con_índice_hacia_arriba_tono_de_piel_claro:': u'\U0001F446\U0001F3FB',
    u':dorso_de_mano_con_índice_hacia_arriba_tono_de_piel_claro_medio:': u'\U0001F446\U0001F3FC',
    u':dorso_de_mano_con_índice_hacia_arriba_tono_de_piel_medio:': u'\U0001F446\U0001F3FD',
    u':dorso_de_mano_con_índice_hacia_arriba_tono_de_piel_oscuro_medio:': u'\U0001F446\U0001F3FE',
    u':dorso_de_mano_con_índice_hacia_arriba_tono_de_piel_oscuro:': u'\U0001F446\U0001F3FF',
    u':dedo_corazón_hacia_arriba:': u'\U0001F595',
    u':dedo_corazón_hacia_arriba_tono_de_piel_claro:': u'\U0001F595\U0001F3FB',
    u':dedo_corazón_hacia_arriba_tono_de_piel_claro_medio:': u'\U0001F595\U0001F3FC',
    u':dedo_corazón_hacia_arriba_tono_de_piel_medio:': u'\U0001F595\U0001F3FD',
    u':dedo_corazón_hacia_arriba_tono_de_piel_oscuro_medio:': u'\U0001F595\U0001F3FE',
    u':dedo_corazón_hacia_arriba_tono_de_piel_oscuro:': u'\U0001F595\U0001F3FF',
    u':dorso_de_mano_con_índice_hacia_abajo:': u'\U0001F447',
    u':dorso_de_mano_con_índice_hacia_abajo_tono_de_piel_claro:': u'\U0001F447\U0001F3FB',
    u':dorso_de_mano_con_índice_hacia_abajo_tono_de_piel_claro_medio:': u'\U0001F447\U0001F3FC',
    u':dorso_de_mano_con_índice_hacia_abajo_tono_de_piel_medio:': u'\U0001F447\U0001F3FD',
    u':dorso_de_mano_con_índice_hacia_abajo_tono_de_piel_oscuro_medio:': u'\U0001F447\U0001F3FE',
    u':dorso_de_mano_con_índice_hacia_abajo_tono_de_piel_oscuro:': u'\U0001F447\U0001F3FF',
    u':dedo_índice_hacia_arriba:': u'\U0000261D',
    u':dedo_índice_hacia_arriba_selector:': u'\U0000261D\U0000FE0F',
    u':dedo_índice_hacia_arriba_tono_de_piel_claro:': u'\U0000261D\U0001F3FB',
    u':dedo_índice_hacia_arriba_tono_de_piel_claro_medio:': u'\U0000261D\U0001F3FC',
    u':dedo_índice_hacia_arriba_tono_de_piel_medio:': u'\U0000261D\U0001F3FD',
    u':dedo_índice_hacia_arriba_tono_de_piel_oscuro_medio:': u'\U0000261D\U0001F3FE',
    u':dedo_índice_hacia_arriba_tono_de_piel_oscuro:': u'\U0000261D\U0001F3FF',
    u':pulgar_hacia_arriba:': u'\U0001F44D',
    u':pulgar_hacia_arriba_tono_de_piel_claro:': u'\U0001F44D\U0001F3FB',
    u':pulgar_hacia_arriba_tono_de_piel_claro_medio:': u'\U0001F44D\U0001F3FC',
    u':pulgar_hacia_arriba_tono_de_piel_medio:': u'\U0001F44D\U0001F3FD',
    u':pulgar_hacia_arriba_tono_de_piel_oscuro_medio:': u'\U0001F44D\U0001F3FE',
    u':pulgar_hacia_arriba_tono_de_piel_oscuro:': u'\U0001F44D\U0001F3FF',
    u':pulgar_hacia_abajo:': u'\U0001F44E',
    u':pulgar_hacia_abajo_tono_de_piel_claro:': u'\U0001F44E\U0001F3FB',
    u':pulgar_hacia_abajo_tono_de_piel_claro_medio:': u'\U0001F44E\U0001F3FC',
    u':pulgar_hacia_abajo_tono_de_piel_medio:': u'\U0001F44E\U0001F3FD',
    u':pulgar_hacia_abajo_tono_de_piel_oscuro_medio:': u'\U0001F44E\U0001F3FE',
    u':pulgar_hacia_abajo_tono_de_piel_oscuro:': u'\U0001F44E\U0001F3FF',
    u':puño_en_alto:': u'\U0000270A',
    u':puño_en_alto_tono_de_piel_claro:': u'\U0000270A\U0001F3FB',
    u':puño_en_alto_tono_de_piel_claro_medio:': u'\U0000270A\U0001F3FC',
    u':puño_en_alto_tono_de_piel_medio:': u'\U0000270A\U0001F3FD',
    u':puño_en_alto_tono_de_piel_oscuro_medio:': u'\U0000270A\U0001F3FE',
    u':puño_en_alto_tono_de_piel_oscuro:': u'\U0000270A\U0001F3FF',
    u':puño_cerrado:': u'\U0001F44A',
    u':puño_cerrado_tono_de_piel_claro:': u'\U0001F44A\U0001F3FB',
    u':puño_cerrado_tono_de_piel_claro_medio:': u'\U0001F44A\U0001F3FC',
    u':puño_cerrado_tono_de_piel_medio:': u'\U0001F44A\U0001F3FD',
    u':puño_cerrado_tono_de_piel_oscuro_medio:': u'\U0001F44A\U0001F3FE',
    u':puño_cerrado_tono_de_piel_oscuro:': u'\U0001F44A\U0001F3FF',
    u':puño_hacia_la_izquierda:': u'\U0001F91B',
    u':puño_hacia_la_izquierda_tono_de_piel_claro:': u'\U0001F91B\U0001F3FB',
    u':puño_hacia_la_izquierda_tono_de_piel_claro_medio:': u'\U0001F91B\U0001F3FC',
    u':puño_hacia_la_izquierda_tono_de_piel_medio:': u'\U0001F91B\U0001F3FD',
    u':puño_hacia_la_izquierda_tono_de_piel_oscuro_medio:': u'\U0001F91B\U0001F3FE',
    u':puño_hacia_la_izquierda_tono_de_piel_oscuro:': u'\U0001F91B\U0001F3FF',
    u':puño_hacia_la_derecha:': u'\U0001F91C',
    u':puño_hacia_la_derecha_tono_de_piel_claro:': u'\U0001F91C\U0001F3FB',
    u':puño_hacia_la_derecha_tono_de_piel_claro_medio:': u'\U0001F91C\U0001F3FC',
    u':puño_hacia_la_derecha_tono_de_piel_medio:': u'\U0001F91C\U0001F3FD',
    u':puño_hacia_la_derecha_tono_de_piel_oscuro_medio:': u'\U0001F91C\U0001F3FE',
    u':puño_hacia_la_derecha_tono_de_piel_oscuro:': u'\U0001F91C\U0001F3FF',
    u':manos_aplaudiendo:': u'\U0001F44F',
    u':manos_aplaudiendo_tono_de_piel_claro:': u'\U0001F44F\U0001F3FB',
    u':manos_aplaudiendo_tono_de_piel_claro_medio:': u'\U0001F44F\U0001F3FC',
    u':manos_aplaudiendo_tono_de_piel_medio:': u'\U0001F44F\U0001F3FD',
    u':manos_aplaudiendo_tono_de_piel_oscuro_medio:': u'\U0001F44F\U0001F3FE',
    u':manos_aplaudiendo_tono_de_piel_oscuro:': u'\U0001F44F\U0001F3FF',
    u':manos_levantadas_celebrando:': u'\U0001F64C',
    u':manos_levantadas_celebrando_tono_de_piel_claro:': u'\U0001F64C\U0001F3FB',
    u':manos_levantadas_celebrando_tono_de_piel_claro_medio:': u'\U0001F64C\U0001F3FC',
    u':manos_levantadas_celebrando_tono_de_piel_medio:': u'\U0001F64C\U0001F3FD',
    u':manos_levantadas_celebrando_tono_de_piel_oscuro_medio:': u'\U0001F64C\U0001F3FE',
    u':manos_levantadas_celebrando_tono_de_piel_oscuro:': u'\U0001F64C\U0001F3FF',
    u':manos_abiertas:': u'\U0001F450',
    u':manos_abiertas_tono_de_piel_claro:': u'\U0001F450\U0001F3FB',
    u':manos_abiertas_tono_de_piel_claro_medio:': u'\U0001F450\U0001F3FC',
    u':manos_abiertas_tono_de_piel_medio:': u'\U0001F450\U0001F3FD',
    u':manos_abiertas_tono_de_piel_oscuro_medio:': u'\U0001F450\U0001F3FE',
    u':manos_abiertas_tono_de_piel_oscuro:': u'\U0001F450\U0001F3FF',
    u':palmas_hacia_arriba_juntas:': u'\U0001F932',
    u':palmas_hacia_arriba_juntas_tono_de_piel_claro:': u'\U0001F932\U0001F3FB',
    u':palmas_hacia_arriba_juntas_tono_de_piel_claro_medio:': u'\U0001F932\U0001F3FC',
    u':palmas_hacia_arriba_juntas_tono_de_piel_medio:': u'\U0001F932\U0001F3FD',
    u':palmas_hacia_arriba_juntas_tono_de_piel_oscuro_medio:': u'\U0001F932\U0001F3FE',
    u':palmas_hacia_arriba_juntas_tono_de_piel_oscuro:': u'\U0001F932\U0001F3FF',
    u':apretón_de_manos:': u'\U0001F91D',
    u':manos_en_oración:': u'\U0001F64F',
    u':manos_en_oración_tono_de_piel_claro:': u'\U0001F64F\U0001F3FB',
    u':manos_en_oración_tono_de_piel_claro_medio:': u'\U0001F64F\U0001F3FC',
    u':manos_en_oración_tono_de_piel_medio:': u'\U0001F64F\U0001F3FD',
    u':manos_en_oración_tono_de_piel_oscuro_medio:': u'\U0001F64F\U0001F3FE',
    u':manos_en_oración_tono_de_piel_oscuro:': u'\U0001F64F\U0001F3FF',
    u':mano_escribiendo:': u'\U0000270D\U0000FE0F',
    u':mano_escribiendo_tono_de_piel_claro:': u'\U0000270D\U0001F3FB',
    u':mano_escribiendo_tono_de_piel_claro_medio:': u'\U0000270D\U0001F3FC',
    u':mano_escribiendo_tono_de_piel_medio:': u'\U0000270D\U0001F3FD',
    u':mano_escribiendo_tono_de_piel_oscuro_medio:': u'\U0000270D\U0001F3FE',
    u':mano_escribiendo_tono_de_piel_oscuro:': u'\U0000270D\U0001F3FF',
    u':pintarse_las_uñas:': u'\U0001F485',
    u':pintarse_las_uñas_tono_de_piel_claro:': u'\U0001F485\U0001F3FB',
    u':pintarse_las_uñas_tono_de_piel_claro_medio:': u'\U0001F485\U0001F3FC',
    u':pintarse_las_uñas_tono_de_piel_medio:': u'\U0001F485\U0001F3FD',
    u':pintarse_las_uñas_tono_de_piel_oscuro_medio:': u'\U0001F485\U0001F3FE',
    u':pintarse_las_uñas_tono_de_piel_oscuro:': u'\U0001F485\U0001F3FF',
    u':selfi:': u'\U0001F933',
    u':selfi_tono_de_piel_claro:': u'\U0001F933\U0001F3FB',
    u':selfi_tono_de_piel_claro_medio:': u'\U0001F933\U0001F3FC',
    u':selfi_tono_de_piel_medio:': u'\U0001F933\U0001F3FD',
    u':selfi_tono_de_piel_oscuro_medio:': u'\U0001F933\U0001F3FE',
    u':selfi_tono_de_piel_oscuro:': u'\U0001F933\U0001F3FF',
    u':bíceps_flexionado:': u'\U0001F4AA',
    u':bíceps_flexionado_tono_de_piel_claro:': u'\U0001F4AA\U0001F3FB',
    u':bíceps_flexionado_tono_de_piel_claro_medio:': u'\U0001F4AA\U0001F3FC',
    u':bíceps_flexionado_tono_de_piel_medio:': u'\U0001F4AA\U0001F3FD',
    u':bíceps_flexionado_tono_de_piel_oscuro_medio:': u'\U0001F4AA\U0001F3FE',
    u':bíceps_flexionado_tono_de_piel_oscuro:': u'\U0001F4AA\U0001F3FF',
    u':brazo_mecánico:': u'\U0001F9BE',
    u':pierna_mecánica:': u'\U0001F9BF',
    u':pierna:': u'\U0001F9B5',
    u':pierna_tono_de_piel_claro:': u'\U0001F9B5\U0001F3FB',
    u':pierna_tono_de_piel_claro_medio:': u'\U0001F9B5\U0001F3FC',
    u':pierna_tono_de_piel_medio:': u'\U0001F9B5\U0001F3FD',
    u':pierna_tono_de_piel_oscuro_medio:': u'\U0001F9B5\U0001F3FE',
    u':pierna_tono_de_piel_oscuro:': u'\U0001F9B5\U0001F3FF',
    u':pie:': u'\U0001F9B6',
    u':pie_tono_de_piel_claro:': u'\U0001F9B6\U0001F3FB',
    u':pie_tono_de_piel_claro_medio:': u'\U0001F9B6\U0001F3FC',
    u':pie_tono_de_piel_medio:': u'\U0001F9B6\U0001F3FD',
    u':pie_tono_de_piel_oscuro_medio:': u'\U0001F9B6\U0001F3FE',
    u':pie_tono_de_piel_oscuro:': u'\U0001F9B6\U0001F3FF',
    u':oreja:': u'\U0001F442',
    u':oreja_tono_de_piel_claro:': u'\U0001F442\U0001F3FB',
    u':oreja_tono_de_piel_claro_medio:': u'\U0001F442\U0001F3FC',
    u':oreja_tono_de_piel_medio:': u'\U0001F442\U0001F3FD',
    u':oreja_tono_de_piel_oscuro_medio:': u'\U0001F442\U0001F3FE',
    u':oreja_tono_de_piel_oscuro:': u'\U0001F442\U0001F3FF',
    u':oreja_con_audífono:': u'\U0001F9BB',
    u':oreja_con_audífono_tono_de_piel_claro:': u'\U0001F9BB\U0001F3FB',
    u':oreja_con_audífono_tono_de_piel_claro_medio:': u'\U0001F9BB\U0001F3FC',
    u':oreja_con_audífono_tono_de_piel_medio:': u'\U0001F9BB\U0001F3FD',
    u':oreja_con_audífono_tono_de_piel_oscuro_medio:': u'\U0001F9BB\U0001F3FE',
    u':oreja_con_audífono_tono_de_piel_oscuro:': u'\U0001F9BB\U0001F3FF',
    u':nariz:': u'\U0001F443',
    u':nariz_tono_de_piel_claro:': u'\U0001F443\U0001F3FB',
    u':nariz_tono_de_piel_claro_medio:': u'\U0001F443\U0001F3FC',
    u':nariz_tono_de_piel_medio:': u'\U0001F443\U0001F3FD',
    u':nariz_tono_de_piel_oscuro_medio:': u'\U0001F443\U0001F3FE',
    u':nariz_tono_de_piel_oscuro:': u'\U0001F443\U0001F3FF',
    u':cerebro:': u'\U0001F9E0',
    u':corazón_humano:': u'\U0001FAC0',
    u':pulmones:': u'\U0001FAC1',
    u':diente:': u'\U0001F9B7',
    u':hueso:': u'\U0001F9B4',
    u':ojos:': u'\U0001F440',
    u':ojo:': u'\U0001F441\U0000FE0F',
    u':lengua:': u'\U0001F445',
    u':boca:': u'\U0001F444',
    u':bebé:': u'\U0001F476',
    u':bebé_tono_de_piel_claro:': u'\U0001F476\U0001F3FB',
    u':bebé_tono_de_piel_claro_medio:': u'\U0001F476\U0001F3FC',
    u':bebé_tono_de_piel_medio:': u'\U0001F476\U0001F3FD',
    u':bebé_tono_de_piel_oscuro_medio:': u'\U0001F476\U0001F3FE',
    u':bebé_tono_de_piel_oscuro:': u'\U0001F476\U0001F3FF',
    u':infante:': u'\U0001F9D2',
    u':infante_tono_de_piel_claro:': u'\U0001F9D2\U0001F3FB',
    u':infante_tono_de_piel_claro_medio:': u'\U0001F9D2\U0001F3FC',
    u':infante_tono_de_piel_medio:': u'\U0001F9D2\U0001F3FD',
    u':infante_tono_de_piel_oscuro_medio:': u'\U0001F9D2\U0001F3FE',
    u':infante_tono_de_piel_oscuro:': u'\U0001F9D2\U0001F3FF',
    u':niño:': u'\U0001F466',
    u':niño_tono_de_piel_claro:': u'\U0001F466\U0001F3FB',
    u':niño_tono_de_piel_claro_medio:': u'\U0001F466\U0001F3FC',
    u':niño_tono_de_piel_medio:': u'\U0001F466\U0001F3FD',
    u':niño_tono_de_piel_oscuro_medio:': u'\U0001F466\U0001F3FE',
    u':niño_tono_de_piel_oscuro:': u'\U0001F466\U0001F3FF',
    u':niña:': u'\U0001F467',
    u':niña_tono_de_piel_claro:': u'\U0001F467\U0001F3FB',
    u':niña_tono_de_piel_claro_medio:': u'\U0001F467\U0001F3FC',
    u':niña_tono_de_piel_medio:': u'\U0001F467\U0001F3FD',
    u':niña_tono_de_piel_oscuro_medio:': u'\U0001F467\U0001F3FE',
    u':niña_tono_de_piel_oscuro:': u'\U0001F467\U0001F3FF',
    u':persona_adulta:': u'\U0001F9D1',
    u':persona_adulta_tono_de_piel_claro:': u'\U0001F9D1\U0001F3FB',
    u':persona_adulta_tono_de_piel_claro_medio:': u'\U0001F9D1\U0001F3FC',
    u':persona_adulta_tono_de_piel_medio:': u'\U0001F9D1\U0001F3FD',
    u':persona_adulta_tono_de_piel_oscuro_medio:': u'\U0001F9D1\U0001F3FE',
    u':persona_adulta_tono_de_piel_oscuro:': u'\U0001F9D1\U0001F3FF',
    u':persona_adulta_rubia:': u'\U0001F471',
    u':persona_adulta_rubia_tono_de_piel_claro:': u'\U0001F471\U0001F3FB',
    u':persona_adulta_rubia_tono_de_piel_claro_medio:': u'\U0001F471\U0001F3FC',
    u':persona_adulta_rubia_tono_de_piel_medio:': u'\U0001F471\U0001F3FD',
    u':persona_adulta_rubia_tono_de_piel_oscuro_medio:': u'\U0001F471\U0001F3FE',
    u':persona_adulta_rubia_tono_de_piel_oscuro:': u'\U0001F471\U0001F3FF',
    u':hombre:': u'\U0001F468',
    u':hombre_tono_de_piel_claro:': u'\U0001F468\U0001F3FB',
    u':hombre_tono_de_piel_claro_medio:': u'\U0001F468\U0001F3FC',
    u':hombre_tono_de_piel_medio:': u'\U0001F468\U0001F3FD',
    u':hombre_tono_de_piel_oscuro_medio:': u'\U0001F468\U0001F3FE',
    u':hombre_tono_de_piel_oscuro:': u'\U0001F468\U0001F3FF',
    u':hombre_con_barba:': u'\U0001F9D4',
    u':hombre_con_barba_tono_de_piel_claro:': u'\U0001F9D4\U0001F3FB',
    u':hombre_con_barba_tono_de_piel_claro_medio:': u'\U0001F9D4\U0001F3FC',
    u':hombre_con_barba_tono_de_piel_medio:': u'\U0001F9D4\U0001F3FD',
    u':hombre_con_barba_tono_de_piel_oscuro_medio:': u'\U0001F9D4\U0001F3FE',
    u':hombre_con_barba_tono_de_piel_oscuro:': u'\U0001F9D4\U0001F3FF',
    u':hombre_pelo_pelirrojo:': u'\U0001F468\U0000200D\U0001F9B0',
    u':hombre_tono_de_piel_claro_y_pelo_pelirrojo:': u'\U0001F468\U0001F3FB\U0000200D\U0001F9B0',
    u':hombre_tono_de_piel_claro_medio_y_pelo_pelirrojo:': u'\U0001F468\U0001F3FC\U0000200D\U0001F9B0',
    u':hombre_tono_de_piel_medio_y_pelo_pelirrojo:': u'\U0001F468\U0001F3FD\U0000200D\U0001F9B0',
    u':hombre_tono_de_piel_oscuro_medio_y_pelo_pelirrojo:': u'\U0001F468\U0001F3FE\U0000200D\U0001F9B0',
    u':hombre_tono_de_piel_oscuro_y_pelo_pelirrojo:': u'\U0001F468\U0001F3FF\U0000200D\U0001F9B0',
    u':hombre_pelo_rizado:': u'\U0001F468\U0000200D\U0001F9B1',
    u':hombre_tono_de_piel_claro_y_pelo_rizado:': u'\U0001F468\U0001F3FB\U0000200D\U0001F9B1',
    u':hombre_tono_de_piel_claro_medio_y_pelo_rizado:': u'\U0001F468\U0001F3FC\U0000200D\U0001F9B1',
    u':hombre_tono_de_piel_medio_y_pelo_rizado:': u'\U0001F468\U0001F3FD\U0000200D\U0001F9B1',
    u':hombre_tono_de_piel_oscuro_medio_y_pelo_rizado:': u'\U0001F468\U0001F3FE\U0000200D\U0001F9B1',
    u':hombre_tono_de_piel_oscuro_y_pelo_rizado:': u'\U0001F468\U0001F3FF\U0000200D\U0001F9B1',
    u':hombre_pelo_blanco:': u'\U0001F468\U0000200D\U0001F9B3',
    u':hombre_tono_de_piel_claro_y_pelo_blanco:': u'\U0001F468\U0001F3FB\U0000200D\U0001F9B3',
    u':hombre_tono_de_piel_claro_medio_y_pelo_blanco:': u'\U0001F468\U0001F3FC\U0000200D\U0001F9B3',
    u':hombre_tono_de_piel_medio_y_pelo_blanco:': u'\U0001F468\U0001F3FD\U0000200D\U0001F9B3',
    u':hombre_tono_de_piel_oscuro_medio_y_pelo_blanco:': u'\U0001F468\U0001F3FE\U0000200D\U0001F9B3',
    u':hombre_tono_de_piel_oscuro_y_pelo_blanco:': u'\U0001F468\U0001F3FF\U0000200D\U0001F9B3',
    u':hombre_sin_pelo:': u'\U0001F468\U0000200D\U0001F9B2',
    u':hombre_tono_de_piel_claro_y_sin_pelo:': u'\U0001F468\U0001F3FB\U0000200D\U0001F9B2',
    u':hombre_tono_de_piel_claro_medio_y_sin_pelo:': u'\U0001F468\U0001F3FC\U0000200D\U0001F9B2',
    u':hombre_tono_de_piel_medio_y_sin_pelo:': u'\U0001F468\U0001F3FD\U0000200D\U0001F9B2',
    u':hombre_tono_de_piel_oscuro_medio_y_sin_pelo:': u'\U0001F468\U0001F3FE\U0000200D\U0001F9B2',
    u':hombre_tono_de_piel_oscuro_y_sin_pelo:': u'\U0001F468\U0001F3FF\U0000200D\U0001F9B2',
    u':mujer:': u'\U0001F469',
    u':mujer_tono_de_piel_claro:': u'\U0001F469\U0001F3FB',
    u':mujer_tono_de_piel_claro_medio:': u'\U0001F469\U0001F3FC',
    u':mujer_tono_de_piel_medio:': u'\U0001F469\U0001F3FD',
    u':mujer_tono_de_piel_oscuro_medio:': u'\U0001F469\U0001F3FE',
    u':mujer_tono_de_piel_oscuro:': u'\U0001F469\U0001F3FF',
    u':mujer_pelo_pelirrojo:': u'\U0001F469\U0000200D\U0001F9B0',
    u':mujer_tono_de_piel_claro_y_pelo_pelirrojo:': u'\U0001F469\U0001F3FB\U0000200D\U0001F9B0',
    u':mujer_tono_de_piel_claro_medio_y_pelo_pelirrojo:': u'\U0001F469\U0001F3FC\U0000200D\U0001F9B0',
    u':mujer_tono_de_piel_medio_y_pelo_pelirrojo:': u'\U0001F469\U0001F3FD\U0000200D\U0001F9B0',
    u':mujer_tono_de_piel_oscuro_medio_y_pelo_pelirrojo:': u'\U0001F469\U0001F3FE\U0000200D\U0001F9B0',
    u':mujer_tono_de_piel_oscuro_y_pelo_pelirrojo:': u'\U0001F469\U0001F3FF\U0000200D\U0001F9B0',
    u':persona_adulta_pelo_pelirrojo:': u'\U0001F9D1\U0000200D\U0001F9B0',
    u':persona_adulta_tono_de_piel_claro_y_pelo_pelirrojo:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F9B0',
    u':persona_adulta_tono_de_piel_claro_medio_y_pelo_pelirrojo:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F9B0',
    u':persona_adulta_tono_de_piel_medio_y_pelo_pelirrojo:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F9B0',
    u':persona_adulta_tono_de_piel_oscuro_medio_y_pelo_pelirrojo:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F9B0',
    u':persona_adulta_tono_de_piel_oscuro_y_pelo_pelirrojo:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F9B0',
    u':mujer_pelo_rizado:': u'\U0001F469\U0000200D\U0001F9B1',
    u':mujer_tono_de_piel_claro_y_pelo_rizado:': u'\U0001F469\U0001F3FB\U0000200D\U0001F9B1',
    u':mujer_tono_de_piel_claro_medio_y_pelo_rizado:': u'\U0001F469\U0001F3FC\U0000200D\U0001F9B1',
    u':mujer_tono_de_piel_medio_y_pelo_rizado:': u'\U0001F469\U0001F3FD\U0000200D\U0001F9B1',
    u':mujer_tono_de_piel_oscuro_medio_y_pelo_rizado:': u'\U0001F469\U0001F3FE\U0000200D\U0001F9B1',
    u':mujer_tono_de_piel_oscuro_y_pelo_rizado:': u'\U0001F469\U0001F3FF\U0000200D\U0001F9B1',
    u':persona_adulta_pelo_rizado:': u'\U0001F9D1\U0000200D\U0001F9B1',
    u':persona_adulta_tono_de_piel_claro_y_pelo_rizado:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F9B1',
    u':persona_adulta_tono_de_piel_claro_medio_y_pelo_rizado:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F9B1',
    u':persona_adulta_tono_de_piel_medio_y_pelo_rizado:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F9B1',
    u':persona_adulta_tono_de_piel_oscuro_medio_y_pelo_rizado:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F9B1',
    u':persona_adulta_tono_de_piel_oscuro_y_pelo_rizado:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F9B1',
    u':mujer_pelo_blanco:': u'\U0001F469\U0000200D\U0001F9B3',
    u':mujer_tono_de_piel_claro_y_pelo_blanco:': u'\U0001F469\U0001F3FB\U0000200D\U0001F9B3',
    u':mujer_tono_de_piel_claro_medio_y_pelo_blanco:': u'\U0001F469\U0001F3FC\U0000200D\U0001F9B3',
    u':mujer_tono_de_piel_medio_y_pelo_blanco:': u'\U0001F469\U0001F3FD\U0000200D\U0001F9B3',
    u':mujer_tono_de_piel_oscuro_medio_y_pelo_blanco:': u'\U0001F469\U0001F3FE\U0000200D\U0001F9B3',
    u':mujer_tono_de_piel_oscuro_y_pelo_blanco:': u'\U0001F469\U0001F3FF\U0000200D\U0001F9B3',
    u':persona_adulta_pelo_blanco:': u'\U0001F9D1\U0000200D\U0001F9B3',
    u':persona_adulta_tono_de_piel_claro_y_pelo_blanco:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F9B3',
    u':persona_adulta_tono_de_piel_claro_medio_y_pelo_blanco:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F9B3',
    u':persona_adulta_tono_de_piel_medio_y_pelo_blanco:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F9B3',
    u':persona_adulta_tono_de_piel_oscuro_medio_y_pelo_blanco:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F9B3',
    u':persona_adulta_tono_de_piel_oscuro_y_pelo_blanco:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F9B3',
    u':mujer_sin_pelo:': u'\U0001F469\U0000200D\U0001F9B2',
    u':mujer_tono_de_piel_claro_y_sin_pelo:': u'\U0001F469\U0001F3FB\U0000200D\U0001F9B2',
    u':mujer_tono_de_piel_claro_medio_y_sin_pelo:': u'\U0001F469\U0001F3FC\U0000200D\U0001F9B2',
    u':mujer_tono_de_piel_medio_y_sin_pelo:': u'\U0001F469\U0001F3FD\U0000200D\U0001F9B2',
    u':mujer_tono_de_piel_oscuro_medio_y_sin_pelo:': u'\U0001F469\U0001F3FE\U0000200D\U0001F9B2',
    u':mujer_tono_de_piel_oscuro_y_sin_pelo:': u'\U0001F469\U0001F3FF\U0000200D\U0001F9B2',
    u':persona_adulta_sin_pelo:': u'\U0001F9D1\U0000200D\U0001F9B2',
    u':persona_adulta_tono_de_piel_claro_y_sin_pelo:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F9B2',
    u':persona_adulta_tono_de_piel_claro_medio_y_sin_pelo:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F9B2',
    u':persona_adulta_tono_de_piel_medio_y_sin_pelo:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F9B2',
    u':persona_adulta_tono_de_piel_oscuro_medio_y_sin_pelo:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F9B2',
    u':persona_adulta_tono_de_piel_oscuro_y_sin_pelo:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F9B2',
    u':mujer_rubia:': u'\U0001F471\U0000200D\U00002640\U0000FE0F',
    u':mujer_rubia_tono_de_piel_claro:': u'\U0001F471\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mujer_rubia_tono_de_piel_claro_medio:': u'\U0001F471\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mujer_rubia_tono_de_piel_medio:': u'\U0001F471\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mujer_rubia_tono_de_piel_oscuro_medio:': u'\U0001F471\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mujer_rubia_tono_de_piel_oscuro:': u'\U0001F471\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':hombre_rubio:': u'\U0001F471\U0000200D\U00002642\U0000FE0F',
    u':hombre_rubio_tono_de_piel_claro:': u'\U0001F471\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':hombre_rubio_tono_de_piel_claro_medio:': u'\U0001F471\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':hombre_rubio_tono_de_piel_medio:': u'\U0001F471\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':hombre_rubio_tono_de_piel_oscuro_medio:': u'\U0001F471\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':hombre_rubio_tono_de_piel_oscuro:': u'\U0001F471\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':persona_adulta_madura:': u'\U0001F9D3',
    u':persona_adulta_madura_tono_de_piel_claro:': u'\U0001F9D3\U0001F3FB',
    u':persona_adulta_madura_tono_de_piel_claro_medio:': u'\U0001F9D3\U0001F3FC',
    u':persona_adulta_madura_tono_de_piel_medio:': u'\U0001F9D3\U0001F3FD',
    u':persona_adulta_madura_tono_de_piel_oscuro_medio:': u'\U0001F9D3\U0001F3FE',
    u':persona_adulta_madura_tono_de_piel_oscuro:': u'\U0001F9D3\U0001F3FF',
    u':anciano:': u'\U0001F474',
    u':anciano_tono_de_piel_claro:': u'\U0001F474\U0001F3FB',
    u':anciano_tono_de_piel_claro_medio:': u'\U0001F474\U0001F3FC',
    u':anciano_tono_de_piel_medio:': u'\U0001F474\U0001F3FD',
    u':anciano_tono_de_piel_oscuro_medio:': u'\U0001F474\U0001F3FE',
    u':anciano_tono_de_piel_oscuro:': u'\U0001F474\U0001F3FF',
    u':anciana:': u'\U0001F475',
    u':anciana_tono_de_piel_claro:': u'\U0001F475\U0001F3FB',
    u':anciana_tono_de_piel_claro_medio:': u'\U0001F475\U0001F3FC',
    u':anciana_tono_de_piel_medio:': u'\U0001F475\U0001F3FD',
    u':anciana_tono_de_piel_oscuro_medio:': u'\U0001F475\U0001F3FE',
    u':anciana_tono_de_piel_oscuro:': u'\U0001F475\U0001F3FF',
    u':persona_frunciendo_el_ceño:': u'\U0001F64D',
    u':persona_frunciendo_el_ceño_tono_de_piel_claro:': u'\U0001F64D\U0001F3FB',
    u':persona_frunciendo_el_ceño_tono_de_piel_claro_medio:': u'\U0001F64D\U0001F3FC',
    u':persona_frunciendo_el_ceño_tono_de_piel_medio:': u'\U0001F64D\U0001F3FD',
    u':persona_frunciendo_el_ceño_tono_de_piel_oscuro_medio:': u'\U0001F64D\U0001F3FE',
    u':persona_frunciendo_el_ceño_tono_de_piel_oscuro:': u'\U0001F64D\U0001F3FF',
    u':hombre_frunciendo_el_ceño:': u'\U0001F64D\U0000200D\U00002642\U0000FE0F',
    u':hombre_frunciendo_el_ceño_tono_de_piel_claro:': u'\U0001F64D\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':hombre_frunciendo_el_ceño_tono_de_piel_claro_medio:': u'\U0001F64D\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':hombre_frunciendo_el_ceño_tono_de_piel_medio:': u'\U0001F64D\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':hombre_frunciendo_el_ceño_tono_de_piel_oscuro_medio:': u'\U0001F64D\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':hombre_frunciendo_el_ceño_tono_de_piel_oscuro:': u'\U0001F64D\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mujer_frunciendo_el_ceño:': u'\U0001F64D\U0000200D\U00002640\U0000FE0F',
    u':mujer_frunciendo_el_ceño_tono_de_piel_claro:': u'\U0001F64D\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mujer_frunciendo_el_ceño_tono_de_piel_claro_medio:': u'\U0001F64D\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mujer_frunciendo_el_ceño_tono_de_piel_medio:': u'\U0001F64D\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mujer_frunciendo_el_ceño_tono_de_piel_oscuro_medio:': u'\U0001F64D\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mujer_frunciendo_el_ceño_tono_de_piel_oscuro:': u'\U0001F64D\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':persona_haciendo_pucheros:': u'\U0001F64E',
    u':persona_haciendo_pucheros_tono_de_piel_claro:': u'\U0001F64E\U0001F3FB',
    u':persona_haciendo_pucheros_tono_de_piel_claro_medio:': u'\U0001F64E\U0001F3FC',
    u':persona_haciendo_pucheros_tono_de_piel_medio:': u'\U0001F64E\U0001F3FD',
    u':persona_haciendo_pucheros_tono_de_piel_oscuro_medio:': u'\U0001F64E\U0001F3FE',
    u':persona_haciendo_pucheros_tono_de_piel_oscuro:': u'\U0001F64E\U0001F3FF',
    u':hombre_haciendo_pucheros:': u'\U0001F64E\U0000200D\U00002642\U0000FE0F',
    u':hombre_haciendo_pucheros_tono_de_piel_claro:': u'\U0001F64E\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':hombre_haciendo_pucheros_tono_de_piel_claro_medio:': u'\U0001F64E\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':hombre_haciendo_pucheros_tono_de_piel_medio:': u'\U0001F64E\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':hombre_haciendo_pucheros_tono_de_piel_oscuro_medio:': u'\U0001F64E\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':hombre_haciendo_pucheros_tono_de_piel_oscuro:': u'\U0001F64E\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mujer_haciendo_pucheros:': u'\U0001F64E\U0000200D\U00002640\U0000FE0F',
    u':mujer_haciendo_pucheros_tono_de_piel_claro:': u'\U0001F64E\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mujer_haciendo_pucheros_tono_de_piel_claro_medio:': u'\U0001F64E\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mujer_haciendo_pucheros_tono_de_piel_medio:': u'\U0001F64E\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mujer_haciendo_pucheros_tono_de_piel_oscuro_medio:': u'\U0001F64E\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mujer_haciendo_pucheros_tono_de_piel_oscuro:': u'\U0001F64E\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':persona_haciendo_el_gesto_de_no:': u'\U0001F645',
    u':persona_haciendo_el_gesto_de_no_tono_de_piel_claro:': u'\U0001F645\U0001F3FB',
    u':persona_haciendo_el_gesto_de_no_tono_de_piel_claro_medio:': u'\U0001F645\U0001F3FC',
    u':persona_haciendo_el_gesto_de_no_tono_de_piel_medio:': u'\U0001F645\U0001F3FD',
    u':persona_haciendo_el_gesto_de_no_tono_de_piel_oscuro_medio:': u'\U0001F645\U0001F3FE',
    u':persona_haciendo_el_gesto_de_no_tono_de_piel_oscuro:': u'\U0001F645\U0001F3FF',
    u':hombre_haciendo_el_gesto_de_no:': u'\U0001F645\U0000200D\U00002642\U0000FE0F',
    u':hombre_haciendo_el_gesto_de_no_tono_de_piel_claro:': u'\U0001F645\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':hombre_haciendo_el_gesto_de_no_tono_de_piel_claro_medio:': u'\U0001F645\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':hombre_haciendo_el_gesto_de_no_tono_de_piel_medio:': u'\U0001F645\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':hombre_haciendo_el_gesto_de_no_tono_de_piel_oscuro_medio:': u'\U0001F645\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':hombre_haciendo_el_gesto_de_no_tono_de_piel_oscuro:': u'\U0001F645\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mujer_haciendo_el_gesto_de_no:': u'\U0001F645\U0000200D\U00002640\U0000FE0F',
    u':mujer_haciendo_el_gesto_de_no_tono_de_piel_claro:': u'\U0001F645\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mujer_haciendo_el_gesto_de_no_tono_de_piel_claro_medio:': u'\U0001F645\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mujer_haciendo_el_gesto_de_no_tono_de_piel_medio:': u'\U0001F645\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mujer_haciendo_el_gesto_de_no_tono_de_piel_oscuro_medio:': u'\U0001F645\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mujer_haciendo_el_gesto_de_no_tono_de_piel_oscuro:': u'\U0001F645\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':persona_haciendo_el_gesto_de_de_acuerdo:': u'\U0001F646',
    u':persona_haciendo_el_gesto_de_de_acuerdo_tono_de_piel_claro:': u'\U0001F646\U0001F3FB',
    u':persona_haciendo_el_gesto_de_de_acuerdo_tono_de_piel_claro_medio:': u'\U0001F646\U0001F3FC',
    u':persona_haciendo_el_gesto_de_de_acuerdo_tono_de_piel_medio:': u'\U0001F646\U0001F3FD',
    u':persona_haciendo_el_gesto_de_de_acuerdo_tono_de_piel_oscuro_medio:': u'\U0001F646\U0001F3FE',
    u':persona_haciendo_el_gesto_de_de_acuerdo_tono_de_piel_oscuro:': u'\U0001F646\U0001F3FF',
    u':hombre_haciendo_el_gesto_de_de_acuerdo:': u'\U0001F646\U0000200D\U00002642\U0000FE0F',
    u':hombre_haciendo_el_gesto_de_de_acuerdo_tono_de_piel_claro:': u'\U0001F646\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':hombre_haciendo_el_gesto_de_de_acuerdo_tono_de_piel_claro_medio:': u'\U0001F646\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':hombre_haciendo_el_gesto_de_de_acuerdo_tono_de_piel_medio:': u'\U0001F646\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':hombre_haciendo_el_gesto_de_de_acuerdo_tono_de_piel_oscuro_medio:': u'\U0001F646\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':hombre_haciendo_el_gesto_de_de_acuerdo_tono_de_piel_oscuro:': u'\U0001F646\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mujer_haciendo_el_gesto_de_de_acuerdo:': u'\U0001F646\U0000200D\U00002640\U0000FE0F',
    u':mujer_haciendo_el_gesto_de_de_acuerdo_tono_de_piel_claro:': u'\U0001F646\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mujer_haciendo_el_gesto_de_de_acuerdo_tono_de_piel_claro_medio:': u'\U0001F646\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mujer_haciendo_el_gesto_de_de_acuerdo_tono_de_piel_medio:': u'\U0001F646\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mujer_haciendo_el_gesto_de_de_acuerdo_tono_de_piel_oscuro_medio:': u'\U0001F646\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mujer_haciendo_el_gesto_de_de_acuerdo_tono_de_piel_oscuro:': u'\U0001F646\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':persona_de_mostrador_de_información:': u'\U0001F481',
    u':persona_de_mostrador_de_información_tono_de_piel_claro:': u'\U0001F481\U0001F3FB',
    u':persona_de_mostrador_de_información_tono_de_piel_claro_medio:': u'\U0001F481\U0001F3FC',
    u':persona_de_mostrador_de_información_tono_de_piel_medio:': u'\U0001F481\U0001F3FD',
    u':persona_de_mostrador_de_información_tono_de_piel_oscuro_medio:': u'\U0001F481\U0001F3FE',
    u':persona_de_mostrador_de_información_tono_de_piel_oscuro:': u'\U0001F481\U0001F3FF',
    u':empleado_de_mostrador_de_información:': u'\U0001F481\U0000200D\U00002642\U0000FE0F',
    u':empleado_de_mostrador_de_información_tono_de_piel_claro:': u'\U0001F481\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':empleado_de_mostrador_de_información_tono_de_piel_claro_medio:': u'\U0001F481\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':empleado_de_mostrador_de_información_tono_de_piel_medio:': u'\U0001F481\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':empleado_de_mostrador_de_información_tono_de_piel_oscuro_medio:': u'\U0001F481\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':empleado_de_mostrador_de_información_tono_de_piel_oscuro:': u'\U0001F481\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':empleada_de_mostrador_de_información:': u'\U0001F481\U0000200D\U00002640\U0000FE0F',
    u':empleada_de_mostrador_de_información_tono_de_piel_claro:': u'\U0001F481\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':empleada_de_mostrador_de_información_tono_de_piel_claro_medio:': u'\U0001F481\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':empleada_de_mostrador_de_información_tono_de_piel_medio:': u'\U0001F481\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':empleada_de_mostrador_de_información_tono_de_piel_oscuro_medio:': u'\U0001F481\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':empleada_de_mostrador_de_información_tono_de_piel_oscuro:': u'\U0001F481\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':persona_con_la_mano_levantada:': u'\U0001F64B',
    u':persona_con_la_mano_levantada_tono_de_piel_claro:': u'\U0001F64B\U0001F3FB',
    u':persona_con_la_mano_levantada_tono_de_piel_claro_medio:': u'\U0001F64B\U0001F3FC',
    u':persona_con_la_mano_levantada_tono_de_piel_medio:': u'\U0001F64B\U0001F3FD',
    u':persona_con_la_mano_levantada_tono_de_piel_oscuro_medio:': u'\U0001F64B\U0001F3FE',
    u':persona_con_la_mano_levantada_tono_de_piel_oscuro:': u'\U0001F64B\U0001F3FF',
    u':hombre_con_la_mano_levantada:': u'\U0001F64B\U0000200D\U00002642\U0000FE0F',
    u':hombre_con_la_mano_levantada_tono_de_piel_claro:': u'\U0001F64B\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':hombre_con_la_mano_levantada_tono_de_piel_claro_medio:': u'\U0001F64B\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':hombre_con_la_mano_levantada_tono_de_piel_medio:': u'\U0001F64B\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':hombre_con_la_mano_levantada_tono_de_piel_oscuro_medio:': u'\U0001F64B\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':hombre_con_la_mano_levantada_tono_de_piel_oscuro:': u'\U0001F64B\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mujer_con_la_mano_levantada:': u'\U0001F64B\U0000200D\U00002640\U0000FE0F',
    u':mujer_con_la_mano_levantada_tono_de_piel_claro:': u'\U0001F64B\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mujer_con_la_mano_levantada_tono_de_piel_claro_medio:': u'\U0001F64B\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mujer_con_la_mano_levantada_tono_de_piel_medio:': u'\U0001F64B\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mujer_con_la_mano_levantada_tono_de_piel_oscuro_medio:': u'\U0001F64B\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mujer_con_la_mano_levantada_tono_de_piel_oscuro:': u'\U0001F64B\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':persona_sorda:': u'\U0001F9CF',
    u':persona_sorda_tono_de_piel_claro:': u'\U0001F9CF\U0001F3FB',
    u':persona_sorda_tono_de_piel_claro_medio:': u'\U0001F9CF\U0001F3FC',
    u':persona_sorda_tono_de_piel_medio:': u'\U0001F9CF\U0001F3FD',
    u':persona_sorda_tono_de_piel_oscuro_medio:': u'\U0001F9CF\U0001F3FE',
    u':persona_sorda_tono_de_piel_oscuro:': u'\U0001F9CF\U0001F3FF',
    u':hombre_sordo:': u'\U0001F9CF\U0000200D\U00002642\U0000FE0F',
    u':hombre_sordo_tono_de_piel_claro:': u'\U0001F9CF\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':hombre_sordo_tono_de_piel_claro_medio:': u'\U0001F9CF\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':hombre_sordo_tono_de_piel_medio:': u'\U0001F9CF\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':hombre_sordo_tono_de_piel_oscuro_medio:': u'\U0001F9CF\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':hombre_sordo_tono_de_piel_oscuro:': u'\U0001F9CF\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mujer_sorda:': u'\U0001F9CF\U0000200D\U00002640\U0000FE0F',
    u':mujer_sorda_tono_de_piel_claro:': u'\U0001F9CF\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mujer_sorda_tono_de_piel_claro_medio:': u'\U0001F9CF\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mujer_sorda_tono_de_piel_medio:': u'\U0001F9CF\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mujer_sorda_tono_de_piel_oscuro_medio:': u'\U0001F9CF\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mujer_sorda_tono_de_piel_oscuro:': u'\U0001F9CF\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':persona_haciendo_una_reverencia:': u'\U0001F647',
    u':persona_haciendo_una_reverencia_tono_de_piel_claro:': u'\U0001F647\U0001F3FB',
    u':persona_haciendo_una_reverencia_tono_de_piel_claro_medio:': u'\U0001F647\U0001F3FC',
    u':persona_haciendo_una_reverencia_tono_de_piel_medio:': u'\U0001F647\U0001F3FD',
    u':persona_haciendo_una_reverencia_tono_de_piel_oscuro_medio:': u'\U0001F647\U0001F3FE',
    u':persona_haciendo_una_reverencia_tono_de_piel_oscuro:': u'\U0001F647\U0001F3FF',
    u':hombre_haciendo_una_reverencia:': u'\U0001F647\U0000200D\U00002642\U0000FE0F',
    u':hombre_haciendo_una_reverencia_tono_de_piel_claro:': u'\U0001F647\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':hombre_haciendo_una_reverencia_tono_de_piel_claro_medio:': u'\U0001F647\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':hombre_haciendo_una_reverencia_tono_de_piel_medio:': u'\U0001F647\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':hombre_haciendo_una_reverencia_tono_de_piel_oscuro_medio:': u'\U0001F647\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':hombre_haciendo_una_reverencia_tono_de_piel_oscuro:': u'\U0001F647\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mujer_haciendo_una_reverencia:': u'\U0001F647\U0000200D\U00002640\U0000FE0F',
    u':mujer_haciendo_una_reverencia_tono_de_piel_claro:': u'\U0001F647\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mujer_haciendo_una_reverencia_tono_de_piel_claro_medio:': u'\U0001F647\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mujer_haciendo_una_reverencia_tono_de_piel_medio:': u'\U0001F647\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mujer_haciendo_una_reverencia_tono_de_piel_oscuro_medio:': u'\U0001F647\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mujer_haciendo_una_reverencia_tono_de_piel_oscuro:': u'\U0001F647\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':persona_con_la_mano_en_la_frente:': u'\U0001F926',
    u':persona_con_la_mano_en_la_frente_tono_de_piel_claro:': u'\U0001F926\U0001F3FB',
    u':persona_con_la_mano_en_la_frente_tono_de_piel_claro_medio:': u'\U0001F926\U0001F3FC',
    u':persona_con_la_mano_en_la_frente_tono_de_piel_medio:': u'\U0001F926\U0001F3FD',
    u':persona_con_la_mano_en_la_frente_tono_de_piel_oscuro_medio:': u'\U0001F926\U0001F3FE',
    u':persona_con_la_mano_en_la_frente_tono_de_piel_oscuro:': u'\U0001F926\U0001F3FF',
    u':hombre_con_la_mano_en_la_frente:': u'\U0001F926\U0000200D\U00002642\U0000FE0F',
    u':hombre_con_la_mano_en_la_frente_tono_de_piel_claro:': u'\U0001F926\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':hombre_con_la_mano_en_la_frente_tono_de_piel_claro_medio:': u'\U0001F926\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':hombre_con_la_mano_en_la_frente_tono_de_piel_medio:': u'\U0001F926\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':hombre_con_la_mano_en_la_frente_tono_de_piel_oscuro_medio:': u'\U0001F926\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':hombre_con_la_mano_en_la_frente_tono_de_piel_oscuro:': u'\U0001F926\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mujer_con_la_mano_en_la_frente:': u'\U0001F926\U0000200D\U00002640\U0000FE0F',
    u':mujer_con_la_mano_en_la_frente_tono_de_piel_claro:': u'\U0001F926\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mujer_con_la_mano_en_la_frente_tono_de_piel_claro_medio:': u'\U0001F926\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mujer_con_la_mano_en_la_frente_tono_de_piel_medio:': u'\U0001F926\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mujer_con_la_mano_en_la_frente_tono_de_piel_oscuro_medio:': u'\U0001F926\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mujer_con_la_mano_en_la_frente_tono_de_piel_oscuro:': u'\U0001F926\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':persona_encogida_de_hombros:': u'\U0001F937',
    u':persona_encogida_de_hombros_tono_de_piel_claro:': u'\U0001F937\U0001F3FB',
    u':persona_encogida_de_hombros_tono_de_piel_claro_medio:': u'\U0001F937\U0001F3FC',
    u':persona_encogida_de_hombros_tono_de_piel_medio:': u'\U0001F937\U0001F3FD',
    u':persona_encogida_de_hombros_tono_de_piel_oscuro_medio:': u'\U0001F937\U0001F3FE',
    u':persona_encogida_de_hombros_tono_de_piel_oscuro:': u'\U0001F937\U0001F3FF',
    u':hombre_encogido_de_hombros:': u'\U0001F937\U0000200D\U00002642\U0000FE0F',
    u':hombre_encogido_de_hombros_tono_de_piel_claro:': u'\U0001F937\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':hombre_encogido_de_hombros_tono_de_piel_claro_medio:': u'\U0001F937\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':hombre_encogido_de_hombros_tono_de_piel_medio:': u'\U0001F937\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':hombre_encogido_de_hombros_tono_de_piel_oscuro_medio:': u'\U0001F937\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':hombre_encogido_de_hombros_tono_de_piel_oscuro:': u'\U0001F937\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mujer_encogida_de_hombros:': u'\U0001F937\U0000200D\U00002640\U0000FE0F',
    u':mujer_encogida_de_hombros_tono_de_piel_claro:': u'\U0001F937\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mujer_encogida_de_hombros_tono_de_piel_claro_medio:': u'\U0001F937\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mujer_encogida_de_hombros_tono_de_piel_medio:': u'\U0001F937\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mujer_encogida_de_hombros_tono_de_piel_oscuro_medio:': u'\U0001F937\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mujer_encogida_de_hombros_tono_de_piel_oscuro:': u'\U0001F937\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':profesional_sanitario:': u'\U0001F9D1\U0000200D\U00002695\U0000FE0F',
    u':profesional_sanitario_tono_de_piel_claro:': u'\U0001F9D1\U0001F3FB\U0000200D\U00002695\U0000FE0F',
    u':profesional_sanitario_tono_de_piel_claro_medio:': u'\U0001F9D1\U0001F3FC\U0000200D\U00002695\U0000FE0F',
    u':profesional_sanitario_tono_de_piel_medio:': u'\U0001F9D1\U0001F3FD\U0000200D\U00002695\U0000FE0F',
    u':profesional_sanitario_tono_de_piel_oscuro_medio:': u'\U0001F9D1\U0001F3FE\U0000200D\U00002695\U0000FE0F',
    u':profesional_sanitario_tono_de_piel_oscuro:': u'\U0001F9D1\U0001F3FF\U0000200D\U00002695\U0000FE0F',
    u':profesional_sanitario_hombre:': u'\U0001F468\U0000200D\U00002695\U0000FE0F',
    u':profesional_sanitario_hombre_tono_de_piel_claro:': u'\U0001F468\U0001F3FB\U0000200D\U00002695\U0000FE0F',
    u':profesional_sanitario_hombre_tono_de_piel_claro_medio:': u'\U0001F468\U0001F3FC\U0000200D\U00002695\U0000FE0F',
    u':profesional_sanitario_hombre_tono_de_piel_medio:': u'\U0001F468\U0001F3FD\U0000200D\U00002695\U0000FE0F',
    u':profesional_sanitario_hombre_tono_de_piel_oscuro_medio:': u'\U0001F468\U0001F3FE\U0000200D\U00002695\U0000FE0F',
    u':profesional_sanitario_hombre_tono_de_piel_oscuro:': u'\U0001F468\U0001F3FF\U0000200D\U00002695\U0000FE0F',
    u':profesional_sanitario_mujer:': u'\U0001F469\U0000200D\U00002695\U0000FE0F',
    u':profesional_sanitario_mujer_tono_de_piel_claro:': u'\U0001F469\U0001F3FB\U0000200D\U00002695\U0000FE0F',
    u':profesional_sanitario_mujer_tono_de_piel_claro_medio:': u'\U0001F469\U0001F3FC\U0000200D\U00002695\U0000FE0F',
    u':profesional_sanitario_mujer_tono_de_piel_medio:': u'\U0001F469\U0001F3FD\U0000200D\U00002695\U0000FE0F',
    u':profesional_sanitario_mujer_tono_de_piel_oscuro_medio:': u'\U0001F469\U0001F3FE\U0000200D\U00002695\U0000FE0F',
    u':profesional_sanitario_mujer_tono_de_piel_oscuro:': u'\U0001F469\U0001F3FF\U0000200D\U00002695\U0000FE0F',
    u':estudiante:': u'\U0001F9D1\U0000200D\U0001F393',
    u':estudiante_tono_de_piel_claro:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F393',
    u':estudiante_tono_de_piel_claro_medio:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F393',
    u':estudiante_tono_de_piel_medio:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F393',
    u':estudiante_tono_de_piel_oscuro_medio:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F393',
    u':estudiante_tono_de_piel_oscuro:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F393',
    u':estudiante_hombre:': u'\U0001F468\U0000200D\U0001F393',
    u':estudiante_hombre_tono_de_piel_claro:': u'\U0001F468\U0001F3FB\U0000200D\U0001F393',
    u':estudiante_hombre_tono_de_piel_claro_medio:': u'\U0001F468\U0001F3FC\U0000200D\U0001F393',
    u':estudiante_hombre_tono_de_piel_medio:': u'\U0001F468\U0001F3FD\U0000200D\U0001F393',
    u':estudiante_hombre_tono_de_piel_oscuro_medio:': u'\U0001F468\U0001F3FE\U0000200D\U0001F393',
    u':estudiante_hombre_tono_de_piel_oscuro:': u'\U0001F468\U0001F3FF\U0000200D\U0001F393',
    u':estudiante_mujer:': u'\U0001F469\U0000200D\U0001F393',
    u':estudiante_mujer_tono_de_piel_claro:': u'\U0001F469\U0001F3FB\U0000200D\U0001F393',
    u':estudiante_mujer_tono_de_piel_claro_medio:': u'\U0001F469\U0001F3FC\U0000200D\U0001F393',
    u':estudiante_mujer_tono_de_piel_medio:': u'\U0001F469\U0001F3FD\U0000200D\U0001F393',
    u':estudiante_mujer_tono_de_piel_oscuro_medio:': u'\U0001F469\U0001F3FE\U0000200D\U0001F393',
    u':estudiante_mujer_tono_de_piel_oscuro:': u'\U0001F469\U0001F3FF\U0000200D\U0001F393',
    u':docente:': u'\U0001F9D1\U0000200D\U0001F3EB',
    u':docente_tono_de_piel_claro:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F3EB',
    u':docente_tono_de_piel_claro_medio:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F3EB',
    u':docente_tono_de_piel_medio:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F3EB',
    u':docente_tono_de_piel_oscuro_medio:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F3EB',
    u':docente_tono_de_piel_oscuro:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F3EB',
    u':docente_hombre:': u'\U0001F468\U0000200D\U0001F3EB',
    u':docente_hombre_tono_de_piel_claro:': u'\U0001F468\U0001F3FB\U0000200D\U0001F3EB',
    u':docente_hombre_tono_de_piel_claro_medio:': u'\U0001F468\U0001F3FC\U0000200D\U0001F3EB',
    u':docente_hombre_tono_de_piel_medio:': u'\U0001F468\U0001F3FD\U0000200D\U0001F3EB',
    u':docente_hombre_tono_de_piel_oscuro_medio:': u'\U0001F468\U0001F3FE\U0000200D\U0001F3EB',
    u':docente_hombre_tono_de_piel_oscuro:': u'\U0001F468\U0001F3FF\U0000200D\U0001F3EB',
    u':docente_mujer:': u'\U0001F469\U0000200D\U0001F3EB',
    u':docente_mujer_tono_de_piel_claro:': u'\U0001F469\U0001F3FB\U0000200D\U0001F3EB',
    u':docente_mujer_tono_de_piel_claro_medio:': u'\U0001F469\U0001F3FC\U0000200D\U0001F3EB',
    u':docente_mujer_tono_de_piel_medio:': u'\U0001F469\U0001F3FD\U0000200D\U0001F3EB',
    u':docente_mujer_tono_de_piel_oscuro_medio:': u'\U0001F469\U0001F3FE\U0000200D\U0001F3EB',
    u':docente_mujer_tono_de_piel_oscuro:': u'\U0001F469\U0001F3FF\U0000200D\U0001F3EB',
    u':fiscal:': u'\U0001F9D1\U0000200D\U00002696\U0000FE0F',
    u':fiscal_tono_de_piel_claro:': u'\U0001F9D1\U0001F3FB\U0000200D\U00002696\U0000FE0F',
    u':fiscal_tono_de_piel_claro_medio:': u'\U0001F9D1\U0001F3FC\U0000200D\U00002696\U0000FE0F',
    u':fiscal_tono_de_piel_medio:': u'\U0001F9D1\U0001F3FD\U0000200D\U00002696\U0000FE0F',
    u':fiscal_tono_de_piel_oscuro_medio:': u'\U0001F9D1\U0001F3FE\U0000200D\U00002696\U0000FE0F',
    u':fiscal_tono_de_piel_oscuro:': u'\U0001F9D1\U0001F3FF\U0000200D\U00002696\U0000FE0F',
    u':fiscal_hombre:': u'\U0001F468\U0000200D\U00002696\U0000FE0F',
    u':fiscal_hombre_tono_de_piel_claro:': u'\U0001F468\U0001F3FB\U0000200D\U00002696\U0000FE0F',
    u':fiscal_hombre_tono_de_piel_claro_medio:': u'\U0001F468\U0001F3FC\U0000200D\U00002696\U0000FE0F',
    u':fiscal_hombre_tono_de_piel_medio:': u'\U0001F468\U0001F3FD\U0000200D\U00002696\U0000FE0F',
    u':fiscal_hombre_tono_de_piel_oscuro_medio:': u'\U0001F468\U0001F3FE\U0000200D\U00002696\U0000FE0F',
    u':fiscal_hombre_tono_de_piel_oscuro:': u'\U0001F468\U0001F3FF\U0000200D\U00002696\U0000FE0F',
    u':fiscal_mujer:': u'\U0001F469\U0000200D\U00002696\U0000FE0F',
    u':fiscal_mujer_tono_de_piel_claro:': u'\U0001F469\U0001F3FB\U0000200D\U00002696\U0000FE0F',
    u':fiscal_mujer_tono_de_piel_claro_medio:': u'\U0001F469\U0001F3FC\U0000200D\U00002696\U0000FE0F',
    u':fiscal_mujer_tono_de_piel_medio:': u'\U0001F469\U0001F3FD\U0000200D\U00002696\U0000FE0F',
    u':fiscal_mujer_tono_de_piel_oscuro_medio:': u'\U0001F469\U0001F3FE\U0000200D\U00002696\U0000FE0F',
    u':fiscal_mujer_tono_de_piel_oscuro:': u'\U0001F469\U0001F3FF\U0000200D\U00002696\U0000FE0F',
    u':profesional_de_la_agricultura:': u'\U0001F9D1\U0000200D\U0001F33E',
    u':profesional_de_la_agricultura_tono_de_piel_claro:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F33E',
    u':profesional_de_la_agricultura_tono_de_piel_claro_medio:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F33E',
    u':profesional_de_la_agricultura_tono_de_piel_medio:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F33E',
    u':profesional_de_la_agricultura_tono_de_piel_oscuro_medio:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F33E',
    u':profesional_de_la_agricultura_tono_de_piel_oscuro:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F33E',
    u':profesional_de_la_agricultura_hombre:': u'\U0001F468\U0000200D\U0001F33E',
    u':profesional_de_la_agricultura_hombre_tono_de_piel_claro:': u'\U0001F468\U0001F3FB\U0000200D\U0001F33E',
    u':profesional_de_la_agricultura_hombre_tono_de_piel_claro_medio:': u'\U0001F468\U0001F3FC\U0000200D\U0001F33E',
    u':profesional_de_la_agricultura_hombre_tono_de_piel_medio:': u'\U0001F468\U0001F3FD\U0000200D\U0001F33E',
    u':profesional_de_la_agricultura_hombre_tono_de_piel_oscuro_medio:': u'\U0001F468\U0001F3FE\U0000200D\U0001F33E',
    u':profesional_de_la_agricultura_hombre_tono_de_piel_oscuro:': u'\U0001F468\U0001F3FF\U0000200D\U0001F33E',
    u':profesional_de_la_agricultura_mujer:': u'\U0001F469\U0000200D\U0001F33E',
    u':profesional_de_la_agricultura_mujer_tono_de_piel_claro:': u'\U0001F469\U0001F3FB\U0000200D\U0001F33E',
    u':profesional_de_la_agricultura_mujer_tono_de_piel_claro_medio:': u'\U0001F469\U0001F3FC\U0000200D\U0001F33E',
    u':profesional_de_la_agricultura_mujer_tono_de_piel_medio:': u'\U0001F469\U0001F3FD\U0000200D\U0001F33E',
    u':profesional_de_la_agricultura_mujer_tono_de_piel_oscuro_medio:': u'\U0001F469\U0001F3FE\U0000200D\U0001F33E',
    u':profesional_de_la_agricultura_mujer_tono_de_piel_oscuro:': u'\U0001F469\U0001F3FF\U0000200D\U0001F33E',
    u':chef:': u'\U0001F9D1\U0000200D\U0001F373',
    u':chef_tono_de_piel_claro:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F373',
    u':chef_tono_de_piel_claro_medio:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F373',
    u':chef_tono_de_piel_medio:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F373',
    u':chef_tono_de_piel_oscuro_medio:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F373',
    u':chef_tono_de_piel_oscuro:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F373',
    u':chef_hombre:': u'\U0001F468\U0000200D\U0001F373',
    u':chef_hombre_tono_de_piel_claro:': u'\U0001F468\U0001F3FB\U0000200D\U0001F373',
    u':chef_hombre_tono_de_piel_claro_medio:': u'\U0001F468\U0001F3FC\U0000200D\U0001F373',
    u':chef_hombre_tono_de_piel_medio:': u'\U0001F468\U0001F3FD\U0000200D\U0001F373',
    u':chef_hombre_tono_de_piel_oscuro_medio:': u'\U0001F468\U0001F3FE\U0000200D\U0001F373',
    u':chef_hombre_tono_de_piel_oscuro:': u'\U0001F468\U0001F3FF\U0000200D\U0001F373',
    u':chef_mujer:': u'\U0001F469\U0000200D\U0001F373',
    u':chef_mujer_tono_de_piel_claro:': u'\U0001F469\U0001F3FB\U0000200D\U0001F373',
    u':chef_mujer_tono_de_piel_claro_medio:': u'\U0001F469\U0001F3FC\U0000200D\U0001F373',
    u':chef_mujer_tono_de_piel_medio:': u'\U0001F469\U0001F3FD\U0000200D\U0001F373',
    u':chef_mujer_tono_de_piel_oscuro_medio:': u'\U0001F469\U0001F3FE\U0000200D\U0001F373',
    u':chef_mujer_tono_de_piel_oscuro:': u'\U0001F469\U0001F3FF\U0000200D\U0001F373',
    u':profesional_de_la_mecánica:': u'\U0001F9D1\U0000200D\U0001F527',
    u':profesional_de_la_mecánica_tono_de_piel_claro:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F527',
    u':profesional_de_la_mecánica_tono_de_piel_claro_medio:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F527',
    u':profesional_de_la_mecánica_tono_de_piel_medio:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F527',
    u':profesional_de_la_mecánica_tono_de_piel_oscuro_medio:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F527',
    u':profesional_de_la_mecánica_tono_de_piel_oscuro:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F527',
    u':profesional_de_la_mecánica_hombre:': u'\U0001F468\U0000200D\U0001F527',
    u':profesional_de_la_mecánica_hombre_tono_de_piel_claro:': u'\U0001F468\U0001F3FB\U0000200D\U0001F527',
    u':profesional_de_la_mecánica_hombre_tono_de_piel_claro_medio:': u'\U0001F468\U0001F3FC\U0000200D\U0001F527',
    u':profesional_de_la_mecánica_hombre_tono_de_piel_medio:': u'\U0001F468\U0001F3FD\U0000200D\U0001F527',
    u':profesional_de_la_mecánica_hombre_tono_de_piel_oscuro_medio:': u'\U0001F468\U0001F3FE\U0000200D\U0001F527',
    u':profesional_de_la_mecánica_hombre_tono_de_piel_oscuro:': u'\U0001F468\U0001F3FF\U0000200D\U0001F527',
    u':profesional_de_la_mecánica_mujer:': u'\U0001F469\U0000200D\U0001F527',
    u':profesional_de_la_mecánica_mujer_tono_de_piel_claro:': u'\U0001F469\U0001F3FB\U0000200D\U0001F527',
    u':profesional_de_la_mecánica_mujer_tono_de_piel_claro_medio:': u'\U0001F469\U0001F3FC\U0000200D\U0001F527',
    u':profesional_de_la_mecánica_mujer_tono_de_piel_medio:': u'\U0001F469\U0001F3FD\U0000200D\U0001F527',
    u':profesional_de_la_mecánica_mujer_tono_de_piel_oscuro_medio:': u'\U0001F469\U0001F3FE\U0000200D\U0001F527',
    u':profesional_de_la_mecánica_mujer_tono_de_piel_oscuro:': u'\U0001F469\U0001F3FF\U0000200D\U0001F527',
    u':profesional_industrial:': u'\U0001F9D1\U0000200D\U0001F3ED',
    u':profesional_industrial_tono_de_piel_claro:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F3ED',
    u':profesional_industrial_tono_de_piel_claro_medio:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F3ED',
    u':profesional_industrial_tono_de_piel_medio:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F3ED',
    u':profesional_industrial_tono_de_piel_oscuro_medio:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F3ED',
    u':profesional_industrial_tono_de_piel_oscuro:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F3ED',
    u':profesional_industrial_hombre:': u'\U0001F468\U0000200D\U0001F3ED',
    u':profesional_industrial_hombre_tono_de_piel_claro:': u'\U0001F468\U0001F3FB\U0000200D\U0001F3ED',
    u':profesional_industrial_hombre_tono_de_piel_claro_medio:': u'\U0001F468\U0001F3FC\U0000200D\U0001F3ED',
    u':profesional_industrial_hombre_tono_de_piel_medio:': u'\U0001F468\U0001F3FD\U0000200D\U0001F3ED',
    u':profesional_industrial_hombre_tono_de_piel_oscuro_medio:': u'\U0001F468\U0001F3FE\U0000200D\U0001F3ED',
    u':profesional_industrial_hombre_tono_de_piel_oscuro:': u'\U0001F468\U0001F3FF\U0000200D\U0001F3ED',
    u':profesional_industrial_mujer:': u'\U0001F469\U0000200D\U0001F3ED',
    u':profesional_industrial_mujer_tono_de_piel_claro:': u'\U0001F469\U0001F3FB\U0000200D\U0001F3ED',
    u':profesional_industrial_mujer_tono_de_piel_claro_medio:': u'\U0001F469\U0001F3FC\U0000200D\U0001F3ED',
    u':profesional_industrial_mujer_tono_de_piel_medio:': u'\U0001F469\U0001F3FD\U0000200D\U0001F3ED',
    u':profesional_industrial_mujer_tono_de_piel_oscuro_medio:': u'\U0001F469\U0001F3FE\U0000200D\U0001F3ED',
    u':profesional_industrial_mujer_tono_de_piel_oscuro:': u'\U0001F469\U0001F3FF\U0000200D\U0001F3ED',
    u':oficinista:': u'\U0001F9D1\U0000200D\U0001F4BC',
    u':oficinista_tono_de_piel_claro:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F4BC',
    u':oficinista_tono_de_piel_claro_medio:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F4BC',
    u':oficinista_tono_de_piel_medio:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F4BC',
    u':oficinista_tono_de_piel_oscuro_medio:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F4BC',
    u':oficinista_tono_de_piel_oscuro:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F4BC',
    u':oficinista_hombre:': u'\U0001F468\U0000200D\U0001F4BC',
    u':oficinista_hombre_tono_de_piel_claro:': u'\U0001F468\U0001F3FB\U0000200D\U0001F4BC',
    u':oficinista_hombre_tono_de_piel_claro_medio:': u'\U0001F468\U0001F3FC\U0000200D\U0001F4BC',
    u':oficinista_hombre_tono_de_piel_medio:': u'\U0001F468\U0001F3FD\U0000200D\U0001F4BC',
    u':oficinista_hombre_tono_de_piel_oscuro_medio:': u'\U0001F468\U0001F3FE\U0000200D\U0001F4BC',
    u':oficinista_hombre_tono_de_piel_oscuro:': u'\U0001F468\U0001F3FF\U0000200D\U0001F4BC',
    u':oficinista_mujer:': u'\U0001F469\U0000200D\U0001F4BC',
    u':oficinista_mujer_tono_de_piel_claro:': u'\U0001F469\U0001F3FB\U0000200D\U0001F4BC',
    u':oficinista_mujer_tono_de_piel_claro_medio:': u'\U0001F469\U0001F3FC\U0000200D\U0001F4BC',
    u':oficinista_mujer_tono_de_piel_medio:': u'\U0001F469\U0001F3FD\U0000200D\U0001F4BC',
    u':oficinista_mujer_tono_de_piel_oscuro_medio:': u'\U0001F469\U0001F3FE\U0000200D\U0001F4BC',
    u':oficinista_mujer_tono_de_piel_oscuro:': u'\U0001F469\U0001F3FF\U0000200D\U0001F4BC',
    u':profesional_de_la_ciencia:': u'\U0001F9D1\U0000200D\U0001F52C',
    u':profesional_de_la_ciencia_tono_de_piel_claro:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F52C',
    u':profesional_de_la_ciencia_tono_de_piel_claro_medio:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F52C',
    u':profesional_de_la_ciencia_tono_de_piel_medio:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F52C',
    u':profesional_de_la_ciencia_tono_de_piel_oscuro_medio:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F52C',
    u':profesional_de_la_ciencia_tono_de_piel_oscuro:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F52C',
    u':profesional_de_la_ciencia_hombre:': u'\U0001F468\U0000200D\U0001F52C',
    u':profesional_de_la_ciencia_hombre_tono_de_piel_claro:': u'\U0001F468\U0001F3FB\U0000200D\U0001F52C',
    u':profesional_de_la_ciencia_hombre_tono_de_piel_claro_medio:': u'\U0001F468\U0001F3FC\U0000200D\U0001F52C',
    u':profesional_de_la_ciencia_hombre_tono_de_piel_medio:': u'\U0001F468\U0001F3FD\U0000200D\U0001F52C',
    u':profesional_de_la_ciencia_hombre_tono_de_piel_oscuro_medio:': u'\U0001F468\U0001F3FE\U0000200D\U0001F52C',
    u':profesional_de_la_ciencia_hombre_tono_de_piel_oscuro:': u'\U0001F468\U0001F3FF\U0000200D\U0001F52C',
    u':profesional_de_la_ciencia_mujer:': u'\U0001F469\U0000200D\U0001F52C',
    u':profesional_de_la_ciencia_mujer_tono_de_piel_claro:': u'\U0001F469\U0001F3FB\U0000200D\U0001F52C',
    u':profesional_de_la_ciencia_mujer_tono_de_piel_claro_medio:': u'\U0001F469\U0001F3FC\U0000200D\U0001F52C',
    u':profesional_de_la_ciencia_mujer_tono_de_piel_medio:': u'\U0001F469\U0001F3FD\U0000200D\U0001F52C',
    u':profesional_de_la_ciencia_mujer_tono_de_piel_oscuro_medio:': u'\U0001F469\U0001F3FE\U0000200D\U0001F52C',
    u':profesional_de_la_ciencia_mujer_tono_de_piel_oscuro:': u'\U0001F469\U0001F3FF\U0000200D\U0001F52C',
    u':profesional_de_la_tecnología:': u'\U0001F9D1\U0000200D\U0001F4BB',
    u':profesional_de_la_tecnología_tono_de_piel_claro:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F4BB',
    u':profesional_de_la_tecnología_tono_de_piel_claro_medio:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F4BB',
    u':profesional_de_la_tecnología_tono_de_piel_medio:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F4BB',
    u':profesional_de_la_tecnología_tono_de_piel_oscuro_medio:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F4BB',
    u':profesional_de_la_tecnología_tono_de_piel_oscuro:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F4BB',
    u':profesional_de_la_tecnología_hombre:': u'\U0001F468\U0000200D\U0001F4BB',
    u':profesional_de_la_tecnología_hombre_tono_de_piel_claro:': u'\U0001F468\U0001F3FB\U0000200D\U0001F4BB',
    u':profesional_de_la_tecnología_hombre_tono_de_piel_claro_medio:': u'\U0001F468\U0001F3FC\U0000200D\U0001F4BB',
    u':profesional_de_la_tecnología_hombre_tono_de_piel_medio:': u'\U0001F468\U0001F3FD\U0000200D\U0001F4BB',
    u':profesional_de_la_tecnología_hombre_tono_de_piel_oscuro_medio:': u'\U0001F468\U0001F3FE\U0000200D\U0001F4BB',
    u':profesional_de_la_tecnología_hombre_tono_de_piel_oscuro:': u'\U0001F468\U0001F3FF\U0000200D\U0001F4BB',
    u':profesional_de_la_tecnología_mujer:': u'\U0001F469\U0000200D\U0001F4BB',
    u':profesional_de_la_tecnología_mujer_tono_de_piel_claro:': u'\U0001F469\U0001F3FB\U0000200D\U0001F4BB',
    u':profesional_de_la_tecnología_mujer_tono_de_piel_claro_medio:': u'\U0001F469\U0001F3FC\U0000200D\U0001F4BB',
    u':profesional_de_la_tecnología_mujer_tono_de_piel_medio:': u'\U0001F469\U0001F3FD\U0000200D\U0001F4BB',
    u':profesional_de_la_tecnología_mujer_tono_de_piel_oscuro_medio:': u'\U0001F469\U0001F3FE\U0000200D\U0001F4BB',
    u':profesional_de_la_tecnología_mujer_tono_de_piel_oscuro:': u'\U0001F469\U0001F3FF\U0000200D\U0001F4BB',
    u':cantante:': u'\U0001F9D1\U0000200D\U0001F3A4',
    u':cantante_tono_de_piel_claro:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F3A4',
    u':cantante_tono_de_piel_claro_medio:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F3A4',
    u':cantante_tono_de_piel_medio:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F3A4',
    u':cantante_tono_de_piel_oscuro_medio:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F3A4',
    u':cantante_tono_de_piel_oscuro:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F3A4',
    u':cantante_hombre:': u'\U0001F468\U0000200D\U0001F3A4',
    u':cantante_hombre_tono_de_piel_claro:': u'\U0001F468\U0001F3FB\U0000200D\U0001F3A4',
    u':cantante_hombre_tono_de_piel_claro_medio:': u'\U0001F468\U0001F3FC\U0000200D\U0001F3A4',
    u':cantante_hombre_tono_de_piel_medio:': u'\U0001F468\U0001F3FD\U0000200D\U0001F3A4',
    u':cantante_hombre_tono_de_piel_oscuro_medio:': u'\U0001F468\U0001F3FE\U0000200D\U0001F3A4',
    u':cantante_hombre_tono_de_piel_oscuro:': u'\U0001F468\U0001F3FF\U0000200D\U0001F3A4',
    u':cantante_mujer:': u'\U0001F469\U0000200D\U0001F3A4',
    u':cantante_mujer_tono_de_piel_claro:': u'\U0001F469\U0001F3FB\U0000200D\U0001F3A4',
    u':cantante_mujer_tono_de_piel_claro_medio:': u'\U0001F469\U0001F3FC\U0000200D\U0001F3A4',
    u':cantante_mujer_tono_de_piel_medio:': u'\U0001F469\U0001F3FD\U0000200D\U0001F3A4',
    u':cantante_mujer_tono_de_piel_oscuro_medio:': u'\U0001F469\U0001F3FE\U0000200D\U0001F3A4',
    u':cantante_mujer_tono_de_piel_oscuro:': u'\U0001F469\U0001F3FF\U0000200D\U0001F3A4',
    u':artista:': u'\U0001F9D1\U0000200D\U0001F3A8',
    u':artista_tono_de_piel_claro:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F3A8',
    u':artista_tono_de_piel_claro_medio:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F3A8',
    u':artista_tono_de_piel_medio:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F3A8',
    u':artista_tono_de_piel_oscuro_medio:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F3A8',
    u':artista_tono_de_piel_oscuro:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F3A8',
    u':artista_hombre:': u'\U0001F468\U0000200D\U0001F3A8',
    u':artista_hombre_tono_de_piel_claro:': u'\U0001F468\U0001F3FB\U0000200D\U0001F3A8',
    u':artista_hombre_tono_de_piel_claro_medio:': u'\U0001F468\U0001F3FC\U0000200D\U0001F3A8',
    u':artista_hombre_tono_de_piel_medio:': u'\U0001F468\U0001F3FD\U0000200D\U0001F3A8',
    u':artista_hombre_tono_de_piel_oscuro_medio:': u'\U0001F468\U0001F3FE\U0000200D\U0001F3A8',
    u':artista_hombre_tono_de_piel_oscuro:': u'\U0001F468\U0001F3FF\U0000200D\U0001F3A8',
    u':artista_mujer:': u'\U0001F469\U0000200D\U0001F3A8',
    u':artista_mujer_tono_de_piel_claro:': u'\U0001F469\U0001F3FB\U0000200D\U0001F3A8',
    u':artista_mujer_tono_de_piel_claro_medio:': u'\U0001F469\U0001F3FC\U0000200D\U0001F3A8',
    u':artista_mujer_tono_de_piel_medio:': u'\U0001F469\U0001F3FD\U0000200D\U0001F3A8',
    u':artista_mujer_tono_de_piel_oscuro_medio:': u'\U0001F469\U0001F3FE\U0000200D\U0001F3A8',
    u':artista_mujer_tono_de_piel_oscuro:': u'\U0001F469\U0001F3FF\U0000200D\U0001F3A8',
    u':piloto:': u'\U0001F9D1\U0000200D\U00002708\U0000FE0F',
    u':piloto_tono_de_piel_claro:': u'\U0001F9D1\U0001F3FB\U0000200D\U00002708\U0000FE0F',
    u':piloto_tono_de_piel_claro_medio:': u'\U0001F9D1\U0001F3FC\U0000200D\U00002708\U0000FE0F',
    u':piloto_tono_de_piel_medio:': u'\U0001F9D1\U0001F3FD\U0000200D\U00002708\U0000FE0F',
    u':piloto_tono_de_piel_oscuro_medio:': u'\U0001F9D1\U0001F3FE\U0000200D\U00002708\U0000FE0F',
    u':piloto_tono_de_piel_oscuro:': u'\U0001F9D1\U0001F3FF\U0000200D\U00002708\U0000FE0F',
    u':piloto_hombre:': u'\U0001F468\U0000200D\U00002708\U0000FE0F',
    u':piloto_hombre_tono_de_piel_claro:': u'\U0001F468\U0001F3FB\U0000200D\U00002708\U0000FE0F',
    u':piloto_hombre_tono_de_piel_claro_medio:': u'\U0001F468\U0001F3FC\U0000200D\U00002708\U0000FE0F',
    u':piloto_hombre_tono_de_piel_medio:': u'\U0001F468\U0001F3FD\U0000200D\U00002708\U0000FE0F',
    u':piloto_hombre_tono_de_piel_oscuro_medio:': u'\U0001F468\U0001F3FE\U0000200D\U00002708\U0000FE0F',
    u':piloto_hombre_tono_de_piel_oscuro:': u'\U0001F468\U0001F3FF\U0000200D\U00002708\U0000FE0F',
    u':piloto_mujer:': u'\U0001F469\U0000200D\U00002708\U0000FE0F',
    u':piloto_mujer_tono_de_piel_claro:': u'\U0001F469\U0001F3FB\U0000200D\U00002708\U0000FE0F',
    u':piloto_mujer_tono_de_piel_claro_medio:': u'\U0001F469\U0001F3FC\U0000200D\U00002708\U0000FE0F',
    u':piloto_mujer_tono_de_piel_medio:': u'\U0001F469\U0001F3FD\U0000200D\U00002708\U0000FE0F',
    u':piloto_mujer_tono_de_piel_oscuro_medio:': u'\U0001F469\U0001F3FE\U0000200D\U00002708\U0000FE0F',
    u':piloto_mujer_tono_de_piel_oscuro:': u'\U0001F469\U0001F3FF\U0000200D\U00002708\U0000FE0F',
    u':astronauta:': u'\U0001F9D1\U0000200D\U0001F680',
    u':astronauta_tono_de_piel_claro:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F680',
    u':astronauta_tono_de_piel_claro_medio:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F680',
    u':astronauta_tono_de_piel_medio:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F680',
    u':astronauta_tono_de_piel_oscuro_medio:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F680',
    u':astronauta_tono_de_piel_oscuro:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F680',
    u':astronauta_hombre:': u'\U0001F468\U0000200D\U0001F680',
    u':astronauta_hombre_tono_de_piel_claro:': u'\U0001F468\U0001F3FB\U0000200D\U0001F680',
    u':astronauta_hombre_tono_de_piel_claro_medio:': u'\U0001F468\U0001F3FC\U0000200D\U0001F680',
    u':astronauta_hombre_tono_de_piel_medio:': u'\U0001F468\U0001F3FD\U0000200D\U0001F680',
    u':astronauta_hombre_tono_de_piel_oscuro_medio:': u'\U0001F468\U0001F3FE\U0000200D\U0001F680',
    u':astronauta_hombre_tono_de_piel_oscuro:': u'\U0001F468\U0001F3FF\U0000200D\U0001F680',
    u':astronauta_mujer:': u'\U0001F469\U0000200D\U0001F680',
    u':astronauta_mujer_tono_de_piel_claro:': u'\U0001F469\U0001F3FB\U0000200D\U0001F680',
    u':astronauta_mujer_tono_de_piel_claro_medio:': u'\U0001F469\U0001F3FC\U0000200D\U0001F680',
    u':astronauta_mujer_tono_de_piel_medio:': u'\U0001F469\U0001F3FD\U0000200D\U0001F680',
    u':astronauta_mujer_tono_de_piel_oscuro_medio:': u'\U0001F469\U0001F3FE\U0000200D\U0001F680',
    u':astronauta_mujer_tono_de_piel_oscuro:': u'\U0001F469\U0001F3FF\U0000200D\U0001F680',
    u':bombero:': u'\U0001F9D1\U0000200D\U0001F692',
    u':bombero_tono_de_piel_claro:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F692',
    u':bombero_tono_de_piel_claro_medio:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F692',
    u':bombero_tono_de_piel_medio:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F692',
    u':bombero_tono_de_piel_oscuro_medio:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F692',
    u':bombero_tono_de_piel_oscuro:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F692',
    u':bombero_hombre:': u'\U0001F468\U0000200D\U0001F692',
    u':bombero_hombre_tono_de_piel_claro:': u'\U0001F468\U0001F3FB\U0000200D\U0001F692',
    u':bombero_hombre_tono_de_piel_claro_medio:': u'\U0001F468\U0001F3FC\U0000200D\U0001F692',
    u':bombero_hombre_tono_de_piel_medio:': u'\U0001F468\U0001F3FD\U0000200D\U0001F692',
    u':bombero_hombre_tono_de_piel_oscuro_medio:': u'\U0001F468\U0001F3FE\U0000200D\U0001F692',
    u':bombero_hombre_tono_de_piel_oscuro:': u'\U0001F468\U0001F3FF\U0000200D\U0001F692',
    u':bombera:': u'\U0001F469\U0000200D\U0001F692',
    u':bombera_tono_de_piel_claro:': u'\U0001F469\U0001F3FB\U0000200D\U0001F692',
    u':bombera_tono_de_piel_claro_medio:': u'\U0001F469\U0001F3FC\U0000200D\U0001F692',
    u':bombera_tono_de_piel_medio:': u'\U0001F469\U0001F3FD\U0000200D\U0001F692',
    u':bombera_tono_de_piel_oscuro_medio:': u'\U0001F469\U0001F3FE\U0000200D\U0001F692',
    u':bombera_tono_de_piel_oscuro:': u'\U0001F469\U0001F3FF\U0000200D\U0001F692',
    u':agente_de_policía:': u'\U0001F46E',
    u':agente_de_policía_tono_de_piel_claro:': u'\U0001F46E\U0001F3FB',
    u':agente_de_policía_tono_de_piel_claro_medio:': u'\U0001F46E\U0001F3FC',
    u':agente_de_policía_tono_de_piel_medio:': u'\U0001F46E\U0001F3FD',
    u':agente_de_policía_tono_de_piel_oscuro_medio:': u'\U0001F46E\U0001F3FE',
    u':agente_de_policía_tono_de_piel_oscuro:': u'\U0001F46E\U0001F3FF',
    u':agente_de_policía_hombre:': u'\U0001F46E\U0000200D\U00002642\U0000FE0F',
    u':agente_de_policía_hombre_tono_de_piel_claro:': u'\U0001F46E\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':agente_de_policía_hombre_tono_de_piel_claro_medio:': u'\U0001F46E\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':agente_de_policía_hombre_tono_de_piel_medio:': u'\U0001F46E\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':agente_de_policía_hombre_tono_de_piel_oscuro_medio:': u'\U0001F46E\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':agente_de_policía_hombre_tono_de_piel_oscuro:': u'\U0001F46E\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':agente_de_policía_mujer:': u'\U0001F46E\U0000200D\U00002640\U0000FE0F',
    u':agente_de_policía_mujer_tono_de_piel_claro:': u'\U0001F46E\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':agente_de_policía_mujer_tono_de_piel_claro_medio:': u'\U0001F46E\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':agente_de_policía_mujer_tono_de_piel_medio:': u'\U0001F46E\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':agente_de_policía_mujer_tono_de_piel_oscuro_medio:': u'\U0001F46E\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':agente_de_policía_mujer_tono_de_piel_oscuro:': u'\U0001F46E\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':detective:': u'\U0001F575\U0000FE0F',
    u':detective_tono_de_piel_claro:': u'\U0001F575\U0001F3FB',
    u':detective_tono_de_piel_claro_medio:': u'\U0001F575\U0001F3FC',
    u':detective_tono_de_piel_medio:': u'\U0001F575\U0001F3FD',
    u':detective_tono_de_piel_oscuro_medio:': u'\U0001F575\U0001F3FE',
    u':detective_tono_de_piel_oscuro:': u'\U0001F575\U0001F3FF',
    u':detective_hombre:': u'\U0001F575\U0000FE0F\U0000200D\U00002642\U0000FE0F',
    u':detective_hombre_tono_de_piel_claro:': u'\U0001F575\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':detective_hombre_tono_de_piel_claro_medio:': u'\U0001F575\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':detective_hombre_tono_de_piel_medio:': u'\U0001F575\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':detective_hombre_tono_de_piel_oscuro_medio:': u'\U0001F575\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':detective_hombre_tono_de_piel_oscuro:': u'\U0001F575\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':detective_mujer:': u'\U0001F575\U0000FE0F\U0000200D\U00002640\U0000FE0F',
    u':detective_mujer_tono_de_piel_claro:': u'\U0001F575\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':detective_mujer_tono_de_piel_claro_medio:': u'\U0001F575\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':detective_mujer_tono_de_piel_medio:': u'\U0001F575\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':detective_mujer_tono_de_piel_oscuro_medio:': u'\U0001F575\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':detective_mujer_tono_de_piel_oscuro:': u'\U0001F575\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':guardia:': u'\U0001F482',
    u':guardia_tono_de_piel_claro:': u'\U0001F482\U0001F3FB',
    u':guardia_tono_de_piel_claro_medio:': u'\U0001F482\U0001F3FC',
    u':guardia_tono_de_piel_medio:': u'\U0001F482\U0001F3FD',
    u':guardia_tono_de_piel_oscuro_medio:': u'\U0001F482\U0001F3FE',
    u':guardia_tono_de_piel_oscuro:': u'\U0001F482\U0001F3FF',
    u':guardia_hombre:': u'\U0001F482\U0000200D\U00002642\U0000FE0F',
    u':guardia_hombre_tono_de_piel_claro:': u'\U0001F482\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':guardia_hombre_tono_de_piel_claro_medio:': u'\U0001F482\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':guardia_hombre_tono_de_piel_medio:': u'\U0001F482\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':guardia_hombre_tono_de_piel_oscuro_medio:': u'\U0001F482\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':guardia_hombre_tono_de_piel_oscuro:': u'\U0001F482\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':guardia_mujer:': u'\U0001F482\U0000200D\U00002640\U0000FE0F',
    u':guardia_mujer_tono_de_piel_claro:': u'\U0001F482\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':guardia_mujer_tono_de_piel_claro_medio:': u'\U0001F482\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':guardia_mujer_tono_de_piel_medio:': u'\U0001F482\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':guardia_mujer_tono_de_piel_oscuro_medio:': u'\U0001F482\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':guardia_mujer_tono_de_piel_oscuro:': u'\U0001F482\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':ninja:': u'\U0001F977',
    u':ninja_tono_de_piel_claro:': u'\U0001F977\U0001F3FB',
    u':ninja_tono_de_piel_claro_medio:': u'\U0001F977\U0001F3FC',
    u':ninja_tono_de_piel_medio:': u'\U0001F977\U0001F3FD',
    u':ninja_tono_de_piel_oscuro_medio:': u'\U0001F977\U0001F3FE',
    u':ninja_tono_de_piel_oscuro:': u'\U0001F977\U0001F3FF',
    u':profesional_de_la_construcción:': u'\U0001F477',
    u':profesional_de_la_construcción_tono_de_piel_claro:': u'\U0001F477\U0001F3FB',
    u':profesional_de_la_construcción_tono_de_piel_claro_medio:': u'\U0001F477\U0001F3FC',
    u':profesional_de_la_construcción_tono_de_piel_medio:': u'\U0001F477\U0001F3FD',
    u':profesional_de_la_construcción_tono_de_piel_oscuro_medio:': u'\U0001F477\U0001F3FE',
    u':profesional_de_la_construcción_tono_de_piel_oscuro:': u'\U0001F477\U0001F3FF',
    u':profesional_de_la_construcción_hombre:': u'\U0001F477\U0000200D\U00002642\U0000FE0F',
    u':profesional_de_la_construcción_hombre_tono_de_piel_claro:': u'\U0001F477\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':profesional_de_la_construcción_hombre_tono_de_piel_claro_medio:': u'\U0001F477\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':profesional_de_la_construcción_hombre_tono_de_piel_medio:': u'\U0001F477\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':profesional_de_la_construcción_hombre_tono_de_piel_oscuro_medio:': u'\U0001F477\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':profesional_de_la_construcción_hombre_tono_de_piel_oscuro:': u'\U0001F477\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':profesional_de_la_construcción_mujer:': u'\U0001F477\U0000200D\U00002640\U0000FE0F',
    u':profesional_de_la_construcción_mujer_tono_de_piel_claro:': u'\U0001F477\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':profesional_de_la_construcción_mujer_tono_de_piel_claro_medio:': u'\U0001F477\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':profesional_de_la_construcción_mujer_tono_de_piel_medio:': u'\U0001F477\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':profesional_de_la_construcción_mujer_tono_de_piel_oscuro_medio:': u'\U0001F477\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':profesional_de_la_construcción_mujer_tono_de_piel_oscuro:': u'\U0001F477\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':príncipe:': u'\U0001F934',
    u':príncipe_tono_de_piel_claro:': u'\U0001F934\U0001F3FB',
    u':príncipe_tono_de_piel_claro_medio:': u'\U0001F934\U0001F3FC',
    u':príncipe_tono_de_piel_medio:': u'\U0001F934\U0001F3FD',
    u':príncipe_tono_de_piel_oscuro_medio:': u'\U0001F934\U0001F3FE',
    u':príncipe_tono_de_piel_oscuro:': u'\U0001F934\U0001F3FF',
    u':princesa:': u'\U0001F478',
    u':princesa_tono_de_piel_claro:': u'\U0001F478\U0001F3FB',
    u':princesa_tono_de_piel_claro_medio:': u'\U0001F478\U0001F3FC',
    u':princesa_tono_de_piel_medio:': u'\U0001F478\U0001F3FD',
    u':princesa_tono_de_piel_oscuro_medio:': u'\U0001F478\U0001F3FE',
    u':princesa_tono_de_piel_oscuro:': u'\U0001F478\U0001F3FF',
    u':persona_con_turbante:': u'\U0001F473',
    u':persona_con_turbante_tono_de_piel_claro:': u'\U0001F473\U0001F3FB',
    u':persona_con_turbante_tono_de_piel_claro_medio:': u'\U0001F473\U0001F3FC',
    u':persona_con_turbante_tono_de_piel_medio:': u'\U0001F473\U0001F3FD',
    u':persona_con_turbante_tono_de_piel_oscuro_medio:': u'\U0001F473\U0001F3FE',
    u':persona_con_turbante_tono_de_piel_oscuro:': u'\U0001F473\U0001F3FF',
    u':hombre_con_turbante:': u'\U0001F473\U0000200D\U00002642\U0000FE0F',
    u':hombre_con_turbante_tono_de_piel_claro:': u'\U0001F473\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':hombre_con_turbante_tono_de_piel_claro_medio:': u'\U0001F473\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':hombre_con_turbante_tono_de_piel_medio:': u'\U0001F473\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':hombre_con_turbante_tono_de_piel_oscuro_medio:': u'\U0001F473\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':hombre_con_turbante_tono_de_piel_oscuro:': u'\U0001F473\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mujer_con_turbante:': u'\U0001F473\U0000200D\U00002640\U0000FE0F',
    u':mujer_con_turbante_tono_de_piel_claro:': u'\U0001F473\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mujer_con_turbante_tono_de_piel_claro_medio:': u'\U0001F473\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mujer_con_turbante_tono_de_piel_medio:': u'\U0001F473\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mujer_con_turbante_tono_de_piel_oscuro_medio:': u'\U0001F473\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mujer_con_turbante_tono_de_piel_oscuro:': u'\U0001F473\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':hombre_con_gorro_chino:': u'\U0001F472',
    u':hombre_con_gorro_chino_tono_de_piel_claro:': u'\U0001F472\U0001F3FB',
    u':hombre_con_gorro_chino_tono_de_piel_claro_medio:': u'\U0001F472\U0001F3FC',
    u':hombre_con_gorro_chino_tono_de_piel_medio:': u'\U0001F472\U0001F3FD',
    u':hombre_con_gorro_chino_tono_de_piel_oscuro_medio:': u'\U0001F472\U0001F3FE',
    u':hombre_con_gorro_chino_tono_de_piel_oscuro:': u'\U0001F472\U0001F3FF',
    u':mujer_con_hiyab:': u'\U0001F9D5',
    u':mujer_con_hiyab_tono_de_piel_claro:': u'\U0001F9D5\U0001F3FB',
    u':mujer_con_hiyab_tono_de_piel_claro_medio:': u'\U0001F9D5\U0001F3FC',
    u':mujer_con_hiyab_tono_de_piel_medio:': u'\U0001F9D5\U0001F3FD',
    u':mujer_con_hiyab_tono_de_piel_oscuro_medio:': u'\U0001F9D5\U0001F3FE',
    u':mujer_con_hiyab_tono_de_piel_oscuro:': u'\U0001F9D5\U0001F3FF',
    u':persona_con_esmoquin:': u'\U0001F935',
    u':persona_con_esmoquin_tono_de_piel_claro:': u'\U0001F935\U0001F3FB',
    u':persona_con_esmoquin_tono_de_piel_claro_medio:': u'\U0001F935\U0001F3FC',
    u':persona_con_esmoquin_tono_de_piel_medio:': u'\U0001F935\U0001F3FD',
    u':persona_con_esmoquin_tono_de_piel_oscuro_medio:': u'\U0001F935\U0001F3FE',
    u':persona_con_esmoquin_tono_de_piel_oscuro:': u'\U0001F935\U0001F3FF',
    u':hombre_con_esmoquin:': u'\U0001F935\U0000200D\U00002642\U0000FE0F',
    u':hombre_con_esmoquin_tono_de_piel_claro:': u'\U0001F935\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':hombre_con_esmoquin_tono_de_piel_claro_medio:': u'\U0001F935\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':hombre_con_esmoquin_tono_de_piel_medio:': u'\U0001F935\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':hombre_con_esmoquin_tono_de_piel_oscuro_medio:': u'\U0001F935\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':hombre_con_esmoquin_tono_de_piel_oscuro:': u'\U0001F935\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mujer_con_esmoquin:': u'\U0001F935\U0000200D\U00002640\U0000FE0F',
    u':mujer_con_esmoquin_tono_de_piel_claro:': u'\U0001F935\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mujer_con_esmoquin_tono_de_piel_claro_medio:': u'\U0001F935\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mujer_con_esmoquin_tono_de_piel_medio:': u'\U0001F935\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mujer_con_esmoquin_tono_de_piel_oscuro_medio:': u'\U0001F935\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mujer_con_esmoquin_tono_de_piel_oscuro:': u'\U0001F935\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':persona_con_velo:': u'\U0001F470',
    u':persona_con_velo_tono_de_piel_claro:': u'\U0001F470\U0001F3FB',
    u':persona_con_velo_tono_de_piel_claro_medio:': u'\U0001F470\U0001F3FC',
    u':persona_con_velo_tono_de_piel_medio:': u'\U0001F470\U0001F3FD',
    u':persona_con_velo_tono_de_piel_oscuro_medio:': u'\U0001F470\U0001F3FE',
    u':persona_con_velo_tono_de_piel_oscuro:': u'\U0001F470\U0001F3FF',
    u':hombre_con_velo:': u'\U0001F470\U0000200D\U00002642\U0000FE0F',
    u':hombre_con_velo_tono_de_piel_claro:': u'\U0001F470\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':hombre_con_velo_tono_de_piel_claro_medio:': u'\U0001F470\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':hombre_con_velo_tono_de_piel_medio:': u'\U0001F470\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':hombre_con_velo_tono_de_piel_oscuro_medio:': u'\U0001F470\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':hombre_con_velo_tono_de_piel_oscuro:': u'\U0001F470\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mujer_con_velo:': u'\U0001F470\U0000200D\U00002640\U0000FE0F',
    u':mujer_con_velo_tono_de_piel_claro:': u'\U0001F470\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mujer_con_velo_tono_de_piel_claro_medio:': u'\U0001F470\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mujer_con_velo_tono_de_piel_medio:': u'\U0001F470\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mujer_con_velo_tono_de_piel_oscuro_medio:': u'\U0001F470\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mujer_con_velo_tono_de_piel_oscuro:': u'\U0001F470\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':mujer_embarazada:': u'\U0001F930',
    u':mujer_embarazada_tono_de_piel_claro:': u'\U0001F930\U0001F3FB',
    u':mujer_embarazada_tono_de_piel_claro_medio:': u'\U0001F930\U0001F3FC',
    u':mujer_embarazada_tono_de_piel_medio:': u'\U0001F930\U0001F3FD',
    u':mujer_embarazada_tono_de_piel_oscuro_medio:': u'\U0001F930\U0001F3FE',
    u':mujer_embarazada_tono_de_piel_oscuro:': u'\U0001F930\U0001F3FF',
    u':lactancia_materna:': u'\U0001F931',
    u':lactancia_materna_tono_de_piel_claro:': u'\U0001F931\U0001F3FB',
    u':lactancia_materna_tono_de_piel_claro_medio:': u'\U0001F931\U0001F3FC',
    u':lactancia_materna_tono_de_piel_medio:': u'\U0001F931\U0001F3FD',
    u':lactancia_materna_tono_de_piel_oscuro_medio:': u'\U0001F931\U0001F3FE',
    u':lactancia_materna_tono_de_piel_oscuro:': u'\U0001F931\U0001F3FF',
    u':mujer_alimentando_a_bebé:': u'\U0001F469\U0000200D\U0001F37C',
    u':mujer_alimentando_a_bebé_tono_de_piel_claro:': u'\U0001F469\U0001F3FB\U0000200D\U0001F37C',
    u':mujer_alimentando_a_bebé_tono_de_piel_claro_medio:': u'\U0001F469\U0001F3FC\U0000200D\U0001F37C',
    u':mujer_alimentando_a_bebé_tono_de_piel_medio:': u'\U0001F469\U0001F3FD\U0000200D\U0001F37C',
    u':mujer_alimentando_a_bebé_tono_de_piel_oscuro_medio:': u'\U0001F469\U0001F3FE\U0000200D\U0001F37C',
    u':mujer_alimentando_a_bebé_tono_de_piel_oscuro:': u'\U0001F469\U0001F3FF\U0000200D\U0001F37C',
    u':hombre_alimentando_a_bebé:': u'\U0001F468\U0000200D\U0001F37C',
    u':hombre_alimentando_a_bebé_tono_de_piel_claro:': u'\U0001F468\U0001F3FB\U0000200D\U0001F37C',
    u':hombre_alimentando_a_bebé_tono_de_piel_claro_medio:': u'\U0001F468\U0001F3FC\U0000200D\U0001F37C',
    u':hombre_alimentando_a_bebé_tono_de_piel_medio:': u'\U0001F468\U0001F3FD\U0000200D\U0001F37C',
    u':hombre_alimentando_a_bebé_tono_de_piel_oscuro_medio:': u'\U0001F468\U0001F3FE\U0000200D\U0001F37C',
    u':hombre_alimentando_a_bebé_tono_de_piel_oscuro:': u'\U0001F468\U0001F3FF\U0000200D\U0001F37C',
    u':persona_alimentando_a_bebé:': u'\U0001F9D1\U0000200D\U0001F37C',
    u':persona_alimentando_a_bebé_tono_de_piel_claro:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F37C',
    u':persona_alimentando_a_bebé_tono_de_piel_claro_medio:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F37C',
    u':persona_alimentando_a_bebé_tono_de_piel_medio:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F37C',
    u':persona_alimentando_a_bebé_tono_de_piel_oscuro_medio:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F37C',
    u':persona_alimentando_a_bebé_tono_de_piel_oscuro:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F37C',
    u':bebé_ángel:': u'\U0001F47C',
    u':bebé_ángel_tono_de_piel_claro:': u'\U0001F47C\U0001F3FB',
    u':bebé_ángel_tono_de_piel_claro_medio:': u'\U0001F47C\U0001F3FC',
    u':bebé_ángel_tono_de_piel_medio:': u'\U0001F47C\U0001F3FD',
    u':bebé_ángel_tono_de_piel_oscuro_medio:': u'\U0001F47C\U0001F3FE',
    u':bebé_ángel_tono_de_piel_oscuro:': u'\U0001F47C\U0001F3FF',
    u':papá_noel:': u'\U0001F385',
    u':papá_noel_tono_de_piel_claro:': u'\U0001F385\U0001F3FB',
    u':papá_noel_tono_de_piel_claro_medio:': u'\U0001F385\U0001F3FC',
    u':papá_noel_tono_de_piel_medio:': u'\U0001F385\U0001F3FD',
    u':papá_noel_tono_de_piel_oscuro_medio:': u'\U0001F385\U0001F3FE',
    u':papá_noel_tono_de_piel_oscuro:': u'\U0001F385\U0001F3FF',
    u':mamá_noel:': u'\U0001F936',
    u':mamá_noel_tono_de_piel_claro:': u'\U0001F936\U0001F3FB',
    u':mamá_noel_tono_de_piel_claro_medio:': u'\U0001F936\U0001F3FC',
    u':mamá_noel_tono_de_piel_medio:': u'\U0001F936\U0001F3FD',
    u':mamá_noel_tono_de_piel_oscuro_medio:': u'\U0001F936\U0001F3FE',
    u':mamá_noel_tono_de_piel_oscuro:': u'\U0001F936\U0001F3FF',
    u':noel:': u'\U0001F9D1\U0000200D\U0001F384',
    u':noel_tono_de_piel_claro:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F384',
    u':noel_tono_de_piel_claro_medio:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F384',
    u':noel_tono_de_piel_medio:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F384',
    u':noel_tono_de_piel_oscuro_medio:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F384',
    u':noel_tono_de_piel_oscuro:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F384',
    u':personaje_de_superhéroe:': u'\U0001F9B8',
    u':personaje_de_superhéroe_tono_de_piel_claro:': u'\U0001F9B8\U0001F3FB',
    u':personaje_de_superhéroe_tono_de_piel_claro_medio:': u'\U0001F9B8\U0001F3FC',
    u':personaje_de_superhéroe_tono_de_piel_medio:': u'\U0001F9B8\U0001F3FD',
    u':personaje_de_superhéroe_tono_de_piel_oscuro_medio:': u'\U0001F9B8\U0001F3FE',
    u':personaje_de_superhéroe_tono_de_piel_oscuro:': u'\U0001F9B8\U0001F3FF',
    u':superhéroe:': u'\U0001F9B8\U0000200D\U00002642\U0000FE0F',
    u':superhéroe_tono_de_piel_claro:': u'\U0001F9B8\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':superhéroe_tono_de_piel_claro_medio:': u'\U0001F9B8\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':superhéroe_tono_de_piel_medio:': u'\U0001F9B8\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':superhéroe_tono_de_piel_oscuro_medio:': u'\U0001F9B8\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':superhéroe_tono_de_piel_oscuro:': u'\U0001F9B8\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':superheroína:': u'\U0001F9B8\U0000200D\U00002640\U0000FE0F',
    u':superheroína_tono_de_piel_claro:': u'\U0001F9B8\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':superheroína_tono_de_piel_claro_medio:': u'\U0001F9B8\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':superheroína_tono_de_piel_medio:': u'\U0001F9B8\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':superheroína_tono_de_piel_oscuro_medio:': u'\U0001F9B8\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':superheroína_tono_de_piel_oscuro:': u'\U0001F9B8\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':personaje_de_supervillano:': u'\U0001F9B9',
    u':personaje_de_supervillano_tono_de_piel_claro:': u'\U0001F9B9\U0001F3FB',
    u':personaje_de_supervillano_tono_de_piel_claro_medio:': u'\U0001F9B9\U0001F3FC',
    u':personaje_de_supervillano_tono_de_piel_medio:': u'\U0001F9B9\U0001F3FD',
    u':personaje_de_supervillano_tono_de_piel_oscuro_medio:': u'\U0001F9B9\U0001F3FE',
    u':personaje_de_supervillano_tono_de_piel_oscuro:': u'\U0001F9B9\U0001F3FF',
    u':supervillano:': u'\U0001F9B9\U0000200D\U00002642\U0000FE0F',
    u':supervillano_tono_de_piel_claro:': u'\U0001F9B9\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':supervillano_tono_de_piel_claro_medio:': u'\U0001F9B9\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':supervillano_tono_de_piel_medio:': u'\U0001F9B9\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':supervillano_tono_de_piel_oscuro_medio:': u'\U0001F9B9\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':supervillano_tono_de_piel_oscuro:': u'\U0001F9B9\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':supervillana:': u'\U0001F9B9\U0000200D\U00002640\U0000FE0F',
    u':supervillana_tono_de_piel_claro:': u'\U0001F9B9\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':supervillana_tono_de_piel_claro_medio:': u'\U0001F9B9\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':supervillana_tono_de_piel_medio:': u'\U0001F9B9\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':supervillana_tono_de_piel_oscuro_medio:': u'\U0001F9B9\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':supervillana_tono_de_piel_oscuro:': u'\U0001F9B9\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':persona_maga:': u'\U0001F9D9',
    u':persona_maga_tono_de_piel_claro:': u'\U0001F9D9\U0001F3FB',
    u':persona_maga_tono_de_piel_claro_medio:': u'\U0001F9D9\U0001F3FC',
    u':persona_maga_tono_de_piel_medio:': u'\U0001F9D9\U0001F3FD',
    u':persona_maga_tono_de_piel_oscuro_medio:': u'\U0001F9D9\U0001F3FE',
    u':persona_maga_tono_de_piel_oscuro:': u'\U0001F9D9\U0001F3FF',
    u':mago:': u'\U0001F9D9\U0000200D\U00002642\U0000FE0F',
    u':mago_tono_de_piel_claro:': u'\U0001F9D9\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':mago_tono_de_piel_claro_medio:': u'\U0001F9D9\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':mago_tono_de_piel_medio:': u'\U0001F9D9\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':mago_tono_de_piel_oscuro_medio:': u'\U0001F9D9\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':mago_tono_de_piel_oscuro:': u'\U0001F9D9\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':maga:': u'\U0001F9D9\U0000200D\U00002640\U0000FE0F',
    u':maga_tono_de_piel_claro:': u'\U0001F9D9\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':maga_tono_de_piel_claro_medio:': u'\U0001F9D9\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':maga_tono_de_piel_medio:': u'\U0001F9D9\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':maga_tono_de_piel_oscuro_medio:': u'\U0001F9D9\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':maga_tono_de_piel_oscuro:': u'\U0001F9D9\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':hada:': u'\U0001F9DA',
    u':hada_tono_de_piel_claro:': u'\U0001F9DA\U0001F3FB',
    u':hada_tono_de_piel_claro_medio:': u'\U0001F9DA\U0001F3FC',
    u':hada_tono_de_piel_medio:': u'\U0001F9DA\U0001F3FD',
    u':hada_tono_de_piel_oscuro_medio:': u'\U0001F9DA\U0001F3FE',
    u':hada_tono_de_piel_oscuro:': u'\U0001F9DA\U0001F3FF',
    u':hada_hombre:': u'\U0001F9DA\U0000200D\U00002642\U0000FE0F',
    u':hada_hombre_tono_de_piel_claro:': u'\U0001F9DA\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':hada_hombre_tono_de_piel_claro_medio:': u'\U0001F9DA\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':hada_hombre_tono_de_piel_medio:': u'\U0001F9DA\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':hada_hombre_tono_de_piel_oscuro_medio:': u'\U0001F9DA\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':hada_hombre_tono_de_piel_oscuro:': u'\U0001F9DA\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':hada_mujer:': u'\U0001F9DA\U0000200D\U00002640\U0000FE0F',
    u':hada_mujer_tono_de_piel_claro:': u'\U0001F9DA\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':hada_mujer_tono_de_piel_claro_medio:': u'\U0001F9DA\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':hada_mujer_tono_de_piel_medio:': u'\U0001F9DA\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':hada_mujer_tono_de_piel_oscuro_medio:': u'\U0001F9DA\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':hada_mujer_tono_de_piel_oscuro:': u'\U0001F9DA\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':vampiro:': u'\U0001F9DB',
    u':vampiro_tono_de_piel_claro:': u'\U0001F9DB\U0001F3FB',
    u':vampiro_tono_de_piel_claro_medio:': u'\U0001F9DB\U0001F3FC',
    u':vampiro_tono_de_piel_medio:': u'\U0001F9DB\U0001F3FD',
    u':vampiro_tono_de_piel_oscuro_medio:': u'\U0001F9DB\U0001F3FE',
    u':vampiro_tono_de_piel_oscuro:': u'\U0001F9DB\U0001F3FF',
    u':vampiro_hombre:': u'\U0001F9DB\U0000200D\U00002642\U0000FE0F',
    u':vampiro_hombre_tono_de_piel_claro:': u'\U0001F9DB\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':vampiro_hombre_tono_de_piel_claro_medio:': u'\U0001F9DB\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':vampiro_hombre_tono_de_piel_medio:': u'\U0001F9DB\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':vampiro_hombre_tono_de_piel_oscuro_medio:': u'\U0001F9DB\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':vampiro_hombre_tono_de_piel_oscuro:': u'\U0001F9DB\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':vampiresa:': u'\U0001F9DB\U0000200D\U00002640\U0000FE0F',
    u':vampiresa_tono_de_piel_claro:': u'\U0001F9DB\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':vampiresa_tono_de_piel_claro_medio:': u'\U0001F9DB\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':vampiresa_tono_de_piel_medio:': u'\U0001F9DB\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':vampiresa_tono_de_piel_oscuro_medio:': u'\U0001F9DB\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':vampiresa_tono_de_piel_oscuro:': u'\U0001F9DB\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':persona_sirena:': u'\U0001F9DC',
    u':persona_sirena_tono_de_piel_claro:': u'\U0001F9DC\U0001F3FB',
    u':persona_sirena_tono_de_piel_claro_medio:': u'\U0001F9DC\U0001F3FC',
    u':persona_sirena_tono_de_piel_medio:': u'\U0001F9DC\U0001F3FD',
    u':persona_sirena_tono_de_piel_oscuro_medio:': u'\U0001F9DC\U0001F3FE',
    u':persona_sirena_tono_de_piel_oscuro:': u'\U0001F9DC\U0001F3FF',
    u':sirena_hombre:': u'\U0001F9DC\U0000200D\U00002642\U0000FE0F',
    u':sirena_hombre_tono_de_piel_claro:': u'\U0001F9DC\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':sirena_hombre_tono_de_piel_claro_medio:': u'\U0001F9DC\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':sirena_hombre_tono_de_piel_medio:': u'\U0001F9DC\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':sirena_hombre_tono_de_piel_oscuro_medio:': u'\U0001F9DC\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':sirena_hombre_tono_de_piel_oscuro:': u'\U0001F9DC\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':sirena:': u'\U0001F9DC\U0000200D\U00002640\U0000FE0F',
    u':sirena_tono_de_piel_claro:': u'\U0001F9DC\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':sirena_tono_de_piel_claro_medio:': u'\U0001F9DC\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':sirena_tono_de_piel_medio:': u'\U0001F9DC\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':sirena_tono_de_piel_oscuro_medio:': u'\U0001F9DC\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':sirena_tono_de_piel_oscuro:': u'\U0001F9DC\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':elfo:': u'\U0001F9DD',
    u':elfo_tono_de_piel_claro:': u'\U0001F9DD\U0001F3FB',
    u':elfo_tono_de_piel_claro_medio:': u'\U0001F9DD\U0001F3FC',
    u':elfo_tono_de_piel_medio:': u'\U0001F9DD\U0001F3FD',
    u':elfo_tono_de_piel_oscuro_medio:': u'\U0001F9DD\U0001F3FE',
    u':elfo_tono_de_piel_oscuro:': u'\U0001F9DD\U0001F3FF',
    u':elfo_hombre:': u'\U0001F9DD\U0000200D\U00002642\U0000FE0F',
    u':elfo_hombre_tono_de_piel_claro:': u'\U0001F9DD\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':elfo_hombre_tono_de_piel_claro_medio:': u'\U0001F9DD\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':elfo_hombre_tono_de_piel_medio:': u'\U0001F9DD\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':elfo_hombre_tono_de_piel_oscuro_medio:': u'\U0001F9DD\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':elfo_hombre_tono_de_piel_oscuro:': u'\U0001F9DD\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':elfa:': u'\U0001F9DD\U0000200D\U00002640\U0000FE0F',
    u':elfa_tono_de_piel_claro:': u'\U0001F9DD\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':elfa_tono_de_piel_claro_medio:': u'\U0001F9DD\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':elfa_tono_de_piel_medio:': u'\U0001F9DD\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':elfa_tono_de_piel_oscuro_medio:': u'\U0001F9DD\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':elfa_tono_de_piel_oscuro:': u'\U0001F9DD\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':genio:': u'\U0001F9DE',
    u':genio_hombre:': u'\U0001F9DE\U0000200D\U00002642\U0000FE0F',
    u':genio_mujer:': u'\U0001F9DE\U0000200D\U00002640\U0000FE0F',
    u':zombi:': u'\U0001F9DF',
    u':zombi_hombre:': u'\U0001F9DF\U0000200D\U00002642\U0000FE0F',
    u':zombi_mujer:': u'\U0001F9DF\U0000200D\U00002640\U0000FE0F',
    u':persona_recibiendo_masaje:': u'\U0001F486',
    u':persona_recibiendo_masaje_tono_de_piel_claro:': u'\U0001F486\U0001F3FB',
    u':persona_recibiendo_masaje_tono_de_piel_claro_medio:': u'\U0001F486\U0001F3FC',
    u':persona_recibiendo_masaje_tono_de_piel_medio:': u'\U0001F486\U0001F3FD',
    u':persona_recibiendo_masaje_tono_de_piel_oscuro_medio:': u'\U0001F486\U0001F3FE',
    u':persona_recibiendo_masaje_tono_de_piel_oscuro:': u'\U0001F486\U0001F3FF',
    u':hombre_recibiendo_masaje:': u'\U0001F486\U0000200D\U00002642\U0000FE0F',
    u':hombre_recibiendo_masaje_tono_de_piel_claro:': u'\U0001F486\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':hombre_recibiendo_masaje_tono_de_piel_claro_medio:': u'\U0001F486\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':hombre_recibiendo_masaje_tono_de_piel_medio:': u'\U0001F486\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':hombre_recibiendo_masaje_tono_de_piel_oscuro_medio:': u'\U0001F486\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':hombre_recibiendo_masaje_tono_de_piel_oscuro:': u'\U0001F486\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mujer_recibiendo_masaje:': u'\U0001F486\U0000200D\U00002640\U0000FE0F',
    u':mujer_recibiendo_masaje_tono_de_piel_claro:': u'\U0001F486\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mujer_recibiendo_masaje_tono_de_piel_claro_medio:': u'\U0001F486\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mujer_recibiendo_masaje_tono_de_piel_medio:': u'\U0001F486\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mujer_recibiendo_masaje_tono_de_piel_oscuro_medio:': u'\U0001F486\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mujer_recibiendo_masaje_tono_de_piel_oscuro:': u'\U0001F486\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':persona_cortándose_el_pelo:': u'\U0001F487',
    u':persona_cortándose_el_pelo_tono_de_piel_claro:': u'\U0001F487\U0001F3FB',
    u':persona_cortándose_el_pelo_tono_de_piel_claro_medio:': u'\U0001F487\U0001F3FC',
    u':persona_cortándose_el_pelo_tono_de_piel_medio:': u'\U0001F487\U0001F3FD',
    u':persona_cortándose_el_pelo_tono_de_piel_oscuro_medio:': u'\U0001F487\U0001F3FE',
    u':persona_cortándose_el_pelo_tono_de_piel_oscuro:': u'\U0001F487\U0001F3FF',
    u':hombre_cortándose_el_pelo:': u'\U0001F487\U0000200D\U00002642\U0000FE0F',
    u':hombre_cortándose_el_pelo_tono_de_piel_claro:': u'\U0001F487\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':hombre_cortándose_el_pelo_tono_de_piel_claro_medio:': u'\U0001F487\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':hombre_cortándose_el_pelo_tono_de_piel_medio:': u'\U0001F487\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':hombre_cortándose_el_pelo_tono_de_piel_oscuro_medio:': u'\U0001F487\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':hombre_cortándose_el_pelo_tono_de_piel_oscuro:': u'\U0001F487\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mujer_cortándose_el_pelo:': u'\U0001F487\U0000200D\U00002640\U0000FE0F',
    u':mujer_cortándose_el_pelo_tono_de_piel_claro:': u'\U0001F487\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mujer_cortándose_el_pelo_tono_de_piel_claro_medio:': u'\U0001F487\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mujer_cortándose_el_pelo_tono_de_piel_medio:': u'\U0001F487\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mujer_cortándose_el_pelo_tono_de_piel_oscuro_medio:': u'\U0001F487\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mujer_cortándose_el_pelo_tono_de_piel_oscuro:': u'\U0001F487\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':persona_caminando:': u'\U0001F6B6',
    u':persona_caminando_tono_de_piel_claro:': u'\U0001F6B6\U0001F3FB',
    u':persona_caminando_tono_de_piel_claro_medio:': u'\U0001F6B6\U0001F3FC',
    u':persona_caminando_tono_de_piel_medio:': u'\U0001F6B6\U0001F3FD',
    u':persona_caminando_tono_de_piel_oscuro_medio:': u'\U0001F6B6\U0001F3FE',
    u':persona_caminando_tono_de_piel_oscuro:': u'\U0001F6B6\U0001F3FF',
    u':hombre_caminando:': u'\U0001F6B6\U0000200D\U00002642\U0000FE0F',
    u':hombre_caminando_tono_de_piel_claro:': u'\U0001F6B6\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':hombre_caminando_tono_de_piel_claro_medio:': u'\U0001F6B6\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':hombre_caminando_tono_de_piel_medio:': u'\U0001F6B6\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':hombre_caminando_tono_de_piel_oscuro_medio:': u'\U0001F6B6\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':hombre_caminando_tono_de_piel_oscuro:': u'\U0001F6B6\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mujer_caminando:': u'\U0001F6B6\U0000200D\U00002640\U0000FE0F',
    u':mujer_caminando_tono_de_piel_claro:': u'\U0001F6B6\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mujer_caminando_tono_de_piel_claro_medio:': u'\U0001F6B6\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mujer_caminando_tono_de_piel_medio:': u'\U0001F6B6\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mujer_caminando_tono_de_piel_oscuro_medio:': u'\U0001F6B6\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mujer_caminando_tono_de_piel_oscuro:': u'\U0001F6B6\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':persona_de_pie:': u'\U0001F9CD',
    u':persona_de_pie_tono_de_piel_claro:': u'\U0001F9CD\U0001F3FB',
    u':persona_de_pie_tono_de_piel_claro_medio:': u'\U0001F9CD\U0001F3FC',
    u':persona_de_pie_tono_de_piel_medio:': u'\U0001F9CD\U0001F3FD',
    u':persona_de_pie_tono_de_piel_oscuro_medio:': u'\U0001F9CD\U0001F3FE',
    u':persona_de_pie_tono_de_piel_oscuro:': u'\U0001F9CD\U0001F3FF',
    u':hombre_de_pie:': u'\U0001F9CD\U0000200D\U00002642\U0000FE0F',
    u':hombre_de_pie_tono_de_piel_claro:': u'\U0001F9CD\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':hombre_de_pie_tono_de_piel_claro_medio:': u'\U0001F9CD\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':hombre_de_pie_tono_de_piel_medio:': u'\U0001F9CD\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':hombre_de_pie_tono_de_piel_oscuro_medio:': u'\U0001F9CD\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':hombre_de_pie_tono_de_piel_oscuro:': u'\U0001F9CD\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mujer_de_pie:': u'\U0001F9CD\U0000200D\U00002640\U0000FE0F',
    u':mujer_de_pie_tono_de_piel_claro:': u'\U0001F9CD\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mujer_de_pie_tono_de_piel_claro_medio:': u'\U0001F9CD\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mujer_de_pie_tono_de_piel_medio:': u'\U0001F9CD\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mujer_de_pie_tono_de_piel_oscuro_medio:': u'\U0001F9CD\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mujer_de_pie_tono_de_piel_oscuro:': u'\U0001F9CD\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':persona_de_rodillas:': u'\U0001F9CE',
    u':persona_de_rodillas_tono_de_piel_claro:': u'\U0001F9CE\U0001F3FB',
    u':persona_de_rodillas_tono_de_piel_claro_medio:': u'\U0001F9CE\U0001F3FC',
    u':persona_de_rodillas_tono_de_piel_medio:': u'\U0001F9CE\U0001F3FD',
    u':persona_de_rodillas_tono_de_piel_oscuro_medio:': u'\U0001F9CE\U0001F3FE',
    u':persona_de_rodillas_tono_de_piel_oscuro:': u'\U0001F9CE\U0001F3FF',
    u':hombre_de_rodillas:': u'\U0001F9CE\U0000200D\U00002642\U0000FE0F',
    u':hombre_de_rodillas_tono_de_piel_claro:': u'\U0001F9CE\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':hombre_de_rodillas_tono_de_piel_claro_medio:': u'\U0001F9CE\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':hombre_de_rodillas_tono_de_piel_medio:': u'\U0001F9CE\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':hombre_de_rodillas_tono_de_piel_oscuro_medio:': u'\U0001F9CE\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':hombre_de_rodillas_tono_de_piel_oscuro:': u'\U0001F9CE\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mujer_de_rodillas:': u'\U0001F9CE\U0000200D\U00002640\U0000FE0F',
    u':mujer_de_rodillas_tono_de_piel_claro:': u'\U0001F9CE\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mujer_de_rodillas_tono_de_piel_claro_medio:': u'\U0001F9CE\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mujer_de_rodillas_tono_de_piel_medio:': u'\U0001F9CE\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mujer_de_rodillas_tono_de_piel_oscuro_medio:': u'\U0001F9CE\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mujer_de_rodillas_tono_de_piel_oscuro:': u'\U0001F9CE\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':persona_con_bastón:': u'\U0001F9D1\U0000200D\U0001F9AF',
    u':persona_con_bastón_tono_de_piel_claro:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F9AF',
    u':persona_con_bastón_tono_de_piel_claro_medio:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F9AF',
    u':persona_con_bastón_tono_de_piel_medio:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F9AF',
    u':persona_con_bastón_tono_de_piel_oscuro_medio:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F9AF',
    u':persona_con_bastón_tono_de_piel_oscuro:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F9AF',
    u':hombre_con_bastón:': u'\U0001F468\U0000200D\U0001F9AF',
    u':hombre_con_bastón_tono_de_piel_claro:': u'\U0001F468\U0001F3FB\U0000200D\U0001F9AF',
    u':hombre_con_bastón_tono_de_piel_claro_medio:': u'\U0001F468\U0001F3FC\U0000200D\U0001F9AF',
    u':hombre_con_bastón_tono_de_piel_medio:': u'\U0001F468\U0001F3FD\U0000200D\U0001F9AF',
    u':hombre_con_bastón_tono_de_piel_oscuro_medio:': u'\U0001F468\U0001F3FE\U0000200D\U0001F9AF',
    u':hombre_con_bastón_tono_de_piel_oscuro:': u'\U0001F468\U0001F3FF\U0000200D\U0001F9AF',
    u':mujer_con_bastón:': u'\U0001F469\U0000200D\U0001F9AF',
    u':mujer_con_bastón_tono_de_piel_claro:': u'\U0001F469\U0001F3FB\U0000200D\U0001F9AF',
    u':mujer_con_bastón_tono_de_piel_claro_medio:': u'\U0001F469\U0001F3FC\U0000200D\U0001F9AF',
    u':mujer_con_bastón_tono_de_piel_medio:': u'\U0001F469\U0001F3FD\U0000200D\U0001F9AF',
    u':mujer_con_bastón_tono_de_piel_oscuro_medio:': u'\U0001F469\U0001F3FE\U0000200D\U0001F9AF',
    u':mujer_con_bastón_tono_de_piel_oscuro:': u'\U0001F469\U0001F3FF\U0000200D\U0001F9AF',
    u':persona_en_silla_de_ruedas_eléctrica:': u'\U0001F9D1\U0000200D\U0001F9BC',
    u':persona_en_silla_de_ruedas_eléctrica_tono_de_piel_claro:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F9BC',
    u':persona_en_silla_de_ruedas_eléctrica_tono_de_piel_claro_medio:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F9BC',
    u':persona_en_silla_de_ruedas_eléctrica_tono_de_piel_medio:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F9BC',
    u':persona_en_silla_de_ruedas_eléctrica_tono_de_piel_oscuro_medio:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F9BC',
    u':persona_en_silla_de_ruedas_eléctrica_tono_de_piel_oscuro:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F9BC',
    u':hombre_en_silla_de_ruedas_eléctrica:': u'\U0001F468\U0000200D\U0001F9BC',
    u':hombre_en_silla_de_ruedas_eléctrica_tono_de_piel_claro:': u'\U0001F468\U0001F3FB\U0000200D\U0001F9BC',
    u':hombre_en_silla_de_ruedas_eléctrica_tono_de_piel_claro_medio:': u'\U0001F468\U0001F3FC\U0000200D\U0001F9BC',
    u':hombre_en_silla_de_ruedas_eléctrica_tono_de_piel_medio:': u'\U0001F468\U0001F3FD\U0000200D\U0001F9BC',
    u':hombre_en_silla_de_ruedas_eléctrica_tono_de_piel_oscuro_medio:': u'\U0001F468\U0001F3FE\U0000200D\U0001F9BC',
    u':hombre_en_silla_de_ruedas_eléctrica_tono_de_piel_oscuro:': u'\U0001F468\U0001F3FF\U0000200D\U0001F9BC',
    u':mujer_en_silla_de_ruedas_eléctrica:': u'\U0001F469\U0000200D\U0001F9BC',
    u':mujer_en_silla_de_ruedas_eléctrica_tono_de_piel_claro:': u'\U0001F469\U0001F3FB\U0000200D\U0001F9BC',
    u':mujer_en_silla_de_ruedas_eléctrica_tono_de_piel_claro_medio:': u'\U0001F469\U0001F3FC\U0000200D\U0001F9BC',
    u':mujer_en_silla_de_ruedas_eléctrica_tono_de_piel_medio:': u'\U0001F469\U0001F3FD\U0000200D\U0001F9BC',
    u':mujer_en_silla_de_ruedas_eléctrica_tono_de_piel_oscuro_medio:': u'\U0001F469\U0001F3FE\U0000200D\U0001F9BC',
    u':mujer_en_silla_de_ruedas_eléctrica_tono_de_piel_oscuro:': u'\U0001F469\U0001F3FF\U0000200D\U0001F9BC',
    u':persona_en_silla_de_ruedas_manual:': u'\U0001F9D1\U0000200D\U0001F9BD',
    u':persona_en_silla_de_ruedas_manual_tono_de_piel_claro:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F9BD',
    u':persona_en_silla_de_ruedas_manual_tono_de_piel_claro_medio:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F9BD',
    u':persona_en_silla_de_ruedas_manual_tono_de_piel_medio:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F9BD',
    u':persona_en_silla_de_ruedas_manual_tono_de_piel_oscuro_medio:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F9BD',
    u':persona_en_silla_de_ruedas_manual_tono_de_piel_oscuro:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F9BD',
    u':hombre_en_silla_de_ruedas_manual:': u'\U0001F468\U0000200D\U0001F9BD',
    u':hombre_en_silla_de_ruedas_manual_tono_de_piel_claro:': u'\U0001F468\U0001F3FB\U0000200D\U0001F9BD',
    u':hombre_en_silla_de_ruedas_manual_tono_de_piel_claro_medio:': u'\U0001F468\U0001F3FC\U0000200D\U0001F9BD',
    u':hombre_en_silla_de_ruedas_manual_tono_de_piel_medio:': u'\U0001F468\U0001F3FD\U0000200D\U0001F9BD',
    u':hombre_en_silla_de_ruedas_manual_tono_de_piel_oscuro_medio:': u'\U0001F468\U0001F3FE\U0000200D\U0001F9BD',
    u':hombre_en_silla_de_ruedas_manual_tono_de_piel_oscuro:': u'\U0001F468\U0001F3FF\U0000200D\U0001F9BD',
    u':mujer_en_silla_de_ruedas_manual:': u'\U0001F469\U0000200D\U0001F9BD',
    u':mujer_en_silla_de_ruedas_manual_tono_de_piel_claro:': u'\U0001F469\U0001F3FB\U0000200D\U0001F9BD',
    u':mujer_en_silla_de_ruedas_manual_tono_de_piel_claro_medio:': u'\U0001F469\U0001F3FC\U0000200D\U0001F9BD',
    u':mujer_en_silla_de_ruedas_manual_tono_de_piel_medio:': u'\U0001F469\U0001F3FD\U0000200D\U0001F9BD',
    u':mujer_en_silla_de_ruedas_manual_tono_de_piel_oscuro_medio:': u'\U0001F469\U0001F3FE\U0000200D\U0001F9BD',
    u':mujer_en_silla_de_ruedas_manual_tono_de_piel_oscuro:': u'\U0001F469\U0001F3FF\U0000200D\U0001F9BD',
    u':persona_corriendo:': u'\U0001F3C3',
    u':persona_corriendo_tono_de_piel_claro:': u'\U0001F3C3\U0001F3FB',
    u':persona_corriendo_tono_de_piel_claro_medio:': u'\U0001F3C3\U0001F3FC',
    u':persona_corriendo_tono_de_piel_medio:': u'\U0001F3C3\U0001F3FD',
    u':persona_corriendo_tono_de_piel_oscuro_medio:': u'\U0001F3C3\U0001F3FE',
    u':persona_corriendo_tono_de_piel_oscuro:': u'\U0001F3C3\U0001F3FF',
    u':hombre_corriendo:': u'\U0001F3C3\U0000200D\U00002642\U0000FE0F',
    u':hombre_corriendo_tono_de_piel_claro:': u'\U0001F3C3\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':hombre_corriendo_tono_de_piel_claro_medio:': u'\U0001F3C3\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':hombre_corriendo_tono_de_piel_medio:': u'\U0001F3C3\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':hombre_corriendo_tono_de_piel_oscuro_medio:': u'\U0001F3C3\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':hombre_corriendo_tono_de_piel_oscuro:': u'\U0001F3C3\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mujer_corriendo:': u'\U0001F3C3\U0000200D\U00002640\U0000FE0F',
    u':mujer_corriendo_tono_de_piel_claro:': u'\U0001F3C3\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mujer_corriendo_tono_de_piel_claro_medio:': u'\U0001F3C3\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mujer_corriendo_tono_de_piel_medio:': u'\U0001F3C3\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mujer_corriendo_tono_de_piel_oscuro_medio:': u'\U0001F3C3\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mujer_corriendo_tono_de_piel_oscuro:': u'\U0001F3C3\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':mujer_bailando:': u'\U0001F483',
    u':mujer_bailando_tono_de_piel_claro:': u'\U0001F483\U0001F3FB',
    u':mujer_bailando_tono_de_piel_claro_medio:': u'\U0001F483\U0001F3FC',
    u':mujer_bailando_tono_de_piel_medio:': u'\U0001F483\U0001F3FD',
    u':mujer_bailando_tono_de_piel_oscuro_medio:': u'\U0001F483\U0001F3FE',
    u':mujer_bailando_tono_de_piel_oscuro:': u'\U0001F483\U0001F3FF',
    u':hombre_bailando:': u'\U0001F57A',
    u':hombre_bailando_tono_de_piel_claro:': u'\U0001F57A\U0001F3FB',
    u':hombre_bailando_tono_de_piel_claro_medio:': u'\U0001F57A\U0001F3FC',
    u':hombre_bailando_tono_de_piel_medio:': u'\U0001F57A\U0001F3FD',
    u':hombre_bailando_tono_de_piel_oscuro_medio:': u'\U0001F57A\U0001F3FE',
    u':hombre_bailando_tono_de_piel_oscuro:': u'\U0001F57A\U0001F3FF',
    u':hombre_trajeado_levitando:': u'\U0001F574\U0000FE0F',
    u':hombre_trajeado_levitando_tono_de_piel_claro:': u'\U0001F574\U0001F3FB',
    u':hombre_trajeado_levitando_tono_de_piel_claro_medio:': u'\U0001F574\U0001F3FC',
    u':hombre_trajeado_levitando_tono_de_piel_medio:': u'\U0001F574\U0001F3FD',
    u':hombre_trajeado_levitando_tono_de_piel_oscuro_medio:': u'\U0001F574\U0001F3FE',
    u':hombre_trajeado_levitando_tono_de_piel_oscuro:': u'\U0001F574\U0001F3FF',
    u':personas_con_orejas_de_conejo:': u'\U0001F46F',
    u':hombres_con_orejas_de_conejo:': u'\U0001F46F\U0000200D\U00002642\U0000FE0F',
    u':mujeres_con_orejas_de_conejo:': u'\U0001F46F\U0000200D\U00002640\U0000FE0F',
    u':persona_en_una_sauna:': u'\U0001F9D6',
    u':persona_en_una_sauna_tono_de_piel_claro:': u'\U0001F9D6\U0001F3FB',
    u':persona_en_una_sauna_tono_de_piel_claro_medio:': u'\U0001F9D6\U0001F3FC',
    u':persona_en_una_sauna_tono_de_piel_medio:': u'\U0001F9D6\U0001F3FD',
    u':persona_en_una_sauna_tono_de_piel_oscuro_medio:': u'\U0001F9D6\U0001F3FE',
    u':persona_en_una_sauna_tono_de_piel_oscuro:': u'\U0001F9D6\U0001F3FF',
    u':hombre_en_una_sauna:': u'\U0001F9D6\U0000200D\U00002642\U0000FE0F',
    u':hombre_en_una_sauna_tono_de_piel_claro:': u'\U0001F9D6\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':hombre_en_una_sauna_tono_de_piel_claro_medio:': u'\U0001F9D6\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':hombre_en_una_sauna_tono_de_piel_medio:': u'\U0001F9D6\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':hombre_en_una_sauna_tono_de_piel_oscuro_medio:': u'\U0001F9D6\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':hombre_en_una_sauna_tono_de_piel_oscuro:': u'\U0001F9D6\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mujer_en_una_sauna:': u'\U0001F9D6\U0000200D\U00002640\U0000FE0F',
    u':mujer_en_una_sauna_tono_de_piel_claro:': u'\U0001F9D6\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mujer_en_una_sauna_tono_de_piel_claro_medio:': u'\U0001F9D6\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mujer_en_una_sauna_tono_de_piel_medio:': u'\U0001F9D6\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mujer_en_una_sauna_tono_de_piel_oscuro_medio:': u'\U0001F9D6\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mujer_en_una_sauna_tono_de_piel_oscuro:': u'\U0001F9D6\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':persona_escalando:': u'\U0001F9D7',
    u':persona_escalando_tono_de_piel_claro:': u'\U0001F9D7\U0001F3FB',
    u':persona_escalando_tono_de_piel_claro_medio:': u'\U0001F9D7\U0001F3FC',
    u':persona_escalando_tono_de_piel_medio:': u'\U0001F9D7\U0001F3FD',
    u':persona_escalando_tono_de_piel_oscuro_medio:': u'\U0001F9D7\U0001F3FE',
    u':persona_escalando_tono_de_piel_oscuro:': u'\U0001F9D7\U0001F3FF',
    u':hombre_escalando:': u'\U0001F9D7\U0000200D\U00002642\U0000FE0F',
    u':hombre_escalando_tono_de_piel_claro:': u'\U0001F9D7\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':hombre_escalando_tono_de_piel_claro_medio:': u'\U0001F9D7\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':hombre_escalando_tono_de_piel_medio:': u'\U0001F9D7\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':hombre_escalando_tono_de_piel_oscuro_medio:': u'\U0001F9D7\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':hombre_escalando_tono_de_piel_oscuro:': u'\U0001F9D7\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mujer_escalando:': u'\U0001F9D7\U0000200D\U00002640\U0000FE0F',
    u':mujer_escalando_tono_de_piel_claro:': u'\U0001F9D7\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mujer_escalando_tono_de_piel_claro_medio:': u'\U0001F9D7\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mujer_escalando_tono_de_piel_medio:': u'\U0001F9D7\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mujer_escalando_tono_de_piel_oscuro_medio:': u'\U0001F9D7\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mujer_escalando_tono_de_piel_oscuro:': u'\U0001F9D7\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':esgrima:': u'\U0001F93A',
    u':carrera_de_caballos:': u'\U0001F3C7',
    u':carrera_de_caballos_tono_de_piel_claro:': u'\U0001F3C7\U0001F3FB',
    u':carrera_de_caballos_tono_de_piel_claro_medio:': u'\U0001F3C7\U0001F3FC',
    u':carrera_de_caballos_tono_de_piel_medio:': u'\U0001F3C7\U0001F3FD',
    u':carrera_de_caballos_tono_de_piel_oscuro_medio:': u'\U0001F3C7\U0001F3FE',
    u':carrera_de_caballos_tono_de_piel_oscuro:': u'\U0001F3C7\U0001F3FF',
    u':esquiador:': u'\U000026F7\U0000FE0F',
    u':practicante_de_snowboard:': u'\U0001F3C2',
    u':practicante_de_snowboard_tono_de_piel_claro:': u'\U0001F3C2\U0001F3FB',
    u':practicante_de_snowboard_tono_de_piel_claro_medio:': u'\U0001F3C2\U0001F3FC',
    u':practicante_de_snowboard_tono_de_piel_medio:': u'\U0001F3C2\U0001F3FD',
    u':practicante_de_snowboard_tono_de_piel_oscuro_medio:': u'\U0001F3C2\U0001F3FE',
    u':practicante_de_snowboard_tono_de_piel_oscuro:': u'\U0001F3C2\U0001F3FF',
    u':golfista:': u'\U0001F3CC\U0000FE0F',
    u':golfista_tono_de_piel_claro:': u'\U0001F3CC\U0001F3FB',
    u':golfista_tono_de_piel_claro_medio:': u'\U0001F3CC\U0001F3FC',
    u':golfista_tono_de_piel_medio:': u'\U0001F3CC\U0001F3FD',
    u':golfista_tono_de_piel_oscuro_medio:': u'\U0001F3CC\U0001F3FE',
    u':golfista_tono_de_piel_oscuro:': u'\U0001F3CC\U0001F3FF',
    u':hombre_jugando_al_golf:': u'\U0001F3CC\U0000FE0F\U0000200D\U00002642\U0000FE0F',
    u':hombre_jugando_al_golf_tono_de_piel_claro:': u'\U0001F3CC\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':hombre_jugando_al_golf_tono_de_piel_claro_medio:': u'\U0001F3CC\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':hombre_jugando_al_golf_tono_de_piel_medio:': u'\U0001F3CC\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':hombre_jugando_al_golf_tono_de_piel_oscuro_medio:': u'\U0001F3CC\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':hombre_jugando_al_golf_tono_de_piel_oscuro:': u'\U0001F3CC\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mujer_jugando_al_golf:': u'\U0001F3CC\U0000FE0F\U0000200D\U00002640\U0000FE0F',
    u':mujer_jugando_al_golf_tono_de_piel_claro:': u'\U0001F3CC\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mujer_jugando_al_golf_tono_de_piel_claro_medio:': u'\U0001F3CC\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mujer_jugando_al_golf_tono_de_piel_medio:': u'\U0001F3CC\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mujer_jugando_al_golf_tono_de_piel_oscuro_medio:': u'\U0001F3CC\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mujer_jugando_al_golf_tono_de_piel_oscuro:': u'\U0001F3CC\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':persona_haciendo_surf:': u'\U0001F3C4',
    u':persona_haciendo_surf_tono_de_piel_claro:': u'\U0001F3C4\U0001F3FB',
    u':persona_haciendo_surf_tono_de_piel_claro_medio:': u'\U0001F3C4\U0001F3FC',
    u':persona_haciendo_surf_tono_de_piel_medio:': u'\U0001F3C4\U0001F3FD',
    u':persona_haciendo_surf_tono_de_piel_oscuro_medio:': u'\U0001F3C4\U0001F3FE',
    u':persona_haciendo_surf_tono_de_piel_oscuro:': u'\U0001F3C4\U0001F3FF',
    u':hombre_haciendo_surf:': u'\U0001F3C4\U0000200D\U00002642\U0000FE0F',
    u':hombre_haciendo_surf_tono_de_piel_claro:': u'\U0001F3C4\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':hombre_haciendo_surf_tono_de_piel_claro_medio:': u'\U0001F3C4\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':hombre_haciendo_surf_tono_de_piel_medio:': u'\U0001F3C4\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':hombre_haciendo_surf_tono_de_piel_oscuro_medio:': u'\U0001F3C4\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':hombre_haciendo_surf_tono_de_piel_oscuro:': u'\U0001F3C4\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mujer_haciendo_surf:': u'\U0001F3C4\U0000200D\U00002640\U0000FE0F',
    u':mujer_haciendo_surf_tono_de_piel_claro:': u'\U0001F3C4\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mujer_haciendo_surf_tono_de_piel_claro_medio:': u'\U0001F3C4\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mujer_haciendo_surf_tono_de_piel_medio:': u'\U0001F3C4\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mujer_haciendo_surf_tono_de_piel_oscuro_medio:': u'\U0001F3C4\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mujer_haciendo_surf_tono_de_piel_oscuro:': u'\U0001F3C4\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':persona_remando_en_un_bote:': u'\U0001F6A3',
    u':persona_remando_en_un_bote_tono_de_piel_claro:': u'\U0001F6A3\U0001F3FB',
    u':persona_remando_en_un_bote_tono_de_piel_claro_medio:': u'\U0001F6A3\U0001F3FC',
    u':persona_remando_en_un_bote_tono_de_piel_medio:': u'\U0001F6A3\U0001F3FD',
    u':persona_remando_en_un_bote_tono_de_piel_oscuro_medio:': u'\U0001F6A3\U0001F3FE',
    u':persona_remando_en_un_bote_tono_de_piel_oscuro:': u'\U0001F6A3\U0001F3FF',
    u':hombre_remando_en_un_bote:': u'\U0001F6A3\U0000200D\U00002642\U0000FE0F',
    u':hombre_remando_en_un_bote_tono_de_piel_claro:': u'\U0001F6A3\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':hombre_remando_en_un_bote_tono_de_piel_claro_medio:': u'\U0001F6A3\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':hombre_remando_en_un_bote_tono_de_piel_medio:': u'\U0001F6A3\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':hombre_remando_en_un_bote_tono_de_piel_oscuro_medio:': u'\U0001F6A3\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':hombre_remando_en_un_bote_tono_de_piel_oscuro:': u'\U0001F6A3\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mujer_remando_en_un_bote:': u'\U0001F6A3\U0000200D\U00002640\U0000FE0F',
    u':mujer_remando_en_un_bote_tono_de_piel_claro:': u'\U0001F6A3\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mujer_remando_en_un_bote_tono_de_piel_claro_medio:': u'\U0001F6A3\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mujer_remando_en_un_bote_tono_de_piel_medio:': u'\U0001F6A3\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mujer_remando_en_un_bote_tono_de_piel_oscuro_medio:': u'\U0001F6A3\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mujer_remando_en_un_bote_tono_de_piel_oscuro:': u'\U0001F6A3\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':persona_nadando:': u'\U0001F3CA',
    u':persona_nadando_tono_de_piel_claro:': u'\U0001F3CA\U0001F3FB',
    u':persona_nadando_tono_de_piel_claro_medio:': u'\U0001F3CA\U0001F3FC',
    u':persona_nadando_tono_de_piel_medio:': u'\U0001F3CA\U0001F3FD',
    u':persona_nadando_tono_de_piel_oscuro_medio:': u'\U0001F3CA\U0001F3FE',
    u':persona_nadando_tono_de_piel_oscuro:': u'\U0001F3CA\U0001F3FF',
    u':hombre_nadando:': u'\U0001F3CA\U0000200D\U00002642\U0000FE0F',
    u':hombre_nadando_tono_de_piel_claro:': u'\U0001F3CA\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':hombre_nadando_tono_de_piel_claro_medio:': u'\U0001F3CA\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':hombre_nadando_tono_de_piel_medio:': u'\U0001F3CA\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':hombre_nadando_tono_de_piel_oscuro_medio:': u'\U0001F3CA\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':hombre_nadando_tono_de_piel_oscuro:': u'\U0001F3CA\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mujer_nadando:': u'\U0001F3CA\U0000200D\U00002640\U0000FE0F',
    u':mujer_nadando_tono_de_piel_claro:': u'\U0001F3CA\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mujer_nadando_tono_de_piel_claro_medio:': u'\U0001F3CA\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mujer_nadando_tono_de_piel_medio:': u'\U0001F3CA\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mujer_nadando_tono_de_piel_oscuro_medio:': u'\U0001F3CA\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mujer_nadando_tono_de_piel_oscuro:': u'\U0001F3CA\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':persona_botando_un_balón:': u'\U000026F9\U0000FE0F',
    u':persona_botando_un_balón_tono_de_piel_claro:': u'\U000026F9\U0001F3FB',
    u':persona_botando_un_balón_tono_de_piel_claro_medio:': u'\U000026F9\U0001F3FC',
    u':persona_botando_un_balón_tono_de_piel_medio:': u'\U000026F9\U0001F3FD',
    u':persona_botando_un_balón_tono_de_piel_oscuro_medio:': u'\U000026F9\U0001F3FE',
    u':persona_botando_un_balón_tono_de_piel_oscuro:': u'\U000026F9\U0001F3FF',
    u':hombre_botando_un_balón:': u'\U000026F9\U0000FE0F\U0000200D\U00002642\U0000FE0F',
    u':hombre_botando_un_balón_tono_de_piel_claro:': u'\U000026F9\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':hombre_botando_un_balón_tono_de_piel_claro_medio:': u'\U000026F9\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':hombre_botando_un_balón_tono_de_piel_medio:': u'\U000026F9\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':hombre_botando_un_balón_tono_de_piel_oscuro_medio:': u'\U000026F9\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':hombre_botando_un_balón_tono_de_piel_oscuro:': u'\U000026F9\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mujer_botando_un_balón:': u'\U000026F9\U0000FE0F\U0000200D\U00002640\U0000FE0F',
    u':mujer_botando_un_balón_tono_de_piel_claro:': u'\U000026F9\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mujer_botando_un_balón_tono_de_piel_claro_medio:': u'\U000026F9\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mujer_botando_un_balón_tono_de_piel_medio:': u'\U000026F9\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mujer_botando_un_balón_tono_de_piel_oscuro_medio:': u'\U000026F9\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mujer_botando_un_balón_tono_de_piel_oscuro:': u'\U000026F9\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':persona_levantando_pesas:': u'\U0001F3CB\U0000FE0F',
    u':persona_levantando_pesas_tono_de_piel_claro:': u'\U0001F3CB\U0001F3FB',
    u':persona_levantando_pesas_tono_de_piel_claro_medio:': u'\U0001F3CB\U0001F3FC',
    u':persona_levantando_pesas_tono_de_piel_medio:': u'\U0001F3CB\U0001F3FD',
    u':persona_levantando_pesas_tono_de_piel_oscuro_medio:': u'\U0001F3CB\U0001F3FE',
    u':persona_levantando_pesas_tono_de_piel_oscuro:': u'\U0001F3CB\U0001F3FF',
    u':hombre_levantando_pesas:': u'\U0001F3CB\U0000FE0F\U0000200D\U00002642\U0000FE0F',
    u':hombre_levantando_pesas_tono_de_piel_claro:': u'\U0001F3CB\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':hombre_levantando_pesas_tono_de_piel_claro_medio:': u'\U0001F3CB\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':hombre_levantando_pesas_tono_de_piel_medio:': u'\U0001F3CB\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':hombre_levantando_pesas_tono_de_piel_oscuro_medio:': u'\U0001F3CB\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':hombre_levantando_pesas_tono_de_piel_oscuro:': u'\U0001F3CB\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mujer_levantando_pesas:': u'\U0001F3CB\U0000FE0F\U0000200D\U00002640\U0000FE0F',
    u':mujer_levantando_pesas_tono_de_piel_claro:': u'\U0001F3CB\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mujer_levantando_pesas_tono_de_piel_claro_medio:': u'\U0001F3CB\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mujer_levantando_pesas_tono_de_piel_medio:': u'\U0001F3CB\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mujer_levantando_pesas_tono_de_piel_oscuro_medio:': u'\U0001F3CB\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mujer_levantando_pesas_tono_de_piel_oscuro:': u'\U0001F3CB\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':persona_en_bicicleta:': u'\U0001F6B4',
    u':persona_en_bicicleta_tono_de_piel_claro:': u'\U0001F6B4\U0001F3FB',
    u':persona_en_bicicleta_tono_de_piel_claro_medio:': u'\U0001F6B4\U0001F3FC',
    u':persona_en_bicicleta_tono_de_piel_medio:': u'\U0001F6B4\U0001F3FD',
    u':persona_en_bicicleta_tono_de_piel_oscuro_medio:': u'\U0001F6B4\U0001F3FE',
    u':persona_en_bicicleta_tono_de_piel_oscuro:': u'\U0001F6B4\U0001F3FF',
    u':hombre_en_bicicleta:': u'\U0001F6B4\U0000200D\U00002642\U0000FE0F',
    u':hombre_en_bicicleta_tono_de_piel_claro:': u'\U0001F6B4\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':hombre_en_bicicleta_tono_de_piel_claro_medio:': u'\U0001F6B4\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':hombre_en_bicicleta_tono_de_piel_medio:': u'\U0001F6B4\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':hombre_en_bicicleta_tono_de_piel_oscuro_medio:': u'\U0001F6B4\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':hombre_en_bicicleta_tono_de_piel_oscuro:': u'\U0001F6B4\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mujer_en_bicicleta:': u'\U0001F6B4\U0000200D\U00002640\U0000FE0F',
    u':mujer_en_bicicleta_tono_de_piel_claro:': u'\U0001F6B4\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mujer_en_bicicleta_tono_de_piel_claro_medio:': u'\U0001F6B4\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mujer_en_bicicleta_tono_de_piel_medio:': u'\U0001F6B4\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mujer_en_bicicleta_tono_de_piel_oscuro_medio:': u'\U0001F6B4\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mujer_en_bicicleta_tono_de_piel_oscuro:': u'\U0001F6B4\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':persona_en_bicicleta_de_montaña:': u'\U0001F6B5',
    u':persona_en_bicicleta_de_montaña_tono_de_piel_claro:': u'\U0001F6B5\U0001F3FB',
    u':persona_en_bicicleta_de_montaña_tono_de_piel_claro_medio:': u'\U0001F6B5\U0001F3FC',
    u':persona_en_bicicleta_de_montaña_tono_de_piel_medio:': u'\U0001F6B5\U0001F3FD',
    u':persona_en_bicicleta_de_montaña_tono_de_piel_oscuro_medio:': u'\U0001F6B5\U0001F3FE',
    u':persona_en_bicicleta_de_montaña_tono_de_piel_oscuro:': u'\U0001F6B5\U0001F3FF',
    u':hombre_en_bicicleta_de_montaña:': u'\U0001F6B5\U0000200D\U00002642\U0000FE0F',
    u':hombre_en_bicicleta_de_montaña_tono_de_piel_claro:': u'\U0001F6B5\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':hombre_en_bicicleta_de_montaña_tono_de_piel_claro_medio:': u'\U0001F6B5\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':hombre_en_bicicleta_de_montaña_tono_de_piel_medio:': u'\U0001F6B5\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':hombre_en_bicicleta_de_montaña_tono_de_piel_oscuro_medio:': u'\U0001F6B5\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':hombre_en_bicicleta_de_montaña_tono_de_piel_oscuro:': u'\U0001F6B5\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mujer_en_bicicleta_de_montaña:': u'\U0001F6B5\U0000200D\U00002640\U0000FE0F',
    u':mujer_en_bicicleta_de_montaña_tono_de_piel_claro:': u'\U0001F6B5\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mujer_en_bicicleta_de_montaña_tono_de_piel_claro_medio:': u'\U0001F6B5\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mujer_en_bicicleta_de_montaña_tono_de_piel_medio:': u'\U0001F6B5\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mujer_en_bicicleta_de_montaña_tono_de_piel_oscuro_medio:': u'\U0001F6B5\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mujer_en_bicicleta_de_montaña_tono_de_piel_oscuro:': u'\U0001F6B5\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':persona_haciendo_voltereta_lateral:': u'\U0001F938',
    u':persona_haciendo_voltereta_lateral_tono_de_piel_claro:': u'\U0001F938\U0001F3FB',
    u':persona_haciendo_voltereta_lateral_tono_de_piel_claro_medio:': u'\U0001F938\U0001F3FC',
    u':persona_haciendo_voltereta_lateral_tono_de_piel_medio:': u'\U0001F938\U0001F3FD',
    u':persona_haciendo_voltereta_lateral_tono_de_piel_oscuro_medio:': u'\U0001F938\U0001F3FE',
    u':persona_haciendo_voltereta_lateral_tono_de_piel_oscuro:': u'\U0001F938\U0001F3FF',
    u':hombre_haciendo_una_voltereta_lateral:': u'\U0001F938\U0000200D\U00002642\U0000FE0F',
    u':hombre_haciendo_una_voltereta_lateral_tono_de_piel_claro:': u'\U0001F938\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':hombre_haciendo_una_voltereta_lateral_tono_de_piel_claro_medio:': u'\U0001F938\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':hombre_haciendo_una_voltereta_lateral_tono_de_piel_medio:': u'\U0001F938\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':hombre_haciendo_una_voltereta_lateral_tono_de_piel_oscuro_medio:': u'\U0001F938\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':hombre_haciendo_una_voltereta_lateral_tono_de_piel_oscuro:': u'\U0001F938\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mujer_haciendo_voltereta_lateral:': u'\U0001F938\U0000200D\U00002640\U0000FE0F',
    u':mujer_haciendo_voltereta_lateral_tono_de_piel_claro:': u'\U0001F938\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mujer_haciendo_voltereta_lateral_tono_de_piel_claro_medio:': u'\U0001F938\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mujer_haciendo_voltereta_lateral_tono_de_piel_medio:': u'\U0001F938\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mujer_haciendo_voltereta_lateral_tono_de_piel_oscuro_medio:': u'\U0001F938\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mujer_haciendo_voltereta_lateral_tono_de_piel_oscuro:': u'\U0001F938\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':personas_luchando:': u'\U0001F93C',
    u':hombres_luchando:': u'\U0001F93C\U0000200D\U00002642\U0000FE0F',
    u':mujeres_luchando:': u'\U0001F93C\U0000200D\U00002640\U0000FE0F',
    u':persona_jugando_al_waterpolo:': u'\U0001F93D',
    u':persona_jugando_al_waterpolo_tono_de_piel_claro:': u'\U0001F93D\U0001F3FB',
    u':persona_jugando_al_waterpolo_tono_de_piel_claro_medio:': u'\U0001F93D\U0001F3FC',
    u':persona_jugando_al_waterpolo_tono_de_piel_medio:': u'\U0001F93D\U0001F3FD',
    u':persona_jugando_al_waterpolo_tono_de_piel_oscuro_medio:': u'\U0001F93D\U0001F3FE',
    u':persona_jugando_al_waterpolo_tono_de_piel_oscuro:': u'\U0001F93D\U0001F3FF',
    u':hombre_jugando_al_waterpolo:': u'\U0001F93D\U0000200D\U00002642\U0000FE0F',
    u':hombre_jugando_al_waterpolo_tono_de_piel_claro:': u'\U0001F93D\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':hombre_jugando_al_waterpolo_tono_de_piel_claro_medio:': u'\U0001F93D\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':hombre_jugando_al_waterpolo_tono_de_piel_medio:': u'\U0001F93D\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':hombre_jugando_al_waterpolo_tono_de_piel_oscuro_medio:': u'\U0001F93D\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':hombre_jugando_al_waterpolo_tono_de_piel_oscuro:': u'\U0001F93D\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mujer_jugando_al_waterpolo:': u'\U0001F93D\U0000200D\U00002640\U0000FE0F',
    u':mujer_jugando_al_waterpolo_tono_de_piel_claro:': u'\U0001F93D\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mujer_jugando_al_waterpolo_tono_de_piel_claro_medio:': u'\U0001F93D\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mujer_jugando_al_waterpolo_tono_de_piel_medio:': u'\U0001F93D\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mujer_jugando_al_waterpolo_tono_de_piel_oscuro_medio:': u'\U0001F93D\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mujer_jugando_al_waterpolo_tono_de_piel_oscuro:': u'\U0001F93D\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':persona_jugando_al_balonmano:': u'\U0001F93E',
    u':persona_jugando_al_balonmano_tono_de_piel_claro:': u'\U0001F93E\U0001F3FB',
    u':persona_jugando_al_balonmano_tono_de_piel_claro_medio:': u'\U0001F93E\U0001F3FC',
    u':persona_jugando_al_balonmano_tono_de_piel_medio:': u'\U0001F93E\U0001F3FD',
    u':persona_jugando_al_balonmano_tono_de_piel_oscuro_medio:': u'\U0001F93E\U0001F3FE',
    u':persona_jugando_al_balonmano_tono_de_piel_oscuro:': u'\U0001F93E\U0001F3FF',
    u':hombre_jugando_al_balonmano:': u'\U0001F93E\U0000200D\U00002642\U0000FE0F',
    u':hombre_jugando_al_balonmano_tono_de_piel_claro:': u'\U0001F93E\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':hombre_jugando_al_balonmano_tono_de_piel_claro_medio:': u'\U0001F93E\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':hombre_jugando_al_balonmano_tono_de_piel_medio:': u'\U0001F93E\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':hombre_jugando_al_balonmano_tono_de_piel_oscuro_medio:': u'\U0001F93E\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':hombre_jugando_al_balonmano_tono_de_piel_oscuro:': u'\U0001F93E\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mujer_jugando_al_balonmano:': u'\U0001F93E\U0000200D\U00002640\U0000FE0F',
    u':mujer_jugando_al_balonmano_tono_de_piel_claro:': u'\U0001F93E\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mujer_jugando_al_balonmano_tono_de_piel_claro_medio:': u'\U0001F93E\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mujer_jugando_al_balonmano_tono_de_piel_medio:': u'\U0001F93E\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mujer_jugando_al_balonmano_tono_de_piel_oscuro_medio:': u'\U0001F93E\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mujer_jugando_al_balonmano_tono_de_piel_oscuro:': u'\U0001F93E\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':persona_haciendo_malabares:': u'\U0001F939',
    u':persona_haciendo_malabares_tono_de_piel_claro:': u'\U0001F939\U0001F3FB',
    u':persona_haciendo_malabares_tono_de_piel_claro_medio:': u'\U0001F939\U0001F3FC',
    u':persona_haciendo_malabares_tono_de_piel_medio:': u'\U0001F939\U0001F3FD',
    u':persona_haciendo_malabares_tono_de_piel_oscuro_medio:': u'\U0001F939\U0001F3FE',
    u':persona_haciendo_malabares_tono_de_piel_oscuro:': u'\U0001F939\U0001F3FF',
    u':hombre_haciendo_malabares:': u'\U0001F939\U0000200D\U00002642\U0000FE0F',
    u':hombre_haciendo_malabares_tono_de_piel_claro:': u'\U0001F939\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':hombre_haciendo_malabares_tono_de_piel_claro_medio:': u'\U0001F939\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':hombre_haciendo_malabares_tono_de_piel_medio:': u'\U0001F939\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':hombre_haciendo_malabares_tono_de_piel_oscuro_medio:': u'\U0001F939\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':hombre_haciendo_malabares_tono_de_piel_oscuro:': u'\U0001F939\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mujer_haciendo_malabares:': u'\U0001F939\U0000200D\U00002640\U0000FE0F',
    u':mujer_haciendo_malabares_tono_de_piel_claro:': u'\U0001F939\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mujer_haciendo_malabares_tono_de_piel_claro_medio:': u'\U0001F939\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mujer_haciendo_malabares_tono_de_piel_medio:': u'\U0001F939\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mujer_haciendo_malabares_tono_de_piel_oscuro_medio:': u'\U0001F939\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mujer_haciendo_malabares_tono_de_piel_oscuro:': u'\U0001F939\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':persona_en_posición_de_loto:': u'\U0001F9D8',
    u':persona_en_posición_de_loto_tono_de_piel_claro:': u'\U0001F9D8\U0001F3FB',
    u':persona_en_posición_de_loto_tono_de_piel_claro_medio:': u'\U0001F9D8\U0001F3FC',
    u':persona_en_posición_de_loto_tono_de_piel_medio:': u'\U0001F9D8\U0001F3FD',
    u':persona_en_posición_de_loto_tono_de_piel_oscuro_medio:': u'\U0001F9D8\U0001F3FE',
    u':persona_en_posición_de_loto_tono_de_piel_oscuro:': u'\U0001F9D8\U0001F3FF',
    u':hombre_en_posición_de_loto:': u'\U0001F9D8\U0000200D\U00002642\U0000FE0F',
    u':hombre_en_posición_de_loto_tono_de_piel_claro:': u'\U0001F9D8\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':hombre_en_posición_de_loto_tono_de_piel_claro_medio:': u'\U0001F9D8\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':hombre_en_posición_de_loto_tono_de_piel_medio:': u'\U0001F9D8\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':hombre_en_posición_de_loto_tono_de_piel_oscuro_medio:': u'\U0001F9D8\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':hombre_en_posición_de_loto_tono_de_piel_oscuro:': u'\U0001F9D8\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':mujer_en_posición_de_loto:': u'\U0001F9D8\U0000200D\U00002640\U0000FE0F',
    u':mujer_en_posición_de_loto_tono_de_piel_claro:': u'\U0001F9D8\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mujer_en_posición_de_loto_tono_de_piel_claro_medio:': u'\U0001F9D8\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mujer_en_posición_de_loto_tono_de_piel_medio:': u'\U0001F9D8\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mujer_en_posición_de_loto_tono_de_piel_oscuro_medio:': u'\U0001F9D8\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mujer_en_posición_de_loto_tono_de_piel_oscuro:': u'\U0001F9D8\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':persona_en_la_bañera:': u'\U0001F6C0',
    u':persona_en_la_bañera_tono_de_piel_claro:': u'\U0001F6C0\U0001F3FB',
    u':persona_en_la_bañera_tono_de_piel_claro_medio:': u'\U0001F6C0\U0001F3FC',
    u':persona_en_la_bañera_tono_de_piel_medio:': u'\U0001F6C0\U0001F3FD',
    u':persona_en_la_bañera_tono_de_piel_oscuro_medio:': u'\U0001F6C0\U0001F3FE',
    u':persona_en_la_bañera_tono_de_piel_oscuro:': u'\U0001F6C0\U0001F3FF',
    u':persona_en_la_cama:': u'\U0001F6CC',
    u':persona_en_la_cama_tono_de_piel_claro:': u'\U0001F6CC\U0001F3FB',
    u':persona_en_la_cama_tono_de_piel_claro_medio:': u'\U0001F6CC\U0001F3FC',
    u':persona_en_la_cama_tono_de_piel_medio:': u'\U0001F6CC\U0001F3FD',
    u':persona_en_la_cama_tono_de_piel_oscuro_medio:': u'\U0001F6CC\U0001F3FE',
    u':persona_en_la_cama_tono_de_piel_oscuro:': u'\U0001F6CC\U0001F3FF',
    u':dos_personas_dándose_la_mano:': u'\U0001F9D1\U0000200D\U0001F91D\U0000200D\U0001F9D1',
    u':dos_personas_dándose_la_mano_tono_de_piel_claro:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FB',
    u':dos_personas_dándose_la_mano_tono_de_piel_claro_y_tono_de_piel_claro_medio:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FC',
    u':dos_personas_dándose_la_mano_tono_de_piel_claro_y_tono_de_piel_medio:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FD',
    u':dos_personas_dándose_la_mano_tono_de_piel_claro_y_tono_de_piel_oscuro_medio:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FE',
    u':dos_personas_dándose_la_mano_tono_de_piel_claro_y_tono_de_piel_oscuro:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FF',
    u':dos_personas_dándose_la_mano_tono_de_piel_claro_medio_y_tono_de_piel_claro:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FB',
    u':dos_personas_dándose_la_mano_tono_de_piel_claro_medio:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FC',
    u':dos_personas_dándose_la_mano_tono_de_piel_claro_medio_y_tono_de_piel_medio:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FD',
    u':dos_personas_dándose_la_mano_tono_de_piel_claro_medio_y_tono_de_piel_oscuro_medio:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FE',
    u':dos_personas_dándose_la_mano_tono_de_piel_claro_medio_y_tono_de_piel_oscuro:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FF',
    u':dos_personas_dándose_la_mano_tono_de_piel_medio_y_tono_de_piel_claro:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FB',
    u':dos_personas_dándose_la_mano_tono_de_piel_medio_y_tono_de_piel_claro_medio:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FC',
    u':dos_personas_dándose_la_mano_tono_de_piel_medio:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FD',
    u':dos_personas_dándose_la_mano_tono_de_piel_medio_y_tono_de_piel_oscuro_medio:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FE',
    u':dos_personas_dándose_la_mano_tono_de_piel_medio_y_tono_de_piel_oscuro:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FF',
    u':dos_personas_dándose_la_mano_tono_de_piel_oscuro_medio_y_tono_de_piel_claro:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FB',
    u':dos_personas_dándose_la_mano_tono_de_piel_oscuro_medio_y_tono_de_piel_claro_medio:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FC',
    u':dos_personas_dándose_la_mano_tono_de_piel_oscuro_medio_y_tono_de_piel_medio:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FD',
    u':dos_personas_dándose_la_mano_tono_de_piel_oscuro_medio:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FE',
    u':dos_personas_dándose_la_mano_tono_de_piel_oscuro_medio_y_tono_de_piel_oscuro:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FF',
    u':dos_personas_dándose_la_mano_tono_de_piel_oscuro_y_tono_de_piel_claro:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FB',
    u':dos_personas_dándose_la_mano_tono_de_piel_oscuro_y_tono_de_piel_claro_medio:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FC',
    u':dos_personas_dándose_la_mano_tono_de_piel_oscuro_y_tono_de_piel_medio:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FD',
    u':dos_personas_dándose_la_mano_tono_de_piel_oscuro_y_tono_de_piel_oscuro_medio:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FE',
    u':dos_personas_dándose_la_mano_tono_de_piel_oscuro:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FF',
    u':mujeres_de_la_mano:': u'\U0001F46D',
    u':mujeres_de_la_mano_tono_de_piel_claro:': u'\U0001F46D\U0001F3FB',
    u':mujeres_de_la_mano_tono_de_piel_claro_y_tono_de_piel_claro_medio:': u'\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FC',
    u':mujeres_de_la_mano_tono_de_piel_claro_y_tono_de_piel_medio:': u'\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FD',
    u':mujeres_de_la_mano_tono_de_piel_claro_y_tono_de_piel_oscuro_medio:': u'\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FE',
    u':mujeres_de_la_mano_tono_de_piel_claro_y_tono_de_piel_oscuro:': u'\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FF',
    u':mujeres_de_la_mano_tono_de_piel_claro_medio_y_tono_de_piel_claro:': u'\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FB',
    u':mujeres_de_la_mano_tono_de_piel_claro_medio:': u'\U0001F46D\U0001F3FC',
    u':mujeres_de_la_mano_tono_de_piel_claro_medio_y_tono_de_piel_medio:': u'\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FD',
    u':mujeres_de_la_mano_tono_de_piel_claro_medio_y_tono_de_piel_oscuro_medio:': u'\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FE',
    u':mujeres_de_la_mano_tono_de_piel_claro_medio_y_tono_de_piel_oscuro:': u'\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FF',
    u':mujeres_de_la_mano_tono_de_piel_medio_y_tono_de_piel_claro:': u'\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FB',
    u':mujeres_de_la_mano_tono_de_piel_medio_y_tono_de_piel_claro_medio:': u'\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FC',
    u':mujeres_de_la_mano_tono_de_piel_medio:': u'\U0001F46D\U0001F3FD',
    u':mujeres_de_la_mano_tono_de_piel_medio_y_tono_de_piel_oscuro_medio:': u'\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FE',
    u':mujeres_de_la_mano_tono_de_piel_medio_y_tono_de_piel_oscuro:': u'\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FF',
    u':mujeres_de_la_mano_tono_de_piel_oscuro_medio_y_tono_de_piel_claro:': u'\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FB',
    u':mujeres_de_la_mano_tono_de_piel_oscuro_medio_y_tono_de_piel_claro_medio:': u'\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FC',
    u':mujeres_de_la_mano_tono_de_piel_oscuro_medio_y_tono_de_piel_medio:': u'\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FD',
    u':mujeres_de_la_mano_tono_de_piel_oscuro_medio:': u'\U0001F46D\U0001F3FE',
    u':mujeres_de_la_mano_tono_de_piel_oscuro_medio_y_tono_de_piel_oscuro:': u'\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FF',
    u':mujeres_de_la_mano_tono_de_piel_oscuro_y_tono_de_piel_claro:': u'\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FB',
    u':mujeres_de_la_mano_tono_de_piel_oscuro_y_tono_de_piel_claro_medio:': u'\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FC',
    u':mujeres_de_la_mano_tono_de_piel_oscuro_y_tono_de_piel_medio:': u'\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FD',
    u':mujeres_de_la_mano_tono_de_piel_oscuro_y_tono_de_piel_oscuro_medio:': u'\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FE',
    u':mujeres_de_la_mano_tono_de_piel_oscuro:': u'\U0001F46D\U0001F3FF',
    u':mujer_y_hombre_de_la_mano:': u'\U0001F46B',
    u':mujer_y_hombre_de_la_mano_tono_de_piel_claro:': u'\U0001F46B\U0001F3FB',
    u':mujer_y_hombre_de_la_mano_tono_de_piel_claro_y_tono_de_piel_claro_medio:': u'\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC',
    u':mujer_y_hombre_de_la_mano_tono_de_piel_claro_y_tono_de_piel_medio:': u'\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD',
    u':mujer_y_hombre_de_la_mano_tono_de_piel_claro_y_tono_de_piel_oscuro_medio:': u'\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE',
    u':mujer_y_hombre_de_la_mano_tono_de_piel_claro_y_tono_de_piel_oscuro:': u'\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF',
    u':mujer_y_hombre_de_la_mano_tono_de_piel_claro_medio_y_tono_de_piel_claro:': u'\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB',
    u':mujer_y_hombre_de_la_mano_tono_de_piel_claro_medio:': u'\U0001F46B\U0001F3FC',
    u':mujer_y_hombre_de_la_mano_tono_de_piel_claro_medio_y_tono_de_piel_medio:': u'\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD',
    u':mujer_y_hombre_de_la_mano_tono_de_piel_claro_medio_y_tono_de_piel_oscuro_medio:': u'\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE',
    u':mujer_y_hombre_de_la_mano_tono_de_piel_claro_medio_y_tono_de_piel_oscuro:': u'\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF',
    u':mujer_y_hombre_de_la_mano_tono_de_piel_medio_y_tono_de_piel_claro:': u'\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB',
    u':mujer_y_hombre_de_la_mano_tono_de_piel_medio_y_tono_de_piel_claro_medio:': u'\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC',
    u':mujer_y_hombre_de_la_mano_tono_de_piel_medio:': u'\U0001F46B\U0001F3FD',
    u':mujer_y_hombre_de_la_mano_tono_de_piel_medio_y_tono_de_piel_oscuro_medio:': u'\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE',
    u':mujer_y_hombre_de_la_mano_tono_de_piel_medio_y_tono_de_piel_oscuro:': u'\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF',
    u':mujer_y_hombre_de_la_mano_tono_de_piel_oscuro_medio_y_tono_de_piel_claro:': u'\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB',
    u':mujer_y_hombre_de_la_mano_tono_de_piel_oscuro_medio_y_tono_de_piel_claro_medio:': u'\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC',
    u':mujer_y_hombre_de_la_mano_tono_de_piel_oscuro_medio_y_tono_de_piel_medio:': u'\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD',
    u':mujer_y_hombre_de_la_mano_tono_de_piel_oscuro_medio:': u'\U0001F46B\U0001F3FE',
    u':mujer_y_hombre_de_la_mano_tono_de_piel_oscuro_medio_y_tono_de_piel_oscuro:': u'\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF',
    u':mujer_y_hombre_de_la_mano_tono_de_piel_oscuro_y_tono_de_piel_claro:': u'\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB',
    u':mujer_y_hombre_de_la_mano_tono_de_piel_oscuro_y_tono_de_piel_claro_medio:': u'\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC',
    u':mujer_y_hombre_de_la_mano_tono_de_piel_oscuro_y_tono_de_piel_medio:': u'\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD',
    u':mujer_y_hombre_de_la_mano_tono_de_piel_oscuro_y_tono_de_piel_oscuro_medio:': u'\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE',
    u':mujer_y_hombre_de_la_mano_tono_de_piel_oscuro:': u'\U0001F46B\U0001F3FF',
    u':hombres_de_la_mano:': u'\U0001F46C',
    u':hombres_de_la_mano_tono_de_piel_claro:': u'\U0001F46C\U0001F3FB',
    u':hombres_de_la_mano_tono_de_piel_claro_y_tono_de_piel_claro_medio:': u'\U0001F468\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC',
    u':hombres_de_la_mano_tono_de_piel_claro_y_tono_de_piel_medio:': u'\U0001F468\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD',
    u':hombres_de_la_mano_tono_de_piel_claro_y_tono_de_piel_oscuro_medio:': u'\U0001F468\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE',
    u':hombres_de_la_mano_tono_de_piel_claro_y_tono_de_piel_oscuro:': u'\U0001F468\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF',
    u':hombres_de_la_mano_tono_de_piel_claro_medio_y_tono_de_piel_claro:': u'\U0001F468\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB',
    u':hombres_de_la_mano_tono_de_piel_claro_medio:': u'\U0001F46C\U0001F3FC',
    u':hombres_de_la_mano_tono_de_piel_claro_medio_y_tono_de_piel_medio:': u'\U0001F468\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD',
    u':hombres_de_la_mano_tono_de_piel_claro_medio_y_tono_de_piel_oscuro_medio:': u'\U0001F468\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE',
    u':hombres_de_la_mano_tono_de_piel_claro_medio_y_tono_de_piel_oscuro:': u'\U0001F468\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF',
    u':hombres_de_la_mano_tono_de_piel_medio_y_tono_de_piel_claro:': u'\U0001F468\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB',
    u':hombres_de_la_mano_tono_de_piel_medio_y_tono_de_piel_claro_medio:': u'\U0001F468\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC',
    u':hombres_de_la_mano_tono_de_piel_medio:': u'\U0001F46C\U0001F3FD',
    u':hombres_de_la_mano_tono_de_piel_medio_y_tono_de_piel_oscuro_medio:': u'\U0001F468\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE',
    u':hombres_de_la_mano_tono_de_piel_medio_y_tono_de_piel_oscuro:': u'\U0001F468\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF',
    u':hombres_de_la_mano_tono_de_piel_oscuro_medio_y_tono_de_piel_claro:': u'\U0001F468\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB',
    u':hombres_de_la_mano_tono_de_piel_oscuro_medio_y_tono_de_piel_claro_medio:': u'\U0001F468\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC',
    u':hombres_de_la_mano_tono_de_piel_oscuro_medio_y_tono_de_piel_medio:': u'\U0001F468\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD',
    u':hombres_de_la_mano_tono_de_piel_oscuro_medio:': u'\U0001F46C\U0001F3FE',
    u':hombres_de_la_mano_tono_de_piel_oscuro_medio_y_tono_de_piel_oscuro:': u'\U0001F468\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF',
    u':hombres_de_la_mano_tono_de_piel_oscuro_y_tono_de_piel_claro:': u'\U0001F468\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB',
    u':hombres_de_la_mano_tono_de_piel_oscuro_y_tono_de_piel_claro_medio:': u'\U0001F468\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC',
    u':hombres_de_la_mano_tono_de_piel_oscuro_y_tono_de_piel_medio:': u'\U0001F468\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD',
    u':hombres_de_la_mano_tono_de_piel_oscuro_y_tono_de_piel_oscuro_medio:': u'\U0001F468\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE',
    u':hombres_de_la_mano_tono_de_piel_oscuro:': u'\U0001F46C\U0001F3FF',
    u':beso:': u'\U0001F48F',
    u':beso_mujer_y_hombre:': u'\U0001F469\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468',
    u':beso_hombre_y_hombre:': u'\U0001F468\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468',
    u':beso_mujer_y_mujer:': u'\U0001F469\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F469',
    u':pareja_enamorada:': u'\U0001F491',
    u':pareja_enamorada_mujer_y_hombre:': u'\U0001F469\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468',
    u':pareja_enamorada_hombre_y_hombre:': u'\U0001F468\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468',
    u':pareja_enamorada_mujer_y_mujer:': u'\U0001F469\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F469',
    u':familia:': u'\U0001F46A',
    u':familia_hombre_mujer_niño:': u'\U0001F468\U0000200D\U0001F469\U0000200D\U0001F466',
    u':familia_hombre_mujer_niña:': u'\U0001F468\U0000200D\U0001F469\U0000200D\U0001F467',
    u':familia_hombre_mujer_niña_niño:': u'\U0001F468\U0000200D\U0001F469\U0000200D\U0001F467\U0000200D\U0001F466',
    u':familia_hombre_mujer_niño_niño:': u'\U0001F468\U0000200D\U0001F469\U0000200D\U0001F466\U0000200D\U0001F466',
    u':familia_hombre_mujer_niña_niña:': u'\U0001F468\U0000200D\U0001F469\U0000200D\U0001F467\U0000200D\U0001F467',
    u':familia_hombre_hombre_niño:': u'\U0001F468\U0000200D\U0001F468\U0000200D\U0001F466',
    u':familia_hombre_hombre_niña:': u'\U0001F468\U0000200D\U0001F468\U0000200D\U0001F467',
    u':familia_hombre_hombre_niña_niño:': u'\U0001F468\U0000200D\U0001F468\U0000200D\U0001F467\U0000200D\U0001F466',
    u':familia_hombre_hombre_niño_niño:': u'\U0001F468\U0000200D\U0001F468\U0000200D\U0001F466\U0000200D\U0001F466',
    u':familia_hombre_hombre_niña_niña:': u'\U0001F468\U0000200D\U0001F468\U0000200D\U0001F467\U0000200D\U0001F467',
    u':familia_mujer_mujer_niño:': u'\U0001F469\U0000200D\U0001F469\U0000200D\U0001F466',
    u':familia_mujer_mujer_niña:': u'\U0001F469\U0000200D\U0001F469\U0000200D\U0001F467',
    u':familia_mujer_mujer_niña_niño:': u'\U0001F469\U0000200D\U0001F469\U0000200D\U0001F467\U0000200D\U0001F466',
    u':familia_mujer_mujer_niño_niño:': u'\U0001F469\U0000200D\U0001F469\U0000200D\U0001F466\U0000200D\U0001F466',
    u':familia_mujer_mujer_niña_niña:': u'\U0001F469\U0000200D\U0001F469\U0000200D\U0001F467\U0000200D\U0001F467',
    u':familia_hombre_y_niño:': u'\U0001F468\U0000200D\U0001F466',
    u':familia_hombre_niño_niño:': u'\U0001F468\U0000200D\U0001F466\U0000200D\U0001F466',
    u':familia_hombre_y_niña:': u'\U0001F468\U0000200D\U0001F467',
    u':familia_hombre_niña_niño:': u'\U0001F468\U0000200D\U0001F467\U0000200D\U0001F466',
    u':familia_hombre_niña_niña:': u'\U0001F468\U0000200D\U0001F467\U0000200D\U0001F467',
    u':familia_mujer_y_niño:': u'\U0001F469\U0000200D\U0001F466',
    u':familia_mujer_niño_niño:': u'\U0001F469\U0000200D\U0001F466\U0000200D\U0001F466',
    u':familia_mujer_y_niña:': u'\U0001F469\U0000200D\U0001F467',
    u':familia_mujer_niña_niño:': u'\U0001F469\U0000200D\U0001F467\U0000200D\U0001F466',
    u':familia_mujer_niña_niña:': u'\U0001F469\U0000200D\U0001F467\U0000200D\U0001F467',
    u':cabeza_parlante:': u'\U0001F5E3\U0000FE0F',
    u':silueta_de_busto:': u'\U0001F464',
    u':dos_siluetas_de_bustos:': u'\U0001F465',
    u':personas_abrazándose:': u'\U0001FAC2',
    u':huellas_de_pies:': u'\U0001F463',
    u':tono_de_piel_claro:': u'\U0001F3FB',
    u':tono_de_piel_claro_medio:': u'\U0001F3FC',
    u':tono_de_piel_medio:': u'\U0001F3FD',
    u':tono_de_piel_oscuro_medio:': u'\U0001F3FE',
    u':tono_de_piel_oscuro:': u'\U0001F3FF',
    u':pelo_pelirrojo:': u'\U0001F9B0',
    u':pelo_rizado:': u'\U0001F9B1',
    u':pelo_blanco:': u'\U0001F9B3',
    u':sin_pelo:': u'\U0001F9B2',
    u':cara_de_mono:': u'\U0001F435',
    u':mono:': u'\U0001F412',
    u':gorila:': u'\U0001F98D',
    u':orangután:': u'\U0001F9A7',
    u':cara_de_perro:': u'\U0001F436',
    u':perro:': u'\U0001F415',
    u':perro_guía:': u'\U0001F9AE',
    u':perro_de_servicio:': u'\U0001F415\U0000200D\U0001F9BA',
    u':caniche:': u'\U0001F429',
    u':lobo:': u'\U0001F43A',
    u':zorro:': u'\U0001F98A',
    u':mapache:': u'\U0001F99D',
    u':cara_de_gato:': u'\U0001F431',
    u':gato:': u'\U0001F408',
    u':gato_negro:': u'\U0001F408\U0000200D\U00002B1B',
    u':león:': u'\U0001F981',
    u':cara_de_tigre:': u'\U0001F42F',
    u':tigre:': u'\U0001F405',
    u':leopardo:': u'\U0001F406',
    u':cara_de_caballo:': u'\U0001F434',
    u':caballo:': u'\U0001F40E',
    u':unicornio:': u'\U0001F984',
    u':cebra:': u'\U0001F993',
    u':ciervo:': u'\U0001F98C',
    u':bisonte:': u'\U0001F9AC',
    u':cara_de_vaca:': u'\U0001F42E',
    u':buey:': u'\U0001F402',
    u':búfalo_de_agua:': u'\U0001F403',
    u':vaca:': u'\U0001F404',
    u':cara_de_cerdo:': u'\U0001F437',
    u':cerdo:': u'\U0001F416',
    u':jabalí:': u'\U0001F417',
    u':nariz_de_cerdo:': u'\U0001F43D',
    u':carnero:': u'\U0001F40F',
    u':oveja:': u'\U0001F411',
    u':cabra:': u'\U0001F410',
    u':dromedario:': u'\U0001F42A',
    u':camello:': u'\U0001F42B',
    u':llama:': u'\U0001F999',
    u':jirafa:': u'\U0001F992',
    u':elefante:': u'\U0001F418',
    u':mamut:': u'\U0001F9A3',
    u':rinoceronte:': u'\U0001F98F',
    u':hipopótamo:': u'\U0001F99B',
    u':cara_de_ratón:': u'\U0001F42D',
    u':ratón:': u'\U0001F401',
    u':rata:': u'\U0001F400',
    u':hámster:': u'\U0001F439',
    u':cara_de_conejo:': u'\U0001F430',
    u':conejo:': u'\U0001F407',
    u':ardilla:': u'\U0001F43F\U0000FE0F',
    u':castor:': u'\U0001F9AB',
    u':erizo:': u'\U0001F994',
    u':murciélago:': u'\U0001F987',
    u':oso:': u'\U0001F43B',
    u':oso_polar:': u'\U0001F43B\U0000200D\U00002744\U0000FE0F',
    u':koala:': u'\U0001F428',
    u':panda:': u'\U0001F43C',
    u':perezoso:': u'\U0001F9A5',
    u':nutria:': u'\U0001F9A6',
    u':mofeta:': u'\U0001F9A8',
    u':canguro:': u'\U0001F998',
    u':tejón:': u'\U0001F9A1',
    u':huellas_de_pezuñas:': u'\U0001F43E',
    u':pavo:': u'\U0001F983',
    u':gallina:': u'\U0001F414',
    u':gallo:': u'\U0001F413',
    u':pollito_rompiendo_el_cascarón:': u'\U0001F423',
    u':pollito:': u'\U0001F424',
    u':pollito_de_frente:': u'\U0001F425',
    u':pájaro:': u'\U0001F426',
    u':pingüino:': u'\U0001F427',
    u':paloma:': u'\U0001F54A\U0000FE0F',
    u':águila:': u'\U0001F985',
    u':pato:': u'\U0001F986',
    u':cisne:': u'\U0001F9A2',
    u':búho:': u'\U0001F989',
    u':dodo:': u'\U0001F9A4',
    u':pluma:': u'\U0001FAB6',
    u':flamenco:': u'\U0001F9A9',
    u':pavo_real:': u'\U0001F99A',
    u':loro:': u'\U0001F99C',
    u':rana:': u'\U0001F438',
    u':cocodrilo:': u'\U0001F40A',
    u':tortuga:': u'\U0001F422',
    u':lagarto:': u'\U0001F98E',
    u':serpiente:': u'\U0001F40D',
    u':cara_de_dragón:': u'\U0001F432',
    u':dragón:': u'\U0001F409',
    u':saurópodo:': u'\U0001F995',
    u':t-rex:': u'\U0001F996',
    u':ballena_soltando_un_chorro:': u'\U0001F433',
    u':ballena:': u'\U0001F40B',
    u':delfín:': u'\U0001F42C',
    u':foca:': u'\U0001F9AD',
    u':pez:': u'\U0001F41F',
    u':pez_tropical:': u'\U0001F420',
    u':pez_globo:': u'\U0001F421',
    u':tiburón:': u'\U0001F988',
    u':pulpo:': u'\U0001F419',
    u':concha_de_mar:': u'\U0001F41A',
    u':caracol:': u'\U0001F40C',
    u':mariposa:': u'\U0001F98B',
    u':insecto:': u'\U0001F41B',
    u':hormiga:': u'\U0001F41C',
    u':abeja:': u'\U0001F41D',
    u':escarabajo:': u'\U0001FAB2',
    u':mariquita:': u'\U0001F41E',
    u':grillo:': u'\U0001F997',
    u':cucaracha:': u'\U0001FAB3',
    u':araña:': u'\U0001F577\U0000FE0F',
    u':tela_de_araña:': u'\U0001F578\U0000FE0F',
    u':escorpión:': u'\U0001F982',
    u':mosquito:': u'\U0001F99F',
    u':mosca:': u'\U0001FAB0',
    u':gusano:': u'\U0001FAB1',
    u':microbio:': u'\U0001F9A0',
    u':ramo_de_flores:': u'\U0001F490',
    u':flor_de_cerezo:': u'\U0001F338',
    u':flor_blanca:': u'\U0001F4AE',
    u':roseta:': u'\U0001F3F5\U0000FE0F',
    u':rosa:': u'\U0001F339',
    u':flor_marchita:': u'\U0001F940',
    u':flor_de_hibisco:': u'\U0001F33A',
    u':girasol:': u'\U0001F33B',
    u':flor:': u'\U0001F33C',
    u':tulipán:': u'\U0001F337',
    u':planta_joven:': u'\U0001F331',
    u':planta_de_maceta:': u'\U0001FAB4',
    u':árbol_de_hoja_perenne:': u'\U0001F332',
    u':árbol_de_hoja_caduca:': u'\U0001F333',
    u':palmera:': u'\U0001F334',
    u':cactus:': u'\U0001F335',
    u':espiga_de_arroz:': u'\U0001F33E',
    u':hierba:': u'\U0001F33F',
    u':trébol:': u'\U00002618\U0000FE0F',
    u':trébol_de_cuatro_hojas:': u'\U0001F340',
    u':hoja_de_arce:': u'\U0001F341',
    u':hojas_caídas:': u'\U0001F342',
    u':hojas_revoloteando_al_viento:': u'\U0001F343',
    u':uvas:': u'\U0001F347',
    u':melón:': u'\U0001F348',
    u':sandía:': u'\U0001F349',
    u':mandarina:': u'\U0001F34A',
    u':limón:': u'\U0001F34B',
    u':plátano:': u'\U0001F34C',
    u':piña:': u'\U0001F34D',
    u':mango:': u'\U0001F96D',
    u':manzana_roja:': u'\U0001F34E',
    u':manzana_verde:': u'\U0001F34F',
    u':pera:': u'\U0001F350',
    u':melocotón:': u'\U0001F351',
    u':cerezas:': u'\U0001F352',
    u':fresa:': u'\U0001F353',
    u':arándanos:': u'\U0001FAD0',
    u':kiwi:': u'\U0001F95D',
    u':tomate:': u'\U0001F345',
    u':aceituna:': u'\U0001FAD2',
    u':coco:': u'\U0001F965',
    u':aguacate:': u'\U0001F951',
    u':berenjena:': u'\U0001F346',
    u':patata:': u'\U0001F954',
    u':zanahoria:': u'\U0001F955',
    u':espiga_de_maíz:': u'\U0001F33D',
    u':chile_picante:': u'\U0001F336\U0000FE0F',
    u':pimiento:': u'\U0001FAD1',
    u':pepino:': u'\U0001F952',
    u':verdura_de_hoja_verde:': u'\U0001F96C',
    u':brócoli:': u'\U0001F966',
    u':ajo:': u'\U0001F9C4',
    u':cebolla:': u'\U0001F9C5',
    u':champiñón:': u'\U0001F344',
    u':cacahuetes:': u'\U0001F95C',
    u':castaña:': u'\U0001F330',
    u':pan_de_molde:': u'\U0001F35E',
    u':cruasán:': u'\U0001F950',
    u':baguete:': u'\U0001F956',
    u':pan_sin_levadura:': u'\U0001FAD3',
    u':bretzel:': u'\U0001F968',
    u':bagel:': u'\U0001F96F',
    u':tortitas:': u'\U0001F95E',
    u':gofre:': u'\U0001F9C7',
    u':cuña_de_queso:': u'\U0001F9C0',
    u':carne_con_hueso:': u'\U0001F356',
    u':muslo_de_pollo:': u'\U0001F357',
    u':corte_de_carne:': u'\U0001F969',
    u':beicon:': u'\U0001F953',
    u':hamburguesa:': u'\U0001F354',
    u':patatas_fritas:': u'\U0001F35F',
    u':pizza:': u'\U0001F355',
    u':perrito_caliente:': u'\U0001F32D',
    u':sándwich:': u'\U0001F96A',
    u':taco:': u'\U0001F32E',
    u':burrito:': u'\U0001F32F',
    u':tamal:': u'\U0001FAD4',
    u':pan_relleno:': u'\U0001F959',
    u':falafel:': u'\U0001F9C6',
    u':huevo:': u'\U0001F95A',
    u':cocinar:': u'\U0001F373',
    u':paella:': u'\U0001F958',
    u':olla_de_comida:': u'\U0001F372',
    u':fondue:': u'\U0001FAD5',
    u':cuenco_con_cuchara:': u'\U0001F963',
    u':ensalada:': u'\U0001F957',
    u':palomitas:': u'\U0001F37F',
    u':mantequilla:': u'\U0001F9C8',
    u':sal:': u'\U0001F9C2',
    u':comida_enlatada:': u'\U0001F96B',
    u':caja_de_bento:': u'\U0001F371',
    u':galleta_de_arroz:': u'\U0001F358',
    u':bola_de_arroz:': u'\U0001F359',
    u':arroz_cocido:': u'\U0001F35A',
    u':arroz_con_curry:': u'\U0001F35B',
    u':tazón_de_fideos:': u'\U0001F35C',
    u':espagueti:': u'\U0001F35D',
    u':patata_asada:': u'\U0001F360',
    u':brocheta:': u'\U0001F362',
    u':sushi:': u'\U0001F363',
    u':gamba_frita:': u'\U0001F364',
    u':pastel_de_pescado_japonés:': u'\U0001F365',
    u':pastel_de_luna:': u'\U0001F96E',
    u':dango:': u'\U0001F361',
    u':dumpling:': u'\U0001F95F',
    u':galleta_de_la_fortuna:': u'\U0001F960',
    u':caja_para_llevar:': u'\U0001F961',
    u':cangrejo:': u'\U0001F980',
    u':langosta:': u'\U0001F99E',
    u':gamba:': u'\U0001F990',
    u':calamar:': u'\U0001F991',
    u':ostra:': u'\U0001F9AA',
    u':cucurucho_de_helado:': u'\U0001F366',
    u':granizado_hawaiano:': u'\U0001F367',
    u':helado:': u'\U0001F368',
    u':dónut:': u'\U0001F369',
    u':galleta:': u'\U0001F36A',
    u':tarta_de_cumpleaños:': u'\U0001F382',
    u':trozo_de_tarta:': u'\U0001F370',
    u':magdalena:': u'\U0001F9C1',
    u':pastel:': u'\U0001F967',
    u':tableta_de_chocolate:': u'\U0001F36B',
    u':caramelo:': u'\U0001F36C',
    u':piruleta:': u'\U0001F36D',
    u':flan:': u'\U0001F36E',
    u':tarro_de_miel:': u'\U0001F36F',
    u':biberón:': u'\U0001F37C',
    u':vaso_de_leche:': u'\U0001F95B',
    u':bebida_caliente:': u'\U00002615',
    u':tetera:': u'\U0001FAD6',
    u':tazón_de_té:': u'\U0001F375',
    u':sake:': u'\U0001F376',
    u':botella_descorchada:': u'\U0001F37E',
    u':copa_de_vino:': u'\U0001F377',
    u':copa_de_cóctel:': u'\U0001F378',
    u':bebida_tropical:': u'\U0001F379',
    u':jarra_de_cerveza:': u'\U0001F37A',
    u':jarras_de_cerveza_brindando:': u'\U0001F37B',
    u':copas_brindando:': u'\U0001F942',
    u':vaso_de_whisky:': u'\U0001F943',
    u':vaso_con_pajita:': u'\U0001F964',
    u':té_de_burbujas:': u'\U0001F9CB',
    u':tetrabrik:': u'\U0001F9C3',
    u':mate:': u'\U0001F9C9',
    u':cubito_de_hielo:': u'\U0001F9CA',
    u':palillos:': u'\U0001F962',
    u':cuchillo_y_tenedor_con_un_plato:': u'\U0001F37D\U0000FE0F',
    u':tenedor_y_cuchillo:': u'\U0001F374',
    u':cuchara:': u'\U0001F944',
    u':cuchillo_de_cocina:': u'\U0001F52A',
    u':ánfora:': u'\U0001F3FA',
    u':globo_terráqueo_mostrando_europa_y_áfrica:': u'\U0001F30D',
    u':globo_terráqueo_mostrando_américa:': u'\U0001F30E',
    u':globo_terráqueo_mostrando_asia_y_australia:': u'\U0001F30F',
    u':globo_terráqueo_con_meridianos:': u'\U0001F310',
    u':mapa_mundial:': u'\U0001F5FA\U0000FE0F',
    u':mapa_de_japón:': u'\U0001F5FE',
    u':brújula:': u'\U0001F9ED',
    u':montaña_con_nieve:': u'\U0001F3D4\U0000FE0F',
    u':montaña:': u'\U000026F0\U0000FE0F',
    u':volcán:': u'\U0001F30B',
    u':monte_fuji:': u'\U0001F5FB',
    u':camping:': u'\U0001F3D5\U0000FE0F',
    u':playa_y_sombrilla:': u'\U0001F3D6\U0000FE0F',
    u':desierto:': u'\U0001F3DC\U0000FE0F',
    u':isla_desierta:': u'\U0001F3DD\U0000FE0F',
    u':parque_nacional:': u'\U0001F3DE\U0000FE0F',
    u':estadio:': u'\U0001F3DF\U0000FE0F',
    u':edificio_clásico:': u'\U0001F3DB\U0000FE0F',
    u':construcción:': u'\U0001F3D7\U0000FE0F',
    u':ladrillo:': u'\U0001F9F1',
    u':piedra:': u'\U0001FAA8',
    u':madera:': u'\U0001FAB5',
    u':cabaña:': u'\U0001F6D6',
    u':casas:': u'\U0001F3D8\U0000FE0F',
    u':casa_abandonada:': u'\U0001F3DA\U0000FE0F',
    u':casa:': u'\U0001F3E0',
    u':casa_con_jardín:': u'\U0001F3E1',
    u':edificio_de_oficinas:': u'\U0001F3E2',
    u':oficina_de_correos_japonesa:': u'\U0001F3E3',
    u':oficina_de_correos_europea:': u'\U0001F3E4',
    u':hospital:': u'\U0001F3E5',
    u':banco:': u'\U0001F3E6',
    u':hotel:': u'\U0001F3E8',
    u':hotel_del_amor:': u'\U0001F3E9',
    u':tienda_24_horas:': u'\U0001F3EA',
    u':edificio_de_colegio:': u'\U0001F3EB',
    u':grandes_almacenes:': u'\U0001F3EC',
    u':fábrica:': u'\U0001F3ED',
    u':castillo_japonés:': u'\U0001F3EF',
    u':castillo_europeo:': u'\U0001F3F0',
    u':iglesia_celebrando_boda:': u'\U0001F492',
    u':torre_de_tokio:': u'\U0001F5FC',
    u':estatua_de_la_libertad:': u'\U0001F5FD',
    u':iglesia:': u'\U000026EA',
    u':mezquita:': u'\U0001F54C',
    u':templo_hindú:': u'\U0001F6D5',
    u':sinagoga:': u'\U0001F54D',
    u':santuario_sintoísta:': u'\U000026E9\U0000FE0F',
    u':kaaba:': u'\U0001F54B',
    u':fuente:': u'\U000026F2',
    u':tienda_de_campaña:': u'\U000026FA',
    u':bruma:': u'\U0001F301',
    u':noche_estrellada:': u'\U0001F303',
    u':paisaje_urbano:': u'\U0001F3D9\U0000FE0F',
    u':amanecer_sobre_montañas:': u'\U0001F304',
    u':amanecer:': u'\U0001F305',
    u':ciudad_al_atardecer:': u'\U0001F306',
    u':puesta_del_sol:': u'\U0001F307',
    u':puente_de_noche:': u'\U0001F309',
    u':aguas_termales:': u'\U00002668\U0000FE0F',
    u':caballo_de_tiovivo:': u'\U0001F3A0',
    u':noria_de_feria:': u'\U0001F3A1',
    u':montaña_rusa:': u'\U0001F3A2',
    u':poste_de_barbero:': u'\U0001F488',
    u':carpa_de_circo:': u'\U0001F3AA',
    u':locomotora_de_vapor:': u'\U0001F682',
    u':vagón:': u'\U0001F683',
    u':tren_de_alta_velocidad:': u'\U0001F684',
    u':tren_bala:': u'\U0001F685',
    u':tren:': u'\U0001F686',
    u':metro:': u'\U0001F687',
    u':tren_ligero:': u'\U0001F688',
    u':estación_de_tren:': u'\U0001F689',
    u':tranvía:': u'\U0001F68A',
    u':monorraíl:': u'\U0001F69D',
    u':ferrocarril_de_montaña:': u'\U0001F69E',
    u':vagón_de_tranvía:': u'\U0001F68B',
    u':autobús:': u'\U0001F68C',
    u':autobús_próximo:': u'\U0001F68D',
    u':trolebús:': u'\U0001F68E',
    u':minibús:': u'\U0001F690',
    u':ambulancia:': u'\U0001F691',
    u':coche_de_bomberos:': u'\U0001F692',
    u':coche_de_policía:': u'\U0001F693',
    u':coche_de_policía_próximo:': u'\U0001F694',
    u':taxi:': u'\U0001F695',
    u':taxi_próximo:': u'\U0001F696',
    u':coche:': u'\U0001F697',
    u':coche_próximo:': u'\U0001F698',
    u':vehículo_deportivo_utilitario:': u'\U0001F699',
    u':camioneta:': u'\U0001F6FB',
    u':camión_de_reparto:': u'\U0001F69A',
    u':camión_articulado:': u'\U0001F69B',
    u':tractor:': u'\U0001F69C',
    u':coche_de_carreras:': u'\U0001F3CE\U0000FE0F',
    u':moto:': u'\U0001F3CD\U0000FE0F',
    u':scooter:': u'\U0001F6F5',
    u':silla_de_ruedas_manual:': u'\U0001F9BD',
    u':silla_de_ruedas_eléctrica:': u'\U0001F9BC',
    u':mototaxi:': u'\U0001F6FA',
    u':bicicleta:': u'\U0001F6B2',
    u':patinete:': u'\U0001F6F4',
    u':monopatín:': u'\U0001F6F9',
    u':patines:': u'\U0001F6FC',
    u':parada_de_autobús:': u'\U0001F68F',
    u':autopista:': u'\U0001F6E3\U0000FE0F',
    u':vía_de_tren:': u'\U0001F6E4\U0000FE0F',
    u':barril_de_petróleo:': u'\U0001F6E2\U0000FE0F',
    u':surtidor_de_gasolina:': u'\U000026FD',
    u':luces_de_policía:': u'\U0001F6A8',
    u':semáforo_horizontal:': u'\U0001F6A5',
    u':semáforo:': u'\U0001F6A6',
    u':señal_de_stop:': u'\U0001F6D1',
    u':obras:': u'\U0001F6A7',
    u':ancla:': u'\U00002693',
    u':barco_de_vela:': u'\U000026F5',
    u':canoa:': u'\U0001F6F6',
    u':lancha_motora:': u'\U0001F6A4',
    u':barco_de_pasajeros:': u'\U0001F6F3\U0000FE0F',
    u':ferri:': u'\U000026F4\U0000FE0F',
    u':barco_a_motor:': u'\U0001F6E5\U0000FE0F',
    u':barco:': u'\U0001F6A2',
    u':avión:': u'\U00002708\U0000FE0F',
    u':avioneta:': u'\U0001F6E9\U0000FE0F',
    u':avión_despegando:': u'\U0001F6EB',
    u':avión_aterrizando:': u'\U0001F6EC',
    u':paracaídas:': u'\U0001FA82',
    u':asiento_de_transporte:': u'\U0001F4BA',
    u':helicóptero:': u'\U0001F681',
    u':ferrocarril_de_suspensión:': u'\U0001F69F',
    u':teleférico_de_montaña:': u'\U0001F6A0',
    u':teleférico:': u'\U0001F6A1',
    u':satélite:': u'\U0001F6F0\U0000FE0F',
    u':cohete:': u'\U0001F680',
    u':platillo_volante:': u'\U0001F6F8',
    u':timbre_de_hotel:': u'\U0001F6CE\U0000FE0F',
    u':equipaje:': u'\U0001F9F3',
    u':reloj_de_arena_sin_tiempo:': u'\U0000231B',
    u':reloj_de_arena_con_tiempo:': u'\U000023F3',
    u':reloj:': u'\U0000231A',
    u':reloj_despertador:': u'\U000023F0',
    u':cronómetro:': u'\U000023F1\U0000FE0F',
    u':temporizador:': u'\U000023F2\U0000FE0F',
    u':reloj_de_sobremesa:': u'\U0001F570\U0000FE0F',
    u':12_en_punto:': u'\U0001F55B',
    u':doce_y_media:': u'\U0001F567',
    u':1_en_punto:': u'\U0001F550',
    u':una_y_media:': u'\U0001F55C',
    u':2_en_punto:': u'\U0001F551',
    u':dos_y_media:': u'\U0001F55D',
    u':3_en_punto:': u'\U0001F552',
    u':tres_y_media:': u'\U0001F55E',
    u':4_en_punto:': u'\U0001F553',
    u':cuatro_y_media:': u'\U0001F55F',
    u':5_en_punto:': u'\U0001F554',
    u':cinco_y_media:': u'\U0001F560',
    u':6_en_punto:': u'\U0001F555',
    u':seis_y_media:': u'\U0001F561',
    u':7_en_punto:': u'\U0001F556',
    u':siete_y_media:': u'\U0001F562',
    u':8_en_punto:': u'\U0001F557',
    u':ocho_y_media:': u'\U0001F563',
    u':9_en_punto:': u'\U0001F558',
    u':nueve_y_media:': u'\U0001F564',
    u':10_en_punto:': u'\U0001F559',
    u':diez_y_media:': u'\U0001F565',
    u':11_en_punto:': u'\U0001F55A',
    u':once_y_media:': u'\U0001F566',
    u':luna_nueva:': u'\U0001F311',
    u':luna_creciente:': u'\U0001F312',
    u':luna_en_cuarto_creciente:': u'\U0001F313',
    u':luna_gibosa_creciente:': u'\U0001F314',
    u':luna_llena:': u'\U0001F315',
    u':luna_gibosa_menguante:': u'\U0001F316',
    u':luna_en_cuarto_menguante:': u'\U0001F317',
    u':luna_menguante:': u'\U0001F318',
    u':luna:': u'\U0001F319',
    u':luna_nueva_con_cara:': u'\U0001F31A',
    u':luna_de_cuarto_creciente_con_cara:': u'\U0001F31B',
    u':luna_de_cuarto_menguante_con_cara:': u'\U0001F31C',
    u':termómetro:': u'\U0001F321\U0000FE0F',
    u':sol:': u'\U00002600\U0000FE0F',
    u':luna_llena_con_cara:': u'\U0001F31D',
    u':sol_con_cara:': u'\U0001F31E',
    u':planeta_con_anillos:': u'\U0001FA90',
    u':estrella_blanca_mediana:': u'\U00002B50',
    u':estrella_brillante:': u'\U0001F31F',
    u':estrella_fugaz:': u'\U0001F320',
    u':vía_láctea:': u'\U0001F30C',
    u':nube:': u'\U00002601\U0000FE0F',
    u':sol_detrás_de_una_nube:': u'\U000026C5',
    u':nube_con_rayo_y_lluvia:': u'\U000026C8\U0000FE0F',
    u':sol_detrás_de_una_nube_pequeña:': u'\U0001F324\U0000FE0F',
    u':sol_detrás_de_una_nube_grande:': u'\U0001F325\U0000FE0F',
    u':sol_detrás_de_una_nube_con_lluvia:': u'\U0001F326\U0000FE0F',
    u':nube_con_lluvia:': u'\U0001F327\U0000FE0F',
    u':nube_con_nieve:': u'\U0001F328\U0000FE0F',
    u':nube_con_rayo:': u'\U0001F329\U0000FE0F',
    u':tornado:': u'\U0001F32A\U0000FE0F',
    u':niebla:': u'\U0001F32B\U0000FE0F',
    u':cara_de_viento:': u'\U0001F32C\U0000FE0F',
    u':ciclón:': u'\U0001F300',
    u':arcoíris:': u'\U0001F308',
    u':paraguas_cerrado:': u'\U0001F302',
    u':paraguas:': u'\U00002602\U0000FE0F',
    u':paraguas_con_gotas_de_lluvia:': u'\U00002614',
    u':sombrilla_en_la_arena:': u'\U000026F1\U0000FE0F',
    u':alto_voltaje:': u'\U000026A1',
    u':copo_de_nieve:': u'\U00002744\U0000FE0F',
    u':muñeco_de_nieve_con_nieve:': u'\U00002603\U0000FE0F',
    u':muñeco_de_nieve:': u'\U000026C4',
    u':meteorito:': u'\U00002604\U0000FE0F',
    u':fuego:': u'\U0001F525',
    u':gota:': u'\U0001F4A7',
    u':ola_de_mar:': u'\U0001F30A',
    u':calabaza_de_halloween:': u'\U0001F383',
    u':árbol_de_navidad:': u'\U0001F384',
    u':fuegos_artificiales:': u'\U0001F386',
    u':bengala:': u'\U0001F387',
    u':petardo:': u'\U0001F9E8',
    u':chispas:': u'\U00002728',
    u':globo:': u'\U0001F388',
    u':cañón_de_confeti:': u'\U0001F389',
    u':bola_de_confeti:': u'\U0001F38A',
    u':árbol_de_tanabata:': u'\U0001F38B',
    u':decoración_de_pino:': u'\U0001F38D',
    u':muñecas_japonesas:': u'\U0001F38E',
    u':banderín_de_carpas:': u'\U0001F38F',
    u':campanilla_de_viento:': u'\U0001F390',
    u':ceremonia_de_contemplación_de_la_luna:': u'\U0001F391',
    u':sobre_rojo:': u'\U0001F9E7',
    u':lazo:': u'\U0001F380',
    u':regalo:': u'\U0001F381',
    u':lazo_conmemorativo:': u'\U0001F397\U0000FE0F',
    u':entradas:': u'\U0001F39F\U0000FE0F',
    u':tique:': u'\U0001F3AB',
    u':medalla_militar:': u'\U0001F396\U0000FE0F',
    u':trofeo:': u'\U0001F3C6',
    u':medalla_deportiva:': u'\U0001F3C5',
    u':medalla_de_oro:': u'\U0001F947',
    u':medalla_de_plata:': u'\U0001F948',
    u':medalla_de_bronce:': u'\U0001F949',
    u':balón_de_fútbol:': u'\U000026BD',
    u':béisbol:': u'\U000026BE',
    u':pelota_de_softball:': u'\U0001F94E',
    u':balón_de_baloncesto:': u'\U0001F3C0',
    u':voleibol:': u'\U0001F3D0',
    u':balón_de_fútbol_americano:': u'\U0001F3C8',
    u':balón_de_rugby:': u'\U0001F3C9',
    u':pelota_de_tenis:': u'\U0001F3BE',
    u':disco_volador:': u'\U0001F94F',
    u':bolos:': u'\U0001F3B3',
    u':críquet:': u'\U0001F3CF',
    u':hockey_sobre_hierba:': u'\U0001F3D1',
    u':hockey_sobre_hielo:': u'\U0001F3D2',
    u':lacrosse:': u'\U0001F94D',
    u':tenis_de_mesa:': u'\U0001F3D3',
    u':bádminton:': u'\U0001F3F8',
    u':guante_de_boxeo:': u'\U0001F94A',
    u':uniforme_de_artes_marciales:': u'\U0001F94B',
    u':portería:': u'\U0001F945',
    u':banderín_en_hoyo:': u'\U000026F3',
    u':patín_de_hielo:': u'\U000026F8\U0000FE0F',
    u':caña_de_pescar:': u'\U0001F3A3',
    u':máscara_de_buceo:': u'\U0001F93F',
    u':camiseta_sin_mangas:': u'\U0001F3BD',
    u':esquís:': u'\U0001F3BF',
    u':trineo:': u'\U0001F6F7',
    u':piedra_de_curling:': u'\U0001F94C',
    u':diana:': u'\U0001F3AF',
    u':yoyó:': u'\U0001FA80',
    u':cometa:': u'\U0001FA81',
    u':bola_negra_de_billar:': u'\U0001F3B1',
    u':bola_de_cristal:': u'\U0001F52E',
    u':varita_mágica:': u'\U0001FA84',
    u':ojo_turco:': u'\U0001F9FF',
    u':mando_de_videoconsola:': u'\U0001F3AE',
    u':joystick:': u'\U0001F579\U0000FE0F',
    u':máquina_tragaperras:': u'\U0001F3B0',
    u':dado:': u'\U0001F3B2',
    u':pieza_de_puzle:': u'\U0001F9E9',
    u':osito_de_peluche:': u'\U0001F9F8',
    u':piñata:': u'\U0001FA85',
    u':muñeca_rusa:': u'\U0001FA86',
    u':palo_de_picas:': u'\U00002660\U0000FE0F',
    u':palo_de_corazones:': u'\U00002665\U0000FE0F',
    u':palo_de_diamantes:': u'\U00002666\U0000FE0F',
    u':palo_de_tréboles:': u'\U00002663\U0000FE0F',
    u':peón_de_ajedrez:': u'\U0000265F\U0000FE0F',
    u':comodín:': u'\U0001F0CF',
    u':dragón_rojo_de_mahjong:': u'\U0001F004',
    u':cartas_de_flores:': u'\U0001F3B4',
    u':máscaras_de_teatro:': u'\U0001F3AD',
    u':cuadro_enmarcado:': u'\U0001F5BC\U0000FE0F',
    u':paleta_de_pintor:': u'\U0001F3A8',
    u':hilo:': u'\U0001F9F5',
    u':aguja_de_coser:': u'\U0001FAA1',
    u':ovillo:': u'\U0001F9F6',
    u':nudo:': u'\U0001FAA2',
    u':gafas:': u'\U0001F453',
    u':gafas_de_sol:': u'\U0001F576\U0000FE0F',
    u':gafas_de_protección:': u'\U0001F97D',
    u':bata_de_laboratorio:': u'\U0001F97C',
    u':chaleco_de_seguridad:': u'\U0001F9BA',
    u':corbata:': u'\U0001F454',
    u':camiseta:': u'\U0001F455',
    u':vaqueros:': u'\U0001F456',
    u':bufanda:': u'\U0001F9E3',
    u':guantes:': u'\U0001F9E4',
    u':abrigo:': u'\U0001F9E5',
    u':calcetines:': u'\U0001F9E6',
    u':vestido:': u'\U0001F457',
    u':kimono:': u'\U0001F458',
    u':sari:': u'\U0001F97B',
    u':traje_de_baño_de_una_pieza:': u'\U0001FA71',
    u':ropa_interior:': u'\U0001FA72',
    u':pantalones_cortos:': u'\U0001FA73',
    u':bikini:': u'\U0001F459',
    u':ropa_de_mujer:': u'\U0001F45A',
    u':monedero:': u'\U0001F45B',
    u':bolso:': u'\U0001F45C',
    u':bolso_de_mano:': u'\U0001F45D',
    u':bolsas_de_compras:': u'\U0001F6CD\U0000FE0F',
    u':mochila_escolar:': u'\U0001F392',
    u':chancla:': u'\U0001FA74',
    u':zapato_de_hombre:': u'\U0001F45E',
    u':zapatilla_deportiva:': u'\U0001F45F',
    u':bota_de_senderismo:': u'\U0001F97E',
    u':bailarina:': u'\U0001F97F',
    u':zapato_de_tacón:': u'\U0001F460',
    u':sandalia_de_mujer:': u'\U0001F461',
    u':zapatillas_de_ballet:': u'\U0001FA70',
    u':bota_de_mujer:': u'\U0001F462',
    u':corona:': u'\U0001F451',
    u':sombrero_de_mujer:': u'\U0001F452',
    u':sombrero_de_copa:': u'\U0001F3A9',
    u':birrete:': u'\U0001F393',
    u':gorra_con_visera:': u'\U0001F9E2',
    u':casco_militar:': u'\U0001FA96',
    u':casco_con_una_cruz_blanca:': u'\U000026D1\U0000FE0F',
    u':rosario:': u'\U0001F4FF',
    u':pintalabios:': u'\U0001F484',
    u':anillo:': u'\U0001F48D',
    u':piedra_preciosa:': u'\U0001F48E',
    u':altavoz_silenciado:': u'\U0001F507',
    u':altavoz_a_volumen_bajo:': u'\U0001F508',
    u':altavoz_a_volumen_medio:': u'\U0001F509',
    u':altavoz_a_volumen_alto:': u'\U0001F50A',
    u':altavoz_de_mano:': u'\U0001F4E2',
    u':megáfono:': u'\U0001F4E3',
    u':corneta_de_posta:': u'\U0001F4EF',
    u':campana:': u'\U0001F514',
    u':campana_con_signo_de_cancelación:': u'\U0001F515',
    u':pentagrama:': u'\U0001F3BC',
    u':nota_musical:': u'\U0001F3B5',
    u':notas_musicales:': u'\U0001F3B6',
    u':micrófono_de_estudio:': u'\U0001F399\U0000FE0F',
    u':control_de_volumen:': u'\U0001F39A\U0000FE0F',
    u':ruedas_de_control:': u'\U0001F39B\U0000FE0F',
    u':micrófono:': u'\U0001F3A4',
    u':auricular:': u'\U0001F3A7',
    u':radio:': u'\U0001F4FB',
    u':saxofón:': u'\U0001F3B7',
    u':acordeón:': u'\U0001FA97',
    u':guitarra:': u'\U0001F3B8',
    u':teclado_musical:': u'\U0001F3B9',
    u':trompeta:': u'\U0001F3BA',
    u':violín:': u'\U0001F3BB',
    u':banjo:': u'\U0001FA95',
    u':tambor:': u'\U0001F941',
    u':tamboril:': u'\U0001FA98',
    u':teléfono_móvil:': u'\U0001F4F1',
    u':móvil_con_una_flecha:': u'\U0001F4F2',
    u':teléfono:': u'\U0000260E\U0000FE0F',
    u':auricular_de_teléfono:': u'\U0001F4DE',
    u':busca:': u'\U0001F4DF',
    u':máquina_de_fax:': u'\U0001F4E0',
    u':pila:': u'\U0001F50B',
    u':enchufe_eléctrico:': u'\U0001F50C',
    u':ordenador_portátil:': u'\U0001F4BB',
    u':ordenador_de_sobremesa:': u'\U0001F5A5\U0000FE0F',
    u':impresora:': u'\U0001F5A8\U0000FE0F',
    u':teclado:': u'\U00002328\U0000FE0F',
    u':ratón_de_ordenador:': u'\U0001F5B1\U0000FE0F',
    u':bola_de_desplazamiento:': u'\U0001F5B2\U0000FE0F',
    u':minidisc:': u'\U0001F4BD',
    u':disquete:': u'\U0001F4BE',
    u':disco_óptico:': u'\U0001F4BF',
    u':disco_dvd:': u'\U0001F4C0',
    u':ábaco:': u'\U0001F9EE',
    u':cámara_de_cine:': u'\U0001F3A5',
    u':fotograma_de_película:': u'\U0001F39E\U0000FE0F',
    u':proyector_de_cine:': u'\U0001F4FD\U0000FE0F',
    u':claqueta:': u'\U0001F3AC',
    u':televisión:': u'\U0001F4FA',
    u':cámara_de_fotos:': u'\U0001F4F7',
    u':cámara_con_flash:': u'\U0001F4F8',
    u':videocámara:': u'\U0001F4F9',
    u':cinta_de_vídeo:': u'\U0001F4FC',
    u':lupa_orientada_hacia_la_izquierda:': u'\U0001F50D',
    u':lupa_orientada_hacia_la_derecha:': u'\U0001F50E',
    u':vela:': u'\U0001F56F\U0000FE0F',
    u':bombilla:': u'\U0001F4A1',
    u':linterna:': u'\U0001F526',
    u':lámpara_japonesa:': u'\U0001F3EE',
    u':lámpara_de_aceite:': u'\U0001FA94',
    u':cuaderno_con_tapa_decorativa:': u'\U0001F4D4',
    u':libro_cerrado:': u'\U0001F4D5',
    u':libro_abierto:': u'\U0001F4D6',
    u':libro_verde:': u'\U0001F4D7',
    u':libro_azul:': u'\U0001F4D8',
    u':libro_naranja:': u'\U0001F4D9',
    u':libros:': u'\U0001F4DA',
    u':cuaderno:': u'\U0001F4D3',
    u':libro_de_contabilidad:': u'\U0001F4D2',
    u':página_doblada:': u'\U0001F4C3',
    u':pergamino:': u'\U0001F4DC',
    u':página_hacia_arriba:': u'\U0001F4C4',
    u':periódico:': u'\U0001F4F0',
    u':periódico_enrollado:': u'\U0001F5DE\U0000FE0F',
    u':marcadores:': u'\U0001F4D1',
    u':marcapáginas:': u'\U0001F516',
    u':etiqueta:': u'\U0001F3F7\U0000FE0F',
    u':bolsa_de_dinero:': u'\U0001F4B0',
    u':moneda:': u'\U0001FA99',
    u':billete_de_yen:': u'\U0001F4B4',
    u':billete_de_dólar:': u'\U0001F4B5',
    u':billete_de_euro:': u'\U0001F4B6',
    u':billete_de_libra:': u'\U0001F4B7',
    u':billete_con_alas:': u'\U0001F4B8',
    u':tarjeta_de_crédito:': u'\U0001F4B3',
    u':recibo:': u'\U0001F9FE',
    u':mercado_al_alza:': u'\U0001F4B9',
    u':sobre:': u'\U00002709\U0000FE0F',
    u':correo_electrónico:': u'\U0001F4E7',
    u':sobre_entrante:': u'\U0001F4E8',
    u':sobre_con_flecha:': u'\U0001F4E9',
    u':bandeja_de_salida:': u'\U0001F4E4',
    u':bandeja_de_entrada:': u'\U0001F4E5',
    u':paquete:': u'\U0001F4E6',
    u':buzón_cerrado_con_la_bandera_levantada:': u'\U0001F4EB',
    u':buzón_cerrado_con_la_bandera_bajada:': u'\U0001F4EA',
    u':buzón_abierto_con_la_bandera_levantada:': u'\U0001F4EC',
    u':buzón_abierto_con_la_bandera_bajada:': u'\U0001F4ED',
    u':buzón:': u'\U0001F4EE',
    u':urna_con_papeleta:': u'\U0001F5F3\U0000FE0F',
    u':lápiz:': u'\U0000270F\U0000FE0F',
    u':pluma_negra:': u'\U00002712\U0000FE0F',
    u':estilográfica:': u'\U0001F58B\U0000FE0F',
    u':bolígrafo:': u'\U0001F58A\U0000FE0F',
    u':pincel:': u'\U0001F58C\U0000FE0F',
    u':lápiz_de_cera:': u'\U0001F58D\U0000FE0F',
    u':cuaderno_de_notas:': u'\U0001F4DD',
    u':maletín:': u'\U0001F4BC',
    u':carpeta_de_archivos:': u'\U0001F4C1',
    u':carpeta_de_archivos_abierta:': u'\U0001F4C2',
    u':separador_de_fichas:': u'\U0001F5C2\U0000FE0F',
    u':calendario:': u'\U0001F4C5',
    u':calendario_recortable:': u'\U0001F4C6',
    u':bloc_de_notas_de_espiral:': u'\U0001F5D2\U0000FE0F',
    u':calendario_de_espiral:': u'\U0001F5D3\U0000FE0F',
    u':organizador_de_fichas:': u'\U0001F4C7',
    u':gráfica_de_evolución_ascendente:': u'\U0001F4C8',
    u':gráfica_de_evolución_descendente:': u'\U0001F4C9',
    u':gráfico_de_barras:': u'\U0001F4CA',
    u':portapapeles:': u'\U0001F4CB',
    u':chincheta:': u'\U0001F4CC',
    u':chincheta_redonda:': u'\U0001F4CD',
    u':clip:': u'\U0001F4CE',
    u':clips_unidos:': u'\U0001F587\U0000FE0F',
    u':regla:': u'\U0001F4CF',
    u':escuadra:': u'\U0001F4D0',
    u':tijeras:': u'\U00002702\U0000FE0F',
    u':archivador_de_tarjetas:': u'\U0001F5C3\U0000FE0F',
    u':archivador:': u'\U0001F5C4\U0000FE0F',
    u':papelera:': u'\U0001F5D1\U0000FE0F',
    u':candado_cerrado:': u'\U0001F512',
    u':candado_abierto:': u'\U0001F513',
    u':candado_con_pluma_estilográfica:': u'\U0001F50F',
    u':candado_cerrado_y_llave:': u'\U0001F510',
    u':llave:': u'\U0001F511',
    u':llave_antigua:': u'\U0001F5DD\U0000FE0F',
    u':martillo:': u'\U0001F528',
    u':hacha:': u'\U0001FA93',
    u':pico:': u'\U000026CF\U0000FE0F',
    u':martillo_y_pico:': u'\U00002692\U0000FE0F',
    u':martillo_y_llave_inglesa:': u'\U0001F6E0\U0000FE0F',
    u':puñal:': u'\U0001F5E1\U0000FE0F',
    u':espadas_cruzadas:': u'\U00002694\U0000FE0F',
    u':pistola:': u'\U0001F52B',
    u':bumerán:': u'\U0001FA83',
    u':arco_y_flecha:': u'\U0001F3F9',
    u':escudo:': u'\U0001F6E1\U0000FE0F',
    u':sierra_de_carpintería:': u'\U0001FA9A',
    u':llave_inglesa:': u'\U0001F527',
    u':destornillador:': u'\U0001FA9B',
    u':tornillo_y_tuerca:': u'\U0001F529',
    u':engranaje:': u'\U00002699\U0000FE0F',
    u':tornillo_de_banco:': u'\U0001F5DC\U0000FE0F',
    u':balanza:': u'\U00002696\U0000FE0F',
    u':bastón:': u'\U0001F9AF',
    u':eslabón:': u'\U0001F517',
    u':cadenas:': u'\U000026D3\U0000FE0F',
    u':gancho:': u'\U0001FA9D',
    u':caja_de_herramientas:': u'\U0001F9F0',
    u':imán:': u'\U0001F9F2',
    u':escalera:': u'\U0001FA9C',
    u':alambique:': u'\U00002697\U0000FE0F',
    u':tubo_de_ensayo:': u'\U0001F9EA',
    u':placa_de_petri:': u'\U0001F9EB',
    u':adn:': u'\U0001F9EC',
    u':microscopio:': u'\U0001F52C',
    u':telescopio:': u'\U0001F52D',
    u':antena_de_satélite:': u'\U0001F4E1',
    u':jeringuilla:': u'\U0001F489',
    u':gota_de_sangre:': u'\U0001FA78',
    u':píldora:': u'\U0001F48A',
    u':tirita:': u'\U0001FA79',
    u':estetoscopio:': u'\U0001FA7A',
    u':puerta:': u'\U0001F6AA',
    u':ascensor:': u'\U0001F6D7',
    u':espejo:': u'\U0001FA9E',
    u':ventana:': u'\U0001FA9F',
    u':cama:': u'\U0001F6CF\U0000FE0F',
    u':sofá_y_lámpara:': u'\U0001F6CB\U0000FE0F',
    u':silla:': u'\U0001FA91',
    u':inodoro:': u'\U0001F6BD',
    u':desatascador:': u'\U0001FAA0',
    u':ducha:': u'\U0001F6BF',
    u':bañera:': u'\U0001F6C1',
    u':trampa_de_ratones:': u'\U0001FAA4',
    u':cuchilla_de_afeitar:': u'\U0001FA92',
    u':bote_de_crema:': u'\U0001F9F4',
    u':imperdible:': u'\U0001F9F7',
    u':escoba:': u'\U0001F9F9',
    u':cesta:': u'\U0001F9FA',
    u':rollo_de_papel:': u'\U0001F9FB',
    u':cubo:': u'\U0001FAA3',
    u':jabón:': u'\U0001F9FC',
    u':cepillo_de_dientes:': u'\U0001FAA5',
    u':esponja:': u'\U0001F9FD',
    u':extintor:': u'\U0001F9EF',
    u':carrito_de_la_compra:': u'\U0001F6D2',
    u':cigarrillo:': u'\U0001F6AC',
    u':ataúd:': u'\U000026B0\U0000FE0F',
    u':lápida:': u'\U0001FAA6',
    u':urna_funeraria:': u'\U000026B1\U0000FE0F',
    u':estatua_moái:': u'\U0001F5FF',
    u':letrero:': u'\U0001FAA7',
    u':señal_de_cajero_automático:': u'\U0001F3E7',
    u':señal_de_usar_papelera:': u'\U0001F6AE',
    u':agua_potable:': u'\U0001F6B0',
    u':símbolo_de_silla_de_ruedas:': u'\U0000267F',
    u':aseo_para_hombres:': u'\U0001F6B9',
    u':señal_de_aseo_para_mujeres:': u'\U0001F6BA',
    u':señal_de_aseos:': u'\U0001F6BB',
    u':señal_de_bebé:': u'\U0001F6BC',
    u':aseos:': u'\U0001F6BE',
    u':control_de_pasaportes:': u'\U0001F6C2',
    u':aduana:': u'\U0001F6C3',
    u':recogida_de_equipajes:': u'\U0001F6C4',
    u':consigna:': u'\U0001F6C5',
    u':advertencia:': u'\U000026A0\U0000FE0F',
    u':niños_cruzando:': u'\U0001F6B8',
    u':dirección_prohibida:': u'\U000026D4',
    u':prohibido:': u'\U0001F6AB',
    u':bicicletas_prohibidas:': u'\U0001F6B3',
    u':prohibido_fumar:': u'\U0001F6AD',
    u':prohibido_tirar_basura:': u'\U0001F6AF',
    u':agua_no_potable:': u'\U0001F6B1',
    u':prohibido_el_paso_de_peatones:': u'\U0001F6B7',
    u':prohibido_el_uso_de_móviles:': u'\U0001F4F5',
    u':prohibido_para_menos_de_18_años:': u'\U0001F51E',
    u':radiactivo:': u'\U00002622\U0000FE0F',
    u':riesgo_biológico:': u'\U00002623\U0000FE0F',
    u':flecha_hacia_arriba:': u'\U00002B06\U0000FE0F',
    u':flecha_hacia_la_esquina_superior_derecha:': u'\U00002197\U0000FE0F',
    u':flecha_hacia_la_derecha:': u'\U000027A1\U0000FE0F',
    u':flecha_hacia_la_esquina_inferior_derecha:': u'\U00002198\U0000FE0F',
    u':flecha_hacia_abajo:': u'\U00002B07\U0000FE0F',
    u':flecha_hacia_la_esquina_inferior_izquierda:': u'\U00002199\U0000FE0F',
    u':flecha_hacia_la_izquierda:': u'\U00002B05\U0000FE0F',
    u':flecha_hacia_la_esquina_superior_izquierda:': u'\U00002196\U0000FE0F',
    u':flecha_arriba_y_abajo:': u'\U00002195\U0000FE0F',
    u':flecha_izquierda_y_derecha:': u'\U00002194\U0000FE0F',
    u':flecha_derecha_curvándose_a_la_izquierda:': u'\U000021A9\U0000FE0F',
    u':flecha_izquierda_curvándose_a_la_derecha:': u'\U000021AA\U0000FE0F',
    u':flecha_derecha_curvándose_hacia_arriba:': u'\U00002934\U0000FE0F',
    u':flecha_derecha_curvándose_hacia_abajo:': u'\U00002935\U0000FE0F',
    u':flechas_verticales_en_sentido_horario:': u'\U0001F503',
    u':flechas_en_sentido_antihorario:': u'\U0001F504',
    u':flecha_back:': u'\U0001F519',
    u':flecha_end:': u'\U0001F51A',
    u':flecha_on!:': u'\U0001F51B',
    u':flecha_soon:': u'\U0001F51C',
    u':flecha_top:': u'\U0001F51D',
    u':lugar_de_culto:': u'\U0001F6D0',
    u':símbolo_de_átomo:': u'\U0000269B\U0000FE0F',
    u':om:': u'\U0001F549\U0000FE0F',
    u':estrella_de_david:': u'\U00002721\U0000FE0F',
    u':rueda_del_dharma:': u'\U00002638\U0000FE0F',
    u':yin_yang:': u'\U0000262F\U0000FE0F',
    u':cruz_latina:': u'\U0000271D\U0000FE0F',
    u':cruz_ortodoxa:': u'\U00002626\U0000FE0F',
    u':media_luna_y_estrella:': u'\U0000262A\U0000FE0F',
    u':símbolo_de_la_paz:': u'\U0000262E\U0000FE0F',
    u':menorá:': u'\U0001F54E',
    u':estrella_de_seis_puntas:': u'\U0001F52F',
    u':aries:': u'\U00002648',
    u':tauro:': u'\U00002649',
    u':géminis:': u'\U0000264A',
    u':cáncer:': u'\U0000264B',
    u':leo:': u'\U0000264C',
    u':virgo:': u'\U0000264D',
    u':libra:': u'\U0000264E',
    u':escorpio:': u'\U0000264F',
    u':sagitario:': u'\U00002650',
    u':capricornio:': u'\U00002651',
    u':acuario:': u'\U00002652',
    u':piscis:': u'\U00002653',
    u':ofiuco:': u'\U000026CE',
    u':reproducción_aleatoria:': u'\U0001F500',
    u':repetir:': u'\U0001F501',
    u':repetir_una_vez:': u'\U0001F502',
    u':reproducir:': u'\U000025B6\U0000FE0F',
    u':avance_rápido:': u'\U000023E9',
    u':pista_siguiente:': u'\U000023ED\U0000FE0F',
    u':reproducir_o_pausa:': u'\U000023EF\U0000FE0F',
    u':retroceso:': u'\U000025C0\U0000FE0F',
    u':rebobinado:': u'\U000023EA',
    u':pista_anterior:': u'\U000023EE\U0000FE0F',
    u':triángulo_hacia_arriba:': u'\U0001F53C',
    u':triángulo_doble_hacia_arriba:': u'\U000023EB',
    u':triángulo_hacia_abajo:': u'\U0001F53D',
    u':triángulo_doble_hacia_abajo:': u'\U000023EC',
    u':pausa:': u'\U000023F8\U0000FE0F',
    u':detener:': u'\U000023F9\U0000FE0F',
    u':grabar:': u'\U000023FA\U0000FE0F',
    u':expulsar:': u'\U000023CF\U0000FE0F',
    u':cine:': u'\U0001F3A6',
    u':brillo_bajo:': u'\U0001F505',
    u':brillo_alto:': u'\U0001F506',
    u':barras_de_cobertura:': u'\U0001F4F6',
    u':modo_vibración:': u'\U0001F4F3',
    u':teléfono_móvil_apagado:': u'\U0001F4F4',
    u':signo_femenino:': u'\U00002640\U0000FE0F',
    u':signo_masculino:': u'\U00002642\U0000FE0F',
    u':símbolo_de_transgénero:': u'\U000026A7\U0000FE0F',
    u':multiplicación:': u'\U00002716\U0000FE0F',
    u':más:': u'\U00002795',
    u':menos:': u'\U00002796',
    u':división:': u'\U00002797',
    u':infinito:': u'\U0000267E\U0000FE0F',
    u':exclamación_doble:': u'\U0000203C\U0000FE0F',
    u':exclamación_e_interrogación:': u'\U00002049\U0000FE0F',
    u':signo_de_interrogación:': u'\U00002753',
    u':interrogación_blanca:': u'\U00002754',
    u':exclamación_blanca:': u'\U00002755',
    u':signo_de_exclamación:': u'\U00002757',
    u':guion_ondulado:': u'\U00003030\U0000FE0F',
    u':cambio_de_divisas:': u'\U0001F4B1',
    u':símbolo_de_dólar:': u'\U0001F4B2',
    u':símbolo_de_medicina:': u'\U00002695\U0000FE0F',
    u':símbolo_de_reciclaje:': u'\U0000267B\U0000FE0F',
    u':flor_de_lis:': u'\U0000269C\U0000FE0F',
    u':emblema_de_tridente:': u'\U0001F531',
    u':etiqueta_identificativa:': u'\U0001F4DB',
    u':símbolo_japonés_para_principiante:': u'\U0001F530',
    u':círculo_rojo_hueco:': u'\U00002B55',
    u':botón_de_marca_de_verificación:': u'\U00002705',
    u':casilla_con_marca_de_verificación:': u'\U00002611\U0000FE0F',
    u':marca_de_verificación:': u'\U00002714\U0000FE0F',
    u':marca_de_cruz:': u'\U0000274C',
    u':botón_con_marca_de_cruz:': u'\U0000274E',
    u':bucle:': u'\U000027B0',
    u':bucle_doble:': u'\U000027BF',
    u':marca_de_alternancia:': u'\U0000303D\U0000FE0F',
    u':asterisco_de_ocho_puntas:': u'\U00002733\U0000FE0F',
    u':estrella_de_ocho_puntas:': u'\U00002734\U0000FE0F',
    u':chispa:': u'\U00002747\U0000FE0F',
    u':copyright:': u'\U000000A9\U0000FE0F',
    u':marca_registrada:': u'\U000000AE\U0000FE0F',
    u':símbolo_de_marca_comercial:': u'\U00002122\U0000FE0F',
    u':teclas_#:': u'\U00000023\U0000FE0F\U000020E3',
    u':teclas_*:': u'\U0000002A\U0000FE0F\U000020E3',
    u':teclas_0:': u'\U00000030\U0000FE0F\U000020E3',
    u':teclas_1:': u'\U00000031\U0000FE0F\U000020E3',
    u':teclas_2:': u'\U00000032\U0000FE0F\U000020E3',
    u':teclas_3:': u'\U00000033\U0000FE0F\U000020E3',
    u':teclas_4:': u'\U00000034\U0000FE0F\U000020E3',
    u':teclas_5:': u'\U00000035\U0000FE0F\U000020E3',
    u':teclas_6:': u'\U00000036\U0000FE0F\U000020E3',
    u':teclas_7:': u'\U00000037\U0000FE0F\U000020E3',
    u':teclas_8:': u'\U00000038\U0000FE0F\U000020E3',
    u':teclas_9:': u'\U00000039\U0000FE0F\U000020E3',
    u':teclas_10:': u'\U0001F51F',
    u':letras_latinas_mayúsculas:': u'\U0001F520',
    u':letras_latinas_minúsculas:': u'\U0001F521',
    u':números:': u'\U0001F522',
    u':símbolos:': u'\U0001F523',
    u':alfabeto_latino:': u'\U0001F524',
    u':grupo_sanguíneo_a:': u'\U0001F170\U0000FE0F',
    u':grupo_sanguíneo_ab:': u'\U0001F18E',
    u':grupo_sanguíneo_b:': u'\U0001F171\U0000FE0F',
    u':borrar:': u'\U0001F191',
    u':botón_cool:': u'\U0001F192',
    u':botón_free:': u'\U0001F193',
    u':información:': u'\U00002139\U0000FE0F',
    u':símbolo_de_identificación:': u'\U0001F194',
    u':m_en_círculo:': u'\U000024C2\U0000FE0F',
    u':botón_new:': u'\U0001F195',
    u':botón_ng:': u'\U0001F196',
    u':grupo_sanguíneo_tipo_o:': u'\U0001F17E\U0000FE0F',
    u':botón_ok:': u'\U0001F197',
    u':aparcamiento:': u'\U0001F17F\U0000FE0F',
    u':símbolo_de_socorro:': u'\U0001F198',
    u':botón_up!:': u'\U0001F199',
    u':botón_vs:': u'\U0001F19A',
    u':ideograma_japonés_para_aquí:': u'\U0001F201',
    u':ideograma_japonés_para_de_cortesía:': u'\U0001F202\U0000FE0F',
    u':ideograma_japonés_para_cantidad_mensual:': u'\U0001F237\U0000FE0F',
    u':ideograma_japonés_para_de_pago:': u'\U0001F236',
    u':ideograma_japonés_para_reservado:': u'\U0001F22F',
    u':ideograma_japonés_para_ganga:': u'\U0001F250',
    u':ideograma_japonés_para_descuento:': u'\U0001F239',
    u':ideograma_japonés_para_gratis:': u'\U0001F21A',
    u':ideograma_japonés_para_prohibido:': u'\U0001F232',
    u':ideograma_japonés_para_aceptable:': u'\U0001F251',
    u':ideograma_japonés_para_aplicación:': u'\U0001F238',
    u':ideograma_japonés_para_aprobado:': u'\U0001F234',
    u':ideograma_japonés_para_vacante:': u'\U0001F233',
    u':ideograma_japonés_para_enhorabuena:': u'\U00003297\U0000FE0F',
    u':ideograma_japonés_para_secreto:': u'\U00003299\U0000FE0F',
    u':ideograma_japonés_para_abierto:': u'\U0001F23A',
    u':ideograma_japonés_para_completo:': u'\U0001F235',
    u':círculo_rojo_grande:': u'\U0001F534',
    u':círculo_naranja:': u'\U0001F7E0',
    u':círculo_amarillo:': u'\U0001F7E1',
    u':círculo_verde:': u'\U0001F7E2',
    u':círculo_azul_grande:': u'\U0001F535',
    u':círculo_morado:': u'\U0001F7E3',
    u':círculo_marrón:': u'\U0001F7E4',
    u':círculo_negro:': u'\U000026AB',
    u':círculo_blanco:': u'\U000026AA',
    u':cuadrado_rojo:': u'\U0001F7E5',
    u':cuadrado_naranja:': u'\U0001F7E7',
    u':cuadrado_amarillo:': u'\U0001F7E8',
    u':cuadrado_verde:': u'\U0001F7E9',
    u':cuadrado_azul:': u'\U0001F7E6',
    u':cuadrado_morado:': u'\U0001F7EA',
    u':cuadrado_marrón:': u'\U0001F7EB',
    u':cuadrado_negro_grande:': u'\U00002B1B',
    u':cuadrado_blanco_grande:': u'\U00002B1C',
    u':cuadrado_negro_mediano:': u'\U000025FC\U0000FE0F',
    u':cuadrado_blanco_mediano:': u'\U000025FB\U0000FE0F',
    u':cuadrado_negro_mediano-pequeño:': u'\U000025FE',
    u':cuadrado_blanco_mediano-pequeño:': u'\U000025FD',
    u':cuadrado_negro_pequeño:': u'\U000025AA\U0000FE0F',
    u':cuadrado_blanco_pequeño:': u'\U000025AB\U0000FE0F',
    u':rombo_naranja_grande:': u'\U0001F536',
    u':rombo_azul_grande:': u'\U0001F537',
    u':rombo_naranja_pequeño:': u'\U0001F538',
    u':rombo_azul_pequeño:': u'\U0001F539',
    u':triángulo_rojo_hacia_arriba:': u'\U0001F53A',
    u':triángulo_rojo_hacia_abajo:': u'\U0001F53B',
    u':rombo_con_pétalo:': u'\U0001F4A0',
    u':botón_de_opción:': u'\U0001F518',
    u':botón_cuadrado_con_borde_blanco:': u'\U0001F533',
    u':botón_cuadrado_con_borde_negro:': u'\U0001F532',
    u':bandera_de_cuadros:': u'\U0001F3C1',
    u':bandera_triangular:': u'\U0001F6A9',
    u':banderas_cruzadas:': u'\U0001F38C',
    u':bandera_negra:': u'\U0001F3F4',
    u':bandera_blanca:': u'\U0001F3F3\U0000FE0F',
    u':bandera_del_arcoíris:': u'\U0001F3F3\U0000FE0F\U0000200D\U0001F308',
    u':bandera_transgénero:': u'\U0001F3F3\U0000FE0F\U0000200D\U000026A7\U0000FE0F',
    u':bandera_pirata:': u'\U0001F3F4\U0000200D\U00002620\U0000FE0F',
    u':bandera_isla_de_la_ascensión:': u'\U0001F1E6\U0001F1E8',
    u':bandera_andorra:': u'\U0001F1E6\U0001F1E9',
    u':bandera_emiratos_árabes_unidos:': u'\U0001F1E6\U0001F1EA',
    u':bandera_afganistán:': u'\U0001F1E6\U0001F1EB',
    u':bandera_antigua_y_barbuda:': u'\U0001F1E6\U0001F1EC',
    u':bandera_anguila:': u'\U0001F1E6\U0001F1EE',
    u':bandera_albania:': u'\U0001F1E6\U0001F1F1',
    u':bandera_armenia:': u'\U0001F1E6\U0001F1F2',
    u':bandera_angola:': u'\U0001F1E6\U0001F1F4',
    u':bandera_antártida:': u'\U0001F1E6\U0001F1F6',
    u':bandera_argentina:': u'\U0001F1E6\U0001F1F7',
    u':bandera_samoa_americana:': u'\U0001F1E6\U0001F1F8',
    u':bandera_austria:': u'\U0001F1E6\U0001F1F9',
    u':bandera_australia:': u'\U0001F1E6\U0001F1FA',
    u':bandera_aruba:': u'\U0001F1E6\U0001F1FC',
    u':bandera_islas_?_land:': u'\U0001F1E6\U0001F1FD',
    u':bandera_azerbaiyán:': u'\U0001F1E6\U0001F1FF',
    u':bandera_bosnia_y_herzegovina:': u'\U0001F1E7\U0001F1E6',
    u':bandera_barbados:': u'\U0001F1E7\U0001F1E7',
    u':bandera_bangladés:': u'\U0001F1E7\U0001F1E9',
    u':bandera_bélgica:': u'\U0001F1E7\U0001F1EA',
    u':bandera_burkina_faso:': u'\U0001F1E7\U0001F1EB',
    u':bandera_bulgaria:': u'\U0001F1E7\U0001F1EC',
    u':bandera_baréin:': u'\U0001F1E7\U0001F1ED',
    u':bandera_burundi:': u'\U0001F1E7\U0001F1EE',
    u':bandera_benín:': u'\U0001F1E7\U0001F1EF',
    u':bandera_san_bartolomé:': u'\U0001F1E7\U0001F1F1',
    u':bandera_bermudas:': u'\U0001F1E7\U0001F1F2',
    u':bandera_brunéi:': u'\U0001F1E7\U0001F1F3',
    u':bandera_bolivia:': u'\U0001F1E7\U0001F1F4',
    u':bandera_caribe_neerlandés:': u'\U0001F1E7\U0001F1F6',
    u':bandera_brasil:': u'\U0001F1E7\U0001F1F7',
    u':bandera_bahamas:': u'\U0001F1E7\U0001F1F8',
    u':bandera_bután:': u'\U0001F1E7\U0001F1F9',
    u':bandera_isla_bouvet:': u'\U0001F1E7\U0001F1FB',
    u':bandera_botsuana:': u'\U0001F1E7\U0001F1FC',
    u':bandera_bielorrusia:': u'\U0001F1E7\U0001F1FE',
    u':bandera_belice:': u'\U0001F1E7\U0001F1FF',
    u':bandera_canadá:': u'\U0001F1E8\U0001F1E6',
    u':bandera_islas_cocos:': u'\U0001F1E8\U0001F1E8',
    u':bandera_república_democrática_del_congo:': u'\U0001F1E8\U0001F1E9',
    u':bandera_república_centroafricana:': u'\U0001F1E8\U0001F1EB',
    u':bandera_congo:': u'\U0001F1E8\U0001F1EC',
    u':bandera_suiza:': u'\U0001F1E8\U0001F1ED',
    u':bandera_côte_d’ivoire:': u'\U0001F1E8\U0001F1EE',
    u':bandera_islas_cook:': u'\U0001F1E8\U0001F1F0',
    u':bandera_chile:': u'\U0001F1E8\U0001F1F1',
    u':bandera_camerún:': u'\U0001F1E8\U0001F1F2',
    u':bandera_china:': u'\U0001F1E8\U0001F1F3',
    u':bandera_colombia:': u'\U0001F1E8\U0001F1F4',
    u':bandera_isla_clipperton:': u'\U0001F1E8\U0001F1F5',
    u':bandera_costa_rica:': u'\U0001F1E8\U0001F1F7',
    u':bandera_cuba:': u'\U0001F1E8\U0001F1FA',
    u':bandera_cabo_verde:': u'\U0001F1E8\U0001F1FB',
    u':bandera_curazao:': u'\U0001F1E8\U0001F1FC',
    u':bandera_isla_de_navidad:': u'\U0001F1E8\U0001F1FD',
    u':bandera_chipre:': u'\U0001F1E8\U0001F1FE',
    u':bandera_chequia:': u'\U0001F1E8\U0001F1FF',
    u':bandera_alemania:': u'\U0001F1E9\U0001F1EA',
    u':bandera_diego_garcía:': u'\U0001F1E9\U0001F1EC',
    u':bandera_yibuti:': u'\U0001F1E9\U0001F1EF',
    u':bandera_dinamarca:': u'\U0001F1E9\U0001F1F0',
    u':bandera_dominica:': u'\U0001F1E9\U0001F1F2',
    u':bandera_república_dominicana:': u'\U0001F1E9\U0001F1F4',
    u':bandera_argelia:': u'\U0001F1E9\U0001F1FF',
    u':bandera_ceuta_y_melilla:': u'\U0001F1EA\U0001F1E6',
    u':bandera_ecuador:': u'\U0001F1EA\U0001F1E8',
    u':bandera_estonia:': u'\U0001F1EA\U0001F1EA',
    u':bandera_egipto:': u'\U0001F1EA\U0001F1EC',
    u':bandera_sáhara_occidental:': u'\U0001F1EA\U0001F1ED',
    u':bandera_eritrea:': u'\U0001F1EA\U0001F1F7',
    u':bandera_españa:': u'\U0001F1EA\U0001F1F8',
    u':bandera_etiopía:': u'\U0001F1EA\U0001F1F9',
    u':bandera_unión_europea:': u'\U0001F1EA\U0001F1FA',
    u':bandera_finlandia:': u'\U0001F1EB\U0001F1EE',
    u':bandera_fiyi:': u'\U0001F1EB\U0001F1EF',
    u':bandera_islas_malvinas:': u'\U0001F1EB\U0001F1F0',
    u':bandera_micronesia:': u'\U0001F1EB\U0001F1F2',
    u':bandera_islas_feroe:': u'\U0001F1EB\U0001F1F4',
    u':bandera_francia:': u'\U0001F1EB\U0001F1F7',
    u':bandera_gabón:': u'\U0001F1EC\U0001F1E6',
    u':bandera_reino_unido:': u'\U0001F1EC\U0001F1E7',
    u':bandera_granada:': u'\U0001F1EC\U0001F1E9',
    u':bandera_georgia:': u'\U0001F1EC\U0001F1EA',
    u':bandera_guayana_francesa:': u'\U0001F1EC\U0001F1EB',
    u':bandera_guernsey:': u'\U0001F1EC\U0001F1EC',
    u':bandera_ghana:': u'\U0001F1EC\U0001F1ED',
    u':bandera_gibraltar:': u'\U0001F1EC\U0001F1EE',
    u':bandera_groenlandia:': u'\U0001F1EC\U0001F1F1',
    u':bandera_gambia:': u'\U0001F1EC\U0001F1F2',
    u':bandera_guinea:': u'\U0001F1EC\U0001F1F3',
    u':bandera_guadalupe:': u'\U0001F1EC\U0001F1F5',
    u':bandera_guinea_ecuatorial:': u'\U0001F1EC\U0001F1F6',
    u':bandera_grecia:': u'\U0001F1EC\U0001F1F7',
    u':bandera_islas_georgia_del_sur_y_sandwich_del_sur:': u'\U0001F1EC\U0001F1F8',
    u':bandera_guatemala:': u'\U0001F1EC\U0001F1F9',
    u':bandera_guam:': u'\U0001F1EC\U0001F1FA',
    u':bandera_guinea-bisáu:': u'\U0001F1EC\U0001F1FC',
    u':bandera_guyana:': u'\U0001F1EC\U0001F1FE',
    u':bandera_rae_de_hong_kong_(china):': u'\U0001F1ED\U0001F1F0',
    u':bandera_islas_heard_y_mcdonald:': u'\U0001F1ED\U0001F1F2',
    u':bandera_honduras:': u'\U0001F1ED\U0001F1F3',
    u':bandera_croacia:': u'\U0001F1ED\U0001F1F7',
    u':bandera_haití:': u'\U0001F1ED\U0001F1F9',
    u':bandera_hungría:': u'\U0001F1ED\U0001F1FA',
    u':bandera_canarias:': u'\U0001F1EE\U0001F1E8',
    u':bandera_indonesia:': u'\U0001F1EE\U0001F1E9',
    u':bandera_irlanda:': u'\U0001F1EE\U0001F1EA',
    u':bandera_israel:': u'\U0001F1EE\U0001F1F1',
    u':bandera_isla_de_man:': u'\U0001F1EE\U0001F1F2',
    u':bandera_india:': u'\U0001F1EE\U0001F1F3',
    u':bandera_territorio_británico_del_océano_índico:': u'\U0001F1EE\U0001F1F4',
    u':bandera_irak:': u'\U0001F1EE\U0001F1F6',
    u':bandera_irán:': u'\U0001F1EE\U0001F1F7',
    u':bandera_islandia:': u'\U0001F1EE\U0001F1F8',
    u':bandera_italia:': u'\U0001F1EE\U0001F1F9',
    u':bandera_jersey:': u'\U0001F1EF\U0001F1EA',
    u':bandera_jamaica:': u'\U0001F1EF\U0001F1F2',
    u':bandera_jordania:': u'\U0001F1EF\U0001F1F4',
    u':bandera_japón:': u'\U0001F1EF\U0001F1F5',
    u':bandera_kenia:': u'\U0001F1F0\U0001F1EA',
    u':bandera_kirguistán:': u'\U0001F1F0\U0001F1EC',
    u':bandera_camboya:': u'\U0001F1F0\U0001F1ED',
    u':bandera_kiribati:': u'\U0001F1F0\U0001F1EE',
    u':bandera_comoras:': u'\U0001F1F0\U0001F1F2',
    u':bandera_san_cristóbal_y_nieves:': u'\U0001F1F0\U0001F1F3',
    u':bandera_corea_del_norte:': u'\U0001F1F0\U0001F1F5',
    u':bandera_corea_del_sur:': u'\U0001F1F0\U0001F1F7',
    u':bandera_kuwait:': u'\U0001F1F0\U0001F1FC',
    u':bandera_islas_caimán:': u'\U0001F1F0\U0001F1FE',
    u':bandera_kazajistán:': u'\U0001F1F0\U0001F1FF',
    u':bandera_laos:': u'\U0001F1F1\U0001F1E6',
    u':bandera_líbano:': u'\U0001F1F1\U0001F1E7',
    u':bandera_santa_lucía:': u'\U0001F1F1\U0001F1E8',
    u':bandera_liechtenstein:': u'\U0001F1F1\U0001F1EE',
    u':bandera_sri_lanka:': u'\U0001F1F1\U0001F1F0',
    u':bandera_liberia:': u'\U0001F1F1\U0001F1F7',
    u':bandera_lesoto:': u'\U0001F1F1\U0001F1F8',
    u':bandera_lituania:': u'\U0001F1F1\U0001F1F9',
    u':bandera_luxemburgo:': u'\U0001F1F1\U0001F1FA',
    u':bandera_letonia:': u'\U0001F1F1\U0001F1FB',
    u':bandera_libia:': u'\U0001F1F1\U0001F1FE',
    u':bandera_marruecos:': u'\U0001F1F2\U0001F1E6',
    u':bandera_mónaco:': u'\U0001F1F2\U0001F1E8',
    u':bandera_moldavia:': u'\U0001F1F2\U0001F1E9',
    u':bandera_montenegro:': u'\U0001F1F2\U0001F1EA',
    u':bandera_san_martín:': u'\U0001F1F2\U0001F1EB',
    u':bandera_madagascar:': u'\U0001F1F2\U0001F1EC',
    u':bandera_islas_marshall:': u'\U0001F1F2\U0001F1ED',
    u':bandera_macedonia_del_norte:': u'\U0001F1F2\U0001F1F0',
    u':bandera_mali:': u'\U0001F1F2\U0001F1F1',
    u':bandera_myanmar_(birmania):': u'\U0001F1F2\U0001F1F2',
    u':bandera_mongolia:': u'\U0001F1F2\U0001F1F3',
    u':bandera_rae_de_macao_(china):': u'\U0001F1F2\U0001F1F4',
    u':bandera_islas_marianas_del_norte:': u'\U0001F1F2\U0001F1F5',
    u':bandera_martinica:': u'\U0001F1F2\U0001F1F6',
    u':bandera_mauritania:': u'\U0001F1F2\U0001F1F7',
    u':bandera_montserrat:': u'\U0001F1F2\U0001F1F8',
    u':bandera_malta:': u'\U0001F1F2\U0001F1F9',
    u':bandera_mauricio:': u'\U0001F1F2\U0001F1FA',
    u':bandera_maldivas:': u'\U0001F1F2\U0001F1FB',
    u':bandera_malaui:': u'\U0001F1F2\U0001F1FC',
    u':bandera_méxico:': u'\U0001F1F2\U0001F1FD',
    u':bandera_malasia:': u'\U0001F1F2\U0001F1FE',
    u':bandera_mozambique:': u'\U0001F1F2\U0001F1FF',
    u':bandera_namibia:': u'\U0001F1F3\U0001F1E6',
    u':bandera_nueva_caledonia:': u'\U0001F1F3\U0001F1E8',
    u':bandera_níger:': u'\U0001F1F3\U0001F1EA',
    u':bandera_isla_norfolk:': u'\U0001F1F3\U0001F1EB',
    u':bandera_nigeria:': u'\U0001F1F3\U0001F1EC',
    u':bandera_nicaragua:': u'\U0001F1F3\U0001F1EE',
    u':bandera_países_bajos:': u'\U0001F1F3\U0001F1F1',
    u':bandera_noruega:': u'\U0001F1F3\U0001F1F4',
    u':bandera_nepal:': u'\U0001F1F3\U0001F1F5',
    u':bandera_nauru:': u'\U0001F1F3\U0001F1F7',
    u':bandera_niue:': u'\U0001F1F3\U0001F1FA',
    u':bandera_nueva_zelanda:': u'\U0001F1F3\U0001F1FF',
    u':bandera_omán:': u'\U0001F1F4\U0001F1F2',
    u':bandera_panamá:': u'\U0001F1F5\U0001F1E6',
    u':bandera_perú:': u'\U0001F1F5\U0001F1EA',
    u':bandera_polinesia_francesa:': u'\U0001F1F5\U0001F1EB',
    u':bandera_papúa_nueva_guinea:': u'\U0001F1F5\U0001F1EC',
    u':bandera_filipinas:': u'\U0001F1F5\U0001F1ED',
    u':bandera_pakistán:': u'\U0001F1F5\U0001F1F0',
    u':bandera_polonia:': u'\U0001F1F5\U0001F1F1',
    u':bandera_san_pedro_y_miquelón:': u'\U0001F1F5\U0001F1F2',
    u':bandera_islas_pitcairn:': u'\U0001F1F5\U0001F1F3',
    u':bandera_puerto_rico:': u'\U0001F1F5\U0001F1F7',
    u':bandera_territorios_palestinos:': u'\U0001F1F5\U0001F1F8',
    u':bandera_portugal:': u'\U0001F1F5\U0001F1F9',
    u':bandera_palaos:': u'\U0001F1F5\U0001F1FC',
    u':bandera_paraguay:': u'\U0001F1F5\U0001F1FE',
    u':bandera_catar:': u'\U0001F1F6\U0001F1E6',
    u':bandera_reunión:': u'\U0001F1F7\U0001F1EA',
    u':bandera_rumanía:': u'\U0001F1F7\U0001F1F4',
    u':bandera_serbia:': u'\U0001F1F7\U0001F1F8',
    u':bandera_rusia:': u'\U0001F1F7\U0001F1FA',
    u':bandera_ruanda:': u'\U0001F1F7\U0001F1FC',
    u':bandera_arabia_saudí:': u'\U0001F1F8\U0001F1E6',
    u':bandera_islas_salomón:': u'\U0001F1F8\U0001F1E7',
    u':bandera_seychelles:': u'\U0001F1F8\U0001F1E8',
    u':bandera_sudán:': u'\U0001F1F8\U0001F1E9',
    u':bandera_suecia:': u'\U0001F1F8\U0001F1EA',
    u':bandera_singapur:': u'\U0001F1F8\U0001F1EC',
    u':bandera_santa_elena:': u'\U0001F1F8\U0001F1ED',
    u':bandera_eslovenia:': u'\U0001F1F8\U0001F1EE',
    u':bandera_svalbard_y_jan_mayen:': u'\U0001F1F8\U0001F1EF',
    u':bandera_eslovaquia:': u'\U0001F1F8\U0001F1F0',
    u':bandera_sierra_leona:': u'\U0001F1F8\U0001F1F1',
    u':bandera_san_marino:': u'\U0001F1F8\U0001F1F2',
    u':bandera_senegal:': u'\U0001F1F8\U0001F1F3',
    u':bandera_somalia:': u'\U0001F1F8\U0001F1F4',
    u':bandera_surinam:': u'\U0001F1F8\U0001F1F7',
    u':bandera_sudán_del_sur:': u'\U0001F1F8\U0001F1F8',
    u':bandera_santo_tomé_y_príncipe:': u'\U0001F1F8\U0001F1F9',
    u':bandera_el_salvador:': u'\U0001F1F8\U0001F1FB',
    u':bandera_sint_maarten:': u'\U0001F1F8\U0001F1FD',
    u':bandera_siria:': u'\U0001F1F8\U0001F1FE',
    u':bandera_esuatini:': u'\U0001F1F8\U0001F1FF',
    u':bandera_tristán_de_acuña:': u'\U0001F1F9\U0001F1E6',
    u':bandera_islas_turcas_y_caicos:': u'\U0001F1F9\U0001F1E8',
    u':bandera_chad:': u'\U0001F1F9\U0001F1E9',
    u':bandera_territorios_australes_franceses:': u'\U0001F1F9\U0001F1EB',
    u':bandera_togo:': u'\U0001F1F9\U0001F1EC',
    u':bandera_tailandia:': u'\U0001F1F9\U0001F1ED',
    u':bandera_tayikistán:': u'\U0001F1F9\U0001F1EF',
    u':bandera_tokelau:': u'\U0001F1F9\U0001F1F0',
    u':bandera_timor-leste:': u'\U0001F1F9\U0001F1F1',
    u':bandera_turkmenistán:': u'\U0001F1F9\U0001F1F2',
    u':bandera_túnez:': u'\U0001F1F9\U0001F1F3',
    u':bandera_tonga:': u'\U0001F1F9\U0001F1F4',
    u':bandera_turquía:': u'\U0001F1F9\U0001F1F7',
    u':bandera_trinidad_y_tobago:': u'\U0001F1F9\U0001F1F9',
    u':bandera_tuvalu:': u'\U0001F1F9\U0001F1FB',
    u':bandera_taiwán:': u'\U0001F1F9\U0001F1FC',
    u':bandera_tanzania:': u'\U0001F1F9\U0001F1FF',
    u':bandera_ucrania:': u'\U0001F1FA\U0001F1E6',
    u':bandera_uganda:': u'\U0001F1FA\U0001F1EC',
    u':bandera_islas_menores_alejadas_de_ee._uu.:': u'\U0001F1FA\U0001F1F2',
    u':bandera_naciones_unidas:': u'\U0001F1FA\U0001F1F3',
    u':bandera_estados_unidos:': u'\U0001F1FA\U0001F1F8',
    u':bandera_uruguay:': u'\U0001F1FA\U0001F1FE',
    u':bandera_uzbekistán:': u'\U0001F1FA\U0001F1FF',
    u':bandera_ciudad_del_vaticano:': u'\U0001F1FB\U0001F1E6',
    u':bandera_san_vicente_y_las_granadinas:': u'\U0001F1FB\U0001F1E8',
    u':bandera_venezuela:': u'\U0001F1FB\U0001F1EA',
    u':bandera_islas_vírgenes_británicas:': u'\U0001F1FB\U0001F1EC',
    u':bandera_islas_vírgenes_de_ee._uu.:': u'\U0001F1FB\U0001F1EE',
    u':bandera_vietnam:': u'\U0001F1FB\U0001F1F3',
    u':bandera_vanuatu:': u'\U0001F1FB\U0001F1FA',
    u':bandera_wallis_y_futuna:': u'\U0001F1FC\U0001F1EB',
    u':bandera_samoa:': u'\U0001F1FC\U0001F1F8',
    u':bandera_kosovo:': u'\U0001F1FD\U0001F1F0',
    u':bandera_yemen:': u'\U0001F1FE\U0001F1EA',
    u':bandera_mayotte:': u'\U0001F1FE\U0001F1F9',
    u':bandera_sudáfrica:': u'\U0001F1FF\U0001F1E6',
    u':bandera_zambia:': u'\U0001F1FF\U0001F1F2',
    u':bandera_zimbabue:': u'\U0001F1FF\U0001F1FC',
    u':bandera_inglaterra:': u'\U0001F3F4\U000E0067\U000E0062\U000E0065\U000E006E\U000E0067\U000E007F',
    u':bandera_escocia:': u'\U0001F3F4\U000E0067\U000E0062\U000E0073\U000E0063\U000E0074\U000E007F',
    u':bandera_gales:': u'\U0001F3F4\U000E0067\U000E0062\U000E0077\U000E006C\U000E0073\U000E007F',
}

UNICODE_EMOJI_SPANISH = {v: k for k, v in EMOJI_UNICODE_SPANISH.items()}
