# This file has been autogenerated by the pywayland scanner

# Copyright © 2014      Jonas Ådahl
# Copyright © 2015      Red Hat Inc.
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from pywayland.protocol_core import Argument, ArgumentType, Global, Interface, Proxy, Resource


class ZwpRelativePointerV1(Interface):
    """Relative pointer object

    A wp_relative_pointer object is an extension to the
    :class:`~pywayland.protocol.wayland.WlPointer` interface used for emitting
    relative pointer events. It shares the same focus as
    :class:`~pywayland.protocol.wayland.WlPointer` objects of the same seat and
    will only emit events when it has focus.
    """

    name = "zwp_relative_pointer_v1"
    version = 1


class ZwpRelativePointerV1Proxy(Proxy):
    interface = ZwpRelativePointerV1

    @ZwpRelativePointerV1.request()
    def destroy(self):
        """Release the relative pointer object
        """
        self._marshal(0)
        self._destroy()


class ZwpRelativePointerV1Resource(Resource):
    interface = ZwpRelativePointerV1

    @ZwpRelativePointerV1.event(
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Fixed),
        Argument(ArgumentType.Fixed),
        Argument(ArgumentType.Fixed),
        Argument(ArgumentType.Fixed),
    )
    def relative_motion(self, utime_hi, utime_lo, dx, dy, dx_unaccel, dy_unaccel):
        """Relative pointer motion

        Relative x/y pointer motion from the pointer of the seat associated
        with this object.

        A relative motion is in the same dimension as regular
        :class:`~pywayland.protocol.wayland.WlPointer` motion events, except
        they do not represent an absolute position. For example, moving a
        pointer from (x, y) to (x', y') would have the equivalent relative
        motion (x' - x, y' - y). If a pointer motion caused the absolute
        pointer position to be clipped by for example the edge of the monitor,
        the relative motion is unaffected by the clipping and will represent
        the unclipped motion.

        This event also contains non-accelerated motion deltas. The non-
        accelerated delta is, when applicable, the regular pointer motion delta
        as it was before having applied motion acceleration and other
        transformations such as normalization.

        Note that the non-accelerated delta does not represent 'raw' events as
        they were read from some device. Pointer motion acceleration is device-
        and configuration-specific and non-accelerated deltas and accelerated
        deltas may have the same value on some devices.

        Relative motions are not coupled to :func:`WlPointer.motion()
        <pywayland.protocol.wayland.WlPointer.motion>` events, and can be sent
        in combination with such events, but also independently. There may also
        be scenarios where :func:`WlPointer.motion()
        <pywayland.protocol.wayland.WlPointer.motion>` is sent, but there is no
        relative motion. The order of an absolute and relative motion event
        originating from the same physical motion is not guaranteed.

        If the client needs button events or focus state, it can receive them
        from a :class:`~pywayland.protocol.wayland.WlPointer` object of the
        same seat that the wp_relative_pointer object is associated with.

        :param utime_hi:
            high 32 bits of a 64 bit timestamp with microsecond granularity
        :type utime_hi:
            `ArgumentType.Uint`
        :param utime_lo:
            low 32 bits of a 64 bit timestamp with microsecond granularity
        :type utime_lo:
            `ArgumentType.Uint`
        :param dx:
            the x component of the motion vector
        :type dx:
            `ArgumentType.Fixed`
        :param dy:
            the y component of the motion vector
        :type dy:
            `ArgumentType.Fixed`
        :param dx_unaccel:
            the x component of the unaccelerated motion vector
        :type dx_unaccel:
            `ArgumentType.Fixed`
        :param dy_unaccel:
            the y component of the unaccelerated motion vector
        :type dy_unaccel:
            `ArgumentType.Fixed`
        """
        self._post_event(0, utime_hi, utime_lo, dx, dy, dx_unaccel, dy_unaccel)


class ZwpRelativePointerV1Global(Global):
    interface = ZwpRelativePointerV1


ZwpRelativePointerV1._gen_c()
ZwpRelativePointerV1.proxy_class = ZwpRelativePointerV1Proxy
ZwpRelativePointerV1.resource_class = ZwpRelativePointerV1Resource
ZwpRelativePointerV1.global_class = ZwpRelativePointerV1Global
