/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFRenderer;
import org.freehep.graphicsio.emf.EMFTag;

public class StrokePath
extends EMFTag {
    private Rectangle bounds;

    public StrokePath() {
        super(64, 1);
    }

    public StrokePath(Rectangle bounds) {
        this();
        this.bounds = bounds;
    }

    @Override
    public EMFTag read(int tagID, EMFInputStream emf, int len) throws IOException {
        return new StrokePath(emf.readRECTL());
    }

    @Override
    public void write(int tagID, EMFOutputStream emf) throws IOException {
        emf.writeRECTL(this.bounds);
    }

    @Override
    public String toString() {
        return super.toString() + "\n  bounds: " + this.bounds;
    }

    @Override
    public void render(EMFRenderer renderer) {
        GeneralPath currentPath = renderer.getPath();
        if (currentPath != null) {
            renderer.drawShape(currentPath);
            renderer.setPath(null);
        }
    }
}

