<!--
title: 自定义域名及 HTTPS 配置
menuText: 自定义域名及 HTTPS 配置
menuOrder: 5
layout: Doc
-->

## 操作场景

通过 Serverless Component 快速构建一个 Serverless Web 网站服务后，如您希望配置自定义域名，支持 HTTPS 的访问，则可以按照如下两种方法快速配置。

## 前提条件

- 已经部署了网站服务，获取了 COS/API 网关 的网站托管地址。文章参考[部署 Vue.js+Express.js 全栈应用](https://serverless.com/cn/framework/docs/providers/tencent/components/high-level-components/tencent-vue-full-stack/)或[快速部署 Hexo 博客](https://serverless.com/cn/framework/docs/providers/tencent/components/high-level-components/tencent-hexo/)
- 已拥有自定义域名（例如 www.example.com），并确保输入的域名已[备案](https://cloud.tencent.com/product/ba)。
- 如果需要 HTTPS 访问，可以申请证书并且[获得证书 ID](https://console.cloud.tencent.com/ssl) （例如：certificateId : axE1bo3），个人站点可以直接申请[域名型（DV）免费 SSL 证书](https://cloud.tencent.com/document/product/400/8422)

&nbsp;

## 方案一：通过 CDN 加速配置支持自定义域名的 HTTPS 访问

配置前，需要确保账号实名并已经[开通 CDN 服务](https://console.cloud.tencent.com/cdn)

### 增加配置

在 `serverless.yml` 中，增加 CDN 自定义域名配置

```yml
myWebsite:
  myWebsite:
  component: '@serverless/tencent-website'
  inputs:
    code:
      src: ./public # Upload static files generated by HEXO
      index: index.html
      error: index.html
    region: ap-guangzhou
    bucketName: my-hexo-bucket
    protocol: https
    # 新增的 CDN 自定义域名配置
    hosts:
      - host: www.example.com # 希望配置的自定义域名
        https:
          certId: axE1bo3 # SSL 证书id
          http2: off
          httpsType: 4
          forceSwitch: -2
```

[查看完整配置项说明](https://github.com/serverless-components/tencent-website/blob/master/docs/configure.md)

### 部署

再次通过`sls`命令进行部署，并可以添加`--debug`参数查看部署过程中的信息。

如您的账号未 [登录](https://cloud.tencent.com/login) 或 [注册](https://cloud.tencent.com/register) 腾讯云，您可以直接通过**微信**扫描命令行中的二维码进行授权登录和注册。

> `sls` 是 `serverless` 命令的简写。

```bash
$ sls --debug
  DEBUG ─ Resolving the template's static variables.
  DEBUG ─ Collecting components from the template.
  DEBUG ─ Downloading any NPM components found in the template.
  DEBUG ─ Analyzing the template's components dependencies.
  DEBUG ─ Creating the template's components graph.
  DEBUG ─ Syncing template state.
  DEBUG ─ Executing the template's components graph.
  DEBUG ─ Preparing website Tencent COS bucket my-hexo-bucket-1250000000.
  DEBUG ─ Bucket "my-hexo-bucket-1250000000" in the "ap-guangzhou" region already exist.
  DEBUG ─ Setting ACL for "my-hexo-bucket-1250000000" bucket in the "ap-guangzhou" region.
  DEBUG ─ Ensuring no CORS are set for "my-hexo-bucket-1250000000" bucket in the "ap-guangzhou" region.
  DEBUG ─ Ensuring no Tags are set for "my-hexo-bucket-1250000000" bucket in the "ap-guangzhou" region.
  DEBUG ─ Configuring bucket my-hexo-bucket-1250000000 for website hosting.
  DEBUG ─ Uploading website files from /Users/tina/Documents/hexoblog/hexo/public to bucket my-hexo-bucket-1250000000.
  DEBUG ─ Starting upload to bucket my-hexo-bucket-1250000000 in region ap-guangzhou
  DEBUG ─ Uploading directory /Users/tina/Documents/hexoblog/hexo/public to bucket my-hexo-bucket-1250000000
  DEBUG ─ The CDN domain www.example.com has existed.
  DEBUG ─ Updating...
  DEBUG ─ Waiting for CDN deploy success..
  DEBUG ─ CDN deploy success to host: www.example.com
  DEBUG ─ Setup https for www.example.com...
  DEBUG ─ Website deployed successfully to URL: https://my-hexo-bucket-1250000000.cos-website.ap-guangzhou.myqcloud.com.

  myWebsite:
    url:  https://my-hexo-bucket-1250000000.cos-website.ap-guangzhou.myqcloud.com
    env:
    host:
      - https://www.example.com (CNAME: www.example.com.cdn.dnsv1.com）

  17s › myWebsite › done
```

### 添加 CNAME

部署完成后，在命令行的输出中可以查看到一个以 `.cdn.dnsv1.com` 为后缀的 CNAME 域名，参考 [CNAME 配置文档](https://cloud.tencent.com/document/product/228/3121)在 DNS 服务商处设置好对应的 CNAME 并生效后，即可访问自定义 HTTPS 域名。

&nbsp;

## 方案二：对 API 网关域名进行自定义域名配置

### 增加配置

在 `serverless.yml` 中，增加 API 网关 自定义域名配置，本文以 egg.js 框架为例

```yml
# serverless.yml

restApi:
  component: '@serverless/tencent-apigateway'
  inputs:
    region: ap-shanghai
    protocols:
      - http
      - https
    serviceName: serverless
    environment: release
    endpoints:
      - path: /users
        method: POST
        function:
          functionName: myFunction
    # 增加 API 网关自定义域名配置
    customDomain:
      - domain: www.example.com
        certificateId: axE1bo3
        protocols:
          - https
```

[查看完整配置项说明](https://github.com/serverless-components/tencent-apigateway/blob/master/docs/configure.md)

### 部署

再次通过`sls`命令进行部署，并可以添加`--debug`参数查看部署过程中的信息。

如您的账号未 [登录](https://cloud.tencent.com/login) 或 [注册](https://cloud.tencent.com/register) 腾讯云，您可以直接通过**微信**扫描命令行中的二维码进行授权登录和注册。

> `sls` 是 `serverless` 命令的简写。

```bash
$ sls --debug

  DEBUG ─ Resolving the template's static variables.
  DEBUG ─ Collecting components from the template.
  DEBUG ─ Downloading any NPM components found in the template.
  DEBUG ─ Analyzing the template's components dependencies.
  DEBUG ─ Creating the template's components graph.
  DEBUG ─ Syncing template state.
  DEBUG ─ Executing the template's components graph.
  DEBUG ─ Starting API-Gateway deployment with name restApi in the ap-shanghai region
  DEBUG ─ Using last time deploy service id service-lqhc88sr
  DEBUG ─ Updating service with serviceId service-lqhc88sr.
  DEBUG ─ Endpoint POST /users already exists with id api-e902tx1q.
  DEBUG ─ Updating api with api id api-e902tx1q.
  DEBUG ─ Service with id api-e902tx1q updated.
  DEBUG ─ Deploying service with id service-lqhc88sr.
  DEBUG ─ Deployment successful for the api named restApi in the ap-shanghai region.
  DEBUG ─ Start unbind all exist domain for service service-lqhc88sr
  DEBUG ─ Start bind custom domain for service service-lqhc88sr
  DEBUG ─ Custom domain for service service-lqhc88sr created successfully.
  DEBUG ─ Please add CNAME record service-lqhc88sr-1250000000.sh.apigw.tencentcs.com for www.example.com.

  restApi:
    protocols:
      - http
      - https
    subDomain:     service-lqhc88sr-1250000000.sh.apigw.tencentcs.com
    environment:   release
    region:        ap-shanghai
    serviceId:     service-lqhc88sr
    apis:
      -
        path:   /users
        method: POST
        apiId:  api-e902tx1q
    customDomains:
      - www.example.com (CNAME: service-lqhc88sr-1250000000.sh.apigw.tencentcs.com)

  8s › restApi › done
```

### 添加 CNAME 记录

部署完成后，在命令行的输出中可以查看到一个以 `.apigw.tencentcs.com` 为后缀的 CNAME 域名，参考 [添加 CNAME 记录](https://cloud.tencent.com/document/product/302/3450)在 DNS 服务商处设置好对应的 CNAME 并生效后，即可访问自定义 HTTPS 域名。
