/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.applemenu;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.RootPaneContainer;
import org.openide.ErrorManager;
import org.openide.awt.Actions;
import org.openide.cookies.EditCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.ViewCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.windows.WindowManager;
import org.openide.windows.WindowSystemEvent;
import org.openide.windows.WindowSystemListener;

abstract class NbApplicationAdapter {
    NbApplicationAdapter() {
    }

    static void install() {
        WindowManager.getDefault().addWindowSystemListener(new WindowSystemListener(){

            public void beforeLoad(WindowSystemEvent event) {
                WindowManager.getDefault().removeWindowSystemListener((WindowSystemListener)this);
                try {
                    Frame main = WindowManager.getDefault().getMainWindow();
                    ((RootPaneContainer)((Object)main)).getRootPane().putClientProperty("apple.awt.fullscreenable", true);
                }
                catch (Throwable e) {
                    Logger.getLogger(NbApplicationAdapter.class.getName()).log(Level.FINE, "Error while setting up full screen support.", e);
                }
            }

            public void afterLoad(WindowSystemEvent event) {
            }

            public void beforeSave(WindowSystemEvent event) {
            }

            public void afterSave(WindowSystemEvent event) {
            }
        });
    }

    void handleAbout() {
        Window[] windows = Dialog.getWindows();
        if (null != windows) {
            for (Window w : windows) {
                JDialog dlg;
                if (!(w instanceof JDialog) || !Boolean.TRUE.equals((dlg = (JDialog)w).getRootPane().getClientProperty("nb.about.dialog")) || !dlg.isVisible()) continue;
                dlg.toFront();
                return;
            }
        }
        this.performAction("Help", "org.netbeans.core.actions.AboutAction");
    }

    void openFiles(List<File> files) {
        for (File f : files) {
            FileObject obj;
            if (!f.exists() || f.isDirectory() || (obj = FileUtil.toFileObject((File)f)) == null) continue;
            try {
                DataObject dob = DataObject.find((FileObject)obj);
                OpenCookie oc = (OpenCookie)dob.getLookup().lookup(OpenCookie.class);
                if (oc != null) {
                    oc.open();
                    continue;
                }
                EditCookie ec = (EditCookie)dob.getLookup().lookup(EditCookie.class);
                if (ec != null) {
                    ec.edit();
                    continue;
                }
                ViewCookie v = (ViewCookie)dob.getLookup().lookup(ViewCookie.class);
                if (v == null) continue;
                v.view();
            }
            catch (DataObjectNotFoundException ex) {
                Logger.getLogger(NbApplicationAdapter.class.getName()).log(Level.INFO, f.getAbsolutePath(), ex);
            }
        }
    }

    public void handlePreferences() {
        this.performAction("Window", "org.netbeans.modules.options.OptionsWindowAction");
    }

    public void handleQuit() {
        this.performAction("System", "org.netbeans.core.actions.SystemExit");
    }

    private boolean performAction(String category, String id) {
        Action a = Actions.forID((String)category, (String)id);
        if (a == null) {
            return false;
        }
        ActionEvent ae = new ActionEvent(this, 1001, "whatever");
        try {
            a.actionPerformed(ae);
            return true;
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(16, (Throwable)e);
            return false;
        }
    }
}

