/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uihandler;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.EditorKit;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.ChoiceView;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class SubmitPanel
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener,
CaretListener,
Comparator<Object>,
Runnable {
    private EditorKit betterXMLKit;
    private JLabel jLabel1;
    private JScrollPane jScrollPane2;
    private JComboBox remove;
    private JEditorPane text;
    private ExplorerManager manager = new ExplorerManager();

    public SubmitPanel() {
        this.initComponents();
        RequestProcessor.getDefault().post((Runnable)this);
    }

    @Override
    public void run() {
        if (EventQueue.isDispatchThread()) {
            try {
                String content = this.text.getDocument().getText(0, this.text.getDocument().getLength());
                this.text.setEditorKit(this.betterXMLKit);
                this.setText(content);
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else {
            this.betterXMLKit = CloneableEditorSupport.getEditorKit((String)"text/xml");
            if (this.betterXMLKit != null) {
                EventQueue.invokeLater(this);
            }
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.text.addCaretListener(this);
        this.manager.addPropertyChangeListener((PropertyChangeListener)this);
    }

    private void initComponents() {
        try {
            this.remove = new JComboBox();
            this.jLabel1 = new JLabel();
            this.jScrollPane2 = new JScrollPane();
            this.text = new JEditorPane();
            this.setPreferredSize(new Dimension(640, 480));
            this.remove.setModel(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.remove = new ChoiceView();
        this.jLabel1.setText(NbBundle.getMessage(SubmitPanel.class, (String)"SubmitPanel.jLabel1.text_1"));
        this.text.setEditable(false);
        this.jScrollPane2.setViewportView(this.text);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane2, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.remove, 0, 507, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.remove, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 203, Short.MAX_VALUE).addContainerGap()));
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    void setText(String content) {
        try {
            this.text.getDocument().remove(0, this.text.getDocument().getLength());
            this.text.getDocument().insertString(0, content, null);
            this.text.getCaret().setDot(0);
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        if ("selectedNodes".equals(ev.getPropertyName())) {
            Node[] arr = this.getExplorerManager().getSelectedNodes();
            if (arr.length != 1) {
                return;
            }
            Object o = arr[0].getValue("offset");
            if (o instanceof Integer) {
                this.text.removeCaretListener(this);
                this.text.getCaret().setDot((Integer)o);
                this.text.addCaretListener(this);
                this.text.requestFocus();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void caretUpdate(CaretEvent e) {
        int offset = this.text.getCaretPosition();
        Node[] arr = this.getExplorerManager().getRootContext().getChildren().getNodes(true);
        int index = Arrays.binarySearch(arr, offset, this);
        if (index < -1) {
            index = -index - 2;
        }
        if (index >= 0 && index < arr.length) {
            try {
                this.getExplorerManager().removePropertyChangeListener((PropertyChangeListener)this);
                this.getExplorerManager().setSelectedNodes(new Node[]{arr[index]});
            }
            catch (PropertyVetoException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                this.getExplorerManager().addPropertyChangeListener((PropertyChangeListener)this);
            }
        }
    }

    @Override
    public int compare(Object o1, Object o2) {
        if (o1 instanceof Node) {
            o1 = ((Node)o1).getValue("offset");
        }
        if (o2 instanceof Node) {
            o2 = ((Node)o2).getValue("offset");
        }
        if (o1 instanceof Integer && o2 instanceof Integer) {
            return (Integer)o1 - (Integer)o2;
        }
        throw new IllegalArgumentException("o1: " + o1 + " o2: " + o2);
    }
}

