/*
 * Decompiled with CFR 0.152.
 */
package jspecview.popup;

import javajs.util.Lst;
import javajs.util.PT;
import jspecview.api.JSVPanel;
import jspecview.common.JSVersion;
import jspecview.common.JSViewer;
import jspecview.common.PanelData;
import jspecview.common.Spectrum;
import jspecview.popup.JSVPopupResourceBundle;
import org.jmol.api.SC;
import org.jmol.popup.GenericPopup;
import org.jmol.popup.PopupResource;

public abstract class JSVGenericPopup
extends GenericPopup {
    protected static final boolean dumpList = false;
    protected static final int UPDATE_NEVER = -1;
    private static final int UPDATE_ALL = 0;
    private static final int UPDATE_CONFIG = 1;
    private static final int UPDATE_SHOW = 2;
    protected JSViewer vwr;
    protected int updateMode;
    private Lst<String> cnmrPeaks;
    private Lst<String> hnmrPeaks;
    private int aboutComputedMenuBaseCount;
    private boolean allowMenu;
    private boolean zoomEnabled;
    private PanelData pd;
    protected JSVPanel thisJsvp;

    protected void initialize(JSViewer viewer, PopupResource bundle, String title) {
        this.vwr = viewer;
        this.initSwing(title, bundle, viewer.getApplet(), JSViewer.isJS, viewer.isSigned, false);
    }

    @Override
    public void jpiDispose() {
        this.helper.menuClearListeners(this.popupMenu);
        this.thisPopup = null;
        this.popupMenu = null;
    }

    @Override
    public Object jpiGetMenuAsObject() {
        return this.popupMenu;
    }

    @Override
    public void jpiShow(int x, int y) {
        this.show(x, y, false);
        this.appRestorePopupMenu();
        this.menuShowPopup(this.popupMenu, this.thisx, this.thisy);
    }

    @Override
    public void jpiUpdateComputedMenus() {
        if (this.updateMode == -1) {
            return;
        }
        this.updateMode = 0;
        this.getViewerData();
        this.updateFileMenu();
        this.updateFileTypeDependentMenus();
        this.updateMode = 1;
        this.updateAboutSubmenu();
    }

    @Override
    protected void appCheckItem(String item, SC newMenu) {
    }

    @Override
    protected String appFixLabel(String label) {
        if (label.startsWith("_")) {
            label = label.substring(label.indexOf("_", 2) + 1);
        } else if (label.equals("VERSION")) {
            label = JSVersion.VERSION;
        }
        label = PT.rep(label, "JAVA", "");
        label = PT.rep(label, "CB", "");
        label = PT.rep(label, "Menu", "");
        label = PT.rep(label, "_", " ");
        return label;
    }

    @Override
    protected String getScriptForCallback(SC source, String id, String script) {
        return script;
    }

    @Override
    public String appGetMenuAsString(String title) {
        return new JSVPopupResourceBundle().getMenuAsText(title);
    }

    @Override
    protected boolean appGetBooleanProperty(String name) {
        return false;
    }

    @Override
    protected boolean appRunSpecialCheckBox(SC item, String basename, String what, boolean TF) {
        return false;
    }

    @Override
    protected void appRestorePopupMenu() {
        this.thisPopup = this.popupMenu;
    }

    @Override
    protected void appRunScript(String script) {
        this.vwr.runScript(script);
    }

    @Override
    protected void appUpdateForShow() {
        this.thisJsvp = this.vwr.selectedPanel;
        this.setEnables(this.thisJsvp);
        if (this.updateMode == -1) {
            return;
        }
        this.getViewerData();
        this.updateMode = 2;
        this.updateSpectraMenu();
        this.updateAboutSubmenu();
    }

    @Override
    protected void appUpdateSpecialCheckBoxValue(SC item, String what, boolean TF) {
    }

    private void getViewerData() {
    }

    private void updateFileTypeDependentMenus() {
    }

    private void updateFileMenu() {
        Object menu = this.htMenus.get("fileMenu");
        if (menu == null) {
            return;
        }
    }

    private void updateSpectraMenu() {
        SC menu;
        SC menuh = (SC)this.htMenus.get("hnmrMenu");
        SC menuc = (SC)this.htMenus.get("cnmrMenu");
        if (menuh != null) {
            this.menuRemoveAll(menuh, 0);
        }
        if (menuc != null) {
            this.menuRemoveAll(menuc, 0);
        }
        if ((menu = (SC)this.htMenus.get("spectraMenu")) == null) {
            return;
        }
        this.menuRemoveAll(menu, 0);
        boolean isOK = this.setSpectraMenu(menuh, this.hnmrPeaks) | this.setSpectraMenu(menuc, this.cnmrPeaks);
        if (isOK) {
            if (menuh != null) {
                this.menuAddSubMenu(menu, menuh);
            }
            if (menuc != null) {
                this.menuAddSubMenu(menu, menuc);
            }
        }
        this.menuEnable(menu, isOK);
    }

    private boolean setSpectraMenu(SC menu, Lst<String> peaks) {
        int n;
        if (menu == null) {
            return false;
        }
        this.menuEnable(menu, false);
        int n2 = n = peaks == null ? 0 : peaks.size();
        if (n == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            String peak = (String)peaks.get(i);
            String title = PT.getQuotedAttribute(peak, "title");
            String atoms = PT.getQuotedAttribute(peak, "atoms");
            if (atoms == null) continue;
            this.menuCreateItem(menu, title, "select visible & (@" + PT.rep(atoms, ",", " or @") + ")", "Focus" + i);
        }
        this.menuEnable(menu, true);
        return true;
    }

    private void updateAboutSubmenu() {
        SC menu = (SC)this.htMenus.get("aboutComputedMenu");
        if (menu == null) {
            return;
        }
        this.menuRemoveAll(menu, this.aboutComputedMenuBaseCount);
    }

    public void setEnabled(boolean allowMenu, boolean zoomEnabled) {
        this.allowMenu = allowMenu;
        this.zoomEnabled = zoomEnabled;
        this.enableMenus();
    }

    private void enableMenus() {
        this.setItemEnabled("_SIGNED_FileMenu", this.allowMenu);
        this.setItemEnabled("ViewMenu", this.pd != null && this.allowMenu);
        this.setItemEnabled("Open_File...", this.allowMenu);
        this.setItemEnabled("Open_Simulation...", this.allowMenu);
        this.setItemEnabled("Open_URL...", this.allowMenu);
        this.setItemEnabled("Save_AsMenu", this.pd != null && this.allowMenu);
        this.setItemEnabled("Export_AsMenu", this.pd != null && this.allowMenu);
        this.setItemEnabled("Append_File...", this.pd != null && this.allowMenu);
        this.setItemEnabled("Append_Simulation...", this.pd != null && this.allowMenu);
        this.setItemEnabled("Append_URL...", this.pd != null && this.allowMenu);
        this.setItemEnabled("Views...", this.pd != null && this.allowMenu);
        this.setItemEnabled("Script", this.allowMenu);
        this.setItemEnabled("Print...", this.pd != null && this.allowMenu);
        this.setItemEnabled("ZoomMenu", this.pd != null && this.zoomEnabled);
    }

    private void setEnables(JSVPanel jsvp) {
        this.pd = jsvp == null ? null : jsvp.getPanelData();
        Spectrum spec0 = this.pd == null ? null : this.pd.getSpectrum();
        boolean isOverlaid = this.pd != null && this.pd.isShowAllStacked();
        boolean isSingle = this.pd != null && this.pd.haveSelectedSpectrum();
        this.setItemEnabled("Integration", this.pd != null && this.pd.getSpectrum().canIntegrate());
        this.setItemEnabled("Measurements", true);
        this.setItemEnabled("Peaks", this.pd != null && this.pd.getSpectrum().is1D());
        this.setItemEnabled("Predicted_Solution_Colour_(fitted)", isSingle && spec0.canShowSolutionColor());
        this.setItemEnabled("Predicted_Solution_Colour_(interpolated)", isSingle && spec0.canShowSolutionColor());
        this.setItemEnabled("Toggle_Trans/Abs", isSingle && spec0.canConvertTransAbs());
        this.setItemEnabled("Show_Overlay_Key", isOverlaid && this.pd.getNumberOfGraphSets() == 1);
        this.setItemEnabled("Overlay_Offset...", isOverlaid);
        this.setItemEnabled("JDXMenu", this.pd != null && spec0.canSaveAsJDX());
        this.setItemEnabled("Export_AsMenu", this.pd != null);
        this.enableMenus();
    }

    private void setItemEnabled(String key, boolean TF) {
        this.menuEnable((SC)this.htMenus.get(key), TF);
    }

    public void setSelected(String key, boolean TF) {
        SC item = (SC)this.htMenus.get(key);
        if (item == null || item.isSelected() == TF) {
            return;
        }
        this.menuEnable(item, false);
        item.setSelected(TF);
        this.menuEnable(item, true);
    }

    @Override
    protected String getUnknownCheckBoxScriptToRun(SC item, String name, String what, boolean TF) {
        return null;
    }
}

