# SPDX-FileCopyrightText: 2018-2019 Laurent Montel <montel@kde.org>
# SPDX-FileCopyrightText: 2018-2019 Volker Krause <vkrause@kde.org>
# SPDX-License-Identifier: BSD-3-Clause


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was KPimItineraryConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

# Use original install prefix when loaded through a "/usr move"
# cross-prefix symbolic link such as /lib -> /usr/lib.
get_filename_component(_realCurr "${CMAKE_CURRENT_LIST_DIR}" REALPATH)
get_filename_component(_realOrig "/usr/lib/cmake/KPimItinerary" REALPATH)
if(_realCurr STREQUAL _realOrig)
  set(PACKAGE_PREFIX_DIR "/usr")
endif()
unset(_realOrig)
unset(_realCurr)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

include(CMakeFindDependencyMacro)
find_dependency(Qt5Gui "5.15.0")
find_dependency(KF5Mime "5.18.1")
if (ON)
    find_dependency(KF5CalendarCore "5.83.0")
endif()
find_dependency(KF5Contacts "5.83.0")
find_dependency(KPimPkPass "5.18.1")

if (NOT TRUE)
    find_dependency(ZLIB)
    if (TRUE)
        find_dependency(Poppler)
    endif()
    if (ON)
        find_dependency(ZXing)
    endif()
    if (ON)
        find_dependency(LibXml2)
    endif()
endif()

include("${CMAKE_CURRENT_LIST_DIR}/KPimItineraryTargets.cmake")

