/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.mbeans;

import java.util.ArrayList;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import org.apache.catalina.deploy.ContextEnvironment;
import org.apache.catalina.deploy.ContextResource;
import org.apache.catalina.deploy.ContextResourceLink;
import org.apache.catalina.deploy.NamingResources;
import org.apache.catalina.mbeans.MBeanUtils;
import org.apache.tomcat.util.modeler.BaseModelMBean;
import org.apache.tomcat.util.modeler.ManagedBean;
import org.apache.tomcat.util.modeler.Registry;

public class NamingResourcesMBean
extends BaseModelMBean {
    protected Registry registry = MBeanUtils.createRegistry();
    protected ManagedBean managed = this.registry.findManagedBean("NamingResources");

    public String[] getEnvironments() {
        ContextEnvironment[] contextEnvironmentArray = ((NamingResources)this.resource).findEnvironments();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ContextEnvironment contextEnvironment : contextEnvironmentArray) {
            try {
                ObjectName objectName = MBeanUtils.createObjectName(this.managed.getDomain(), contextEnvironment);
                arrayList.add(objectName.toString());
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Cannot create object name for environment " + contextEnvironment);
                illegalArgumentException.initCause(malformedObjectNameException);
                throw illegalArgumentException;
            }
        }
        return arrayList.toArray(new String[0]);
    }

    public String[] getResources() {
        ContextResource[] contextResourceArray = ((NamingResources)this.resource).findResources();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ContextResource contextResource : contextResourceArray) {
            try {
                ObjectName objectName = MBeanUtils.createObjectName(this.managed.getDomain(), contextResource);
                arrayList.add(objectName.toString());
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Cannot create object name for resource " + contextResource);
                illegalArgumentException.initCause(malformedObjectNameException);
                throw illegalArgumentException;
            }
        }
        return arrayList.toArray(new String[0]);
    }

    public String[] getResourceLinks() {
        ContextResourceLink[] contextResourceLinkArray = ((NamingResources)this.resource).findResourceLinks();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ContextResourceLink contextResourceLink : contextResourceLinkArray) {
            try {
                ObjectName objectName = MBeanUtils.createObjectName(this.managed.getDomain(), contextResourceLink);
                arrayList.add(objectName.toString());
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Cannot create object name for resource " + contextResourceLink);
                illegalArgumentException.initCause(malformedObjectNameException);
                throw illegalArgumentException;
            }
        }
        return arrayList.toArray(new String[0]);
    }

    public String addEnvironment(String string, String string2, String string3) throws MalformedObjectNameException {
        NamingResources namingResources = (NamingResources)this.resource;
        if (namingResources == null) {
            return null;
        }
        ContextEnvironment contextEnvironment = namingResources.findEnvironment(string);
        if (contextEnvironment != null) {
            throw new IllegalArgumentException("Invalid environment name - already exists '" + string + "'");
        }
        contextEnvironment = new ContextEnvironment();
        contextEnvironment.setName(string);
        contextEnvironment.setType(string2);
        contextEnvironment.setValue(string3);
        namingResources.addEnvironment(contextEnvironment);
        ManagedBean managedBean = this.registry.findManagedBean("ContextEnvironment");
        ObjectName objectName = MBeanUtils.createObjectName(managedBean.getDomain(), contextEnvironment);
        return objectName.toString();
    }

    public String addResource(String string, String string2) throws MalformedObjectNameException {
        NamingResources namingResources = (NamingResources)this.resource;
        if (namingResources == null) {
            return null;
        }
        ContextResource contextResource = namingResources.findResource(string);
        if (contextResource != null) {
            throw new IllegalArgumentException("Invalid resource name - already exists'" + string + "'");
        }
        contextResource = new ContextResource();
        contextResource.setName(string);
        contextResource.setType(string2);
        namingResources.addResource(contextResource);
        ManagedBean managedBean = this.registry.findManagedBean("ContextResource");
        ObjectName objectName = MBeanUtils.createObjectName(managedBean.getDomain(), contextResource);
        return objectName.toString();
    }

    public String addResourceLink(String string, String string2) throws MalformedObjectNameException {
        NamingResources namingResources = (NamingResources)this.resource;
        if (namingResources == null) {
            return null;
        }
        ContextResourceLink contextResourceLink = namingResources.findResourceLink(string);
        if (contextResourceLink != null) {
            throw new IllegalArgumentException("Invalid resource link name - already exists'" + string + "'");
        }
        contextResourceLink = new ContextResourceLink();
        contextResourceLink.setName(string);
        contextResourceLink.setType(string2);
        namingResources.addResourceLink(contextResourceLink);
        ManagedBean managedBean = this.registry.findManagedBean("ContextResourceLink");
        ObjectName objectName = MBeanUtils.createObjectName(managedBean.getDomain(), contextResourceLink);
        return objectName.toString();
    }

    public void removeEnvironment(String string) {
        NamingResources namingResources = (NamingResources)this.resource;
        if (namingResources == null) {
            return;
        }
        ContextEnvironment contextEnvironment = namingResources.findEnvironment(string);
        if (contextEnvironment == null) {
            throw new IllegalArgumentException("Invalid environment name '" + string + "'");
        }
        namingResources.removeEnvironment(string);
    }

    public void removeResource(String string) {
        string = ObjectName.unquote(string);
        NamingResources namingResources = (NamingResources)this.resource;
        if (namingResources == null) {
            return;
        }
        ContextResource contextResource = namingResources.findResource(string);
        if (contextResource == null) {
            throw new IllegalArgumentException("Invalid resource name '" + string + "'");
        }
        namingResources.removeResource(string);
    }

    public void removeResourceLink(String string) {
        string = ObjectName.unquote(string);
        NamingResources namingResources = (NamingResources)this.resource;
        if (namingResources == null) {
            return;
        }
        ContextResourceLink contextResourceLink = namingResources.findResourceLink(string);
        if (contextResourceLink == null) {
            throw new IllegalArgumentException("Invalid resource Link name '" + string + "'");
        }
        namingResources.removeResourceLink(string);
    }
}

