/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.resources;

import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.naming.resources.ClasspathURLStreamHandler;
import org.apache.naming.resources.DirContextURLStreamHandler;

public class DirContextURLStreamHandlerFactory
implements URLStreamHandlerFactory {
    private static DirContextURLStreamHandlerFactory instance = new DirContextURLStreamHandlerFactory();
    private List<URLStreamHandlerFactory> userFactories = new CopyOnWriteArrayList<URLStreamHandlerFactory>();

    public static DirContextURLStreamHandlerFactory getInstance() {
        return instance;
    }

    public static void addUserFactory(URLStreamHandlerFactory uRLStreamHandlerFactory) {
        DirContextURLStreamHandlerFactory.instance.userFactories.add(uRLStreamHandlerFactory);
    }

    private DirContextURLStreamHandlerFactory() {
    }

    @Override
    public URLStreamHandler createURLStreamHandler(String string) {
        if (string.equals("jndi")) {
            return new DirContextURLStreamHandler();
        }
        if (string.equals("classpath")) {
            return new ClasspathURLStreamHandler();
        }
        for (URLStreamHandlerFactory uRLStreamHandlerFactory : this.userFactories) {
            URLStreamHandler uRLStreamHandler = uRLStreamHandlerFactory.createURLStreamHandler(string);
            if (uRLStreamHandler == null) continue;
            return uRLStreamHandler;
        }
        return null;
    }
}

